//
// Copyright (c) 2020, NVIDIA CORPORATION.  All rights reserved.
//
// NVIDIA CORPORATION and its licensors retain all intellectual property
// and proprietary rights in and to this software, related documentation
// and any modifications thereto.  Any use, reproduction, disclosure or
// distribution of this software and related documentation without an express
// license agreement from NVIDIA CORPORATION is strictly prohibited.
//

#pragma once

#include "cqi.hpp"
#include "nvswitch_drv.hpp"

#include <memory>

namespace nscq::cqi {

struct drv : public cqi {
    using cqi_t = drv;
    using cqi::cqi;
    static auto make_root_cqi() -> std::unique_ptr<drv>;
    virtual auto make_cqi(type<nvswitch_drv>) -> std::shared_ptr<nvswitch_drv> = 0;
};

} // namespace nscq::cqi
