.TH sane\-coolscan 5 "13 Jul 2008" "@PACKAGEVERSION@" "SANE Scanner Access Now Easy"
.IX sane\-coolscan

.SH NAME
sane\-coolscan \- SANE backend for Nikon film-scanners

.SH ABOUT THIS FILE

This file is a short description of the coolscan-backend for sane! 

.SH DESCRIPTION

The
.B sane\-coolscan
library implements a SANE backend that provides the interface to the following Nikon Coolscan Film scanners: Nikon LS20, LS30, LS1000, LS2000.

.B Even though the backend has worked for a number of people, there are still some problems, especially in combination with some SCSI card/drivers (AHA-1505/aha152x.o) and the autofocus command. You should consider this backend 'alpha' and be careful when using it the first time.

.SH CONFIGURATION

The configuration file for this backend resides in 
.IR @CONFIGDIR@/coolscan.conf .

Its contents is a list of device names that correspond to Nikon Coolscan scanners. Empty lines
and lines starting with a hash mark (#) are ignored. A sample configuration file is
shown below: 

.nf
 #scsi Vendor Model Type 
 scsi Nikon * Scanner 
 /dev/scanner 
.fi

The special device name must be a generic SCSI device or a symlink to such a device.
To find out to which device your scanner is assigned and how you have to set the
permissions of that device, have a look at sane\-scsi. 

.SH SCSI ADAPTER TIPS

Some SCSI-adapters and low-level SCSI drivers do not work correctly with this backend and the
Coolscan scanners. These systems hang when the autofocus command is send to the Scanner.
To see a list of which card/driver combinations work or dont work have a look at:
http://andreas.rick.free.fr/sane/autofocus.html.



.SH FILES

.TP
The backend configuration file:
.I @CONFIGDIR@/coolscan.conf
.TP
The static library implementing this backend:
.I @LIBDIR@/libsane\-coolscan.a
.TP
The shared library implementing this backend:
.I @LIBDIR@/libsane\-coolscan.so
(present on systems that support dynamic loading)

.SH ENVIRONMENT

.TP
.B SANE_DEBUG_COOLSCAN
If the library was compiled with debug support enabled, this environment
variable controls the debug level for this backend. E.g., a value of 128
requests all debug output to be printed. Smaller levels reduce verbosity:
SANE_DEBUG_COOLSCAN values

Examples:

on bash:
.br
export SANE_DEBUG_COOLSCAN=8

on csh:
.br
setenv SANE_DEBUG_COOLSCAN 8

.SH BUGS

The autofocus command does not work with some SCSI card/driver combinations
.PP
The gamma table is not implemented for the LS1000 yet.
.PP
The dust-removal is not working yet

.SH SEE ALSO

.TP
.I http://andreas.rick.free.fr/sane/
The homepage of this backend
.TP
.I http://www.sema.be/coolscan/
The original version of the coolscan backend by Didier
.PP
sane(7), sane\-scsi(5)

.SH THANKS TO

.PP
Didier Carlier \- For writing the original Coolscan backend (without it I would not have started this)
.PP
Oliver Rauch \- For adapting xsane so quickly to the infrared stuff.
.PP
All the other people working on SANE.

.SH AUTHOR
Andreas Rick

.SH EMAIL-CONTACT
andreas.rick@free.fr
