RabbitMQ `3.11.11` is a maintenance release in the `3.11.x` [release series](https://www.rabbitmq.com/versions.html).

Please refer to the upgrade section from [v3.11.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.11.0)
if upgrading from a version prior to 3.11.0.

This release requires Erlang 25.
[RabbitMQ and Erlang/OTP Compatibility Matrix](https://www.rabbitmq.com/which-erlang.html) has more details on
Erlang version requirements for RabbitMQ.


### Minimum Supported Erlang Version

As of 3.11.0, RabbitMQ requires Erlang 25. Nodes **will fail to start** on older Erlang releases.

Erlang 25 as our new baseline means much improved performance on ARM64 architectures, [profiling with flame graphs](https://blog.rabbitmq.com/posts/2022/05/flame-graphs/)
across all architectures, and the most recent TLS 1.3 implementation available to all RabbitMQ 3.11 users.


## Changes Worth Mentioning

Release notes can be found on GitHub at [rabbitmq-server/release-notes](https://github.com/rabbitmq/rabbitmq-server/tree/v3.11.x/release-notes).

### Core Server

#### Bug Fixes

 * Streams consumers that oscillate between being active and inactive, or just happen to be
   temporarily become really slow, could become completely starved of deliveries. That is,
   their message delivery rate could drop to 0 while other consumers did not have this problem.

   GitHub issue: [#7638](https://github.com/rabbitmq/rabbitmq-server/pull/7638)

 * Stream coordinator process memory footprint is now reported correctly (and classified differently).

   Contributed by @gomoripeti (CloudAMQP).

   GitHub issue: [#7548](https://github.com/rabbitmq/rabbitmq-server/pull/7548)

#### Enhancements

 * There is now a way to pre-configure users and their permissions for newly created virtual hosts:

  ``` ini
  default_users.qa_user.vhost_pattern = qa.*
  default_users.qa_user.tags = policymaker,monitoring
  default_users.qa_user.password = fd237824441a78cd922410af4b83f0888186a8d7
  default_users.qa_user.read = .*
  default_users.qa_user.write = .*
  default_users.qa_user.configure = .*
  ```
   This is primarily useful in environments where RabbitMQ is provided as a service but
   customers (clients) have control over virtual hosts.

   Contributed by @illotum (AWS).

   GitHub issue: [#7208](https://github.com/rabbitmq/rabbitmq-server/issues/7208).


## Management Plugin

### Bug Fixes

 * HTTP API will now respond with a `405 Method Not Allowed` instead of a 500 when
   an unsupported method is used by the client.

   Contributed by @gomoripeti (CloudAMQP).

   GitHub issue: [#7675](https://github.com/rabbitmq/rabbitmq-server/pull/7675)


### STOMP Plugin

#### Enhancements

 * Consumers on `/queue/` destinations that consume from [streams](https://rabbitmq.com/streams.html) now can specify the
   `x-stream-max-segment-size-bytes` setting via `SUBSCRIBE` frame headers.

   GitHub issues: [#7605](https://github.com/rabbitmq/rabbitmq-server/pull/7605)


### etcd Peer Discovery Plugin

#### Bug Fixes

 * Node key TTL setting was unintentionally ignored.

   GitHub issues: [#7554](https://github.com/rabbitmq/rabbitmq-server/issues/7554)


## Dependency Upgrades

None in this release.


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.11.11.tar.xz`
instead of the source tarball produced by GitHub.
