/*
 * Copyright (c) 2015, 2016, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/**
 * @test
 * @summary Test implicit String concatenations, multiple shapes.
 *
 * @compile ImplicitStringConcatShapes.java
 * @run main/othervm -Xverify:all ImplicitStringConcatShapes
 *
 * @compile -XDstringConcat=inline ImplicitStringConcatShapes.java
 * @run main/othervm -Xverify:all ImplicitStringConcatShapes
 *
 * @compile -XDstringConcat=indy -source 1.9 -target 1.9 ImplicitStringConcatShapes.java
 *
 * @run main/othervm -Xverify:all -Djava.lang.invoke.stringConcat=BC_SB                                                              ImplicitStringConcatShapes
 * @run main/othervm -Xverify:all -Djava.lang.invoke.stringConcat=BC_SB_SIZED                                                        ImplicitStringConcatShapes
 * @run main/othervm -Xverify:all -Djava.lang.invoke.stringConcat=MH_SB_SIZED                                                        ImplicitStringConcatShapes
 * @run main/othervm -Xverify:all -Djava.lang.invoke.stringConcat=BC_SB_SIZED_EXACT                                                  ImplicitStringConcatShapes
 * @run main/othervm -Xverify:all -Djava.lang.invoke.stringConcat=MH_SB_SIZED_EXACT                                                  ImplicitStringConcatShapes
 * @run main/othervm -Xverify:all -Djava.lang.invoke.stringConcat=MH_INLINE_SIZED_EXACT                                              ImplicitStringConcatShapes
 *
 * @run main/othervm -Xverify:all -Djava.lang.invoke.stringConcat=BC_SB                  -Djava.lang.invoke.stringConcat.debug=true  ImplicitStringConcatShapes
 * @run main/othervm -Xverify:all -Djava.lang.invoke.stringConcat=BC_SB_SIZED            -Djava.lang.invoke.stringConcat.debug=true  ImplicitStringConcatShapes
 * @run main/othervm -Xverify:all -Djava.lang.invoke.stringConcat=MH_SB_SIZED            -Djava.lang.invoke.stringConcat.debug=true  ImplicitStringConcatShapes
 * @run main/othervm -Xverify:all -Djava.lang.invoke.stringConcat=BC_SB_SIZED_EXACT      -Djava.lang.invoke.stringConcat.debug=true  ImplicitStringConcatShapes
 * @run main/othervm -Xverify:all -Djava.lang.invoke.stringConcat=MH_SB_SIZED_EXACT      -Djava.lang.invoke.stringConcat.debug=true  ImplicitStringConcatShapes
 * @run main/othervm -Xverify:all -Djava.lang.invoke.stringConcat=MH_INLINE_SIZED_EXACT  -Djava.lang.invoke.stringConcat.debug=true  ImplicitStringConcatShapes
 *
 * @run main/othervm -Xverify:all -Djava.lang.invoke.stringConcat=BC_SB                                                              -Djava.lang.invoke.stringConcat.cache=true  ImplicitStringConcatShapes
 * @run main/othervm -Xverify:all -Djava.lang.invoke.stringConcat=BC_SB_SIZED                                                        -Djava.lang.invoke.stringConcat.cache=true  ImplicitStringConcatShapes
 * @run main/othervm -Xverify:all -Djava.lang.invoke.stringConcat=MH_SB_SIZED                                                        -Djava.lang.invoke.stringConcat.cache=true  ImplicitStringConcatShapes
 * @run main/othervm -Xverify:all -Djava.lang.invoke.stringConcat=BC_SB_SIZED_EXACT                                                  -Djava.lang.invoke.stringConcat.cache=true  ImplicitStringConcatShapes
 * @run main/othervm -Xverify:all -Djava.lang.invoke.stringConcat=MH_SB_SIZED_EXACT                                                  -Djava.lang.invoke.stringConcat.cache=true  ImplicitStringConcatShapes
 * @run main/othervm -Xverify:all -Djava.lang.invoke.stringConcat=MH_INLINE_SIZED_EXACT                                              -Djava.lang.invoke.stringConcat.cache=true  ImplicitStringConcatShapes

 * @run main/othervm -Xverify:all -Djava.lang.invoke.stringConcat=BC_SB                  -Djava.lang.invoke.stringConcat.debug=true  -Djava.lang.invoke.stringConcat.cache=true  ImplicitStringConcatShapes
 * @run main/othervm -Xverify:all -Djava.lang.invoke.stringConcat=BC_SB_SIZED            -Djava.lang.invoke.stringConcat.debug=true  -Djava.lang.invoke.stringConcat.cache=true  ImplicitStringConcatShapes
 * @run main/othervm -Xverify:all -Djava.lang.invoke.stringConcat=MH_SB_SIZED            -Djava.lang.invoke.stringConcat.debug=true  -Djava.lang.invoke.stringConcat.cache=true  ImplicitStringConcatShapes
 * @run main/othervm -Xverify:all -Djava.lang.invoke.stringConcat=BC_SB_SIZED_EXACT      -Djava.lang.invoke.stringConcat.debug=true  -Djava.lang.invoke.stringConcat.cache=true  ImplicitStringConcatShapes
 * @run main/othervm -Xverify:all -Djava.lang.invoke.stringConcat=MH_SB_SIZED_EXACT      -Djava.lang.invoke.stringConcat.debug=true  -Djava.lang.invoke.stringConcat.cache=true  ImplicitStringConcatShapes
 * @run main/othervm -Xverify:all -Djava.lang.invoke.stringConcat=MH_INLINE_SIZED_EXACT  -Djava.lang.invoke.stringConcat.debug=true  -Djava.lang.invoke.stringConcat.cache=true  ImplicitStringConcatShapes
 *
 * @compile -XDstringConcat=indyWithConstants -source 1.9 -target 1.9 ImplicitStringConcatShapes.java
 *
 * @run main/othervm -Xverify:all -Djava.lang.invoke.stringConcat=BC_SB                                                              ImplicitStringConcatShapes
 * @run main/othervm -Xverify:all -Djava.lang.invoke.stringConcat=BC_SB_SIZED                                                        ImplicitStringConcatShapes
 * @run main/othervm -Xverify:all -Djava.lang.invoke.stringConcat=MH_SB_SIZED                                                        ImplicitStringConcatShapes
 * @run main/othervm -Xverify:all -Djava.lang.invoke.stringConcat=BC_SB_SIZED_EXACT                                                  ImplicitStringConcatShapes
 * @run main/othervm -Xverify:all -Djava.lang.invoke.stringConcat=MH_SB_SIZED_EXACT                                                  ImplicitStringConcatShapes
 * @run main/othervm -Xverify:all -Djava.lang.invoke.stringConcat=MH_INLINE_SIZED_EXACT                                              ImplicitStringConcatShapes
 *
 * @run main/othervm -Xverify:all -Djava.lang.invoke.stringConcat=BC_SB                  -Djava.lang.invoke.stringConcat.debug=true  ImplicitStringConcatShapes
 * @run main/othervm -Xverify:all -Djava.lang.invoke.stringConcat=BC_SB_SIZED            -Djava.lang.invoke.stringConcat.debug=true  ImplicitStringConcatShapes
 * @run main/othervm -Xverify:all -Djava.lang.invoke.stringConcat=MH_SB_SIZED            -Djava.lang.invoke.stringConcat.debug=true  ImplicitStringConcatShapes
 * @run main/othervm -Xverify:all -Djava.lang.invoke.stringConcat=BC_SB_SIZED_EXACT      -Djava.lang.invoke.stringConcat.debug=true  ImplicitStringConcatShapes
 * @run main/othervm -Xverify:all -Djava.lang.invoke.stringConcat=MH_SB_SIZED_EXACT      -Djava.lang.invoke.stringConcat.debug=true  ImplicitStringConcatShapes
 * @run main/othervm -Xverify:all -Djava.lang.invoke.stringConcat=MH_INLINE_SIZED_EXACT  -Djava.lang.invoke.stringConcat.debug=true  ImplicitStringConcatShapes
 *
 * @run main/othervm -Xverify:all -Djava.lang.invoke.stringConcat=BC_SB                                                              -Djava.lang.invoke.stringConcat.cache=true  ImplicitStringConcatShapes
 * @run main/othervm -Xverify:all -Djava.lang.invoke.stringConcat=BC_SB_SIZED                                                        -Djava.lang.invoke.stringConcat.cache=true  ImplicitStringConcatShapes
 * @run main/othervm -Xverify:all -Djava.lang.invoke.stringConcat=MH_SB_SIZED                                                        -Djava.lang.invoke.stringConcat.cache=true  ImplicitStringConcatShapes
 * @run main/othervm -Xverify:all -Djava.lang.invoke.stringConcat=BC_SB_SIZED_EXACT                                                  -Djava.lang.invoke.stringConcat.cache=true  ImplicitStringConcatShapes
 * @run main/othervm -Xverify:all -Djava.lang.invoke.stringConcat=MH_SB_SIZED_EXACT                                                  -Djava.lang.invoke.stringConcat.cache=true  ImplicitStringConcatShapes
 * @run main/othervm -Xverify:all -Djava.lang.invoke.stringConcat=MH_INLINE_SIZED_EXACT                                              -Djava.lang.invoke.stringConcat.cache=true  ImplicitStringConcatShapes
 *
 * @run main/othervm -Xverify:all -Djava.lang.invoke.stringConcat=BC_SB                  -Djava.lang.invoke.stringConcat.debug=true  -Djava.lang.invoke.stringConcat.cache=true  ImplicitStringConcatShapes
 * @run main/othervm -Xverify:all -Djava.lang.invoke.stringConcat=BC_SB_SIZED            -Djava.lang.invoke.stringConcat.debug=true  -Djava.lang.invoke.stringConcat.cache=true  ImplicitStringConcatShapes
 * @run main/othervm -Xverify:all -Djava.lang.invoke.stringConcat=MH_SB_SIZED            -Djava.lang.invoke.stringConcat.debug=true  -Djava.lang.invoke.stringConcat.cache=true  ImplicitStringConcatShapes
 * @run main/othervm -Xverify:all -Djava.lang.invoke.stringConcat=BC_SB_SIZED_EXACT      -Djava.lang.invoke.stringConcat.debug=true  -Djava.lang.invoke.stringConcat.cache=true  ImplicitStringConcatShapes
 * @run main/othervm -Xverify:all -Djava.lang.invoke.stringConcat=MH_SB_SIZED_EXACT      -Djava.lang.invoke.stringConcat.debug=true  -Djava.lang.invoke.stringConcat.cache=true  ImplicitStringConcatShapes
 * @run main/othervm -Xverify:all -Djava.lang.invoke.stringConcat=MH_INLINE_SIZED_EXACT  -Djava.lang.invoke.stringConcat.debug=true  -Djava.lang.invoke.stringConcat.cache=true  ImplicitStringConcatShapes
*/
public class ImplicitStringConcatShapes {
    public static void test(String expected, String actual) {
        // Fingers crossed: String concat should work.
        if (!expected.equals(actual)) {
            StringBuilder sb = new StringBuilder();
            sb.append("Expected = ");
            sb.append(expected);
            sb.append(", actual = ");
            sb.append(actual);
            throw new IllegalStateException(sb.toString());
        }
    }

    static class MyClass {
        private final int i;

        public MyClass(int i) {
            this.i = i;
        }

        public String toString() {
            return new StringBuilder("C(").append(i).append(")").toString();
        }
    }

    static class MyClassNullToString {
        public String toString() {
            return null;
        }
    }

    public static void main(String[] args) throws Exception {
        new ImplicitStringConcatShapes().run();
    }
    static final boolean sf_bl = true;
    static final byte sf_b = 80;
    static final byte sf_bM = -41;
    static final char sf_c = 'C';
    static final short sf_s = 5500;
    static final short sf_sM = -8400;
    static final int sf_i = 75000000;
    static final int sf_iM = -2000000;
    static final Integer sf_I = 1000000;
    static final Integer sf_IN = null;
    static final float sf_f = 17.0f;
    static final float sf_fM = -42.0f;
    static final long sf_l = -194313216L;
    static final long sf_lM = -1705032704L;
    static final double sf_d = 12.0d;
    static final double sf_dM = -84.0d;
    static final Object sf_o = new MyClass(87);
    static final Object sf_oN = null;
    static final Object sf_oNtS = new MyClassNullToString();
    static final String sf_str = "75";
    static final String sf_strU = "\u04511";
    static final String sf_strU1 = "\u000151";
    static final String sf_strU2 = "\u000292";
    static final int[] sf_iAN = null;
    static final Object[] sf_oAN = null;
    static  boolean s_bl = true;
    static  byte s_b = 25;
    static  byte s_bM = -43;
    static  char s_c = 'T';
    static  short s_s = 3900;
    static  short s_sM = -2900;
    static  int s_i = 97000000;
    static  int s_iM = -1000000;
    static  Integer s_I = 25000000;
    static  Integer s_IN = null;
    static  float s_f = 55.0f;
    static  float s_fM = -52.0f;
    static  long s_l = 935228928L;
    static  long s_lM = -1410065408L;
    static  double s_d = 8.0d;
    static  double s_dM = -96.0d;
    static  Object s_o = new MyClass(82);
    static  Object s_oN = null;
    static  Object s_oNtS = new MyClassNullToString();
    static  String s_str = "18";
    static  String s_strU = "\u045180";
    static  String s_strU1 = "\u000112";
    static  String s_strU2 = "\u000291";
    static  int[] s_iAN = null;
    static  Object[] s_oAN = null;
     final boolean f_bl = false;
     final byte f_b = 44;
     final byte f_bM = -54;
     final char f_c = 'I';
     final short f_s = 8000;
     final short f_sM = -9900;
     final int f_i = 58000000;
     final int f_iM = -55000000;
     final Integer f_I = 94000000;
     final Integer f_IN = null;
     final float f_f = 94.0f;
     final float f_fM = -87.0f;
     final long f_l = 1460392448L;
     final long f_lM = -820130816L;
     final double f_d = 83.0d;
     final double f_dM = -99.0d;
     final Object f_o = new MyClass(70);
     final Object f_oN = null;
     final Object f_oNtS = new MyClassNullToString();
     final String f_str = "19";
     final String f_strU = "\u045176";
     final String f_strU1 = "\u000121";
     final String f_strU2 = "\u000218";
     final int[] f_iAN = null;
     final Object[] f_oAN = null;

    public void run() {
        run0();
        run1();
        run2();
        run3();
        run4();
        run5();
    }

    public void run0() {
        test("-96.0", "" + s_dM);
        test("null", "" + s_oNtS);
        test("\u045176", "" + f_strU);
        test("92", "" + sf_strU2);
        test("51", "" + sf_strU1);
        test("null", "" + s_iAN);
        test("-54", "" + f_bM);
        test("-87.0", "" + f_fM);
        test("null", "" + s_oAN);
        test("19", "" + f_str);
        test("-41", "" + sf_bM);
        test("null", "" + sf_IN);
        test("T", "" + s_c);
        test("-42.0", "" + sf_fM);
        test("25", "" + s_b);
        test("null", "" + f_oN);
        test("-1410065408", "" + s_lM);
        test("8.0", "" + s_d);
        test("55.0", "" + s_f);
        test("97000000", "" + s_i);
        test("-9900", "" + f_sM);
        test("935228928", "" + s_l);
        test("-8400", "" + sf_sM);
        test("C(82)", "" + s_o);
        test("null", "" + sf_oNtS);
        test("true", "" + s_bl);
        test("3900", "" + s_s);
        test("null", "" + sf_oN);
        test("94000000", "" + f_I);
        test("null", "" + f_IN);
        test("true", "" + sf_bl);
        test("5500", "" + sf_s);
        test("-2900", "" + s_sM);
        test("-194313216", "" + sf_l);
        test("12", "" + s_strU1);
        test("C(87)", "" + sf_o);
        test("91", "" + s_strU2);
        test("21", "" + f_strU1);
        test("18", "" + f_strU2);
        test("null", "" + f_iAN);
        test("null", "" + s_oN);
        test("\u045180", "" + s_strU);
        test("C", "" + sf_c);
        test("75", "" + sf_str);
        test("-43", "" + s_bM);
        test("80", "" + sf_b);
        test("null", "" + s_IN);
        test("-52.0", "" + s_fM);
        test("75000000", "" + sf_i);
        test("44", "" + f_b);
        test("-1705032704", "" + sf_lM);
        test("null", "" + f_oAN);
        test("83.0", "" + f_d);
        test("I", "" + f_c);
        test("94.0", "" + f_f);
        test("12.0", "" + sf_d);
        test("-99.0", "" + f_dM);
        test("17.0", "" + sf_f);
        test("-84.0", "" + sf_dM);
        test("58000000", "" + f_i);
        test("-55000000", "" + f_iM);
        test("1460392448", "" + f_l);
        test("C(70)", "" + f_o);
        test("\u04511", "" + sf_strU);
        test("8000", "" + f_s);
        test("18", "" + s_str);
        test("-1000000", "" + s_iM);
        test("1000000", "" + sf_I);
        test("null", "" + f_oNtS);
        test("false", "" + f_bl);
        test("null", "" + sf_iAN);
        test("-2000000", "" + sf_iM);
        test("-820130816", "" + f_lM);
        test("null", "" + sf_oAN);
        test("25000000", "" + s_I);
        test("-96.0-96.0", "" + s_dM + s_dM);
        test("-96.0null", "" + s_dM + s_oNtS);
        test("-96.0\u045176", "" + s_dM + f_strU);
        test("-96.092", "" + s_dM + sf_strU2);
        test("-96.051", "" + s_dM + sf_strU1);
        test("-96.0null", "" + s_dM + s_iAN);
        test("-96.0-54", "" + s_dM + f_bM);
        test("-96.0-87.0", "" + s_dM + f_fM);
        test("-96.0null", "" + s_dM + s_oAN);
        test("-96.019", "" + s_dM + f_str);
        test("-96.0-41", "" + s_dM + sf_bM);
        test("-96.0null", "" + s_dM + sf_IN);
        test("-96.0T", "" + s_dM + s_c);
        test("-96.0-42.0", "" + s_dM + sf_fM);
        test("-96.025", "" + s_dM + s_b);
        test("-96.0null", "" + s_dM + f_oN);
        test("-96.0-1410065408", "" + s_dM + s_lM);
        test("-96.08.0", "" + s_dM + s_d);
        test("-96.055.0", "" + s_dM + s_f);
        test("-96.097000000", "" + s_dM + s_i);
        test("-96.0-9900", "" + s_dM + f_sM);
        test("-96.0935228928", "" + s_dM + s_l);
        test("-96.0-8400", "" + s_dM + sf_sM);
        test("-96.0C(82)", "" + s_dM + s_o);
        test("-96.0null", "" + s_dM + sf_oNtS);
        test("-96.0true", "" + s_dM + s_bl);
        test("-96.03900", "" + s_dM + s_s);
        test("-96.0null", "" + s_dM + sf_oN);
        test("-96.094000000", "" + s_dM + f_I);
        test("-96.0null", "" + s_dM + f_IN);
        test("-96.0true", "" + s_dM + sf_bl);
        test("-96.05500", "" + s_dM + sf_s);
        test("-96.0-2900", "" + s_dM + s_sM);
        test("-96.0-194313216", "" + s_dM + sf_l);
        test("-96.012", "" + s_dM + s_strU1);
        test("-96.0C(87)", "" + s_dM + sf_o);
        test("-96.091", "" + s_dM + s_strU2);
        test("-96.021", "" + s_dM + f_strU1);
        test("-96.018", "" + s_dM + f_strU2);
        test("-96.0null", "" + s_dM + f_iAN);
        test("-96.0null", "" + s_dM + s_oN);
        test("-96.0\u045180", "" + s_dM + s_strU);
        test("-96.0C", "" + s_dM + sf_c);
        test("-96.075", "" + s_dM + sf_str);
        test("-96.0-43", "" + s_dM + s_bM);
        test("-96.080", "" + s_dM + sf_b);
        test("-96.0null", "" + s_dM + s_IN);
        test("-96.0-52.0", "" + s_dM + s_fM);
        test("-96.075000000", "" + s_dM + sf_i);
        test("-96.044", "" + s_dM + f_b);
        test("-96.0-1705032704", "" + s_dM + sf_lM);
        test("-96.0null", "" + s_dM + f_oAN);
        test("-96.083.0", "" + s_dM + f_d);
        test("-96.0I", "" + s_dM + f_c);
        test("-96.094.0", "" + s_dM + f_f);
        test("-96.012.0", "" + s_dM + sf_d);
        test("-96.0-99.0", "" + s_dM + f_dM);
        test("-96.017.0", "" + s_dM + sf_f);
        test("-96.0-84.0", "" + s_dM + sf_dM);
        test("-96.058000000", "" + s_dM + f_i);
        test("-96.0-55000000", "" + s_dM + f_iM);
        test("-96.01460392448", "" + s_dM + f_l);
        test("-96.0C(70)", "" + s_dM + f_o);
        test("-96.0\u04511", "" + s_dM + sf_strU);
        test("-96.08000", "" + s_dM + f_s);
        test("-96.018", "" + s_dM + s_str);
        test("-96.0-1000000", "" + s_dM + s_iM);
        test("-96.01000000", "" + s_dM + sf_I);
        test("-96.0null", "" + s_dM + f_oNtS);
        test("-96.0false", "" + s_dM + f_bl);
        test("-96.0null", "" + s_dM + sf_iAN);
        test("-96.0-2000000", "" + s_dM + sf_iM);
        test("-96.0-820130816", "" + s_dM + f_lM);
        test("-96.0null", "" + s_dM + sf_oAN);
        test("-96.025000000", "" + s_dM + s_I);
        test("null-96.0", "" + s_oNtS + s_dM);
        test("nullnull", "" + s_oNtS + s_oNtS);
        test("null\u045176", "" + s_oNtS + f_strU);
        test("null92", "" + s_oNtS + sf_strU2);
        test("null51", "" + s_oNtS + sf_strU1);
        test("nullnull", "" + s_oNtS + s_iAN);
        test("null-54", "" + s_oNtS + f_bM);
        test("null-87.0", "" + s_oNtS + f_fM);
        test("nullnull", "" + s_oNtS + s_oAN);
        test("null19", "" + s_oNtS + f_str);
        test("null-41", "" + s_oNtS + sf_bM);
        test("nullnull", "" + s_oNtS + sf_IN);
        test("nullT", "" + s_oNtS + s_c);
        test("null-42.0", "" + s_oNtS + sf_fM);
        test("null25", "" + s_oNtS + s_b);
        test("nullnull", "" + s_oNtS + f_oN);
        test("null-1410065408", "" + s_oNtS + s_lM);
        test("null8.0", "" + s_oNtS + s_d);
        test("null55.0", "" + s_oNtS + s_f);
        test("null97000000", "" + s_oNtS + s_i);
        test("null-9900", "" + s_oNtS + f_sM);
        test("null935228928", "" + s_oNtS + s_l);
        test("null-8400", "" + s_oNtS + sf_sM);
        test("nullC(82)", "" + s_oNtS + s_o);
        test("nullnull", "" + s_oNtS + sf_oNtS);
        test("nulltrue", "" + s_oNtS + s_bl);
        test("null3900", "" + s_oNtS + s_s);
        test("nullnull", "" + s_oNtS + sf_oN);
        test("null94000000", "" + s_oNtS + f_I);
        test("nullnull", "" + s_oNtS + f_IN);
        test("nulltrue", "" + s_oNtS + sf_bl);
        test("null5500", "" + s_oNtS + sf_s);
        test("null-2900", "" + s_oNtS + s_sM);
        test("null-194313216", "" + s_oNtS + sf_l);
        test("null12", "" + s_oNtS + s_strU1);
        test("nullC(87)", "" + s_oNtS + sf_o);
        test("null91", "" + s_oNtS + s_strU2);
        test("null21", "" + s_oNtS + f_strU1);
        test("null18", "" + s_oNtS + f_strU2);
        test("nullnull", "" + s_oNtS + f_iAN);
        test("nullnull", "" + s_oNtS + s_oN);
        test("null\u045180", "" + s_oNtS + s_strU);
        test("nullC", "" + s_oNtS + sf_c);
        test("null75", "" + s_oNtS + sf_str);
        test("null-43", "" + s_oNtS + s_bM);
        test("null80", "" + s_oNtS + sf_b);
        test("nullnull", "" + s_oNtS + s_IN);
        test("null-52.0", "" + s_oNtS + s_fM);
        test("null75000000", "" + s_oNtS + sf_i);
        test("null44", "" + s_oNtS + f_b);
        test("null-1705032704", "" + s_oNtS + sf_lM);
        test("nullnull", "" + s_oNtS + f_oAN);
        test("null83.0", "" + s_oNtS + f_d);
        test("nullI", "" + s_oNtS + f_c);
        test("null94.0", "" + s_oNtS + f_f);
        test("null12.0", "" + s_oNtS + sf_d);
        test("null-99.0", "" + s_oNtS + f_dM);
        test("null17.0", "" + s_oNtS + sf_f);
        test("null-84.0", "" + s_oNtS + sf_dM);
        test("null58000000", "" + s_oNtS + f_i);
        test("null-55000000", "" + s_oNtS + f_iM);
        test("null1460392448", "" + s_oNtS + f_l);
        test("nullC(70)", "" + s_oNtS + f_o);
        test("null\u04511", "" + s_oNtS + sf_strU);
        test("null8000", "" + s_oNtS + f_s);
        test("null18", "" + s_oNtS + s_str);
        test("null-1000000", "" + s_oNtS + s_iM);
        test("null1000000", "" + s_oNtS + sf_I);
        test("nullnull", "" + s_oNtS + f_oNtS);
        test("nullfalse", "" + s_oNtS + f_bl);
        test("nullnull", "" + s_oNtS + sf_iAN);
        test("null-2000000", "" + s_oNtS + sf_iM);
        test("null-820130816", "" + s_oNtS + f_lM);
        test("nullnull", "" + s_oNtS + sf_oAN);
        test("null25000000", "" + s_oNtS + s_I);
        test("\u045176-96.0", "" + f_strU + s_dM);
        test("\u045176null", "" + f_strU + s_oNtS);
        test("\u045176\u045176", "" + f_strU + f_strU);
        test("\u04517692", "" + f_strU + sf_strU2);
        test("\u04517651", "" + f_strU + sf_strU1);
        test("\u045176null", "" + f_strU + s_iAN);
        test("\u045176-54", "" + f_strU + f_bM);
        test("\u045176-87.0", "" + f_strU + f_fM);
        test("\u045176null", "" + f_strU + s_oAN);
        test("\u04517619", "" + f_strU + f_str);
        test("\u045176-41", "" + f_strU + sf_bM);
        test("\u045176null", "" + f_strU + sf_IN);
        test("\u045176T", "" + f_strU + s_c);
        test("\u045176-42.0", "" + f_strU + sf_fM);
        test("\u04517625", "" + f_strU + s_b);
        test("\u045176null", "" + f_strU + f_oN);
        test("\u045176-1410065408", "" + f_strU + s_lM);
        test("\u0451768.0", "" + f_strU + s_d);
        test("\u04517655.0", "" + f_strU + s_f);
        test("\u04517697000000", "" + f_strU + s_i);
        test("\u045176-9900", "" + f_strU + f_sM);
        test("\u045176935228928", "" + f_strU + s_l);
        test("\u045176-8400", "" + f_strU + sf_sM);
        test("\u045176C(82)", "" + f_strU + s_o);
        test("\u045176null", "" + f_strU + sf_oNtS);
        test("\u045176true", "" + f_strU + s_bl);
        test("\u0451763900", "" + f_strU + s_s);
        test("\u045176null", "" + f_strU + sf_oN);
        test("\u04517694000000", "" + f_strU + f_I);
        test("\u045176null", "" + f_strU + f_IN);
        test("\u045176true", "" + f_strU + sf_bl);
        test("\u0451765500", "" + f_strU + sf_s);
        test("\u045176-2900", "" + f_strU + s_sM);
        test("\u045176-194313216", "" + f_strU + sf_l);
        test("\u04517612", "" + f_strU + s_strU1);
        test("\u045176C(87)", "" + f_strU + sf_o);
        test("\u04517691", "" + f_strU + s_strU2);
        test("\u04517621", "" + f_strU + f_strU1);
        test("\u04517618", "" + f_strU + f_strU2);
        test("\u045176null", "" + f_strU + f_iAN);
        test("\u045176null", "" + f_strU + s_oN);
        test("\u045176\u045180", "" + f_strU + s_strU);
        test("\u045176C", "" + f_strU + sf_c);
        test("\u04517675", "" + f_strU + sf_str);
        test("\u045176-43", "" + f_strU + s_bM);
        test("\u04517680", "" + f_strU + sf_b);
        test("\u045176null", "" + f_strU + s_IN);
        test("\u045176-52.0", "" + f_strU + s_fM);
        test("\u04517675000000", "" + f_strU + sf_i);
        test("\u04517644", "" + f_strU + f_b);
        test("\u045176-1705032704", "" + f_strU + sf_lM);
        test("\u045176null", "" + f_strU + f_oAN);
        test("\u04517683.0", "" + f_strU + f_d);
        test("\u045176I", "" + f_strU + f_c);
        test("\u04517694.0", "" + f_strU + f_f);
        test("\u04517612.0", "" + f_strU + sf_d);
        test("\u045176-99.0", "" + f_strU + f_dM);
        test("\u04517617.0", "" + f_strU + sf_f);
        test("\u045176-84.0", "" + f_strU + sf_dM);
        test("\u04517658000000", "" + f_strU + f_i);
        test("\u045176-55000000", "" + f_strU + f_iM);
        test("\u0451761460392448", "" + f_strU + f_l);
        test("\u045176C(70)", "" + f_strU + f_o);
        test("\u045176\u04511", "" + f_strU + sf_strU);
        test("\u0451768000", "" + f_strU + f_s);
        test("\u04517618", "" + f_strU + s_str);
        test("\u045176-1000000", "" + f_strU + s_iM);
        test("\u0451761000000", "" + f_strU + sf_I);
        test("\u045176null", "" + f_strU + f_oNtS);
        test("\u045176false", "" + f_strU + f_bl);
        test("\u045176null", "" + f_strU + sf_iAN);
        test("\u045176-2000000", "" + f_strU + sf_iM);
        test("\u045176-820130816", "" + f_strU + f_lM);
        test("\u045176null", "" + f_strU + sf_oAN);
        test("\u04517625000000", "" + f_strU + s_I);
        test("92-96.0", "" + sf_strU2 + s_dM);
        test("92null", "" + sf_strU2 + s_oNtS);
        test("92\u045176", "" + sf_strU2 + f_strU);
        test("9292", "" + sf_strU2 + sf_strU2);
        test("9251", "" + sf_strU2 + sf_strU1);
        test("92null", "" + sf_strU2 + s_iAN);
        test("92-54", "" + sf_strU2 + f_bM);
        test("92-87.0", "" + sf_strU2 + f_fM);
        test("92null", "" + sf_strU2 + s_oAN);
        test("9219", "" + sf_strU2 + f_str);
        test("92-41", "" + sf_strU2 + sf_bM);
        test("92null", "" + sf_strU2 + sf_IN);
        test("92T", "" + sf_strU2 + s_c);
        test("92-42.0", "" + sf_strU2 + sf_fM);
        test("9225", "" + sf_strU2 + s_b);
        test("92null", "" + sf_strU2 + f_oN);
        test("92-1410065408", "" + sf_strU2 + s_lM);
        test("928.0", "" + sf_strU2 + s_d);
        test("9255.0", "" + sf_strU2 + s_f);
        test("9297000000", "" + sf_strU2 + s_i);
        test("92-9900", "" + sf_strU2 + f_sM);
        test("92935228928", "" + sf_strU2 + s_l);
        test("92-8400", "" + sf_strU2 + sf_sM);
        test("92C(82)", "" + sf_strU2 + s_o);
        test("92null", "" + sf_strU2 + sf_oNtS);
        test("92true", "" + sf_strU2 + s_bl);
        test("923900", "" + sf_strU2 + s_s);
        test("92null", "" + sf_strU2 + sf_oN);
        test("9294000000", "" + sf_strU2 + f_I);
        test("92null", "" + sf_strU2 + f_IN);
        test("92true", "" + sf_strU2 + sf_bl);
        test("925500", "" + sf_strU2 + sf_s);
        test("92-2900", "" + sf_strU2 + s_sM);
        test("92-194313216", "" + sf_strU2 + sf_l);
        test("9212", "" + sf_strU2 + s_strU1);
        test("92C(87)", "" + sf_strU2 + sf_o);
        test("9291", "" + sf_strU2 + s_strU2);
        test("9221", "" + sf_strU2 + f_strU1);
        test("9218", "" + sf_strU2 + f_strU2);
        test("92null", "" + sf_strU2 + f_iAN);
        test("92null", "" + sf_strU2 + s_oN);
        test("92\u045180", "" + sf_strU2 + s_strU);
        test("92C", "" + sf_strU2 + sf_c);
        test("9275", "" + sf_strU2 + sf_str);
        test("92-43", "" + sf_strU2 + s_bM);
        test("9280", "" + sf_strU2 + sf_b);
        test("92null", "" + sf_strU2 + s_IN);
        test("92-52.0", "" + sf_strU2 + s_fM);
        test("9275000000", "" + sf_strU2 + sf_i);
        test("9244", "" + sf_strU2 + f_b);
        test("92-1705032704", "" + sf_strU2 + sf_lM);
        test("92null", "" + sf_strU2 + f_oAN);
        test("9283.0", "" + sf_strU2 + f_d);
        test("92I", "" + sf_strU2 + f_c);
        test("9294.0", "" + sf_strU2 + f_f);
        test("9212.0", "" + sf_strU2 + sf_d);
        test("92-99.0", "" + sf_strU2 + f_dM);
        test("9217.0", "" + sf_strU2 + sf_f);
        test("92-84.0", "" + sf_strU2 + sf_dM);
        test("9258000000", "" + sf_strU2 + f_i);
        test("92-55000000", "" + sf_strU2 + f_iM);
        test("921460392448", "" + sf_strU2 + f_l);
        test("92C(70)", "" + sf_strU2 + f_o);
        test("92\u04511", "" + sf_strU2 + sf_strU);
        test("928000", "" + sf_strU2 + f_s);
        test("9218", "" + sf_strU2 + s_str);
        test("92-1000000", "" + sf_strU2 + s_iM);
        test("921000000", "" + sf_strU2 + sf_I);
        test("92null", "" + sf_strU2 + f_oNtS);
        test("92false", "" + sf_strU2 + f_bl);
        test("92null", "" + sf_strU2 + sf_iAN);
        test("92-2000000", "" + sf_strU2 + sf_iM);
        test("92-820130816", "" + sf_strU2 + f_lM);
        test("92null", "" + sf_strU2 + sf_oAN);
        test("9225000000", "" + sf_strU2 + s_I);
        test("51-96.0", "" + sf_strU1 + s_dM);
        test("51null", "" + sf_strU1 + s_oNtS);
        test("51\u045176", "" + sf_strU1 + f_strU);
        test("5192", "" + sf_strU1 + sf_strU2);
        test("5151", "" + sf_strU1 + sf_strU1);
        test("51null", "" + sf_strU1 + s_iAN);
        test("51-54", "" + sf_strU1 + f_bM);
        test("51-87.0", "" + sf_strU1 + f_fM);
        test("51null", "" + sf_strU1 + s_oAN);
        test("5119", "" + sf_strU1 + f_str);
        test("51-41", "" + sf_strU1 + sf_bM);
        test("51null", "" + sf_strU1 + sf_IN);
        test("51T", "" + sf_strU1 + s_c);
        test("51-42.0", "" + sf_strU1 + sf_fM);
        test("5125", "" + sf_strU1 + s_b);
        test("51null", "" + sf_strU1 + f_oN);
        test("51-1410065408", "" + sf_strU1 + s_lM);
        test("518.0", "" + sf_strU1 + s_d);
        test("5155.0", "" + sf_strU1 + s_f);
        test("5197000000", "" + sf_strU1 + s_i);
        test("51-9900", "" + sf_strU1 + f_sM);
        test("51935228928", "" + sf_strU1 + s_l);
        test("51-8400", "" + sf_strU1 + sf_sM);
        test("51C(82)", "" + sf_strU1 + s_o);
        test("51null", "" + sf_strU1 + sf_oNtS);
        test("51true", "" + sf_strU1 + s_bl);
        test("513900", "" + sf_strU1 + s_s);
        test("51null", "" + sf_strU1 + sf_oN);
        test("5194000000", "" + sf_strU1 + f_I);
        test("51null", "" + sf_strU1 + f_IN);
        test("51true", "" + sf_strU1 + sf_bl);
        test("515500", "" + sf_strU1 + sf_s);
        test("51-2900", "" + sf_strU1 + s_sM);
        test("51-194313216", "" + sf_strU1 + sf_l);
        test("5112", "" + sf_strU1 + s_strU1);
        test("51C(87)", "" + sf_strU1 + sf_o);
        test("5191", "" + sf_strU1 + s_strU2);
        test("5121", "" + sf_strU1 + f_strU1);
        test("5118", "" + sf_strU1 + f_strU2);
        test("51null", "" + sf_strU1 + f_iAN);
        test("51null", "" + sf_strU1 + s_oN);
        test("51\u045180", "" + sf_strU1 + s_strU);
        test("51C", "" + sf_strU1 + sf_c);
        test("5175", "" + sf_strU1 + sf_str);
        test("51-43", "" + sf_strU1 + s_bM);
        test("5180", "" + sf_strU1 + sf_b);
        test("51null", "" + sf_strU1 + s_IN);
        test("51-52.0", "" + sf_strU1 + s_fM);
        test("5175000000", "" + sf_strU1 + sf_i);
        test("5144", "" + sf_strU1 + f_b);
        test("51-1705032704", "" + sf_strU1 + sf_lM);
        test("51null", "" + sf_strU1 + f_oAN);
        test("5183.0", "" + sf_strU1 + f_d);
        test("51I", "" + sf_strU1 + f_c);
        test("5194.0", "" + sf_strU1 + f_f);
        test("5112.0", "" + sf_strU1 + sf_d);
        test("51-99.0", "" + sf_strU1 + f_dM);
        test("5117.0", "" + sf_strU1 + sf_f);
        test("51-84.0", "" + sf_strU1 + sf_dM);
        test("5158000000", "" + sf_strU1 + f_i);
        test("51-55000000", "" + sf_strU1 + f_iM);
        test("511460392448", "" + sf_strU1 + f_l);
        test("51C(70)", "" + sf_strU1 + f_o);
        test("51\u04511", "" + sf_strU1 + sf_strU);
        test("518000", "" + sf_strU1 + f_s);
        test("5118", "" + sf_strU1 + s_str);
        test("51-1000000", "" + sf_strU1 + s_iM);
        test("511000000", "" + sf_strU1 + sf_I);
        test("51null", "" + sf_strU1 + f_oNtS);
        test("51false", "" + sf_strU1 + f_bl);
        test("51null", "" + sf_strU1 + sf_iAN);
        test("51-2000000", "" + sf_strU1 + sf_iM);
        test("51-820130816", "" + sf_strU1 + f_lM);
        test("51null", "" + sf_strU1 + sf_oAN);
        test("5125000000", "" + sf_strU1 + s_I);
        test("null-96.0", "" + s_iAN + s_dM);
        test("nullnull", "" + s_iAN + s_oNtS);
        test("null\u045176", "" + s_iAN + f_strU);
        test("null92", "" + s_iAN + sf_strU2);
        test("null51", "" + s_iAN + sf_strU1);
        test("nullnull", "" + s_iAN + s_iAN);
        test("null-54", "" + s_iAN + f_bM);
        test("null-87.0", "" + s_iAN + f_fM);
        test("nullnull", "" + s_iAN + s_oAN);
        test("null19", "" + s_iAN + f_str);
        test("null-41", "" + s_iAN + sf_bM);
        test("nullnull", "" + s_iAN + sf_IN);
        test("nullT", "" + s_iAN + s_c);
        test("null-42.0", "" + s_iAN + sf_fM);
        test("null25", "" + s_iAN + s_b);
        test("nullnull", "" + s_iAN + f_oN);
        test("null-1410065408", "" + s_iAN + s_lM);
        test("null8.0", "" + s_iAN + s_d);
        test("null55.0", "" + s_iAN + s_f);
        test("null97000000", "" + s_iAN + s_i);
        test("null-9900", "" + s_iAN + f_sM);
        test("null935228928", "" + s_iAN + s_l);
        test("null-8400", "" + s_iAN + sf_sM);
        test("nullC(82)", "" + s_iAN + s_o);
        test("nullnull", "" + s_iAN + sf_oNtS);
        test("nulltrue", "" + s_iAN + s_bl);
        test("null3900", "" + s_iAN + s_s);
        test("nullnull", "" + s_iAN + sf_oN);
        test("null94000000", "" + s_iAN + f_I);
        test("nullnull", "" + s_iAN + f_IN);
        test("nulltrue", "" + s_iAN + sf_bl);
        test("null5500", "" + s_iAN + sf_s);
        test("null-2900", "" + s_iAN + s_sM);
        test("null-194313216", "" + s_iAN + sf_l);
        test("null12", "" + s_iAN + s_strU1);
        test("nullC(87)", "" + s_iAN + sf_o);
        test("null91", "" + s_iAN + s_strU2);
        test("null21", "" + s_iAN + f_strU1);
        test("null18", "" + s_iAN + f_strU2);
        test("nullnull", "" + s_iAN + f_iAN);
        test("nullnull", "" + s_iAN + s_oN);
        test("null\u045180", "" + s_iAN + s_strU);
        test("nullC", "" + s_iAN + sf_c);
        test("null75", "" + s_iAN + sf_str);
        test("null-43", "" + s_iAN + s_bM);
        test("null80", "" + s_iAN + sf_b);
        test("nullnull", "" + s_iAN + s_IN);
        test("null-52.0", "" + s_iAN + s_fM);
        test("null75000000", "" + s_iAN + sf_i);
        test("null44", "" + s_iAN + f_b);
        test("null-1705032704", "" + s_iAN + sf_lM);
        test("nullnull", "" + s_iAN + f_oAN);
        test("null83.0", "" + s_iAN + f_d);
        test("nullI", "" + s_iAN + f_c);
        test("null94.0", "" + s_iAN + f_f);
        test("null12.0", "" + s_iAN + sf_d);
        test("null-99.0", "" + s_iAN + f_dM);
        test("null17.0", "" + s_iAN + sf_f);
        test("null-84.0", "" + s_iAN + sf_dM);
        test("null58000000", "" + s_iAN + f_i);
        test("null-55000000", "" + s_iAN + f_iM);
        test("null1460392448", "" + s_iAN + f_l);
        test("nullC(70)", "" + s_iAN + f_o);
        test("null\u04511", "" + s_iAN + sf_strU);
        test("null8000", "" + s_iAN + f_s);
        test("null18", "" + s_iAN + s_str);
        test("null-1000000", "" + s_iAN + s_iM);
        test("null1000000", "" + s_iAN + sf_I);
        test("nullnull", "" + s_iAN + f_oNtS);
        test("nullfalse", "" + s_iAN + f_bl);
        test("nullnull", "" + s_iAN + sf_iAN);
        test("null-2000000", "" + s_iAN + sf_iM);
        test("null-820130816", "" + s_iAN + f_lM);
        test("nullnull", "" + s_iAN + sf_oAN);
        test("null25000000", "" + s_iAN + s_I);
        test("-54-96.0", "" + f_bM + s_dM);
        test("-54null", "" + f_bM + s_oNtS);
        test("-54\u045176", "" + f_bM + f_strU);
        test("-5492", "" + f_bM + sf_strU2);
        test("-5451", "" + f_bM + sf_strU1);
        test("-54null", "" + f_bM + s_iAN);
        test("-54-54", "" + f_bM + f_bM);
        test("-54-87.0", "" + f_bM + f_fM);
        test("-54null", "" + f_bM + s_oAN);
        test("-5419", "" + f_bM + f_str);
        test("-54-41", "" + f_bM + sf_bM);
        test("-54null", "" + f_bM + sf_IN);
        test("-54T", "" + f_bM + s_c);
        test("-54-42.0", "" + f_bM + sf_fM);
        test("-5425", "" + f_bM + s_b);
        test("-54null", "" + f_bM + f_oN);
        test("-54-1410065408", "" + f_bM + s_lM);
        test("-548.0", "" + f_bM + s_d);
        test("-5455.0", "" + f_bM + s_f);
        test("-5497000000", "" + f_bM + s_i);
        test("-54-9900", "" + f_bM + f_sM);
        test("-54935228928", "" + f_bM + s_l);
        test("-54-8400", "" + f_bM + sf_sM);
        test("-54C(82)", "" + f_bM + s_o);
        test("-54null", "" + f_bM + sf_oNtS);
        test("-54true", "" + f_bM + s_bl);
        test("-543900", "" + f_bM + s_s);
        test("-54null", "" + f_bM + sf_oN);
        test("-5494000000", "" + f_bM + f_I);
        test("-54null", "" + f_bM + f_IN);
        test("-54true", "" + f_bM + sf_bl);
        test("-545500", "" + f_bM + sf_s);
        test("-54-2900", "" + f_bM + s_sM);
        test("-54-194313216", "" + f_bM + sf_l);
        test("-5412", "" + f_bM + s_strU1);
        test("-54C(87)", "" + f_bM + sf_o);
        test("-5491", "" + f_bM + s_strU2);
        test("-5421", "" + f_bM + f_strU1);
        test("-5418", "" + f_bM + f_strU2);
        test("-54null", "" + f_bM + f_iAN);
        test("-54null", "" + f_bM + s_oN);
        test("-54\u045180", "" + f_bM + s_strU);
        test("-54C", "" + f_bM + sf_c);
        test("-5475", "" + f_bM + sf_str);
        test("-54-43", "" + f_bM + s_bM);
        test("-5480", "" + f_bM + sf_b);
        test("-54null", "" + f_bM + s_IN);
        test("-54-52.0", "" + f_bM + s_fM);
        test("-5475000000", "" + f_bM + sf_i);
        test("-5444", "" + f_bM + f_b);
        test("-54-1705032704", "" + f_bM + sf_lM);
        test("-54null", "" + f_bM + f_oAN);
        test("-5483.0", "" + f_bM + f_d);
        test("-54I", "" + f_bM + f_c);
        test("-5494.0", "" + f_bM + f_f);
        test("-5412.0", "" + f_bM + sf_d);
        test("-54-99.0", "" + f_bM + f_dM);
        test("-5417.0", "" + f_bM + sf_f);
        test("-54-84.0", "" + f_bM + sf_dM);
        test("-5458000000", "" + f_bM + f_i);
        test("-54-55000000", "" + f_bM + f_iM);
        test("-541460392448", "" + f_bM + f_l);
        test("-54C(70)", "" + f_bM + f_o);
        test("-54\u04511", "" + f_bM + sf_strU);
        test("-548000", "" + f_bM + f_s);
        test("-5418", "" + f_bM + s_str);
        test("-54-1000000", "" + f_bM + s_iM);
        test("-541000000", "" + f_bM + sf_I);
        test("-54null", "" + f_bM + f_oNtS);
        test("-54false", "" + f_bM + f_bl);
        test("-54null", "" + f_bM + sf_iAN);
        test("-54-2000000", "" + f_bM + sf_iM);
        test("-54-820130816", "" + f_bM + f_lM);
        test("-54null", "" + f_bM + sf_oAN);
        test("-5425000000", "" + f_bM + s_I);
        test("-87.0-96.0", "" + f_fM + s_dM);
        test("-87.0null", "" + f_fM + s_oNtS);
        test("-87.0\u045176", "" + f_fM + f_strU);
        test("-87.092", "" + f_fM + sf_strU2);
        test("-87.051", "" + f_fM + sf_strU1);
        test("-87.0null", "" + f_fM + s_iAN);
        test("-87.0-54", "" + f_fM + f_bM);
        test("-87.0-87.0", "" + f_fM + f_fM);
        test("-87.0null", "" + f_fM + s_oAN);
        test("-87.019", "" + f_fM + f_str);
        test("-87.0-41", "" + f_fM + sf_bM);
        test("-87.0null", "" + f_fM + sf_IN);
        test("-87.0T", "" + f_fM + s_c);
        test("-87.0-42.0", "" + f_fM + sf_fM);
        test("-87.025", "" + f_fM + s_b);
        test("-87.0null", "" + f_fM + f_oN);
        test("-87.0-1410065408", "" + f_fM + s_lM);
        test("-87.08.0", "" + f_fM + s_d);
        test("-87.055.0", "" + f_fM + s_f);
        test("-87.097000000", "" + f_fM + s_i);
        test("-87.0-9900", "" + f_fM + f_sM);
        test("-87.0935228928", "" + f_fM + s_l);
        test("-87.0-8400", "" + f_fM + sf_sM);
        test("-87.0C(82)", "" + f_fM + s_o);
        test("-87.0null", "" + f_fM + sf_oNtS);
        test("-87.0true", "" + f_fM + s_bl);
        test("-87.03900", "" + f_fM + s_s);
        test("-87.0null", "" + f_fM + sf_oN);
        test("-87.094000000", "" + f_fM + f_I);
        test("-87.0null", "" + f_fM + f_IN);
        test("-87.0true", "" + f_fM + sf_bl);
        test("-87.05500", "" + f_fM + sf_s);
        test("-87.0-2900", "" + f_fM + s_sM);
        test("-87.0-194313216", "" + f_fM + sf_l);
        test("-87.012", "" + f_fM + s_strU1);
        test("-87.0C(87)", "" + f_fM + sf_o);
        test("-87.091", "" + f_fM + s_strU2);
        test("-87.021", "" + f_fM + f_strU1);
        test("-87.018", "" + f_fM + f_strU2);
        test("-87.0null", "" + f_fM + f_iAN);
        test("-87.0null", "" + f_fM + s_oN);
        test("-87.0\u045180", "" + f_fM + s_strU);
        test("-87.0C", "" + f_fM + sf_c);
        test("-87.075", "" + f_fM + sf_str);
        test("-87.0-43", "" + f_fM + s_bM);
        test("-87.080", "" + f_fM + sf_b);
        test("-87.0null", "" + f_fM + s_IN);
        test("-87.0-52.0", "" + f_fM + s_fM);
        test("-87.075000000", "" + f_fM + sf_i);
        test("-87.044", "" + f_fM + f_b);
        test("-87.0-1705032704", "" + f_fM + sf_lM);
        test("-87.0null", "" + f_fM + f_oAN);
        test("-87.083.0", "" + f_fM + f_d);
        test("-87.0I", "" + f_fM + f_c);
        test("-87.094.0", "" + f_fM + f_f);
        test("-87.012.0", "" + f_fM + sf_d);
        test("-87.0-99.0", "" + f_fM + f_dM);
        test("-87.017.0", "" + f_fM + sf_f);
        test("-87.0-84.0", "" + f_fM + sf_dM);
        test("-87.058000000", "" + f_fM + f_i);
        test("-87.0-55000000", "" + f_fM + f_iM);
        test("-87.01460392448", "" + f_fM + f_l);
        test("-87.0C(70)", "" + f_fM + f_o);
        test("-87.0\u04511", "" + f_fM + sf_strU);
        test("-87.08000", "" + f_fM + f_s);
        test("-87.018", "" + f_fM + s_str);
        test("-87.0-1000000", "" + f_fM + s_iM);
        test("-87.01000000", "" + f_fM + sf_I);
        test("-87.0null", "" + f_fM + f_oNtS);
        test("-87.0false", "" + f_fM + f_bl);
        test("-87.0null", "" + f_fM + sf_iAN);
        test("-87.0-2000000", "" + f_fM + sf_iM);
        test("-87.0-820130816", "" + f_fM + f_lM);
        test("-87.0null", "" + f_fM + sf_oAN);
        test("-87.025000000", "" + f_fM + s_I);
        test("null-96.0", "" + s_oAN + s_dM);
        test("nullnull", "" + s_oAN + s_oNtS);
        test("null\u045176", "" + s_oAN + f_strU);
        test("null92", "" + s_oAN + sf_strU2);
        test("null51", "" + s_oAN + sf_strU1);
        test("nullnull", "" + s_oAN + s_iAN);
        test("null-54", "" + s_oAN + f_bM);
        test("null-87.0", "" + s_oAN + f_fM);
        test("nullnull", "" + s_oAN + s_oAN);
        test("null19", "" + s_oAN + f_str);
        test("null-41", "" + s_oAN + sf_bM);
        test("nullnull", "" + s_oAN + sf_IN);
        test("nullT", "" + s_oAN + s_c);
        test("null-42.0", "" + s_oAN + sf_fM);
        test("null25", "" + s_oAN + s_b);
        test("nullnull", "" + s_oAN + f_oN);
        test("null-1410065408", "" + s_oAN + s_lM);
        test("null8.0", "" + s_oAN + s_d);
        test("null55.0", "" + s_oAN + s_f);
        test("null97000000", "" + s_oAN + s_i);
        test("null-9900", "" + s_oAN + f_sM);
        test("null935228928", "" + s_oAN + s_l);
        test("null-8400", "" + s_oAN + sf_sM);
        test("nullC(82)", "" + s_oAN + s_o);
        test("nullnull", "" + s_oAN + sf_oNtS);
        test("nulltrue", "" + s_oAN + s_bl);
        test("null3900", "" + s_oAN + s_s);
        test("nullnull", "" + s_oAN + sf_oN);
        test("null94000000", "" + s_oAN + f_I);
        test("nullnull", "" + s_oAN + f_IN);
        test("nulltrue", "" + s_oAN + sf_bl);
        test("null5500", "" + s_oAN + sf_s);
        test("null-2900", "" + s_oAN + s_sM);
        test("null-194313216", "" + s_oAN + sf_l);
        test("null12", "" + s_oAN + s_strU1);
        test("nullC(87)", "" + s_oAN + sf_o);
        test("null91", "" + s_oAN + s_strU2);
        test("null21", "" + s_oAN + f_strU1);
        test("null18", "" + s_oAN + f_strU2);
        test("nullnull", "" + s_oAN + f_iAN);
        test("nullnull", "" + s_oAN + s_oN);
        test("null\u045180", "" + s_oAN + s_strU);
        test("nullC", "" + s_oAN + sf_c);
        test("null75", "" + s_oAN + sf_str);
        test("null-43", "" + s_oAN + s_bM);
        test("null80", "" + s_oAN + sf_b);
        test("nullnull", "" + s_oAN + s_IN);
        test("null-52.0", "" + s_oAN + s_fM);
        test("null75000000", "" + s_oAN + sf_i);
        test("null44", "" + s_oAN + f_b);
        test("null-1705032704", "" + s_oAN + sf_lM);
        test("nullnull", "" + s_oAN + f_oAN);
        test("null83.0", "" + s_oAN + f_d);
        test("nullI", "" + s_oAN + f_c);
        test("null94.0", "" + s_oAN + f_f);
        test("null12.0", "" + s_oAN + sf_d);
        test("null-99.0", "" + s_oAN + f_dM);
        test("null17.0", "" + s_oAN + sf_f);
        test("null-84.0", "" + s_oAN + sf_dM);
        test("null58000000", "" + s_oAN + f_i);
        test("null-55000000", "" + s_oAN + f_iM);
        test("null1460392448", "" + s_oAN + f_l);
        test("nullC(70)", "" + s_oAN + f_o);
        test("null\u04511", "" + s_oAN + sf_strU);
        test("null8000", "" + s_oAN + f_s);
        test("null18", "" + s_oAN + s_str);
        test("null-1000000", "" + s_oAN + s_iM);
        test("null1000000", "" + s_oAN + sf_I);
        test("nullnull", "" + s_oAN + f_oNtS);
        test("nullfalse", "" + s_oAN + f_bl);
        test("nullnull", "" + s_oAN + sf_iAN);
        test("null-2000000", "" + s_oAN + sf_iM);
        test("null-820130816", "" + s_oAN + f_lM);
        test("nullnull", "" + s_oAN + sf_oAN);
        test("null25000000", "" + s_oAN + s_I);
        test("19-96.0", "" + f_str + s_dM);
        test("19null", "" + f_str + s_oNtS);
        test("19\u045176", "" + f_str + f_strU);
        test("1992", "" + f_str + sf_strU2);
        test("1951", "" + f_str + sf_strU1);
        test("19null", "" + f_str + s_iAN);
        test("19-54", "" + f_str + f_bM);
        test("19-87.0", "" + f_str + f_fM);
        test("19null", "" + f_str + s_oAN);
        test("1919", "" + f_str + f_str);
        test("19-41", "" + f_str + sf_bM);
        test("19null", "" + f_str + sf_IN);
        test("19T", "" + f_str + s_c);
        test("19-42.0", "" + f_str + sf_fM);
        test("1925", "" + f_str + s_b);
        test("19null", "" + f_str + f_oN);
        test("19-1410065408", "" + f_str + s_lM);
        test("198.0", "" + f_str + s_d);
        test("1955.0", "" + f_str + s_f);
        test("1997000000", "" + f_str + s_i);
        test("19-9900", "" + f_str + f_sM);
        test("19935228928", "" + f_str + s_l);
        test("19-8400", "" + f_str + sf_sM);
        test("19C(82)", "" + f_str + s_o);
        test("19null", "" + f_str + sf_oNtS);
        test("19true", "" + f_str + s_bl);
        test("193900", "" + f_str + s_s);
        test("19null", "" + f_str + sf_oN);
        test("1994000000", "" + f_str + f_I);
        test("19null", "" + f_str + f_IN);
        test("19true", "" + f_str + sf_bl);
        test("195500", "" + f_str + sf_s);
        test("19-2900", "" + f_str + s_sM);
        test("19-194313216", "" + f_str + sf_l);
        test("1912", "" + f_str + s_strU1);
        test("19C(87)", "" + f_str + sf_o);
        test("1991", "" + f_str + s_strU2);
        test("1921", "" + f_str + f_strU1);
        test("1918", "" + f_str + f_strU2);
        test("19null", "" + f_str + f_iAN);
        test("19null", "" + f_str + s_oN);
        test("19\u045180", "" + f_str + s_strU);
        test("19C", "" + f_str + sf_c);
        test("1975", "" + f_str + sf_str);
        test("19-43", "" + f_str + s_bM);
        test("1980", "" + f_str + sf_b);
        test("19null", "" + f_str + s_IN);
        test("19-52.0", "" + f_str + s_fM);
        test("1975000000", "" + f_str + sf_i);
        test("1944", "" + f_str + f_b);
        test("19-1705032704", "" + f_str + sf_lM);
        test("19null", "" + f_str + f_oAN);
        test("1983.0", "" + f_str + f_d);
        test("19I", "" + f_str + f_c);
        test("1994.0", "" + f_str + f_f);
        test("1912.0", "" + f_str + sf_d);
        test("19-99.0", "" + f_str + f_dM);
        test("1917.0", "" + f_str + sf_f);
        test("19-84.0", "" + f_str + sf_dM);
        test("1958000000", "" + f_str + f_i);
        test("19-55000000", "" + f_str + f_iM);
        test("191460392448", "" + f_str + f_l);
        test("19C(70)", "" + f_str + f_o);
        test("19\u04511", "" + f_str + sf_strU);
        test("198000", "" + f_str + f_s);
        test("1918", "" + f_str + s_str);
        test("19-1000000", "" + f_str + s_iM);
        test("191000000", "" + f_str + sf_I);
        test("19null", "" + f_str + f_oNtS);
        test("19false", "" + f_str + f_bl);
        test("19null", "" + f_str + sf_iAN);
        test("19-2000000", "" + f_str + sf_iM);
        test("19-820130816", "" + f_str + f_lM);
        test("19null", "" + f_str + sf_oAN);
        test("1925000000", "" + f_str + s_I);
        test("-41-96.0", "" + sf_bM + s_dM);
        test("-41null", "" + sf_bM + s_oNtS);
        test("-41\u045176", "" + sf_bM + f_strU);
        test("-4192", "" + sf_bM + sf_strU2);
        test("-4151", "" + sf_bM + sf_strU1);
        test("-41null", "" + sf_bM + s_iAN);
        test("-41-54", "" + sf_bM + f_bM);
        test("-41-87.0", "" + sf_bM + f_fM);
        test("-41null", "" + sf_bM + s_oAN);
        test("-4119", "" + sf_bM + f_str);
        test("-41-41", "" + sf_bM + sf_bM);
        test("-41null", "" + sf_bM + sf_IN);
        test("-41T", "" + sf_bM + s_c);
        test("-41-42.0", "" + sf_bM + sf_fM);
        test("-4125", "" + sf_bM + s_b);
        test("-41null", "" + sf_bM + f_oN);
        test("-41-1410065408", "" + sf_bM + s_lM);
        test("-418.0", "" + sf_bM + s_d);
        test("-4155.0", "" + sf_bM + s_f);
        test("-4197000000", "" + sf_bM + s_i);
        test("-41-9900", "" + sf_bM + f_sM);
        test("-41935228928", "" + sf_bM + s_l);
        test("-41-8400", "" + sf_bM + sf_sM);
        test("-41C(82)", "" + sf_bM + s_o);
        test("-41null", "" + sf_bM + sf_oNtS);
        test("-41true", "" + sf_bM + s_bl);
        test("-413900", "" + sf_bM + s_s);
        test("-41null", "" + sf_bM + sf_oN);
        test("-4194000000", "" + sf_bM + f_I);
        test("-41null", "" + sf_bM + f_IN);
        test("-41true", "" + sf_bM + sf_bl);
        test("-415500", "" + sf_bM + sf_s);
        test("-41-2900", "" + sf_bM + s_sM);
        test("-41-194313216", "" + sf_bM + sf_l);
        test("-4112", "" + sf_bM + s_strU1);
        test("-41C(87)", "" + sf_bM + sf_o);
        test("-4191", "" + sf_bM + s_strU2);
        test("-4121", "" + sf_bM + f_strU1);
        test("-4118", "" + sf_bM + f_strU2);
        test("-41null", "" + sf_bM + f_iAN);
        test("-41null", "" + sf_bM + s_oN);
        test("-41\u045180", "" + sf_bM + s_strU);
        test("-41C", "" + sf_bM + sf_c);
        test("-4175", "" + sf_bM + sf_str);
        test("-41-43", "" + sf_bM + s_bM);
        test("-4180", "" + sf_bM + sf_b);
        test("-41null", "" + sf_bM + s_IN);
        test("-41-52.0", "" + sf_bM + s_fM);
        test("-4175000000", "" + sf_bM + sf_i);
        test("-4144", "" + sf_bM + f_b);
        test("-41-1705032704", "" + sf_bM + sf_lM);
        test("-41null", "" + sf_bM + f_oAN);
        test("-4183.0", "" + sf_bM + f_d);
        test("-41I", "" + sf_bM + f_c);
        test("-4194.0", "" + sf_bM + f_f);
        test("-4112.0", "" + sf_bM + sf_d);
        test("-41-99.0", "" + sf_bM + f_dM);
        test("-4117.0", "" + sf_bM + sf_f);
        test("-41-84.0", "" + sf_bM + sf_dM);
        test("-4158000000", "" + sf_bM + f_i);
        test("-41-55000000", "" + sf_bM + f_iM);
        test("-411460392448", "" + sf_bM + f_l);
        test("-41C(70)", "" + sf_bM + f_o);
        test("-41\u04511", "" + sf_bM + sf_strU);
        test("-418000", "" + sf_bM + f_s);
        test("-4118", "" + sf_bM + s_str);
        test("-41-1000000", "" + sf_bM + s_iM);
        test("-411000000", "" + sf_bM + sf_I);
        test("-41null", "" + sf_bM + f_oNtS);
        test("-41false", "" + sf_bM + f_bl);
        test("-41null", "" + sf_bM + sf_iAN);
        test("-41-2000000", "" + sf_bM + sf_iM);
        test("-41-820130816", "" + sf_bM + f_lM);
        test("-41null", "" + sf_bM + sf_oAN);
        test("-4125000000", "" + sf_bM + s_I);
        test("null-96.0", "" + sf_IN + s_dM);
        test("nullnull", "" + sf_IN + s_oNtS);
        test("null\u045176", "" + sf_IN + f_strU);
        test("null92", "" + sf_IN + sf_strU2);
        test("null51", "" + sf_IN + sf_strU1);
        test("nullnull", "" + sf_IN + s_iAN);
        test("null-54", "" + sf_IN + f_bM);
        test("null-87.0", "" + sf_IN + f_fM);
        test("nullnull", "" + sf_IN + s_oAN);
        test("null19", "" + sf_IN + f_str);
        test("null-41", "" + sf_IN + sf_bM);
        test("nullnull", "" + sf_IN + sf_IN);
        test("nullT", "" + sf_IN + s_c);
        test("null-42.0", "" + sf_IN + sf_fM);
        test("null25", "" + sf_IN + s_b);
        test("nullnull", "" + sf_IN + f_oN);
        test("null-1410065408", "" + sf_IN + s_lM);
        test("null8.0", "" + sf_IN + s_d);
        test("null55.0", "" + sf_IN + s_f);
        test("null97000000", "" + sf_IN + s_i);
        test("null-9900", "" + sf_IN + f_sM);
        test("null935228928", "" + sf_IN + s_l);
        test("null-8400", "" + sf_IN + sf_sM);
        test("nullC(82)", "" + sf_IN + s_o);
        test("nullnull", "" + sf_IN + sf_oNtS);
        test("nulltrue", "" + sf_IN + s_bl);
        test("null3900", "" + sf_IN + s_s);
        test("nullnull", "" + sf_IN + sf_oN);
        test("null94000000", "" + sf_IN + f_I);
        test("nullnull", "" + sf_IN + f_IN);
        test("nulltrue", "" + sf_IN + sf_bl);
        test("null5500", "" + sf_IN + sf_s);
        test("null-2900", "" + sf_IN + s_sM);
        test("null-194313216", "" + sf_IN + sf_l);
        test("null12", "" + sf_IN + s_strU1);
        test("nullC(87)", "" + sf_IN + sf_o);
        test("null91", "" + sf_IN + s_strU2);
        test("null21", "" + sf_IN + f_strU1);
        test("null18", "" + sf_IN + f_strU2);
        test("nullnull", "" + sf_IN + f_iAN);
        test("nullnull", "" + sf_IN + s_oN);
        test("null\u045180", "" + sf_IN + s_strU);
        test("nullC", "" + sf_IN + sf_c);
        test("null75", "" + sf_IN + sf_str);
        test("null-43", "" + sf_IN + s_bM);
        test("null80", "" + sf_IN + sf_b);
        test("nullnull", "" + sf_IN + s_IN);
        test("null-52.0", "" + sf_IN + s_fM);
        test("null75000000", "" + sf_IN + sf_i);
        test("null44", "" + sf_IN + f_b);
        test("null-1705032704", "" + sf_IN + sf_lM);
        test("nullnull", "" + sf_IN + f_oAN);
        test("null83.0", "" + sf_IN + f_d);
        test("nullI", "" + sf_IN + f_c);
        test("null94.0", "" + sf_IN + f_f);
        test("null12.0", "" + sf_IN + sf_d);
        test("null-99.0", "" + sf_IN + f_dM);
        test("null17.0", "" + sf_IN + sf_f);
        test("null-84.0", "" + sf_IN + sf_dM);
        test("null58000000", "" + sf_IN + f_i);
        test("null-55000000", "" + sf_IN + f_iM);
        test("null1460392448", "" + sf_IN + f_l);
        test("nullC(70)", "" + sf_IN + f_o);
        test("null\u04511", "" + sf_IN + sf_strU);
        test("null8000", "" + sf_IN + f_s);
        test("null18", "" + sf_IN + s_str);
        test("null-1000000", "" + sf_IN + s_iM);
        test("null1000000", "" + sf_IN + sf_I);
        test("nullnull", "" + sf_IN + f_oNtS);
        test("nullfalse", "" + sf_IN + f_bl);
        test("nullnull", "" + sf_IN + sf_iAN);
        test("null-2000000", "" + sf_IN + sf_iM);
        test("null-820130816", "" + sf_IN + f_lM);
        test("nullnull", "" + sf_IN + sf_oAN);
        test("null25000000", "" + sf_IN + s_I);
        test("T-96.0", "" + s_c + s_dM);
        test("Tnull", "" + s_c + s_oNtS);
        test("T\u045176", "" + s_c + f_strU);
        test("T92", "" + s_c + sf_strU2);
        test("T51", "" + s_c + sf_strU1);
        test("Tnull", "" + s_c + s_iAN);
        test("T-54", "" + s_c + f_bM);
        test("T-87.0", "" + s_c + f_fM);
        test("Tnull", "" + s_c + s_oAN);
        test("T19", "" + s_c + f_str);
        test("T-41", "" + s_c + sf_bM);
        test("Tnull", "" + s_c + sf_IN);
        test("TT", "" + s_c + s_c);
        test("T-42.0", "" + s_c + sf_fM);
        test("T25", "" + s_c + s_b);
        test("Tnull", "" + s_c + f_oN);
        test("T-1410065408", "" + s_c + s_lM);
        test("T8.0", "" + s_c + s_d);
        test("T55.0", "" + s_c + s_f);
        test("T97000000", "" + s_c + s_i);
        test("T-9900", "" + s_c + f_sM);
        test("T935228928", "" + s_c + s_l);
        test("T-8400", "" + s_c + sf_sM);
        test("TC(82)", "" + s_c + s_o);
        test("Tnull", "" + s_c + sf_oNtS);
    }

    public void run1() {
        test("Ttrue", "" + s_c + s_bl);
        test("T3900", "" + s_c + s_s);
        test("Tnull", "" + s_c + sf_oN);
        test("T94000000", "" + s_c + f_I);
        test("Tnull", "" + s_c + f_IN);
        test("Ttrue", "" + s_c + sf_bl);
        test("T5500", "" + s_c + sf_s);
        test("T-2900", "" + s_c + s_sM);
        test("T-194313216", "" + s_c + sf_l);
        test("T12", "" + s_c + s_strU1);
        test("TC(87)", "" + s_c + sf_o);
        test("T91", "" + s_c + s_strU2);
        test("T21", "" + s_c + f_strU1);
        test("T18", "" + s_c + f_strU2);
        test("Tnull", "" + s_c + f_iAN);
        test("Tnull", "" + s_c + s_oN);
        test("T\u045180", "" + s_c + s_strU);
        test("TC", "" + s_c + sf_c);
        test("T75", "" + s_c + sf_str);
        test("T-43", "" + s_c + s_bM);
        test("T80", "" + s_c + sf_b);
        test("Tnull", "" + s_c + s_IN);
        test("T-52.0", "" + s_c + s_fM);
        test("T75000000", "" + s_c + sf_i);
        test("T44", "" + s_c + f_b);
        test("T-1705032704", "" + s_c + sf_lM);
        test("Tnull", "" + s_c + f_oAN);
        test("T83.0", "" + s_c + f_d);
        test("TI", "" + s_c + f_c);
        test("T94.0", "" + s_c + f_f);
        test("T12.0", "" + s_c + sf_d);
        test("T-99.0", "" + s_c + f_dM);
        test("T17.0", "" + s_c + sf_f);
        test("T-84.0", "" + s_c + sf_dM);
        test("T58000000", "" + s_c + f_i);
        test("T-55000000", "" + s_c + f_iM);
        test("T1460392448", "" + s_c + f_l);
        test("TC(70)", "" + s_c + f_o);
        test("T\u04511", "" + s_c + sf_strU);
        test("T8000", "" + s_c + f_s);
        test("T18", "" + s_c + s_str);
        test("T-1000000", "" + s_c + s_iM);
        test("T1000000", "" + s_c + sf_I);
        test("Tnull", "" + s_c + f_oNtS);
        test("Tfalse", "" + s_c + f_bl);
        test("Tnull", "" + s_c + sf_iAN);
        test("T-2000000", "" + s_c + sf_iM);
        test("T-820130816", "" + s_c + f_lM);
        test("Tnull", "" + s_c + sf_oAN);
        test("T25000000", "" + s_c + s_I);
        test("-42.0-96.0", "" + sf_fM + s_dM);
        test("-42.0null", "" + sf_fM + s_oNtS);
        test("-42.0\u045176", "" + sf_fM + f_strU);
        test("-42.092", "" + sf_fM + sf_strU2);
        test("-42.051", "" + sf_fM + sf_strU1);
        test("-42.0null", "" + sf_fM + s_iAN);
        test("-42.0-54", "" + sf_fM + f_bM);
        test("-42.0-87.0", "" + sf_fM + f_fM);
        test("-42.0null", "" + sf_fM + s_oAN);
        test("-42.019", "" + sf_fM + f_str);
        test("-42.0-41", "" + sf_fM + sf_bM);
        test("-42.0null", "" + sf_fM + sf_IN);
        test("-42.0T", "" + sf_fM + s_c);
        test("-42.0-42.0", "" + sf_fM + sf_fM);
        test("-42.025", "" + sf_fM + s_b);
        test("-42.0null", "" + sf_fM + f_oN);
        test("-42.0-1410065408", "" + sf_fM + s_lM);
        test("-42.08.0", "" + sf_fM + s_d);
        test("-42.055.0", "" + sf_fM + s_f);
        test("-42.097000000", "" + sf_fM + s_i);
        test("-42.0-9900", "" + sf_fM + f_sM);
        test("-42.0935228928", "" + sf_fM + s_l);
        test("-42.0-8400", "" + sf_fM + sf_sM);
        test("-42.0C(82)", "" + sf_fM + s_o);
        test("-42.0null", "" + sf_fM + sf_oNtS);
        test("-42.0true", "" + sf_fM + s_bl);
        test("-42.03900", "" + sf_fM + s_s);
        test("-42.0null", "" + sf_fM + sf_oN);
        test("-42.094000000", "" + sf_fM + f_I);
        test("-42.0null", "" + sf_fM + f_IN);
        test("-42.0true", "" + sf_fM + sf_bl);
        test("-42.05500", "" + sf_fM + sf_s);
        test("-42.0-2900", "" + sf_fM + s_sM);
        test("-42.0-194313216", "" + sf_fM + sf_l);
        test("-42.012", "" + sf_fM + s_strU1);
        test("-42.0C(87)", "" + sf_fM + sf_o);
        test("-42.091", "" + sf_fM + s_strU2);
        test("-42.021", "" + sf_fM + f_strU1);
        test("-42.018", "" + sf_fM + f_strU2);
        test("-42.0null", "" + sf_fM + f_iAN);
        test("-42.0null", "" + sf_fM + s_oN);
        test("-42.0\u045180", "" + sf_fM + s_strU);
        test("-42.0C", "" + sf_fM + sf_c);
        test("-42.075", "" + sf_fM + sf_str);
        test("-42.0-43", "" + sf_fM + s_bM);
        test("-42.080", "" + sf_fM + sf_b);
        test("-42.0null", "" + sf_fM + s_IN);
        test("-42.0-52.0", "" + sf_fM + s_fM);
        test("-42.075000000", "" + sf_fM + sf_i);
        test("-42.044", "" + sf_fM + f_b);
        test("-42.0-1705032704", "" + sf_fM + sf_lM);
        test("-42.0null", "" + sf_fM + f_oAN);
        test("-42.083.0", "" + sf_fM + f_d);
        test("-42.0I", "" + sf_fM + f_c);
        test("-42.094.0", "" + sf_fM + f_f);
        test("-42.012.0", "" + sf_fM + sf_d);
        test("-42.0-99.0", "" + sf_fM + f_dM);
        test("-42.017.0", "" + sf_fM + sf_f);
        test("-42.0-84.0", "" + sf_fM + sf_dM);
        test("-42.058000000", "" + sf_fM + f_i);
        test("-42.0-55000000", "" + sf_fM + f_iM);
        test("-42.01460392448", "" + sf_fM + f_l);
        test("-42.0C(70)", "" + sf_fM + f_o);
        test("-42.0\u04511", "" + sf_fM + sf_strU);
        test("-42.08000", "" + sf_fM + f_s);
        test("-42.018", "" + sf_fM + s_str);
        test("-42.0-1000000", "" + sf_fM + s_iM);
        test("-42.01000000", "" + sf_fM + sf_I);
        test("-42.0null", "" + sf_fM + f_oNtS);
        test("-42.0false", "" + sf_fM + f_bl);
        test("-42.0null", "" + sf_fM + sf_iAN);
        test("-42.0-2000000", "" + sf_fM + sf_iM);
        test("-42.0-820130816", "" + sf_fM + f_lM);
        test("-42.0null", "" + sf_fM + sf_oAN);
        test("-42.025000000", "" + sf_fM + s_I);
        test("25-96.0", "" + s_b + s_dM);
        test("25null", "" + s_b + s_oNtS);
        test("25\u045176", "" + s_b + f_strU);
        test("2592", "" + s_b + sf_strU2);
        test("2551", "" + s_b + sf_strU1);
        test("25null", "" + s_b + s_iAN);
        test("25-54", "" + s_b + f_bM);
        test("25-87.0", "" + s_b + f_fM);
        test("25null", "" + s_b + s_oAN);
        test("2519", "" + s_b + f_str);
        test("25-41", "" + s_b + sf_bM);
        test("25null", "" + s_b + sf_IN);
        test("25T", "" + s_b + s_c);
        test("25-42.0", "" + s_b + sf_fM);
        test("2525", "" + s_b + s_b);
        test("25null", "" + s_b + f_oN);
        test("25-1410065408", "" + s_b + s_lM);
        test("258.0", "" + s_b + s_d);
        test("2555.0", "" + s_b + s_f);
        test("2597000000", "" + s_b + s_i);
        test("25-9900", "" + s_b + f_sM);
        test("25935228928", "" + s_b + s_l);
        test("25-8400", "" + s_b + sf_sM);
        test("25C(82)", "" + s_b + s_o);
        test("25null", "" + s_b + sf_oNtS);
        test("25true", "" + s_b + s_bl);
        test("253900", "" + s_b + s_s);
        test("25null", "" + s_b + sf_oN);
        test("2594000000", "" + s_b + f_I);
        test("25null", "" + s_b + f_IN);
        test("25true", "" + s_b + sf_bl);
        test("255500", "" + s_b + sf_s);
        test("25-2900", "" + s_b + s_sM);
        test("25-194313216", "" + s_b + sf_l);
        test("2512", "" + s_b + s_strU1);
        test("25C(87)", "" + s_b + sf_o);
        test("2591", "" + s_b + s_strU2);
        test("2521", "" + s_b + f_strU1);
        test("2518", "" + s_b + f_strU2);
        test("25null", "" + s_b + f_iAN);
        test("25null", "" + s_b + s_oN);
        test("25\u045180", "" + s_b + s_strU);
        test("25C", "" + s_b + sf_c);
        test("2575", "" + s_b + sf_str);
        test("25-43", "" + s_b + s_bM);
        test("2580", "" + s_b + sf_b);
        test("25null", "" + s_b + s_IN);
        test("25-52.0", "" + s_b + s_fM);
        test("2575000000", "" + s_b + sf_i);
        test("2544", "" + s_b + f_b);
        test("25-1705032704", "" + s_b + sf_lM);
        test("25null", "" + s_b + f_oAN);
        test("2583.0", "" + s_b + f_d);
        test("25I", "" + s_b + f_c);
        test("2594.0", "" + s_b + f_f);
        test("2512.0", "" + s_b + sf_d);
        test("25-99.0", "" + s_b + f_dM);
        test("2517.0", "" + s_b + sf_f);
        test("25-84.0", "" + s_b + sf_dM);
        test("2558000000", "" + s_b + f_i);
        test("25-55000000", "" + s_b + f_iM);
        test("251460392448", "" + s_b + f_l);
        test("25C(70)", "" + s_b + f_o);
        test("25\u04511", "" + s_b + sf_strU);
        test("258000", "" + s_b + f_s);
        test("2518", "" + s_b + s_str);
        test("25-1000000", "" + s_b + s_iM);
        test("251000000", "" + s_b + sf_I);
        test("25null", "" + s_b + f_oNtS);
        test("25false", "" + s_b + f_bl);
        test("25null", "" + s_b + sf_iAN);
        test("25-2000000", "" + s_b + sf_iM);
        test("25-820130816", "" + s_b + f_lM);
        test("25null", "" + s_b + sf_oAN);
        test("2525000000", "" + s_b + s_I);
        test("null-96.0", "" + f_oN + s_dM);
        test("nullnull", "" + f_oN + s_oNtS);
        test("null\u045176", "" + f_oN + f_strU);
        test("null92", "" + f_oN + sf_strU2);
        test("null51", "" + f_oN + sf_strU1);
        test("nullnull", "" + f_oN + s_iAN);
        test("null-54", "" + f_oN + f_bM);
        test("null-87.0", "" + f_oN + f_fM);
        test("nullnull", "" + f_oN + s_oAN);
        test("null19", "" + f_oN + f_str);
        test("null-41", "" + f_oN + sf_bM);
        test("nullnull", "" + f_oN + sf_IN);
        test("nullT", "" + f_oN + s_c);
        test("null-42.0", "" + f_oN + sf_fM);
        test("null25", "" + f_oN + s_b);
        test("nullnull", "" + f_oN + f_oN);
        test("null-1410065408", "" + f_oN + s_lM);
        test("null8.0", "" + f_oN + s_d);
        test("null55.0", "" + f_oN + s_f);
        test("null97000000", "" + f_oN + s_i);
        test("null-9900", "" + f_oN + f_sM);
        test("null935228928", "" + f_oN + s_l);
        test("null-8400", "" + f_oN + sf_sM);
        test("nullC(82)", "" + f_oN + s_o);
        test("nullnull", "" + f_oN + sf_oNtS);
        test("nulltrue", "" + f_oN + s_bl);
        test("null3900", "" + f_oN + s_s);
        test("nullnull", "" + f_oN + sf_oN);
        test("null94000000", "" + f_oN + f_I);
        test("nullnull", "" + f_oN + f_IN);
        test("nulltrue", "" + f_oN + sf_bl);
        test("null5500", "" + f_oN + sf_s);
        test("null-2900", "" + f_oN + s_sM);
        test("null-194313216", "" + f_oN + sf_l);
        test("null12", "" + f_oN + s_strU1);
        test("nullC(87)", "" + f_oN + sf_o);
        test("null91", "" + f_oN + s_strU2);
        test("null21", "" + f_oN + f_strU1);
        test("null18", "" + f_oN + f_strU2);
        test("nullnull", "" + f_oN + f_iAN);
        test("nullnull", "" + f_oN + s_oN);
        test("null\u045180", "" + f_oN + s_strU);
        test("nullC", "" + f_oN + sf_c);
        test("null75", "" + f_oN + sf_str);
        test("null-43", "" + f_oN + s_bM);
        test("null80", "" + f_oN + sf_b);
        test("nullnull", "" + f_oN + s_IN);
        test("null-52.0", "" + f_oN + s_fM);
        test("null75000000", "" + f_oN + sf_i);
        test("null44", "" + f_oN + f_b);
        test("null-1705032704", "" + f_oN + sf_lM);
        test("nullnull", "" + f_oN + f_oAN);
        test("null83.0", "" + f_oN + f_d);
        test("nullI", "" + f_oN + f_c);
        test("null94.0", "" + f_oN + f_f);
        test("null12.0", "" + f_oN + sf_d);
        test("null-99.0", "" + f_oN + f_dM);
        test("null17.0", "" + f_oN + sf_f);
        test("null-84.0", "" + f_oN + sf_dM);
        test("null58000000", "" + f_oN + f_i);
        test("null-55000000", "" + f_oN + f_iM);
        test("null1460392448", "" + f_oN + f_l);
        test("nullC(70)", "" + f_oN + f_o);
        test("null\u04511", "" + f_oN + sf_strU);
        test("null8000", "" + f_oN + f_s);
        test("null18", "" + f_oN + s_str);
        test("null-1000000", "" + f_oN + s_iM);
        test("null1000000", "" + f_oN + sf_I);
        test("nullnull", "" + f_oN + f_oNtS);
        test("nullfalse", "" + f_oN + f_bl);
        test("nullnull", "" + f_oN + sf_iAN);
        test("null-2000000", "" + f_oN + sf_iM);
        test("null-820130816", "" + f_oN + f_lM);
        test("nullnull", "" + f_oN + sf_oAN);
        test("null25000000", "" + f_oN + s_I);
        test("-1410065408-96.0", "" + s_lM + s_dM);
        test("-1410065408null", "" + s_lM + s_oNtS);
        test("-1410065408\u045176", "" + s_lM + f_strU);
        test("-141006540892", "" + s_lM + sf_strU2);
        test("-141006540851", "" + s_lM + sf_strU1);
        test("-1410065408null", "" + s_lM + s_iAN);
        test("-1410065408-54", "" + s_lM + f_bM);
        test("-1410065408-87.0", "" + s_lM + f_fM);
        test("-1410065408null", "" + s_lM + s_oAN);
        test("-141006540819", "" + s_lM + f_str);
        test("-1410065408-41", "" + s_lM + sf_bM);
        test("-1410065408null", "" + s_lM + sf_IN);
        test("-1410065408T", "" + s_lM + s_c);
        test("-1410065408-42.0", "" + s_lM + sf_fM);
        test("-141006540825", "" + s_lM + s_b);
        test("-1410065408null", "" + s_lM + f_oN);
        test("-1410065408-1410065408", "" + s_lM + s_lM);
        test("-14100654088.0", "" + s_lM + s_d);
        test("-141006540855.0", "" + s_lM + s_f);
        test("-141006540897000000", "" + s_lM + s_i);
        test("-1410065408-9900", "" + s_lM + f_sM);
        test("-1410065408935228928", "" + s_lM + s_l);
        test("-1410065408-8400", "" + s_lM + sf_sM);
        test("-1410065408C(82)", "" + s_lM + s_o);
        test("-1410065408null", "" + s_lM + sf_oNtS);
        test("-1410065408true", "" + s_lM + s_bl);
        test("-14100654083900", "" + s_lM + s_s);
        test("-1410065408null", "" + s_lM + sf_oN);
        test("-141006540894000000", "" + s_lM + f_I);
        test("-1410065408null", "" + s_lM + f_IN);
        test("-1410065408true", "" + s_lM + sf_bl);
        test("-14100654085500", "" + s_lM + sf_s);
        test("-1410065408-2900", "" + s_lM + s_sM);
        test("-1410065408-194313216", "" + s_lM + sf_l);
        test("-141006540812", "" + s_lM + s_strU1);
        test("-1410065408C(87)", "" + s_lM + sf_o);
        test("-141006540891", "" + s_lM + s_strU2);
        test("-141006540821", "" + s_lM + f_strU1);
        test("-141006540818", "" + s_lM + f_strU2);
        test("-1410065408null", "" + s_lM + f_iAN);
        test("-1410065408null", "" + s_lM + s_oN);
        test("-1410065408\u045180", "" + s_lM + s_strU);
        test("-1410065408C", "" + s_lM + sf_c);
        test("-141006540875", "" + s_lM + sf_str);
        test("-1410065408-43", "" + s_lM + s_bM);
        test("-141006540880", "" + s_lM + sf_b);
        test("-1410065408null", "" + s_lM + s_IN);
        test("-1410065408-52.0", "" + s_lM + s_fM);
        test("-141006540875000000", "" + s_lM + sf_i);
        test("-141006540844", "" + s_lM + f_b);
        test("-1410065408-1705032704", "" + s_lM + sf_lM);
        test("-1410065408null", "" + s_lM + f_oAN);
        test("-141006540883.0", "" + s_lM + f_d);
        test("-1410065408I", "" + s_lM + f_c);
        test("-141006540894.0", "" + s_lM + f_f);
        test("-141006540812.0", "" + s_lM + sf_d);
        test("-1410065408-99.0", "" + s_lM + f_dM);
        test("-141006540817.0", "" + s_lM + sf_f);
        test("-1410065408-84.0", "" + s_lM + sf_dM);
        test("-141006540858000000", "" + s_lM + f_i);
        test("-1410065408-55000000", "" + s_lM + f_iM);
        test("-14100654081460392448", "" + s_lM + f_l);
        test("-1410065408C(70)", "" + s_lM + f_o);
        test("-1410065408\u04511", "" + s_lM + sf_strU);
        test("-14100654088000", "" + s_lM + f_s);
        test("-141006540818", "" + s_lM + s_str);
        test("-1410065408-1000000", "" + s_lM + s_iM);
        test("-14100654081000000", "" + s_lM + sf_I);
        test("-1410065408null", "" + s_lM + f_oNtS);
        test("-1410065408false", "" + s_lM + f_bl);
        test("-1410065408null", "" + s_lM + sf_iAN);
        test("-1410065408-2000000", "" + s_lM + sf_iM);
        test("-1410065408-820130816", "" + s_lM + f_lM);
        test("-1410065408null", "" + s_lM + sf_oAN);
        test("-141006540825000000", "" + s_lM + s_I);
        test("8.0-96.0", "" + s_d + s_dM);
        test("8.0null", "" + s_d + s_oNtS);
        test("8.0\u045176", "" + s_d + f_strU);
        test("8.092", "" + s_d + sf_strU2);
        test("8.051", "" + s_d + sf_strU1);
        test("8.0null", "" + s_d + s_iAN);
        test("8.0-54", "" + s_d + f_bM);
        test("8.0-87.0", "" + s_d + f_fM);
        test("8.0null", "" + s_d + s_oAN);
        test("8.019", "" + s_d + f_str);
        test("8.0-41", "" + s_d + sf_bM);
        test("8.0null", "" + s_d + sf_IN);
        test("8.0T", "" + s_d + s_c);
        test("8.0-42.0", "" + s_d + sf_fM);
        test("8.025", "" + s_d + s_b);
        test("8.0null", "" + s_d + f_oN);
        test("8.0-1410065408", "" + s_d + s_lM);
        test("8.08.0", "" + s_d + s_d);
        test("8.055.0", "" + s_d + s_f);
        test("8.097000000", "" + s_d + s_i);
        test("8.0-9900", "" + s_d + f_sM);
        test("8.0935228928", "" + s_d + s_l);
        test("8.0-8400", "" + s_d + sf_sM);
        test("8.0C(82)", "" + s_d + s_o);
        test("8.0null", "" + s_d + sf_oNtS);
        test("8.0true", "" + s_d + s_bl);
        test("8.03900", "" + s_d + s_s);
        test("8.0null", "" + s_d + sf_oN);
        test("8.094000000", "" + s_d + f_I);
        test("8.0null", "" + s_d + f_IN);
        test("8.0true", "" + s_d + sf_bl);
        test("8.05500", "" + s_d + sf_s);
        test("8.0-2900", "" + s_d + s_sM);
        test("8.0-194313216", "" + s_d + sf_l);
        test("8.012", "" + s_d + s_strU1);
        test("8.0C(87)", "" + s_d + sf_o);
        test("8.091", "" + s_d + s_strU2);
        test("8.021", "" + s_d + f_strU1);
        test("8.018", "" + s_d + f_strU2);
        test("8.0null", "" + s_d + f_iAN);
        test("8.0null", "" + s_d + s_oN);
        test("8.0\u045180", "" + s_d + s_strU);
        test("8.0C", "" + s_d + sf_c);
        test("8.075", "" + s_d + sf_str);
        test("8.0-43", "" + s_d + s_bM);
        test("8.080", "" + s_d + sf_b);
        test("8.0null", "" + s_d + s_IN);
        test("8.0-52.0", "" + s_d + s_fM);
        test("8.075000000", "" + s_d + sf_i);
        test("8.044", "" + s_d + f_b);
        test("8.0-1705032704", "" + s_d + sf_lM);
        test("8.0null", "" + s_d + f_oAN);
        test("8.083.0", "" + s_d + f_d);
        test("8.0I", "" + s_d + f_c);
        test("8.094.0", "" + s_d + f_f);
        test("8.012.0", "" + s_d + sf_d);
        test("8.0-99.0", "" + s_d + f_dM);
        test("8.017.0", "" + s_d + sf_f);
        test("8.0-84.0", "" + s_d + sf_dM);
        test("8.058000000", "" + s_d + f_i);
        test("8.0-55000000", "" + s_d + f_iM);
        test("8.01460392448", "" + s_d + f_l);
        test("8.0C(70)", "" + s_d + f_o);
        test("8.0\u04511", "" + s_d + sf_strU);
        test("8.08000", "" + s_d + f_s);
        test("8.018", "" + s_d + s_str);
        test("8.0-1000000", "" + s_d + s_iM);
        test("8.01000000", "" + s_d + sf_I);
        test("8.0null", "" + s_d + f_oNtS);
        test("8.0false", "" + s_d + f_bl);
        test("8.0null", "" + s_d + sf_iAN);
        test("8.0-2000000", "" + s_d + sf_iM);
        test("8.0-820130816", "" + s_d + f_lM);
        test("8.0null", "" + s_d + sf_oAN);
        test("8.025000000", "" + s_d + s_I);
        test("55.0-96.0", "" + s_f + s_dM);
        test("55.0null", "" + s_f + s_oNtS);
        test("55.0\u045176", "" + s_f + f_strU);
        test("55.092", "" + s_f + sf_strU2);
        test("55.051", "" + s_f + sf_strU1);
        test("55.0null", "" + s_f + s_iAN);
        test("55.0-54", "" + s_f + f_bM);
        test("55.0-87.0", "" + s_f + f_fM);
        test("55.0null", "" + s_f + s_oAN);
        test("55.019", "" + s_f + f_str);
        test("55.0-41", "" + s_f + sf_bM);
        test("55.0null", "" + s_f + sf_IN);
        test("55.0T", "" + s_f + s_c);
        test("55.0-42.0", "" + s_f + sf_fM);
        test("55.025", "" + s_f + s_b);
        test("55.0null", "" + s_f + f_oN);
        test("55.0-1410065408", "" + s_f + s_lM);
        test("55.08.0", "" + s_f + s_d);
        test("55.055.0", "" + s_f + s_f);
        test("55.097000000", "" + s_f + s_i);
        test("55.0-9900", "" + s_f + f_sM);
        test("55.0935228928", "" + s_f + s_l);
        test("55.0-8400", "" + s_f + sf_sM);
        test("55.0C(82)", "" + s_f + s_o);
        test("55.0null", "" + s_f + sf_oNtS);
        test("55.0true", "" + s_f + s_bl);
        test("55.03900", "" + s_f + s_s);
        test("55.0null", "" + s_f + sf_oN);
        test("55.094000000", "" + s_f + f_I);
        test("55.0null", "" + s_f + f_IN);
        test("55.0true", "" + s_f + sf_bl);
        test("55.05500", "" + s_f + sf_s);
        test("55.0-2900", "" + s_f + s_sM);
        test("55.0-194313216", "" + s_f + sf_l);
        test("55.012", "" + s_f + s_strU1);
        test("55.0C(87)", "" + s_f + sf_o);
        test("55.091", "" + s_f + s_strU2);
        test("55.021", "" + s_f + f_strU1);
        test("55.018", "" + s_f + f_strU2);
        test("55.0null", "" + s_f + f_iAN);
        test("55.0null", "" + s_f + s_oN);
        test("55.0\u045180", "" + s_f + s_strU);
        test("55.0C", "" + s_f + sf_c);
        test("55.075", "" + s_f + sf_str);
        test("55.0-43", "" + s_f + s_bM);
        test("55.080", "" + s_f + sf_b);
        test("55.0null", "" + s_f + s_IN);
        test("55.0-52.0", "" + s_f + s_fM);
        test("55.075000000", "" + s_f + sf_i);
        test("55.044", "" + s_f + f_b);
        test("55.0-1705032704", "" + s_f + sf_lM);
        test("55.0null", "" + s_f + f_oAN);
        test("55.083.0", "" + s_f + f_d);
        test("55.0I", "" + s_f + f_c);
        test("55.094.0", "" + s_f + f_f);
        test("55.012.0", "" + s_f + sf_d);
        test("55.0-99.0", "" + s_f + f_dM);
        test("55.017.0", "" + s_f + sf_f);
        test("55.0-84.0", "" + s_f + sf_dM);
        test("55.058000000", "" + s_f + f_i);
        test("55.0-55000000", "" + s_f + f_iM);
        test("55.01460392448", "" + s_f + f_l);
        test("55.0C(70)", "" + s_f + f_o);
        test("55.0\u04511", "" + s_f + sf_strU);
        test("55.08000", "" + s_f + f_s);
        test("55.018", "" + s_f + s_str);
        test("55.0-1000000", "" + s_f + s_iM);
        test("55.01000000", "" + s_f + sf_I);
        test("55.0null", "" + s_f + f_oNtS);
        test("55.0false", "" + s_f + f_bl);
        test("55.0null", "" + s_f + sf_iAN);
        test("55.0-2000000", "" + s_f + sf_iM);
        test("55.0-820130816", "" + s_f + f_lM);
        test("55.0null", "" + s_f + sf_oAN);
        test("55.025000000", "" + s_f + s_I);
        test("97000000-96.0", "" + s_i + s_dM);
        test("97000000null", "" + s_i + s_oNtS);
        test("97000000\u045176", "" + s_i + f_strU);
        test("9700000092", "" + s_i + sf_strU2);
        test("9700000051", "" + s_i + sf_strU1);
        test("97000000null", "" + s_i + s_iAN);
        test("97000000-54", "" + s_i + f_bM);
        test("97000000-87.0", "" + s_i + f_fM);
        test("97000000null", "" + s_i + s_oAN);
        test("9700000019", "" + s_i + f_str);
        test("97000000-41", "" + s_i + sf_bM);
        test("97000000null", "" + s_i + sf_IN);
        test("97000000T", "" + s_i + s_c);
        test("97000000-42.0", "" + s_i + sf_fM);
        test("9700000025", "" + s_i + s_b);
        test("97000000null", "" + s_i + f_oN);
        test("97000000-1410065408", "" + s_i + s_lM);
        test("970000008.0", "" + s_i + s_d);
        test("9700000055.0", "" + s_i + s_f);
        test("9700000097000000", "" + s_i + s_i);
        test("97000000-9900", "" + s_i + f_sM);
        test("97000000935228928", "" + s_i + s_l);
        test("97000000-8400", "" + s_i + sf_sM);
        test("97000000C(82)", "" + s_i + s_o);
        test("97000000null", "" + s_i + sf_oNtS);
        test("97000000true", "" + s_i + s_bl);
        test("970000003900", "" + s_i + s_s);
        test("97000000null", "" + s_i + sf_oN);
        test("9700000094000000", "" + s_i + f_I);
        test("97000000null", "" + s_i + f_IN);
        test("97000000true", "" + s_i + sf_bl);
        test("970000005500", "" + s_i + sf_s);
        test("97000000-2900", "" + s_i + s_sM);
        test("97000000-194313216", "" + s_i + sf_l);
        test("9700000012", "" + s_i + s_strU1);
        test("97000000C(87)", "" + s_i + sf_o);
        test("9700000091", "" + s_i + s_strU2);
        test("9700000021", "" + s_i + f_strU1);
        test("9700000018", "" + s_i + f_strU2);
        test("97000000null", "" + s_i + f_iAN);
        test("97000000null", "" + s_i + s_oN);
        test("97000000\u045180", "" + s_i + s_strU);
        test("97000000C", "" + s_i + sf_c);
        test("9700000075", "" + s_i + sf_str);
        test("97000000-43", "" + s_i + s_bM);
        test("9700000080", "" + s_i + sf_b);
        test("97000000null", "" + s_i + s_IN);
        test("97000000-52.0", "" + s_i + s_fM);
        test("9700000075000000", "" + s_i + sf_i);
        test("9700000044", "" + s_i + f_b);
        test("97000000-1705032704", "" + s_i + sf_lM);
        test("97000000null", "" + s_i + f_oAN);
        test("9700000083.0", "" + s_i + f_d);
        test("97000000I", "" + s_i + f_c);
        test("9700000094.0", "" + s_i + f_f);
        test("9700000012.0", "" + s_i + sf_d);
        test("97000000-99.0", "" + s_i + f_dM);
        test("9700000017.0", "" + s_i + sf_f);
        test("97000000-84.0", "" + s_i + sf_dM);
        test("9700000058000000", "" + s_i + f_i);
        test("97000000-55000000", "" + s_i + f_iM);
        test("970000001460392448", "" + s_i + f_l);
        test("97000000C(70)", "" + s_i + f_o);
        test("97000000\u04511", "" + s_i + sf_strU);
        test("970000008000", "" + s_i + f_s);
        test("9700000018", "" + s_i + s_str);
        test("97000000-1000000", "" + s_i + s_iM);
        test("970000001000000", "" + s_i + sf_I);
        test("97000000null", "" + s_i + f_oNtS);
        test("97000000false", "" + s_i + f_bl);
        test("97000000null", "" + s_i + sf_iAN);
        test("97000000-2000000", "" + s_i + sf_iM);
        test("97000000-820130816", "" + s_i + f_lM);
        test("97000000null", "" + s_i + sf_oAN);
        test("9700000025000000", "" + s_i + s_I);
        test("-9900-96.0", "" + f_sM + s_dM);
        test("-9900null", "" + f_sM + s_oNtS);
        test("-9900\u045176", "" + f_sM + f_strU);
        test("-990092", "" + f_sM + sf_strU2);
        test("-990051", "" + f_sM + sf_strU1);
        test("-9900null", "" + f_sM + s_iAN);
        test("-9900-54", "" + f_sM + f_bM);
        test("-9900-87.0", "" + f_sM + f_fM);
        test("-9900null", "" + f_sM + s_oAN);
        test("-990019", "" + f_sM + f_str);
        test("-9900-41", "" + f_sM + sf_bM);
        test("-9900null", "" + f_sM + sf_IN);
        test("-9900T", "" + f_sM + s_c);
        test("-9900-42.0", "" + f_sM + sf_fM);
        test("-990025", "" + f_sM + s_b);
        test("-9900null", "" + f_sM + f_oN);
        test("-9900-1410065408", "" + f_sM + s_lM);
        test("-99008.0", "" + f_sM + s_d);
        test("-990055.0", "" + f_sM + s_f);
        test("-990097000000", "" + f_sM + s_i);
        test("-9900-9900", "" + f_sM + f_sM);
        test("-9900935228928", "" + f_sM + s_l);
        test("-9900-8400", "" + f_sM + sf_sM);
        test("-9900C(82)", "" + f_sM + s_o);
        test("-9900null", "" + f_sM + sf_oNtS);
        test("-9900true", "" + f_sM + s_bl);
        test("-99003900", "" + f_sM + s_s);
        test("-9900null", "" + f_sM + sf_oN);
        test("-990094000000", "" + f_sM + f_I);
        test("-9900null", "" + f_sM + f_IN);
        test("-9900true", "" + f_sM + sf_bl);
        test("-99005500", "" + f_sM + sf_s);
        test("-9900-2900", "" + f_sM + s_sM);
        test("-9900-194313216", "" + f_sM + sf_l);
        test("-990012", "" + f_sM + s_strU1);
        test("-9900C(87)", "" + f_sM + sf_o);
        test("-990091", "" + f_sM + s_strU2);
        test("-990021", "" + f_sM + f_strU1);
        test("-990018", "" + f_sM + f_strU2);
        test("-9900null", "" + f_sM + f_iAN);
        test("-9900null", "" + f_sM + s_oN);
        test("-9900\u045180", "" + f_sM + s_strU);
        test("-9900C", "" + f_sM + sf_c);
        test("-990075", "" + f_sM + sf_str);
        test("-9900-43", "" + f_sM + s_bM);
        test("-990080", "" + f_sM + sf_b);
        test("-9900null", "" + f_sM + s_IN);
        test("-9900-52.0", "" + f_sM + s_fM);
        test("-990075000000", "" + f_sM + sf_i);
        test("-990044", "" + f_sM + f_b);
        test("-9900-1705032704", "" + f_sM + sf_lM);
        test("-9900null", "" + f_sM + f_oAN);
        test("-990083.0", "" + f_sM + f_d);
        test("-9900I", "" + f_sM + f_c);
        test("-990094.0", "" + f_sM + f_f);
        test("-990012.0", "" + f_sM + sf_d);
        test("-9900-99.0", "" + f_sM + f_dM);
        test("-990017.0", "" + f_sM + sf_f);
        test("-9900-84.0", "" + f_sM + sf_dM);
        test("-990058000000", "" + f_sM + f_i);
        test("-9900-55000000", "" + f_sM + f_iM);
        test("-99001460392448", "" + f_sM + f_l);
        test("-9900C(70)", "" + f_sM + f_o);
        test("-9900\u04511", "" + f_sM + sf_strU);
        test("-99008000", "" + f_sM + f_s);
        test("-990018", "" + f_sM + s_str);
        test("-9900-1000000", "" + f_sM + s_iM);
        test("-99001000000", "" + f_sM + sf_I);
        test("-9900null", "" + f_sM + f_oNtS);
        test("-9900false", "" + f_sM + f_bl);
        test("-9900null", "" + f_sM + sf_iAN);
        test("-9900-2000000", "" + f_sM + sf_iM);
        test("-9900-820130816", "" + f_sM + f_lM);
        test("-9900null", "" + f_sM + sf_oAN);
        test("-990025000000", "" + f_sM + s_I);
        test("935228928-96.0", "" + s_l + s_dM);
        test("935228928null", "" + s_l + s_oNtS);
        test("935228928\u045176", "" + s_l + f_strU);
        test("93522892892", "" + s_l + sf_strU2);
        test("93522892851", "" + s_l + sf_strU1);
        test("935228928null", "" + s_l + s_iAN);
        test("935228928-54", "" + s_l + f_bM);
        test("935228928-87.0", "" + s_l + f_fM);
        test("935228928null", "" + s_l + s_oAN);
        test("93522892819", "" + s_l + f_str);
        test("935228928-41", "" + s_l + sf_bM);
        test("935228928null", "" + s_l + sf_IN);
        test("935228928T", "" + s_l + s_c);
        test("935228928-42.0", "" + s_l + sf_fM);
        test("93522892825", "" + s_l + s_b);
        test("935228928null", "" + s_l + f_oN);
        test("935228928-1410065408", "" + s_l + s_lM);
        test("9352289288.0", "" + s_l + s_d);
        test("93522892855.0", "" + s_l + s_f);
        test("93522892897000000", "" + s_l + s_i);
        test("935228928-9900", "" + s_l + f_sM);
        test("935228928935228928", "" + s_l + s_l);
        test("935228928-8400", "" + s_l + sf_sM);
        test("935228928C(82)", "" + s_l + s_o);
        test("935228928null", "" + s_l + sf_oNtS);
        test("935228928true", "" + s_l + s_bl);
        test("9352289283900", "" + s_l + s_s);
        test("935228928null", "" + s_l + sf_oN);
        test("93522892894000000", "" + s_l + f_I);
        test("935228928null", "" + s_l + f_IN);
        test("935228928true", "" + s_l + sf_bl);
        test("9352289285500", "" + s_l + sf_s);
        test("935228928-2900", "" + s_l + s_sM);
        test("935228928-194313216", "" + s_l + sf_l);
        test("93522892812", "" + s_l + s_strU1);
        test("935228928C(87)", "" + s_l + sf_o);
        test("93522892891", "" + s_l + s_strU2);
        test("93522892821", "" + s_l + f_strU1);
        test("93522892818", "" + s_l + f_strU2);
        test("935228928null", "" + s_l + f_iAN);
        test("935228928null", "" + s_l + s_oN);
        test("935228928\u045180", "" + s_l + s_strU);
        test("935228928C", "" + s_l + sf_c);
        test("93522892875", "" + s_l + sf_str);
        test("935228928-43", "" + s_l + s_bM);
        test("93522892880", "" + s_l + sf_b);
        test("935228928null", "" + s_l + s_IN);
        test("935228928-52.0", "" + s_l + s_fM);
        test("93522892875000000", "" + s_l + sf_i);
        test("93522892844", "" + s_l + f_b);
        test("935228928-1705032704", "" + s_l + sf_lM);
        test("935228928null", "" + s_l + f_oAN);
        test("93522892883.0", "" + s_l + f_d);
        test("935228928I", "" + s_l + f_c);
        test("93522892894.0", "" + s_l + f_f);
        test("93522892812.0", "" + s_l + sf_d);
        test("935228928-99.0", "" + s_l + f_dM);
        test("93522892817.0", "" + s_l + sf_f);
        test("935228928-84.0", "" + s_l + sf_dM);
        test("93522892858000000", "" + s_l + f_i);
        test("935228928-55000000", "" + s_l + f_iM);
        test("9352289281460392448", "" + s_l + f_l);
        test("935228928C(70)", "" + s_l + f_o);
        test("935228928\u04511", "" + s_l + sf_strU);
        test("9352289288000", "" + s_l + f_s);
        test("93522892818", "" + s_l + s_str);
        test("935228928-1000000", "" + s_l + s_iM);
        test("9352289281000000", "" + s_l + sf_I);
        test("935228928null", "" + s_l + f_oNtS);
        test("935228928false", "" + s_l + f_bl);
        test("935228928null", "" + s_l + sf_iAN);
        test("935228928-2000000", "" + s_l + sf_iM);
        test("935228928-820130816", "" + s_l + f_lM);
        test("935228928null", "" + s_l + sf_oAN);
        test("93522892825000000", "" + s_l + s_I);
        test("-8400-96.0", "" + sf_sM + s_dM);
        test("-8400null", "" + sf_sM + s_oNtS);
        test("-8400\u045176", "" + sf_sM + f_strU);
        test("-840092", "" + sf_sM + sf_strU2);
        test("-840051", "" + sf_sM + sf_strU1);
        test("-8400null", "" + sf_sM + s_iAN);
        test("-8400-54", "" + sf_sM + f_bM);
        test("-8400-87.0", "" + sf_sM + f_fM);
        test("-8400null", "" + sf_sM + s_oAN);
        test("-840019", "" + sf_sM + f_str);
        test("-8400-41", "" + sf_sM + sf_bM);
        test("-8400null", "" + sf_sM + sf_IN);
        test("-8400T", "" + sf_sM + s_c);
        test("-8400-42.0", "" + sf_sM + sf_fM);
        test("-840025", "" + sf_sM + s_b);
        test("-8400null", "" + sf_sM + f_oN);
        test("-8400-1410065408", "" + sf_sM + s_lM);
        test("-84008.0", "" + sf_sM + s_d);
        test("-840055.0", "" + sf_sM + s_f);
        test("-840097000000", "" + sf_sM + s_i);
        test("-8400-9900", "" + sf_sM + f_sM);
        test("-8400935228928", "" + sf_sM + s_l);
        test("-8400-8400", "" + sf_sM + sf_sM);
        test("-8400C(82)", "" + sf_sM + s_o);
        test("-8400null", "" + sf_sM + sf_oNtS);
        test("-8400true", "" + sf_sM + s_bl);
        test("-84003900", "" + sf_sM + s_s);
        test("-8400null", "" + sf_sM + sf_oN);
        test("-840094000000", "" + sf_sM + f_I);
        test("-8400null", "" + sf_sM + f_IN);
        test("-8400true", "" + sf_sM + sf_bl);
        test("-84005500", "" + sf_sM + sf_s);
        test("-8400-2900", "" + sf_sM + s_sM);
        test("-8400-194313216", "" + sf_sM + sf_l);
        test("-840012", "" + sf_sM + s_strU1);
        test("-8400C(87)", "" + sf_sM + sf_o);
        test("-840091", "" + sf_sM + s_strU2);
        test("-840021", "" + sf_sM + f_strU1);
        test("-840018", "" + sf_sM + f_strU2);
        test("-8400null", "" + sf_sM + f_iAN);
        test("-8400null", "" + sf_sM + s_oN);
        test("-8400\u045180", "" + sf_sM + s_strU);
        test("-8400C", "" + sf_sM + sf_c);
        test("-840075", "" + sf_sM + sf_str);
        test("-8400-43", "" + sf_sM + s_bM);
        test("-840080", "" + sf_sM + sf_b);
        test("-8400null", "" + sf_sM + s_IN);
        test("-8400-52.0", "" + sf_sM + s_fM);
        test("-840075000000", "" + sf_sM + sf_i);
        test("-840044", "" + sf_sM + f_b);
        test("-8400-1705032704", "" + sf_sM + sf_lM);
        test("-8400null", "" + sf_sM + f_oAN);
        test("-840083.0", "" + sf_sM + f_d);
        test("-8400I", "" + sf_sM + f_c);
        test("-840094.0", "" + sf_sM + f_f);
        test("-840012.0", "" + sf_sM + sf_d);
        test("-8400-99.0", "" + sf_sM + f_dM);
        test("-840017.0", "" + sf_sM + sf_f);
        test("-8400-84.0", "" + sf_sM + sf_dM);
        test("-840058000000", "" + sf_sM + f_i);
        test("-8400-55000000", "" + sf_sM + f_iM);
        test("-84001460392448", "" + sf_sM + f_l);
        test("-8400C(70)", "" + sf_sM + f_o);
        test("-8400\u04511", "" + sf_sM + sf_strU);
        test("-84008000", "" + sf_sM + f_s);
        test("-840018", "" + sf_sM + s_str);
        test("-8400-1000000", "" + sf_sM + s_iM);
        test("-84001000000", "" + sf_sM + sf_I);
        test("-8400null", "" + sf_sM + f_oNtS);
        test("-8400false", "" + sf_sM + f_bl);
        test("-8400null", "" + sf_sM + sf_iAN);
        test("-8400-2000000", "" + sf_sM + sf_iM);
        test("-8400-820130816", "" + sf_sM + f_lM);
        test("-8400null", "" + sf_sM + sf_oAN);
        test("-840025000000", "" + sf_sM + s_I);
        test("C(82)-96.0", "" + s_o + s_dM);
        test("C(82)null", "" + s_o + s_oNtS);
        test("C(82)\u045176", "" + s_o + f_strU);
        test("C(82)92", "" + s_o + sf_strU2);
        test("C(82)51", "" + s_o + sf_strU1);
        test("C(82)null", "" + s_o + s_iAN);
        test("C(82)-54", "" + s_o + f_bM);
        test("C(82)-87.0", "" + s_o + f_fM);
        test("C(82)null", "" + s_o + s_oAN);
        test("C(82)19", "" + s_o + f_str);
        test("C(82)-41", "" + s_o + sf_bM);
        test("C(82)null", "" + s_o + sf_IN);
        test("C(82)T", "" + s_o + s_c);
        test("C(82)-42.0", "" + s_o + sf_fM);
        test("C(82)25", "" + s_o + s_b);
        test("C(82)null", "" + s_o + f_oN);
        test("C(82)-1410065408", "" + s_o + s_lM);
        test("C(82)8.0", "" + s_o + s_d);
        test("C(82)55.0", "" + s_o + s_f);
        test("C(82)97000000", "" + s_o + s_i);
        test("C(82)-9900", "" + s_o + f_sM);
        test("C(82)935228928", "" + s_o + s_l);
        test("C(82)-8400", "" + s_o + sf_sM);
        test("C(82)C(82)", "" + s_o + s_o);
        test("C(82)null", "" + s_o + sf_oNtS);
        test("C(82)true", "" + s_o + s_bl);
        test("C(82)3900", "" + s_o + s_s);
        test("C(82)null", "" + s_o + sf_oN);
        test("C(82)94000000", "" + s_o + f_I);
        test("C(82)null", "" + s_o + f_IN);
        test("C(82)true", "" + s_o + sf_bl);
        test("C(82)5500", "" + s_o + sf_s);
        test("C(82)-2900", "" + s_o + s_sM);
        test("C(82)-194313216", "" + s_o + sf_l);
        test("C(82)12", "" + s_o + s_strU1);
        test("C(82)C(87)", "" + s_o + sf_o);
        test("C(82)91", "" + s_o + s_strU2);
        test("C(82)21", "" + s_o + f_strU1);
        test("C(82)18", "" + s_o + f_strU2);
        test("C(82)null", "" + s_o + f_iAN);
        test("C(82)null", "" + s_o + s_oN);
        test("C(82)\u045180", "" + s_o + s_strU);
        test("C(82)C", "" + s_o + sf_c);
        test("C(82)75", "" + s_o + sf_str);
        test("C(82)-43", "" + s_o + s_bM);
        test("C(82)80", "" + s_o + sf_b);
        test("C(82)null", "" + s_o + s_IN);
        test("C(82)-52.0", "" + s_o + s_fM);
        test("C(82)75000000", "" + s_o + sf_i);
        test("C(82)44", "" + s_o + f_b);
        test("C(82)-1705032704", "" + s_o + sf_lM);
        test("C(82)null", "" + s_o + f_oAN);
        test("C(82)83.0", "" + s_o + f_d);
        test("C(82)I", "" + s_o + f_c);
        test("C(82)94.0", "" + s_o + f_f);
        test("C(82)12.0", "" + s_o + sf_d);
        test("C(82)-99.0", "" + s_o + f_dM);
        test("C(82)17.0", "" + s_o + sf_f);
        test("C(82)-84.0", "" + s_o + sf_dM);
        test("C(82)58000000", "" + s_o + f_i);
        test("C(82)-55000000", "" + s_o + f_iM);
        test("C(82)1460392448", "" + s_o + f_l);
        test("C(82)C(70)", "" + s_o + f_o);
        test("C(82)\u04511", "" + s_o + sf_strU);
        test("C(82)8000", "" + s_o + f_s);
        test("C(82)18", "" + s_o + s_str);
        test("C(82)-1000000", "" + s_o + s_iM);
        test("C(82)1000000", "" + s_o + sf_I);
        test("C(82)null", "" + s_o + f_oNtS);
        test("C(82)false", "" + s_o + f_bl);
        test("C(82)null", "" + s_o + sf_iAN);
        test("C(82)-2000000", "" + s_o + sf_iM);
        test("C(82)-820130816", "" + s_o + f_lM);
        test("C(82)null", "" + s_o + sf_oAN);
        test("C(82)25000000", "" + s_o + s_I);
        test("null-96.0", "" + sf_oNtS + s_dM);
        test("nullnull", "" + sf_oNtS + s_oNtS);
        test("null\u045176", "" + sf_oNtS + f_strU);
        test("null92", "" + sf_oNtS + sf_strU2);
        test("null51", "" + sf_oNtS + sf_strU1);
        test("nullnull", "" + sf_oNtS + s_iAN);
        test("null-54", "" + sf_oNtS + f_bM);
        test("null-87.0", "" + sf_oNtS + f_fM);
        test("nullnull", "" + sf_oNtS + s_oAN);
        test("null19", "" + sf_oNtS + f_str);
        test("null-41", "" + sf_oNtS + sf_bM);
        test("nullnull", "" + sf_oNtS + sf_IN);
        test("nullT", "" + sf_oNtS + s_c);
        test("null-42.0", "" + sf_oNtS + sf_fM);
        test("null25", "" + sf_oNtS + s_b);
        test("nullnull", "" + sf_oNtS + f_oN);
        test("null-1410065408", "" + sf_oNtS + s_lM);
        test("null8.0", "" + sf_oNtS + s_d);
        test("null55.0", "" + sf_oNtS + s_f);
        test("null97000000", "" + sf_oNtS + s_i);
        test("null-9900", "" + sf_oNtS + f_sM);
        test("null935228928", "" + sf_oNtS + s_l);
        test("null-8400", "" + sf_oNtS + sf_sM);
        test("nullC(82)", "" + sf_oNtS + s_o);
        test("nullnull", "" + sf_oNtS + sf_oNtS);
        test("nulltrue", "" + sf_oNtS + s_bl);
        test("null3900", "" + sf_oNtS + s_s);
        test("nullnull", "" + sf_oNtS + sf_oN);
        test("null94000000", "" + sf_oNtS + f_I);
        test("nullnull", "" + sf_oNtS + f_IN);
        test("nulltrue", "" + sf_oNtS + sf_bl);
        test("null5500", "" + sf_oNtS + sf_s);
        test("null-2900", "" + sf_oNtS + s_sM);
        test("null-194313216", "" + sf_oNtS + sf_l);
        test("null12", "" + sf_oNtS + s_strU1);
        test("nullC(87)", "" + sf_oNtS + sf_o);
        test("null91", "" + sf_oNtS + s_strU2);
        test("null21", "" + sf_oNtS + f_strU1);
        test("null18", "" + sf_oNtS + f_strU2);
        test("nullnull", "" + sf_oNtS + f_iAN);
        test("nullnull", "" + sf_oNtS + s_oN);
        test("null\u045180", "" + sf_oNtS + s_strU);
        test("nullC", "" + sf_oNtS + sf_c);
        test("null75", "" + sf_oNtS + sf_str);
        test("null-43", "" + sf_oNtS + s_bM);
        test("null80", "" + sf_oNtS + sf_b);
        test("nullnull", "" + sf_oNtS + s_IN);
        test("null-52.0", "" + sf_oNtS + s_fM);
        test("null75000000", "" + sf_oNtS + sf_i);
        test("null44", "" + sf_oNtS + f_b);
        test("null-1705032704", "" + sf_oNtS + sf_lM);
        test("nullnull", "" + sf_oNtS + f_oAN);
        test("null83.0", "" + sf_oNtS + f_d);
        test("nullI", "" + sf_oNtS + f_c);
        test("null94.0", "" + sf_oNtS + f_f);
        test("null12.0", "" + sf_oNtS + sf_d);
        test("null-99.0", "" + sf_oNtS + f_dM);
        test("null17.0", "" + sf_oNtS + sf_f);
        test("null-84.0", "" + sf_oNtS + sf_dM);
        test("null58000000", "" + sf_oNtS + f_i);
        test("null-55000000", "" + sf_oNtS + f_iM);
        test("null1460392448", "" + sf_oNtS + f_l);
        test("nullC(70)", "" + sf_oNtS + f_o);
        test("null\u04511", "" + sf_oNtS + sf_strU);
        test("null8000", "" + sf_oNtS + f_s);
        test("null18", "" + sf_oNtS + s_str);
        test("null-1000000", "" + sf_oNtS + s_iM);
        test("null1000000", "" + sf_oNtS + sf_I);
        test("nullnull", "" + sf_oNtS + f_oNtS);
        test("nullfalse", "" + sf_oNtS + f_bl);
        test("nullnull", "" + sf_oNtS + sf_iAN);
        test("null-2000000", "" + sf_oNtS + sf_iM);
        test("null-820130816", "" + sf_oNtS + f_lM);
        test("nullnull", "" + sf_oNtS + sf_oAN);
        test("null25000000", "" + sf_oNtS + s_I);
        test("true-96.0", "" + s_bl + s_dM);
        test("truenull", "" + s_bl + s_oNtS);
        test("true\u045176", "" + s_bl + f_strU);
        test("true92", "" + s_bl + sf_strU2);
        test("true51", "" + s_bl + sf_strU1);
        test("truenull", "" + s_bl + s_iAN);
        test("true-54", "" + s_bl + f_bM);
        test("true-87.0", "" + s_bl + f_fM);
        test("truenull", "" + s_bl + s_oAN);
        test("true19", "" + s_bl + f_str);
        test("true-41", "" + s_bl + sf_bM);
        test("truenull", "" + s_bl + sf_IN);
        test("trueT", "" + s_bl + s_c);
        test("true-42.0", "" + s_bl + sf_fM);
        test("true25", "" + s_bl + s_b);
        test("truenull", "" + s_bl + f_oN);
        test("true-1410065408", "" + s_bl + s_lM);
        test("true8.0", "" + s_bl + s_d);
        test("true55.0", "" + s_bl + s_f);
        test("true97000000", "" + s_bl + s_i);
        test("true-9900", "" + s_bl + f_sM);
        test("true935228928", "" + s_bl + s_l);
        test("true-8400", "" + s_bl + sf_sM);
        test("trueC(82)", "" + s_bl + s_o);
        test("truenull", "" + s_bl + sf_oNtS);
        test("truetrue", "" + s_bl + s_bl);
        test("true3900", "" + s_bl + s_s);
        test("truenull", "" + s_bl + sf_oN);
        test("true94000000", "" + s_bl + f_I);
        test("truenull", "" + s_bl + f_IN);
        test("truetrue", "" + s_bl + sf_bl);
        test("true5500", "" + s_bl + sf_s);
        test("true-2900", "" + s_bl + s_sM);
        test("true-194313216", "" + s_bl + sf_l);
        test("true12", "" + s_bl + s_strU1);
        test("trueC(87)", "" + s_bl + sf_o);
        test("true91", "" + s_bl + s_strU2);
        test("true21", "" + s_bl + f_strU1);
        test("true18", "" + s_bl + f_strU2);
        test("truenull", "" + s_bl + f_iAN);
        test("truenull", "" + s_bl + s_oN);
        test("true\u045180", "" + s_bl + s_strU);
        test("trueC", "" + s_bl + sf_c);
        test("true75", "" + s_bl + sf_str);
        test("true-43", "" + s_bl + s_bM);
        test("true80", "" + s_bl + sf_b);
        test("truenull", "" + s_bl + s_IN);
        test("true-52.0", "" + s_bl + s_fM);
        test("true75000000", "" + s_bl + sf_i);
        test("true44", "" + s_bl + f_b);
    }

    public void run2() {
        test("true-1705032704", "" + s_bl + sf_lM);
        test("truenull", "" + s_bl + f_oAN);
        test("true83.0", "" + s_bl + f_d);
        test("trueI", "" + s_bl + f_c);
        test("true94.0", "" + s_bl + f_f);
        test("true12.0", "" + s_bl + sf_d);
        test("true-99.0", "" + s_bl + f_dM);
        test("true17.0", "" + s_bl + sf_f);
        test("true-84.0", "" + s_bl + sf_dM);
        test("true58000000", "" + s_bl + f_i);
        test("true-55000000", "" + s_bl + f_iM);
        test("true1460392448", "" + s_bl + f_l);
        test("trueC(70)", "" + s_bl + f_o);
        test("true\u04511", "" + s_bl + sf_strU);
        test("true8000", "" + s_bl + f_s);
        test("true18", "" + s_bl + s_str);
        test("true-1000000", "" + s_bl + s_iM);
        test("true1000000", "" + s_bl + sf_I);
        test("truenull", "" + s_bl + f_oNtS);
        test("truefalse", "" + s_bl + f_bl);
        test("truenull", "" + s_bl + sf_iAN);
        test("true-2000000", "" + s_bl + sf_iM);
        test("true-820130816", "" + s_bl + f_lM);
        test("truenull", "" + s_bl + sf_oAN);
        test("true25000000", "" + s_bl + s_I);
        test("3900-96.0", "" + s_s + s_dM);
        test("3900null", "" + s_s + s_oNtS);
        test("3900\u045176", "" + s_s + f_strU);
        test("390092", "" + s_s + sf_strU2);
        test("390051", "" + s_s + sf_strU1);
        test("3900null", "" + s_s + s_iAN);
        test("3900-54", "" + s_s + f_bM);
        test("3900-87.0", "" + s_s + f_fM);
        test("3900null", "" + s_s + s_oAN);
        test("390019", "" + s_s + f_str);
        test("3900-41", "" + s_s + sf_bM);
        test("3900null", "" + s_s + sf_IN);
        test("3900T", "" + s_s + s_c);
        test("3900-42.0", "" + s_s + sf_fM);
        test("390025", "" + s_s + s_b);
        test("3900null", "" + s_s + f_oN);
        test("3900-1410065408", "" + s_s + s_lM);
        test("39008.0", "" + s_s + s_d);
        test("390055.0", "" + s_s + s_f);
        test("390097000000", "" + s_s + s_i);
        test("3900-9900", "" + s_s + f_sM);
        test("3900935228928", "" + s_s + s_l);
        test("3900-8400", "" + s_s + sf_sM);
        test("3900C(82)", "" + s_s + s_o);
        test("3900null", "" + s_s + sf_oNtS);
        test("3900true", "" + s_s + s_bl);
        test("39003900", "" + s_s + s_s);
        test("3900null", "" + s_s + sf_oN);
        test("390094000000", "" + s_s + f_I);
        test("3900null", "" + s_s + f_IN);
        test("3900true", "" + s_s + sf_bl);
        test("39005500", "" + s_s + sf_s);
        test("3900-2900", "" + s_s + s_sM);
        test("3900-194313216", "" + s_s + sf_l);
        test("390012", "" + s_s + s_strU1);
        test("3900C(87)", "" + s_s + sf_o);
        test("390091", "" + s_s + s_strU2);
        test("390021", "" + s_s + f_strU1);
        test("390018", "" + s_s + f_strU2);
        test("3900null", "" + s_s + f_iAN);
        test("3900null", "" + s_s + s_oN);
        test("3900\u045180", "" + s_s + s_strU);
        test("3900C", "" + s_s + sf_c);
        test("390075", "" + s_s + sf_str);
        test("3900-43", "" + s_s + s_bM);
        test("390080", "" + s_s + sf_b);
        test("3900null", "" + s_s + s_IN);
        test("3900-52.0", "" + s_s + s_fM);
        test("390075000000", "" + s_s + sf_i);
        test("390044", "" + s_s + f_b);
        test("3900-1705032704", "" + s_s + sf_lM);
        test("3900null", "" + s_s + f_oAN);
        test("390083.0", "" + s_s + f_d);
        test("3900I", "" + s_s + f_c);
        test("390094.0", "" + s_s + f_f);
        test("390012.0", "" + s_s + sf_d);
        test("3900-99.0", "" + s_s + f_dM);
        test("390017.0", "" + s_s + sf_f);
        test("3900-84.0", "" + s_s + sf_dM);
        test("390058000000", "" + s_s + f_i);
        test("3900-55000000", "" + s_s + f_iM);
        test("39001460392448", "" + s_s + f_l);
        test("3900C(70)", "" + s_s + f_o);
        test("3900\u04511", "" + s_s + sf_strU);
        test("39008000", "" + s_s + f_s);
        test("390018", "" + s_s + s_str);
        test("3900-1000000", "" + s_s + s_iM);
        test("39001000000", "" + s_s + sf_I);
        test("3900null", "" + s_s + f_oNtS);
        test("3900false", "" + s_s + f_bl);
        test("3900null", "" + s_s + sf_iAN);
        test("3900-2000000", "" + s_s + sf_iM);
        test("3900-820130816", "" + s_s + f_lM);
        test("3900null", "" + s_s + sf_oAN);
        test("390025000000", "" + s_s + s_I);
        test("null-96.0", "" + sf_oN + s_dM);
        test("nullnull", "" + sf_oN + s_oNtS);
        test("null\u045176", "" + sf_oN + f_strU);
        test("null92", "" + sf_oN + sf_strU2);
        test("null51", "" + sf_oN + sf_strU1);
        test("nullnull", "" + sf_oN + s_iAN);
        test("null-54", "" + sf_oN + f_bM);
        test("null-87.0", "" + sf_oN + f_fM);
        test("nullnull", "" + sf_oN + s_oAN);
        test("null19", "" + sf_oN + f_str);
        test("null-41", "" + sf_oN + sf_bM);
        test("nullnull", "" + sf_oN + sf_IN);
        test("nullT", "" + sf_oN + s_c);
        test("null-42.0", "" + sf_oN + sf_fM);
        test("null25", "" + sf_oN + s_b);
        test("nullnull", "" + sf_oN + f_oN);
        test("null-1410065408", "" + sf_oN + s_lM);
        test("null8.0", "" + sf_oN + s_d);
        test("null55.0", "" + sf_oN + s_f);
        test("null97000000", "" + sf_oN + s_i);
        test("null-9900", "" + sf_oN + f_sM);
        test("null935228928", "" + sf_oN + s_l);
        test("null-8400", "" + sf_oN + sf_sM);
        test("nullC(82)", "" + sf_oN + s_o);
        test("nullnull", "" + sf_oN + sf_oNtS);
        test("nulltrue", "" + sf_oN + s_bl);
        test("null3900", "" + sf_oN + s_s);
        test("nullnull", "" + sf_oN + sf_oN);
        test("null94000000", "" + sf_oN + f_I);
        test("nullnull", "" + sf_oN + f_IN);
        test("nulltrue", "" + sf_oN + sf_bl);
        test("null5500", "" + sf_oN + sf_s);
        test("null-2900", "" + sf_oN + s_sM);
        test("null-194313216", "" + sf_oN + sf_l);
        test("null12", "" + sf_oN + s_strU1);
        test("nullC(87)", "" + sf_oN + sf_o);
        test("null91", "" + sf_oN + s_strU2);
        test("null21", "" + sf_oN + f_strU1);
        test("null18", "" + sf_oN + f_strU2);
        test("nullnull", "" + sf_oN + f_iAN);
        test("nullnull", "" + sf_oN + s_oN);
        test("null\u045180", "" + sf_oN + s_strU);
        test("nullC", "" + sf_oN + sf_c);
        test("null75", "" + sf_oN + sf_str);
        test("null-43", "" + sf_oN + s_bM);
        test("null80", "" + sf_oN + sf_b);
        test("nullnull", "" + sf_oN + s_IN);
        test("null-52.0", "" + sf_oN + s_fM);
        test("null75000000", "" + sf_oN + sf_i);
        test("null44", "" + sf_oN + f_b);
        test("null-1705032704", "" + sf_oN + sf_lM);
        test("nullnull", "" + sf_oN + f_oAN);
        test("null83.0", "" + sf_oN + f_d);
        test("nullI", "" + sf_oN + f_c);
        test("null94.0", "" + sf_oN + f_f);
        test("null12.0", "" + sf_oN + sf_d);
        test("null-99.0", "" + sf_oN + f_dM);
        test("null17.0", "" + sf_oN + sf_f);
        test("null-84.0", "" + sf_oN + sf_dM);
        test("null58000000", "" + sf_oN + f_i);
        test("null-55000000", "" + sf_oN + f_iM);
        test("null1460392448", "" + sf_oN + f_l);
        test("nullC(70)", "" + sf_oN + f_o);
        test("null\u04511", "" + sf_oN + sf_strU);
        test("null8000", "" + sf_oN + f_s);
        test("null18", "" + sf_oN + s_str);
        test("null-1000000", "" + sf_oN + s_iM);
        test("null1000000", "" + sf_oN + sf_I);
        test("nullnull", "" + sf_oN + f_oNtS);
        test("nullfalse", "" + sf_oN + f_bl);
        test("nullnull", "" + sf_oN + sf_iAN);
        test("null-2000000", "" + sf_oN + sf_iM);
        test("null-820130816", "" + sf_oN + f_lM);
        test("nullnull", "" + sf_oN + sf_oAN);
        test("null25000000", "" + sf_oN + s_I);
        test("94000000-96.0", "" + f_I + s_dM);
        test("94000000null", "" + f_I + s_oNtS);
        test("94000000\u045176", "" + f_I + f_strU);
        test("9400000092", "" + f_I + sf_strU2);
        test("9400000051", "" + f_I + sf_strU1);
        test("94000000null", "" + f_I + s_iAN);
        test("94000000-54", "" + f_I + f_bM);
        test("94000000-87.0", "" + f_I + f_fM);
        test("94000000null", "" + f_I + s_oAN);
        test("9400000019", "" + f_I + f_str);
        test("94000000-41", "" + f_I + sf_bM);
        test("94000000null", "" + f_I + sf_IN);
        test("94000000T", "" + f_I + s_c);
        test("94000000-42.0", "" + f_I + sf_fM);
        test("9400000025", "" + f_I + s_b);
        test("94000000null", "" + f_I + f_oN);
        test("94000000-1410065408", "" + f_I + s_lM);
        test("940000008.0", "" + f_I + s_d);
        test("9400000055.0", "" + f_I + s_f);
        test("9400000097000000", "" + f_I + s_i);
        test("94000000-9900", "" + f_I + f_sM);
        test("94000000935228928", "" + f_I + s_l);
        test("94000000-8400", "" + f_I + sf_sM);
        test("94000000C(82)", "" + f_I + s_o);
        test("94000000null", "" + f_I + sf_oNtS);
        test("94000000true", "" + f_I + s_bl);
        test("940000003900", "" + f_I + s_s);
        test("94000000null", "" + f_I + sf_oN);
        test("9400000094000000", "" + f_I + f_I);
        test("94000000null", "" + f_I + f_IN);
        test("94000000true", "" + f_I + sf_bl);
        test("940000005500", "" + f_I + sf_s);
        test("94000000-2900", "" + f_I + s_sM);
        test("94000000-194313216", "" + f_I + sf_l);
        test("9400000012", "" + f_I + s_strU1);
        test("94000000C(87)", "" + f_I + sf_o);
        test("9400000091", "" + f_I + s_strU2);
        test("9400000021", "" + f_I + f_strU1);
        test("9400000018", "" + f_I + f_strU2);
        test("94000000null", "" + f_I + f_iAN);
        test("94000000null", "" + f_I + s_oN);
        test("94000000\u045180", "" + f_I + s_strU);
        test("94000000C", "" + f_I + sf_c);
        test("9400000075", "" + f_I + sf_str);
        test("94000000-43", "" + f_I + s_bM);
        test("9400000080", "" + f_I + sf_b);
        test("94000000null", "" + f_I + s_IN);
        test("94000000-52.0", "" + f_I + s_fM);
        test("9400000075000000", "" + f_I + sf_i);
        test("9400000044", "" + f_I + f_b);
        test("94000000-1705032704", "" + f_I + sf_lM);
        test("94000000null", "" + f_I + f_oAN);
        test("9400000083.0", "" + f_I + f_d);
        test("94000000I", "" + f_I + f_c);
        test("9400000094.0", "" + f_I + f_f);
        test("9400000012.0", "" + f_I + sf_d);
        test("94000000-99.0", "" + f_I + f_dM);
        test("9400000017.0", "" + f_I + sf_f);
        test("94000000-84.0", "" + f_I + sf_dM);
        test("9400000058000000", "" + f_I + f_i);
        test("94000000-55000000", "" + f_I + f_iM);
        test("940000001460392448", "" + f_I + f_l);
        test("94000000C(70)", "" + f_I + f_o);
        test("94000000\u04511", "" + f_I + sf_strU);
        test("940000008000", "" + f_I + f_s);
        test("9400000018", "" + f_I + s_str);
        test("94000000-1000000", "" + f_I + s_iM);
        test("940000001000000", "" + f_I + sf_I);
        test("94000000null", "" + f_I + f_oNtS);
        test("94000000false", "" + f_I + f_bl);
        test("94000000null", "" + f_I + sf_iAN);
        test("94000000-2000000", "" + f_I + sf_iM);
        test("94000000-820130816", "" + f_I + f_lM);
        test("94000000null", "" + f_I + sf_oAN);
        test("9400000025000000", "" + f_I + s_I);
        test("null-96.0", "" + f_IN + s_dM);
        test("nullnull", "" + f_IN + s_oNtS);
        test("null\u045176", "" + f_IN + f_strU);
        test("null92", "" + f_IN + sf_strU2);
        test("null51", "" + f_IN + sf_strU1);
        test("nullnull", "" + f_IN + s_iAN);
        test("null-54", "" + f_IN + f_bM);
        test("null-87.0", "" + f_IN + f_fM);
        test("nullnull", "" + f_IN + s_oAN);
        test("null19", "" + f_IN + f_str);
        test("null-41", "" + f_IN + sf_bM);
        test("nullnull", "" + f_IN + sf_IN);
        test("nullT", "" + f_IN + s_c);
        test("null-42.0", "" + f_IN + sf_fM);
        test("null25", "" + f_IN + s_b);
        test("nullnull", "" + f_IN + f_oN);
        test("null-1410065408", "" + f_IN + s_lM);
        test("null8.0", "" + f_IN + s_d);
        test("null55.0", "" + f_IN + s_f);
        test("null97000000", "" + f_IN + s_i);
        test("null-9900", "" + f_IN + f_sM);
        test("null935228928", "" + f_IN + s_l);
        test("null-8400", "" + f_IN + sf_sM);
        test("nullC(82)", "" + f_IN + s_o);
        test("nullnull", "" + f_IN + sf_oNtS);
        test("nulltrue", "" + f_IN + s_bl);
        test("null3900", "" + f_IN + s_s);
        test("nullnull", "" + f_IN + sf_oN);
        test("null94000000", "" + f_IN + f_I);
        test("nullnull", "" + f_IN + f_IN);
        test("nulltrue", "" + f_IN + sf_bl);
        test("null5500", "" + f_IN + sf_s);
        test("null-2900", "" + f_IN + s_sM);
        test("null-194313216", "" + f_IN + sf_l);
        test("null12", "" + f_IN + s_strU1);
        test("nullC(87)", "" + f_IN + sf_o);
        test("null91", "" + f_IN + s_strU2);
        test("null21", "" + f_IN + f_strU1);
        test("null18", "" + f_IN + f_strU2);
        test("nullnull", "" + f_IN + f_iAN);
        test("nullnull", "" + f_IN + s_oN);
        test("null\u045180", "" + f_IN + s_strU);
        test("nullC", "" + f_IN + sf_c);
        test("null75", "" + f_IN + sf_str);
        test("null-43", "" + f_IN + s_bM);
        test("null80", "" + f_IN + sf_b);
        test("nullnull", "" + f_IN + s_IN);
        test("null-52.0", "" + f_IN + s_fM);
        test("null75000000", "" + f_IN + sf_i);
        test("null44", "" + f_IN + f_b);
        test("null-1705032704", "" + f_IN + sf_lM);
        test("nullnull", "" + f_IN + f_oAN);
        test("null83.0", "" + f_IN + f_d);
        test("nullI", "" + f_IN + f_c);
        test("null94.0", "" + f_IN + f_f);
        test("null12.0", "" + f_IN + sf_d);
        test("null-99.0", "" + f_IN + f_dM);
        test("null17.0", "" + f_IN + sf_f);
        test("null-84.0", "" + f_IN + sf_dM);
        test("null58000000", "" + f_IN + f_i);
        test("null-55000000", "" + f_IN + f_iM);
        test("null1460392448", "" + f_IN + f_l);
        test("nullC(70)", "" + f_IN + f_o);
        test("null\u04511", "" + f_IN + sf_strU);
        test("null8000", "" + f_IN + f_s);
        test("null18", "" + f_IN + s_str);
        test("null-1000000", "" + f_IN + s_iM);
        test("null1000000", "" + f_IN + sf_I);
        test("nullnull", "" + f_IN + f_oNtS);
        test("nullfalse", "" + f_IN + f_bl);
        test("nullnull", "" + f_IN + sf_iAN);
        test("null-2000000", "" + f_IN + sf_iM);
        test("null-820130816", "" + f_IN + f_lM);
        test("nullnull", "" + f_IN + sf_oAN);
        test("null25000000", "" + f_IN + s_I);
        test("true-96.0", "" + sf_bl + s_dM);
        test("truenull", "" + sf_bl + s_oNtS);
        test("true\u045176", "" + sf_bl + f_strU);
        test("true92", "" + sf_bl + sf_strU2);
        test("true51", "" + sf_bl + sf_strU1);
        test("truenull", "" + sf_bl + s_iAN);
        test("true-54", "" + sf_bl + f_bM);
        test("true-87.0", "" + sf_bl + f_fM);
        test("truenull", "" + sf_bl + s_oAN);
        test("true19", "" + sf_bl + f_str);
        test("true-41", "" + sf_bl + sf_bM);
        test("truenull", "" + sf_bl + sf_IN);
        test("trueT", "" + sf_bl + s_c);
        test("true-42.0", "" + sf_bl + sf_fM);
        test("true25", "" + sf_bl + s_b);
        test("truenull", "" + sf_bl + f_oN);
        test("true-1410065408", "" + sf_bl + s_lM);
        test("true8.0", "" + sf_bl + s_d);
        test("true55.0", "" + sf_bl + s_f);
        test("true97000000", "" + sf_bl + s_i);
        test("true-9900", "" + sf_bl + f_sM);
        test("true935228928", "" + sf_bl + s_l);
        test("true-8400", "" + sf_bl + sf_sM);
        test("trueC(82)", "" + sf_bl + s_o);
        test("truenull", "" + sf_bl + sf_oNtS);
        test("truetrue", "" + sf_bl + s_bl);
        test("true3900", "" + sf_bl + s_s);
        test("truenull", "" + sf_bl + sf_oN);
        test("true94000000", "" + sf_bl + f_I);
        test("truenull", "" + sf_bl + f_IN);
        test("truetrue", "" + sf_bl + sf_bl);
        test("true5500", "" + sf_bl + sf_s);
        test("true-2900", "" + sf_bl + s_sM);
        test("true-194313216", "" + sf_bl + sf_l);
        test("true12", "" + sf_bl + s_strU1);
        test("trueC(87)", "" + sf_bl + sf_o);
        test("true91", "" + sf_bl + s_strU2);
        test("true21", "" + sf_bl + f_strU1);
        test("true18", "" + sf_bl + f_strU2);
        test("truenull", "" + sf_bl + f_iAN);
        test("truenull", "" + sf_bl + s_oN);
        test("true\u045180", "" + sf_bl + s_strU);
        test("trueC", "" + sf_bl + sf_c);
        test("true75", "" + sf_bl + sf_str);
        test("true-43", "" + sf_bl + s_bM);
        test("true80", "" + sf_bl + sf_b);
        test("truenull", "" + sf_bl + s_IN);
        test("true-52.0", "" + sf_bl + s_fM);
        test("true75000000", "" + sf_bl + sf_i);
        test("true44", "" + sf_bl + f_b);
        test("true-1705032704", "" + sf_bl + sf_lM);
        test("truenull", "" + sf_bl + f_oAN);
        test("true83.0", "" + sf_bl + f_d);
        test("trueI", "" + sf_bl + f_c);
        test("true94.0", "" + sf_bl + f_f);
        test("true12.0", "" + sf_bl + sf_d);
        test("true-99.0", "" + sf_bl + f_dM);
        test("true17.0", "" + sf_bl + sf_f);
        test("true-84.0", "" + sf_bl + sf_dM);
        test("true58000000", "" + sf_bl + f_i);
        test("true-55000000", "" + sf_bl + f_iM);
        test("true1460392448", "" + sf_bl + f_l);
        test("trueC(70)", "" + sf_bl + f_o);
        test("true\u04511", "" + sf_bl + sf_strU);
        test("true8000", "" + sf_bl + f_s);
        test("true18", "" + sf_bl + s_str);
        test("true-1000000", "" + sf_bl + s_iM);
        test("true1000000", "" + sf_bl + sf_I);
        test("truenull", "" + sf_bl + f_oNtS);
        test("truefalse", "" + sf_bl + f_bl);
        test("truenull", "" + sf_bl + sf_iAN);
        test("true-2000000", "" + sf_bl + sf_iM);
        test("true-820130816", "" + sf_bl + f_lM);
        test("truenull", "" + sf_bl + sf_oAN);
        test("true25000000", "" + sf_bl + s_I);
        test("5500-96.0", "" + sf_s + s_dM);
        test("5500null", "" + sf_s + s_oNtS);
        test("5500\u045176", "" + sf_s + f_strU);
        test("550092", "" + sf_s + sf_strU2);
        test("550051", "" + sf_s + sf_strU1);
        test("5500null", "" + sf_s + s_iAN);
        test("5500-54", "" + sf_s + f_bM);
        test("5500-87.0", "" + sf_s + f_fM);
        test("5500null", "" + sf_s + s_oAN);
        test("550019", "" + sf_s + f_str);
        test("5500-41", "" + sf_s + sf_bM);
        test("5500null", "" + sf_s + sf_IN);
        test("5500T", "" + sf_s + s_c);
        test("5500-42.0", "" + sf_s + sf_fM);
        test("550025", "" + sf_s + s_b);
        test("5500null", "" + sf_s + f_oN);
        test("5500-1410065408", "" + sf_s + s_lM);
        test("55008.0", "" + sf_s + s_d);
        test("550055.0", "" + sf_s + s_f);
        test("550097000000", "" + sf_s + s_i);
        test("5500-9900", "" + sf_s + f_sM);
        test("5500935228928", "" + sf_s + s_l);
        test("5500-8400", "" + sf_s + sf_sM);
        test("5500C(82)", "" + sf_s + s_o);
        test("5500null", "" + sf_s + sf_oNtS);
        test("5500true", "" + sf_s + s_bl);
        test("55003900", "" + sf_s + s_s);
        test("5500null", "" + sf_s + sf_oN);
        test("550094000000", "" + sf_s + f_I);
        test("5500null", "" + sf_s + f_IN);
        test("5500true", "" + sf_s + sf_bl);
        test("55005500", "" + sf_s + sf_s);
        test("5500-2900", "" + sf_s + s_sM);
        test("5500-194313216", "" + sf_s + sf_l);
        test("550012", "" + sf_s + s_strU1);
        test("5500C(87)", "" + sf_s + sf_o);
        test("550091", "" + sf_s + s_strU2);
        test("550021", "" + sf_s + f_strU1);
        test("550018", "" + sf_s + f_strU2);
        test("5500null", "" + sf_s + f_iAN);
        test("5500null", "" + sf_s + s_oN);
        test("5500\u045180", "" + sf_s + s_strU);
        test("5500C", "" + sf_s + sf_c);
        test("550075", "" + sf_s + sf_str);
        test("5500-43", "" + sf_s + s_bM);
        test("550080", "" + sf_s + sf_b);
        test("5500null", "" + sf_s + s_IN);
        test("5500-52.0", "" + sf_s + s_fM);
        test("550075000000", "" + sf_s + sf_i);
        test("550044", "" + sf_s + f_b);
        test("5500-1705032704", "" + sf_s + sf_lM);
        test("5500null", "" + sf_s + f_oAN);
        test("550083.0", "" + sf_s + f_d);
        test("5500I", "" + sf_s + f_c);
        test("550094.0", "" + sf_s + f_f);
        test("550012.0", "" + sf_s + sf_d);
        test("5500-99.0", "" + sf_s + f_dM);
        test("550017.0", "" + sf_s + sf_f);
        test("5500-84.0", "" + sf_s + sf_dM);
        test("550058000000", "" + sf_s + f_i);
        test("5500-55000000", "" + sf_s + f_iM);
        test("55001460392448", "" + sf_s + f_l);
        test("5500C(70)", "" + sf_s + f_o);
        test("5500\u04511", "" + sf_s + sf_strU);
        test("55008000", "" + sf_s + f_s);
        test("550018", "" + sf_s + s_str);
        test("5500-1000000", "" + sf_s + s_iM);
        test("55001000000", "" + sf_s + sf_I);
        test("5500null", "" + sf_s + f_oNtS);
        test("5500false", "" + sf_s + f_bl);
        test("5500null", "" + sf_s + sf_iAN);
        test("5500-2000000", "" + sf_s + sf_iM);
        test("5500-820130816", "" + sf_s + f_lM);
        test("5500null", "" + sf_s + sf_oAN);
        test("550025000000", "" + sf_s + s_I);
        test("-2900-96.0", "" + s_sM + s_dM);
        test("-2900null", "" + s_sM + s_oNtS);
        test("-2900\u045176", "" + s_sM + f_strU);
        test("-290092", "" + s_sM + sf_strU2);
        test("-290051", "" + s_sM + sf_strU1);
        test("-2900null", "" + s_sM + s_iAN);
        test("-2900-54", "" + s_sM + f_bM);
        test("-2900-87.0", "" + s_sM + f_fM);
        test("-2900null", "" + s_sM + s_oAN);
        test("-290019", "" + s_sM + f_str);
        test("-2900-41", "" + s_sM + sf_bM);
        test("-2900null", "" + s_sM + sf_IN);
        test("-2900T", "" + s_sM + s_c);
        test("-2900-42.0", "" + s_sM + sf_fM);
        test("-290025", "" + s_sM + s_b);
        test("-2900null", "" + s_sM + f_oN);
        test("-2900-1410065408", "" + s_sM + s_lM);
        test("-29008.0", "" + s_sM + s_d);
        test("-290055.0", "" + s_sM + s_f);
        test("-290097000000", "" + s_sM + s_i);
        test("-2900-9900", "" + s_sM + f_sM);
        test("-2900935228928", "" + s_sM + s_l);
        test("-2900-8400", "" + s_sM + sf_sM);
        test("-2900C(82)", "" + s_sM + s_o);
        test("-2900null", "" + s_sM + sf_oNtS);
        test("-2900true", "" + s_sM + s_bl);
        test("-29003900", "" + s_sM + s_s);
        test("-2900null", "" + s_sM + sf_oN);
        test("-290094000000", "" + s_sM + f_I);
        test("-2900null", "" + s_sM + f_IN);
        test("-2900true", "" + s_sM + sf_bl);
        test("-29005500", "" + s_sM + sf_s);
        test("-2900-2900", "" + s_sM + s_sM);
        test("-2900-194313216", "" + s_sM + sf_l);
        test("-290012", "" + s_sM + s_strU1);
        test("-2900C(87)", "" + s_sM + sf_o);
        test("-290091", "" + s_sM + s_strU2);
        test("-290021", "" + s_sM + f_strU1);
        test("-290018", "" + s_sM + f_strU2);
        test("-2900null", "" + s_sM + f_iAN);
        test("-2900null", "" + s_sM + s_oN);
        test("-2900\u045180", "" + s_sM + s_strU);
        test("-2900C", "" + s_sM + sf_c);
        test("-290075", "" + s_sM + sf_str);
        test("-2900-43", "" + s_sM + s_bM);
        test("-290080", "" + s_sM + sf_b);
        test("-2900null", "" + s_sM + s_IN);
        test("-2900-52.0", "" + s_sM + s_fM);
        test("-290075000000", "" + s_sM + sf_i);
        test("-290044", "" + s_sM + f_b);
        test("-2900-1705032704", "" + s_sM + sf_lM);
        test("-2900null", "" + s_sM + f_oAN);
        test("-290083.0", "" + s_sM + f_d);
        test("-2900I", "" + s_sM + f_c);
        test("-290094.0", "" + s_sM + f_f);
        test("-290012.0", "" + s_sM + sf_d);
        test("-2900-99.0", "" + s_sM + f_dM);
        test("-290017.0", "" + s_sM + sf_f);
        test("-2900-84.0", "" + s_sM + sf_dM);
        test("-290058000000", "" + s_sM + f_i);
        test("-2900-55000000", "" + s_sM + f_iM);
        test("-29001460392448", "" + s_sM + f_l);
        test("-2900C(70)", "" + s_sM + f_o);
        test("-2900\u04511", "" + s_sM + sf_strU);
        test("-29008000", "" + s_sM + f_s);
        test("-290018", "" + s_sM + s_str);
        test("-2900-1000000", "" + s_sM + s_iM);
        test("-29001000000", "" + s_sM + sf_I);
        test("-2900null", "" + s_sM + f_oNtS);
        test("-2900false", "" + s_sM + f_bl);
        test("-2900null", "" + s_sM + sf_iAN);
        test("-2900-2000000", "" + s_sM + sf_iM);
        test("-2900-820130816", "" + s_sM + f_lM);
        test("-2900null", "" + s_sM + sf_oAN);
        test("-290025000000", "" + s_sM + s_I);
        test("-194313216-96.0", "" + sf_l + s_dM);
        test("-194313216null", "" + sf_l + s_oNtS);
        test("-194313216\u045176", "" + sf_l + f_strU);
        test("-19431321692", "" + sf_l + sf_strU2);
        test("-19431321651", "" + sf_l + sf_strU1);
        test("-194313216null", "" + sf_l + s_iAN);
        test("-194313216-54", "" + sf_l + f_bM);
        test("-194313216-87.0", "" + sf_l + f_fM);
        test("-194313216null", "" + sf_l + s_oAN);
        test("-19431321619", "" + sf_l + f_str);
        test("-194313216-41", "" + sf_l + sf_bM);
        test("-194313216null", "" + sf_l + sf_IN);
        test("-194313216T", "" + sf_l + s_c);
        test("-194313216-42.0", "" + sf_l + sf_fM);
        test("-19431321625", "" + sf_l + s_b);
        test("-194313216null", "" + sf_l + f_oN);
        test("-194313216-1410065408", "" + sf_l + s_lM);
        test("-1943132168.0", "" + sf_l + s_d);
        test("-19431321655.0", "" + sf_l + s_f);
        test("-19431321697000000", "" + sf_l + s_i);
        test("-194313216-9900", "" + sf_l + f_sM);
        test("-194313216935228928", "" + sf_l + s_l);
        test("-194313216-8400", "" + sf_l + sf_sM);
        test("-194313216C(82)", "" + sf_l + s_o);
        test("-194313216null", "" + sf_l + sf_oNtS);
        test("-194313216true", "" + sf_l + s_bl);
        test("-1943132163900", "" + sf_l + s_s);
        test("-194313216null", "" + sf_l + sf_oN);
        test("-19431321694000000", "" + sf_l + f_I);
        test("-194313216null", "" + sf_l + f_IN);
        test("-194313216true", "" + sf_l + sf_bl);
        test("-1943132165500", "" + sf_l + sf_s);
        test("-194313216-2900", "" + sf_l + s_sM);
        test("-194313216-194313216", "" + sf_l + sf_l);
        test("-19431321612", "" + sf_l + s_strU1);
        test("-194313216C(87)", "" + sf_l + sf_o);
        test("-19431321691", "" + sf_l + s_strU2);
        test("-19431321621", "" + sf_l + f_strU1);
        test("-19431321618", "" + sf_l + f_strU2);
        test("-194313216null", "" + sf_l + f_iAN);
        test("-194313216null", "" + sf_l + s_oN);
        test("-194313216\u045180", "" + sf_l + s_strU);
        test("-194313216C", "" + sf_l + sf_c);
        test("-19431321675", "" + sf_l + sf_str);
        test("-194313216-43", "" + sf_l + s_bM);
        test("-19431321680", "" + sf_l + sf_b);
        test("-194313216null", "" + sf_l + s_IN);
        test("-194313216-52.0", "" + sf_l + s_fM);
        test("-19431321675000000", "" + sf_l + sf_i);
        test("-19431321644", "" + sf_l + f_b);
        test("-194313216-1705032704", "" + sf_l + sf_lM);
        test("-194313216null", "" + sf_l + f_oAN);
        test("-19431321683.0", "" + sf_l + f_d);
        test("-194313216I", "" + sf_l + f_c);
        test("-19431321694.0", "" + sf_l + f_f);
        test("-19431321612.0", "" + sf_l + sf_d);
        test("-194313216-99.0", "" + sf_l + f_dM);
        test("-19431321617.0", "" + sf_l + sf_f);
        test("-194313216-84.0", "" + sf_l + sf_dM);
        test("-19431321658000000", "" + sf_l + f_i);
        test("-194313216-55000000", "" + sf_l + f_iM);
        test("-1943132161460392448", "" + sf_l + f_l);
        test("-194313216C(70)", "" + sf_l + f_o);
        test("-194313216\u04511", "" + sf_l + sf_strU);
        test("-1943132168000", "" + sf_l + f_s);
        test("-19431321618", "" + sf_l + s_str);
        test("-194313216-1000000", "" + sf_l + s_iM);
        test("-1943132161000000", "" + sf_l + sf_I);
        test("-194313216null", "" + sf_l + f_oNtS);
        test("-194313216false", "" + sf_l + f_bl);
        test("-194313216null", "" + sf_l + sf_iAN);
        test("-194313216-2000000", "" + sf_l + sf_iM);
        test("-194313216-820130816", "" + sf_l + f_lM);
        test("-194313216null", "" + sf_l + sf_oAN);
        test("-19431321625000000", "" + sf_l + s_I);
        test("12-96.0", "" + s_strU1 + s_dM);
        test("12null", "" + s_strU1 + s_oNtS);
        test("12\u045176", "" + s_strU1 + f_strU);
        test("1292", "" + s_strU1 + sf_strU2);
        test("1251", "" + s_strU1 + sf_strU1);
        test("12null", "" + s_strU1 + s_iAN);
        test("12-54", "" + s_strU1 + f_bM);
        test("12-87.0", "" + s_strU1 + f_fM);
        test("12null", "" + s_strU1 + s_oAN);
        test("1219", "" + s_strU1 + f_str);
        test("12-41", "" + s_strU1 + sf_bM);
        test("12null", "" + s_strU1 + sf_IN);
        test("12T", "" + s_strU1 + s_c);
        test("12-42.0", "" + s_strU1 + sf_fM);
        test("1225", "" + s_strU1 + s_b);
        test("12null", "" + s_strU1 + f_oN);
        test("12-1410065408", "" + s_strU1 + s_lM);
        test("128.0", "" + s_strU1 + s_d);
        test("1255.0", "" + s_strU1 + s_f);
        test("1297000000", "" + s_strU1 + s_i);
        test("12-9900", "" + s_strU1 + f_sM);
        test("12935228928", "" + s_strU1 + s_l);
        test("12-8400", "" + s_strU1 + sf_sM);
        test("12C(82)", "" + s_strU1 + s_o);
        test("12null", "" + s_strU1 + sf_oNtS);
        test("12true", "" + s_strU1 + s_bl);
        test("123900", "" + s_strU1 + s_s);
        test("12null", "" + s_strU1 + sf_oN);
        test("1294000000", "" + s_strU1 + f_I);
        test("12null", "" + s_strU1 + f_IN);
        test("12true", "" + s_strU1 + sf_bl);
        test("125500", "" + s_strU1 + sf_s);
        test("12-2900", "" + s_strU1 + s_sM);
        test("12-194313216", "" + s_strU1 + sf_l);
        test("1212", "" + s_strU1 + s_strU1);
        test("12C(87)", "" + s_strU1 + sf_o);
        test("1291", "" + s_strU1 + s_strU2);
        test("1221", "" + s_strU1 + f_strU1);
        test("1218", "" + s_strU1 + f_strU2);
        test("12null", "" + s_strU1 + f_iAN);
        test("12null", "" + s_strU1 + s_oN);
        test("12\u045180", "" + s_strU1 + s_strU);
        test("12C", "" + s_strU1 + sf_c);
        test("1275", "" + s_strU1 + sf_str);
        test("12-43", "" + s_strU1 + s_bM);
        test("1280", "" + s_strU1 + sf_b);
        test("12null", "" + s_strU1 + s_IN);
        test("12-52.0", "" + s_strU1 + s_fM);
        test("1275000000", "" + s_strU1 + sf_i);
        test("1244", "" + s_strU1 + f_b);
        test("12-1705032704", "" + s_strU1 + sf_lM);
        test("12null", "" + s_strU1 + f_oAN);
        test("1283.0", "" + s_strU1 + f_d);
        test("12I", "" + s_strU1 + f_c);
        test("1294.0", "" + s_strU1 + f_f);
        test("1212.0", "" + s_strU1 + sf_d);
        test("12-99.0", "" + s_strU1 + f_dM);
        test("1217.0", "" + s_strU1 + sf_f);
        test("12-84.0", "" + s_strU1 + sf_dM);
        test("1258000000", "" + s_strU1 + f_i);
        test("12-55000000", "" + s_strU1 + f_iM);
        test("121460392448", "" + s_strU1 + f_l);
        test("12C(70)", "" + s_strU1 + f_o);
        test("12\u04511", "" + s_strU1 + sf_strU);
        test("128000", "" + s_strU1 + f_s);
        test("1218", "" + s_strU1 + s_str);
        test("12-1000000", "" + s_strU1 + s_iM);
        test("121000000", "" + s_strU1 + sf_I);
        test("12null", "" + s_strU1 + f_oNtS);
        test("12false", "" + s_strU1 + f_bl);
        test("12null", "" + s_strU1 + sf_iAN);
        test("12-2000000", "" + s_strU1 + sf_iM);
        test("12-820130816", "" + s_strU1 + f_lM);
        test("12null", "" + s_strU1 + sf_oAN);
        test("1225000000", "" + s_strU1 + s_I);
        test("C(87)-96.0", "" + sf_o + s_dM);
        test("C(87)null", "" + sf_o + s_oNtS);
        test("C(87)\u045176", "" + sf_o + f_strU);
        test("C(87)92", "" + sf_o + sf_strU2);
        test("C(87)51", "" + sf_o + sf_strU1);
        test("C(87)null", "" + sf_o + s_iAN);
        test("C(87)-54", "" + sf_o + f_bM);
        test("C(87)-87.0", "" + sf_o + f_fM);
        test("C(87)null", "" + sf_o + s_oAN);
        test("C(87)19", "" + sf_o + f_str);
        test("C(87)-41", "" + sf_o + sf_bM);
        test("C(87)null", "" + sf_o + sf_IN);
        test("C(87)T", "" + sf_o + s_c);
        test("C(87)-42.0", "" + sf_o + sf_fM);
        test("C(87)25", "" + sf_o + s_b);
        test("C(87)null", "" + sf_o + f_oN);
        test("C(87)-1410065408", "" + sf_o + s_lM);
        test("C(87)8.0", "" + sf_o + s_d);
        test("C(87)55.0", "" + sf_o + s_f);
        test("C(87)97000000", "" + sf_o + s_i);
        test("C(87)-9900", "" + sf_o + f_sM);
        test("C(87)935228928", "" + sf_o + s_l);
        test("C(87)-8400", "" + sf_o + sf_sM);
        test("C(87)C(82)", "" + sf_o + s_o);
        test("C(87)null", "" + sf_o + sf_oNtS);
        test("C(87)true", "" + sf_o + s_bl);
        test("C(87)3900", "" + sf_o + s_s);
        test("C(87)null", "" + sf_o + sf_oN);
        test("C(87)94000000", "" + sf_o + f_I);
        test("C(87)null", "" + sf_o + f_IN);
        test("C(87)true", "" + sf_o + sf_bl);
        test("C(87)5500", "" + sf_o + sf_s);
        test("C(87)-2900", "" + sf_o + s_sM);
        test("C(87)-194313216", "" + sf_o + sf_l);
        test("C(87)12", "" + sf_o + s_strU1);
        test("C(87)C(87)", "" + sf_o + sf_o);
        test("C(87)91", "" + sf_o + s_strU2);
        test("C(87)21", "" + sf_o + f_strU1);
        test("C(87)18", "" + sf_o + f_strU2);
        test("C(87)null", "" + sf_o + f_iAN);
        test("C(87)null", "" + sf_o + s_oN);
        test("C(87)\u045180", "" + sf_o + s_strU);
        test("C(87)C", "" + sf_o + sf_c);
        test("C(87)75", "" + sf_o + sf_str);
        test("C(87)-43", "" + sf_o + s_bM);
        test("C(87)80", "" + sf_o + sf_b);
        test("C(87)null", "" + sf_o + s_IN);
        test("C(87)-52.0", "" + sf_o + s_fM);
        test("C(87)75000000", "" + sf_o + sf_i);
        test("C(87)44", "" + sf_o + f_b);
        test("C(87)-1705032704", "" + sf_o + sf_lM);
        test("C(87)null", "" + sf_o + f_oAN);
        test("C(87)83.0", "" + sf_o + f_d);
        test("C(87)I", "" + sf_o + f_c);
        test("C(87)94.0", "" + sf_o + f_f);
        test("C(87)12.0", "" + sf_o + sf_d);
        test("C(87)-99.0", "" + sf_o + f_dM);
        test("C(87)17.0", "" + sf_o + sf_f);
        test("C(87)-84.0", "" + sf_o + sf_dM);
        test("C(87)58000000", "" + sf_o + f_i);
        test("C(87)-55000000", "" + sf_o + f_iM);
        test("C(87)1460392448", "" + sf_o + f_l);
        test("C(87)C(70)", "" + sf_o + f_o);
        test("C(87)\u04511", "" + sf_o + sf_strU);
        test("C(87)8000", "" + sf_o + f_s);
        test("C(87)18", "" + sf_o + s_str);
        test("C(87)-1000000", "" + sf_o + s_iM);
        test("C(87)1000000", "" + sf_o + sf_I);
        test("C(87)null", "" + sf_o + f_oNtS);
        test("C(87)false", "" + sf_o + f_bl);
        test("C(87)null", "" + sf_o + sf_iAN);
        test("C(87)-2000000", "" + sf_o + sf_iM);
        test("C(87)-820130816", "" + sf_o + f_lM);
        test("C(87)null", "" + sf_o + sf_oAN);
        test("C(87)25000000", "" + sf_o + s_I);
        test("91-96.0", "" + s_strU2 + s_dM);
        test("91null", "" + s_strU2 + s_oNtS);
        test("91\u045176", "" + s_strU2 + f_strU);
        test("9192", "" + s_strU2 + sf_strU2);
        test("9151", "" + s_strU2 + sf_strU1);
        test("91null", "" + s_strU2 + s_iAN);
        test("91-54", "" + s_strU2 + f_bM);
        test("91-87.0", "" + s_strU2 + f_fM);
        test("91null", "" + s_strU2 + s_oAN);
        test("9119", "" + s_strU2 + f_str);
        test("91-41", "" + s_strU2 + sf_bM);
        test("91null", "" + s_strU2 + sf_IN);
        test("91T", "" + s_strU2 + s_c);
        test("91-42.0", "" + s_strU2 + sf_fM);
        test("9125", "" + s_strU2 + s_b);
        test("91null", "" + s_strU2 + f_oN);
        test("91-1410065408", "" + s_strU2 + s_lM);
        test("918.0", "" + s_strU2 + s_d);
        test("9155.0", "" + s_strU2 + s_f);
        test("9197000000", "" + s_strU2 + s_i);
        test("91-9900", "" + s_strU2 + f_sM);
        test("91935228928", "" + s_strU2 + s_l);
        test("91-8400", "" + s_strU2 + sf_sM);
        test("91C(82)", "" + s_strU2 + s_o);
        test("91null", "" + s_strU2 + sf_oNtS);
        test("91true", "" + s_strU2 + s_bl);
        test("913900", "" + s_strU2 + s_s);
        test("91null", "" + s_strU2 + sf_oN);
        test("9194000000", "" + s_strU2 + f_I);
        test("91null", "" + s_strU2 + f_IN);
        test("91true", "" + s_strU2 + sf_bl);
        test("915500", "" + s_strU2 + sf_s);
        test("91-2900", "" + s_strU2 + s_sM);
        test("91-194313216", "" + s_strU2 + sf_l);
        test("9112", "" + s_strU2 + s_strU1);
        test("91C(87)", "" + s_strU2 + sf_o);
        test("9191", "" + s_strU2 + s_strU2);
        test("9121", "" + s_strU2 + f_strU1);
        test("9118", "" + s_strU2 + f_strU2);
        test("91null", "" + s_strU2 + f_iAN);
        test("91null", "" + s_strU2 + s_oN);
        test("91\u045180", "" + s_strU2 + s_strU);
        test("91C", "" + s_strU2 + sf_c);
        test("9175", "" + s_strU2 + sf_str);
        test("91-43", "" + s_strU2 + s_bM);
        test("9180", "" + s_strU2 + sf_b);
        test("91null", "" + s_strU2 + s_IN);
        test("91-52.0", "" + s_strU2 + s_fM);
        test("9175000000", "" + s_strU2 + sf_i);
        test("9144", "" + s_strU2 + f_b);
        test("91-1705032704", "" + s_strU2 + sf_lM);
        test("91null", "" + s_strU2 + f_oAN);
        test("9183.0", "" + s_strU2 + f_d);
        test("91I", "" + s_strU2 + f_c);
        test("9194.0", "" + s_strU2 + f_f);
        test("9112.0", "" + s_strU2 + sf_d);
        test("91-99.0", "" + s_strU2 + f_dM);
        test("9117.0", "" + s_strU2 + sf_f);
        test("91-84.0", "" + s_strU2 + sf_dM);
        test("9158000000", "" + s_strU2 + f_i);
        test("91-55000000", "" + s_strU2 + f_iM);
        test("911460392448", "" + s_strU2 + f_l);
        test("91C(70)", "" + s_strU2 + f_o);
        test("91\u04511", "" + s_strU2 + sf_strU);
        test("918000", "" + s_strU2 + f_s);
        test("9118", "" + s_strU2 + s_str);
        test("91-1000000", "" + s_strU2 + s_iM);
        test("911000000", "" + s_strU2 + sf_I);
        test("91null", "" + s_strU2 + f_oNtS);
        test("91false", "" + s_strU2 + f_bl);
        test("91null", "" + s_strU2 + sf_iAN);
        test("91-2000000", "" + s_strU2 + sf_iM);
        test("91-820130816", "" + s_strU2 + f_lM);
        test("91null", "" + s_strU2 + sf_oAN);
        test("9125000000", "" + s_strU2 + s_I);
        test("21-96.0", "" + f_strU1 + s_dM);
        test("21null", "" + f_strU1 + s_oNtS);
        test("21\u045176", "" + f_strU1 + f_strU);
        test("2192", "" + f_strU1 + sf_strU2);
        test("2151", "" + f_strU1 + sf_strU1);
        test("21null", "" + f_strU1 + s_iAN);
        test("21-54", "" + f_strU1 + f_bM);
        test("21-87.0", "" + f_strU1 + f_fM);
        test("21null", "" + f_strU1 + s_oAN);
        test("2119", "" + f_strU1 + f_str);
        test("21-41", "" + f_strU1 + sf_bM);
        test("21null", "" + f_strU1 + sf_IN);
        test("21T", "" + f_strU1 + s_c);
        test("21-42.0", "" + f_strU1 + sf_fM);
        test("2125", "" + f_strU1 + s_b);
        test("21null", "" + f_strU1 + f_oN);
        test("21-1410065408", "" + f_strU1 + s_lM);
        test("218.0", "" + f_strU1 + s_d);
        test("2155.0", "" + f_strU1 + s_f);
        test("2197000000", "" + f_strU1 + s_i);
        test("21-9900", "" + f_strU1 + f_sM);
        test("21935228928", "" + f_strU1 + s_l);
        test("21-8400", "" + f_strU1 + sf_sM);
        test("21C(82)", "" + f_strU1 + s_o);
        test("21null", "" + f_strU1 + sf_oNtS);
        test("21true", "" + f_strU1 + s_bl);
        test("213900", "" + f_strU1 + s_s);
        test("21null", "" + f_strU1 + sf_oN);
        test("2194000000", "" + f_strU1 + f_I);
        test("21null", "" + f_strU1 + f_IN);
        test("21true", "" + f_strU1 + sf_bl);
        test("215500", "" + f_strU1 + sf_s);
        test("21-2900", "" + f_strU1 + s_sM);
        test("21-194313216", "" + f_strU1 + sf_l);
        test("2112", "" + f_strU1 + s_strU1);
        test("21C(87)", "" + f_strU1 + sf_o);
        test("2191", "" + f_strU1 + s_strU2);
        test("2121", "" + f_strU1 + f_strU1);
        test("2118", "" + f_strU1 + f_strU2);
        test("21null", "" + f_strU1 + f_iAN);
        test("21null", "" + f_strU1 + s_oN);
        test("21\u045180", "" + f_strU1 + s_strU);
        test("21C", "" + f_strU1 + sf_c);
        test("2175", "" + f_strU1 + sf_str);
        test("21-43", "" + f_strU1 + s_bM);
        test("2180", "" + f_strU1 + sf_b);
        test("21null", "" + f_strU1 + s_IN);
        test("21-52.0", "" + f_strU1 + s_fM);
        test("2175000000", "" + f_strU1 + sf_i);
        test("2144", "" + f_strU1 + f_b);
        test("21-1705032704", "" + f_strU1 + sf_lM);
        test("21null", "" + f_strU1 + f_oAN);
        test("2183.0", "" + f_strU1 + f_d);
        test("21I", "" + f_strU1 + f_c);
        test("2194.0", "" + f_strU1 + f_f);
        test("2112.0", "" + f_strU1 + sf_d);
        test("21-99.0", "" + f_strU1 + f_dM);
        test("2117.0", "" + f_strU1 + sf_f);
        test("21-84.0", "" + f_strU1 + sf_dM);
        test("2158000000", "" + f_strU1 + f_i);
        test("21-55000000", "" + f_strU1 + f_iM);
        test("211460392448", "" + f_strU1 + f_l);
        test("21C(70)", "" + f_strU1 + f_o);
        test("21\u04511", "" + f_strU1 + sf_strU);
        test("218000", "" + f_strU1 + f_s);
        test("2118", "" + f_strU1 + s_str);
        test("21-1000000", "" + f_strU1 + s_iM);
        test("211000000", "" + f_strU1 + sf_I);
        test("21null", "" + f_strU1 + f_oNtS);
        test("21false", "" + f_strU1 + f_bl);
        test("21null", "" + f_strU1 + sf_iAN);
        test("21-2000000", "" + f_strU1 + sf_iM);
        test("21-820130816", "" + f_strU1 + f_lM);
        test("21null", "" + f_strU1 + sf_oAN);
        test("2125000000", "" + f_strU1 + s_I);
        test("18-96.0", "" + f_strU2 + s_dM);
        test("18null", "" + f_strU2 + s_oNtS);
        test("18\u045176", "" + f_strU2 + f_strU);
        test("1892", "" + f_strU2 + sf_strU2);
        test("1851", "" + f_strU2 + sf_strU1);
        test("18null", "" + f_strU2 + s_iAN);
        test("18-54", "" + f_strU2 + f_bM);
        test("18-87.0", "" + f_strU2 + f_fM);
        test("18null", "" + f_strU2 + s_oAN);
        test("1819", "" + f_strU2 + f_str);
        test("18-41", "" + f_strU2 + sf_bM);
        test("18null", "" + f_strU2 + sf_IN);
        test("18T", "" + f_strU2 + s_c);
        test("18-42.0", "" + f_strU2 + sf_fM);
        test("1825", "" + f_strU2 + s_b);
        test("18null", "" + f_strU2 + f_oN);
        test("18-1410065408", "" + f_strU2 + s_lM);
        test("188.0", "" + f_strU2 + s_d);
        test("1855.0", "" + f_strU2 + s_f);
        test("1897000000", "" + f_strU2 + s_i);
        test("18-9900", "" + f_strU2 + f_sM);
        test("18935228928", "" + f_strU2 + s_l);
        test("18-8400", "" + f_strU2 + sf_sM);
        test("18C(82)", "" + f_strU2 + s_o);
        test("18null", "" + f_strU2 + sf_oNtS);
        test("18true", "" + f_strU2 + s_bl);
        test("183900", "" + f_strU2 + s_s);
        test("18null", "" + f_strU2 + sf_oN);
        test("1894000000", "" + f_strU2 + f_I);
        test("18null", "" + f_strU2 + f_IN);
        test("18true", "" + f_strU2 + sf_bl);
        test("185500", "" + f_strU2 + sf_s);
        test("18-2900", "" + f_strU2 + s_sM);
        test("18-194313216", "" + f_strU2 + sf_l);
        test("1812", "" + f_strU2 + s_strU1);
        test("18C(87)", "" + f_strU2 + sf_o);
        test("1891", "" + f_strU2 + s_strU2);
        test("1821", "" + f_strU2 + f_strU1);
        test("1818", "" + f_strU2 + f_strU2);
        test("18null", "" + f_strU2 + f_iAN);
        test("18null", "" + f_strU2 + s_oN);
        test("18\u045180", "" + f_strU2 + s_strU);
        test("18C", "" + f_strU2 + sf_c);
        test("1875", "" + f_strU2 + sf_str);
        test("18-43", "" + f_strU2 + s_bM);
        test("1880", "" + f_strU2 + sf_b);
        test("18null", "" + f_strU2 + s_IN);
        test("18-52.0", "" + f_strU2 + s_fM);
        test("1875000000", "" + f_strU2 + sf_i);
        test("1844", "" + f_strU2 + f_b);
        test("18-1705032704", "" + f_strU2 + sf_lM);
        test("18null", "" + f_strU2 + f_oAN);
        test("1883.0", "" + f_strU2 + f_d);
        test("18I", "" + f_strU2 + f_c);
        test("1894.0", "" + f_strU2 + f_f);
        test("1812.0", "" + f_strU2 + sf_d);
        test("18-99.0", "" + f_strU2 + f_dM);
        test("1817.0", "" + f_strU2 + sf_f);
        test("18-84.0", "" + f_strU2 + sf_dM);
        test("1858000000", "" + f_strU2 + f_i);
        test("18-55000000", "" + f_strU2 + f_iM);
        test("181460392448", "" + f_strU2 + f_l);
        test("18C(70)", "" + f_strU2 + f_o);
        test("18\u04511", "" + f_strU2 + sf_strU);
        test("188000", "" + f_strU2 + f_s);
        test("1818", "" + f_strU2 + s_str);
        test("18-1000000", "" + f_strU2 + s_iM);
        test("181000000", "" + f_strU2 + sf_I);
        test("18null", "" + f_strU2 + f_oNtS);
        test("18false", "" + f_strU2 + f_bl);
        test("18null", "" + f_strU2 + sf_iAN);
        test("18-2000000", "" + f_strU2 + sf_iM);
        test("18-820130816", "" + f_strU2 + f_lM);
        test("18null", "" + f_strU2 + sf_oAN);
        test("1825000000", "" + f_strU2 + s_I);
    }

    public void run3() {
        test("null-96.0", "" + f_iAN + s_dM);
        test("nullnull", "" + f_iAN + s_oNtS);
        test("null\u045176", "" + f_iAN + f_strU);
        test("null92", "" + f_iAN + sf_strU2);
        test("null51", "" + f_iAN + sf_strU1);
        test("nullnull", "" + f_iAN + s_iAN);
        test("null-54", "" + f_iAN + f_bM);
        test("null-87.0", "" + f_iAN + f_fM);
        test("nullnull", "" + f_iAN + s_oAN);
        test("null19", "" + f_iAN + f_str);
        test("null-41", "" + f_iAN + sf_bM);
        test("nullnull", "" + f_iAN + sf_IN);
        test("nullT", "" + f_iAN + s_c);
        test("null-42.0", "" + f_iAN + sf_fM);
        test("null25", "" + f_iAN + s_b);
        test("nullnull", "" + f_iAN + f_oN);
        test("null-1410065408", "" + f_iAN + s_lM);
        test("null8.0", "" + f_iAN + s_d);
        test("null55.0", "" + f_iAN + s_f);
        test("null97000000", "" + f_iAN + s_i);
        test("null-9900", "" + f_iAN + f_sM);
        test("null935228928", "" + f_iAN + s_l);
        test("null-8400", "" + f_iAN + sf_sM);
        test("nullC(82)", "" + f_iAN + s_o);
        test("nullnull", "" + f_iAN + sf_oNtS);
        test("nulltrue", "" + f_iAN + s_bl);
        test("null3900", "" + f_iAN + s_s);
        test("nullnull", "" + f_iAN + sf_oN);
        test("null94000000", "" + f_iAN + f_I);
        test("nullnull", "" + f_iAN + f_IN);
        test("nulltrue", "" + f_iAN + sf_bl);
        test("null5500", "" + f_iAN + sf_s);
        test("null-2900", "" + f_iAN + s_sM);
        test("null-194313216", "" + f_iAN + sf_l);
        test("null12", "" + f_iAN + s_strU1);
        test("nullC(87)", "" + f_iAN + sf_o);
        test("null91", "" + f_iAN + s_strU2);
        test("null21", "" + f_iAN + f_strU1);
        test("null18", "" + f_iAN + f_strU2);
        test("nullnull", "" + f_iAN + f_iAN);
        test("nullnull", "" + f_iAN + s_oN);
        test("null\u045180", "" + f_iAN + s_strU);
        test("nullC", "" + f_iAN + sf_c);
        test("null75", "" + f_iAN + sf_str);
        test("null-43", "" + f_iAN + s_bM);
        test("null80", "" + f_iAN + sf_b);
        test("nullnull", "" + f_iAN + s_IN);
        test("null-52.0", "" + f_iAN + s_fM);
        test("null75000000", "" + f_iAN + sf_i);
        test("null44", "" + f_iAN + f_b);
        test("null-1705032704", "" + f_iAN + sf_lM);
        test("nullnull", "" + f_iAN + f_oAN);
        test("null83.0", "" + f_iAN + f_d);
        test("nullI", "" + f_iAN + f_c);
        test("null94.0", "" + f_iAN + f_f);
        test("null12.0", "" + f_iAN + sf_d);
        test("null-99.0", "" + f_iAN + f_dM);
        test("null17.0", "" + f_iAN + sf_f);
        test("null-84.0", "" + f_iAN + sf_dM);
        test("null58000000", "" + f_iAN + f_i);
        test("null-55000000", "" + f_iAN + f_iM);
        test("null1460392448", "" + f_iAN + f_l);
        test("nullC(70)", "" + f_iAN + f_o);
        test("null\u04511", "" + f_iAN + sf_strU);
        test("null8000", "" + f_iAN + f_s);
        test("null18", "" + f_iAN + s_str);
        test("null-1000000", "" + f_iAN + s_iM);
        test("null1000000", "" + f_iAN + sf_I);
        test("nullnull", "" + f_iAN + f_oNtS);
        test("nullfalse", "" + f_iAN + f_bl);
        test("nullnull", "" + f_iAN + sf_iAN);
        test("null-2000000", "" + f_iAN + sf_iM);
        test("null-820130816", "" + f_iAN + f_lM);
        test("nullnull", "" + f_iAN + sf_oAN);
        test("null25000000", "" + f_iAN + s_I);
        test("null-96.0", "" + s_oN + s_dM);
        test("nullnull", "" + s_oN + s_oNtS);
        test("null\u045176", "" + s_oN + f_strU);
        test("null92", "" + s_oN + sf_strU2);
        test("null51", "" + s_oN + sf_strU1);
        test("nullnull", "" + s_oN + s_iAN);
        test("null-54", "" + s_oN + f_bM);
        test("null-87.0", "" + s_oN + f_fM);
        test("nullnull", "" + s_oN + s_oAN);
        test("null19", "" + s_oN + f_str);
        test("null-41", "" + s_oN + sf_bM);
        test("nullnull", "" + s_oN + sf_IN);
        test("nullT", "" + s_oN + s_c);
        test("null-42.0", "" + s_oN + sf_fM);
        test("null25", "" + s_oN + s_b);
        test("nullnull", "" + s_oN + f_oN);
        test("null-1410065408", "" + s_oN + s_lM);
        test("null8.0", "" + s_oN + s_d);
        test("null55.0", "" + s_oN + s_f);
        test("null97000000", "" + s_oN + s_i);
        test("null-9900", "" + s_oN + f_sM);
        test("null935228928", "" + s_oN + s_l);
        test("null-8400", "" + s_oN + sf_sM);
        test("nullC(82)", "" + s_oN + s_o);
        test("nullnull", "" + s_oN + sf_oNtS);
        test("nulltrue", "" + s_oN + s_bl);
        test("null3900", "" + s_oN + s_s);
        test("nullnull", "" + s_oN + sf_oN);
        test("null94000000", "" + s_oN + f_I);
        test("nullnull", "" + s_oN + f_IN);
        test("nulltrue", "" + s_oN + sf_bl);
        test("null5500", "" + s_oN + sf_s);
        test("null-2900", "" + s_oN + s_sM);
        test("null-194313216", "" + s_oN + sf_l);
        test("null12", "" + s_oN + s_strU1);
        test("nullC(87)", "" + s_oN + sf_o);
        test("null91", "" + s_oN + s_strU2);
        test("null21", "" + s_oN + f_strU1);
        test("null18", "" + s_oN + f_strU2);
        test("nullnull", "" + s_oN + f_iAN);
        test("nullnull", "" + s_oN + s_oN);
        test("null\u045180", "" + s_oN + s_strU);
        test("nullC", "" + s_oN + sf_c);
        test("null75", "" + s_oN + sf_str);
        test("null-43", "" + s_oN + s_bM);
        test("null80", "" + s_oN + sf_b);
        test("nullnull", "" + s_oN + s_IN);
        test("null-52.0", "" + s_oN + s_fM);
        test("null75000000", "" + s_oN + sf_i);
        test("null44", "" + s_oN + f_b);
        test("null-1705032704", "" + s_oN + sf_lM);
        test("nullnull", "" + s_oN + f_oAN);
        test("null83.0", "" + s_oN + f_d);
        test("nullI", "" + s_oN + f_c);
        test("null94.0", "" + s_oN + f_f);
        test("null12.0", "" + s_oN + sf_d);
        test("null-99.0", "" + s_oN + f_dM);
        test("null17.0", "" + s_oN + sf_f);
        test("null-84.0", "" + s_oN + sf_dM);
        test("null58000000", "" + s_oN + f_i);
        test("null-55000000", "" + s_oN + f_iM);
        test("null1460392448", "" + s_oN + f_l);
        test("nullC(70)", "" + s_oN + f_o);
        test("null\u04511", "" + s_oN + sf_strU);
        test("null8000", "" + s_oN + f_s);
        test("null18", "" + s_oN + s_str);
        test("null-1000000", "" + s_oN + s_iM);
        test("null1000000", "" + s_oN + sf_I);
        test("nullnull", "" + s_oN + f_oNtS);
        test("nullfalse", "" + s_oN + f_bl);
        test("nullnull", "" + s_oN + sf_iAN);
        test("null-2000000", "" + s_oN + sf_iM);
        test("null-820130816", "" + s_oN + f_lM);
        test("nullnull", "" + s_oN + sf_oAN);
        test("null25000000", "" + s_oN + s_I);
        test("\u045180-96.0", "" + s_strU + s_dM);
        test("\u045180null", "" + s_strU + s_oNtS);
        test("\u045180\u045176", "" + s_strU + f_strU);
        test("\u04518092", "" + s_strU + sf_strU2);
        test("\u04518051", "" + s_strU + sf_strU1);
        test("\u045180null", "" + s_strU + s_iAN);
        test("\u045180-54", "" + s_strU + f_bM);
        test("\u045180-87.0", "" + s_strU + f_fM);
        test("\u045180null", "" + s_strU + s_oAN);
        test("\u04518019", "" + s_strU + f_str);
        test("\u045180-41", "" + s_strU + sf_bM);
        test("\u045180null", "" + s_strU + sf_IN);
        test("\u045180T", "" + s_strU + s_c);
        test("\u045180-42.0", "" + s_strU + sf_fM);
        test("\u04518025", "" + s_strU + s_b);
        test("\u045180null", "" + s_strU + f_oN);
        test("\u045180-1410065408", "" + s_strU + s_lM);
        test("\u0451808.0", "" + s_strU + s_d);
        test("\u04518055.0", "" + s_strU + s_f);
        test("\u04518097000000", "" + s_strU + s_i);
        test("\u045180-9900", "" + s_strU + f_sM);
        test("\u045180935228928", "" + s_strU + s_l);
        test("\u045180-8400", "" + s_strU + sf_sM);
        test("\u045180C(82)", "" + s_strU + s_o);
        test("\u045180null", "" + s_strU + sf_oNtS);
        test("\u045180true", "" + s_strU + s_bl);
        test("\u0451803900", "" + s_strU + s_s);
        test("\u045180null", "" + s_strU + sf_oN);
        test("\u04518094000000", "" + s_strU + f_I);
        test("\u045180null", "" + s_strU + f_IN);
        test("\u045180true", "" + s_strU + sf_bl);
        test("\u0451805500", "" + s_strU + sf_s);
        test("\u045180-2900", "" + s_strU + s_sM);
        test("\u045180-194313216", "" + s_strU + sf_l);
        test("\u04518012", "" + s_strU + s_strU1);
        test("\u045180C(87)", "" + s_strU + sf_o);
        test("\u04518091", "" + s_strU + s_strU2);
        test("\u04518021", "" + s_strU + f_strU1);
        test("\u04518018", "" + s_strU + f_strU2);
        test("\u045180null", "" + s_strU + f_iAN);
        test("\u045180null", "" + s_strU + s_oN);
        test("\u045180\u045180", "" + s_strU + s_strU);
        test("\u045180C", "" + s_strU + sf_c);
        test("\u04518075", "" + s_strU + sf_str);
        test("\u045180-43", "" + s_strU + s_bM);
        test("\u04518080", "" + s_strU + sf_b);
        test("\u045180null", "" + s_strU + s_IN);
        test("\u045180-52.0", "" + s_strU + s_fM);
        test("\u04518075000000", "" + s_strU + sf_i);
        test("\u04518044", "" + s_strU + f_b);
        test("\u045180-1705032704", "" + s_strU + sf_lM);
        test("\u045180null", "" + s_strU + f_oAN);
        test("\u04518083.0", "" + s_strU + f_d);
        test("\u045180I", "" + s_strU + f_c);
        test("\u04518094.0", "" + s_strU + f_f);
        test("\u04518012.0", "" + s_strU + sf_d);
        test("\u045180-99.0", "" + s_strU + f_dM);
        test("\u04518017.0", "" + s_strU + sf_f);
        test("\u045180-84.0", "" + s_strU + sf_dM);
        test("\u04518058000000", "" + s_strU + f_i);
        test("\u045180-55000000", "" + s_strU + f_iM);
        test("\u0451801460392448", "" + s_strU + f_l);
        test("\u045180C(70)", "" + s_strU + f_o);
        test("\u045180\u04511", "" + s_strU + sf_strU);
        test("\u0451808000", "" + s_strU + f_s);
        test("\u04518018", "" + s_strU + s_str);
        test("\u045180-1000000", "" + s_strU + s_iM);
        test("\u0451801000000", "" + s_strU + sf_I);
        test("\u045180null", "" + s_strU + f_oNtS);
        test("\u045180false", "" + s_strU + f_bl);
        test("\u045180null", "" + s_strU + sf_iAN);
        test("\u045180-2000000", "" + s_strU + sf_iM);
        test("\u045180-820130816", "" + s_strU + f_lM);
        test("\u045180null", "" + s_strU + sf_oAN);
        test("\u04518025000000", "" + s_strU + s_I);
        test("C-96.0", "" + sf_c + s_dM);
        test("Cnull", "" + sf_c + s_oNtS);
        test("C\u045176", "" + sf_c + f_strU);
        test("C92", "" + sf_c + sf_strU2);
        test("C51", "" + sf_c + sf_strU1);
        test("Cnull", "" + sf_c + s_iAN);
        test("C-54", "" + sf_c + f_bM);
        test("C-87.0", "" + sf_c + f_fM);
        test("Cnull", "" + sf_c + s_oAN);
        test("C19", "" + sf_c + f_str);
        test("C-41", "" + sf_c + sf_bM);
        test("Cnull", "" + sf_c + sf_IN);
        test("CT", "" + sf_c + s_c);
        test("C-42.0", "" + sf_c + sf_fM);
        test("C25", "" + sf_c + s_b);
        test("Cnull", "" + sf_c + f_oN);
        test("C-1410065408", "" + sf_c + s_lM);
        test("C8.0", "" + sf_c + s_d);
        test("C55.0", "" + sf_c + s_f);
        test("C97000000", "" + sf_c + s_i);
        test("C-9900", "" + sf_c + f_sM);
        test("C935228928", "" + sf_c + s_l);
        test("C-8400", "" + sf_c + sf_sM);
        test("CC(82)", "" + sf_c + s_o);
        test("Cnull", "" + sf_c + sf_oNtS);
        test("Ctrue", "" + sf_c + s_bl);
        test("C3900", "" + sf_c + s_s);
        test("Cnull", "" + sf_c + sf_oN);
        test("C94000000", "" + sf_c + f_I);
        test("Cnull", "" + sf_c + f_IN);
        test("Ctrue", "" + sf_c + sf_bl);
        test("C5500", "" + sf_c + sf_s);
        test("C-2900", "" + sf_c + s_sM);
        test("C-194313216", "" + sf_c + sf_l);
        test("C12", "" + sf_c + s_strU1);
        test("CC(87)", "" + sf_c + sf_o);
        test("C91", "" + sf_c + s_strU2);
        test("C21", "" + sf_c + f_strU1);
        test("C18", "" + sf_c + f_strU2);
        test("Cnull", "" + sf_c + f_iAN);
        test("Cnull", "" + sf_c + s_oN);
        test("C\u045180", "" + sf_c + s_strU);
        test("CC", "" + sf_c + sf_c);
        test("C75", "" + sf_c + sf_str);
        test("C-43", "" + sf_c + s_bM);
        test("C80", "" + sf_c + sf_b);
        test("Cnull", "" + sf_c + s_IN);
        test("C-52.0", "" + sf_c + s_fM);
        test("C75000000", "" + sf_c + sf_i);
        test("C44", "" + sf_c + f_b);
        test("C-1705032704", "" + sf_c + sf_lM);
        test("Cnull", "" + sf_c + f_oAN);
        test("C83.0", "" + sf_c + f_d);
        test("CI", "" + sf_c + f_c);
        test("C94.0", "" + sf_c + f_f);
        test("C12.0", "" + sf_c + sf_d);
        test("C-99.0", "" + sf_c + f_dM);
        test("C17.0", "" + sf_c + sf_f);
        test("C-84.0", "" + sf_c + sf_dM);
        test("C58000000", "" + sf_c + f_i);
        test("C-55000000", "" + sf_c + f_iM);
        test("C1460392448", "" + sf_c + f_l);
        test("CC(70)", "" + sf_c + f_o);
        test("C\u04511", "" + sf_c + sf_strU);
        test("C8000", "" + sf_c + f_s);
        test("C18", "" + sf_c + s_str);
        test("C-1000000", "" + sf_c + s_iM);
        test("C1000000", "" + sf_c + sf_I);
        test("Cnull", "" + sf_c + f_oNtS);
        test("Cfalse", "" + sf_c + f_bl);
        test("Cnull", "" + sf_c + sf_iAN);
        test("C-2000000", "" + sf_c + sf_iM);
        test("C-820130816", "" + sf_c + f_lM);
        test("Cnull", "" + sf_c + sf_oAN);
        test("C25000000", "" + sf_c + s_I);
        test("75-96.0", "" + sf_str + s_dM);
        test("75null", "" + sf_str + s_oNtS);
        test("75\u045176", "" + sf_str + f_strU);
        test("7592", "" + sf_str + sf_strU2);
        test("7551", "" + sf_str + sf_strU1);
        test("75null", "" + sf_str + s_iAN);
        test("75-54", "" + sf_str + f_bM);
        test("75-87.0", "" + sf_str + f_fM);
        test("75null", "" + sf_str + s_oAN);
        test("7519", "" + sf_str + f_str);
        test("75-41", "" + sf_str + sf_bM);
        test("75null", "" + sf_str + sf_IN);
        test("75T", "" + sf_str + s_c);
        test("75-42.0", "" + sf_str + sf_fM);
        test("7525", "" + sf_str + s_b);
        test("75null", "" + sf_str + f_oN);
        test("75-1410065408", "" + sf_str + s_lM);
        test("758.0", "" + sf_str + s_d);
        test("7555.0", "" + sf_str + s_f);
        test("7597000000", "" + sf_str + s_i);
        test("75-9900", "" + sf_str + f_sM);
        test("75935228928", "" + sf_str + s_l);
        test("75-8400", "" + sf_str + sf_sM);
        test("75C(82)", "" + sf_str + s_o);
        test("75null", "" + sf_str + sf_oNtS);
        test("75true", "" + sf_str + s_bl);
        test("753900", "" + sf_str + s_s);
        test("75null", "" + sf_str + sf_oN);
        test("7594000000", "" + sf_str + f_I);
        test("75null", "" + sf_str + f_IN);
        test("75true", "" + sf_str + sf_bl);
        test("755500", "" + sf_str + sf_s);
        test("75-2900", "" + sf_str + s_sM);
        test("75-194313216", "" + sf_str + sf_l);
        test("7512", "" + sf_str + s_strU1);
        test("75C(87)", "" + sf_str + sf_o);
        test("7591", "" + sf_str + s_strU2);
        test("7521", "" + sf_str + f_strU1);
        test("7518", "" + sf_str + f_strU2);
        test("75null", "" + sf_str + f_iAN);
        test("75null", "" + sf_str + s_oN);
        test("75\u045180", "" + sf_str + s_strU);
        test("75C", "" + sf_str + sf_c);
        test("7575", "" + sf_str + sf_str);
        test("75-43", "" + sf_str + s_bM);
        test("7580", "" + sf_str + sf_b);
        test("75null", "" + sf_str + s_IN);
        test("75-52.0", "" + sf_str + s_fM);
        test("7575000000", "" + sf_str + sf_i);
        test("7544", "" + sf_str + f_b);
        test("75-1705032704", "" + sf_str + sf_lM);
        test("75null", "" + sf_str + f_oAN);
        test("7583.0", "" + sf_str + f_d);
        test("75I", "" + sf_str + f_c);
        test("7594.0", "" + sf_str + f_f);
        test("7512.0", "" + sf_str + sf_d);
        test("75-99.0", "" + sf_str + f_dM);
        test("7517.0", "" + sf_str + sf_f);
        test("75-84.0", "" + sf_str + sf_dM);
        test("7558000000", "" + sf_str + f_i);
        test("75-55000000", "" + sf_str + f_iM);
        test("751460392448", "" + sf_str + f_l);
        test("75C(70)", "" + sf_str + f_o);
        test("75\u04511", "" + sf_str + sf_strU);
        test("758000", "" + sf_str + f_s);
        test("7518", "" + sf_str + s_str);
        test("75-1000000", "" + sf_str + s_iM);
        test("751000000", "" + sf_str + sf_I);
        test("75null", "" + sf_str + f_oNtS);
        test("75false", "" + sf_str + f_bl);
        test("75null", "" + sf_str + sf_iAN);
        test("75-2000000", "" + sf_str + sf_iM);
        test("75-820130816", "" + sf_str + f_lM);
        test("75null", "" + sf_str + sf_oAN);
        test("7525000000", "" + sf_str + s_I);
        test("-43-96.0", "" + s_bM + s_dM);
        test("-43null", "" + s_bM + s_oNtS);
        test("-43\u045176", "" + s_bM + f_strU);
        test("-4392", "" + s_bM + sf_strU2);
        test("-4351", "" + s_bM + sf_strU1);
        test("-43null", "" + s_bM + s_iAN);
        test("-43-54", "" + s_bM + f_bM);
        test("-43-87.0", "" + s_bM + f_fM);
        test("-43null", "" + s_bM + s_oAN);
        test("-4319", "" + s_bM + f_str);
        test("-43-41", "" + s_bM + sf_bM);
        test("-43null", "" + s_bM + sf_IN);
        test("-43T", "" + s_bM + s_c);
        test("-43-42.0", "" + s_bM + sf_fM);
        test("-4325", "" + s_bM + s_b);
        test("-43null", "" + s_bM + f_oN);
        test("-43-1410065408", "" + s_bM + s_lM);
        test("-438.0", "" + s_bM + s_d);
        test("-4355.0", "" + s_bM + s_f);
        test("-4397000000", "" + s_bM + s_i);
        test("-43-9900", "" + s_bM + f_sM);
        test("-43935228928", "" + s_bM + s_l);
        test("-43-8400", "" + s_bM + sf_sM);
        test("-43C(82)", "" + s_bM + s_o);
        test("-43null", "" + s_bM + sf_oNtS);
        test("-43true", "" + s_bM + s_bl);
        test("-433900", "" + s_bM + s_s);
        test("-43null", "" + s_bM + sf_oN);
        test("-4394000000", "" + s_bM + f_I);
        test("-43null", "" + s_bM + f_IN);
        test("-43true", "" + s_bM + sf_bl);
        test("-435500", "" + s_bM + sf_s);
        test("-43-2900", "" + s_bM + s_sM);
        test("-43-194313216", "" + s_bM + sf_l);
        test("-4312", "" + s_bM + s_strU1);
        test("-43C(87)", "" + s_bM + sf_o);
        test("-4391", "" + s_bM + s_strU2);
        test("-4321", "" + s_bM + f_strU1);
        test("-4318", "" + s_bM + f_strU2);
        test("-43null", "" + s_bM + f_iAN);
        test("-43null", "" + s_bM + s_oN);
        test("-43\u045180", "" + s_bM + s_strU);
        test("-43C", "" + s_bM + sf_c);
        test("-4375", "" + s_bM + sf_str);
        test("-43-43", "" + s_bM + s_bM);
        test("-4380", "" + s_bM + sf_b);
        test("-43null", "" + s_bM + s_IN);
        test("-43-52.0", "" + s_bM + s_fM);
        test("-4375000000", "" + s_bM + sf_i);
        test("-4344", "" + s_bM + f_b);
        test("-43-1705032704", "" + s_bM + sf_lM);
        test("-43null", "" + s_bM + f_oAN);
        test("-4383.0", "" + s_bM + f_d);
        test("-43I", "" + s_bM + f_c);
        test("-4394.0", "" + s_bM + f_f);
        test("-4312.0", "" + s_bM + sf_d);
        test("-43-99.0", "" + s_bM + f_dM);
        test("-4317.0", "" + s_bM + sf_f);
        test("-43-84.0", "" + s_bM + sf_dM);
        test("-4358000000", "" + s_bM + f_i);
        test("-43-55000000", "" + s_bM + f_iM);
        test("-431460392448", "" + s_bM + f_l);
        test("-43C(70)", "" + s_bM + f_o);
        test("-43\u04511", "" + s_bM + sf_strU);
        test("-438000", "" + s_bM + f_s);
        test("-4318", "" + s_bM + s_str);
        test("-43-1000000", "" + s_bM + s_iM);
        test("-431000000", "" + s_bM + sf_I);
        test("-43null", "" + s_bM + f_oNtS);
        test("-43false", "" + s_bM + f_bl);
        test("-43null", "" + s_bM + sf_iAN);
        test("-43-2000000", "" + s_bM + sf_iM);
        test("-43-820130816", "" + s_bM + f_lM);
        test("-43null", "" + s_bM + sf_oAN);
        test("-4325000000", "" + s_bM + s_I);
        test("80-96.0", "" + sf_b + s_dM);
        test("80null", "" + sf_b + s_oNtS);
        test("80\u045176", "" + sf_b + f_strU);
        test("8092", "" + sf_b + sf_strU2);
        test("8051", "" + sf_b + sf_strU1);
        test("80null", "" + sf_b + s_iAN);
        test("80-54", "" + sf_b + f_bM);
        test("80-87.0", "" + sf_b + f_fM);
        test("80null", "" + sf_b + s_oAN);
        test("8019", "" + sf_b + f_str);
        test("80-41", "" + sf_b + sf_bM);
        test("80null", "" + sf_b + sf_IN);
        test("80T", "" + sf_b + s_c);
        test("80-42.0", "" + sf_b + sf_fM);
        test("8025", "" + sf_b + s_b);
        test("80null", "" + sf_b + f_oN);
        test("80-1410065408", "" + sf_b + s_lM);
        test("808.0", "" + sf_b + s_d);
        test("8055.0", "" + sf_b + s_f);
        test("8097000000", "" + sf_b + s_i);
        test("80-9900", "" + sf_b + f_sM);
        test("80935228928", "" + sf_b + s_l);
        test("80-8400", "" + sf_b + sf_sM);
        test("80C(82)", "" + sf_b + s_o);
        test("80null", "" + sf_b + sf_oNtS);
        test("80true", "" + sf_b + s_bl);
        test("803900", "" + sf_b + s_s);
        test("80null", "" + sf_b + sf_oN);
        test("8094000000", "" + sf_b + f_I);
        test("80null", "" + sf_b + f_IN);
        test("80true", "" + sf_b + sf_bl);
        test("805500", "" + sf_b + sf_s);
        test("80-2900", "" + sf_b + s_sM);
        test("80-194313216", "" + sf_b + sf_l);
        test("8012", "" + sf_b + s_strU1);
        test("80C(87)", "" + sf_b + sf_o);
        test("8091", "" + sf_b + s_strU2);
        test("8021", "" + sf_b + f_strU1);
        test("8018", "" + sf_b + f_strU2);
        test("80null", "" + sf_b + f_iAN);
        test("80null", "" + sf_b + s_oN);
        test("80\u045180", "" + sf_b + s_strU);
        test("80C", "" + sf_b + sf_c);
        test("8075", "" + sf_b + sf_str);
        test("80-43", "" + sf_b + s_bM);
        test("8080", "" + sf_b + sf_b);
        test("80null", "" + sf_b + s_IN);
        test("80-52.0", "" + sf_b + s_fM);
        test("8075000000", "" + sf_b + sf_i);
        test("8044", "" + sf_b + f_b);
        test("80-1705032704", "" + sf_b + sf_lM);
        test("80null", "" + sf_b + f_oAN);
        test("8083.0", "" + sf_b + f_d);
        test("80I", "" + sf_b + f_c);
        test("8094.0", "" + sf_b + f_f);
        test("8012.0", "" + sf_b + sf_d);
        test("80-99.0", "" + sf_b + f_dM);
        test("8017.0", "" + sf_b + sf_f);
        test("80-84.0", "" + sf_b + sf_dM);
        test("8058000000", "" + sf_b + f_i);
        test("80-55000000", "" + sf_b + f_iM);
        test("801460392448", "" + sf_b + f_l);
        test("80C(70)", "" + sf_b + f_o);
        test("80\u04511", "" + sf_b + sf_strU);
        test("808000", "" + sf_b + f_s);
        test("8018", "" + sf_b + s_str);
        test("80-1000000", "" + sf_b + s_iM);
        test("801000000", "" + sf_b + sf_I);
        test("80null", "" + sf_b + f_oNtS);
        test("80false", "" + sf_b + f_bl);
        test("80null", "" + sf_b + sf_iAN);
        test("80-2000000", "" + sf_b + sf_iM);
        test("80-820130816", "" + sf_b + f_lM);
        test("80null", "" + sf_b + sf_oAN);
        test("8025000000", "" + sf_b + s_I);
        test("null-96.0", "" + s_IN + s_dM);
        test("nullnull", "" + s_IN + s_oNtS);
        test("null\u045176", "" + s_IN + f_strU);
        test("null92", "" + s_IN + sf_strU2);
        test("null51", "" + s_IN + sf_strU1);
        test("nullnull", "" + s_IN + s_iAN);
        test("null-54", "" + s_IN + f_bM);
        test("null-87.0", "" + s_IN + f_fM);
        test("nullnull", "" + s_IN + s_oAN);
        test("null19", "" + s_IN + f_str);
        test("null-41", "" + s_IN + sf_bM);
        test("nullnull", "" + s_IN + sf_IN);
        test("nullT", "" + s_IN + s_c);
        test("null-42.0", "" + s_IN + sf_fM);
        test("null25", "" + s_IN + s_b);
        test("nullnull", "" + s_IN + f_oN);
        test("null-1410065408", "" + s_IN + s_lM);
        test("null8.0", "" + s_IN + s_d);
        test("null55.0", "" + s_IN + s_f);
        test("null97000000", "" + s_IN + s_i);
        test("null-9900", "" + s_IN + f_sM);
        test("null935228928", "" + s_IN + s_l);
        test("null-8400", "" + s_IN + sf_sM);
        test("nullC(82)", "" + s_IN + s_o);
        test("nullnull", "" + s_IN + sf_oNtS);
        test("nulltrue", "" + s_IN + s_bl);
        test("null3900", "" + s_IN + s_s);
        test("nullnull", "" + s_IN + sf_oN);
        test("null94000000", "" + s_IN + f_I);
        test("nullnull", "" + s_IN + f_IN);
        test("nulltrue", "" + s_IN + sf_bl);
        test("null5500", "" + s_IN + sf_s);
        test("null-2900", "" + s_IN + s_sM);
        test("null-194313216", "" + s_IN + sf_l);
        test("null12", "" + s_IN + s_strU1);
        test("nullC(87)", "" + s_IN + sf_o);
        test("null91", "" + s_IN + s_strU2);
        test("null21", "" + s_IN + f_strU1);
        test("null18", "" + s_IN + f_strU2);
        test("nullnull", "" + s_IN + f_iAN);
        test("nullnull", "" + s_IN + s_oN);
        test("null\u045180", "" + s_IN + s_strU);
        test("nullC", "" + s_IN + sf_c);
        test("null75", "" + s_IN + sf_str);
        test("null-43", "" + s_IN + s_bM);
        test("null80", "" + s_IN + sf_b);
        test("nullnull", "" + s_IN + s_IN);
        test("null-52.0", "" + s_IN + s_fM);
        test("null75000000", "" + s_IN + sf_i);
        test("null44", "" + s_IN + f_b);
        test("null-1705032704", "" + s_IN + sf_lM);
        test("nullnull", "" + s_IN + f_oAN);
        test("null83.0", "" + s_IN + f_d);
        test("nullI", "" + s_IN + f_c);
        test("null94.0", "" + s_IN + f_f);
        test("null12.0", "" + s_IN + sf_d);
        test("null-99.0", "" + s_IN + f_dM);
        test("null17.0", "" + s_IN + sf_f);
        test("null-84.0", "" + s_IN + sf_dM);
        test("null58000000", "" + s_IN + f_i);
        test("null-55000000", "" + s_IN + f_iM);
        test("null1460392448", "" + s_IN + f_l);
        test("nullC(70)", "" + s_IN + f_o);
        test("null\u04511", "" + s_IN + sf_strU);
        test("null8000", "" + s_IN + f_s);
        test("null18", "" + s_IN + s_str);
        test("null-1000000", "" + s_IN + s_iM);
        test("null1000000", "" + s_IN + sf_I);
        test("nullnull", "" + s_IN + f_oNtS);
        test("nullfalse", "" + s_IN + f_bl);
        test("nullnull", "" + s_IN + sf_iAN);
        test("null-2000000", "" + s_IN + sf_iM);
        test("null-820130816", "" + s_IN + f_lM);
        test("nullnull", "" + s_IN + sf_oAN);
        test("null25000000", "" + s_IN + s_I);
        test("-52.0-96.0", "" + s_fM + s_dM);
        test("-52.0null", "" + s_fM + s_oNtS);
        test("-52.0\u045176", "" + s_fM + f_strU);
        test("-52.092", "" + s_fM + sf_strU2);
        test("-52.051", "" + s_fM + sf_strU1);
        test("-52.0null", "" + s_fM + s_iAN);
        test("-52.0-54", "" + s_fM + f_bM);
        test("-52.0-87.0", "" + s_fM + f_fM);
        test("-52.0null", "" + s_fM + s_oAN);
        test("-52.019", "" + s_fM + f_str);
        test("-52.0-41", "" + s_fM + sf_bM);
        test("-52.0null", "" + s_fM + sf_IN);
        test("-52.0T", "" + s_fM + s_c);
        test("-52.0-42.0", "" + s_fM + sf_fM);
        test("-52.025", "" + s_fM + s_b);
        test("-52.0null", "" + s_fM + f_oN);
        test("-52.0-1410065408", "" + s_fM + s_lM);
        test("-52.08.0", "" + s_fM + s_d);
        test("-52.055.0", "" + s_fM + s_f);
        test("-52.097000000", "" + s_fM + s_i);
        test("-52.0-9900", "" + s_fM + f_sM);
        test("-52.0935228928", "" + s_fM + s_l);
        test("-52.0-8400", "" + s_fM + sf_sM);
        test("-52.0C(82)", "" + s_fM + s_o);
        test("-52.0null", "" + s_fM + sf_oNtS);
        test("-52.0true", "" + s_fM + s_bl);
        test("-52.03900", "" + s_fM + s_s);
        test("-52.0null", "" + s_fM + sf_oN);
        test("-52.094000000", "" + s_fM + f_I);
        test("-52.0null", "" + s_fM + f_IN);
        test("-52.0true", "" + s_fM + sf_bl);
        test("-52.05500", "" + s_fM + sf_s);
        test("-52.0-2900", "" + s_fM + s_sM);
        test("-52.0-194313216", "" + s_fM + sf_l);
        test("-52.012", "" + s_fM + s_strU1);
        test("-52.0C(87)", "" + s_fM + sf_o);
        test("-52.091", "" + s_fM + s_strU2);
        test("-52.021", "" + s_fM + f_strU1);
        test("-52.018", "" + s_fM + f_strU2);
        test("-52.0null", "" + s_fM + f_iAN);
        test("-52.0null", "" + s_fM + s_oN);
        test("-52.0\u045180", "" + s_fM + s_strU);
        test("-52.0C", "" + s_fM + sf_c);
        test("-52.075", "" + s_fM + sf_str);
        test("-52.0-43", "" + s_fM + s_bM);
        test("-52.080", "" + s_fM + sf_b);
        test("-52.0null", "" + s_fM + s_IN);
        test("-52.0-52.0", "" + s_fM + s_fM);
        test("-52.075000000", "" + s_fM + sf_i);
        test("-52.044", "" + s_fM + f_b);
        test("-52.0-1705032704", "" + s_fM + sf_lM);
        test("-52.0null", "" + s_fM + f_oAN);
        test("-52.083.0", "" + s_fM + f_d);
        test("-52.0I", "" + s_fM + f_c);
        test("-52.094.0", "" + s_fM + f_f);
        test("-52.012.0", "" + s_fM + sf_d);
        test("-52.0-99.0", "" + s_fM + f_dM);
        test("-52.017.0", "" + s_fM + sf_f);
        test("-52.0-84.0", "" + s_fM + sf_dM);
        test("-52.058000000", "" + s_fM + f_i);
        test("-52.0-55000000", "" + s_fM + f_iM);
        test("-52.01460392448", "" + s_fM + f_l);
        test("-52.0C(70)", "" + s_fM + f_o);
        test("-52.0\u04511", "" + s_fM + sf_strU);
        test("-52.08000", "" + s_fM + f_s);
        test("-52.018", "" + s_fM + s_str);
        test("-52.0-1000000", "" + s_fM + s_iM);
        test("-52.01000000", "" + s_fM + sf_I);
        test("-52.0null", "" + s_fM + f_oNtS);
        test("-52.0false", "" + s_fM + f_bl);
        test("-52.0null", "" + s_fM + sf_iAN);
        test("-52.0-2000000", "" + s_fM + sf_iM);
        test("-52.0-820130816", "" + s_fM + f_lM);
        test("-52.0null", "" + s_fM + sf_oAN);
        test("-52.025000000", "" + s_fM + s_I);
        test("75000000-96.0", "" + sf_i + s_dM);
        test("75000000null", "" + sf_i + s_oNtS);
        test("75000000\u045176", "" + sf_i + f_strU);
        test("7500000092", "" + sf_i + sf_strU2);
        test("7500000051", "" + sf_i + sf_strU1);
        test("75000000null", "" + sf_i + s_iAN);
        test("75000000-54", "" + sf_i + f_bM);
        test("75000000-87.0", "" + sf_i + f_fM);
        test("75000000null", "" + sf_i + s_oAN);
        test("7500000019", "" + sf_i + f_str);
        test("75000000-41", "" + sf_i + sf_bM);
        test("75000000null", "" + sf_i + sf_IN);
        test("75000000T", "" + sf_i + s_c);
        test("75000000-42.0", "" + sf_i + sf_fM);
        test("7500000025", "" + sf_i + s_b);
        test("75000000null", "" + sf_i + f_oN);
        test("75000000-1410065408", "" + sf_i + s_lM);
        test("750000008.0", "" + sf_i + s_d);
        test("7500000055.0", "" + sf_i + s_f);
        test("7500000097000000", "" + sf_i + s_i);
        test("75000000-9900", "" + sf_i + f_sM);
        test("75000000935228928", "" + sf_i + s_l);
        test("75000000-8400", "" + sf_i + sf_sM);
        test("75000000C(82)", "" + sf_i + s_o);
        test("75000000null", "" + sf_i + sf_oNtS);
        test("75000000true", "" + sf_i + s_bl);
        test("750000003900", "" + sf_i + s_s);
        test("75000000null", "" + sf_i + sf_oN);
        test("7500000094000000", "" + sf_i + f_I);
        test("75000000null", "" + sf_i + f_IN);
        test("75000000true", "" + sf_i + sf_bl);
        test("750000005500", "" + sf_i + sf_s);
        test("75000000-2900", "" + sf_i + s_sM);
        test("75000000-194313216", "" + sf_i + sf_l);
        test("7500000012", "" + sf_i + s_strU1);
        test("75000000C(87)", "" + sf_i + sf_o);
        test("7500000091", "" + sf_i + s_strU2);
        test("7500000021", "" + sf_i + f_strU1);
        test("7500000018", "" + sf_i + f_strU2);
        test("75000000null", "" + sf_i + f_iAN);
        test("75000000null", "" + sf_i + s_oN);
        test("75000000\u045180", "" + sf_i + s_strU);
        test("75000000C", "" + sf_i + sf_c);
        test("7500000075", "" + sf_i + sf_str);
        test("75000000-43", "" + sf_i + s_bM);
        test("7500000080", "" + sf_i + sf_b);
        test("75000000null", "" + sf_i + s_IN);
        test("75000000-52.0", "" + sf_i + s_fM);
        test("7500000075000000", "" + sf_i + sf_i);
        test("7500000044", "" + sf_i + f_b);
        test("75000000-1705032704", "" + sf_i + sf_lM);
        test("75000000null", "" + sf_i + f_oAN);
        test("7500000083.0", "" + sf_i + f_d);
        test("75000000I", "" + sf_i + f_c);
        test("7500000094.0", "" + sf_i + f_f);
        test("7500000012.0", "" + sf_i + sf_d);
        test("75000000-99.0", "" + sf_i + f_dM);
        test("7500000017.0", "" + sf_i + sf_f);
        test("75000000-84.0", "" + sf_i + sf_dM);
        test("7500000058000000", "" + sf_i + f_i);
        test("75000000-55000000", "" + sf_i + f_iM);
        test("750000001460392448", "" + sf_i + f_l);
        test("75000000C(70)", "" + sf_i + f_o);
        test("75000000\u04511", "" + sf_i + sf_strU);
        test("750000008000", "" + sf_i + f_s);
        test("7500000018", "" + sf_i + s_str);
        test("75000000-1000000", "" + sf_i + s_iM);
        test("750000001000000", "" + sf_i + sf_I);
        test("75000000null", "" + sf_i + f_oNtS);
        test("75000000false", "" + sf_i + f_bl);
        test("75000000null", "" + sf_i + sf_iAN);
        test("75000000-2000000", "" + sf_i + sf_iM);
        test("75000000-820130816", "" + sf_i + f_lM);
        test("75000000null", "" + sf_i + sf_oAN);
        test("7500000025000000", "" + sf_i + s_I);
        test("44-96.0", "" + f_b + s_dM);
        test("44null", "" + f_b + s_oNtS);
        test("44\u045176", "" + f_b + f_strU);
        test("4492", "" + f_b + sf_strU2);
        test("4451", "" + f_b + sf_strU1);
        test("44null", "" + f_b + s_iAN);
        test("44-54", "" + f_b + f_bM);
        test("44-87.0", "" + f_b + f_fM);
        test("44null", "" + f_b + s_oAN);
        test("4419", "" + f_b + f_str);
        test("44-41", "" + f_b + sf_bM);
        test("44null", "" + f_b + sf_IN);
        test("44T", "" + f_b + s_c);
        test("44-42.0", "" + f_b + sf_fM);
        test("4425", "" + f_b + s_b);
        test("44null", "" + f_b + f_oN);
        test("44-1410065408", "" + f_b + s_lM);
        test("448.0", "" + f_b + s_d);
        test("4455.0", "" + f_b + s_f);
        test("4497000000", "" + f_b + s_i);
        test("44-9900", "" + f_b + f_sM);
        test("44935228928", "" + f_b + s_l);
        test("44-8400", "" + f_b + sf_sM);
        test("44C(82)", "" + f_b + s_o);
        test("44null", "" + f_b + sf_oNtS);
        test("44true", "" + f_b + s_bl);
        test("443900", "" + f_b + s_s);
        test("44null", "" + f_b + sf_oN);
        test("4494000000", "" + f_b + f_I);
        test("44null", "" + f_b + f_IN);
        test("44true", "" + f_b + sf_bl);
        test("445500", "" + f_b + sf_s);
        test("44-2900", "" + f_b + s_sM);
        test("44-194313216", "" + f_b + sf_l);
        test("4412", "" + f_b + s_strU1);
        test("44C(87)", "" + f_b + sf_o);
        test("4491", "" + f_b + s_strU2);
        test("4421", "" + f_b + f_strU1);
        test("4418", "" + f_b + f_strU2);
        test("44null", "" + f_b + f_iAN);
        test("44null", "" + f_b + s_oN);
        test("44\u045180", "" + f_b + s_strU);
        test("44C", "" + f_b + sf_c);
        test("4475", "" + f_b + sf_str);
        test("44-43", "" + f_b + s_bM);
        test("4480", "" + f_b + sf_b);
        test("44null", "" + f_b + s_IN);
        test("44-52.0", "" + f_b + s_fM);
        test("4475000000", "" + f_b + sf_i);
        test("4444", "" + f_b + f_b);
        test("44-1705032704", "" + f_b + sf_lM);
        test("44null", "" + f_b + f_oAN);
        test("4483.0", "" + f_b + f_d);
        test("44I", "" + f_b + f_c);
        test("4494.0", "" + f_b + f_f);
        test("4412.0", "" + f_b + sf_d);
        test("44-99.0", "" + f_b + f_dM);
        test("4417.0", "" + f_b + sf_f);
        test("44-84.0", "" + f_b + sf_dM);
        test("4458000000", "" + f_b + f_i);
        test("44-55000000", "" + f_b + f_iM);
        test("441460392448", "" + f_b + f_l);
        test("44C(70)", "" + f_b + f_o);
        test("44\u04511", "" + f_b + sf_strU);
        test("448000", "" + f_b + f_s);
        test("4418", "" + f_b + s_str);
        test("44-1000000", "" + f_b + s_iM);
        test("441000000", "" + f_b + sf_I);
        test("44null", "" + f_b + f_oNtS);
        test("44false", "" + f_b + f_bl);
        test("44null", "" + f_b + sf_iAN);
        test("44-2000000", "" + f_b + sf_iM);
        test("44-820130816", "" + f_b + f_lM);
        test("44null", "" + f_b + sf_oAN);
        test("4425000000", "" + f_b + s_I);
        test("-1705032704-96.0", "" + sf_lM + s_dM);
        test("-1705032704null", "" + sf_lM + s_oNtS);
        test("-1705032704\u045176", "" + sf_lM + f_strU);
        test("-170503270492", "" + sf_lM + sf_strU2);
        test("-170503270451", "" + sf_lM + sf_strU1);
        test("-1705032704null", "" + sf_lM + s_iAN);
        test("-1705032704-54", "" + sf_lM + f_bM);
        test("-1705032704-87.0", "" + sf_lM + f_fM);
        test("-1705032704null", "" + sf_lM + s_oAN);
        test("-170503270419", "" + sf_lM + f_str);
        test("-1705032704-41", "" + sf_lM + sf_bM);
        test("-1705032704null", "" + sf_lM + sf_IN);
        test("-1705032704T", "" + sf_lM + s_c);
        test("-1705032704-42.0", "" + sf_lM + sf_fM);
        test("-170503270425", "" + sf_lM + s_b);
        test("-1705032704null", "" + sf_lM + f_oN);
        test("-1705032704-1410065408", "" + sf_lM + s_lM);
        test("-17050327048.0", "" + sf_lM + s_d);
        test("-170503270455.0", "" + sf_lM + s_f);
        test("-170503270497000000", "" + sf_lM + s_i);
        test("-1705032704-9900", "" + sf_lM + f_sM);
        test("-1705032704935228928", "" + sf_lM + s_l);
        test("-1705032704-8400", "" + sf_lM + sf_sM);
        test("-1705032704C(82)", "" + sf_lM + s_o);
        test("-1705032704null", "" + sf_lM + sf_oNtS);
        test("-1705032704true", "" + sf_lM + s_bl);
        test("-17050327043900", "" + sf_lM + s_s);
        test("-1705032704null", "" + sf_lM + sf_oN);
        test("-170503270494000000", "" + sf_lM + f_I);
        test("-1705032704null", "" + sf_lM + f_IN);
        test("-1705032704true", "" + sf_lM + sf_bl);
        test("-17050327045500", "" + sf_lM + sf_s);
        test("-1705032704-2900", "" + sf_lM + s_sM);
        test("-1705032704-194313216", "" + sf_lM + sf_l);
        test("-170503270412", "" + sf_lM + s_strU1);
        test("-1705032704C(87)", "" + sf_lM + sf_o);
        test("-170503270491", "" + sf_lM + s_strU2);
        test("-170503270421", "" + sf_lM + f_strU1);
        test("-170503270418", "" + sf_lM + f_strU2);
        test("-1705032704null", "" + sf_lM + f_iAN);
        test("-1705032704null", "" + sf_lM + s_oN);
        test("-1705032704\u045180", "" + sf_lM + s_strU);
        test("-1705032704C", "" + sf_lM + sf_c);
        test("-170503270475", "" + sf_lM + sf_str);
        test("-1705032704-43", "" + sf_lM + s_bM);
        test("-170503270480", "" + sf_lM + sf_b);
        test("-1705032704null", "" + sf_lM + s_IN);
        test("-1705032704-52.0", "" + sf_lM + s_fM);
        test("-170503270475000000", "" + sf_lM + sf_i);
        test("-170503270444", "" + sf_lM + f_b);
        test("-1705032704-1705032704", "" + sf_lM + sf_lM);
        test("-1705032704null", "" + sf_lM + f_oAN);
        test("-170503270483.0", "" + sf_lM + f_d);
        test("-1705032704I", "" + sf_lM + f_c);
        test("-170503270494.0", "" + sf_lM + f_f);
        test("-170503270412.0", "" + sf_lM + sf_d);
        test("-1705032704-99.0", "" + sf_lM + f_dM);
        test("-170503270417.0", "" + sf_lM + sf_f);
        test("-1705032704-84.0", "" + sf_lM + sf_dM);
        test("-170503270458000000", "" + sf_lM + f_i);
        test("-1705032704-55000000", "" + sf_lM + f_iM);
        test("-17050327041460392448", "" + sf_lM + f_l);
        test("-1705032704C(70)", "" + sf_lM + f_o);
        test("-1705032704\u04511", "" + sf_lM + sf_strU);
        test("-17050327048000", "" + sf_lM + f_s);
        test("-170503270418", "" + sf_lM + s_str);
        test("-1705032704-1000000", "" + sf_lM + s_iM);
        test("-17050327041000000", "" + sf_lM + sf_I);
        test("-1705032704null", "" + sf_lM + f_oNtS);
        test("-1705032704false", "" + sf_lM + f_bl);
        test("-1705032704null", "" + sf_lM + sf_iAN);
        test("-1705032704-2000000", "" + sf_lM + sf_iM);
        test("-1705032704-820130816", "" + sf_lM + f_lM);
        test("-1705032704null", "" + sf_lM + sf_oAN);
        test("-170503270425000000", "" + sf_lM + s_I);
        test("null-96.0", "" + f_oAN + s_dM);
        test("nullnull", "" + f_oAN + s_oNtS);
        test("null\u045176", "" + f_oAN + f_strU);
        test("null92", "" + f_oAN + sf_strU2);
        test("null51", "" + f_oAN + sf_strU1);
        test("nullnull", "" + f_oAN + s_iAN);
        test("null-54", "" + f_oAN + f_bM);
        test("null-87.0", "" + f_oAN + f_fM);
        test("nullnull", "" + f_oAN + s_oAN);
        test("null19", "" + f_oAN + f_str);
        test("null-41", "" + f_oAN + sf_bM);
        test("nullnull", "" + f_oAN + sf_IN);
        test("nullT", "" + f_oAN + s_c);
        test("null-42.0", "" + f_oAN + sf_fM);
        test("null25", "" + f_oAN + s_b);
        test("nullnull", "" + f_oAN + f_oN);
        test("null-1410065408", "" + f_oAN + s_lM);
        test("null8.0", "" + f_oAN + s_d);
        test("null55.0", "" + f_oAN + s_f);
        test("null97000000", "" + f_oAN + s_i);
        test("null-9900", "" + f_oAN + f_sM);
        test("null935228928", "" + f_oAN + s_l);
        test("null-8400", "" + f_oAN + sf_sM);
        test("nullC(82)", "" + f_oAN + s_o);
        test("nullnull", "" + f_oAN + sf_oNtS);
        test("nulltrue", "" + f_oAN + s_bl);
        test("null3900", "" + f_oAN + s_s);
        test("nullnull", "" + f_oAN + sf_oN);
        test("null94000000", "" + f_oAN + f_I);
        test("nullnull", "" + f_oAN + f_IN);
        test("nulltrue", "" + f_oAN + sf_bl);
        test("null5500", "" + f_oAN + sf_s);
        test("null-2900", "" + f_oAN + s_sM);
        test("null-194313216", "" + f_oAN + sf_l);
        test("null12", "" + f_oAN + s_strU1);
        test("nullC(87)", "" + f_oAN + sf_o);
        test("null91", "" + f_oAN + s_strU2);
        test("null21", "" + f_oAN + f_strU1);
        test("null18", "" + f_oAN + f_strU2);
        test("nullnull", "" + f_oAN + f_iAN);
        test("nullnull", "" + f_oAN + s_oN);
        test("null\u045180", "" + f_oAN + s_strU);
        test("nullC", "" + f_oAN + sf_c);
        test("null75", "" + f_oAN + sf_str);
        test("null-43", "" + f_oAN + s_bM);
        test("null80", "" + f_oAN + sf_b);
        test("nullnull", "" + f_oAN + s_IN);
        test("null-52.0", "" + f_oAN + s_fM);
        test("null75000000", "" + f_oAN + sf_i);
        test("null44", "" + f_oAN + f_b);
        test("null-1705032704", "" + f_oAN + sf_lM);
        test("nullnull", "" + f_oAN + f_oAN);
        test("null83.0", "" + f_oAN + f_d);
        test("nullI", "" + f_oAN + f_c);
        test("null94.0", "" + f_oAN + f_f);
        test("null12.0", "" + f_oAN + sf_d);
        test("null-99.0", "" + f_oAN + f_dM);
        test("null17.0", "" + f_oAN + sf_f);
        test("null-84.0", "" + f_oAN + sf_dM);
        test("null58000000", "" + f_oAN + f_i);
        test("null-55000000", "" + f_oAN + f_iM);
        test("null1460392448", "" + f_oAN + f_l);
        test("nullC(70)", "" + f_oAN + f_o);
        test("null\u04511", "" + f_oAN + sf_strU);
        test("null8000", "" + f_oAN + f_s);
        test("null18", "" + f_oAN + s_str);
        test("null-1000000", "" + f_oAN + s_iM);
        test("null1000000", "" + f_oAN + sf_I);
        test("nullnull", "" + f_oAN + f_oNtS);
        test("nullfalse", "" + f_oAN + f_bl);
        test("nullnull", "" + f_oAN + sf_iAN);
        test("null-2000000", "" + f_oAN + sf_iM);
        test("null-820130816", "" + f_oAN + f_lM);
        test("nullnull", "" + f_oAN + sf_oAN);
        test("null25000000", "" + f_oAN + s_I);
        test("83.0-96.0", "" + f_d + s_dM);
        test("83.0null", "" + f_d + s_oNtS);
        test("83.0\u045176", "" + f_d + f_strU);
        test("83.092", "" + f_d + sf_strU2);
        test("83.051", "" + f_d + sf_strU1);
        test("83.0null", "" + f_d + s_iAN);
        test("83.0-54", "" + f_d + f_bM);
        test("83.0-87.0", "" + f_d + f_fM);
        test("83.0null", "" + f_d + s_oAN);
        test("83.019", "" + f_d + f_str);
        test("83.0-41", "" + f_d + sf_bM);
        test("83.0null", "" + f_d + sf_IN);
        test("83.0T", "" + f_d + s_c);
        test("83.0-42.0", "" + f_d + sf_fM);
        test("83.025", "" + f_d + s_b);
        test("83.0null", "" + f_d + f_oN);
        test("83.0-1410065408", "" + f_d + s_lM);
        test("83.08.0", "" + f_d + s_d);
        test("83.055.0", "" + f_d + s_f);
        test("83.097000000", "" + f_d + s_i);
        test("83.0-9900", "" + f_d + f_sM);
        test("83.0935228928", "" + f_d + s_l);
        test("83.0-8400", "" + f_d + sf_sM);
        test("83.0C(82)", "" + f_d + s_o);
        test("83.0null", "" + f_d + sf_oNtS);
    }

    public void run4() {
        test("83.0true", "" + f_d + s_bl);
        test("83.03900", "" + f_d + s_s);
        test("83.0null", "" + f_d + sf_oN);
        test("83.094000000", "" + f_d + f_I);
        test("83.0null", "" + f_d + f_IN);
        test("83.0true", "" + f_d + sf_bl);
        test("83.05500", "" + f_d + sf_s);
        test("83.0-2900", "" + f_d + s_sM);
        test("83.0-194313216", "" + f_d + sf_l);
        test("83.012", "" + f_d + s_strU1);
        test("83.0C(87)", "" + f_d + sf_o);
        test("83.091", "" + f_d + s_strU2);
        test("83.021", "" + f_d + f_strU1);
        test("83.018", "" + f_d + f_strU2);
        test("83.0null", "" + f_d + f_iAN);
        test("83.0null", "" + f_d + s_oN);
        test("83.0\u045180", "" + f_d + s_strU);
        test("83.0C", "" + f_d + sf_c);
        test("83.075", "" + f_d + sf_str);
        test("83.0-43", "" + f_d + s_bM);
        test("83.080", "" + f_d + sf_b);
        test("83.0null", "" + f_d + s_IN);
        test("83.0-52.0", "" + f_d + s_fM);
        test("83.075000000", "" + f_d + sf_i);
        test("83.044", "" + f_d + f_b);
        test("83.0-1705032704", "" + f_d + sf_lM);
        test("83.0null", "" + f_d + f_oAN);
        test("83.083.0", "" + f_d + f_d);
        test("83.0I", "" + f_d + f_c);
        test("83.094.0", "" + f_d + f_f);
        test("83.012.0", "" + f_d + sf_d);
        test("83.0-99.0", "" + f_d + f_dM);
        test("83.017.0", "" + f_d + sf_f);
        test("83.0-84.0", "" + f_d + sf_dM);
        test("83.058000000", "" + f_d + f_i);
        test("83.0-55000000", "" + f_d + f_iM);
        test("83.01460392448", "" + f_d + f_l);
        test("83.0C(70)", "" + f_d + f_o);
        test("83.0\u04511", "" + f_d + sf_strU);
        test("83.08000", "" + f_d + f_s);
        test("83.018", "" + f_d + s_str);
        test("83.0-1000000", "" + f_d + s_iM);
        test("83.01000000", "" + f_d + sf_I);
        test("83.0null", "" + f_d + f_oNtS);
        test("83.0false", "" + f_d + f_bl);
        test("83.0null", "" + f_d + sf_iAN);
        test("83.0-2000000", "" + f_d + sf_iM);
        test("83.0-820130816", "" + f_d + f_lM);
        test("83.0null", "" + f_d + sf_oAN);
        test("83.025000000", "" + f_d + s_I);
        test("I-96.0", "" + f_c + s_dM);
        test("Inull", "" + f_c + s_oNtS);
        test("I\u045176", "" + f_c + f_strU);
        test("I92", "" + f_c + sf_strU2);
        test("I51", "" + f_c + sf_strU1);
        test("Inull", "" + f_c + s_iAN);
        test("I-54", "" + f_c + f_bM);
        test("I-87.0", "" + f_c + f_fM);
        test("Inull", "" + f_c + s_oAN);
        test("I19", "" + f_c + f_str);
        test("I-41", "" + f_c + sf_bM);
        test("Inull", "" + f_c + sf_IN);
        test("IT", "" + f_c + s_c);
        test("I-42.0", "" + f_c + sf_fM);
        test("I25", "" + f_c + s_b);
        test("Inull", "" + f_c + f_oN);
        test("I-1410065408", "" + f_c + s_lM);
        test("I8.0", "" + f_c + s_d);
        test("I55.0", "" + f_c + s_f);
        test("I97000000", "" + f_c + s_i);
        test("I-9900", "" + f_c + f_sM);
        test("I935228928", "" + f_c + s_l);
        test("I-8400", "" + f_c + sf_sM);
        test("IC(82)", "" + f_c + s_o);
        test("Inull", "" + f_c + sf_oNtS);
        test("Itrue", "" + f_c + s_bl);
        test("I3900", "" + f_c + s_s);
        test("Inull", "" + f_c + sf_oN);
        test("I94000000", "" + f_c + f_I);
        test("Inull", "" + f_c + f_IN);
        test("Itrue", "" + f_c + sf_bl);
        test("I5500", "" + f_c + sf_s);
        test("I-2900", "" + f_c + s_sM);
        test("I-194313216", "" + f_c + sf_l);
        test("I12", "" + f_c + s_strU1);
        test("IC(87)", "" + f_c + sf_o);
        test("I91", "" + f_c + s_strU2);
        test("I21", "" + f_c + f_strU1);
        test("I18", "" + f_c + f_strU2);
        test("Inull", "" + f_c + f_iAN);
        test("Inull", "" + f_c + s_oN);
        test("I\u045180", "" + f_c + s_strU);
        test("IC", "" + f_c + sf_c);
        test("I75", "" + f_c + sf_str);
        test("I-43", "" + f_c + s_bM);
        test("I80", "" + f_c + sf_b);
        test("Inull", "" + f_c + s_IN);
        test("I-52.0", "" + f_c + s_fM);
        test("I75000000", "" + f_c + sf_i);
        test("I44", "" + f_c + f_b);
        test("I-1705032704", "" + f_c + sf_lM);
        test("Inull", "" + f_c + f_oAN);
        test("I83.0", "" + f_c + f_d);
        test("II", "" + f_c + f_c);
        test("I94.0", "" + f_c + f_f);
        test("I12.0", "" + f_c + sf_d);
        test("I-99.0", "" + f_c + f_dM);
        test("I17.0", "" + f_c + sf_f);
        test("I-84.0", "" + f_c + sf_dM);
        test("I58000000", "" + f_c + f_i);
        test("I-55000000", "" + f_c + f_iM);
        test("I1460392448", "" + f_c + f_l);
        test("IC(70)", "" + f_c + f_o);
        test("I\u04511", "" + f_c + sf_strU);
        test("I8000", "" + f_c + f_s);
        test("I18", "" + f_c + s_str);
        test("I-1000000", "" + f_c + s_iM);
        test("I1000000", "" + f_c + sf_I);
        test("Inull", "" + f_c + f_oNtS);
        test("Ifalse", "" + f_c + f_bl);
        test("Inull", "" + f_c + sf_iAN);
        test("I-2000000", "" + f_c + sf_iM);
        test("I-820130816", "" + f_c + f_lM);
        test("Inull", "" + f_c + sf_oAN);
        test("I25000000", "" + f_c + s_I);
        test("94.0-96.0", "" + f_f + s_dM);
        test("94.0null", "" + f_f + s_oNtS);
        test("94.0\u045176", "" + f_f + f_strU);
        test("94.092", "" + f_f + sf_strU2);
        test("94.051", "" + f_f + sf_strU1);
        test("94.0null", "" + f_f + s_iAN);
        test("94.0-54", "" + f_f + f_bM);
        test("94.0-87.0", "" + f_f + f_fM);
        test("94.0null", "" + f_f + s_oAN);
        test("94.019", "" + f_f + f_str);
        test("94.0-41", "" + f_f + sf_bM);
        test("94.0null", "" + f_f + sf_IN);
        test("94.0T", "" + f_f + s_c);
        test("94.0-42.0", "" + f_f + sf_fM);
        test("94.025", "" + f_f + s_b);
        test("94.0null", "" + f_f + f_oN);
        test("94.0-1410065408", "" + f_f + s_lM);
        test("94.08.0", "" + f_f + s_d);
        test("94.055.0", "" + f_f + s_f);
        test("94.097000000", "" + f_f + s_i);
        test("94.0-9900", "" + f_f + f_sM);
        test("94.0935228928", "" + f_f + s_l);
        test("94.0-8400", "" + f_f + sf_sM);
        test("94.0C(82)", "" + f_f + s_o);
        test("94.0null", "" + f_f + sf_oNtS);
        test("94.0true", "" + f_f + s_bl);
        test("94.03900", "" + f_f + s_s);
        test("94.0null", "" + f_f + sf_oN);
        test("94.094000000", "" + f_f + f_I);
        test("94.0null", "" + f_f + f_IN);
        test("94.0true", "" + f_f + sf_bl);
        test("94.05500", "" + f_f + sf_s);
        test("94.0-2900", "" + f_f + s_sM);
        test("94.0-194313216", "" + f_f + sf_l);
        test("94.012", "" + f_f + s_strU1);
        test("94.0C(87)", "" + f_f + sf_o);
        test("94.091", "" + f_f + s_strU2);
        test("94.021", "" + f_f + f_strU1);
        test("94.018", "" + f_f + f_strU2);
        test("94.0null", "" + f_f + f_iAN);
        test("94.0null", "" + f_f + s_oN);
        test("94.0\u045180", "" + f_f + s_strU);
        test("94.0C", "" + f_f + sf_c);
        test("94.075", "" + f_f + sf_str);
        test("94.0-43", "" + f_f + s_bM);
        test("94.080", "" + f_f + sf_b);
        test("94.0null", "" + f_f + s_IN);
        test("94.0-52.0", "" + f_f + s_fM);
        test("94.075000000", "" + f_f + sf_i);
        test("94.044", "" + f_f + f_b);
        test("94.0-1705032704", "" + f_f + sf_lM);
        test("94.0null", "" + f_f + f_oAN);
        test("94.083.0", "" + f_f + f_d);
        test("94.0I", "" + f_f + f_c);
        test("94.094.0", "" + f_f + f_f);
        test("94.012.0", "" + f_f + sf_d);
        test("94.0-99.0", "" + f_f + f_dM);
        test("94.017.0", "" + f_f + sf_f);
        test("94.0-84.0", "" + f_f + sf_dM);
        test("94.058000000", "" + f_f + f_i);
        test("94.0-55000000", "" + f_f + f_iM);
        test("94.01460392448", "" + f_f + f_l);
        test("94.0C(70)", "" + f_f + f_o);
        test("94.0\u04511", "" + f_f + sf_strU);
        test("94.08000", "" + f_f + f_s);
        test("94.018", "" + f_f + s_str);
        test("94.0-1000000", "" + f_f + s_iM);
        test("94.01000000", "" + f_f + sf_I);
        test("94.0null", "" + f_f + f_oNtS);
        test("94.0false", "" + f_f + f_bl);
        test("94.0null", "" + f_f + sf_iAN);
        test("94.0-2000000", "" + f_f + sf_iM);
        test("94.0-820130816", "" + f_f + f_lM);
        test("94.0null", "" + f_f + sf_oAN);
        test("94.025000000", "" + f_f + s_I);
        test("12.0-96.0", "" + sf_d + s_dM);
        test("12.0null", "" + sf_d + s_oNtS);
        test("12.0\u045176", "" + sf_d + f_strU);
        test("12.092", "" + sf_d + sf_strU2);
        test("12.051", "" + sf_d + sf_strU1);
        test("12.0null", "" + sf_d + s_iAN);
        test("12.0-54", "" + sf_d + f_bM);
        test("12.0-87.0", "" + sf_d + f_fM);
        test("12.0null", "" + sf_d + s_oAN);
        test("12.019", "" + sf_d + f_str);
        test("12.0-41", "" + sf_d + sf_bM);
        test("12.0null", "" + sf_d + sf_IN);
        test("12.0T", "" + sf_d + s_c);
        test("12.0-42.0", "" + sf_d + sf_fM);
        test("12.025", "" + sf_d + s_b);
        test("12.0null", "" + sf_d + f_oN);
        test("12.0-1410065408", "" + sf_d + s_lM);
        test("12.08.0", "" + sf_d + s_d);
        test("12.055.0", "" + sf_d + s_f);
        test("12.097000000", "" + sf_d + s_i);
        test("12.0-9900", "" + sf_d + f_sM);
        test("12.0935228928", "" + sf_d + s_l);
        test("12.0-8400", "" + sf_d + sf_sM);
        test("12.0C(82)", "" + sf_d + s_o);
        test("12.0null", "" + sf_d + sf_oNtS);
        test("12.0true", "" + sf_d + s_bl);
        test("12.03900", "" + sf_d + s_s);
        test("12.0null", "" + sf_d + sf_oN);
        test("12.094000000", "" + sf_d + f_I);
        test("12.0null", "" + sf_d + f_IN);
        test("12.0true", "" + sf_d + sf_bl);
        test("12.05500", "" + sf_d + sf_s);
        test("12.0-2900", "" + sf_d + s_sM);
        test("12.0-194313216", "" + sf_d + sf_l);
        test("12.012", "" + sf_d + s_strU1);
        test("12.0C(87)", "" + sf_d + sf_o);
        test("12.091", "" + sf_d + s_strU2);
        test("12.021", "" + sf_d + f_strU1);
        test("12.018", "" + sf_d + f_strU2);
        test("12.0null", "" + sf_d + f_iAN);
        test("12.0null", "" + sf_d + s_oN);
        test("12.0\u045180", "" + sf_d + s_strU);
        test("12.0C", "" + sf_d + sf_c);
        test("12.075", "" + sf_d + sf_str);
        test("12.0-43", "" + sf_d + s_bM);
        test("12.080", "" + sf_d + sf_b);
        test("12.0null", "" + sf_d + s_IN);
        test("12.0-52.0", "" + sf_d + s_fM);
        test("12.075000000", "" + sf_d + sf_i);
        test("12.044", "" + sf_d + f_b);
        test("12.0-1705032704", "" + sf_d + sf_lM);
        test("12.0null", "" + sf_d + f_oAN);
        test("12.083.0", "" + sf_d + f_d);
        test("12.0I", "" + sf_d + f_c);
        test("12.094.0", "" + sf_d + f_f);
        test("12.012.0", "" + sf_d + sf_d);
        test("12.0-99.0", "" + sf_d + f_dM);
        test("12.017.0", "" + sf_d + sf_f);
        test("12.0-84.0", "" + sf_d + sf_dM);
        test("12.058000000", "" + sf_d + f_i);
        test("12.0-55000000", "" + sf_d + f_iM);
        test("12.01460392448", "" + sf_d + f_l);
        test("12.0C(70)", "" + sf_d + f_o);
        test("12.0\u04511", "" + sf_d + sf_strU);
        test("12.08000", "" + sf_d + f_s);
        test("12.018", "" + sf_d + s_str);
        test("12.0-1000000", "" + sf_d + s_iM);
        test("12.01000000", "" + sf_d + sf_I);
        test("12.0null", "" + sf_d + f_oNtS);
        test("12.0false", "" + sf_d + f_bl);
        test("12.0null", "" + sf_d + sf_iAN);
        test("12.0-2000000", "" + sf_d + sf_iM);
        test("12.0-820130816", "" + sf_d + f_lM);
        test("12.0null", "" + sf_d + sf_oAN);
        test("12.025000000", "" + sf_d + s_I);
        test("-99.0-96.0", "" + f_dM + s_dM);
        test("-99.0null", "" + f_dM + s_oNtS);
        test("-99.0\u045176", "" + f_dM + f_strU);
        test("-99.092", "" + f_dM + sf_strU2);
        test("-99.051", "" + f_dM + sf_strU1);
        test("-99.0null", "" + f_dM + s_iAN);
        test("-99.0-54", "" + f_dM + f_bM);
        test("-99.0-87.0", "" + f_dM + f_fM);
        test("-99.0null", "" + f_dM + s_oAN);
        test("-99.019", "" + f_dM + f_str);
        test("-99.0-41", "" + f_dM + sf_bM);
        test("-99.0null", "" + f_dM + sf_IN);
        test("-99.0T", "" + f_dM + s_c);
        test("-99.0-42.0", "" + f_dM + sf_fM);
        test("-99.025", "" + f_dM + s_b);
        test("-99.0null", "" + f_dM + f_oN);
        test("-99.0-1410065408", "" + f_dM + s_lM);
        test("-99.08.0", "" + f_dM + s_d);
        test("-99.055.0", "" + f_dM + s_f);
        test("-99.097000000", "" + f_dM + s_i);
        test("-99.0-9900", "" + f_dM + f_sM);
        test("-99.0935228928", "" + f_dM + s_l);
        test("-99.0-8400", "" + f_dM + sf_sM);
        test("-99.0C(82)", "" + f_dM + s_o);
        test("-99.0null", "" + f_dM + sf_oNtS);
        test("-99.0true", "" + f_dM + s_bl);
        test("-99.03900", "" + f_dM + s_s);
        test("-99.0null", "" + f_dM + sf_oN);
        test("-99.094000000", "" + f_dM + f_I);
        test("-99.0null", "" + f_dM + f_IN);
        test("-99.0true", "" + f_dM + sf_bl);
        test("-99.05500", "" + f_dM + sf_s);
        test("-99.0-2900", "" + f_dM + s_sM);
        test("-99.0-194313216", "" + f_dM + sf_l);
        test("-99.012", "" + f_dM + s_strU1);
        test("-99.0C(87)", "" + f_dM + sf_o);
        test("-99.091", "" + f_dM + s_strU2);
        test("-99.021", "" + f_dM + f_strU1);
        test("-99.018", "" + f_dM + f_strU2);
        test("-99.0null", "" + f_dM + f_iAN);
        test("-99.0null", "" + f_dM + s_oN);
        test("-99.0\u045180", "" + f_dM + s_strU);
        test("-99.0C", "" + f_dM + sf_c);
        test("-99.075", "" + f_dM + sf_str);
        test("-99.0-43", "" + f_dM + s_bM);
        test("-99.080", "" + f_dM + sf_b);
        test("-99.0null", "" + f_dM + s_IN);
        test("-99.0-52.0", "" + f_dM + s_fM);
        test("-99.075000000", "" + f_dM + sf_i);
        test("-99.044", "" + f_dM + f_b);
        test("-99.0-1705032704", "" + f_dM + sf_lM);
        test("-99.0null", "" + f_dM + f_oAN);
        test("-99.083.0", "" + f_dM + f_d);
        test("-99.0I", "" + f_dM + f_c);
        test("-99.094.0", "" + f_dM + f_f);
        test("-99.012.0", "" + f_dM + sf_d);
        test("-99.0-99.0", "" + f_dM + f_dM);
        test("-99.017.0", "" + f_dM + sf_f);
        test("-99.0-84.0", "" + f_dM + sf_dM);
        test("-99.058000000", "" + f_dM + f_i);
        test("-99.0-55000000", "" + f_dM + f_iM);
        test("-99.01460392448", "" + f_dM + f_l);
        test("-99.0C(70)", "" + f_dM + f_o);
        test("-99.0\u04511", "" + f_dM + sf_strU);
        test("-99.08000", "" + f_dM + f_s);
        test("-99.018", "" + f_dM + s_str);
        test("-99.0-1000000", "" + f_dM + s_iM);
        test("-99.01000000", "" + f_dM + sf_I);
        test("-99.0null", "" + f_dM + f_oNtS);
        test("-99.0false", "" + f_dM + f_bl);
        test("-99.0null", "" + f_dM + sf_iAN);
        test("-99.0-2000000", "" + f_dM + sf_iM);
        test("-99.0-820130816", "" + f_dM + f_lM);
        test("-99.0null", "" + f_dM + sf_oAN);
        test("-99.025000000", "" + f_dM + s_I);
        test("17.0-96.0", "" + sf_f + s_dM);
        test("17.0null", "" + sf_f + s_oNtS);
        test("17.0\u045176", "" + sf_f + f_strU);
        test("17.092", "" + sf_f + sf_strU2);
        test("17.051", "" + sf_f + sf_strU1);
        test("17.0null", "" + sf_f + s_iAN);
        test("17.0-54", "" + sf_f + f_bM);
        test("17.0-87.0", "" + sf_f + f_fM);
        test("17.0null", "" + sf_f + s_oAN);
        test("17.019", "" + sf_f + f_str);
        test("17.0-41", "" + sf_f + sf_bM);
        test("17.0null", "" + sf_f + sf_IN);
        test("17.0T", "" + sf_f + s_c);
        test("17.0-42.0", "" + sf_f + sf_fM);
        test("17.025", "" + sf_f + s_b);
        test("17.0null", "" + sf_f + f_oN);
        test("17.0-1410065408", "" + sf_f + s_lM);
        test("17.08.0", "" + sf_f + s_d);
        test("17.055.0", "" + sf_f + s_f);
        test("17.097000000", "" + sf_f + s_i);
        test("17.0-9900", "" + sf_f + f_sM);
        test("17.0935228928", "" + sf_f + s_l);
        test("17.0-8400", "" + sf_f + sf_sM);
        test("17.0C(82)", "" + sf_f + s_o);
        test("17.0null", "" + sf_f + sf_oNtS);
        test("17.0true", "" + sf_f + s_bl);
        test("17.03900", "" + sf_f + s_s);
        test("17.0null", "" + sf_f + sf_oN);
        test("17.094000000", "" + sf_f + f_I);
        test("17.0null", "" + sf_f + f_IN);
        test("17.0true", "" + sf_f + sf_bl);
        test("17.05500", "" + sf_f + sf_s);
        test("17.0-2900", "" + sf_f + s_sM);
        test("17.0-194313216", "" + sf_f + sf_l);
        test("17.012", "" + sf_f + s_strU1);
        test("17.0C(87)", "" + sf_f + sf_o);
        test("17.091", "" + sf_f + s_strU2);
        test("17.021", "" + sf_f + f_strU1);
        test("17.018", "" + sf_f + f_strU2);
        test("17.0null", "" + sf_f + f_iAN);
        test("17.0null", "" + sf_f + s_oN);
        test("17.0\u045180", "" + sf_f + s_strU);
        test("17.0C", "" + sf_f + sf_c);
        test("17.075", "" + sf_f + sf_str);
        test("17.0-43", "" + sf_f + s_bM);
        test("17.080", "" + sf_f + sf_b);
        test("17.0null", "" + sf_f + s_IN);
        test("17.0-52.0", "" + sf_f + s_fM);
        test("17.075000000", "" + sf_f + sf_i);
        test("17.044", "" + sf_f + f_b);
        test("17.0-1705032704", "" + sf_f + sf_lM);
        test("17.0null", "" + sf_f + f_oAN);
        test("17.083.0", "" + sf_f + f_d);
        test("17.0I", "" + sf_f + f_c);
        test("17.094.0", "" + sf_f + f_f);
        test("17.012.0", "" + sf_f + sf_d);
        test("17.0-99.0", "" + sf_f + f_dM);
        test("17.017.0", "" + sf_f + sf_f);
        test("17.0-84.0", "" + sf_f + sf_dM);
        test("17.058000000", "" + sf_f + f_i);
        test("17.0-55000000", "" + sf_f + f_iM);
        test("17.01460392448", "" + sf_f + f_l);
        test("17.0C(70)", "" + sf_f + f_o);
        test("17.0\u04511", "" + sf_f + sf_strU);
        test("17.08000", "" + sf_f + f_s);
        test("17.018", "" + sf_f + s_str);
        test("17.0-1000000", "" + sf_f + s_iM);
        test("17.01000000", "" + sf_f + sf_I);
        test("17.0null", "" + sf_f + f_oNtS);
        test("17.0false", "" + sf_f + f_bl);
        test("17.0null", "" + sf_f + sf_iAN);
        test("17.0-2000000", "" + sf_f + sf_iM);
        test("17.0-820130816", "" + sf_f + f_lM);
        test("17.0null", "" + sf_f + sf_oAN);
        test("17.025000000", "" + sf_f + s_I);
        test("-84.0-96.0", "" + sf_dM + s_dM);
        test("-84.0null", "" + sf_dM + s_oNtS);
        test("-84.0\u045176", "" + sf_dM + f_strU);
        test("-84.092", "" + sf_dM + sf_strU2);
        test("-84.051", "" + sf_dM + sf_strU1);
        test("-84.0null", "" + sf_dM + s_iAN);
        test("-84.0-54", "" + sf_dM + f_bM);
        test("-84.0-87.0", "" + sf_dM + f_fM);
        test("-84.0null", "" + sf_dM + s_oAN);
        test("-84.019", "" + sf_dM + f_str);
        test("-84.0-41", "" + sf_dM + sf_bM);
        test("-84.0null", "" + sf_dM + sf_IN);
        test("-84.0T", "" + sf_dM + s_c);
        test("-84.0-42.0", "" + sf_dM + sf_fM);
        test("-84.025", "" + sf_dM + s_b);
        test("-84.0null", "" + sf_dM + f_oN);
        test("-84.0-1410065408", "" + sf_dM + s_lM);
        test("-84.08.0", "" + sf_dM + s_d);
        test("-84.055.0", "" + sf_dM + s_f);
        test("-84.097000000", "" + sf_dM + s_i);
        test("-84.0-9900", "" + sf_dM + f_sM);
        test("-84.0935228928", "" + sf_dM + s_l);
        test("-84.0-8400", "" + sf_dM + sf_sM);
        test("-84.0C(82)", "" + sf_dM + s_o);
        test("-84.0null", "" + sf_dM + sf_oNtS);
        test("-84.0true", "" + sf_dM + s_bl);
        test("-84.03900", "" + sf_dM + s_s);
        test("-84.0null", "" + sf_dM + sf_oN);
        test("-84.094000000", "" + sf_dM + f_I);
        test("-84.0null", "" + sf_dM + f_IN);
        test("-84.0true", "" + sf_dM + sf_bl);
        test("-84.05500", "" + sf_dM + sf_s);
        test("-84.0-2900", "" + sf_dM + s_sM);
        test("-84.0-194313216", "" + sf_dM + sf_l);
        test("-84.012", "" + sf_dM + s_strU1);
        test("-84.0C(87)", "" + sf_dM + sf_o);
        test("-84.091", "" + sf_dM + s_strU2);
        test("-84.021", "" + sf_dM + f_strU1);
        test("-84.018", "" + sf_dM + f_strU2);
        test("-84.0null", "" + sf_dM + f_iAN);
        test("-84.0null", "" + sf_dM + s_oN);
        test("-84.0\u045180", "" + sf_dM + s_strU);
        test("-84.0C", "" + sf_dM + sf_c);
        test("-84.075", "" + sf_dM + sf_str);
        test("-84.0-43", "" + sf_dM + s_bM);
        test("-84.080", "" + sf_dM + sf_b);
        test("-84.0null", "" + sf_dM + s_IN);
        test("-84.0-52.0", "" + sf_dM + s_fM);
        test("-84.075000000", "" + sf_dM + sf_i);
        test("-84.044", "" + sf_dM + f_b);
        test("-84.0-1705032704", "" + sf_dM + sf_lM);
        test("-84.0null", "" + sf_dM + f_oAN);
        test("-84.083.0", "" + sf_dM + f_d);
        test("-84.0I", "" + sf_dM + f_c);
        test("-84.094.0", "" + sf_dM + f_f);
        test("-84.012.0", "" + sf_dM + sf_d);
        test("-84.0-99.0", "" + sf_dM + f_dM);
        test("-84.017.0", "" + sf_dM + sf_f);
        test("-84.0-84.0", "" + sf_dM + sf_dM);
        test("-84.058000000", "" + sf_dM + f_i);
        test("-84.0-55000000", "" + sf_dM + f_iM);
        test("-84.01460392448", "" + sf_dM + f_l);
        test("-84.0C(70)", "" + sf_dM + f_o);
        test("-84.0\u04511", "" + sf_dM + sf_strU);
        test("-84.08000", "" + sf_dM + f_s);
        test("-84.018", "" + sf_dM + s_str);
        test("-84.0-1000000", "" + sf_dM + s_iM);
        test("-84.01000000", "" + sf_dM + sf_I);
        test("-84.0null", "" + sf_dM + f_oNtS);
        test("-84.0false", "" + sf_dM + f_bl);
        test("-84.0null", "" + sf_dM + sf_iAN);
        test("-84.0-2000000", "" + sf_dM + sf_iM);
        test("-84.0-820130816", "" + sf_dM + f_lM);
        test("-84.0null", "" + sf_dM + sf_oAN);
        test("-84.025000000", "" + sf_dM + s_I);
        test("58000000-96.0", "" + f_i + s_dM);
        test("58000000null", "" + f_i + s_oNtS);
        test("58000000\u045176", "" + f_i + f_strU);
        test("5800000092", "" + f_i + sf_strU2);
        test("5800000051", "" + f_i + sf_strU1);
        test("58000000null", "" + f_i + s_iAN);
        test("58000000-54", "" + f_i + f_bM);
        test("58000000-87.0", "" + f_i + f_fM);
        test("58000000null", "" + f_i + s_oAN);
        test("5800000019", "" + f_i + f_str);
        test("58000000-41", "" + f_i + sf_bM);
        test("58000000null", "" + f_i + sf_IN);
        test("58000000T", "" + f_i + s_c);
        test("58000000-42.0", "" + f_i + sf_fM);
        test("5800000025", "" + f_i + s_b);
        test("58000000null", "" + f_i + f_oN);
        test("58000000-1410065408", "" + f_i + s_lM);
        test("580000008.0", "" + f_i + s_d);
        test("5800000055.0", "" + f_i + s_f);
        test("5800000097000000", "" + f_i + s_i);
        test("58000000-9900", "" + f_i + f_sM);
        test("58000000935228928", "" + f_i + s_l);
        test("58000000-8400", "" + f_i + sf_sM);
        test("58000000C(82)", "" + f_i + s_o);
        test("58000000null", "" + f_i + sf_oNtS);
        test("58000000true", "" + f_i + s_bl);
        test("580000003900", "" + f_i + s_s);
        test("58000000null", "" + f_i + sf_oN);
        test("5800000094000000", "" + f_i + f_I);
        test("58000000null", "" + f_i + f_IN);
        test("58000000true", "" + f_i + sf_bl);
        test("580000005500", "" + f_i + sf_s);
        test("58000000-2900", "" + f_i + s_sM);
        test("58000000-194313216", "" + f_i + sf_l);
        test("5800000012", "" + f_i + s_strU1);
        test("58000000C(87)", "" + f_i + sf_o);
        test("5800000091", "" + f_i + s_strU2);
        test("5800000021", "" + f_i + f_strU1);
        test("5800000018", "" + f_i + f_strU2);
        test("58000000null", "" + f_i + f_iAN);
        test("58000000null", "" + f_i + s_oN);
        test("58000000\u045180", "" + f_i + s_strU);
        test("58000000C", "" + f_i + sf_c);
        test("5800000075", "" + f_i + sf_str);
        test("58000000-43", "" + f_i + s_bM);
        test("5800000080", "" + f_i + sf_b);
        test("58000000null", "" + f_i + s_IN);
        test("58000000-52.0", "" + f_i + s_fM);
        test("5800000075000000", "" + f_i + sf_i);
        test("5800000044", "" + f_i + f_b);
        test("58000000-1705032704", "" + f_i + sf_lM);
        test("58000000null", "" + f_i + f_oAN);
        test("5800000083.0", "" + f_i + f_d);
        test("58000000I", "" + f_i + f_c);
        test("5800000094.0", "" + f_i + f_f);
        test("5800000012.0", "" + f_i + sf_d);
        test("58000000-99.0", "" + f_i + f_dM);
        test("5800000017.0", "" + f_i + sf_f);
        test("58000000-84.0", "" + f_i + sf_dM);
        test("5800000058000000", "" + f_i + f_i);
        test("58000000-55000000", "" + f_i + f_iM);
        test("580000001460392448", "" + f_i + f_l);
        test("58000000C(70)", "" + f_i + f_o);
        test("58000000\u04511", "" + f_i + sf_strU);
        test("580000008000", "" + f_i + f_s);
        test("5800000018", "" + f_i + s_str);
        test("58000000-1000000", "" + f_i + s_iM);
        test("580000001000000", "" + f_i + sf_I);
        test("58000000null", "" + f_i + f_oNtS);
        test("58000000false", "" + f_i + f_bl);
        test("58000000null", "" + f_i + sf_iAN);
        test("58000000-2000000", "" + f_i + sf_iM);
        test("58000000-820130816", "" + f_i + f_lM);
        test("58000000null", "" + f_i + sf_oAN);
        test("5800000025000000", "" + f_i + s_I);
        test("-55000000-96.0", "" + f_iM + s_dM);
        test("-55000000null", "" + f_iM + s_oNtS);
        test("-55000000\u045176", "" + f_iM + f_strU);
        test("-5500000092", "" + f_iM + sf_strU2);
        test("-5500000051", "" + f_iM + sf_strU1);
        test("-55000000null", "" + f_iM + s_iAN);
        test("-55000000-54", "" + f_iM + f_bM);
        test("-55000000-87.0", "" + f_iM + f_fM);
        test("-55000000null", "" + f_iM + s_oAN);
        test("-5500000019", "" + f_iM + f_str);
        test("-55000000-41", "" + f_iM + sf_bM);
        test("-55000000null", "" + f_iM + sf_IN);
        test("-55000000T", "" + f_iM + s_c);
        test("-55000000-42.0", "" + f_iM + sf_fM);
        test("-5500000025", "" + f_iM + s_b);
        test("-55000000null", "" + f_iM + f_oN);
        test("-55000000-1410065408", "" + f_iM + s_lM);
        test("-550000008.0", "" + f_iM + s_d);
        test("-5500000055.0", "" + f_iM + s_f);
        test("-5500000097000000", "" + f_iM + s_i);
        test("-55000000-9900", "" + f_iM + f_sM);
        test("-55000000935228928", "" + f_iM + s_l);
        test("-55000000-8400", "" + f_iM + sf_sM);
        test("-55000000C(82)", "" + f_iM + s_o);
        test("-55000000null", "" + f_iM + sf_oNtS);
        test("-55000000true", "" + f_iM + s_bl);
        test("-550000003900", "" + f_iM + s_s);
        test("-55000000null", "" + f_iM + sf_oN);
        test("-5500000094000000", "" + f_iM + f_I);
        test("-55000000null", "" + f_iM + f_IN);
        test("-55000000true", "" + f_iM + sf_bl);
        test("-550000005500", "" + f_iM + sf_s);
        test("-55000000-2900", "" + f_iM + s_sM);
        test("-55000000-194313216", "" + f_iM + sf_l);
        test("-5500000012", "" + f_iM + s_strU1);
        test("-55000000C(87)", "" + f_iM + sf_o);
        test("-5500000091", "" + f_iM + s_strU2);
        test("-5500000021", "" + f_iM + f_strU1);
        test("-5500000018", "" + f_iM + f_strU2);
        test("-55000000null", "" + f_iM + f_iAN);
        test("-55000000null", "" + f_iM + s_oN);
        test("-55000000\u045180", "" + f_iM + s_strU);
        test("-55000000C", "" + f_iM + sf_c);
        test("-5500000075", "" + f_iM + sf_str);
        test("-55000000-43", "" + f_iM + s_bM);
        test("-5500000080", "" + f_iM + sf_b);
        test("-55000000null", "" + f_iM + s_IN);
        test("-55000000-52.0", "" + f_iM + s_fM);
        test("-5500000075000000", "" + f_iM + sf_i);
        test("-5500000044", "" + f_iM + f_b);
        test("-55000000-1705032704", "" + f_iM + sf_lM);
        test("-55000000null", "" + f_iM + f_oAN);
        test("-5500000083.0", "" + f_iM + f_d);
        test("-55000000I", "" + f_iM + f_c);
        test("-5500000094.0", "" + f_iM + f_f);
        test("-5500000012.0", "" + f_iM + sf_d);
        test("-55000000-99.0", "" + f_iM + f_dM);
        test("-5500000017.0", "" + f_iM + sf_f);
        test("-55000000-84.0", "" + f_iM + sf_dM);
        test("-5500000058000000", "" + f_iM + f_i);
        test("-55000000-55000000", "" + f_iM + f_iM);
        test("-550000001460392448", "" + f_iM + f_l);
        test("-55000000C(70)", "" + f_iM + f_o);
        test("-55000000\u04511", "" + f_iM + sf_strU);
        test("-550000008000", "" + f_iM + f_s);
        test("-5500000018", "" + f_iM + s_str);
        test("-55000000-1000000", "" + f_iM + s_iM);
        test("-550000001000000", "" + f_iM + sf_I);
        test("-55000000null", "" + f_iM + f_oNtS);
        test("-55000000false", "" + f_iM + f_bl);
        test("-55000000null", "" + f_iM + sf_iAN);
        test("-55000000-2000000", "" + f_iM + sf_iM);
        test("-55000000-820130816", "" + f_iM + f_lM);
        test("-55000000null", "" + f_iM + sf_oAN);
        test("-5500000025000000", "" + f_iM + s_I);
        test("1460392448-96.0", "" + f_l + s_dM);
        test("1460392448null", "" + f_l + s_oNtS);
        test("1460392448\u045176", "" + f_l + f_strU);
        test("146039244892", "" + f_l + sf_strU2);
        test("146039244851", "" + f_l + sf_strU1);
        test("1460392448null", "" + f_l + s_iAN);
        test("1460392448-54", "" + f_l + f_bM);
        test("1460392448-87.0", "" + f_l + f_fM);
        test("1460392448null", "" + f_l + s_oAN);
        test("146039244819", "" + f_l + f_str);
        test("1460392448-41", "" + f_l + sf_bM);
        test("1460392448null", "" + f_l + sf_IN);
        test("1460392448T", "" + f_l + s_c);
        test("1460392448-42.0", "" + f_l + sf_fM);
        test("146039244825", "" + f_l + s_b);
        test("1460392448null", "" + f_l + f_oN);
        test("1460392448-1410065408", "" + f_l + s_lM);
        test("14603924488.0", "" + f_l + s_d);
        test("146039244855.0", "" + f_l + s_f);
        test("146039244897000000", "" + f_l + s_i);
        test("1460392448-9900", "" + f_l + f_sM);
        test("1460392448935228928", "" + f_l + s_l);
        test("1460392448-8400", "" + f_l + sf_sM);
        test("1460392448C(82)", "" + f_l + s_o);
        test("1460392448null", "" + f_l + sf_oNtS);
        test("1460392448true", "" + f_l + s_bl);
        test("14603924483900", "" + f_l + s_s);
        test("1460392448null", "" + f_l + sf_oN);
        test("146039244894000000", "" + f_l + f_I);
        test("1460392448null", "" + f_l + f_IN);
        test("1460392448true", "" + f_l + sf_bl);
        test("14603924485500", "" + f_l + sf_s);
        test("1460392448-2900", "" + f_l + s_sM);
        test("1460392448-194313216", "" + f_l + sf_l);
        test("146039244812", "" + f_l + s_strU1);
        test("1460392448C(87)", "" + f_l + sf_o);
        test("146039244891", "" + f_l + s_strU2);
        test("146039244821", "" + f_l + f_strU1);
        test("146039244818", "" + f_l + f_strU2);
        test("1460392448null", "" + f_l + f_iAN);
        test("1460392448null", "" + f_l + s_oN);
        test("1460392448\u045180", "" + f_l + s_strU);
        test("1460392448C", "" + f_l + sf_c);
        test("146039244875", "" + f_l + sf_str);
        test("1460392448-43", "" + f_l + s_bM);
        test("146039244880", "" + f_l + sf_b);
        test("1460392448null", "" + f_l + s_IN);
        test("1460392448-52.0", "" + f_l + s_fM);
        test("146039244875000000", "" + f_l + sf_i);
        test("146039244844", "" + f_l + f_b);
        test("1460392448-1705032704", "" + f_l + sf_lM);
        test("1460392448null", "" + f_l + f_oAN);
        test("146039244883.0", "" + f_l + f_d);
        test("1460392448I", "" + f_l + f_c);
        test("146039244894.0", "" + f_l + f_f);
        test("146039244812.0", "" + f_l + sf_d);
        test("1460392448-99.0", "" + f_l + f_dM);
        test("146039244817.0", "" + f_l + sf_f);
        test("1460392448-84.0", "" + f_l + sf_dM);
        test("146039244858000000", "" + f_l + f_i);
        test("1460392448-55000000", "" + f_l + f_iM);
        test("14603924481460392448", "" + f_l + f_l);
        test("1460392448C(70)", "" + f_l + f_o);
        test("1460392448\u04511", "" + f_l + sf_strU);
        test("14603924488000", "" + f_l + f_s);
        test("146039244818", "" + f_l + s_str);
        test("1460392448-1000000", "" + f_l + s_iM);
        test("14603924481000000", "" + f_l + sf_I);
        test("1460392448null", "" + f_l + f_oNtS);
        test("1460392448false", "" + f_l + f_bl);
        test("1460392448null", "" + f_l + sf_iAN);
        test("1460392448-2000000", "" + f_l + sf_iM);
        test("1460392448-820130816", "" + f_l + f_lM);
        test("1460392448null", "" + f_l + sf_oAN);
        test("146039244825000000", "" + f_l + s_I);
        test("C(70)-96.0", "" + f_o + s_dM);
        test("C(70)null", "" + f_o + s_oNtS);
        test("C(70)\u045176", "" + f_o + f_strU);
        test("C(70)92", "" + f_o + sf_strU2);
        test("C(70)51", "" + f_o + sf_strU1);
        test("C(70)null", "" + f_o + s_iAN);
        test("C(70)-54", "" + f_o + f_bM);
        test("C(70)-87.0", "" + f_o + f_fM);
        test("C(70)null", "" + f_o + s_oAN);
        test("C(70)19", "" + f_o + f_str);
        test("C(70)-41", "" + f_o + sf_bM);
        test("C(70)null", "" + f_o + sf_IN);
        test("C(70)T", "" + f_o + s_c);
        test("C(70)-42.0", "" + f_o + sf_fM);
        test("C(70)25", "" + f_o + s_b);
        test("C(70)null", "" + f_o + f_oN);
        test("C(70)-1410065408", "" + f_o + s_lM);
        test("C(70)8.0", "" + f_o + s_d);
        test("C(70)55.0", "" + f_o + s_f);
        test("C(70)97000000", "" + f_o + s_i);
        test("C(70)-9900", "" + f_o + f_sM);
        test("C(70)935228928", "" + f_o + s_l);
        test("C(70)-8400", "" + f_o + sf_sM);
        test("C(70)C(82)", "" + f_o + s_o);
        test("C(70)null", "" + f_o + sf_oNtS);
        test("C(70)true", "" + f_o + s_bl);
        test("C(70)3900", "" + f_o + s_s);
        test("C(70)null", "" + f_o + sf_oN);
        test("C(70)94000000", "" + f_o + f_I);
        test("C(70)null", "" + f_o + f_IN);
        test("C(70)true", "" + f_o + sf_bl);
        test("C(70)5500", "" + f_o + sf_s);
        test("C(70)-2900", "" + f_o + s_sM);
        test("C(70)-194313216", "" + f_o + sf_l);
        test("C(70)12", "" + f_o + s_strU1);
        test("C(70)C(87)", "" + f_o + sf_o);
        test("C(70)91", "" + f_o + s_strU2);
        test("C(70)21", "" + f_o + f_strU1);
        test("C(70)18", "" + f_o + f_strU2);
        test("C(70)null", "" + f_o + f_iAN);
        test("C(70)null", "" + f_o + s_oN);
        test("C(70)\u045180", "" + f_o + s_strU);
        test("C(70)C", "" + f_o + sf_c);
        test("C(70)75", "" + f_o + sf_str);
        test("C(70)-43", "" + f_o + s_bM);
        test("C(70)80", "" + f_o + sf_b);
        test("C(70)null", "" + f_o + s_IN);
        test("C(70)-52.0", "" + f_o + s_fM);
        test("C(70)75000000", "" + f_o + sf_i);
        test("C(70)44", "" + f_o + f_b);
        test("C(70)-1705032704", "" + f_o + sf_lM);
        test("C(70)null", "" + f_o + f_oAN);
        test("C(70)83.0", "" + f_o + f_d);
        test("C(70)I", "" + f_o + f_c);
        test("C(70)94.0", "" + f_o + f_f);
        test("C(70)12.0", "" + f_o + sf_d);
        test("C(70)-99.0", "" + f_o + f_dM);
        test("C(70)17.0", "" + f_o + sf_f);
        test("C(70)-84.0", "" + f_o + sf_dM);
        test("C(70)58000000", "" + f_o + f_i);
        test("C(70)-55000000", "" + f_o + f_iM);
        test("C(70)1460392448", "" + f_o + f_l);
        test("C(70)C(70)", "" + f_o + f_o);
        test("C(70)\u04511", "" + f_o + sf_strU);
        test("C(70)8000", "" + f_o + f_s);
        test("C(70)18", "" + f_o + s_str);
        test("C(70)-1000000", "" + f_o + s_iM);
        test("C(70)1000000", "" + f_o + sf_I);
        test("C(70)null", "" + f_o + f_oNtS);
        test("C(70)false", "" + f_o + f_bl);
        test("C(70)null", "" + f_o + sf_iAN);
        test("C(70)-2000000", "" + f_o + sf_iM);
        test("C(70)-820130816", "" + f_o + f_lM);
        test("C(70)null", "" + f_o + sf_oAN);
        test("C(70)25000000", "" + f_o + s_I);
        test("\u04511-96.0", "" + sf_strU + s_dM);
        test("\u04511null", "" + sf_strU + s_oNtS);
        test("\u04511\u045176", "" + sf_strU + f_strU);
        test("\u0451192", "" + sf_strU + sf_strU2);
        test("\u0451151", "" + sf_strU + sf_strU1);
        test("\u04511null", "" + sf_strU + s_iAN);
        test("\u04511-54", "" + sf_strU + f_bM);
        test("\u04511-87.0", "" + sf_strU + f_fM);
        test("\u04511null", "" + sf_strU + s_oAN);
        test("\u0451119", "" + sf_strU + f_str);
        test("\u04511-41", "" + sf_strU + sf_bM);
        test("\u04511null", "" + sf_strU + sf_IN);
        test("\u04511T", "" + sf_strU + s_c);
        test("\u04511-42.0", "" + sf_strU + sf_fM);
        test("\u0451125", "" + sf_strU + s_b);
        test("\u04511null", "" + sf_strU + f_oN);
        test("\u04511-1410065408", "" + sf_strU + s_lM);
        test("\u045118.0", "" + sf_strU + s_d);
        test("\u0451155.0", "" + sf_strU + s_f);
        test("\u0451197000000", "" + sf_strU + s_i);
        test("\u04511-9900", "" + sf_strU + f_sM);
        test("\u04511935228928", "" + sf_strU + s_l);
        test("\u04511-8400", "" + sf_strU + sf_sM);
        test("\u04511C(82)", "" + sf_strU + s_o);
        test("\u04511null", "" + sf_strU + sf_oNtS);
        test("\u04511true", "" + sf_strU + s_bl);
        test("\u045113900", "" + sf_strU + s_s);
        test("\u04511null", "" + sf_strU + sf_oN);
        test("\u0451194000000", "" + sf_strU + f_I);
        test("\u04511null", "" + sf_strU + f_IN);
        test("\u04511true", "" + sf_strU + sf_bl);
        test("\u045115500", "" + sf_strU + sf_s);
        test("\u04511-2900", "" + sf_strU + s_sM);
        test("\u04511-194313216", "" + sf_strU + sf_l);
        test("\u0451112", "" + sf_strU + s_strU1);
        test("\u04511C(87)", "" + sf_strU + sf_o);
        test("\u0451191", "" + sf_strU + s_strU2);
        test("\u0451121", "" + sf_strU + f_strU1);
        test("\u0451118", "" + sf_strU + f_strU2);
        test("\u04511null", "" + sf_strU + f_iAN);
        test("\u04511null", "" + sf_strU + s_oN);
        test("\u04511\u045180", "" + sf_strU + s_strU);
        test("\u04511C", "" + sf_strU + sf_c);
        test("\u0451175", "" + sf_strU + sf_str);
        test("\u04511-43", "" + sf_strU + s_bM);
        test("\u0451180", "" + sf_strU + sf_b);
        test("\u04511null", "" + sf_strU + s_IN);
        test("\u04511-52.0", "" + sf_strU + s_fM);
        test("\u0451175000000", "" + sf_strU + sf_i);
        test("\u0451144", "" + sf_strU + f_b);
        test("\u04511-1705032704", "" + sf_strU + sf_lM);
        test("\u04511null", "" + sf_strU + f_oAN);
        test("\u0451183.0", "" + sf_strU + f_d);
        test("\u04511I", "" + sf_strU + f_c);
        test("\u0451194.0", "" + sf_strU + f_f);
        test("\u0451112.0", "" + sf_strU + sf_d);
        test("\u04511-99.0", "" + sf_strU + f_dM);
        test("\u0451117.0", "" + sf_strU + sf_f);
        test("\u04511-84.0", "" + sf_strU + sf_dM);
        test("\u0451158000000", "" + sf_strU + f_i);
        test("\u04511-55000000", "" + sf_strU + f_iM);
        test("\u045111460392448", "" + sf_strU + f_l);
        test("\u04511C(70)", "" + sf_strU + f_o);
        test("\u04511\u04511", "" + sf_strU + sf_strU);
        test("\u045118000", "" + sf_strU + f_s);
        test("\u0451118", "" + sf_strU + s_str);
        test("\u04511-1000000", "" + sf_strU + s_iM);
        test("\u045111000000", "" + sf_strU + sf_I);
        test("\u04511null", "" + sf_strU + f_oNtS);
        test("\u04511false", "" + sf_strU + f_bl);
        test("\u04511null", "" + sf_strU + sf_iAN);
        test("\u04511-2000000", "" + sf_strU + sf_iM);
        test("\u04511-820130816", "" + sf_strU + f_lM);
        test("\u04511null", "" + sf_strU + sf_oAN);
        test("\u0451125000000", "" + sf_strU + s_I);
        test("8000-96.0", "" + f_s + s_dM);
        test("8000null", "" + f_s + s_oNtS);
        test("8000\u045176", "" + f_s + f_strU);
        test("800092", "" + f_s + sf_strU2);
        test("800051", "" + f_s + sf_strU1);
        test("8000null", "" + f_s + s_iAN);
        test("8000-54", "" + f_s + f_bM);
        test("8000-87.0", "" + f_s + f_fM);
        test("8000null", "" + f_s + s_oAN);
        test("800019", "" + f_s + f_str);
        test("8000-41", "" + f_s + sf_bM);
        test("8000null", "" + f_s + sf_IN);
        test("8000T", "" + f_s + s_c);
        test("8000-42.0", "" + f_s + sf_fM);
        test("800025", "" + f_s + s_b);
        test("8000null", "" + f_s + f_oN);
        test("8000-1410065408", "" + f_s + s_lM);
        test("80008.0", "" + f_s + s_d);
        test("800055.0", "" + f_s + s_f);
        test("800097000000", "" + f_s + s_i);
        test("8000-9900", "" + f_s + f_sM);
        test("8000935228928", "" + f_s + s_l);
        test("8000-8400", "" + f_s + sf_sM);
        test("8000C(82)", "" + f_s + s_o);
        test("8000null", "" + f_s + sf_oNtS);
        test("8000true", "" + f_s + s_bl);
        test("80003900", "" + f_s + s_s);
        test("8000null", "" + f_s + sf_oN);
        test("800094000000", "" + f_s + f_I);
        test("8000null", "" + f_s + f_IN);
        test("8000true", "" + f_s + sf_bl);
        test("80005500", "" + f_s + sf_s);
        test("8000-2900", "" + f_s + s_sM);
        test("8000-194313216", "" + f_s + sf_l);
        test("800012", "" + f_s + s_strU1);
        test("8000C(87)", "" + f_s + sf_o);
        test("800091", "" + f_s + s_strU2);
        test("800021", "" + f_s + f_strU1);
        test("800018", "" + f_s + f_strU2);
        test("8000null", "" + f_s + f_iAN);
        test("8000null", "" + f_s + s_oN);
        test("8000\u045180", "" + f_s + s_strU);
        test("8000C", "" + f_s + sf_c);
        test("800075", "" + f_s + sf_str);
        test("8000-43", "" + f_s + s_bM);
        test("800080", "" + f_s + sf_b);
        test("8000null", "" + f_s + s_IN);
        test("8000-52.0", "" + f_s + s_fM);
        test("800075000000", "" + f_s + sf_i);
        test("800044", "" + f_s + f_b);
        test("8000-1705032704", "" + f_s + sf_lM);
        test("8000null", "" + f_s + f_oAN);
        test("800083.0", "" + f_s + f_d);
        test("8000I", "" + f_s + f_c);
        test("800094.0", "" + f_s + f_f);
        test("800012.0", "" + f_s + sf_d);
        test("8000-99.0", "" + f_s + f_dM);
        test("800017.0", "" + f_s + sf_f);
        test("8000-84.0", "" + f_s + sf_dM);
        test("800058000000", "" + f_s + f_i);
        test("8000-55000000", "" + f_s + f_iM);
        test("80001460392448", "" + f_s + f_l);
        test("8000C(70)", "" + f_s + f_o);
        test("8000\u04511", "" + f_s + sf_strU);
        test("80008000", "" + f_s + f_s);
        test("800018", "" + f_s + s_str);
        test("8000-1000000", "" + f_s + s_iM);
        test("80001000000", "" + f_s + sf_I);
        test("8000null", "" + f_s + f_oNtS);
        test("8000false", "" + f_s + f_bl);
        test("8000null", "" + f_s + sf_iAN);
        test("8000-2000000", "" + f_s + sf_iM);
        test("8000-820130816", "" + f_s + f_lM);
        test("8000null", "" + f_s + sf_oAN);
        test("800025000000", "" + f_s + s_I);
        test("18-96.0", "" + s_str + s_dM);
        test("18null", "" + s_str + s_oNtS);
        test("18\u045176", "" + s_str + f_strU);
        test("1892", "" + s_str + sf_strU2);
        test("1851", "" + s_str + sf_strU1);
        test("18null", "" + s_str + s_iAN);
        test("18-54", "" + s_str + f_bM);
        test("18-87.0", "" + s_str + f_fM);
        test("18null", "" + s_str + s_oAN);
        test("1819", "" + s_str + f_str);
        test("18-41", "" + s_str + sf_bM);
        test("18null", "" + s_str + sf_IN);
        test("18T", "" + s_str + s_c);
        test("18-42.0", "" + s_str + sf_fM);
        test("1825", "" + s_str + s_b);
        test("18null", "" + s_str + f_oN);
        test("18-1410065408", "" + s_str + s_lM);
        test("188.0", "" + s_str + s_d);
        test("1855.0", "" + s_str + s_f);
        test("1897000000", "" + s_str + s_i);
        test("18-9900", "" + s_str + f_sM);
        test("18935228928", "" + s_str + s_l);
        test("18-8400", "" + s_str + sf_sM);
        test("18C(82)", "" + s_str + s_o);
        test("18null", "" + s_str + sf_oNtS);
        test("18true", "" + s_str + s_bl);
        test("183900", "" + s_str + s_s);
        test("18null", "" + s_str + sf_oN);
        test("1894000000", "" + s_str + f_I);
        test("18null", "" + s_str + f_IN);
        test("18true", "" + s_str + sf_bl);
        test("185500", "" + s_str + sf_s);
        test("18-2900", "" + s_str + s_sM);
        test("18-194313216", "" + s_str + sf_l);
        test("1812", "" + s_str + s_strU1);
        test("18C(87)", "" + s_str + sf_o);
        test("1891", "" + s_str + s_strU2);
        test("1821", "" + s_str + f_strU1);
        test("1818", "" + s_str + f_strU2);
        test("18null", "" + s_str + f_iAN);
        test("18null", "" + s_str + s_oN);
        test("18\u045180", "" + s_str + s_strU);
        test("18C", "" + s_str + sf_c);
        test("1875", "" + s_str + sf_str);
        test("18-43", "" + s_str + s_bM);
        test("1880", "" + s_str + sf_b);
        test("18null", "" + s_str + s_IN);
        test("18-52.0", "" + s_str + s_fM);
        test("1875000000", "" + s_str + sf_i);
        test("1844", "" + s_str + f_b);
    }

    public void run5() {
        test("18-1705032704", "" + s_str + sf_lM);
        test("18null", "" + s_str + f_oAN);
        test("1883.0", "" + s_str + f_d);
        test("18I", "" + s_str + f_c);
        test("1894.0", "" + s_str + f_f);
        test("1812.0", "" + s_str + sf_d);
        test("18-99.0", "" + s_str + f_dM);
        test("1817.0", "" + s_str + sf_f);
        test("18-84.0", "" + s_str + sf_dM);
        test("1858000000", "" + s_str + f_i);
        test("18-55000000", "" + s_str + f_iM);
        test("181460392448", "" + s_str + f_l);
        test("18C(70)", "" + s_str + f_o);
        test("18\u04511", "" + s_str + sf_strU);
        test("188000", "" + s_str + f_s);
        test("1818", "" + s_str + s_str);
        test("18-1000000", "" + s_str + s_iM);
        test("181000000", "" + s_str + sf_I);
        test("18null", "" + s_str + f_oNtS);
        test("18false", "" + s_str + f_bl);
        test("18null", "" + s_str + sf_iAN);
        test("18-2000000", "" + s_str + sf_iM);
        test("18-820130816", "" + s_str + f_lM);
        test("18null", "" + s_str + sf_oAN);
        test("1825000000", "" + s_str + s_I);
        test("-1000000-96.0", "" + s_iM + s_dM);
        test("-1000000null", "" + s_iM + s_oNtS);
        test("-1000000\u045176", "" + s_iM + f_strU);
        test("-100000092", "" + s_iM + sf_strU2);
        test("-100000051", "" + s_iM + sf_strU1);
        test("-1000000null", "" + s_iM + s_iAN);
        test("-1000000-54", "" + s_iM + f_bM);
        test("-1000000-87.0", "" + s_iM + f_fM);
        test("-1000000null", "" + s_iM + s_oAN);
        test("-100000019", "" + s_iM + f_str);
        test("-1000000-41", "" + s_iM + sf_bM);
        test("-1000000null", "" + s_iM + sf_IN);
        test("-1000000T", "" + s_iM + s_c);
        test("-1000000-42.0", "" + s_iM + sf_fM);
        test("-100000025", "" + s_iM + s_b);
        test("-1000000null", "" + s_iM + f_oN);
        test("-1000000-1410065408", "" + s_iM + s_lM);
        test("-10000008.0", "" + s_iM + s_d);
        test("-100000055.0", "" + s_iM + s_f);
        test("-100000097000000", "" + s_iM + s_i);
        test("-1000000-9900", "" + s_iM + f_sM);
        test("-1000000935228928", "" + s_iM + s_l);
        test("-1000000-8400", "" + s_iM + sf_sM);
        test("-1000000C(82)", "" + s_iM + s_o);
        test("-1000000null", "" + s_iM + sf_oNtS);
        test("-1000000true", "" + s_iM + s_bl);
        test("-10000003900", "" + s_iM + s_s);
        test("-1000000null", "" + s_iM + sf_oN);
        test("-100000094000000", "" + s_iM + f_I);
        test("-1000000null", "" + s_iM + f_IN);
        test("-1000000true", "" + s_iM + sf_bl);
        test("-10000005500", "" + s_iM + sf_s);
        test("-1000000-2900", "" + s_iM + s_sM);
        test("-1000000-194313216", "" + s_iM + sf_l);
        test("-100000012", "" + s_iM + s_strU1);
        test("-1000000C(87)", "" + s_iM + sf_o);
        test("-100000091", "" + s_iM + s_strU2);
        test("-100000021", "" + s_iM + f_strU1);
        test("-100000018", "" + s_iM + f_strU2);
        test("-1000000null", "" + s_iM + f_iAN);
        test("-1000000null", "" + s_iM + s_oN);
        test("-1000000\u045180", "" + s_iM + s_strU);
        test("-1000000C", "" + s_iM + sf_c);
        test("-100000075", "" + s_iM + sf_str);
        test("-1000000-43", "" + s_iM + s_bM);
        test("-100000080", "" + s_iM + sf_b);
        test("-1000000null", "" + s_iM + s_IN);
        test("-1000000-52.0", "" + s_iM + s_fM);
        test("-100000075000000", "" + s_iM + sf_i);
        test("-100000044", "" + s_iM + f_b);
        test("-1000000-1705032704", "" + s_iM + sf_lM);
        test("-1000000null", "" + s_iM + f_oAN);
        test("-100000083.0", "" + s_iM + f_d);
        test("-1000000I", "" + s_iM + f_c);
        test("-100000094.0", "" + s_iM + f_f);
        test("-100000012.0", "" + s_iM + sf_d);
        test("-1000000-99.0", "" + s_iM + f_dM);
        test("-100000017.0", "" + s_iM + sf_f);
        test("-1000000-84.0", "" + s_iM + sf_dM);
        test("-100000058000000", "" + s_iM + f_i);
        test("-1000000-55000000", "" + s_iM + f_iM);
        test("-10000001460392448", "" + s_iM + f_l);
        test("-1000000C(70)", "" + s_iM + f_o);
        test("-1000000\u04511", "" + s_iM + sf_strU);
        test("-10000008000", "" + s_iM + f_s);
        test("-100000018", "" + s_iM + s_str);
        test("-1000000-1000000", "" + s_iM + s_iM);
        test("-10000001000000", "" + s_iM + sf_I);
        test("-1000000null", "" + s_iM + f_oNtS);
        test("-1000000false", "" + s_iM + f_bl);
        test("-1000000null", "" + s_iM + sf_iAN);
        test("-1000000-2000000", "" + s_iM + sf_iM);
        test("-1000000-820130816", "" + s_iM + f_lM);
        test("-1000000null", "" + s_iM + sf_oAN);
        test("-100000025000000", "" + s_iM + s_I);
        test("1000000-96.0", "" + sf_I + s_dM);
        test("1000000null", "" + sf_I + s_oNtS);
        test("1000000\u045176", "" + sf_I + f_strU);
        test("100000092", "" + sf_I + sf_strU2);
        test("100000051", "" + sf_I + sf_strU1);
        test("1000000null", "" + sf_I + s_iAN);
        test("1000000-54", "" + sf_I + f_bM);
        test("1000000-87.0", "" + sf_I + f_fM);
        test("1000000null", "" + sf_I + s_oAN);
        test("100000019", "" + sf_I + f_str);
        test("1000000-41", "" + sf_I + sf_bM);
        test("1000000null", "" + sf_I + sf_IN);
        test("1000000T", "" + sf_I + s_c);
        test("1000000-42.0", "" + sf_I + sf_fM);
        test("100000025", "" + sf_I + s_b);
        test("1000000null", "" + sf_I + f_oN);
        test("1000000-1410065408", "" + sf_I + s_lM);
        test("10000008.0", "" + sf_I + s_d);
        test("100000055.0", "" + sf_I + s_f);
        test("100000097000000", "" + sf_I + s_i);
        test("1000000-9900", "" + sf_I + f_sM);
        test("1000000935228928", "" + sf_I + s_l);
        test("1000000-8400", "" + sf_I + sf_sM);
        test("1000000C(82)", "" + sf_I + s_o);
        test("1000000null", "" + sf_I + sf_oNtS);
        test("1000000true", "" + sf_I + s_bl);
        test("10000003900", "" + sf_I + s_s);
        test("1000000null", "" + sf_I + sf_oN);
        test("100000094000000", "" + sf_I + f_I);
        test("1000000null", "" + sf_I + f_IN);
        test("1000000true", "" + sf_I + sf_bl);
        test("10000005500", "" + sf_I + sf_s);
        test("1000000-2900", "" + sf_I + s_sM);
        test("1000000-194313216", "" + sf_I + sf_l);
        test("100000012", "" + sf_I + s_strU1);
        test("1000000C(87)", "" + sf_I + sf_o);
        test("100000091", "" + sf_I + s_strU2);
        test("100000021", "" + sf_I + f_strU1);
        test("100000018", "" + sf_I + f_strU2);
        test("1000000null", "" + sf_I + f_iAN);
        test("1000000null", "" + sf_I + s_oN);
        test("1000000\u045180", "" + sf_I + s_strU);
        test("1000000C", "" + sf_I + sf_c);
        test("100000075", "" + sf_I + sf_str);
        test("1000000-43", "" + sf_I + s_bM);
        test("100000080", "" + sf_I + sf_b);
        test("1000000null", "" + sf_I + s_IN);
        test("1000000-52.0", "" + sf_I + s_fM);
        test("100000075000000", "" + sf_I + sf_i);
        test("100000044", "" + sf_I + f_b);
        test("1000000-1705032704", "" + sf_I + sf_lM);
        test("1000000null", "" + sf_I + f_oAN);
        test("100000083.0", "" + sf_I + f_d);
        test("1000000I", "" + sf_I + f_c);
        test("100000094.0", "" + sf_I + f_f);
        test("100000012.0", "" + sf_I + sf_d);
        test("1000000-99.0", "" + sf_I + f_dM);
        test("100000017.0", "" + sf_I + sf_f);
        test("1000000-84.0", "" + sf_I + sf_dM);
        test("100000058000000", "" + sf_I + f_i);
        test("1000000-55000000", "" + sf_I + f_iM);
        test("10000001460392448", "" + sf_I + f_l);
        test("1000000C(70)", "" + sf_I + f_o);
        test("1000000\u04511", "" + sf_I + sf_strU);
        test("10000008000", "" + sf_I + f_s);
        test("100000018", "" + sf_I + s_str);
        test("1000000-1000000", "" + sf_I + s_iM);
        test("10000001000000", "" + sf_I + sf_I);
        test("1000000null", "" + sf_I + f_oNtS);
        test("1000000false", "" + sf_I + f_bl);
        test("1000000null", "" + sf_I + sf_iAN);
        test("1000000-2000000", "" + sf_I + sf_iM);
        test("1000000-820130816", "" + sf_I + f_lM);
        test("1000000null", "" + sf_I + sf_oAN);
        test("100000025000000", "" + sf_I + s_I);
        test("null-96.0", "" + f_oNtS + s_dM);
        test("nullnull", "" + f_oNtS + s_oNtS);
        test("null\u045176", "" + f_oNtS + f_strU);
        test("null92", "" + f_oNtS + sf_strU2);
        test("null51", "" + f_oNtS + sf_strU1);
        test("nullnull", "" + f_oNtS + s_iAN);
        test("null-54", "" + f_oNtS + f_bM);
        test("null-87.0", "" + f_oNtS + f_fM);
        test("nullnull", "" + f_oNtS + s_oAN);
        test("null19", "" + f_oNtS + f_str);
        test("null-41", "" + f_oNtS + sf_bM);
        test("nullnull", "" + f_oNtS + sf_IN);
        test("nullT", "" + f_oNtS + s_c);
        test("null-42.0", "" + f_oNtS + sf_fM);
        test("null25", "" + f_oNtS + s_b);
        test("nullnull", "" + f_oNtS + f_oN);
        test("null-1410065408", "" + f_oNtS + s_lM);
        test("null8.0", "" + f_oNtS + s_d);
        test("null55.0", "" + f_oNtS + s_f);
        test("null97000000", "" + f_oNtS + s_i);
        test("null-9900", "" + f_oNtS + f_sM);
        test("null935228928", "" + f_oNtS + s_l);
        test("null-8400", "" + f_oNtS + sf_sM);
        test("nullC(82)", "" + f_oNtS + s_o);
        test("nullnull", "" + f_oNtS + sf_oNtS);
        test("nulltrue", "" + f_oNtS + s_bl);
        test("null3900", "" + f_oNtS + s_s);
        test("nullnull", "" + f_oNtS + sf_oN);
        test("null94000000", "" + f_oNtS + f_I);
        test("nullnull", "" + f_oNtS + f_IN);
        test("nulltrue", "" + f_oNtS + sf_bl);
        test("null5500", "" + f_oNtS + sf_s);
        test("null-2900", "" + f_oNtS + s_sM);
        test("null-194313216", "" + f_oNtS + sf_l);
        test("null12", "" + f_oNtS + s_strU1);
        test("nullC(87)", "" + f_oNtS + sf_o);
        test("null91", "" + f_oNtS + s_strU2);
        test("null21", "" + f_oNtS + f_strU1);
        test("null18", "" + f_oNtS + f_strU2);
        test("nullnull", "" + f_oNtS + f_iAN);
        test("nullnull", "" + f_oNtS + s_oN);
        test("null\u045180", "" + f_oNtS + s_strU);
        test("nullC", "" + f_oNtS + sf_c);
        test("null75", "" + f_oNtS + sf_str);
        test("null-43", "" + f_oNtS + s_bM);
        test("null80", "" + f_oNtS + sf_b);
        test("nullnull", "" + f_oNtS + s_IN);
        test("null-52.0", "" + f_oNtS + s_fM);
        test("null75000000", "" + f_oNtS + sf_i);
        test("null44", "" + f_oNtS + f_b);
        test("null-1705032704", "" + f_oNtS + sf_lM);
        test("nullnull", "" + f_oNtS + f_oAN);
        test("null83.0", "" + f_oNtS + f_d);
        test("nullI", "" + f_oNtS + f_c);
        test("null94.0", "" + f_oNtS + f_f);
        test("null12.0", "" + f_oNtS + sf_d);
        test("null-99.0", "" + f_oNtS + f_dM);
        test("null17.0", "" + f_oNtS + sf_f);
        test("null-84.0", "" + f_oNtS + sf_dM);
        test("null58000000", "" + f_oNtS + f_i);
        test("null-55000000", "" + f_oNtS + f_iM);
        test("null1460392448", "" + f_oNtS + f_l);
        test("nullC(70)", "" + f_oNtS + f_o);
        test("null\u04511", "" + f_oNtS + sf_strU);
        test("null8000", "" + f_oNtS + f_s);
        test("null18", "" + f_oNtS + s_str);
        test("null-1000000", "" + f_oNtS + s_iM);
        test("null1000000", "" + f_oNtS + sf_I);
        test("nullnull", "" + f_oNtS + f_oNtS);
        test("nullfalse", "" + f_oNtS + f_bl);
        test("nullnull", "" + f_oNtS + sf_iAN);
        test("null-2000000", "" + f_oNtS + sf_iM);
        test("null-820130816", "" + f_oNtS + f_lM);
        test("nullnull", "" + f_oNtS + sf_oAN);
        test("null25000000", "" + f_oNtS + s_I);
        test("false-96.0", "" + f_bl + s_dM);
        test("falsenull", "" + f_bl + s_oNtS);
        test("false\u045176", "" + f_bl + f_strU);
        test("false92", "" + f_bl + sf_strU2);
        test("false51", "" + f_bl + sf_strU1);
        test("falsenull", "" + f_bl + s_iAN);
        test("false-54", "" + f_bl + f_bM);
        test("false-87.0", "" + f_bl + f_fM);
        test("falsenull", "" + f_bl + s_oAN);
        test("false19", "" + f_bl + f_str);
        test("false-41", "" + f_bl + sf_bM);
        test("falsenull", "" + f_bl + sf_IN);
        test("falseT", "" + f_bl + s_c);
        test("false-42.0", "" + f_bl + sf_fM);
        test("false25", "" + f_bl + s_b);
        test("falsenull", "" + f_bl + f_oN);
        test("false-1410065408", "" + f_bl + s_lM);
        test("false8.0", "" + f_bl + s_d);
        test("false55.0", "" + f_bl + s_f);
        test("false97000000", "" + f_bl + s_i);
        test("false-9900", "" + f_bl + f_sM);
        test("false935228928", "" + f_bl + s_l);
        test("false-8400", "" + f_bl + sf_sM);
        test("falseC(82)", "" + f_bl + s_o);
        test("falsenull", "" + f_bl + sf_oNtS);
        test("falsetrue", "" + f_bl + s_bl);
        test("false3900", "" + f_bl + s_s);
        test("falsenull", "" + f_bl + sf_oN);
        test("false94000000", "" + f_bl + f_I);
        test("falsenull", "" + f_bl + f_IN);
        test("falsetrue", "" + f_bl + sf_bl);
        test("false5500", "" + f_bl + sf_s);
        test("false-2900", "" + f_bl + s_sM);
        test("false-194313216", "" + f_bl + sf_l);
        test("false12", "" + f_bl + s_strU1);
        test("falseC(87)", "" + f_bl + sf_o);
        test("false91", "" + f_bl + s_strU2);
        test("false21", "" + f_bl + f_strU1);
        test("false18", "" + f_bl + f_strU2);
        test("falsenull", "" + f_bl + f_iAN);
        test("falsenull", "" + f_bl + s_oN);
        test("false\u045180", "" + f_bl + s_strU);
        test("falseC", "" + f_bl + sf_c);
        test("false75", "" + f_bl + sf_str);
        test("false-43", "" + f_bl + s_bM);
        test("false80", "" + f_bl + sf_b);
        test("falsenull", "" + f_bl + s_IN);
        test("false-52.0", "" + f_bl + s_fM);
        test("false75000000", "" + f_bl + sf_i);
        test("false44", "" + f_bl + f_b);
        test("false-1705032704", "" + f_bl + sf_lM);
        test("falsenull", "" + f_bl + f_oAN);
        test("false83.0", "" + f_bl + f_d);
        test("falseI", "" + f_bl + f_c);
        test("false94.0", "" + f_bl + f_f);
        test("false12.0", "" + f_bl + sf_d);
        test("false-99.0", "" + f_bl + f_dM);
        test("false17.0", "" + f_bl + sf_f);
        test("false-84.0", "" + f_bl + sf_dM);
        test("false58000000", "" + f_bl + f_i);
        test("false-55000000", "" + f_bl + f_iM);
        test("false1460392448", "" + f_bl + f_l);
        test("falseC(70)", "" + f_bl + f_o);
        test("false\u04511", "" + f_bl + sf_strU);
        test("false8000", "" + f_bl + f_s);
        test("false18", "" + f_bl + s_str);
        test("false-1000000", "" + f_bl + s_iM);
        test("false1000000", "" + f_bl + sf_I);
        test("falsenull", "" + f_bl + f_oNtS);
        test("falsefalse", "" + f_bl + f_bl);
        test("falsenull", "" + f_bl + sf_iAN);
        test("false-2000000", "" + f_bl + sf_iM);
        test("false-820130816", "" + f_bl + f_lM);
        test("falsenull", "" + f_bl + sf_oAN);
        test("false25000000", "" + f_bl + s_I);
        test("null-96.0", "" + sf_iAN + s_dM);
        test("nullnull", "" + sf_iAN + s_oNtS);
        test("null\u045176", "" + sf_iAN + f_strU);
        test("null92", "" + sf_iAN + sf_strU2);
        test("null51", "" + sf_iAN + sf_strU1);
        test("nullnull", "" + sf_iAN + s_iAN);
        test("null-54", "" + sf_iAN + f_bM);
        test("null-87.0", "" + sf_iAN + f_fM);
        test("nullnull", "" + sf_iAN + s_oAN);
        test("null19", "" + sf_iAN + f_str);
        test("null-41", "" + sf_iAN + sf_bM);
        test("nullnull", "" + sf_iAN + sf_IN);
        test("nullT", "" + sf_iAN + s_c);
        test("null-42.0", "" + sf_iAN + sf_fM);
        test("null25", "" + sf_iAN + s_b);
        test("nullnull", "" + sf_iAN + f_oN);
        test("null-1410065408", "" + sf_iAN + s_lM);
        test("null8.0", "" + sf_iAN + s_d);
        test("null55.0", "" + sf_iAN + s_f);
        test("null97000000", "" + sf_iAN + s_i);
        test("null-9900", "" + sf_iAN + f_sM);
        test("null935228928", "" + sf_iAN + s_l);
        test("null-8400", "" + sf_iAN + sf_sM);
        test("nullC(82)", "" + sf_iAN + s_o);
        test("nullnull", "" + sf_iAN + sf_oNtS);
        test("nulltrue", "" + sf_iAN + s_bl);
        test("null3900", "" + sf_iAN + s_s);
        test("nullnull", "" + sf_iAN + sf_oN);
        test("null94000000", "" + sf_iAN + f_I);
        test("nullnull", "" + sf_iAN + f_IN);
        test("nulltrue", "" + sf_iAN + sf_bl);
        test("null5500", "" + sf_iAN + sf_s);
        test("null-2900", "" + sf_iAN + s_sM);
        test("null-194313216", "" + sf_iAN + sf_l);
        test("null12", "" + sf_iAN + s_strU1);
        test("nullC(87)", "" + sf_iAN + sf_o);
        test("null91", "" + sf_iAN + s_strU2);
        test("null21", "" + sf_iAN + f_strU1);
        test("null18", "" + sf_iAN + f_strU2);
        test("nullnull", "" + sf_iAN + f_iAN);
        test("nullnull", "" + sf_iAN + s_oN);
        test("null\u045180", "" + sf_iAN + s_strU);
        test("nullC", "" + sf_iAN + sf_c);
        test("null75", "" + sf_iAN + sf_str);
        test("null-43", "" + sf_iAN + s_bM);
        test("null80", "" + sf_iAN + sf_b);
        test("nullnull", "" + sf_iAN + s_IN);
        test("null-52.0", "" + sf_iAN + s_fM);
        test("null75000000", "" + sf_iAN + sf_i);
        test("null44", "" + sf_iAN + f_b);
        test("null-1705032704", "" + sf_iAN + sf_lM);
        test("nullnull", "" + sf_iAN + f_oAN);
        test("null83.0", "" + sf_iAN + f_d);
        test("nullI", "" + sf_iAN + f_c);
        test("null94.0", "" + sf_iAN + f_f);
        test("null12.0", "" + sf_iAN + sf_d);
        test("null-99.0", "" + sf_iAN + f_dM);
        test("null17.0", "" + sf_iAN + sf_f);
        test("null-84.0", "" + sf_iAN + sf_dM);
        test("null58000000", "" + sf_iAN + f_i);
        test("null-55000000", "" + sf_iAN + f_iM);
        test("null1460392448", "" + sf_iAN + f_l);
        test("nullC(70)", "" + sf_iAN + f_o);
        test("null\u04511", "" + sf_iAN + sf_strU);
        test("null8000", "" + sf_iAN + f_s);
        test("null18", "" + sf_iAN + s_str);
        test("null-1000000", "" + sf_iAN + s_iM);
        test("null1000000", "" + sf_iAN + sf_I);
        test("nullnull", "" + sf_iAN + f_oNtS);
        test("nullfalse", "" + sf_iAN + f_bl);
        test("nullnull", "" + sf_iAN + sf_iAN);
        test("null-2000000", "" + sf_iAN + sf_iM);
        test("null-820130816", "" + sf_iAN + f_lM);
        test("nullnull", "" + sf_iAN + sf_oAN);
        test("null25000000", "" + sf_iAN + s_I);
        test("-2000000-96.0", "" + sf_iM + s_dM);
        test("-2000000null", "" + sf_iM + s_oNtS);
        test("-2000000\u045176", "" + sf_iM + f_strU);
        test("-200000092", "" + sf_iM + sf_strU2);
        test("-200000051", "" + sf_iM + sf_strU1);
        test("-2000000null", "" + sf_iM + s_iAN);
        test("-2000000-54", "" + sf_iM + f_bM);
        test("-2000000-87.0", "" + sf_iM + f_fM);
        test("-2000000null", "" + sf_iM + s_oAN);
        test("-200000019", "" + sf_iM + f_str);
        test("-2000000-41", "" + sf_iM + sf_bM);
        test("-2000000null", "" + sf_iM + sf_IN);
        test("-2000000T", "" + sf_iM + s_c);
        test("-2000000-42.0", "" + sf_iM + sf_fM);
        test("-200000025", "" + sf_iM + s_b);
        test("-2000000null", "" + sf_iM + f_oN);
        test("-2000000-1410065408", "" + sf_iM + s_lM);
        test("-20000008.0", "" + sf_iM + s_d);
        test("-200000055.0", "" + sf_iM + s_f);
        test("-200000097000000", "" + sf_iM + s_i);
        test("-2000000-9900", "" + sf_iM + f_sM);
        test("-2000000935228928", "" + sf_iM + s_l);
        test("-2000000-8400", "" + sf_iM + sf_sM);
        test("-2000000C(82)", "" + sf_iM + s_o);
        test("-2000000null", "" + sf_iM + sf_oNtS);
        test("-2000000true", "" + sf_iM + s_bl);
        test("-20000003900", "" + sf_iM + s_s);
        test("-2000000null", "" + sf_iM + sf_oN);
        test("-200000094000000", "" + sf_iM + f_I);
        test("-2000000null", "" + sf_iM + f_IN);
        test("-2000000true", "" + sf_iM + sf_bl);
        test("-20000005500", "" + sf_iM + sf_s);
        test("-2000000-2900", "" + sf_iM + s_sM);
        test("-2000000-194313216", "" + sf_iM + sf_l);
        test("-200000012", "" + sf_iM + s_strU1);
        test("-2000000C(87)", "" + sf_iM + sf_o);
        test("-200000091", "" + sf_iM + s_strU2);
        test("-200000021", "" + sf_iM + f_strU1);
        test("-200000018", "" + sf_iM + f_strU2);
        test("-2000000null", "" + sf_iM + f_iAN);
        test("-2000000null", "" + sf_iM + s_oN);
        test("-2000000\u045180", "" + sf_iM + s_strU);
        test("-2000000C", "" + sf_iM + sf_c);
        test("-200000075", "" + sf_iM + sf_str);
        test("-2000000-43", "" + sf_iM + s_bM);
        test("-200000080", "" + sf_iM + sf_b);
        test("-2000000null", "" + sf_iM + s_IN);
        test("-2000000-52.0", "" + sf_iM + s_fM);
        test("-200000075000000", "" + sf_iM + sf_i);
        test("-200000044", "" + sf_iM + f_b);
        test("-2000000-1705032704", "" + sf_iM + sf_lM);
        test("-2000000null", "" + sf_iM + f_oAN);
        test("-200000083.0", "" + sf_iM + f_d);
        test("-2000000I", "" + sf_iM + f_c);
        test("-200000094.0", "" + sf_iM + f_f);
        test("-200000012.0", "" + sf_iM + sf_d);
        test("-2000000-99.0", "" + sf_iM + f_dM);
        test("-200000017.0", "" + sf_iM + sf_f);
        test("-2000000-84.0", "" + sf_iM + sf_dM);
        test("-200000058000000", "" + sf_iM + f_i);
        test("-2000000-55000000", "" + sf_iM + f_iM);
        test("-20000001460392448", "" + sf_iM + f_l);
        test("-2000000C(70)", "" + sf_iM + f_o);
        test("-2000000\u04511", "" + sf_iM + sf_strU);
        test("-20000008000", "" + sf_iM + f_s);
        test("-200000018", "" + sf_iM + s_str);
        test("-2000000-1000000", "" + sf_iM + s_iM);
        test("-20000001000000", "" + sf_iM + sf_I);
        test("-2000000null", "" + sf_iM + f_oNtS);
        test("-2000000false", "" + sf_iM + f_bl);
        test("-2000000null", "" + sf_iM + sf_iAN);
        test("-2000000-2000000", "" + sf_iM + sf_iM);
        test("-2000000-820130816", "" + sf_iM + f_lM);
        test("-2000000null", "" + sf_iM + sf_oAN);
        test("-200000025000000", "" + sf_iM + s_I);
        test("-820130816-96.0", "" + f_lM + s_dM);
        test("-820130816null", "" + f_lM + s_oNtS);
        test("-820130816\u045176", "" + f_lM + f_strU);
        test("-82013081692", "" + f_lM + sf_strU2);
        test("-82013081651", "" + f_lM + sf_strU1);
        test("-820130816null", "" + f_lM + s_iAN);
        test("-820130816-54", "" + f_lM + f_bM);
        test("-820130816-87.0", "" + f_lM + f_fM);
        test("-820130816null", "" + f_lM + s_oAN);
        test("-82013081619", "" + f_lM + f_str);
        test("-820130816-41", "" + f_lM + sf_bM);
        test("-820130816null", "" + f_lM + sf_IN);
        test("-820130816T", "" + f_lM + s_c);
        test("-820130816-42.0", "" + f_lM + sf_fM);
        test("-82013081625", "" + f_lM + s_b);
        test("-820130816null", "" + f_lM + f_oN);
        test("-820130816-1410065408", "" + f_lM + s_lM);
        test("-8201308168.0", "" + f_lM + s_d);
        test("-82013081655.0", "" + f_lM + s_f);
        test("-82013081697000000", "" + f_lM + s_i);
        test("-820130816-9900", "" + f_lM + f_sM);
        test("-820130816935228928", "" + f_lM + s_l);
        test("-820130816-8400", "" + f_lM + sf_sM);
        test("-820130816C(82)", "" + f_lM + s_o);
        test("-820130816null", "" + f_lM + sf_oNtS);
        test("-820130816true", "" + f_lM + s_bl);
        test("-8201308163900", "" + f_lM + s_s);
        test("-820130816null", "" + f_lM + sf_oN);
        test("-82013081694000000", "" + f_lM + f_I);
        test("-820130816null", "" + f_lM + f_IN);
        test("-820130816true", "" + f_lM + sf_bl);
        test("-8201308165500", "" + f_lM + sf_s);
        test("-820130816-2900", "" + f_lM + s_sM);
        test("-820130816-194313216", "" + f_lM + sf_l);
        test("-82013081612", "" + f_lM + s_strU1);
        test("-820130816C(87)", "" + f_lM + sf_o);
        test("-82013081691", "" + f_lM + s_strU2);
        test("-82013081621", "" + f_lM + f_strU1);
        test("-82013081618", "" + f_lM + f_strU2);
        test("-820130816null", "" + f_lM + f_iAN);
        test("-820130816null", "" + f_lM + s_oN);
        test("-820130816\u045180", "" + f_lM + s_strU);
        test("-820130816C", "" + f_lM + sf_c);
        test("-82013081675", "" + f_lM + sf_str);
        test("-820130816-43", "" + f_lM + s_bM);
        test("-82013081680", "" + f_lM + sf_b);
        test("-820130816null", "" + f_lM + s_IN);
        test("-820130816-52.0", "" + f_lM + s_fM);
        test("-82013081675000000", "" + f_lM + sf_i);
        test("-82013081644", "" + f_lM + f_b);
        test("-820130816-1705032704", "" + f_lM + sf_lM);
        test("-820130816null", "" + f_lM + f_oAN);
        test("-82013081683.0", "" + f_lM + f_d);
        test("-820130816I", "" + f_lM + f_c);
        test("-82013081694.0", "" + f_lM + f_f);
        test("-82013081612.0", "" + f_lM + sf_d);
        test("-820130816-99.0", "" + f_lM + f_dM);
        test("-82013081617.0", "" + f_lM + sf_f);
        test("-820130816-84.0", "" + f_lM + sf_dM);
        test("-82013081658000000", "" + f_lM + f_i);
        test("-820130816-55000000", "" + f_lM + f_iM);
        test("-8201308161460392448", "" + f_lM + f_l);
        test("-820130816C(70)", "" + f_lM + f_o);
        test("-820130816\u04511", "" + f_lM + sf_strU);
        test("-8201308168000", "" + f_lM + f_s);
        test("-82013081618", "" + f_lM + s_str);
        test("-820130816-1000000", "" + f_lM + s_iM);
        test("-8201308161000000", "" + f_lM + sf_I);
        test("-820130816null", "" + f_lM + f_oNtS);
        test("-820130816false", "" + f_lM + f_bl);
        test("-820130816null", "" + f_lM + sf_iAN);
        test("-820130816-2000000", "" + f_lM + sf_iM);
        test("-820130816-820130816", "" + f_lM + f_lM);
        test("-820130816null", "" + f_lM + sf_oAN);
        test("-82013081625000000", "" + f_lM + s_I);
        test("null-96.0", "" + sf_oAN + s_dM);
        test("nullnull", "" + sf_oAN + s_oNtS);
        test("null\u045176", "" + sf_oAN + f_strU);
        test("null92", "" + sf_oAN + sf_strU2);
        test("null51", "" + sf_oAN + sf_strU1);
        test("nullnull", "" + sf_oAN + s_iAN);
        test("null-54", "" + sf_oAN + f_bM);
        test("null-87.0", "" + sf_oAN + f_fM);
        test("nullnull", "" + sf_oAN + s_oAN);
        test("null19", "" + sf_oAN + f_str);
        test("null-41", "" + sf_oAN + sf_bM);
        test("nullnull", "" + sf_oAN + sf_IN);
        test("nullT", "" + sf_oAN + s_c);
        test("null-42.0", "" + sf_oAN + sf_fM);
        test("null25", "" + sf_oAN + s_b);
        test("nullnull", "" + sf_oAN + f_oN);
        test("null-1410065408", "" + sf_oAN + s_lM);
        test("null8.0", "" + sf_oAN + s_d);
        test("null55.0", "" + sf_oAN + s_f);
        test("null97000000", "" + sf_oAN + s_i);
        test("null-9900", "" + sf_oAN + f_sM);
        test("null935228928", "" + sf_oAN + s_l);
        test("null-8400", "" + sf_oAN + sf_sM);
        test("nullC(82)", "" + sf_oAN + s_o);
        test("nullnull", "" + sf_oAN + sf_oNtS);
        test("nulltrue", "" + sf_oAN + s_bl);
        test("null3900", "" + sf_oAN + s_s);
        test("nullnull", "" + sf_oAN + sf_oN);
        test("null94000000", "" + sf_oAN + f_I);
        test("nullnull", "" + sf_oAN + f_IN);
        test("nulltrue", "" + sf_oAN + sf_bl);
        test("null5500", "" + sf_oAN + sf_s);
        test("null-2900", "" + sf_oAN + s_sM);
        test("null-194313216", "" + sf_oAN + sf_l);
        test("null12", "" + sf_oAN + s_strU1);
        test("nullC(87)", "" + sf_oAN + sf_o);
        test("null91", "" + sf_oAN + s_strU2);
        test("null21", "" + sf_oAN + f_strU1);
        test("null18", "" + sf_oAN + f_strU2);
        test("nullnull", "" + sf_oAN + f_iAN);
        test("nullnull", "" + sf_oAN + s_oN);
        test("null\u045180", "" + sf_oAN + s_strU);
        test("nullC", "" + sf_oAN + sf_c);
        test("null75", "" + sf_oAN + sf_str);
        test("null-43", "" + sf_oAN + s_bM);
        test("null80", "" + sf_oAN + sf_b);
        test("nullnull", "" + sf_oAN + s_IN);
        test("null-52.0", "" + sf_oAN + s_fM);
        test("null75000000", "" + sf_oAN + sf_i);
        test("null44", "" + sf_oAN + f_b);
        test("null-1705032704", "" + sf_oAN + sf_lM);
        test("nullnull", "" + sf_oAN + f_oAN);
        test("null83.0", "" + sf_oAN + f_d);
        test("nullI", "" + sf_oAN + f_c);
        test("null94.0", "" + sf_oAN + f_f);
        test("null12.0", "" + sf_oAN + sf_d);
        test("null-99.0", "" + sf_oAN + f_dM);
        test("null17.0", "" + sf_oAN + sf_f);
        test("null-84.0", "" + sf_oAN + sf_dM);
        test("null58000000", "" + sf_oAN + f_i);
        test("null-55000000", "" + sf_oAN + f_iM);
        test("null1460392448", "" + sf_oAN + f_l);
        test("nullC(70)", "" + sf_oAN + f_o);
        test("null\u04511", "" + sf_oAN + sf_strU);
        test("null8000", "" + sf_oAN + f_s);
        test("null18", "" + sf_oAN + s_str);
        test("null-1000000", "" + sf_oAN + s_iM);
        test("null1000000", "" + sf_oAN + sf_I);
        test("nullnull", "" + sf_oAN + f_oNtS);
        test("nullfalse", "" + sf_oAN + f_bl);
        test("nullnull", "" + sf_oAN + sf_iAN);
        test("null-2000000", "" + sf_oAN + sf_iM);
        test("null-820130816", "" + sf_oAN + f_lM);
        test("nullnull", "" + sf_oAN + sf_oAN);
        test("null25000000", "" + sf_oAN + s_I);
        test("25000000-96.0", "" + s_I + s_dM);
        test("25000000null", "" + s_I + s_oNtS);
        test("25000000\u045176", "" + s_I + f_strU);
        test("2500000092", "" + s_I + sf_strU2);
        test("2500000051", "" + s_I + sf_strU1);
        test("25000000null", "" + s_I + s_iAN);
        test("25000000-54", "" + s_I + f_bM);
        test("25000000-87.0", "" + s_I + f_fM);
        test("25000000null", "" + s_I + s_oAN);
        test("2500000019", "" + s_I + f_str);
        test("25000000-41", "" + s_I + sf_bM);
        test("25000000null", "" + s_I + sf_IN);
        test("25000000T", "" + s_I + s_c);
        test("25000000-42.0", "" + s_I + sf_fM);
        test("2500000025", "" + s_I + s_b);
        test("25000000null", "" + s_I + f_oN);
        test("25000000-1410065408", "" + s_I + s_lM);
        test("250000008.0", "" + s_I + s_d);
        test("2500000055.0", "" + s_I + s_f);
        test("2500000097000000", "" + s_I + s_i);
        test("25000000-9900", "" + s_I + f_sM);
        test("25000000935228928", "" + s_I + s_l);
        test("25000000-8400", "" + s_I + sf_sM);
        test("25000000C(82)", "" + s_I + s_o);
        test("25000000null", "" + s_I + sf_oNtS);
        test("25000000true", "" + s_I + s_bl);
        test("250000003900", "" + s_I + s_s);
        test("25000000null", "" + s_I + sf_oN);
        test("2500000094000000", "" + s_I + f_I);
        test("25000000null", "" + s_I + f_IN);
        test("25000000true", "" + s_I + sf_bl);
        test("250000005500", "" + s_I + sf_s);
        test("25000000-2900", "" + s_I + s_sM);
        test("25000000-194313216", "" + s_I + sf_l);
        test("2500000012", "" + s_I + s_strU1);
        test("25000000C(87)", "" + s_I + sf_o);
        test("2500000091", "" + s_I + s_strU2);
        test("2500000021", "" + s_I + f_strU1);
        test("2500000018", "" + s_I + f_strU2);
        test("25000000null", "" + s_I + f_iAN);
        test("25000000null", "" + s_I + s_oN);
        test("25000000\u045180", "" + s_I + s_strU);
        test("25000000C", "" + s_I + sf_c);
        test("2500000075", "" + s_I + sf_str);
        test("25000000-43", "" + s_I + s_bM);
        test("2500000080", "" + s_I + sf_b);
        test("25000000null", "" + s_I + s_IN);
        test("25000000-52.0", "" + s_I + s_fM);
        test("2500000075000000", "" + s_I + sf_i);
        test("2500000044", "" + s_I + f_b);
        test("25000000-1705032704", "" + s_I + sf_lM);
        test("25000000null", "" + s_I + f_oAN);
        test("2500000083.0", "" + s_I + f_d);
        test("25000000I", "" + s_I + f_c);
        test("2500000094.0", "" + s_I + f_f);
        test("2500000012.0", "" + s_I + sf_d);
        test("25000000-99.0", "" + s_I + f_dM);
        test("2500000017.0", "" + s_I + sf_f);
        test("25000000-84.0", "" + s_I + sf_dM);
        test("2500000058000000", "" + s_I + f_i);
        test("25000000-55000000", "" + s_I + f_iM);
        test("250000001460392448", "" + s_I + f_l);
        test("25000000C(70)", "" + s_I + f_o);
        test("25000000\u04511", "" + s_I + sf_strU);
        test("250000008000", "" + s_I + f_s);
        test("2500000018", "" + s_I + s_str);
        test("25000000-1000000", "" + s_I + s_iM);
        test("250000001000000", "" + s_I + sf_I);
        test("25000000null", "" + s_I + f_oNtS);
        test("25000000false", "" + s_I + f_bl);
        test("25000000null", "" + s_I + sf_iAN);
        test("25000000-2000000", "" + s_I + sf_iM);
        test("25000000-820130816", "" + s_I + f_lM);
        test("25000000null", "" + s_I + sf_oAN);
        test("2500000025000000", "" + s_I + s_I);
    }

}
