.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991, 1994, 1996 X Consortium
.\"
.\" Permission is hereby granted, free of charge, to any person obtaining
.\" a copy of this software and associated documentation files (the
.\" "Software"), to deal in the Software without restriction, including
.\" without limitation the rights to use, copy, modify, merge, publish,
.\" distribute, sublicense, and/or sell copies of the Software, and to
.\" permit persons to whom the Software is furnished to do so, subject to
.\" the following conditions:
.\"
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\"
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE X CONSORTIUM BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\"
.\" Except as contained in this notice, the name of the X Consortium shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from the X Consortium.
.\"
.\" Copyright \(co 1985, 1986, 1987, 1988, 1989, 1990, 1991 by
.\" Digital Equipment Corporation
.\"
.\" Portions Copyright \(co 1990, 1991 by
.\" Tektronix, Inc.
.\"
.\" Permission to use, copy, modify and distribute this documentation for
.\" any purpose and without fee is hereby granted, provided that the above
.\" copyright notice appears in all copies and that both that copyright notice
.\" and this permission notice appear in all copies, and that the names of
.\" Digital and Tektronix not be used in in advertising or publicity pertaining
.\" to this documentation without specific, written prior permission.
.\" Digital and Tektronix makes no representations about the suitability
.\" of this documentation for any purpose.
.\" It is provided "as is" without express or implied warranty.
.\"
.\"
.ds xT X Toolkit Intrinsics \- C Language Interface
.ds xW Athena X Widgets \- C Language X Toolkit Interface
.ds xL Xlib \- C Language X Interface
.ds xC Inter-Client Communication Conventions Manual
.TH XSetSelectionOwner __libmansuffix__ __xorgversion__ "XLIB FUNCTIONS"
.SH NAME
XSetSelectionOwner, XGetSelectionOwner, XConvertSelection \- manipulate window selection
.SH SYNTAX
.HP
int XSetSelectionOwner\^(\^Display *\fIdisplay\fP\^, Atom \fIselection\fP\^,
Window \fIowner\fP\^, Time \fItime\fP\^);
.HP
Window XGetSelectionOwner\^(\^Display *\fIdisplay\fP\^, Atom
\fIselection\fP\^);
.HP
int XConvertSelection\^(\^Display *\fIdisplay\fP\^, Atom \fIselection\fP\^,
Atom \fItarget\fP\^, Atom \fIproperty\fP\^, Window \fIrequestor\fP\^, Time
\fItime\fP\^);
.SH ARGUMENTS
.IP \fIdisplay\fP 1i
Specifies the connection to the X server.
.IP \fIowner\fP 1i
Specifies the owner of the specified selection atom.
You can pass a window or
.BR None .
.IP \fIproperty\fP 1i
Specifies the property name.
You also can pass
.BR None .
.IP \fIrequestor\fP 1i
Specifies the requestor.
.IP \fIselection\fP 1i
Specifies the selection atom.
.IP \fItarget\fP 1i
Specifies the target atom.
.IP \fItime\fP 1i
Specifies the time.
You can pass either a timestamp or
.BR CurrentTime .
.SH DESCRIPTION
The
.B XSetSelectionOwner
function changes the owner and last-change time for the specified selection
and has no effect if the specified time is earlier than the current
last-change time of the specified selection
or is later than the current X server time.
Otherwise, the last-change time is set to the specified time,
with
.B CurrentTime
replaced by the current server time.
If the owner window is specified as
.BR None ,
then the owner of the selection becomes
.B None
(that is, no owner).
Otherwise, the owner of the selection becomes the client executing
the request.
.LP
If the new owner (whether a client or
.BR None )
is not
the same as the current owner of the selection and the current
owner is not
.BR None ,
the current owner is sent a
.B SelectionClear
event.
If the client that is the owner of a selection is later
terminated (that is, its connection is closed)
or if the owner window it has specified in the request is later
destroyed,
the owner of the selection automatically
reverts to
.BR None ,
but the last-change time is not affected.
The selection atom is uninterpreted by the X server.
.B XGetSelectionOwner
returns the owner window, which is reported in
.B SelectionRequest
and
.B SelectionClear
events.
Selections are global to the X server.
.LP
.B XSetSelectionOwner
can generate
.B BadAtom
and
.B BadWindow
errors.
.LP
The
.B XGetSelectionOwner
function
returns the window ID associated with the window that currently owns the
specified selection.
If no selection was specified, the function returns the constant
.BR None .
If
.B None
is returned,
there is no owner for the selection.
.LP
.B XGetSelectionOwner
can generate a
.B BadAtom
error.
.LP
.B XConvertSelection
requests that the specified selection be converted to the specified target
type:
.IP \(bu 5
If the specified selection has an owner, the X server sends a
.B SelectionRequest
event to that owner.
.IP \(bu 5
If no owner for the specified
selection exists, the X server generates a
.B SelectionNotify
event to the
requestor with property
.BR None .
.LP
The arguments are passed on unchanged in either of the events.
There are two predefined selection atoms: PRIMARY and SECONDARY.
.LP
.B XConvertSelection
can generate
.B BadAtom
and
.B BadWindow
errors.
.SH DIAGNOSTICS
.TP 1i
.B BadAtom
A value for an Atom argument does not name a defined Atom.
.TP 1i
.B BadWindow
A value for a Window argument does not name a defined Window.
.SH "SEE ALSO"
\fI\*(xL\fP
