/* -*- Mode: C++; tab-width: 2; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/*
 * This file is part of the libe-book project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * For further information visit http://libebook.sourceforge.net
 */

#ifndef IMPLZSSSTREAM_H_INCLUDED
#define IMPLZSSSTREAM_H_INCLUDED

#include <boost/scoped_ptr.hpp>

#include <librevenge-stream/librevenge-stream.h>

namespace libebook
{

class IMPLZSSStream : public librevenge::RVNGInputStream
{
// disable copying
  IMPLZSSStream(const IMPLZSSStream &other);
  IMPLZSSStream &operator=(const IMPLZSSStream &other);

public:
  struct Configuration
  {
    unsigned offsetBits;
    unsigned lengthBits;
    unsigned uncompressedLength;
    unsigned fillPos;
    char fillChar;
    bool allowOverflow;
    bool bigEndian;

    Configuration();
  };

public:
  explicit IMPLZSSStream(librevenge::RVNGInputStream *stream, const Configuration &configuration = Configuration());
  virtual ~IMPLZSSStream();

  virtual bool isStructured();
  virtual unsigned subStreamCount();
  virtual const char *subStreamName(unsigned id);
  virtual bool existsSubStream(const char *name);
  virtual librevenge::RVNGInputStream *getSubStreamByName(const char *name);
  virtual RVNGInputStream *getSubStreamById(unsigned id);

  virtual const unsigned char *read(unsigned long numBytes, unsigned long &numBytesRead);
  virtual int seek(long offset, librevenge::RVNG_SEEK_TYPE seekType);
  virtual long tell();
  virtual bool isEnd();

private:
  boost::scoped_ptr<librevenge::RVNGInputStream> m_stream;
};

}

#endif // IMPLZSSSTREAM_H_INCLUDED

/* vim:set shiftwidth=2 softtabstop=2 expandtab: */
