/*
 * Decompiled with CFR 0.152.
 */
package JFlex;

import JFlex.ErrorMessages;
import JFlex.GeneratorException;
import JFlex.Options;
import JFlex.StdOutWriter;
import JFlex.Timer;
import java.awt.TextArea;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;

public final class Out {
    public static final String NL = System.getProperty("line.separator");
    private static int warnings;
    private static int errors;
    private static StdOutWriter out;

    public static void setGUIMode(TextArea text) {
        out.setGUIMode(text);
    }

    public static void setOutputStream(OutputStream stream) {
        out = new StdOutWriter(stream);
        out.setGUIMode(null);
    }

    public static void time(ErrorMessages message, Timer time) {
        if (Options.time) {
            String msg = ErrorMessages.get(message, time.toString());
            out.println(msg);
        }
    }

    public static void time(String message) {
        if (Options.time) {
            out.println(message);
        }
    }

    public static void println(String message) {
        if (Options.verbose) {
            out.println(message);
        }
    }

    public static void println(ErrorMessages message, String data) {
        if (Options.verbose) {
            out.println(ErrorMessages.get(message, data));
        }
    }

    public static void println(ErrorMessages message, int data) {
        if (Options.verbose) {
            out.println(ErrorMessages.get(message, data));
        }
    }

    public static void print(String message) {
        if (Options.verbose) {
            out.print(message);
        }
    }

    public static void debug(String message) {
    }

    public static void dump(String message) {
        if (Options.dump) {
            out.println(message);
        }
    }

    private static void err(String message) {
        out.println(message);
    }

    public static void checkErrors() {
        if (errors > 0) {
            throw new GeneratorException();
        }
    }

    public static void statistics() {
        StringBuffer line = new StringBuffer(errors + " error");
        if (errors != 1) {
            line.append("s");
        }
        line.append(", " + warnings + " warning");
        if (warnings != 1) {
            line.append("s");
        }
        line.append(".");
        Out.err(line.toString());
    }

    public static void resetCounters() {
        errors = 0;
        warnings = 0;
    }

    public static void warning(String message) {
        ++warnings;
        Out.err(NL + "Warning : " + message);
    }

    public static void warning(ErrorMessages message, int line) {
        ++warnings;
        String msg = NL + "Warning";
        if (line > 0) {
            msg = msg + " in line " + (line + 1);
        }
        Out.err(msg + ": " + ErrorMessages.get(message));
    }

    public static void warning(File file, ErrorMessages message, int line, int column) {
        String msg = NL + "Warning";
        if (file != null) {
            msg = msg + " in file \"" + file + "\"";
        }
        if (line >= 0) {
            msg = msg + " (line " + (line + 1) + ")";
        }
        try {
            Out.err(msg + ": " + NL + ErrorMessages.get(message));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Out.err(msg);
        }
        ++warnings;
        if (line >= 0) {
            if (column >= 0) {
                Out.showPosition(file, line, column);
            } else {
                Out.showPosition(file, line);
            }
        }
    }

    public static void error(String message) {
        ++errors;
        Out.err(NL + message);
    }

    public static void error(ErrorMessages message) {
        ++errors;
        Out.err(NL + "Error: " + ErrorMessages.get(message));
    }

    public static void error(ErrorMessages message, String data) {
        ++errors;
        Out.err(NL + "Error: " + ErrorMessages.get(message, data));
    }

    public static void error(ErrorMessages message, File file) {
        ++errors;
        Out.err(NL + "Error: " + ErrorMessages.get(message) + " (" + file + ")");
    }

    public static void error(File file, ErrorMessages message, int line, int column) {
        String msg = NL + "Error";
        if (file != null) {
            msg = msg + " in file \"" + file + "\"";
        }
        if (line >= 0) {
            msg = msg + " (line " + (line + 1) + ")";
        }
        try {
            Out.err(msg + ": " + NL + ErrorMessages.get(message));
        }
        catch (ArrayIndexOutOfBoundsException e) {
            Out.err(msg);
        }
        ++errors;
        if (line >= 0) {
            if (column >= 0) {
                Out.showPosition(file, line, column);
            } else {
                Out.showPosition(file, line);
            }
        }
    }

    public static void showPosition(File file, int line, int column) {
        try {
            String ln = Out.getLine(file, line);
            if (ln != null) {
                Out.err(ln);
                if (column < 0) {
                    return;
                }
                String t = "^";
                for (int i = 0; i < column; ++i) {
                    t = " " + t;
                }
                Out.err(t);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void showPosition(File file, int line) {
        try {
            String ln = Out.getLine(file, line);
            if (ln != null) {
                Out.err(ln);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static String getLine(File file, int line) throws IOException {
        BufferedReader reader = new BufferedReader(new FileReader(file));
        String msg = "";
        for (int i = 0; i <= line; ++i) {
            msg = reader.readLine();
        }
        reader.close();
        return msg;
    }

    public static void printSystemInfo() {
        Out.err("Java version:  " + System.getProperty("java.version"));
        Out.err("Runtime name:  " + System.getProperty("java.runtime.name"));
        Out.err("Vendor:        " + System.getProperty("java.vendor"));
        Out.err("VM version:    " + System.getProperty("java.vm.version"));
        Out.err("VM vendor:     " + System.getProperty("java.vm.vendor"));
        Out.err("VM name:       " + System.getProperty("java.vm.name"));
        Out.err("VM info:       " + System.getProperty("java.vm.info"));
        Out.err("OS name:       " + System.getProperty("os.name"));
        Out.err("OS arch:       " + System.getProperty("os.arch"));
        Out.err("OS version:    " + System.getProperty("os.version"));
        Out.err("Encoding:      " + System.getProperty("file.encoding"));
        Out.err("JFlex version: 1.4.3");
    }

    public static void requestBugReport(Error e) {
        Out.err("An unexpected error occurred. Please send a report of this to");
        Out.err("<bugs@jflex.de> and include the following information:");
        Out.err("");
        Out.printSystemInfo();
        Out.err("Exception:");
        e.printStackTrace(out);
        Out.err("");
        Out.err("Please also include a specification (as small as possible)");
        Out.err("that triggers this error. You may also want to check at");
        Out.err("http://www.jflex.de if there is a newer version available");
        Out.err("that doesn't have this problem");
        Out.err("");
        Out.err("Thanks for your support.");
    }

    static {
        out = new StdOutWriter();
    }
}

