/*
 * Copyright (c) 2009 Stanford University.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer.
 * - Redistributions in binary form must reproduce the above copyright
 *   notice, this list of conditions and the following disclaimer in the
 *   documentation and/or other materials provided with the
 *   distribution.
 * - Neither the name of the Stanford University nor the names of
 *   its contributors may be used to endorse or promote products derived
 *   from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * ``AS IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
 * FOR A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL STANFORD
 * UNIVERSITY OR ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
 * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED
 * OF THE POSSIBILITY OF SUCH DAMAGE.
 */

/**
 * General-purpose I/O abstraction for the SAM3U.
 * Includes PIO controllers A, B, C with 32 pins each.
 *
 * @author Wanja Hofer <wanja@cs.fau.de>
 */

configuration HplSam3uGeneralIOC
{
	provides {
		interface GeneralIO as PioA0;
		interface GeneralIO as PioA1;
		interface GeneralIO as PioA2;
		interface GeneralIO as PioA3;
		interface GeneralIO as PioA4;
		interface GeneralIO as PioA5;
		interface GeneralIO as PioA6;
		interface GeneralIO as PioA7;
		interface GeneralIO as PioA8;
		interface GeneralIO as PioA9;
		interface GeneralIO as PioA10;
		interface GeneralIO as PioA11;
		interface GeneralIO as PioA12;
		interface GeneralIO as PioA13;
		interface GeneralIO as PioA14;
		interface GeneralIO as PioA15;
		interface GeneralIO as PioA16;
		interface GeneralIO as PioA17;
		interface GeneralIO as PioA18;
		interface GeneralIO as PioA19;
		interface GeneralIO as PioA20;
		interface GeneralIO as PioA21;
		interface GeneralIO as PioA22;
		interface GeneralIO as PioA23;
		interface GeneralIO as PioA24;
		interface GeneralIO as PioA25;
		interface GeneralIO as PioA26;
		interface GeneralIO as PioA27;
		interface GeneralIO as PioA28;
		interface GeneralIO as PioA29;
		interface GeneralIO as PioA30;
		interface GeneralIO as PioA31;

		interface GeneralIO as PioB0;
		interface GeneralIO as PioB1;
		interface GeneralIO as PioB2;
		interface GeneralIO as PioB3;
		interface GeneralIO as PioB4;
		interface GeneralIO as PioB5;
		interface GeneralIO as PioB6;
		interface GeneralIO as PioB7;
		interface GeneralIO as PioB8;
		interface GeneralIO as PioB9;
		interface GeneralIO as PioB10;
		interface GeneralIO as PioB11;
		interface GeneralIO as PioB12;
		interface GeneralIO as PioB13;
		interface GeneralIO as PioB14;
		interface GeneralIO as PioB15;
		interface GeneralIO as PioB16;
		interface GeneralIO as PioB17;
		interface GeneralIO as PioB18;
		interface GeneralIO as PioB19;
		interface GeneralIO as PioB20;
		interface GeneralIO as PioB21;
		interface GeneralIO as PioB22;
		interface GeneralIO as PioB23;
		interface GeneralIO as PioB24;
		interface GeneralIO as PioB25;
		interface GeneralIO as PioB26;
		interface GeneralIO as PioB27;
		interface GeneralIO as PioB28;
		interface GeneralIO as PioB29;
		interface GeneralIO as PioB30;
		interface GeneralIO as PioB31;

		interface GeneralIO as PioC0;
		interface GeneralIO as PioC1;
		interface GeneralIO as PioC2;
		interface GeneralIO as PioC3;
		interface GeneralIO as PioC4;
		interface GeneralIO as PioC5;
		interface GeneralIO as PioC6;
		interface GeneralIO as PioC7;
		interface GeneralIO as PioC8;
		interface GeneralIO as PioC9;
		interface GeneralIO as PioC10;
		interface GeneralIO as PioC11;
		interface GeneralIO as PioC12;
		interface GeneralIO as PioC13;
		interface GeneralIO as PioC14;
		interface GeneralIO as PioC15;
		interface GeneralIO as PioC16;
		interface GeneralIO as PioC17;
		interface GeneralIO as PioC18;
		interface GeneralIO as PioC19;
		interface GeneralIO as PioC20;
		interface GeneralIO as PioC21;
		interface GeneralIO as PioC22;
		interface GeneralIO as PioC23;
		interface GeneralIO as PioC24;
		interface GeneralIO as PioC25;
		interface GeneralIO as PioC26;
		interface GeneralIO as PioC27;
		interface GeneralIO as PioC28;
		interface GeneralIO as PioC29;
		interface GeneralIO as PioC30;
		interface GeneralIO as PioC31;

		interface GpioInterrupt as InterruptPioA0;
		interface GpioInterrupt as InterruptPioA1;
		interface GpioInterrupt as InterruptPioA2;
		interface GpioInterrupt as InterruptPioA3;
		interface GpioInterrupt as InterruptPioA4;
		interface GpioInterrupt as InterruptPioA5;
		interface GpioInterrupt as InterruptPioA6;
		interface GpioInterrupt as InterruptPioA7;
		interface GpioInterrupt as InterruptPioA8;
		interface GpioInterrupt as InterruptPioA9;
		interface GpioInterrupt as InterruptPioA10;
		interface GpioInterrupt as InterruptPioA11;
		interface GpioInterrupt as InterruptPioA12;
		interface GpioInterrupt as InterruptPioA13;
		interface GpioInterrupt as InterruptPioA14;
		interface GpioInterrupt as InterruptPioA15;
		interface GpioInterrupt as InterruptPioA16;
		interface GpioInterrupt as InterruptPioA17;
		interface GpioInterrupt as InterruptPioA18;
		interface GpioInterrupt as InterruptPioA19;
		interface GpioInterrupt as InterruptPioA20;
		interface GpioInterrupt as InterruptPioA21;
		interface GpioInterrupt as InterruptPioA22;
		interface GpioInterrupt as InterruptPioA23;
		interface GpioInterrupt as InterruptPioA24;
		interface GpioInterrupt as InterruptPioA25;
		interface GpioInterrupt as InterruptPioA26;
		interface GpioInterrupt as InterruptPioA27;
		interface GpioInterrupt as InterruptPioA28;
		interface GpioInterrupt as InterruptPioA29;
		interface GpioInterrupt as InterruptPioA30;
		interface GpioInterrupt as InterruptPioA31;
                                               
		interface GpioInterrupt as InterruptPioB0;
		interface GpioInterrupt as InterruptPioB1;
		interface GpioInterrupt as InterruptPioB2;
		interface GpioInterrupt as InterruptPioB3;
		interface GpioInterrupt as InterruptPioB4;
		interface GpioInterrupt as InterruptPioB5;
		interface GpioInterrupt as InterruptPioB6;
		interface GpioInterrupt as InterruptPioB7;
		interface GpioInterrupt as InterruptPioB8;
		interface GpioInterrupt as InterruptPioB9;
		interface GpioInterrupt as InterruptPioB10;
		interface GpioInterrupt as InterruptPioB11;
		interface GpioInterrupt as InterruptPioB12;
		interface GpioInterrupt as InterruptPioB13;
		interface GpioInterrupt as InterruptPioB14;
		interface GpioInterrupt as InterruptPioB15;
		interface GpioInterrupt as InterruptPioB16;
		interface GpioInterrupt as InterruptPioB17;
		interface GpioInterrupt as InterruptPioB18;
		interface GpioInterrupt as InterruptPioB19;
		interface GpioInterrupt as InterruptPioB20;
		interface GpioInterrupt as InterruptPioB21;
		interface GpioInterrupt as InterruptPioB22;
		interface GpioInterrupt as InterruptPioB23;
		interface GpioInterrupt as InterruptPioB24;
		interface GpioInterrupt as InterruptPioB25;
		interface GpioInterrupt as InterruptPioB26;
		interface GpioInterrupt as InterruptPioB27;
		interface GpioInterrupt as InterruptPioB28;
		interface GpioInterrupt as InterruptPioB29;
		interface GpioInterrupt as InterruptPioB30;
		interface GpioInterrupt as InterruptPioB31;
                                               
		interface GpioInterrupt as InterruptPioC0;
		interface GpioInterrupt as InterruptPioC1;
		interface GpioInterrupt as InterruptPioC2;
		interface GpioInterrupt as InterruptPioC3;
		interface GpioInterrupt as InterruptPioC4;
		interface GpioInterrupt as InterruptPioC5;
		interface GpioInterrupt as InterruptPioC6;
		interface GpioInterrupt as InterruptPioC7;
		interface GpioInterrupt as InterruptPioC8;
		interface GpioInterrupt as InterruptPioC9;
		interface GpioInterrupt as InterruptPioC10;
		interface GpioInterrupt as InterruptPioC11;
		interface GpioInterrupt as InterruptPioC12;
		interface GpioInterrupt as InterruptPioC13;
		interface GpioInterrupt as InterruptPioC14;
		interface GpioInterrupt as InterruptPioC15;
		interface GpioInterrupt as InterruptPioC16;
		interface GpioInterrupt as InterruptPioC17;
		interface GpioInterrupt as InterruptPioC18;
		interface GpioInterrupt as InterruptPioC19;
		interface GpioInterrupt as InterruptPioC20;
		interface GpioInterrupt as InterruptPioC21;
		interface GpioInterrupt as InterruptPioC22;
		interface GpioInterrupt as InterruptPioC23;
		interface GpioInterrupt as InterruptPioC24;
		interface GpioInterrupt as InterruptPioC25;
		interface GpioInterrupt as InterruptPioC26;
		interface GpioInterrupt as InterruptPioC27;
		interface GpioInterrupt as InterruptPioC28;
		interface GpioInterrupt as InterruptPioC29;
		interface GpioInterrupt as InterruptPioC30;
		interface GpioInterrupt as InterruptPioC31;

		interface GpioCapture as CapturePioA0;
		interface GpioCapture as CapturePioA1;
		interface GpioCapture as CapturePioA2;
		interface GpioCapture as CapturePioA3;
		interface GpioCapture as CapturePioA4;
		interface GpioCapture as CapturePioA5;
		interface GpioCapture as CapturePioA6;
		interface GpioCapture as CapturePioA7;
		interface GpioCapture as CapturePioA8;
		interface GpioCapture as CapturePioA9;
		interface GpioCapture as CapturePioA10;
		interface GpioCapture as CapturePioA11;
		interface GpioCapture as CapturePioA12;
		interface GpioCapture as CapturePioA13;
		interface GpioCapture as CapturePioA14;
		interface GpioCapture as CapturePioA15;
		interface GpioCapture as CapturePioA16;
		interface GpioCapture as CapturePioA17;
		interface GpioCapture as CapturePioA18;
		interface GpioCapture as CapturePioA19;
		interface GpioCapture as CapturePioA20;
		interface GpioCapture as CapturePioA21;
		interface GpioCapture as CapturePioA22;
		interface GpioCapture as CapturePioA23;
		interface GpioCapture as CapturePioA24;
		interface GpioCapture as CapturePioA25;
		interface GpioCapture as CapturePioA26;
		interface GpioCapture as CapturePioA27;
		interface GpioCapture as CapturePioA28;
		interface GpioCapture as CapturePioA29;
		interface GpioCapture as CapturePioA30;
		interface GpioCapture as CapturePioA31;
                                           
		interface GpioCapture as CapturePioB0;
		interface GpioCapture as CapturePioB1;
		interface GpioCapture as CapturePioB2;
		interface GpioCapture as CapturePioB3;
		interface GpioCapture as CapturePioB4;
		interface GpioCapture as CapturePioB5;
		interface GpioCapture as CapturePioB6;
		interface GpioCapture as CapturePioB7;
		interface GpioCapture as CapturePioB8;
		interface GpioCapture as CapturePioB9;
		interface GpioCapture as CapturePioB10;
		interface GpioCapture as CapturePioB11;
		interface GpioCapture as CapturePioB12;
		interface GpioCapture as CapturePioB13;
		interface GpioCapture as CapturePioB14;
		interface GpioCapture as CapturePioB15;
		interface GpioCapture as CapturePioB16;
		interface GpioCapture as CapturePioB17;
		interface GpioCapture as CapturePioB18;
		interface GpioCapture as CapturePioB19;
		interface GpioCapture as CapturePioB20;
		interface GpioCapture as CapturePioB21;
		interface GpioCapture as CapturePioB22;
		interface GpioCapture as CapturePioB23;
		interface GpioCapture as CapturePioB24;
		interface GpioCapture as CapturePioB25;
		interface GpioCapture as CapturePioB26;
		interface GpioCapture as CapturePioB27;
		interface GpioCapture as CapturePioB28;
		interface GpioCapture as CapturePioB29;
		interface GpioCapture as CapturePioB30;
		interface GpioCapture as CapturePioB31;
                                           
		interface GpioCapture as CapturePioC0;
		interface GpioCapture as CapturePioC1;
		interface GpioCapture as CapturePioC2;
		interface GpioCapture as CapturePioC3;
		interface GpioCapture as CapturePioC4;
		interface GpioCapture as CapturePioC5;
		interface GpioCapture as CapturePioC6;
		interface GpioCapture as CapturePioC7;
		interface GpioCapture as CapturePioC8;
		interface GpioCapture as CapturePioC9;
		interface GpioCapture as CapturePioC10;
		interface GpioCapture as CapturePioC11;
		interface GpioCapture as CapturePioC12;
		interface GpioCapture as CapturePioC13;
		interface GpioCapture as CapturePioC14;
		interface GpioCapture as CapturePioC15;
		interface GpioCapture as CapturePioC16;
		interface GpioCapture as CapturePioC17;
		interface GpioCapture as CapturePioC18;
		interface GpioCapture as CapturePioC19;
		interface GpioCapture as CapturePioC20;
		interface GpioCapture as CapturePioC21;
		interface GpioCapture as CapturePioC22;
		interface GpioCapture as CapturePioC23;
		interface GpioCapture as CapturePioC24;
		interface GpioCapture as CapturePioC25;
		interface GpioCapture as CapturePioC26;
		interface GpioCapture as CapturePioC27;
		interface GpioCapture as CapturePioC28;
		interface GpioCapture as CapturePioC29;
		interface GpioCapture as CapturePioC30;
		interface GpioCapture as CapturePioC31;

		interface HplSam3GeneralIOPin as HplPioA0;
		interface HplSam3GeneralIOPin as HplPioA1;
		interface HplSam3GeneralIOPin as HplPioA2;
		interface HplSam3GeneralIOPin as HplPioA3;
		interface HplSam3GeneralIOPin as HplPioA4;
		interface HplSam3GeneralIOPin as HplPioA5;
		interface HplSam3GeneralIOPin as HplPioA6;
		interface HplSam3GeneralIOPin as HplPioA7;
		interface HplSam3GeneralIOPin as HplPioA8;
		interface HplSam3GeneralIOPin as HplPioA9;
		interface HplSam3GeneralIOPin as HplPioA10;
		interface HplSam3GeneralIOPin as HplPioA11;
		interface HplSam3GeneralIOPin as HplPioA12;
		interface HplSam3GeneralIOPin as HplPioA13;
		interface HplSam3GeneralIOPin as HplPioA14;
		interface HplSam3GeneralIOPin as HplPioA15;
		interface HplSam3GeneralIOPin as HplPioA16;
		interface HplSam3GeneralIOPin as HplPioA17;
		interface HplSam3GeneralIOPin as HplPioA18;
		interface HplSam3GeneralIOPin as HplPioA19;
		interface HplSam3GeneralIOPin as HplPioA20;
		interface HplSam3GeneralIOPin as HplPioA21;
		interface HplSam3GeneralIOPin as HplPioA22;
		interface HplSam3GeneralIOPin as HplPioA23;
		interface HplSam3GeneralIOPin as HplPioA24;
		interface HplSam3GeneralIOPin as HplPioA25;
		interface HplSam3GeneralIOPin as HplPioA26;
		interface HplSam3GeneralIOPin as HplPioA27;
		interface HplSam3GeneralIOPin as HplPioA28;
		interface HplSam3GeneralIOPin as HplPioA29;
		interface HplSam3GeneralIOPin as HplPioA30;
		interface HplSam3GeneralIOPin as HplPioA31;

		interface HplSam3GeneralIOPin as HplPioB0;
		interface HplSam3GeneralIOPin as HplPioB1;
		interface HplSam3GeneralIOPin as HplPioB2;
		interface HplSam3GeneralIOPin as HplPioB3;
		interface HplSam3GeneralIOPin as HplPioB4;
		interface HplSam3GeneralIOPin as HplPioB5;
		interface HplSam3GeneralIOPin as HplPioB6;
		interface HplSam3GeneralIOPin as HplPioB7;
		interface HplSam3GeneralIOPin as HplPioB8;
		interface HplSam3GeneralIOPin as HplPioB9;
		interface HplSam3GeneralIOPin as HplPioB10;
		interface HplSam3GeneralIOPin as HplPioB11;
		interface HplSam3GeneralIOPin as HplPioB12;
		interface HplSam3GeneralIOPin as HplPioB13;
		interface HplSam3GeneralIOPin as HplPioB14;
		interface HplSam3GeneralIOPin as HplPioB15;
		interface HplSam3GeneralIOPin as HplPioB16;
		interface HplSam3GeneralIOPin as HplPioB17;
		interface HplSam3GeneralIOPin as HplPioB18;
		interface HplSam3GeneralIOPin as HplPioB19;
		interface HplSam3GeneralIOPin as HplPioB20;
		interface HplSam3GeneralIOPin as HplPioB21;
		interface HplSam3GeneralIOPin as HplPioB22;
		interface HplSam3GeneralIOPin as HplPioB23;
		interface HplSam3GeneralIOPin as HplPioB24;
		interface HplSam3GeneralIOPin as HplPioB25;
		interface HplSam3GeneralIOPin as HplPioB26;
		interface HplSam3GeneralIOPin as HplPioB27;
		interface HplSam3GeneralIOPin as HplPioB28;
		interface HplSam3GeneralIOPin as HplPioB29;
		interface HplSam3GeneralIOPin as HplPioB30;
		interface HplSam3GeneralIOPin as HplPioB31;

		interface HplSam3GeneralIOPin as HplPioC0;
		interface HplSam3GeneralIOPin as HplPioC1;
		interface HplSam3GeneralIOPin as HplPioC2;
		interface HplSam3GeneralIOPin as HplPioC3;
		interface HplSam3GeneralIOPin as HplPioC4;
		interface HplSam3GeneralIOPin as HplPioC5;
		interface HplSam3GeneralIOPin as HplPioC6;
		interface HplSam3GeneralIOPin as HplPioC7;
		interface HplSam3GeneralIOPin as HplPioC8;
		interface HplSam3GeneralIOPin as HplPioC9;
		interface HplSam3GeneralIOPin as HplPioC10;
		interface HplSam3GeneralIOPin as HplPioC11;
		interface HplSam3GeneralIOPin as HplPioC12;
		interface HplSam3GeneralIOPin as HplPioC13;
		interface HplSam3GeneralIOPin as HplPioC14;
		interface HplSam3GeneralIOPin as HplPioC15;
		interface HplSam3GeneralIOPin as HplPioC16;
		interface HplSam3GeneralIOPin as HplPioC17;
		interface HplSam3GeneralIOPin as HplPioC18;
		interface HplSam3GeneralIOPin as HplPioC19;
		interface HplSam3GeneralIOPin as HplPioC20;
		interface HplSam3GeneralIOPin as HplPioC21;
		interface HplSam3GeneralIOPin as HplPioC22;
		interface HplSam3GeneralIOPin as HplPioC23;
		interface HplSam3GeneralIOPin as HplPioC24;
		interface HplSam3GeneralIOPin as HplPioC25;
		interface HplSam3GeneralIOPin as HplPioC26;
		interface HplSam3GeneralIOPin as HplPioC27;
		interface HplSam3GeneralIOPin as HplPioC28;
		interface HplSam3GeneralIOPin as HplPioC29;
		interface HplSam3GeneralIOPin as HplPioC30;
		interface HplSam3GeneralIOPin as HplPioC31;
	}
}

implementation
{
	components 
	new HplSam3GeneralIOPioC(0x400e0c00) as PioA,
	new HplSam3GeneralIOPioC(0x400e0e00) as PioB,
	new HplSam3GeneralIOPioC(0x400e1000) as PioC;

    components HplSam3GeneralIOP;
    PioA.HplPort -> HplSam3GeneralIOP.HplPortA;
    PioB.HplPort -> HplSam3GeneralIOP.HplPortB;
    PioC.HplPort -> HplSam3GeneralIOP.HplPortC;

    components McuSleepC;
    HplSam3GeneralIOP.PioAInterruptWrapper -> McuSleepC;
    HplSam3GeneralIOP.PioBInterruptWrapper -> McuSleepC;
    HplSam3GeneralIOP.PioCInterruptWrapper -> McuSleepC;

    components HplNVICC, HplSam3uClockC;
    PioA.PIOIrqControl -> HplNVICC.PIOAInterrupt;
    PioA.PIOClockControl -> HplSam3uClockC.PIOAPPCntl;
    PioB.PIOIrqControl -> HplNVICC.PIOBInterrupt;
    PioB.PIOClockControl -> HplSam3uClockC.PIOBPPCntl;
    PioC.PIOIrqControl -> HplNVICC.PIOCInterrupt;
    PioC.PIOClockControl -> HplSam3uClockC.PIOCPPCntl;

	PioA0 = PioA.Pin0;
	PioA1 = PioA.Pin1;
	PioA2 = PioA.Pin2;
	PioA3 = PioA.Pin3;
	PioA4 = PioA.Pin4;
	PioA5 = PioA.Pin5;
	PioA6 = PioA.Pin6;
	PioA7 = PioA.Pin7;
	PioA8 = PioA.Pin8;
	PioA9 = PioA.Pin9;
	PioA10 = PioA.Pin10;
	PioA11 = PioA.Pin11;
	PioA12 = PioA.Pin12;
	PioA13 = PioA.Pin13;
	PioA14 = PioA.Pin14;
	PioA15 = PioA.Pin15;
	PioA16 = PioA.Pin16;
	PioA17 = PioA.Pin17;
	PioA18 = PioA.Pin18;
	PioA19 = PioA.Pin19;
	PioA20 = PioA.Pin20;
	PioA21 = PioA.Pin21;
	PioA22 = PioA.Pin22;
	PioA23 = PioA.Pin23;
	PioA24 = PioA.Pin24;
	PioA25 = PioA.Pin25;
	PioA26 = PioA.Pin26;
	PioA27 = PioA.Pin27;
	PioA28 = PioA.Pin28;
	PioA29 = PioA.Pin29;
	PioA30 = PioA.Pin30;
	PioA31 = PioA.Pin31;

	PioB0 = PioB.Pin0;
	PioB1 = PioB.Pin1;
	PioB2 = PioB.Pin2;
	PioB3 = PioB.Pin3;
	PioB4 = PioB.Pin4;
	PioB5 = PioB.Pin5;
	PioB6 = PioB.Pin6;
	PioB7 = PioB.Pin7;
	PioB8 = PioB.Pin8;
	PioB9 = PioB.Pin9;
	PioB10 = PioB.Pin10;
	PioB11 = PioB.Pin11;
	PioB12 = PioB.Pin12;
	PioB13 = PioB.Pin13;
	PioB14 = PioB.Pin14;
	PioB15 = PioB.Pin15;
	PioB16 = PioB.Pin16;
	PioB17 = PioB.Pin17;
	PioB18 = PioB.Pin18;
	PioB19 = PioB.Pin19;
	PioB20 = PioB.Pin20;
	PioB21 = PioB.Pin21;
	PioB22 = PioB.Pin22;
	PioB23 = PioB.Pin23;
	PioB24 = PioB.Pin24;
	PioB25 = PioB.Pin25;
	PioB26 = PioB.Pin26;
	PioB27 = PioB.Pin27;
	PioB28 = PioB.Pin28;
	PioB29 = PioB.Pin29;
	PioB30 = PioB.Pin30;
	PioB31 = PioB.Pin31;

	PioC0 = PioC.Pin0;
	PioC1 = PioC.Pin1;
	PioC2 = PioC.Pin2;
	PioC3 = PioC.Pin3;
	PioC4 = PioC.Pin4;
	PioC5 = PioC.Pin5;
	PioC6 = PioC.Pin6;
	PioC7 = PioC.Pin7;
	PioC8 = PioC.Pin8;
	PioC9 = PioC.Pin9;
	PioC10 = PioC.Pin10;
	PioC11 = PioC.Pin11;
	PioC12 = PioC.Pin12;
	PioC13 = PioC.Pin13;
	PioC14 = PioC.Pin14;
	PioC15 = PioC.Pin15;
	PioC16 = PioC.Pin16;
	PioC17 = PioC.Pin17;
	PioC18 = PioC.Pin18;
	PioC19 = PioC.Pin19;
	PioC20 = PioC.Pin20;
	PioC21 = PioC.Pin21;
	PioC22 = PioC.Pin22;
	PioC23 = PioC.Pin23;
	PioC24 = PioC.Pin24;
	PioC25 = PioC.Pin25;
	PioC26 = PioC.Pin26;
	PioC27 = PioC.Pin27;
	PioC28 = PioC.Pin28;
	PioC29 = PioC.Pin29;
	PioC30 = PioC.Pin30;
	PioC31 = PioC.Pin31;

	InterruptPioA0 = PioA.InterruptPin0;
	InterruptPioA1 = PioA.InterruptPin1;
	InterruptPioA2 = PioA.InterruptPin2;
	InterruptPioA3 = PioA.InterruptPin3;
	InterruptPioA4 = PioA.InterruptPin4;
	InterruptPioA5 = PioA.InterruptPin5;
	InterruptPioA6 = PioA.InterruptPin6;
	InterruptPioA7 = PioA.InterruptPin7;
	InterruptPioA8 = PioA.InterruptPin8;
	InterruptPioA9 = PioA.InterruptPin9;
	InterruptPioA10 = PioA.InterruptPin10;
	InterruptPioA11 = PioA.InterruptPin11;
	InterruptPioA12 = PioA.InterruptPin12;
	InterruptPioA13 = PioA.InterruptPin13;
	InterruptPioA14 = PioA.InterruptPin14;
	InterruptPioA15 = PioA.InterruptPin15;
	InterruptPioA16 = PioA.InterruptPin16;
	InterruptPioA17 = PioA.InterruptPin17;
	InterruptPioA18 = PioA.InterruptPin18;
	InterruptPioA19 = PioA.InterruptPin19;
	InterruptPioA20 = PioA.InterruptPin20;
	InterruptPioA21 = PioA.InterruptPin21;
	InterruptPioA22 = PioA.InterruptPin22;
	InterruptPioA23 = PioA.InterruptPin23;
	InterruptPioA24 = PioA.InterruptPin24;
	InterruptPioA25 = PioA.InterruptPin25;
	InterruptPioA26 = PioA.InterruptPin26;
	InterruptPioA27 = PioA.InterruptPin27;
	InterruptPioA28 = PioA.InterruptPin28;
	InterruptPioA29 = PioA.InterruptPin29;
	InterruptPioA30 = PioA.InterruptPin30;
	InterruptPioA31 = PioA.InterruptPin31;
                
	InterruptPioB0 = PioB.InterruptPin0;
	InterruptPioB1 = PioB.InterruptPin1;
	InterruptPioB2 = PioB.InterruptPin2;
	InterruptPioB3 = PioB.InterruptPin3;
	InterruptPioB4 = PioB.InterruptPin4;
	InterruptPioB5 = PioB.InterruptPin5;
	InterruptPioB6 = PioB.InterruptPin6;
	InterruptPioB7 = PioB.InterruptPin7;
	InterruptPioB8 = PioB.InterruptPin8;
	InterruptPioB9 = PioB.InterruptPin9;
	InterruptPioB10 = PioB.InterruptPin10;
	InterruptPioB11 = PioB.InterruptPin11;
	InterruptPioB12 = PioB.InterruptPin12;
	InterruptPioB13 = PioB.InterruptPin13;
	InterruptPioB14 = PioB.InterruptPin14;
	InterruptPioB15 = PioB.InterruptPin15;
	InterruptPioB16 = PioB.InterruptPin16;
	InterruptPioB17 = PioB.InterruptPin17;
	InterruptPioB18 = PioB.InterruptPin18;
	InterruptPioB19 = PioB.InterruptPin19;
	InterruptPioB20 = PioB.InterruptPin20;
	InterruptPioB21 = PioB.InterruptPin21;
	InterruptPioB22 = PioB.InterruptPin22;
	InterruptPioB23 = PioB.InterruptPin23;
	InterruptPioB24 = PioB.InterruptPin24;
	InterruptPioB25 = PioB.InterruptPin25;
	InterruptPioB26 = PioB.InterruptPin26;
	InterruptPioB27 = PioB.InterruptPin27;
	InterruptPioB28 = PioB.InterruptPin28;
	InterruptPioB29 = PioB.InterruptPin29;
	InterruptPioB30 = PioB.InterruptPin30;
	InterruptPioB31 = PioB.InterruptPin31;
                
	InterruptPioC0 = PioC.InterruptPin0;
	InterruptPioC1 = PioC.InterruptPin1;
	InterruptPioC2 = PioC.InterruptPin2;
	InterruptPioC3 = PioC.InterruptPin3;
	InterruptPioC4 = PioC.InterruptPin4;
	InterruptPioC5 = PioC.InterruptPin5;
	InterruptPioC6 = PioC.InterruptPin6;
	InterruptPioC7 = PioC.InterruptPin7;
	InterruptPioC8 = PioC.InterruptPin8;
	InterruptPioC9 = PioC.InterruptPin9;
	InterruptPioC10 = PioC.InterruptPin10;
	InterruptPioC11 = PioC.InterruptPin11;
	InterruptPioC12 = PioC.InterruptPin12;
	InterruptPioC13 = PioC.InterruptPin13;
	InterruptPioC14 = PioC.InterruptPin14;
	InterruptPioC15 = PioC.InterruptPin15;
	InterruptPioC16 = PioC.InterruptPin16;
	InterruptPioC17 = PioC.InterruptPin17;
	InterruptPioC18 = PioC.InterruptPin18;
	InterruptPioC19 = PioC.InterruptPin19;
	InterruptPioC20 = PioC.InterruptPin20;
	InterruptPioC21 = PioC.InterruptPin21;
	InterruptPioC22 = PioC.InterruptPin22;
	InterruptPioC23 = PioC.InterruptPin23;
	InterruptPioC24 = PioC.InterruptPin24;
	InterruptPioC25 = PioC.InterruptPin25;
	InterruptPioC26 = PioC.InterruptPin26;
	InterruptPioC27 = PioC.InterruptPin27;
	InterruptPioC28 = PioC.InterruptPin28;
	InterruptPioC29 = PioC.InterruptPin29;
	InterruptPioC30 = PioC.InterruptPin30;
	InterruptPioC31 = PioC.InterruptPin31;

	CapturePioA0 = PioA.CapturePin0;
	CapturePioA1 = PioA.CapturePin1;
	CapturePioA2 = PioA.CapturePin2;
	CapturePioA3 = PioA.CapturePin3;
	CapturePioA4 = PioA.CapturePin4;
	CapturePioA5 = PioA.CapturePin5;
	CapturePioA6 = PioA.CapturePin6;
	CapturePioA7 = PioA.CapturePin7;
	CapturePioA8 = PioA.CapturePin8;
	CapturePioA9 = PioA.CapturePin9;
	CapturePioA10 = PioA.CapturePin10;
	CapturePioA11 = PioA.CapturePin11;
	CapturePioA12 = PioA.CapturePin12;
	CapturePioA13 = PioA.CapturePin13;
	CapturePioA14 = PioA.CapturePin14;
	CapturePioA15 = PioA.CapturePin15;
	CapturePioA16 = PioA.CapturePin16;
	CapturePioA17 = PioA.CapturePin17;
	CapturePioA18 = PioA.CapturePin18;
	CapturePioA19 = PioA.CapturePin19;
	CapturePioA20 = PioA.CapturePin20;
	CapturePioA21 = PioA.CapturePin21;
	CapturePioA22 = PioA.CapturePin22;
	CapturePioA23 = PioA.CapturePin23;
	CapturePioA24 = PioA.CapturePin24;
	CapturePioA25 = PioA.CapturePin25;
	CapturePioA26 = PioA.CapturePin26;
	CapturePioA27 = PioA.CapturePin27;
	CapturePioA28 = PioA.CapturePin28;
	CapturePioA29 = PioA.CapturePin29;
	CapturePioA30 = PioA.CapturePin30;
	CapturePioA31 = PioA.CapturePin31;
              
	CapturePioB0 = PioB.CapturePin0;
	CapturePioB1 = PioB.CapturePin1;
	CapturePioB2 = PioB.CapturePin2;
	CapturePioB3 = PioB.CapturePin3;
	CapturePioB4 = PioB.CapturePin4;
	CapturePioB5 = PioB.CapturePin5;
	CapturePioB6 = PioB.CapturePin6;
	CapturePioB7 = PioB.CapturePin7;
	CapturePioB8 = PioB.CapturePin8;
	CapturePioB9 = PioB.CapturePin9;
	CapturePioB10 = PioB.CapturePin10;
	CapturePioB11 = PioB.CapturePin11;
	CapturePioB12 = PioB.CapturePin12;
	CapturePioB13 = PioB.CapturePin13;
	CapturePioB14 = PioB.CapturePin14;
	CapturePioB15 = PioB.CapturePin15;
	CapturePioB16 = PioB.CapturePin16;
	CapturePioB17 = PioB.CapturePin17;
	CapturePioB18 = PioB.CapturePin18;
	CapturePioB19 = PioB.CapturePin19;
	CapturePioB20 = PioB.CapturePin20;
	CapturePioB21 = PioB.CapturePin21;
	CapturePioB22 = PioB.CapturePin22;
	CapturePioB23 = PioB.CapturePin23;
	CapturePioB24 = PioB.CapturePin24;
	CapturePioB25 = PioB.CapturePin25;
	CapturePioB26 = PioB.CapturePin26;
	CapturePioB27 = PioB.CapturePin27;
	CapturePioB28 = PioB.CapturePin28;
	CapturePioB29 = PioB.CapturePin29;
	CapturePioB30 = PioB.CapturePin30;
	CapturePioB31 = PioB.CapturePin31;
              
	CapturePioC0 = PioC.CapturePin0;
	CapturePioC1 = PioC.CapturePin1;
	CapturePioC2 = PioC.CapturePin2;
	CapturePioC3 = PioC.CapturePin3;
	CapturePioC4 = PioC.CapturePin4;
	CapturePioC5 = PioC.CapturePin5;
	CapturePioC6 = PioC.CapturePin6;
	CapturePioC7 = PioC.CapturePin7;
	CapturePioC8 = PioC.CapturePin8;
	CapturePioC9 = PioC.CapturePin9;
	CapturePioC10 = PioC.CapturePin10;
	CapturePioC11 = PioC.CapturePin11;
	CapturePioC12 = PioC.CapturePin12;
	CapturePioC13 = PioC.CapturePin13;
	CapturePioC14 = PioC.CapturePin14;
	CapturePioC15 = PioC.CapturePin15;
	CapturePioC16 = PioC.CapturePin16;
	CapturePioC17 = PioC.CapturePin17;
	CapturePioC18 = PioC.CapturePin18;
	CapturePioC19 = PioC.CapturePin19;
	CapturePioC20 = PioC.CapturePin20;
	CapturePioC21 = PioC.CapturePin21;
	CapturePioC22 = PioC.CapturePin22;
	CapturePioC23 = PioC.CapturePin23;
	CapturePioC24 = PioC.CapturePin24;
	CapturePioC25 = PioC.CapturePin25;
	CapturePioC26 = PioC.CapturePin26;
	CapturePioC27 = PioC.CapturePin27;
	CapturePioC28 = PioC.CapturePin28;
	CapturePioC29 = PioC.CapturePin29;
	CapturePioC30 = PioC.CapturePin30;
	CapturePioC31 = PioC.CapturePin31;

	HplPioA0 = PioA.HplPin0;
	HplPioA1 = PioA.HplPin1;
	HplPioA2 = PioA.HplPin2;
	HplPioA3 = PioA.HplPin3;
	HplPioA4 = PioA.HplPin4;
	HplPioA5 = PioA.HplPin5;
	HplPioA6 = PioA.HplPin6;
	HplPioA7 = PioA.HplPin7;
	HplPioA8 = PioA.HplPin8;
	HplPioA9 = PioA.HplPin9;
	HplPioA10 = PioA.HplPin10;
	HplPioA11 = PioA.HplPin11;
	HplPioA12 = PioA.HplPin12;
	HplPioA13 = PioA.HplPin13;
	HplPioA14 = PioA.HplPin14;
	HplPioA15 = PioA.HplPin15;
	HplPioA16 = PioA.HplPin16;
	HplPioA17 = PioA.HplPin17;
	HplPioA18 = PioA.HplPin18;
	HplPioA19 = PioA.HplPin19;
	HplPioA20 = PioA.HplPin20;
	HplPioA21 = PioA.HplPin21;
	HplPioA22 = PioA.HplPin22;
	HplPioA23 = PioA.HplPin23;
	HplPioA24 = PioA.HplPin24;
	HplPioA25 = PioA.HplPin25;
	HplPioA26 = PioA.HplPin26;
	HplPioA27 = PioA.HplPin27;
	HplPioA28 = PioA.HplPin28;
	HplPioA29 = PioA.HplPin29;
	HplPioA30 = PioA.HplPin30;
	HplPioA31 = PioA.HplPin31;

	HplPioB0 = PioB.HplPin0;
	HplPioB1 = PioB.HplPin1;
	HplPioB2 = PioB.HplPin2;
	HplPioB3 = PioB.HplPin3;
	HplPioB4 = PioB.HplPin4;
	HplPioB5 = PioB.HplPin5;
	HplPioB6 = PioB.HplPin6;
	HplPioB7 = PioB.HplPin7;
	HplPioB8 = PioB.HplPin8;
	HplPioB9 = PioB.HplPin9;
	HplPioB10 = PioB.HplPin10;
	HplPioB11 = PioB.HplPin11;
	HplPioB12 = PioB.HplPin12;
	HplPioB13 = PioB.HplPin13;
	HplPioB14 = PioB.HplPin14;
	HplPioB15 = PioB.HplPin15;
	HplPioB16 = PioB.HplPin16;
	HplPioB17 = PioB.HplPin17;
	HplPioB18 = PioB.HplPin18;
	HplPioB19 = PioB.HplPin19;
	HplPioB20 = PioB.HplPin20;
	HplPioB21 = PioB.HplPin21;
	HplPioB22 = PioB.HplPin22;
	HplPioB23 = PioB.HplPin23;
	HplPioB24 = PioB.HplPin24;
	HplPioB25 = PioB.HplPin25;
	HplPioB26 = PioB.HplPin26;
	HplPioB27 = PioB.HplPin27;
	HplPioB28 = PioB.HplPin28;
	HplPioB29 = PioB.HplPin29;
	HplPioB30 = PioB.HplPin30;
	HplPioB31 = PioB.HplPin31;

	HplPioC0 = PioC.HplPin0;
	HplPioC1 = PioC.HplPin1;
	HplPioC2 = PioC.HplPin2;
	HplPioC3 = PioC.HplPin3;
	HplPioC4 = PioC.HplPin4;
	HplPioC5 = PioC.HplPin5;
	HplPioC6 = PioC.HplPin6;
	HplPioC7 = PioC.HplPin7;
	HplPioC8 = PioC.HplPin8;
	HplPioC9 = PioC.HplPin9;
	HplPioC10 = PioC.HplPin10;
	HplPioC11 = PioC.HplPin11;
	HplPioC12 = PioC.HplPin12;
	HplPioC13 = PioC.HplPin13;
	HplPioC14 = PioC.HplPin14;
	HplPioC15 = PioC.HplPin15;
	HplPioC16 = PioC.HplPin16;
	HplPioC17 = PioC.HplPin17;
	HplPioC18 = PioC.HplPin18;
	HplPioC19 = PioC.HplPin19;
	HplPioC20 = PioC.HplPin20;
	HplPioC21 = PioC.HplPin21;
	HplPioC22 = PioC.HplPin22;
	HplPioC23 = PioC.HplPin23;
	HplPioC24 = PioC.HplPin24;
	HplPioC25 = PioC.HplPin25;
	HplPioC26 = PioC.HplPin26;
	HplPioC27 = PioC.HplPin27;
	HplPioC28 = PioC.HplPin28;
	HplPioC29 = PioC.HplPin29;
	HplPioC30 = PioC.HplPin30;
	HplPioC31 = PioC.HplPin31;
}
