#!/bin/sh

set -eu

# Usage: sh debian/ignore-manpage.sh <module> ...
#        PDF::API2 may be ommitted from module name
#        Text from lintian warnings may be used instead of module name too
# Example: sh debian/ignore-manpage.sh PDF::API2::Win32 Version usr/share/man/man3/PDF::API2::Resource::Font::CoreFont::courieroblique.3pm.gz
#
# Adds manpage to the list of manpages to ignore
# Stores their name and size in debian/ignored-manpages
# The manpages are removed after "$(MAKE) install" is called
# See debian/remove-ignored-manpages.sh

LIST=debian/ignored-manpages

while [ -n "${1:-}" ]; do
    FILE=`echo $1 | sed 's,^usr/share/man/man3/,,; s,::,/,g; s,\.3pm\.gz$,,'`
    echo $FILE | grep -l 'PDF/API2/' > /dev/null || FILE="PDF/API2/$FILE"
    sed -i "/  $1$/ d" $LIST
    md5sum lib/${FILE}.pm | sed 's,lib/PDF/API2/,,; s,/,::,g; s,\.pm$,,' >> $LIST
    shift
done
