#include <winpr/crt.h>
#include <winpr/print.h>

#include <freerdp/freerdp.h>
#include <freerdp/codec/rfx.h>


static BYTE encodeHeaderSample[] = {
	/* as in 4.2.2 */
	0xc0, 0xcc, 0x0c, 0x00, 0x00, 0x00, 0xca, 0xac, 0xcc, 0xca, 0x00, 0x01, 0xc3, 0xcc, 0x0d, 0x00,
	0x00, 0x00, 0x01, 0xff, 0x00, 0x40, 0x00, 0x28, 0xa8, 0xc1, 0xcc, 0x0a, 0x00, 0x00, 0x00, 0x01,
	0x01, 0x00, 0x01, 0xc2, 0xcc, 0x0c, 0x00, 0x00, 0x00, 0x01, 0x00, 0x40, 0x00, 0x40, 0x00
};

static BYTE encodeDataSample[] = {
	/* FRAME_BEGIN as in 4.2.3 */
	0xc4, 0xcc, 0x0e, 0x00, 0x00, 0x00, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00,

	/* REGION as in 4.2.3 */
	0xc6, 0xcc,	0x17, 0x00, 0x00, 0x00, 0x01, 0x00, 0xcd, 0x01, 0x00, 0x00, 0x00, 0x00, 0x00, 0x40,
	0x00, 0x40,	0x00, 0xc1, 0xca, 0x01, 0x00,

	/* TILESET as in 4.2.4.1 */
	0xc7, 0xcc, 0x3e, 0x0b, 0x00, 0x00, 0x01, 0x00, 0xc2, 0xca, 0x00, 0x00, 0x51, 0x50, 0x01, 0x40,
	0x01, 0x00, 0x23, 0x0b, 0x00, 0x00, 0x66, 0x66, 0x77, 0x88, 0x98, 0xc3, 0xca, 0x23, 0x0b, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xae, 0x03, 0xcf, 0x03, 0x93, 0x03, 0xc0, 0x01,
	0x01, 0x15, 0x48, 0x99, 0xc7, 0x41, 0xa1, 0x12, 0x68, 0x11, 0xdc, 0x22, 0x29, 0x74, 0xef, 0xfd,
	0x20, 0x92, 0xe0, 0x4e, 0xa8, 0x69, 0x3b, 0xfd, 0x41, 0x83, 0xbf, 0x28, 0x53, 0x0c, 0x1f, 0xe2,
	0x54, 0x0c, 0x77, 0x7c, 0xa3, 0x05, 0x7c, 0x30, 0xd0, 0x9c, 0xe8, 0x09, 0x39, 0x1a, 0x5d, 0xff,
	0xe2, 0x01, 0x22, 0x13, 0x80, 0x90, 0x87, 0xd2, 0x9f, 0xfd, 0xfd, 0x50, 0x09, 0x0d, 0x24, 0xa0,
	0x8f, 0xab, 0xfe, 0x3c, 0x04, 0x84, 0xc6, 0x9c, 0xde, 0xf8, 0x80, 0xc3, 0x22, 0x50, 0xaf, 0x4c,
	0x2a, 0x7f, 0xfe, 0xe0, 0x5c, 0xa9, 0x52, 0x8a, 0x06, 0x7d, 0x3d, 0x09, 0x03, 0x65, 0xa3, 0xaf,
	0xd2, 0x61, 0x1f, 0x72, 0x04, 0x50, 0x8d, 0x3e, 0x16, 0x4a, 0x3f, 0xff, 0xfd, 0x41, 0x42, 0x87,
	0x24, 0x37, 0x06, 0x17, 0x2e, 0x56, 0x05, 0x9c, 0x1c, 0xb3, 0x84, 0x6a, 0xff, 0xfb, 0x43, 0x8b,
	0xa3, 0x7a, 0x32, 0x43, 0x28, 0xe1, 0x1f, 0x50, 0x54, 0xfc, 0xca, 0xa5, 0xdf, 0xff, 0x08, 0x04,
	0x48, 0x15, 0x61, 0xd9, 0x76, 0x43, 0xf8, 0x2a, 0x07, 0xe9, 0x65, 0xf7, 0xc6, 0x89, 0x2d, 0x40,
	0xa1, 0xc3, 0x35, 0x8d, 0xf5, 0xed, 0xf5, 0x91, 0xae, 0x2f, 0xcc, 0x01, 0xce, 0x03, 0x48, 0xc0,
	0x8d, 0x63, 0xf4, 0xfd, 0x50, 0x20, 0x2d, 0x0c, 0x9b, 0xb0, 0x8d, 0x13, 0xc0, 0x8a, 0x09, 0x52,
	0x1b, 0x02, 0x6e, 0x42, 0x3b, 0xd0, 0x13, 0x4e, 0x84, 0x01, 0x26, 0x88, 0x6a, 0x04, 0x84, 0x34,
	0x2a, 0xa5, 0x00, 0xba, 0x54, 0x48, 0x58, 0xea, 0x54, 0x02, 0xb4, 0x1d, 0xa7, 0xfa, 0x47, 0x82,
	0xec, 0x7a, 0x77, 0xfd, 0x00, 0x92, 0x66, 0x62, 0x04, 0xa6, 0x9b, 0xff, 0xf6, 0x80, 0xc0, 0x69,
	0x01, 0xc2, 0x3e, 0x90, 0x14, 0x20, 0x2f, 0xfc, 0x40, 0x96, 0x59, 0x58, 0x0c, 0xb1, 0x13, 0x68,
	0x20, 0x2e, 0xb5, 0xf5, 0xdf, 0xff, 0xf8, 0xfc, 0x56, 0x88, 0x60, 0x24, 0x53, 0xb5, 0x41, 0x46,
	0x5f, 0xf8, 0xf1, 0x7e, 0xde, 0x4a, 0x08, 0x97, 0xe0, 0x55, 0x03, 0x8f, 0xe5, 0x75, 0x61, 0x03,
	0xf2, 0xe1, 0x90, 0x01, 0xa2, 0x8e, 0x88, 0x04, 0x98, 0x05, 0x93, 0x6b, 0xff, 0xea, 0xc0, 0x60,
	0xa1, 0x88, 0x04, 0x49, 0xbf, 0xf7, 0xff, 0x8c, 0xb4, 0x59, 0x90, 0x80, 0x30, 0x64, 0x53, 0xff,
	0xf5, 0xc4, 0x48, 0xda, 0xda, 0xcb, 0x80, 0x38, 0x61, 0x57, 0xb2, 0xaf, 0x00, 0xe8, 0x7b, 0x46,
	0xe6, 0xd8, 0x02, 0x03, 0x8a, 0x06, 0x18, 0x14, 0x32, 0x83, 0xd0, 0x8a, 0xee, 0xbc, 0x81, 0xb4,
	0x28, 0xc4, 0x7f, 0xf9, 0xa1, 0x69, 0x00, 0x91, 0xc5, 0x51, 0xff, 0xfe, 0x3f, 0xe9, 0xf1, 0x70,
	0x30, 0x24, 0x10, 0xa7, 0xcb, 0x1f, 0x8a, 0x24, 0x93, 0xed, 0x83, 0x00, 0x36, 0x20, 0xd1, 0x50,
	0xe7, 0xd8, 0xad, 0x58, 0x20, 0x09, 0x22, 0x80, 0xd0, 0xca, 0x5d, 0x1a, 0xd7, 0xf1, 0x60, 0x75,
	0x2a, 0xf2, 0xd7, 0xf8, 0xc0, 0x32, 0x45, 0x86, 0x00, 0x43, 0x01, 0xfe, 0x80, 0xf7, 0x42, 0x81,
	0x74, 0x84, 0x4c, 0xa1, 0x60, 0x4c, 0xcb, 0x14, 0x58, 0x01, 0x4d, 0x18, 0xa1, 0xaa, 0x47, 0x0e,
	0x11, 0x1a, 0x40, 0x7d, 0x41, 0x02, 0xe3, 0x30, 0xcd, 0x33, 0x81, 0x34, 0x06, 0x46, 0x83, 0xa2,
	0x47, 0x1c, 0x04, 0xaa, 0x20, 0x12, 0xa2, 0x8b, 0x81, 0xc4, 0x9c, 0xa0, 0x2e, 0x06, 0x32, 0xf8,
	0x86, 0x85, 0x01, 0xe8, 0x70, 0xf9, 0x46, 0x09, 0x6a, 0xbf, 0xe0, 0xf5, 0xa4, 0xc8, 0x78, 0xe7,
	0xd2, 0x97, 0x0b, 0xbc, 0x3c, 0x97, 0xff, 0xd5, 0x40, 0x94, 0xb2, 0xc1, 0x18, 0x18, 0x11, 0x1f,
	0x43, 0xc1, 0x18, 0xc3, 0x83, 0x7f, 0x9a, 0x31, 0xc4, 0x8e, 0x70, 0x56, 0xda, 0xf6, 0x17, 0xde,
	0xd1, 0x02, 0x0d, 0x42, 0x21, 0x13, 0xdc, 0x3a, 0x3c, 0x40, 0x9e, 0xf4, 0x01, 0x43, 0xea, 0x0c,
	0x46, 0x73, 0xa2, 0x7b, 0x0c, 0x80, 0xff, 0xe4, 0xad, 0x2e, 0x09, 0xb4, 0x63, 0xb0, 0x8c, 0x54,
	0x59, 0xfa, 0xac, 0x76, 0x36, 0x10, 0x05, 0xf0, 0x98, 0x88, 0x83, 0x42, 0x00, 0x20, 0x71, 0xcc,
	0xc1, 0xa9, 0x97, 0x3e, 0x5a, 0x0d, 0x04, 0x50, 0x92, 0x23, 0x20, 0x0d, 0x0a, 0x1c, 0x57, 0xd7,
	0xff, 0x10, 0xf2, 0x03, 0x0f, 0x58, 0x1b, 0xa5, 0x11, 0xf8, 0xf1, 0xb4, 0x12, 0xdb, 0x1a, 0x48,
	0x56, 0x1f, 0xe3, 0xc7, 0x50, 0xe9, 0x16, 0xb4, 0xbc, 0xb0, 0x40, 0x93, 0xea, 0xb5, 0x5b, 0x2f,
	0xfc, 0x50, 0x0a, 0x6f, 0xcc, 0x25, 0xe0, 0x06, 0xab, 0x5f, 0x24, 0xfe, 0x8b, 0xcb, 0x42, 0x43,
	0x7e, 0x69, 0x02, 0x25, 0xc7, 0x38, 0x00, 0x6e, 0xe5, 0x80, 0xa8, 0xa4, 0x30, 0x44, 0x15, 0x8f,
	0xe9, 0x0c, 0xd3, 0xa6, 0xc2, 0x14, 0x34, 0x4a, 0xfe, 0x03, 0x7f, 0x06, 0xa5, 0x91, 0x02, 0x54,
	0xf1, 0xa1, 0xa1, 0x53, 0xbf, 0x11, 0xf2, 0x8f, 0x83, 0x67, 0x80, 0x09, 0x08, 0x12, 0x3f, 0xfd,
	0x44, 0x91, 0xc2, 0x83, 0x30, 0x50, 0x07, 0x02, 0x82, 0x4d, 0x31, 0x34, 0x06, 0x41, 0x79, 0x6f,
	0xf0, 0xcc, 0x03, 0x79, 0x00, 0x2c, 0x05, 0x24, 0xec, 0x8d, 0x29, 0x15, 0xaf, 0x44, 0xc8, 0xeb,
	0x4f, 0xe1, 0xfd, 0xf1, 0x41, 0x48, 0x81, 0x08, 0xaf, 0xfe, 0x51, 0x48, 0xce, 0xe7, 0xf9, 0xb6,
	0x0a, 0x30, 0x83, 0x11, 0xf0, 0x0c, 0x3b, 0xd2, 0xa6, 0x24, 0x24, 0xef, 0x25, 0xfa, 0x5a, 0x3e,
	0x92, 0x3e, 0x79, 0x0e, 0x35, 0x61, 0xc8, 0xaa, 0x1c, 0x2e, 0x9a, 0x27, 0x7f, 0xff, 0xf0, 0x7d,
	0x30, 0x5b, 0xbc, 0x91, 0xff, 0xfe, 0x43, 0x24, 0x28, 0x66, 0xa7, 0x70, 0x99, 0x28, 0x6e, 0x2b,
	0x18, 0x2b, 0xd4, 0xa1, 0x77, 0x3b, 0x96, 0x9f, 0xf7, 0xeb, 0xbe, 0x1f, 0x04, 0x34, 0x75, 0x84,
	0x31, 0x42, 0x4c, 0x65, 0xaa, 0x09, 0x50, 0xa0, 0xc4, 0x51, 0x31, 0xd3, 0x26, 0x3a, 0x1b, 0xf4,
	0x6e, 0x4a, 0x4e, 0x17, 0x25, 0x84, 0x78, 0x7d, 0x2c, 0x3f, 0x46, 0x18, 0xca, 0x5f, 0xf9, 0xe5,
	0x38, 0x2f, 0xd8, 0x71, 0x94, 0x94, 0xe2, 0xcc, 0xa3, 0x15, 0xb0, 0xda, 0xa9, 0xcb, 0x58, 0xe4,
	0x18, 0x77, 0x93, 0x8a, 0x51, 0xc6, 0x23, 0xc4, 0x4e, 0x6d, 0xd9, 0x14, 0x1e, 0x9b, 0x8d, 0xbc,
	0xcb, 0x9d, 0xc4, 0x18, 0x05, 0xf5, 0xa9, 0x29, 0xf8, 0x6d, 0x29, 0x38, 0xc7, 0x44, 0xe5, 0x3a,
	0xcd, 0xba, 0x61, 0x98, 0x4a, 0x57, 0x02, 0x96, 0x42, 0x02, 0xd9, 0x37, 0x11, 0xde, 0x2d, 0xd4,
	0x3f, 0xfe, 0x61, 0xe7, 0x33, 0xd7, 0x89, 0x4a, 0xdd, 0xb0, 0x34, 0x47, 0xf4, 0xdc, 0xad, 0xaa,
	0xc9, 0x9d, 0x7e, 0x6d, 0x4b, 0xcc, 0xdc, 0x17, 0x89, 0x57, 0xfd, 0xbb, 0x37, 0x75, 0x47, 0x5a,
	0xec, 0x2c, 0x6e, 0x3c, 0x15, 0x92, 0x54, 0x64, 0x2c, 0xab, 0x9e, 0xab, 0x2b, 0xdd, 0x3c, 0x66,
	0xa0, 0x8f, 0x47, 0x5e, 0x93, 0x1a, 0x37, 0x16, 0xf4, 0x89, 0x23, 0x00, 0x00, 0xb0, 0x33, 0x56,
	0xfa, 0x14, 0x1e, 0xff, 0x48, 0x7a, 0x7e, 0x0f, 0x10, 0x1f, 0xf4, 0x91, 0xc8, 0x10, 0x56, 0x84,
	0xff, 0x08, 0xec, 0xb4, 0xac, 0x0e, 0x0f, 0xff, 0xad, 0xc5, 0xe0, 0x1a, 0x2f, 0x82, 0x04, 0x9f,
	0x91, 0xc2, 0x0e, 0xfe, 0x48, 0x36, 0x79, 0x01, 0x42, 0x14, 0xff, 0xfe, 0x30, 0xf0, 0x08, 0x18,
	0xf1, 0x81, 0x45, 0x9a, 0x60, 0xc1, 0x79, 0xf0, 0x14, 0x12, 0x10, 0xce, 0xea, 0x31, 0x5a, 0xff,
	0xfc, 0x20, 0x13, 0x82, 0x2f, 0xc9, 0x02, 0x1f, 0x81, 0xcb, 0x00, 0xe1, 0x10, 0xd2, 0xb4, 0xbe,
	0x87, 0xff, 0xb0, 0x1e, 0x27, 0x81, 0xb7, 0x04, 0x06, 0x3c, 0xc2, 0x04, 0xf6, 0x06, 0x0e, 0x28,
	0xbc, 0x40, 0xbf, 0x12, 0x1e, 0x86, 0xd4, 0x6a, 0x7f, 0x18, 0x1b, 0x96, 0x85, 0x4c, 0x16, 0x80,
	0xdf, 0x2c, 0xa5, 0x8d, 0x86, 0xa3, 0x4a, 0x8a, 0xb4, 0x1b, 0xa1, 0x38, 0xa9, 0xd5, 0xff, 0xff,
	0xea, 0x06, 0x20, 0xd2, 0x95, 0x1e, 0xf4, 0x2f, 0xb2, 0x12, 0x0e, 0x61, 0x78, 0x4a, 0x17, 0x52,
	0x5d, 0xe4, 0x25, 0x1f, 0xfe, 0xc0, 0xb3, 0x1f, 0xff, 0xff, 0xec, 0x02, 0x82, 0x80, 0x90, 0x41,
	0x88, 0xde, 0x48, 0x2c, 0x42, 0x52, 0x0b, 0x2f, 0x43, 0x7e, 0x50, 0x78, 0xf2, 0x67, 0x78, 0x41,
	0x34, 0x3d, 0xc8, 0x0f, 0x67, 0xa1, 0xeb, 0x21, 0xfe, 0xc0, 0x1f, 0x22, 0x60, 0x41, 0x6c, 0x00,
	0x92, 0x4b, 0x60, 0x10, 0xd0, 0x0d, 0x01, 0x35, 0x05, 0x0e, 0x87, 0xa2, 0xa0, 0x5d, 0x1f, 0xa3,
	0xaf, 0x7f, 0xf1, 0xbe, 0x8f, 0xcd, 0xa5, 0x00, 0x1c, 0x10, 0x40, 0x15, 0x76, 0x81, 0x05, 0xef,
	0xee, 0x00, 0x60, 0x84, 0x00, 0x99, 0x40, 0x4a, 0x82, 0x17, 0xe9, 0xfc, 0xc4, 0x7f, 0xff, 0xfd,
	0x04, 0x80, 0x06, 0x06, 0xdc, 0xaf, 0xa7, 0x7e, 0x94, 0x75, 0x74, 0x01, 0x00, 0xe0, 0x91, 0x00,
	0x85, 0x7f, 0x8e, 0xd6, 0x0b, 0x20, 0x21, 0x30, 0xca, 0x62, 0x8e, 0x07, 0x04, 0xe9, 0x45, 0x40,
	0x5f, 0x47, 0x4a, 0x30, 0x15, 0x41, 0xcb, 0xdf, 0xff, 0xfc, 0xbf, 0xc3, 0xb4, 0x46, 0x6a, 0x01,
	0x40, 0xd0, 0xa7, 0x34, 0x18, 0x24, 0x1c, 0x2a, 0x45, 0xfe, 0xa8, 0x05, 0x08, 0x61, 0xfd, 0xa8,
	0x80, 0x71, 0x01, 0x25, 0x9c, 0xc1, 0x47, 0x17, 0x37, 0x02, 0x7a, 0x15, 0xff, 0xf3, 0x01, 0x45,
	0x7f, 0xd6, 0x80, 0x60, 0x83, 0x67, 0xf8, 0x9d, 0x2f, 0xf4, 0xdd, 0x8c, 0x30, 0x01, 0x51, 0x42,
	0xbc, 0x43, 0x7a, 0x6b, 0x9f, 0x84, 0x1e, 0x00, 0x48, 0xc1, 0xe0, 0xb7, 0xe0, 0x7e, 0x99, 0xf2,
	0x4a, 0xe9, 0x40, 0x02, 0x81, 0xc3, 0x00, 0x24, 0x3a, 0xc5, 0x52, 0x0f, 0x91, 0xc8, 0x68, 0x25,
	0x40, 0x99, 0xa4, 0x25, 0x1a, 0x04, 0xd0, 0xa2, 0x91, 0xdd, 0xeb, 0x93, 0x00, 0x21, 0x49, 0x24,
	0x8b, 0x40, 0x75, 0x38, 0x14, 0xa1, 0xfd, 0x3f, 0x88, 0x25, 0xbf, 0x32, 0x00, 0xe3, 0x19, 0xfc,
	0xb9, 0xf8, 0x6f, 0x81, 0xc0, 0x01, 0xb3, 0x93, 0x20, 0x09, 0x08, 0x25, 0x84, 0xe1, 0x34, 0xd4,
	0x1b, 0x48, 0x88, 0x11, 0xa0, 0x15, 0x59, 0xd7, 0x07, 0x81, 0x81, 0x3b, 0xa1, 0x40, 0x2e, 0x2f,
	0x48, 0x70, 0x09, 0xc4, 0x76, 0x49, 0x0f, 0x2e, 0x50, 0x2e, 0x46, 0x19, 0xa4, 0x16, 0xa2, 0x1b,
	0x84, 0xa2, 0x89, 0x58, 0xfc, 0x4f, 0x3f, 0x40, 0x90, 0x4c, 0xa3, 0x01, 0x32, 0x09, 0x02, 0x80,
	0x9c, 0x91, 0x13, 0x2c, 0xba, 0xde, 0x5d, 0x99, 0xf2, 0xff, 0xff, 0x3d, 0x5a, 0x1f, 0xa9, 0x02,
	0x90, 0x8f, 0xf3, 0x08, 0xbd, 0x01, 0xf8, 0xd0, 0x2a, 0x95, 0x41, 0x0c, 0x40, 0x0a, 0x20, 0xc4,
	0xd4, 0xcc, 0x6b, 0x0f, 0xf0, 0x80, 0xb1, 0x5d, 0x28, 0x3d, 0x08, 0xc2, 0xf8, 0x31, 0x02, 0x49,
	0x88, 0x14, 0x28, 0xed, 0xe8, 0x86, 0x3b, 0x00, 0x9f, 0x95, 0x06, 0x37, 0x15, 0xa4, 0x59, 0xc8,
	0x80, 0xb6, 0x10, 0xf0, 0xe5, 0xb8, 0x18, 0x00, 0x56, 0x1c, 0xff, 0x95, 0x21, 0x0e, 0x7f, 0x2b,
	0xc5, 0x08, 0x59, 0x10, 0xe1, 0x46, 0x31, 0x8d, 0xec, 0xe0, 0xa1, 0x99, 0xbb, 0x21, 0xff, 0xfe,
	0x30, 0x10, 0xd0, 0x05, 0xe3, 0x08, 0x50, 0xfc, 0xf3, 0x0e, 0x00, 0x8d, 0x68, 0x8e, 0x07, 0xa6,
	0x80, 0x34, 0x42, 0xed, 0x1f, 0x88, 0x00, 0xf0, 0x8a, 0x21, 0xae, 0xf7, 0xfb, 0x80, 0x28, 0x86,
	0x0f, 0xff, 0xff, 0x82, 0xea, 0x47, 0x95, 0x91, 0xe0, 0x04, 0x01, 0x44, 0x0c, 0x29, 0xff, 0x0e,
	0x33, 0xe8, 0xc0, 0x54, 0x04, 0x23, 0xfc, 0x81, 0x5b, 0xf0, 0x3c, 0x07, 0x10, 0x70, 0x30, 0xd8,
	0x21, 0x6f, 0xef, 0xde, 0x46, 0x09, 0x43, 0xfa, 0x5f, 0xff, 0x0d, 0x72, 0x30, 0xdd, 0x00, 0xdb,
	0xe4, 0x48, 0x24, 0x97, 0x08, 0x46, 0xb1, 0x49, 0xc4, 0x4d, 0x80, 0x12, 0x60, 0xff, 0xa4, 0xa6,
	0xff, 0xf6, 0x8c, 0x00, 0x40, 0x05, 0x02, 0xb4, 0x0f, 0xf0, 0x3e, 0xfc, 0x84, 0x38, 0x81, 0x94,
	0x8b, 0xfe, 0x49, 0xef, 0xc0, 0x10, 0x49, 0x88, 0x28, 0xa2, 0x1c, 0x2a, 0x8b, 0x64, 0xd4, 0x86,
	0xd7, 0xff, 0xff, 0xff, 0xeb, 0x91, 0x6b, 0x11, 0x10, 0x00, 0x69, 0x4c, 0xbf, 0xb4, 0x1c, 0xd8,
	0x00, 0x07, 0x16, 0x80, 0x60, 0x0a, 0x1c, 0x82, 0x42, 0x27, 0x82, 0x43, 0xc9, 0x0a, 0x64, 0x20,
	0x5a, 0x5f, 0x4e, 0xbf, 0x8c, 0x38, 0x82, 0x36, 0x02, 0x07, 0x72, 0x79, 0x07, 0x23, 0xb4, 0xbb,
	0x57, 0x5f, 0xe8, 0x04, 0xdd, 0x39, 0xe9, 0x07, 0x95, 0xbe, 0x04, 0x2b, 0xdd, 0x8e, 0x22, 0xdc,
	0x14, 0x2c, 0x61, 0xa3, 0xa9, 0xcd, 0x4f, 0x82, 0x5d, 0xa0, 0x44, 0xdf, 0xf4, 0x96, 0xff, 0xf5,
	0x2b, 0xff, 0xfe, 0x01, 0x19, 0xd2, 0xa2, 0x9e, 0x43, 0xa5, 0x7f, 0xf0, 0x4c, 0x4c, 0x2b, 0x3c,
	0x33, 0xe2, 0x55, 0xff, 0x04, 0x06, 0x29, 0x2c, 0x0d, 0x22, 0x5d, 0x7c, 0x93, 0xba, 0x18, 0xaf,
	0xf9, 0x32, 0xa6, 0xc3, 0x99, 0x46, 0x79, 0xe3, 0x06, 0xa6, 0x38, 0x8b, 0x92, 0x22, 0x4b, 0xdb,
	0x1b, 0x36, 0x20, 0xb0, 0x6c, 0x20, 0xce, 0x37, 0x42, 0xe1, 0x66, 0xd4, 0x49, 0x34, 0x42, 0x8b,
	0xfa, 0x9c, 0x12, 0x99, 0xdc, 0x06, 0x87, 0xfa, 0x46, 0xf8, 0x2f, 0x04, 0xa9, 0xd8, 0x82, 0x07,
	0xa6, 0x30, 0x0f, 0xc0, 0xdf, 0x35, 0xe8, 0x90, 0xf0, 0xff, 0xff, 0xa8, 0xe0, 0xd7, 0x02, 0x60,
	0x1a, 0xc3, 0x20, 0x28, 0xa2, 0x31, 0x29, 0x3c, 0xeb, 0x04, 0xa5, 0xdd, 0x48, 0x0e, 0x82, 0xa4,
	0xb6, 0x56, 0x22, 0x06, 0x57, 0xe0, 0xda, 0x10, 0x27, 0x31, 0x0e, 0x11, 0x77, 0xfe, 0x02, 0x60,
	0x16, 0x48, 0x81, 0x8c, 0x0d, 0x05, 0x17, 0x7f, 0xcb, 0xbb, 0x7e, 0x25, 0x2a, 0x41, 0xfd, 0x8a,
	0x7f, 0xc9, 0x36, 0x7c, 0xe0, 0x98, 0x7e, 0x92, 0xef, 0x7e, 0x06, 0x03, 0x13, 0x3e, 0x20, 0x3a,
	0xbf, 0x4c, 0xc3, 0x0f, 0x2e, 0x80, 0x74, 0xbf, 0x39, 0x3c, 0xf0, 0xa6, 0xb2, 0xe9, 0x3f, 0x41,
	0x55, 0x1f, 0x2c, 0xf5, 0xd2, 0x7e, 0x8c, 0xae, 0x4e, 0xaa, 0x61, 0x3c, 0xbc, 0x3f, 0xc4, 0xc7,
	0x36, 0xdc, 0x23, 0xc8, 0xb8, 0x52, 0xe2, 0x8a, 0x80, 0x18, 0x00, 0x00, 0xb2, 0x46, 0xa2, 0x56,
	0x0d, 0x12, 0x94, 0xaa, 0xbd, 0x01, 0x07, 0xff, 0xfa, 0x34, 0x0c, 0x5f, 0xf8, 0x0c, 0x12, 0x50,
	0xaf, 0xd6, 0xd1, 0x89, 0x40, 0xa4, 0xff, 0xe0, 0xce, 0xc4, 0x49, 0x25, 0x9d, 0xc1, 0xff, 0x7e,
	0x60, 0x24, 0x5d, 0xcc, 0x10, 0xc0, 0xbe, 0x5a, 0x12, 0xd3, 0xc3, 0xfe, 0x2d, 0x40, 0x7c, 0x28,
	0x9e, 0x71, 0x01, 0xd2, 0x6e, 0x86, 0x0b, 0xc8, 0xf2, 0x9b, 0x45, 0x08, 0x4c, 0x04, 0x52, 0x7e,
	0xf2, 0x7e, 0xd9, 0xcc, 0x0b, 0x1c, 0x20, 0x80, 0xae, 0xaf, 0xfe, 0xb0, 0x6d, 0x23, 0xf2, 0x41,
	0xe3, 0x2e, 0x20, 0x11, 0x4b, 0x74, 0x89, 0xdd, 0xff, 0xa8, 0x38, 0xa3, 0x95, 0x82, 0x15, 0xf0,
	0xd0, 0xd5, 0xf1, 0x92, 0x8e, 0xee, 0xc0, 0x26, 0x81, 0xe9, 0x47, 0xff, 0xee, 0x0d, 0x20, 0x34,
	0x31, 0x3a, 0xef, 0x40, 0xb2, 0x29, 0x47, 0x19, 0x7f, 0x04, 0x27, 0xf1, 0x90, 0x85, 0x09, 0x86,
	0x7d, 0x42, 0xe2, 0x54, 0x5d, 0x5f, 0xe8, 0x0e, 0xd0, 0x2c, 0xaa, 0x16, 0xbf, 0x04, 0xa7, 0xf8,
	0xa2, 0x46, 0x0b, 0x08, 0x7a, 0x79, 0xe9, 0x28, 0x62, 0x7c, 0x33, 0xf4, 0x0b, 0x14, 0x82, 0xfa,
	0x61, 0xeb, 0xc1, 0xff, 0x4c, 0xa4, 0x11, 0x7f, 0x03, 0x68, 0x44, 0xc1, 0x1f, 0x81, 0x3a, 0x6c,
	0x77, 0x95, 0x02, 0x2b, 0x53, 0x80, 0xe5, 0x10, 0x1e, 0x90, 0xe8, 0xfd, 0x1f, 0xa6, 0x40, 0x0b,
	0x13, 0xff, 0x4e, 0x4d, 0x7f, 0x52, 0xe8, 0xaf, 0x9a, 0xc1, 0x80, 0x0f, 0x0a, 0x14, 0x02, 0x3c,
	0xc0, 0x09, 0x13, 0xe7, 0xdc, 0xc0, 0x1a, 0x28, 0xa0, 0xe4, 0x83, 0x8e, 0x03, 0x88, 0xd5, 0xaf,
	0x1a, 0xbd, 0x91, 0x00, 0xb7, 0x4e, 0xba, 0xdf, 0xf8, 0xdb, 0xcc, 0x02, 0x43, 0xc4, 0x14, 0x2a,
	0x3f, 0xc8, 0x0d, 0x09, 0x1c, 0x44, 0xf4, 0x01, 0x3c, 0xca, 0x28, 0x56, 0x80, 0xa6, 0x85, 0x00,
	0xea, 0x3e, 0x8f, 0xeb, 0x9f, 0xfc, 0x6e, 0x07, 0xc4, 0xe0, 0x30, 0x78, 0xa0, 0x1e, 0x6f, 0x54,
	0x78, 0x51, 0xff, 0x56, 0x4a, 0x01, 0x47, 0x02, 0x4c, 0x21, 0x3b, 0xfb, 0x90, 0x0a, 0xcc, 0x1d,
	0xd2, 0x47, 0xff, 0xfc, 0x70, 0x18, 0x22, 0xc0, 0xb9, 0x2f, 0xe9, 0x7f, 0x91, 0xd3, 0x66, 0x2f,
	0x80, 0x2c, 0x24, 0xa7, 0xfa, 0x84, 0x51, 0xab, 0x6b, 0x72, 0x00, 0xab, 0x33, 0x04, 0xcf, 0x43,
	0xff, 0x17, 0x51, 0x84, 0x0c, 0x01, 0x50, 0x10, 0x8f, 0x90, 0x34, 0x41, 0x44, 0x84, 0x8e, 0x08,
	0x19, 0x04, 0x48, 0x50, 0x84, 0x38, 0x3d, 0x02, 0x52, 0xf9, 0x7c, 0xd2, 0xd0, 0x1f, 0x13, 0x42,
	0xa0, 0x21, 0x41, 0xc4, 0x02, 0x02, 0x3d, 0x09, 0xc8, 0xfd, 0x60, 0x7d, 0x35, 0x4f, 0x7f, 0xff,
	0xf9, 0x97, 0x6a, 0xd8, 0x00, 0xc3, 0x83, 0x00, 0x09, 0x50, 0x4b, 0x90, 0x8a, 0xc7, 0x94, 0x4d,
	0x47, 0xc1, 0x62, 0x32, 0x28, 0x24, 0x09, 0x52, 0x2e, 0x2e, 0x1c, 0x96, 0x44, 0xa0, 0x09, 0xc8,
	0xce, 0x64, 0xa9, 0x1c, 0x19, 0x0e, 0x52, 0x3e, 0x3e, 0x19, 0x93, 0xa0, 0x36, 0x26, 0x22, 0x08,
	0x9a, 0x00, 0xdd, 0x66, 0x3a, 0x93, 0xd5, 0x89, 0xd1, 0x40, 0x06, 0xd4, 0xa8, 0x22, 0x73, 0x7b,
	0x3d, 0x3f, 0xe3, 0x04, 0x94, 0xff, 0xff, 0xff, 0xff, 0x0c, 0x56, 0x77, 0xac, 0xe0, 0xc4, 0x06,
	0x1f, 0xb8, 0xa5, 0x80, 0xfd, 0x68, 0x1c, 0x32, 0x16, 0x03, 0xde, 0x71, 0x2a, 0x3d, 0x14, 0x19,
	0xbe, 0xc2, 0x88, 0xd9, 0x24, 0x92, 0x5f, 0xc5, 0x90, 0x0a, 0x85, 0xc2, 0x3f, 0x87, 0x03, 0xa8,
	0x26, 0x17, 0xc4, 0x06, 0x86, 0x12, 0x87, 0x76, 0x0a, 0x48, 0x16, 0xed, 0x96, 0x93, 0xec, 0x1b,
	0x30, 0x73, 0xe8, 0x1a, 0x3f, 0xff, 0x4d, 0xce, 0x40, 0xf3, 0x0c, 0x51, 0x4b, 0x84, 0x9e, 0x67,
	0x2b, 0x15, 0x40, 0x1a, 0xa0, 0xfc, 0x10, 0x0f, 0xd8, 0x81, 0x35, 0x87, 0xff, 0x98, 0x0f, 0x40,
	0x00, 0xba, 0xc0, 0x71, 0xe2, 0x00, 0x18, 0x28, 0xb3, 0x82, 0xcc, 0x80, 0x6a, 0xa0, 0x43, 0xff,
	0x2d, 0xd6, 0x04, 0x8a, 0x68, 0xff, 0xff, 0xff, 0xfc, 0x1a, 0xf3, 0x1a, 0x2a, 0x06, 0xc0, 0x01,
	0x40, 0x0c, 0x30, 0xc1, 0xd0, 0xd7, 0x4f, 0xcb, 0x74, 0x1f, 0x07, 0xd3, 0xb4, 0x0d, 0x88, 0x98,
	0xea, 0xda, 0x9f, 0xce, 0x2b, 0x3c, 0x55, 0xb3, 0x40, 0x14, 0xff, 0xff, 0xff, 0xea, 0xdb, 0x9b,
	0x92, 0xd8, 0x68, 0x08, 0x0b, 0x41, 0x09, 0x26, 0x40, 0x8c, 0xf1, 0xb0, 0x9a, 0x98, 0xc0, 0x80,
	0x8b, 0xf0, 0x3d, 0xe7, 0xec, 0x19, 0x68, 0x21, 0x03, 0x29, 0x7f, 0xe1, 0x6d, 0x4c, 0x0f, 0x01,
	0xd1, 0x51, 0x01, 0x1a, 0x50, 0x2a, 0x59, 0x27, 0x80, 0xc1, 0x6e, 0x33, 0xf1, 0x80, 0xe1, 0x49,
	0x08, 0xe9, 0x17, 0xff, 0xff, 0xff, 0x80, 0x5a, 0x10, 0x10, 0x36, 0x5e, 0xca, 0xf8, 0x3a, 0x00,
	0x1e, 0xb0, 0x06, 0x84, 0x01, 0xf3, 0x07, 0x1b, 0x4a, 0xc0, 0x1e, 0x21, 0x43, 0x8e, 0xa5, 0x55,
	0x77, 0xc7, 0x65, 0x7c, 0xc2, 0xdf, 0x5e, 0x0c, 0x42, 0x20, 0xd2, 0x48, 0x61, 0xc8, 0x1c, 0x65,
	0xf8, 0xfe, 0x4c, 0x88, 0x71, 0x1f, 0x82, 0x50, 0x81, 0xa3, 0x54, 0x09, 0x13, 0x28, 0x52, 0xf5,
	0xe0, 0x82, 0xc3, 0x06, 0x7f, 0xfa, 0x2c, 0xcf, 0xf8, 0xf4, 0x7f, 0xff, 0xfd, 0x01, 0x49, 0xa4,
	0xb8, 0xde, 0x62, 0x84, 0xfe, 0xed, 0x65, 0x1f, 0x3c, 0x3c, 0xb2, 0x50, 0x76, 0x30, 0x5b, 0x03,
	0xc0, 0x08, 0xa6, 0x64, 0x90, 0xc8, 0xcd, 0x14, 0x6e, 0x69, 0x46, 0x7a, 0xc6, 0x1c, 0x87, 0xd7,
	0x48, 0x7b, 0x49, 0x05, 0x2d, 0x5e, 0x7f, 0xcb, 0x67, 0xf0, 0xd9, 0x0d, 0x1e, 0x9e, 0x53, 0xb7,
	0x64, 0xa5, 0xa5, 0x10, 0x39, 0x06, 0x11, 0x3f, 0xb1, 0xa9, 0xa6, 0xe8, 0x4d, 0x47, 0x77, 0xda,
	0x43, 0x76, 0x89, 0x45, 0x09, 0x70, 0xc2, 0x38, 0x0f, 0x09, 0x6f, 0xe7, 0x2d, 0x82, 0x35, 0x07,
	0xfe, 0x64, 0x18, 0x2e, 0xb8, 0x04, 0x42, 0x54, 0x80, 0x43, 0x12, 0x6c, 0x9a, 0x55, 0xc9, 0x0a,
	0xa0, 0x79, 0x47, 0x52, 0x65, 0x2a, 0xff, 0x50, 0x11, 0xc9, 0x4e, 0xfe, 0x5b, 0x30, 0xa4, 0xe8,
	0x30, 0x63, 0xff, 0x21, 0x12, 0x1b, 0xdc, 0x1c, 0x01, 0x41, 0x51, 0x1f, 0xff, 0xfa, 0xc3, 0xe3,
	0x55, 0xf1, 0x66, 0xe2, 0xd5, 0x78, 0x5e, 0xfa, 0x4d, 0xf2, 0x61, 0x01, 0x26, 0x15, 0xa9, 0xf9,
	0xd9, 0x32, 0x41, 0x90, 0x36, 0x4e, 0xae, 0xe3, 0x0b, 0x16, 0x56, 0x8c, 0x6e, 0x42, 0x5d, 0xd8,
	0x1e, 0xfe, 0x1d, 0x40, 0x3a, 0x50, 0x9f, 0x09, 0x14, 0xeb, 0x6e, 0x48, 0x7a, 0x91, 0x88, 0x7b,
	0x7d, 0x8f, 0x72, 0x42, 0x39, 0xb0, 0x1c, 0x65, 0x18, 0x23, 0x8b, 0x60, 0x30, 0x00,

	/* FRAME_END as in 4.2.3 */
	0xc5, 0xcc,	0x08, 0x00, 0x00, 0x00, 0x01, 0x00
};

static UINT32 refImage[] = { /* 4.2.4.4 Inverse Color Conversion */
	0x00229cdf, 0x00249de0, 0x00259fe2, 0x002ca5e8, 0x00229cdf, 0x00229ce0, 0x00239de0, 0x00229ce0,
	0x00229cdf, 0x00229cdf, 0x00239ce0, 0x00249ce0, 0x00249ce0, 0x00219ce3, 0x001e9ce6, 0x00209ae2,
	0x002299dd, 0x002199de, 0x00209adf, 0x00209ae0, 0x001f9be0, 0x001e9ae0, 0x001d99e0, 0x001c98e0,
	0x001b97df, 0x001e96dc, 0x002194d9, 0x001f93dd, 0x001d93e0, 0x001b94dc, 0x001895d8, 0x001c92db,
	0x00208fde, 0x001b91de, 0x001693df, 0x001793df, 0x001992df, 0x001891df, 0x00178fdf, 0x00178edf,
	0x00168dde, 0x00158cdd, 0x00148cdc, 0x00128cda, 0x00118cd9, 0x00118bd9, 0x00128ada, 0x001289da,
	0x001288db, 0x001187da, 0x001186da, 0x001085da, 0x000f85d9, 0x000f84d9, 0x000e83d9, 0x000d82d8,
	0x000d82d8, 0x000d81d8, 0x000d80d7, 0x000d7fd7, 0x000d7ed6, 0x000d7ed6, 0x000d7ed6, 0x000d7ed6,
	0x00259fe1, 0x0027a1e2, 0x0029a2e3, 0x002ba4e6, 0x00249fe1, 0x00249fe1, 0x00249fe1, 0x00249ee1,
	0x00239ee1, 0x00249ee1, 0x00249ee1, 0x00259de1, 0x00259de2, 0x00249de2, 0x00229de2, 0x00229ce1,
	0x00229bdf, 0x00219ce0, 0x00209ce1, 0x00209ce2, 0x00209ce2, 0x00209ae0, 0x002199de, 0x001f99df,
	0x001d98e0, 0x001e97e0, 0x001f97e0, 0x001d96df, 0x001c95de, 0x001c94e0, 0x001c94e1, 0x001d93e1,
	0x001d92e0, 0x001b93de, 0x001a94dc, 0x001a93de, 0x001a93e0, 0x001992e0, 0x001891df, 0x00188fdf,
	0x00178edf, 0x00168ede, 0x00158edd, 0x00148ddc, 0x00138ddb, 0x00138cdb, 0x00138bdb, 0x00128adb,
	0x001289db, 0x001288db, 0x001187db, 0x001186db, 0x001085db, 0x000f84da, 0x000e83d9, 0x000e83d9,
	0x000e83d9, 0x000e82d9, 0x000e81d8, 0x000e80d8, 0x000d7fd7, 0x000d7fd7, 0x000d7fd7, 0x000d7fd7,
	0x0027a3e3, 0x002aa4e3, 0x002ea6e3, 0x002aa4e3, 0x0026a2e3, 0x0026a1e3, 0x0025a1e3, 0x0025a0e3,
	0x0025a0e3, 0x0025a0e3, 0x00259fe3, 0x00269fe3, 0x00269ee4, 0x00279ee1, 0x00279edf, 0x00259ee0,
	0x00239ee1, 0x00219ee2, 0x00209ee4, 0x00209de4, 0x00219de3, 0x00229be0, 0x002499dc, 0x002299de,
	0x001f98e0, 0x001d99e4, 0x001b9ae7, 0x001c98e2, 0x001c96dc, 0x001e94e3, 0x002092ea, 0x001d94e6,
	0x001a96e2, 0x001c96de, 0x001d95da, 0x001c94de, 0x001b94e1, 0x001a93e0, 0x001a92e0, 0x001991e0,
	0x001890e0, 0x001790df, 0x00178fde, 0x00168fde, 0x00158edd, 0x00148ddd, 0x00138cdc, 0x00138bdc,
	0x00128adc, 0x001289dc, 0x001188dc, 0x001187dd, 0x001086dd, 0x000f85db, 0x000e83d9, 0x000e84da,
	0x000f84da, 0x000e83da, 0x000e82d9, 0x000e81d9, 0x000e80d8, 0x000e80d8, 0x000e80d8, 0x000e80d8,
	0x002aa7e5, 0x002da7e4, 0x0031a8e3, 0x002ca6e3, 0x0027a4e4, 0x0027a3e4, 0x0027a3e4, 0x0027a3e4,
	0x0026a2e4, 0x0026a2e4, 0x0027a1e5, 0x0027a0e5, 0x0027a0e6, 0x0026a0e5, 0x0025a0e4, 0x00259fe4,
	0x00259ee3, 0x00239ee5, 0x00229fe6, 0x00229fe5, 0x00229fe4, 0x0013a5e6, 0x001b9fe8, 0x0016a0e8,
	0x0011a0e7, 0x00129fef, 0x00139ef7, 0x001b99ec, 0x00179ae2, 0x00149ce4, 0x001d98e5, 0x001c97e6,
	0x001b96e7, 0x001c98dc, 0x001d97df, 0x001c96e1, 0x001c94e2, 0x001b94e1, 0x001b93e1, 0x001a93e0,
	0x001a92e0, 0x001991e0, 0x001890e0, 0x001790df, 0x00168fdf, 0x00158ede, 0x00158dde, 0x00148cdd,
	0x00138bdc, 0x00128add, 0x001289dd, 0x001188de, 0x001187de, 0x000f85dc, 0x000d83da, 0x000f85db,
	0x001086db, 0x000f84db, 0x000f83da, 0x000e82da, 0x000e81da, 0x000e81da, 0x000e81da, 0x000e81da,
	0x002caae7, 0x0030aae5, 0x0034abe3, 0x002ea8e4, 0x0029a6e5, 0x0028a6e5, 0x0028a5e5, 0x0028a5e5,
	0x0028a5e6, 0x0028a4e6, 0x0028a3e7, 0x0028a2e7, 0x0028a1e8, 0x0025a2e9, 0x0023a3ea, 0x0025a0e8,
	0x00279ee6, 0x00259fe7, 0x0023a0e9, 0x0018a4f5, 0x000ea7ff, 0x001ba6de, 0x00558ebb, 0x006f839c,
	0x0089797e, 0x008d797c, 0x00917979, 0x007f7b94, 0x005687af, 0x00229bd6, 0x0004a4fd, 0x00109df4,
	0x001c97eb, 0x001c9ada, 0x001c98e4, 0x001c97e3, 0x001d95e2, 0x001c95e2, 0x001c94e2, 0x001c94e1,
	0x001b94e1, 0x001a93e1, 0x001a92e1, 0x001991e1, 0x001890e1, 0x00178fe0, 0x00158edf, 0x00148dde,
	0x00138cdd, 0x00128bde, 0x00128adf, 0x001289df, 0x001188e0, 0x000f85dd, 0x000d83da, 0x000f85db,
	0x001187dd, 0x001086dc, 0x000f84dc, 0x000e83db, 0x000e81db, 0x000e81db, 0x000e81db, 0x000e81db,
	0x0030abe5, 0x0036afe8, 0x0034abe4, 0x002faae5, 0x002ba8e6, 0x0036aee8, 0x0026a6e8, 0x0029a7e7,
	0x002ca8e7, 0x002da7e6, 0x002fa5e5, 0x002ca5e7, 0x0029a4e9, 0x002ba5e5, 0x002ca5e2, 0x0010aaef,
	0x0013adf6, 0x0023a3f8, 0x006091a5, 0x00a6755d, 0x00ec5915, 0x00ff490c, 0x00fa5504, 0x00ff590f,
	0x00ff5d1b, 0x00ff6116, 0x00fa6412, 0x00ff550f, 0x00ff4b0d, 0x00fb4918, 0x00f54823, 0x008e737e,
	0x00269eda, 0x0006a2ff, 0x001d97e2, 0x001799ea, 0x001c97e4, 0x001a98e4, 0x001898e4, 0x001a96e3,
	0x001b95e3, 0x001a94e2, 0x001a93e0, 0x001992e1, 0x001891e2, 0x001790e1, 0x00168fe0, 0x00158fdf,
	0x00138ede, 0x00138ddf, 0x00138ce0, 0x00128be0, 0x001189e0, 0x001087de, 0x000f85db, 0x00138ae0,
	0x000f87dc, 0x000f86dc, 0x000f85dc, 0x000f84dc, 0x000e83db, 0x000e83db, 0x000e83db, 0x000e83db,
	0x0034abe2, 0x003cb4ec, 0x0034ace5, 0x0031abe6, 0x002daae8, 0x0044b6eb, 0x0024a7ea, 0x0029aaea,
	0x002face9, 0x0032a9e6, 0x0035a7e3, 0x0030a7e6, 0x002ba8ea, 0x0025aaf0, 0x0020adf6, 0x004d8ba7,
	0x00b8674c, 0x00ff5510, 0x00f7650c, 0x00f86313, 0x00fa611b, 0x00f0671f, 0x00fc6222, 0x00fb6926,
	0x00f96f29, 0x00f67122, 0x00f3721b, 0x00f26b20, 0x00f16424, 0x00ff5622, 0x00ff531f, 0x00ff4b17,
	0x00ff440e, 0x00b1615b, 0x001f95e0, 0x00129bf0, 0x001c9ae5, 0x00189ae6, 0x00159be7, 0x001898e6,
	0x001b95e5, 0x001b95e2, 0x001995e0, 0x001994e1, 0x001892e2, 0x001792e1, 0x001691e0, 0x001590df,
	0x00148fdf, 0x00148fe0, 0x00148fe1, 0x00128de1, 0x00108be0, 0x001189de, 0x001186dd, 0x00178fe4,
	0x000e87db, 0x000e87dc, 0x000f87dd, 0x000f85dc, 0x000e84dc, 0x000e84dc, 0x000e84dc, 0x000e84dc,
	0x0036b1eb, 0x0036b4f0, 0x002eafed, 0x002caeec, 0x002aadec, 0x0041b4ef, 0x0029abe9, 0x002cabe8,
	0x002fabe7, 0x0031abe6, 0x0032aae6, 0x002faae7, 0x002ca9e8, 0x0025a7eb, 0x00946a5f, 0x00ff3e06,
	0x00f95618, 0x00e27312, 0x00f87329, 0x00f77427, 0x00f77626, 0x00f27628, 0x00f8712b, 0x00f9772e,
	0x00f97e30, 0x00f77f2e, 0x00f5812b, 0x00f57b2c, 0x00f5752d, 0x00fd6a2b, 0x00fb652a, 0x00f65e2c,
	0x00f1572e, 0x00ff4810, 0x00ff460f, 0x00817680, 0x0002a7f1, 0x002496ea, 0x00199be4, 0x001b98e4,
	0x001d96e5, 0x001b96e2, 0x001a96e0, 0x001995e1, 0x001794e3, 0x001793e2, 0x001692e1, 0x001691e0,
	0x001590df, 0x001591e1, 0x001591e3, 0x00138fe1, 0x00108ce0, 0x00128be0, 0x00158ae0, 0x00168de2,
	0x000f89dd, 0x000f88dd, 0x000f88dd, 0x000f86dd, 0x000f85dc, 0x000f85dc, 0x000f85dc, 0x000f85dc,
	0x005fc1e7, 0x0057bee8, 0x004fbbe9, 0x004ebae6, 0x004ebae3, 0x0051b6ee, 0x002eaee8, 0x002eade6,
	0x002fabe5, 0x002face7, 0x002eade9, 0x002eace7, 0x002daae5, 0x0015b2ff, 0x00ec4310, 0x00f15016,
	0x00f75d1c, 0x00f87123, 0x00f9862a, 0x00f6882d, 0x00f48b31, 0x00f48532, 0x00f47f33, 0x00f78535,
	0x00fa8c37, 0x00f88e39, 0x00f7903a, 0x00f88b38, 0x00f98635, 0x00f87e35, 0x00f77635, 0x00f76d34,
	0x00f76532, 0x00f85e31, 0x00f95730, 0x00ff5125, 0x00f65237, 0x0003a5fd, 0x001e9be1, 0x001e98e3,
	0x001f96e5, 0x001c97e2, 0x001a97df, 0x001896e1, 0x001795e4, 0x001794e3, 0x001793e2, 0x001692e1,
	0x001692e0, 0x001693e2, 0x001794e4, 0x001391e2, 0x000f8ee0, 0x00148ee1, 0x00198ee3, 0x00148ce1,
	0x000f8bde, 0x000f8ade, 0x000f89de, 0x000f88dd, 0x000f86dd, 0x000f86dd, 0x000f86dd, 0x000f86dd,
	0x003cb6ee, 0x0036b4ef, 0x0030b2f0, 0x0030b1ee, 0x002fb1ec, 0x0038b0ef, 0x002eaee9, 0x002faee8,
	0x0031ade6, 0x002fafe8, 0x002eb1ea, 0x0031adec, 0x0029afee, 0x0030aac8, 0x00ff3d05, 0x00fa501a,
	0x00f96021, 0x00f87428, 0x00f7882f, 0x00fa9638, 0x00f59b38, 0x00f5973b, 0x00f6923e, 0x00f89440,
	0x00fa9742, 0x00fa9a44, 0x00fa9d46, 0x00f99845, 0x00f89444, 0x00f98d43, 0x00fa8641, 0x00f97d3f,
	0x00f9743d, 0x00f77039, 0x00f56d35, 0x00ff6122, 0x00bf6c63, 0x00129eef, 0x00229ae8, 0x001c99ed,
	0x00179ce4, 0x001498f0, 0x001b94e1, 0x001a96e2, 0x001998e3, 0x001897e4, 0x001896e5, 0x001895e4,
	0x001993e2, 0x001792e1, 0x001590df, 0x001692e2, 0x001793e5, 0x001490e4, 0x00128ee2, 0x00118de3,
	0x00108de3, 0x00118bde, 0x001289d9, 0x000f88e2, 0x000c89dd, 0x001085e0, 0x000987e4, 0x000987e4,
	0x0040b5e9, 0x003bb4e9, 0x0037b2ea, 0x0037b2e9, 0x0038b1e8, 0x0033b0ea, 0x002eaeeb, 0x0030afe9,
	0x0033afe8, 0x0030b2ea, 0x002eb5ec, 0x0034aff2, 0x0025b4f7, 0x008d7f86, 0x00f64f00, 0x00ed5c1e,
	0x00fa6326, 0x00f7762d, 0x00f58a35, 0x00fea242, 0x00f7ab3f, 0x00f7a843, 0x00f7a548, 0x00f9a34a,
	0x00faa24c, 0x00fba64f, 0x00fcaa52, 0x00f9a652, 0x00f7a252, 0x00fa9c50, 0x00fd974e, 0x00fc8d4b,
	0x00fb8348, 0x00f68341, 0x00f1823a, 0x00f5732c, 0x00718cac, 0x00179af0, 0x002599ef, 0x002697e9,
	0x00269bc6, 0x001696f1, 0x001d91e3, 0x001c96e3, 0x001b9be3, 0x001a99e6, 0x001998e9, 0x001b97e7,
	0x001c95e5, 0x001891df, 0x00138dda, 0x001992e2, 0x001e98ea, 0x001592e6, 0x000b8de2, 0x000e8ee5,
	0x00108fe9, 0x00128cdf, 0x001489d4, 0x000e88e6, 0x00088cdc, 0x001184e4, 0x000488ec, 0x000488ec,
	0x003eb6ea, 0x003bb5eb, 0x0038b4eb, 0x0038b4eb, 0x0038b3eb, 0x0035b2eb, 0x0033b1ec, 0x0034b1eb,
	0x0035b1ea, 0x0032b3e9, 0x0030b5e9, 0x0034b0f0, 0x0023b6f8, 0x00c56044, 0x00f9540c, 0x00f26322,
	0x00f77029, 0x00f77d2f, 0x00f78b35, 0x00fba142, 0x00f6b046, 0x00fbb44f, 0x00f7b051, 0x00f9af54,
	0x00fbad56, 0x00fcb25a, 0x00feb75d, 0x00fab35f, 0x00f6b061, 0x00faac5d, 0x00fda95a, 0x00fb9f55,
	0x00f99551, 0x00f7914b, 0x00f68d45, 0x00ff7e23, 0x001ba5f0, 0x00129ef4, 0x002896f1, 0x00239fb1,
	0x006c9600, 0x003c9c82, 0x00179ef8, 0x00169cf4, 0x00149de3, 0x00169ae5, 0x001897e7, 0x001995e6,
	0x001a93e5, 0x001993e3, 0x001793e0, 0x001c98e6, 0x001a95e5, 0x001692e5, 0x00138fe5, 0x00138ceb,
	0x00138be3, 0x000087e4, 0x00007cf5, 0x001a86d3, 0x000d8cf1, 0x00008fe2, 0x000d85ea, 0x000886f1,
	0x003cb7ec, 0x003bb7ed, 0x003ab6ed, 0x0039b6ed, 0x0038b5ed, 0x0037b5ed, 0x0037b4ed, 0x0037b3ed,
	0x0036b3ec, 0x0034b4e9, 0x0031b5e5, 0x0035b1ef, 0x0021b8fa, 0x00fd4203, 0x00fc581e, 0x00f86a26,
	0x00f47c2d, 0x00f78431, 0x00f98c36, 0x00f8a041, 0x00f6b54d, 0x00fec05b, 0x00f6bc5a, 0x00f8ba5d,
	0x00fbb861, 0x00fdbe65, 0x00ffc469, 0x00fbc16c, 0x00f5bd70, 0x00fabc6b, 0x00febb66, 0x00fab160,
	0x00f6a75a, 0x00f89f55, 0x00fa984f, 0x00df956f, 0x0008a6fc, 0x00259ddb, 0x00159ff3, 0x004aa172,
	0x0069a90d, 0x0062a406, 0x005a981b, 0x0034969b, 0x000e99ff, 0x001297f2, 0x001695e4, 0x001793e5,
	0x001892e5, 0x001995e6, 0x001a98e7, 0x00209deb, 0x001593df, 0x001892e4, 0x001a91e9, 0x002095eb,
	0x00259dd1, 0x00d0f772, 0x00c1f396, 0x000083f1, 0x001782a0, 0x003c7e2f, 0x001787cc, 0x000b8ada,
	0x003db9ed, 0x003cb8ed, 0x003bb8ed, 0x003ab7ed, 0x0039b7ed, 0x0039b7ed, 0x0039b6ed, 0x003ab6ed,
	0x003ab6ed, 0x0037b4ed, 0x0034b2ec, 0x0035abf3, 0x006e96b3, 0x00ff4601, 0x00f86520, 0x00f67329,
	0x00f58131, 0x00f78b37, 0x00f9953e, 0x00f8a649, 0x00f8b854, 0x00fcc260, 0x00f8c465, 0x00f9c36a,
	0x00fac26e, 0x00fac773, 0x00facb77, 0x00fbcb7b, 0x00fccb7e, 0x00fac87b, 0x00f8c578, 0x00f9bc72,
	0x00fbb46d, 0x00f6b069, 0x00feaa57, 0x0094a0a5, 0x0013a1f3, 0x00219df0, 0x00199eff, 0x0071c124,
	0x0079b826, 0x0072b21e, 0x006aaa24, 0x0067a125, 0x00649a19, 0x00419d72, 0x001f9fcb, 0x001994ff,
	0x001399f1, 0x00199cf4, 0x001ea0f8, 0x001b9cff, 0x001193f6, 0x001293f1, 0x001393ec, 0x000083ff,
	0x0072cca0, 0x00cbf982, 0x00d0ffac, 0x0079a046, 0x00337700, 0x003a7c03, 0x000d8de2, 0x000d8edb,
	0x003fbbee, 0x003ebaed, 0x003db9ed, 0x003cb9ed, 0x003bb8ed, 0x003bb8ed, 0x003cb9ee, 0x003cb9ee,
	0x003db9ef, 0x003ab4f1, 0x0037aff3, 0x0032b3fe, 0x00b48f7d, 0x00ff5907, 0x00f37122, 0x00f57c2b,
	0x00f68735, 0x00f7923d, 0x00f89d45, 0x00f9ac50, 0x00f9bb5a, 0x00f9c465, 0x00facd71, 0x00facd76,
	0x00facd7b, 0x00f7cf80, 0x00f4d286, 0x00fcd689, 0x00ffd98c, 0x00fbd48b, 0x00f3cf8a, 0x00f9c885,
	0x00ffc17f, 0x00f5c27d, 0x00ffbc5e, 0x0048abdc, 0x001e9deb, 0x001ea2e8, 0x001da8e5, 0x0099d31c,
	0x008acb22, 0x0082c427, 0x007abc2c, 0x0075b429, 0x0070ad25, 0x006dab17, 0x006ba908, 0x005ea912,
	0x00519f54, 0x00489b6d, 0x003e9887, 0x003b9592, 0x00389880, 0x00449663, 0x00509446, 0x0083b43c,
	0x004f851b, 0x00afe187, 0x009fcc83, 0x00368011, 0x0043821c, 0x0032853c, 0x000492f9, 0x001092dd,
	0x0040bcee, 0x003fbcee, 0x003ebbee, 0x003dbaed, 0x003cbaed, 0x003cb9ed, 0x003cb9ec, 0x003cb9ec,
	0x003cb8ec, 0x003fb4f0, 0x0043aff5, 0x000ebbe9, 0x00ffb897, 0x00f7814d, 0x00f57623, 0x00f6812e,
	0x00f88c39, 0x00f89943, 0x00f8a64d, 0x00f8b257, 0x00f9bd60, 0x00fac96d, 0x00fbd47b, 0x00fad681,
	0x00fad788, 0x00fbd98e, 0x00fbda93, 0x00fae5a1, 0x00fed692, 0x00fadea0, 0x00f9db98, 0x00fad694,
	0x00fbd090, 0x00ffd285, 0x00ffc778, 0x00009afd, 0x0026a8f2, 0x0020a4f8, 0x0053bea5, 0x00a4da31,
	0x009dd638, 0x0097d03a, 0x0091ca3d, 0x008bc539, 0x0085c035, 0x007dbe31, 0x0074bc2d, 0x0076b81c,
	0x0077b027, 0x0072ab25, 0x006da724, 0x006ba328, 0x0068a31f, 0x0058951a, 0x0078b745, 0x00bbf181,
	0x0073ad4c, 0x00417c15, 0x00508b1e, 0x0043861c, 0x00498614, 0x0017868b, 0x000b90f6, 0x00168ee8,
	0x0042beef, 0x0041bdee, 0x0040bcee, 0x003fbced, 0x003ebbed, 0x003dbaec, 0x003db9eb, 0x003cb8ea,
	0x003bb7e9, 0x0039b9f0, 0x0037bbf7, 0x0050b5dc, 0x00ff9744, 0x00fec49d, 0x00f87a24, 0x00f88530,
	0x00f9913d, 0x00f8a049, 0x00f7af55, 0x00f8b85d, 0x00f9c065, 0x00face75, 0x00fcdb85, 0x00fbde8d,
	0x00fae195, 0x00fee29b, 0x00ffe2a0, 0x00fbe9a4, 0x00ffbe6b, 0x00fdde9f, 0x00ffe8a6, 0x00fbe3a3,
	0x00f8dea0, 0x00fdd899, 0x00b6bdab, 0x00119ff1, 0x001ea4e9, 0x001a9fff, 0x0089d465, 0x00b0e245,
	0x00b0e04e, 0x00acdc4e, 0x00a7d94e, 0x00a1d649, 0x009ad345, 0x0097ce3d, 0x0094c935, 0x008dc534,
	0x0086c133, 0x007bbc32, 0x006fb731, 0x006db330, 0x006cae2e, 0x007eba3f, 0x0070a531, 0x007bb54f,
	0x00579a20, 0x005c9f2b, 0x00519425, 0x0080b965, 0x00609a1d, 0x000390e3, 0x00118ef2, 0x001c89f2,
	0x0044c0ef, 0x0043bfef, 0x0042beee, 0x0040bdee, 0x003fbcee, 0x003fbbed, 0x0040baeb, 0x003eb9ed,
	0x003cb9ee, 0x0037b9eb, 0x0027bcf7, 0x00949c8f, 0x00fb9637, 0x00f9bc7c, 0x00f9b585, 0x00f7994a,
	0x00f69b43, 0x00f6a64e, 0x00f7b259, 0x00f8bc66, 0x00fac672, 0x00fad380, 0x00fae08d, 0x00f9e698,
	0x00f9eba2, 0x00feeaa6, 0x00ffeaab, 0x00fcefa9, 0x00faba62, 0x00fbdc99, 0x00fff4b9, 0x00fbecb2,
	0x00f7e6ab, 0x00ffe5a3, 0x0064b1d1, 0x00199ff0, 0x00269fe9, 0x000499f2, 0x00e3f051, 0x00d5ef58,
	0x00c0e364, 0x00bde165, 0x00bae065, 0x00b5de5d, 0x00b0dc56, 0x00aad74e, 0x00a3d346, 0x009bd043,
	0x0093cd3f, 0x008cc93e, 0x0084c63c, 0x0081c139, 0x007dbc36, 0x008bc746, 0x0089c245, 0x0063a02c,
	0x0065aa2c, 0x005ea42d, 0x00509626, 0x00a4cf98, 0x00d9eadd, 0x00b9ddff, 0x00389ef4, 0x00008fd4,
	0x0046c1ef, 0x0044c0ef, 0x0043bfef, 0x0042beef, 0x0040bdef, 0x0042bced, 0x0043baec, 0x0040baf0,
	0x003dbaf4, 0x0035b8e7, 0x0017bdf7, 0x00d97f50, 0x00f79147, 0x00f7a554, 0x00ffdbba, 0x00f8a24d,
	0x00f3a549, 0x00f5ad53, 0x00f7b55e, 0x00f9c16f, 0x00fbcc7f, 0x00f9d88a, 0x00f8e595, 0x00f8eda2,
	0x00f8f5ae, 0x00fff3b2, 0x00fff2b6, 0x00fef5ae, 0x00f4b659, 0x00f9db93, 0x00feffcd, 0x00fbf6c1,
	0x00f7edb6, 0x00fff2ac, 0x0013a4f7, 0x0016a5f0, 0x0018a5e8, 0x0056b4cd, 0x00f1f271, 0x00d5ef84,
	0x00cfe67b, 0x00cde77c, 0x00cbe77c, 0x00c9e672, 0x00c7e567, 0x00bce15f, 0x00b1dd57, 0x00a9dc51,
	0x00a0da4b, 0x009dd749, 0x009ad447, 0x0094cf43, 0x008fcb3f, 0x0088c43c, 0x0082be39, 0x0072b430,
	0x0063a928, 0x0059a028, 0x004e9827, 0x00a0c479, 0x00fffbf7, 0x007fd3f5, 0x00038fe2, 0x000e89e2,
	0x0048c3ef, 0x0046c2ef, 0x0045c1f0, 0x0043c0f0, 0x0042bff0, 0x0042beee, 0x0043bdec, 0x0041bcef,
	0x003fbcf2, 0x002fc0fe, 0x0036bdfc, 0x00f54c00, 0x00ff8a52, 0x00faa65e, 0x00fdc48e, 0x00fbc185,
	0x00f5ae50, 0x00f7b65e, 0x00f9be6c, 0x00fac978, 0x00fbd485, 0x00fede98, 0x00ffe8aa, 0x00fdeeae,
	0x00f9f5b2, 0x00fcf6ba, 0x00fff7c2, 0x00fcf0b2, 0x00f7cc6e, 0x00fbde91, 0x00fdfcca, 0x00fffbd1,
	0x00fffdc8, 0x00cae4c8, 0x0016a1f2, 0x001da4ef, 0x0012a1f1, 0x009fd5b9, 0x00eaf28c, 0x00dcf095,
	0x00d9eb90, 0x00d9ec93, 0x00d9ec95, 0x00d6eb8c, 0x00d4ea83, 0x00c9e779, 0x00bfe36f, 0x00b8e368,
	0x00b1e262, 0x00afe05e, 0x00addf5a, 0x00a3d952, 0x0099d449, 0x008ecb41, 0x0084c33a, 0x0075b833,
	0x0066ac2c, 0x005da329, 0x00559927, 0x004b9421, 0x002499b9, 0x001593fe, 0x000993d8, 0x000f90d8,
	0x004ac5ef, 0x0048c4f0, 0x0046c2f0, 0x0045c1f1, 0x0043c0f1, 0x0043bfef, 0x0043bfed, 0x0042beee,
	0x0041bdf0, 0x0038bbf0, 0x0072a1b8, 0x00ff5d1e, 0x00f97931, 0x00f5a151, 0x00f9ad61, 0x00fee0bd,
	0x00f8b758, 0x00fabf69, 0x00fcc87a, 0x00fcd282, 0x00fcdc8b, 0x00fbde8f, 0x00fbe193, 0x00fbeba4,
	0x00fbf5b5, 0x00faf8c2, 0x00f9fcce, 0x00f9ecb7, 0x00fae183, 0x00fee290, 0x00fbfac8, 0x00fdf8d8,
	0x00fffccb, 0x008bcedc, 0x00189fee, 0x0025a3ee, 0x000b9dfb, 0x00e8f6a5, 0x00e4f1a6, 0x00e4f0a6,
	0x00e4efa6, 0x00e5f1aa, 0x00e6f2ad, 0x00e3f1a6, 0x00e0ef9e, 0x00d7ec93, 0x00cde987, 0x00c8ea80,
	0x00c2eb78, 0x00c1ea73, 0x00c0e96e, 0x00b1e360, 0x00a3dd53, 0x0094d247, 0x0086c83b, 0x0078bc35,
	0x0069b030, 0x0062a52b, 0x005b9b27, 0x0057920a, 0x000995fc, 0x000d96e5, 0x001091eb, 0x001091eb,
	0x004ac5f0, 0x0049c4f0, 0x0047c3f1, 0x0045c2f1, 0x0044c1f2, 0x0041c1f2, 0x003fc1f2, 0x003fbff1,
	0x003fbcf0, 0x0032c3fe, 0x00be7f6e, 0x00fe6526, 0x00f67b35, 0x00f59a4d, 0x00f8ab5c, 0x00fbd0a0,
	0x00f7c783, 0x00fec16b, 0x00fdd17f, 0x00fbdb87, 0x00f9e590, 0x00f8ed9a, 0x00f7f4a5, 0x00fbea9a,
	0x00ffdf8e, 0x00fce3a0, 0x00f7e6b1, 0x00fceecc, 0x00fffbcb, 0x00fff3c7, 0x00fcf1c3, 0x00fef5d2,
	0x00fffcd3, 0x004bb5e7, 0x0021a5ed, 0x001ca2ee, 0x003daae2, 0x00eef6ac, 0x00e6f2b1, 0x00e8f2b5,
	0x00e9f3b8, 0x00eaf4ba, 0x00ebf5bc, 0x00e8f3b6, 0x00e6f2af, 0x00e0f0a8, 0x00dbeea2, 0x00d6ef9a,
	0x00d1f092, 0x00c9ed82, 0x00c1eb73, 0x00b0e362, 0x00a1dc51, 0x0094d347, 0x0088ca3e, 0x007bbf38,
	0x006eb433, 0x0066a92e, 0x005da01b, 0x003d9448, 0x000a93f6, 0x000e94ec, 0x001193f0, 0x001193f0,
	0x004bc5f1, 0x004ac5f1, 0x0048c4f1, 0x0047c3f2, 0x0045c3f2, 0x0040c3f4, 0x003bc4f6, 0x003cbff3,
	0x003ebbf0, 0x002dcaff, 0x00ff5d25, 0x00fe6d2f, 0x00f37d39, 0x00f59348, 0x00f8a958, 0x00f7c083,
	0x00f7d7ae, 0x00ffc36d, 0x00ffda84, 0x00fbe48c, 0x00f7ee94, 0x00f8ed9e, 0x00faeca7, 0x00f9f1b4,
	0x00f8f6c1, 0x00fcf6c8, 0x00fff6d0, 0x00fef2d3, 0x00fcf4ba, 0x00fffee8, 0x00f7fdea, 0x00fdfde3,
	0x00fffcdc, 0x000b9df1, 0x002aaaed, 0x001baaf6, 0x0080c8da, 0x00fdffbb, 0x00e8f2bd, 0x00ebf4c4,
	0x00eff7cb, 0x00eff7cb, 0x00eff7cb, 0x00edf6c5, 0x00ebf5c0, 0x00eaf4be, 0x00e8f3bd, 0x00e4f4b4,
	0x00e0f6ab, 0x00d0f191, 0x00c1ec77, 0x00b0e463, 0x009edb4e, 0x0095d448, 0x008bcc42, 0x007fc23b,
	0x0073b935, 0x006aac31, 0x0060a510, 0x00229687, 0x000b91f1, 0x000e93f3, 0x001294f5, 0x001294f5,
	0x004cc6f1, 0x004bc5f2, 0x0049c5f2, 0x0047c4f2, 0x0046c4f2, 0x0043c4f1, 0x0040c4f0, 0x0042c0f3,
	0x0039c1f6, 0x005eacca, 0x00fb591e, 0x00f36e31, 0x00f88135, 0x00fb923f, 0x00fbaf5e, 0x00ffc373,
	0x00fde2ba, 0x00ffcd75, 0x00ffd372, 0x00ffe584, 0x00fff796, 0x00fef4a2, 0x00fdf1ae, 0x00fff8c2,
	0x00fcf8cd, 0x00fef8d2, 0x00fff9d6, 0x00fef6e1, 0x00fcf5dd, 0x00fffbee, 0x00fbfce8, 0x00fffce0,
	0x00b2e0e8, 0x0019a4f0, 0x0026abec, 0x0016a8f6, 0x00c2e4d8, 0x00f9fac5, 0x00eff6cb, 0x00f0f7ce,
	0x00f1f8d2, 0x00f1f8d1, 0x00f2f9d1, 0x00f1f9cd, 0x00f1f9ca, 0x00f2fbca, 0x00f4fdca, 0x00e7f8b6,
	0x00daf3a2, 0x00cbef8a, 0x00bcec71, 0x00b0e661, 0x00a5e151, 0x009ad949, 0x008fd240, 0x0083c73b,
	0x0077bc35, 0x006ab31d, 0x005ea905, 0x00138dea, 0x001193ef, 0x001093f0, 0x000f93f0, 0x000f93f0,
	0x004dc6f2, 0x004cc6f2, 0x004ac5f3, 0x0048c5f3, 0x0047c5f3, 0x0046c4ef, 0x0046c4eb, 0x0048c0f3,
	0x0034c7fb, 0x00989591, 0x00fc6428, 0x00f1773b, 0x00fc8432, 0x00ff9135, 0x00ffb564, 0x00ffbe5a,
	0x00f3ddb6, 0x00ccd097, 0x00b4cea5, 0x00b0d3b1, 0x00abd7bd, 0x00c3e1bf, 0x00daebc1, 0x00f5fdc7,
	0x00ffffbd, 0x00fffecd, 0x00fffcdc, 0x00fffce0, 0x00fbfce5, 0x00fdfbe6, 0x00fffae7, 0x00fffbdd,
	0x0061c4f4, 0x0026aaee, 0x0022abec, 0x0010a7f6, 0x00ffffd7, 0x00f5f5d0, 0x00f6fad9, 0x00f4f9d9,
	0x00f2f9da, 0x00f3fad8, 0x00f4fbd7, 0x00f5fcd5, 0x00f7fdd4, 0x00f3face, 0x00f0f7c8, 0x00e2f4b0,
	0x00d4f199, 0x00c5ee82, 0x00b7eb6b, 0x00b1e95f, 0x00abe754, 0x009fdf49, 0x0094d83f, 0x0087cc3a,
	0x007bc034, 0x006bb425, 0x005ba332, 0x000495f9, 0x001795ee, 0x001293ed, 0x000c91eb, 0x000c91eb,
	0x004fc8f3, 0x004dc8f3, 0x004cc8f4, 0x004bc8f4, 0x0049c8f4, 0x0047c5f2, 0x0045c2ef, 0x0042c2f8,
	0x0034c8ff, 0x00df6746, 0x00ff632a, 0x00ff701b, 0x00e18b53, 0x00a4a185, 0x0063c1cd, 0x0026c0ff,
	0x002ab8ff, 0x0025b5f1, 0x0027b7f9, 0x0026b5f6, 0x0023b3f2, 0x0024b5fa, 0x0025b7ff, 0x00189ddf,
	0x0043bbf4, 0x009edae8, 0x00f9f9dc, 0x00f3fbe6, 0x00ffffea, 0x00fdffe6, 0x00fafce2, 0x00ffffff,
	0x001ea8ef, 0x001ca8f1, 0x001ba8f2, 0x005bc4f1, 0x00ffffe7, 0x00fbf9e1, 0x00fbfce3, 0x00f8fbe0,
	0x00f5fadd, 0x00f5fbdb, 0x00f5fbda, 0x00f6fcd7, 0x00f6fdd3, 0x00f0f8c9, 0x00ebf4be, 0x00dff2a9,
	0x00d4f094, 0x00c7f47b, 0x00baf862, 0x00b0ef58, 0x00a6e64e, 0x00a3e248, 0x0098d73a, 0x008acd38,
	0x007bc435, 0x0070b821, 0x003b9c84, 0x000d93f4, 0x001394ed, 0x001193e9, 0x000f92e6, 0x000f92e6,
	0x0050c9f4, 0x004fcaf4, 0x004ecaf5, 0x004dcaf5, 0x004ccaf6, 0x0048c5f4, 0x0045c0f3, 0x0047c2ef,
	0x004ac4eb, 0x00ff521f, 0x00a79a92, 0x0051b7e6, 0x0028c7ff, 0x002cc4f9, 0x0031c1f1, 0x003fbbf0,
	0x0037c0ef, 0x0039b9f0, 0x003bb3f1, 0x0038b5f4, 0x0036b7f7, 0x0032b9f0, 0x002fbbe8, 0x002fb8eb,
	0x002fb5ed, 0x0020acf3, 0x0010a3fa, 0x0070c9f3, 0x00f5f9df, 0x00f6fbde, 0x00f6fdde, 0x00d8ebe4,
	0x0011a5ee, 0x002db2f5, 0x0014a5f8, 0x00a5e2ec, 0x00fffff8, 0x00fffef3, 0x00fffded, 0x00fcfde6,
	0x00f8fce0, 0x00f7fcde, 0x00f6fcdd, 0x00f6fcd8, 0x00f5fdd3, 0x00edf7c4, 0x00e5f1b4, 0x00e5f5b8,
	0x00e4f9bb, 0x00ecfed2, 0x00f3ffe9, 0x00edfedb, 0x00e8f9cd, 0x00caef89, 0x009cd636, 0x0084c72e,
	0x006bb826, 0x006cb315, 0x001a95d6, 0x001591ef, 0x001093eb, 0x001193e6, 0x001294e1, 0x001294e1,
	0x0052cbf4, 0x0050caf4, 0x004ecaf4, 0x004ccaf3, 0x004ac9f3, 0x0048c8f5, 0x0046c7f6, 0x0040bfed,
	0x0041bfeb, 0x0041d4f9, 0x0033c9fc, 0x002fc9ff, 0x0042c3ec, 0x0040c3f4, 0x003ec3fc, 0x0035bbf4,
	0x0033bbf3, 0x0049bdf7, 0x0039b7f9, 0x0037b7f6, 0x0035b7f2, 0x002eb5f4, 0x0028b3f5, 0x002fbbf8,
	0x002fbaf2, 0x0030b5f2, 0x0031b0f1, 0x001facf6, 0x000dabed, 0x007fd2ed, 0x00ffffe6, 0x0080d9d2,
	0x002faaf8, 0x001dafec, 0x0003aae6, 0x00fff8ff, 0x00fffffe, 0x00fffff9, 0x00fffdf4, 0x00fdfeeb,
	0x00fbfee3, 0x00f9fde1, 0x00f7fce0, 0x00f5fdd8, 0x00f4fdcf, 0x00f5fce2, 0x00f6fde8, 0x00f3fde8,
	0x00f1fde9, 0x00ebfdd3, 0x00e6fdbe, 0x00e0f8ba, 0x00daf2b7, 0x00eafcd2, 0x00f2fde6, 0x00b7de8d,
	0x0084c73d, 0x009ab848, 0x0014a1f9, 0x000494f3, 0x001094ef, 0x001095ec, 0x001095e9, 0x001095e9,
	0x0054ccf5, 0x0051cbf4, 0x004ecaf3, 0x004cc9f2, 0x0049c8f1, 0x0048cbf5, 0x0048cef9, 0x0040c4f3,
	0x0049cafc, 0x0040c2f1, 0x0047caf5, 0x0046c7f4, 0x0046c4f3, 0x0039b5ee, 0x002ca5e8, 0x002eb1e1,
	0x0056c1ea, 0x006dc9e9, 0x0037c2e5, 0x0051caeb, 0x006bd2f1, 0x0074d1f5, 0x007dcff9, 0x0056c7f8,
	0x001fafe8, 0x0025b1ee, 0x002cb3f4, 0x003eb5f9, 0x002bb3ee, 0x001baff5, 0x0032b5f0, 0x003fb2f9,
	0x0026a9f2, 0x001faeeb, 0x003fb8f4, 0x00fcfff3, 0x00ffffff, 0x00ffffff, 0x00fffefb, 0x00fefff1,
	0x00feffe6, 0x00fbffe5, 0x00f8fde3, 0x00f5fdd7, 0x00f3fecb, 0x00f5fbeb, 0x00f7feee, 0x00f2fdde,
	0x00edfccf, 0x00e3f9b0, 0x00d9f692, 0x00d2f48b, 0x00ccf184, 0x00ceee97, 0x00d0eaa9, 0x00daebc1,
	0x00f4fbe9, 0x007fc679, 0x005ac1ff, 0x001aa1eb, 0x001195f2, 0x000f96f2, 0x000e97f2, 0x000e97f2,
	0x0054cdf5, 0x0052ccf4, 0x004fcbf3, 0x004dc9f3, 0x004ac8f2, 0x0049c6f2, 0x0047c4f2, 0x0049d2f3,
	0x0046c8f3, 0x004dc5fc, 0x002c9add, 0x001883cd, 0x00046cbe, 0x000080c5, 0x000f96d4, 0x002eaddb,
	0x0060c6eb, 0x0076cdef, 0x0051caea, 0x0069d2f0, 0x0081daf5, 0x009ae4f7, 0x00b3eff9, 0x00cffaff,
	0x00e3feff, 0x009ae1ff, 0x0048bcf7, 0x0011b5dd, 0x0032aef0, 0x0028acfc, 0x0031b2f3, 0x0034b1f6,
	0x0025adf0, 0x0026acf6, 0x0098d1fc, 0x00fffdf8, 0x00ffffff, 0x00fffffb, 0x00fefff4, 0x00fdffee,
	0x00fcfde7, 0x00fbfee4, 0x00faffe0, 0x00f8fde7, 0x00f7fcef, 0x00f3fbeb, 0x00effdd9, 0x00e9fbc2,
	0x00e3f9ac, 0x00d9f49b, 0x00ceef8b, 0x00c1ea76, 0x00b4e562, 0x00abdd5a, 0x00a2d261, 0x00c1e98e,
	0x00dbe8b9, 0x0096d4ff, 0x008ed0fa, 0x0042aeee, 0x001095f1, 0x001096f1, 0x000f96f1, 0x000f96f1,
	0x0055cef5, 0x0053ccf4, 0x0050cbf4, 0x004ecaf4, 0x004cc8f4, 0x0051caf7, 0x0057cbfa, 0x0045c0ea,
	0x001a75c7, 0x000058ad, 0x00015bb4, 0x00066fc0, 0x000b84cd, 0x000093ce, 0x0011a7e0, 0x003eb9e6,
	0x006bcbeb, 0x007ed1f6, 0x006cd3f0, 0x0082dbf4, 0x0098e3f9, 0x00a5ecf7, 0x00b2f4f5, 0x00c7f7f9,
	0x00ddfafd, 0x00f2ffff, 0x00f8fff6, 0x00bcebfe, 0x0022b4f2, 0x0029afff, 0x002fb0f7, 0x0029b1f2,
	0x0023b1ee, 0x001aa7fa, 0x00cae6f4, 0x00f7f8f4, 0x00feffff, 0x00fefff7, 0x00feffed, 0x00fcffeb,
	0x00fbfae9, 0x00fbfee3, 0x00fbffdc, 0x00fbffe9, 0x00fbfff7, 0x00f1fedd, 0x00e7fbc3, 0x00e0f6b4,
	0x00d8f0a5, 0x00ceec94, 0x00c4e884, 0x00b8e678, 0x00ace36c, 0x00a0df53, 0x0094d455, 0x0080bd41,
	0x00d2e599, 0x002ca1f4, 0x0030a2f6, 0x00209cf3, 0x001096f1, 0x001096f1, 0x001096f1, 0x001096f1,
	0x0055cef4, 0x0053cdf4, 0x0051cbf5, 0x0050cbf5, 0x004ecaf6, 0x004dc9f4, 0x0054d0fa, 0x002b86ce,
	0x000752b1, 0x00045fb9, 0x000a74c9, 0x000882ce, 0x000691d4, 0x0002a0d5, 0x0024b5e7, 0x004cc4ea,
	0x0074d3ee, 0x0083d9f5, 0x007fddf4, 0x0093e4f6, 0x00a8ecf9, 0x00b6f2f9, 0x00c3f9f9, 0x00d3fafb,
	0x00e3fcfc, 0x00edfefb, 0x00f0f9f3, 0x00ffffff, 0x00fffdff, 0x007edcef, 0x0026adfd, 0x002aaff7,
	0x002db2f2, 0x0034b1e0, 0x0009a7f7, 0x008dd3f5, 0x00fdfbf9, 0x00fffff6, 0x00fdffeb, 0x00fcffe6,
	0x00fcfce0, 0x00f9fcde, 0x00f7fcdd, 0x00fcffef, 0x00f9fdec, 0x00e8f5d0, 0x00dff5bd, 0x00d9f1ad,
	0x00d2ed9d, 0x00c5e97e, 0x00b8e26d, 0x00abdd5e, 0x009fd74f, 0x0098c95f, 0x0092c735, 0x008bc942,
	0x0080b34d, 0x00009bf2, 0x001894f8, 0x001595f5, 0x001397f2, 0x001296f1, 0x001195f0, 0x001195f0,
	0x0056cff4, 0x0054cdf5, 0x0052ccf5, 0x0051cbf7, 0x0051cbf9, 0x0049c8f1, 0x0051d5fa, 0x001662c1,
	0x00005cbb, 0x000874cd, 0x00037cce, 0x00028dd4, 0x00019edb, 0x0009aedc, 0x0037c2ee, 0x005acfef,
	0x007edcf0, 0x0088e1f4, 0x0092e6f8, 0x00a5eef8, 0x00b9f5f9, 0x00c7f9fb, 0x00d5fdfe, 0x00dffdfc,
	0x00e9fdfa, 0x00f0fefe, 0x00f8ffff, 0x00fafffe, 0x00fdfffc, 0x00fdfbff, 0x001db0e8, 0x002ab1ee,
	0x0037b2f5, 0x0025b9f7, 0x0029b4f8, 0x0022aff5, 0x001baaf2, 0x009fd7f6, 0x00fdffea, 0x00fcfee0,
	0x00fcfdd7, 0x00f8fada, 0x00f4f7dd, 0x00fdfef5, 0x00f6fae1, 0x00dfecc3, 0x00d8efb6, 0x00d2eca6,
	0x00ccea95, 0x00bce567, 0x00abdb56, 0x009fd344, 0x0092cb33, 0x0085c824, 0x0079b46a, 0x003a9eaf,
	0x000c97ff, 0x001994f9, 0x000f9bee, 0x00139af0, 0x001699f3, 0x001497f1, 0x001295ef, 0x001295ef,
	0x0058d0f5, 0x0056cef5, 0x0053cdf4, 0x0053ccf6, 0x0052cbf8, 0x0053d6fb, 0x004fc8fc, 0x00004cad,
	0x00096fca, 0x000b80d4, 0x000588d5, 0x000598db, 0x0005a8e1, 0x0018b6e6, 0x003fc8f2, 0x0063d3f3,
	0x0086dff5, 0x0091e4f7, 0x009ce9fa, 0x00aef0f9, 0x00c0f7f9, 0x00cbfafb, 0x00d7fdfd, 0x00defdfc,
	0x00e6fefb, 0x00f0fffe, 0x00faffff, 0x00f2fefb, 0x00fefffd, 0x00c6e9fb, 0x001eb0ec, 0x0030b4f6,
	0x0030b7f8, 0x0019a8f7, 0x0026b0f0, 0x0022aef3, 0x001eabf5, 0x0027aafa, 0x001ca6f6, 0x007dcdea,
	0x00dff4dd, 0x00eaffb0, 0x00fdfeed, 0x00ffffef, 0x00fcf9d3, 0x00edeeb4, 0x00e6e9ac, 0x00d9e68a,
	0x00cbe367, 0x00b9e153, 0x00a6dd4d, 0x0075c57f, 0x0043adb0, 0x00229bf3, 0x000a9cff, 0x000998f6,
	0x00109cef, 0x00189aee, 0x00149ded, 0x00159bf0, 0x001599f2, 0x001397f0, 0x001195ee, 0x001195ee,
	0x005ad1f6, 0x0057cff5, 0x0054cef4, 0x0054cdf6, 0x0053cbf8, 0x004dd3f4, 0x002c9add, 0x00045ec1,
	0x000572c9, 0x000683d2, 0x000794dc, 0x0008a2e2, 0x0008b1e8, 0x0028bfef, 0x0048cef6, 0x006bd8f8,
	0x008fe3fa, 0x009be8fa, 0x00a6edfb, 0x00b7f3fb, 0x00c7f9fa, 0x00d0fbfc, 0x00d9fdfd, 0x00defefd,
	0x00e2fffc, 0x00effffe, 0x00fcffff, 0x00ebfef7, 0x00fffffe, 0x008fd7f8, 0x001eb0f1, 0x002eb0f6,
	0x0018abec, 0x00e0f7fd, 0x0024ade9, 0x0023acf1, 0x0021acf8, 0x0026aef7, 0x002cb0f6, 0x001aa9f5,
	0x0008a3f4, 0x0022a7f9, 0x004cc2f2, 0x006dcdef, 0x007ec9db, 0x007fcac2, 0x0081c6c6, 0x0061bccb,
	0x0041b3d0, 0x0024a7e9, 0x00089bff, 0x00119dff, 0x001a9fff, 0x000f99e9, 0x00149cf9, 0x00159cf7,
	0x00159cf5, 0x00179df1, 0x00199eed, 0x00179cef, 0x001599f1, 0x001397ef, 0x001195ed, 0x001195ed,
	0x005cd2f6, 0x0059d0f5, 0x0055cff3, 0x0054cdf5, 0x0053ccf8, 0x0051d5f6, 0x00167bcf, 0x000467c6,
	0x00067bcf, 0x00068bd7, 0x00059cdf, 0x0008a9e5, 0x000ab6eb, 0x002bc4f1, 0x004cd2f7, 0x006ddbf9,
	0x008ee5fa, 0x009deafb, 0x00aceffb, 0x00bdf5fb, 0x00cefbfa, 0x00d5fbfc, 0x00dcfcfd, 0x00dcfefd,
	0x00ddfffd, 0x00e4fffd, 0x00eafffd, 0x00fffffe, 0x00ffffff, 0x0027c0de, 0x0026b5f6, 0x001fb0f9,
	0x004dc6ff, 0x00fff9ef, 0x00fefffa, 0x008bd8f7, 0x0018a7f3, 0x001daaf4, 0x0023acf6, 0x0022acf3,
	0x0022abf0, 0x001aa3f2, 0x001aa6ee, 0x0018a8f5, 0x000ea2f3, 0x0011a4f2, 0x0014a4ff, 0x0015a3fc,
	0x0016a3fa, 0x0017a2f3, 0x0019a2ec, 0x000e99fe, 0x00169bed, 0x0000a1ff, 0x002b9de8, 0x0061b5b0,
	0x00109af7, 0x00149cf2, 0x00189eed, 0x00169cef, 0x00149af0, 0x001298ee, 0x001096ec, 0x001096ec,
	0x005fd3f7, 0x005bd2f5, 0x0056d0f3, 0x0055cef5, 0x0053cdf7, 0x0056d8f8, 0x00005cc0, 0x000370cb,
	0x000785d6, 0x000594dc, 0x0004a3e2, 0x0008afe8, 0x000cbcee, 0x002ec8f3, 0x0050d5f9, 0x006fdefa,
	0x008de7fb, 0x009fecfb, 0x00b1f2fb, 0x00c3f7fb, 0x00d4fcfa, 0x00d9fcfc, 0x00defcfd, 0x00dbfdfd,
	0x00d9fffd, 0x00d9fdfb, 0x00d9fcfa, 0x00e5fafa, 0x00a4eaf7, 0x002badfb, 0x002fb9fa, 0x001aaeed,
	0x0099dbf8, 0x00ffffff, 0x00fefdfc, 0x00fffefd, 0x00fffffd, 0x008cd4fa, 0x0019a9f6, 0x0018a9f7,
	0x0016aaf9, 0x001aa7f3, 0x001ea5ee, 0x001fa7f2, 0x0021a9f6, 0x001ea7f7, 0x001ba5f7, 0x0017a4f9,
	0x0012a2fb, 0x000b9dfd, 0x000399fe, 0x0026a2fa, 0x006fc0b0, 0x00cfca5e, 0x00ffe528, 0x0074b4b3,
	0x000b98fa, 0x00119af4, 0x00179dee, 0x00159cee, 0x00139aef, 0x001198ed, 0x000f96eb, 0x000f96eb,
	0x005dd1f6, 0x005bd2f5, 0x0058d2f4, 0x0053cef4, 0x0056d2fb, 0x0040b2e6, 0x000164c6, 0x000376cf,
	0x000487d7, 0x000296dd, 0x0001a4e4, 0x0004b1ea, 0x0007bdf1, 0x001bc8f2, 0x0043d5fc, 0x0064ddfb,
	0x0085e6fb, 0x0098ebfc, 0x00acf1fd, 0x00bef9ff, 0x00cfffff, 0x00cffdff, 0x00cff9fb, 0x00d2fefe,
	0x00d5ffff, 0x00c6f9ff, 0x00b8efff, 0x005ad7d9, 0x0040b9e9, 0x002fb9ff, 0x002bb2f0, 0x0028afeb,
	0x00def0f2, 0x00ffffff, 0x00feffff, 0x00fffefe, 0x00fffefa, 0x00fffffa, 0x00fffff9, 0x00c2e8f0,
	0x0084cde7, 0x0053bbe9, 0x0022a9eb, 0x0014a1ff, 0x00069ff8, 0x000fa0f8, 0x0019a3eb, 0x0043b1e1,
	0x006ec2c9, 0x00b0d79a, 0x00f2eb6b, 0x00ebee32, 0x00f8e647, 0x00ffe23a, 0x00fde142, 0x000098f4,
	0x0019a1fc, 0x00169ef7, 0x00129bf1, 0x00139af1, 0x00149af0, 0x001298ee, 0x001096ec, 0x001096ec,
	0x005ccff6, 0x005bd2f6, 0x005ad4f6, 0x0052cdf2, 0x005ad6fe, 0x00298cd5, 0x00026ccc, 0x00027bd2,
	0x000189d8, 0x000097df, 0x0000a6e6, 0x0000b2ed, 0x0002bef4, 0x0009c7f1, 0x0035d5ff, 0x0059ddfd,
	0x007ce5fb, 0x0091eafd, 0x00a6f0ff, 0x00b1f2ff, 0x00bbf5ff, 0x00bef5fc, 0x00c1f6f9, 0x00c1f7f7,
	0x00c1f9f4, 0x00c7fdfc, 0x00cdffff, 0x00c2f9f8, 0x005acdf4, 0x0039b1f3, 0x0038baf5, 0x002ab4f7,
	0x00fcfbf8, 0x00fdfeff, 0x00feffff, 0x00fffeff, 0x00fffcf6, 0x00fdfef2, 0x00f7ffee, 0x00fcffea,
	0x00ffffe5, 0x00ffffd8, 0x00ffffcb, 0x00fffbf1, 0x00ffffdf, 0x00fdfdc2, 0x00f7ff88, 0x00fbfe92,
	0x00ffff7f, 0x00fdfc6c, 0x00faf759, 0x00f8f059, 0x00f7e958, 0x00f7e359, 0x00d0d368, 0x000998ff,
	0x00189aef, 0x00129af2, 0x000c99f5, 0x001199f3, 0x001599f2, 0x001397f0, 0x001195ee, 0x001195ee,
	0x005fd2f9, 0x005cd3f8, 0x0059d4f6, 0x0058d3f8, 0x005edaff, 0x001971cd, 0x00026ecd, 0x00037bd3,
	0x000488d9, 0x000497e0, 0x0005a6e6, 0x0001ade7, 0x0000b5e8, 0x0007beea, 0x0023cbf5, 0x004cd7f8,
	0x0074e4fc, 0x0089e8fd, 0x009fecfe, 0x00a5edfe, 0x00abeffe, 0x00aeeffc, 0x00b0eff9, 0x00b3f3f9,
	0x00b6f6f8, 0x00b6f9fc, 0x00b5fcff, 0x00daf3ff, 0x001ab9f1, 0x0028b3f4, 0x002bb3f6, 0x0073cef4,
	0x00fdfdf5, 0x00fdfefa, 0x00fdfffe, 0x00fffef9, 0x00fffdf3, 0x00fdfeee, 0x00faffe9, 0x00fdffe4,
	0x00ffffde, 0x00ffffd0, 0x00ffffc2, 0x00fdfad7, 0x00fffcf3, 0x00ffffc0, 0x00fcfbc5, 0x00fcff84,
	0x00fcfb8b, 0x00fbf67a, 0x00f9f269, 0x00f7ed5e, 0x00f4e954, 0x00f7e948, 0x0087bda9, 0x00109afc,
	0x00179cf2, 0x00149bf1, 0x00119af1, 0x001399f2, 0x001698f3, 0x001496f1, 0x001294ef, 0x001294ef,
	0x0062d4fc, 0x005dd4f9, 0x0059d4f6, 0x0056d1f6, 0x0053cef5, 0x00014ebe, 0x00026fcd, 0x00057bd4,
	0x000787da, 0x000996e0, 0x000ca5e7, 0x000bb0e9, 0x0009bbeb, 0x0015c5f3, 0x0021d0fc, 0x0046dafc,
	0x006ce3fc, 0x0082e6fd, 0x0097e9fe, 0x0099e9fe, 0x009ce8fe, 0x009ee9fb, 0x00a0e9f9, 0x00a6eefa,
	0x00acf3fc, 0x00b0effc, 0x00b5ecfb, 0x0089ddf9, 0x0028b4f3, 0x003ebef7, 0x001eadf7, 0x00bde8f0,
	0x00fefff2, 0x00fefff3, 0x00fdfff4, 0x00fefef2, 0x00fefef0, 0x00fefeea, 0x00fefee4, 0x00fefede,
	0x00fefed8, 0x00fcffc9, 0x00fbffba, 0x00f6fea0, 0x00ffffce, 0x00fff9f6, 0x00ffffc9, 0x00fdf7be,
	0x00f8f87a, 0x00f9f66b, 0x00f9f35c, 0x00f5ee56, 0x00f1e84f, 0x00f8ee37, 0x003fa7ea, 0x00189df5,
	0x00179df4, 0x00169cf1, 0x00159bee, 0x00169af2, 0x001798f5, 0x001596f3, 0x001394f1, 0x001394f1,
	0x0066d7fc, 0x005fd1f5, 0x0060d4f6, 0x0059d8f9, 0x00399ddb, 0x000858be, 0x00096ccd, 0x000c7ad2,
	0x001087d7, 0x001296df, 0x0013a6e8, 0x0013b0eb, 0x001bc3f5, 0x000fc8f3, 0x0017d0f9, 0x0027d3f4,
	0x004bd7f7, 0x0061dbf8, 0x0077def9, 0x007fe0fa, 0x0088e1fa, 0x008de4fb, 0x0091e7fb, 0x0096eafc,
	0x009aedfd, 0x009feafb, 0x00a3e7fa, 0x005eccfb, 0x002db7f5, 0x0024b8f9, 0x0014b1f5, 0x00fffbff,
	0x00feffec, 0x00ffffed, 0x00ffffee, 0x00ffffec, 0x00fefdeb, 0x00fefde4, 0x00fefddd, 0x00fefed6,
	0x00fefece, 0x00fcfdc1, 0x00fcfcb5, 0x00f6fb8d, 0x00f8fc8a, 0x00f8facc, 0x00f8fef2, 0x00f9ffbe,
	0x00fbf9c2, 0x00fbf8ac, 0x00fcf796, 0x00faf491, 0x00f7f18d, 0x00ffe5a9, 0x000096f7, 0x00089af7,
	0x00159ef7, 0x00169df4, 0x00169cf0, 0x00169bf2, 0x001699f4, 0x001497f3, 0x001396f1, 0x001396f1,
	0x006bd9fb, 0x0061cef1, 0x0067d3f7, 0x005cdefd, 0x001f6cc0, 0x000f63bf, 0x000f6acd, 0x001478d1,
	0x001887d4, 0x001997df, 0x001aa6e9, 0x0014a9e4, 0x001dbbef, 0x000dbeeb, 0x0023c5f6, 0x0013c6ed,
	0x002acbf3, 0x0040cff4, 0x0056d4f4, 0x0065d7f6, 0x0074daf7, 0x007bdffb, 0x0083e5fe, 0x0086e6fe,
	0x0089e8fd, 0x008ee5fb, 0x0092e2fa, 0x0033bcfc, 0x0032b9f7, 0x0031bafd, 0x0057c5f7, 0x00f4ffde,
	0x00fdffe7, 0x00ffffe7, 0x00ffffe7, 0x00ffffe6, 0x00fdfce6, 0x00fdfddd, 0x00fdfdd5, 0x00fdfdcd,
	0x00fefdc5, 0x00fdfaba, 0x00fcf8af, 0x00fef99f, 0x00fffb8e, 0x00fafe77, 0x00f4fb7d, 0x00f9f8d2,
	0x00fdffee, 0x00fefedf, 0x00fffcd0, 0x00fefacd, 0x00fdf9ca, 0x00a6d3ce, 0x000399eb, 0x001ea1ec,
	0x00149ffa, 0x00159ef6, 0x00179ef2, 0x00169cf3, 0x00159af3, 0x001499f2, 0x001398f1, 0x001398f1,
	0x0055d4f4, 0x005bd1f1, 0x0069d6f6, 0x006ee2ff, 0x000c50a8, 0x001161be, 0x000f6acd, 0x001f83d6,
	0x001f89dc, 0x000f8cdd, 0x001a9be0, 0x0022b1f4, 0x001dabe1, 0x0014aedf, 0x0026bdee, 0x0015bae7,
	0x001fc1ef, 0x0025c7ef, 0x002bcdef, 0x003dcdf1, 0x004ecef3, 0x005bd6f9, 0x0068defe, 0x006eddfc,
	0x0073ddfb, 0x0076ddf5, 0x0070d3f7, 0x0031bafb, 0x0033b9f6, 0x0024b6ff, 0x00a4dee5, 0x00f9ffdc,
	0x00fdfedc, 0x00ffffdc, 0x00ffffdc, 0x00fefedb, 0x00fcfdda, 0x00fdfdd2, 0x00fdfdcb, 0x00fdfdc3,
	0x00fefdbc, 0x00fdfbaf, 0x00fcfaa2, 0x00fdfb93, 0x00fefb83, 0x00fcfd6b, 0x00f9fc60, 0x00fbf85d,
	0x00fdf74c, 0x00fef576, 0x00fff2a1, 0x00f6ec87, 0x00f8e360, 0x0051bbb4, 0x000d9afe, 0x001a9ef7,
	0x00159ef6, 0x00159df4, 0x00159df2, 0x00149bf2, 0x001299f2, 0x001299f2, 0x001299f2, 0x001299f2,
	0x0067d4fd, 0x0069d6f9, 0x006cd9f5, 0x004fb7dc, 0x001953af, 0x001c67c6, 0x00005abd, 0x001a7eca,
	0x00157bd4, 0x000581dc, 0x002aa1e7, 0x000189d3, 0x002dabe3, 0x0023a7dc, 0x0029b4e6, 0x0017ade1,
	0x0014b7ec, 0x0015b9ea, 0x0016bbe9, 0x001fbfec, 0x0028c2ef, 0x003bcdf7, 0x004ed8ff, 0x0056d5fb,
	0x005dd2f8, 0x005ed6f0, 0x004ec5f4, 0x002fb9fa, 0x0035b8f4, 0x0017b1ff, 0x00f0f7d2, 0x00feffda,
	0x00fdfcd2, 0x00fdfdd1, 0x00fdfed1, 0x00fdfecf, 0x00fcfecd, 0x00fcfdc7, 0x00fdfdc0, 0x00fdfdb9,
	0x00fdfdb2, 0x00fdfca4, 0x00fdfc95, 0x00fdfc87, 0x00fdfc79, 0x00fdfa6c, 0x00fef85f, 0x00f9f645,
	0x00f6ef47, 0x00f2e938, 0x00efe428, 0x00eee425, 0x00ffdd05, 0x000399ff, 0x0017a1f5, 0x00179ef4,
	0x00169cf3, 0x00159cf3, 0x00149cf3, 0x00129bf1, 0x001099f0, 0x00119af1, 0x00129bf2, 0x00129bf2,
	0x0066d5fb, 0x0070d5fc, 0x0078e2ff, 0x003b86c7, 0x00235fba, 0x001e6aba, 0x00227ad1, 0x002787d8,
	0x00248cd7, 0x001d8dd4, 0x002189d1, 0x002ca1ea, 0x002296d5, 0x0031aaef, 0x0020a1db, 0x0017a1dd,
	0x000ea1e0, 0x001aace3, 0x0013b1eb, 0x0010b8ed, 0x000dc0ef, 0x001cc1ef, 0x002cc3f0, 0x0036c4f2,
	0x0040c5f4, 0x0047c9f2, 0x0045c3f6, 0x0031bafa, 0x0031b7f7, 0x004cc2f4, 0x00f5fac0, 0x00fdffc6,
	0x00fdfcc5, 0x00fdfdc4, 0x00fdfdc4, 0x00fcfdc2, 0x00fbfdc1, 0x00f8f9b6, 0x00fdfdb3, 0x00fdfdab,
	0x00fdfca3, 0x00fcfc95, 0x00fcfb88, 0x00fcfb7b, 0x00fbfb6d, 0x00fcf962, 0x00fcf757, 0x00f8f245,
	0x00f4eb41, 0x00f0e532, 0x00ebe023, 0x00fbe01c, 0x00c5d244, 0x000aa2fe, 0x00169ff9, 0x00179ff6,
	0x00189ff3, 0x00179ef2, 0x00159df2, 0x00179ff5, 0x0018a1f8, 0x00159ef5, 0x00129bf2, 0x00129bf2,
	0x0065d7fa, 0x0064d1f7, 0x005de7ff, 0x0004439b, 0x000e4ca5, 0x00317bcd, 0x000455c1, 0x000053c9,
	0x000368c6, 0x002687ca, 0x002881ca, 0x002789d1, 0x002791d7, 0x000774c9, 0x00178dcf, 0x001f9ce1,
	0x00179be4, 0x001e9eda, 0x000097de, 0x0003a5e6, 0x0008b1ee, 0x0009b0e8, 0x000aafe2, 0x0017b4e9,
	0x0024b9ef, 0x0030bdf4, 0x003cc1f9, 0x0034bcf9, 0x002cb6f9, 0x0080d2e8, 0x00fafdaf, 0x00fcfdb3,
	0x00fdfcb7, 0x00fdfcb7, 0x00fdfdb7, 0x00fcfcb6, 0x00fbfcb5, 0x00f4f4a5, 0x00fdfda5, 0x00fcfc9d,
	0x00fcfc94, 0x00fbfb87, 0x00fbfb7b, 0x00fafa6e, 0x00fafa61, 0x00faf758, 0x00faf54e, 0x00f7ee44,
	0x00f3e73a, 0x00ede12c, 0x00e7db1e, 0x00ffd21a, 0x0078b090, 0x0009a0fd, 0x00159dfd, 0x0018a0f8,
	0x001aa2f2, 0x0018a0f2, 0x00169ef2, 0x00139bf2, 0x001099f1, 0x00119af2, 0x00129bf3, 0x00129bf3,
	0x0060d4f7, 0x0067dcfd, 0x004fc2f0, 0x00002c8a, 0x002e6bc0, 0x000547ad, 0x000044ba, 0x003685c4,
	0x00064ebc, 0x001462c3, 0x002d70cb, 0x000f5ab4, 0x002274cd, 0x001169c2, 0x001979c2, 0x001d80d0,
	0x001980d7, 0x001a86d3, 0x001090de, 0x00038dda, 0x000599e6, 0x00059ce1, 0x00049edd, 0x0005a6e1,
	0x0000a7de, 0x001fb6ee, 0x0039bdf7, 0x0038bcf6, 0x0024b5fc, 0x00bfe8b9, 0x00fafea2, 0x00fbfca5,
	0x00fcfaa8, 0x00fcfca7, 0x00fdfda6, 0x00fbfca3, 0x00f9fb9f, 0x00f6f795, 0x00fafb92, 0x00fbfb8b,
	0x00fbfb85, 0x00fafa79, 0x00fafa6d, 0x00f9f961, 0x00f8f956, 0x00f9f64c, 0x00f9f442, 0x00f5ec39,
	0x00f2e531, 0x00efde28, 0x00ecd620, 0x00eed900, 0x0032a6e5, 0x0019a4ff, 0x0029a4f4, 0x0020a2f4,
	0x0018a0f5, 0x00179ef4, 0x00159df4, 0x00139bf3, 0x001199f2, 0x00129af2, 0x00129af3, 0x00129af3,
	0x005bd1f5, 0x0063dffa, 0x00318dcc, 0x00062d91, 0x000e499a, 0x0000369f, 0x00003897, 0x00155fb6,
	0x0053aad9, 0x0031a6e2, 0x0045bcef, 0x006dddff, 0x0076defa, 0x006dd9f9, 0x0064d5f9, 0x0054c5f3,
	0x0045b5ed, 0x00238ed6, 0x001277ce, 0x00006cc6, 0x000282de, 0x000187db, 0x00008dd7, 0x00079be1,
	0x000099dc, 0x0022b1f0, 0x0036baf4, 0x003cbcf4, 0x001cb5ff, 0x00fffe89, 0x00fbff96, 0x00fbfc98,
	0x00fbf99a, 0x00fcfb98, 0x00fdfd96, 0x00fafb90, 0x00f6f98a, 0x00f7f984, 0x00f8fa7f, 0x00fafa7a,
	0x00fbfb75, 0x00fafa6a, 0x00f9f960, 0x00f8f855, 0x00f7f84a, 0x00f7f540, 0x00f8f336, 0x00f4eb2f,
	0x00f0e328, 0x00f0da24, 0x00f0d121, 0x00e9ca24, 0x00049bff, 0x0020a3f6, 0x0016a1f7, 0x0016a0f7,
	0x00169ef7, 0x00159df6, 0x00149cf5, 0x00139bf4, 0x00129af3, 0x00129af3, 0x00129af3, 0x00129af3,
	0x005ae3ff, 0x0064d8ff, 0x000d4798, 0x00002682, 0x001d6bb7, 0x003aa2de, 0x005fe5ff, 0x0052d8fd,
	0x004dd6f6, 0x0048ccf5, 0x005fd0f6, 0x0068d9ff, 0x0061d3f8, 0x005bd2f8, 0x0042cbff, 0x0053cefe,
	0x0051cff5, 0x0049caf6, 0x004acdff, 0x0040baff, 0x000e7edb, 0x000069c2, 0x000584da, 0x000184d5,
	0x00068cd8, 0x0038bef8, 0x003abef7, 0x0035beff, 0x0062c7e2, 0x00fbf379, 0x00f8fa83, 0x00f9f983,
	0x00faf884, 0x00f9f77f, 0x00f7f77b, 0x00f8f979, 0x00f9fa77, 0x00f8f972, 0x00f7f86c, 0x00fcfc6c,
	0x00f9f864, 0x00f8f85b, 0x00f8f752, 0x00f7f649, 0x00f6f53f, 0x00f5f237, 0x00f4ef2f, 0x00f1e628,
	0x00eede20, 0x00ead61f, 0x00f2cc11, 0x009db96c, 0x000c9ffe, 0x001ba3f9, 0x0017a2f9, 0x0017a0f9,
	0x00169ef8, 0x00169df7, 0x00159cf6, 0x00149bf5, 0x00139af5, 0x00139af5, 0x00139af5, 0x00139af5,
	0x0060d8f9, 0x005bd9f8, 0x004cadd7, 0x0069ddff, 0x0056ddf8, 0x0055d6fc, 0x0055d0ff, 0x005cd5ff,
	0x0053cbf2, 0x004bcaf6, 0x0043cafa, 0x0047c9f8, 0x004cc8f6, 0x005ccff1, 0x0046ccf8, 0x0055caff,
	0x003ec4fa, 0x0043c3fb, 0x0048c2fd, 0x003ebff4, 0x0044ccfb, 0x0037b3fc, 0x000b7bdd, 0x00006dc9,
	0x000d80d4, 0x004eccff, 0x003ec3fa, 0x002ec2ff, 0x00a7dea8, 0x00f8ec5b, 0x00f5f570, 0x00f7f66f,
	0x00faf76e, 0x00f5f467, 0x00f1f060, 0x00f6f663, 0x00fbfc65, 0x00f8f95f, 0x00f6f659, 0x00fefe5d,
	0x00f7f652, 0x00f7f54c, 0x00f7f545, 0x00f6f33d, 0x00f6f235, 0x00f3ef2f, 0x00f1eb29, 0x00efe221,
	0x00ecd818, 0x00e5d21a, 0x00f3c700, 0x0052a9b4, 0x0014a4fb, 0x0015a3fb, 0x0017a3fc, 0x0017a1fa,
	0x00179ff8, 0x00169df8, 0x00159cf7, 0x00159bf7, 0x001499f6, 0x001499f6, 0x001499f6, 0x001499f6,
	0x0058cff2, 0x0059ddfd, 0x0055d5f9, 0x005ddeff, 0x004dcef3, 0x004dcbf3, 0x004cc8f3, 0x0056d2fc,
	0x0059d3fd, 0x0050cefb, 0x0047cafa, 0x0048c9f9, 0x0049c7f9, 0x0051cbf6, 0x0045c9f9, 0x004bc8fd,
	0x003fc5f9, 0x0041c4fa, 0x0043c2fb, 0x003bbdf3, 0x003ac0f4, 0x003ec7fc, 0x003ac6fc, 0x0025a1e3,
	0x001f8dd9, 0x0037b9f7, 0x0026bbfa, 0x002abbf4, 0x00ced857, 0x00f9fa5b, 0x00d9db49, 0x00edec58,
	0x00faf560, 0x00f2ef4d, 0x00e9ea3b, 0x00eeef46, 0x00f2f451, 0x00f9f34f, 0x00edf145, 0x00fef84b,
	0x00f4f542, 0x00f5f43d, 0x00f6f337, 0x00f5f131, 0x00f5ef2b, 0x00f2eb27, 0x00f0e622, 0x00eedb1d,
	0x00ecd117, 0x00f1cc09, 0x00f5c509, 0x000fadff, 0x0017a1f9, 0x0018a1f9, 0x0018a1f8, 0x0018a0f9,
	0x00179ff9, 0x00169df9, 0x00169cf8, 0x00159bf8, 0x001599f8, 0x001599f8, 0x001599f8, 0x001599f8,
	0x0060d5fb, 0x005bd3fb, 0x0056d2fb, 0x0055d1fc, 0x0055d0fe, 0x0054d0fa, 0x0053d1f6, 0x0051cef7,
	0x004ecbf8, 0x004dcbf9, 0x004ccafb, 0x0049c8fb, 0x0047c6fc, 0x0045c6fb, 0x0043c6fa, 0x0041c6fa,
	0x0040c7f9, 0x003fc5f9, 0x003ec3f9, 0x003fc3fb, 0x0041c4fd, 0x0038baf2, 0x0040c1f8, 0x003dc3fb,
	0x003bc5fe, 0x0037c1f6, 0x0034beef, 0x002ebcf0, 0x00ded722, 0x00bfdc38, 0x00dee142, 0x00ecea4a,
	0x00eae442, 0x00eee942, 0x00f2ee42, 0x00eeed3f, 0x00eaec3d, 0x00fbee3f, 0x00e5ec31, 0x00fff239,
	0x00f2f531, 0x00f4f32e, 0x00f5f12a, 0x00f5ee25, 0x00f4ec21, 0x00f2e71e, 0x00f0e11c, 0x00eed519,
	0x00ecc917, 0x00dec40c, 0x00bbbe39, 0x000798f8, 0x001a9ff8, 0x001a9ff7, 0x001a9ff5, 0x00189ff7,
	0x00179ff9, 0x00179ef9, 0x00169cf9, 0x00169bf9, 0x001699f9, 0x001699f9, 0x001699f9, 0x001699f9,
	0x005cd4f9, 0x0058d4f9, 0x0055d3f9, 0x0056d2fa, 0x0058d0fb, 0x0056d0f8, 0x0054d0f6, 0x0051cef7,
	0x004dccf9, 0x004ccbfa, 0x004bcafb, 0x0049c8fb, 0x0047c7fb, 0x0045c7fb, 0x0043c6fa, 0x0041c6fa,
	0x0040c6f9, 0x003fc4f9, 0x003ec3f9, 0x003ec2fa, 0x003ec2fb, 0x003abef5, 0x003ec2f8, 0x003bc1f9,
	0x0037c0f9, 0x0036beff, 0x0035bbff, 0x0067bb84, 0x00b0d219, 0x00b4d31a, 0x00d3da39, 0x00e2dd3d,
	0x00d6d532, 0x00e1df38, 0x00ece93e, 0x00e1e636, 0x00e9e536, 0x00f1e634, 0x00e5e42b, 0x00f6e62e,
	0x00e9eb29, 0x00f0ee2a, 0x00f0e824, 0x00ece420, 0x00e9e01d, 0x00ebdb1c, 0x00edd71c, 0x00e9ce19,
	0x00e5c516, 0x00e7c004, 0x006cb292, 0x00109dfc, 0x0018a1f7, 0x001aa0f5, 0x001ca0f3, 0x0019a0f6,
	0x00179ff9, 0x00169ef9, 0x00169cf9, 0x00159bf8, 0x00159af8, 0x001499f8, 0x001499f7, 0x001499f7,
	0x0058d4f6, 0x0056d4f6, 0x0054d5f7, 0x0057d3f7, 0x005bd1f8, 0x0058d0f6, 0x0054cff5, 0x0050cef8,
	0x004dcdfa, 0x004bcbfb, 0x004acafb, 0x0048c9fb, 0x0046c7fb, 0x0045c7fa, 0x0043c7fa, 0x0042c6fa,
	0x0040c6f9, 0x003fc4f9, 0x003ec3f9, 0x003dc1f9, 0x003cc0f9, 0x003cc1f8, 0x003cc2f7, 0x0038bff6,
	0x0034bbf5, 0x0035bdfd, 0x0037beff, 0x0046bcfc, 0x0082c92c, 0x00a0be02, 0x00b8c420, 0x00d8cf31,
	0x00d2d632, 0x00d4d52e, 0x00d7d42a, 0x00cdd725, 0x00e9df2f, 0x00e6dd2a, 0x00e4dc25, 0x00edd922,
	0x00e0e220, 0x00ede927, 0x00eae01e, 0x00e4da1c, 0x00ded319, 0x00e5d01a, 0x00ebcd1b, 0x00e5c818,
	0x00dec214, 0x00f0bc00, 0x001da5eb, 0x0019a1ff, 0x0016a2f7, 0x0019a2f4, 0x001ea2f1, 0x001aa0f5,
	0x00169ff9, 0x00169ef8, 0x00159df8, 0x00159cf8, 0x00149bf8, 0x00139af7, 0x001299f6, 0x001299f6,
	0x005ed5f9, 0x0063d6fc, 0x0068d6ff, 0x005fd3fc, 0x0056d0f8, 0x0053cff8, 0x0051cef8, 0x004ecdf9,
	0x004bccfb, 0x004acbfb, 0x0048cafb, 0x0047c9fa, 0x0046c8fb, 0x0044c7fa, 0x0043c7fa, 0x0042c6fa,
	0x0040c5f9, 0x003fc4f9, 0x003ec3f9, 0x003dc1f9, 0x003cc0f9, 0x003bc1f9, 0x003bc1f8, 0x0038bff7,
	0x0036bdf7, 0x0035bdfa, 0x0034bdfe, 0x0022c3f6, 0x0027bbfc, 0x0053b0b2, 0x009bc606, 0x00c1d322,
	0x00d3dd36, 0x00b4ba12, 0x00c4c71f, 0x00c5cf22, 0x00d9d82d, 0x00dfdb30, 0x00dcd52b, 0x00e8d520,
	0x00d5d51c, 0x00e8e428, 0x00ece324, 0x00d1ce1f, 0x00d3c51d, 0x00dcc302, 0x00cfc312, 0x00e3c209,
	0x00e3be00, 0x0084bf6e, 0x000ca0f6, 0x00129ffd, 0x0018a2f6, 0x0019a1f5, 0x001ba1f4, 0x0018a0f6,
	0x00169ff8, 0x00159ef8, 0x00159df8, 0x00149cf7, 0x00139bf7, 0x00129af6, 0x001098f4, 0x001098f4,
	0x0065d7fb, 0x005dd4fa, 0x0056d2f8, 0x0053d0f9, 0x0050cff9, 0x004fcef9, 0x004dcdfa, 0x004bcdfa,
	0x004accfb, 0x0048cbfb, 0x0047cafb, 0x0046c9fa, 0x0045c8fa, 0x0044c7fa, 0x0043c7fa, 0x0042c6fa,
	0x0040c5fa, 0x003fc4f9, 0x003ec3f9, 0x003dc1f9, 0x003bc0f9, 0x003ac0f9, 0x0039c0f9, 0x0038bff9,
	0x0037bff9, 0x0034bef8, 0x0031bcf7, 0x0033bbf8, 0x0035bbfa, 0x002cbcff, 0x0061c2df, 0x0093cb85,
	0x00c5d52b, 0x00cbd82f, 0x00b0bb13, 0x00b5be17, 0x00b9c21b, 0x00c7c826, 0x00c5bf21, 0x00dbc817,
	0x00cac819, 0x00dbd722, 0x00ddd61a, 0x00b7bd0d, 0x00c8bd04, 0x00d0c000, 0x00adc951, 0x006cb8b1,
	0x0004a3ff, 0x0013a4fb, 0x0021a4f5, 0x001ea3f5, 0x001aa1f6, 0x0019a1f6, 0x0018a0f7, 0x0017a0f7,
	0x00169ff8, 0x00159ef7, 0x00149ef7, 0x00139df7, 0x00139cf6, 0x00119af4, 0x000f98f2, 0x000f98f2,
	0x005cd5f9, 0x0058d3f8, 0x0053d1f8, 0x0052d0f9, 0x0050cff9, 0x004ecefa, 0x004ccdfa, 0x004accfa,
	0x0048ccfa, 0x0047cbfa, 0x0046cafa, 0x0045c9fa, 0x0044c8fa, 0x0043c7fa, 0x0042c7fa, 0x0041c6fa,
	0x0040c5fa, 0x003fc4f9, 0x003ec2f9, 0x003cc1f9, 0x003bc0f9, 0x003ac0f9, 0x0038bff9, 0x0037bff9,
	0x0036bff9, 0x0035bdf6, 0x0034bbf3, 0x0035b9f7, 0x0035b8fb, 0x0022b5ff, 0x002fb5ff, 0x004dbae6,
	0x006bbfce, 0x0027b1c5, 0x006cbc7c, 0x008abd49, 0x00a7be15, 0x00b9bf09, 0x00ccc000, 0x00dac43d,
	0x00bbca20, 0x00aec73e, 0x0099bc54, 0x005aad8b, 0x0036abc4, 0x0004b3ff, 0x0015a7ff, 0x0021a4ff,
	0x0019a0fb, 0x001ba2fa, 0x001da4f9, 0x001ba3f8, 0x001aa1f7, 0x0019a1f7, 0x0018a0f7, 0x0017a0f7,
	0x00169ff8, 0x00159ef7, 0x00149ef7, 0x00139df7, 0x00129cf6, 0x00119af5, 0x000f99f3, 0x000f99f3,
	0x0053d2f6, 0x0052d1f7, 0x0051d1f8, 0x0050d0f9, 0x004fcffa, 0x004dcefa, 0x004bcdfa, 0x0049ccfa,
	0x0047cbfa, 0x0046caf9, 0x0045caf9, 0x0044c9f9, 0x0044c8fa, 0x0043c7fa, 0x0042c6f9, 0x0041c6f9,
	0x0040c5fa, 0x003fc4f9, 0x003dc2f9, 0x003cc1f9, 0x003ac0f9, 0x0039c0f9, 0x0038bff9, 0x0036bff9,
	0x0035bef8, 0x0036bcf4, 0x0038baf0, 0x0036b8f6, 0x0034b5fc, 0x002cb6f9, 0x0023b7f6, 0x0025b5fa,
	0x0028b4ff, 0x0028b6ff, 0x0029b7ff, 0x001fb5ff, 0x0015b2ff, 0x0020aef7, 0x003cb9ff, 0x005acbf0,
	0x0042befa, 0x002ab6fc, 0x0012adff, 0x0018acfc, 0x001eacfa, 0x001ea9fd, 0x001ea7ff, 0x001ba8fa,
	0x0018a8f4, 0x0018a6f8, 0x0018a4fd, 0x0019a3fa, 0x001aa1f7, 0x0019a1f7, 0x0018a0f8, 0x0017a0f8,
	0x00169ff8, 0x00159ef7, 0x00149df7, 0x00139cf6, 0x00129bf6, 0x00119af5, 0x001099f4, 0x001099f4,
	0x0054d1f8, 0x0052d1f8, 0x0051d0f9, 0x004fcff9, 0x004ecffa, 0x004ccefa, 0x004acdf9, 0x0048ccf9,
	0x0045cbf9, 0x0045caf9, 0x0044c9f9, 0x0043c8f9, 0x0043c8f9, 0x0042c7f9, 0x0042c6f9, 0x0041c5f9,
	0x0040c5fa, 0x003fc4f9, 0x003dc2f9, 0x003bc1f9, 0x003ac0fa, 0x0038bff9, 0x0037bff9, 0x0036bef9,
	0x0034bef8, 0x0035bcf6, 0x0035baf5, 0x0034b8f8, 0x0033b6fc, 0x002eb6f9, 0x0029b6f7, 0x0029b5f8,
	0x002ab4fa, 0x002ab5fb, 0x002ab5fc, 0x002ab2f6, 0x002aafef, 0x001ba9f6, 0x009bcfd9, 0x006dcfe9,
	0x0074c7e4, 0x0080c9dd, 0x0019adfb, 0x001cacf9, 0x001fabf8, 0x001fa9f9, 0x001ea7fb, 0x001ca7f9,
	0x001aa7f6, 0x001aa5f8, 0x001aa4fb, 0x001aa3fa, 0x001aa2f8, 0x0019a1f8, 0x0018a0f8, 0x0017a0f8,
	0x00169ff8, 0x00159ef7, 0x00149df7, 0x00139cf6, 0x00129bf6, 0x00119bf5, 0x00119af5, 0x00119af5,
	0x0055d0f9, 0x0053d0fa, 0x0051d0fa, 0x004fcffa, 0x004dcffa, 0x004bcefa, 0x0049cdf9, 0x0046ccf9,
	0x0044caf8, 0x0043caf8, 0x0043c9f8, 0x0043c8f9, 0x0042c8f9, 0x0042c7f9, 0x0041c6f9, 0x0041c6f9,
	0x0040c5fa, 0x003ec3f9, 0x003dc2fa, 0x003bc1fa, 0x0039c0fa, 0x0038bff9, 0x0036bff9, 0x0035bef9,
	0x0034bdf8, 0x0033bcf9, 0x0033bafa, 0x0032b9fb, 0x0032b8fc, 0x0030b7fa, 0x002eb6f8, 0x002db5f7,
	0x002bb4f5, 0x002bb4f6, 0x002bb3f7, 0x0029b2f9, 0x0028b2fc, 0x0030b2f7, 0x0012a8fe, 0x007fd4e1,
	0x0058bbe6, 0x0015aafb, 0x001fadf8, 0x0020acf7, 0x0020aaf5, 0x001fa9f6, 0x001ea8f7, 0x001da6f7,
	0x001ca5f8, 0x001ca4f8, 0x001ba3f9, 0x001ba3f9, 0x001ba2f9, 0x0019a1f9, 0x0018a0f8, 0x0017a0f8,
	0x00169ff8, 0x00159ef7, 0x00149df7, 0x00139cf6, 0x00129bf5, 0x00129bf5, 0x00129bf5, 0x00129bf5,
	0x0055d0f9, 0x0053d0fa, 0x0051d0fa, 0x004fcffa, 0x004dcffa, 0x004bcefa, 0x0049cdf9, 0x0046ccf9,
	0x0044caf8, 0x0043caf8, 0x0043c9f8, 0x0043c8f9, 0x0042c8f9, 0x0042c7f9, 0x0041c6f9, 0x0041c6f9,
	0x0040c5fa, 0x003ec3f9, 0x003dc2fa, 0x003bc1fa, 0x0039c0fa, 0x0038bff9, 0x0036bff9, 0x0035bef9,
	0x0034bdf8, 0x0033bcf9, 0x0033bafa, 0x0032b9fb, 0x0032b8fc, 0x0030b7fa, 0x002eb6f8, 0x002db5f7,
	0x002bb4f5, 0x002bb4f6, 0x002bb3f7, 0x002ab2f8, 0x0029b2fa, 0x002db6f5, 0x001db5f6, 0x00239bff,
	0x0020b6f3, 0x000cacfb, 0x001eacf7, 0x001fabf6, 0x0020aaf5, 0x001fa9f6, 0x001ea8f7, 0x001da6f7,
	0x001ca5f8, 0x001ca4f8, 0x001ba3f9, 0x001ba3f9, 0x001ba2f9, 0x0019a1f9, 0x0018a0f8, 0x0017a0f8,
	0x00169ff8, 0x00159ef7, 0x00149df7, 0x00139cf6, 0x00129bf5, 0x00129bf5, 0x00129bf5, 0x00129bf5,
	0x0055d0f9, 0x0053d0fa, 0x0051d0fa, 0x004fcffa, 0x004dcffa, 0x004bcefa, 0x0049cdf9, 0x0046ccf9,
	0x0044caf8, 0x0043caf8, 0x0043c9f8, 0x0043c8f9, 0x0042c8f9, 0x0042c7f9, 0x0041c6f9, 0x0041c6f9,
	0x0040c5fa, 0x003ec3f9, 0x003dc2fa, 0x003bc1fa, 0x0039c0fa, 0x0038bff9, 0x0036bff9, 0x0035bef9,
	0x0034bdf8, 0x0033bcf9, 0x0033bafa, 0x0032b9fb, 0x0032b8fc, 0x0030b7fa, 0x002eb6f8, 0x002db5f7,
	0x002bb4f5, 0x002bb4f6, 0x002bb3f7, 0x002bb2f8, 0x002bb1f8, 0x0022aff9, 0x0019acfa, 0x001eadf7,
	0x0024aef3, 0x0020adf5, 0x001dabf6, 0x001fabf6, 0x0020aaf5, 0x001fa9f6, 0x001ea8f7, 0x001da6f7,
	0x001ca5f8, 0x001ca4f8, 0x001ba3f9, 0x001ba3f9, 0x001ba2f9, 0x0019a1f9, 0x0018a0f8, 0x0017a0f8,
	0x00169ff8, 0x00159ef7, 0x00149df7, 0x00139cf6, 0x00129bf5, 0x00129bf5, 0x00129bf5, 0x00129bf5,
	0x0055d0f9, 0x0053d0fa, 0x0051d0fa, 0x004fcffa, 0x004dcffa, 0x004bcefa, 0x0049cdf9, 0x0046ccf9,
	0x0044caf8, 0x0043caf8, 0x0043c9f8, 0x0043c8f9, 0x0042c8f9, 0x0042c7f9, 0x0041c6f9, 0x0041c6f9,
	0x0040c5fa, 0x003ec3f9, 0x003dc2fa, 0x003bc1fa, 0x0039c0fa, 0x0038bff9, 0x0036bff9, 0x0035bef9,
	0x0034bdf8, 0x0033bcf9, 0x0033bafa, 0x0032b9fb, 0x0032b8fc, 0x0030b7fa, 0x002eb6f8, 0x002db5f7,
	0x002bb4f5, 0x002bb4f6, 0x002bb3f7, 0x002bb2f8, 0x002bb1f8, 0x0022aff9, 0x0019acfa, 0x001eadf7,
	0x0024aef3, 0x0020adf5, 0x001dabf6, 0x001fabf6, 0x0020aaf5, 0x001fa9f6, 0x001ea8f7, 0x001da6f7,
	0x001ca5f8, 0x001ca4f8, 0x001ba3f9, 0x001ba3f9, 0x001ba2f9, 0x0019a1f9, 0x0018a0f8, 0x0017a0f8,
	0x00169ff8, 0x00159ef7, 0x00149df7, 0x00139cf6, 0x00129bf5, 0x00129bf5, 0x00129bf5, 0x00129bf5
};


#define IMG_WIDTH 64
#define IMG_HEIGHT 64
#define FORMAT_SIZE 4
#define FORMAT PIXEL_FORMAT_XRGB32

static INLINE size_t fuzzyCompare(BYTE b1, BYTE b2)
{
	if (b1 > b2)
		return b1 - b2;
	return b2 - b1;
}

static BOOL fuzzyCompareImage(const UINT32 *refImage, const BYTE *img, size_t npixels) {
	size_t i;
	size_t totalDelta = 0;

	for(i = 0; i < npixels; i++, refImage++)
	{
		BYTE A = *img++;
		BYTE R = *img++;
		BYTE G = *img++;
		BYTE B = *img++;
		size_t delta;

		if (A != 0x00)
			return FALSE;

		delta = fuzzyCompare(R, (*refImage & 0x00ff0000) >> 16);
		if (delta > 1)
			return FALSE;
		totalDelta += delta;

		delta = fuzzyCompare(G, (*refImage & 0x0000ff00) >> 8);
		if (delta > 1)
			return FALSE;
		totalDelta += delta;

		delta = fuzzyCompare(B, (*refImage & 0x0000ff));
		if (delta > 1)
			return FALSE;
		totalDelta += delta;
	}

	WLog_DBG("test", "totalDelta=%d (npixels=%d)", totalDelta, npixels);
	return TRUE;
}

int TestFreeRDPCodecRemoteFX(int argc, char* argv[])
{
	int rc = -1;
	REGION16 region = { 0 };
	RFX_CONTEXT* context = NULL;
	BYTE *dest = NULL;
	size_t stride = FORMAT_SIZE * IMG_WIDTH;

	context = rfx_context_new(FALSE);
	if (!context)
		goto fail;

	dest = calloc(IMG_WIDTH * IMG_HEIGHT, FORMAT_SIZE);
	if (!dest)
		goto fail;

	region16_init(&region);
	if (!rfx_process_message(context, encodeHeaderSample, sizeof(encodeHeaderSample), 0, 0, dest, FORMAT,
			stride, IMG_HEIGHT, &region))
		goto fail;

	region16_clear(&region);
	if(!rfx_process_message(context, encodeDataSample, sizeof(encodeDataSample), 0, 0, dest, FORMAT,
			stride, IMG_HEIGHT, &region))
		goto fail;
	region16_print(&region);

#if 0
	FILE *f = fopen("/tmp/windows.data", "w");
	fwrite(dest, IMG_WIDTH * IMG_HEIGHT, FORMAT_SIZE, f);
	fclose(f);
#endif

	if (!fuzzyCompareImage(refImage, dest, IMG_WIDTH * IMG_HEIGHT))
		goto fail;

	rc = 0;
fail:
	region16_uninit(&region);
	rfx_context_free(context);
	free(dest);
	return rc;
}
