#include "common.h"
#ifndef OPENSSL_NO_DH
#define DN_new DH_new
#ifndef HEADER_DH_H
# include <openssl/dh.h>
#endif

DH *get_dh2048()
{
    static unsigned char dhp_2048[] = {
	0xEF, 0xED, 0x5C, 0xA2, 0x8E, 0x37, 0xD8, 0xF4, 0xD1, 0xE9, 
	0x85, 0x06, 0x79, 0x0E, 0xC0, 0xBC, 0xD2, 0xF3, 0xBC, 0x26, 
	0xAE, 0x63, 0xB9, 0x06, 0xDF, 0x16, 0xDB, 0xE5, 0x76, 0x76, 
	0xD5, 0xBC, 0x4F, 0xC1, 0x55, 0x28, 0xC9, 0x7A, 0xC8, 0xD6, 
	0x1E, 0xB0, 0x5D, 0x85, 0x12, 0x39, 0x62, 0x06, 0x9D, 0x99, 
	0x4D, 0xCF, 0x79, 0x27, 0x94, 0xB6, 0xE1, 0xC2, 0x92, 0x06, 
	0xA3, 0xCF, 0x10, 0x25, 0xC4, 0x3D, 0x01, 0xD2, 0x34, 0x0C, 
	0x1F, 0xB2, 0xA3, 0x0D, 0xA8, 0xDC, 0xB6, 0x5F, 0xDB, 0x8C, 
	0xF6, 0x73, 0xC2, 0x07, 0x70, 0x4D, 0x01, 0x85, 0xE8, 0x49, 
	0xBC, 0xC1, 0x80, 0x6C, 0x77, 0x71, 0xFF, 0x5D, 0x25, 0x2F, 
	0x64, 0x5F, 0x0D, 0x33, 0xB3, 0x43, 0x24, 0xC0, 0xFC, 0xB3, 
	0x94, 0xEA, 0xF2, 0xB7, 0x24, 0x08, 0x12, 0x74, 0x9D, 0xEA, 
	0x20, 0x31, 0xD7, 0x0C, 0x0A, 0x84, 0x37, 0xCF, 0x34, 0x56, 
	0x85, 0xFB, 0xF4, 0x7C, 0xF4, 0x4E, 0x67, 0x0E, 0x63, 0xB2, 
	0x49, 0xAF, 0xA6, 0x43, 0xD3, 0x6E, 0x60, 0xA9, 0x96, 0xD6, 
	0xE8, 0x63, 0x7E, 0x23, 0x39, 0x91, 0xE1, 0xF6, 0xC3, 0x8B, 
	0x60, 0x92, 0x73, 0xB9, 0x5A, 0x69, 0xDF, 0x8A, 0xD4, 0x0E, 
	0x1C, 0x95, 0x82, 0x59, 0xE4, 0x3B, 0xA8, 0xAC, 0x46, 0x47, 
	0xE2, 0xFE, 0x98, 0xD7, 0xC2, 0xD4, 0xC6, 0x0A, 0xC5, 0x23, 
	0x98, 0xCA, 0x0C, 0x5A, 0x82, 0xE1, 0x17, 0xC8, 0xA4, 0x5C, 
	0x43, 0x2A, 0xE5, 0x5B, 0x20, 0x7C, 0x36, 0x90, 0x71, 0xB6, 
	0x02, 0x55, 0xF5, 0x26, 0x13, 0xCF, 0xB3, 0x4C, 0xB7, 0x89, 
	0x57, 0xC8, 0x27, 0x28, 0x72, 0x04, 0xF1, 0x78, 0x4B, 0xFF, 
	0xB3, 0x78, 0x60, 0x79, 0xEF, 0xDD, 0xDE, 0x34, 0x88, 0xE2, 
	0x00, 0x13, 0xED, 0x4B, 0x9F, 0xE7, 0x71, 0xBA, 0x68, 0xF6, 
	0xD2, 0x9E, 0xF3, 0x3B, 0x2D, 0x2B
    };
    static unsigned char dhg_2048[] = {
	0x02
    };
    DH *dh = DH_new();
    BIGNUM *dhp_bn, *dhg_bn;

    if (dh == NULL)
        return NULL;
    dhp_bn = BN_bin2bn(dhp_2048, sizeof (dhp_2048), NULL);
    dhg_bn = BN_bin2bn(dhg_2048, sizeof (dhg_2048), NULL);
    if (dhp_bn == NULL || dhg_bn == NULL
            || !DH_set0_pqg(dh, dhp_bn, NULL, dhg_bn)) {
        DH_free(dh);
        BN_free(dhp_bn);
        BN_free(dhg_bn);
        return NULL;
    }
    return dh;
}
#endif /* OPENSSL_NO_DH */
