
/*
 * DACS NTLM Authentication Tester
 * Copyright (C) 2018 Distributed Systems Software, Inc.
 *
 * It does not appear to be necessary to provide a workgroup or domain
 * parameter, but your mileage may vary.
 * This program and the DACS libdsm library have tested successfully against
 * accounts on Windows 10 and Windows Server 2012.
 */

/*
 * Copyright (c) 2003-2018
 * Distributed Systems Software.  All rights reserved.
 * See the file LICENSE for redistribution information.
 */

#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <pwd.h>
#include <unistd.h>
#include <string.h>
#include <stdlib.h>
#include <stdio.h>

#include <iconv.h>

#include "libdsm.h"
#include "src/smb_types.h"

#ifndef lint
static MAYBE_UNUSED const char copyright[] =
"Copyright (c) 2003-2018\n\
Distributed Systems Software.  All rights reserved.";
static MAYBE_UNUSED const char revid[] =
  "$Id: ntlmauth.c 2986 2018-01-26 00:26:30Z brachman $";
#endif

static int quiet_flag = 0;
static int verbose_flag = 0;

static inline MAYBE_UNUSED int
streq(const char *p, const char *q)
{

    return(strcmp(p, q) == 0);
}

static void
show_copyright(void)
{

  fprintf(stderr, "DACS NTLM Authentication Test\n");
  fprintf(stderr, "Copyright (C) 2018 Distributed Systems Software, Inc.\n");
  fprintf(stderr, "Built with: %s\n\n", libdsm_version_string());
}

static void
usage(void)
{

  if (!quiet_flag)
	show_copyright();

  fprintf(stderr,
		  "Usage: ntlmauth [-h] [-q] [-v] [-s server] [-u username] [-pw passwd] [-d domain] [-port #] [-w workgroup]\n");
}

int
main(int argc, char **argv)
{
  int i, port;
  char *password, *username;
  char *domain, *win_server_name, *workgroup;

  quiet_flag = 0;
  verbose_flag = 0;

  port = 0;
  domain = "";
  workgroup = "";
  username = NULL;
  password = NULL;

  /*
   * XXX For convenient testing, initialize this to your NTLM server's domain
   * name or IP address.
   */
  win_server_name = "10.0.0.128";

#ifdef NOTDEF
  domain = "BSD9";
  workgroup = "windmill-vm";
  workgroup = "WORKGROUP";
  username = "test";
  password = "test";
  username = "brachman";
  password = "bjbtest";
#endif

  i = 1;
  while (i < argc) {
	if (streq(argv[i], "-d") && argv[i + 1] != NULL) {
	  domain = argv[++i];
	  i++;
	}
	else if (streq(argv[i], "-h") || streq(argv[i], "--help")) {
	  usage();
	  exit(0);
	}
	else if (streq(argv[i], "-port") && argv[i + 1] != NULL) {
	  port = atoi(argv[++i]);
	  i++;
	}
	else if (streq(argv[i], "-pw") && argv[i + 1] != NULL) {
	  password = argv[++i];
	  i++;
	}
	else if (streq(argv[i], "-q")) {
	  quiet_flag++;
	  i++;
	}
	else if (streq(argv[i], "-s") && argv[i + 1] != NULL) {
	  win_server_name = argv[++i];
	  i++;
	}
	else if (streq(argv[i], "-u") && argv[i + 1] != NULL) {
	  username = argv[++i];
	  i++;
	}
	else if (streq(argv[i], "-v")) {
	  verbose_flag++;
	  i++;
	}
	else if (streq(argv[i], "-w") && argv[i + 1] != NULL) {
	  workgroup = argv[++i];
	  i++;
	}
	else {
	  usage();
	  exit(1);
	}
  }

  if (username != NULL && password != NULL)
	quiet_flag = 1;

  /* Override. */
  if (verbose_flag)
	quiet_flag = 0;

  if (!quiet_flag)
	  show_copyright();

  /* XXX A convenient default for testing... */
  if (username == NULL)
	username = "test";

  if (password == NULL) {
	char prompt[512];

	snprintf(prompt, sizeof(prompt), "NTLM password for username \"%s\"? ",
			 username);
	if ((password = getpass(prompt)) == NULL) {
	  /* XXX A convenient default for testing... */
	  password = "test";
	}
  }

  if (local_ntlm_auth_libdsm(username, password, NULL, port, win_server_name,
							 domain, workgroup, NULL, NULL) != 0) {
	exit(1);
  }

  exit(0);
}
