/* Copyright 2024 Advanced Micro Devices, Inc.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of this software and associated documentation files (the "Software"),
 * to deal in the Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, sublicense,
 * and/or sell copies of the Software, and to permit persons to whom the
 * Software is furnished to do so, subject to the following conditions:
 *
 * The above copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
 * THE COPYRIGHT HOLDER(S) OR AUTHOR(S) BE LIABLE FOR ANY CLAIM, DAMAGES OR
 * OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
 * ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
 * OTHER DEALINGS IN THE SOFTWARE.
 *
 * Authors: AMD
 *
 */
// Headers from LSDp CL1744173
#ifndef _vpe_6_1_0_OFFSET_HEADER
#define _vpe_6_1_0_OFFSET_HEADER



// addressBlock: vpe_vpedec
// base address: 0x46000
#define regVPEC_DEC_START                                                                               0x0000
#define regVPEC_DEC_START_BASE_IDX                                                                      0
#define regVPEC_UCODE_ADDR                                                                              0x0001
#define regVPEC_UCODE_ADDR_BASE_IDX                                                                     0
#define regVPEC_UCODE_DATA                                                                              0x0002
#define regVPEC_UCODE_DATA_BASE_IDX                                                                     0
#define regVPEC_F32_CNTL                                                                                0x0003
#define regVPEC_F32_CNTL_BASE_IDX                                                                       0
#define regVPEC_MMHUB_CNTL                                                                              0x0004
#define regVPEC_MMHUB_CNTL_BASE_IDX                                                                     0
#define regVPEC_MMHUB_TRUSTLVL                                                                          0x0005
#define regVPEC_MMHUB_TRUSTLVL_BASE_IDX                                                                 0
#define regVPEC_VPEP_CTRL                                                                               0x0010
#define regVPEC_VPEP_CTRL_BASE_IDX                                                                      0
#define regVPEC_CLK_CTRL                                                                                0x0011
#define regVPEC_CLK_CTRL_BASE_IDX                                                                       0
#define regVPEC_PG_CNTL                                                                                 0x0012
#define regVPEC_PG_CNTL_BASE_IDX                                                                        0
#define regVPEC_POWER_CNTL                                                                              0x0013
#define regVPEC_POWER_CNTL_BASE_IDX                                                                     0
#define regVPEC_CNTL                                                                                    0x0014
#define regVPEC_CNTL_BASE_IDX                                                                           0
#define regVPEC_CNTL1                                                                                   0x0015
#define regVPEC_CNTL1_BASE_IDX                                                                          0
#define regVPEC_CNTL2                                                                                   0x0016
#define regVPEC_CNTL2_BASE_IDX                                                                          0
#define regVPEC_GB_ADDR_CONFIG                                                                          0x0017
#define regVPEC_GB_ADDR_CONFIG_BASE_IDX                                                                 0
#define regVPEC_GB_ADDR_CONFIG_READ                                                                     0x0018
#define regVPEC_GB_ADDR_CONFIG_READ_BASE_IDX                                                            0
#define regVPEC_PROCESS_QUANTUM0                                                                        0x0019
#define regVPEC_PROCESS_QUANTUM0_BASE_IDX                                                               0
#define regVPEC_PROCESS_QUANTUM1                                                                        0x001a
#define regVPEC_PROCESS_QUANTUM1_BASE_IDX                                                               0
#define regVPEC_CONTEXT_SWITCH_THRESHOLD                                                                0x001b
#define regVPEC_CONTEXT_SWITCH_THRESHOLD_BASE_IDX                                                       0
#define regVPEC_GLOBAL_QUANTUM                                                                          0x001c
#define regVPEC_GLOBAL_QUANTUM_BASE_IDX                                                                 0
#define regVPEC_WATCHDOG_CNTL                                                                           0x001d
#define regVPEC_WATCHDOG_CNTL_BASE_IDX                                                                  0
#define regVPEC_ATOMIC_CNTL                                                                             0x001e
#define regVPEC_ATOMIC_CNTL_BASE_IDX                                                                    0
#define regVPEC_UCODE_VERSION                                                                           0x001f
#define regVPEC_UCODE_VERSION_BASE_IDX                                                                  0
#define regVPEC_MEMREQ_BURST_CNTL                                                                       0x0020
#define regVPEC_MEMREQ_BURST_CNTL_BASE_IDX                                                              0
#define regVPEC_TIMESTAMP_CNTL                                                                          0x0021
#define regVPEC_TIMESTAMP_CNTL_BASE_IDX                                                                 0
#define regVPEC_GLOBAL_TIMESTAMP_LO                                                                     0x0022
#define regVPEC_GLOBAL_TIMESTAMP_LO_BASE_IDX                                                            0
#define regVPEC_GLOBAL_TIMESTAMP_HI                                                                     0x0023
#define regVPEC_GLOBAL_TIMESTAMP_HI_BASE_IDX                                                            0
#define regVPEC_FREEZE                                                                                  0x0024
#define regVPEC_FREEZE_BASE_IDX                                                                         0
#define regVPEC_CE_CTRL                                                                                 0x0025
#define regVPEC_CE_CTRL_BASE_IDX                                                                        0
#define regVPEC_RELAX_ORDERING_LUT                                                                      0x0026
#define regVPEC_RELAX_ORDERING_LUT_BASE_IDX                                                             0
#define regVPEC_CREDIT_CNTL                                                                             0x0027
#define regVPEC_CREDIT_CNTL_BASE_IDX                                                                    0
#define regVPEC_SCRATCH_RAM_DATA                                                                        0x0028
#define regVPEC_SCRATCH_RAM_DATA_BASE_IDX                                                               0
#define regVPEC_SCRATCH_RAM_ADDR                                                                        0x0029
#define regVPEC_SCRATCH_RAM_ADDR_BASE_IDX                                                               0
#define regVPEC_QUEUE_RESET_REQ                                                                         0x002a
#define regVPEC_QUEUE_RESET_REQ_BASE_IDX                                                                0
#define regVPEC_PERFCNT_PERFCOUNTER0_CFG                                                                0x002b
#define regVPEC_PERFCNT_PERFCOUNTER0_CFG_BASE_IDX                                                       0
#define regVPEC_PERFCNT_PERFCOUNTER1_CFG                                                                0x002c
#define regVPEC_PERFCNT_PERFCOUNTER1_CFG_BASE_IDX                                                       0
#define regVPEC_PERFCNT_PERFCOUNTER_RSLT_CNTL                                                           0x002d
#define regVPEC_PERFCNT_PERFCOUNTER_RSLT_CNTL_BASE_IDX                                                  0
#define regVPEC_PERFCNT_MISC_CNTL                                                                       0x002e
#define regVPEC_PERFCNT_MISC_CNTL_BASE_IDX                                                              0
#define regVPEC_PERFCNT_PERFCOUNTER_LO                                                                  0x002f
#define regVPEC_PERFCNT_PERFCOUNTER_LO_BASE_IDX                                                         0
#define regVPEC_PERFCNT_PERFCOUNTER_HI                                                                  0x0030
#define regVPEC_PERFCNT_PERFCOUNTER_HI_BASE_IDX                                                         0
#define regVPEC_DEBUG_INDEX                                                                             0x0031
#define regVPEC_DEBUG_INDEX_BASE_IDX                                                                    0
#define regVPEC_DEBUG_DATA                                                                              0x0032
#define regVPEC_DEBUG_DATA_BASE_IDX                                                                     0
#define regVPEC_CRC_CTRL                                                                                0x0033
#define regVPEC_CRC_CTRL_BASE_IDX                                                                       0
#define regVPEC_CRC_DATA                                                                                0x0034
#define regVPEC_CRC_DATA_BASE_IDX                                                                       0
#define regVPEC_PUB_DUMMY0                                                                              0x0035
#define regVPEC_PUB_DUMMY0_BASE_IDX                                                                     0
#define regVPEC_PUB_DUMMY1                                                                              0x0036
#define regVPEC_PUB_DUMMY1_BASE_IDX                                                                     0
#define regVPEC_PUB_DUMMY2                                                                              0x0037
#define regVPEC_PUB_DUMMY2_BASE_IDX                                                                     0
#define regVPEC_PUB_DUMMY3                                                                              0x0038
#define regVPEC_PUB_DUMMY3_BASE_IDX                                                                     0
#define regVPEC_PUB_DUMMY4                                                                              0x0039
#define regVPEC_PUB_DUMMY4_BASE_IDX                                                                     0
#define regVPEC_PUB_DUMMY5                                                                              0x003a
#define regVPEC_PUB_DUMMY5_BASE_IDX                                                                     0
#define regVPEC_PUB_DUMMY6                                                                              0x003b
#define regVPEC_PUB_DUMMY6_BASE_IDX                                                                     0
#define regVPEC_PUB_DUMMY7                                                                              0x003c
#define regVPEC_PUB_DUMMY7_BASE_IDX                                                                     0
#define regVPEC_UCODE1_CHECKSUM                                                                         0x0040
#define regVPEC_UCODE1_CHECKSUM_BASE_IDX                                                                0
#define regVPEC_VERSION                                                                                 0x0041
#define regVPEC_VERSION_BASE_IDX                                                                        0
#define regVPEC_UCODE_CHECKSUM                                                                          0x0042
#define regVPEC_UCODE_CHECKSUM_BASE_IDX                                                                 0
#define regVPEC_CLOCK_GATING_STATUS                                                                     0x0043
#define regVPEC_CLOCK_GATING_STATUS_BASE_IDX                                                            0
#define regVPEC_RB_RPTR_FETCH                                                                           0x0044
#define regVPEC_RB_RPTR_FETCH_BASE_IDX                                                                  0
#define regVPEC_RB_RPTR_FETCH_HI                                                                        0x0045
#define regVPEC_RB_RPTR_FETCH_HI_BASE_IDX                                                               0
#define regVPEC_IB_OFFSET_FETCH                                                                         0x0046
#define regVPEC_IB_OFFSET_FETCH_BASE_IDX                                                                0
#define regVPEC_CMDIB_OFFSET_FETCH                                                                      0x0047
#define regVPEC_CMDIB_OFFSET_FETCH_BASE_IDX                                                             0
#define regVPEC_ATOMIC_PREOP_LO                                                                         0x0048
#define regVPEC_ATOMIC_PREOP_LO_BASE_IDX                                                                0
#define regVPEC_ATOMIC_PREOP_HI                                                                         0x0049
#define regVPEC_ATOMIC_PREOP_HI_BASE_IDX                                                                0
#define regVPEC_CE_BUSY                                                                                 0x004a
#define regVPEC_CE_BUSY_BASE_IDX                                                                        0
#define regVPEC_F32_COUNTER                                                                             0x004b
#define regVPEC_F32_COUNTER_BASE_IDX                                                                    0
#define regVPEC_HOLE_ADDR_LO                                                                            0x004c
#define regVPEC_HOLE_ADDR_LO_BASE_IDX                                                                   0
#define regVPEC_HOLE_ADDR_HI                                                                            0x004d
#define regVPEC_HOLE_ADDR_HI_BASE_IDX                                                                   0
#define regVPEC_ERROR_LOG                                                                               0x004e
#define regVPEC_ERROR_LOG_BASE_IDX                                                                      0
#define regVPEC_INT_STATUS                                                                              0x004f
#define regVPEC_INT_STATUS_BASE_IDX                                                                     0
#define regVPEC_STATUS                                                                                  0x0050
#define regVPEC_STATUS_BASE_IDX                                                                         0
#define regVPEC_STATUS1                                                                                 0x0051
#define regVPEC_STATUS1_BASE_IDX                                                                        0
#define regVPEC_STATUS2                                                                                 0x0052
#define regVPEC_STATUS2_BASE_IDX                                                                        0
#define regVPEC_STATUS3                                                                                 0x0053
#define regVPEC_STATUS3_BASE_IDX                                                                        0
#define regVPEC_STATUS4                                                                                 0x0054
#define regVPEC_STATUS4_BASE_IDX                                                                        0
#define regVPEC_STATUS5                                                                                 0x0055
#define regVPEC_STATUS5_BASE_IDX                                                                        0
#define regVPEC_STATUS6                                                                                 0x0056
#define regVPEC_STATUS6_BASE_IDX                                                                        0
#define regVPEC_STATUS7                                                                                 0x0057
#define regVPEC_STATUS7_BASE_IDX                                                                        0
#define regVPEC_INST                                                                                    0x0058
#define regVPEC_INST_BASE_IDX                                                                           0
#define regVPEC_QUEUE_STATUS0                                                                           0x0059
#define regVPEC_QUEUE_STATUS0_BASE_IDX                                                                  0
#define regVPEC_QUEUE_HANG_STATUS                                                                       0x005a
#define regVPEC_QUEUE_HANG_STATUS_BASE_IDX                                                              0
#define regVPEC_QUEUE0_RB_CNTL                                                                          0x0080
#define regVPEC_QUEUE0_RB_CNTL_BASE_IDX                                                                 0
#define regVPEC_QUEUE0_SCHEDULE_CNTL                                                                    0x0081
#define regVPEC_QUEUE0_SCHEDULE_CNTL_BASE_IDX                                                           0
#define regVPEC_QUEUE0_RB_BASE                                                                          0x0082
#define regVPEC_QUEUE0_RB_BASE_BASE_IDX                                                                 0
#define regVPEC_QUEUE0_RB_BASE_HI                                                                       0x0083
#define regVPEC_QUEUE0_RB_BASE_HI_BASE_IDX                                                              0
#define regVPEC_QUEUE0_RB_RPTR                                                                          0x0084
#define regVPEC_QUEUE0_RB_RPTR_BASE_IDX                                                                 0
#define regVPEC_QUEUE0_RB_RPTR_HI                                                                       0x0085
#define regVPEC_QUEUE0_RB_RPTR_HI_BASE_IDX                                                              0
#define regVPEC_QUEUE0_RB_WPTR                                                                          0x0086
#define regVPEC_QUEUE0_RB_WPTR_BASE_IDX                                                                 0
#define regVPEC_QUEUE0_RB_WPTR_HI                                                                       0x0087
#define regVPEC_QUEUE0_RB_WPTR_HI_BASE_IDX                                                              0
#define regVPEC_QUEUE0_RB_RPTR_ADDR_HI                                                                  0x0088
#define regVPEC_QUEUE0_RB_RPTR_ADDR_HI_BASE_IDX                                                         0
#define regVPEC_QUEUE0_RB_RPTR_ADDR_LO                                                                  0x0089
#define regVPEC_QUEUE0_RB_RPTR_ADDR_LO_BASE_IDX                                                         0
#define regVPEC_QUEUE0_RB_AQL_CNTL                                                                      0x008a
#define regVPEC_QUEUE0_RB_AQL_CNTL_BASE_IDX                                                             0
#define regVPEC_QUEUE0_MINOR_PTR_UPDATE                                                                 0x008b
#define regVPEC_QUEUE0_MINOR_PTR_UPDATE_BASE_IDX                                                        0
#define regVPEC_QUEUE0_CD_INFO                                                                          0x008c
#define regVPEC_QUEUE0_CD_INFO_BASE_IDX                                                                 0
#define regVPEC_QUEUE0_RB_PREEMPT                                                                       0x008d
#define regVPEC_QUEUE0_RB_PREEMPT_BASE_IDX                                                              0
#define regVPEC_QUEUE0_SKIP_CNTL                                                                        0x008e
#define regVPEC_QUEUE0_SKIP_CNTL_BASE_IDX                                                               0
#define regVPEC_QUEUE0_DOORBELL                                                                         0x008f
#define regVPEC_QUEUE0_DOORBELL_BASE_IDX                                                                0
#define regVPEC_QUEUE0_DOORBELL_OFFSET                                                                  0x0090
#define regVPEC_QUEUE0_DOORBELL_OFFSET_BASE_IDX                                                         0
#define regVPEC_QUEUE0_DUMMY0                                                                           0x0091
#define regVPEC_QUEUE0_DUMMY0_BASE_IDX                                                                  0
#define regVPEC_QUEUE0_DUMMY1                                                                           0x0092
#define regVPEC_QUEUE0_DUMMY1_BASE_IDX                                                                  0
#define regVPEC_QUEUE0_DUMMY2                                                                           0x0093
#define regVPEC_QUEUE0_DUMMY2_BASE_IDX                                                                  0
#define regVPEC_QUEUE0_DUMMY3                                                                           0x0094
#define regVPEC_QUEUE0_DUMMY3_BASE_IDX                                                                  0
#define regVPEC_QUEUE0_DUMMY4                                                                           0x0095
#define regVPEC_QUEUE0_DUMMY4_BASE_IDX                                                                  0
#define regVPEC_QUEUE0_IB_CNTL                                                                          0x00ac
#define regVPEC_QUEUE0_IB_CNTL_BASE_IDX                                                                 0
#define regVPEC_QUEUE0_IB_RPTR                                                                          0x00ad
#define regVPEC_QUEUE0_IB_RPTR_BASE_IDX                                                                 0
#define regVPEC_QUEUE0_IB_OFFSET                                                                        0x00ae
#define regVPEC_QUEUE0_IB_OFFSET_BASE_IDX                                                               0
#define regVPEC_QUEUE0_IB_BASE_LO                                                                       0x00af
#define regVPEC_QUEUE0_IB_BASE_LO_BASE_IDX                                                              0
#define regVPEC_QUEUE0_IB_BASE_HI                                                                       0x00b0
#define regVPEC_QUEUE0_IB_BASE_HI_BASE_IDX                                                              0
#define regVPEC_QUEUE0_IB_SIZE                                                                          0x00b1
#define regVPEC_QUEUE0_IB_SIZE_BASE_IDX                                                                 0
#define regVPEC_QUEUE0_CMDIB_CNTL                                                                       0x00b2
#define regVPEC_QUEUE0_CMDIB_CNTL_BASE_IDX                                                              0
#define regVPEC_QUEUE0_CMDIB_RPTR                                                                       0x00b3
#define regVPEC_QUEUE0_CMDIB_RPTR_BASE_IDX                                                              0
#define regVPEC_QUEUE0_CMDIB_OFFSET                                                                     0x00b4
#define regVPEC_QUEUE0_CMDIB_OFFSET_BASE_IDX                                                            0
#define regVPEC_QUEUE0_CMDIB_BASE_LO                                                                    0x00b5
#define regVPEC_QUEUE0_CMDIB_BASE_LO_BASE_IDX                                                           0
#define regVPEC_QUEUE0_CMDIB_BASE_HI                                                                    0x00b6
#define regVPEC_QUEUE0_CMDIB_BASE_HI_BASE_IDX                                                           0
#define regVPEC_QUEUE0_CMDIB_SIZE                                                                       0x00b7
#define regVPEC_QUEUE0_CMDIB_SIZE_BASE_IDX                                                              0
#define regVPEC_QUEUE0_CSA_ADDR_LO                                                                      0x00b8
#define regVPEC_QUEUE0_CSA_ADDR_LO_BASE_IDX                                                             0
#define regVPEC_QUEUE0_CSA_ADDR_HI                                                                      0x00b9
#define regVPEC_QUEUE0_CSA_ADDR_HI_BASE_IDX                                                             0
#define regVPEC_QUEUE0_CONTEXT_STATUS                                                                   0x00ba
#define regVPEC_QUEUE0_CONTEXT_STATUS_BASE_IDX                                                          0
#define regVPEC_QUEUE0_DOORBELL_LOG                                                                     0x00bb
#define regVPEC_QUEUE0_DOORBELL_LOG_BASE_IDX                                                            0
#define regVPEC_QUEUE0_IB_SUB_REMAIN                                                                    0x00bc
#define regVPEC_QUEUE0_IB_SUB_REMAIN_BASE_IDX                                                           0
#define regVPEC_QUEUE0_PREEMPT                                                                          0x00bd
#define regVPEC_QUEUE0_PREEMPT_BASE_IDX                                                                 0
#define regVPEC_QUEUE1_RB_CNTL                                                                          0x00d8
#define regVPEC_QUEUE1_RB_CNTL_BASE_IDX                                                                 0
#define regVPEC_QUEUE1_SCHEDULE_CNTL                                                                    0x00d9
#define regVPEC_QUEUE1_SCHEDULE_CNTL_BASE_IDX                                                           0
#define regVPEC_QUEUE1_RB_BASE                                                                          0x00da
#define regVPEC_QUEUE1_RB_BASE_BASE_IDX                                                                 0
#define regVPEC_QUEUE1_RB_BASE_HI                                                                       0x00db
#define regVPEC_QUEUE1_RB_BASE_HI_BASE_IDX                                                              0
#define regVPEC_QUEUE1_RB_RPTR                                                                          0x00dc
#define regVPEC_QUEUE1_RB_RPTR_BASE_IDX                                                                 0
#define regVPEC_QUEUE1_RB_RPTR_HI                                                                       0x00dd
#define regVPEC_QUEUE1_RB_RPTR_HI_BASE_IDX                                                              0
#define regVPEC_QUEUE1_RB_WPTR                                                                          0x00de
#define regVPEC_QUEUE1_RB_WPTR_BASE_IDX                                                                 0
#define regVPEC_QUEUE1_RB_WPTR_HI                                                                       0x00df
#define regVPEC_QUEUE1_RB_WPTR_HI_BASE_IDX                                                              0
#define regVPEC_QUEUE1_RB_RPTR_ADDR_HI                                                                  0x00e0
#define regVPEC_QUEUE1_RB_RPTR_ADDR_HI_BASE_IDX                                                         0
#define regVPEC_QUEUE1_RB_RPTR_ADDR_LO                                                                  0x00e1
#define regVPEC_QUEUE1_RB_RPTR_ADDR_LO_BASE_IDX                                                         0
#define regVPEC_QUEUE1_RB_AQL_CNTL                                                                      0x00e2
#define regVPEC_QUEUE1_RB_AQL_CNTL_BASE_IDX                                                             0
#define regVPEC_QUEUE1_MINOR_PTR_UPDATE                                                                 0x00e3
#define regVPEC_QUEUE1_MINOR_PTR_UPDATE_BASE_IDX                                                        0
#define regVPEC_QUEUE1_CD_INFO                                                                          0x00e4
#define regVPEC_QUEUE1_CD_INFO_BASE_IDX                                                                 0
#define regVPEC_QUEUE1_RB_PREEMPT                                                                       0x00e5
#define regVPEC_QUEUE1_RB_PREEMPT_BASE_IDX                                                              0
#define regVPEC_QUEUE1_SKIP_CNTL                                                                        0x00e6
#define regVPEC_QUEUE1_SKIP_CNTL_BASE_IDX                                                               0
#define regVPEC_QUEUE1_DOORBELL                                                                         0x00e7
#define regVPEC_QUEUE1_DOORBELL_BASE_IDX                                                                0
#define regVPEC_QUEUE1_DOORBELL_OFFSET                                                                  0x00e8
#define regVPEC_QUEUE1_DOORBELL_OFFSET_BASE_IDX                                                         0
#define regVPEC_QUEUE1_DUMMY0                                                                           0x00e9
#define regVPEC_QUEUE1_DUMMY0_BASE_IDX                                                                  0
#define regVPEC_QUEUE1_DUMMY1                                                                           0x00ea
#define regVPEC_QUEUE1_DUMMY1_BASE_IDX                                                                  0
#define regVPEC_QUEUE1_DUMMY2                                                                           0x00eb
#define regVPEC_QUEUE1_DUMMY2_BASE_IDX                                                                  0
#define regVPEC_QUEUE1_DUMMY3                                                                           0x00ec
#define regVPEC_QUEUE1_DUMMY3_BASE_IDX                                                                  0
#define regVPEC_QUEUE1_DUMMY4                                                                           0x00ed
#define regVPEC_QUEUE1_DUMMY4_BASE_IDX                                                                  0
#define regVPEC_QUEUE1_IB_CNTL                                                                          0x0104
#define regVPEC_QUEUE1_IB_CNTL_BASE_IDX                                                                 0
#define regVPEC_QUEUE1_IB_RPTR                                                                          0x0105
#define regVPEC_QUEUE1_IB_RPTR_BASE_IDX                                                                 0
#define regVPEC_QUEUE1_IB_OFFSET                                                                        0x0106
#define regVPEC_QUEUE1_IB_OFFSET_BASE_IDX                                                               0
#define regVPEC_QUEUE1_IB_BASE_LO                                                                       0x0107
#define regVPEC_QUEUE1_IB_BASE_LO_BASE_IDX                                                              0
#define regVPEC_QUEUE1_IB_BASE_HI                                                                       0x0108
#define regVPEC_QUEUE1_IB_BASE_HI_BASE_IDX                                                              0
#define regVPEC_QUEUE1_IB_SIZE                                                                          0x0109
#define regVPEC_QUEUE1_IB_SIZE_BASE_IDX                                                                 0
#define regVPEC_QUEUE1_CMDIB_CNTL                                                                       0x010a
#define regVPEC_QUEUE1_CMDIB_CNTL_BASE_IDX                                                              0
#define regVPEC_QUEUE1_CMDIB_RPTR                                                                       0x010b
#define regVPEC_QUEUE1_CMDIB_RPTR_BASE_IDX                                                              0
#define regVPEC_QUEUE1_CMDIB_OFFSET                                                                     0x010c
#define regVPEC_QUEUE1_CMDIB_OFFSET_BASE_IDX                                                            0
#define regVPEC_QUEUE1_CMDIB_BASE_LO                                                                    0x010d
#define regVPEC_QUEUE1_CMDIB_BASE_LO_BASE_IDX                                                           0
#define regVPEC_QUEUE1_CMDIB_BASE_HI                                                                    0x010e
#define regVPEC_QUEUE1_CMDIB_BASE_HI_BASE_IDX                                                           0
#define regVPEC_QUEUE1_CMDIB_SIZE                                                                       0x010f
#define regVPEC_QUEUE1_CMDIB_SIZE_BASE_IDX                                                              0
#define regVPEC_QUEUE1_CSA_ADDR_LO                                                                      0x0110
#define regVPEC_QUEUE1_CSA_ADDR_LO_BASE_IDX                                                             0
#define regVPEC_QUEUE1_CSA_ADDR_HI                                                                      0x0111
#define regVPEC_QUEUE1_CSA_ADDR_HI_BASE_IDX                                                             0
#define regVPEC_QUEUE1_CONTEXT_STATUS                                                                   0x0112
#define regVPEC_QUEUE1_CONTEXT_STATUS_BASE_IDX                                                          0
#define regVPEC_QUEUE1_DOORBELL_LOG                                                                     0x0113
#define regVPEC_QUEUE1_DOORBELL_LOG_BASE_IDX                                                            0
#define regVPEC_QUEUE1_IB_SUB_REMAIN                                                                    0x0114
#define regVPEC_QUEUE1_IB_SUB_REMAIN_BASE_IDX                                                           0
#define regVPEC_QUEUE1_PREEMPT                                                                          0x0115
#define regVPEC_QUEUE1_PREEMPT_BASE_IDX                                                                 0
#define regVPEC_QUEUE2_RB_CNTL                                                                          0x0130
#define regVPEC_QUEUE2_RB_CNTL_BASE_IDX                                                                 0
#define regVPEC_QUEUE2_SCHEDULE_CNTL                                                                    0x0131
#define regVPEC_QUEUE2_SCHEDULE_CNTL_BASE_IDX                                                           0
#define regVPEC_QUEUE2_RB_BASE                                                                          0x0132
#define regVPEC_QUEUE2_RB_BASE_BASE_IDX                                                                 0
#define regVPEC_QUEUE2_RB_BASE_HI                                                                       0x0133
#define regVPEC_QUEUE2_RB_BASE_HI_BASE_IDX                                                              0
#define regVPEC_QUEUE2_RB_RPTR                                                                          0x0134
#define regVPEC_QUEUE2_RB_RPTR_BASE_IDX                                                                 0
#define regVPEC_QUEUE2_RB_RPTR_HI                                                                       0x0135
#define regVPEC_QUEUE2_RB_RPTR_HI_BASE_IDX                                                              0
#define regVPEC_QUEUE2_RB_WPTR                                                                          0x0136
#define regVPEC_QUEUE2_RB_WPTR_BASE_IDX                                                                 0
#define regVPEC_QUEUE2_RB_WPTR_HI                                                                       0x0137
#define regVPEC_QUEUE2_RB_WPTR_HI_BASE_IDX                                                              0
#define regVPEC_QUEUE2_RB_RPTR_ADDR_HI                                                                  0x0138
#define regVPEC_QUEUE2_RB_RPTR_ADDR_HI_BASE_IDX                                                         0
#define regVPEC_QUEUE2_RB_RPTR_ADDR_LO                                                                  0x0139
#define regVPEC_QUEUE2_RB_RPTR_ADDR_LO_BASE_IDX                                                         0
#define regVPEC_QUEUE2_RB_AQL_CNTL                                                                      0x013a
#define regVPEC_QUEUE2_RB_AQL_CNTL_BASE_IDX                                                             0
#define regVPEC_QUEUE2_MINOR_PTR_UPDATE                                                                 0x013b
#define regVPEC_QUEUE2_MINOR_PTR_UPDATE_BASE_IDX                                                        0
#define regVPEC_QUEUE2_CD_INFO                                                                          0x013c
#define regVPEC_QUEUE2_CD_INFO_BASE_IDX                                                                 0
#define regVPEC_QUEUE2_RB_PREEMPT                                                                       0x013d
#define regVPEC_QUEUE2_RB_PREEMPT_BASE_IDX                                                              0
#define regVPEC_QUEUE2_SKIP_CNTL                                                                        0x013e
#define regVPEC_QUEUE2_SKIP_CNTL_BASE_IDX                                                               0
#define regVPEC_QUEUE2_DOORBELL                                                                         0x013f
#define regVPEC_QUEUE2_DOORBELL_BASE_IDX                                                                0
#define regVPEC_QUEUE2_DOORBELL_OFFSET                                                                  0x0140
#define regVPEC_QUEUE2_DOORBELL_OFFSET_BASE_IDX                                                         0
#define regVPEC_QUEUE2_DUMMY0                                                                           0x0141
#define regVPEC_QUEUE2_DUMMY0_BASE_IDX                                                                  0
#define regVPEC_QUEUE2_DUMMY1                                                                           0x0142
#define regVPEC_QUEUE2_DUMMY1_BASE_IDX                                                                  0
#define regVPEC_QUEUE2_DUMMY2                                                                           0x0143
#define regVPEC_QUEUE2_DUMMY2_BASE_IDX                                                                  0
#define regVPEC_QUEUE2_DUMMY3                                                                           0x0144
#define regVPEC_QUEUE2_DUMMY3_BASE_IDX                                                                  0
#define regVPEC_QUEUE2_DUMMY4                                                                           0x0145
#define regVPEC_QUEUE2_DUMMY4_BASE_IDX                                                                  0
#define regVPEC_QUEUE2_IB_CNTL                                                                          0x015c
#define regVPEC_QUEUE2_IB_CNTL_BASE_IDX                                                                 0
#define regVPEC_QUEUE2_IB_RPTR                                                                          0x015d
#define regVPEC_QUEUE2_IB_RPTR_BASE_IDX                                                                 0
#define regVPEC_QUEUE2_IB_OFFSET                                                                        0x015e
#define regVPEC_QUEUE2_IB_OFFSET_BASE_IDX                                                               0
#define regVPEC_QUEUE2_IB_BASE_LO                                                                       0x015f
#define regVPEC_QUEUE2_IB_BASE_LO_BASE_IDX                                                              0
#define regVPEC_QUEUE2_IB_BASE_HI                                                                       0x0160
#define regVPEC_QUEUE2_IB_BASE_HI_BASE_IDX                                                              0
#define regVPEC_QUEUE2_IB_SIZE                                                                          0x0161
#define regVPEC_QUEUE2_IB_SIZE_BASE_IDX                                                                 0
#define regVPEC_QUEUE2_CMDIB_CNTL                                                                       0x0162
#define regVPEC_QUEUE2_CMDIB_CNTL_BASE_IDX                                                              0
#define regVPEC_QUEUE2_CMDIB_RPTR                                                                       0x0163
#define regVPEC_QUEUE2_CMDIB_RPTR_BASE_IDX                                                              0
#define regVPEC_QUEUE2_CMDIB_OFFSET                                                                     0x0164
#define regVPEC_QUEUE2_CMDIB_OFFSET_BASE_IDX                                                            0
#define regVPEC_QUEUE2_CMDIB_BASE_LO                                                                    0x0165
#define regVPEC_QUEUE2_CMDIB_BASE_LO_BASE_IDX                                                           0
#define regVPEC_QUEUE2_CMDIB_BASE_HI                                                                    0x0166
#define regVPEC_QUEUE2_CMDIB_BASE_HI_BASE_IDX                                                           0
#define regVPEC_QUEUE2_CMDIB_SIZE                                                                       0x0167
#define regVPEC_QUEUE2_CMDIB_SIZE_BASE_IDX                                                              0
#define regVPEC_QUEUE2_CSA_ADDR_LO                                                                      0x0168
#define regVPEC_QUEUE2_CSA_ADDR_LO_BASE_IDX                                                             0
#define regVPEC_QUEUE2_CSA_ADDR_HI                                                                      0x0169
#define regVPEC_QUEUE2_CSA_ADDR_HI_BASE_IDX                                                             0
#define regVPEC_QUEUE2_CONTEXT_STATUS                                                                   0x016a
#define regVPEC_QUEUE2_CONTEXT_STATUS_BASE_IDX                                                          0
#define regVPEC_QUEUE2_DOORBELL_LOG                                                                     0x016b
#define regVPEC_QUEUE2_DOORBELL_LOG_BASE_IDX                                                            0
#define regVPEC_QUEUE2_IB_SUB_REMAIN                                                                    0x016c
#define regVPEC_QUEUE2_IB_SUB_REMAIN_BASE_IDX                                                           0
#define regVPEC_QUEUE2_PREEMPT                                                                          0x016d
#define regVPEC_QUEUE2_PREEMPT_BASE_IDX                                                                 0
#define regVPEC_QUEUE3_RB_CNTL                                                                          0x0188
#define regVPEC_QUEUE3_RB_CNTL_BASE_IDX                                                                 0
#define regVPEC_QUEUE3_SCHEDULE_CNTL                                                                    0x0189
#define regVPEC_QUEUE3_SCHEDULE_CNTL_BASE_IDX                                                           0
#define regVPEC_QUEUE3_RB_BASE                                                                          0x018a
#define regVPEC_QUEUE3_RB_BASE_BASE_IDX                                                                 0
#define regVPEC_QUEUE3_RB_BASE_HI                                                                       0x018b
#define regVPEC_QUEUE3_RB_BASE_HI_BASE_IDX                                                              0
#define regVPEC_QUEUE3_RB_RPTR                                                                          0x018c
#define regVPEC_QUEUE3_RB_RPTR_BASE_IDX                                                                 0
#define regVPEC_QUEUE3_RB_RPTR_HI                                                                       0x018d
#define regVPEC_QUEUE3_RB_RPTR_HI_BASE_IDX                                                              0
#define regVPEC_QUEUE3_RB_WPTR                                                                          0x018e
#define regVPEC_QUEUE3_RB_WPTR_BASE_IDX                                                                 0
#define regVPEC_QUEUE3_RB_WPTR_HI                                                                       0x018f
#define regVPEC_QUEUE3_RB_WPTR_HI_BASE_IDX                                                              0
#define regVPEC_QUEUE3_RB_RPTR_ADDR_HI                                                                  0x0190
#define regVPEC_QUEUE3_RB_RPTR_ADDR_HI_BASE_IDX                                                         0
#define regVPEC_QUEUE3_RB_RPTR_ADDR_LO                                                                  0x0191
#define regVPEC_QUEUE3_RB_RPTR_ADDR_LO_BASE_IDX                                                         0
#define regVPEC_QUEUE3_RB_AQL_CNTL                                                                      0x0192
#define regVPEC_QUEUE3_RB_AQL_CNTL_BASE_IDX                                                             0
#define regVPEC_QUEUE3_MINOR_PTR_UPDATE                                                                 0x0193
#define regVPEC_QUEUE3_MINOR_PTR_UPDATE_BASE_IDX                                                        0
#define regVPEC_QUEUE3_CD_INFO                                                                          0x0194
#define regVPEC_QUEUE3_CD_INFO_BASE_IDX                                                                 0
#define regVPEC_QUEUE3_RB_PREEMPT                                                                       0x0195
#define regVPEC_QUEUE3_RB_PREEMPT_BASE_IDX                                                              0
#define regVPEC_QUEUE3_SKIP_CNTL                                                                        0x0196
#define regVPEC_QUEUE3_SKIP_CNTL_BASE_IDX                                                               0
#define regVPEC_QUEUE3_DOORBELL                                                                         0x0197
#define regVPEC_QUEUE3_DOORBELL_BASE_IDX                                                                0
#define regVPEC_QUEUE3_DOORBELL_OFFSET                                                                  0x0198
#define regVPEC_QUEUE3_DOORBELL_OFFSET_BASE_IDX                                                         0
#define regVPEC_QUEUE3_DUMMY0                                                                           0x0199
#define regVPEC_QUEUE3_DUMMY0_BASE_IDX                                                                  0
#define regVPEC_QUEUE3_DUMMY1                                                                           0x019a
#define regVPEC_QUEUE3_DUMMY1_BASE_IDX                                                                  0
#define regVPEC_QUEUE3_DUMMY2                                                                           0x019b
#define regVPEC_QUEUE3_DUMMY2_BASE_IDX                                                                  0
#define regVPEC_QUEUE3_DUMMY3                                                                           0x019c
#define regVPEC_QUEUE3_DUMMY3_BASE_IDX                                                                  0
#define regVPEC_QUEUE3_DUMMY4                                                                           0x019d
#define regVPEC_QUEUE3_DUMMY4_BASE_IDX                                                                  0
#define regVPEC_QUEUE3_IB_CNTL                                                                          0x01b4
#define regVPEC_QUEUE3_IB_CNTL_BASE_IDX                                                                 0
#define regVPEC_QUEUE3_IB_RPTR                                                                          0x01b5
#define regVPEC_QUEUE3_IB_RPTR_BASE_IDX                                                                 0
#define regVPEC_QUEUE3_IB_OFFSET                                                                        0x01b6
#define regVPEC_QUEUE3_IB_OFFSET_BASE_IDX                                                               0
#define regVPEC_QUEUE3_IB_BASE_LO                                                                       0x01b7
#define regVPEC_QUEUE3_IB_BASE_LO_BASE_IDX                                                              0
#define regVPEC_QUEUE3_IB_BASE_HI                                                                       0x01b8
#define regVPEC_QUEUE3_IB_BASE_HI_BASE_IDX                                                              0
#define regVPEC_QUEUE3_IB_SIZE                                                                          0x01b9
#define regVPEC_QUEUE3_IB_SIZE_BASE_IDX                                                                 0
#define regVPEC_QUEUE3_CMDIB_CNTL                                                                       0x01ba
#define regVPEC_QUEUE3_CMDIB_CNTL_BASE_IDX                                                              0
#define regVPEC_QUEUE3_CMDIB_RPTR                                                                       0x01bb
#define regVPEC_QUEUE3_CMDIB_RPTR_BASE_IDX                                                              0
#define regVPEC_QUEUE3_CMDIB_OFFSET                                                                     0x01bc
#define regVPEC_QUEUE3_CMDIB_OFFSET_BASE_IDX                                                            0
#define regVPEC_QUEUE3_CMDIB_BASE_LO                                                                    0x01bd
#define regVPEC_QUEUE3_CMDIB_BASE_LO_BASE_IDX                                                           0
#define regVPEC_QUEUE3_CMDIB_BASE_HI                                                                    0x01be
#define regVPEC_QUEUE3_CMDIB_BASE_HI_BASE_IDX                                                           0
#define regVPEC_QUEUE3_CMDIB_SIZE                                                                       0x01bf
#define regVPEC_QUEUE3_CMDIB_SIZE_BASE_IDX                                                              0
#define regVPEC_QUEUE3_CSA_ADDR_LO                                                                      0x01c0
#define regVPEC_QUEUE3_CSA_ADDR_LO_BASE_IDX                                                             0
#define regVPEC_QUEUE3_CSA_ADDR_HI                                                                      0x01c1
#define regVPEC_QUEUE3_CSA_ADDR_HI_BASE_IDX                                                             0
#define regVPEC_QUEUE3_CONTEXT_STATUS                                                                   0x01c2
#define regVPEC_QUEUE3_CONTEXT_STATUS_BASE_IDX                                                          0
#define regVPEC_QUEUE3_DOORBELL_LOG                                                                     0x01c3
#define regVPEC_QUEUE3_DOORBELL_LOG_BASE_IDX                                                            0
#define regVPEC_QUEUE3_IB_SUB_REMAIN                                                                    0x01c4
#define regVPEC_QUEUE3_IB_SUB_REMAIN_BASE_IDX                                                           0
#define regVPEC_QUEUE3_PREEMPT                                                                          0x01c5
#define regVPEC_QUEUE3_PREEMPT_BASE_IDX                                                                 0
#define regVPEC_QUEUE4_RB_CNTL                                                                          0x01e0
#define regVPEC_QUEUE4_RB_CNTL_BASE_IDX                                                                 0
#define regVPEC_QUEUE4_SCHEDULE_CNTL                                                                    0x01e1
#define regVPEC_QUEUE4_SCHEDULE_CNTL_BASE_IDX                                                           0
#define regVPEC_QUEUE4_RB_BASE                                                                          0x01e2
#define regVPEC_QUEUE4_RB_BASE_BASE_IDX                                                                 0
#define regVPEC_QUEUE4_RB_BASE_HI                                                                       0x01e3
#define regVPEC_QUEUE4_RB_BASE_HI_BASE_IDX                                                              0
#define regVPEC_QUEUE4_RB_RPTR                                                                          0x01e4
#define regVPEC_QUEUE4_RB_RPTR_BASE_IDX                                                                 0
#define regVPEC_QUEUE4_RB_RPTR_HI                                                                       0x01e5
#define regVPEC_QUEUE4_RB_RPTR_HI_BASE_IDX                                                              0
#define regVPEC_QUEUE4_RB_WPTR                                                                          0x01e6
#define regVPEC_QUEUE4_RB_WPTR_BASE_IDX                                                                 0
#define regVPEC_QUEUE4_RB_WPTR_HI                                                                       0x01e7
#define regVPEC_QUEUE4_RB_WPTR_HI_BASE_IDX                                                              0
#define regVPEC_QUEUE4_RB_RPTR_ADDR_HI                                                                  0x01e8
#define regVPEC_QUEUE4_RB_RPTR_ADDR_HI_BASE_IDX                                                         0
#define regVPEC_QUEUE4_RB_RPTR_ADDR_LO                                                                  0x01e9
#define regVPEC_QUEUE4_RB_RPTR_ADDR_LO_BASE_IDX                                                         0
#define regVPEC_QUEUE4_RB_AQL_CNTL                                                                      0x01ea
#define regVPEC_QUEUE4_RB_AQL_CNTL_BASE_IDX                                                             0
#define regVPEC_QUEUE4_MINOR_PTR_UPDATE                                                                 0x01eb
#define regVPEC_QUEUE4_MINOR_PTR_UPDATE_BASE_IDX                                                        0
#define regVPEC_QUEUE4_CD_INFO                                                                          0x01ec
#define regVPEC_QUEUE4_CD_INFO_BASE_IDX                                                                 0
#define regVPEC_QUEUE4_RB_PREEMPT                                                                       0x01ed
#define regVPEC_QUEUE4_RB_PREEMPT_BASE_IDX                                                              0
#define regVPEC_QUEUE4_SKIP_CNTL                                                                        0x01ee
#define regVPEC_QUEUE4_SKIP_CNTL_BASE_IDX                                                               0
#define regVPEC_QUEUE4_DOORBELL                                                                         0x01ef
#define regVPEC_QUEUE4_DOORBELL_BASE_IDX                                                                0
#define regVPEC_QUEUE4_DOORBELL_OFFSET                                                                  0x01f0
#define regVPEC_QUEUE4_DOORBELL_OFFSET_BASE_IDX                                                         0
#define regVPEC_QUEUE4_DUMMY0                                                                           0x01f1
#define regVPEC_QUEUE4_DUMMY0_BASE_IDX                                                                  0
#define regVPEC_QUEUE4_DUMMY1                                                                           0x01f2
#define regVPEC_QUEUE4_DUMMY1_BASE_IDX                                                                  0
#define regVPEC_QUEUE4_DUMMY2                                                                           0x01f3
#define regVPEC_QUEUE4_DUMMY2_BASE_IDX                                                                  0
#define regVPEC_QUEUE4_DUMMY3                                                                           0x01f4
#define regVPEC_QUEUE4_DUMMY3_BASE_IDX                                                                  0
#define regVPEC_QUEUE4_DUMMY4                                                                           0x01f5
#define regVPEC_QUEUE4_DUMMY4_BASE_IDX                                                                  0
#define regVPEC_QUEUE4_IB_CNTL                                                                          0x020c
#define regVPEC_QUEUE4_IB_CNTL_BASE_IDX                                                                 0
#define regVPEC_QUEUE4_IB_RPTR                                                                          0x020d
#define regVPEC_QUEUE4_IB_RPTR_BASE_IDX                                                                 0
#define regVPEC_QUEUE4_IB_OFFSET                                                                        0x020e
#define regVPEC_QUEUE4_IB_OFFSET_BASE_IDX                                                               0
#define regVPEC_QUEUE4_IB_BASE_LO                                                                       0x020f
#define regVPEC_QUEUE4_IB_BASE_LO_BASE_IDX                                                              0
#define regVPEC_QUEUE4_IB_BASE_HI                                                                       0x0210
#define regVPEC_QUEUE4_IB_BASE_HI_BASE_IDX                                                              0
#define regVPEC_QUEUE4_IB_SIZE                                                                          0x0211
#define regVPEC_QUEUE4_IB_SIZE_BASE_IDX                                                                 0
#define regVPEC_QUEUE4_CMDIB_CNTL                                                                       0x0212
#define regVPEC_QUEUE4_CMDIB_CNTL_BASE_IDX                                                              0
#define regVPEC_QUEUE4_CMDIB_RPTR                                                                       0x0213
#define regVPEC_QUEUE4_CMDIB_RPTR_BASE_IDX                                                              0
#define regVPEC_QUEUE4_CMDIB_OFFSET                                                                     0x0214
#define regVPEC_QUEUE4_CMDIB_OFFSET_BASE_IDX                                                            0
#define regVPEC_QUEUE4_CMDIB_BASE_LO                                                                    0x0215
#define regVPEC_QUEUE4_CMDIB_BASE_LO_BASE_IDX                                                           0
#define regVPEC_QUEUE4_CMDIB_BASE_HI                                                                    0x0216
#define regVPEC_QUEUE4_CMDIB_BASE_HI_BASE_IDX                                                           0
#define regVPEC_QUEUE4_CMDIB_SIZE                                                                       0x0217
#define regVPEC_QUEUE4_CMDIB_SIZE_BASE_IDX                                                              0
#define regVPEC_QUEUE4_CSA_ADDR_LO                                                                      0x0218
#define regVPEC_QUEUE4_CSA_ADDR_LO_BASE_IDX                                                             0
#define regVPEC_QUEUE4_CSA_ADDR_HI                                                                      0x0219
#define regVPEC_QUEUE4_CSA_ADDR_HI_BASE_IDX                                                             0
#define regVPEC_QUEUE4_CONTEXT_STATUS                                                                   0x021a
#define regVPEC_QUEUE4_CONTEXT_STATUS_BASE_IDX                                                          0
#define regVPEC_QUEUE4_DOORBELL_LOG                                                                     0x021b
#define regVPEC_QUEUE4_DOORBELL_LOG_BASE_IDX                                                            0
#define regVPEC_QUEUE4_IB_SUB_REMAIN                                                                    0x021c
#define regVPEC_QUEUE4_IB_SUB_REMAIN_BASE_IDX                                                           0
#define regVPEC_QUEUE4_PREEMPT                                                                          0x021d
#define regVPEC_QUEUE4_PREEMPT_BASE_IDX                                                                 0
#define regVPEC_QUEUE5_RB_CNTL                                                                          0x0238
#define regVPEC_QUEUE5_RB_CNTL_BASE_IDX                                                                 0
#define regVPEC_QUEUE5_SCHEDULE_CNTL                                                                    0x0239
#define regVPEC_QUEUE5_SCHEDULE_CNTL_BASE_IDX                                                           0
#define regVPEC_QUEUE5_RB_BASE                                                                          0x023a
#define regVPEC_QUEUE5_RB_BASE_BASE_IDX                                                                 0
#define regVPEC_QUEUE5_RB_BASE_HI                                                                       0x023b
#define regVPEC_QUEUE5_RB_BASE_HI_BASE_IDX                                                              0
#define regVPEC_QUEUE5_RB_RPTR                                                                          0x023c
#define regVPEC_QUEUE5_RB_RPTR_BASE_IDX                                                                 0
#define regVPEC_QUEUE5_RB_RPTR_HI                                                                       0x023d
#define regVPEC_QUEUE5_RB_RPTR_HI_BASE_IDX                                                              0
#define regVPEC_QUEUE5_RB_WPTR                                                                          0x023e
#define regVPEC_QUEUE5_RB_WPTR_BASE_IDX                                                                 0
#define regVPEC_QUEUE5_RB_WPTR_HI                                                                       0x023f
#define regVPEC_QUEUE5_RB_WPTR_HI_BASE_IDX                                                              0
#define regVPEC_QUEUE5_RB_RPTR_ADDR_HI                                                                  0x0240
#define regVPEC_QUEUE5_RB_RPTR_ADDR_HI_BASE_IDX                                                         0
#define regVPEC_QUEUE5_RB_RPTR_ADDR_LO                                                                  0x0241
#define regVPEC_QUEUE5_RB_RPTR_ADDR_LO_BASE_IDX                                                         0
#define regVPEC_QUEUE5_RB_AQL_CNTL                                                                      0x0242
#define regVPEC_QUEUE5_RB_AQL_CNTL_BASE_IDX                                                             0
#define regVPEC_QUEUE5_MINOR_PTR_UPDATE                                                                 0x0243
#define regVPEC_QUEUE5_MINOR_PTR_UPDATE_BASE_IDX                                                        0
#define regVPEC_QUEUE5_CD_INFO                                                                          0x0244
#define regVPEC_QUEUE5_CD_INFO_BASE_IDX                                                                 0
#define regVPEC_QUEUE5_RB_PREEMPT                                                                       0x0245
#define regVPEC_QUEUE5_RB_PREEMPT_BASE_IDX                                                              0
#define regVPEC_QUEUE5_SKIP_CNTL                                                                        0x0246
#define regVPEC_QUEUE5_SKIP_CNTL_BASE_IDX                                                               0
#define regVPEC_QUEUE5_DOORBELL                                                                         0x0247
#define regVPEC_QUEUE5_DOORBELL_BASE_IDX                                                                0
#define regVPEC_QUEUE5_DOORBELL_OFFSET                                                                  0x0248
#define regVPEC_QUEUE5_DOORBELL_OFFSET_BASE_IDX                                                         0
#define regVPEC_QUEUE5_DUMMY0                                                                           0x0249
#define regVPEC_QUEUE5_DUMMY0_BASE_IDX                                                                  0
#define regVPEC_QUEUE5_DUMMY1                                                                           0x024a
#define regVPEC_QUEUE5_DUMMY1_BASE_IDX                                                                  0
#define regVPEC_QUEUE5_DUMMY2                                                                           0x024b
#define regVPEC_QUEUE5_DUMMY2_BASE_IDX                                                                  0
#define regVPEC_QUEUE5_DUMMY3                                                                           0x024c
#define regVPEC_QUEUE5_DUMMY3_BASE_IDX                                                                  0
#define regVPEC_QUEUE5_DUMMY4                                                                           0x024d
#define regVPEC_QUEUE5_DUMMY4_BASE_IDX                                                                  0
#define regVPEC_QUEUE5_IB_CNTL                                                                          0x0264
#define regVPEC_QUEUE5_IB_CNTL_BASE_IDX                                                                 0
#define regVPEC_QUEUE5_IB_RPTR                                                                          0x0265
#define regVPEC_QUEUE5_IB_RPTR_BASE_IDX                                                                 0
#define regVPEC_QUEUE5_IB_OFFSET                                                                        0x0266
#define regVPEC_QUEUE5_IB_OFFSET_BASE_IDX                                                               0
#define regVPEC_QUEUE5_IB_BASE_LO                                                                       0x0267
#define regVPEC_QUEUE5_IB_BASE_LO_BASE_IDX                                                              0
#define regVPEC_QUEUE5_IB_BASE_HI                                                                       0x0268
#define regVPEC_QUEUE5_IB_BASE_HI_BASE_IDX                                                              0
#define regVPEC_QUEUE5_IB_SIZE                                                                          0x0269
#define regVPEC_QUEUE5_IB_SIZE_BASE_IDX                                                                 0
#define regVPEC_QUEUE5_CMDIB_CNTL                                                                       0x026a
#define regVPEC_QUEUE5_CMDIB_CNTL_BASE_IDX                                                              0
#define regVPEC_QUEUE5_CMDIB_RPTR                                                                       0x026b
#define regVPEC_QUEUE5_CMDIB_RPTR_BASE_IDX                                                              0
#define regVPEC_QUEUE5_CMDIB_OFFSET                                                                     0x026c
#define regVPEC_QUEUE5_CMDIB_OFFSET_BASE_IDX                                                            0
#define regVPEC_QUEUE5_CMDIB_BASE_LO                                                                    0x026d
#define regVPEC_QUEUE5_CMDIB_BASE_LO_BASE_IDX                                                           0
#define regVPEC_QUEUE5_CMDIB_BASE_HI                                                                    0x026e
#define regVPEC_QUEUE5_CMDIB_BASE_HI_BASE_IDX                                                           0
#define regVPEC_QUEUE5_CMDIB_SIZE                                                                       0x026f
#define regVPEC_QUEUE5_CMDIB_SIZE_BASE_IDX                                                              0
#define regVPEC_QUEUE5_CSA_ADDR_LO                                                                      0x0270
#define regVPEC_QUEUE5_CSA_ADDR_LO_BASE_IDX                                                             0
#define regVPEC_QUEUE5_CSA_ADDR_HI                                                                      0x0271
#define regVPEC_QUEUE5_CSA_ADDR_HI_BASE_IDX                                                             0
#define regVPEC_QUEUE5_CONTEXT_STATUS                                                                   0x0272
#define regVPEC_QUEUE5_CONTEXT_STATUS_BASE_IDX                                                          0
#define regVPEC_QUEUE5_DOORBELL_LOG                                                                     0x0273
#define regVPEC_QUEUE5_DOORBELL_LOG_BASE_IDX                                                            0
#define regVPEC_QUEUE5_IB_SUB_REMAIN                                                                    0x0274
#define regVPEC_QUEUE5_IB_SUB_REMAIN_BASE_IDX                                                           0
#define regVPEC_QUEUE5_PREEMPT                                                                          0x0275
#define regVPEC_QUEUE5_PREEMPT_BASE_IDX                                                                 0
#define regVPEC_QUEUE6_RB_CNTL                                                                          0x0290
#define regVPEC_QUEUE6_RB_CNTL_BASE_IDX                                                                 0
#define regVPEC_QUEUE6_SCHEDULE_CNTL                                                                    0x0291
#define regVPEC_QUEUE6_SCHEDULE_CNTL_BASE_IDX                                                           0
#define regVPEC_QUEUE6_RB_BASE                                                                          0x0292
#define regVPEC_QUEUE6_RB_BASE_BASE_IDX                                                                 0
#define regVPEC_QUEUE6_RB_BASE_HI                                                                       0x0293
#define regVPEC_QUEUE6_RB_BASE_HI_BASE_IDX                                                              0
#define regVPEC_QUEUE6_RB_RPTR                                                                          0x0294
#define regVPEC_QUEUE6_RB_RPTR_BASE_IDX                                                                 0
#define regVPEC_QUEUE6_RB_RPTR_HI                                                                       0x0295
#define regVPEC_QUEUE6_RB_RPTR_HI_BASE_IDX                                                              0
#define regVPEC_QUEUE6_RB_WPTR                                                                          0x0296
#define regVPEC_QUEUE6_RB_WPTR_BASE_IDX                                                                 0
#define regVPEC_QUEUE6_RB_WPTR_HI                                                                       0x0297
#define regVPEC_QUEUE6_RB_WPTR_HI_BASE_IDX                                                              0
#define regVPEC_QUEUE6_RB_RPTR_ADDR_HI                                                                  0x0298
#define regVPEC_QUEUE6_RB_RPTR_ADDR_HI_BASE_IDX                                                         0
#define regVPEC_QUEUE6_RB_RPTR_ADDR_LO                                                                  0x0299
#define regVPEC_QUEUE6_RB_RPTR_ADDR_LO_BASE_IDX                                                         0
#define regVPEC_QUEUE6_RB_AQL_CNTL                                                                      0x029a
#define regVPEC_QUEUE6_RB_AQL_CNTL_BASE_IDX                                                             0
#define regVPEC_QUEUE6_MINOR_PTR_UPDATE                                                                 0x029b
#define regVPEC_QUEUE6_MINOR_PTR_UPDATE_BASE_IDX                                                        0
#define regVPEC_QUEUE6_CD_INFO                                                                          0x029c
#define regVPEC_QUEUE6_CD_INFO_BASE_IDX                                                                 0
#define regVPEC_QUEUE6_RB_PREEMPT                                                                       0x029d
#define regVPEC_QUEUE6_RB_PREEMPT_BASE_IDX                                                              0
#define regVPEC_QUEUE6_SKIP_CNTL                                                                        0x029e
#define regVPEC_QUEUE6_SKIP_CNTL_BASE_IDX                                                               0
#define regVPEC_QUEUE6_DOORBELL                                                                         0x029f
#define regVPEC_QUEUE6_DOORBELL_BASE_IDX                                                                0
#define regVPEC_QUEUE6_DOORBELL_OFFSET                                                                  0x02a0
#define regVPEC_QUEUE6_DOORBELL_OFFSET_BASE_IDX                                                         0
#define regVPEC_QUEUE6_DUMMY0                                                                           0x02a1
#define regVPEC_QUEUE6_DUMMY0_BASE_IDX                                                                  0
#define regVPEC_QUEUE6_DUMMY1                                                                           0x02a2
#define regVPEC_QUEUE6_DUMMY1_BASE_IDX                                                                  0
#define regVPEC_QUEUE6_DUMMY2                                                                           0x02a3
#define regVPEC_QUEUE6_DUMMY2_BASE_IDX                                                                  0
#define regVPEC_QUEUE6_DUMMY3                                                                           0x02a4
#define regVPEC_QUEUE6_DUMMY3_BASE_IDX                                                                  0
#define regVPEC_QUEUE6_DUMMY4                                                                           0x02a5
#define regVPEC_QUEUE6_DUMMY4_BASE_IDX                                                                  0
#define regVPEC_QUEUE6_IB_CNTL                                                                          0x02bc
#define regVPEC_QUEUE6_IB_CNTL_BASE_IDX                                                                 0
#define regVPEC_QUEUE6_IB_RPTR                                                                          0x02bd
#define regVPEC_QUEUE6_IB_RPTR_BASE_IDX                                                                 0
#define regVPEC_QUEUE6_IB_OFFSET                                                                        0x02be
#define regVPEC_QUEUE6_IB_OFFSET_BASE_IDX                                                               0
#define regVPEC_QUEUE6_IB_BASE_LO                                                                       0x02bf
#define regVPEC_QUEUE6_IB_BASE_LO_BASE_IDX                                                              0
#define regVPEC_QUEUE6_IB_BASE_HI                                                                       0x02c0
#define regVPEC_QUEUE6_IB_BASE_HI_BASE_IDX                                                              0
#define regVPEC_QUEUE6_IB_SIZE                                                                          0x02c1
#define regVPEC_QUEUE6_IB_SIZE_BASE_IDX                                                                 0
#define regVPEC_QUEUE6_CMDIB_CNTL                                                                       0x02c2
#define regVPEC_QUEUE6_CMDIB_CNTL_BASE_IDX                                                              0
#define regVPEC_QUEUE6_CMDIB_RPTR                                                                       0x02c3
#define regVPEC_QUEUE6_CMDIB_RPTR_BASE_IDX                                                              0
#define regVPEC_QUEUE6_CMDIB_OFFSET                                                                     0x02c4
#define regVPEC_QUEUE6_CMDIB_OFFSET_BASE_IDX                                                            0
#define regVPEC_QUEUE6_CMDIB_BASE_LO                                                                    0x02c5
#define regVPEC_QUEUE6_CMDIB_BASE_LO_BASE_IDX                                                           0
#define regVPEC_QUEUE6_CMDIB_BASE_HI                                                                    0x02c6
#define regVPEC_QUEUE6_CMDIB_BASE_HI_BASE_IDX                                                           0
#define regVPEC_QUEUE6_CMDIB_SIZE                                                                       0x02c7
#define regVPEC_QUEUE6_CMDIB_SIZE_BASE_IDX                                                              0
#define regVPEC_QUEUE6_CSA_ADDR_LO                                                                      0x02c8
#define regVPEC_QUEUE6_CSA_ADDR_LO_BASE_IDX                                                             0
#define regVPEC_QUEUE6_CSA_ADDR_HI                                                                      0x02c9
#define regVPEC_QUEUE6_CSA_ADDR_HI_BASE_IDX                                                             0
#define regVPEC_QUEUE6_CONTEXT_STATUS                                                                   0x02ca
#define regVPEC_QUEUE6_CONTEXT_STATUS_BASE_IDX                                                          0
#define regVPEC_QUEUE6_DOORBELL_LOG                                                                     0x02cb
#define regVPEC_QUEUE6_DOORBELL_LOG_BASE_IDX                                                            0
#define regVPEC_QUEUE6_IB_SUB_REMAIN                                                                    0x02cc
#define regVPEC_QUEUE6_IB_SUB_REMAIN_BASE_IDX                                                           0
#define regVPEC_QUEUE6_PREEMPT                                                                          0x02cd
#define regVPEC_QUEUE6_PREEMPT_BASE_IDX                                                                 0
#define regVPEC_QUEUE7_RB_CNTL                                                                          0x02e8
#define regVPEC_QUEUE7_RB_CNTL_BASE_IDX                                                                 0
#define regVPEC_QUEUE7_SCHEDULE_CNTL                                                                    0x02e9
#define regVPEC_QUEUE7_SCHEDULE_CNTL_BASE_IDX                                                           0
#define regVPEC_QUEUE7_RB_BASE                                                                          0x02ea
#define regVPEC_QUEUE7_RB_BASE_BASE_IDX                                                                 0
#define regVPEC_QUEUE7_RB_BASE_HI                                                                       0x02eb
#define regVPEC_QUEUE7_RB_BASE_HI_BASE_IDX                                                              0
#define regVPEC_QUEUE7_RB_RPTR                                                                          0x02ec
#define regVPEC_QUEUE7_RB_RPTR_BASE_IDX                                                                 0
#define regVPEC_QUEUE7_RB_RPTR_HI                                                                       0x02ed
#define regVPEC_QUEUE7_RB_RPTR_HI_BASE_IDX                                                              0
#define regVPEC_QUEUE7_RB_WPTR                                                                          0x02ee
#define regVPEC_QUEUE7_RB_WPTR_BASE_IDX                                                                 0
#define regVPEC_QUEUE7_RB_WPTR_HI                                                                       0x02ef
#define regVPEC_QUEUE7_RB_WPTR_HI_BASE_IDX                                                              0
#define regVPEC_QUEUE7_RB_RPTR_ADDR_HI                                                                  0x02f0
#define regVPEC_QUEUE7_RB_RPTR_ADDR_HI_BASE_IDX                                                         0
#define regVPEC_QUEUE7_RB_RPTR_ADDR_LO                                                                  0x02f1
#define regVPEC_QUEUE7_RB_RPTR_ADDR_LO_BASE_IDX                                                         0
#define regVPEC_QUEUE7_RB_AQL_CNTL                                                                      0x02f2
#define regVPEC_QUEUE7_RB_AQL_CNTL_BASE_IDX                                                             0
#define regVPEC_QUEUE7_MINOR_PTR_UPDATE                                                                 0x02f3
#define regVPEC_QUEUE7_MINOR_PTR_UPDATE_BASE_IDX                                                        0
#define regVPEC_QUEUE7_CD_INFO                                                                          0x02f4
#define regVPEC_QUEUE7_CD_INFO_BASE_IDX                                                                 0
#define regVPEC_QUEUE7_RB_PREEMPT                                                                       0x02f5
#define regVPEC_QUEUE7_RB_PREEMPT_BASE_IDX                                                              0
#define regVPEC_QUEUE7_SKIP_CNTL                                                                        0x02f6
#define regVPEC_QUEUE7_SKIP_CNTL_BASE_IDX                                                               0
#define regVPEC_QUEUE7_DOORBELL                                                                         0x02f7
#define regVPEC_QUEUE7_DOORBELL_BASE_IDX                                                                0
#define regVPEC_QUEUE7_DOORBELL_OFFSET                                                                  0x02f8
#define regVPEC_QUEUE7_DOORBELL_OFFSET_BASE_IDX                                                         0
#define regVPEC_QUEUE7_DUMMY0                                                                           0x02f9
#define regVPEC_QUEUE7_DUMMY0_BASE_IDX                                                                  0
#define regVPEC_QUEUE7_DUMMY1                                                                           0x02fa
#define regVPEC_QUEUE7_DUMMY1_BASE_IDX                                                                  0
#define regVPEC_QUEUE7_DUMMY2                                                                           0x02fb
#define regVPEC_QUEUE7_DUMMY2_BASE_IDX                                                                  0
#define regVPEC_QUEUE7_DUMMY3                                                                           0x02fc
#define regVPEC_QUEUE7_DUMMY3_BASE_IDX                                                                  0
#define regVPEC_QUEUE7_DUMMY4                                                                           0x02fd
#define regVPEC_QUEUE7_DUMMY4_BASE_IDX                                                                  0
#define regVPEC_QUEUE7_IB_CNTL                                                                          0x0314
#define regVPEC_QUEUE7_IB_CNTL_BASE_IDX                                                                 0
#define regVPEC_QUEUE7_IB_RPTR                                                                          0x0315
#define regVPEC_QUEUE7_IB_RPTR_BASE_IDX                                                                 0
#define regVPEC_QUEUE7_IB_OFFSET                                                                        0x0316
#define regVPEC_QUEUE7_IB_OFFSET_BASE_IDX                                                               0
#define regVPEC_QUEUE7_IB_BASE_LO                                                                       0x0317
#define regVPEC_QUEUE7_IB_BASE_LO_BASE_IDX                                                              0
#define regVPEC_QUEUE7_IB_BASE_HI                                                                       0x0318
#define regVPEC_QUEUE7_IB_BASE_HI_BASE_IDX                                                              0
#define regVPEC_QUEUE7_IB_SIZE                                                                          0x0319
#define regVPEC_QUEUE7_IB_SIZE_BASE_IDX                                                                 0
#define regVPEC_QUEUE7_CMDIB_CNTL                                                                       0x031a
#define regVPEC_QUEUE7_CMDIB_CNTL_BASE_IDX                                                              0
#define regVPEC_QUEUE7_CMDIB_RPTR                                                                       0x031b
#define regVPEC_QUEUE7_CMDIB_RPTR_BASE_IDX                                                              0
#define regVPEC_QUEUE7_CMDIB_OFFSET                                                                     0x031c
#define regVPEC_QUEUE7_CMDIB_OFFSET_BASE_IDX                                                            0
#define regVPEC_QUEUE7_CMDIB_BASE_LO                                                                    0x031d
#define regVPEC_QUEUE7_CMDIB_BASE_LO_BASE_IDX                                                           0
#define regVPEC_QUEUE7_CMDIB_BASE_HI                                                                    0x031e
#define regVPEC_QUEUE7_CMDIB_BASE_HI_BASE_IDX                                                           0
#define regVPEC_QUEUE7_CMDIB_SIZE                                                                       0x031f
#define regVPEC_QUEUE7_CMDIB_SIZE_BASE_IDX                                                              0
#define regVPEC_QUEUE7_CSA_ADDR_LO                                                                      0x0320
#define regVPEC_QUEUE7_CSA_ADDR_LO_BASE_IDX                                                             0
#define regVPEC_QUEUE7_CSA_ADDR_HI                                                                      0x0321
#define regVPEC_QUEUE7_CSA_ADDR_HI_BASE_IDX                                                             0
#define regVPEC_QUEUE7_CONTEXT_STATUS                                                                   0x0322
#define regVPEC_QUEUE7_CONTEXT_STATUS_BASE_IDX                                                          0
#define regVPEC_QUEUE7_DOORBELL_LOG                                                                     0x0323
#define regVPEC_QUEUE7_DOORBELL_LOG_BASE_IDX                                                            0
#define regVPEC_QUEUE7_IB_SUB_REMAIN                                                                    0x0324
#define regVPEC_QUEUE7_IB_SUB_REMAIN_BASE_IDX                                                           0
#define regVPEC_QUEUE7_PREEMPT                                                                          0x0325
#define regVPEC_QUEUE7_PREEMPT_BASE_IDX                                                                 0


// addressBlock: vpe_vpep_vpdpp0_dispdec_vpcnvc_cfg_dispdec
// base address: 0x0
#define regVPCNVC_SURFACE_PIXEL_FORMAT                                                                  0x0744
#define regVPCNVC_SURFACE_PIXEL_FORMAT_BASE_IDX                                                         0
#define regVPCNVC_FORMAT_CONTROL                                                                        0x0745
#define regVPCNVC_FORMAT_CONTROL_BASE_IDX                                                               0
#define regVPCNVC_FCNV_FP_BIAS_R                                                                        0x0746
#define regVPCNVC_FCNV_FP_BIAS_R_BASE_IDX                                                               0
#define regVPCNVC_FCNV_FP_BIAS_G                                                                        0x0747
#define regVPCNVC_FCNV_FP_BIAS_G_BASE_IDX                                                               0
#define regVPCNVC_FCNV_FP_BIAS_B                                                                        0x0748
#define regVPCNVC_FCNV_FP_BIAS_B_BASE_IDX                                                               0
#define regVPCNVC_FCNV_FP_SCALE_R                                                                       0x0749
#define regVPCNVC_FCNV_FP_SCALE_R_BASE_IDX                                                              0
#define regVPCNVC_FCNV_FP_SCALE_G                                                                       0x074a
#define regVPCNVC_FCNV_FP_SCALE_G_BASE_IDX                                                              0
#define regVPCNVC_FCNV_FP_SCALE_B                                                                       0x074b
#define regVPCNVC_FCNV_FP_SCALE_B_BASE_IDX                                                              0
#define regVPCNVC_COLOR_KEYER_CONTROL                                                                   0x074c
#define regVPCNVC_COLOR_KEYER_CONTROL_BASE_IDX                                                          0
#define regVPCNVC_COLOR_KEYER_ALPHA                                                                     0x074d
#define regVPCNVC_COLOR_KEYER_ALPHA_BASE_IDX                                                            0
#define regVPCNVC_COLOR_KEYER_RED                                                                       0x074e
#define regVPCNVC_COLOR_KEYER_RED_BASE_IDX                                                              0
#define regVPCNVC_COLOR_KEYER_GREEN                                                                     0x074f
#define regVPCNVC_COLOR_KEYER_GREEN_BASE_IDX                                                            0
#define regVPCNVC_COLOR_KEYER_BLUE                                                                      0x0750
#define regVPCNVC_COLOR_KEYER_BLUE_BASE_IDX                                                             0
#define regVPCNVC_ALPHA_2BIT_LUT                                                                        0x0752
#define regVPCNVC_ALPHA_2BIT_LUT_BASE_IDX                                                               0
#define regVPCNVC_PRE_DEALPHA                                                                           0x0753
#define regVPCNVC_PRE_DEALPHA_BASE_IDX                                                                  0
#define regVPCNVC_PRE_CSC_MODE                                                                          0x0754
#define regVPCNVC_PRE_CSC_MODE_BASE_IDX                                                                 0
#define regVPCNVC_PRE_CSC_C11_C12                                                                       0x0755
#define regVPCNVC_PRE_CSC_C11_C12_BASE_IDX                                                              0
#define regVPCNVC_PRE_CSC_C13_C14                                                                       0x0756
#define regVPCNVC_PRE_CSC_C13_C14_BASE_IDX                                                              0
#define regVPCNVC_PRE_CSC_C21_C22                                                                       0x0757
#define regVPCNVC_PRE_CSC_C21_C22_BASE_IDX                                                              0
#define regVPCNVC_PRE_CSC_C23_C24                                                                       0x0758
#define regVPCNVC_PRE_CSC_C23_C24_BASE_IDX                                                              0
#define regVPCNVC_PRE_CSC_C31_C32                                                                       0x0759
#define regVPCNVC_PRE_CSC_C31_C32_BASE_IDX                                                              0
#define regVPCNVC_PRE_CSC_C33_C34                                                                       0x075a
#define regVPCNVC_PRE_CSC_C33_C34_BASE_IDX                                                              0
#define regVPCNVC_COEF_FORMAT                                                                           0x075b
#define regVPCNVC_COEF_FORMAT_BASE_IDX                                                                  0
#define regVPCNVC_PRE_DEGAM                                                                             0x075c
#define regVPCNVC_PRE_DEGAM_BASE_IDX                                                                    0
#define regVPCNVC_PRE_REALPHA                                                                           0x075d
#define regVPCNVC_PRE_REALPHA_BASE_IDX                                                                  0
#define regVPCNVC_CFG_TEST_DEBUG_INDEX                                                                  0x075e
#define regVPCNVC_CFG_TEST_DEBUG_INDEX_BASE_IDX                                                         0
#define regVPCNVC_CFG_TEST_DEBUG_DATA                                                                   0x075f
#define regVPCNVC_CFG_TEST_DEBUG_DATA_BASE_IDX                                                          0


// addressBlock: vpe_vpep_vpdpp0_dispdec_vpdscl_dispdec
// base address: 0x0
#define regVPDSCL_COEF_RAM_TAP_SELECT                                                                   0x0768
#define regVPDSCL_COEF_RAM_TAP_SELECT_BASE_IDX                                                          0
#define regVPDSCL_COEF_RAM_TAP_DATA                                                                     0x0769
#define regVPDSCL_COEF_RAM_TAP_DATA_BASE_IDX                                                            0
#define regVPDSCL_MODE                                                                                  0x076a
#define regVPDSCL_MODE_BASE_IDX                                                                         0
#define regVPDSCL_TAP_CONTROL                                                                           0x076b
#define regVPDSCL_TAP_CONTROL_BASE_IDX                                                                  0
#define regVPDSCL_CONTROL                                                                               0x076c
#define regVPDSCL_CONTROL_BASE_IDX                                                                      0
#define regVPDSCL_2TAP_CONTROL                                                                          0x076d
#define regVPDSCL_2TAP_CONTROL_BASE_IDX                                                                 0
#define regVPDSCL_MANUAL_REPLICATE_CONTROL                                                              0x076e
#define regVPDSCL_MANUAL_REPLICATE_CONTROL_BASE_IDX                                                     0
#define regVPDSCL_HORZ_FILTER_SCALE_RATIO                                                               0x076f
#define regVPDSCL_HORZ_FILTER_SCALE_RATIO_BASE_IDX                                                      0
#define regVPDSCL_HORZ_FILTER_INIT                                                                      0x0770
#define regVPDSCL_HORZ_FILTER_INIT_BASE_IDX                                                             0
#define regVPDSCL_HORZ_FILTER_SCALE_RATIO_C                                                             0x0771
#define regVPDSCL_HORZ_FILTER_SCALE_RATIO_C_BASE_IDX                                                    0
#define regVPDSCL_HORZ_FILTER_INIT_C                                                                    0x0772
#define regVPDSCL_HORZ_FILTER_INIT_C_BASE_IDX                                                           0
#define regVPDSCL_VERT_FILTER_SCALE_RATIO                                                               0x0773
#define regVPDSCL_VERT_FILTER_SCALE_RATIO_BASE_IDX                                                      0
#define regVPDSCL_VERT_FILTER_INIT                                                                      0x0774
#define regVPDSCL_VERT_FILTER_INIT_BASE_IDX                                                             0
#define regVPDSCL_VERT_FILTER_INIT_BOT                                                                  0x0775
#define regVPDSCL_VERT_FILTER_INIT_BOT_BASE_IDX                                                         0
#define regVPDSCL_VERT_FILTER_SCALE_RATIO_C                                                             0x0776
#define regVPDSCL_VERT_FILTER_SCALE_RATIO_C_BASE_IDX                                                    0
#define regVPDSCL_VERT_FILTER_INIT_C                                                                    0x0777
#define regVPDSCL_VERT_FILTER_INIT_C_BASE_IDX                                                           0
#define regVPDSCL_VERT_FILTER_INIT_BOT_C                                                                0x0778
#define regVPDSCL_VERT_FILTER_INIT_BOT_C_BASE_IDX                                                       0
#define regVPDSCL_BLACK_COLOR                                                                           0x0779
#define regVPDSCL_BLACK_COLOR_BASE_IDX                                                                  0
#define regVPDSCL_UPDATE                                                                                0x077a
#define regVPDSCL_UPDATE_BASE_IDX                                                                       0
#define regVPDSCL_AUTOCAL                                                                               0x077b
#define regVPDSCL_AUTOCAL_BASE_IDX                                                                      0
#define regVPDSCL_EXT_OVERSCAN_LEFT_RIGHT                                                               0x077c
#define regVPDSCL_EXT_OVERSCAN_LEFT_RIGHT_BASE_IDX                                                      0
#define regVPDSCL_EXT_OVERSCAN_TOP_BOTTOM                                                               0x077d
#define regVPDSCL_EXT_OVERSCAN_TOP_BOTTOM_BASE_IDX                                                      0
#define regVPOTG_H_BLANK                                                                                0x077e
#define regVPOTG_H_BLANK_BASE_IDX                                                                       0
#define regVPOTG_V_BLANK                                                                                0x077f
#define regVPOTG_V_BLANK_BASE_IDX                                                                       0
#define regVPDSCL_RECOUT_START                                                                          0x0780
#define regVPDSCL_RECOUT_START_BASE_IDX                                                                 0
#define regVPDSCL_RECOUT_SIZE                                                                           0x0781
#define regVPDSCL_RECOUT_SIZE_BASE_IDX                                                                  0
#define regVPMPC_SIZE                                                                                   0x0782
#define regVPMPC_SIZE_BASE_IDX                                                                          0
#define regVPLB_DATA_FORMAT                                                                             0x0783
#define regVPLB_DATA_FORMAT_BASE_IDX                                                                    0
#define regVPLB_MEMORY_CTRL                                                                             0x0784
#define regVPLB_MEMORY_CTRL_BASE_IDX                                                                    0
#define regVPLB_V_COUNTER                                                                               0x0785
#define regVPLB_V_COUNTER_BASE_IDX                                                                      0
#define regVPDSCL_MEM_PWR_CTRL                                                                          0x0786
#define regVPDSCL_MEM_PWR_CTRL_BASE_IDX                                                                 0
#define regVPDSCL_MEM_PWR_STATUS                                                                        0x0787
#define regVPDSCL_MEM_PWR_STATUS_BASE_IDX                                                               0
#define regVPDSCL_DEBUG                                                                                 0x0788
#define regVPDSCL_DEBUG_BASE_IDX                                                                        0
#define regVPDSCL_TEST_DEBUG_INDEX                                                                      0x0789
#define regVPDSCL_TEST_DEBUG_INDEX_BASE_IDX                                                             0
#define regVPDSCL_TEST_DEBUG_DATA                                                                       0x078a
#define regVPDSCL_TEST_DEBUG_DATA_BASE_IDX                                                              0


// addressBlock: vpe_vpep_vpdpp0_dispdec_vpcm_dispdec
// base address: 0x0
#define regVPCM_CONTROL                                                                                 0x07b8
#define regVPCM_CONTROL_BASE_IDX                                                                        0
#define regVPCM_POST_CSC_CONTROL                                                                        0x07b9
#define regVPCM_POST_CSC_CONTROL_BASE_IDX                                                               0
#define regVPCM_POST_CSC_C11_C12                                                                        0x07ba
#define regVPCM_POST_CSC_C11_C12_BASE_IDX                                                               0
#define regVPCM_POST_CSC_C13_C14                                                                        0x07bb
#define regVPCM_POST_CSC_C13_C14_BASE_IDX                                                               0
#define regVPCM_POST_CSC_C21_C22                                                                        0x07bc
#define regVPCM_POST_CSC_C21_C22_BASE_IDX                                                               0
#define regVPCM_POST_CSC_C23_C24                                                                        0x07bd
#define regVPCM_POST_CSC_C23_C24_BASE_IDX                                                               0
#define regVPCM_POST_CSC_C31_C32                                                                        0x07be
#define regVPCM_POST_CSC_C31_C32_BASE_IDX                                                               0
#define regVPCM_POST_CSC_C33_C34                                                                        0x07bf
#define regVPCM_POST_CSC_C33_C34_BASE_IDX                                                               0
#define regVPCM_GAMUT_REMAP_CONTROL                                                                     0x07c0
#define regVPCM_GAMUT_REMAP_CONTROL_BASE_IDX                                                            0
#define regVPCM_GAMUT_REMAP_C11_C12                                                                     0x07c1
#define regVPCM_GAMUT_REMAP_C11_C12_BASE_IDX                                                            0
#define regVPCM_GAMUT_REMAP_C13_C14                                                                     0x07c2
#define regVPCM_GAMUT_REMAP_C13_C14_BASE_IDX                                                            0
#define regVPCM_GAMUT_REMAP_C21_C22                                                                     0x07c3
#define regVPCM_GAMUT_REMAP_C21_C22_BASE_IDX                                                            0
#define regVPCM_GAMUT_REMAP_C23_C24                                                                     0x07c4
#define regVPCM_GAMUT_REMAP_C23_C24_BASE_IDX                                                            0
#define regVPCM_GAMUT_REMAP_C31_C32                                                                     0x07c5
#define regVPCM_GAMUT_REMAP_C31_C32_BASE_IDX                                                            0
#define regVPCM_GAMUT_REMAP_C33_C34                                                                     0x07c6
#define regVPCM_GAMUT_REMAP_C33_C34_BASE_IDX                                                            0
#define regVPCM_BIAS_CR_R                                                                               0x07c7
#define regVPCM_BIAS_CR_R_BASE_IDX                                                                      0
#define regVPCM_BIAS_Y_G_CB_B                                                                           0x07c8
#define regVPCM_BIAS_Y_G_CB_B_BASE_IDX                                                                  0
#define regVPCM_GAMCOR_CONTROL                                                                          0x07c9
#define regVPCM_GAMCOR_CONTROL_BASE_IDX                                                                 0
#define regVPCM_GAMCOR_LUT_INDEX                                                                        0x07ca
#define regVPCM_GAMCOR_LUT_INDEX_BASE_IDX                                                               0
#define regVPCM_GAMCOR_LUT_DATA                                                                         0x07cb
#define regVPCM_GAMCOR_LUT_DATA_BASE_IDX                                                                0
#define regVPCM_GAMCOR_LUT_CONTROL                                                                      0x07cc
#define regVPCM_GAMCOR_LUT_CONTROL_BASE_IDX                                                             0
#define regVPCM_GAMCOR_RAMA_START_CNTL_B                                                                0x07cd
#define regVPCM_GAMCOR_RAMA_START_CNTL_B_BASE_IDX                                                       0
#define regVPCM_GAMCOR_RAMA_START_CNTL_G                                                                0x07ce
#define regVPCM_GAMCOR_RAMA_START_CNTL_G_BASE_IDX                                                       0
#define regVPCM_GAMCOR_RAMA_START_CNTL_R                                                                0x07cf
#define regVPCM_GAMCOR_RAMA_START_CNTL_R_BASE_IDX                                                       0
#define regVPCM_GAMCOR_RAMA_START_SLOPE_CNTL_B                                                          0x07d0
#define regVPCM_GAMCOR_RAMA_START_SLOPE_CNTL_B_BASE_IDX                                                 0
#define regVPCM_GAMCOR_RAMA_START_SLOPE_CNTL_G                                                          0x07d1
#define regVPCM_GAMCOR_RAMA_START_SLOPE_CNTL_G_BASE_IDX                                                 0
#define regVPCM_GAMCOR_RAMA_START_SLOPE_CNTL_R                                                          0x07d2
#define regVPCM_GAMCOR_RAMA_START_SLOPE_CNTL_R_BASE_IDX                                                 0
#define regVPCM_GAMCOR_RAMA_START_BASE_CNTL_B                                                           0x07d3
#define regVPCM_GAMCOR_RAMA_START_BASE_CNTL_B_BASE_IDX                                                  0
#define regVPCM_GAMCOR_RAMA_START_BASE_CNTL_G                                                           0x07d4
#define regVPCM_GAMCOR_RAMA_START_BASE_CNTL_G_BASE_IDX                                                  0
#define regVPCM_GAMCOR_RAMA_START_BASE_CNTL_R                                                           0x07d5
#define regVPCM_GAMCOR_RAMA_START_BASE_CNTL_R_BASE_IDX                                                  0
#define regVPCM_GAMCOR_RAMA_END_CNTL1_B                                                                 0x07d6
#define regVPCM_GAMCOR_RAMA_END_CNTL1_B_BASE_IDX                                                        0
#define regVPCM_GAMCOR_RAMA_END_CNTL2_B                                                                 0x07d7
#define regVPCM_GAMCOR_RAMA_END_CNTL2_B_BASE_IDX                                                        0
#define regVPCM_GAMCOR_RAMA_END_CNTL1_G                                                                 0x07d8
#define regVPCM_GAMCOR_RAMA_END_CNTL1_G_BASE_IDX                                                        0
#define regVPCM_GAMCOR_RAMA_END_CNTL2_G                                                                 0x07d9
#define regVPCM_GAMCOR_RAMA_END_CNTL2_G_BASE_IDX                                                        0
#define regVPCM_GAMCOR_RAMA_END_CNTL1_R                                                                 0x07da
#define regVPCM_GAMCOR_RAMA_END_CNTL1_R_BASE_IDX                                                        0
#define regVPCM_GAMCOR_RAMA_END_CNTL2_R                                                                 0x07db
#define regVPCM_GAMCOR_RAMA_END_CNTL2_R_BASE_IDX                                                        0
#define regVPCM_GAMCOR_RAMA_OFFSET_B                                                                    0x07dc
#define regVPCM_GAMCOR_RAMA_OFFSET_B_BASE_IDX                                                           0
#define regVPCM_GAMCOR_RAMA_OFFSET_G                                                                    0x07dd
#define regVPCM_GAMCOR_RAMA_OFFSET_G_BASE_IDX                                                           0
#define regVPCM_GAMCOR_RAMA_OFFSET_R                                                                    0x07de
#define regVPCM_GAMCOR_RAMA_OFFSET_R_BASE_IDX                                                           0
#define regVPCM_GAMCOR_RAMA_REGION_0_1                                                                  0x07df
#define regVPCM_GAMCOR_RAMA_REGION_0_1_BASE_IDX                                                         0
#define regVPCM_GAMCOR_RAMA_REGION_2_3                                                                  0x07e0
#define regVPCM_GAMCOR_RAMA_REGION_2_3_BASE_IDX                                                         0
#define regVPCM_GAMCOR_RAMA_REGION_4_5                                                                  0x07e1
#define regVPCM_GAMCOR_RAMA_REGION_4_5_BASE_IDX                                                         0
#define regVPCM_GAMCOR_RAMA_REGION_6_7                                                                  0x07e2
#define regVPCM_GAMCOR_RAMA_REGION_6_7_BASE_IDX                                                         0
#define regVPCM_GAMCOR_RAMA_REGION_8_9                                                                  0x07e3
#define regVPCM_GAMCOR_RAMA_REGION_8_9_BASE_IDX                                                         0
#define regVPCM_GAMCOR_RAMA_REGION_10_11                                                                0x07e4
#define regVPCM_GAMCOR_RAMA_REGION_10_11_BASE_IDX                                                       0
#define regVPCM_GAMCOR_RAMA_REGION_12_13                                                                0x07e5
#define regVPCM_GAMCOR_RAMA_REGION_12_13_BASE_IDX                                                       0
#define regVPCM_GAMCOR_RAMA_REGION_14_15                                                                0x07e6
#define regVPCM_GAMCOR_RAMA_REGION_14_15_BASE_IDX                                                       0
#define regVPCM_GAMCOR_RAMA_REGION_16_17                                                                0x07e7
#define regVPCM_GAMCOR_RAMA_REGION_16_17_BASE_IDX                                                       0
#define regVPCM_GAMCOR_RAMA_REGION_18_19                                                                0x07e8
#define regVPCM_GAMCOR_RAMA_REGION_18_19_BASE_IDX                                                       0
#define regVPCM_GAMCOR_RAMA_REGION_20_21                                                                0x07e9
#define regVPCM_GAMCOR_RAMA_REGION_20_21_BASE_IDX                                                       0
#define regVPCM_GAMCOR_RAMA_REGION_22_23                                                                0x07ea
#define regVPCM_GAMCOR_RAMA_REGION_22_23_BASE_IDX                                                       0
#define regVPCM_GAMCOR_RAMA_REGION_24_25                                                                0x07eb
#define regVPCM_GAMCOR_RAMA_REGION_24_25_BASE_IDX                                                       0
#define regVPCM_GAMCOR_RAMA_REGION_26_27                                                                0x07ec
#define regVPCM_GAMCOR_RAMA_REGION_26_27_BASE_IDX                                                       0
#define regVPCM_GAMCOR_RAMA_REGION_28_29                                                                0x07ed
#define regVPCM_GAMCOR_RAMA_REGION_28_29_BASE_IDX                                                       0
#define regVPCM_GAMCOR_RAMA_REGION_30_31                                                                0x07ee
#define regVPCM_GAMCOR_RAMA_REGION_30_31_BASE_IDX                                                       0
#define regVPCM_GAMCOR_RAMA_REGION_32_33                                                                0x07ef
#define regVPCM_GAMCOR_RAMA_REGION_32_33_BASE_IDX                                                       0
#define regVPCM_HDR_MULT_COEF                                                                           0x07f0
#define regVPCM_HDR_MULT_COEF_BASE_IDX                                                                  0
#define regVPCM_MEM_PWR_CTRL                                                                            0x07f1
#define regVPCM_MEM_PWR_CTRL_BASE_IDX                                                                   0
#define regVPCM_MEM_PWR_STATUS                                                                          0x07f2
#define regVPCM_MEM_PWR_STATUS_BASE_IDX                                                                 0
#define regVPCM_DEALPHA                                                                                 0x07f4
#define regVPCM_DEALPHA_BASE_IDX                                                                        0
#define regVPCM_COEF_FORMAT                                                                             0x07f5
#define regVPCM_COEF_FORMAT_BASE_IDX                                                                    0
#define regVPCM_TEST_DEBUG_INDEX                                                                        0x07f6
#define regVPCM_TEST_DEBUG_INDEX_BASE_IDX                                                               0
#define regVPCM_TEST_DEBUG_DATA                                                                         0x07f7
#define regVPCM_TEST_DEBUG_DATA_BASE_IDX                                                                0


// addressBlock: vpe_vpep_vpdpp0_dispdec_vpdpp_top_dispdec
// base address: 0x0
#define regVPDPP_CONTROL                                                                                0x0738
#define regVPDPP_CONTROL_BASE_IDX                                                                       0
#define regVPDPP_SOFT_RESET                                                                             0x0739
#define regVPDPP_SOFT_RESET_BASE_IDX                                                                    0
#define regVPDPP_CRC_VAL_R_G                                                                            0x073a
#define regVPDPP_CRC_VAL_R_G_BASE_IDX                                                                   0
#define regVPDPP_CRC_VAL_B_A                                                                            0x073b
#define regVPDPP_CRC_VAL_B_A_BASE_IDX                                                                   0
#define regVPDPP_CRC_CTRL                                                                               0x073c
#define regVPDPP_CRC_CTRL_BASE_IDX                                                                      0
#define regVPHOST_READ_CONTROL                                                                          0x073d
#define regVPHOST_READ_CONTROL_BASE_IDX                                                                 0
#define regVPDPP_DEBUG_SEL                                                                              0x073e
#define regVPDPP_DEBUG_SEL_BASE_IDX                                                                     0
#define regVPDPP_DEBUG_SPARE                                                                            0x073f
#define regVPDPP_DEBUG_SPARE_BASE_IDX                                                                   0
#define regVPDPP_TEST_DEBUG_INDEX                                                                       0x0740
#define regVPDPP_TEST_DEBUG_INDEX_BASE_IDX                                                              0
#define regVPDPP_TEST_DEBUG_DATA                                                                        0x0741
#define regVPDPP_TEST_DEBUG_DATA_BASE_IDX                                                               0


// addressBlock: vpe_vpep_vpmpc_vpmpcc0_dispdec
// base address: 0x0
#define regVPMPCC_TOP_SEL                                                                               0x0dc0
#define regVPMPCC_TOP_SEL_BASE_IDX                                                                      0
#define regVPMPCC_BOT_SEL                                                                               0x0dc1
#define regVPMPCC_BOT_SEL_BASE_IDX                                                                      0
#define regVPMPCC_VPOPP_ID                                                                              0x0dc2
#define regVPMPCC_VPOPP_ID_BASE_IDX                                                                     0
#define regVPMPCC_CONTROL                                                                               0x0dc3
#define regVPMPCC_CONTROL_BASE_IDX                                                                      0
#define regVPMPCC_TOP_GAIN                                                                              0x0dc4
#define regVPMPCC_TOP_GAIN_BASE_IDX                                                                     0
#define regVPMPCC_BOT_GAIN_INSIDE                                                                       0x0dc5
#define regVPMPCC_BOT_GAIN_INSIDE_BASE_IDX                                                              0
#define regVPMPCC_BOT_GAIN_OUTSIDE                                                                      0x0dc6
#define regVPMPCC_BOT_GAIN_OUTSIDE_BASE_IDX                                                             0
#define regVPMPCC_MOVABLE_CM_LOCATION_CONTROL                                                           0x0dc7
#define regVPMPCC_MOVABLE_CM_LOCATION_CONTROL_BASE_IDX                                                  0
#define regVPMPCC_BG_R_CR                                                                               0x0dc8
#define regVPMPCC_BG_R_CR_BASE_IDX                                                                      0
#define regVPMPCC_BG_G_Y                                                                                0x0dc9
#define regVPMPCC_BG_G_Y_BASE_IDX                                                                       0
#define regVPMPCC_BG_B_CB                                                                               0x0dca
#define regVPMPCC_BG_B_CB_BASE_IDX                                                                      0
#define regVPMPCC_MEM_PWR_CTRL                                                                          0x0dcb
#define regVPMPCC_MEM_PWR_CTRL_BASE_IDX                                                                 0
#define regVPMPCC_STATUS                                                                                0x0dcc
#define regVPMPCC_STATUS_BASE_IDX                                                                       0
#define regVPMPCC_TEST_DEBUG_INDEX                                                                      0x0dce
#define regVPMPCC_TEST_DEBUG_INDEX_BASE_IDX                                                             0
#define regVPMPCC_TEST_DEBUG_DATA                                                                       0x0dcf
#define regVPMPCC_TEST_DEBUG_DATA_BASE_IDX                                                              0


// addressBlock: vpe_vpep_vpmpc_vpmpc_cfg_dispdec
// base address: 0x0
#define regVPMPC_CLOCK_CONTROL                                                                          0x0f8c
#define regVPMPC_CLOCK_CONTROL_BASE_IDX                                                                 0
#define regVPMPC_SOFT_RESET                                                                             0x0f8d
#define regVPMPC_SOFT_RESET_BASE_IDX                                                                    0
#define regVPMPC_CRC_CTRL                                                                               0x0f8e
#define regVPMPC_CRC_CTRL_BASE_IDX                                                                      0
#define regVPMPC_CRC_SEL_CONTROL                                                                        0x0f8f
#define regVPMPC_CRC_SEL_CONTROL_BASE_IDX                                                               0
#define regVPMPC_CRC_RESULT_AR                                                                          0x0f90
#define regVPMPC_CRC_RESULT_AR_BASE_IDX                                                                 0
#define regVPMPC_CRC_RESULT_GB                                                                          0x0f91
#define regVPMPC_CRC_RESULT_GB_BASE_IDX                                                                 0
#define regVPMPC_CRC_RESULT_C                                                                           0x0f92
#define regVPMPC_CRC_RESULT_C_BASE_IDX                                                                  0
#define regVPMPC_DEBUG_CONTROL                                                                          0x0f93
#define regVPMPC_DEBUG_CONTROL_BASE_IDX                                                                 0
#define regVPMPCC_DEBUG_DATA_SELECT                                                                     0x0f94
#define regVPMPCC_DEBUG_DATA_SELECT_BASE_IDX                                                            0
#define regVPMPC_BYPASS_BG_AR                                                                           0x0f95
#define regVPMPC_BYPASS_BG_AR_BASE_IDX                                                                  0
#define regVPMPC_BYPASS_BG_GB                                                                           0x0f96
#define regVPMPC_BYPASS_BG_GB_BASE_IDX                                                                  0
#define regVPMPC_HOST_READ_CONTROL                                                                      0x0f97
#define regVPMPC_HOST_READ_CONTROL_BASE_IDX                                                             0
#define regVPMPC_PENDING_STATUS_MISC                                                                    0x0f98
#define regVPMPC_PENDING_STATUS_MISC_BASE_IDX                                                           0
#define regVPMPC_CFG_TEST_DEBUG_INDEX                                                                   0x0fbd
#define regVPMPC_CFG_TEST_DEBUG_INDEX_BASE_IDX                                                          0
#define regVPMPC_CFG_TEST_DEBUG_DATA                                                                    0x0fbe
#define regVPMPC_CFG_TEST_DEBUG_DATA_BASE_IDX                                                           0


// addressBlock: vpe_vpep_vpmpc_vpmpcc_ogam0_dispdec
// base address: 0x0
#define regVPMPCC_OGAM_CONTROL                                                                          0x0e14
#define regVPMPCC_OGAM_CONTROL_BASE_IDX                                                                 0
#define regVPMPCC_OGAM_LUT_INDEX                                                                        0x0e15
#define regVPMPCC_OGAM_LUT_INDEX_BASE_IDX                                                               0
#define regVPMPCC_OGAM_LUT_DATA                                                                         0x0e16
#define regVPMPCC_OGAM_LUT_DATA_BASE_IDX                                                                0
#define regVPMPCC_OGAM_LUT_CONTROL                                                                      0x0e17
#define regVPMPCC_OGAM_LUT_CONTROL_BASE_IDX                                                             0
#define regVPMPCC_OGAM_RAMA_START_CNTL_B                                                                0x0e18
#define regVPMPCC_OGAM_RAMA_START_CNTL_B_BASE_IDX                                                       0
#define regVPMPCC_OGAM_RAMA_START_CNTL_G                                                                0x0e19
#define regVPMPCC_OGAM_RAMA_START_CNTL_G_BASE_IDX                                                       0
#define regVPMPCC_OGAM_RAMA_START_CNTL_R                                                                0x0e1a
#define regVPMPCC_OGAM_RAMA_START_CNTL_R_BASE_IDX                                                       0
#define regVPMPCC_OGAM_RAMA_START_SLOPE_CNTL_B                                                          0x0e1b
#define regVPMPCC_OGAM_RAMA_START_SLOPE_CNTL_B_BASE_IDX                                                 0
#define regVPMPCC_OGAM_RAMA_START_SLOPE_CNTL_G                                                          0x0e1c
#define regVPMPCC_OGAM_RAMA_START_SLOPE_CNTL_G_BASE_IDX                                                 0
#define regVPMPCC_OGAM_RAMA_START_SLOPE_CNTL_R                                                          0x0e1d
#define regVPMPCC_OGAM_RAMA_START_SLOPE_CNTL_R_BASE_IDX                                                 0
#define regVPMPCC_OGAM_RAMA_START_BASE_CNTL_B                                                           0x0e1e
#define regVPMPCC_OGAM_RAMA_START_BASE_CNTL_B_BASE_IDX                                                  0
#define regVPMPCC_OGAM_RAMA_START_BASE_CNTL_G                                                           0x0e1f
#define regVPMPCC_OGAM_RAMA_START_BASE_CNTL_G_BASE_IDX                                                  0
#define regVPMPCC_OGAM_RAMA_START_BASE_CNTL_R                                                           0x0e20
#define regVPMPCC_OGAM_RAMA_START_BASE_CNTL_R_BASE_IDX                                                  0
#define regVPMPCC_OGAM_RAMA_END_CNTL1_B                                                                 0x0e21
#define regVPMPCC_OGAM_RAMA_END_CNTL1_B_BASE_IDX                                                        0
#define regVPMPCC_OGAM_RAMA_END_CNTL2_B                                                                 0x0e22
#define regVPMPCC_OGAM_RAMA_END_CNTL2_B_BASE_IDX                                                        0
#define regVPMPCC_OGAM_RAMA_END_CNTL1_G                                                                 0x0e23
#define regVPMPCC_OGAM_RAMA_END_CNTL1_G_BASE_IDX                                                        0
#define regVPMPCC_OGAM_RAMA_END_CNTL2_G                                                                 0x0e24
#define regVPMPCC_OGAM_RAMA_END_CNTL2_G_BASE_IDX                                                        0
#define regVPMPCC_OGAM_RAMA_END_CNTL1_R                                                                 0x0e25
#define regVPMPCC_OGAM_RAMA_END_CNTL1_R_BASE_IDX                                                        0
#define regVPMPCC_OGAM_RAMA_END_CNTL2_R                                                                 0x0e26
#define regVPMPCC_OGAM_RAMA_END_CNTL2_R_BASE_IDX                                                        0
#define regVPMPCC_OGAM_RAMA_OFFSET_B                                                                    0x0e27
#define regVPMPCC_OGAM_RAMA_OFFSET_B_BASE_IDX                                                           0
#define regVPMPCC_OGAM_RAMA_OFFSET_G                                                                    0x0e28
#define regVPMPCC_OGAM_RAMA_OFFSET_G_BASE_IDX                                                           0
#define regVPMPCC_OGAM_RAMA_OFFSET_R                                                                    0x0e29
#define regVPMPCC_OGAM_RAMA_OFFSET_R_BASE_IDX                                                           0
#define regVPMPCC_OGAM_RAMA_REGION_0_1                                                                  0x0e2a
#define regVPMPCC_OGAM_RAMA_REGION_0_1_BASE_IDX                                                         0
#define regVPMPCC_OGAM_RAMA_REGION_2_3                                                                  0x0e2b
#define regVPMPCC_OGAM_RAMA_REGION_2_3_BASE_IDX                                                         0
#define regVPMPCC_OGAM_RAMA_REGION_4_5                                                                  0x0e2c
#define regVPMPCC_OGAM_RAMA_REGION_4_5_BASE_IDX                                                         0
#define regVPMPCC_OGAM_RAMA_REGION_6_7                                                                  0x0e2d
#define regVPMPCC_OGAM_RAMA_REGION_6_7_BASE_IDX                                                         0
#define regVPMPCC_OGAM_RAMA_REGION_8_9                                                                  0x0e2e
#define regVPMPCC_OGAM_RAMA_REGION_8_9_BASE_IDX                                                         0
#define regVPMPCC_OGAM_RAMA_REGION_10_11                                                                0x0e2f
#define regVPMPCC_OGAM_RAMA_REGION_10_11_BASE_IDX                                                       0
#define regVPMPCC_OGAM_RAMA_REGION_12_13                                                                0x0e30
#define regVPMPCC_OGAM_RAMA_REGION_12_13_BASE_IDX                                                       0
#define regVPMPCC_OGAM_RAMA_REGION_14_15                                                                0x0e31
#define regVPMPCC_OGAM_RAMA_REGION_14_15_BASE_IDX                                                       0
#define regVPMPCC_OGAM_RAMA_REGION_16_17                                                                0x0e32
#define regVPMPCC_OGAM_RAMA_REGION_16_17_BASE_IDX                                                       0
#define regVPMPCC_OGAM_RAMA_REGION_18_19                                                                0x0e33
#define regVPMPCC_OGAM_RAMA_REGION_18_19_BASE_IDX                                                       0
#define regVPMPCC_OGAM_RAMA_REGION_20_21                                                                0x0e34
#define regVPMPCC_OGAM_RAMA_REGION_20_21_BASE_IDX                                                       0
#define regVPMPCC_OGAM_RAMA_REGION_22_23                                                                0x0e35
#define regVPMPCC_OGAM_RAMA_REGION_22_23_BASE_IDX                                                       0
#define regVPMPCC_OGAM_RAMA_REGION_24_25                                                                0x0e36
#define regVPMPCC_OGAM_RAMA_REGION_24_25_BASE_IDX                                                       0
#define regVPMPCC_OGAM_RAMA_REGION_26_27                                                                0x0e37
#define regVPMPCC_OGAM_RAMA_REGION_26_27_BASE_IDX                                                       0
#define regVPMPCC_OGAM_RAMA_REGION_28_29                                                                0x0e38
#define regVPMPCC_OGAM_RAMA_REGION_28_29_BASE_IDX                                                       0
#define regVPMPCC_OGAM_RAMA_REGION_30_31                                                                0x0e39
#define regVPMPCC_OGAM_RAMA_REGION_30_31_BASE_IDX                                                       0
#define regVPMPCC_OGAM_RAMA_REGION_32_33                                                                0x0e3a
#define regVPMPCC_OGAM_RAMA_REGION_32_33_BASE_IDX                                                       0
#define regVPMPCC_GAMUT_REMAP_COEF_FORMAT                                                               0x0e3b
#define regVPMPCC_GAMUT_REMAP_COEF_FORMAT_BASE_IDX                                                      0
#define regVPMPCC_GAMUT_REMAP_MODE                                                                      0x0e3c
#define regVPMPCC_GAMUT_REMAP_MODE_BASE_IDX                                                             0
#define regVPMPC_GAMUT_REMAP_C11_C12_A                                                                  0x0e3d
#define regVPMPC_GAMUT_REMAP_C11_C12_A_BASE_IDX                                                         0
#define regVPMPC_GAMUT_REMAP_C13_C14_A                                                                  0x0e3e
#define regVPMPC_GAMUT_REMAP_C13_C14_A_BASE_IDX                                                         0
#define regVPMPC_GAMUT_REMAP_C21_C22_A                                                                  0x0e3f
#define regVPMPC_GAMUT_REMAP_C21_C22_A_BASE_IDX                                                         0
#define regVPMPC_GAMUT_REMAP_C23_C24_A                                                                  0x0e40
#define regVPMPC_GAMUT_REMAP_C23_C24_A_BASE_IDX                                                         0
#define regVPMPC_GAMUT_REMAP_C31_C32_A                                                                  0x0e41
#define regVPMPC_GAMUT_REMAP_C31_C32_A_BASE_IDX                                                         0
#define regVPMPC_GAMUT_REMAP_C33_C34_A                                                                  0x0e42
#define regVPMPC_GAMUT_REMAP_C33_C34_A_BASE_IDX                                                         0
#define regVPMPCC_OGAM_TEST_DEBUG_INDEX                                                                 0x0e44
#define regVPMPCC_OGAM_TEST_DEBUG_INDEX_BASE_IDX                                                        0
#define regVPMPCC_OGAM_TEST_DEBUG_DATA                                                                  0x0e45
#define regVPMPCC_OGAM_TEST_DEBUG_DATA_BASE_IDX                                                         0


// addressBlock: vpe_vpep_vpmpc_vpmpcc_mcm0_dispdec
// base address: 0x0
#define regVPMPCC_MCM_SHAPER_CONTROL                                                                    0x1059
#define regVPMPCC_MCM_SHAPER_CONTROL_BASE_IDX                                                           0
#define regVPMPCC_MCM_SHAPER_OFFSET_R                                                                   0x105a
#define regVPMPCC_MCM_SHAPER_OFFSET_R_BASE_IDX                                                          0
#define regVPMPCC_MCM_SHAPER_OFFSET_G                                                                   0x105b
#define regVPMPCC_MCM_SHAPER_OFFSET_G_BASE_IDX                                                          0
#define regVPMPCC_MCM_SHAPER_OFFSET_B                                                                   0x105c
#define regVPMPCC_MCM_SHAPER_OFFSET_B_BASE_IDX                                                          0
#define regVPMPCC_MCM_SHAPER_SCALE_R                                                                    0x105d
#define regVPMPCC_MCM_SHAPER_SCALE_R_BASE_IDX                                                           0
#define regVPMPCC_MCM_SHAPER_SCALE_G_B                                                                  0x105e
#define regVPMPCC_MCM_SHAPER_SCALE_G_B_BASE_IDX                                                         0
#define regVPMPCC_MCM_SHAPER_LUT_INDEX                                                                  0x105f
#define regVPMPCC_MCM_SHAPER_LUT_INDEX_BASE_IDX                                                         0
#define regVPMPCC_MCM_SHAPER_LUT_DATA                                                                   0x1060
#define regVPMPCC_MCM_SHAPER_LUT_DATA_BASE_IDX                                                          0
#define regVPMPCC_MCM_SHAPER_LUT_WRITE_EN_MASK                                                          0x1061
#define regVPMPCC_MCM_SHAPER_LUT_WRITE_EN_MASK_BASE_IDX                                                 0
#define regVPMPCC_MCM_SHAPER_RAMA_START_CNTL_B                                                          0x1062
#define regVPMPCC_MCM_SHAPER_RAMA_START_CNTL_B_BASE_IDX                                                 0
#define regVPMPCC_MCM_SHAPER_RAMA_START_CNTL_G                                                          0x1063
#define regVPMPCC_MCM_SHAPER_RAMA_START_CNTL_G_BASE_IDX                                                 0
#define regVPMPCC_MCM_SHAPER_RAMA_START_CNTL_R                                                          0x1064
#define regVPMPCC_MCM_SHAPER_RAMA_START_CNTL_R_BASE_IDX                                                 0
#define regVPMPCC_MCM_SHAPER_RAMA_END_CNTL_B                                                            0x1065
#define regVPMPCC_MCM_SHAPER_RAMA_END_CNTL_B_BASE_IDX                                                   0
#define regVPMPCC_MCM_SHAPER_RAMA_END_CNTL_G                                                            0x1066
#define regVPMPCC_MCM_SHAPER_RAMA_END_CNTL_G_BASE_IDX                                                   0
#define regVPMPCC_MCM_SHAPER_RAMA_END_CNTL_R                                                            0x1067
#define regVPMPCC_MCM_SHAPER_RAMA_END_CNTL_R_BASE_IDX                                                   0
#define regVPMPCC_MCM_SHAPER_RAMA_REGION_0_1                                                            0x1068
#define regVPMPCC_MCM_SHAPER_RAMA_REGION_0_1_BASE_IDX                                                   0
#define regVPMPCC_MCM_SHAPER_RAMA_REGION_2_3                                                            0x1069
#define regVPMPCC_MCM_SHAPER_RAMA_REGION_2_3_BASE_IDX                                                   0
#define regVPMPCC_MCM_SHAPER_RAMA_REGION_4_5                                                            0x106a
#define regVPMPCC_MCM_SHAPER_RAMA_REGION_4_5_BASE_IDX                                                   0
#define regVPMPCC_MCM_SHAPER_RAMA_REGION_6_7                                                            0x106b
#define regVPMPCC_MCM_SHAPER_RAMA_REGION_6_7_BASE_IDX                                                   0
#define regVPMPCC_MCM_SHAPER_RAMA_REGION_8_9                                                            0x106c
#define regVPMPCC_MCM_SHAPER_RAMA_REGION_8_9_BASE_IDX                                                   0
#define regVPMPCC_MCM_SHAPER_RAMA_REGION_10_11                                                          0x106d
#define regVPMPCC_MCM_SHAPER_RAMA_REGION_10_11_BASE_IDX                                                 0
#define regVPMPCC_MCM_SHAPER_RAMA_REGION_12_13                                                          0x106e
#define regVPMPCC_MCM_SHAPER_RAMA_REGION_12_13_BASE_IDX                                                 0
#define regVPMPCC_MCM_SHAPER_RAMA_REGION_14_15                                                          0x106f
#define regVPMPCC_MCM_SHAPER_RAMA_REGION_14_15_BASE_IDX                                                 0
#define regVPMPCC_MCM_SHAPER_RAMA_REGION_16_17                                                          0x1070
#define regVPMPCC_MCM_SHAPER_RAMA_REGION_16_17_BASE_IDX                                                 0
#define regVPMPCC_MCM_SHAPER_RAMA_REGION_18_19                                                          0x1071
#define regVPMPCC_MCM_SHAPER_RAMA_REGION_18_19_BASE_IDX                                                 0
#define regVPMPCC_MCM_SHAPER_RAMA_REGION_20_21                                                          0x1072
#define regVPMPCC_MCM_SHAPER_RAMA_REGION_20_21_BASE_IDX                                                 0
#define regVPMPCC_MCM_SHAPER_RAMA_REGION_22_23                                                          0x1073
#define regVPMPCC_MCM_SHAPER_RAMA_REGION_22_23_BASE_IDX                                                 0
#define regVPMPCC_MCM_SHAPER_RAMA_REGION_24_25                                                          0x1074
#define regVPMPCC_MCM_SHAPER_RAMA_REGION_24_25_BASE_IDX                                                 0
#define regVPMPCC_MCM_SHAPER_RAMA_REGION_26_27                                                          0x1075
#define regVPMPCC_MCM_SHAPER_RAMA_REGION_26_27_BASE_IDX                                                 0
#define regVPMPCC_MCM_SHAPER_RAMA_REGION_28_29                                                          0x1076
#define regVPMPCC_MCM_SHAPER_RAMA_REGION_28_29_BASE_IDX                                                 0
#define regVPMPCC_MCM_SHAPER_RAMA_REGION_30_31                                                          0x1077
#define regVPMPCC_MCM_SHAPER_RAMA_REGION_30_31_BASE_IDX                                                 0
#define regVPMPCC_MCM_SHAPER_RAMA_REGION_32_33                                                          0x1078
#define regVPMPCC_MCM_SHAPER_RAMA_REGION_32_33_BASE_IDX                                                 0
#define regVPMPCC_MCM_3DLUT_MODE                                                                        0x1079
#define regVPMPCC_MCM_3DLUT_MODE_BASE_IDX                                                               0
#define regVPMPCC_MCM_3DLUT_INDEX                                                                       0x107a
#define regVPMPCC_MCM_3DLUT_INDEX_BASE_IDX                                                              0
#define regVPMPCC_MCM_3DLUT_DATA                                                                        0x107b
#define regVPMPCC_MCM_3DLUT_DATA_BASE_IDX                                                               0
#define regVPMPCC_MCM_3DLUT_DATA_30BIT                                                                  0x107c
#define regVPMPCC_MCM_3DLUT_DATA_30BIT_BASE_IDX                                                         0
#define regVPMPCC_MCM_3DLUT_READ_WRITE_CONTROL                                                          0x107d
#define regVPMPCC_MCM_3DLUT_READ_WRITE_CONTROL_BASE_IDX                                                 0
#define regVPMPCC_MCM_3DLUT_OUT_NORM_FACTOR                                                             0x107e
#define regVPMPCC_MCM_3DLUT_OUT_NORM_FACTOR_BASE_IDX                                                    0
#define regVPMPCC_MCM_3DLUT_OUT_OFFSET_R                                                                0x107f
#define regVPMPCC_MCM_3DLUT_OUT_OFFSET_R_BASE_IDX                                                       0
#define regVPMPCC_MCM_3DLUT_OUT_OFFSET_G                                                                0x1080
#define regVPMPCC_MCM_3DLUT_OUT_OFFSET_G_BASE_IDX                                                       0
#define regVPMPCC_MCM_3DLUT_OUT_OFFSET_B                                                                0x1081
#define regVPMPCC_MCM_3DLUT_OUT_OFFSET_B_BASE_IDX                                                       0
#define regVPMPCC_MCM_1DLUT_CONTROL                                                                     0x1082
#define regVPMPCC_MCM_1DLUT_CONTROL_BASE_IDX                                                            0
#define regVPMPCC_MCM_1DLUT_LUT_INDEX                                                                   0x1083
#define regVPMPCC_MCM_1DLUT_LUT_INDEX_BASE_IDX                                                          0
#define regVPMPCC_MCM_1DLUT_LUT_DATA                                                                    0x1084
#define regVPMPCC_MCM_1DLUT_LUT_DATA_BASE_IDX                                                           0
#define regVPMPCC_MCM_1DLUT_LUT_CONTROL                                                                 0x1085
#define regVPMPCC_MCM_1DLUT_LUT_CONTROL_BASE_IDX                                                        0
#define regVPMPCC_MCM_1DLUT_RAMA_START_CNTL_B                                                           0x1086
#define regVPMPCC_MCM_1DLUT_RAMA_START_CNTL_B_BASE_IDX                                                  0
#define regVPMPCC_MCM_1DLUT_RAMA_START_CNTL_G                                                           0x1087
#define regVPMPCC_MCM_1DLUT_RAMA_START_CNTL_G_BASE_IDX                                                  0
#define regVPMPCC_MCM_1DLUT_RAMA_START_CNTL_R                                                           0x1088
#define regVPMPCC_MCM_1DLUT_RAMA_START_CNTL_R_BASE_IDX                                                  0
#define regVPMPCC_MCM_1DLUT_RAMA_START_SLOPE_CNTL_B                                                     0x1089
#define regVPMPCC_MCM_1DLUT_RAMA_START_SLOPE_CNTL_B_BASE_IDX                                            0
#define regVPMPCC_MCM_1DLUT_RAMA_START_SLOPE_CNTL_G                                                     0x108a
#define regVPMPCC_MCM_1DLUT_RAMA_START_SLOPE_CNTL_G_BASE_IDX                                            0
#define regVPMPCC_MCM_1DLUT_RAMA_START_SLOPE_CNTL_R                                                     0x108b
#define regVPMPCC_MCM_1DLUT_RAMA_START_SLOPE_CNTL_R_BASE_IDX                                            0
#define regVPMPCC_MCM_1DLUT_RAMA_START_BASE_CNTL_B                                                      0x108c
#define regVPMPCC_MCM_1DLUT_RAMA_START_BASE_CNTL_B_BASE_IDX                                             0
#define regVPMPCC_MCM_1DLUT_RAMA_START_BASE_CNTL_G                                                      0x108d
#define regVPMPCC_MCM_1DLUT_RAMA_START_BASE_CNTL_G_BASE_IDX                                             0
#define regVPMPCC_MCM_1DLUT_RAMA_START_BASE_CNTL_R                                                      0x108e
#define regVPMPCC_MCM_1DLUT_RAMA_START_BASE_CNTL_R_BASE_IDX                                             0
#define regVPMPCC_MCM_1DLUT_RAMA_END_CNTL1_B                                                            0x108f
#define regVPMPCC_MCM_1DLUT_RAMA_END_CNTL1_B_BASE_IDX                                                   0
#define regVPMPCC_MCM_1DLUT_RAMA_END_CNTL2_B                                                            0x1090
#define regVPMPCC_MCM_1DLUT_RAMA_END_CNTL2_B_BASE_IDX                                                   0
#define regVPMPCC_MCM_1DLUT_RAMA_END_CNTL1_G                                                            0x1091
#define regVPMPCC_MCM_1DLUT_RAMA_END_CNTL1_G_BASE_IDX                                                   0
#define regVPMPCC_MCM_1DLUT_RAMA_END_CNTL2_G                                                            0x1092
#define regVPMPCC_MCM_1DLUT_RAMA_END_CNTL2_G_BASE_IDX                                                   0
#define regVPMPCC_MCM_1DLUT_RAMA_END_CNTL1_R                                                            0x1093
#define regVPMPCC_MCM_1DLUT_RAMA_END_CNTL1_R_BASE_IDX                                                   0
#define regVPMPCC_MCM_1DLUT_RAMA_END_CNTL2_R                                                            0x1094
#define regVPMPCC_MCM_1DLUT_RAMA_END_CNTL2_R_BASE_IDX                                                   0
#define regVPMPCC_MCM_1DLUT_RAMA_OFFSET_B                                                               0x1095
#define regVPMPCC_MCM_1DLUT_RAMA_OFFSET_B_BASE_IDX                                                      0
#define regVPMPCC_MCM_1DLUT_RAMA_OFFSET_G                                                               0x1096
#define regVPMPCC_MCM_1DLUT_RAMA_OFFSET_G_BASE_IDX                                                      0
#define regVPMPCC_MCM_1DLUT_RAMA_OFFSET_R                                                               0x1097
#define regVPMPCC_MCM_1DLUT_RAMA_OFFSET_R_BASE_IDX                                                      0
#define regVPMPCC_MCM_1DLUT_RAMA_REGION_0_1                                                             0x1098
#define regVPMPCC_MCM_1DLUT_RAMA_REGION_0_1_BASE_IDX                                                    0
#define regVPMPCC_MCM_1DLUT_RAMA_REGION_2_3                                                             0x1099
#define regVPMPCC_MCM_1DLUT_RAMA_REGION_2_3_BASE_IDX                                                    0
#define regVPMPCC_MCM_1DLUT_RAMA_REGION_4_5                                                             0x109a
#define regVPMPCC_MCM_1DLUT_RAMA_REGION_4_5_BASE_IDX                                                    0
#define regVPMPCC_MCM_1DLUT_RAMA_REGION_6_7                                                             0x109b
#define regVPMPCC_MCM_1DLUT_RAMA_REGION_6_7_BASE_IDX                                                    0
#define regVPMPCC_MCM_1DLUT_RAMA_REGION_8_9                                                             0x109c
#define regVPMPCC_MCM_1DLUT_RAMA_REGION_8_9_BASE_IDX                                                    0
#define regVPMPCC_MCM_1DLUT_RAMA_REGION_10_11                                                           0x109d
#define regVPMPCC_MCM_1DLUT_RAMA_REGION_10_11_BASE_IDX                                                  0
#define regVPMPCC_MCM_1DLUT_RAMA_REGION_12_13                                                           0x109e
#define regVPMPCC_MCM_1DLUT_RAMA_REGION_12_13_BASE_IDX                                                  0
#define regVPMPCC_MCM_1DLUT_RAMA_REGION_14_15                                                           0x109f
#define regVPMPCC_MCM_1DLUT_RAMA_REGION_14_15_BASE_IDX                                                  0
#define regVPMPCC_MCM_1DLUT_RAMA_REGION_16_17                                                           0x10a0
#define regVPMPCC_MCM_1DLUT_RAMA_REGION_16_17_BASE_IDX                                                  0
#define regVPMPCC_MCM_1DLUT_RAMA_REGION_18_19                                                           0x10a1
#define regVPMPCC_MCM_1DLUT_RAMA_REGION_18_19_BASE_IDX                                                  0
#define regVPMPCC_MCM_1DLUT_RAMA_REGION_20_21                                                           0x10a2
#define regVPMPCC_MCM_1DLUT_RAMA_REGION_20_21_BASE_IDX                                                  0
#define regVPMPCC_MCM_1DLUT_RAMA_REGION_22_23                                                           0x10a3
#define regVPMPCC_MCM_1DLUT_RAMA_REGION_22_23_BASE_IDX                                                  0
#define regVPMPCC_MCM_1DLUT_RAMA_REGION_24_25                                                           0x10a4
#define regVPMPCC_MCM_1DLUT_RAMA_REGION_24_25_BASE_IDX                                                  0
#define regVPMPCC_MCM_1DLUT_RAMA_REGION_26_27                                                           0x10a5
#define regVPMPCC_MCM_1DLUT_RAMA_REGION_26_27_BASE_IDX                                                  0
#define regVPMPCC_MCM_1DLUT_RAMA_REGION_28_29                                                           0x10a6
#define regVPMPCC_MCM_1DLUT_RAMA_REGION_28_29_BASE_IDX                                                  0
#define regVPMPCC_MCM_1DLUT_RAMA_REGION_30_31                                                           0x10a7
#define regVPMPCC_MCM_1DLUT_RAMA_REGION_30_31_BASE_IDX                                                  0
#define regVPMPCC_MCM_1DLUT_RAMA_REGION_32_33                                                           0x10a8
#define regVPMPCC_MCM_1DLUT_RAMA_REGION_32_33_BASE_IDX                                                  0
#define regVPMPCC_MCM_MEM_PWR_CTRL                                                                      0x10a9
#define regVPMPCC_MCM_MEM_PWR_CTRL_BASE_IDX                                                             0
#define regVPMPCC_MCM_TEST_DEBUG_INDEX                                                                  0x10ab
#define regVPMPCC_MCM_TEST_DEBUG_INDEX_BASE_IDX                                                         0
#define regVPMPCC_MCM_TEST_DEBUG_DATA                                                                   0x10ac
#define regVPMPCC_MCM_TEST_DEBUG_DATA_BASE_IDX                                                          0


// addressBlock: vpe_vpep_vpmpc_vpmpc_ocsc_dispdec
// base address: 0x0
#define regVPMPC_OUT0_MUX                                                                               0x0fcc
#define regVPMPC_OUT0_MUX_BASE_IDX                                                                      0
#define regVPMPC_OUT0_FLOAT_CONTROL                                                                     0x0fcd
#define regVPMPC_OUT0_FLOAT_CONTROL_BASE_IDX                                                            0
#define regVPMPC_OUT0_DENORM_CONTROL                                                                    0x0fce
#define regVPMPC_OUT0_DENORM_CONTROL_BASE_IDX                                                           0
#define regVPMPC_OUT0_DENORM_CLAMP_G_Y                                                                  0x0fcf
#define regVPMPC_OUT0_DENORM_CLAMP_G_Y_BASE_IDX                                                         0
#define regVPMPC_OUT0_DENORM_CLAMP_B_CB                                                                 0x0fd0
#define regVPMPC_OUT0_DENORM_CLAMP_B_CB_BASE_IDX                                                        0
#define regVPMPC_OUT_CSC_COEF_FORMAT                                                                    0x0fe4
#define regVPMPC_OUT_CSC_COEF_FORMAT_BASE_IDX                                                           0
#define regVPMPC_OUT0_CSC_MODE                                                                          0x0fe5
#define regVPMPC_OUT0_CSC_MODE_BASE_IDX                                                                 0
#define regVPMPC_OUT0_CSC_C11_C12_A                                                                     0x0fe6
#define regVPMPC_OUT0_CSC_C11_C12_A_BASE_IDX                                                            0
#define regVPMPC_OUT0_CSC_C13_C14_A                                                                     0x0fe7
#define regVPMPC_OUT0_CSC_C13_C14_A_BASE_IDX                                                            0
#define regVPMPC_OUT0_CSC_C21_C22_A                                                                     0x0fe8
#define regVPMPC_OUT0_CSC_C21_C22_A_BASE_IDX                                                            0
#define regVPMPC_OUT0_CSC_C23_C24_A                                                                     0x0fe9
#define regVPMPC_OUT0_CSC_C23_C24_A_BASE_IDX                                                            0
#define regVPMPC_OUT0_CSC_C31_C32_A                                                                     0x0fea
#define regVPMPC_OUT0_CSC_C31_C32_A_BASE_IDX                                                            0
#define regVPMPC_OUT0_CSC_C33_C34_A                                                                     0x0feb
#define regVPMPC_OUT0_CSC_C33_C34_A_BASE_IDX                                                            0
#define regVPMPC_OCSC_TEST_DEBUG_INDEX                                                                  0x1035
#define regVPMPC_OCSC_TEST_DEBUG_INDEX_BASE_IDX                                                         0
#define regVPMPC_OCSC_TEST_DEBUG_DATA                                                                   0x1036
#define regVPMPC_OCSC_TEST_DEBUG_DATA_BASE_IDX                                                          0


// addressBlock: vpe_vpep_vpopp_vpfmt0_dispdec
// base address: 0x0
#define regVPFMT_CLAMP_COMPONENT_R                                                                      0x12b0
#define regVPFMT_CLAMP_COMPONENT_R_BASE_IDX                                                             0
#define regVPFMT_CLAMP_COMPONENT_G                                                                      0x12b1
#define regVPFMT_CLAMP_COMPONENT_G_BASE_IDX                                                             0
#define regVPFMT_CLAMP_COMPONENT_B                                                                      0x12b2
#define regVPFMT_CLAMP_COMPONENT_B_BASE_IDX                                                             0
#define regVPFMT_DYNAMIC_EXP_CNTL                                                                       0x12b3
#define regVPFMT_DYNAMIC_EXP_CNTL_BASE_IDX                                                              0
#define regVPFMT_CONTROL                                                                                0x12b4
#define regVPFMT_CONTROL_BASE_IDX                                                                       0
#define regVPFMT_BIT_DEPTH_CONTROL                                                                      0x12b5
#define regVPFMT_BIT_DEPTH_CONTROL_BASE_IDX                                                             0
#define regVPFMT_DITHER_RAND_R_SEED                                                                     0x12b6
#define regVPFMT_DITHER_RAND_R_SEED_BASE_IDX                                                            0
#define regVPFMT_DITHER_RAND_G_SEED                                                                     0x12b7
#define regVPFMT_DITHER_RAND_G_SEED_BASE_IDX                                                            0
#define regVPFMT_DITHER_RAND_B_SEED                                                                     0x12b8
#define regVPFMT_DITHER_RAND_B_SEED_BASE_IDX                                                            0
#define regVPFMT_CLAMP_CNTL                                                                             0x12b9
#define regVPFMT_CLAMP_CNTL_BASE_IDX                                                                    0
#define regVPFMT_DEBUG_CNTL                                                                             0x12bc
#define regVPFMT_DEBUG_CNTL_BASE_IDX                                                                    0
#define regVPFMT_TEST_DEBUG_INDEX                                                                       0x12be
#define regVPFMT_TEST_DEBUG_INDEX_BASE_IDX                                                              0
#define regVPFMT_TEST_DEBUG_DATA                                                                        0x12bf
#define regVPFMT_TEST_DEBUG_DATA_BASE_IDX                                                               0


// addressBlock: vpe_vpep_vpopp_vpopp_pipe0_dispdec
// base address: 0x0
#define regVPOPP_PIPE_CONTROL                                                                           0x12e8
#define regVPOPP_PIPE_CONTROL_BASE_IDX                                                                  0
#define regVPOPP_PIPE_SPARE_DEBUG                                                                       0x12e9
#define regVPOPP_PIPE_SPARE_DEBUG_BASE_IDX                                                              0
#define regVPOPP_PIPE_TEST_DEBUG_INDEX                                                                  0x12ea
#define regVPOPP_PIPE_TEST_DEBUG_INDEX_BASE_IDX                                                         0
#define regVPOPP_PIPE_TEST_DEBUG_DATA                                                                   0x12eb
#define regVPOPP_PIPE_TEST_DEBUG_DATA_BASE_IDX                                                          0


// addressBlock: vpe_vpep_vpopp_vpopp_pipe_crc0_dispdec
// base address: 0x0
#define regVPOPP_PIPE_CRC_CONTROL                                                                       0x12ee
#define regVPOPP_PIPE_CRC_CONTROL_BASE_IDX                                                              0
#define regVPOPP_PIPE_CRC_MASK                                                                          0x12ef
#define regVPOPP_PIPE_CRC_MASK_BASE_IDX                                                                 0
#define regVPOPP_PIPE_CRC_RESULT0                                                                       0x12f0
#define regVPOPP_PIPE_CRC_RESULT0_BASE_IDX                                                              0
#define regVPOPP_PIPE_CRC_RESULT1                                                                       0x12f1
#define regVPOPP_PIPE_CRC_RESULT1_BASE_IDX                                                              0
#define regVPOPP_PIPE_CRC_RESULT2                                                                       0x12f2
#define regVPOPP_PIPE_CRC_RESULT2_BASE_IDX                                                              0


// addressBlock: vpe_vpep_vpopp_vpopp_top_dispdec
// base address: 0x0
#define regVPOPP_TOP_CLK_CONTROL                                                                        0x13c2
#define regVPOPP_TOP_CLK_CONTROL_BASE_IDX                                                               0
#define regVPOPP_DEBUG_CONTROL                                                                          0x13c3
#define regVPOPP_DEBUG_CONTROL_BASE_IDX                                                                 0
#define regVPOPP_TOP_SPARE_DEBUG                                                                        0x13c4
#define regVPOPP_TOP_SPARE_DEBUG_BASE_IDX                                                               0
#define regVPOPP_TOP_TEST_DEBUG_INDEX                                                                   0x13c5
#define regVPOPP_TOP_TEST_DEBUG_INDEX_BASE_IDX                                                          0
#define regVPOPP_TOP_TEST_DEBUG_DATA                                                                    0x13c6
#define regVPOPP_TOP_TEST_DEBUG_DATA_BASE_IDX                                                           0


// addressBlock: vpe_vpep_vpcdc_cdc_dispdec
// base address: 0x0
#define regVPEP_MGCG_CNTL                                                                               0x0600
#define regVPEP_MGCG_CNTL_BASE_IDX                                                                      0
#define regVPCDC_SOFT_RESET                                                                             0x0601
#define regVPCDC_SOFT_RESET_BASE_IDX                                                                    0
#define regVPCDC_FE0_SURFACE_CONFIG                                                                     0x0602
#define regVPCDC_FE0_SURFACE_CONFIG_BASE_IDX                                                            0
#define regVPCDC_FE0_CROSSBAR_CONFIG                                                                    0x0603
#define regVPCDC_FE0_CROSSBAR_CONFIG_BASE_IDX                                                           0
#define regVPCDC_FE0_VIEWPORT_START_CONFIG                                                              0x0604
#define regVPCDC_FE0_VIEWPORT_START_CONFIG_BASE_IDX                                                     0
#define regVPCDC_FE0_VIEWPORT_DIMENSION_CONFIG                                                          0x0605
#define regVPCDC_FE0_VIEWPORT_DIMENSION_CONFIG_BASE_IDX                                                 0
#define regVPCDC_FE0_VIEWPORT_START_C_CONFIG                                                            0x0606
#define regVPCDC_FE0_VIEWPORT_START_C_CONFIG_BASE_IDX                                                   0
#define regVPCDC_FE0_VIEWPORT_DIMENSION_C_CONFIG                                                        0x0607
#define regVPCDC_FE0_VIEWPORT_DIMENSION_C_CONFIG_BASE_IDX                                               0
#define regVPCDC_BE0_P2B_CONFIG                                                                         0x0608
#define regVPCDC_BE0_P2B_CONFIG_BASE_IDX                                                                0
#define regVPCDC_BE0_GLOBAL_SYNC_CONFIG                                                                 0x0609
#define regVPCDC_BE0_GLOBAL_SYNC_CONFIG_BASE_IDX                                                        0
#define regVPCDC_GLOBAL_SYNC_TRIGGER                                                                    0x060a
#define regVPCDC_GLOBAL_SYNC_TRIGGER_BASE_IDX                                                           0
#define regVPCDC_VREADY_STATUS                                                                          0x060b
#define regVPCDC_VREADY_STATUS_BASE_IDX                                                                 0
#define regVPEP_MEM_GLOBAL_PWR_REQ_CNTL                                                                 0x060c
#define regVPEP_MEM_GLOBAL_PWR_REQ_CNTL_BASE_IDX                                                        0
#define regVPFE_MEM_PWR_CNTL                                                                            0x060d
#define regVPFE_MEM_PWR_CNTL_BASE_IDX                                                                   0
#define regVPBE_MEM_PWR_CNTL                                                                            0x060e
#define regVPBE_MEM_PWR_CNTL_BASE_IDX                                                                   0
#define regVPEP_RBBMIF_TIMEOUT                                                                          0x060f
#define regVPEP_RBBMIF_TIMEOUT_BASE_IDX                                                                 0
#define regVPEP_RBBMIF_STATUS                                                                           0x0610
#define regVPEP_RBBMIF_STATUS_BASE_IDX                                                                  0
#define regVPEP_RBBMIF_TIMEOUT_DIS                                                                      0x0611
#define regVPEP_RBBMIF_TIMEOUT_DIS_BASE_IDX                                                             0
#define regVPCDC_DEBUG_CTRL0                                                                            0x0612
#define regVPCDC_DEBUG_CTRL0_BASE_IDX                                                                   0
#define regVPCDC_DEBUG_CTRL1                                                                            0x0613
#define regVPCDC_DEBUG_CTRL1_BASE_IDX                                                                   0
#define regVPCDC_TEST_DEBUG_INDEX                                                                       0x0614
#define regVPCDC_TEST_DEBUG_INDEX_BASE_IDX                                                              0
#define regVPCDC_TEST_DEBUG_DATA                                                                        0x0615
#define regVPCDC_TEST_DEBUG_DATA_BASE_IDX                                                               0


// addressBlock: vpe_vpep_vpcdc_vpcdc_dcperfmon_dc_perfmon_dispdec
// base address: 0x3a708
#define regPERFCOUNTER_CNTL                                                                             0x0682
#define regPERFCOUNTER_CNTL_BASE_IDX                                                                    0
#define regPERFCOUNTER_CNTL2                                                                            0x0683
#define regPERFCOUNTER_CNTL2_BASE_IDX                                                                   0
#define regPERFCOUNTER_STATE                                                                            0x0684
#define regPERFCOUNTER_STATE_BASE_IDX                                                                   0
#define regPERFMON_CNTL                                                                                 0x0685
#define regPERFMON_CNTL_BASE_IDX                                                                        0
#define regPERFMON_CNTL2                                                                                0x0686
#define regPERFMON_CNTL2_BASE_IDX                                                                       0
#define regPERFMON_CVALUE_INT_MISC                                                                      0x0687
#define regPERFMON_CVALUE_INT_MISC_BASE_IDX                                                             0
#define regPERFMON_CVALUE_LOW                                                                           0x0688
#define regPERFMON_CVALUE_LOW_BASE_IDX                                                                  0
#define regPERFMON_HI                                                                                   0x0689
#define regPERFMON_HI_BASE_IDX                                                                          0
#define regPERFMON_LOW                                                                                  0x068a
#define regPERFMON_LOW_BASE_IDX                                                                         0
#define regPERFMON_TEST_DEBUG_INDEX                                                                     0x068b
#define regPERFMON_TEST_DEBUG_INDEX_BASE_IDX                                                            0
#define regPERFMON_TEST_DEBUG_DATA                                                                      0x068c
#define regPERFMON_TEST_DEBUG_DATA_BASE_IDX                                                             0


// addressBlock: dc_perfmon_dc_perfmondebugind
// base address: 0x0
#define ixPERFMON_DEBUG_ID                                                                             0x0000
#define ixPERFMON_DEBUG01                                                                              0x0001
#define ixPERFMON_DEBUG02                                                                              0x0002
#define ixPERFMON_DEBUG03                                                                              0x0003
#define ixPERFMON_DEBUG04                                                                              0x0004
#define ixPERFMON_DEBUG05                                                                              0x0005
#define ixPERFMON_DEBUG06                                                                              0x0006
#define ixPERFMON_DEBUG07                                                                              0x0007
#define ixPERFMON_DEBUG08                                                                              0x0008
#define ixPERFMON_DEBUG09                                                                              0x0009
#define ixPERFMON_DEBUG0A                                                                              0x000a
#define ixPERFMON_DEBUG0B                                                                              0x000b
#define ixPERFMON_DEBUG0C                                                                              0x000c
#define ixPERFMON_DEBUG0D                                                                              0x000d
#define ixPERFMON_DEBUG0E                                                                              0x000e
#define ixPERFMON_DEBUG0F                                                                              0x000f
#define ixPERFMON_DEBUG10                                                                              0x0010
#define ixPERFMON_DEBUG11                                                                              0x0011
#define ixPERFMON_DEBUG12                                                                              0x0012


// addressBlock: vpfmt0_vpfmtdebugind
// base address: 0x0
#define ixVPFMT_DEBUG_ID                                                                               0x0000
#define ixVPFMT_DEBUG0                                                                                 0x0001
#define ixVPFMT_DEBUG1                                                                                 0x0002
#define ixVPFMT_DEBUG2                                                                                 0x0003
#define ixVPFMT_DEBUG3                                                                                 0x0004
#define ixVPFMT_DEBUG4                                                                                 0x0005
#define ixVPFMT_DEBUG5                                                                                 0x0006
#define ixVPFMT_DEBUG6                                                                                 0x0007
#define ixVPFMT_DEBUG7                                                                                 0x0008
#define ixVPFMT_DEBUG8                                                                                 0x0009
#define ixVPFMT_DEBUG9                                                                                 0x000a
#define ixVPFMT_DEBUG10                                                                                0x000b
#define ixVPFMT_DEBUG11                                                                                0x000c


// addressBlock: vpopp_pipe0_vpopppipedebugind
// base address: 0x0
#define ixVPOPP_PIPE_DEBUG_ID                                                                          0x0000
#define ixVPOPP_PIPE_DEBUG_0                                                                           0x0001
#define ixVPOPP_PIPE_DEBUG_1                                                                           0x0002
#define ixVPOPP_PIPE_DEBUG_2                                                                           0x0003


// addressBlock: vpopp_top_vpopp_topdebugind
// base address: 0x0
#define ixVPOPP_TOP_DEBUG_ID                                                                           0x0000

#endif
