/*
          Copyright (C) 1993, 1994, RSNA and Washington University

          The software and supporting documentation for the Radiological
          Society of North America (RSNA) 1993, 1994 Digital Imaging and
          Communications in Medicine (DICOM) Demonstration were developed
          at the
                  Electronic Radiology Laboratory
                  Mallinckrodt Institute of Radiology
                  Washington University School of Medicine
                  510 S. Kingshighway Blvd.
                  St. Louis, MO 63110
          as part of the 1993, 1994 DICOM Central Test Node project for, and
          under contract with, the Radiological Society of North America.

          THIS SOFTWARE IS MADE AVAILABLE, AS IS, AND NEITHER RSNA NOR
          WASHINGTON UNIVERSITY MAKE ANY WARRANTY ABOUT THE SOFTWARE, ITS
          PERFORMANCE, ITS MERCHANTABILITY OR FITNESS FOR ANY PARTICULAR
          USE, FREEDOM FROM ANY COMPUTER DISEASES OR ITS CONFORMITY TO ANY
          SPECIFICATION. THE ENTIRE RISK AS TO QUALITY AND PERFORMANCE OF
          THE SOFTWARE IS WITH THE USER.

          Copyright of the software and supporting documentation is
          jointly owned by RSNA and Washington University, and free access
          is hereby granted as a license to use this software, copy this
          software and prepare derivative works based upon this software.
          However, any distribution of this software source code or
          supporting documentation or derivative works (source code and
          supporting documentation) must include the three paragraphs of
          the copyright notice.
*/
/* Copyright marker.  Copyright will be inserted above.  Do not remove */
/*
**				DICOM 93
**		     Electronic Radiology Laboratory
**		   Mallinckrodt Institute of Radiology
**		Washington University School of Medicine
**
** Module Name(s):
** Author, Date:	Stephen M. More, 18-June-1992
** Intent:		Include file for resize functions.
** Last Update:		$Author: smm $, $Date: 1994-12-30 18:33:25 $
** Source File:		$RCSfile: pixavg.h,v $
** Revision:		$Revision: 1.4 $
** Status:		$State: Exp $
*/

#define	SIGNED_16BIT	1
#define	SIGNED_8BIT	2
#define	UNSIGNED_16BIT	3
#define	UNSIGNED_8BIT	4

static CONDITION
pixelavg16signed(short *pixels, unsigned long rows,
		 unsigned long cols, unsigned long factor,
	    short **pixout, unsigned long *newRows, unsigned long *newCols);

static CONDITION
pixelavg8unsigned(unsigned char *pixels, unsigned long rows,
		  unsigned long cols, unsigned long factor,
	    short **pixout, unsigned long *newRows, unsigned long *newCols);

CONDITION
pixelResize(void *pixels, unsigned long rows, unsigned long cols,
	    int type, unsigned long desiredRows, unsigned long desiredCols, int mask_flag, int and_flag,
	    void **pixout, unsigned long *newRows, unsigned long *newCols);
