<?xml version='1.0' encoding='UTF-8' standalone='yes' ?>
<tagfile>
  <compound kind="file">
    <name>barrier.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/C/threads/</path>
    <filename>barrier_8h</filename>
    <includes id="common_8h" name="common.h" local="no" imported="no">Inventor/C/threads/common.h</includes>
    <member kind="function">
      <type>cc_barrier *</type>
      <name>cc_barrier_construct</name>
      <anchorfile>barrier_8h.html</anchorfile>
      <anchor>a08b3fa4e3a37add61b05759033d4de1b</anchor>
      <arglist>(unsigned int numthreads)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_barrier_destruct</name>
      <anchorfile>barrier_8h.html</anchorfile>
      <anchor>aadab0c4cb10481f3e272885a84a4709d</anchor>
      <arglist>(cc_barrier *barrier)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cc_barrier_enter</name>
      <anchorfile>barrier_8h.html</anchorfile>
      <anchor>acb9ec6cb444608a16d1bed98a55949ae</anchor>
      <arglist>(cc_barrier *barrier)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>common.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/C/threads/</path>
    <filename>common_8h</filename>
    <member kind="typedef">
      <type>struct cc_sched</type>
      <name>cc_sched</name>
      <anchorfile>common_8h.html</anchorfile>
      <anchor>a42acbbf50baecd447dfbc76305b4bafb</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>struct cc_wpool</type>
      <name>cc_wpool</name>
      <anchorfile>common_8h.html</anchorfile>
      <anchor>a5cd98b5d28446124b569ac260b1ca774</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>struct cc_worker</type>
      <name>cc_worker</name>
      <anchorfile>common_8h.html</anchorfile>
      <anchor>a256d99f9f55c522f7b478a5e091a7aa6</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>struct cc_thread</type>
      <name>cc_thread</name>
      <anchorfile>common_8h.html</anchorfile>
      <anchor>a125b0ce154c9b9ead0a92df5abdbed70</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>struct cc_mutex</type>
      <name>cc_mutex</name>
      <anchorfile>common_8h.html</anchorfile>
      <anchor>a480e847013035e71e32afbb8f8470626</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>struct cc_rwmutex</type>
      <name>cc_rwmutex</name>
      <anchorfile>common_8h.html</anchorfile>
      <anchor>a2aeb009bcdf2e26aa2bb3275e09422cb</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>struct cc_condvar</type>
      <name>cc_condvar</name>
      <anchorfile>common_8h.html</anchorfile>
      <anchor>a4009ed32241ef5637806e8526c9061db</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>struct cc_storage</type>
      <name>cc_storage</name>
      <anchorfile>common_8h.html</anchorfile>
      <anchor>a39bad19f9e36be7b7ec7c498e1a7254a</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>struct cc_fifo</type>
      <name>cc_fifo</name>
      <anchorfile>common_8h.html</anchorfile>
      <anchor>a7d996ed6e701d03f8e9480b55a540828</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>struct cc_barrier</type>
      <name>cc_barrier</name>
      <anchorfile>common_8h.html</anchorfile>
      <anchor>a697b4c8e006ee21aacf099a7377a8ea4</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>struct cc_recmutex</type>
      <name>cc_recmutex</name>
      <anchorfile>common_8h.html</anchorfile>
      <anchor>a33e7e331036f7b76a8b14ad03a226969</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>cc_precedence</name>
      <anchorfile>common_8h.html</anchorfile>
      <anchor>a8fee93200a830bf8d695dc1ad90284bc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>cc_threads_implementation</name>
      <anchorfile>common_8h.html</anchorfile>
      <anchor>a8aea26903d4582f3645184059e50e25c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>cc_retval</name>
      <anchorfile>common_8h.html</anchorfile>
      <anchor>afb1e455fcfc68469973c055b20999d1b</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cc_thread_implementation</name>
      <anchorfile>common_8h.html</anchorfile>
      <anchor>a135759144d479fdfc6346eb99bd6a91f</anchor>
      <arglist>(void)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>condvar.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/C/threads/</path>
    <filename>condvar_8h</filename>
    <includes id="common_8h" name="common.h" local="no" imported="no">Inventor/C/threads/common.h</includes>
    <member kind="function">
      <type>cc_condvar *</type>
      <name>cc_condvar_construct</name>
      <anchorfile>condvar_8h.html</anchorfile>
      <anchor>af43cd24911db044ca2481fdccde7a1f0</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_condvar_destruct</name>
      <anchorfile>condvar_8h.html</anchorfile>
      <anchor>afb0209d8ddc637437fe467c14d407832</anchor>
      <arglist>(cc_condvar *condvar)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cc_condvar_wait</name>
      <anchorfile>condvar_8h.html</anchorfile>
      <anchor>aef8501afbc406efd662e8175546edd14</anchor>
      <arglist>(cc_condvar *condvar, cc_mutex *mutex)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cc_condvar_timed_wait</name>
      <anchorfile>condvar_8h.html</anchorfile>
      <anchor>aa52ad3084323b1619ab73d5eaf6fbb88</anchor>
      <arglist>(cc_condvar *condvar, cc_mutex *mutex, cc_time period)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_condvar_wake_one</name>
      <anchorfile>condvar_8h.html</anchorfile>
      <anchor>a07daf12565da74c1c8adc7a3023468a5</anchor>
      <arglist>(cc_condvar *condvar)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_condvar_wake_all</name>
      <anchorfile>condvar_8h.html</anchorfile>
      <anchor>aa0855441ff36d1ad59ec4e576ff85e0d</anchor>
      <arglist>(cc_condvar *condvar)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>debugerror.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/C/errors/</path>
    <filename>debugerror_8h</filename>
    <includes id="error_8h" name="error.h" local="no" imported="no">Inventor/C/errors/error.h</includes>
    <member kind="typedef">
      <type>struct cc_debugerror</type>
      <name>cc_debugerror</name>
      <anchorfile>group__errors.html</anchorfile>
      <anchor>ga98981b5dfb3a50dba80de1fdf6aa9109</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>void</type>
      <name>cc_debugerror_cb</name>
      <anchorfile>debugerror_8h.html</anchorfile>
      <anchor>a1d3f377f90c7732d23b13dc8fd80c7e3</anchor>
      <arglist>(const cc_debugerror *err, void *data)</arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>CC_DEBUGERROR_SEVERITY</name>
      <anchorfile>debugerror_8h.html</anchorfile>
      <anchor>a6f1bb3b059794d3c57998471a0dc33e3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>CC_DEBUGERROR_ERROR</name>
      <anchorfile>debugerror_8h.html</anchorfile>
      <anchor>a6f1bb3b059794d3c57998471a0dc33e3a7f3503747456ebd36e35051d2b5cd09a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>CC_DEBUGERROR_WARNING</name>
      <anchorfile>debugerror_8h.html</anchorfile>
      <anchor>a6f1bb3b059794d3c57998471a0dc33e3a60b297f683404656a5c76db3feab4eb0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>CC_DEBUGERROR_INFO</name>
      <anchorfile>debugerror_8h.html</anchorfile>
      <anchor>a6f1bb3b059794d3c57998471a0dc33e3a3b48d0a938231b85aee9d4a58d8f0f56</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>error.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/C/errors/</path>
    <filename>error_8h</filename>
    <includes id="string_8h" name="string.h" local="no" imported="no">Inventor/C/base/string.h</includes>
    <member kind="typedef">
      <type>struct cc_error</type>
      <name>cc_error</name>
      <anchorfile>group__errors.html</anchorfile>
      <anchor>ga1fb56dcbdf4946c4519c715b92caca14</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>void</type>
      <name>cc_error_cb</name>
      <anchorfile>error_8h.html</anchorfile>
      <anchor>ac4504cffc1a4f2f2bc889178d3818f75</anchor>
      <arglist>(const cc_error *err, void *data)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>fifo.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/C/threads/</path>
    <filename>fifo_8h</filename>
    <includes id="common_8h" name="common.h" local="no" imported="no">Inventor/C/threads/common.h</includes>
    <member kind="function">
      <type>cc_fifo *</type>
      <name>cc_fifo_new</name>
      <anchorfile>fifo_8h.html</anchorfile>
      <anchor>a4e4fcdd2972f0f1bb11b2d4745079191</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_fifo_delete</name>
      <anchorfile>fifo_8h.html</anchorfile>
      <anchor>aef1a8b82445d1674f0d9806e4e86ab4b</anchor>
      <arglist>(cc_fifo *fifo)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_fifo_assign</name>
      <anchorfile>fifo_8h.html</anchorfile>
      <anchor>a4b59b38f87481efc2041bb7bc2c8a13c</anchor>
      <arglist>(cc_fifo *fifo, void *ptr, uint32_t type)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_fifo_retrieve</name>
      <anchorfile>fifo_8h.html</anchorfile>
      <anchor>ae22cfbc1394df9c68a2518d00b33f406</anchor>
      <arglist>(cc_fifo *fifo, void **ptr, uint32_t *type)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>cc_fifo_try_retrieve</name>
      <anchorfile>fifo_8h.html</anchorfile>
      <anchor>aecd1aa4e9efb711dbbba929fcf23c17b</anchor>
      <arglist>(cc_fifo *fifo, void **ptr, uint32_t *type)</arglist>
    </member>
    <member kind="function">
      <type>unsigned int</type>
      <name>cc_fifo_size</name>
      <anchorfile>fifo_8h.html</anchorfile>
      <anchor>a3cf31898a7217a97ef00324cc0d6e0c5</anchor>
      <arglist>(cc_fifo *fifo)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_fifo_lock</name>
      <anchorfile>fifo_8h.html</anchorfile>
      <anchor>a654abc1b5249b4b8348f4aebb52bd900</anchor>
      <arglist>(cc_fifo *fifo)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_fifo_unlock</name>
      <anchorfile>fifo_8h.html</anchorfile>
      <anchor>a97d46b795994d8e6d7237d99393d8d94</anchor>
      <arglist>(cc_fifo *fifo)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>cc_fifo_peek</name>
      <anchorfile>fifo_8h.html</anchorfile>
      <anchor>a254a1a966ae1da0153f884e9b1df2c92</anchor>
      <arglist>(cc_fifo *fifo, void **item, uint32_t *type)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>cc_fifo_contains</name>
      <anchorfile>fifo_8h.html</anchorfile>
      <anchor>af9f1a63db8598d795a3b5f07fcca52f4</anchor>
      <arglist>(cc_fifo *fifo, void *item)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>cc_fifo_reclaim</name>
      <anchorfile>fifo_8h.html</anchorfile>
      <anchor>ab43246ce53fc777cfefcd85407e08e83</anchor>
      <arglist>(cc_fifo *fifo, void *item)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>hash.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/C/base/</path>
    <filename>hash_8h</filename>
    <member kind="typedef">
      <type>uintptr_t</type>
      <name>cc_hash_key</name>
      <anchorfile>hash_8h.html</anchorfile>
      <anchor>af06662abf2e6f6f516b00673cba5969b</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>struct cc_hash</type>
      <name>cc_hash</name>
      <anchorfile>hash_8h.html</anchorfile>
      <anchor>a727fda23295414ad0fc28e16be55f8aa</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>cc_hash_key</type>
      <name>cc_hash_func</name>
      <anchorfile>hash_8h.html</anchorfile>
      <anchor>a4898219b43dabf39e47a1d061c440277</anchor>
      <arglist>(const cc_hash_key key)</arglist>
    </member>
    <member kind="typedef">
      <type>void</type>
      <name>cc_hash_apply_func</name>
      <anchorfile>hash_8h.html</anchorfile>
      <anchor>ac1fff00729b2bb34f90bfbd4121a2e61</anchor>
      <arglist>(cc_hash_key key, void *val, void *closure)</arglist>
    </member>
    <member kind="function">
      <type>cc_hash *</type>
      <name>cc_hash_construct</name>
      <anchorfile>hash_8h.html</anchorfile>
      <anchor>a5ddc99f3996de4a625ff68a415fe597b</anchor>
      <arglist>(unsigned int size, float loadfactor)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_hash_destruct</name>
      <anchorfile>hash_8h.html</anchorfile>
      <anchor>aec73575d34a0ef54ae43d36ff056ddd9</anchor>
      <arglist>(cc_hash *ht)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_hash_clear</name>
      <anchorfile>hash_8h.html</anchorfile>
      <anchor>a7f7571eab4742e08fe4a0290dc97369a</anchor>
      <arglist>(cc_hash *ht)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>cc_hash_put</name>
      <anchorfile>hash_8h.html</anchorfile>
      <anchor>af7f9e79d9d42b55093cdf2eb6dd380d8</anchor>
      <arglist>(cc_hash *ht, cc_hash_key key, void *val)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>cc_hash_get</name>
      <anchorfile>hash_8h.html</anchorfile>
      <anchor>ae48139859990f932d46bfd311e9e5612</anchor>
      <arglist>(cc_hash *ht, cc_hash_key key, void **val)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>cc_hash_remove</name>
      <anchorfile>hash_8h.html</anchorfile>
      <anchor>ac935a65f1170c7fcd2a5bb2f739ae5fd</anchor>
      <arglist>(cc_hash *ht, cc_hash_key key)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_hash_apply</name>
      <anchorfile>hash_8h.html</anchorfile>
      <anchor>a012b0962e9368b8eadd3f579511e04bf</anchor>
      <arglist>(cc_hash *ht, cc_hash_apply_func *func, void *closure)</arglist>
    </member>
    <member kind="function">
      <type>unsigned int</type>
      <name>cc_hash_get_num_elements</name>
      <anchorfile>hash_8h.html</anchorfile>
      <anchor>a7c5f67dc300bcfa466d9658749186ff9</anchor>
      <arglist>(cc_hash *ht)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_hash_set_hash_func</name>
      <anchorfile>hash_8h.html</anchorfile>
      <anchor>a7d83ee3b50d24b6c614d824f466a5f7a</anchor>
      <arglist>(cc_hash *ht, cc_hash_func *func)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_hash_print_stat</name>
      <anchorfile>hash_8h.html</anchorfile>
      <anchor>a9f2f3e61fd5a5ca79329d43ac4812474</anchor>
      <arglist>(cc_hash *ht)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>heap.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/C/base/</path>
    <filename>heap_8h</filename>
    <member kind="typedef">
      <type>int</type>
      <name>cc_heap_compare_cb</name>
      <anchorfile>heap_8h.html</anchorfile>
      <anchor>a47f3785a4735870bb7386a9e0a334625</anchor>
      <arglist>(void *o1, void *o2)</arglist>
    </member>
    <member kind="typedef">
      <type>struct cc_heap</type>
      <name>cc_heap</name>
      <anchorfile>heap_8h.html</anchorfile>
      <anchor>a3cfe921d58e2792362b8c28cc74c2637</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>cc_heap *</type>
      <name>cc_heap_construct</name>
      <anchorfile>heap_8h.html</anchorfile>
      <anchor>a9be3b026a6ef0c5d78fffd46ac3b3b8c</anchor>
      <arglist>(unsigned int size, cc_heap_compare_cb *comparecb, SbBool support_remove)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_heap_destruct</name>
      <anchorfile>heap_8h.html</anchorfile>
      <anchor>a0288a01e95c1a24413645d0623a82166</anchor>
      <arglist>(cc_heap *h)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_heap_clear</name>
      <anchorfile>heap_8h.html</anchorfile>
      <anchor>a71e9aa42386f736864042e72ee7ad0ca</anchor>
      <arglist>(cc_heap *h)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_heap_add</name>
      <anchorfile>heap_8h.html</anchorfile>
      <anchor>aefa3ba63b7ace7b1cc0d774d54576a4f</anchor>
      <arglist>(cc_heap *h, void *o)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>cc_heap_get_top</name>
      <anchorfile>heap_8h.html</anchorfile>
      <anchor>aa3173f1d3d5a0f8518380a7b713a952a</anchor>
      <arglist>(cc_heap *h)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>cc_heap_extract_top</name>
      <anchorfile>heap_8h.html</anchorfile>
      <anchor>aa253e04784df1765ae4769fe80b28cea</anchor>
      <arglist>(cc_heap *h)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cc_heap_remove</name>
      <anchorfile>heap_8h.html</anchorfile>
      <anchor>a088aeb698e4df777529b702e3f523235</anchor>
      <arglist>(cc_heap *h, void *o)</arglist>
    </member>
    <member kind="function">
      <type>unsigned int</type>
      <name>cc_heap_elements</name>
      <anchorfile>heap_8h.html</anchorfile>
      <anchor>aae0cabf2363726f31257dfbbfef3765f</anchor>
      <arglist>(cc_heap *h)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>cc_heap_empty</name>
      <anchorfile>heap_8h.html</anchorfile>
      <anchor>ade2be8b0679dbb5d9be8c6ac486a84f8</anchor>
      <arglist>(cc_heap *h)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>memalloc.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/C/base/</path>
    <filename>memalloc_8h</filename>
    <member kind="typedef">
      <type>struct cc_memalloc</type>
      <name>cc_memalloc</name>
      <anchorfile>memalloc_8h.html</anchorfile>
      <anchor>ae3c740f22f57a7a7d7a05b1cce58c451</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>int</type>
      <name>cc_memalloc_strategy_cb</name>
      <anchorfile>memalloc_8h.html</anchorfile>
      <anchor>abc5453b97baa2e9a66c2a1130270cc15</anchor>
      <arglist>(const int numunits_allocated)</arglist>
    </member>
    <member kind="function">
      <type>cc_memalloc *</type>
      <name>cc_memalloc_construct</name>
      <anchorfile>memalloc_8h.html</anchorfile>
      <anchor>ac9ed08ff8666e9dac4c2060f4b5ea7ca</anchor>
      <arglist>(const unsigned int unitsize)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_memalloc_destruct</name>
      <anchorfile>memalloc_8h.html</anchorfile>
      <anchor>a12e3bbd5b1a9771b5af9a0becf7642dc</anchor>
      <arglist>(cc_memalloc *allocator)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>cc_memalloc_allocate</name>
      <anchorfile>memalloc_8h.html</anchorfile>
      <anchor>ab51b6af04b140b1107b08187f3b57237</anchor>
      <arglist>(cc_memalloc *allocator)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_memalloc_deallocate</name>
      <anchorfile>memalloc_8h.html</anchorfile>
      <anchor>a90bd1bc461b30fc15280b1da65007c3a</anchor>
      <arglist>(cc_memalloc *allocator, void *ptr)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_memalloc_clear</name>
      <anchorfile>memalloc_8h.html</anchorfile>
      <anchor>a5161cb02bd23ce15d6103960f4591d55</anchor>
      <arglist>(cc_memalloc *allocator)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_memalloc_set_strategy</name>
      <anchorfile>memalloc_8h.html</anchorfile>
      <anchor>a3de013b2bf9a5c6dfd24fea80ed9f59c</anchor>
      <arglist>(cc_memalloc *allocator, cc_memalloc_strategy_cb *cb)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>mutex.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/C/threads/</path>
    <filename>mutex_8h</filename>
    <includes id="common_8h" name="common.h" local="no" imported="no">Inventor/C/threads/common.h</includes>
    <member kind="function">
      <type>cc_mutex *</type>
      <name>cc_mutex_construct</name>
      <anchorfile>mutex_8h.html</anchorfile>
      <anchor>a67514cef4b9e1d00b0b0351e8cc2f3e0</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_mutex_destruct</name>
      <anchorfile>mutex_8h.html</anchorfile>
      <anchor>ae7c298016280a87354ee7f53f9774104</anchor>
      <arglist>(cc_mutex *mutex)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_mutex_lock</name>
      <anchorfile>mutex_8h.html</anchorfile>
      <anchor>ab68ff1ae48b2a4e79c2e80920efb464a</anchor>
      <arglist>(cc_mutex *mutex)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cc_mutex_try_lock</name>
      <anchorfile>mutex_8h.html</anchorfile>
      <anchor>ad82cc2b3ffa50695c8b311c9312e1316</anchor>
      <arglist>(cc_mutex *mutex)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_mutex_unlock</name>
      <anchorfile>mutex_8h.html</anchorfile>
      <anchor>a958bb509f74af082422fe35a11984cfd</anchor>
      <arglist>(cc_mutex *mutex)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>rbptree.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/C/base/</path>
    <filename>rbptree_8h</filename>
    <member kind="typedef">
      <type>struct cc_rbptree_node</type>
      <name>cc_rbptree_node</name>
      <anchorfile>rbptree_8h.html</anchorfile>
      <anchor>a5209167b68ccfcbe6d068b16057102ed</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>struct cc_rbptree</type>
      <name>cc_rbptree</name>
      <anchorfile>rbptree_8h.html</anchorfile>
      <anchor>ab09eebdf9578e3f9aa6a2e6c852c76ee</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>void</type>
      <name>cc_rbptree_traversecb</name>
      <anchorfile>rbptree_8h.html</anchorfile>
      <anchor>a48571686e40c3566ebf3e9458b2aaa17</anchor>
      <arglist>(void *p, void *data, void *closure)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_rbptree_init</name>
      <anchorfile>rbptree_8h.html</anchorfile>
      <anchor>af09e13486f87122b6d6f096960415c8b</anchor>
      <arglist>(cc_rbptree *t)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_rbptree_clean</name>
      <anchorfile>rbptree_8h.html</anchorfile>
      <anchor>aa6d7161d1c7b096a40e4ade32414867c</anchor>
      <arglist>(cc_rbptree *t)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_rbptree_insert</name>
      <anchorfile>rbptree_8h.html</anchorfile>
      <anchor>a84a326595b5d2def77f6727a666a00ba</anchor>
      <arglist>(cc_rbptree *t, void *p, void *data)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>cc_rbptree_remove</name>
      <anchorfile>rbptree_8h.html</anchorfile>
      <anchor>a77937a81bb8d88f04a23bab29d614194</anchor>
      <arglist>(cc_rbptree *t, void *p)</arglist>
    </member>
    <member kind="function">
      <type>uint32_t</type>
      <name>cc_rbptree_size</name>
      <anchorfile>rbptree_8h.html</anchorfile>
      <anchor>a2806ddfd9cf98ae83ff39154572886d2</anchor>
      <arglist>(const cc_rbptree *t)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_rbptree_traverse</name>
      <anchorfile>rbptree_8h.html</anchorfile>
      <anchor>abf647ec6e901c359427cf7c868ca9db0</anchor>
      <arglist>(const cc_rbptree *t, cc_rbptree_traversecb *func, void *closure)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_rbptree_debug</name>
      <anchorfile>rbptree_8h.html</anchorfile>
      <anchor>aaea2989fd3afd6b7cf29e7407a544c00</anchor>
      <arglist>(const cc_rbptree *t)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>recmutex.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/C/threads/</path>
    <filename>recmutex_8h</filename>
    <includes id="common_8h" name="common.h" local="no" imported="no">Inventor/C/threads/common.h</includes>
    <member kind="function">
      <type>cc_recmutex *</type>
      <name>cc_recmutex_construct</name>
      <anchorfile>recmutex_8h.html</anchorfile>
      <anchor>ac104959a6bd31cca7d271fb1a90145d0</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_recmutex_destruct</name>
      <anchorfile>recmutex_8h.html</anchorfile>
      <anchor>ad2cbeae6e909c185748ffe0a62daf7f1</anchor>
      <arglist>(cc_recmutex *recmutex)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cc_recmutex_lock</name>
      <anchorfile>recmutex_8h.html</anchorfile>
      <anchor>a236f7a2dbc904f55231186cbde2828f0</anchor>
      <arglist>(cc_recmutex *recmutex)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cc_recmutex_unlock</name>
      <anchorfile>recmutex_8h.html</anchorfile>
      <anchor>ac19c670433c86270d18513b35bc186c4</anchor>
      <arglist>(cc_recmutex *recmutex)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cc_recmutex_try_lock</name>
      <anchorfile>recmutex_8h.html</anchorfile>
      <anchor>aa6b36adf80a064ce584f0474bc3cfb91</anchor>
      <arglist>(cc_recmutex *recmutex)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>rwmutex.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/C/threads/</path>
    <filename>rwmutex_8h</filename>
    <includes id="common_8h" name="common.h" local="no" imported="no">Inventor/C/threads/common.h</includes>
    <member kind="function">
      <type>cc_rwmutex *</type>
      <name>cc_rwmutex_construct</name>
      <anchorfile>rwmutex_8h.html</anchorfile>
      <anchor>af66434284d47f7ec42a2e3e039c7ab3f</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>cc_rwmutex *</type>
      <name>cc_rwmutex_construct_etc</name>
      <anchorfile>rwmutex_8h.html</anchorfile>
      <anchor>a77b0f32aa4a12f3b96417f689e4d6fe1</anchor>
      <arglist>(cc_precedence policy)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_rwmutex_destruct</name>
      <anchorfile>rwmutex_8h.html</anchorfile>
      <anchor>a00629d8116bd7783e5fcd94bc790aee8</anchor>
      <arglist>(cc_rwmutex *rwmutex)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cc_rwmutex_write_lock</name>
      <anchorfile>rwmutex_8h.html</anchorfile>
      <anchor>a6d095f0878e5ab4a7baf55d20e13c6a9</anchor>
      <arglist>(cc_rwmutex *rwmutex)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cc_rwmutex_write_try_lock</name>
      <anchorfile>rwmutex_8h.html</anchorfile>
      <anchor>a4276fa164bdddde7ab8a589145879398</anchor>
      <arglist>(cc_rwmutex *rwmutex)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cc_rwmutex_write_unlock</name>
      <anchorfile>rwmutex_8h.html</anchorfile>
      <anchor>ac42b9d7e4dc8fb6bab15cfc335f6356a</anchor>
      <arglist>(cc_rwmutex *rwmutex)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cc_rwmutex_read_lock</name>
      <anchorfile>rwmutex_8h.html</anchorfile>
      <anchor>abd167fb3395d37f0ccbd6e17c5a91c13</anchor>
      <arglist>(cc_rwmutex *rwmutex)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cc_rwmutex_read_try_lock</name>
      <anchorfile>rwmutex_8h.html</anchorfile>
      <anchor>a29505e11963df28bd489b008e9cac00f</anchor>
      <arglist>(cc_rwmutex *rwmutex)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cc_rwmutex_read_unlock</name>
      <anchorfile>rwmutex_8h.html</anchorfile>
      <anchor>abaf5ab58f3d51204ea8bc2bf0bd18f9e</anchor>
      <arglist>(cc_rwmutex *rwmutex)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>SbClip.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/</path>
    <filename>SbClip_8h</filename>
    <class kind="class">SbClip</class>
    <member kind="typedef">
      <type>void *</type>
      <name>SbClipCallback</name>
      <anchorfile>SbClip_8h.html</anchorfile>
      <anchor>a7b99637988652ddb53ced29ce010e18e</anchor>
      <arglist>(const SbVec3f &amp;v0, void *vdata0, const SbVec3f &amp;v1, void *vdata1, const SbVec3f &amp;newvertex, void *userdata)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>SbDict.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/</path>
    <filename>SbDict_8h</filename>
    <class kind="class">SbDict</class>
    <member kind="typedef">
      <type>uintptr_t</type>
      <name>SbDictKeyType</name>
      <anchorfile>SbDict_8h.html</anchorfile>
      <anchor>acb82d07bb08c0b99aaf953617f4212fa</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>void</type>
      <name>SbDictApplyFunc</name>
      <anchorfile>SbDict_8h.html</anchorfile>
      <anchor>aff41e28ec4b46527fe4c91be4616eca9</anchor>
      <arglist>(SbDictKeyType key, void *value)</arglist>
    </member>
    <member kind="typedef">
      <type>void</type>
      <name>SbDictApplyDataFunc</name>
      <anchorfile>SbDict_8h.html</anchorfile>
      <anchor>a42154327d573d825af27f7b67e82846c</anchor>
      <arglist>(SbDictKeyType key, void *value, void *data)</arglist>
    </member>
    <member kind="typedef">
      <type>SbDictKeyType</type>
      <name>SbDictHashingFunc</name>
      <anchorfile>SbDict_8h.html</anchorfile>
      <anchor>a68895d232bbc01b1edc40809de2db5d6</anchor>
      <arglist>(const SbDictKeyType key)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>SbImage.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/</path>
    <filename>SbImage_8h</filename>
    <class kind="class">SbImage</class>
    <member kind="typedef">
      <type>SbBool</type>
      <name>SbImageScheduleReadCB</name>
      <anchorfile>SbImage_8h.html</anchorfile>
      <anchor>aec75901f7cf7231e18a9319c8c93027d</anchor>
      <arglist>(const SbString &amp;, SbImage *, void *)</arglist>
    </member>
    <member kind="typedef">
      <type>SbBool</type>
      <name>SbImageReadImageCB</name>
      <anchorfile>SbImage_8h.html</anchorfile>
      <anchor>a749e25189202ba72003c04cc9e591045</anchor>
      <arglist>(const SbString &amp;, SbImage *, void *)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>SbProfilingData.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/annex/Profiler/</path>
    <filename>SbProfilingData_8h</filename>
    <includes id="SoType_8h" name="SoType.h" local="no" imported="no">Inventor/SoType.h</includes>
    <class kind="class">SbProfilingData</class>
    <member kind="typedef">
      <type>void *</type>
      <name>SbProfilingNodeKey</name>
      <anchorfile>SbProfilingData_8h.html</anchorfile>
      <anchor>ab504be724d5409b88c9735f92c9d2e60</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>int16_t</type>
      <name>SbProfilingNodeTypeKey</name>
      <anchorfile>SbProfilingData_8h.html</anchorfile>
      <anchor>a050c3662b04c5000d45cfcf792ce40db</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>const char *</type>
      <name>SbProfilingNodeNameKey</name>
      <anchorfile>SbProfilingData_8h.html</anchorfile>
      <anchor>a766ecc81c4a94c10db9f1282a9eaeb4f</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>SbTesselator.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/</path>
    <filename>SbTesselator_8h</filename>
    <class kind="class">SbTesselator</class>
    <member kind="typedef">
      <type>void</type>
      <name>SbTesselatorCB</name>
      <anchorfile>SbTesselator_8h.html</anchorfile>
      <anchor>a7f7d2fcfc589decba0aab9eb3f253b90</anchor>
      <arglist>(void *v0, void *v1, void *v2, void *data)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>sched.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/C/threads/</path>
    <filename>sched_8h</filename>
    <includes id="common_8h" name="common.h" local="no" imported="no">Inventor/C/threads/common.h</includes>
    <member kind="typedef">
      <type>void</type>
      <name>cc_sched_f</name>
      <anchorfile>sched_8h.html</anchorfile>
      <anchor>a76544dc5c498d7b827403cb313051dab</anchor>
      <arglist>(void *closure)</arglist>
    </member>
    <member kind="function">
      <type>cc_sched *</type>
      <name>cc_sched_construct</name>
      <anchorfile>sched_8h.html</anchorfile>
      <anchor>aa6708ee2026420e559ebfac7a59ffa18</anchor>
      <arglist>(int numthreads)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_sched_destruct</name>
      <anchorfile>sched_8h.html</anchorfile>
      <anchor>ad3970d66c72d7c3600a4512a0e6f10ac</anchor>
      <arglist>(cc_sched *sched)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_sched_set_num_threads</name>
      <anchorfile>sched_8h.html</anchorfile>
      <anchor>aa32ed8dd1ca6f5d31f6c177c919827d9</anchor>
      <arglist>(cc_sched *sched, int num)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cc_sched_get_num_threads</name>
      <anchorfile>sched_8h.html</anchorfile>
      <anchor>a9727b730645317fc320923e756a675c9</anchor>
      <arglist>(cc_sched *sched)</arglist>
    </member>
    <member kind="function">
      <type>uint32_t</type>
      <name>cc_sched_schedule</name>
      <anchorfile>sched_8h.html</anchorfile>
      <anchor>a6fdaca4dd411f6baf4b6635f7879064b</anchor>
      <arglist>(cc_sched *sched, cc_sched_f *workfunc, void *closure, float priority)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>cc_sched_unschedule</name>
      <anchorfile>sched_8h.html</anchorfile>
      <anchor>a7675245f822e5d88c1b2a38766aa794c</anchor>
      <arglist>(cc_sched *sched, uint32_t schedid)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_sched_wait_all</name>
      <anchorfile>sched_8h.html</anchorfile>
      <anchor>af37556dd26772e72f650f3378bf99ffd</anchor>
      <arglist>(cc_sched *sched)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cc_sched_get_num_remaining</name>
      <anchorfile>sched_8h.html</anchorfile>
      <anchor>a9c269e9d5c97530f4a5b51df5272c776</anchor>
      <arglist>(cc_sched *sched)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_sched_set_num_allowed</name>
      <anchorfile>sched_8h.html</anchorfile>
      <anchor>ab32995a3067e56acbd21b362ca9be7d2</anchor>
      <arglist>(cc_sched *sched, int num)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_sched_change_priority</name>
      <anchorfile>sched_8h.html</anchorfile>
      <anchor>ae0a097a0cd951009b75dd7be2c16871d</anchor>
      <arglist>(cc_sched *sched, uint32_t schedid, float priority)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>ScXMLStateMachine.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/scxml/</path>
    <filename>ScXMLStateMachine_8h</filename>
    <class kind="class">ScXMLStateMachine</class>
    <member kind="typedef">
      <type>void</type>
      <name>ScXMLStateMachineDeleteCB</name>
      <anchorfile>ScXMLStateMachine_8h.html</anchorfile>
      <anchor>ae034fd3855c0742ad9ee1cf922ae9a93</anchor>
      <arglist>(void *userdata, ScXMLStateMachine *statemachine)</arglist>
    </member>
    <member kind="typedef">
      <type>void</type>
      <name>ScXMLStateChangeCB</name>
      <anchorfile>ScXMLStateMachine_8h.html</anchorfile>
      <anchor>a382ec530b26743dc815f7cb832ce00a4</anchor>
      <arglist>(void *userdata, ScXMLStateMachine *statemachine, const char *stateidentifier, SbBool enterstate, SbBool success)</arglist>
    </member>
    <member kind="typedef">
      <type>void</type>
      <name>ScXMLParallelStateChangeCB</name>
      <anchorfile>ScXMLStateMachine_8h.html</anchorfile>
      <anchor>abb78f2e452e7fe8ca2587c25c15097cf</anchor>
      <arglist>(void *userdata, ScXMLStateMachine *statemachine, int numstates, const char **stateidentifiers, SbBool enterstate, SbBool success)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>SoActionMethodList.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/lists/</path>
    <filename>SoActionMethodList_8h</filename>
    <includes id="SoType_8h" name="SoType.h" local="no" imported="no">Inventor/SoType.h</includes>
    <class kind="class">SoActionMethodList</class>
    <member kind="typedef">
      <type>void(*</type>
      <name>SoActionMethod</name>
      <anchorfile>SoActionMethodList_8h.html</anchorfile>
      <anchor>a20da48d2b340cf58ff0fca763fcf1577</anchor>
      <arglist>)(SoAction *, SoNode *)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>SoCallback.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/nodes/</path>
    <filename>SoCallback_8h</filename>
    <class kind="class">SoCallback</class>
    <member kind="typedef">
      <type>void</type>
      <name>SoCallbackCB</name>
      <anchorfile>SoCallback_8h.html</anchorfile>
      <anchor>ad9451945b593767f377104fab4bb2035</anchor>
      <arglist>(void *userdata, SoAction *action)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>SoCallbackAction.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/actions/</path>
    <filename>SoCallbackAction_8h</filename>
    <class kind="class">SoCallbackAction</class>
    <member kind="typedef">
      <type>void</type>
      <name>SoTriangleCB</name>
      <anchorfile>SoCallbackAction_8h.html</anchorfile>
      <anchor>a38c75c113e2ddebb11872737e22de036</anchor>
      <arglist>(void *userdata, SoCallbackAction *action, const SoPrimitiveVertex *v1, const SoPrimitiveVertex *v2, const SoPrimitiveVertex *v3)</arglist>
    </member>
    <member kind="typedef">
      <type>void</type>
      <name>SoLineSegmentCB</name>
      <anchorfile>SoCallbackAction_8h.html</anchorfile>
      <anchor>a6e4ebc8a54b96078d4a70b552d8a1f86</anchor>
      <arglist>(void *userdata, SoCallbackAction *action, const SoPrimitiveVertex *v1, const SoPrimitiveVertex *v2)</arglist>
    </member>
    <member kind="typedef">
      <type>void</type>
      <name>SoPointCB</name>
      <anchorfile>SoCallbackAction_8h.html</anchorfile>
      <anchor>a404627c51c9d7daaae5351ca11fd815d</anchor>
      <arglist>(void *userdata, SoCallbackAction *action, const SoPrimitiveVertex *v)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>SoCallbackList.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/lists/</path>
    <filename>SoCallbackList_8h</filename>
    <class kind="class">SoCallbackList</class>
    <member kind="typedef">
      <type>void</type>
      <name>SoCallbackListCB</name>
      <anchorfile>SoCallbackList_8h.html</anchorfile>
      <anchor>af2e448a2584c8740fc2735ec3972c49e</anchor>
      <arglist>(void *userdata, void *callbackdata)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>SoContextHandler.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/misc/</path>
    <filename>SoContextHandler_8h</filename>
    <class kind="class">SoContextHandler</class>
  </compound>
  <compound kind="file">
    <name>SoDB.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/</path>
    <filename>SoDB_8h</filename>
    <includes id="SoType_8h" name="SoType.h" local="no" imported="no">Inventor/SoType.h</includes>
    <class kind="class">SoDB</class>
    <member kind="typedef">
      <type>void</type>
      <name>SoDBHeaderCB</name>
      <anchorfile>SoDB_8h.html</anchorfile>
      <anchor>adfef9190f2aba6f35abf08374dffc68a</anchor>
      <arglist>(void *data, SoInput *input)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>SoDragger.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/draggers/</path>
    <filename>SoDragger_8h</filename>
    <includes id="SoCallbackList_8h" name="SoCallbackList.h" local="no" imported="no">Inventor/lists/SoCallbackList.h</includes>
    <class kind="class">SoDragger</class>
    <member kind="typedef">
      <type>void</type>
      <name>SoDraggerCB</name>
      <anchorfile>SoDragger_8h.html</anchorfile>
      <anchor>aee66fa82a01dba5b1b7b72c13cec68fc</anchor>
      <arglist>(void *data, SoDragger *dragger)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>SoEventCallback.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/nodes/</path>
    <filename>SoEventCallback_8h</filename>
    <class kind="class">SoEventCallback</class>
    <member kind="typedef">
      <type>void</type>
      <name>SoEventCallbackCB</name>
      <anchorfile>SoEventCallback_8h.html</anchorfile>
      <anchor>a6e0dbb53c95cc1225c031e027c7bc7b1</anchor>
      <arglist>(void *userdata, SoEventCallback *node)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>SoExtSelection.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/nodes/</path>
    <filename>SoExtSelection_8h</filename>
    <includes id="SoSelection_8h" name="SoSelection.h" local="no" imported="no">Inventor/nodes/SoSelection.h</includes>
    <includes id="SoCallbackAction_8h" name="SoCallbackAction.h" local="no" imported="no">Inventor/actions/SoCallbackAction.h</includes>
    <class kind="class">SoExtSelection</class>
  </compound>
  <compound kind="file">
    <name>SoForeignFileKit.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/annex/ForeignFiles/</path>
    <filename>SoForeignFileKit_8h</filename>
    <class kind="class">SoForeignFileKit</class>
  </compound>
  <compound kind="file">
    <name>SoGLCacheContextElement.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/elements/</path>
    <filename>SoGLCacheContextElement_8h</filename>
    <class kind="class">SoGLCacheContextElement</class>
  </compound>
  <compound kind="file">
    <name>SoGLImage.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/misc/</path>
    <filename>SoGLImage_8h</filename>
    <includes id="SoType_8h" name="SoType.h" local="no" imported="no">Inventor/SoType.h</includes>
    <class kind="class">SoGLImage</class>
  </compound>
  <compound kind="file">
    <name>SoGLMultiTextureCoordinateElement.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/elements/</path>
    <filename>SoGLMultiTextureCoordinateElement_8h</filename>
    <includes id="SoMultiTextureCoordinateElement_8h" name="SoMultiTextureCoordinateElement.h" local="no" imported="no">Inventor/elements/SoMultiTextureCoordinateElement.h</includes>
    <class kind="class">SoGLMultiTextureCoordinateElement</class>
  </compound>
  <compound kind="file">
    <name>SoGLRenderAction.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/actions/</path>
    <filename>SoGLRenderAction_8h</filename>
    <class kind="class">SoGLRenderAction</class>
    <member kind="typedef">
      <type>void</type>
      <name>SoGLRenderPassCB</name>
      <anchorfile>SoGLRenderAction_8h.html</anchorfile>
      <anchor>a53d49957c78db1408e769922d160cc0d</anchor>
      <arglist>(void *userdata)</arglist>
    </member>
    <member kind="typedef">
      <type>float</type>
      <name>SoGLSortedObjectOrderCB</name>
      <anchorfile>SoGLRenderAction_8h.html</anchorfile>
      <anchor>a4ad9050a0255e669ec9714b2ae789d24</anchor>
      <arglist>(void *userdata, SoGLRenderAction *action)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>SoIntersectionDetectionAction.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/collision/</path>
    <filename>SoIntersectionDetectionAction_8h</filename>
    <includes id="SoCallbackAction_8h" name="SoCallbackAction.h" local="no" imported="no">Inventor/actions/SoCallbackAction.h</includes>
    <class kind="struct">SoIntersectingPrimitive</class>
    <class kind="class">SoIntersectionDetectionAction</class>
  </compound>
  <compound kind="file">
    <name>SoMultiTextureCoordinateElement.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/elements/</path>
    <filename>SoMultiTextureCoordinateElement_8h</filename>
    <class kind="class">SoMultiTextureCoordinateElement</class>
  </compound>
  <compound kind="file">
    <name>SoOutput.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/</path>
    <filename>SoOutput_8h</filename>
    <class kind="class">SoOutput</class>
  </compound>
  <compound kind="file">
    <name>SoProfilingReportGenerator.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/annex/Profiler/utils/</path>
    <filename>SoProfilingReportGenerator_8h</filename>
    <class kind="class">SoProfilingReportGenerator</class>
  </compound>
  <compound kind="file">
    <name>SoProto.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/misc/</path>
    <filename>SoProto_8h</filename>
    <class kind="class">SoProto</class>
  </compound>
  <compound kind="file">
    <name>SoRenderManager.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/</path>
    <filename>SoRenderManager_8h</filename>
    <includes id="SoGLRenderAction_8h" name="SoGLRenderAction.h" local="no" imported="no">Inventor/actions/SoGLRenderAction.h</includes>
    <class kind="class">SoRenderManager</class>
  </compound>
  <compound kind="file">
    <name>SoSceneManager.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/</path>
    <filename>SoSceneManager_8h</filename>
    <class kind="class">SoSceneManager</class>
    <member kind="typedef">
      <type>void</type>
      <name>SoSceneManagerRenderCB</name>
      <anchorfile>SoSceneManager_8h.html</anchorfile>
      <anchor>abada319f5f2375442afabf9d7d61e726</anchor>
      <arglist>(void *userdata, class SoSceneManager *mgr)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>SoScXMLNavigationTarget.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/navigation/</path>
    <filename>SoScXMLNavigationTarget_8h</filename>
    <class kind="class">SoScXMLNavigationTarget</class>
  </compound>
  <compound kind="file">
    <name>SoSelection.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/nodes/</path>
    <filename>SoSelection_8h</filename>
    <class kind="class">SoSelection</class>
    <member kind="typedef">
      <type>SoPath *</type>
      <name>SoSelectionPickCB</name>
      <anchorfile>SoSelection_8h.html</anchorfile>
      <anchor>abdc320e66f9b345540a490491c618ecb</anchor>
      <arglist>(void *data, const SoPickedPoint *pick)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>SoSensor.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/sensors/</path>
    <filename>SoSensor_8h</filename>
    <class kind="class">SoSensor</class>
    <member kind="typedef">
      <type>void</type>
      <name>SoSensorCB</name>
      <anchorfile>SoSensor_8h.html</anchorfile>
      <anchor>a0e20257319c3430fe1cee699ef6e3420</anchor>
      <arglist>(void *data, SoSensor *sensor)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>SoShaderProgram.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/nodes/</path>
    <filename>SoShaderProgram_8h</filename>
    <class kind="class">SoShaderProgram</class>
  </compound>
  <compound kind="file">
    <name>SoType.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/</path>
    <filename>SoType_8h</filename>
    <includes id="SbDict_8h" name="SbDict.h" local="no" imported="no">Inventor/SbDict.h</includes>
    <class kind="class">SbList</class>
    <class kind="class">SoType</class>
  </compound>
  <compound kind="file">
    <name>SoVertexAttributeElement.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/elements/</path>
    <filename>SoVertexAttributeElement_8h</filename>
  </compound>
  <compound kind="file">
    <name>SoVRMLAnchor.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/VRMLnodes/</path>
    <filename>SoVRMLAnchor_8h</filename>
    <class kind="class">SoVRMLAnchor</class>
  </compound>
  <compound kind="file">
    <name>SoVRMLAudioClip.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/VRMLnodes/</path>
    <filename>SoVRMLAudioClip_8h</filename>
    <class kind="class">SoVRMLAudioClip</class>
  </compound>
  <compound kind="file">
    <name>SoVRMLImageTexture.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/VRMLnodes/</path>
    <filename>SoVRMLImageTexture_8h</filename>
    <includes id="SbImage_8h" name="SbImage.h" local="no" imported="no">Inventor/SbImage.h</includes>
    <class kind="class">SoVRMLImageTexture</class>
  </compound>
  <compound kind="file">
    <name>SoVRMLInline.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/VRMLnodes/</path>
    <filename>SoVRMLInline_8h</filename>
    <includes id="SoCallbackAction_8h" name="SoCallbackAction.h" local="no" imported="no">Inventor/actions/SoCallbackAction.h</includes>
    <class kind="class">SoVRMLInline</class>
  </compound>
  <compound kind="file">
    <name>SoVRMLScript.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/VRMLnodes/</path>
    <filename>SoVRMLScript_8h</filename>
    <class kind="class">SoVRMLScript</class>
  </compound>
  <compound kind="file">
    <name>SoWWWAnchor.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/nodes/</path>
    <filename>SoWWWAnchor_8h</filename>
    <class kind="class">SoWWWAnchor</class>
  </compound>
  <compound kind="file">
    <name>SoWWWInline.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/nodes/</path>
    <filename>SoWWWInline_8h</filename>
    <includes id="SoCallbackAction_8h" name="SoCallbackAction.h" local="no" imported="no">Inventor/actions/SoCallbackAction.h</includes>
    <class kind="class">SoWWWInline</class>
  </compound>
  <compound kind="file">
    <name>spidermonkey.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/C/glue/</path>
    <filename>spidermonkey_8h</filename>
  </compound>
  <compound kind="file">
    <name>storage.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/C/threads/</path>
    <filename>storage_8h</filename>
    <includes id="common_8h" name="common.h" local="no" imported="no">Inventor/C/threads/common.h</includes>
  </compound>
  <compound kind="file">
    <name>string.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/C/base/</path>
    <filename>string_8h</filename>
    <class kind="struct">cc_string</class>
  </compound>
  <compound kind="file">
    <name>thread.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/C/threads/</path>
    <filename>thread_8h</filename>
    <includes id="common_8h" name="common.h" local="no" imported="no">Inventor/C/threads/common.h</includes>
  </compound>
  <compound kind="file">
    <name>tidbits.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/C/</path>
    <filename>tidbits_8h</filename>
    <member kind="function">
      <type>void</type>
      <name>cc_coin_atexit_static_internal</name>
      <anchorfile>tidbits_8h.html</anchorfile>
      <anchor>a543c2c5b6e2507250ab773f1838105ec</anchor>
      <arglist>(coin_atexit_f *fp)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>types.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/C/XML/</path>
    <filename>types_8h</filename>
    <member kind="typedef">
      <type>struct cc_xml_doc</type>
      <name>cc_xml_doc</name>
      <anchorfile>group__XML.html</anchorfile>
      <anchor>ga4668bec10f4a41c447ba1c9d42721a4b</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>cc_xml_filter_choice</type>
      <name>cc_xml_filter_cb</name>
      <anchorfile>types_8h.html</anchorfile>
      <anchor>af2b6235c6da1a1a26b0073741cee8d78</anchor>
      <arglist>(void *userdata, cc_xml_doc *doc, cc_xml_elt *elt, int pushing)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>worker.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/C/threads/</path>
    <filename>worker_8h</filename>
    <includes id="common_8h" name="common.h" local="no" imported="no">Inventor/C/threads/common.h</includes>
    <member kind="function">
      <type>void</type>
      <name>cc_worker_destruct</name>
      <anchorfile>worker_8h.html</anchorfile>
      <anchor>abab35ee0bc4d8daa85f92e543c1282fd</anchor>
      <arglist>(cc_worker *worker)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>cc_worker_start</name>
      <anchorfile>worker_8h.html</anchorfile>
      <anchor>ac5c05ca84a6b98e22b80c92e4c483f3e</anchor>
      <arglist>(cc_worker *worker, cc_worker_f *workfunc, void *closure)</arglist>
    </member>
  </compound>
  <compound kind="file">
    <name>wpool.h</name>
    <path>C:/Users/Roy/Documents/coin/include/Inventor/C/threads/</path>
    <filename>wpool_8h</filename>
    <includes id="common_8h" name="common.h" local="no" imported="no">Inventor/C/threads/common.h</includes>
    <member kind="function">
      <type>cc_wpool *</type>
      <name>cc_wpool_construct</name>
      <anchorfile>wpool_8h.html</anchorfile>
      <anchor>a9550e19fd66501b2d8f04ae3d1567e0d</anchor>
      <arglist>(int numworkers)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_wpool_destruct</name>
      <anchorfile>wpool_8h.html</anchorfile>
      <anchor>a3a88eb052e62c806ad1ba3baa7a9a267</anchor>
      <arglist>(cc_wpool *pool)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>cc_wpool_get_num_workers</name>
      <anchorfile>wpool_8h.html</anchorfile>
      <anchor>a4dcdd6841fcde116c5db4110512ac349</anchor>
      <arglist>(cc_wpool *pool)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_wpool_set_num_workers</name>
      <anchorfile>wpool_8h.html</anchorfile>
      <anchor>aa8dd9d5e8efbbd3bfc6868437eb1dde1</anchor>
      <arglist>(cc_wpool *pool, int newnum)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_wpool_wait_all</name>
      <anchorfile>wpool_8h.html</anchorfile>
      <anchor>aa72a4d47ebc25bde285eda7e92ab1d60</anchor>
      <arglist>(cc_wpool *pool)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>cc_wpool_try_begin</name>
      <anchorfile>wpool_8h.html</anchorfile>
      <anchor>a124e8b13ad6d891464464faf1dc06720</anchor>
      <arglist>(cc_wpool *pool, int numworkersneeded)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_wpool_begin</name>
      <anchorfile>wpool_8h.html</anchorfile>
      <anchor>af74a596c25276cf64940945ced3e1aac</anchor>
      <arglist>(cc_wpool *pool, int numworkersneeded)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_wpool_start_worker</name>
      <anchorfile>wpool_8h.html</anchorfile>
      <anchor>ab6520bc3ada9718920816fda16fe345f</anchor>
      <arglist>(cc_wpool *pool, cc_wpool_f *workfunc, void *closure)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_wpool_end</name>
      <anchorfile>wpool_8h.html</anchorfile>
      <anchor>aee918e25fac8bb394789c70c3501a522</anchor>
      <arglist>(cc_wpool *pool)</arglist>
    </member>
  </compound>
  <compound kind="page">
    <name>coin300</name>
    <title>New Features in Coin v3.0.0</title>
    <filename>coin300</filename>
  </compound>
  <compound kind="page">
    <name>coin250</name>
    <title>New Features in Coin v2.5.0</title>
    <filename>coin250</filename>
    <docanchor file="coin250" title="Geographical Data Support">geonodes</docanchor>
    <docanchor file="coin250" title="Generic GLSL Shader Support">shadernodes</docanchor>
    <docanchor file="coin250" title="Generic Shadow Rendering Functionality">shadownodes</docanchor>
    <docanchor file="coin250" title="Vertex Buffer Object (VBO) Usage">vborendering</docanchor>
    <docanchor file="coin250" title="Expanded Sb* Class Collection">sbclasses</docanchor>
    <docanchor file="coin250" title="Expanded Field Class Collection">fieldclasses</docanchor>
    <docanchor file="coin250" title="SoFrustumCamera node">frustumcamera</docanchor>
    <docanchor file="coin250" title="Miscellaneous">misc250</docanchor>
    <docanchor file="coin250" title="SoSearchAction on SoFile nodes">sofile</docanchor>
    <docanchor file="coin250" title="SbTypeInfo&lt;T&gt; template type information library">sbtypeinfo</docanchor>
    <docanchor file="coin250" title="Visual Studio Projects">vcprojects</docanchor>
  </compound>
  <compound kind="page">
    <name>coin240</name>
    <title>New Features in Coin v2.4.0</title>
    <filename>coin240</filename>
  </compound>
  <compound kind="page">
    <name>coin230</name>
    <title>New Features in Coin v2.3.0</title>
    <filename>coin230</filename>
    <docanchor file="coin230" title="More Multi-Texturing">multitexturing230</docanchor>
    <docanchor file="coin230" title="Texture coordinate mapping nodes">texcoordmaps</docanchor>
  </compound>
  <compound kind="page">
    <name>coin220</name>
    <title>New Features in Coin v2.2.0</title>
    <filename>coin220</filename>
    <docanchor file="coin220" title="Multi-Texturing">multitexturing220</docanchor>
    <docanchor file="coin220" title="Bump-Mapping">bumpmapping</docanchor>
    <docanchor file="coin220" title="Better Font Support">fontsupport</docanchor>
    <docanchor file="coin220" title="Render To Texture Support">scenetexture</docanchor>
    <docanchor file="coin220" title="Misc">misc</docanchor>
  </compound>
  <compound kind="page">
    <name>coin210</name>
    <title>New Features in Coin v2.1.0</title>
    <filename>coin210</filename>
    <docanchor file="coin210" title="HardCopy Support">hardcopy</docanchor>
    <docanchor file="coin210" title="FreeType and Win32 TrueType Font Support">fonts</docanchor>
    <docanchor file="coin210" title="Intersection Detection">intersectiondetection</docanchor>
    <docanchor file="coin210" title="SoLineHighlightRenderAction/SoBoxHighlightRenderAction and Multiple SoSelection Nodes">soselectionhighlight</docanchor>
    <docanchor file="coin210" title="Misc">misc210</docanchor>
    <docanchor file="coin210" title="Compressed File I/O Support">compressedio</docanchor>
    <docanchor file="coin210" title="Additional Convenience Functions">convenience</docanchor>
    <docanchor file="coin210" title="NO_COPY SoSFImage CopyPolicy">copypolicy</docanchor>
  </compound>
  <compound kind="page">
    <name>coin200</name>
    <title>New Features in Coin v2.0.0</title>
    <filename>coin200</filename>
    <docanchor file="coin200" title="Big-Image Support">bigimage</docanchor>
    <docanchor file="coin200" title="3D Textures Support">textures3d</docanchor>
    <docanchor file="coin200" title="3D Sound Support">sound3d</docanchor>
    <docanchor file="coin200" title="VRML97 Support">vrml97</docanchor>
    <docanchor file="coin200" title="Mac OS X Support">macosx</docanchor>
    <docanchor file="coin200" title="Multi-Pipe Rendering Support">multipipe</docanchor>
  </compound>
  <compound kind="page">
    <name>coin_vbo_rendering</name>
    <title>Vertex array and VBO rendering in Coin</title>
    <filename>coin_vbo_rendering</filename>
  </compound>
  <compound kind="page">
    <name>coin_books</name>
    <title>Books Related to Open Inventor / Coin</title>
    <filename>coin_books</filename>
    <docanchor file="coin_books" title="The Inventor Mentor">mentorbook</docanchor>
    <docanchor file="coin_books" title="The Inventor Toolmaker">toolmakerbook</docanchor>
    <docanchor file="coin_books" title="The Annotated VRML2.0 Reference Manual">vrml2refbook</docanchor>
    <docanchor file="coin_books" title="The Open GL Programming Manual">openglbook</docanchor>
    <docanchor file="coin_books" title="The Open Inventor C++ Reference Manual">oirefbook</docanchor>
  </compound>
  <compound kind="page">
    <name>coin_environment_variables</name>
    <title>Environment variables</title>
    <filename>coin_environment_variables</filename>
  </compound>
  <compound kind="page">
    <name>coin_foreign_file_support</name>
    <title>Foreign File Format Support</title>
    <filename>coin_foreign_file_support</filename>
  </compound>
  <compound kind="page">
    <name>coin_libraries</name>
    <title>Coin use of 3rd party libraries.</title>
    <filename>coin_libraries</filename>
    <docanchor file="coin_libraries" title="The simage library">simage</docanchor>
  </compound>
  <compound kind="page">
    <name>coin_compression_overview</name>
    <title>File compression</title>
    <filename>coin_compression_overview</filename>
  </compound>
  <compound kind="page">
    <name>coin_dynload_overview</name>
    <title>Dynamic Loading of Extension Nodes</title>
    <filename>coin_dynload_overview</filename>
  </compound>
  <compound kind="page">
    <name>coin_shaders</name>
    <title>Shaders in Coin</title>
    <filename>coin_shaders</filename>
  </compound>
  <compound kind="page">
    <name>coin_multithreading_support</name>
    <title>Multithreading Support in Coin</title>
    <filename>coin_multithreading_support</filename>
  </compound>
  <compound kind="page">
    <name>coin_xml_parsing</name>
    <title>XML Parsing with Coin</title>
    <filename>coin_xml_parsing</filename>
  </compound>
  <compound kind="group">
    <name>actions</name>
    <title>Action Classes</title>
    <filename>group__actions.html</filename>
    <class kind="class">SoAction</class>
    <class kind="class">SoAudioRenderAction</class>
    <class kind="class">SoBoxHighlightRenderAction</class>
    <class kind="class">SoCallbackAction</class>
    <class kind="class">SoGetBoundingBoxAction</class>
    <class kind="class">SoGetMatrixAction</class>
    <class kind="class">SoGetPrimitiveCountAction</class>
    <class kind="class">SoGLRenderAction</class>
    <class kind="class">SoHandleEventAction</class>
    <class kind="class">SoLineHighlightRenderAction</class>
    <class kind="class">SoPickAction</class>
    <class kind="class">SoRayPickAction</class>
    <class kind="class">SoReorganizeAction</class>
    <class kind="class">SoSearchAction</class>
    <class kind="class">SoToVRML2Action</class>
    <class kind="class">SoToVRMLAction</class>
    <class kind="class">SoWriteAction</class>
    <class kind="class">SoIntersectionDetectionAction</class>
    <class kind="class">SoActionMethodList</class>
    <class kind="class">SoEnabledElementsList</class>
  </compound>
  <compound kind="group">
    <name>base</name>
    <title>Base Classes</title>
    <filename>group__base.html</filename>
    <class kind="class">SbBox2d</class>
    <class kind="class">SbBox2f</class>
    <class kind="class">SbBox2i32</class>
    <class kind="class">SbBox2s</class>
    <class kind="class">SbBox3d</class>
    <class kind="class">SbBox3f</class>
    <class kind="class">SbBox3s</class>
    <class kind="class">SbBSPTree</class>
    <class kind="class">SbClip</class>
    <class kind="class">SbColor4f</class>
    <class kind="class">SbColor</class>
    <class kind="class">SbCylinder</class>
    <class kind="class">SbDict</class>
    <class kind="class">SbDPLine</class>
    <class kind="class">SbDPMatrix</class>
    <class kind="class">SbDPPlane</class>
    <class kind="class">SbDPRotation</class>
    <class kind="class">SbDPViewVolume</class>
    <class kind="class">SbHeap</class>
    <class kind="class">SbImage</class>
    <class kind="class">SbLine</class>
    <class kind="class">SbMatrix</class>
    <class kind="class">SbName</class>
    <class kind="class">SbOctTree</class>
    <class kind="class">SbPlane</class>
    <class kind="class">SbRotation</class>
    <class kind="class">SbSphere</class>
    <class kind="class">SbString</class>
    <class kind="class">SbTesselator</class>
    <class kind="class">SbTime</class>
    <class kind="class">SbVec2d</class>
    <class kind="class">SbVec2f</class>
    <class kind="class">SbVec2i32</class>
    <class kind="class">SbVec2s</class>
    <class kind="class">SbVec3d</class>
    <class kind="class">SbVec3f</class>
    <class kind="class">SbVec3s</class>
    <class kind="class">SbVec4d</class>
    <class kind="class">SbVec4f</class>
    <class kind="class">SbViewportRegion</class>
    <class kind="class">SbViewVolume</class>
    <class kind="class">SbXfBox3d</class>
    <class kind="class">SbXfBox3f</class>
    <class kind="struct">cc_string</class>
    <class kind="class">SbTri3f</class>
    <class kind="class">SbIntList</class>
    <class kind="class">SbList</class>
    <class kind="class">SbPList</class>
    <class kind="class">SbStringList</class>
    <class kind="class">SbVec3fList</class>
  </compound>
  <compound kind="group">
    <name>bundles</name>
    <title>Bundle Classes</title>
    <filename>group__bundles.html</filename>
    <class kind="class">SoBundle</class>
    <class kind="class">SoMaterialBundle</class>
    <class kind="class">SoNormalBundle</class>
    <class kind="class">SoTextureCoordinateBundle</class>
    <class kind="class">SoVertexAttributeBundle</class>
    <page>group__bundles</page>
  </compound>
  <compound kind="group">
    <name>caches</name>
    <title>Cache Classes</title>
    <filename>group__caches.html</filename>
    <class kind="class">SoBoundingBoxCache</class>
    <class kind="class">SoCache</class>
    <class kind="class">SoConvexDataCache</class>
    <class kind="class">SoGLCacheList</class>
    <class kind="class">SoGLRenderCache</class>
    <class kind="class">SoNormalCache</class>
    <class kind="class">SoShaderProgramCache</class>
    <page>group__caches</page>
  </compound>
  <compound kind="group">
    <name>details</name>
    <title>Detail Classes</title>
    <filename>group__details.html</filename>
    <class kind="class">SoConeDetail</class>
    <class kind="class">SoCubeDetail</class>
    <class kind="class">SoCylinderDetail</class>
    <class kind="class">SoDetail</class>
    <class kind="class">SoFaceDetail</class>
    <class kind="class">SoLineDetail</class>
    <class kind="class">SoNodeKitDetail</class>
    <class kind="class">SoPointDetail</class>
    <class kind="class">SoTextDetail</class>
    <class kind="class">SoDetailList</class>
  </compound>
  <compound kind="group">
    <name>draggers</name>
    <title>Dragger Classes</title>
    <filename>group__draggers.html</filename>
    <class kind="class">SoCenterballDragger</class>
    <class kind="class">SoDirectionalLightDragger</class>
    <class kind="class">SoDragger</class>
    <class kind="class">SoDragPointDragger</class>
    <class kind="class">SoHandleBoxDragger</class>
    <class kind="class">SoJackDragger</class>
    <class kind="class">SoPointLightDragger</class>
    <class kind="class">SoRotateCylindricalDragger</class>
    <class kind="class">SoRotateDiscDragger</class>
    <class kind="class">SoRotateSphericalDragger</class>
    <class kind="class">SoScale1Dragger</class>
    <class kind="class">SoScale2Dragger</class>
    <class kind="class">SoScale2UniformDragger</class>
    <class kind="class">SoScaleUniformDragger</class>
    <class kind="class">SoSpotLightDragger</class>
    <class kind="class">SoTabBoxDragger</class>
    <class kind="class">SoTabPlaneDragger</class>
    <class kind="class">SoTrackballDragger</class>
    <class kind="class">SoTransformBoxDragger</class>
    <class kind="class">SoTransformerDragger</class>
    <class kind="class">SoTranslate1Dragger</class>
    <class kind="class">SoTranslate2Dragger</class>
  </compound>
  <compound kind="group">
    <name>elements</name>
    <title>Element Classes</title>
    <filename>group__elements.html</filename>
    <class kind="class">SoGLCacheContextElement</class>
    <class kind="class">SoGLClipPlaneElement</class>
    <class kind="class">SoGLColorIndexElement</class>
    <class kind="class">SoGLCoordinateElement</class>
    <class kind="class">SoGLDepthBufferElement</class>
    <class kind="class">SoGLDisplayList</class>
    <class kind="class">SoGLDrawStyleElement</class>
    <class kind="class">SoGLEnvironmentElement</class>
    <class kind="class">SoGLLazyElement</class>
    <class kind="class">SoGLLightIdElement</class>
    <class kind="class">SoGLLinePatternElement</class>
    <class kind="class">SoGLLineWidthElement</class>
    <class kind="class">SoGLModelMatrixElement</class>
    <class kind="class">SoGLMultiTextureCoordinateElement</class>
    <class kind="class">SoGLMultiTextureImageElement</class>
    <class kind="class">SoGLMultiTextureMatrixElement</class>
    <class kind="class">SoGLNormalElement</class>
    <class kind="class">SoGLPointSizeElement</class>
    <class kind="class">SoGLPolygonOffsetElement</class>
    <class kind="class">SoGLProjectionMatrixElement</class>
    <class kind="class">SoGLRenderPassElement</class>
    <class kind="class">SoGLShapeHintsElement</class>
    <class kind="class">SoGLUpdateAreaElement</class>
    <class kind="class">SoGLVBOElement</class>
    <class kind="class">SoGLViewingMatrixElement</class>
    <class kind="class">SoGLViewportRegionElement</class>
    <class kind="class">SoAccumulatedElement</class>
    <class kind="class">SoAmbientColorElement</class>
    <class kind="class">SoAnnoText3CharOrientElement</class>
    <class kind="class">SoAnnoText3FontSizeHintElement</class>
    <class kind="class">SoAnnoText3RenderPrintElement</class>
    <class kind="class">SoBBoxModelMatrixElement</class>
    <class kind="class">SoBumpMapCoordinateElement</class>
    <class kind="class">SoBumpMapElement</class>
    <class kind="class">SoBumpMapMatrixElement</class>
    <class kind="class">SoCacheElement</class>
    <class kind="class">SoClipPlaneElement</class>
    <class kind="class">SoComplexityElement</class>
    <class kind="class">SoComplexityTypeElement</class>
    <class kind="class">SoCoordinateElement</class>
    <class kind="class">SoCreaseAngleElement</class>
    <class kind="class">SoCullElement</class>
    <class kind="class">SoDecimationPercentageElement</class>
    <class kind="class">SoDecimationTypeElement</class>
    <class kind="class">SoDepthBufferElement</class>
    <class kind="class">SoDiffuseColorElement</class>
    <class kind="class">SoDrawStyleElement</class>
    <class kind="class">SoElement</class>
    <class kind="class">SoEmissiveColorElement</class>
    <class kind="class">SoEnvironmentElement</class>
    <class kind="class">SoFloatElement</class>
    <class kind="class">SoFocalDistanceElement</class>
    <class kind="class">SoFontNameElement</class>
    <class kind="class">SoFontSizeElement</class>
    <class kind="class">SoInt32Element</class>
    <class kind="class">SoLazyElement</class>
    <class kind="class">SoLightAttenuationElement</class>
    <class kind="class">SoLightElement</class>
    <class kind="class">SoLightModelElement</class>
    <class kind="class">SoLinePatternElement</class>
    <class kind="class">SoLineWidthElement</class>
    <class kind="class">SoListenerDopplerElement</class>
    <class kind="class">SoListenerGainElement</class>
    <class kind="class">SoListenerOrientationElement</class>
    <class kind="class">SoListenerPositionElement</class>
    <class kind="class">SoLocalBBoxMatrixElement</class>
    <class kind="class">SoMaterialBindingElement</class>
    <class kind="class">SoModelMatrixElement</class>
    <class kind="class">SoMultiTextureCoordinateElement</class>
    <class kind="class">SoMultiTextureEnabledElement</class>
    <class kind="class">SoMultiTextureImageElement</class>
    <class kind="class">SoMultiTextureMatrixElement</class>
    <class kind="class">SoNormalBindingElement</class>
    <class kind="class">SoNormalElement</class>
    <class kind="class">SoOverrideElement</class>
    <class kind="class">SoPickRayElement</class>
    <class kind="class">SoPickStyleElement</class>
    <class kind="class">SoPointSizeElement</class>
    <class kind="class">SoPolygonOffsetElement</class>
    <class kind="class">SoProfileCoordinateElement</class>
    <class kind="class">SoProfileElement</class>
    <class kind="class">SoReplacedElement</class>
    <class kind="class">SoShapeStyleElement</class>
    <class kind="class">SoShininessElement</class>
    <class kind="class">SoSoundElement</class>
    <class kind="class">SoSpecularColorElement</class>
    <class kind="class">SoSwitchElement</class>
    <class kind="class">SoTextOutlineEnabledElement</class>
    <class kind="class">SoTextureCombineElement</class>
    <class kind="class">SoTextureCoordinateBindingElement</class>
    <class kind="class">SoTextureOverrideElement</class>
    <class kind="class">SoTextureQualityElement</class>
    <class kind="class">SoTextureScalePolicyElement</class>
    <class kind="class">SoTextureScaleQualityElement</class>
    <class kind="class">SoTextureUnitElement</class>
    <class kind="class">SoTransparencyElement</class>
    <class kind="class">SoUnitsElement</class>
    <class kind="class">SoVertexAttributeBindingElement</class>
    <class kind="class">SoViewingMatrixElement</class>
    <class kind="class">SoViewportRegionElement</class>
    <class kind="class">SoViewVolumeElement</class>
    <class kind="class">SoWindowElement</class>
    <class kind="class">SoGeoElement</class>
    <class kind="class">SoGLShadowCullingElement</class>
    <class kind="class">SoShadowStyleElement</class>
    <page>group__elements</page>
  </compound>
  <compound kind="group">
    <name>engines</name>
    <title>Engine Classes</title>
    <filename>group__engines.html</filename>
    <class kind="class">SoBoolOperation</class>
    <class kind="class">SoCalculator</class>
    <class kind="class">SoComposeMatrix</class>
    <class kind="class">SoComposeRotation</class>
    <class kind="class">SoComposeRotationFromTo</class>
    <class kind="class">SoComposeVec2f</class>
    <class kind="class">SoComposeVec3f</class>
    <class kind="class">SoComposeVec4f</class>
    <class kind="class">SoComputeBoundingBox</class>
    <class kind="class">SoConcatenate</class>
    <class kind="class">SoCounter</class>
    <class kind="class">SoDecomposeMatrix</class>
    <class kind="class">SoDecomposeRotation</class>
    <class kind="class">SoDecomposeVec2f</class>
    <class kind="class">SoDecomposeVec3f</class>
    <class kind="class">SoDecomposeVec4f</class>
    <class kind="class">SoElapsedTime</class>
    <class kind="class">SoEngine</class>
    <class kind="class">SoEngineOutput</class>
    <class kind="class">SoFieldConverter</class>
    <class kind="class">SoGate</class>
    <class kind="class">SoHeightMapToNormalMap</class>
    <class kind="class">SoInterpolate</class>
    <class kind="class">SoInterpolateFloat</class>
    <class kind="class">SoInterpolateRotation</class>
    <class kind="class">SoInterpolateVec2f</class>
    <class kind="class">SoInterpolateVec3f</class>
    <class kind="class">SoInterpolateVec4f</class>
    <class kind="class">SoNodeEngine</class>
    <class kind="class">SoOneShot</class>
    <class kind="class">SoOnOff</class>
    <class kind="class">SoEngineOutputData</class>
    <class kind="class">SoSelectOne</class>
    <class kind="class">SoTexture2Convert</class>
    <class kind="class">SoTimeCounter</class>
    <class kind="class">SoTransformVec3f</class>
    <class kind="class">SoTriggerAny</class>
    <class kind="class">SoEngineList</class>
    <class kind="class">SoEngineOutputList</class>
  </compound>
  <compound kind="group">
    <name>errors</name>
    <title>Error Handling Classes</title>
    <filename>group__errors.html</filename>
    <class kind="class">SoDebugError</class>
    <class kind="class">SoError</class>
    <class kind="class">SoMemoryError</class>
    <class kind="class">SoReadError</class>
    <member kind="typedef">
      <type>struct cc_debugerror</type>
      <name>cc_debugerror</name>
      <anchorfile>group__errors.html</anchorfile>
      <anchor>ga98981b5dfb3a50dba80de1fdf6aa9109</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>struct cc_error</type>
      <name>cc_error</name>
      <anchorfile>group__errors.html</anchorfile>
      <anchor>ga1fb56dcbdf4946c4519c715b92caca14</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>events</name>
    <title>Event Classes</title>
    <filename>group__events.html</filename>
    <class kind="class">SoButtonEvent</class>
    <class kind="class">SoEvent</class>
    <class kind="class">SoKeyboardEvent</class>
    <class kind="class">SoLocation2Event</class>
    <class kind="class">SoMotion3Event</class>
    <class kind="class">SoMouseButtonEvent</class>
    <class kind="class">SoSpaceballButtonEvent</class>
  </compound>
  <compound kind="group">
    <name>fields</name>
    <title>Field Classes</title>
    <filename>group__fields.html</filename>
    <class kind="class">SoField</class>
    <class kind="class">SoFieldData</class>
    <class kind="class">SoMFBitMask</class>
    <class kind="class">SoMFBool</class>
    <class kind="class">SoMFColor</class>
    <class kind="class">SoMFColorRGBA</class>
    <class kind="class">SoMFDouble</class>
    <class kind="class">SoMFEngine</class>
    <class kind="class">SoMFEnum</class>
    <class kind="class">SoMFFloat</class>
    <class kind="class">SoMField</class>
    <class kind="class">SoMFInt32</class>
    <class kind="class">SoMFMatrix</class>
    <class kind="class">SoMFName</class>
    <class kind="class">SoMFNode</class>
    <class kind="class">SoMFPath</class>
    <class kind="class">SoMFPlane</class>
    <class kind="class">SoMFRotation</class>
    <class kind="class">SoMFShort</class>
    <class kind="class">SoMFString</class>
    <class kind="class">SoMFTime</class>
    <class kind="class">SoMFUInt32</class>
    <class kind="class">SoMFUShort</class>
    <class kind="class">SoMFVec2b</class>
    <class kind="class">SoMFVec2d</class>
    <class kind="class">SoMFVec2f</class>
    <class kind="class">SoMFVec2i32</class>
    <class kind="class">SoMFVec2s</class>
    <class kind="class">SoMFVec3b</class>
    <class kind="class">SoMFVec3d</class>
    <class kind="class">SoMFVec3f</class>
    <class kind="class">SoMFVec3i32</class>
    <class kind="class">SoMFVec3s</class>
    <class kind="class">SoMFVec4b</class>
    <class kind="class">SoMFVec4d</class>
    <class kind="class">SoMFVec4f</class>
    <class kind="class">SoMFVec4i32</class>
    <class kind="class">SoMFVec4s</class>
    <class kind="class">SoMFVec4ub</class>
    <class kind="class">SoMFVec4ui32</class>
    <class kind="class">SoMFVec4us</class>
    <class kind="class">SoSFBitMask</class>
    <class kind="class">SoSFBool</class>
    <class kind="class">SoSFBox2d</class>
    <class kind="class">SoSFBox2f</class>
    <class kind="class">SoSFBox2i32</class>
    <class kind="class">SoSFBox2s</class>
    <class kind="class">SoSFBox3d</class>
    <class kind="class">SoSFBox3f</class>
    <class kind="class">SoSFBox3i32</class>
    <class kind="class">SoSFBox3s</class>
    <class kind="class">SoSFColor</class>
    <class kind="class">SoSFColorRGBA</class>
    <class kind="class">SoSFDouble</class>
    <class kind="class">SoSFEngine</class>
    <class kind="class">SoSFEnum</class>
    <class kind="class">SoSFFloat</class>
    <class kind="class">SoSField</class>
    <class kind="class">SoSFImage3</class>
    <class kind="class">SoSFImage</class>
    <class kind="class">SoSFInt32</class>
    <class kind="class">SoSFMatrix</class>
    <class kind="class">SoSFName</class>
    <class kind="class">SoSFNode</class>
    <class kind="class">SoSFPath</class>
    <class kind="class">SoSFPlane</class>
    <class kind="class">SoSFRotation</class>
    <class kind="class">SoSFShort</class>
    <class kind="class">SoSFString</class>
    <class kind="class">SoSFTime</class>
    <class kind="class">SoSFTrigger</class>
    <class kind="class">SoSFUInt32</class>
    <class kind="class">SoSFUShort</class>
    <class kind="class">SoSFVec2b</class>
    <class kind="class">SoSFVec2d</class>
    <class kind="class">SoSFVec2f</class>
    <class kind="class">SoSFVec2i32</class>
    <class kind="class">SoSFVec2s</class>
    <class kind="class">SoSFVec3b</class>
    <class kind="class">SoSFVec3d</class>
    <class kind="class">SoSFVec3f</class>
    <class kind="class">SoSFVec3i32</class>
    <class kind="class">SoSFVec3s</class>
    <class kind="class">SoSFVec4b</class>
    <class kind="class">SoSFVec4d</class>
    <class kind="class">SoSFVec4f</class>
    <class kind="class">SoSFVec4i32</class>
    <class kind="class">SoSFVec4s</class>
    <class kind="class">SoSFVec4ub</class>
    <class kind="class">SoSFVec4ui32</class>
    <class kind="class">SoSFVec4us</class>
    <class kind="class">SoFieldList</class>
  </compound>
  <compound kind="group">
    <name>general</name>
    <title>Miscellaneous Classes</title>
    <filename>group__general.html</filename>
    <class kind="class">SoFieldContainer</class>
    <class kind="class">SoInput</class>
    <class kind="class">SoOutput</class>
    <class kind="class">SoAuditorList</class>
    <class kind="class">SoBaseList</class>
    <class kind="class">SoCallbackList</class>
    <class kind="class">SoPathList</class>
    <class kind="class">SoPickedPointList</class>
    <class kind="class">SoTypeList</class>
    <class kind="class">SoAudioDevice</class>
    <class kind="class">SoBase</class>
    <class kind="class">SoChildList</class>
    <class kind="class">SoContextHandler</class>
    <class kind="class">SoDB</class>
    <class kind="class">SoFullPath</class>
    <class kind="class">SoInteraction</class>
    <class kind="class">SoLightPath</class>
    <class kind="class">SoLockManager</class>
    <class kind="class">SoNormalGenerator</class>
    <class kind="class">SoNotList</class>
    <class kind="class">SoNotRec</class>
    <class kind="class">SoPath</class>
    <class kind="class">SoPickedPoint</class>
    <class kind="class">SoPrimitiveVertex</class>
    <class kind="class">SoSceneManager</class>
    <class kind="class">SoState</class>
    <class kind="class">SoTempPath</class>
    <class kind="class">SoType</class>
    <class kind="class">SoOffscreenRenderer</class>
  </compound>
  <compound kind="group">
    <name>manips</name>
    <title>Manipulator Classes</title>
    <filename>group__manips.html</filename>
    <class kind="class">SoCenterballManip</class>
    <class kind="class">SoClipPlaneManip</class>
    <class kind="class">SoDirectionalLightManip</class>
    <class kind="class">SoHandleBoxManip</class>
    <class kind="class">SoJackManip</class>
    <class kind="class">SoPointLightManip</class>
    <class kind="class">SoSpotLightManip</class>
    <class kind="class">SoTabBoxManip</class>
    <class kind="class">SoTrackballManip</class>
    <class kind="class">SoTransformBoxManip</class>
    <class kind="class">SoTransformerManip</class>
    <class kind="class">SoTransformManip</class>
  </compound>
  <compound kind="group">
    <name>navigation</name>
    <title>Navigation Classes</title>
    <filename>group__navigation.html</filename>
    <class kind="class">SoScXMLDollyTarget</class>
    <class kind="class">SoScXMLFlightControlTarget</class>
    <class kind="class">SoScXMLMiscTarget</class>
    <class kind="class">SoScXMLMotionTarget</class>
    <class kind="class">SoScXMLNavigation</class>
    <class kind="class">SoScXMLNavigationTarget</class>
    <class kind="class">SoScXMLPanTarget</class>
    <class kind="class">SoScXMLRotateTarget</class>
    <class kind="class">SoScXMLSeekTarget</class>
    <class kind="class">SoScXMLSpinTarget</class>
    <class kind="class">SoScXMLZoomTarget</class>
  </compound>
  <compound kind="group">
    <name>nodekits</name>
    <title>NodeKit Classes</title>
    <filename>group__nodekits.html</filename>
    <class kind="class">SoAppearanceKit</class>
    <class kind="class">SoBaseKit</class>
    <class kind="class">SoCameraKit</class>
    <class kind="class">SoInteractionKit</class>
    <class kind="class">SoLightKit</class>
    <class kind="class">SoNodekitCatalog</class>
    <class kind="class">SoNodeKit</class>
    <class kind="class">SoNodeKitListPart</class>
    <class kind="class">SoNodeKitPath</class>
    <class kind="class">SoSceneKit</class>
    <class kind="class">SoSeparatorKit</class>
    <class kind="class">SoShapeKit</class>
    <class kind="class">SoWrapperKit</class>
  </compound>
  <compound kind="group">
    <name>nodes</name>
    <title>Node Classes</title>
    <filename>group__nodes.html</filename>
    <class kind="class">SoGeoCoordinate</class>
    <class kind="class">SoGeoLocation</class>
    <class kind="class">SoGeoOrigin</class>
    <class kind="class">SoGeoSeparator</class>
    <class kind="class">SoAlphaTest</class>
    <class kind="class">SoAnnotation</class>
    <class kind="class">SoAntiSquish</class>
    <class kind="class">SoArray</class>
    <class kind="class">SoBaseColor</class>
    <class kind="class">SoBlinker</class>
    <class kind="class">SoBumpMapCoordinate</class>
    <class kind="class">SoBumpMap</class>
    <class kind="class">SoBumpMapTransform</class>
    <class kind="class">SoCacheHint</class>
    <class kind="class">SoCallback</class>
    <class kind="class">SoCamera</class>
    <class kind="class">SoClipPlane</class>
    <class kind="class">SoColorIndex</class>
    <class kind="class">SoComplexity</class>
    <class kind="class">SoCoordinate3</class>
    <class kind="class">SoCoordinate4</class>
    <class kind="class">SoDepthBuffer</class>
    <class kind="class">SoDirectionalLight</class>
    <class kind="class">SoDrawStyle</class>
    <class kind="class">SoEnvironment</class>
    <class kind="class">SoEventCallback</class>
    <class kind="class">SoExtSelection</class>
    <class kind="class">SoFile</class>
    <class kind="class">SoFont</class>
    <class kind="class">SoFontStyle</class>
    <class kind="class">SoFrustumCamera</class>
    <class kind="class">SoGroup</class>
    <class kind="class">SoInfo</class>
    <class kind="class">SoLabel</class>
    <class kind="class">SoLevelOfDetail</class>
    <class kind="class">SoLight</class>
    <class kind="class">SoLightModel</class>
    <class kind="class">SoLinearProfile</class>
    <class kind="class">SoListener</class>
    <class kind="class">SoLocateHighlight</class>
    <class kind="class">SoLOD</class>
    <class kind="class">SoMaterialBinding</class>
    <class kind="class">SoMaterial</class>
    <class kind="class">SoMatrixTransform</class>
    <class kind="class">SoMultipleCopy</class>
    <class kind="class">SoNode</class>
    <class kind="class">SoNormalBinding</class>
    <class kind="class">SoNormal</class>
    <class kind="class">SoNurbsProfile</class>
    <class kind="class">SoOrthographicCamera</class>
    <class kind="class">SoPackedColor</class>
    <class kind="class">SoPathSwitch</class>
    <class kind="class">SoPendulum</class>
    <class kind="class">SoPerspectiveCamera</class>
    <class kind="class">SoPickStyle</class>
    <class kind="class">SoPointLight</class>
    <class kind="class">SoPolygonOffset</class>
    <class kind="class">SoProfileCoordinate2</class>
    <class kind="class">SoProfileCoordinate3</class>
    <class kind="class">SoProfile</class>
    <class kind="class">SoResetTransform</class>
    <class kind="class">SoRotation</class>
    <class kind="class">SoRotationXYZ</class>
    <class kind="class">SoRotor</class>
    <class kind="class">SoScale</class>
    <class kind="class">SoSceneTexture2</class>
    <class kind="class">SoSceneTextureCubeMap</class>
    <class kind="class">SoSelection</class>
    <class kind="class">SoSeparator</class>
    <class kind="class">SoShapeHints</class>
    <class kind="class">SoShuttle</class>
    <class kind="class">SoSpotLight</class>
    <class kind="class">SoSurroundScale</class>
    <class kind="class">SoSwitch</class>
    <class kind="class">SoTexture2</class>
    <class kind="class">SoTexture2Transform</class>
    <class kind="class">SoTexture3</class>
    <class kind="class">SoTexture3Transform</class>
    <class kind="class">SoTextureCombine</class>
    <class kind="class">SoTextureCoordinate2</class>
    <class kind="class">SoTextureCoordinate3</class>
    <class kind="class">SoTextureCoordinateBinding</class>
    <class kind="class">SoTextureCoordinateCube</class>
    <class kind="class">SoTextureCoordinateCylinder</class>
    <class kind="class">SoTextureCoordinateDefault</class>
    <class kind="class">SoTextureCoordinateEnvironment</class>
    <class kind="class">SoTextureCoordinateFunction</class>
    <class kind="class">SoTextureCoordinateNormalMap</class>
    <class kind="class">SoTextureCoordinateObject</class>
    <class kind="class">SoTextureCoordinatePlane</class>
    <class kind="class">SoTextureCoordinateReflectionMap</class>
    <class kind="class">SoTextureCoordinateSphere</class>
    <class kind="class">SoTextureCubeMap</class>
    <class kind="class">SoTextureMatrixTransform</class>
    <class kind="class">SoTextureScalePolicy</class>
    <class kind="class">SoTextureUnit</class>
    <class kind="class">SoTransformation</class>
    <class kind="class">SoTransform</class>
    <class kind="class">SoTransformSeparator</class>
    <class kind="class">SoTranslation</class>
    <class kind="class">SoTransparencyType</class>
    <class kind="class">SoUnits</class>
    <class kind="class">SoVertexProperty</class>
    <class kind="class">SoWWWAnchor</class>
    <class kind="class">SoWWWInline</class>
    <class kind="class">SoFragmentShader</class>
    <class kind="class">SoGeometryShader</class>
    <class kind="class">SoVertexShader</class>
    <class kind="class">SoShadowCulling</class>
    <class kind="class">SoShadowSpotLight</class>
    <class kind="class">SoShadowStyle</class>
    <class kind="class">SoAsciiText</class>
    <class kind="class">SoCone</class>
    <class kind="class">SoCube</class>
    <class kind="class">SoCylinder</class>
    <class kind="class">SoFaceSet</class>
    <class kind="class">SoImage</class>
    <class kind="class">SoIndexedFaceSet</class>
    <class kind="class">SoIndexedLineSet</class>
    <class kind="class">SoIndexedMarkerSet</class>
    <class kind="class">SoIndexedNurbsCurve</class>
    <class kind="class">SoIndexedNurbsSurface</class>
    <class kind="class">SoIndexedPointSet</class>
    <class kind="class">SoIndexedShape</class>
    <class kind="class">SoIndexedTriangleStripSet</class>
    <class kind="class">SoLineSet</class>
    <class kind="class">SoMarkerSet</class>
    <class kind="class">SoNonIndexedShape</class>
    <class kind="class">SoNurbsCurve</class>
    <class kind="class">SoNurbsSurface</class>
    <class kind="class">SoPointSet</class>
    <class kind="class">SoQuadMesh</class>
    <class kind="class">SoShape</class>
    <class kind="class">SoSphere</class>
    <class kind="class">SoText2</class>
    <class kind="class">SoText3</class>
    <class kind="class">SoTriangleStripSet</class>
    <class kind="class">SoVertexShape</class>
    <class kind="class">SoPackedColorV20</class>
    <class kind="class">SoShapeHintsV10</class>
    <class kind="class">SoUpgrader</class>
    <member kind="define">
      <type>#define</type>
      <name>SO_NODE_HEADER</name>
      <anchorfile>group__nodes.html</anchorfile>
      <anchor>ga2c4d8b776be8aac5d22cf94b7b92235e</anchor>
      <arglist>(classname)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>SO_NODE_ABSTRACT_HEADER</name>
      <anchorfile>group__nodes.html</anchorfile>
      <anchor>ga2bb0ff232b768799a8f33832780e23b0</anchor>
      <arglist>(classname)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>SO_NODE_INIT_CLASS</name>
      <anchorfile>group__nodes.html</anchorfile>
      <anchor>ga3498e0cf3179332511a984d81b6bbd62</anchor>
      <arglist>(classname, parentclass, parentname)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>SO_NODE_INIT_ABSTRACT_CLASS</name>
      <anchorfile>group__nodes.html</anchorfile>
      <anchor>gab7e402b0a82fae1a3abdd4d9afe833cc</anchor>
      <arglist>(classname, parentclass, parentname)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>SO_NODE_SOURCE</name>
      <anchorfile>group__nodes.html</anchorfile>
      <anchor>ga0c812aee96f40bd1b759f8c5a9d09b48</anchor>
      <arglist>(classname)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>SO_NODE_ABSTRACT_SOURCE</name>
      <anchorfile>group__nodes.html</anchorfile>
      <anchor>ga687f9e5e91d6cec3bb4f8aac7a753473</anchor>
      <arglist>(classname)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>SO_NODE_CONSTRUCTOR</name>
      <anchorfile>group__nodes.html</anchorfile>
      <anchor>ga5aa0e28f57bbf350f271c1550156281f</anchor>
      <arglist>(classname)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>SO_NODE_IS_FIRST_INSTANCE</name>
      <anchorfile>group__nodes.html</anchorfile>
      <anchor>ga7342238d25c2224535918b8e5b3f8bfd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>SO_NODE_ADD_FIELD</name>
      <anchorfile>group__nodes.html</anchorfile>
      <anchor>gaba48e7967e2d337365375343dc650c45</anchor>
      <arglist>(field, defaultvalue)</arglist>
    </member>
    <member kind="define">
      <type>#define</type>
      <name>SO_NODE_DEFINE_ENUM_VALUE</name>
      <anchorfile>group__nodes.html</anchorfile>
      <anchor>ga1c28d883c32ef2ac0e5b758d6061fcb2</anchor>
      <arglist>(enumname, enumvalue)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SoType</type>
      <name>getClassTypeId</name>
      <anchorfile>group__nodes.html</anchorfile>
      <anchor>ga9513de738f5681eeae4bb9f8ff5e7500</anchor>
      <arglist>(void)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>projectors</name>
    <title>Projector Classes</title>
    <filename>group__projectors.html</filename>
    <class kind="class">SbCylinderPlaneProjector</class>
    <class kind="class">SbCylinderProjector</class>
    <class kind="class">SbCylinderSectionProjector</class>
    <class kind="class">SbCylinderSheetProjector</class>
    <class kind="class">SbLineProjector</class>
    <class kind="class">SbPlaneProjector</class>
    <class kind="class">SbProjector</class>
    <class kind="class">SbSpherePlaneProjector</class>
    <class kind="class">SbSphereProjector</class>
    <class kind="class">SbSphereSectionProjector</class>
    <class kind="class">SbSphereSheetProjector</class>
  </compound>
  <compound kind="group">
    <name>sensors</name>
    <title>Sensor Classes</title>
    <filename>group__sensors.html</filename>
    <class kind="class">SoAlarmSensor</class>
    <class kind="class">SoDataSensor</class>
    <class kind="class">SoDelayQueueSensor</class>
    <class kind="class">SoFieldSensor</class>
    <class kind="class">SoIdleSensor</class>
    <class kind="class">SoNodeSensor</class>
    <class kind="class">SoOneShotSensor</class>
    <class kind="class">SoPathSensor</class>
    <class kind="class">SoSensor</class>
    <class kind="class">SoSensorManager</class>
    <class kind="class">SoTimerQueueSensor</class>
    <class kind="class">SoTimerSensor</class>
  </compound>
  <compound kind="group">
    <name>shaders</name>
    <title>Shader Classes</title>
    <filename>group__shaders.html</filename>
    <class kind="class">SoVertexAttributeBinding</class>
    <class kind="class">SoVertexAttribute</class>
    <class kind="class">SoShaderObject</class>
    <class kind="class">SoShaderProgram</class>
  </compound>
  <compound kind="group">
    <name>soscxml</name>
    <title>Coin specific State Chart XML Classes</title>
    <filename>group__soscxml.html</filename>
    <class kind="class">ScXMLCoinEvaluator</class>
    <class kind="class">SoScXMLEvent</class>
    <class kind="class">SoScXMLStateMachine</class>
  </compound>
  <compound kind="group">
    <name>sound</name>
    <title>3D Sound Support Classes</title>
    <filename>group__sound.html</filename>
    <class kind="class">SoAudioDevice</class>
    <class kind="class">SoListener</class>
    <class kind="class">SoVRMLAudioClip</class>
    <class kind="class">SoVRMLSound</class>
  </compound>
  <compound kind="group">
    <name>scxml</name>
    <title>State Chart XML Classes</title>
    <filename>group__scxml.html</filename>
    <class kind="class">ScXMLAbstractStateElt</class>
    <class kind="class">ScXMLAnchorElt</class>
    <class kind="class">ScXMLAssignElt</class>
    <class kind="class">ScXMLContentElt</class>
    <class kind="class">ScXML</class>
    <class kind="class">ScXMLDataElt</class>
    <class kind="class">ScXMLDataModelElt</class>
    <class kind="class">ScXMLECMAScriptEvaluator</class>
    <class kind="class">ScXMLElseElt</class>
    <class kind="class">ScXMLElseIfElt</class>
    <class kind="class">ScXMLElt</class>
    <class kind="class">ScXMLEltReader</class>
    <class kind="class">ScXMLEvaluator</class>
    <class kind="class">ScXMLDataObj</class>
    <class kind="class">ScXMLConstantDataObj</class>
    <class kind="class">ScXMLReferenceDataObj</class>
    <class kind="class">ScXMLAndOpExprDataObj</class>
    <class kind="class">ScXMLEvent</class>
    <class kind="class">ScXMLEventElt</class>
    <class kind="class">ScXMLEventTarget</class>
    <class kind="class">ScXMLExecutableElt</class>
    <class kind="class">ScXMLFinalElt</class>
    <class kind="class">ScXMLFinalizeElt</class>
    <class kind="class">ScXMLHistoryElt</class>
    <class kind="class">ScXMLIfElt</class>
    <class kind="class">ScXMLInitialElt</class>
    <class kind="class">ScXMLInvokeElt</class>
    <class kind="class">ScXMLLogElt</class>
    <class kind="class">ScXMLMinimumExprDataObj</class>
    <class kind="class">ScXMLMinimumEvaluator</class>
    <class kind="class">ScXMLObject</class>
    <class kind="class">ScXMLOnEntryElt</class>
    <class kind="class">ScXMLOnExitElt</class>
    <class kind="class">ScXMLParallelElt</class>
    <class kind="class">ScXMLParamElt</class>
    <class kind="class">ScXMLScriptElt</class>
    <class kind="class">ScXMLScxmlElt</class>
    <class kind="class">ScXMLSendElt</class>
    <class kind="class">ScXMLStateElt</class>
    <class kind="class">ScXMLStateMachine</class>
    <class kind="class">ScXMLTransitionElt</class>
    <class kind="class">ScXMLValidateElt</class>
    <class kind="class">ScXMLXPathEvaluator</class>
    <page>group__scxml</page>
  </compound>
  <compound kind="group">
    <name>threads</name>
    <title>Portable Threads Abstraction Classes</title>
    <filename>group__threads.html</filename>
  </compound>
  <compound kind="group">
    <name>VRMLnodes</name>
    <title>VRML97 Classes</title>
    <filename>group__VRMLnodes.html</filename>
    <class kind="class">SoVRMLAnchor</class>
    <class kind="class">SoVRMLAppearance</class>
    <class kind="class">SoVRMLAudioClip</class>
    <class kind="class">SoVRMLBackground</class>
    <class kind="class">SoVRMLBillboard</class>
    <class kind="class">SoVRMLBox</class>
    <class kind="class">SoVRMLCollision</class>
    <class kind="class">SoVRMLColor</class>
    <class kind="class">SoVRMLColorInterpolator</class>
    <class kind="class">SoVRMLCone</class>
    <class kind="class">SoVRMLCoordinate</class>
    <class kind="class">SoVRMLCoordinateInterpolator</class>
    <class kind="class">SoVRMLCylinder</class>
    <class kind="class">SoVRMLCylinderSensor</class>
    <class kind="class">SoVRMLDirectionalLight</class>
    <class kind="class">SoVRMLElevationGrid</class>
    <class kind="class">SoVRMLExtrusion</class>
    <class kind="class">SoVRMLFog</class>
    <class kind="class">SoVRMLFontStyle</class>
    <class kind="class">SoVRMLGroup</class>
    <class kind="class">SoVRMLImageTexture</class>
    <class kind="class">SoVRMLIndexedFaceSet</class>
    <class kind="class">SoVRMLIndexedLine</class>
    <class kind="class">SoVRMLIndexedLineSet</class>
    <class kind="class">SoVRMLInline</class>
    <class kind="class">SoVRMLLOD</class>
    <class kind="class">SoVRMLMaterial</class>
    <class kind="class">SoVRMLMovieTexture</class>
    <class kind="class">SoVRMLNavigationInfo</class>
    <class kind="class">SoVRMLNormal</class>
    <class kind="class">SoVRMLNormalInterpolator</class>
    <class kind="class">SoVRMLOrientationInterpolator</class>
    <class kind="class">SoVRMLPixelTexture</class>
    <class kind="class">SoVRMLPlaneSensor</class>
    <class kind="class">SoVRMLPointLight</class>
    <class kind="class">SoVRMLPointSet</class>
    <class kind="class">SoVRMLPositionInterpolator</class>
    <class kind="class">SoVRMLProximitySensor</class>
    <class kind="class">SoVRMLScalarInterpolator</class>
    <class kind="class">SoVRMLScript</class>
    <class kind="class">SoVRMLShape</class>
    <class kind="class">SoVRMLSound</class>
    <class kind="class">SoVRMLSphere</class>
    <class kind="class">SoVRMLSphereSensor</class>
    <class kind="class">SoVRMLSpotLight</class>
    <class kind="class">SoVRMLSwitch</class>
    <class kind="class">SoVRMLText</class>
    <class kind="class">SoVRMLTextureCoordinate</class>
    <class kind="class">SoVRMLTextureTransform</class>
    <class kind="class">SoVRMLTimeSensor</class>
    <class kind="class">SoVRMLTouchSensor</class>
    <class kind="class">SoVRMLTransform</class>
    <class kind="class">SoVRMLViewpoint</class>
    <class kind="class">SoVRMLVisibilitySensor</class>
    <class kind="class">SoVRMLWorldInfo</class>
  </compound>
  <compound kind="group">
    <name>hardcopy</name>
    <title>Vectorized Printing Classes</title>
    <filename>group__hardcopy.html</filename>
    <class kind="class">SoHardCopy</class>
    <class kind="class">SoPSVectorOutput</class>
    <class kind="class">SoVectorizeAction</class>
    <class kind="class">SoVectorizePSAction</class>
    <class kind="class">SoVectorOutput</class>
    <page>group__hardcopy</page>
  </compound>
  <compound kind="group">
    <name>XML</name>
    <title>XML related functions and objects</title>
    <filename>group__XML.html</filename>
    <member kind="typedef">
      <type>struct cc_xml_doc</type>
      <name>cc_xml_doc</name>
      <anchorfile>group__XML.html</anchorfile>
      <anchor>ga4668bec10f4a41c447ba1c9d42721a4b</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type>cc_xml_doc *</type>
      <name>cc_xml_doc_new</name>
      <anchorfile>group__XML.html</anchorfile>
      <anchor>gafe56d78ac5013d52bcde44c50832e003</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_xml_doc_delete_x</name>
      <anchorfile>group__XML.html</anchorfile>
      <anchor>ga2c3f2733691b7d1e60765c4c691433ee</anchor>
      <arglist>(cc_xml_doc *doc)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_xml_doc_set_filter_cb_x</name>
      <anchorfile>group__XML.html</anchorfile>
      <anchor>ga80383244e73c1e8bebe041d60a04fc26</anchor>
      <arglist>(cc_xml_doc *doc, cc_xml_filter_cb *cb, void *userdata)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>cc_xml_doc_get_filter_cb</name>
      <anchorfile>group__XML.html</anchorfile>
      <anchor>gaf233557263433cc126ab09e3d1f214da</anchor>
      <arglist>(const cc_xml_doc *doc, cc_xml_filter_cb *&amp;cb, void *&amp;userdata)</arglist>
    </member>
  </compound>
  <compound kind="group">
    <name>profiler</name>
    <title>Scene Graph Profiling</title>
    <filename>group__profiler.html</filename>
    <class kind="class">SbProfilingData</class>
    <class kind="class">SoProfiler</class>
    <class kind="class">SoProfilerElement</class>
    <class kind="class">SoProfilerStats</class>
    <class kind="class">SoProfilingReportGenerator</class>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_PROFILER</name>
      <anchorfile>group__profiler.html</anchorfile>
      <anchor>gaa961552d7a272cffa96986008e4559ef</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_PROFILER_OVERLAY</name>
      <anchorfile>group__profiler.html</anchorfile>
      <anchor>ga7a452448717da283f227a6e0372d98e1</anchor>
      <arglist></arglist>
    </member>
    <page>group__profiler</page>
  </compound>
  <compound kind="group">
    <name>macros</name>
    <title>Miscellaneous Macros</title>
    <filename>group__macros.html</filename>
    <page>group__macros</page>
  </compound>
  <compound kind="group">
    <name>envvars</name>
    <title>Miscellaneous Environment Variables</title>
    <filename>group__envvars.html</filename>
    <member kind="variable">
      <type>typedef</type>
      <name>EnvironmentVariable</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga160f0493fab38338b2f643e503f42c5a</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_DEBUG_GLU_INFO</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>gac471927112b8114e3ff80638a0c41186</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_DEBUG_GLU_VERSION</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>gaa0c7252d566d12794c50afe2c949e26e</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_DEBUG_FONTSUPPORT</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>gaaab43c306c49c92e8cc7837fbe98ebc0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_DEBUG_3DS</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>gaaef79266d00c91619db6970261283019</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_DEBUG_AUDIO</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga096cfb4c1b2af14362f0143706eb6e5b</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_DEBUG_BREAK</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>gadc1f729d9eba031babda1b1e5956d2e4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_DEBUG_CACHING</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga1273bb807ef53967c55921ce1cc66557</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_DEBUG_DL</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga6be7e716a13ad32f259283561d621791</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_DEBUG_IMPORT</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga8abcb9727bec09662a67bb2cb9c18beb</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_DEBUG_LISTMODULES</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>gaf5d7ce55f98908f97b1808319a5c2c63</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_DEBUG_SOINPUT_FINDFILE</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>gafb8e1b4dad5ff10c6f0a06bef219175c</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_DEBUG_SOOFFSCREENRENDERER</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>gaf16ac7d963c63f0eadf747e84b75b84c</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_DEBUG_WRITEREFS</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>gae5ea9aff6622fd1236f2e74690fab1f1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_RANDOMIZE_RENDER_CACHING</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga46b8021248b01518f74e5df4f3c2bb9a</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_FREETYPE2_LIBNAME</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga731b0e30e1939bd3abebe6b96680efb4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_FORCE_FREETYPE_OFF</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>gacd5a3b63f91864450781ebeb03f4b893</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_FORCE_WIN32FONTS_OFF</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga08232d335b7fc29b5e0cee626c045f82</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_FONT_PATH</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga0aa96a2c671bb3c9d80fbbb617024dbc</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_DISABLE_UTF8</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>gacc8788192252e09ed3f717b1eeb4a16a</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_GLBBOX</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>gaebfb3f48ce42f98cf97cebda2fc8de7d</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_GLU_LIBNAME</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>gace7293f684f5a8226303a30b356bcc59</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_AGLGLUE_NO_PBUFFERS</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>gaed99424a50e132d6d22e55ff257e3e9b</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_SIMAGE_LIBNAME</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga61addf80a3f7ad56c9df060afda037f4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_GLXGLUE_NO_GLX13_PBUFFERS</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga993070d4e52f9c51f4996f2f301ee52a</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_GLXGLUE_NO_PBUFFERS</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga5258d9404c2bf90474f9be0d4da8f7e5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_ZLIB_LIBNAME</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga58c4d2cf2da06b9e7ff1d28c558a3b47</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_BZIP2_LIBNAME</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>gaccfa9bd01bec3355ec87015e4110b3fa</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_WGLGLUE_NO_PBUFFERS</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga70f080dfebc739f7c9743be051e8f514</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_DONT_MANGLE_OUTPUT_NAMES</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>gab314494bb3ca81e80c64aeb0fef8940c</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_EXTSELECTION_SAVE_OFFSCREENBUFFER</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>gaa49b5e6b3aa71be0bc74a835d5b08cdc</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_FORCE_TILED_OFFSCREENRENDERING</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga8ae1212fb971402447280627d0f4aee3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_GLERROR_DEBUGGING</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga189bff7fbefd8c698889694d3a492cd5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_IDA_DEBUG</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>gaee3fb64ca33c7bef5936ae4be9f57245</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_OFFSCREENRENDERER_MAX_TILESIZE</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga76c76e6c84bafaafae15b8173c684a2e</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_OFFSCREENRENDERER_TILEHEIGHT</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga78a40fec5d1ba802d0768769fc6423fb</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_OFFSCREENRENDERER_TILEWIDTH</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>gae95acf0bc238fdf2c7ce3dc285f007a6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_OLDSTYLE_FORMATTING</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>gaaca199dac7fb359e3fdc6741ab9bd872</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_SEPARATE_DIFFUSE_TRANSPARENCY_OVERRIDE</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga8c8c8b0022fc3d2badd4c5c7bac82fcd</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_SOINPUT_SEARCH_GLOBAL_DICT</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga5f815c4bd3e73423097eb410c530c604</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_SOOFFSCREENRENDERER_TILEPREFIX</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>gafa944ee0f96ff8ad92867e1869e3c31a</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_SORTED_LAYERS_USE_NVIDIA_RC</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga91e3e56e17045991d6b8e4a7afe2f056</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_SOUND_BUFFER_LENGTH</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga68e0a11c1fb3765f5f2513f7d71cf273</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_SOUND_DISABLE</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga31b4b9e855837945ed7263bdcaa3307e</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_SOUND_DRIVER_NAME</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>gaca77175c26f048fc7a56abea73c7a570</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_SOUND_ENABLE</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>gabc1642132634e56bcab3a54cdf552eef</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_SOUND_INTRO_PAUSE</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga3e2c52fc742c67a698efd763976ab3e0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_SOUND_NUM_BUFFERS</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga7bdb8c1d7d7b80adc7a68a7dec828488</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_SOUND_THREAD_SLEEP_TIME</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga45691a7924c93b53f1e812a1e32c8a26</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_OPENAL_LIBNAME</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga36ca646a5704c19038a5fc8b3b01ee12</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_TEX2_LINEAR_LIMIT</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga185320717d5b7f2d13916760b8c5e045</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_TEX2_LINEAR_MIPMAP_LIMIT</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga5c2d9df7b36ef9582ae011056f9bfb6c</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_TEX2_MIPMAP_LIMIT</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>gacf02c7b3e3a234c707c2da8692aff1e8</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_TEX2_SCALEUP_LIMIT</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga37c3053a7d2e969fedbabc869b0dfad8</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_TEX2_USE_GLTEXSUBIMAGE</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga3877be7fd2ef906a7946909577281c4e</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_MAXIMUM_TEXTURE2_SIZE</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga83ce1001456f60648a778cc64e82d1a8</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_MAXIMUM_TEXTURE3_SIZE</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>gaa5f9d6372d10298e698a7a17e7c4a4e9</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_USE_GL_VERTEX_ARRAYS</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>gacf0e6a30c525f548a29d9e8366d0f47b</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_NORMALIZATION_CUBEMAP_SIZE</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga8ca3d1ee345ec75836f520539b699f9b</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>OIV_NUM_SORTED_LAYERS_PASSES</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga0aeab0bd809f7e5cdc64f6b67ec1a9ac</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_MAX_VBO_MEMORY</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>gad387103012a6f22ca8f5b7a0294f454c</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_NUM_SORTED_LAYERS_PASSES</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>gaa6a3b1230da972797b4d774786345082</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_QUADMESH_PRECISE_LIGHTING</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>gadc08a2ed84e40e44d6eb805349bfdb1e</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_ENABLE_CONFORMANT_GL_CLAMP</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>gacc3ec6854a39775eff0c8eab3f1a9951</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>IV_SEPARATOR_MAX_CACHES</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga68bb6f654e01bed206d40bedee84e756</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_AUTOCACHE_LOCAL_MAX</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>gad6001c165dd6a19447f7c9cb9cef8134</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_AUTOCACHE_LOCAL_MIN</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>gae0e14afa32d5ffcf2a6d1cc55aaac462</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_AUTOCACHE_REMOTE_MAX</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga57e557edf508c6f196b62b753312cae3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_AUTOCACHE_REMOTE_MIN</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga8008e2e4b71d235c550b2a1e188f4412</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_AUTO_CACHING</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>gae5b82c8a059f77d2c8e6bbc3f7da6062</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_ENABLE_VBO</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga25235c1cdc3c0286344c1eefdfe0e1b7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_VBO</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga09298eef78a1fa87fd394142b93c78f1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_VBO_MAX_LIMIT</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga49c2d0f121c9621b0a22dd2e801a3f3a</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_VBO_MIN_LIMIT</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>gae490c79818e5b740fa4c0d70a0a3ce44</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_SOOFFSCREENRENDERER_ALLOW_RESOURCEHOG</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga3dd5609f80b099f4b86ee280a477292f</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>SO_DRAGGER_DIR</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga55da7b788a9a910ce2ddfebad2a74c34</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>SO_SHADER_DIR</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>gaa94c258a246eff7b6e4d36a01c786031</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COINDIR</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga242bc75fbc202307ad1fb3ae0b8b316e</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_ALLOW_SPIDERMONKEY</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga4c89fd2b9ddf4a6b63e2880891093f08</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_AUTOCACHE_VBO_LIMIT</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga0db997be15a8e8cb4e176f1a5950d141</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_CALCULATE_NURBS_NORMALS</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>gab02553d033733fc89b976850d958df7f</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_CGLGLUE_NO_PBUFFERS</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga4203b8bae9a614eb7f62c3405b0d09ac</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_CG_LIBNAME</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga163b4bee09739c7dba6e445cadde2f70</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_DEBUG_ASSERT_SOBASE_SETNAME</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga8876240dd54921d0383450be383d0fdd</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_DEBUG_BINARY_INPUT</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga91de9e91fc3bc34e259d9d415799b7fd</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_DEBUG_CLEANUP</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga377903ed55fa1f8d0a8e0d2b43c7c447</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_DEBUG_EXTRA</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>gafb7d9a7f53267772a8917f799783e51a</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_DEBUG_FLATTEN_NODEKITS_ON_WRITE</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga98356c3ca0074918440a09b2fdf2204c</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_DEBUG_GLRENDER_TRAVERSAL</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga7b535e23af93e5e4a885e4d5321d5708</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_DEBUG_GLUNURBSSURFACE</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga29a24548846897fba18074098b242ebf</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_DEBUG_INTERSECTIONDETECTIONACTION</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>gaef2e81d0e905622b24946f6fb9906c25</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_DEBUG_MUTEXLOCK_MAXTIME</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga0f3dec2e8867223f549730f6c85016c6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_DEBUG_MUTEXLOCK_TIMING</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga7d98e4e0dc3c2546fe6fa4f6bc2ffe74</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_DEBUG_MUTEX_COUNT</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga63be89e95dc4d5439662fc426e8b23f4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_DEBUG_NORMALIZE</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga6ec48b180882fd2359264bd67a6de5d3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_DEBUG_NPRINTF</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>gab88c648bca11e634df126a6d76785b69</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_DEBUG_NURBS_COMPLEXITY</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga6da066644fe988322d4574b0078e82b0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_DEBUG_ROOT_NOTIFICATIONS</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>gac5cc3ed62995b02c71abe08a9fa39a94</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_DEBUG_SIMAGE</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga9c1f39ff63f06e2254efb230830450a9</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_DEBUG_SOEXTSELECTION</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga26044abce8cbe4888b6ded4c9faae61e</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_DEBUG_SOFILE_READ</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>gad651e8252160322c989f48ad06579aeb</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_DEBUG_SOOFFSCREENRENDERER_TILEPREFIX</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga069aef2c8faa2ecb5d70e224c19d0fd2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_DEBUG_SPIDERMONKEY_BINDING</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>gaa24faeaeabed94bc9ff732669b879a8a</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_DEBUG_STRING_GROW</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga6d847145f404a75f9f073f93331fb41a</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_DEBUG_TRACK_SOBASE_INSTANCES</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>gadbcb0e2a26353d9156bc97e87f51df63</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_DEBUG_VBO</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga4c5d8f0cbc7641fa9ebe2be351498075</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_DEBUG_VRMLSCRIPT</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga3f4905c7632cae1ecf879f2524f7a9b9</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_FONTCONFIG_LIBNAME</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga204481c1d7cf268007bf6984c5ad5f30</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_FORCE_AGL</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga933bff42283f134e529902b01a972225</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_FORCE_FONTCONFIG_OFF</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga4257e1826f35d3e05faeaba07e9c4c5f</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_GLU_SILENCE_TESS_COMBINE_WARNING</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>gadef74b6ad69768ef63db05eaee034341</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_GL_DISABLE_VBO</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>gaf5eed218d9d54e605f70cac6450384a4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_GL_NO_CURRENT_CONTEXT_CHECK</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga7a624f62c581524264eacb8a7f770071</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_HANDLE_STACK_OVERFLOW</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga742145dc4b01b8a113e418b0a6ddee9f</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_NESTED_CACHING</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga7283d138f95dc54c2d69b5520dcb5500</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_NOT_STRICT_VRML97</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga10737573873c9079b67bd66ba84175f4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_NO_NVIDIA_COLOR_PER_FACE_BUG_WORKAROUND</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga8c89a53ce2a0d1e3857ea3540ff3b358</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_NO_SOTYPE_DYNLOAD</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga9e117ec4223842e36e8d950b51697c46</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_OFFSCREEN_STENCIL_BITS</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga2676124ca3ab75d2bc09ce1a1dec97fa</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_OLD_NURBS_COMPLEXITY</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>gad475a1075ec8665f3000c2b8f9682f1b</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_PREFER_GLU_TESSELLATOR</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>gabf5caa8df0f1e1dffc16540f6a0f2d5b</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_REDUCE_LINEAR_NURBS_STEPS</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga165feb145cfd7f49df3cd6a97071c26d</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_SMART_CACHING</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga117718249c07a559316a5ab06ee2d3ad</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_SPIDERMONKEY_LIBNAME</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga3186e3287f274b3af87e6d60e29d6ff5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_TEX2_ANISOTROPIC_LIMIT</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga20f9cc473f3572486af7e18e2da0ef76</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_TEX2_USE_SGIS_GENERATE_MIPMAP</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>gaded751af564b7687a3137f5dcf0026b3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_VERTEX_ARRAYS</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>gafff36f9cad1322e147739161279022dd</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>COIN_VIEWUP</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>ga1a8a23c9700aba9d269fc5d13a728c83</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>EnvironmentVariable</type>
      <name>WINDIR</name>
      <anchorfile>group__envvars.html</anchorfile>
      <anchor>gaeb1dcdafd3fe5f8f015d07406747698c</anchor>
      <arglist></arglist>
    </member>
    <page>group__envvars</page>
  </compound>
  <compound kind="struct">
    <name>cc_sched</name>
    <filename>structcc__sched.html</filename>
    <member kind="variable">
      <type>cc_mutex *</type>
      <name>mutex</name>
      <anchorfile>structcc__sched.html</anchorfile>
      <anchor>a6da30980570afd16c135de426ba4e18f</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>cc_heap *</type>
      <name>itemheap</name>
      <anchorfile>structcc__sched.html</anchorfile>
      <anchor>a3d6b3e3f5c1f60b9b90b7aa2f455ebcd</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>cc_memalloc *</type>
      <name>itemalloc</name>
      <anchorfile>structcc__sched.html</anchorfile>
      <anchor>acb961ec417d5ee2aafd228c8c04940c3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>uint32_t</type>
      <name>schedid_counter</name>
      <anchorfile>structcc__sched.html</anchorfile>
      <anchor>a82393fb885f0b7140902a6504e5b1cf9</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>int</type>
      <name>numallowed</name>
      <anchorfile>structcc__sched.html</anchorfile>
      <anchor>a173fa179764cab8517e51354562060ee</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SbBool</type>
      <name>iswaitingall</name>
      <anchorfile>structcc__sched.html</anchorfile>
      <anchor>a068eac36eaf28bdd77c488b802a83ffa</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>cc_string</name>
    <filename>structcc__string.html</filename>
  </compound>
  <compound kind="class">
    <name>SbBox2d</name>
    <filename>classSbBox2d.html</filename>
    <member kind="function">
      <type></type>
      <name>SbBox2d</name>
      <anchorfile>classSbBox2d.html</anchorfile>
      <anchor>ab5d433a13b536b2935830e6e0e81bbcf</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbBox2d</name>
      <anchorfile>classSbBox2d.html</anchorfile>
      <anchor>ab35a9df21fe541e6d26f1d9bdb18001b</anchor>
      <arglist>(double xmin, double ymin, double xmax, double ymax)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbBox2d</name>
      <anchorfile>classSbBox2d.html</anchorfile>
      <anchor>a47551f0655643ba2556d56dc137e2aa3</anchor>
      <arglist>(const SbVec2d &amp;minpoint, const SbVec2d &amp;maxpoint)</arglist>
    </member>
    <member kind="function">
      <type>SbBox2d &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox2d.html</anchorfile>
      <anchor>ac95c2f308fed44c6bb399e61a50a9f70</anchor>
      <arglist>(double xmin, double ymin, double xmax, double ymax)</arglist>
    </member>
    <member kind="function">
      <type>SbBox2d &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox2d.html</anchorfile>
      <anchor>a28504f92d8e1af08da2f841883b8a839</anchor>
      <arglist>(const SbVec2d &amp;minpoint, const SbVec2d &amp;maxpoint)</arglist>
    </member>
    <member kind="function">
      <type>SbBox2d &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox2d.html</anchorfile>
      <anchor>a9911fcb3302faad2b6778a20bc7f2509</anchor>
      <arglist>(const SbBox2f &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>SbBox2d &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox2d.html</anchorfile>
      <anchor>a2c86872d0aea6b849904f1714174f307</anchor>
      <arglist>(const SbBox2s &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>SbBox2d &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox2d.html</anchorfile>
      <anchor>a52d1f9128dd2d5068b936f0dfbeee3a8</anchor>
      <arglist>(const SbBox2i32 &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getBounds</name>
      <anchorfile>classSbBox2d.html</anchorfile>
      <anchor>a234cb25edb09f55cbcd2214f06f6e6ed</anchor>
      <arglist>(double &amp;xmin, double &amp;ymin, double &amp;xmax, double &amp;ymax) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getBounds</name>
      <anchorfile>classSbBox2d.html</anchorfile>
      <anchor>a1f20170a2b0418efa77f321e935f15f5</anchor>
      <arglist>(SbVec2d &amp;minpoint, SbVec2d &amp;maxpoint) const </arglist>
    </member>
    <member kind="function">
      <type>const SbVec2d &amp;</type>
      <name>getMin</name>
      <anchorfile>classSbBox2d.html</anchorfile>
      <anchor>a07e1d73e574c837502f77ddfd0550073</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SbVec2d &amp;</type>
      <name>getMin</name>
      <anchorfile>classSbBox2d.html</anchorfile>
      <anchor>a68745130b47973a8cbb4c96d6bb75035</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SbVec2d &amp;</type>
      <name>getMax</name>
      <anchorfile>classSbBox2d.html</anchorfile>
      <anchor>ae15e40202deab6d4db29c7740b11c460</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SbVec2d &amp;</type>
      <name>getMax</name>
      <anchorfile>classSbBox2d.html</anchorfile>
      <anchor>a136376a27439d712e88e3624a6e5b70c</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>extendBy</name>
      <anchorfile>classSbBox2d.html</anchorfile>
      <anchor>a579b3a3ce2297998dda39f036ad1caf3</anchor>
      <arglist>(const SbVec2d &amp;point)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>extendBy</name>
      <anchorfile>classSbBox2d.html</anchorfile>
      <anchor>aeab99592f3ed491da6ea1e23ea1b94e7</anchor>
      <arglist>(const SbBox2d &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>makeEmpty</name>
      <anchorfile>classSbBox2d.html</anchorfile>
      <anchor>a61a1cb11326fc2a0a4d16a0851fdbda5</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isEmpty</name>
      <anchorfile>classSbBox2d.html</anchorfile>
      <anchor>a2ed1a822e48a2ccd7d739a7c6ef0b69d</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>hasArea</name>
      <anchorfile>classSbBox2d.html</anchorfile>
      <anchor>a619ffbd12248becb50fd654e5ddb82d5</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbBox2d.html</anchorfile>
      <anchor>ab0b3eeacb8e310670640504a9ac8db72</anchor>
      <arglist>(const SbVec2d &amp;point) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbBox2d.html</anchorfile>
      <anchor>a9769d3bfaa165eb19a662f132370e156</anchor>
      <arglist>(const SbBox2d &amp;box) const </arglist>
    </member>
    <member kind="function">
      <type>SbVec2d</type>
      <name>getClosestPoint</name>
      <anchorfile>classSbBox2d.html</anchorfile>
      <anchor>ab1086ccdb9db97b52434e613651f370b</anchor>
      <arglist>(const SbVec2d &amp;p) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>findIntersection</name>
      <anchorfile>classSbBox2d.html</anchorfile>
      <anchor>af352d83227b49a421dd0929cfeb83429</anchor>
      <arglist>(const SbVec2d &amp;a, const SbVec2d &amp;b, SbVec2d &amp;ia, SbVec2d &amp;ib) const </arglist>
    </member>
    <member kind="function">
      <type>SbVec2d</type>
      <name>getCenter</name>
      <anchorfile>classSbBox2d.html</anchorfile>
      <anchor>a944514ea38673a674b67b4f05a56a966</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getOrigin</name>
      <anchorfile>classSbBox2d.html</anchorfile>
      <anchor>a424c0fd9dfdbbdd374f62615d09553b1</anchor>
      <arglist>(double &amp;originX, double &amp;originY) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getSize</name>
      <anchorfile>classSbBox2d.html</anchorfile>
      <anchor>a621c694a5e0dfa63376b9f7103532101</anchor>
      <arglist>(double &amp;sizeX, double &amp;sizeY) const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>getAspectRatio</name>
      <anchorfile>classSbBox2d.html</anchorfile>
      <anchor>a3ed9685d595181df1213f3953dd69ed5</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbBox2d.html</anchorfile>
      <anchor>ab6de355aab03179a741038c6856378bd</anchor>
      <arglist>(const SbBox2d &amp;b1, const SbBox2d &amp;b2)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbBox2d.html</anchorfile>
      <anchor>a420c973f766c0f9cb2e8c7ec1aa6e03d</anchor>
      <arglist>(const SbBox2d &amp;b1, const SbBox2d &amp;b2)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbBox2f</name>
    <filename>classSbBox2f.html</filename>
    <member kind="function">
      <type></type>
      <name>SbBox2f</name>
      <anchorfile>classSbBox2f.html</anchorfile>
      <anchor>af60e9222058dbdcd867cbb048c721b03</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbBox2f</name>
      <anchorfile>classSbBox2f.html</anchorfile>
      <anchor>a488cf3016af1093b2189a19cc9087fc6</anchor>
      <arglist>(float xmin, float ymin, float xmax, float ymax)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbBox2f</name>
      <anchorfile>classSbBox2f.html</anchorfile>
      <anchor>a9ec2e3cb95df5dbcf3f331aed736f1b7</anchor>
      <arglist>(const SbVec2f &amp;minpoint, const SbVec2f &amp;maxpoint)</arglist>
    </member>
    <member kind="function">
      <type>SbBox2f &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox2f.html</anchorfile>
      <anchor>a36c09cc65b4a63013bc31dea68a7b6e1</anchor>
      <arglist>(float xmin, float ymin, float xmax, float ymax)</arglist>
    </member>
    <member kind="function">
      <type>SbBox2f &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox2f.html</anchorfile>
      <anchor>af3a9b1d9fd5ff0af88a6a77f44e00878</anchor>
      <arglist>(const SbVec2f &amp;minpoint, const SbVec2f &amp;maxpoint)</arglist>
    </member>
    <member kind="function">
      <type>SbBox2f &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox2f.html</anchorfile>
      <anchor>af4abc503bb458358536c5b4e5454bd85</anchor>
      <arglist>(const SbBox2d &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>SbBox2f &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox2f.html</anchorfile>
      <anchor>a95232a587c8a3c42c4d0c128f7582a01</anchor>
      <arglist>(const SbBox2s &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>SbBox2f &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox2f.html</anchorfile>
      <anchor>ad97a22a8df3411c4bdbb267aaa41da78</anchor>
      <arglist>(const SbBox2i32 &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getBounds</name>
      <anchorfile>classSbBox2f.html</anchorfile>
      <anchor>a45e11f6106b3897c55777cca63a2e70d</anchor>
      <arglist>(float &amp;xmin, float &amp;ymin, float &amp;xmax, float &amp;ymax) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getBounds</name>
      <anchorfile>classSbBox2f.html</anchorfile>
      <anchor>a17d12a72cb94b999b5133e8e6e9a8ea1</anchor>
      <arglist>(SbVec2f &amp;minpoint, SbVec2f &amp;maxpoint) const </arglist>
    </member>
    <member kind="function">
      <type>const SbVec2f &amp;</type>
      <name>getMin</name>
      <anchorfile>classSbBox2f.html</anchorfile>
      <anchor>a4c3f5237eab11eb573ad5dd197dddf69</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SbVec2f &amp;</type>
      <name>getMin</name>
      <anchorfile>classSbBox2f.html</anchorfile>
      <anchor>a87381f189b356411c3bb009334f14eeb</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SbVec2f &amp;</type>
      <name>getMax</name>
      <anchorfile>classSbBox2f.html</anchorfile>
      <anchor>adef18ca6285056b08d44138c3d1ee37e</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>extendBy</name>
      <anchorfile>classSbBox2f.html</anchorfile>
      <anchor>ae2e64a1f974668066070f8b85256cc1e</anchor>
      <arglist>(const SbVec2f &amp;point)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>extendBy</name>
      <anchorfile>classSbBox2f.html</anchorfile>
      <anchor>a2d6c817d8fde53380e5bd1fa68b22f08</anchor>
      <arglist>(const SbBox2f &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>makeEmpty</name>
      <anchorfile>classSbBox2f.html</anchorfile>
      <anchor>a8a53357d402331b2433a190182c055dc</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isEmpty</name>
      <anchorfile>classSbBox2f.html</anchorfile>
      <anchor>a374158ced7a6565ba21f2cdaa2cb2366</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>hasArea</name>
      <anchorfile>classSbBox2f.html</anchorfile>
      <anchor>a6d2a7c6a1859f2d1ef32a05039340695</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbBox2f.html</anchorfile>
      <anchor>acfd1639fbf4df552c0058cbc7477646b</anchor>
      <arglist>(const SbVec2f &amp;point) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbBox2f.html</anchorfile>
      <anchor>a7401884a79096c9ed0955f0e0018eee7</anchor>
      <arglist>(const SbBox2f &amp;box) const </arglist>
    </member>
    <member kind="function">
      <type>SbVec2f</type>
      <name>getClosestPoint</name>
      <anchorfile>classSbBox2f.html</anchorfile>
      <anchor>a7817d0a9d943d0f68844d1c3aab1ed6e</anchor>
      <arglist>(const SbVec2f &amp;point) const </arglist>
    </member>
    <member kind="function">
      <type>SbVec2f</type>
      <name>getCenter</name>
      <anchorfile>classSbBox2f.html</anchorfile>
      <anchor>aba253f3e70bff6c93e175dfba6f54e6c</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getOrigin</name>
      <anchorfile>classSbBox2f.html</anchorfile>
      <anchor>a93d21c5df92d6b620ded73dd11e62be8</anchor>
      <arglist>(float &amp;originX, float &amp;originY) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getSize</name>
      <anchorfile>classSbBox2f.html</anchorfile>
      <anchor>afa20c0897b2bdb6d38176a209a404c57</anchor>
      <arglist>(float &amp;sizeX, float &amp;sizeY) const </arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getAspectRatio</name>
      <anchorfile>classSbBox2f.html</anchorfile>
      <anchor>a3bb2a9743b41994cf27ed9ebc23d6c54</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbBox2f.html</anchorfile>
      <anchor>a44f45d9426e170bec8f85b0fd82033d8</anchor>
      <arglist>(const SbBox2f &amp;b1, const SbBox2f &amp;b2)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbBox2f.html</anchorfile>
      <anchor>aca1673211be6ce175bc5ac0c795feaa3</anchor>
      <arglist>(const SbBox2f &amp;b1, const SbBox2f &amp;b2)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbBox2i32</name>
    <filename>classSbBox2i32.html</filename>
    <member kind="function">
      <type></type>
      <name>SbBox2i32</name>
      <anchorfile>classSbBox2i32.html</anchorfile>
      <anchor>a00a108df9578449c28a71e82df2e3425</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbBox2i32</name>
      <anchorfile>classSbBox2i32.html</anchorfile>
      <anchor>a3f3b707dd61816ec42977710045a80eb</anchor>
      <arglist>(int32_t xmin, int32_t ymin, int32_t xmax, int32_t ymax)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbBox2i32</name>
      <anchorfile>classSbBox2i32.html</anchorfile>
      <anchor>a3ccb05c485c28ffe37a0b006bdaa7b73</anchor>
      <arglist>(const SbVec2i32 &amp;minpoint, const SbVec2i32 &amp;maxpoint)</arglist>
    </member>
    <member kind="function">
      <type>SbBox2i32 &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox2i32.html</anchorfile>
      <anchor>a07b5e5d4d93577e76196c787b241af7a</anchor>
      <arglist>(int32_t xmin, int32_t ymin, int32_t xmax, int32_t ymax)</arglist>
    </member>
    <member kind="function">
      <type>SbBox2i32 &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox2i32.html</anchorfile>
      <anchor>af968faf7abaa4a340f9a51f1d5f41d36</anchor>
      <arglist>(const SbVec2i32 &amp;minpoint, const SbVec2i32 &amp;maxpoint)</arglist>
    </member>
    <member kind="function">
      <type>SbBox2i32 &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox2i32.html</anchorfile>
      <anchor>a50cf910454ea88f88a9183d0a8a88a70</anchor>
      <arglist>(const SbBox2s &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>SbBox2i32 &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox2i32.html</anchorfile>
      <anchor>ad6b3a830d99a9134c2c094dc2bf1eb96</anchor>
      <arglist>(const SbBox2f &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>SbBox2i32 &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox2i32.html</anchorfile>
      <anchor>abb51acdad3cd319cec4a5c1e81d5ed62</anchor>
      <arglist>(const SbBox2d &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getBounds</name>
      <anchorfile>classSbBox2i32.html</anchorfile>
      <anchor>ae94dbc7e63c352dc56cbc94e62f51433</anchor>
      <arglist>(int32_t &amp;xmin, int32_t &amp;ymin, int32_t &amp;xmax, int32_t &amp;ymax) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getBounds</name>
      <anchorfile>classSbBox2i32.html</anchorfile>
      <anchor>a0fedf55243c89c2eea73f1e865419526</anchor>
      <arglist>(SbVec2i32 &amp;minpoint, SbVec2i32 &amp;maxpoint) const </arglist>
    </member>
    <member kind="function">
      <type>const SbVec2i32 &amp;</type>
      <name>getMin</name>
      <anchorfile>classSbBox2i32.html</anchorfile>
      <anchor>a361a0932a370bf9c832452d11fe10859</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>const SbVec2i32 &amp;</type>
      <name>getMax</name>
      <anchorfile>classSbBox2i32.html</anchorfile>
      <anchor>a990604edbbc198d7c9d424da8c766f50</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>extendBy</name>
      <anchorfile>classSbBox2i32.html</anchorfile>
      <anchor>a8bafd6a3bee621e012315639c107d239</anchor>
      <arglist>(const SbVec2i32 &amp;point)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>extendBy</name>
      <anchorfile>classSbBox2i32.html</anchorfile>
      <anchor>a351aac1810159af0755a5f338ddc9628</anchor>
      <arglist>(const SbBox2i32 &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>makeEmpty</name>
      <anchorfile>classSbBox2i32.html</anchorfile>
      <anchor>acecabbd2c9355ec12504aab11b5a2819</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbBox2i32.html</anchorfile>
      <anchor>a97fd0d39afa98b0ee03d3fdbc13f69b3</anchor>
      <arglist>(const SbVec2i32 &amp;point) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbBox2i32.html</anchorfile>
      <anchor>ade2117edc5a383e297c28130342ffaf4</anchor>
      <arglist>(const SbBox2i32 &amp;box) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getOrigin</name>
      <anchorfile>classSbBox2i32.html</anchorfile>
      <anchor>a547cad66d589a58d199e6fbd815e973b</anchor>
      <arglist>(int32_t &amp;originX, int32_t &amp;originY) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getSize</name>
      <anchorfile>classSbBox2i32.html</anchorfile>
      <anchor>a8b526798ae0e7a74d3f8afe1bb09813c</anchor>
      <arglist>(int32_t &amp;sizeX, int32_t &amp;sizeY) const </arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getAspectRatio</name>
      <anchorfile>classSbBox2i32.html</anchorfile>
      <anchor>a5c310b514c13efb4d72ef52d1301e7de</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbBox2i32.html</anchorfile>
      <anchor>aab3f8be9fe431ab0554ee51e7ed15142</anchor>
      <arglist>(const SbBox2i32 &amp;b1, const SbBox2i32 &amp;b2)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbBox2i32.html</anchorfile>
      <anchor>ac8a1e71eb6cb04c5529b0fb0f1e151c6</anchor>
      <arglist>(const SbBox2i32 &amp;b1, const SbBox2i32 &amp;b2)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbBox2s</name>
    <filename>classSbBox2s.html</filename>
    <member kind="function">
      <type></type>
      <name>SbBox2s</name>
      <anchorfile>classSbBox2s.html</anchorfile>
      <anchor>a9c89d2e09b48756623200f573d3d8c32</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbBox2s</name>
      <anchorfile>classSbBox2s.html</anchorfile>
      <anchor>adc4b8796c9228ef325f6c7e63ecb3442</anchor>
      <arglist>(short xmin, short ymin, short xmax, short ymax)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbBox2s</name>
      <anchorfile>classSbBox2s.html</anchorfile>
      <anchor>aae69b105fdcb01d3a4e9482de5f55271</anchor>
      <arglist>(const SbVec2s &amp;minpoint, const SbVec2s &amp;maxpoint)</arglist>
    </member>
    <member kind="function">
      <type>SbBox2s &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox2s.html</anchorfile>
      <anchor>a45e3b9b59d7e4d62e4a38d54743aff2b</anchor>
      <arglist>(short xmin, short ymin, short xmax, short ymax)</arglist>
    </member>
    <member kind="function">
      <type>SbBox2s &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox2s.html</anchorfile>
      <anchor>ae63d6210915c86cd2cb87b5e303ed3ab</anchor>
      <arglist>(const SbVec2s &amp;minpoint, const SbVec2s &amp;maxpoint)</arglist>
    </member>
    <member kind="function">
      <type>SbBox2s &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox2s.html</anchorfile>
      <anchor>a2127e685bab4548cac5ba22ec7605e42</anchor>
      <arglist>(const SbBox2i32 &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>SbBox2s &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox2s.html</anchorfile>
      <anchor>a93f392204a9df6e72745f203b8ad09f1</anchor>
      <arglist>(const SbBox2f &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>SbBox2s &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox2s.html</anchorfile>
      <anchor>a22d4c407102514013fcb8e506a9b5b85</anchor>
      <arglist>(const SbBox2d &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getBounds</name>
      <anchorfile>classSbBox2s.html</anchorfile>
      <anchor>a4d926e9b29187c9d478c4393d061b648</anchor>
      <arglist>(short &amp;xmin, short &amp;ymin, short &amp;xmax, short &amp;ymax) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getBounds</name>
      <anchorfile>classSbBox2s.html</anchorfile>
      <anchor>a3b87582c6906c5e9487214838be7018c</anchor>
      <arglist>(SbVec2s &amp;minpoint, SbVec2s &amp;maxpoint) const </arglist>
    </member>
    <member kind="function">
      <type>const SbVec2s &amp;</type>
      <name>getMin</name>
      <anchorfile>classSbBox2s.html</anchorfile>
      <anchor>a91a1e049c92a5b2fdd13d019a627e0cf</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>const SbVec2s &amp;</type>
      <name>getMax</name>
      <anchorfile>classSbBox2s.html</anchorfile>
      <anchor>a2968325960913e67bee599cc10687882</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>extendBy</name>
      <anchorfile>classSbBox2s.html</anchorfile>
      <anchor>a1dca266f470c5a66671ee6cab151ad3f</anchor>
      <arglist>(const SbVec2s &amp;point)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>extendBy</name>
      <anchorfile>classSbBox2s.html</anchorfile>
      <anchor>af04182b3564b7e62eeda4ab6d5f36de6</anchor>
      <arglist>(const SbBox2s &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>makeEmpty</name>
      <anchorfile>classSbBox2s.html</anchorfile>
      <anchor>aa22e56acd95b2ffdc76ddf77ee0c6bcb</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbBox2s.html</anchorfile>
      <anchor>a4b9b4b852219efec3734aa94ce4c6c70</anchor>
      <arglist>(const SbVec2s &amp;point) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbBox2s.html</anchorfile>
      <anchor>a56ba599429cb7882e499f97508c02dd2</anchor>
      <arglist>(const SbBox2s &amp;box) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getOrigin</name>
      <anchorfile>classSbBox2s.html</anchorfile>
      <anchor>a0adb3836750e29ea6dc135fcc4c49a05</anchor>
      <arglist>(short &amp;originX, short &amp;originY) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getSize</name>
      <anchorfile>classSbBox2s.html</anchorfile>
      <anchor>a1acda6274210fc28351d8fb99d666cce</anchor>
      <arglist>(short &amp;sizeX, short &amp;sizeY) const </arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getAspectRatio</name>
      <anchorfile>classSbBox2s.html</anchorfile>
      <anchor>a241be4815b5fcc2a2b0ff00f4788edf6</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbBox2s.html</anchorfile>
      <anchor>a1042a3532734ad78f25483c2f1305458</anchor>
      <arglist>(const SbBox2s &amp;b1, const SbBox2s &amp;b2)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbBox2s.html</anchorfile>
      <anchor>a56b6a6b0eb776ef2ad99e78bc27993d7</anchor>
      <arglist>(const SbBox2s &amp;b1, const SbBox2s &amp;b2)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbBox3d</name>
    <filename>classSbBox3d.html</filename>
    <member kind="function">
      <type></type>
      <name>SbBox3d</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>a45ea275b28082f1ee978041b7a0ca6a8</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbBox3d</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>ab70192aeedddd65122a5fc352c4dfe1c</anchor>
      <arglist>(double xmin, double ymin, double zmin, double xmax, double ymax, double zmax)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbBox3d</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>ab90fc4d7004dfdfe6c9d09c359df61a2</anchor>
      <arglist>(const SbVec3d &amp;minpoint, const SbVec3d &amp;maxpoint)</arglist>
    </member>
    <member kind="function">
      <type>SbBox3d &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>a43a4b2b558e8a21d33648b1bda85f789</anchor>
      <arglist>(double xmin, double ymin, double zmin, double xmax, double ymax, double zmax)</arglist>
    </member>
    <member kind="function">
      <type>SbBox3d &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>a650b55c2c282cdcfc4ab2115b6ecaa0e</anchor>
      <arglist>(const SbVec3d &amp;minpoint, const SbVec3d &amp;maxpoint)</arglist>
    </member>
    <member kind="function">
      <type>SbBox3d &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>aa88a95e250520e098a655bf263a20d13</anchor>
      <arglist>(const SbBox3f &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>SbBox3d &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>a9bceea65b321021e97decbf346002b73</anchor>
      <arglist>(const SbBox3s &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>SbBox3d &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>a637c1cace5e460cf431bf930e809603e</anchor>
      <arglist>(const SbBox3i32 &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getBounds</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>ac8e19a7801269ebd51478d4200cf603c</anchor>
      <arglist>(double &amp;xmin, double &amp;ymin, double &amp;zmin, double &amp;xmax, double &amp;ymax, double &amp;zmax) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getBounds</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>a937f9b9cff639ad270f6fdaa3c42a3b3</anchor>
      <arglist>(SbVec3d &amp;minpoint, SbVec3d &amp;maxpoint) const </arglist>
    </member>
    <member kind="function">
      <type>const SbVec3d &amp;</type>
      <name>getMin</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>a7299b3288cfe389fb83008f45006a389</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SbVec3d &amp;</type>
      <name>getMin</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>a54dd241796af5a3b58300856e1e3f4b9</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SbVec3d &amp;</type>
      <name>getMax</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>aa217bf5822e7370f8cca17196409132d</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SbVec3d &amp;</type>
      <name>getMax</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>a9efbd7394f969d498fd82720803a05a5</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>extendBy</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>ac893a7e396c4e3e52c3167419bab3a1b</anchor>
      <arglist>(const SbVec3d &amp;pt)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>extendBy</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>a573d9e294173cee3cbe859bcd3d6246f</anchor>
      <arglist>(const SbBox3d &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>transform</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>a962b54989a51435308b1ea93e523b319</anchor>
      <arglist>(const SbDPMatrix &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>makeEmpty</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>a026528f81ff09aa8120c03b42d88ebc3</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isEmpty</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>a54aacc32b9847c9d29478ee942a4eca5</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>hasVolume</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>a4a74318453685999701759d29ad96e9c</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>getVolume</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>a71c8c10233f233794ca68364f11b0514</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>ae729692ebea9df8918a35a3eaeef5c3f</anchor>
      <arglist>(const SbVec3d &amp;point) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>a03fb2447e6bf398f279f5cde48b5ff88</anchor>
      <arglist>(const SbBox3d &amp;box) const </arglist>
    </member>
    <member kind="function">
      <type>SbVec3d</type>
      <name>getClosestPoint</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>adf9dd8bd1e7da863e0cad8e8cbf30d22</anchor>
      <arglist>(const SbVec3d &amp;point) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>outside</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>aba043028044bdd311ac6c0c3f4ab6f90</anchor>
      <arglist>(const SbDPMatrix &amp;mvp, int &amp;cullbits) const </arglist>
    </member>
    <member kind="function">
      <type>SbVec3d</type>
      <name>getCenter</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>a425d984108e4c1fd7bae6da90c290104</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getOrigin</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>a9ce815e8fbfa02396b64d3224f9c0c35</anchor>
      <arglist>(double &amp;origoX, double &amp;origoY, double &amp;origoZ) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getSize</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>a166f5825a2195a863fb21308137e29f0</anchor>
      <arglist>(double &amp;sizeX, double &amp;sizeY, double &amp;sizeZ) const </arglist>
    </member>
    <member kind="function">
      <type>SbVec3d</type>
      <name>getSize</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>a8ff67f0490a0cd66afad1462aa49baf6</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getSpan</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>aa07cd614e6fa03736082c6a0c884fead</anchor>
      <arglist>(const SbVec3d &amp;dir, double &amp;dmin, double &amp;dmax) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>a721b6f1ee22969f38a9c8516f7c500c2</anchor>
      <arglist>(FILE *file) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>ab4a51a09147360c5bc153f0db3a7ee92</anchor>
      <arglist>(const SbBox3d &amp;b1, const SbBox3d &amp;b2)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbBox3d.html</anchorfile>
      <anchor>ac649125547a086c55bbf67ee25a9222c</anchor>
      <arglist>(const SbBox3d &amp;b1, const SbBox3d &amp;b2)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbBox3f</name>
    <filename>classSbBox3f.html</filename>
    <member kind="function">
      <type></type>
      <name>SbBox3f</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>acda68a85f93e1c8756d2f1804e1fab4e</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbBox3f</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>ae9b4d556bd2445c2245ad28b28e21d00</anchor>
      <arglist>(float xmin, float ymin, float zmin, float xmax, float ymax, float zmax)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbBox3f</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>ad190f9a9eae99d4d498443d1cf7a81db</anchor>
      <arglist>(const SbVec3f &amp;minpoint, const SbVec3f &amp;maxpoint)</arglist>
    </member>
    <member kind="function">
      <type>SbBox3f &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>a2d834ff650b6b13dfd031391548b7a54</anchor>
      <arglist>(float xmin, float ymin, float zmin, float xmax, float ymax, float zmax)</arglist>
    </member>
    <member kind="function">
      <type>SbBox3f &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>a401fe84bbd869ebcf4e0239cdb341085</anchor>
      <arglist>(const SbVec3f &amp;minpoint, const SbVec3f &amp;maxpoint)</arglist>
    </member>
    <member kind="function">
      <type>SbBox3f &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>aaeb8955f8a8e15f2929f9b14d59aabee</anchor>
      <arglist>(const SbBox3d &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>SbBox3f &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>a72d624cf6e21ea8140db50f20b70776d</anchor>
      <arglist>(const SbBox3s &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>SbBox3f &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>a2a2f27fd6b76e6557a2b9de0d209e178</anchor>
      <arglist>(const SbBox3i32 &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getBounds</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>a530b02ef338d45ffd874a665ce8ade45</anchor>
      <arglist>(float &amp;xmin, float &amp;ymin, float &amp;zmin, float &amp;xmax, float &amp;ymax, float &amp;zmax) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getBounds</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>a49017e945b2fb6051791b29f9f6f63ad</anchor>
      <arglist>(SbVec3f &amp;minpoint, SbVec3f &amp;maxpoint) const </arglist>
    </member>
    <member kind="function">
      <type>const SbVec3f &amp;</type>
      <name>getMin</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>ac8dc8307c75142946783dd2b457859b2</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SbVec3f &amp;</type>
      <name>getMin</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>a19ba3e3cd73083cfe9a099813616c4cc</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SbVec3f &amp;</type>
      <name>getMax</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>ac69fd7a029fdef8683639ebd95c94e2d</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SbVec3f &amp;</type>
      <name>getMax</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>a6957d8a5bd2296ff6174885b79ad7acf</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>extendBy</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>af34b9c76920737d7791f88c090a22634</anchor>
      <arglist>(const SbVec3f &amp;pt)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>extendBy</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>ae81199b5fe1786b8f621d794a153c20a</anchor>
      <arglist>(const SbBox3f &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>transform</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>aef13d65bf2de3ce2f3bc963b6d1bda7e</anchor>
      <arglist>(const SbMatrix &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>makeEmpty</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>a5ef7fe06e8ceb456f75fc2762a9b50aa</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isEmpty</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>a1a6b29cab6d14c8a4175ed23940ae638</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>hasVolume</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>afe4b5cdcd2b3a92177545fb69f9b5a93</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getVolume</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>a4b2c392aabd479a6b4b2063ad09ca344</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>a832e6cbf2690063618f24d1985d52a74</anchor>
      <arglist>(const SbVec3f &amp;pt) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>a10a1a38f8b2a7a35d93b45e9b398c274</anchor>
      <arglist>(const SbBox3f &amp;box) const </arglist>
    </member>
    <member kind="function">
      <type>SbVec3f</type>
      <name>getClosestPoint</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>a2bcd8de27983faebb08bb61d328a7307</anchor>
      <arglist>(const SbVec3f &amp;point) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>outside</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>ab93b10d14f5eb5b8f5ea4d67bf5de334</anchor>
      <arglist>(const SbMatrix &amp;mvp, int &amp;cullbits) const </arglist>
    </member>
    <member kind="function">
      <type>SbVec3f</type>
      <name>getCenter</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>a2423226714e3d49db4b6b8ee1e6e5cc6</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getOrigin</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>a918dc86a611c03c1e915dfbc5616c10d</anchor>
      <arglist>(float &amp;originX, float &amp;originY, float &amp;originZ) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getSize</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>aa62d6629c6d76046b00ebab4fe64d10a</anchor>
      <arglist>(float &amp;sizeX, float &amp;sizeY, float &amp;sizeZ) const </arglist>
    </member>
    <member kind="function">
      <type>SbVec3f</type>
      <name>getSize</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>af0e66bd7cb388dc70ca76adc378bbae4</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getSpan</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>a70176c1cbf01656d4b5951f0270ee83e</anchor>
      <arglist>(const SbVec3f &amp;dir, float &amp;dmin, float &amp;dmax) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>ac7921bece2465caaae2b2c407bfc0655</anchor>
      <arglist>(FILE *file) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>ab8d0c8d5fad634d9067c36c06c5427fc</anchor>
      <arglist>(const SbBox3f &amp;b1, const SbBox3f &amp;b2)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbBox3f.html</anchorfile>
      <anchor>a445f1b0feaacc059e3d63e03641f5ee0</anchor>
      <arglist>(const SbBox3f &amp;b1, const SbBox3f &amp;b2)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbBox3s</name>
    <filename>classSbBox3s.html</filename>
    <member kind="function">
      <type></type>
      <name>SbBox3s</name>
      <anchorfile>classSbBox3s.html</anchorfile>
      <anchor>af34ced593533a18d9744eda71fe932f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbBox3s</name>
      <anchorfile>classSbBox3s.html</anchorfile>
      <anchor>ae563f1b8d0fe6397dbe2db8d2f6634f3</anchor>
      <arglist>(short xmin, short ymin, short zmin, short xmax, short ymax, short zmax)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbBox3s</name>
      <anchorfile>classSbBox3s.html</anchorfile>
      <anchor>a060ac9e7fa6d50e26a70dfe67503ba8c</anchor>
      <arglist>(const SbVec3s &amp;minpoint, const SbVec3s &amp;maxpoint)</arglist>
    </member>
    <member kind="function">
      <type>SbBox3s &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox3s.html</anchorfile>
      <anchor>a2c477237d4a0e162a8118092a58c51ee</anchor>
      <arglist>(short xmin, short ymin, short zmin, short xmax, short ymax, short zmax)</arglist>
    </member>
    <member kind="function">
      <type>SbBox3s &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox3s.html</anchorfile>
      <anchor>a3c9080831e46e5719873beddab6e9f82</anchor>
      <arglist>(const SbVec3s &amp;minpoint, const SbVec3s &amp;maxpoint)</arglist>
    </member>
    <member kind="function">
      <type>SbBox3s &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox3s.html</anchorfile>
      <anchor>ae8d2fa61d7f88aba9ca027008eb2d5ee</anchor>
      <arglist>(const SbBox3i32 &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>SbBox3s &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox3s.html</anchorfile>
      <anchor>a56964bf82750b50608ebf6d049b092a1</anchor>
      <arglist>(const SbBox3f &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>SbBox3s &amp;</type>
      <name>setBounds</name>
      <anchorfile>classSbBox3s.html</anchorfile>
      <anchor>ac4648044180760e079b576d7bc281fb0</anchor>
      <arglist>(const SbBox3d &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getBounds</name>
      <anchorfile>classSbBox3s.html</anchorfile>
      <anchor>a2a3f6ad05fbb0c58a45b55fbc3db2c99</anchor>
      <arglist>(short &amp;xmin, short &amp;ymin, short &amp;zmin, short &amp;xmax, short &amp;ymax, short &amp;zmax) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getBounds</name>
      <anchorfile>classSbBox3s.html</anchorfile>
      <anchor>afa7695ba77e64b44302e0e7696920fa5</anchor>
      <arglist>(SbVec3s &amp;minpoint, SbVec3s &amp;maxpoint) const </arglist>
    </member>
    <member kind="function">
      <type>const SbVec3s &amp;</type>
      <name>getMin</name>
      <anchorfile>classSbBox3s.html</anchorfile>
      <anchor>a24160f4b13f39cc43730bb308140e2fc</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>const SbVec3s &amp;</type>
      <name>getMax</name>
      <anchorfile>classSbBox3s.html</anchorfile>
      <anchor>ad2196a1c83df1a9c47c25b57ff941208</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>extendBy</name>
      <anchorfile>classSbBox3s.html</anchorfile>
      <anchor>a68ef880438212a29e6a7254a55a5fe10</anchor>
      <arglist>(const SbVec3s &amp;pt)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>extendBy</name>
      <anchorfile>classSbBox3s.html</anchorfile>
      <anchor>acc8678e70b1802613f1ba2a4cdbc6b66</anchor>
      <arglist>(const SbBox3s &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>makeEmpty</name>
      <anchorfile>classSbBox3s.html</anchorfile>
      <anchor>a57664b65dd1ff57ee18c14a1c44f23ca</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbBox3s.html</anchorfile>
      <anchor>a64ca69ea3e97c842b0f2fe7dcf193b0d</anchor>
      <arglist>(const SbVec3s &amp;pt) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbBox3s.html</anchorfile>
      <anchor>add9507c9acba4a435df851596a1220df</anchor>
      <arglist>(const SbBox3s &amp;box) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getOrigin</name>
      <anchorfile>classSbBox3s.html</anchorfile>
      <anchor>a4458952c2aa8674841f06766141e3809</anchor>
      <arglist>(short &amp;originX, short &amp;originY, short &amp;originZ) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getSize</name>
      <anchorfile>classSbBox3s.html</anchorfile>
      <anchor>a2b5baad7cbe8f688c69c543a8167f79b</anchor>
      <arglist>(short &amp;sizeX, short &amp;sizeY, short &amp;sizeZ) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbBox3s.html</anchorfile>
      <anchor>a8947d1fa6e0badfc158e309139b23d90</anchor>
      <arglist>(const SbBox3s &amp;b1, const SbBox3s &amp;b2)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbBox3s.html</anchorfile>
      <anchor>a9a916e95490b2e6483d1b5d29502df96</anchor>
      <arglist>(const SbBox3s &amp;b1, const SbBox3s &amp;b2)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbBSPTree</name>
    <filename>classSbBSPTree.html</filename>
    <member kind="function">
      <type></type>
      <name>SbBSPTree</name>
      <anchorfile>classSbBSPTree.html</anchorfile>
      <anchor>a81cd11e722bd4d8782c9b2617e0e3907</anchor>
      <arglist>(const int maxnodepts=64, const int initsize=4)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbBSPTree</name>
      <anchorfile>classSbBSPTree.html</anchorfile>
      <anchor>a20b5c9fe452abb73582520f2503f302e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>numPoints</name>
      <anchorfile>classSbBSPTree.html</anchorfile>
      <anchor>acabe1a2ce55abf7bd81d7189370b940d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>SbVec3f</type>
      <name>getPoint</name>
      <anchorfile>classSbBSPTree.html</anchorfile>
      <anchor>ae7b02a0ced518b5cf5ba4ea9e248325b</anchor>
      <arglist>(const int idx) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getPoint</name>
      <anchorfile>classSbBSPTree.html</anchorfile>
      <anchor>a9ec6294a48cdd6f578387d03d86886b1</anchor>
      <arglist>(const int idx, SbVec3f &amp;pt) const </arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>getUserData</name>
      <anchorfile>classSbBSPTree.html</anchorfile>
      <anchor>a76173717bb73ad3985689e213e426d4d</anchor>
      <arglist>(const int idx) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setUserData</name>
      <anchorfile>classSbBSPTree.html</anchorfile>
      <anchor>a3e0dc00d4b8a12821f8cf6995fd9620e</anchor>
      <arglist>(const int idx, void *const data)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>addPoint</name>
      <anchorfile>classSbBSPTree.html</anchorfile>
      <anchor>a94c0936113aecbd1089f5692965cdde6</anchor>
      <arglist>(const SbVec3f &amp;pt, void *const userdata=NULL)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>removePoint</name>
      <anchorfile>classSbBSPTree.html</anchorfile>
      <anchor>abe40262d6438a4228b4acc9ff944b9b3</anchor>
      <arglist>(const SbVec3f &amp;pt)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removePoint</name>
      <anchorfile>classSbBSPTree.html</anchorfile>
      <anchor>a7c352323ca873a56b2dafc4e1022ec07</anchor>
      <arglist>(const int idx)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>findPoint</name>
      <anchorfile>classSbBSPTree.html</anchorfile>
      <anchor>a2c5b590a42feeaa07404e33187cbd6c5</anchor>
      <arglist>(const SbVec3f &amp;pos) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>findClosest</name>
      <anchorfile>classSbBSPTree.html</anchorfile>
      <anchor>a976e48d9573af9c661dbc7c07ff705eb</anchor>
      <arglist>(const SbVec3f &amp;pos) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear</name>
      <anchorfile>classSbBSPTree.html</anchorfile>
      <anchor>ae2d8a472cce88969ad72455554f25842</anchor>
      <arglist>(const int initsize=4)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>findPoints</name>
      <anchorfile>classSbBSPTree.html</anchorfile>
      <anchor>a5a42133555ca189a93348b7b15c9c721</anchor>
      <arglist>(const SbSphere &amp;sphere, SbIntList &amp;array) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>findClosest</name>
      <anchorfile>classSbBSPTree.html</anchorfile>
      <anchor>a30241b721d474f107510837c6fe8ff3f</anchor>
      <arglist>(const SbSphere &amp;sphere, SbIntList &amp;array) const </arglist>
    </member>
    <member kind="function">
      <type>const SbBox3f &amp;</type>
      <name>getBBox</name>
      <anchorfile>classSbBSPTree.html</anchorfile>
      <anchor>ad12878eb4e012cb869560e168ad488d9</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const SbVec3f *</type>
      <name>getPointsArrayPtr</name>
      <anchorfile>classSbBSPTree.html</anchorfile>
      <anchor>a44f0f2af2000a791d814cc1618e135d2</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>findPoints</name>
      <anchorfile>classSbBSPTree.html</anchorfile>
      <anchor>a7a2860d3095b13a0caff048ecba1a6ce</anchor>
      <arglist>(const SbSphere &amp;sphere, SbList&lt; int &gt; &amp;array) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>findClosest</name>
      <anchorfile>classSbBSPTree.html</anchorfile>
      <anchor>a61bcf839b193be178f471fa7e1e5cf33</anchor>
      <arglist>(const SbSphere &amp;sphere, SbList&lt; int &gt; &amp;array) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbClip</name>
    <filename>classSbClip.html</filename>
    <member kind="function">
      <type></type>
      <name>SbClip</name>
      <anchorfile>classSbClip.html</anchorfile>
      <anchor>ad84357d002b55482d098de8d44ff7d3e</anchor>
      <arglist>(SbClipCallback *callback=NULL, void *userdata=NULL)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addVertex</name>
      <anchorfile>classSbClip.html</anchorfile>
      <anchor>a341c5e4129ebef7f8447d408350ae98a</anchor>
      <arglist>(const SbVec3f &amp;v, void *vdata=NULL)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reset</name>
      <anchorfile>classSbClip.html</anchorfile>
      <anchor>a0f4196a57e40383c33d04e9e19d2d5fc</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clip</name>
      <anchorfile>classSbClip.html</anchorfile>
      <anchor>adb59533f96dbca4e433fa8194e69677a</anchor>
      <arglist>(const SbPlane &amp;plane)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getNumVertices</name>
      <anchorfile>classSbClip.html</anchorfile>
      <anchor>ac370e148fa6838c46f83409bec65840f</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getVertex</name>
      <anchorfile>classSbClip.html</anchorfile>
      <anchor>ac9c8f0b50c8db80ced3063eabb6be9f4</anchor>
      <arglist>(const int idx, SbVec3f &amp;v, void **vdata=NULL) const </arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>getVertexData</name>
      <anchorfile>classSbClip.html</anchorfile>
      <anchor>a3107cb450b83fe492b7dbf4b4c78db88</anchor>
      <arglist>(const int idx) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbColor</name>
    <filename>classSbColor.html</filename>
    <base>SbVec3f</base>
    <member kind="function">
      <type></type>
      <name>SbColor</name>
      <anchorfile>classSbColor.html</anchorfile>
      <anchor>a57b97220a4686bf7f16c9a7daa81e995</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbColor</name>
      <anchorfile>classSbColor.html</anchorfile>
      <anchor>ad505d11c8d16b471e41d35a0f19bad6f</anchor>
      <arglist>(const SbVec3f &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbColor</name>
      <anchorfile>classSbColor.html</anchorfile>
      <anchor>a8c13fdb8bb612dc9050af5fee374cc2d</anchor>
      <arglist>(const float *const rgb)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbColor</name>
      <anchorfile>classSbColor.html</anchorfile>
      <anchor>af4c539e5b646684bd3687a529d66ad8a</anchor>
      <arglist>(const float r, const float g, const float b)</arglist>
    </member>
    <member kind="function">
      <type>SbColor &amp;</type>
      <name>setHSVValue</name>
      <anchorfile>classSbColor.html</anchorfile>
      <anchor>ab0e0b257d9e44ccfeb0361e060dfc7ee</anchor>
      <arglist>(float h, float s, float v)</arglist>
    </member>
    <member kind="function">
      <type>SbColor &amp;</type>
      <name>setHSVValue</name>
      <anchorfile>classSbColor.html</anchorfile>
      <anchor>a06585db40ed0e0e3ad8ad9f0426acf49</anchor>
      <arglist>(const float hsv[3])</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getHSVValue</name>
      <anchorfile>classSbColor.html</anchorfile>
      <anchor>ae6ff17e35f2e3054d34806cb8189b0f7</anchor>
      <arglist>(float &amp;h, float &amp;s, float &amp;v) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getHSVValue</name>
      <anchorfile>classSbColor.html</anchorfile>
      <anchor>a94c675166c62eb52768bac743d5ee372</anchor>
      <arglist>(float hsv[3]) const </arglist>
    </member>
    <member kind="function">
      <type>SbColor &amp;</type>
      <name>setPackedValue</name>
      <anchorfile>classSbColor.html</anchorfile>
      <anchor>aea92d5997a1ac924c9bf68c9c9c23ecb</anchor>
      <arglist>(const uint32_t rgba, float &amp;transparency)</arglist>
    </member>
    <member kind="function">
      <type>uint32_t</type>
      <name>getPackedValue</name>
      <anchorfile>classSbColor.html</anchorfile>
      <anchor>a690a376d590c60393d1a9e31bcc3a3bb</anchor>
      <arglist>(const float transparency=0.0f) const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec3f</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>aa76258aca6004c0bc187eb1bb6ad8920</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec3f</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>a5d493a03bcc39dd578d10fb16a9880b0</anchor>
      <arglist>(const float v[3])</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec3f</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>ab1b1809e180447f9543c568fe1797afe</anchor>
      <arglist>(float x, float y, float z)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec3f</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>a361be6b8e470fcd78a751d9e903c77d1</anchor>
      <arglist>(const SbVec3d &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec3f</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>a407499b4811c6d58fd869b9b7ac968ba</anchor>
      <arglist>(const SbVec3b &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec3f</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>a7bd67c1129f1b91537b630b75882773e</anchor>
      <arglist>(const SbVec3s &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec3f</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>ae46cd083167fe597aec88d0756b99133</anchor>
      <arglist>(const SbVec3i32 &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec3f</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>aa3f9d152a6c12807db97f06f8a6a882d</anchor>
      <arglist>(const SbPlane &amp;p0, const SbPlane &amp;p1, const SbPlane &amp;p2)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>a441b6c1a81cb3a144aea083d273e0fba</anchor>
      <arglist>(const float v[3])</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>acbd4bc205e738596a07798c3fa066f7f</anchor>
      <arglist>(float x, float y, float z)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>a398f573712c5fe396171acbcc350c1b7</anchor>
      <arglist>(const SbVec3f &amp;barycentric, const SbVec3f &amp;v0, const SbVec3f &amp;v1, const SbVec3f &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>a01a8dba4f91c56a4f7fd8a1c2fe0b74f</anchor>
      <arglist>(const SbVec3d &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>ae861ee2e14544a07526edac9f8ab56b8</anchor>
      <arglist>(const SbVec3b &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>a9c0650859153a39b3d0214ccb804d66f</anchor>
      <arglist>(const SbVec3s &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>a8197f09226440885ae0ca0cb19f48ad9</anchor>
      <arglist>(const SbVec3i32 &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>const float *</type>
      <name>getValue</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>a7706fc4599b5d6ecca4783bfc7345a5b</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getValue</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>a6c1b1415cdae844f2a2a02a489b5e25a</anchor>
      <arglist>(float &amp;x, float &amp;y, float &amp;z) const </arglist>
    </member>
    <member kind="function">
      <type>float &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>afaa7c9c8e280f703bd46b4701817f6ae</anchor>
      <arglist>(int i)</arglist>
    </member>
    <member kind="function">
      <type>const float &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>a5a25adcfa62c8e771d4a47311766dcd0</anchor>
      <arglist>(int i) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>equals</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>ad44ff53aee4ad077228cf614ac4d4e38</anchor>
      <arglist>(const SbVec3f &amp;v, float tolerance) const </arglist>
    </member>
    <member kind="function">
      <type>SbVec3f</type>
      <name>cross</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>a1d8d558618c7e5dca35b19b817ab3ca6</anchor>
      <arglist>(const SbVec3f &amp;v) const </arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>dot</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>aceb5ad1cb652c99b0fa5e9769fd7ab81</anchor>
      <arglist>(const SbVec3f &amp;v) const </arglist>
    </member>
    <member kind="function">
      <type>SbVec3f</type>
      <name>getClosestAxis</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>aeaaaaf4dd7cf6c0e9acc16973cf5d8d1</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>length</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>a450de33397f52427bf9870f6ecf3c91e</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>sqrLength</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>ac7c60a3962e92614377f803612a4c364</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>normalize</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>ac0d97d3db797a7a849d4f28c3a2436f2</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>negate</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>a93022b11a182eba2bb4bd334ee243d43</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f &amp;</type>
      <name>operator*=</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>aff19f4a93eef8f249c007ee879d0b5c6</anchor>
      <arglist>(float d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f &amp;</type>
      <name>operator/=</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>a1f312a6caf3ecd58fc4adfaa9cc76708</anchor>
      <arglist>(float d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f &amp;</type>
      <name>operator+=</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>a047dd8714e8aa6c0877742e8984465be</anchor>
      <arglist>(const SbVec3f &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f &amp;</type>
      <name>operator-=</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>aa42684f487f3b3d449e077e1bfe06391</anchor>
      <arglist>(const SbVec3f &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f</type>
      <name>operator-</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>a505ad1e2c216bcb0a49c383431777419</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SbString</type>
      <name>toString</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>ad18661fd400bc3514295c51b7174336c</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>fromString</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>ac905cbd501030b50597f35d4092a0a02</anchor>
      <arglist>(const SbString &amp;str)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>a7170fa390bee7c8be559c23ec99518a4</anchor>
      <arglist>(FILE *fp) const </arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float</type>
      <name>vec</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>a47474608ef4d1d3724b2bfad52a60dd2</anchor>
      <arglist>[3]</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f</type>
      <name>operator*</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>aa03aed703688d6b2760baa8f16ac2792</anchor>
      <arglist>(const SbVec3f &amp;v, float d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f</type>
      <name>operator*</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>ac6a0bb153d74282d1d13070d850bb4e9</anchor>
      <arglist>(float d, const SbVec3f &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f</type>
      <name>operator/</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>ab7e6292b2c255bdbd92e36f93cba6120</anchor>
      <arglist>(const SbVec3f &amp;v, float d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f</type>
      <name>operator+</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>a4a0d56698007ef9dced0e01822984034</anchor>
      <arglist>(const SbVec3f &amp;v1, const SbVec3f &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f</type>
      <name>operator-</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>a6c05f978707fca7bcd7df43d9ee12f33</anchor>
      <arglist>(const SbVec3f &amp;v1, const SbVec3f &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>a75471273e406ad2f2df577bb83e02986</anchor>
      <arglist>(const SbVec3f &amp;v1, const SbVec3f &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbVec3f.html</anchorfile>
      <anchor>a64345dd21abc88550089caa1860ecc45</anchor>
      <arglist>(const SbVec3f &amp;v1, const SbVec3f &amp;v2)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbColor4f</name>
    <filename>classSbColor4f.html</filename>
    <base>SbVec4f</base>
    <member kind="function">
      <type></type>
      <name>SbColor4f</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>abf2300514eb7df2d08870e181f2fc4d4</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbColor4f</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>a53e7fc28bfa7153848582f9bff90fdf4</anchor>
      <arglist>(const SbColor &amp;rgb, const float alpha=1.0f)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbColor4f</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>aee7803324174c72f1c50185c97007aa5</anchor>
      <arglist>(const SbVec4f &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbColor4f</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>ae76a933cb041ea3717fe2a565de13b2b</anchor>
      <arglist>(const float *const rgba)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbColor4f</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>ad1a3fec4de9db97cd1ebd48e81810f27</anchor>
      <arglist>(const float r, const float g, const float b, const float a=1.0f)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValue</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>a4b4894afb2bb85d3398b1ee18e3087d4</anchor>
      <arglist>(const float r, const float g, const float b, const float a=1.0f)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValue</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>a800bec94d1e9de045f9c274ad256d913</anchor>
      <arglist>(const float col[4])</arglist>
    </member>
    <member kind="function">
      <type>const float *</type>
      <name>getValue</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>a715af0da049d60bfd307c62d899b828d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getValue</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>a6a8d80bc0b6c99f22de3ec3c709c0dfb</anchor>
      <arglist>(float &amp;r, float &amp;g, float &amp;b, float &amp;a)</arglist>
    </member>
    <member kind="function">
      <type>SbColor4f &amp;</type>
      <name>setRGB</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>a734808c688beb9359623a13dc0d5f010</anchor>
      <arglist>(const SbColor &amp;col)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getRGB</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>a973c01d8c620d3003e6bdd538d0b3360</anchor>
      <arglist>(SbColor &amp;color)</arglist>
    </member>
    <member kind="function">
      <type>SbColor4f &amp;</type>
      <name>setHSVValue</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>a18d2536de1a547cb257aadc6e50dd88f</anchor>
      <arglist>(float h, float s, float v, float a=1.0f)</arglist>
    </member>
    <member kind="function">
      <type>SbColor4f &amp;</type>
      <name>setHSVValue</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>a04e5474068c768e2fc4eb6850b50237a</anchor>
      <arglist>(const float hsv[3], float alpha=1.0f)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getHSVValue</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>a240dccc38d73379abc757bf074fa7820</anchor>
      <arglist>(float &amp;h, float &amp;s, float &amp;v) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getHSVValue</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>a4c41a43e085132a314c087e4bbac542a</anchor>
      <arglist>(float hsv[3]) const </arglist>
    </member>
    <member kind="function">
      <type>SbColor4f &amp;</type>
      <name>setPackedValue</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>a22e7a117d0bf23c0ac65575fa25bd677</anchor>
      <arglist>(const uint32_t rgba)</arglist>
    </member>
    <member kind="function">
      <type>uint32_t</type>
      <name>getPackedValue</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>a52629067a54c01dfa70a11fd02da3da0</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>operator[]</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>a276f5de9641d3972f43617649c561f67</anchor>
      <arglist>(const int idx) const </arglist>
    </member>
    <member kind="function">
      <type>float &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>ae8a3bdb9100bf8dce49cdaf2328b759c</anchor>
      <arglist>(const int idx)</arglist>
    </member>
    <member kind="function">
      <type>SbColor4f &amp;</type>
      <name>operator*=</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>ae31222f52097bddb749f79ab4d47d118</anchor>
      <arglist>(const float d)</arglist>
    </member>
    <member kind="function">
      <type>SbColor4f &amp;</type>
      <name>operator/=</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>ab257bf4d02b46088c6b1f2d3a06c7d23</anchor>
      <arglist>(const float d)</arglist>
    </member>
    <member kind="function">
      <type>SbColor4f &amp;</type>
      <name>operator+=</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>a26329aa5fe3dda3ee1d3f3146bc33b96</anchor>
      <arglist>(const SbColor4f &amp;c)</arglist>
    </member>
    <member kind="function">
      <type>SbColor4f &amp;</type>
      <name>operator-=</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>afe4e215e3f77dc75b6e33323baeddc30</anchor>
      <arglist>(const SbColor4f &amp;c)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec4f</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>a8906e1c6054ce209d1f6d77a21515e44</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec4f</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>ad731535c83725d6bdc900b9a30ab4c92</anchor>
      <arglist>(const float v[4])</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec4f</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>adf498d940df41d8a89e34bffcb3cf2b8</anchor>
      <arglist>(float x, float y, float z, float w)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec4f</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>a8545647ed869389186e93b47b7e2d52e</anchor>
      <arglist>(const SbVec4d &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec4f</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>a98e08f627dac939645bb52580db3c4aa</anchor>
      <arglist>(const SbVec4b &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec4f</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>a254dd416048917eee27af0b8463fbd48</anchor>
      <arglist>(const SbVec4s &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec4f</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>ac83cc2c568738c8781fcee9b2fde8cf8</anchor>
      <arglist>(const SbVec4i32 &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec4f &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>a5a641bc3d9805f860ed2c5d2b635389e</anchor>
      <arglist>(const float v[4])</arglist>
    </member>
    <member kind="function">
      <type>SbVec4f &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>aa064707268b43ad1df00633375e7e092</anchor>
      <arglist>(float x, float y, float z, float w)</arglist>
    </member>
    <member kind="function">
      <type>SbVec4f &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>a9c1937f4c3d7b1148957a0ac6d67b72f</anchor>
      <arglist>(const SbVec4d &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec4f &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>aee85f8205cddc571831987e400c4775e</anchor>
      <arglist>(const SbVec4b &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec4f &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>a2cb09fafbc258b541f6cd85c7e0a6b04</anchor>
      <arglist>(const SbVec4s &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec4f &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>a6122ce3070d5e7ee16db5cb9ef89b173</anchor>
      <arglist>(const SbVec4i32 &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>const float *</type>
      <name>getValue</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>a88b6add43c67f4711a2c327df8a4a4d0</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getValue</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>a05298e0798e51c1e66e686a9069345f7</anchor>
      <arglist>(float &amp;x, float &amp;y, float &amp;z, float &amp;w) const </arglist>
    </member>
    <member kind="function">
      <type>float &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>aec83ad2e3162654f8d072404f8a10fd3</anchor>
      <arglist>(int i)</arglist>
    </member>
    <member kind="function">
      <type>const float &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>a23a56952ae4ffcdc921ae9a1a78e97a1</anchor>
      <arglist>(int i) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>equals</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>aa189954da7227667ccb1bb342c51d362</anchor>
      <arglist>(const SbVec4f &amp;v, float tolerance) const </arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>dot</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>ab34395948ac0e4ed013003056bae3b13</anchor>
      <arglist>(const SbVec4f &amp;v) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getReal</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>a741cad8de0f09ea5518814d3f0ad20f3</anchor>
      <arglist>(SbVec3f &amp;v) const </arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>length</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>ad7c1ade932e4896ddb06bf7e09f6ba1b</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>sqrLength</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>aab32ba1dec469c4f77ae2c336b944033</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>negate</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>ac87c676afcddcdd4c4a8e4dfacaaf81e</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>normalize</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>aee89703dbbd922b7c3df9084787af3bd</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>SbVec4f &amp;</type>
      <name>operator*=</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>a6edff39216ff55da920bb1a10363e7a0</anchor>
      <arglist>(float d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec4f &amp;</type>
      <name>operator/=</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>a386fce6ce83b627ec4fe352241301ad0</anchor>
      <arglist>(float d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec4f &amp;</type>
      <name>operator+=</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>abe309edc1357ce93eb1f218c6eb1e1ba</anchor>
      <arglist>(const SbVec4f &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec4f &amp;</type>
      <name>operator-=</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>a0fa3416e87b398acfb9fdf0fc26b3a61</anchor>
      <arglist>(const SbVec4f &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec4f</type>
      <name>operator-</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>a604c1b9929a75b6f41e9faa9c1d670ca</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>aea5573a058fb5a76724790c834e9c1d3</anchor>
      <arglist>(FILE *fp) const </arglist>
    </member>
    <member kind="friend">
      <type>friend SbColor4f</type>
      <name>operator*</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>acbb7294a2d7e5e10c6807da2a422f847</anchor>
      <arglist>(const SbColor4f &amp;c, const float d)</arglist>
    </member>
    <member kind="friend">
      <type>friend SbColor4f</type>
      <name>operator*</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>ab9a7c90da47b08a148fccd7030c42834</anchor>
      <arglist>(const float d, const SbColor4f &amp;c)</arglist>
    </member>
    <member kind="friend">
      <type>friend SbColor4f</type>
      <name>operator/</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>ae48a713a98060ce1409e185c9a79bb3c</anchor>
      <arglist>(const SbColor4f &amp;c, const float d)</arglist>
    </member>
    <member kind="friend">
      <type>friend SbColor4f</type>
      <name>operator+</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>a7681baa1f2aca9f602b8ca4141a30ccb</anchor>
      <arglist>(const SbColor4f &amp;v1, const SbColor4f &amp;v2)</arglist>
    </member>
    <member kind="friend">
      <type>friend SbColor4f</type>
      <name>operator-</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>a555100ee71c33ba2ec63cdad33d42110</anchor>
      <arglist>(const SbColor4f &amp;v1, const SbColor4f &amp;v2)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator==</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>a3fff3adfe14963774875fd2d5116aa31</anchor>
      <arglist>(const SbColor4f &amp;v1, const SbColor4f &amp;v2)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator!=</name>
      <anchorfile>classSbColor4f.html</anchorfile>
      <anchor>aab73e3db4033c10a001e6c08feb26015</anchor>
      <arglist>(const SbColor4f &amp;v1, const SbColor4f &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>SbVec4f</type>
      <name>operator*</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>a92a3a4750b0fa4407f48db6adc22a9ca</anchor>
      <arglist>(const SbVec4f &amp;v, float d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec4f</type>
      <name>operator*</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>abd05dad2218ea2be75c970bb965f0fed</anchor>
      <arglist>(float d, const SbVec4f &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec4f</type>
      <name>operator/</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>af0c94dc96d51452294649791712c142a</anchor>
      <arglist>(const SbVec4f &amp;v, float d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec4f</type>
      <name>operator+</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>abc1db057a8df5be3eb7f5d19f90b0e58</anchor>
      <arglist>(const SbVec4f &amp;v1, const SbVec4f &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>SbVec4f</type>
      <name>operator-</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>aeb503e55d6b40b30f6306f6689fb37b8</anchor>
      <arglist>(const SbVec4f &amp;v1, const SbVec4f &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>aaaeee53660c883978e3ab2b0cfc27a77</anchor>
      <arglist>(const SbVec4f &amp;v1, const SbVec4f &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbVec4f.html</anchorfile>
      <anchor>a63873557b254683d8b5313b0615dc061</anchor>
      <arglist>(const SbVec4f &amp;v1, const SbVec4f &amp;v2)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbCylinder</name>
    <filename>classSbCylinder.html</filename>
    <member kind="function">
      <type></type>
      <name>SbCylinder</name>
      <anchorfile>classSbCylinder.html</anchorfile>
      <anchor>ab268ab24f22bd16e48cf39208af2ecc2</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbCylinder</name>
      <anchorfile>classSbCylinder.html</anchorfile>
      <anchor>a8fddfda354f81860438fb87545cfc345</anchor>
      <arglist>(const SbLine &amp;a, const float r)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValue</name>
      <anchorfile>classSbCylinder.html</anchorfile>
      <anchor>af90337238a8ab3a5db63e0a69c5e9d71</anchor>
      <arglist>(const SbLine &amp;a, const float r)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAxis</name>
      <anchorfile>classSbCylinder.html</anchorfile>
      <anchor>a67bbd92c4b5d74aa76c795c44a50a003</anchor>
      <arglist>(const SbLine &amp;a)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRadius</name>
      <anchorfile>classSbCylinder.html</anchorfile>
      <anchor>a03a31659f75d8da21d426051bc2bf9b1</anchor>
      <arglist>(const float r)</arglist>
    </member>
    <member kind="function">
      <type>const SbLine &amp;</type>
      <name>getAxis</name>
      <anchorfile>classSbCylinder.html</anchorfile>
      <anchor>addfae1b302c037f56574b7b6362bb4bb</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getRadius</name>
      <anchorfile>classSbCylinder.html</anchorfile>
      <anchor>a02a8d5b7a192889abe798962d1ab5d53</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbCylinder.html</anchorfile>
      <anchor>a3342f6f716873e1ec71907aa167ba970</anchor>
      <arglist>(const SbLine &amp;l, SbVec3f &amp;intersection) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbCylinder.html</anchorfile>
      <anchor>ac69c116097c43eaa4fe1e64d71550000</anchor>
      <arglist>(const SbLine &amp;l, SbVec3f &amp;enter, SbVec3f &amp;exit) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classSbCylinder.html</anchorfile>
      <anchor>ab42dc00c9f080d0f307e89739c75d5b2</anchor>
      <arglist>(FILE *file) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbCylinderPlaneProjector</name>
    <filename>classSbCylinderPlaneProjector.html</filename>
    <base>SbCylinderSectionProjector</base>
    <member kind="function">
      <type></type>
      <name>SbCylinderPlaneProjector</name>
      <anchorfile>classSbCylinderPlaneProjector.html</anchorfile>
      <anchor>a08fd132904bbd02f023a9828343042cc</anchor>
      <arglist>(const float edgetol=0.9f, const SbBool orienttoeye=TRUE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbCylinderPlaneProjector</name>
      <anchorfile>classSbCylinderPlaneProjector.html</anchorfile>
      <anchor>abdc129cdfa4dd62899ee4aee8b6db575</anchor>
      <arglist>(const SbCylinder &amp;cyl, const float edgetol=0.9f, const SbBool orienttoeye=TRUE)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbProjector *</type>
      <name>copy</name>
      <anchorfile>classSbCylinderPlaneProjector.html</anchorfile>
      <anchor>adb328b12149ab9c8f3a172d7fc78040c</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbVec3f</type>
      <name>project</name>
      <anchorfile>classSbCylinderPlaneProjector.html</anchorfile>
      <anchor>afb1bc7a499cfab6096c991dfb14ee569</anchor>
      <arglist>(const SbVec2f &amp;point)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbRotation</type>
      <name>getRotation</name>
      <anchorfile>classSbCylinderPlaneProjector.html</anchorfile>
      <anchor>aca777eb280e6dec53fdfe4df92248799</anchor>
      <arglist>(const SbVec3f &amp;point1, const SbVec3f &amp;point2)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbCylinderSectionProjector</name>
      <anchorfile>classSbCylinderSectionProjector.html</anchorfile>
      <anchor>a372620eae35a518562eaa71ec623ca88</anchor>
      <arglist>(const float edgetol=0.9f, const SbBool orienttoeye=TRUE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbCylinderSectionProjector</name>
      <anchorfile>classSbCylinderSectionProjector.html</anchorfile>
      <anchor>ad55f8fc72cd86d3153ed5a929277622d</anchor>
      <arglist>(const SbCylinder &amp;cyl, const float edgetol=0.9f, const SbBool orienttoeye=TRUE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTolerance</name>
      <anchorfile>classSbCylinderSectionProjector.html</anchorfile>
      <anchor>a5d62015051b829b7af812d98fd0303be</anchor>
      <arglist>(const float edgetol)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getTolerance</name>
      <anchorfile>classSbCylinderSectionProjector.html</anchorfile>
      <anchor>a7c83b84a42f126133e4d9b6ce13e1c89</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isWithinTolerance</name>
      <anchorfile>classSbCylinderSectionProjector.html</anchorfile>
      <anchor>a901871f080a352cdaec49f13a0ccce13</anchor>
      <arglist>(const SbVec3f &amp;point)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f</type>
      <name>projectAndGetRotation</name>
      <anchorfile>classSbCylinderProjector.html</anchorfile>
      <anchor>a8c299f86e571141f3cdaa07c222b7b07</anchor>
      <arglist>(const SbVec2f &amp;point, SbRotation &amp;rot)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCylinder</name>
      <anchorfile>classSbCylinderProjector.html</anchorfile>
      <anchor>ac4c6c87f8bc0656f781b9281d9c37294</anchor>
      <arglist>(const SbCylinder &amp;cyl)</arglist>
    </member>
    <member kind="function">
      <type>const SbCylinder &amp;</type>
      <name>getCylinder</name>
      <anchorfile>classSbCylinderProjector.html</anchorfile>
      <anchor>a35df77d446b36e2c374f9ab78e853196</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setOrientToEye</name>
      <anchorfile>classSbCylinderProjector.html</anchorfile>
      <anchor>a366afa63e637a639ed16ee34374d7073</anchor>
      <arglist>(const SbBool orienttoeye)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isOrientToEye</name>
      <anchorfile>classSbCylinderProjector.html</anchorfile>
      <anchor>ab8427c0e6d749b739728b7af507d7d3c</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFront</name>
      <anchorfile>classSbCylinderProjector.html</anchorfile>
      <anchor>a3a66f1c989709170b78c07cf172293ae</anchor>
      <arglist>(const SbBool infront)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isFront</name>
      <anchorfile>classSbCylinderProjector.html</anchorfile>
      <anchor>a013b148faf20892010ea0184860170f2</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isPointInFront</name>
      <anchorfile>classSbCylinderProjector.html</anchorfile>
      <anchor>a73f1f508e65589e63f18a79b3b076e6d</anchor>
      <arglist>(const SbVec3f &amp;point) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setWorkingSpace</name>
      <anchorfile>classSbCylinderProjector.html</anchorfile>
      <anchor>a67017820b22d21be5008a09517cad5d9</anchor>
      <arglist>(const SbMatrix &amp;space)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setViewVolume</name>
      <anchorfile>classSbProjector.html</anchorfile>
      <anchor>a31e07b5d3f93e5be01f1945536e74a18</anchor>
      <arglist>(const SbViewVolume &amp;vol)</arglist>
    </member>
    <member kind="function">
      <type>const SbViewVolume &amp;</type>
      <name>getViewVolume</name>
      <anchorfile>classSbProjector.html</anchorfile>
      <anchor>af9c675566ac78be97e2c5f8dfde640e0</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>const SbMatrix &amp;</type>
      <name>getWorkingSpace</name>
      <anchorfile>classSbProjector.html</anchorfile>
      <anchor>a0c8973e3b20cea311ab0067ef45c7820</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>tryProject</name>
      <anchorfile>classSbProjector.html</anchorfile>
      <anchor>a1912d859fd6a18d253706c9fdd40b5e0</anchor>
      <arglist>(const SbVec2f &amp;point, const float epsilon, SbVec3f &amp;result)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>SbRotation</type>
      <name>getRotation</name>
      <anchorfile>classSbCylinderPlaneProjector.html</anchorfile>
      <anchor>a4aba339a4a76f500347952d5c901fbc7</anchor>
      <arglist>(const SbVec3f &amp;point1, const SbBool tol1, const SbVec3f &amp;point2, const SbBool tol2)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>setupTolerance</name>
      <anchorfile>classSbCylinderSectionProjector.html</anchorfile>
      <anchor>abbed8e29371e9d9b76e5341883bfdd7c</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>SbCylinderProjector</name>
      <anchorfile>classSbCylinderProjector.html</anchorfile>
      <anchor>a6dd2e2729ca64533ad3f6e46c5a04226</anchor>
      <arglist>(const SbBool orienttoeye)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>SbCylinderProjector</name>
      <anchorfile>classSbCylinderProjector.html</anchorfile>
      <anchor>a0c3291f74209ce8faed25c9074ec10f9</anchor>
      <arglist>(const SbCylinder &amp;cylinder, const SbBool orienttoeye)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>SbBool</type>
      <name>intersectCylinderFront</name>
      <anchorfile>classSbCylinderProjector.html</anchorfile>
      <anchor>a11b8f0cd7a7d1f7946e10283aa0fb394</anchor>
      <arglist>(const SbLine &amp;line, SbVec3f &amp;result)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>SbProjector</name>
      <anchorfile>classSbProjector.html</anchorfile>
      <anchor>af5e966f3ff29a796d35c7a1e0c6284e5</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~SbProjector</name>
      <anchorfile>classSbProjector.html</anchorfile>
      <anchor>a6414ffa4d6d0635f1261b71a5df81ea9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>SbLine</type>
      <name>getWorkingLine</name>
      <anchorfile>classSbProjector.html</anchorfile>
      <anchor>a0383142c3d4e1e69d13af75884905c9e</anchor>
      <arglist>(const SbVec2f &amp;point) const </arglist>
    </member>
    <member kind="function" protection="protected">
      <type>float</type>
      <name>findVanishingDistance</name>
      <anchorfile>classSbProjector.html</anchorfile>
      <anchor>ad0157c8540c59a47168fcb0d4a62af58</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" protection="protected">
      <type>SbBool</type>
      <name>verifyProjection</name>
      <anchorfile>classSbProjector.html</anchorfile>
      <anchor>ac501fd419478c1cdad459d218d44d75f</anchor>
      <arglist>(const SbVec3f &amp;projpt) const </arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float</type>
      <name>tolerance</name>
      <anchorfile>classSbCylinderSectionProjector.html</anchorfile>
      <anchor>aefc718ff69cf2e490fd9de532a9b43ac</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float</type>
      <name>tolDist</name>
      <anchorfile>classSbCylinderSectionProjector.html</anchorfile>
      <anchor>a798cc0c751300b98aa20d6381994a802</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbVec3f</type>
      <name>planeDir</name>
      <anchorfile>classSbCylinderSectionProjector.html</anchorfile>
      <anchor>a6c1a2f3bba580766b888672dfdfd6834</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbLine</type>
      <name>planeLine</name>
      <anchorfile>classSbCylinderSectionProjector.html</anchorfile>
      <anchor>a989430109a1f431e9a6a60a75e47cef9</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float</type>
      <name>planeDist</name>
      <anchorfile>classSbCylinderSectionProjector.html</anchorfile>
      <anchor>aa1a721305a73dc62e97aff7be3b3e5a6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbPlane</type>
      <name>tolPlane</name>
      <anchorfile>classSbCylinderSectionProjector.html</anchorfile>
      <anchor>a5d8b4276b37a9b596458366615506ecb</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbBool</type>
      <name>intersectFront</name>
      <anchorfile>classSbCylinderProjector.html</anchorfile>
      <anchor>a6040babe44b89117f1cb3bc0cdffc377</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbCylinder</type>
      <name>cylinder</name>
      <anchorfile>classSbCylinderProjector.html</anchorfile>
      <anchor>aa3debf12deff6aa74807637383eacd77</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbBool</type>
      <name>orientToEye</name>
      <anchorfile>classSbCylinderProjector.html</anchorfile>
      <anchor>afed152233dd402a2376f300c34adfa84</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbBool</type>
      <name>needSetup</name>
      <anchorfile>classSbCylinderProjector.html</anchorfile>
      <anchor>af4238e26836efac6c8d10a8579a7ec70</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbVec3f</type>
      <name>lastPoint</name>
      <anchorfile>classSbCylinderProjector.html</anchorfile>
      <anchor>af2e2f91ad80b06fa7072bad5bdd78647</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbViewVolume</type>
      <name>viewVol</name>
      <anchorfile>classSbProjector.html</anchorfile>
      <anchor>af87ecfa2c2a1f99472327b7721eca310</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbMatrix</type>
      <name>worldToWorking</name>
      <anchorfile>classSbProjector.html</anchorfile>
      <anchor>a9320194b4e872c21a2f6b04a2ff9d815</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbMatrix</type>
      <name>workingToWorld</name>
      <anchorfile>classSbProjector.html</anchorfile>
      <anchor>a9cb662f372bcc9d01a7b392cde75e8e1</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbCylinderProjector</name>
    <filename>classSbCylinderProjector.html</filename>
    <base>SbProjector</base>
    <member kind="function" virtualness="pure">
      <type>virtual SbVec3f</type>
      <name>project</name>
      <anchorfile>classSbCylinderProjector.html</anchorfile>
      <anchor>a0932d5f18d746906ef42ab363d8913be</anchor>
      <arglist>(const SbVec2f &amp;point)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual SbRotation</type>
      <name>getRotation</name>
      <anchorfile>classSbCylinderProjector.html</anchorfile>
      <anchor>aa5dd6c4bc18a40ed5706b22beedcee58</anchor>
      <arglist>(const SbVec3f &amp;point1, const SbVec3f &amp;point2)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual SbProjector *</type>
      <name>copy</name>
      <anchorfile>classSbProjector.html</anchorfile>
      <anchor>aa33a37be8140f93ccad65e06a1f5c88b</anchor>
      <arglist>(void) const =0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbCylinderSectionProjector</name>
    <filename>classSbCylinderSectionProjector.html</filename>
    <base>SbCylinderProjector</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SbProjector *</type>
      <name>copy</name>
      <anchorfile>classSbCylinderSectionProjector.html</anchorfile>
      <anchor>a3385ed8d4720d5db3d028c4b6b7e5b10</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbVec3f</type>
      <name>project</name>
      <anchorfile>classSbCylinderSectionProjector.html</anchorfile>
      <anchor>a1559a388a0fdcd3de1ef8a2fe1066388</anchor>
      <arglist>(const SbVec2f &amp;point)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbRotation</type>
      <name>getRotation</name>
      <anchorfile>classSbCylinderSectionProjector.html</anchorfile>
      <anchor>a520520c707d304d80d4e6a8dd7f0374f</anchor>
      <arglist>(const SbVec3f &amp;point1, const SbVec3f &amp;point2)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbCylinderSheetProjector</name>
    <filename>classSbCylinderSheetProjector.html</filename>
    <base>SbCylinderProjector</base>
    <member kind="function">
      <type></type>
      <name>SbCylinderSheetProjector</name>
      <anchorfile>classSbCylinderSheetProjector.html</anchorfile>
      <anchor>a5cd81d6b119f6a77a4901d21c601339c</anchor>
      <arglist>(const SbBool orienttoeye=TRUE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbCylinderSheetProjector</name>
      <anchorfile>classSbCylinderSheetProjector.html</anchorfile>
      <anchor>aad3e95afc70fc70876845988f856205b</anchor>
      <arglist>(const SbCylinder &amp;cyl, const SbBool orienttoeye=TRUE)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbProjector *</type>
      <name>copy</name>
      <anchorfile>classSbCylinderSheetProjector.html</anchorfile>
      <anchor>a637eed19f250bb485cae830aeec43e9f</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbVec3f</type>
      <name>project</name>
      <anchorfile>classSbCylinderSheetProjector.html</anchorfile>
      <anchor>ac37ca81fe5dd8d1e7ecb176b692c8697</anchor>
      <arglist>(const SbVec2f &amp;point)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbRotation</type>
      <name>getRotation</name>
      <anchorfile>classSbCylinderSheetProjector.html</anchorfile>
      <anchor>a69a4e33d14b05a51533f45e977116bbe</anchor>
      <arglist>(const SbVec3f &amp;point1, const SbVec3f &amp;point2)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>setupPlane</name>
      <anchorfile>classSbCylinderSheetProjector.html</anchorfile>
      <anchor>af48ce18494eb4209176f1f6aab916d0d</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbVec3f</type>
      <name>workingProjPoint</name>
      <anchorfile>classSbCylinderSheetProjector.html</anchorfile>
      <anchor>a00ea3600bebe862c80d4cf120eaa184f</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbVec3f</type>
      <name>planeDir</name>
      <anchorfile>classSbCylinderSheetProjector.html</anchorfile>
      <anchor>af431cab97204963a160c156e04d103ce</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbPlane</type>
      <name>tolPlane</name>
      <anchorfile>classSbCylinderSheetProjector.html</anchorfile>
      <anchor>aba60a9c4f3431342af1a621f31179ddb</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbDict</name>
    <filename>classSbDict.html</filename>
    <member kind="function">
      <type></type>
      <name>SbDict</name>
      <anchorfile>classSbDict.html</anchorfile>
      <anchor>a92792a27e53f730d81c3f545ea1aeb66</anchor>
      <arglist>(const int entries=251)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbDict</name>
      <anchorfile>classSbDict.html</anchorfile>
      <anchor>adc2e06721f4e751e6c4b128eaed92b1c</anchor>
      <arglist>(const SbDict &amp;from)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbDict</name>
      <anchorfile>classSbDict.html</anchorfile>
      <anchor>abc0830ad6fc3f118ef9364193b488bd9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>SbDict &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbDict.html</anchorfile>
      <anchor>a79d4f48693dedcc4e643b7e65beecca3</anchor>
      <arglist>(const SbDict &amp;from)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>applyToAll</name>
      <anchorfile>classSbDict.html</anchorfile>
      <anchor>ab4c534180e79f149150418ce8e93e7d0</anchor>
      <arglist>(SbDictApplyFunc *rtn) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>applyToAll</name>
      <anchorfile>classSbDict.html</anchorfile>
      <anchor>aac6330a331057cd9aac365090cd8d919</anchor>
      <arglist>(SbDictApplyDataFunc *rtn, void *data) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear</name>
      <anchorfile>classSbDict.html</anchorfile>
      <anchor>a7a685b879d51576ad1719b9beca0b03b</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>enter</name>
      <anchorfile>classSbDict.html</anchorfile>
      <anchor>a0bba31f23e0a1d50cd3167b27b3398e0</anchor>
      <arglist>(const Key key, void *const value)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>find</name>
      <anchorfile>classSbDict.html</anchorfile>
      <anchor>ad2958e8376cefa3be704ac0986daab0d</anchor>
      <arglist>(const Key key, void *&amp;value) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>makePList</name>
      <anchorfile>classSbDict.html</anchorfile>
      <anchor>a7899d71e83dc06751a2f84a6e47945f5</anchor>
      <arglist>(SbPList &amp;keys, SbPList &amp;values)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>remove</name>
      <anchorfile>classSbDict.html</anchorfile>
      <anchor>a99399bd0d0a2400d2050acad0f944853</anchor>
      <arglist>(const Key key)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setHashingFunction</name>
      <anchorfile>classSbDict.html</anchorfile>
      <anchor>acb8a122d624bbb4c70236f1e8998e6b0</anchor>
      <arglist>(SbDictHashingFunc *func)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbDPLine</name>
    <filename>classSbDPLine.html</filename>
    <member kind="function">
      <type></type>
      <name>SbDPLine</name>
      <anchorfile>classSbDPLine.html</anchorfile>
      <anchor>acd891c0ec98d97dbd7875444eb15d728</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbDPLine</name>
      <anchorfile>classSbDPLine.html</anchorfile>
      <anchor>abeb8525f59026c04f1bfc9e5f9384af4</anchor>
      <arglist>(const SbVec3d &amp;p0, const SbVec3d &amp;p1)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValue</name>
      <anchorfile>classSbDPLine.html</anchorfile>
      <anchor>a2bbe6dd0ab4145e4443d5a3d1c2ee268</anchor>
      <arglist>(const SbVec3d &amp;p0, const SbVec3d &amp;p1)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPosDir</name>
      <anchorfile>classSbDPLine.html</anchorfile>
      <anchor>a577cfe7776c15483c5d1a8adc2c29cfc</anchor>
      <arglist>(const SbVec3d &amp;position, const SbVec3d &amp;direction)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>getClosestPoints</name>
      <anchorfile>classSbDPLine.html</anchorfile>
      <anchor>a355e0a4a1f22ae2f750051b9e9094fbc</anchor>
      <arglist>(const SbDPLine &amp;line2, SbVec3d &amp;ptOnThis, SbVec3d &amp;ptOnLine2) const </arglist>
    </member>
    <member kind="function">
      <type>SbVec3d</type>
      <name>getClosestPoint</name>
      <anchorfile>classSbDPLine.html</anchorfile>
      <anchor>a049140acbac918165aa821ca85d35bf6</anchor>
      <arglist>(const SbVec3d &amp;point) const </arglist>
    </member>
    <member kind="function">
      <type>const SbVec3d &amp;</type>
      <name>getPosition</name>
      <anchorfile>classSbDPLine.html</anchorfile>
      <anchor>a643fe9cb3f4dd3f9fe17ee283b86650b</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>const SbVec3d &amp;</type>
      <name>getDirection</name>
      <anchorfile>classSbDPLine.html</anchorfile>
      <anchor>a3376b619ce25fc9506c2771a1e23b30b</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classSbDPLine.html</anchorfile>
      <anchor>a3476ce5ea28fc8e4c9b88c79028742a6</anchor>
      <arglist>(FILE *file) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbDPMatrix</name>
    <filename>classSbDPMatrix.html</filename>
    <member kind="function">
      <type></type>
      <name>SbDPMatrix</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>a128a211a7842030be0e1c041f471f991</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbDPMatrix</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>a8cde278900f7f4c9685958e5c788ba2b</anchor>
      <arglist>(const double a11, const double a12, const double a13, const double a14, const double a21, const double a22, const double a23, const double a24, const double a31, const double a32, const double a33, const double a34, const double a41, const double a42, const double a43, const double a44)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbDPMatrix</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>a26d2933f7ff756a6c11c2696bf7c8603</anchor>
      <arglist>(const SbDPMat &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbDPMatrix</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>afa1e0f29be6a11a565f221f96076ba87</anchor>
      <arglist>(const SbDPMat *matrix)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbDPMatrix</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>ab7b2feaf256ebcc815c7b4148a50449f</anchor>
      <arglist>(const SbMatrix &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbDPMatrix</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>a98f02d5633413ffbdeb4044eb4552248</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValue</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>a47126c746af49b0bf8b700a8b99fe09e</anchor>
      <arglist>(const SbDPMat &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValue</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>aea0f76b23ee126dbd9d92d66b77f3ebd</anchor>
      <arglist>(const SbMatrix &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValue</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>a7039941aa193a375d440923e93580619</anchor>
      <arglist>(const double *pMat)</arglist>
    </member>
    <member kind="function">
      <type>const SbDPMat &amp;</type>
      <name>getValue</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>a2102d0cd7239bba1558b2d9500f9e4b2</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>makeIdentity</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>a5ebe71e85bd73734f391f3c7736a6a59</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRotate</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>aecb5ac77f13d3041efab4239f496b024</anchor>
      <arglist>(const SbDPRotation &amp;q)</arglist>
    </member>
    <member kind="function">
      <type>SbDPMatrix</type>
      <name>inverse</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>a16928f3c478a92adb9f1617324317fa9</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>det3</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>a4380f394be7aa7f0156a22fa35586f7c</anchor>
      <arglist>(int r1, int r2, int r3, int c1, int c2, int c3) const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>det3</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>ab90006b1d1a779a14dd49e70a2795c0a</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>det4</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>ae74f3f4a0212f3159eaba0e3f1d9d93a</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>equals</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>a41410cfd05478e098b8f7446b712f5e5</anchor>
      <arglist>(const SbDPMatrix &amp;m, double tolerance) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getValue</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>af997385ce8dffb28c38acc9df3a91aef</anchor>
      <arglist>(SbDPMat &amp;m) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setScale</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>a965c24d5efbdbbd0ec34ee327a063073</anchor>
      <arglist>(const double s)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setScale</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>aa6d94a40b76407b8feb94b8a4cc409ee</anchor>
      <arglist>(const SbVec3d &amp;s)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTranslate</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>ab74a0f653f57e888074078748031faca</anchor>
      <arglist>(const SbVec3d &amp;t)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTransform</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>abde926c18b54a0d8666130918c744e88</anchor>
      <arglist>(const SbVec3d &amp;t, const SbDPRotation &amp;r, const SbVec3d &amp;s)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTransform</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>aec1c06558a7c4deed0093102308ff384</anchor>
      <arglist>(const SbVec3d &amp;t, const SbDPRotation &amp;r, const SbVec3d &amp;s, const SbDPRotation &amp;so)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTransform</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>abfd3f938b5145dc09a81b5b381cd39b8</anchor>
      <arglist>(const SbVec3d &amp;translation, const SbDPRotation &amp;rotation, const SbVec3d &amp;scaleFactor, const SbDPRotation &amp;scaleOrientation, const SbVec3d &amp;center)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getTransform</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>a5a6c1a6de8bfcfbec8d40fdf86746e9b</anchor>
      <arglist>(SbVec3d &amp;t, SbDPRotation &amp;r, SbVec3d &amp;s, SbDPRotation &amp;so) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getTransform</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>a7130fb0618edbc93d0dcb6e35bb1a6aa</anchor>
      <arglist>(SbVec3d &amp;translation, SbDPRotation &amp;rotation, SbVec3d &amp;scaleFactor, SbDPRotation &amp;scaleOrientation, const SbVec3d &amp;center) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>factor</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>abf2e53bbe1cfae3a6e6942b94c7fe23b</anchor>
      <arglist>(SbDPMatrix &amp;r, SbVec3d &amp;s, SbDPMatrix &amp;u, SbVec3d &amp;t, SbDPMatrix &amp;proj)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>LUDecomposition</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>ae2a77b2e48bdfcf31d1ccc2c357dfdaa</anchor>
      <arglist>(int index[4], double &amp;d)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>LUBackSubstitution</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>ae6462895224c68c394b6e7554a7cd476</anchor>
      <arglist>(int index[4], double b[4]) const </arglist>
    </member>
    <member kind="function">
      <type>SbDPMatrix</type>
      <name>transpose</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>a8fa9bbf1ea7c5776c9e6d30963397d99</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SbDPMatrix &amp;</type>
      <name>multRight</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>a94cfe014d9ff734715d95528594f0dab</anchor>
      <arglist>(const SbDPMatrix &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>SbDPMatrix &amp;</type>
      <name>multLeft</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>ad460ff02e7cbb1d936924860c2597f07</anchor>
      <arglist>(const SbDPMatrix &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>multMatrixVec</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>a587eab95805eb41f15cd0a94f4e7e1a3</anchor>
      <arglist>(const SbVec3d &amp;src, SbVec3d &amp;dst) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>multVecMatrix</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>a92985ed3d10b79b1dc2175389450e0b0</anchor>
      <arglist>(const SbVec3d &amp;src, SbVec3d &amp;dst) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>multDirMatrix</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>a9e01f23afa9a41db717cd4283307c024</anchor>
      <arglist>(const SbVec3d &amp;src, SbVec3d &amp;dst) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>multLineMatrix</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>a6784286f5833eb2ca81227ec4b3d14c6</anchor>
      <arglist>(const SbDPLine &amp;src, SbDPLine &amp;dst) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>multVecMatrix</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>a96f5a847637003e527dd1b22e0fbfce4</anchor>
      <arglist>(const SbVec4d &amp;src, SbVec4d &amp;dst) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>adca41af3835ba425687b343bf5ea211f</anchor>
      <arglist>(FILE *fp) const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator double *</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>ad050e634a24d8b5d8cd116e80316e74f</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator SbDPMat &amp;</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>a7e631132127dd962adc8ae686f414efb</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>double *</type>
      <name>operator[]</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>a3e9db2cc1e28ca32f45465b9e01a12fe</anchor>
      <arglist>(int i)</arglist>
    </member>
    <member kind="function">
      <type>const double *</type>
      <name>operator[]</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>af4f27f62e5a13c62662eee52eb179feb</anchor>
      <arglist>(int i) const </arglist>
    </member>
    <member kind="function">
      <type>SbDPMatrix &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>ab4bf47329bd286320f889bc267027b8a</anchor>
      <arglist>(const SbDPMat &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>SbDPMatrix &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>acb80ec05f96b34bef20434d629ede014</anchor>
      <arglist>(const SbDPMatrix &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>SbDPMatrix &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>a1dbd777cd44b861cbecd64ec1da2204f</anchor>
      <arglist>(const SbDPRotation &amp;q)</arglist>
    </member>
    <member kind="function">
      <type>SbDPMatrix &amp;</type>
      <name>operator*=</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>a5d1cd09332b55cff37b6bb7a2f980918</anchor>
      <arglist>(const SbDPMatrix &amp;m)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SbDPMatrix</type>
      <name>identity</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>a77c852c30e49dea81679efbb9eeb71b2</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="friend">
      <type>friend SbDPMatrix</type>
      <name>operator*</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>ad0c5a82f0b6100292f78322850978234</anchor>
      <arglist>(const SbDPMatrix &amp;m1, const SbDPMatrix &amp;m2)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator==</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>a728375812e131ac66d696b78a720985a</anchor>
      <arglist>(const SbDPMatrix &amp;m1, const SbDPMatrix &amp;m2)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator!=</name>
      <anchorfile>classSbDPMatrix.html</anchorfile>
      <anchor>a4a3d456e61e7addad0f5e3f81987146a</anchor>
      <arglist>(const SbDPMatrix &amp;m1, const SbDPMatrix &amp;m2)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbDPPlane</name>
    <filename>classSbDPPlane.html</filename>
    <member kind="function">
      <type></type>
      <name>SbDPPlane</name>
      <anchorfile>classSbDPPlane.html</anchorfile>
      <anchor>a19743ddaf4a384d3cba5a4e6f9a5a3ea</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbDPPlane</name>
      <anchorfile>classSbDPPlane.html</anchorfile>
      <anchor>a45410d9d067acdb90601e54d893579c5</anchor>
      <arglist>(const SbVec3d &amp;normal, const double D)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbDPPlane</name>
      <anchorfile>classSbDPPlane.html</anchorfile>
      <anchor>ae8b10470c878267cd3762cd89104db83</anchor>
      <arglist>(const SbVec3d &amp;p0, const SbVec3d &amp;p1, const SbVec3d &amp;p2)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbDPPlane</name>
      <anchorfile>classSbDPPlane.html</anchorfile>
      <anchor>acc7c2504435602ca952768e1c9cffa13</anchor>
      <arglist>(const SbVec3d &amp;normal, const SbVec3d &amp;point)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>offset</name>
      <anchorfile>classSbDPPlane.html</anchorfile>
      <anchor>a87d41a81065603b897e0f2c284ef6cdc</anchor>
      <arglist>(const double d)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbDPPlane.html</anchorfile>
      <anchor>a1d87db21d7aaf66094777d1aa3b68ef5</anchor>
      <arglist>(const SbDPLine &amp;l, SbVec3d &amp;intersection) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>transform</name>
      <anchorfile>classSbDPPlane.html</anchorfile>
      <anchor>a71e39eb1f846b916e17780b013d9e5a8</anchor>
      <arglist>(const SbDPMatrix &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isInHalfSpace</name>
      <anchorfile>classSbDPPlane.html</anchorfile>
      <anchor>abe3d3a38c1f5f5160c0d385748cc789e</anchor>
      <arglist>(const SbVec3d &amp;point) const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>getDistance</name>
      <anchorfile>classSbDPPlane.html</anchorfile>
      <anchor>a2a0cc1f549ad08a6311d96e63b43e8dc</anchor>
      <arglist>(const SbVec3d &amp;point) const </arglist>
    </member>
    <member kind="function">
      <type>const SbVec3d &amp;</type>
      <name>getNormal</name>
      <anchorfile>classSbDPPlane.html</anchorfile>
      <anchor>af7c17d2b6c6f42ddbfe7fe3234ca4fc4</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>getDistanceFromOrigin</name>
      <anchorfile>classSbDPPlane.html</anchorfile>
      <anchor>aec49f5ebae3498aedf497f3a8139d05e</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classSbDPPlane.html</anchorfile>
      <anchor>a0d879fe36a4658cff22d74d6993dc980</anchor>
      <arglist>(FILE *file) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbDPPlane.html</anchorfile>
      <anchor>ada15f11208993d05fb67efe1e3ee6fdc</anchor>
      <arglist>(const SbDPPlane &amp;pl, SbDPLine &amp;line) const </arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator==</name>
      <anchorfile>classSbDPPlane.html</anchorfile>
      <anchor>ae782368c6d9fae2120c18c92230c8d89</anchor>
      <arglist>(const SbDPPlane &amp;p1, const SbDPPlane &amp;p2)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator!=</name>
      <anchorfile>classSbDPPlane.html</anchorfile>
      <anchor>a649768b36ed267dd12e76a5795d4e096</anchor>
      <arglist>(const SbDPPlane &amp;p1, const SbDPPlane &amp;p2)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbDPRotation</name>
    <filename>classSbDPRotation.html</filename>
    <member kind="function">
      <type></type>
      <name>SbDPRotation</name>
      <anchorfile>classSbDPRotation.html</anchorfile>
      <anchor>a75e95ae9852ea9bbc637e2620b1e94f9</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbDPRotation</name>
      <anchorfile>classSbDPRotation.html</anchorfile>
      <anchor>ac0780b9ba075f24437a86aa1423ad5ed</anchor>
      <arglist>(const SbVec3d &amp;axis, const double radians)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbDPRotation</name>
      <anchorfile>classSbDPRotation.html</anchorfile>
      <anchor>a526858027f32f228658c698e9dd8d430</anchor>
      <arglist>(const double q[4])</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbDPRotation</name>
      <anchorfile>classSbDPRotation.html</anchorfile>
      <anchor>a2f4eb6b6904cbf232a616aced527fec9</anchor>
      <arglist>(const double q0, const double q1, const double q2, const double q3)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbDPRotation</name>
      <anchorfile>classSbDPRotation.html</anchorfile>
      <anchor>a26323e59933868a9aee01f90f97fae39</anchor>
      <arglist>(const SbDPMatrix &amp;m)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbDPRotation</name>
      <anchorfile>classSbDPRotation.html</anchorfile>
      <anchor>aa722c5954dfabfd29a44466ba70e4e3f</anchor>
      <arglist>(const SbVec3d &amp;rotateFrom, const SbVec3d &amp;rotateTo)</arglist>
    </member>
    <member kind="function">
      <type>const double *</type>
      <name>getValue</name>
      <anchorfile>classSbDPRotation.html</anchorfile>
      <anchor>aecccfdd66370eab41116e5d5e23b734d</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getValue</name>
      <anchorfile>classSbDPRotation.html</anchorfile>
      <anchor>a839115811d7fd455ecdc8a120f991b9e</anchor>
      <arglist>(double &amp;q0, double &amp;q1, double &amp;q2, double &amp;q3) const </arglist>
    </member>
    <member kind="function">
      <type>SbDPRotation &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbDPRotation.html</anchorfile>
      <anchor>a79f13ce745916c9793ae37aee6ed4d2a</anchor>
      <arglist>(const double q0, const double q1, const double q2, const double q3)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getValue</name>
      <anchorfile>classSbDPRotation.html</anchorfile>
      <anchor>ad35092ed386bb6cb7edc1d80160f01c0</anchor>
      <arglist>(SbVec3d &amp;axis, double &amp;radians) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getValue</name>
      <anchorfile>classSbDPRotation.html</anchorfile>
      <anchor>a302ae3c115349b2fae090498bee12812</anchor>
      <arglist>(SbDPMatrix &amp;matrix) const </arglist>
    </member>
    <member kind="function">
      <type>SbDPRotation &amp;</type>
      <name>invert</name>
      <anchorfile>classSbDPRotation.html</anchorfile>
      <anchor>a404861abbf42a5c66445738fe5275003</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>SbDPRotation</type>
      <name>inverse</name>
      <anchorfile>classSbDPRotation.html</anchorfile>
      <anchor>a4cbd2c6dbbe6e1ad18a32c987caecc2e</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SbDPRotation &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbDPRotation.html</anchorfile>
      <anchor>a523b33d8acfb38b8b34dc3f08cb47425</anchor>
      <arglist>(const double q[4])</arglist>
    </member>
    <member kind="function">
      <type>SbDPRotation &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbDPRotation.html</anchorfile>
      <anchor>a159abdcd77b50ceda59b4a0592778af1</anchor>
      <arglist>(const SbDPMatrix &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>SbDPRotation &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbDPRotation.html</anchorfile>
      <anchor>a6859b5db7a7d0c688397583cc87da55f</anchor>
      <arglist>(const SbVec3d &amp;axis, const double radians)</arglist>
    </member>
    <member kind="function">
      <type>SbDPRotation &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbDPRotation.html</anchorfile>
      <anchor>a62330c9ee7c08b3d0aca25cce1f77195</anchor>
      <arglist>(const SbVec3d &amp;rotateFrom, const SbVec3d &amp;rotateTo)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>equals</name>
      <anchorfile>classSbDPRotation.html</anchorfile>
      <anchor>a3f62b83779628666e74f3eabbc1dbb5a</anchor>
      <arglist>(const SbDPRotation &amp;r, double tolerance) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>multVec</name>
      <anchorfile>classSbDPRotation.html</anchorfile>
      <anchor>a78f9a415856b14cce91691cbc35d68af</anchor>
      <arglist>(const SbVec3d &amp;src, SbVec3d &amp;dst) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>scaleAngle</name>
      <anchorfile>classSbDPRotation.html</anchorfile>
      <anchor>a43fd701a0941cc47f940f5b62692602a</anchor>
      <arglist>(const double scaleFactor)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classSbDPRotation.html</anchorfile>
      <anchor>abd18c0a49dcb073f285b266c2464305e</anchor>
      <arglist>(FILE *fp) const </arglist>
    </member>
    <member kind="function">
      <type>SbDPRotation &amp;</type>
      <name>operator*=</name>
      <anchorfile>classSbDPRotation.html</anchorfile>
      <anchor>a1c52b9f857e1bf35813b46274c89a569</anchor>
      <arglist>(const SbDPRotation &amp;q)</arglist>
    </member>
    <member kind="function">
      <type>SbDPRotation &amp;</type>
      <name>operator*=</name>
      <anchorfile>classSbDPRotation.html</anchorfile>
      <anchor>af3e6b1e1d66b79c71d7d51f97e75a502</anchor>
      <arglist>(const double s)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SbDPRotation</type>
      <name>slerp</name>
      <anchorfile>classSbDPRotation.html</anchorfile>
      <anchor>a1653228819abaf8d9b2353fc22584331</anchor>
      <arglist>(const SbDPRotation &amp;rot0, const SbDPRotation &amp;rot1, double t)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SbDPRotation</type>
      <name>identity</name>
      <anchorfile>classSbDPRotation.html</anchorfile>
      <anchor>aa6dd1f0167071e01c72c61f292ddf9f5</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator==</name>
      <anchorfile>classSbDPRotation.html</anchorfile>
      <anchor>a456c673216e5fe96d0919d36f37c78a1</anchor>
      <arglist>(const SbDPRotation &amp;q1, const SbDPRotation &amp;q2)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator!=</name>
      <anchorfile>classSbDPRotation.html</anchorfile>
      <anchor>ad518f0072406b2b16a7104a3da13e83f</anchor>
      <arglist>(const SbDPRotation &amp;q1, const SbDPRotation &amp;q2)</arglist>
    </member>
    <member kind="friend">
      <type>friend SbDPRotation</type>
      <name>operator*</name>
      <anchorfile>classSbDPRotation.html</anchorfile>
      <anchor>a5152cc6241a0bcfd01ee2862dcb6bd58</anchor>
      <arglist>(const SbDPRotation &amp;q1, const SbDPRotation &amp;q2)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbDPViewVolume</name>
    <filename>classSbDPViewVolume.html</filename>
    <member kind="enumeration">
      <type></type>
      <name>ProjectionType</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a6e291b38723761fefa5f4d548656f02d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>ORTHOGRAPHIC</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a6e291b38723761fefa5f4d548656f02daba5f0b8714367d2d4f3fc89d827dad01</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>PERSPECTIVE</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a6e291b38723761fefa5f4d548656f02daf82dddc9bfb5b1bc708b4d0831a2fa08</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbDPViewVolume</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a6a9df3bca0f7d4224f6d9f87fbcfc0b6</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbDPViewVolume</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a2fcb214d160096d3f035c3a7aeec3407</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getMatrices</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a5e4d0ef235cc4a16a4dc40e9519d3ff6</anchor>
      <arglist>(SbDPMatrix &amp;affine, SbDPMatrix &amp;proj) const </arglist>
    </member>
    <member kind="function">
      <type>SbDPMatrix</type>
      <name>getMatrix</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a087ecaaf8f01b8e0df6641fec148eaea</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SbDPMatrix</type>
      <name>getCameraSpaceMatrix</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>ae5624a4e6f27e726be19e73541e46bb3</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>projectPointToLine</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>ab70cc4d29ec989fefcd77bf4c293d8a4</anchor>
      <arglist>(const SbVec2d &amp;pt, SbDPLine &amp;line) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>projectPointToLine</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a41c45c6a71305d3ebb0325e34b97006a</anchor>
      <arglist>(const SbVec2d &amp;pt, SbVec3d &amp;line0, SbVec3d &amp;line1) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>projectToScreen</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a0b24ce1372dab7be4211ccc95020b2e2</anchor>
      <arglist>(const SbVec3d &amp;src, SbVec3d &amp;dst) const </arglist>
    </member>
    <member kind="function">
      <type>SbPlane</type>
      <name>getPlane</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>ac53fde4fac62a058d2fdeee83248e511</anchor>
      <arglist>(const double distFromEye) const </arglist>
    </member>
    <member kind="function">
      <type>SbVec3d</type>
      <name>getSightPoint</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>aeaf93f694ba927c01331fc733c7850c8</anchor>
      <arglist>(const double distFromEye) const </arglist>
    </member>
    <member kind="function">
      <type>SbVec3d</type>
      <name>getPlanePoint</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a2bd4d56e10d3d0bdde2afe3c0f09b646</anchor>
      <arglist>(const double distFromEye, const SbVec2d &amp;normPoint) const </arglist>
    </member>
    <member kind="function">
      <type>SbDPRotation</type>
      <name>getAlignRotation</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a416f3c5f8ae8386dc967ed30c6bcd480</anchor>
      <arglist>(SbBool rightAngleOnly=FALSE) const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>getWorldToScreenScale</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a1ff755b170530b5f02ba511df3574abf</anchor>
      <arglist>(const SbVec3d &amp;worldCenter, double normRadius) const </arglist>
    </member>
    <member kind="function">
      <type>SbVec2d</type>
      <name>projectBox</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>abe0de2b057ffe859a38e7ed8cf28668a</anchor>
      <arglist>(const SbBox3f &amp;box) const </arglist>
    </member>
    <member kind="function">
      <type>SbDPViewVolume</type>
      <name>narrow</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a7729c1e052b8f3f33dc5a350695f09c1</anchor>
      <arglist>(double left, double bottom, double right, double top) const </arglist>
    </member>
    <member kind="function">
      <type>SbDPViewVolume</type>
      <name>narrow</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a2a33d2299b611e4ae9abc63d976e389e</anchor>
      <arglist>(const SbBox3f &amp;box) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ortho</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a5b1ae06d0a994807f8b7b03591390af6</anchor>
      <arglist>(double left, double right, double bottom, double top, double nearval, double farval)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>perspective</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a79b16609b4bb4ea993d2dc0abb1e9372</anchor>
      <arglist>(double fovy, double aspect, double nearval, double farval)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>frustum</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a5a1a8270a5c8a792b4baaa0f0db9718c</anchor>
      <arglist>(double left, double right, double bottom, double top, double nearval, double farval)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>rotateCamera</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a67b021bbbc5a24853825d464444a8377</anchor>
      <arglist>(const SbDPRotation &amp;q)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>translateCamera</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a56e666557e3a6cd38ab28b803ee2fdd4</anchor>
      <arglist>(const SbVec3d &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3d</type>
      <name>zVector</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a671550e1c0b702ae25a09f7ef8bfc278</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SbDPViewVolume</type>
      <name>zNarrow</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a20607fc2a782816c12e3c6e6f436c73b</anchor>
      <arglist>(double nearval, double farval) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>scale</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a3dc5c5e4cd6a2d0ae9059811dc80e5ad</anchor>
      <arglist>(double factor)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>scaleWidth</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a417df19943bcf1c2bdaeaf8336386ee7</anchor>
      <arglist>(double ratio)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>scaleHeight</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a999e189bd9500c74c4af3a0bc4ad94de</anchor>
      <arglist>(double ratio)</arglist>
    </member>
    <member kind="function">
      <type>ProjectionType</type>
      <name>getProjectionType</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a819c02e9ce96fede96d846ac4de81fc7</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>const SbVec3d &amp;</type>
      <name>getProjectionPoint</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>ad9f29ab6a2ec2d445a15a1e63245902f</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>const SbVec3d &amp;</type>
      <name>getProjectionDirection</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a7bc7dbdc50b23e2ba0e758e3547af345</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>getNearDist</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>af7dacec031c3325fd0e459b16a980846</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>getWidth</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a548fc09e3466071a4bcef967f5f62c45</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>getHeight</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>aa88d09ef77cdf2a91b2b6be7b3f982c1</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>getDepth</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>abe6919a344c6307f02dd239caed9eb37</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a7f86cf3fa69f7d2de129860cd7a8e682</anchor>
      <arglist>(FILE *fp) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getViewVolumePlanes</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a4fe16dc06a5c67d4ac710e061dd2972f</anchor>
      <arglist>(SbPlane planes[6]) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>transform</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>aaa31bc923afc5064b7cfc0317291dd8c</anchor>
      <arglist>(const SbDPMatrix &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3d</type>
      <name>getViewUp</name>
      <anchorfile>classSbDPViewVolume.html</anchorfile>
      <anchor>a8c71e7df9cfb7093274061d7fccb51a6</anchor>
      <arglist>(void) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbHeap</name>
    <filename>classSbHeap.html</filename>
    <member kind="function">
      <type></type>
      <name>SbHeap</name>
      <anchorfile>classSbHeap.html</anchorfile>
      <anchor>ac2992274d2b95a4fc4c9e596a43fa810</anchor>
      <arglist>(const SbHeapFuncs &amp;SbHeapFuncs, const int initsize=1024)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbHeap</name>
      <anchorfile>classSbHeap.html</anchorfile>
      <anchor>a82d70ed3e4e280473261ecd68e5f89cc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>emptyHeap</name>
      <anchorfile>classSbHeap.html</anchorfile>
      <anchor>a90933aaa6cf97fe3770944cc7b949c1b</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>size</name>
      <anchorfile>classSbHeap.html</anchorfile>
      <anchor>a8664a6ca3ee93e78bcd5f55edaecf93c</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>add</name>
      <anchorfile>classSbHeap.html</anchorfile>
      <anchor>a391497a9c15341877e0139696e36488e</anchor>
      <arglist>(void *obj)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbHeap.html</anchorfile>
      <anchor>a8a7e532b4747e84aa5de3892e484a08f</anchor>
      <arglist>(const int pos)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbHeap.html</anchorfile>
      <anchor>ab9441203bdf007b2ad839cb66f894111</anchor>
      <arglist>(void *obj)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>extractMin</name>
      <anchorfile>classSbHeap.html</anchorfile>
      <anchor>ac9ca75ef3d29b357807660859c7ff9dd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>getMin</name>
      <anchorfile>classSbHeap.html</anchorfile>
      <anchor>a8e16f8b087f872d7b3d78009c8a2c9f0</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>operator[]</name>
      <anchorfile>classSbHeap.html</anchorfile>
      <anchor>ac6e4b8b6a82325634d3223c02ab286b4</anchor>
      <arglist>(const int idx)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>newWeight</name>
      <anchorfile>classSbHeap.html</anchorfile>
      <anchor>a48c0b4f7e527bb6dbe4139ab88c9e6ba</anchor>
      <arglist>(void *obj, int hpos=-1)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>buildHeap</name>
      <anchorfile>classSbHeap.html</anchorfile>
      <anchor>a26fcc520108e1f46e04a3a9513ab0fcb</anchor>
      <arglist>(SbBool(*progresscb)(float percentage, void *data)=NULL, void *data=NULL)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>traverseHeap</name>
      <anchorfile>classSbHeap.html</anchorfile>
      <anchor>a584bda2162966815974bbfe6ec291d6c</anchor>
      <arglist>(SbBool(*func)(void *, void *), void *userdata) const </arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>SbHeapFuncs</name>
    <filename>structSbHeapFuncs.html</filename>
    <member kind="variable">
      <type>float(*</type>
      <name>eval_func</name>
      <anchorfile>structSbHeapFuncs.html</anchorfile>
      <anchor>a5c73f24b66111ee54c8f54c478ee133e</anchor>
      <arglist>)(void *)</arglist>
    </member>
    <member kind="variable">
      <type>int(*</type>
      <name>get_index_func</name>
      <anchorfile>structSbHeapFuncs.html</anchorfile>
      <anchor>af35c5326d7d98064539f2474cfe054e5</anchor>
      <arglist>)(void *)</arglist>
    </member>
    <member kind="variable">
      <type>void(*</type>
      <name>set_index_func</name>
      <anchorfile>structSbHeapFuncs.html</anchorfile>
      <anchor>a52baccb47c85e89e17c422fc18881e8e</anchor>
      <arglist>)(void *, int)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbImage</name>
    <filename>classSbImage.html</filename>
    <member kind="function">
      <type></type>
      <name>SbImage</name>
      <anchorfile>classSbImage.html</anchorfile>
      <anchor>a550b12717f54edaea466e959d2980d89</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbImage</name>
      <anchorfile>classSbImage.html</anchorfile>
      <anchor>a778084cf728861bd8d0914ea2fcba96e</anchor>
      <arglist>(const unsigned char *bytes, const SbVec2s &amp;size, const int bytesperpixel)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbImage</name>
      <anchorfile>classSbImage.html</anchorfile>
      <anchor>a3c65278b7e9875b5b3b96cd5f40811ec</anchor>
      <arglist>(const unsigned char *bytes, const SbVec3s &amp;size, const int bytesperpixel)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbImage</name>
      <anchorfile>classSbImage.html</anchorfile>
      <anchor>a32a64d8424b7754e4f870e8afb7757fa</anchor>
      <arglist>(const SbImage &amp;image)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbImage</name>
      <anchorfile>classSbImage.html</anchorfile>
      <anchor>a79f9dcc12b3fe1c11f2d4fc289610f1c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValue</name>
      <anchorfile>classSbImage.html</anchorfile>
      <anchor>a8c119ce77ae392580d3f4776adeb72ce</anchor>
      <arglist>(const SbVec2s &amp;size, const int bytesperpixel, const unsigned char *bytes)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValue</name>
      <anchorfile>classSbImage.html</anchorfile>
      <anchor>a1d234ffdf7ae23b249cd9978044c7e69</anchor>
      <arglist>(const SbVec3s &amp;size, const int bytesperpixel, const unsigned char *bytes)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValuePtr</name>
      <anchorfile>classSbImage.html</anchorfile>
      <anchor>a5393d25e565e123ebc889055612592bf</anchor>
      <arglist>(const SbVec2s &amp;size, const int bytesperpixel, const unsigned char *bytes)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValuePtr</name>
      <anchorfile>classSbImage.html</anchorfile>
      <anchor>a4cdc0f3a01dc4651a4aa9794d58357d2</anchor>
      <arglist>(const SbVec3s &amp;size, const int bytesperpixel, const unsigned char *bytes)</arglist>
    </member>
    <member kind="function">
      <type>unsigned char *</type>
      <name>getValue</name>
      <anchorfile>classSbImage.html</anchorfile>
      <anchor>acb2f388d0b8578c5404c4bf1dd5fffd9</anchor>
      <arglist>(SbVec2s &amp;size, int &amp;bytesperpixel) const </arglist>
    </member>
    <member kind="function">
      <type>unsigned char *</type>
      <name>getValue</name>
      <anchorfile>classSbImage.html</anchorfile>
      <anchor>aba15636b7fa4e247ac28d3d5117ffb94</anchor>
      <arglist>(SbVec3s &amp;size, int &amp;bytesperpixel) const </arglist>
    </member>
    <member kind="function">
      <type>SbVec3s</type>
      <name>getSize</name>
      <anchorfile>classSbImage.html</anchorfile>
      <anchor>a71bb34fa531a99feda2afbd471451f5a</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>readFile</name>
      <anchorfile>classSbImage.html</anchorfile>
      <anchor>a869f0fa0bfe5b58bf31e8c00bc0dc6c0</anchor>
      <arglist>(const SbString &amp;filename, const SbString *const *searchdirectories=NULL, const int numdirectories=0)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbImage.html</anchorfile>
      <anchor>ac55f4c3fc5de35ac845092d5c8100f39</anchor>
      <arglist>(const SbImage &amp;image) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbImage.html</anchorfile>
      <anchor>a6e2bbeae4c05a1d6246b7adf5ccb3500</anchor>
      <arglist>(const SbImage &amp;image) const </arglist>
    </member>
    <member kind="function">
      <type>SbImage &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbImage.html</anchorfile>
      <anchor>a5f21488a4af52f41f22015396315f6e8</anchor>
      <arglist>(const SbImage &amp;image)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>hasData</name>
      <anchorfile>classSbImage.html</anchorfile>
      <anchor>a8de2c2de07a2a77896943adf637e49f2</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>readLock</name>
      <anchorfile>classSbImage.html</anchorfile>
      <anchor>a53e32fee8d919ea93694cc057901b9e8</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>readUnlock</name>
      <anchorfile>classSbImage.html</anchorfile>
      <anchor>a05425d2892c309c392a5287aac4ade46</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>scheduleReadFile</name>
      <anchorfile>classSbImage.html</anchorfile>
      <anchor>aeb76fecd85ad2b627f4b3bd247e1df3a</anchor>
      <arglist>(SbImageScheduleReadCB *cb, void *closure, const SbString &amp;filename, const SbString *const *searchdirectories=NULL, const int numdirectories=0)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>addReadImageCB</name>
      <anchorfile>classSbImage.html</anchorfile>
      <anchor>a24b1dd5bb0bfa78a89db2363f822561c</anchor>
      <arglist>(SbImageReadImageCB *cb, void *closure)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>removeReadImageCB</name>
      <anchorfile>classSbImage.html</anchorfile>
      <anchor>a57f25c820e03b12c28e2775a69ccebea</anchor>
      <arglist>(SbImageReadImageCB *cb, void *closure)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SbString</type>
      <name>searchForFile</name>
      <anchorfile>classSbImage.html</anchorfile>
      <anchor>a1155f75c7b9aa27fcd0b004bde938704</anchor>
      <arglist>(const SbString &amp;basename, const SbString *const *dirlist, const int numdirs)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbIntList</name>
    <filename>classSbIntList.html</filename>
    <base>SbPList</base>
    <member kind="function">
      <type></type>
      <name>SbIntList</name>
      <anchorfile>classSbIntList.html</anchorfile>
      <anchor>a77787425ccf57683a584e891c16f783b</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbIntList</name>
      <anchorfile>classSbIntList.html</anchorfile>
      <anchor>afca9c9369d5fe31414c0b068772fe0bf</anchor>
      <arglist>(const int sizehint)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbIntList.html</anchorfile>
      <anchor>aa7c78267d6164e2e3d9550e7c1c023c0</anchor>
      <arglist>(const int item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbIntList.html</anchorfile>
      <anchor>a8c36ff744a7dc5749699447d696f77bc</anchor>
      <arglist>(const int item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbIntList.html</anchorfile>
      <anchor>a832e8fa620c7101da392b1a77c3bb9bf</anchor>
      <arglist>(const int item, const int addbefore)</arglist>
    </member>
    <member kind="function">
      <type>int &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbIntList.html</anchorfile>
      <anchor>ae439fa049157086bd96326ae5d698bc1</anchor>
      <arglist>(const int idx) const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbPList</name>
      <anchorfile>classSbPList.html</anchorfile>
      <anchor>aa7f2d079fc9b7f79159c52bfc84c1903</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbPList</name>
      <anchorfile>classSbPList.html</anchorfile>
      <anchor>af811d0ca4b528e41ded787620a098302</anchor>
      <arglist>(const SbPList &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbPList</name>
      <anchorfile>classSbPList.html</anchorfile>
      <anchor>abd1d6b798ff7e7ca94a2c0cd421a99b5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbPList.html</anchorfile>
      <anchor>afde90b2b3d0a9f12bdf0525bc6f8dd95</anchor>
      <arglist>(const SbPList &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbPList &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbPList.html</anchorfile>
      <anchor>aebfa0b8e1ecc80d7fa4b290bcc0a63d4</anchor>
      <arglist>(const SbPList &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbPList.html</anchorfile>
      <anchor>a74b60d94666a2e26bfd8d594093171b3</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbPList.html</anchorfile>
      <anchor>a61404440e153af0870eac6183d09fc04</anchor>
      <arglist>(void *item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbPList.html</anchorfile>
      <anchor>a2a1636490324dc243990114af901d656</anchor>
      <arglist>(void *item) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbPList.html</anchorfile>
      <anchor>af500b13baee20036c51b7746c9b046b0</anchor>
      <arglist>(void *item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbPList.html</anchorfile>
      <anchor>a4e876aa0634c39c25d6492a70691341d</anchor>
      <arglist>(void *item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbPList.html</anchorfile>
      <anchor>a6a4deead2d652da76afce4a6d6cbf755</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbPList.html</anchorfile>
      <anchor>a85f37433e030fb1845a1f210098b805d</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbPList.html</anchorfile>
      <anchor>accb7298ca284c3e7bb2a7bff3706c9a4</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbPList.html</anchorfile>
      <anchor>ac32c857e4308dd6b638275d90ea6fc60</anchor>
      <arglist>(const int length, const int fit=0)</arglist>
    </member>
    <member kind="function">
      <type>void **</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbPList.html</anchorfile>
      <anchor>ab29c4fcd0c37d4356fa8d776ee3dc506</anchor>
      <arglist>(const int start=0) const </arglist>
    </member>
    <member kind="function">
      <type>void *&amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbPList.html</anchorfile>
      <anchor>a9b4d944db89e8d9faaadcdc86a20970d</anchor>
      <arglist>(const int index) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbPList.html</anchorfile>
      <anchor>a00666511202c8b820dd86b102230d9da</anchor>
      <arglist>(const SbPList &amp;l) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbPList.html</anchorfile>
      <anchor>a0d9b46c3f7278629cf2a01d57e1e1912</anchor>
      <arglist>(const SbPList &amp;l) const </arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>get</name>
      <anchorfile>classSbPList.html</anchorfile>
      <anchor>aa426c733e4fe6caf207f8e744d0ccd79</anchor>
      <arglist>(const int index) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set</name>
      <anchorfile>classSbPList.html</anchorfile>
      <anchor>a2594a4326065d15ec4bcb3104b4e74b6</anchor>
      <arglist>(const int index, void *item)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbPList.html</anchorfile>
      <anchor>a28744f335b05d2e87bbc000f39a9e241</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbPList.html</anchorfile>
      <anchor>a26537c96975f9cc9d781ea8cc5f68b4a</anchor>
      <arglist>(void) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbLine</name>
    <filename>classSbLine.html</filename>
    <member kind="function">
      <type></type>
      <name>SbLine</name>
      <anchorfile>classSbLine.html</anchorfile>
      <anchor>aa8db4c11f19c63d8431002d34edaa515</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbLine</name>
      <anchorfile>classSbLine.html</anchorfile>
      <anchor>a5ab86e886ad329357c68bbb67c92d53c</anchor>
      <arglist>(const SbVec3f &amp;origin, const SbVec3f &amp;point)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValue</name>
      <anchorfile>classSbLine.html</anchorfile>
      <anchor>a6beb09e9ca8cf702ddcf0b2a56793a1d</anchor>
      <arglist>(const SbVec3f &amp;origin, const SbVec3f &amp;point)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPosDir</name>
      <anchorfile>classSbLine.html</anchorfile>
      <anchor>ab4910d8a37e4e80c80eabc4caee321e6</anchor>
      <arglist>(const SbVec3f &amp;position, const SbVec3f &amp;direction)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>getClosestPoints</name>
      <anchorfile>classSbLine.html</anchorfile>
      <anchor>a23f8cd0d0f777342689530b43ed37bc4</anchor>
      <arglist>(const SbLine &amp;line2, SbVec3f &amp;ptOnThis, SbVec3f &amp;ptOnLine2) const </arglist>
    </member>
    <member kind="function">
      <type>SbVec3f</type>
      <name>getClosestPoint</name>
      <anchorfile>classSbLine.html</anchorfile>
      <anchor>afc49eedb145ef1991c44f28b5917bcd0</anchor>
      <arglist>(const SbVec3f &amp;point) const </arglist>
    </member>
    <member kind="function">
      <type>const SbVec3f &amp;</type>
      <name>getPosition</name>
      <anchorfile>classSbLine.html</anchorfile>
      <anchor>a0443fe92e89186972fdc2d373bb14985</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>const SbVec3f &amp;</type>
      <name>getDirection</name>
      <anchorfile>classSbLine.html</anchorfile>
      <anchor>aa7fd52fea972cb036d0143b40343c4e2</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classSbLine.html</anchorfile>
      <anchor>a9cd8e3b4c988f491a1b4df3857dcb993</anchor>
      <arglist>(FILE *file) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbLineProjector</name>
    <filename>classSbLineProjector.html</filename>
    <base>SbProjector</base>
    <member kind="function">
      <type></type>
      <name>SbLineProjector</name>
      <anchorfile>classSbLineProjector.html</anchorfile>
      <anchor>a62208e6694d0c49d5f5f2285253dd2c6</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbProjector *</type>
      <name>copy</name>
      <anchorfile>classSbLineProjector.html</anchorfile>
      <anchor>a0e27b2257ff05292cf44c0ad5fff8798</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbVec3f</type>
      <name>project</name>
      <anchorfile>classSbLineProjector.html</anchorfile>
      <anchor>a37d1853c90acf15a9f1b89f5ce916328</anchor>
      <arglist>(const SbVec2f &amp;point)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>tryProject</name>
      <anchorfile>classSbLineProjector.html</anchorfile>
      <anchor>a30d31ed062b21ede8aba6d6efb7cabcd</anchor>
      <arglist>(const SbVec2f &amp;point, const float epsilon, SbVec3f &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setLine</name>
      <anchorfile>classSbLineProjector.html</anchorfile>
      <anchor>a67f4544fb46670d4a5a1f7d19f07a3c9</anchor>
      <arglist>(const SbLine &amp;line)</arglist>
    </member>
    <member kind="function">
      <type>const SbLine &amp;</type>
      <name>getLine</name>
      <anchorfile>classSbLineProjector.html</anchorfile>
      <anchor>a9cbcedfbc8a50fae937f50c5ea58d230</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbVec3f</type>
      <name>getVector</name>
      <anchorfile>classSbLineProjector.html</anchorfile>
      <anchor>a0ac417f0ecb8ba48885eb38797cd8cb0</anchor>
      <arglist>(const SbVec2f &amp;viewpos1, const SbVec2f &amp;viewpos2)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbVec3f</type>
      <name>getVector</name>
      <anchorfile>classSbLineProjector.html</anchorfile>
      <anchor>a69cdc927750e6a129219255de434f535</anchor>
      <arglist>(const SbVec2f &amp;viewpos)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setStartPosition</name>
      <anchorfile>classSbLineProjector.html</anchorfile>
      <anchor>a1a5e94503de9afdc59070e6c2e3da3fc</anchor>
      <arglist>(const SbVec2f &amp;viewpos)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setStartPosition</name>
      <anchorfile>classSbLineProjector.html</anchorfile>
      <anchor>ad03cee2f1c3908b186d9373dd320b6c5</anchor>
      <arglist>(const SbVec3f &amp;point)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setWorkingSpace</name>
      <anchorfile>classSbProjector.html</anchorfile>
      <anchor>acc11d72e261a3a27304377d673e48b21</anchor>
      <arglist>(const SbMatrix &amp;space)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbLine</type>
      <name>line</name>
      <anchorfile>classSbLineProjector.html</anchorfile>
      <anchor>a941a98593075b2dd72aefe27389675dd</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbVec3f</type>
      <name>lastPoint</name>
      <anchorfile>classSbLineProjector.html</anchorfile>
      <anchor>a933b480d6eee70fa3dea6a5fcf4aae5b</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbList</name>
    <filename>classSbList.html</filename>
    <templarg>Type</templarg>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab18cad4eb2d06030cd564917a8c331f4</anchor>
      <arglist>(const int sizehint=DEFAULTSIZE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a189665fb116eed3812bad8a2da247d3d</anchor>
      <arglist>(const SbList&lt; Type &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbList</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae7c20239e83b64aec15b53273622618d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad35a42495f3ecb04a19a387dc468ce92</anchor>
      <arglist>(const SbList&lt; Type &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SbList&lt; Type &gt; &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a54522df5b70fac1df3c4eaa8808ccbc6</anchor>
      <arglist>(const SbList&lt; Type &gt; &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>fit</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ad92621e814796448b9fe0990bdb959ab</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae98b0264bc9a47902cb36386dde1341c</anchor>
      <arglist>(const Type item)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a965b16dcd3df1052b9926312905f87ae</anchor>
      <arglist>(const Type item) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ada8fe73c9935bd004fc2b9c07bc68638</anchor>
      <arglist>(const Type item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab4817441dd2125c7dc22b7b6d3d84155</anchor>
      <arglist>(const Type item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aa3ca1bc32dde2755b354dd250fbed1da</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFast</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a5c53be30fa6d84a05676128ff4f1e4b3</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a8527386d48de36971b2460f61e4873e7</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a0dc149facedb4f0ac8c1ccb2d628ed1d</anchor>
      <arglist>(const int length, const int dofit=0)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>push</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af8b64ab9fa5562d1ae179a2ba3c825fe</anchor>
      <arglist>(const Type item)</arglist>
    </member>
    <member kind="function">
      <type>Type</type>
      <name>pop</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a23a3b993144dfe304eee41cb555549f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const Type *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ab28a59b1a848e2e553f18ecd08527a58</anchor>
      <arglist>(const int start=0) const </arglist>
    </member>
    <member kind="function">
      <type>Type</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>ae520560666e824264137d148e824243e</anchor>
      <arglist>(const int index) const </arglist>
    </member>
    <member kind="function">
      <type>Type &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a61f700e59d16e5d793d9ba97f071e822</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a974b3f9163c9c6b7960d1c73ee2dc4e8</anchor>
      <arglist>(const SbList&lt; Type &gt; &amp;l) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>afcd87df8458e16206ff4c7d5c5ce303e</anchor>
      <arglist>(const SbList&lt; Type &gt; &amp;l) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ensureCapacity</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>af046ab4c15fea0db879ed5e8388b9156</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>expand</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>aed7f50965b7b3a655b8013c440313980</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>int</type>
      <name>getArraySize</name>
      <anchorfile>classSbList.html</anchorfile>
      <anchor>a528ac3389f454a8206bca3b166d2a5f8</anchor>
      <arglist>(void) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbMatrix</name>
    <filename>classSbMatrix.html</filename>
    <member kind="function">
      <type></type>
      <name>SbMatrix</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>aa9c543c99277c8efe81ecaa27d2977a3</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbMatrix</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>af4f62a6e3d63538dc5660b59592f3559</anchor>
      <arglist>(const float a11, const float a12, const float a13, const float a14, const float a21, const float a22, const float a23, const float a24, const float a31, const float a32, const float a33, const float a34, const float a41, const float a42, const float a43, const float a44)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbMatrix</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a11cc61c8a398ca99f727c24e9dac5145</anchor>
      <arglist>(const SbMat &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbMatrix</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a14a38bb0c23bd9899b73e1cf6d42674f</anchor>
      <arglist>(const SbMat *matrix)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbMatrix</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a8e36c51695b7f881e6527a0171e4b59b</anchor>
      <arglist>(const SbDPMatrix &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbMatrix</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a56c2af917e531b6a2c689277da0e5e40</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValue</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a823e51aa6487c9445f08520664bb0f24</anchor>
      <arglist>(const SbMat &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValue</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a336dcb30ce4faaac2f0ad661b3c611d4</anchor>
      <arglist>(const SbDPMatrix &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValue</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a64f74a53cfa9fa179febed9c526a5e5a</anchor>
      <arglist>(const float *pMat)</arglist>
    </member>
    <member kind="function">
      <type>const SbMat &amp;</type>
      <name>getValue</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a985e8cd7ac8771a0fc4da0579932d19c</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>makeIdentity</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>aa3932a07fef33751bea1d2afad98dd80</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRotate</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>ad980a0a21520443af5f27ad2c3a0ac4d</anchor>
      <arglist>(const SbRotation &amp;q)</arglist>
    </member>
    <member kind="function">
      <type>SbMatrix</type>
      <name>inverse</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a4e99f030b83ae08e885ed43558a1b9b5</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>det3</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a39aa5544c14e36f3090be4284a3ba2a6</anchor>
      <arglist>(int r1, int r2, int r3, int c1, int c2, int c3) const </arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>det3</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a8f7fddeb6c22a4e8b3170b4400e4512d</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>det4</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>ae5de806e797f203628e8fae31a653c32</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>equals</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a69ddc3035f28bcce3457c49b886f75f5</anchor>
      <arglist>(const SbMatrix &amp;m, float tolerance) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getValue</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>ad5b9d0fc68e6657036e34cf941768adb</anchor>
      <arglist>(SbMat &amp;m) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setScale</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>ac3fe68df7dff290a61a29ee3494559fb</anchor>
      <arglist>(const float s)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setScale</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a20666edc6bd3449c8121213504e2d779</anchor>
      <arglist>(const SbVec3f &amp;s)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTranslate</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a9e7499122cfa98b5e3eec4832248343d</anchor>
      <arglist>(const SbVec3f &amp;t)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTransform</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>ab213f7106629056c14f92d7cca1b0e40</anchor>
      <arglist>(const SbVec3f &amp;t, const SbRotation &amp;r, const SbVec3f &amp;s)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTransform</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a35048991968e198707e5186ac9c12c68</anchor>
      <arglist>(const SbVec3f &amp;t, const SbRotation &amp;r, const SbVec3f &amp;s, const SbRotation &amp;so)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTransform</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>aaa26b5ff6e108f1ad44552320dec9375</anchor>
      <arglist>(const SbVec3f &amp;translation, const SbRotation &amp;rotation, const SbVec3f &amp;scaleFactor, const SbRotation &amp;scaleOrientation, const SbVec3f &amp;center)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getTransform</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a2ab231640a3a3211716de76c07606e70</anchor>
      <arglist>(SbVec3f &amp;t, SbRotation &amp;r, SbVec3f &amp;s, SbRotation &amp;so) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getTransform</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a3ddfbb7b43f8d347717cc6621d5457d1</anchor>
      <arglist>(SbVec3f &amp;translation, SbRotation &amp;rotation, SbVec3f &amp;scaleFactor, SbRotation &amp;scaleOrientation, const SbVec3f &amp;center) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>factor</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>aefdcc23eccf6de5cbf7eafd230f206cc</anchor>
      <arglist>(SbMatrix &amp;r, SbVec3f &amp;s, SbMatrix &amp;u, SbVec3f &amp;t, SbMatrix &amp;proj)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>LUDecomposition</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a44442a984a6db189e521b8e599187eb3</anchor>
      <arglist>(int index[4], float &amp;d)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>LUBackSubstitution</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>ad680536320c79d550eeb1e9b4ce8a90d</anchor>
      <arglist>(int index[4], float b[4]) const </arglist>
    </member>
    <member kind="function">
      <type>SbMatrix</type>
      <name>transpose</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>aa0ef21dc210ce541751d3dd389be6074</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SbMatrix &amp;</type>
      <name>multRight</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a95c83d6772896a1c592d9f02ef9b9b73</anchor>
      <arglist>(const SbMatrix &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>SbMatrix &amp;</type>
      <name>multLeft</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a9fb67deb0eba537ad84e4a7064ced20d</anchor>
      <arglist>(const SbMatrix &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>multMatrixVec</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>ad96d19c79f60edf82502db778af0c10e</anchor>
      <arglist>(const SbVec3f &amp;src, SbVec3f &amp;dst) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>multVecMatrix</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>af7fb9a0687aefbc3a853b87923bb538d</anchor>
      <arglist>(const SbVec3f &amp;src, SbVec3f &amp;dst) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>multDirMatrix</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>ad29df20d6916d82dbf90290a83a7d9a4</anchor>
      <arglist>(const SbVec3f &amp;src, SbVec3f &amp;dst) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>multLineMatrix</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a8ee6706c8ddadca45266b6217bec8ab4</anchor>
      <arglist>(const SbLine &amp;src, SbLine &amp;dst) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>multVecMatrix</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a725fdbc6bb273e222544ec4f242912e5</anchor>
      <arglist>(const SbVec4f &amp;src, SbVec4f &amp;dst) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a2170946f1261bb3cb3e43dbc07a7d965</anchor>
      <arglist>(FILE *fp) const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator float *</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a2e9cb965db606983daab26f713cd85bd</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator SbMat &amp;</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a68ebdb48cc42675a9608de80ac995b03</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>float *</type>
      <name>operator[]</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>ad01011ae53be487a1a5951ee501d81f7</anchor>
      <arglist>(int i)</arglist>
    </member>
    <member kind="function">
      <type>const float *</type>
      <name>operator[]</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>ac568d42a060b5b72a35d6f8795279161</anchor>
      <arglist>(int i) const </arglist>
    </member>
    <member kind="function">
      <type>SbMatrix &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>ab923719276439757ba9c351af0d48645</anchor>
      <arglist>(const SbMat &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>SbMatrix &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a53b9da1c1ed8a4aabe50962719b16f21</anchor>
      <arglist>(const SbMatrix &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>SbMatrix &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a2f48f009fcc63c5ccb7a7c49bc80d03a</anchor>
      <arglist>(const SbRotation &amp;q)</arglist>
    </member>
    <member kind="function">
      <type>SbMatrix &amp;</type>
      <name>operator*=</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a2cde5f5b6c11272d146b8684a4c87823</anchor>
      <arglist>(const SbMatrix &amp;m)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SbMatrix</type>
      <name>identity</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>adc24591ea5071d7d8f18eee7066c36e3</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="friend">
      <type>friend SbMatrix</type>
      <name>operator*</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>af6ee85af9ea51cca2e159b777aeafacc</anchor>
      <arglist>(const SbMatrix &amp;m1, const SbMatrix &amp;m2)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator==</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>abf8843860b5e03a0061ebe2ec9d8a9ad</anchor>
      <arglist>(const SbMatrix &amp;m1, const SbMatrix &amp;m2)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator!=</name>
      <anchorfile>classSbMatrix.html</anchorfile>
      <anchor>a00563ae0cae392aefedeb3a6f77ce9f4</anchor>
      <arglist>(const SbMatrix &amp;m1, const SbMatrix &amp;m2)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbName</name>
    <filename>classSbName.html</filename>
    <member kind="function">
      <type></type>
      <name>SbName</name>
      <anchorfile>classSbName.html</anchorfile>
      <anchor>ad6a4c7d4f516d74b22a0f054065c4d1b</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbName</name>
      <anchorfile>classSbName.html</anchorfile>
      <anchor>ab724be41e08ba30cbe70bca6bb0f6920</anchor>
      <arglist>(const char *namestring)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbName</name>
      <anchorfile>classSbName.html</anchorfile>
      <anchor>ab523d9d8a9ebe1a7e7d7206579cba24f</anchor>
      <arglist>(const SbString &amp;str)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbName</name>
      <anchorfile>classSbName.html</anchorfile>
      <anchor>a29e5b8239dd822004d5a332bfecec96e</anchor>
      <arglist>(const SbName &amp;name)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbName</name>
      <anchorfile>classSbName.html</anchorfile>
      <anchor>a727ed1c947b2f9a7f00216489af3fa5d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>getString</name>
      <anchorfile>classSbName.html</anchorfile>
      <anchor>a3b56356c5c5f8e3fabc0dbc47c6499fe</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbName.html</anchorfile>
      <anchor>a8922348ac9a89bd418ec7cc580d7b037</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!</name>
      <anchorfile>classSbName.html</anchorfile>
      <anchor>a4dd95424ad0fc82a5dd7ea7b3e13738e</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>operator const char *</name>
      <anchorfile>classSbName.html</anchorfile>
      <anchor>a11223b37f380585bc94e490ff300091f</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SbBool</type>
      <name>isIdentStartChar</name>
      <anchorfile>classSbName.html</anchorfile>
      <anchor>a8542c60491baad59191fa04c8f05c7ff</anchor>
      <arglist>(const char c)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SbBool</type>
      <name>isIdentChar</name>
      <anchorfile>classSbName.html</anchorfile>
      <anchor>a3f201ffe519350d5ae06f31fc30ed9c9</anchor>
      <arglist>(const char c)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SbBool</type>
      <name>isBaseNameStartChar</name>
      <anchorfile>classSbName.html</anchorfile>
      <anchor>ab4e8fb488f254fda26e22055223ecf0e</anchor>
      <arglist>(const char c)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SbBool</type>
      <name>isBaseNameChar</name>
      <anchorfile>classSbName.html</anchorfile>
      <anchor>ad4c80d5dd355792ef2406f09d47b42de</anchor>
      <arglist>(const char c)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const SbName &amp;</type>
      <name>empty</name>
      <anchorfile>classSbName.html</anchorfile>
      <anchor>a20587288b45a68e953a08428640afcc9</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator==</name>
      <anchorfile>classSbName.html</anchorfile>
      <anchor>a1a9e2e87224f997e7b85ea4270f31491</anchor>
      <arglist>(const SbName &amp;lhs, const char *rhs)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator==</name>
      <anchorfile>classSbName.html</anchorfile>
      <anchor>a11b92ad49c0bd13adc4cfa5bbaa4ff0d</anchor>
      <arglist>(const char *lhs, const SbName &amp;rhs)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator==</name>
      <anchorfile>classSbName.html</anchorfile>
      <anchor>af664e0fe96b220633d87506098c586ff</anchor>
      <arglist>(const SbName &amp;lhs, const SbName &amp;rhs)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator!=</name>
      <anchorfile>classSbName.html</anchorfile>
      <anchor>a817a20561fe7a7cc170a871975806296</anchor>
      <arglist>(const SbName &amp;lhs, const char *rhs)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator!=</name>
      <anchorfile>classSbName.html</anchorfile>
      <anchor>aed52cb7e045ed247aba2ca9e0715c031</anchor>
      <arglist>(const char *lhs, const SbName &amp;rhs)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator!=</name>
      <anchorfile>classSbName.html</anchorfile>
      <anchor>a29000d9ba142f3ad44fb42b0c9b9baf3</anchor>
      <arglist>(const SbName &amp;lhs, const SbName &amp;rhs)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbOctTree</name>
    <filename>classSbOctTree.html</filename>
    <member kind="function">
      <type></type>
      <name>SbOctTree</name>
      <anchorfile>classSbOctTree.html</anchorfile>
      <anchor>add70351f00eacc285ac91c8394af6f84</anchor>
      <arglist>(const SbBox3f &amp;bbox, const SbOctTreeFuncs &amp;itemfuncs, const int maxitemspernode=64)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbOctTree</name>
      <anchorfile>classSbOctTree.html</anchorfile>
      <anchor>ab9a58a484f6eacacce9b5d91943abd7b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addItem</name>
      <anchorfile>classSbOctTree.html</anchorfile>
      <anchor>abe0d819501c3e600783942cffb2b157f</anchor>
      <arglist>(void *const item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSbOctTree.html</anchorfile>
      <anchor>a0960def43c29ed624d0da49241db7d77</anchor>
      <arglist>(void *const item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>findItems</name>
      <anchorfile>classSbOctTree.html</anchorfile>
      <anchor>a10d23e833a1d3a1c45eee2ec7808fef0</anchor>
      <arglist>(const SbVec3f &amp;pos, SbList&lt; void * &gt; &amp;destarray, const SbBool removeduplicates=TRUE) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>findItems</name>
      <anchorfile>classSbOctTree.html</anchorfile>
      <anchor>ac7ab5ad89d43d84fc0b222b83813bb60</anchor>
      <arglist>(const SbBox3f &amp;box, SbList&lt; void * &gt; &amp;destarray, const SbBool removeduplicates=TRUE) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>findItems</name>
      <anchorfile>classSbOctTree.html</anchorfile>
      <anchor>a666126ccabc9c9b144d8134c708eea9c</anchor>
      <arglist>(const SbSphere &amp;sphere, SbList&lt; void * &gt; &amp;destarray, const SbBool removeduplicates=TRUE) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>findItems</name>
      <anchorfile>classSbOctTree.html</anchorfile>
      <anchor>a74610e46f323032c732ce889537071e9</anchor>
      <arglist>(const SbPlane *const planes, const int numplanes, SbList&lt; void * &gt; &amp;destarray, const SbBool removeduplicates=TRUE) const </arglist>
    </member>
    <member kind="function">
      <type>const SbBox3f &amp;</type>
      <name>getBoundingBox</name>
      <anchorfile>classSbOctTree.html</anchorfile>
      <anchor>a88265002b10b254686e652d04369f9aa</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clear</name>
      <anchorfile>classSbOctTree.html</anchorfile>
      <anchor>a40ce23dda004f6b4a6c97a488286b0c7</anchor>
      <arglist>(void)</arglist>
    </member>
  </compound>
  <compound kind="struct">
    <name>SbOctTreeFuncs</name>
    <filename>structSbOctTreeFuncs.html</filename>
    <member kind="variable">
      <type>SbBool(*</type>
      <name>ptinsidefunc</name>
      <anchorfile>structSbOctTreeFuncs.html</anchorfile>
      <anchor>a5450fad1a556bcb0788817e5a39fc16e</anchor>
      <arglist>)(void *const item, const SbVec3f &amp;pt)</arglist>
    </member>
    <member kind="variable">
      <type>SbBool(*</type>
      <name>insideboxfunc</name>
      <anchorfile>structSbOctTreeFuncs.html</anchorfile>
      <anchor>a19dbec3e9e9c84894d8cad53143af732</anchor>
      <arglist>)(void *const item, const SbBox3f &amp;box)</arglist>
    </member>
    <member kind="variable">
      <type>SbBool(*</type>
      <name>insidespherefunc</name>
      <anchorfile>structSbOctTreeFuncs.html</anchorfile>
      <anchor>a39db96f6e92c0ca5734f0ae3158a75a7</anchor>
      <arglist>)(void *const item, const SbSphere &amp;sphere)</arglist>
    </member>
    <member kind="variable">
      <type>SbBool(*</type>
      <name>insideplanesfunc</name>
      <anchorfile>structSbOctTreeFuncs.html</anchorfile>
      <anchor>a755d9f3c5dcab3bfbaf8ac46c17c537f</anchor>
      <arglist>)(void *const item, const SbPlane *const planes, const int numplanes)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbPlane</name>
    <filename>classSbPlane.html</filename>
    <member kind="function">
      <type></type>
      <name>SbPlane</name>
      <anchorfile>classSbPlane.html</anchorfile>
      <anchor>a1db5bae636297d29cc50435cd2f85cde</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbPlane</name>
      <anchorfile>classSbPlane.html</anchorfile>
      <anchor>a9d318bb4c7e48e81dfee4248048b3c0b</anchor>
      <arglist>(const SbVec3f &amp;normal, const float D)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbPlane</name>
      <anchorfile>classSbPlane.html</anchorfile>
      <anchor>acb9fc24accebfae55bc56cd1deda2aa7</anchor>
      <arglist>(const SbVec3f &amp;p0, const SbVec3f &amp;p1, const SbVec3f &amp;p2)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbPlane</name>
      <anchorfile>classSbPlane.html</anchorfile>
      <anchor>aed3e3d54f30693e031efd3373f35a25c</anchor>
      <arglist>(const SbVec3f &amp;normal, const SbVec3f &amp;point)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>offset</name>
      <anchorfile>classSbPlane.html</anchorfile>
      <anchor>a324e8467ece2b14d3cd993d471862a6e</anchor>
      <arglist>(const float d)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbPlane.html</anchorfile>
      <anchor>a3fdc7674d58978e6084aeaa9904bc45b</anchor>
      <arglist>(const SbLine &amp;l, SbVec3f &amp;intersection) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>transform</name>
      <anchorfile>classSbPlane.html</anchorfile>
      <anchor>a383bc77412bbf7173e96a8e14e5a3325</anchor>
      <arglist>(const SbMatrix &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isInHalfSpace</name>
      <anchorfile>classSbPlane.html</anchorfile>
      <anchor>a06ed999695986b64637e7259ed08e025</anchor>
      <arglist>(const SbVec3f &amp;point) const </arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getDistance</name>
      <anchorfile>classSbPlane.html</anchorfile>
      <anchor>ac0edd1b836dc4a1b82b30e2022c96af4</anchor>
      <arglist>(const SbVec3f &amp;point) const </arglist>
    </member>
    <member kind="function">
      <type>const SbVec3f &amp;</type>
      <name>getNormal</name>
      <anchorfile>classSbPlane.html</anchorfile>
      <anchor>a406e0a08d2cf669cdb6d46985451e0c3</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getDistanceFromOrigin</name>
      <anchorfile>classSbPlane.html</anchorfile>
      <anchor>a866c4110060e528e8c97a1bc68c87942</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classSbPlane.html</anchorfile>
      <anchor>ae2473004750eecc7ad898be2683d13f3</anchor>
      <arglist>(FILE *file) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbPlane.html</anchorfile>
      <anchor>ad1c37626dab205b1adcfcd17d7383f48</anchor>
      <arglist>(const SbPlane &amp;pl, SbLine &amp;line) const </arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator==</name>
      <anchorfile>classSbPlane.html</anchorfile>
      <anchor>a8830930d3c1f38ec5d41cc9b5416a142</anchor>
      <arglist>(const SbPlane &amp;p1, const SbPlane &amp;p2)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator!=</name>
      <anchorfile>classSbPlane.html</anchorfile>
      <anchor>a45b6be8ea7abb92fa999a67e5724bd4b</anchor>
      <arglist>(const SbPlane &amp;p1, const SbPlane &amp;p2)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbPlaneProjector</name>
    <filename>classSbPlaneProjector.html</filename>
    <base>SbProjector</base>
    <member kind="function">
      <type></type>
      <name>SbPlaneProjector</name>
      <anchorfile>classSbPlaneProjector.html</anchorfile>
      <anchor>a17fb773d8a14e7c0a2099cf062f41f44</anchor>
      <arglist>(const SbBool orient=FALSE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbPlaneProjector</name>
      <anchorfile>classSbPlaneProjector.html</anchorfile>
      <anchor>a3ef8017b79f7ddb0114cf1b4ac2cdcdc</anchor>
      <arglist>(const SbPlane &amp;plane, const SbBool orient=FALSE)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbProjector *</type>
      <name>copy</name>
      <anchorfile>classSbPlaneProjector.html</anchorfile>
      <anchor>ae3f3b295ffcddc449ed87884696cc22a</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbVec3f</type>
      <name>project</name>
      <anchorfile>classSbPlaneProjector.html</anchorfile>
      <anchor>af53fe67381ccac9b29de56c243ab5243</anchor>
      <arglist>(const SbVec2f &amp;point)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>tryProject</name>
      <anchorfile>classSbPlaneProjector.html</anchorfile>
      <anchor>a56924db7500b49c135112a478e0544ba</anchor>
      <arglist>(const SbVec2f &amp;point, const float epsilon, SbVec3f &amp;result)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPlane</name>
      <anchorfile>classSbPlaneProjector.html</anchorfile>
      <anchor>a87b6cc3c0b0081f6794283c08bf6a815</anchor>
      <arglist>(const SbPlane &amp;plane)</arglist>
    </member>
    <member kind="function">
      <type>const SbPlane &amp;</type>
      <name>getPlane</name>
      <anchorfile>classSbPlaneProjector.html</anchorfile>
      <anchor>ae1631081487749e1d59d50f5d7421577</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setOrientToEye</name>
      <anchorfile>classSbPlaneProjector.html</anchorfile>
      <anchor>a338c5c92203c71af31467f53e7ca067e</anchor>
      <arglist>(const SbBool orienttoeye)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isOrientToEye</name>
      <anchorfile>classSbPlaneProjector.html</anchorfile>
      <anchor>a67f83822957c8b8bc0d242bb0e16dee0</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbVec3f</type>
      <name>getVector</name>
      <anchorfile>classSbPlaneProjector.html</anchorfile>
      <anchor>a71bff22fade60bab1dff0712fc9c1b09</anchor>
      <arglist>(const SbVec2f &amp;viewpos1, const SbVec2f &amp;viewpos2)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbVec3f</type>
      <name>getVector</name>
      <anchorfile>classSbPlaneProjector.html</anchorfile>
      <anchor>a4078f3a50298f318235dd7385db0c82c</anchor>
      <arglist>(const SbVec2f &amp;viewpos)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setStartPosition</name>
      <anchorfile>classSbPlaneProjector.html</anchorfile>
      <anchor>a313f157900e6b80cee0bcb7247966d9a</anchor>
      <arglist>(const SbVec2f &amp;viewpos)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setStartPosition</name>
      <anchorfile>classSbPlaneProjector.html</anchorfile>
      <anchor>a2b9100b73f90134a2f178ea73b5d2a57</anchor>
      <arglist>(const SbVec3f &amp;point)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>setupPlane</name>
      <anchorfile>classSbPlaneProjector.html</anchorfile>
      <anchor>a688bfaa1b95d749458ffb137314c5703</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbPlane</type>
      <name>plane</name>
      <anchorfile>classSbPlaneProjector.html</anchorfile>
      <anchor>a285bd75831659701d3be8e67233d9b39</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbPlane</type>
      <name>nonOrientPlane</name>
      <anchorfile>classSbPlaneProjector.html</anchorfile>
      <anchor>a1306a57449db989650f04758486d3951</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbBool</type>
      <name>orientToEye</name>
      <anchorfile>classSbPlaneProjector.html</anchorfile>
      <anchor>a217fdecb25351d4f4b83ebbf061e52a5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbBool</type>
      <name>needSetup</name>
      <anchorfile>classSbPlaneProjector.html</anchorfile>
      <anchor>aca42872fdc02d9914112c9d9c85c6a3d</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbVec3f</type>
      <name>lastPoint</name>
      <anchorfile>classSbPlaneProjector.html</anchorfile>
      <anchor>afbd27c654699465a946209f344b94d72</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbPList</name>
    <filename>classSbPList.html</filename>
  </compound>
  <compound kind="class">
    <name>SbProfilingData</name>
    <filename>classSbProfilingData.html</filename>
    <member kind="function">
      <type></type>
      <name>SbProfilingData</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>a488aacafe6ca7807896ac31343667978</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbProfilingData</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>a846e722d1391ba5c86952478ee04b923</anchor>
      <arglist>(const SbProfilingData &amp;rhs)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbProfilingData</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>abd2766243e5524aded127cd6d45a0074</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setActionType</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>ae18037eb4ed6aee87bd05e511ee33f55</anchor>
      <arglist>(SoType actiontype)</arglist>
    </member>
    <member kind="function">
      <type>SoType</type>
      <name>getActionType</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>a8fee8cfcb0ea11f6b39c61f4b23c1a75</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setActionStartTime</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>afedc0010bd7aac22f3191acfaafb4d73</anchor>
      <arglist>(SbTime starttime)</arglist>
    </member>
    <member kind="function">
      <type>SbTime</type>
      <name>getActionStartTime</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>af81ea04bbb250ad845ab09842a3bacab</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setActionStopTime</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>acfa2223276b957082882eca43b9464c2</anchor>
      <arglist>(SbTime stoptime)</arglist>
    </member>
    <member kind="function">
      <type>SbTime</type>
      <name>getActionStopTime</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>aa61ac387d00dca469744778b173a53c0</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SbTime</type>
      <name>getActionDuration</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>aed43aca0a6bc52249ad57288a0f2adad</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setNodeTiming</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>a27e4e5f78b5e5c1d0e90f040f3835a6a</anchor>
      <arglist>(const SoPath *path, SbTime timing)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setNodeTiming</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>a05fd61b8921339389b1c5079a82e45fa</anchor>
      <arglist>(int idx, SbTime timing)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>preOffsetNodeTiming</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>af20d7eb46b40fd5e6085479bf8d55181</anchor>
      <arglist>(int idx, SbTime timing)</arglist>
    </member>
    <member kind="function">
      <type>SbTime</type>
      <name>getNodeTiming</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>ae286da3c7216ff41f377f028ee1dfe38</anchor>
      <arglist>(const SoPath *path, unsigned int queryflags=0) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getIndex</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>aecb6beb0a686cc503b2dfabf086aa396</anchor>
      <arglist>(const SoPath *path, SbBool create=FALSE)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getParentIndex</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>a37985e2a40de405bc1655d32a1439b65</anchor>
      <arglist>(int idx) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reset</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>a40251e3b831483c7a8d591fdc8ef8afe</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>SbProfilingData &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>ac341fadcf59bdd94cd51c2cd4ef7e41d</anchor>
      <arglist>(const SbProfilingData &amp;rhs)</arglist>
    </member>
    <member kind="function">
      <type>SbProfilingData &amp;</type>
      <name>operator+=</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>ad569c820296171fe6c2798403c7cb508</anchor>
      <arglist>(const SbProfilingData &amp;rhs)</arglist>
    </member>
    <member kind="function">
      <type>size_t</type>
      <name>getProfilingDataSize</name>
      <anchorfile>classSbProfilingData.html</anchorfile>
      <anchor>a03f58491dc5544dce791c269cf327287</anchor>
      <arglist>(void) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbProjector</name>
    <filename>classSbProjector.html</filename>
    <member kind="function" virtualness="pure">
      <type>virtual SbVec3f</type>
      <name>project</name>
      <anchorfile>classSbProjector.html</anchorfile>
      <anchor>a10aa00e733aae551b5e813bce2e52d2d</anchor>
      <arglist>(const SbVec2f &amp;point)=0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbRotation</name>
    <filename>classSbRotation.html</filename>
    <member kind="function">
      <type></type>
      <name>SbRotation</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>af7b34a3688cd8e1bfc3482bddb997b82</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbRotation</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>aabdc5a912bc0a6690dd47083a8b3f39f</anchor>
      <arglist>(const SbVec3f &amp;axis, const float radians)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbRotation</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>ae048a5c82d3f01f275f6223c8e180092</anchor>
      <arglist>(const float q[4])</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbRotation</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>ab86e1cbd8aec00ea9006be02649fa93f</anchor>
      <arglist>(const float q0, const float q1, const float q2, const float q3)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbRotation</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>ac42b51c454f31c7e4427801097cfda1f</anchor>
      <arglist>(const SbMatrix &amp;m)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbRotation</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>a5a71d62e68580ed900c071b3cf605b56</anchor>
      <arglist>(const SbVec3f &amp;rotateFrom, const SbVec3f &amp;rotateTo)</arglist>
    </member>
    <member kind="function">
      <type>const float *</type>
      <name>getValue</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>a56ceb5d89693bb481816cef1aa6888cb</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getValue</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>a3a23df52b8445707f0b2f7af62b46193</anchor>
      <arglist>(float &amp;q0, float &amp;q1, float &amp;q2, float &amp;q3) const </arglist>
    </member>
    <member kind="function">
      <type>SbRotation &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>a341d6be6f5b7207edb5eb4f118f4e352</anchor>
      <arglist>(const float q0, const float q1, const float q2, const float q3)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getValue</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>a2ffaac1ce15b20631d9b7a207e70354f</anchor>
      <arglist>(SbVec3f &amp;axis, float &amp;radians) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getValue</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>a2e724099b40235538bf2d950aefc4c27</anchor>
      <arglist>(SbMatrix &amp;matrix) const </arglist>
    </member>
    <member kind="function">
      <type>SbRotation &amp;</type>
      <name>invert</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>a60bf4c2709c944b64bef644375250d88</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>SbRotation</type>
      <name>inverse</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>ab4ccde92fa0e3a49ba7253572495d0ad</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SbRotation &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>a3f7dfa32c2ab80fc0e6808ca1940512d</anchor>
      <arglist>(const float q[4])</arglist>
    </member>
    <member kind="function">
      <type>SbRotation &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>a39efcb6f3651bea7b194f2e56cfb910f</anchor>
      <arglist>(const SbMatrix &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>SbRotation &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>a0346dd919d996967cb7d1b907214f0ab</anchor>
      <arglist>(const SbVec3f &amp;axis, const float radians)</arglist>
    </member>
    <member kind="function">
      <type>SbRotation &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>a0e4f23004de7569337960d7e5011e63d</anchor>
      <arglist>(const SbVec3f &amp;rotateFrom, const SbVec3f &amp;rotateTo)</arglist>
    </member>
    <member kind="function">
      <type>SbRotation &amp;</type>
      <name>operator*=</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>a466a7aae8799516373a99a0e3da290aa</anchor>
      <arglist>(const SbRotation &amp;q)</arglist>
    </member>
    <member kind="function">
      <type>SbRotation &amp;</type>
      <name>operator*=</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>a36daec8ca173721537b21146d7bb9a64</anchor>
      <arglist>(const float s)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>operator[]</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>afa8ec3a17f2107882ef71a135d1e94b5</anchor>
      <arglist>(size_t n) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>equals</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>ad981c09219f1db9a60e3a9d1aa157f16</anchor>
      <arglist>(const SbRotation &amp;r, float tolerance) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>multVec</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>a7bf8bae2e9ae953e50769fad99689be5</anchor>
      <arglist>(const SbVec3f &amp;src, SbVec3f &amp;dst) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>scaleAngle</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>aecf5befb7013da43f9c459ee86a81e80</anchor>
      <arglist>(const float scaleFactor)</arglist>
    </member>
    <member kind="function">
      <type>SbString</type>
      <name>toString</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>a46624fd51f3907355e1497aa62aaf448</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>fromString</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>abe4d493f5ad74a6c30135f62c0e36df6</anchor>
      <arglist>(const SbString &amp;str)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>aac469a8233c886ca5236f984e704429e</anchor>
      <arglist>(FILE *fp) const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SbRotation</type>
      <name>slerp</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>a04650493010ed066c2d055596f38c6f4</anchor>
      <arglist>(const SbRotation &amp;rot0, const SbRotation &amp;rot1, float t)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SbRotation</type>
      <name>identity</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>a185e88e106dbba29d4bb8339ff28c4ac</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator==</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>a083b52d28a5b2c848ec051b051383816</anchor>
      <arglist>(const SbRotation &amp;q1, const SbRotation &amp;q2)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator!=</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>a5fb0f927ad287d0913505d7f7ac04429</anchor>
      <arglist>(const SbRotation &amp;q1, const SbRotation &amp;q2)</arglist>
    </member>
    <member kind="friend">
      <type>friend SbRotation</type>
      <name>operator*</name>
      <anchorfile>classSbRotation.html</anchorfile>
      <anchor>a6bded4a443b38c90962ada7ce35996a7</anchor>
      <arglist>(const SbRotation &amp;q1, const SbRotation &amp;q2)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbSphere</name>
    <filename>classSbSphere.html</filename>
    <member kind="function">
      <type></type>
      <name>SbSphere</name>
      <anchorfile>classSbSphere.html</anchorfile>
      <anchor>a73387572407620a899681cb05af33cd0</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbSphere</name>
      <anchorfile>classSbSphere.html</anchorfile>
      <anchor>a10410586031d8b3c9b5bc55876f3b1c9</anchor>
      <arglist>(const SbVec3f &amp;center, const float radius)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValue</name>
      <anchorfile>classSbSphere.html</anchorfile>
      <anchor>a906782620b3e8bdb004ba314e9f90cbe</anchor>
      <arglist>(const SbVec3f &amp;center, const float radius)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCenter</name>
      <anchorfile>classSbSphere.html</anchorfile>
      <anchor>a4b7d11065b77b3d1ea4308880a6b0574</anchor>
      <arglist>(const SbVec3f &amp;center)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRadius</name>
      <anchorfile>classSbSphere.html</anchorfile>
      <anchor>a27485e86fea83dff472e6042eab71ed3</anchor>
      <arglist>(const float radius)</arglist>
    </member>
    <member kind="function">
      <type>const SbVec3f &amp;</type>
      <name>getCenter</name>
      <anchorfile>classSbSphere.html</anchorfile>
      <anchor>a51899824c3284da57977780d4197ad6a</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getRadius</name>
      <anchorfile>classSbSphere.html</anchorfile>
      <anchor>ab0baed9c052cd61025e0ce6f592494b4</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>circumscribe</name>
      <anchorfile>classSbSphere.html</anchorfile>
      <anchor>a57d815c498ead420cfe4b480fd4a6aa2</anchor>
      <arglist>(const SbBox3f &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbSphere.html</anchorfile>
      <anchor>a8d5150f1558437d3df085a99148b2da6</anchor>
      <arglist>(const SbLine &amp;l, SbVec3f &amp;intersection) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbSphere.html</anchorfile>
      <anchor>a19ce686c2aa73243e226c4f6248cebc2</anchor>
      <arglist>(const SbLine &amp;l, SbVec3f &amp;enter, SbVec3f &amp;exit) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>pointInside</name>
      <anchorfile>classSbSphere.html</anchorfile>
      <anchor>aabe23950f304691ffe483d5204c110de</anchor>
      <arglist>(const SbVec3f &amp;p) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classSbSphere.html</anchorfile>
      <anchor>a90637cee3bd8473e4b99ed8ab0fcb009</anchor>
      <arglist>(FILE *file) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbSpherePlaneProjector</name>
    <filename>classSbSpherePlaneProjector.html</filename>
    <base>SbSphereSectionProjector</base>
    <member kind="function">
      <type></type>
      <name>SbSpherePlaneProjector</name>
      <anchorfile>classSbSpherePlaneProjector.html</anchorfile>
      <anchor>a3042ff531eb61c7cbc3b9d4c5a6f3b19</anchor>
      <arglist>(const float edgetol=0.9f, const SbBool orienttoeye=TRUE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbSpherePlaneProjector</name>
      <anchorfile>classSbSpherePlaneProjector.html</anchorfile>
      <anchor>a85c71f491a82ea4e698bda6611365bf2</anchor>
      <arglist>(const SbSphere &amp;sph, const float edgetol=0.9f, const SbBool orienttoeye=TRUE)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbProjector *</type>
      <name>copy</name>
      <anchorfile>classSbSpherePlaneProjector.html</anchorfile>
      <anchor>a979ad6f81c3272af5fb4e011b6144e0b</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbVec3f</type>
      <name>project</name>
      <anchorfile>classSbSpherePlaneProjector.html</anchorfile>
      <anchor>affe7047c1f8ef6c2bcf2032d76bd73c4</anchor>
      <arglist>(const SbVec2f &amp;point)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbRotation</type>
      <name>getRotation</name>
      <anchorfile>classSbSpherePlaneProjector.html</anchorfile>
      <anchor>ab0010e8222fbf7f4a86b8a18260e45e1</anchor>
      <arglist>(const SbVec3f &amp;point1, const SbVec3f &amp;point2)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbSphereSectionProjector</name>
      <anchorfile>classSbSphereSectionProjector.html</anchorfile>
      <anchor>a9090a203bc67b74149a825fc5df14c42</anchor>
      <arglist>(const float edgetol=0.9f, const SbBool orienttoeye=TRUE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbSphereSectionProjector</name>
      <anchorfile>classSbSphereSectionProjector.html</anchorfile>
      <anchor>a048b76c7d97b33c9576c2e870ea9a502</anchor>
      <arglist>(const SbSphere &amp;sph, const float edgetol=0.9f, const SbBool orienttoeye=TRUE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTolerance</name>
      <anchorfile>classSbSphereSectionProjector.html</anchorfile>
      <anchor>ab54f9887c3ba8b10ca0154d3049688b3</anchor>
      <arglist>(const float edgetol)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getTolerance</name>
      <anchorfile>classSbSphereSectionProjector.html</anchorfile>
      <anchor>a9948856bbb657386faa06e89f63563d9</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRadialFactor</name>
      <anchorfile>classSbSphereSectionProjector.html</anchorfile>
      <anchor>aa089532afabe3ba67335ce603a7c879b</anchor>
      <arglist>(const float rad=0.0f)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getRadialFactor</name>
      <anchorfile>classSbSphereSectionProjector.html</anchorfile>
      <anchor>ab761d04897f2ddb3a848ae9884f9a28b</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isWithinTolerance</name>
      <anchorfile>classSbSphereSectionProjector.html</anchorfile>
      <anchor>ac5f2c7751c2eda4828cf891a39509b8f</anchor>
      <arglist>(const SbVec3f &amp;point)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f</type>
      <name>projectAndGetRotation</name>
      <anchorfile>classSbSphereProjector.html</anchorfile>
      <anchor>ac38482c976e0d9054e794a034abcf79e</anchor>
      <arglist>(const SbVec2f &amp;point, SbRotation &amp;rot)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSphere</name>
      <anchorfile>classSbSphereProjector.html</anchorfile>
      <anchor>ace6896e5966432ac44d86c04d1e4eb61</anchor>
      <arglist>(const SbSphere &amp;sph)</arglist>
    </member>
    <member kind="function">
      <type>const SbSphere &amp;</type>
      <name>getSphere</name>
      <anchorfile>classSbSphereProjector.html</anchorfile>
      <anchor>a04cedf93a2991d4c01cf62d682bfb410</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setOrientToEye</name>
      <anchorfile>classSbSphereProjector.html</anchorfile>
      <anchor>ac4d069b1a39639e6700a63d659c7236f</anchor>
      <arglist>(const SbBool orienttoeye)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isOrientToEye</name>
      <anchorfile>classSbSphereProjector.html</anchorfile>
      <anchor>a21c3eb49a33a231fd5029313839716de</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFront</name>
      <anchorfile>classSbSphereProjector.html</anchorfile>
      <anchor>a071532046e8c7319df2a29befe5903e2</anchor>
      <arglist>(const SbBool infront)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isFront</name>
      <anchorfile>classSbSphereProjector.html</anchorfile>
      <anchor>a4a3d6320e55c3ce61d70279418336bfc</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isPointInFront</name>
      <anchorfile>classSbSphereProjector.html</anchorfile>
      <anchor>acba3d30ad794463d201f395cefc05125</anchor>
      <arglist>(const SbVec3f &amp;point) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setWorkingSpace</name>
      <anchorfile>classSbSphereProjector.html</anchorfile>
      <anchor>afe1519305c87d7726dc40b9daaa59764</anchor>
      <arglist>(const SbMatrix &amp;space)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>SbRotation</type>
      <name>getRotation</name>
      <anchorfile>classSbSpherePlaneProjector.html</anchorfile>
      <anchor>a8fb39b306183be8e6353e43df6bfc349</anchor>
      <arglist>(const SbVec3f &amp;point1, const SbBool tol1, const SbVec3f &amp;point2, const SbBool tol2)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>setupTolerance</name>
      <anchorfile>classSbSphereSectionProjector.html</anchorfile>
      <anchor>a482a9ff7c5301f9ae5bca606f3f5d345</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>SbSphereProjector</name>
      <anchorfile>classSbSphereProjector.html</anchorfile>
      <anchor>a868f57ebec32957883b1321b0adf955b</anchor>
      <arglist>(const SbBool orienttoeye)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>SbSphereProjector</name>
      <anchorfile>classSbSphereProjector.html</anchorfile>
      <anchor>a378cd6b9ec089b03a78251e433d57758</anchor>
      <arglist>(const SbSphere &amp;s, const SbBool orienttoeye)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>SbBool</type>
      <name>intersectSphereFront</name>
      <anchorfile>classSbSphereProjector.html</anchorfile>
      <anchor>ab08294fd4cac38679167e552e4940ab0</anchor>
      <arglist>(const SbLine &amp;l, SbVec3f &amp;result)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float</type>
      <name>tolerance</name>
      <anchorfile>classSbSphereSectionProjector.html</anchorfile>
      <anchor>a7428f52b5d33e7c256361c1bfccf9b84</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float</type>
      <name>tolDist</name>
      <anchorfile>classSbSphereSectionProjector.html</anchorfile>
      <anchor>a8680e19ea7232b1f972fbc5c17478bd3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float</type>
      <name>radialFactor</name>
      <anchorfile>classSbSphereSectionProjector.html</anchorfile>
      <anchor>ab221449da9bff16c2ffc0a7cd3e4f26f</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbVec3f</type>
      <name>planePoint</name>
      <anchorfile>classSbSphereSectionProjector.html</anchorfile>
      <anchor>a9d54fc42f4321c46a2cc8ff4b074e0f6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbVec3f</type>
      <name>planeDir</name>
      <anchorfile>classSbSphereSectionProjector.html</anchorfile>
      <anchor>af31156dbf1e400fb807ab9754bcd13c7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float</type>
      <name>planeDist</name>
      <anchorfile>classSbSphereSectionProjector.html</anchorfile>
      <anchor>ad6d329c6cdc0645d91226668351118e7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbPlane</type>
      <name>tolPlane</name>
      <anchorfile>classSbSphereSectionProjector.html</anchorfile>
      <anchor>a1607bd15508d9d1f93a3371f8f31b460</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbBool</type>
      <name>intersectFront</name>
      <anchorfile>classSbSphereProjector.html</anchorfile>
      <anchor>af53c03608a41fad58f82856113d20f65</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbSphere</type>
      <name>sphere</name>
      <anchorfile>classSbSphereProjector.html</anchorfile>
      <anchor>ab0ba051f5995c4924989789b99ca818f</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbBool</type>
      <name>orientToEye</name>
      <anchorfile>classSbSphereProjector.html</anchorfile>
      <anchor>a0883b57c43eb641b44359f5caeb977fa</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbBool</type>
      <name>needSetup</name>
      <anchorfile>classSbSphereProjector.html</anchorfile>
      <anchor>a136681b3e872e38473160fe0fde0352d</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbVec3f</type>
      <name>lastPoint</name>
      <anchorfile>classSbSphereProjector.html</anchorfile>
      <anchor>a23eb381f2626c24f4c2fa378e89412b4</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbSphereProjector</name>
    <filename>classSbSphereProjector.html</filename>
    <base>SbProjector</base>
    <member kind="function" virtualness="pure">
      <type>virtual SbRotation</type>
      <name>getRotation</name>
      <anchorfile>classSbSphereProjector.html</anchorfile>
      <anchor>a9c4d57571349f6233e78e351b949a7b9</anchor>
      <arglist>(const SbVec3f &amp;point1, const SbVec3f &amp;point2)=0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbSphereSectionProjector</name>
    <filename>classSbSphereSectionProjector.html</filename>
    <base>SbSphereProjector</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SbProjector *</type>
      <name>copy</name>
      <anchorfile>classSbSphereSectionProjector.html</anchorfile>
      <anchor>a029c0ba8ce899c0767cca58f8bd1daae</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbVec3f</type>
      <name>project</name>
      <anchorfile>classSbSphereSectionProjector.html</anchorfile>
      <anchor>ae9bd7709409cf32532354b67bb0cb8f9</anchor>
      <arglist>(const SbVec2f &amp;point)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbRotation</type>
      <name>getRotation</name>
      <anchorfile>classSbSphereSectionProjector.html</anchorfile>
      <anchor>acb939b44f139674396cfb9304a2fa686</anchor>
      <arglist>(const SbVec3f &amp;point1, const SbVec3f &amp;point2)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbSphereSheetProjector</name>
    <filename>classSbSphereSheetProjector.html</filename>
    <base>SbSphereProjector</base>
    <member kind="function">
      <type></type>
      <name>SbSphereSheetProjector</name>
      <anchorfile>classSbSphereSheetProjector.html</anchorfile>
      <anchor>a8356658bb33977f1787120b0c9d40af3</anchor>
      <arglist>(const SbBool orienttoeye=TRUE)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbSphereSheetProjector</name>
      <anchorfile>classSbSphereSheetProjector.html</anchorfile>
      <anchor>a26219758d2f787d0386fcec538289895</anchor>
      <arglist>(const SbSphere &amp;sph, const SbBool orienttoeye=TRUE)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbProjector *</type>
      <name>copy</name>
      <anchorfile>classSbSphereSheetProjector.html</anchorfile>
      <anchor>a78b0fb44dc547a05cd624f4ccb1bd00e</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbVec3f</type>
      <name>project</name>
      <anchorfile>classSbSphereSheetProjector.html</anchorfile>
      <anchor>a0bcb1b01105408906699823d85f8990c</anchor>
      <arglist>(const SbVec2f &amp;point)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbRotation</type>
      <name>getRotation</name>
      <anchorfile>classSbSphereSheetProjector.html</anchorfile>
      <anchor>ae98f637b246b3defc53a8db8c228d5b0</anchor>
      <arglist>(const SbVec3f &amp;point1, const SbVec3f &amp;point2)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>setupPlane</name>
      <anchorfile>classSbSphereSheetProjector.html</anchorfile>
      <anchor>a9e7eea331df3c3fd6197b9d308c444c1</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbVec3f</type>
      <name>workingProjPoint</name>
      <anchorfile>classSbSphereSheetProjector.html</anchorfile>
      <anchor>a1e15498d6b5eec4688af05be0e980815</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbVec3f</type>
      <name>planePoint</name>
      <anchorfile>classSbSphereSheetProjector.html</anchorfile>
      <anchor>a82db4e1ef68eecc7d51b3d88f1178b7b</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbVec3f</type>
      <name>planeDir</name>
      <anchorfile>classSbSphereSheetProjector.html</anchorfile>
      <anchor>ab262ce8024b732bb3533c5b78b2ec862</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float</type>
      <name>planeDist</name>
      <anchorfile>classSbSphereSheetProjector.html</anchorfile>
      <anchor>a6e28d2fee1faf1f50d41f3185826c5dc</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbPlane</type>
      <name>tolPlane</name>
      <anchorfile>classSbSphereSheetProjector.html</anchorfile>
      <anchor>ac4f5bcfe4f3032b8cba40d94572a1e82</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbString</name>
    <filename>classSbString.html</filename>
    <member kind="function">
      <type></type>
      <name>SbString</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>ad8bd7fd681ed31cae3c2165b9575e65d</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbString</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a3100d87da8215cf09b4386cb500ad464</anchor>
      <arglist>(const char *s)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbString</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a7dee6217016462d0a27715917fa2644b</anchor>
      <arglist>(const wchar_t *s)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbString</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a5107e4772f6e2088d256d34da1e30730</anchor>
      <arglist>(const char *s, int start, int end)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbString</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a4aa2a3f963edba4e22746393f82d5855</anchor>
      <arglist>(const SbString &amp;s)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbString</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a39c40a499231bc125b14b802c0b85f70</anchor>
      <arglist>(const int digits)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbString</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a33b47eab7803f9d9cec6db6862ab2120</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>uint32_t</type>
      <name>hash</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a8fe69cd2307f145cd8579e78623f2770</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a40ff62a8a6b3c2279e41a40c4d90d987</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>makeEmpty</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>ade6800edca5eb14538b266a61fede1e4</anchor>
      <arglist>(SbBool freeold=TRUE)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>getString</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a36c93f1212c84f3c509bab21befcaf9e</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SbString</type>
      <name>getSubString</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>aa0a2e1d9447be4508e70f0438e2047d7</anchor>
      <arglist>(int startidx, int endidx=-1) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>deleteSubString</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a7d14b085ab8efac7bf5ee5a3b4a88e4f</anchor>
      <arglist>(int startidx, int endidx=-1)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addIntString</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>ac371e6d216d1f29b15b0fe6bd7023e99</anchor>
      <arglist>(const int value)</arglist>
    </member>
    <member kind="function">
      <type>char</type>
      <name>operator[]</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a504691fd9edb039ce9a81b80fd5c6e25</anchor>
      <arglist>(int index) const </arglist>
    </member>
    <member kind="function">
      <type>SbString &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>aff8574febe670eb6ed208c38ef9a530f</anchor>
      <arglist>(const char *s)</arglist>
    </member>
    <member kind="function">
      <type>SbString &amp;</type>
      <name>operator=</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a48e6dd186644cb4248fa467873bda3bb</anchor>
      <arglist>(const SbString &amp;s)</arglist>
    </member>
    <member kind="function">
      <type>SbString &amp;</type>
      <name>operator+=</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a7b4907e540abc08f9e966105ed9f20a9</anchor>
      <arglist>(const char *s)</arglist>
    </member>
    <member kind="function">
      <type>SbString &amp;</type>
      <name>operator+=</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a876f50865efc300930a7b242a1417a4b</anchor>
      <arglist>(const SbString &amp;s)</arglist>
    </member>
    <member kind="function">
      <type>SbString &amp;</type>
      <name>operator+=</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a45c3f7f9f4c2b8798f2cb44ccf16dc17</anchor>
      <arglist>(const char c)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a12ace3d31334950a73c0034afa5727e8</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>compareSubString</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>ac2abacbc36a4e80da68e3efb2d378762</anchor>
      <arglist>(const char *text, int offset=0) const </arglist>
    </member>
    <member kind="function">
      <type>SbString &amp;</type>
      <name>sprintf</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a5b8b394310de686b49033d6e5ef16280</anchor>
      <arglist>(const char *formatstr,...)</arglist>
    </member>
    <member kind="function">
      <type>SbString &amp;</type>
      <name>vsprintf</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>af55ef20fed88bf7dbb8cb1eaf2457af3</anchor>
      <arglist>(const char *formatstr, va_list args)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a1187400f9d3f0c458475c0882fa25a68</anchor>
      <arglist>(const SbString &amp;s) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>findAll</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a503482650e525fc7c75887ee2c80602c</anchor>
      <arglist>(const SbString &amp;s, SbIntList &amp;found) const </arglist>
    </member>
    <member kind="function">
      <type>SbString</type>
      <name>lower</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>afddda19e7e3c6485778322f7dd7f7c84</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>SbString</type>
      <name>upper</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a27374fbca91b0aae370a06a30332c10e</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>ae1c15177a1a67ff07c0899b29f60f0b6</anchor>
      <arglist>(std::FILE *fp) const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static uint32_t</type>
      <name>hash</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>aeb40745b411a8d8efb71f1c738e3df8d</anchor>
      <arglist>(const char *s)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator==</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>acb6753b1515604ca971a1a87aff2f428</anchor>
      <arglist>(const SbString &amp;sbstr, const char *s)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator==</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>ac9b65d4d28f6c30992fea63ddd7cf2b9</anchor>
      <arglist>(const char *s, const SbString &amp;sbstr)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator==</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a678e767b7619480700a63bc39c567734</anchor>
      <arglist>(const SbString &amp;str1, const SbString &amp;str2)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator!=</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>aea9790c709cb18bdb1d696b322dbf1cf</anchor>
      <arglist>(const SbString &amp;sbstr, const char *s)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator!=</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a65681d9c628370051ef61439f119bf17</anchor>
      <arglist>(const char *s, const SbString &amp;sbstr)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator!=</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>ac7482060b03b437119ecae06d3986178</anchor>
      <arglist>(const SbString &amp;str1, const SbString &amp;str2)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator&lt;</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a6ed1cb37360a4ca12c90f1c7cb27db6b</anchor>
      <arglist>(const SbString &amp;sbstr, const char *s)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator&lt;</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a9072e7b323d65c64110af3fff813b4d1</anchor>
      <arglist>(const char *s, const SbString &amp;sbstr)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator&lt;</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a94ed21c674ca5fc0100e0babf1a680cb</anchor>
      <arglist>(const SbString &amp;str1, const SbString &amp;str2)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator&gt;</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a4ec0654b3fe5c53bfc65b10746731d7f</anchor>
      <arglist>(const SbString &amp;sbstr, const char *s)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator&gt;</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a46bc605c66301db6ecb77e923fec9a91</anchor>
      <arglist>(const char *s, const SbString &amp;sbstr)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator&gt;</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>af52285d09146696f46c923e786a6ad02</anchor>
      <arglist>(const SbString &amp;str1, const SbString &amp;str2)</arglist>
    </member>
    <member kind="friend">
      <type>friend const SbString</type>
      <name>operator+</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a9eaa950edece45dbdf394a3b39744c5d</anchor>
      <arglist>(const SbString &amp;str1, const SbString &amp;str2)</arglist>
    </member>
    <member kind="friend">
      <type>friend const SbString</type>
      <name>operator+</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a8c85f017ad0d4f843049a0c0f5026fa8</anchor>
      <arglist>(const SbString &amp;sbstr, const char *s)</arglist>
    </member>
    <member kind="friend">
      <type>friend const SbString</type>
      <name>operator+</name>
      <anchorfile>classSbString.html</anchorfile>
      <anchor>a54b38460b412035516ce1dca74affbec</anchor>
      <arglist>(const char *s, const SbString &amp;sbstr)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbStringList</name>
    <filename>classSbStringList.html</filename>
    <base>SbPList</base>
    <member kind="function">
      <type></type>
      <name>SbStringList</name>
      <anchorfile>classSbStringList.html</anchorfile>
      <anchor>a5f9e3315b61678d13d6f2360cc0e8c98</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbStringList</name>
      <anchorfile>classSbStringList.html</anchorfile>
      <anchor>ae66cdc3f06175aff254fd055db619b82</anchor>
      <arglist>(const int sizehint)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSbStringList.html</anchorfile>
      <anchor>a417f2e12fef8f50b0b9c52b9cddcb304</anchor>
      <arglist>(SbString *string) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbStringList.html</anchorfile>
      <anchor>ad3242b4d563ab18cf2ec232865490e35</anchor>
      <arglist>(SbString *string, int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>SbString *&amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbStringList.html</anchorfile>
      <anchor>a08fcc3f1c87d5dfc984efb7a0ff9da06</anchor>
      <arglist>(const int idx) const </arglist>
    </member>
    <member kind="function">
      <type>const SbString **</type>
      <name>getArrayPtr</name>
      <anchorfile>classSbStringList.html</anchorfile>
      <anchor>a81212f126cbb620500693d8109e3c5a6</anchor>
      <arglist>(void) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbTesselator</name>
    <filename>classSbTesselator.html</filename>
    <member kind="function">
      <type></type>
      <name>SbTesselator</name>
      <anchorfile>classSbTesselator.html</anchorfile>
      <anchor>af364565888f0def8e1665f223adb8d61</anchor>
      <arglist>(SbTesselatorCB *func=NULL, void *data=NULL)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbTesselator</name>
      <anchorfile>classSbTesselator.html</anchorfile>
      <anchor>a635c1016d1bcde86146bb86b04ccb17e</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>beginPolygon</name>
      <anchorfile>classSbTesselator.html</anchorfile>
      <anchor>a8092c3ca8ca4539e18fff6ff7552c828</anchor>
      <arglist>(SbBool keepVertices=FALSE, const SbVec3f &amp;normal=SbVec3f(0.0f, 0.0f, 0.0f))</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addVertex</name>
      <anchorfile>classSbTesselator.html</anchorfile>
      <anchor>aefa3b7a22e769602fae46054725d7a0b</anchor>
      <arglist>(const SbVec3f &amp;v, void *data)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>endPolygon</name>
      <anchorfile>classSbTesselator.html</anchorfile>
      <anchor>a904c2f4eb454771851a600fce8957385</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCallback</name>
      <anchorfile>classSbTesselator.html</anchorfile>
      <anchor>ab6937880e7f06cecadd8efd95a7c469f</anchor>
      <arglist>(SbTesselatorCB *func, void *data)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbTime</name>
    <filename>classSbTime.html</filename>
    <member kind="function">
      <type></type>
      <name>SbTime</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>a9f7c034551e616cadd327ddef6310484</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbTime</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>a3579ba1742a3827a42f5a6d34b3d8de5</anchor>
      <arglist>(const double sec)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbTime</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>a43c176cc2f6d54eb4d0bdb57d9cea8c7</anchor>
      <arglist>(const int32_t sec, const long usec)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbTime</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>a7b1d561c19cc78f7e061fc50c9b0021f</anchor>
      <arglist>(const struct timeval *const tv)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setToTimeOfDay</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>aeae606e00a26076aeaccca2e0b077aac</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValue</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>a8f695933fe3cc2722eb8bdd75aa99c69</anchor>
      <arglist>(const double sec)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValue</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>a2fcad96f5a9be55efbe29574a1de172b</anchor>
      <arglist>(const int32_t sec, const long usec)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValue</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>ab38f422af390a3eb5f9141be0ca41a72</anchor>
      <arglist>(const struct timeval *const tv)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMsecValue</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>a675520e49045fd8a1cf419a3f761c26e</anchor>
      <arglist>(const unsigned long msec)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>getValue</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>a1e3b3352c6e1e3330bc973722b31b0a5</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getValue</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>a25850c444ca5546ad930762d84fbd785</anchor>
      <arglist>(time_t &amp;sec, long &amp;usec) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getValue</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>a3656a0fdcb99666e28b2d529a154b136</anchor>
      <arglist>(struct timeval *tv) const </arglist>
    </member>
    <member kind="function">
      <type>unsigned long</type>
      <name>getMsecValue</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>a53242079bebcf638575a503580fea12f</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SbString</type>
      <name>format</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>a805ee471c1515b79e25a492fabb7ff52</anchor>
      <arglist>(const char *const fmt=&quot;%S.%i&quot;) const </arglist>
    </member>
    <member kind="function">
      <type>SbString</type>
      <name>formatDate</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>aee559ca25b0c21ecf46e66a53a1a4ba8</anchor>
      <arglist>(const char *const fmt=NULL) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>parsedate</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>ac5f6ad3aabca3582cc14dfa1ac9c4092</anchor>
      <arglist>(const char *const date)</arglist>
    </member>
    <member kind="function">
      <type>SbTime &amp;</type>
      <name>operator+=</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>a644fc261ef8d20ad27e54bbda017c8ec</anchor>
      <arglist>(const SbTime &amp;tm)</arglist>
    </member>
    <member kind="function">
      <type>SbTime &amp;</type>
      <name>operator-=</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>a3b3141c403d383780d9ac61d2ebe0b1e</anchor>
      <arglist>(const SbTime &amp;tm)</arglist>
    </member>
    <member kind="function">
      <type>SbTime</type>
      <name>operator-</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>ada704b7d227b1a3455b92d04f37dbd4d</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SbTime &amp;</type>
      <name>operator*=</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>a6b1b1bd6b756ea34fa61d968a0f45b48</anchor>
      <arglist>(const double s)</arglist>
    </member>
    <member kind="function">
      <type>SbTime &amp;</type>
      <name>operator/=</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>a50011d50a5a86f86fe27e48ca2d8ddd3</anchor>
      <arglist>(const double s)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>operator/</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>a0b9af8e86b6f73f3c0957c0178b4c494</anchor>
      <arglist>(const SbTime &amp;tm) const </arglist>
    </member>
    <member kind="function">
      <type>SbTime</type>
      <name>operator%</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>ac7567255fdd8ffb5163db976f4d4fd10</anchor>
      <arglist>(const SbTime &amp;tm) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>ae016c412bb33f25e8545fb8a1f975100</anchor>
      <arglist>(const SbTime &amp;tm) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>acb03f6e006ed42ca3ab0aef34a7c76d0</anchor>
      <arglist>(const SbTime &amp;tm) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>operator&lt;</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>acd5d13a6e3b1e05dd6046ceb7bf351bc</anchor>
      <arglist>(const SbTime &amp;tm) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>operator&gt;</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>a871a6382f5c855cbd87d2b923a14a104</anchor>
      <arglist>(const SbTime &amp;tm) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>operator&lt;=</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>aa8523e0a101e6e8d75fc6d133b897532</anchor>
      <arglist>(const SbTime &amp;tm) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>operator&gt;=</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>ad2660348eaf285d16a71f35a8a9500c2</anchor>
      <arglist>(const SbTime &amp;tm) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>a216dcb16368240c1ede20813f4aab9a3</anchor>
      <arglist>(FILE *fp) const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SbTime</type>
      <name>getTimeOfDay</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>a6a24da27d9ba83fc848b860f164d00fc</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SbTime</type>
      <name>zero</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>aa43feadef19a055eb17bf244605f9972</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SbTime</type>
      <name>max</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>a43279740f6f03fc3333a2165f4e75322</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SbTime</type>
      <name>maxTime</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>a8c4c29b97fef8d0f9a373fdf10e303e5</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>sleep</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>a1c47c0ca8049cd2129c39ba393d52595</anchor>
      <arglist>(int msec)</arglist>
    </member>
    <member kind="friend">
      <type>friend SbTime</type>
      <name>operator+</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>a83f13bc9e9d38624d8b33200dbbb55d9</anchor>
      <arglist>(const SbTime &amp;t0, const SbTime &amp;t1)</arglist>
    </member>
    <member kind="friend">
      <type>friend SbTime</type>
      <name>operator-</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>afbc8605f18ff122b2fd97f6e913b8959</anchor>
      <arglist>(const SbTime &amp;t0, const SbTime &amp;t1)</arglist>
    </member>
    <member kind="friend">
      <type>friend SbTime</type>
      <name>operator*</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>aca6723ed67e401c11550c29b548b2128</anchor>
      <arglist>(const double s, const SbTime &amp;tm)</arglist>
    </member>
    <member kind="friend">
      <type>friend SbTime</type>
      <name>operator*</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>a424088174b4e476e6feaf414fd9fd1c9</anchor>
      <arglist>(const SbTime &amp;tm, const double s)</arglist>
    </member>
    <member kind="friend">
      <type>friend SbTime</type>
      <name>operator/</name>
      <anchorfile>classSbTime.html</anchorfile>
      <anchor>ac30cf5c325aca8e6f924ac03e28b571c</anchor>
      <arglist>(const SbTime &amp;tm, const double s)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbTri3f</name>
    <filename>classSbTri3f.html</filename>
    <member kind="function">
      <type>float</type>
      <name>getDistance</name>
      <anchorfile>classSbTri3f.html</anchorfile>
      <anchor>a572f57f80105d18f96c5ecdd8e56d622</anchor>
      <arglist>(const SbTri3f &amp;t) const </arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getDistance</name>
      <anchorfile>classSbTri3f.html</anchorfile>
      <anchor>a1bb7b2e08618b8876eefdafe64d90730</anchor>
      <arglist>(const SbVec3f &amp;p) const </arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getDistance</name>
      <anchorfile>classSbTri3f.html</anchorfile>
      <anchor>ac1c7af7583616f4e765db99ef626356b</anchor>
      <arglist>(const SbVec3f &amp;p1, const SbVec3f &amp;p2) const </arglist>
    </member>
    <member kind="function">
      <type>const SbBox3f</type>
      <name>getBoundingBox</name>
      <anchorfile>classSbTri3f.html</anchorfile>
      <anchor>ab32817843cf5175dd0ba6fbc53e8d1c1</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static float</type>
      <name>getDistance</name>
      <anchorfile>classSbTri3f.html</anchorfile>
      <anchor>a937567ef2f6dbc2eae693d8ab3e62e7a</anchor>
      <arglist>(const SbVec3f &amp;p, const SbVec3f &amp;p1, const SbVec3f &amp;p2)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static float</type>
      <name>sqrDistance</name>
      <anchorfile>classSbTri3f.html</anchorfile>
      <anchor>ab3b3f482d2834535d889576dfca7d0cc</anchor>
      <arglist>(const SbVec3f &amp;a1, const SbVec3f &amp;a2, const SbVec3f &amp;b1, const SbVec3f &amp;b2, float *linP0, float *linP1)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbTypeInfo</name>
    <filename>structSbTypeInfo.html</filename>
    <templarg></templarg>
  </compound>
  <compound kind="class">
    <name>SbVec2b</name>
    <filename>classSbVec2b.html</filename>
  </compound>
  <compound kind="class">
    <name>SbVec2d</name>
    <filename>classSbVec2d.html</filename>
    <member kind="function">
      <type></type>
      <name>SbVec2d</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>ac63dd0791c0095c9144f9bb9a6607eea</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec2d</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>a8db1b8fa814457c661fd9d3883fe339b</anchor>
      <arglist>(const double v[2])</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec2d</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>a49f6c2e309736dc6150b5c5da97d7712</anchor>
      <arglist>(double x, double y)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec2d</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>ad5b47009527e6d47db0bbde7d901b7d3</anchor>
      <arglist>(const SbVec2f &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec2d</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>a38d93efca3bd30cfc4dc4a39c772920a</anchor>
      <arglist>(const SbVec2b &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec2d</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>aa27005c1f3b6621801122a8110a983cb</anchor>
      <arglist>(const SbVec2s &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec2d</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>a55d2f7e0c108ff0a57d76661627c84df</anchor>
      <arglist>(const SbVec2i32 &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2d &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>a497a600ee7dd4324a62f344b34927b57</anchor>
      <arglist>(const double v[2])</arglist>
    </member>
    <member kind="function">
      <type>SbVec2d &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>aa714b79f7d7157f3f782f223fdb17e23</anchor>
      <arglist>(double x, double y)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2d &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>ac6bf0143ec4cf44f744d2629c1ff88a5</anchor>
      <arglist>(const SbVec2f &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2d &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>a8ba5a744c6e52bdc183584f796fbdd38</anchor>
      <arglist>(const SbVec2b &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2d &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>aef24e59ed4eb153b229737938b362f2f</anchor>
      <arglist>(const SbVec2s &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2d &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>ad303b770569dff5d0e017cdc9fd707f8</anchor>
      <arglist>(const SbVec2i32 &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>const double *</type>
      <name>getValue</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>a8196fd627e54beab9ad70eccb59a532e</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getValue</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>ade6f3f6f9ef8b69436556d94aa669419</anchor>
      <arglist>(double &amp;x, double &amp;y) const </arglist>
    </member>
    <member kind="function">
      <type>double &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>a306d9694244216f16a1ee8157547fdb9</anchor>
      <arglist>(int i)</arglist>
    </member>
    <member kind="function">
      <type>const double &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>ab578b7a8f6277d21d6f99fda12d3909c</anchor>
      <arglist>(int i) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>equals</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>ac72a9b3a91a8eb5df3fbeb9fcba5ebca</anchor>
      <arglist>(const SbVec2d &amp;v, double tolerance) const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>dot</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>aa11e9576aead3dc3fec725e8e3bae493</anchor>
      <arglist>(const SbVec2d &amp;v) const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>length</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>af31b639d6b7418ac2e20bd993102da32</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>normalize</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>a50bd14d8fd33c214eed8dc712b62441a</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>negate</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>a0e540f28f7a2332dbd186e38ca066c82</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2d &amp;</type>
      <name>operator*=</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>a260c4188f947b9f403d6218db8c31ae1</anchor>
      <arglist>(double d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2d &amp;</type>
      <name>operator/=</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>a6d0c4645c6758f2b561730371118d2e6</anchor>
      <arglist>(double d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2d &amp;</type>
      <name>operator+=</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>a5eb83d7686ad695253070e6526f1aba5</anchor>
      <arglist>(const SbVec2d &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2d &amp;</type>
      <name>operator-=</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>aab3e960580edf05188ae53192d300bc6</anchor>
      <arglist>(const SbVec2d &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2d</type>
      <name>operator-</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>ae4139bac70ce43eae04d01ea201cf26a</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>a3da99134f1188978f82e8b9ea489688f</anchor>
      <arglist>(FILE *fp) const </arglist>
    </member>
    <member kind="function">
      <type>SbVec2d</type>
      <name>operator*</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>a7e3711363bfc17138c74285ef7489c98</anchor>
      <arglist>(const SbVec2d &amp;v, double d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2d</type>
      <name>operator*</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>ada5a6cdd907178159235471c7a87a983</anchor>
      <arglist>(double d, const SbVec2d &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2d</type>
      <name>operator/</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>a1bf50012c612e4cba25faf4c43b35fdd</anchor>
      <arglist>(const SbVec2d &amp;v, double d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2d</type>
      <name>operator+</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>aca58910afc203e37d3130116b194c4f6</anchor>
      <arglist>(const SbVec2d &amp;v1, const SbVec2d &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2d</type>
      <name>operator-</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>a5fca9f72a94995260ff026f8f96031fa</anchor>
      <arglist>(const SbVec2d &amp;v1, const SbVec2d &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>ac385222f5fba67dd4681703b68203fb5</anchor>
      <arglist>(const SbVec2d &amp;v1, const SbVec2d &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbVec2d.html</anchorfile>
      <anchor>a024224408ed78d7a0978b7e544021780</anchor>
      <arglist>(const SbVec2d &amp;v1, const SbVec2d &amp;v2)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbVec2f</name>
    <filename>classSbVec2f.html</filename>
    <member kind="function">
      <type></type>
      <name>SbVec2f</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>a1346ce09a8a9385f9c006cc5d63fcbf6</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec2f</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>af3a6d469ba3a49ddc779aba017d3bb6b</anchor>
      <arglist>(const float v[2])</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec2f</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>ab304ea742290b959eccc883bdae04e21</anchor>
      <arglist>(float x, float y)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec2f</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>a86d660046ca1cd6d23db075dc558a02c</anchor>
      <arglist>(const SbVec2d &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec2f</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>aa2ecac9cb0488503e03f7155df51d3ed</anchor>
      <arglist>(const SbVec2b &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec2f</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>acac859226bb926bed1e2f05698897f2a</anchor>
      <arglist>(const SbVec2s &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec2f</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>a0aad8c6cd9c4811851bb86fd771ad039</anchor>
      <arglist>(const SbVec2i32 &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2f &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>aa1e22cf35a2b1d95069161eb89b09421</anchor>
      <arglist>(const float v[2])</arglist>
    </member>
    <member kind="function">
      <type>SbVec2f &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>a186ed3c323758b75395a9b3f4e39ce25</anchor>
      <arglist>(float x, float y)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2f &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>a1c47c2a19edb3d862f3315652cdd76b4</anchor>
      <arglist>(const SbVec2d &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2f &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>af75f570bfdd582e34e840ecd96a8a1cf</anchor>
      <arglist>(const SbVec2b &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2f &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>a6b8d3b85044489347f3fa474f4fb8d4d</anchor>
      <arglist>(const SbVec2s &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2f &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>a8ee69f0bab7c511656ed566aa87d78d7</anchor>
      <arglist>(const SbVec2i32 &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>const float *</type>
      <name>getValue</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>aa0dc4fb6e6f4c8e5335b78b7e778bb0f</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getValue</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>a3797e1005a46fd2e7ae96b1f1205f346</anchor>
      <arglist>(float &amp;x, float &amp;y) const </arglist>
    </member>
    <member kind="function">
      <type>float &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>a100bbbce7a35d7a2e5e1490896fdb729</anchor>
      <arglist>(int i)</arglist>
    </member>
    <member kind="function">
      <type>const float &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>abcace420148bd42d78dfbeff58ee9b51</anchor>
      <arglist>(int i) const </arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>dot</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>a2be3a84c07f75c4598225fa9b2efbfdb</anchor>
      <arglist>(const SbVec2f &amp;v) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>equals</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>a1fd0f02a12897e4312ad5cd1d265d5e3</anchor>
      <arglist>(const SbVec2f &amp;v, float tolerance) const </arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>length</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>af57d1ca34479d2650173fea20272c202</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>sqrLength</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>a1cf0f7c5388427c78a331fc38dac684e</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>negate</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>a3d337eaf4ba60a986ca315dbdc0a8316</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>normalize</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>a5391fa1b1910a636d8344e6981711f54</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2f &amp;</type>
      <name>operator*=</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>a41946e80ae85d1b2e6c2a27d1ef3b0a2</anchor>
      <arglist>(float d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2f &amp;</type>
      <name>operator/=</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>a485f2867b40967c4d75f2c2369bdc982</anchor>
      <arglist>(float d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2f &amp;</type>
      <name>operator+=</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>acfa72ec47271a175e83aa4ea3de95cc0</anchor>
      <arglist>(const SbVec2f &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2f &amp;</type>
      <name>operator-=</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>ae142bb7c371783d7ad7f69c3d4193560</anchor>
      <arglist>(const SbVec2f &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2f</type>
      <name>operator-</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>a91922cc9cd9fb7f713ff290792fbd286</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SbString</type>
      <name>toString</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>a5774ff5c9f0a33121cdd310e9e7e965a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>fromString</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>a5b8c2115eded5cbd4009a451e81b6466</anchor>
      <arglist>(const SbString &amp;str)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>a68f630c43b88431884124295d7158575</anchor>
      <arglist>(FILE *fp) const </arglist>
    </member>
    <member kind="function">
      <type>SbVec2f</type>
      <name>operator*</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>af85a55a861e50ed5ad7d65c4e832d2b5</anchor>
      <arglist>(const SbVec2f &amp;v, float d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2f</type>
      <name>operator*</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>a140633ec6be9373641446923dcad1c23</anchor>
      <arglist>(float d, const SbVec2f &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2f</type>
      <name>operator/</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>ae241274f86f09257c43312082f79c11e</anchor>
      <arglist>(const SbVec2f &amp;v, float d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2f</type>
      <name>operator+</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>a833644ab1c9540c85936d53902343dbc</anchor>
      <arglist>(const SbVec2f &amp;v1, const SbVec2f &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2f</type>
      <name>operator-</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>ad7705425b46b63001e60b15ac5a7e609</anchor>
      <arglist>(const SbVec2f &amp;v1, const SbVec2f &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>afc60d5b71be030e65e2b48b777fe2f04</anchor>
      <arglist>(const SbVec2f &amp;v1, const SbVec2f &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbVec2f.html</anchorfile>
      <anchor>a486b82cdb61e5ebe1c55040425257f63</anchor>
      <arglist>(const SbVec2f &amp;v1, const SbVec2f &amp;v2)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbVec2i32</name>
    <filename>classSbVec2i32.html</filename>
    <member kind="function">
      <type></type>
      <name>SbVec2i32</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>a61e4389eec4df5c60d8a2541a53dad61</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec2i32</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>ad59bbb7800e85102cd79ab426a2cca7e</anchor>
      <arglist>(const int32_t v[2])</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec2i32</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>a63207a149dd902f2fd4efa6ed344ff0d</anchor>
      <arglist>(int32_t x, int32_t y)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec2i32</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>aa6ae02dc4997eb8b8733f8058973b86c</anchor>
      <arglist>(const SbVec2ui32 &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec2i32</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>afcd070a1d22281da4ac07c475fe39cf7</anchor>
      <arglist>(const SbVec2b &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec2i32</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>a5c0bce7d90fca72b17032fd674c58ed6</anchor>
      <arglist>(const SbVec2s &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec2i32</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>a60131c056aa7c115e2513257412ba168</anchor>
      <arglist>(const SbVec2f &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec2i32</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>aa43fbef9688c1eb7a5e60c5e09c617ce</anchor>
      <arglist>(const SbVec2d &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2i32 &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>a8b97efa83369d7bf3d8deb0bcff7fe50</anchor>
      <arglist>(const int32_t v[2])</arglist>
    </member>
    <member kind="function">
      <type>SbVec2i32 &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>ad49d532be08ccf4d9ffefdb198b73055</anchor>
      <arglist>(int32_t x, int32_t y)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2i32 &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>a52e224026a651fdd3ed21aa078ff30c0</anchor>
      <arglist>(const SbVec2ui32 &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2i32 &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>aa1791190f26a7336931c0a7d660be05e</anchor>
      <arglist>(const SbVec2b &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2i32 &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>a37fe9378a81cd3ebc6ae4a23fba34b0f</anchor>
      <arglist>(const SbVec2s &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2i32 &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>ac5cb93e79d042c64c45094f7b56d643c</anchor>
      <arglist>(const SbVec2f &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2i32 &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>aff9883884b8de7439fba08700679678f</anchor>
      <arglist>(const SbVec2d &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>const int32_t *</type>
      <name>getValue</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>aaaa3b2880e0833dc63c180cf97db6817</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getValue</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>aa22ee9b640806424e831791539007550</anchor>
      <arglist>(int32_t &amp;x, int32_t &amp;y) const </arglist>
    </member>
    <member kind="function">
      <type>int32_t &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>a9cb52ebe0108572eb79141b2cb2bd347</anchor>
      <arglist>(const int i)</arglist>
    </member>
    <member kind="function">
      <type>const int32_t &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>a66f3b50a93ca28e0ebc8374724e0ffbc</anchor>
      <arglist>(const int i) const </arglist>
    </member>
    <member kind="function">
      <type>int32_t</type>
      <name>dot</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>ad1f6e8ecd1ddd78d90e69406e3319436</anchor>
      <arglist>(const SbVec2i32 &amp;v) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>negate</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>a8375dc369919c84c71c8dc890353a93a</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2i32 &amp;</type>
      <name>operator*=</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>a69f3a02de524b32ae9093895fefe4137</anchor>
      <arglist>(int d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2i32 &amp;</type>
      <name>operator*=</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>ae72687d6fd9bf9ab916937e3df71e438</anchor>
      <arglist>(double d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2i32 &amp;</type>
      <name>operator/=</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>a56e63433419e83d2032e186be949faba</anchor>
      <arglist>(int d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2i32 &amp;</type>
      <name>operator/=</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>a0371eb39aaf87ea431621c900914a8e2</anchor>
      <arglist>(double d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2i32 &amp;</type>
      <name>operator+=</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>acd086b0892a1e4db6a455d7de07de539</anchor>
      <arglist>(const SbVec2i32 &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2i32 &amp;</type>
      <name>operator-=</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>a1886ed6e73f786043aee2a2c5661d321</anchor>
      <arglist>(const SbVec2i32 &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2i32</type>
      <name>operator-</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>a0139e533c26f3c1e176726065505efd8</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>af1d14c194142f91e7f6ef98154ca57d8</anchor>
      <arglist>(FILE *fp) const </arglist>
    </member>
    <member kind="function">
      <type>SbVec2i32</type>
      <name>operator*</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>add94a0d66b3532a8caab83bbb5f9b3b1</anchor>
      <arglist>(const SbVec2i32 &amp;v, int d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2i32</type>
      <name>operator*</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>a1711661c6358b10a93ecbcde9382d960</anchor>
      <arglist>(const SbVec2i32 &amp;v, double d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2i32</type>
      <name>operator*</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>a704de48696f1392dd9e0f688db7ea4fb</anchor>
      <arglist>(int d, const SbVec2i32 &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2i32</type>
      <name>operator*</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>aa0b5803367782d4a783504fc729deff9</anchor>
      <arglist>(double d, const SbVec2i32 &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2i32</type>
      <name>operator/</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>ac56ca284a16ec1723a03ce26c4c5f682</anchor>
      <arglist>(const SbVec2i32 &amp;v, int d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2i32</type>
      <name>operator/</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>a17b0be4cc751a41ff8423359ed754c03</anchor>
      <arglist>(const SbVec2i32 &amp;v, double d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2i32</type>
      <name>operator+</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>ac0679ae7383def6697ac3e649e8fbfe5</anchor>
      <arglist>(const SbVec2i32 &amp;v1, const SbVec2i32 &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2i32</type>
      <name>operator-</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>a31768d5c34d39849be6586176dae6f85</anchor>
      <arglist>(const SbVec2i32 &amp;v1, const SbVec2i32 &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>ab90407c32069ca2fed431d5db3633771</anchor>
      <arglist>(const SbVec2i32 &amp;v1, const SbVec2i32 &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbVec2i32.html</anchorfile>
      <anchor>a9eec58ef56baf761ade75e659ab6dabe</anchor>
      <arglist>(const SbVec2i32 &amp;v1, const SbVec2i32 &amp;v2)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbVec2s</name>
    <filename>classSbVec2s.html</filename>
    <member kind="function">
      <type></type>
      <name>SbVec2s</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>a949d11f0e5baf23139d37077d86c8668</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec2s</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>a81a132782d39edfd8aa9637551d9cab1</anchor>
      <arglist>(const short v[2])</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec2s</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>a164465f376cdb9154aaa07fda5419efa</anchor>
      <arglist>(short x, short y)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec2s</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>af847eda487ca16d780c0150144e1154d</anchor>
      <arglist>(const SbVec2us &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec2s</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>a1e4b9ff96307591762b7c5b3e7e2c214</anchor>
      <arglist>(const SbVec2b &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec2s</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>a5287c7f1a1a8c5ca4bad9ada3f79da3a</anchor>
      <arglist>(const SbVec2i32 &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec2s</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>a8365abe07d53394660dba57b699d36a9</anchor>
      <arglist>(const SbVec2f &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec2s</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>aa4e1abdb20854f571736e316de7cc683</anchor>
      <arglist>(const SbVec2d &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2s &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>a749320fbf358f1101ba7c25a1ba1a3b8</anchor>
      <arglist>(const short v[2])</arglist>
    </member>
    <member kind="function">
      <type>SbVec2s &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>a7cf9b71b29cb2e8e959d231f5832f85e</anchor>
      <arglist>(short x, short y)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2s &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>a94dbeefccf4638ac09a5d739d1c96c0b</anchor>
      <arglist>(const SbVec2us &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2s &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>ac36f7b2d4621000432abf7b1a7c7419c</anchor>
      <arglist>(const SbVec2b &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2s &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>a9079068a737e916a72b475e970922156</anchor>
      <arglist>(const SbVec2i32 &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2s &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>a57e93cf652fab9f7d970386dccd41d50</anchor>
      <arglist>(const SbVec2f &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2s &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>a8527511481b416340acede23b547bb4a</anchor>
      <arglist>(const SbVec2d &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>const short *</type>
      <name>getValue</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>af0b03b94fb74fe27e19eedaac45f3c4b</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getValue</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>ace4d7b62486aec23623e3e1a9d2e61d2</anchor>
      <arglist>(short &amp;x, short &amp;y) const </arglist>
    </member>
    <member kind="function">
      <type>short &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>ae587f3baf9a51d5a27f5749ef1250ec1</anchor>
      <arglist>(int i)</arglist>
    </member>
    <member kind="function">
      <type>const short &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>aafd87817fc4726dfd7bb82377c4b104e</anchor>
      <arglist>(int i) const </arglist>
    </member>
    <member kind="function">
      <type>int32_t</type>
      <name>dot</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>a4107393b7353b5ea585caba6e4c3cb3c</anchor>
      <arglist>(SbVec2s v) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>negate</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>ab1a9e1cdd67a4ca519e91c60ab4cb477</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2s &amp;</type>
      <name>operator*=</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>adb491459cb1087ec53f77ec81d5c19c7</anchor>
      <arglist>(int d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2s &amp;</type>
      <name>operator*=</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>a620828c4fb519e299eecfc0c5a2c2153</anchor>
      <arglist>(double d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2s &amp;</type>
      <name>operator/=</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>ac5864539fcf034cd700a9ed0a3c2951f</anchor>
      <arglist>(int d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2s &amp;</type>
      <name>operator/=</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>ad8f0d4947c757fa8a7fb080b77ed2216</anchor>
      <arglist>(double d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2s &amp;</type>
      <name>operator+=</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>a66bc5e12845fdb529c78cdf2369d832b</anchor>
      <arglist>(SbVec2s v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2s &amp;</type>
      <name>operator-=</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>a68d74241813333fdf0a7c8297120cac5</anchor>
      <arglist>(SbVec2s v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2s</type>
      <name>operator-</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>a7646c3cf72bae0391398a796d443c9ae</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SbString</type>
      <name>toString</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>af8575684136c09b11a575e6b0d64aa61</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>fromString</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>a748fddd3cd777af3474334b4e349897e</anchor>
      <arglist>(const SbString &amp;str)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>a23d77487485f32caa794527405424ae4</anchor>
      <arglist>(FILE *fp) const </arglist>
    </member>
    <member kind="function">
      <type>SbVec2s</type>
      <name>operator*</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>a5221675e922038fc41bba38c50c67d50</anchor>
      <arglist>(const SbVec2s &amp;v, int d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2s</type>
      <name>operator*</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>a25e4787e9b198ad65308ab2ee49bff3f</anchor>
      <arglist>(const SbVec2s &amp;v, double d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2s</type>
      <name>operator*</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>ae5cd1a0742d4f664500b3cf6882e2265</anchor>
      <arglist>(int d, const SbVec2s &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2s</type>
      <name>operator*</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>a3248bf507756da3eecf357391618f102</anchor>
      <arglist>(double d, const SbVec2s &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2s</type>
      <name>operator/</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>a0da97de4ad79429159ef2a7e9d9b9c75</anchor>
      <arglist>(const SbVec2s &amp;v, int d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2s</type>
      <name>operator/</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>a4997afc77f28a86590c3b56851ac7653</anchor>
      <arglist>(const SbVec2s &amp;v, double d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2s</type>
      <name>operator+</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>aa0e3205ce44f1b1834fcd95f90b370e7</anchor>
      <arglist>(const SbVec2s &amp;v1, const SbVec2s &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>SbVec2s</type>
      <name>operator-</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>a0d9471171e0850999d1ea739c791db64</anchor>
      <arglist>(const SbVec2s &amp;v1, const SbVec2s &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>a5e0d9c3c70b584ef527896aab18d0c8c</anchor>
      <arglist>(const SbVec2s &amp;v1, const SbVec2s &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbVec2s.html</anchorfile>
      <anchor>a2cac79faa94b112ba7aef64565c7cede</anchor>
      <arglist>(const SbVec2s &amp;v1, const SbVec2s &amp;v2)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbVec2ub</name>
    <filename>classSbVec2ub.html</filename>
  </compound>
  <compound kind="class">
    <name>SbVec2ui32</name>
    <filename>classSbVec2ui32.html</filename>
  </compound>
  <compound kind="class">
    <name>SbVec2us</name>
    <filename>classSbVec2us.html</filename>
  </compound>
  <compound kind="class">
    <name>SbVec3b</name>
    <filename>classSbVec3b.html</filename>
  </compound>
  <compound kind="class">
    <name>SbVec3d</name>
    <filename>classSbVec3d.html</filename>
    <member kind="function">
      <type></type>
      <name>SbVec3d</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>a8eadb0adc327684c460881ae81253e12</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec3d</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>a6d5c6a6082b72c55aae88e23acd843c1</anchor>
      <arglist>(const double v[3])</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec3d</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>a48aba5218dae1458533f87b178da6c5a</anchor>
      <arglist>(double x, double y, double z)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec3d</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>a823106c1f8611953022ce6e422631d6d</anchor>
      <arglist>(const SbVec3f &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec3d</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>a0c4266b3b2c8d12bb6a4cc36583b64af</anchor>
      <arglist>(const SbVec3b &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec3d</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>a278090650beed389e86fb29070a27f20</anchor>
      <arglist>(const SbVec3s &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec3d</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>aa2ba794348f9bed86b80853790cae5a0</anchor>
      <arglist>(const SbVec3i32 &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec3d</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>adddf72fdfe5999442b9ca0ed2f781d9c</anchor>
      <arglist>(const SbDPPlane &amp;p0, const SbDPPlane &amp;p1, const SbDPPlane &amp;p2)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3d &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>a3502ebf227e379148924170d37d1d91b</anchor>
      <arglist>(const double v[3])</arglist>
    </member>
    <member kind="function">
      <type>SbVec3d &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>af33229ecf26ed9181b9560f2cf2cfd45</anchor>
      <arglist>(double x, double y, double z)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3d &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>a1767493fbe105a21443784c1401a8197</anchor>
      <arglist>(const SbVec3d &amp;barycentric, const SbVec3d &amp;v0, const SbVec3d &amp;v1, const SbVec3d &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3d &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>ac5a6c3d7be0b7515767823eb5128c712</anchor>
      <arglist>(const SbVec3f &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3d &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>abbf3097826dee7efb5e27e1816b5520a</anchor>
      <arglist>(const SbVec3b &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3d &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>af2213f41172c01715105e62441ee3e32</anchor>
      <arglist>(const SbVec3s &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3d &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>ac9d45642a2188d2fd3ca9d3a3a1b74d8</anchor>
      <arglist>(const SbVec3i32 &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>const double *</type>
      <name>getValue</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>a3c7752979790cf79dcb1a2d142e24cd0</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getValue</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>a229990b034ac29b804df0c0fd82fccd3</anchor>
      <arglist>(double &amp;x, double &amp;y, double &amp;z) const </arglist>
    </member>
    <member kind="function">
      <type>double &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>a62efe1c7f2ff4889b66c72c444aca348</anchor>
      <arglist>(const int i)</arglist>
    </member>
    <member kind="function">
      <type>const double &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>a56ba55a640920f895e38e46211211473</anchor>
      <arglist>(const int i) const </arglist>
    </member>
    <member kind="function">
      <type>SbVec3d</type>
      <name>cross</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>ac6df9286890b5c2beb6421c4149ed754</anchor>
      <arglist>(const SbVec3d &amp;v) const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>dot</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>af7461180b134fd94eca26edc9ca9f2a4</anchor>
      <arglist>(const SbVec3d &amp;v) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>equals</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>ad10c722e0e09df8bde90b96e28a9fb81</anchor>
      <arglist>(const SbVec3d &amp;v, double tolerance) const </arglist>
    </member>
    <member kind="function">
      <type>SbVec3d</type>
      <name>getClosestAxis</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>a4fce1116dd4e23c854ade26f7da14c54</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>length</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>acd55215365e30dd2755a92c50c269d55</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>sqrLength</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>abb278c6eccf60c06f3b79adda21588d5</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>negate</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>acd1ac1abcfc3e3ed33da1d00a16e0b26</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>normalize</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>a18665ea58a934c30bf0c1c6514756906</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3d &amp;</type>
      <name>operator*=</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>a5e8c9c3639bba11ce7d0a8f9979b9734</anchor>
      <arglist>(double d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3d &amp;</type>
      <name>operator/=</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>afd49d1b1b565338d01143c800dd5a01f</anchor>
      <arglist>(double d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3d &amp;</type>
      <name>operator+=</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>a168f773bc5d03cea72b7b6e195f3b5b9</anchor>
      <arglist>(const SbVec3d &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3d &amp;</type>
      <name>operator-=</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>aeb66ed4671c530add3355deb25dd551a</anchor>
      <arglist>(const SbVec3d &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3d</type>
      <name>operator-</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>a69ea7dfc7770859935cd95d6c32af976</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SbString</type>
      <name>toString</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>ac26323bde6d8de6f24f33005d06b5ebb</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>fromString</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>afccce23ff5d0cbc4be2afacfd7981542</anchor>
      <arglist>(const SbString &amp;str)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>a6ab02454ed758a43c33212a71f548076</anchor>
      <arglist>(FILE *fp) const </arglist>
    </member>
    <member kind="function">
      <type>SbVec3d</type>
      <name>operator*</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>ab89d6a719951db2488c8bdb326da998e</anchor>
      <arglist>(const SbVec3d &amp;v, double d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3d</type>
      <name>operator*</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>adff62fee69aa44d6fb8dfc1406234f02</anchor>
      <arglist>(double d, const SbVec3d &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3d</type>
      <name>operator/</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>afa88edac3a167324bd3f1244b00a4cde</anchor>
      <arglist>(const SbVec3d &amp;v, double d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3d</type>
      <name>operator+</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>aeb666d8a1c045ccf8bcb6e7cb7dc2031</anchor>
      <arglist>(const SbVec3d &amp;v1, const SbVec3d &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3d</type>
      <name>operator-</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>af0c8316a21d5cf3059da242c43673328</anchor>
      <arglist>(const SbVec3d &amp;v1, const SbVec3d &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>a6274cf58ed1a8882288f72ea5ae2cee3</anchor>
      <arglist>(const SbVec3d &amp;v1, const SbVec3d &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbVec3d.html</anchorfile>
      <anchor>a1940e03f88535e05b9fcf5afd573993e</anchor>
      <arglist>(const SbVec3d &amp;v1, const SbVec3d &amp;v2)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbVec3f</name>
    <filename>classSbVec3f.html</filename>
  </compound>
  <compound kind="class">
    <name>SbVec3fList</name>
    <filename>classSbVec3fList.html</filename>
    <base>SbPList</base>
    <member kind="function">
      <type></type>
      <name>SbVec3fList</name>
      <anchorfile>classSbVec3fList.html</anchorfile>
      <anchor>a1e7610fb5a9ce564075095b632f6b322</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbVec3fList</name>
      <anchorfile>classSbVec3fList.html</anchorfile>
      <anchor>a8fcd4eb25a06eba2bc6dcfb9d3287c45</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSbVec3fList.html</anchorfile>
      <anchor>a9899c06fc9b57c6d203c542791bba3c6</anchor>
      <arglist>(const SbVec3f *item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSbVec3fList.html</anchorfile>
      <anchor>adc8c71f530c7b2cdd6e2c61c07b84e92</anchor>
      <arglist>(const SbVec3f *item, const int insertbefore)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f *</type>
      <name>operator[]</name>
      <anchorfile>classSbVec3fList.html</anchorfile>
      <anchor>a3935b67deed30958ceebab1bf5a71e86</anchor>
      <arglist>(const int idx) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbVec3i32</name>
    <filename>classSbVec3i32.html</filename>
  </compound>
  <compound kind="class">
    <name>SbVec3s</name>
    <filename>classSbVec3s.html</filename>
    <member kind="function">
      <type></type>
      <name>SbVec3s</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>a8a17743467745471b1b30c6bf00a181a</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec3s</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>a31fd3dc5ec1fddb163f9f6a88ae89190</anchor>
      <arglist>(const short v[3])</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec3s</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>adc03f5041b94c89f8e5f3f62c653a746</anchor>
      <arglist>(short x, short y, short z)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec3s</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>a2678145a4a2f7292f6e0ab74847ed823</anchor>
      <arglist>(const SbVec3us &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec3s</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>af11345b4ad1e0e22df232888f20f175c</anchor>
      <arglist>(const SbVec3b &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec3s</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>ae5b06878f494b039ad77a1a8edabc384</anchor>
      <arglist>(const SbVec3i32 &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec3s</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>af7f0f60434502a96320805da1129e2ca</anchor>
      <arglist>(const SbVec3f &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec3s</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>a87ebb005dda25e4028180796dc718da9</anchor>
      <arglist>(const SbVec3d &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3s &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>a13bcd6f18c9b72e0398932ebc2c3f2be</anchor>
      <arglist>(const short v[3])</arglist>
    </member>
    <member kind="function">
      <type>SbVec3s &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>a7b3b315d4c4ee43904b574e55413987b</anchor>
      <arglist>(const SbVec3us &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3s &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>aaa8e79640bc4dabb9bd3e2c7bd577e0c</anchor>
      <arglist>(const SbVec3b &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3s &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>a508bfa34c7c89ef64cd756467970ee39</anchor>
      <arglist>(const SbVec3i32 &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3s &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>a301642f2b0250ceaae2cc92cbcd64612</anchor>
      <arglist>(const SbVec3f &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3s &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>ad75c16547603db047d2dde75f0f86808</anchor>
      <arglist>(const SbVec3d &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>const short *</type>
      <name>getValue</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>a502fec3919ce6e5ae80f30b77a7b07d6</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getValue</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>a40172f9d6dce70b746e9eb094556077b</anchor>
      <arglist>(short &amp;x, short &amp;y, short &amp;z) const </arglist>
    </member>
    <member kind="function">
      <type>short &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>aaa6622340cee55ca1b64ead2dfc6d2ee</anchor>
      <arglist>(int i)</arglist>
    </member>
    <member kind="function">
      <type>const short &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>aa1f9f28f093154dca582c062c9a1587c</anchor>
      <arglist>(int i) const </arglist>
    </member>
    <member kind="function">
      <type>int32_t</type>
      <name>dot</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>a7bbf8d8436c367d776a31e68956259b7</anchor>
      <arglist>(const SbVec3s &amp;v) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>negate</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>a38e6999933ca957c0af4ab78e07b8a67</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3s &amp;</type>
      <name>operator*=</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>a720cd5ffc9f2db83119ae9147a46d791</anchor>
      <arglist>(int d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3s &amp;</type>
      <name>operator*=</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>a0374a739323fd020d463fd20bb150935</anchor>
      <arglist>(double d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3s &amp;</type>
      <name>operator/=</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>a40824232039d0b271ca7f0543d95197c</anchor>
      <arglist>(int d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3s &amp;</type>
      <name>operator/=</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>a1ca5b77e6a490548f857b6d94e6a0638</anchor>
      <arglist>(double d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3s &amp;</type>
      <name>operator+=</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>a58cea8166e2a1705f15322da77f4927d</anchor>
      <arglist>(const SbVec3s &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3s &amp;</type>
      <name>operator-=</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>aef82255498882ba2ba3041f4113034cc</anchor>
      <arglist>(const SbVec3s &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3s</type>
      <name>operator-</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>aff0430528c83a8f9f060437389eb5763</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SbString</type>
      <name>toString</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>ac7585dd3a279c0a646eb256324885a4d</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>fromString</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>a1560b584ee7714f1d43cb0e997f1c511</anchor>
      <arglist>(const SbString &amp;str)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>a235d9a29c7cb17fb8998a45579762b76</anchor>
      <arglist>(FILE *fp) const </arglist>
    </member>
    <member kind="function">
      <type>SbVec3s</type>
      <name>operator*</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>a12b8f0a890e6bd3db0af00688c1f5a9e</anchor>
      <arglist>(const SbVec3s &amp;v, int d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3s</type>
      <name>operator*</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>a0823116c5c7ab79f9ba5edaf50d940d3</anchor>
      <arglist>(const SbVec3s &amp;v, double d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3s</type>
      <name>operator*</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>a0788806ebdea7d7629c2fd3e5870828c</anchor>
      <arglist>(int d, const SbVec3s &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3s</type>
      <name>operator*</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>a2234b3b8fd74475bf03709ba0dce6839</anchor>
      <arglist>(double d, const SbVec3s &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3s</type>
      <name>operator/</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>a03691fd07c4ea890fbd6e64a218b3003</anchor>
      <arglist>(const SbVec3s &amp;v, int d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3s</type>
      <name>operator/</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>a4ab17190eb376a2158952bff4561839a</anchor>
      <arglist>(const SbVec3s &amp;v, double d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3s</type>
      <name>operator+</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>a0fae636d216f98ed3bc952f87c2b76e7</anchor>
      <arglist>(const SbVec3s &amp;v1, const SbVec3s &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3s</type>
      <name>operator-</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>aa2c20aecadbd48a78c765d80f779f7bf</anchor>
      <arglist>(const SbVec3s &amp;v1, const SbVec3s &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>a17f16774265457801b432b293eaed06a</anchor>
      <arglist>(const SbVec3s &amp;v1, const SbVec3s &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbVec3s.html</anchorfile>
      <anchor>a3559605a112446e3796c80b87e6389d1</anchor>
      <arglist>(const SbVec3s &amp;v1, const SbVec3s &amp;v2)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbVec3ub</name>
    <filename>classSbVec3ub.html</filename>
  </compound>
  <compound kind="class">
    <name>SbVec3ui32</name>
    <filename>classSbVec3ui32.html</filename>
  </compound>
  <compound kind="class">
    <name>SbVec3us</name>
    <filename>classSbVec3us.html</filename>
  </compound>
  <compound kind="class">
    <name>SbVec4b</name>
    <filename>classSbVec4b.html</filename>
  </compound>
  <compound kind="class">
    <name>SbVec4d</name>
    <filename>classSbVec4d.html</filename>
    <member kind="function">
      <type></type>
      <name>SbVec4d</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>ac7b884bfbc3a4b9ce649cdb59de77c79</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec4d</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>a4b144ff8a8ac21844af1a5b3726116fa</anchor>
      <arglist>(const double v[4])</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec4d</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>a0837c17f58fa7dcec2691c541518aece</anchor>
      <arglist>(double x, double y, double z, double w)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec4d</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>aee7e6576a17bc24a36855fe435afb4f1</anchor>
      <arglist>(const SbVec4f &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec4d</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>ac01e33c7da04a3a6a5cc6c3fd6283d44</anchor>
      <arglist>(const SbVec4b &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec4d</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>ac1efc8004cd66e8db305e3ceedf10115</anchor>
      <arglist>(const SbVec4s &amp;v)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbVec4d</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>ae434ea3369094a66f4f2248fdade51d5</anchor>
      <arglist>(const SbVec4i32 &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec4d &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>a3935367aceacc5ec86a5e6e696f89e60</anchor>
      <arglist>(const double v[4])</arglist>
    </member>
    <member kind="function">
      <type>SbVec4d &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>ade3661a30bd5f8b3eb0304d0f473a5e0</anchor>
      <arglist>(double x, double y, double z, double w)</arglist>
    </member>
    <member kind="function">
      <type>SbVec4d &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>a47b57f921f695d62482ed7bab91113d2</anchor>
      <arglist>(const SbVec4f &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec4d &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>ae09ccacd8d4a66f1da6e9e1c256ce9b4</anchor>
      <arglist>(const SbVec4b &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec4d &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>a675ded6aca0f8ef91ac9bf30ad8e1ac8</anchor>
      <arglist>(const SbVec4s &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec4d &amp;</type>
      <name>setValue</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>a2a3136bdafc59fcf0fb4205b0efbeca1</anchor>
      <arglist>(const SbVec4i32 &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>const double *</type>
      <name>getValue</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>a6299815f67264a71fcf2df4e8a40bd63</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getValue</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>ae6b9ac4bc5f996c9bf4c5fcf814734ec</anchor>
      <arglist>(double &amp;x, double &amp;y, double &amp;z, double &amp;w) const </arglist>
    </member>
    <member kind="function">
      <type>double &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>a351373dbd4dd29a1c7fe8a0da5d6761c</anchor>
      <arglist>(int i)</arglist>
    </member>
    <member kind="function">
      <type>const double &amp;</type>
      <name>operator[]</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>ab69511ea29e5e811f90d27c028db9367</anchor>
      <arglist>(int i) const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>dot</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>a9ed52f41df8638a703b14b7ee0e039d5</anchor>
      <arglist>(const SbVec4d &amp;v) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>equals</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>a726c267da1187fa7ae3a0b4db7cf6ecb</anchor>
      <arglist>(const SbVec4d &amp;v, double tolerance) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getReal</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>a8780e717c447c61f1b95f70c473ebcc2</anchor>
      <arglist>(SbVec3d &amp;v) const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>length</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>aea050b75dedfbf92dfff42994d6f7d36</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>sqrLength</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>aa6fdcd73e0441fc63968e078cbd2ffd0</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>negate</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>ad954080acdc3f04dcf367720462677fd</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>normalize</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>aac6b1ddbae7284245537b7354f7bcc92</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>SbVec4d &amp;</type>
      <name>operator*=</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>a84b928e2bae9c8951bfe58a97fada7d7</anchor>
      <arglist>(double d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec4d &amp;</type>
      <name>operator+=</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>aa53a7b2961acae8d12ab2362b445c951</anchor>
      <arglist>(const SbVec4d &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec4d &amp;</type>
      <name>operator-=</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>ada8b1af27e1fed0ed972140637c56cc8</anchor>
      <arglist>(const SbVec4d &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec4d</type>
      <name>operator-</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>a16a51bbadf6264b2042e01b3dec13ee6</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>a7a492d9ff3804a4983d1593ceae41676</anchor>
      <arglist>(FILE *fp) const </arglist>
    </member>
    <member kind="function">
      <type>SbVec4d</type>
      <name>operator*</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>aafc14f0cd0ce50cabbcc1d4f59f0599f</anchor>
      <arglist>(const SbVec4d &amp;v, double d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec4d</type>
      <name>operator*</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>a38efeb2b0d465bb232847e2a8551e123</anchor>
      <arglist>(double d, const SbVec4d &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec4d</type>
      <name>operator/</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>ae02649fb85b10ede354e713efb7c55fb</anchor>
      <arglist>(const SbVec4d &amp;v, double d)</arglist>
    </member>
    <member kind="function">
      <type>SbVec4d</type>
      <name>operator+</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>a7e01a6afd5a4380ae240805cd96744c2</anchor>
      <arglist>(const SbVec4d &amp;v1, const SbVec4d &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>SbVec4d</type>
      <name>operator-</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>a07e36b6b71e7d092c5dc047f02f21572</anchor>
      <arglist>(const SbVec4d &amp;v1, const SbVec4d &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator==</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>a38923a1aab2ce280682f0c33f7229789</anchor>
      <arglist>(const SbVec4d &amp;v1, const SbVec4d &amp;v2)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>operator!=</name>
      <anchorfile>classSbVec4d.html</anchorfile>
      <anchor>a62d2ed55527d44f10f5b429c0182876e</anchor>
      <arglist>(const SbVec4d &amp;v1, const SbVec4d &amp;v2)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbVec4f</name>
    <filename>classSbVec4f.html</filename>
  </compound>
  <compound kind="class">
    <name>SbVec4i32</name>
    <filename>classSbVec4i32.html</filename>
  </compound>
  <compound kind="class">
    <name>SbVec4s</name>
    <filename>classSbVec4s.html</filename>
  </compound>
  <compound kind="class">
    <name>SbVec4ub</name>
    <filename>classSbVec4ub.html</filename>
  </compound>
  <compound kind="class">
    <name>SbVec4ui32</name>
    <filename>classSbVec4ui32.html</filename>
  </compound>
  <compound kind="class">
    <name>SbViewportRegion</name>
    <filename>classSbViewportRegion.html</filename>
    <member kind="function">
      <type></type>
      <name>SbViewportRegion</name>
      <anchorfile>classSbViewportRegion.html</anchorfile>
      <anchor>af522056ea9d27359b03cb2b88536f0e2</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbViewportRegion</name>
      <anchorfile>classSbViewportRegion.html</anchorfile>
      <anchor>af415380060c898ed123ba1b3cf120802</anchor>
      <arglist>(short width, short height)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbViewportRegion</name>
      <anchorfile>classSbViewportRegion.html</anchorfile>
      <anchor>a9573bcfcce0b7e9ffa774d82f0fc09ad</anchor>
      <arglist>(SbVec2s winSize)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbViewportRegion</name>
      <anchorfile>classSbViewportRegion.html</anchorfile>
      <anchor>a8b9832f4a55148a0553529c1c6cc0966</anchor>
      <arglist>(const SbViewportRegion &amp;vpReg)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setWindowSize</name>
      <anchorfile>classSbViewportRegion.html</anchorfile>
      <anchor>a0ae54dc0d8416d2cccdb0b3d6d3ae640</anchor>
      <arglist>(short width, short height)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setWindowSize</name>
      <anchorfile>classSbViewportRegion.html</anchorfile>
      <anchor>a8772016f85c60dd7737eabca3483f0da</anchor>
      <arglist>(SbVec2s winSize)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setViewport</name>
      <anchorfile>classSbViewportRegion.html</anchorfile>
      <anchor>aee9986763e2234c411c8822206db539d</anchor>
      <arglist>(float left, float bottom, float width, float height)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setViewport</name>
      <anchorfile>classSbViewportRegion.html</anchorfile>
      <anchor>ad5f9e32fb1fde9ea5825572c76d06e57</anchor>
      <arglist>(SbVec2f origin, SbVec2f size)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setViewportPixels</name>
      <anchorfile>classSbViewportRegion.html</anchorfile>
      <anchor>a2977b42c205177a6e89b3860fd823951</anchor>
      <arglist>(short left, short bottom, short width, short height)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setViewportPixels</name>
      <anchorfile>classSbViewportRegion.html</anchorfile>
      <anchor>a98cd719e0afc2b942f0cd99110b8aff0</anchor>
      <arglist>(SbVec2s origin, SbVec2s size)</arglist>
    </member>
    <member kind="function">
      <type>const SbVec2s &amp;</type>
      <name>getWindowSize</name>
      <anchorfile>classSbViewportRegion.html</anchorfile>
      <anchor>a1a45d79dc096e081c3b2d47aec122531</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>const SbVec2f &amp;</type>
      <name>getViewportOrigin</name>
      <anchorfile>classSbViewportRegion.html</anchorfile>
      <anchor>abff18efe5fbac028929a5a59e2422fd9</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>const SbVec2s &amp;</type>
      <name>getViewportOriginPixels</name>
      <anchorfile>classSbViewportRegion.html</anchorfile>
      <anchor>a9f44010af49a6646ca6e584b2922d585</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>const SbVec2f &amp;</type>
      <name>getViewportSize</name>
      <anchorfile>classSbViewportRegion.html</anchorfile>
      <anchor>a2a26d4d33e2dc855e6b413a1d842620e</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>const SbVec2s &amp;</type>
      <name>getViewportSizePixels</name>
      <anchorfile>classSbViewportRegion.html</anchorfile>
      <anchor>a18fc6778e0c34a74ed2b40a08e9c52d8</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getViewportAspectRatio</name>
      <anchorfile>classSbViewportRegion.html</anchorfile>
      <anchor>a3cd6ad89d36e1785cd78502cce109831</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>scaleWidth</name>
      <anchorfile>classSbViewportRegion.html</anchorfile>
      <anchor>a11855a05e9ed450a22cddffdcb373e58</anchor>
      <arglist>(float ratio)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>scaleHeight</name>
      <anchorfile>classSbViewportRegion.html</anchorfile>
      <anchor>ab3249cb0a55be9ced4681951283a176e</anchor>
      <arglist>(float ratio)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPixelsPerInch</name>
      <anchorfile>classSbViewportRegion.html</anchorfile>
      <anchor>a13bf92c587ea65ea35bafbd342b11d44</anchor>
      <arglist>(float ppi)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getPixelsPerInch</name>
      <anchorfile>classSbViewportRegion.html</anchorfile>
      <anchor>a5da22464468f5e09f14b2c0b53768677</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getPixelsPerPoint</name>
      <anchorfile>classSbViewportRegion.html</anchorfile>
      <anchor>add259b948edb8f5a95b8739b63497e72</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classSbViewportRegion.html</anchorfile>
      <anchor>a06f53e143b12459c2a10bf8de961c5aa</anchor>
      <arglist>(FILE *file) const </arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator==</name>
      <anchorfile>classSbViewportRegion.html</anchorfile>
      <anchor>a759c633952740a45c23994bec51fb830</anchor>
      <arglist>(const SbViewportRegion &amp;reg1, const SbViewportRegion &amp;reg2)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator!=</name>
      <anchorfile>classSbViewportRegion.html</anchorfile>
      <anchor>aa4ea8adbc5071d1d32e113fbeaeb1597</anchor>
      <arglist>(const SbViewportRegion &amp;reg1, const SbViewportRegion &amp;reg2)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbViewVolume</name>
    <filename>classSbViewVolume.html</filename>
    <member kind="enumeration">
      <type></type>
      <name>ProjectionType</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a769616c39bae7ee4e78bac640e0bdaf4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>ORTHOGRAPHIC</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a769616c39bae7ee4e78bac640e0bdaf4a19f676b5e880a7189080151156b64337</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>PERSPECTIVE</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a769616c39bae7ee4e78bac640e0bdaf4a9538d7439b5b05a137f9e33f8bd4e014</anchor>
      <arglist></arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbViewVolume</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>acbcf2f7f32cf0e74b4655367b4a8fe94</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbViewVolume</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>abc5d921466ff37e56d462f2d126ab87d</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getMatrices</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>aaf5df672ba977f9b5b4d83e1682f6de9</anchor>
      <arglist>(SbMatrix &amp;affine, SbMatrix &amp;proj) const </arglist>
    </member>
    <member kind="function">
      <type>SbMatrix</type>
      <name>getMatrix</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a5bd9601e086a5b27d3bfd19a6f16a9b0</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SbMatrix</type>
      <name>getCameraSpaceMatrix</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a6415ae9f9f4d5daaaababae549247666</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>projectPointToLine</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a7cfeb60597f0834c09ce41b35774699a</anchor>
      <arglist>(const SbVec2f &amp;pt, SbLine &amp;line) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>projectPointToLine</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>aa41f86414351097ed9299823fdab175c</anchor>
      <arglist>(const SbVec2f &amp;pt, SbVec3f &amp;line0, SbVec3f &amp;line1) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>projectToScreen</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a477a722363ab50a7d0b75af4371dbddc</anchor>
      <arglist>(const SbVec3f &amp;src, SbVec3f &amp;dst) const </arglist>
    </member>
    <member kind="function">
      <type>SbPlane</type>
      <name>getPlane</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a4d2915f546da802d20f297f8afa8fb47</anchor>
      <arglist>(const float distFromEye) const </arglist>
    </member>
    <member kind="function">
      <type>SbVec3f</type>
      <name>getSightPoint</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>aae79513a8eb36402c510ccfcd2a7203d</anchor>
      <arglist>(const float distFromEye) const </arglist>
    </member>
    <member kind="function">
      <type>SbVec3f</type>
      <name>getPlanePoint</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>ad8d8c82474ce1b6c84a342accc813e28</anchor>
      <arglist>(const float distFromEye, const SbVec2f &amp;normPoint) const </arglist>
    </member>
    <member kind="function">
      <type>SbRotation</type>
      <name>getAlignRotation</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a221effb886a5848924f2707b113c9923</anchor>
      <arglist>(SbBool rightAngleOnly=FALSE) const </arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getWorldToScreenScale</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>ac45918c8f816fdd10bd89edf1447c780</anchor>
      <arglist>(const SbVec3f &amp;worldCenter, float normRadius) const </arglist>
    </member>
    <member kind="function">
      <type>SbVec2f</type>
      <name>projectBox</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a90c8bfc8c2826c0ec832c3025bc41df6</anchor>
      <arglist>(const SbBox3f &amp;box) const </arglist>
    </member>
    <member kind="function">
      <type>SbViewVolume</type>
      <name>narrow</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a10f0ca68486f3dc6fa9253e705573d5a</anchor>
      <arglist>(float left, float bottom, float right, float top) const </arglist>
    </member>
    <member kind="function">
      <type>SbViewVolume</type>
      <name>narrow</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>ab0056db207f6a96c7c0892b83217f3bd</anchor>
      <arglist>(const SbBox3f &amp;box) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ortho</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a74cccdb71cc35fb5b3b084917031ebe7</anchor>
      <arglist>(float left, float right, float bottom, float top, float nearval, float farval)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>perspective</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>aa62d154de3ec060318a8bc49d59c5422</anchor>
      <arglist>(float fovy, float aspect, float nearval, float farval)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>frustum</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a3bdbe7dc553465904db3b42fa295b48e</anchor>
      <arglist>(float left, float right, float bottom, float top, float nearval, float farval)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>rotateCamera</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a7f048618c8b356e7cc5af37d81972a5d</anchor>
      <arglist>(const SbRotation &amp;q)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>translateCamera</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a7a29ff8f99f24a9d16defe527ff0fc0f</anchor>
      <arglist>(const SbVec3f &amp;v)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f</type>
      <name>zVector</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>ab702af9ddc8697b134e314e70e84b602</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SbViewVolume</type>
      <name>zNarrow</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a192fb38eabeddd0d2a7fae8cc27fc2a4</anchor>
      <arglist>(float nearval, float farval) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>scale</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a8ba76dfded56d0e9b41a3c4f8adec007</anchor>
      <arglist>(float factor)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>scaleWidth</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a9d2eb384e69810c23df5748342e081d3</anchor>
      <arglist>(float ratio)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>scaleHeight</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a93de473b12e0847fd6aa31a9d143f5c9</anchor>
      <arglist>(float ratio)</arglist>
    </member>
    <member kind="function">
      <type>ProjectionType</type>
      <name>getProjectionType</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>af06b504f57b8eb466f9e0c5409263943</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>const SbVec3f &amp;</type>
      <name>getProjectionPoint</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>ad3d957bb6ec1c6c4fab52778b3cceae0</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>const SbVec3f &amp;</type>
      <name>getProjectionDirection</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a2cb3b07c63a0d809a1470ab2ad5b8f21</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getNearDist</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>ad4e8a159275d69742ca57f2c8b929666</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getWidth</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>ac45e31a043e90e6475e8248d1b12e068</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getHeight</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>adcd3d826f3cf1b15ebd29f8e643e15bd</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getDepth</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a82d1fb3a6211c10da97258d098f14ab6</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a1251fb193ab40917dafc4158a55c14da</anchor>
      <arglist>(FILE *fp) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getViewVolumePlanes</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>ae3f1ef1529f1fb9b20f8e6fede8f09c4</anchor>
      <arglist>(SbPlane planes[6]) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>transform</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a0f836b45107fedfea1a212aeaed38a3e</anchor>
      <arglist>(const SbMatrix &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f</type>
      <name>getViewUp</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a7883d7582364e2b09166a84df7cac841</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a629e0432230dcb411e9d66db4b48c565</anchor>
      <arglist>(const SbVec3f &amp;p) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>aa253278e65ec9e7480d7fb5c981f1b46</anchor>
      <arglist>(const SbVec3f &amp;p0, const SbVec3f &amp;p1, SbVec3f &amp;closestpoint) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a3dfd57079062c0e4d6c1eeda7002be07</anchor>
      <arglist>(const SbBox3f &amp;box) const </arglist>
    </member>
    <member kind="function">
      <type>SbBox3f</type>
      <name>intersectionBox</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>af8b1049cb503fa77675371e14711bab4</anchor>
      <arglist>(const SbBox3f &amp;box) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>outsideTest</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>ae3d998894473b6756d8046aee13b6b81</anchor>
      <arglist>(const SbPlane &amp;p, const SbVec3f &amp;bmin, const SbVec3f &amp;bmax) const </arglist>
    </member>
    <member kind="function">
      <type>const SbDPViewVolume &amp;</type>
      <name>getDPViewVolume</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a2c18508188a5aed2093f61a1ff631d98</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="variable">
      <type>ProjectionType</type>
      <name>type</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a8299568cb7ad6fda09eec92adede6877</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SbVec3f</type>
      <name>projPoint</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>ab473472322064d5b790a0361fc31ec00</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SbVec3f</type>
      <name>projDir</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a3d66037590e6ad2f2ba8d8e63cb72e02</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>float</type>
      <name>nearDist</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a063842c5cf236a3b5351fa4241679730</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>float</type>
      <name>nearToFar</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a6c20b2e40244a5c83d52e97c169d7e0e</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SbVec3f</type>
      <name>llf</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>adf2952f98c0edf4ae4416858d906f3f3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SbVec3f</type>
      <name>lrf</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>a152c5ad6f9182d94dbc8e36bf1c994e2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SbVec3f</type>
      <name>ulf</name>
      <anchorfile>classSbViewVolume.html</anchorfile>
      <anchor>acdeb4aa5b5c465b64a90dddcd8f06ffd</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbXfBox3d</name>
    <filename>classSbXfBox3d.html</filename>
    <base>SbBox3d</base>
    <member kind="function">
      <type></type>
      <name>SbXfBox3d</name>
      <anchorfile>classSbXfBox3d.html</anchorfile>
      <anchor>a44adce59ac262e3deb32a42bc536c824</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbXfBox3d</name>
      <anchorfile>classSbXfBox3d.html</anchorfile>
      <anchor>aec9342cfb81b97f1591e601c7c8f04b1</anchor>
      <arglist>(const SbVec3d &amp;boxmin, const SbVec3d &amp;boxmax)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbXfBox3d</name>
      <anchorfile>classSbXfBox3d.html</anchorfile>
      <anchor>a7b56b4cc56417ef51d429719f2b735e2</anchor>
      <arglist>(const SbBox3d &amp;box)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTransform</name>
      <anchorfile>classSbXfBox3d.html</anchorfile>
      <anchor>acedc78abc26655c9775bc6bfdb35d281</anchor>
      <arglist>(const SbDPMatrix &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type>const SbDPMatrix &amp;</type>
      <name>getTransform</name>
      <anchorfile>classSbXfBox3d.html</anchorfile>
      <anchor>a2cbf251985dd24eddb10183813706c11</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>const SbDPMatrix &amp;</type>
      <name>getInverse</name>
      <anchorfile>classSbXfBox3d.html</anchorfile>
      <anchor>a82126a8078c6fe00f82e62d20b105432</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SbVec3d</type>
      <name>getCenter</name>
      <anchorfile>classSbXfBox3d.html</anchorfile>
      <anchor>a60245ff127d7916dc161e5cecbf6f954</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>extendBy</name>
      <anchorfile>classSbXfBox3d.html</anchorfile>
      <anchor>a8da790ddabc38dedcac25228fe89eef5</anchor>
      <arglist>(const SbVec3d &amp;pt)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>extendBy</name>
      <anchorfile>classSbXfBox3d.html</anchorfile>
      <anchor>a64874cec573cb996acd53e57779ac100</anchor>
      <arglist>(const SbBox3d &amp;bb)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>extendBy</name>
      <anchorfile>classSbXfBox3d.html</anchorfile>
      <anchor>a18392992a10fbbcf77c2c77124492cfd</anchor>
      <arglist>(const SbXfBox3d &amp;bb)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbXfBox3d.html</anchorfile>
      <anchor>a759c0a46239aee73ee7d7dd2b65aac78</anchor>
      <arglist>(const SbVec3d &amp;pt) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbXfBox3d.html</anchorfile>
      <anchor>a51a7909a610b743c1cf5c065b37584c9</anchor>
      <arglist>(const SbBox3d &amp;bb) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbXfBox3d.html</anchorfile>
      <anchor>a5625829df7ef683e001845721714146d</anchor>
      <arglist>(const SbXfBox3d &amp;bb) const </arglist>
    </member>
    <member kind="function">
      <type>SbBox3d</type>
      <name>project</name>
      <anchorfile>classSbXfBox3d.html</anchorfile>
      <anchor>aa88643991ebb23198bc8d2592bcf1d45</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getSpan</name>
      <anchorfile>classSbXfBox3d.html</anchorfile>
      <anchor>a0e42031bc1e756e7c6e1b55cce4204d0</anchor>
      <arglist>(const SbVec3d &amp;direction, double &amp;dMin, double &amp;dMax) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>transform</name>
      <anchorfile>classSbXfBox3d.html</anchorfile>
      <anchor>a6bc269dedda3d499ccd711fb66dd4474</anchor>
      <arglist>(const SbDPMatrix &amp;matrix)</arglist>
    </member>
    <member kind="function">
      <type>double</type>
      <name>getVolume</name>
      <anchorfile>classSbXfBox3d.html</anchorfile>
      <anchor>a46048dc12f5a50f5d6406c542a6055c6</anchor>
      <arglist>(void) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SbXfBox3f</name>
    <filename>classSbXfBox3f.html</filename>
    <base>SbBox3f</base>
    <member kind="function">
      <type></type>
      <name>SbXfBox3f</name>
      <anchorfile>classSbXfBox3f.html</anchorfile>
      <anchor>a2adb39957d667d7bdc8d3b2c73bf03ee</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbXfBox3f</name>
      <anchorfile>classSbXfBox3f.html</anchorfile>
      <anchor>afebdecf40efde099111da9108b6c0f0a</anchor>
      <arglist>(const SbVec3f &amp;boxmin, const SbVec3f &amp;boxmax)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SbXfBox3f</name>
      <anchorfile>classSbXfBox3f.html</anchorfile>
      <anchor>a0434ffabf617a0709fd8906650777425</anchor>
      <arglist>(const SbBox3f &amp;box)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SbXfBox3f</name>
      <anchorfile>classSbXfBox3f.html</anchorfile>
      <anchor>a5f7d0963b5d178faec3752339e08edda</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTransform</name>
      <anchorfile>classSbXfBox3f.html</anchorfile>
      <anchor>a8283248fd57a70c3c9c9fe15a04733f2</anchor>
      <arglist>(const SbMatrix &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>const SbMatrix &amp;</type>
      <name>getTransform</name>
      <anchorfile>classSbXfBox3f.html</anchorfile>
      <anchor>aedbafa6684b44dff0b5248f6541ae9fb</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>const SbMatrix &amp;</type>
      <name>getInverse</name>
      <anchorfile>classSbXfBox3f.html</anchorfile>
      <anchor>a4a35397bc8d3eafb53acdac3f5c7b939</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SbVec3f</type>
      <name>getCenter</name>
      <anchorfile>classSbXfBox3f.html</anchorfile>
      <anchor>a50ad1e2df8b4c2373902abd2194cad54</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>extendBy</name>
      <anchorfile>classSbXfBox3f.html</anchorfile>
      <anchor>af8ea6006198bccfd6857d43fbb853db0</anchor>
      <arglist>(const SbVec3f &amp;pt)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>extendBy</name>
      <anchorfile>classSbXfBox3f.html</anchorfile>
      <anchor>aca7f30a621d18216f8ed2cc9fb621f9a</anchor>
      <arglist>(const SbBox3f &amp;bb)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>extendBy</name>
      <anchorfile>classSbXfBox3f.html</anchorfile>
      <anchor>a05f077bbffbfae38d6a6cdb76aba253f</anchor>
      <arglist>(const SbXfBox3f &amp;bb)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbXfBox3f.html</anchorfile>
      <anchor>a333003a0d994f1d773646c4065b66d93</anchor>
      <arglist>(const SbVec3f &amp;pt) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbXfBox3f.html</anchorfile>
      <anchor>a6424cd04c1c287437f2298c263ef8dd9</anchor>
      <arglist>(const SbBox3f &amp;bb) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>intersect</name>
      <anchorfile>classSbXfBox3f.html</anchorfile>
      <anchor>a2029b20c3ed2342d74c9b43bf6d75d45</anchor>
      <arglist>(const SbXfBox3f &amp;bb) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getSpan</name>
      <anchorfile>classSbXfBox3f.html</anchorfile>
      <anchor>ad90372acfef5c095bb3b68cbf409f116</anchor>
      <arglist>(const SbVec3f &amp;direction, float &amp;dMin, float &amp;dMax) const </arglist>
    </member>
    <member kind="function">
      <type>SbBox3f</type>
      <name>project</name>
      <anchorfile>classSbXfBox3f.html</anchorfile>
      <anchor>a6365153aae3157ac1f6e67a78adbab58</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>transform</name>
      <anchorfile>classSbXfBox3f.html</anchorfile>
      <anchor>a011e2b7df656b970e4bf09937cda6498</anchor>
      <arglist>(const SbMatrix &amp;m)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getVolume</name>
      <anchorfile>classSbXfBox3f.html</anchorfile>
      <anchor>af6732f4fef8dcb3b5917b3c9d8d2ba83</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>print</name>
      <anchorfile>classSbXfBox3f.html</anchorfile>
      <anchor>a3c3d8bbfbe74aac42630c51595045046</anchor>
      <arglist>(FILE *file) const </arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator==</name>
      <anchorfile>classSbXfBox3f.html</anchorfile>
      <anchor>a9b6bfb6e1bad9a583fe7cae59cec244f</anchor>
      <arglist>(const SbXfBox3f &amp;b1, const SbXfBox3f &amp;b2)</arglist>
    </member>
    <member kind="friend">
      <type>friend int</type>
      <name>operator!=</name>
      <anchorfile>classSbXfBox3f.html</anchorfile>
      <anchor>a4a4b5fde749599d4e7db361886b36e72</anchor>
      <arglist>(const SbXfBox3f &amp;b1, const SbXfBox3f &amp;b2)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXML</name>
    <filename>classScXML.html</filename>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>initClasses</name>
      <anchorfile>classScXML.html</anchorfile>
      <anchor>a575021fd42fe7862aeaadef4d79cfc50</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static ScXMLStateMachine *</type>
      <name>readFile</name>
      <anchorfile>classScXML.html</anchorfile>
      <anchor>a1cf5fd33dccf83b71c676b74996c2843</anchor>
      <arglist>(const char *filename)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static ScXMLStateMachine *</type>
      <name>readBuffer</name>
      <anchorfile>classScXML.html</anchorfile>
      <anchor>a94ab99dfd3b0be6d49a521088e59c49a</anchor>
      <arglist>(const SbByteBuffer &amp;buffer)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLAbstractStateElt</name>
    <filename>classScXMLAbstractStateElt.html</filename>
    <base>ScXMLElt</base>
    <member kind="function" virtualness="pure">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLAbstractStateElt.html</anchorfile>
      <anchor>a867c54d30371c84bb914eab9eeca8b60</anchor>
      <arglist>(void) const =0</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>handleXMLAttributes</name>
      <anchorfile>classScXMLAbstractStateElt.html</anchorfile>
      <anchor>aeb4dd3b18eb44246b68770299c6d41e6</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const ScXMLElt *</type>
      <name>search</name>
      <anchorfile>classScXMLAbstractStateElt.html</anchorfile>
      <anchor>a65c343ca45f1ab1d49b35c4eb5b6d7ae</anchor>
      <arglist>(const char *attrname, const char *attrvalue) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setXMLAttribute</name>
      <anchorfile>classScXMLElt.html</anchorfile>
      <anchor>abb8824092c35f5293d957065a0259396</anchor>
      <arglist>(const char *attribute, const char *value)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>getXMLAttribute</name>
      <anchorfile>classScXMLElt.html</anchorfile>
      <anchor>a3cfb6f404acb4ad13de107f2ef5ee748</anchor>
      <arglist>(const char *attribute) const </arglist>
    </member>
    <member kind="function">
      <type>ScXMLElt *</type>
      <name>clone</name>
      <anchorfile>classScXMLElt.html</anchorfile>
      <anchor>a4603b60d4f340f21d57987363d92f3bb</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setContainer</name>
      <anchorfile>classScXMLElt.html</anchorfile>
      <anchor>ac663bd4b53820306beef387a6e1a916b</anchor>
      <arglist>(ScXMLElt *container)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isContainedIn</name>
      <anchorfile>classScXMLElt.html</anchorfile>
      <anchor>a453fa4676cdf492633a0bd0c6fc08b94</anchor>
      <arglist>(const ScXMLElt *object) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isOfType</name>
      <anchorfile>classScXMLObject.html</anchorfile>
      <anchor>aaec2be794e49c8e1d6177e5de4c05a11</anchor>
      <arglist>(SoType type) const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SoType</type>
      <name>getClassTypeId</name>
      <anchorfile>classScXMLObject.html</anchorfile>
      <anchor>aff4dbd61103a1c659b1126bd1342d9f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>initClass</name>
      <anchorfile>classScXMLObject.html</anchorfile>
      <anchor>ad52f3e69104a3527433768dc369539ae</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>cleanClass</name>
      <anchorfile>classScXMLObject.html</anchorfile>
      <anchor>aae0c5a4a174aca5ba7d7c6f41828b181</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="protected" static="yes">
      <type>static void</type>
      <name>registerClassType</name>
      <anchorfile>classScXMLObject.html</anchorfile>
      <anchor>a8146bae33082f60297517988ebda4632</anchor>
      <arglist>(const char *xmlns, const char *classname, SoType type)</arglist>
    </member>
    <member kind="function" protection="protected" static="yes">
      <type>static void</type>
      <name>registerInvokeClassType</name>
      <anchorfile>classScXMLObject.html</anchorfile>
      <anchor>aa7838602d6dc4f741be2b0984cedf966</anchor>
      <arglist>(const char *xmlns, const char *targettype, const char *source, SoType type)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLAnchorElt</name>
    <filename>classScXMLAnchorElt.html</filename>
    <base>ScXMLElt</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLAnchorElt.html</anchorfile>
      <anchor>aec91e009df3fe505d390f55d4074aaa3</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>handleXMLAttributes</name>
      <anchorfile>classScXMLAnchorElt.html</anchorfile>
      <anchor>a99563ba2ea8f290d1bd4fca33a9ae20c</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const ScXMLElt *</type>
      <name>search</name>
      <anchorfile>classScXMLAnchorElt.html</anchorfile>
      <anchor>a245a9a5201559f42fa6722a2b8f26ca5</anchor>
      <arglist>(const char *attrname, const char *attrvalue) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLAndOpExprDataObj</name>
    <filename>classScXMLAndOpExprDataObj.html</filename>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLAndOpExprDataObj.html</anchorfile>
      <anchor>a41b1a6cfa2bd14069afaa2b77d3eb08a</anchor>
      <arglist>(void) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLAssignElt</name>
    <filename>classScXMLAssignElt.html</filename>
    <base>ScXMLExecutableElt</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLAssignElt.html</anchorfile>
      <anchor>a9e4329f07dada52e3d0d47aada29d03d</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ScXMLAssignElt</name>
      <anchorfile>classScXMLAssignElt.html</anchorfile>
      <anchor>a5284526a47273ba0a92fd09a42af74c5</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>handleXMLAttributes</name>
      <anchorfile>classScXMLAssignElt.html</anchorfile>
      <anchor>a365ebe17d543bfbc44783cd932030ce6</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const ScXMLElt *</type>
      <name>search</name>
      <anchorfile>classScXMLAssignElt.html</anchorfile>
      <anchor>a9f6ec11b6ec7b9797b2937ab52ec3a0b</anchor>
      <arglist>(const char *attrname, const char *attrvalue) const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>initClass</name>
      <anchorfile>classScXMLAssignElt.html</anchorfile>
      <anchor>ada746ed6fe36b4c6065d1e272cb66050</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>cleanClass</name>
      <anchorfile>classScXMLAssignElt.html</anchorfile>
      <anchor>ac9629e5875b1b5cedc7769b9c9e36001</anchor>
      <arglist>(void)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLCoinEvaluator</name>
    <filename>classScXMLCoinEvaluator.html</filename>
    <base>ScXMLEvaluator</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLCoinEvaluator.html</anchorfile>
      <anchor>ab5e3ae77175019134d38a3a105a9b331</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setStateMachine</name>
      <anchorfile>classScXMLCoinEvaluator.html</anchorfile>
      <anchor>a9b3cc77cd58c18d836f3fb5885436e33</anchor>
      <arglist>(ScXMLStateMachine *sm)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>clearTemporaryVariables</name>
      <anchorfile>classScXMLCoinEvaluator.html</anchorfile>
      <anchor>aeb19052d03db41282f624ec86b58bb1f</anchor>
      <arglist>(void)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLConstantDataObj</name>
    <filename>classScXMLConstantDataObj.html</filename>
    <base>ScXMLDataObj</base>
    <member kind="function" virtualness="pure">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLConstantDataObj.html</anchorfile>
      <anchor>a8c426234b6bb8ece08fcd426d74f0270</anchor>
      <arglist>(void) const =0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLContentElt</name>
    <filename>classScXMLContentElt.html</filename>
    <base>ScXMLElt</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLContentElt.html</anchorfile>
      <anchor>a70e883d93d988a568be716255c8ae058</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>handleXMLAttributes</name>
      <anchorfile>classScXMLElt.html</anchorfile>
      <anchor>ac76e77f8ecedd593ec87b0fa1ee5f7df</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const ScXMLElt *</type>
      <name>search</name>
      <anchorfile>classScXMLElt.html</anchorfile>
      <anchor>a6acef7487d9ea12bf0ca4de9b156f453</anchor>
      <arglist>(const char *attrname, const char *attrvalue) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLDataElt</name>
    <filename>classScXMLDataElt.html</filename>
    <base>ScXMLElt</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLDataElt.html</anchorfile>
      <anchor>a14d94658625f6550d695d5c6cbb5431f</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>handleXMLAttributes</name>
      <anchorfile>classScXMLDataElt.html</anchorfile>
      <anchor>adbae717dc44fe179e36b6b3917dd98b7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const ScXMLElt *</type>
      <name>search</name>
      <anchorfile>classScXMLDataElt.html</anchorfile>
      <anchor>a35d6cf96952275c788ce4f0d2352f2ba</anchor>
      <arglist>(const char *attrname, const char *attrvalue) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLDataModelElt</name>
    <filename>classScXMLDataModelElt.html</filename>
    <base>ScXMLElt</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLDataModelElt.html</anchorfile>
      <anchor>a77afbff6c4313034a840eabaa465e0ca</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>handleXMLAttributes</name>
      <anchorfile>classScXMLDataModelElt.html</anchorfile>
      <anchor>a8a15fbe319261c8645985da8f1143738</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const ScXMLElt *</type>
      <name>search</name>
      <anchorfile>classScXMLDataModelElt.html</anchorfile>
      <anchor>a5144bbbf936f06916580f1018501a486</anchor>
      <arglist>(const char *attrname, const char *attrvalue) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLDataObj</name>
    <filename>classScXMLDataObj.html</filename>
    <base>ScXMLObject</base>
    <member kind="function" virtualness="pure">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLDataObj.html</anchorfile>
      <anchor>aa8f127e9e677b82f01f321b18a298e16</anchor>
      <arglist>(void) const =0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLDocument</name>
    <filename>classScXMLDocument.html</filename>
    <base>ScXMLObject</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLDocument.html</anchorfile>
      <anchor>a88d3171d490d794a619682a878e4a5b5</anchor>
      <arglist>(void) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLECMAScriptEvaluator</name>
    <filename>classScXMLECMAScriptEvaluator.html</filename>
    <base>ScXMLEvaluator</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLECMAScriptEvaluator.html</anchorfile>
      <anchor>a9f43d76d7fc779f0d16cac6073f980fd</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setStateMachine</name>
      <anchorfile>classScXMLEvaluator.html</anchorfile>
      <anchor>a903df9c19b4a93b2988b57672f417d3c</anchor>
      <arglist>(ScXMLStateMachine *sm)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>clearTemporaryVariables</name>
      <anchorfile>classScXMLEvaluator.html</anchorfile>
      <anchor>a7eb59462c0c8b1a267522a89ec22d607</anchor>
      <arglist>(void)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLElseElt</name>
    <filename>classScXMLElseElt.html</filename>
    <base>ScXMLExecutableElt</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLElseElt.html</anchorfile>
      <anchor>a88772975690349a91b7708da14e00dec</anchor>
      <arglist>(void) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLElseIfElt</name>
    <filename>classScXMLElseIfElt.html</filename>
    <base>ScXMLExecutableElt</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLElseIfElt.html</anchorfile>
      <anchor>ad16f8ade0309085a6baad665f846f97b</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>handleXMLAttributes</name>
      <anchorfile>classScXMLElseIfElt.html</anchorfile>
      <anchor>a0150583699cdc62856c7dc3e949ad520</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const ScXMLElt *</type>
      <name>search</name>
      <anchorfile>classScXMLElseIfElt.html</anchorfile>
      <anchor>ab414574c327311a5a3a17ea42a63f8d4</anchor>
      <arglist>(const char *attrname, const char *attrvalue) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLElt</name>
    <filename>classScXMLElt.html</filename>
    <base>ScXMLObject</base>
    <member kind="function" virtualness="pure">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLElt.html</anchorfile>
      <anchor>a3b97c34ff5fba99583caa4d8ef5252d2</anchor>
      <arglist>(void) const =0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLEltReader</name>
    <filename>classScXMLEltReader.html</filename>
  </compound>
  <compound kind="class">
    <name>ScXMLEvaluator</name>
    <filename>classScXMLEvaluator.html</filename>
    <base>ScXMLObject</base>
    <member kind="function" virtualness="pure">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLEvaluator.html</anchorfile>
      <anchor>a22f5bcbd102a6ebfbf399c35addc24e6</anchor>
      <arglist>(void) const =0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLEvent</name>
    <filename>classScXMLEvent.html</filename>
    <base>ScXMLObject</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLEvent.html</anchorfile>
      <anchor>ae1a1e3ab1922f5b1f5f32201810141d6</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setEventName</name>
      <anchorfile>classScXMLEvent.html</anchorfile>
      <anchor>a7c1112de3684d5726726fbf97bfdffe3</anchor>
      <arglist>(const SbName &amp;name)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLEventElt</name>
    <filename>classScXMLEventElt.html</filename>
    <base>ScXMLExecutableElt</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLEventElt.html</anchorfile>
      <anchor>a269a22f8961a136c0b14122e9b9290d1</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>handleXMLAttributes</name>
      <anchorfile>classScXMLEventElt.html</anchorfile>
      <anchor>ad2e64434411a92e1a6659408ff9f89f4</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const ScXMLElt *</type>
      <name>search</name>
      <anchorfile>classScXMLEventElt.html</anchorfile>
      <anchor>a0337e1a88e9f69c77c0d9804ddcfa2d9</anchor>
      <arglist>(const char *attrname, const char *attrvalue) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLEventTarget</name>
    <filename>classScXMLEventTarget.html</filename>
    <base>ScXMLObject</base>
    <member kind="function" virtualness="pure">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLEventTarget.html</anchorfile>
      <anchor>a83c3e492e1f1cd43160447442ca05828</anchor>
      <arglist>(void) const =0</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const ScXMLEvent *</type>
      <name>getCurrentEvent</name>
      <anchorfile>classScXMLEventTarget.html</anchorfile>
      <anchor>a07704f89bbf875d9f878a3beb1e49c5e</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>queueEvent</name>
      <anchorfile>classScXMLEventTarget.html</anchorfile>
      <anchor>a023f131293775c89553361dace4be77b</anchor>
      <arglist>(const ScXMLEvent *event)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>queueEvent</name>
      <anchorfile>classScXMLEventTarget.html</anchorfile>
      <anchor>a148b192e2023df0791fb6a31e20ae780</anchor>
      <arglist>(const SbName &amp;eventid)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>setCurrentEvent</name>
      <anchorfile>classScXMLEventTarget.html</anchorfile>
      <anchor>aef63077fd0be0d7d5517782eba5041a1</anchor>
      <arglist>(const ScXMLEvent *event)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>processOneEvent</name>
      <anchorfile>classScXMLEventTarget.html</anchorfile>
      <anchor>ac141e368b9f95ff6feb08e4237e80ee0</anchor>
      <arglist>(const ScXMLEvent *event)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLExecutableElt</name>
    <filename>classScXMLExecutableElt.html</filename>
    <base>ScXMLElt</base>
    <member kind="function" virtualness="pure">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLExecutableElt.html</anchorfile>
      <anchor>ad26b5a870cf887de5d6c9da6421984be</anchor>
      <arglist>(void) const =0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLFinalElt</name>
    <filename>classScXMLFinalElt.html</filename>
    <base>ScXMLAbstractStateElt</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLFinalElt.html</anchorfile>
      <anchor>ab13f54ce2f567778fb77f5524dcbea76</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const ScXMLElt *</type>
      <name>search</name>
      <anchorfile>classScXMLFinalElt.html</anchorfile>
      <anchor>a5e5e493bb46a5b472cd60eff54a99e3f</anchor>
      <arglist>(const char *attrname, const char *attrvalue) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLFinalizeElt</name>
    <filename>classScXMLFinalizeElt.html</filename>
    <base>ScXMLElt</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLFinalizeElt.html</anchorfile>
      <anchor>abf145d86470e1aa1bf795fec7af9199e</anchor>
      <arglist>(void) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLHistoryElt</name>
    <filename>classScXMLHistoryElt.html</filename>
    <base>ScXMLElt</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLHistoryElt.html</anchorfile>
      <anchor>a5e27d13ebefa1f76b2f9a8e983976946</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>handleXMLAttributes</name>
      <anchorfile>classScXMLHistoryElt.html</anchorfile>
      <anchor>ac077afa9f5c2048df00d37b86022ff31</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const ScXMLElt *</type>
      <name>search</name>
      <anchorfile>classScXMLHistoryElt.html</anchorfile>
      <anchor>a960abdf9cf94fcb26c6ccf2ef3228695</anchor>
      <arglist>(const char *attrname, const char *attrvalue) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLIfElt</name>
    <filename>classScXMLIfElt.html</filename>
    <base>ScXMLExecutableElt</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLIfElt.html</anchorfile>
      <anchor>a623bb596ba1bc6e11cbb906d24d8a396</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>handleXMLAttributes</name>
      <anchorfile>classScXMLIfElt.html</anchorfile>
      <anchor>ae628a920951925caf369ebef3c69c262</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const ScXMLElt *</type>
      <name>search</name>
      <anchorfile>classScXMLIfElt.html</anchorfile>
      <anchor>ab7413ae8ecc183cdcab3b167b76b7013</anchor>
      <arglist>(const char *attrname, const char *attrvalue) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLInitialElt</name>
    <filename>classScXMLInitialElt.html</filename>
    <base>ScXMLElt</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLInitialElt.html</anchorfile>
      <anchor>a40a1b0b55b36752af9c7e602192b0aff</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const ScXMLElt *</type>
      <name>search</name>
      <anchorfile>classScXMLInitialElt.html</anchorfile>
      <anchor>aa3dd5f89740cbb6a56e8dff93411a037</anchor>
      <arglist>(const char *attrname, const char *attrvalue) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLInvokeElt</name>
    <filename>classScXMLInvokeElt.html</filename>
    <base>ScXMLExecutableElt</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLInvokeElt.html</anchorfile>
      <anchor>a66c1d5ded6bf024315feeed966238ec9</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>handleXMLAttributes</name>
      <anchorfile>classScXMLInvokeElt.html</anchorfile>
      <anchor>afa48803a9d3619d5638fb92a28d6d3f2</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const ScXMLElt *</type>
      <name>search</name>
      <anchorfile>classScXMLInvokeElt.html</anchorfile>
      <anchor>a2933aeea688287977f2d67e864087d0c</anchor>
      <arglist>(const char *attrname, const char *attrvalue) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLLogElt</name>
    <filename>classScXMLLogElt.html</filename>
    <base>ScXMLExecutableElt</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLLogElt.html</anchorfile>
      <anchor>a5d600c29d8aeeac85f539247e33c115c</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>handleXMLAttributes</name>
      <anchorfile>classScXMLLogElt.html</anchorfile>
      <anchor>a9d070ae058209d8a58d469141d55a4d1</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const ScXMLElt *</type>
      <name>search</name>
      <anchorfile>classScXMLLogElt.html</anchorfile>
      <anchor>af4fbe0327f219d97ffb9b4095c697f05</anchor>
      <arglist>(const char *attrname, const char *attrvalue) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLMinimumEvaluator</name>
    <filename>classScXMLMinimumEvaluator.html</filename>
    <base>ScXMLEvaluator</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLMinimumEvaluator.html</anchorfile>
      <anchor>ae55e1481c0bf1ffb5a4b500b94339bcf</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setStateMachine</name>
      <anchorfile>classScXMLMinimumEvaluator.html</anchorfile>
      <anchor>a7cd2015644ffedd3ace380747fe3eacc</anchor>
      <arglist>(ScXMLStateMachine *)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual ScXMLDataObj *</type>
      <name>evaluate</name>
      <anchorfile>classScXMLMinimumEvaluator.html</anchorfile>
      <anchor>a8818d107a5d566999ead28f9cf768910</anchor>
      <arglist>(const char *expression) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>setAtLocation</name>
      <anchorfile>classScXMLMinimumEvaluator.html</anchorfile>
      <anchor>aa2bab3639e92cb1a242d797e10b580c2</anchor>
      <arglist>(const char *location, ScXMLDataObj *obj)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual ScXMLDataObj *</type>
      <name>locate</name>
      <anchorfile>classScXMLMinimumEvaluator.html</anchorfile>
      <anchor>ad4154a3ac9e015ca50531217af94129f</anchor>
      <arglist>(const char *location) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>clearTemporaryVariables</name>
      <anchorfile>classScXMLMinimumEvaluator.html</anchorfile>
      <anchor>ace8b736796006bbd8bd2fb3838cab38f</anchor>
      <arglist>(void)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLMinimumExprDataObj</name>
    <filename>classScXMLMinimumExprDataObj.html</filename>
    <member kind="function" virtualness="pure">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLMinimumExprDataObj.html</anchorfile>
      <anchor>acae67b14941ffd8ca46c042512dbcf09</anchor>
      <arglist>(void) const =0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLObject</name>
    <filename>classScXMLObject.html</filename>
    <member kind="function" virtualness="pure">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLObject.html</anchorfile>
      <anchor>a99bfd8003e56ea165441c66a33da44c6</anchor>
      <arglist>(void) const =0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLOnEntryElt</name>
    <filename>classScXMLOnEntryElt.html</filename>
    <base>ScXMLElt</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLOnEntryElt.html</anchorfile>
      <anchor>a078f97877bae46861d7a05a7fda1996b</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const ScXMLElt *</type>
      <name>search</name>
      <anchorfile>classScXMLOnEntryElt.html</anchorfile>
      <anchor>a2930fd3894e3c21d1d10993fdd04383a</anchor>
      <arglist>(const char *attrname, const char *attrvalue) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLOnExitElt</name>
    <filename>classScXMLOnExitElt.html</filename>
    <base>ScXMLElt</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLOnExitElt.html</anchorfile>
      <anchor>a844737d3f6767fa425d20e5458abdd01</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const ScXMLElt *</type>
      <name>search</name>
      <anchorfile>classScXMLOnExitElt.html</anchorfile>
      <anchor>a7760290bf8098ce86c22ed52c6c5efa5</anchor>
      <arglist>(const char *attrname, const char *attrvalue) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLParallelElt</name>
    <filename>classScXMLParallelElt.html</filename>
    <base>ScXMLAbstractStateElt</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLParallelElt.html</anchorfile>
      <anchor>a483f26b1ac7ce1364471d80f1cc33a06</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>handleXMLAttributes</name>
      <anchorfile>classScXMLParallelElt.html</anchorfile>
      <anchor>a9617bfd842c4f986f172e587ab223d61</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const ScXMLElt *</type>
      <name>search</name>
      <anchorfile>classScXMLParallelElt.html</anchorfile>
      <anchor>ad29265132b5610609f55438edbeaefa4</anchor>
      <arglist>(const char *attrname, const char *attrvalue) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isAtomicState</name>
      <anchorfile>classScXMLParallelElt.html</anchorfile>
      <anchor>a43af8b51bd0c20c1eb58e7d553b72567</anchor>
      <arglist>(void) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLParamElt</name>
    <filename>classScXMLParamElt.html</filename>
    <base>ScXMLElt</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLParamElt.html</anchorfile>
      <anchor>a2e5c05eb612dfd8e5a542241d634f4eb</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>handleXMLAttributes</name>
      <anchorfile>classScXMLParamElt.html</anchorfile>
      <anchor>aa9be25ba25216e462d66688ff4e6bc64</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const ScXMLElt *</type>
      <name>search</name>
      <anchorfile>classScXMLParamElt.html</anchorfile>
      <anchor>aede51d8795a89444321e3a7c73efcc92</anchor>
      <arglist>(const char *attrname, const char *attrvalue) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLReferenceDataObj</name>
    <filename>classScXMLReferenceDataObj.html</filename>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLReferenceDataObj.html</anchorfile>
      <anchor>aac0d2a78478331133777a2632d640db5</anchor>
      <arglist>(void) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLScriptElt</name>
    <filename>classScXMLScriptElt.html</filename>
    <base>ScXMLExecutableElt</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLScriptElt.html</anchorfile>
      <anchor>a1ae76d0efdccb514e443ac8a9be49f50</anchor>
      <arglist>(void) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLScxmlElt</name>
    <filename>classScXMLScxmlElt.html</filename>
    <base>ScXMLElt</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLScxmlElt.html</anchorfile>
      <anchor>a5dc763bea77dab6230705fa955fa064e</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>handleXMLAttributes</name>
      <anchorfile>classScXMLScxmlElt.html</anchorfile>
      <anchor>a29134c57770eedc8f9b15a251890ae13</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const ScXMLElt *</type>
      <name>search</name>
      <anchorfile>classScXMLScxmlElt.html</anchorfile>
      <anchor>a853ecc1b3753d05b65ac0f1b3fd7064e</anchor>
      <arglist>(const char *attrname, const char *attrvalue) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLSendElt</name>
    <filename>classScXMLSendElt.html</filename>
    <base>ScXMLExecutableElt</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLSendElt.html</anchorfile>
      <anchor>ad5315395706244f28549c3220c3c1474</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>handleXMLAttributes</name>
      <anchorfile>classScXMLSendElt.html</anchorfile>
      <anchor>a2a8200bf1060a20e0d91b4491059b574</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const ScXMLElt *</type>
      <name>search</name>
      <anchorfile>classScXMLSendElt.html</anchorfile>
      <anchor>a75ce67af90a43334a092045a97e8a5d7</anchor>
      <arglist>(const char *attrname, const char *attrvalue) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLStateElt</name>
    <filename>classScXMLStateElt.html</filename>
    <base>ScXMLAbstractStateElt</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLStateElt.html</anchorfile>
      <anchor>a76088e37137a421d1e96570c9cf78a02</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>ScXMLStateElt</name>
      <anchorfile>classScXMLStateElt.html</anchorfile>
      <anchor>a6df32b2660e35cdfe5a3d8421fa06259</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~ScXMLStateElt</name>
      <anchorfile>classScXMLStateElt.html</anchorfile>
      <anchor>ae2a8e7e817e691345cb185f470ede375</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setSrcAttribute</name>
      <anchorfile>classScXMLStateElt.html</anchorfile>
      <anchor>ae04314f867ba7a3d357e084225cf134d</anchor>
      <arglist>(const char *src)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>getSrcAttribute</name>
      <anchorfile>classScXMLStateElt.html</anchorfile>
      <anchor>a82ff212d78cedcf354fd2e26c29d7d20</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setInitialAttribute</name>
      <anchorfile>classScXMLStateElt.html</anchorfile>
      <anchor>a6720ab49835e6c0fad259720986b8501</anchor>
      <arglist>(const char *initial)</arglist>
    </member>
    <member kind="function">
      <type>const char *</type>
      <name>getInitialAttribute</name>
      <anchorfile>classScXMLStateElt.html</anchorfile>
      <anchor>a37e789c8aa21cd638e8db4df002e5353</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>handleXMLAttributes</name>
      <anchorfile>classScXMLStateElt.html</anchorfile>
      <anchor>a7ce8ae758e0d4cc5e3122e5fbff5bda9</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const ScXMLElt *</type>
      <name>search</name>
      <anchorfile>classScXMLStateElt.html</anchorfile>
      <anchor>a652ebdf497b03bdbd3892bda34cabba0</anchor>
      <arglist>(const char *attrname, const char *attrvalue) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isAtomicState</name>
      <anchorfile>classScXMLStateElt.html</anchorfile>
      <anchor>afe6b9075e7b34f1d3251e557de45191e</anchor>
      <arglist>(void) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLStateMachine</name>
    <filename>classScXMLStateMachine.html</filename>
    <base>ScXMLEventTarget</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLStateMachine.html</anchorfile>
      <anchor>a16f24b950c817b6defaafdc0743537a9</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setSessionId</name>
      <anchorfile>classScXMLStateMachine.html</anchorfile>
      <anchor>a675d32dd576b9cbe81b89481935c31ed</anchor>
      <arglist>(const SbName &amp;sessionid)</arglist>
    </member>
    <member kind="function">
      <type>const SbName &amp;</type>
      <name>getSessionId</name>
      <anchorfile>classScXMLStateMachine.html</anchorfile>
      <anchor>af10e94dd407117cc7ae532a3d5f4b01a</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>initialize</name>
      <anchorfile>classScXMLStateMachine.html</anchorfile>
      <anchor>aba14c712ade5e2ca27c73102cef20b62</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>isActive</name>
      <anchorfile>classScXMLStateMachine.html</anchorfile>
      <anchor>ad7427887c8aefd7ea4fc38bee6beb75f</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>isFinished</name>
      <anchorfile>classScXMLStateMachine.html</anchorfile>
      <anchor>a0ed0801fcc51dbb8d40b005ddcd64e98</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>getNumActiveStates</name>
      <anchorfile>classScXMLStateMachine.html</anchorfile>
      <anchor>aaf848db1832ccc5fb47d117237f62403</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const ScXMLElt *</type>
      <name>getActiveState</name>
      <anchorfile>classScXMLStateMachine.html</anchorfile>
      <anchor>a678ea79bceb511c8959706df7ee97c22</anchor>
      <arglist>(int idx) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>addDeleteCallback</name>
      <anchorfile>classScXMLStateMachine.html</anchorfile>
      <anchor>af8bf1428945535c5479a7cc79e9acb00</anchor>
      <arglist>(ScXMLStateMachineDeleteCB *callback, void *userdata)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>removeDeleteCallback</name>
      <anchorfile>classScXMLStateMachine.html</anchorfile>
      <anchor>ae6b467bfeefaef24bf8a03884e3013e5</anchor>
      <arglist>(ScXMLStateMachineDeleteCB *callback, void *userdata)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>addStateChangeCallback</name>
      <anchorfile>classScXMLStateMachine.html</anchorfile>
      <anchor>ad84c8d6eccdb3a9f77938855bef43068</anchor>
      <arglist>(ScXMLStateChangeCB *callback, void *userdata)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>removeStateChangeCallback</name>
      <anchorfile>classScXMLStateMachine.html</anchorfile>
      <anchor>ab498767b29892f25403678a8e6ee8a53</anchor>
      <arglist>(ScXMLStateChangeCB *callback, void *userdata)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>processOneEvent</name>
      <anchorfile>classScXMLStateMachine.html</anchorfile>
      <anchor>a9dbeab737cb398f1a50cb523fd417e64</anchor>
      <arglist>(const ScXMLEvent *event)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLTransitionElt</name>
    <filename>classScXMLTransitionElt.html</filename>
    <base>ScXMLElt</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLTransitionElt.html</anchorfile>
      <anchor>ab4fd381b6b101f88d9ba00ecdaf13fe0</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>handleXMLAttributes</name>
      <anchorfile>classScXMLTransitionElt.html</anchorfile>
      <anchor>a3c5cb6b36ea69121befca3438f1255f4</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const ScXMLElt *</type>
      <name>search</name>
      <anchorfile>classScXMLTransitionElt.html</anchorfile>
      <anchor>a2f95806bc4c5978dae575dbaf718a8d2</anchor>
      <arglist>(const char *attrname, const char *attrvalue) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isConditionLess</name>
      <anchorfile>classScXMLTransitionElt.html</anchorfile>
      <anchor>a358a0db69503c44efba7190b454797b5</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isTargetLess</name>
      <anchorfile>classScXMLTransitionElt.html</anchorfile>
      <anchor>ad118e7d52eb73026dd2a7b0528a99086</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isSelfReferencing</name>
      <anchorfile>classScXMLTransitionElt.html</anchorfile>
      <anchor>a12a303f9cf0a23a711e741729fa40f17</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>isEventMatch</name>
      <anchorfile>classScXMLTransitionElt.html</anchorfile>
      <anchor>adcdc76be8a70ad3d85a52a8352f86e39</anchor>
      <arglist>(const ScXMLEvent *event) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>evaluateCondition</name>
      <anchorfile>classScXMLTransitionElt.html</anchorfile>
      <anchor>a2092e23a55d5d2c8615c0027e9bf4e57</anchor>
      <arglist>(ScXMLStateMachine *statemachine)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>execute</name>
      <anchorfile>classScXMLTransitionElt.html</anchorfile>
      <anchor>a95bd1dbb5653bfd36a4e840e0853574e</anchor>
      <arglist>(ScXMLStateMachine *statemachine) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLValidateElt</name>
    <filename>classScXMLValidateElt.html</filename>
    <base>ScXMLExecutableElt</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLValidateElt.html</anchorfile>
      <anchor>ae1f66ba601caa686c7bcbe431e42528b</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>handleXMLAttributes</name>
      <anchorfile>classScXMLValidateElt.html</anchorfile>
      <anchor>a191f8975f4364fd2265d2c75821d07b0</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const ScXMLElt *</type>
      <name>search</name>
      <anchorfile>classScXMLValidateElt.html</anchorfile>
      <anchor>a7ae08da47b4a3c4d0696bd7031acb4d8</anchor>
      <arglist>(const char *attrname, const char *attrvalue) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>ScXMLXPathEvaluator</name>
    <filename>classScXMLXPathEvaluator.html</filename>
    <base>ScXMLEvaluator</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classScXMLXPathEvaluator.html</anchorfile>
      <anchor>ad1c51fd322840a03d6634217711b8b47</anchor>
      <arglist>(void) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoAccumulatedElement</name>
    <filename>classSoAccumulatedElement.html</filename>
    <base>SoElement</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>matches</name>
      <anchorfile>classSoAccumulatedElement.html</anchorfile>
      <anchor>a8d960ab8dca94f56c4f8493d2eaa0508</anchor>
      <arglist>(const SoElement *element) const </arglist>
    </member>
    <member kind="function">
      <type>const SoType</type>
      <name>getTypeId</name>
      <anchorfile>classSoElement.html</anchorfile>
      <anchor>a8a7fb999dff6f39ea1280eea97a8933a</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getStackIndex</name>
      <anchorfile>classSoElement.html</anchorfile>
      <anchor>ae2eb4b8dcfbc520faef17c4820f9c4c9</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>pop</name>
      <anchorfile>classSoElement.html</anchorfile>
      <anchor>a47fb7cba01227fed02b5d48d7797dddb</anchor>
      <arglist>(SoState *state, const SoElement *prevTopElement)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDepth</name>
      <anchorfile>classSoElement.html</anchorfile>
      <anchor>a8508119bc6d937ab882f45f86745d2e1</anchor>
      <arglist>(const int depth)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getDepth</name>
      <anchorfile>classSoElement.html</anchorfile>
      <anchor>a3c98d36d1a92f70d4957395c3e5f3313</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>print</name>
      <anchorfile>classSoElement.html</anchorfile>
      <anchor>ae9d85b24213e349b96e4bb78233a0ff6</anchor>
      <arglist>(FILE *file=stdout) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~SoElement</name>
      <anchorfile>classSoElement.html</anchorfile>
      <anchor>a9ce2a1034d3bb27910ce9a3eea6e64e5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>initClass</name>
      <anchorfile>classSoElement.html</anchorfile>
      <anchor>a53244db0aff108029f890d602b904890</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SoType</type>
      <name>getClassTypeId</name>
      <anchorfile>classSoElement.html</anchorfile>
      <anchor>a2c70e4edee66676d8f682b7a4afda037</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static int</type>
      <name>getClassStackIndex</name>
      <anchorfile>classSoElement.html</anchorfile>
      <anchor>ad2a2e4a49f1cccadc601e75a51048391</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>initElements</name>
      <anchorfile>classSoElement.html</anchorfile>
      <anchor>af00f2621eec54163e7d1eb5ae7e81ad5</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static int</type>
      <name>getNumStackIndices</name>
      <anchorfile>classSoElement.html</anchorfile>
      <anchor>aff64aac9bd872ce52ac5dfbfa36c36dc</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SoType</type>
      <name>getIdFromStackIndex</name>
      <anchorfile>classSoElement.html</anchorfile>
      <anchor>a5ac8400720c4ab228dec79bf301d7647</anchor>
      <arglist>(const int stackIndex)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>init</name>
      <anchorfile>classSoAccumulatedElement.html</anchorfile>
      <anchor>ae73af63a5def9e9f13c08c0d67cbed27</anchor>
      <arglist>(SoState *state)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>push</name>
      <anchorfile>classSoAccumulatedElement.html</anchorfile>
      <anchor>aa056ead3804fe3818d8ca55e67ef38d0</anchor>
      <arglist>(SoState *state)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>clearNodeIds</name>
      <anchorfile>classSoAccumulatedElement.html</anchorfile>
      <anchor>a70f1473b38a1d7337d643ee8b4e59bc6</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>addNodeId</name>
      <anchorfile>classSoAccumulatedElement.html</anchorfile>
      <anchor>a0132837d8e145edce7586e2b3169cf20</anchor>
      <arglist>(const SoNode *const node)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>setNodeId</name>
      <anchorfile>classSoAccumulatedElement.html</anchorfile>
      <anchor>a72bfdec083dc26e5b36bbd7a0bccbd47</anchor>
      <arglist>(const SoNode *const node)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>copyNodeIds</name>
      <anchorfile>classSoAccumulatedElement.html</anchorfile>
      <anchor>ae65a5e4a450f584709bf55bb18a3edb8</anchor>
      <arglist>(const SoAccumulatedElement *copyfrom)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual SoElement *</type>
      <name>copyMatchInfo</name>
      <anchorfile>classSoAccumulatedElement.html</anchorfile>
      <anchor>a6e21205ffcb6a05b7573e5b22c0fe81f</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>captureThis</name>
      <anchorfile>classSoAccumulatedElement.html</anchorfile>
      <anchor>a77c8c1edfcfa96314e39456d67b4137f</anchor>
      <arglist>(SoState *state) const </arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>SoElement</name>
      <anchorfile>classSoElement.html</anchorfile>
      <anchor>a34312a1075fc6b90b3e5ccf5875c8c79</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>capture</name>
      <anchorfile>classSoElement.html</anchorfile>
      <anchor>ace260f18f598e00d95c98c96925950f8</anchor>
      <arglist>(SoState *const state) const </arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>setTypeId</name>
      <anchorfile>classSoElement.html</anchorfile>
      <anchor>a48d6dbea777d2eee021a788cf896ecaa</anchor>
      <arglist>(const SoType typeId)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>setStackIndex</name>
      <anchorfile>classSoElement.html</anchorfile>
      <anchor>a84b9e1b74e61a4c8383650a33dc7a9c8</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>SoElement *</type>
      <name>getNextInStack</name>
      <anchorfile>classSoElement.html</anchorfile>
      <anchor>ae738e26ff31219dc9abe8a72e93e110a</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" protection="protected">
      <type>SoElement *</type>
      <name>getNextFree</name>
      <anchorfile>classSoElement.html</anchorfile>
      <anchor>a4ff965194a4c7905b695022724698ae4</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbList&lt; uint32_t &gt;</type>
      <name>nodeIds</name>
      <anchorfile>classSoAccumulatedElement.html</anchorfile>
      <anchor>a6ad9023f4ff2487772a486f0d5057323</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SoType</type>
      <name>typeId</name>
      <anchorfile>classSoElement.html</anchorfile>
      <anchor>a3acf0e425bc7ef0a812df905a39fb269</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>stackIndex</name>
      <anchorfile>classSoElement.html</anchorfile>
      <anchor>a3babbcafa83800192cee2acb1a8edd6f</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>depth</name>
      <anchorfile>classSoElement.html</anchorfile>
      <anchor>a60e3b7f1344de81f7d6a198e7655235f</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" protection="protected" static="yes">
      <type>static SoElement *</type>
      <name>getElement</name>
      <anchorfile>classSoElement.html</anchorfile>
      <anchor>a30c40ecaa79d6b140278fe906273e714</anchor>
      <arglist>(SoState *const state, const int stackIndex)</arglist>
    </member>
    <member kind="function" protection="protected" static="yes">
      <type>static const SoElement *</type>
      <name>getConstElement</name>
      <anchorfile>classSoElement.html</anchorfile>
      <anchor>ab8cb20060c9b527c8b2e343b1cf4032a</anchor>
      <arglist>(SoState *const state, const int stackIndex)</arglist>
    </member>
    <member kind="function" protection="protected" static="yes">
      <type>static int</type>
      <name>createStackIndex</name>
      <anchorfile>classSoElement.html</anchorfile>
      <anchor>a6e4a8ae82aae7ac4d2516929a2e62d1d</anchor>
      <arglist>(const SoType id)</arglist>
    </member>
    <member kind="variable" protection="protected" static="yes">
      <type>static int</type>
      <name>classStackIndex</name>
      <anchorfile>classSoElement.html</anchorfile>
      <anchor>a3ab188deb13cb1a8c1b40ee365fce944</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected" static="yes">
      <type>static SoTypeList *</type>
      <name>stackToType</name>
      <anchorfile>classSoElement.html</anchorfile>
      <anchor>a8e7258ccd9bda58158a370fc16455bbc</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoAction</name>
    <filename>classSoAction.html</filename>
    <member kind="enumeration">
      <type></type>
      <name>AppliedCode</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a1c1dcf644f0e8bc1acd92f9cd8c917d3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>PathCode</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a0942e2ce7d88ebc8e7cd10cf26310c67</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~SoAction</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>ad2839c2461c998920de832d8bdaa34c1</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a364ad60918a4d20ebdc9635457fe331c</anchor>
      <arglist>(void) const =0</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>isOfType</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a82e33af1a24879a4dfd36a11a9832689</anchor>
      <arglist>(SoType type) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>apply</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>ad2d6ddb297b3a1f5b80026db5fd5e616</anchor>
      <arglist>(SoNode *root)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>apply</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a8f922db782cb971042da8adc64f61d47</anchor>
      <arglist>(SoPath *path)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>apply</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a311e03e553957474b6920afe03fb94fc</anchor>
      <arglist>(const SoPathList &amp;pathlist, SbBool obeysrules=FALSE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>apply</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a984b580685859d42c4505980249fd409</anchor>
      <arglist>(SoAction *beingApplied)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>invalidateState</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a3fbc8efc139853a56e707baecf02b357</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>AppliedCode</type>
      <name>getWhatAppliedTo</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a4d0897cb9be1eecfdecefe1d997c7bfb</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SoNode *</type>
      <name>getNodeAppliedTo</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>abafb324d344d32013ed45e7d02cfa230</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SoPath *</type>
      <name>getPathAppliedTo</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a26927425cfa1f5cbcad875a94493c2a5</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>const SoPathList *</type>
      <name>getPathListAppliedTo</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>addea4390ccdaaaa3457d1f243ff95b0b</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>const SoPathList *</type>
      <name>getOriginalPathListAppliedTo</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a258606e1d65239e8c4008da42a49c59c</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isLastPathListAppliedTo</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>aec41770acf5a27f1b82a7e031571d101</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>PathCode</type>
      <name>getPathCode</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a42b2f4960252071194099b4a965eefa2</anchor>
      <arglist>(int &amp;numindices, const int *&amp;indices)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>traverse</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a805627d07445a9c3a7e6324748aac2a9</anchor>
      <arglist>(SoNode *const node)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>hasTerminated</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a1ae6a4f107b03fb899743f5f3d5fc7d3</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>const SoPath *</type>
      <name>getCurPath</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>af5920f3da63a6ba8577dc56621815341</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>SoState *</type>
      <name>getState</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>aa6cf40cb31bb8371eb5d9a847ce9c944</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>PathCode</type>
      <name>getCurPathCode</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>abba574ba5288668051405a9fcd3678aa</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SoNode *</type>
      <name>getCurPathTail</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a4e9810cb526353255fedf04792151c2d</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>usePathCode</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>aea5650e3b7ae6207c4c3d675e83073b5</anchor>
      <arglist>(int &amp;numindices, const int *&amp;indices)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pushCurPath</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a148ece4bf4cda79914ee3a2116c05d09</anchor>
      <arglist>(const int childindex, SoNode *node=NULL)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>popCurPath</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a88ceb9648c0f51d7ba87475ca8555f28</anchor>
      <arglist>(const PathCode prevpathcode)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pushCurPath</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>abebcc05d2d935803a3c95310c9447614</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>popPushCurPath</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>adf8242136a44ff3af40ea102b372e4e1</anchor>
      <arglist>(const int childindex, SoNode *node=NULL)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>popCurPath</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a989bcb87598bf55b31bf0704189abb11</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>switchToPathTraversal</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a4285818426cf039bd556b537398d9ece</anchor>
      <arglist>(SoPath *path)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>switchToNodeTraversal</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>accfc280f70bc8f888f61890f07a4aac2</anchor>
      <arglist>(SoNode *node)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>initClass</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a6fca4d3db681ecea3bd1d5c24d1f160d</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>initClasses</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a9c1f8064ac89d9e36d36a8d05365e26a</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SoType</type>
      <name>getClassTypeId</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a3a714aae7f852be330d276041f7bc26e</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>nullAction</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a6dd54a728307c37d3cd87b2891b9359e</anchor>
      <arglist>(SoAction *action, SoNode *node)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>SoAction</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a7f6ac9fad4b83a66a321adfa48ebacd1</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>beginTraversal</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a893a67a9bf2e7b5b5ef0f1f36f1b8097</anchor>
      <arglist>(SoNode *node)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>endTraversal</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a9af52ee33d0effeba2f23d9c3d4d6ad0</anchor>
      <arglist>(SoNode *node)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>setTerminated</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>aa968d7390c6d9ec862e0c9c1c7e48de5</anchor>
      <arglist>(const SbBool flag)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual const SoEnabledElementsList &amp;</type>
      <name>getEnabledElements</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a92a36e12e654c3fb3838aebbfe0d2ced</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>shouldCompactPathList</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a074946b7ebc44bed35f915d04680cb36</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" protection="protected" static="yes">
      <type>static SoEnabledElementsList *</type>
      <name>getClassEnabledElements</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>ac3a072966a0f9fa9f96fa1affc44fe9b</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="protected" static="yes">
      <type>static SoActionMethodList *</type>
      <name>getClassActionMethods</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a655c3dbf9f093cdfaa7cc896ca54c0f3</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SoState *</type>
      <name>state</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a5b4ccb851346b95c3c3562b1824d258b</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SoActionMethodList *</type>
      <name>traversalMethods</name>
      <anchorfile>classSoAction.html</anchorfile>
      <anchor>a00703b6a5c0bac45ac95756f7eb054af</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoActionMethodList</name>
    <filename>classSoActionMethodList.html</filename>
    <base>SbPList</base>
    <member kind="function">
      <type></type>
      <name>SoActionMethodList</name>
      <anchorfile>classSoActionMethodList.html</anchorfile>
      <anchor>af86c8480152c573d9e75e835aa72bc74</anchor>
      <arglist>(SoActionMethodList *const parentlist)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SoActionMethodList</name>
      <anchorfile>classSoActionMethodList.html</anchorfile>
      <anchor>a474f294ac9475da3d05f269dd47c7699</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addMethod</name>
      <anchorfile>classSoActionMethodList.html</anchorfile>
      <anchor>a79983ab40c7c4be74506aff39f9e0a72</anchor>
      <arglist>(const SoType node, const SoActionMethod method)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setUp</name>
      <anchorfile>classSoActionMethodList.html</anchorfile>
      <anchor>a85d2c887bf7ccc5d8fbc3cb9e7df0050</anchor>
      <arglist>(void)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoAlarmSensor</name>
    <filename>classSoAlarmSensor.html</filename>
    <base>SoTimerQueueSensor</base>
    <member kind="function">
      <type></type>
      <name>SoAlarmSensor</name>
      <anchorfile>classSoAlarmSensor.html</anchorfile>
      <anchor>a114d31b978c009fb47f419bc356d4f88</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoAlarmSensor</name>
      <anchorfile>classSoAlarmSensor.html</anchorfile>
      <anchor>a2b5ca4eee57d66a63d73a89cf9324b2a</anchor>
      <arglist>(SoSensorCB *func, void *data)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~SoAlarmSensor</name>
      <anchorfile>classSoAlarmSensor.html</anchorfile>
      <anchor>ab504b1bd587ec26c7ffcbc5a72ac3f1f</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTime</name>
      <anchorfile>classSoAlarmSensor.html</anchorfile>
      <anchor>af1886674d1187f94ff408349f738d3cc</anchor>
      <arglist>(const SbTime &amp;abstime)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTimeFromNow</name>
      <anchorfile>classSoAlarmSensor.html</anchorfile>
      <anchor>a8988efd19de1d900859696a628e8e55f</anchor>
      <arglist>(const SbTime &amp;reltime)</arglist>
    </member>
    <member kind="function">
      <type>const SbTime &amp;</type>
      <name>getTime</name>
      <anchorfile>classSoAlarmSensor.html</anchorfile>
      <anchor>a420fd1f77e890846947be9e08d64b762</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>schedule</name>
      <anchorfile>classSoAlarmSensor.html</anchorfile>
      <anchor>a457a8626f5856284e66367e5ec8bf54a</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoTimerQueueSensor</name>
      <anchorfile>classSoTimerQueueSensor.html</anchorfile>
      <anchor>aa44140fca366b973dcd09a17f67c3593</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoTimerQueueSensor</name>
      <anchorfile>classSoTimerQueueSensor.html</anchorfile>
      <anchor>a4d62dc9062913ecfa745fde7c06169a8</anchor>
      <arglist>(SoSensorCB *func, void *data)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~SoTimerQueueSensor</name>
      <anchorfile>classSoTimerQueueSensor.html</anchorfile>
      <anchor>ad2d8778f4f166cc1fbd70968a5b2638c</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SbTime &amp;</type>
      <name>getTriggerTime</name>
      <anchorfile>classSoTimerQueueSensor.html</anchorfile>
      <anchor>a3d5ab7bf4b9106307ec4ae1994f1aa4b</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>unschedule</name>
      <anchorfile>classSoTimerQueueSensor.html</anchorfile>
      <anchor>aa6d792983952ef2af6a3e7f005af3b11</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>isScheduled</name>
      <anchorfile>classSoTimerQueueSensor.html</anchorfile>
      <anchor>afe00440d7a01a61b27f66f297d3a3f5d</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>trigger</name>
      <anchorfile>classSoTimerQueueSensor.html</anchorfile>
      <anchor>a3459bf3e4f6bda6de8da7d0a8d64f814</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoSensor</name>
      <anchorfile>classSoSensor.html</anchorfile>
      <anchor>aef8e234f18554cf8d895e49d2ad87fe3</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoSensor</name>
      <anchorfile>classSoSensor.html</anchorfile>
      <anchor>ac7b074e66870f8b291eba260b6469c2c</anchor>
      <arglist>(SoSensorCB *func, void *data)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~SoSensor</name>
      <anchorfile>classSoSensor.html</anchorfile>
      <anchor>a12f75e795419d1ec79ba4c3e2c5a31cd</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFunction</name>
      <anchorfile>classSoSensor.html</anchorfile>
      <anchor>ac0a0152828590c9b23da259a9c60a629</anchor>
      <arglist>(SoSensorCB *callbackfunction)</arglist>
    </member>
    <member kind="function">
      <type>SoSensorCBPtr</type>
      <name>getFunction</name>
      <anchorfile>classSoSensor.html</anchorfile>
      <anchor>a512bff71da628c79dc14d02019c07782</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setData</name>
      <anchorfile>classSoSensor.html</anchorfile>
      <anchor>acc7ffab34126318972fdc0830de49150</anchor>
      <arglist>(void *callbackdata)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>getData</name>
      <anchorfile>classSoSensor.html</anchorfile>
      <anchor>ac6474ccce9c26b3f72e6ad0adea03ff5</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setNextInQueue</name>
      <anchorfile>classSoSensor.html</anchorfile>
      <anchor>a011855ebf2d30b097370ebca6eee98c9</anchor>
      <arglist>(SoSensor *next)</arglist>
    </member>
    <member kind="function">
      <type>SoSensor *</type>
      <name>getNextInQueue</name>
      <anchorfile>classSoSensor.html</anchorfile>
      <anchor>af73bb1b36e43218af6186899f31a5db5</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>initClass</name>
      <anchorfile>classSoSensor.html</anchorfile>
      <anchor>a267d8529b420c15f969e124cc809e987</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>setTriggerTime</name>
      <anchorfile>classSoTimerQueueSensor.html</anchorfile>
      <anchor>aa2720312ff24da9ecf460d6e8b7fb592</anchor>
      <arglist>(const SbTime &amp;time)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbBool</type>
      <name>scheduled</name>
      <anchorfile>classSoTimerQueueSensor.html</anchorfile>
      <anchor>a22000bb83389ed0058939e77416751df</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SoSensorCB *</type>
      <name>func</name>
      <anchorfile>classSoSensor.html</anchorfile>
      <anchor>ac21ccac7235fb0f895fff539c13a0ed9</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>void *</type>
      <name>funcData</name>
      <anchorfile>classSoSensor.html</anchorfile>
      <anchor>a00da05a8947650ec2555977ed526cb6c</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoAlphaTest</name>
    <filename>classSoAlphaTest.html</filename>
    <base>SoNode</base>
    <member kind="enumeration">
      <type></type>
      <name>Function</name>
      <anchorfile>classSoAlphaTest.html</anchorfile>
      <anchor>af21bb2d9573f0673e2f636ef82f424f1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>NONE</name>
      <anchorfile>classSoAlphaTest.html</anchorfile>
      <anchor>af21bb2d9573f0673e2f636ef82f424f1a8b0557cff65c58a521bc7ec8ac83a676</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>NEVER</name>
      <anchorfile>classSoAlphaTest.html</anchorfile>
      <anchor>af21bb2d9573f0673e2f636ef82f424f1af76ce4e47d1a17e5d3a86714f55d894f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>ALWAYS</name>
      <anchorfile>classSoAlphaTest.html</anchorfile>
      <anchor>af21bb2d9573f0673e2f636ef82f424f1a5b1a78aa5e038ba10398322cebad7026</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>LESS</name>
      <anchorfile>classSoAlphaTest.html</anchorfile>
      <anchor>af21bb2d9573f0673e2f636ef82f424f1a6f8eca382fe3ae8a5eb483f33d6aa246</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>LEQUAL</name>
      <anchorfile>classSoAlphaTest.html</anchorfile>
      <anchor>af21bb2d9573f0673e2f636ef82f424f1af0b59036b3007a7ba0e46750dc3ca43e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>EQUAL</name>
      <anchorfile>classSoAlphaTest.html</anchorfile>
      <anchor>af21bb2d9573f0673e2f636ef82f424f1af7d8e0673b5e7a12949710eb07a564ec</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>GEQUAL</name>
      <anchorfile>classSoAlphaTest.html</anchorfile>
      <anchor>af21bb2d9573f0673e2f636ef82f424f1a29037b9059c646095cc398734dc2c9e4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>GREATER</name>
      <anchorfile>classSoAlphaTest.html</anchorfile>
      <anchor>af21bb2d9573f0673e2f636ef82f424f1a91b47b7fee0997423f21ac7a2f246ff0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>NOTEQUAL</name>
      <anchorfile>classSoAlphaTest.html</anchorfile>
      <anchor>af21bb2d9573f0673e2f636ef82f424f1afc6e593de21a5a964995650ea1be9da6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>NodeType</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>afaebe871158a88c800ded8c44f583b09</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>INVENTOR</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>afaebe871158a88c800ded8c44f583b09ac0831e453c51372e48be01ebf3f75d5d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>VRML1</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>afaebe871158a88c800ded8c44f583b09af394e16a0b4d94ea3336b93f865b65a2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>VRML2</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>afaebe871158a88c800ded8c44f583b09a2c12262016b245952c410f20efd7a232</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>INVENTOR_1</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>afaebe871158a88c800ded8c44f583b09a3dd4cd24b703ba3d27c03f27278020e7</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>INVENTOR_2_0</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>afaebe871158a88c800ded8c44f583b09a7968ab0659fe9def9c8e5bfbb3af4a09</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>INVENTOR_2_1</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>afaebe871158a88c800ded8c44f583b09aea47620acfc8e1c86c3913fe309b6710</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>INVENTOR_2_5</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>afaebe871158a88c800ded8c44f583b09ab07b87a88930896f6f3903544cd9df09</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>INVENTOR_2_6</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>afaebe871158a88c800ded8c44f583b09adeb3f37f9ac4d872643fab303ceca4bf</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>COIN_1_0</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>afaebe871158a88c800ded8c44f583b09ac72b86803610982c730cbba098b3676e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>COIN_2_0</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>afaebe871158a88c800ded8c44f583b09a37f44b5c6ca9907b4fd06f6fda7bb4bb</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>EXTENSION</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>afaebe871158a88c800ded8c44f583b09a3d8337c6cd271876193dfaad2578edab</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classSoAlphaTest.html</anchorfile>
      <anchor>aa03090417f90d29d7ce99fba6fbb7b49</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoAlphaTest</name>
      <anchorfile>classSoAlphaTest.html</anchorfile>
      <anchor>ac5237575286ae6204fbb62999dd96ec4</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>GLRender</name>
      <anchorfile>classSoAlphaTest.html</anchorfile>
      <anchor>a458d60b8f8a4d99945b6cac555393166</anchor>
      <arglist>(SoGLRenderAction *action)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setOverride</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>a3c4f3e94bccef0da0f47bcdf64a3e915</anchor>
      <arglist>(const SbBool state)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isOverride</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>a34d1d340b3a5e6ae9db5fa2cbb548b35</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setNodeType</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>a54cb403721ece12f95be66a3baef48a4</anchor>
      <arglist>(const NodeType type)</arglist>
    </member>
    <member kind="function">
      <type>NodeType</type>
      <name>getNodeType</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>a2b4b7b6a405f10d8995bc08c212ab4cf</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SoNode *</type>
      <name>copy</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>a5bb1642be1ce816fa367284761a3bcc9</anchor>
      <arglist>(SbBool copyconnections=FALSE) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>affectsState</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>a633c15b6ff9fc56491d686ebe26f96a0</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>doAction</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>a7f93b0ccc30d3d3283773c1b254b34ca</anchor>
      <arglist>(SoAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>GLRenderBelowPath</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>aa921ef5b5420dfb2ee8a04cc54e4f896</anchor>
      <arglist>(SoGLRenderAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>GLRenderInPath</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>aa26545310c0283245e7cab76fc92a5b5</anchor>
      <arglist>(SoGLRenderAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>GLRenderOffPath</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>a8cbbfd0f5bcf3e30528ac0bbda826bf6</anchor>
      <arglist>(SoGLRenderAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>callback</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>a8a49410ba330a0763397753677a874cb</anchor>
      <arglist>(SoCallbackAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>getBoundingBox</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>a4fe80ee53bf8d7821b9b6e91ac20f5c4</anchor>
      <arglist>(SoGetBoundingBoxAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>getMatrix</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>a8a590d9596435ff93fe37cea3aae62ca</anchor>
      <arglist>(SoGetMatrixAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>handleEvent</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>a1f198a845c3f8e8eb313762afd9cb7d5</anchor>
      <arglist>(SoHandleEventAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>pick</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>ad1acb723f774cdc90eb69f23ac191967</anchor>
      <arglist>(SoPickAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>rayPick</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>acbc15afe5dd825bfaa3c479b51fed98a</anchor>
      <arglist>(SoRayPickAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>search</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>ad45bab33f06902f1735fb05a82dec650</anchor>
      <arglist>(SoSearchAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>write</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>add1c0182576fda3e51ccc9a38dd1b694</anchor>
      <arglist>(SoWriteAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>audioRender</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>a7c6cf297f3abf3a171fd7492d0fee0e5</anchor>
      <arglist>(SoAudioRenderAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>getPrimitiveCount</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>a1e33c6b6ea83d1982ecf2febb903d942</anchor>
      <arglist>(SoGetPrimitiveCountAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>grabEventsSetup</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>af9f97e3ffaeb4e50e1e1a647a1535e47</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>grabEventsCleanup</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>a7afcbdc2e142bfa4be450e9124ac93a2</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>startNotify</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>ab623a7a6404b31e171869f953113eba7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>notify</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>a19bd6f80f2151fd082ca774068aef239</anchor>
      <arglist>(SoNotList *l)</arglist>
    </member>
    <member kind="function">
      <type>uint32_t</type>
      <name>getNodeId</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>ab52fe77c928a116a0f407c3a6c4462cb</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SoChildList *</type>
      <name>getChildren</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>af2df4f667bda1276a0a37f142f227de8</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>writeInstance</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>a2c1c9901261a3b02fa99e6b1f7223d3f</anchor>
      <arglist>(SoOutput *out)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SoNode *</type>
      <name>addToCopyDict</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>a8de5e3402ef14c3a833d59e92eb1b964</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>copyContents</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>acf00f4c8151db47b00d508b2e7c2794a</anchor>
      <arglist>(const SoFieldContainer *from, SbBool copyconnections)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SoFieldContainer *</type>
      <name>copyThroughConnection</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>a52532c42b16a2a480cf7ddf46d51b62f</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setToDefaults</name>
      <anchorfile>classSoFieldContainer.html</anchorfile>
      <anchor>a96ce6bfbc94538e8d037030f9990ee61</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>hasDefaultValues</name>
      <anchorfile>classSoFieldContainer.html</anchorfile>
      <anchor>a1bfd3ad51195e034dfebbff073f79b0e</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>fieldsAreEqual</name>
      <anchorfile>classSoFieldContainer.html</anchorfile>
      <anchor>a7bcfcef5ab9fa426500f612f85daeb9a</anchor>
      <arglist>(const SoFieldContainer *container) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copyFieldValues</name>
      <anchorfile>classSoFieldContainer.html</anchorfile>
      <anchor>abc620aa3c3c1d797772ecd8b6ba82075</anchor>
      <arglist>(const SoFieldContainer *container, SbBool copyconnections=FALSE)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>set</name>
      <anchorfile>classSoFieldContainer.html</anchorfile>
      <anchor>a42458263ddb5dbbdf9473c3dae07a483</anchor>
      <arglist>(const char *const fielddata)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get</name>
      <anchorfile>classSoFieldContainer.html</anchorfile>
      <anchor>aab59399cd2889f2504587c59a98bd35a</anchor>
      <arglist>(SbString &amp;fielddata)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>getFields</name>
      <anchorfile>classSoFieldContainer.html</anchorfile>
      <anchor>a243551995fa3e159b3a384dc8ee352c1</anchor>
      <arglist>(SoFieldList &amp;l) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>getAllFields</name>
      <anchorfile>classSoFieldContainer.html</anchorfile>
      <anchor>a440fa92008d81efb70611c0b692050c5</anchor>
      <arglist>(SoFieldList &amp;l) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SoField *</type>
      <name>getField</name>
      <anchorfile>classSoFieldContainer.html</anchorfile>
      <anchor>af37c273006d56c866373bbdbd2740e61</anchor>
      <arglist>(const SbName &amp;name) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SoField *</type>
      <name>getEventIn</name>
      <anchorfile>classSoFieldContainer.html</anchorfile>
      <anchor>adc3421886e0c2f3a942ad1ecb791bcb8</anchor>
      <arglist>(const SbName &amp;name) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SoField *</type>
      <name>getEventOut</name>
      <anchorfile>classSoFieldContainer.html</anchorfile>
      <anchor>a7cb4b21d9564a06b622fe844e3e5c166</anchor>
      <arglist>(const SbName &amp;name) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>getFieldName</name>
      <anchorfile>classSoFieldContainer.html</anchorfile>
      <anchor>af4793f88a9be2404ea0607de4a9b2111</anchor>
      <arglist>(const SoField *const field, SbName &amp;name) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>enableNotify</name>
      <anchorfile>classSoFieldContainer.html</anchorfile>
      <anchor>acfd479a5769b6f2e5c64e33bc5ecda81</anchor>
      <arglist>(const SbBool flag)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isNotifyEnabled</name>
      <anchorfile>classSoFieldContainer.html</anchorfile>
      <anchor>a26e6ab8aa9c6f6ce4e79ff89ed6bd330</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>set</name>
      <anchorfile>classSoFieldContainer.html</anchorfile>
      <anchor>aecae5577413772a3df69f8a67c9f8861</anchor>
      <arglist>(const char *fielddata, SoInput *input)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>get</name>
      <anchorfile>classSoFieldContainer.html</anchorfile>
      <anchor>a1b1ee6b9b4c4dce34072b2207d86e272</anchor>
      <arglist>(SbString &amp;fielddata, SoOutput *out)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>validateNewFieldValue</name>
      <anchorfile>classSoFieldContainer.html</anchorfile>
      <anchor>a242628b2d7e41340398754054ae11ad5</anchor>
      <arglist>(SoField *field, void *newval)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>addWriteReference</name>
      <anchorfile>classSoFieldContainer.html</anchorfile>
      <anchor>a8fe87d323c349aa7123ecbd2096a90dd</anchor>
      <arglist>(SoOutput *out, SbBool isfromfield=FALSE)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>getIsBuiltIn</name>
      <anchorfile>classSoFieldContainer.html</anchorfile>
      <anchor>aacdbdb2562de00fd2a5f3caa05aa44f7</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>getFieldsMemorySize</name>
      <anchorfile>classSoFieldContainer.html</anchorfile>
      <anchor>a21abe486f26e41c6d3dd03b28d8a30b2</anchor>
      <arglist>(size_t &amp;managed, size_t &amp;unmanaged) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setUserData</name>
      <anchorfile>classSoFieldContainer.html</anchorfile>
      <anchor>a0381b3af71e47ffccaf445aa4de38bad</anchor>
      <arglist>(void *userdata) const </arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>getUserData</name>
      <anchorfile>classSoFieldContainer.html</anchorfile>
      <anchor>a6a5d55381c6f6d8ea62f410885d68fc3</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ref</name>
      <anchorfile>classSoBase.html</anchorfile>
      <anchor>aa5cf76b995f72f073a91f40d9b4b42a9</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unref</name>
      <anchorfile>classSoBase.html</anchorfile>
      <anchor>a29e7a0f62ff982fa75bfe4eb0373d6d0</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unrefNoDelete</name>
      <anchorfile>classSoBase.html</anchorfile>
      <anchor>ae4bf96b749f2f2a8577050787f7fbee4</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>int32_t</type>
      <name>getRefCount</name>
      <anchorfile>classSoBase.html</anchorfile>
      <anchor>a5485f34f5d7159bfd4d0db7813fce585</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>touch</name>
      <anchorfile>classSoBase.html</anchorfile>
      <anchor>aba7fd51b022505fa822d295095b7f6a7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isOfType</name>
      <anchorfile>classSoBase.html</anchorfile>
      <anchor>ab15fb37137177d3137663b2194b11991</anchor>
      <arglist>(SoType type) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbName</type>
      <name>getName</name>
      <anchorfile>classSoBase.html</anchorfile>
      <anchor>a6b701830707d957fa112b1e9d9f10a08</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setName</name>
      <anchorfile>classSoBase.html</anchorfile>
      <anchor>ab9bb8b4387f5fb39d4aa3fe92ca81261</anchor>
      <arglist>(const SbName &amp;newname)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addAuditor</name>
      <anchorfile>classSoBase.html</anchorfile>
      <anchor>ae6df5f7ce9b7426544fa890d7c48b23a</anchor>
      <arglist>(void *const auditor, const SoNotRec::Type type)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeAuditor</name>
      <anchorfile>classSoBase.html</anchorfile>
      <anchor>a40434ac2a479164cbeee3f6583307b77</anchor>
      <arglist>(void *const auditor, const SoNotRec::Type type)</arglist>
    </member>
    <member kind="function">
      <type>const SoAuditorList &amp;</type>
      <name>getAuditors</name>
      <anchorfile>classSoBase.html</anchorfile>
      <anchor>af64b194d0d914bcdd97b48c53b051d4e</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>shouldWrite</name>
      <anchorfile>classSoBase.html</anchorfile>
      <anchor>a6f95394c79b081e482d94a15a823b32f</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>assertAlive</name>
      <anchorfile>classSoBase.html</anchorfile>
      <anchor>a56d653cd42bd72dc7824be40e7fc9fc8</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static uint32_t</type>
      <name>getCompatibilityTypes</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>ae749600d30d3f68fab7ec45e43b309f0</anchor>
      <arglist>(const SoType &amp;nodetype)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SoNode *</type>
      <name>getByName</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>ad8312b743a45ae88013c788b7dd94717</anchor>
      <arglist>(const SbName &amp;name)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static int</type>
      <name>getByName</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>a28ffc12aa508802ca4c22d4aa91a34dd</anchor>
      <arglist>(const SbName &amp;name, SoNodeList &amp;l)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>initClasses</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>a466efa129792e1b14437048a19cb073c</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static uint32_t</type>
      <name>getNextNodeId</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>a35e2a892910f5bc75d4ba573afe39ddb</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static int</type>
      <name>getActionMethodIndex</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>a9e9bc3dd0763fffc3844ba072d8ac43f</anchor>
      <arglist>(const SoType type)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>getBoundingBoxS</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>a91ab391491a486f54f75335f54ad3116</anchor>
      <arglist>(SoAction *action, SoNode *node)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>GLRenderS</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>a2c2f47db02ea2726e34c7edcadf72ca9</anchor>
      <arglist>(SoAction *action, SoNode *node)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>callbackS</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>ac45acbf1842b7b06465bc656b0c3e76d</anchor>
      <arglist>(SoAction *action, SoNode *node)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>getMatrixS</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>a5b49397f58a5ed03ff3d963725ee0307</anchor>
      <arglist>(SoAction *action, SoNode *node)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>handleEventS</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>aa08772cfe2d6780d8f35c652ee06bd0b</anchor>
      <arglist>(SoAction *action, SoNode *node)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>pickS</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>ad2a0c9f57f0520fcf27144783d06fb9d</anchor>
      <arglist>(SoAction *action, SoNode *node)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>rayPickS</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>afafa6668c3cdb488ac4aea1175c995c2</anchor>
      <arglist>(SoAction *action, SoNode *node)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>searchS</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>a0ad7a52381f8278fc7d776bc7ce84877</anchor>
      <arglist>(SoAction *action, SoNode *node)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>writeS</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>afdabeb342b514c04baca61377856c782</anchor>
      <arglist>(SoAction *action, SoNode *node)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>audioRenderS</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>a71c0b51745c06555f8e47ef881f90047</anchor>
      <arglist>(SoAction *action, SoNode *node)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>getPrimitiveCountS</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>abe0ca21e17894d0b42765c3925d80421</anchor>
      <arglist>(SoAction *action, SoNode *node)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>initCopyDict</name>
      <anchorfile>classSoFieldContainer.html</anchorfile>
      <anchor>abd1c5856ee0e9c1e410b44e1d860c2fc</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>addCopy</name>
      <anchorfile>classSoFieldContainer.html</anchorfile>
      <anchor>aa4bd2cf6fe33bd29bba62d49cc166233</anchor>
      <arglist>(const SoFieldContainer *orig, const SoFieldContainer *copy)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SoFieldContainer *</type>
      <name>checkCopy</name>
      <anchorfile>classSoFieldContainer.html</anchorfile>
      <anchor>aa95f3cfa95ecdb443d7d62faa1c2aee0</anchor>
      <arglist>(const SoFieldContainer *orig)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SoFieldContainer *</type>
      <name>findCopy</name>
      <anchorfile>classSoFieldContainer.html</anchorfile>
      <anchor>aa5631c8ea1ef70662b136e690cbb8cf8</anchor>
      <arglist>(const SoFieldContainer *orig, const SbBool copyconnections)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>copyDone</name>
      <anchorfile>classSoFieldContainer.html</anchorfile>
      <anchor>ac30353612cc6fc6fa1c0b953e9648fe3</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>initClass</name>
      <anchorfile>classSoBase.html</anchorfile>
      <anchor>a8419a92b3ac808c6a789673db06776be</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SoType</type>
      <name>getClassTypeId</name>
      <anchorfile>classSoBase.html</anchorfile>
      <anchor>a73ce238db093db6ba1b4009818cc9f27</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>addName</name>
      <anchorfile>classSoBase.html</anchorfile>
      <anchor>a74952f1fd17c44eb0fc9c3dc3b69102a</anchor>
      <arglist>(SoBase *const base, const char *const name)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>removeName</name>
      <anchorfile>classSoBase.html</anchorfile>
      <anchor>a427c87fa9d48a2d09da950b7a0895fc7</anchor>
      <arglist>(SoBase *const base, const char *const name)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>incrementCurrentWriteCounter</name>
      <anchorfile>classSoBase.html</anchorfile>
      <anchor>a73037fd0866b2d280e6770c1ff11649b</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>decrementCurrentWriteCounter</name>
      <anchorfile>classSoBase.html</anchorfile>
      <anchor>a9258013519caafda065433bb168ed126</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SoBase *</type>
      <name>getNamedBase</name>
      <anchorfile>classSoBase.html</anchorfile>
      <anchor>acda0e2703e0f76ef10f0b14ce19e6e42</anchor>
      <arglist>(const SbName &amp;name, SoType type)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static int</type>
      <name>getNamedBases</name>
      <anchorfile>classSoBase.html</anchorfile>
      <anchor>a64dd273d58c357da1b0df1b4212bfb29</anchor>
      <arglist>(const SbName &amp;name, SoBaseList &amp;baselist, SoType type)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SbBool</type>
      <name>read</name>
      <anchorfile>classSoBase.html</anchorfile>
      <anchor>a08ab1a0fb1b141d3afc2e745a998fc01</anchor>
      <arglist>(SoInput *input, SoBase *&amp;base, SoType expectedtype)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>setInstancePrefix</name>
      <anchorfile>classSoBase.html</anchorfile>
      <anchor>a24fef6a61e75a6bffb4f83d4cf10fca5</anchor>
      <arglist>(const SbString &amp;c)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>setTraceRefs</name>
      <anchorfile>classSoBase.html</anchorfile>
      <anchor>a4617280cf55689be859f44b1e332a414</anchor>
      <arglist>(SbBool trace)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SbBool</type>
      <name>getTraceRefs</name>
      <anchorfile>classSoBase.html</anchorfile>
      <anchor>adc549cc4452943800c625056b264d1ff</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SbBool</type>
      <name>connectRoute</name>
      <anchorfile>classSoBase.html</anchorfile>
      <anchor>ac0a10d7a457ae5403dac0e6a76d00984</anchor>
      <arglist>(SoInput *input, const SbName &amp;fromnodename, const SbName &amp;fromfieldname, const SbName &amp;tonodename, const SbName &amp;tofieldname)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SbBool</type>
      <name>readRoute</name>
      <anchorfile>classSoBase.html</anchorfile>
      <anchor>ab6687c0316a76792276a0e0e5755f552</anchor>
      <arglist>(SoInput *input)</arglist>
    </member>
    <member kind="variable">
      <type>SoSFEnum</type>
      <name>function</name>
      <anchorfile>classSoAlphaTest.html</anchorfile>
      <anchor>a683d9420bd0b60257d6eb077dd0331a5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoSFFloat</type>
      <name>value</name>
      <anchorfile>classSoAlphaTest.html</anchorfile>
      <anchor>ae6897e246889a1e8fa43567d332639dc</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual const SoFieldData *</type>
      <name>getFieldData</name>
      <anchorfile>classSoAlphaTest.html</anchorfile>
      <anchor>a355d2a53ee5ef01bd66330657399b439</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~SoAlphaTest</name>
      <anchorfile>classSoAlphaTest.html</anchorfile>
      <anchor>a66c7ac9fdd3bdd8ae4b88594d6b34bcb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>SoNode</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>a11b3f6d76929bcf86e8f8662e2f8249d</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~SoNode</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>ad7cef6be5ac6b2b2715666e2ba60128d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>readInstance</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>a9a126748a9bc691bc8cc49b8245e5855</anchor>
      <arglist>(SoInput *in, unsigned short flags)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>SoFieldContainer</name>
      <anchorfile>classSoFieldContainer.html</anchorfile>
      <anchor>a3950d8784a244da6e5d81361760f2845</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~SoFieldContainer</name>
      <anchorfile>classSoFieldContainer.html</anchorfile>
      <anchor>a4aa2232495749eb6ac1af54d200f2180</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>SoBase</name>
      <anchorfile>classSoBase.html</anchorfile>
      <anchor>a30a12f045bf793692612e8420a2d8413</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~SoBase</name>
      <anchorfile>classSoBase.html</anchorfile>
      <anchor>a4e09f562870ef14253a439aa8379c1ea</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>destroy</name>
      <anchorfile>classSoBase.html</anchorfile>
      <anchor>ab102bb9166fc2453ff67e15337038691</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>SbBool</type>
      <name>hasMultipleWriteRefs</name>
      <anchorfile>classSoBase.html</anchorfile>
      <anchor>a58a876542e7d86adf89966d3c899a97a</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" protection="protected">
      <type>SbBool</type>
      <name>writeHeader</name>
      <anchorfile>classSoBase.html</anchorfile>
      <anchor>a247faa658c4fb075e41442ac1d632b85</anchor>
      <arglist>(SoOutput *out, SbBool isgroup, SbBool isengine) const </arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>writeFooter</name>
      <anchorfile>classSoBase.html</anchorfile>
      <anchor>abdb9f869861fba02d37012b5dbcf3deb</anchor>
      <arglist>(SoOutput *out) const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual const char *</type>
      <name>getFileFormatName</name>
      <anchorfile>classSoBase.html</anchorfile>
      <anchor>a7cb3979a71e021ce8cafab2d75e2c5c5</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual SoNotRec</type>
      <name>createNotRec</name>
      <anchorfile>classSoBase.html</anchorfile>
      <anchor>aa41e45678b8c582b5202143a220ad76c</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="protected" static="yes">
      <type>static const SoFieldData **</type>
      <name>getFieldDataPtr</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>a8b4c4bf288ab4e253021238a188ab66f</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="protected" static="yes">
      <type>static void</type>
      <name>setNextActionMethodIndex</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>a6fcaac360719b61121c378ae267ca461</anchor>
      <arglist>(int index)</arglist>
    </member>
    <member kind="function" protection="protected" static="yes">
      <type>static int</type>
      <name>getNextActionMethodIndex</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>aa9ec668431c27b092c790a728ab32646</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="protected" static="yes">
      <type>static void</type>
      <name>incNextActionMethodIndex</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>a92fde0337a9037cc06dd084f6c644189</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="protected" static="yes">
      <type>static void</type>
      <name>setCompatibilityTypes</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>a52dab3d7a7ae89422c095a9c3a977e30</anchor>
      <arglist>(const SoType &amp;nodetype, const uint32_t bitmask)</arglist>
    </member>
    <member kind="function" protection="protected" static="yes">
      <type>static uint32_t</type>
      <name>getCurrentWriteCounter</name>
      <anchorfile>classSoBase.html</anchorfile>
      <anchor>a79a1022df39ae04dfefff5449d4ead24</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="protected" static="yes">
      <type>static void</type>
      <name>staticDataLock</name>
      <anchorfile>classSoBase.html</anchorfile>
      <anchor>a704e6447bdfacab4171721c803087b54</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="protected" static="yes">
      <type>static void</type>
      <name>staticDataUnlock</name>
      <anchorfile>classSoBase.html</anchorfile>
      <anchor>a7610ab9ef6c403635bb913cbf7a24032</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="enumeration" protection="protected">
      <type></type>
      <name>BaseFlags</name>
      <anchorfile>classSoBase.html</anchorfile>
      <anchor>a42fedf98911431b5a47e7734a228746f</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>uint32_t</type>
      <name>uniqueId</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>a11772c4de94b96f7bfe97062293804ff</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbBool</type>
      <name>isBuiltIn</name>
      <anchorfile>classSoFieldContainer.html</anchorfile>
      <anchor>abfdbfe7eae635b3d67893c978297401f</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected" static="yes">
      <type>static uint32_t</type>
      <name>nextUniqueId</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>a5c1d79535857c5bdede70e4be9227faf</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected" static="yes">
      <type>static int</type>
      <name>nextActionMethodIndex</name>
      <anchorfile>classSoNode.html</anchorfile>
      <anchor>a9c90bc3168a1b09951ec86ffa6658b4c</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoAmbientColorElement</name>
    <filename>classSoAmbientColorElement.html</filename>
    <base>SoReplacedElement</base>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>init</name>
      <anchorfile>classSoAmbientColorElement.html</anchorfile>
      <anchor>a368aa4ee343079b63b4cafaaa10d864e</anchor>
      <arglist>(SoState *state)</arglist>
    </member>
    <member kind="function">
      <type>int32_t</type>
      <name>getNum</name>
      <anchorfile>classSoAmbientColorElement.html</anchorfile>
      <anchor>a9370d89eb64011e7f4a50b23ae43ef60</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>const SbColor &amp;</type>
      <name>get</name>
      <anchorfile>classSoAmbientColorElement.html</anchorfile>
      <anchor>aba503b5bd12b0f1885a1ba8e53d7a58d</anchor>
      <arglist>(const int index) const </arglist>
    </member>
    <member kind="function">
      <type>const SbColor *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSoAmbientColorElement.html</anchorfile>
      <anchor>a7faeb5a15da80a7b6b39e9798ea859ef</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>matches</name>
      <anchorfile>classSoReplacedElement.html</anchorfile>
      <anchor>aee36b6c58ae4061d5088b458cf202563</anchor>
      <arglist>(const SoElement *element) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SoElement *</type>
      <name>copyMatchInfo</name>
      <anchorfile>classSoReplacedElement.html</anchorfile>
      <anchor>ab0ee93ac77371446b6f97b8be6b87f8a</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>uint32_t</type>
      <name>getNodeId</name>
      <anchorfile>classSoReplacedElement.html</anchorfile>
      <anchor>a02dc63142ee10f1e8b9badece0d84264</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>print</name>
      <anchorfile>classSoReplacedElement.html</anchorfile>
      <anchor>a89573f9676df2ca3b5c638fff73005d4</anchor>
      <arglist>(FILE *file) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>push</name>
      <anchorfile>classSoElement.html</anchorfile>
      <anchor>a69fc44b31adb066ba40bbc555298b107</anchor>
      <arglist>(SoState *state)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void *</type>
      <name>createInstance</name>
      <anchorfile>classSoAmbientColorElement.html</anchorfile>
      <anchor>a28f1ae945fee0e706603066f479674dd</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>initClass</name>
      <anchorfile>classSoAmbientColorElement.html</anchorfile>
      <anchor>a59e64b27e95f6af5ab133f8e64398dfe</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>set</name>
      <anchorfile>classSoAmbientColorElement.html</anchorfile>
      <anchor>a5629821bd220092418e313b97cc8ed2b</anchor>
      <arglist>(SoState *const state, SoNode *const node, const int32_t numcolors, const SbColor *const colors)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const SoAmbientColorElement *</type>
      <name>getInstance</name>
      <anchorfile>classSoAmbientColorElement.html</anchorfile>
      <anchor>ac874eae412b6dbbf9ecb3dbf8717fdca</anchor>
      <arglist>(SoState *state)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~SoAmbientColorElement</name>
      <anchorfile>classSoAmbientColorElement.html</anchorfile>
      <anchor>af82269472b965fda951e8d9b28f13099</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~SoReplacedElement</name>
      <anchorfile>classSoReplacedElement.html</anchorfile>
      <anchor>aa616fc07d9945d27c12302aeafe73144</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>captureThis</name>
      <anchorfile>classSoElement.html</anchorfile>
      <anchor>a4a920fb9569636f889f530f3f6b4b232</anchor>
      <arglist>(SoState *state) const </arglist>
    </member>
    <member kind="function" protection="protected" static="yes">
      <type>static SoElement *</type>
      <name>getElement</name>
      <anchorfile>classSoReplacedElement.html</anchorfile>
      <anchor>a70833996b60d53f3e54ec90a3ea9fab5</anchor>
      <arglist>(SoState *const state, const int stackIndex, SoNode *const node)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>uint32_t</type>
      <name>nodeId</name>
      <anchorfile>classSoReplacedElement.html</anchorfile>
      <anchor>a7695219e8870f983e6960e4dcbbe487f</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoAnnotation</name>
    <filename>classSoAnnotation.html</filename>
    <base>SoSeparator</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classSoAnnotation.html</anchorfile>
      <anchor>a26b898ffe58bc938ca94a80cbdc85789</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoAnnotation</name>
      <anchorfile>classSoAnnotation.html</anchorfile>
      <anchor>a1cf5f2290120ddca31ae6581729589e6</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>GLRender</name>
      <anchorfile>classSoAnnotation.html</anchorfile>
      <anchor>a013d26bdf7954d82710e1cc4b53802c3</anchor>
      <arglist>(SoGLRenderAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>GLRenderBelowPath</name>
      <anchorfile>classSoAnnotation.html</anchorfile>
      <anchor>ac163eb13b6b28c244073cd6fd51e6152</anchor>
      <arglist>(SoGLRenderAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>GLRenderInPath</name>
      <anchorfile>classSoAnnotation.html</anchorfile>
      <anchor>a692f4cec9f0b9171b92c2738118ee756</anchor>
      <arglist>(SoGLRenderAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>GLRenderOffPath</name>
      <anchorfile>classSoAnnotation.html</anchorfile>
      <anchor>a3ebc773e02a9a58dd5bce711c093dc3b</anchor>
      <arglist>(SoGLRenderAction *action)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoSeparator</name>
      <anchorfile>classSoSeparator.html</anchorfile>
      <anchor>ad7f6193eae60c6472805adfb4fe9bf8c</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoSeparator</name>
      <anchorfile>classSoSeparator.html</anchorfile>
      <anchor>ad1e38488e022de4d26959d2fa80be211</anchor>
      <arglist>(const int nchildren)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>doAction</name>
      <anchorfile>classSoSeparator.html</anchorfile>
      <anchor>aaf118218be778ea04ce57ef324c5dfd4</anchor>
      <arglist>(SoAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>callback</name>
      <anchorfile>classSoSeparator.html</anchorfile>
      <anchor>a81ec52d27db047d5494aef8cf14ffccc</anchor>
      <arglist>(SoCallbackAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>getBoundingBox</name>
      <anchorfile>classSoSeparator.html</anchorfile>
      <anchor>a5c5a86e7711f424c0a03620d5b6a4b66</anchor>
      <arglist>(SoGetBoundingBoxAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>getMatrix</name>
      <anchorfile>classSoSeparator.html</anchorfile>
      <anchor>acf1998647522bf0c94f3c5cbef47dcd0</anchor>
      <arglist>(SoGetMatrixAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>handleEvent</name>
      <anchorfile>classSoSeparator.html</anchorfile>
      <anchor>ac9615e18520dae307a27f7ce702f2d2a</anchor>
      <arglist>(SoHandleEventAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>rayPick</name>
      <anchorfile>classSoSeparator.html</anchorfile>
      <anchor>aec8d7ff5aa0b22c05186384220f6f968</anchor>
      <arglist>(SoRayPickAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>search</name>
      <anchorfile>classSoSeparator.html</anchorfile>
      <anchor>a424aa0ce45dd2871f210d33486e0736e</anchor>
      <arglist>(SoSearchAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>getPrimitiveCount</name>
      <anchorfile>classSoSeparator.html</anchorfile>
      <anchor>a43c5e64fc553d1f0b0e826cf04bc7e42</anchor>
      <arglist>(SoGetPrimitiveCountAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>audioRender</name>
      <anchorfile>classSoSeparator.html</anchorfile>
      <anchor>a380f637a8c2b165a6132e21ce76d9da4</anchor>
      <arglist>(SoAudioRenderAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>notify</name>
      <anchorfile>classSoSeparator.html</anchorfile>
      <anchor>a0d71862bb6eb5e8416f6ca6df2582d18</anchor>
      <arglist>(SoNotList *nl)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>affectsState</name>
      <anchorfile>classSoSeparator.html</anchorfile>
      <anchor>a1da7b0209b1361ebb1637e9cb484164c</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoGroup</name>
      <anchorfile>classSoGroup.html</anchorfile>
      <anchor>a6a166a894fe88f6c186efd09ecff7cf8</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoGroup</name>
      <anchorfile>classSoGroup.html</anchorfile>
      <anchor>aa7e15ff5654c7ab4724b397fff8ae889</anchor>
      <arglist>(int nchildren)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>addChild</name>
      <anchorfile>classSoGroup.html</anchorfile>
      <anchor>a23e0a7aebf3ec75c40638cc360c0e5e6</anchor>
      <arglist>(SoNode *node)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>insertChild</name>
      <anchorfile>classSoGroup.html</anchorfile>
      <anchor>a0a87322279423aab116fe442626158b7</anchor>
      <arglist>(SoNode *child, int newchildindex)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SoNode *</type>
      <name>getChild</name>
      <anchorfile>classSoGroup.html</anchorfile>
      <anchor>aa15cf5f6a91f19377852b71efb670a9b</anchor>
      <arglist>(int index) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>findChild</name>
      <anchorfile>classSoGroup.html</anchorfile>
      <anchor>a1c662ef0bbe4052c6573f595b94276b7</anchor>
      <arglist>(const SoNode *node) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>getNumChildren</name>
      <anchorfile>classSoGroup.html</anchorfile>
      <anchor>afb2aef68e18331b6edc3523cf6f546f2</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>removeChild</name>
      <anchorfile>classSoGroup.html</anchorfile>
      <anchor>a08a8536e74a09043e820206cc1107c77</anchor>
      <arglist>(int childindex)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>removeChild</name>
      <anchorfile>classSoGroup.html</anchorfile>
      <anchor>a4164d0ef348129adf0ec244153576e07</anchor>
      <arglist>(SoNode *child)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>removeAllChildren</name>
      <anchorfile>classSoGroup.html</anchorfile>
      <anchor>a0e0f51c52b2a78173c46531785decd36</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>replaceChild</name>
      <anchorfile>classSoGroup.html</anchorfile>
      <anchor>ad8ad1c3ce980cd622a9e6481dc567d0c</anchor>
      <arglist>(int index, SoNode *newchild)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>replaceChild</name>
      <anchorfile>classSoGroup.html</anchorfile>
      <anchor>ae006a114fac6746a3514eebd0a8f3dc5</anchor>
      <arglist>(SoNode *oldchild, SoNode *newchild)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>pick</name>
      <anchorfile>classSoGroup.html</anchorfile>
      <anchor>aa17968b17d069e36fc9c5598f9b43c20</anchor>
      <arglist>(SoPickAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>write</name>
      <anchorfile>classSoGroup.html</anchorfile>
      <anchor>a12aef60c111941b6663a7a77bc83b75c</anchor>
      <arglist>(SoWriteAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SoChildList *</type>
      <name>getChildren</name>
      <anchorfile>classSoGroup.html</anchorfile>
      <anchor>a6816e99adaa3bcc6056df91e4db1fca0</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>setNumRenderCaches</name>
      <anchorfile>classSoSeparator.html</anchorfile>
      <anchor>af01258db89466ee375dc8515ff461a04</anchor>
      <arglist>(const int howmany)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static int</type>
      <name>getNumRenderCaches</name>
      <anchorfile>classSoSeparator.html</anchorfile>
      <anchor>a1a68e63539ff381417d47900eed05ca7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual const SoFieldData *</type>
      <name>getFieldData</name>
      <anchorfile>classSoAnnotation.html</anchorfile>
      <anchor>a63d898683c32ee8bd99d2429e67c0130</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~SoAnnotation</name>
      <anchorfile>classSoAnnotation.html</anchorfile>
      <anchor>ad07f41206e3fbf738ba76ae86c5f68d6</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~SoSeparator</name>
      <anchorfile>classSoSeparator.html</anchorfile>
      <anchor>a1327db2197764b07dc4aa91de5c1c1a4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>cullTest</name>
      <anchorfile>classSoSeparator.html</anchorfile>
      <anchor>a1ca8311b65c6db7087867a8a9babae13</anchor>
      <arglist>(SoState *state)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>cullTest</name>
      <anchorfile>classSoSeparator.html</anchorfile>
      <anchor>a063a6864d6a8377333fd4e06bdc375be</anchor>
      <arglist>(SoGLRenderAction *action, int &amp;cullresults)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>readInstance</name>
      <anchorfile>classSoSeparator.html</anchorfile>
      <anchor>a7dbd724491497fc7ea5c45f380335e73</anchor>
      <arglist>(SoInput *in, unsigned short flags)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~SoGroup</name>
      <anchorfile>classSoGroup.html</anchorfile>
      <anchor>a45d9cfe36bf555a90b2e253a2e5a9d9b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>readChildren</name>
      <anchorfile>classSoGroup.html</anchorfile>
      <anchor>ac2d8b2d407cfdf87edf06fb986d53d02</anchor>
      <arglist>(SoInput *in)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>copyContents</name>
      <anchorfile>classSoGroup.html</anchorfile>
      <anchor>aae8e8e5103e323b5d59eb8386671cc59</anchor>
      <arglist>(const SoFieldContainer *from, SbBool copyconnections)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual SoNotRec</type>
      <name>createNotRec</name>
      <anchorfile>classSoGroup.html</anchorfile>
      <anchor>aa8cac54a0a595403f5475cc502bebdd7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>setOperation</name>
      <anchorfile>classSoGroup.html</anchorfile>
      <anchor>a0ced0d3a09ac439ea20cc78ea755f9f9</anchor>
      <arglist>(const SoNotRec::OperationType opType=SoNotRec::UNSPECIFIED, const SoNode *cc=NULL, const SoNode *pc=NULL, const int ci=-1)</arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>CacheEnabled</name>
      <anchorfile>classSoSeparator.html</anchorfile>
      <anchor>a4d0aacab3b6836083f8960031d207c7a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>OFF</name>
      <anchorfile>classSoSeparator.html</anchorfile>
      <anchor>a4d0aacab3b6836083f8960031d207c7aa821ffe63c4908003367d83f3de5d3160</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>ON</name>
      <anchorfile>classSoSeparator.html</anchorfile>
      <anchor>a4d0aacab3b6836083f8960031d207c7aa73dd81721759f093b29f13b94d123969</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>AUTO</name>
      <anchorfile>classSoSeparator.html</anchorfile>
      <anchor>a4d0aacab3b6836083f8960031d207c7aa522798bd64d9ce99991583f77f425a7a</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoSFEnum</type>
      <name>renderCaching</name>
      <anchorfile>classSoSeparator.html</anchorfile>
      <anchor>a66bb73ac97538902c0f55f8d1f4444a5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoSFEnum</type>
      <name>boundingBoxCaching</name>
      <anchorfile>classSoSeparator.html</anchorfile>
      <anchor>a060012a219ed95d686d6f1d7406d5d93</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoSFEnum</type>
      <name>renderCulling</name>
      <anchorfile>classSoSeparator.html</anchorfile>
      <anchor>a6fb6fba13bf1023d22185c0e4d850f67</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoSFEnum</type>
      <name>pickCulling</name>
      <anchorfile>classSoSeparator.html</anchorfile>
      <anchor>aaf382e5d94f190ae4bc56ea5211a5724</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SoChildList *</type>
      <name>children</name>
      <anchorfile>classSoGroup.html</anchorfile>
      <anchor>a858f7cf002e23637542fcd92d098be70</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoAnnoText3CharOrientElement</name>
    <filename>classSoAnnoText3CharOrientElement.html</filename>
    <base>SoInt32Element</base>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>init</name>
      <anchorfile>classSoAnnoText3CharOrientElement.html</anchorfile>
      <anchor>afdc0a6ff633e8fb9bd74e71f513b1049</anchor>
      <arglist>(SoState *state)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>matches</name>
      <anchorfile>classSoInt32Element.html</anchorfile>
      <anchor>a0213652995df022b9e07c93736fd0890</anchor>
      <arglist>(const SoElement *element) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SoElement *</type>
      <name>copyMatchInfo</name>
      <anchorfile>classSoInt32Element.html</anchorfile>
      <anchor>a575ffc5133d689bbc0075c5e60199a3d</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>print</name>
      <anchorfile>classSoInt32Element.html</anchorfile>
      <anchor>a4df0485c1d02d4835b73fe7b430f01ae</anchor>
      <arglist>(FILE *file) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setElt</name>
      <anchorfile>classSoInt32Element.html</anchorfile>
      <anchor>a8c2dc883660896b2aff89f72de7dacf9</anchor>
      <arglist>(int32_t value)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void *</type>
      <name>createInstance</name>
      <anchorfile>classSoAnnoText3CharOrientElement.html</anchorfile>
      <anchor>ac49260c3e67377d195e97190220cfca2</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>initClass</name>
      <anchorfile>classSoAnnoText3CharOrientElement.html</anchorfile>
      <anchor>a581c562a5131c9a550d14a81f1acf8b4</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>set</name>
      <anchorfile>classSoAnnoText3CharOrientElement.html</anchorfile>
      <anchor>ae550a4525a0bf0c4faf6c26a199cb8c2</anchor>
      <arglist>(SoState *const state, SbBool isOriented)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SbBool</type>
      <name>get</name>
      <anchorfile>classSoAnnoText3CharOrientElement.html</anchorfile>
      <anchor>a7b0c871d540bdefd03299cfccb0c1c81</anchor>
      <arglist>(SoState *state)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SbBool</type>
      <name>getDefault</name>
      <anchorfile>classSoAnnoText3CharOrientElement.html</anchorfile>
      <anchor>af8292ed270ee6b890a0f856d4eee1d9e</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>set</name>
      <anchorfile>classSoInt32Element.html</anchorfile>
      <anchor>a02d87fb2e27bd17355ffbb05ef106d29</anchor>
      <arglist>(const int index, SoState *const state, const int32_t value)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static int32_t</type>
      <name>get</name>
      <anchorfile>classSoInt32Element.html</anchorfile>
      <anchor>a616f8407ec7222158c6d73b039ef8e45</anchor>
      <arglist>(const int index, SoState *const state)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~SoAnnoText3CharOrientElement</name>
      <anchorfile>classSoAnnoText3CharOrientElement.html</anchorfile>
      <anchor>afd0ba435beb4eda0bb9f1bd882134c8d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int32_t</type>
      <name>data</name>
      <anchorfile>classSoInt32Element.html</anchorfile>
      <anchor>ad2adf8868e417739697ee385ced135e0</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoAnnoText3FontSizeHintElement</name>
    <filename>classSoAnnoText3FontSizeHintElement.html</filename>
    <base>SoInt32Element</base>
    <member kind="enumeration">
      <type></type>
      <name>FontSizeHint</name>
      <anchorfile>classSoAnnoText3FontSizeHintElement.html</anchorfile>
      <anchor>a98f0d14bf9b70be20542b622b125d15a</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>init</name>
      <anchorfile>classSoAnnoText3FontSizeHintElement.html</anchorfile>
      <anchor>afe7bfe55a1872e2893abac0e0017175a</anchor>
      <arglist>(SoState *state)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void *</type>
      <name>createInstance</name>
      <anchorfile>classSoAnnoText3FontSizeHintElement.html</anchorfile>
      <anchor>a9a1ee1c83e43c16d38fc30f519b789bb</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>initClass</name>
      <anchorfile>classSoAnnoText3FontSizeHintElement.html</anchorfile>
      <anchor>a44c607eeee829147dafad3a4865df7b4</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>set</name>
      <anchorfile>classSoAnnoText3FontSizeHintElement.html</anchorfile>
      <anchor>a417518c1b885acaa084d15afc9e68a01</anchor>
      <arglist>(SoState *const state, const FontSizeHint hint)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static FontSizeHint</type>
      <name>get</name>
      <anchorfile>classSoAnnoText3FontSizeHintElement.html</anchorfile>
      <anchor>accc6a6e8cfe921724ae55e377ee00f76</anchor>
      <arglist>(SoState *const state)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static FontSizeHint</type>
      <name>getDefault</name>
      <anchorfile>classSoAnnoText3FontSizeHintElement.html</anchorfile>
      <anchor>a73f0b1789aaabaa5871ad7e0b9fd52c3</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>set</name>
      <anchorfile>classSoAnnoText3FontSizeHintElement.html</anchorfile>
      <anchor>a1340607d80d51b178fdb590c3efb1068</anchor>
      <arglist>(SoState *const state, SoNode *const node, const FontSizeHint hint)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~SoAnnoText3FontSizeHintElement</name>
      <anchorfile>classSoAnnoText3FontSizeHintElement.html</anchorfile>
      <anchor>acf0dbe3e49012b99e2809c4a9147905b</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoAnnoText3RenderPrintElement</name>
    <filename>classSoAnnoText3RenderPrintElement.html</filename>
    <base>SoInt32Element</base>
    <member kind="enumeration">
      <type></type>
      <name>RenderPrintType</name>
      <anchorfile>classSoAnnoText3RenderPrintElement.html</anchorfile>
      <anchor>a702375a265c616b3c6c54277866a59d2</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>init</name>
      <anchorfile>classSoAnnoText3RenderPrintElement.html</anchorfile>
      <anchor>a9ce4457f345b033c3d11f59427c9b320</anchor>
      <arglist>(SoState *state)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void *</type>
      <name>createInstance</name>
      <anchorfile>classSoAnnoText3RenderPrintElement.html</anchorfile>
      <anchor>a93e94aa8053b946468c76401d2955a8f</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>initClass</name>
      <anchorfile>classSoAnnoText3RenderPrintElement.html</anchorfile>
      <anchor>a560eb4fadca5662e1f4df74d00fcc55f</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>set</name>
      <anchorfile>classSoAnnoText3RenderPrintElement.html</anchorfile>
      <anchor>afe06909553fa8329c2fa5994618ee3a9</anchor>
      <arglist>(SoState *const state, const RenderPrintType hint)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static RenderPrintType</type>
      <name>get</name>
      <anchorfile>classSoAnnoText3RenderPrintElement.html</anchorfile>
      <anchor>ab65b711c1ca56f2487d587ec3bd6c1d2</anchor>
      <arglist>(SoState *const state)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static RenderPrintType</type>
      <name>getDefault</name>
      <anchorfile>classSoAnnoText3RenderPrintElement.html</anchorfile>
      <anchor>a0a4a981987fbd6b2003c5248143fd033</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>set</name>
      <anchorfile>classSoAnnoText3RenderPrintElement.html</anchorfile>
      <anchor>ad8bbfd6051c745689d91da6a35931dd7</anchor>
      <arglist>(SoState *const state, SoNode *const node, const RenderPrintType type)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~SoAnnoText3RenderPrintElement</name>
      <anchorfile>classSoAnnoText3RenderPrintElement.html</anchorfile>
      <anchor>a63a250105c3b2c93a15b54c8e07b3fb8</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoAntiSquish</name>
    <filename>classSoAntiSquish.html</filename>
    <base>SoTransformation</base>
    <member kind="enumeration">
      <type></type>
      <name>Sizing</name>
      <anchorfile>classSoAntiSquish.html</anchorfile>
      <anchor>acf81274786acabfd0ae29fb4153e2c58</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classSoAntiSquish.html</anchorfile>
      <anchor>ab4d3957b02985133c59f6a2e3971433e</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoAntiSquish</name>
      <anchorfile>classSoAntiSquish.html</anchorfile>
      <anchor>a064915282a46650395701d0b89782d87</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>recalc</name>
      <anchorfile>classSoAntiSquish.html</anchorfile>
      <anchor>aa73905e1f7b5e08832bd8853347526d5</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>doAction</name>
      <anchorfile>classSoAntiSquish.html</anchorfile>
      <anchor>ae4b654892639e4b97eb6a96091e6647c</anchor>
      <arglist>(SoAction *action)</arglist>
    </member>
    <member kind="variable">
      <type>SoSFEnum</type>
      <name>sizing</name>
      <anchorfile>classSoAntiSquish.html</anchorfile>
      <anchor>a6be9e92711ab95e09bc2c3ebe1a96456</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoSFBool</type>
      <name>recalcAlways</name>
      <anchorfile>classSoAntiSquish.html</anchorfile>
      <anchor>a5a3a74c44b6aa014a46cf87bc6242708</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual const SoFieldData *</type>
      <name>getFieldData</name>
      <anchorfile>classSoAntiSquish.html</anchorfile>
      <anchor>ac2199444299a7325deb9af9cb1a2064d</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~SoAntiSquish</name>
      <anchorfile>classSoAntiSquish.html</anchorfile>
      <anchor>aeea57d2f55d6479b85f7a74c0049b558</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>callback</name>
      <anchorfile>classSoAntiSquish.html</anchorfile>
      <anchor>adfc66ffab1845a91be6dcfe61e6d31ba</anchor>
      <arglist>(SoCallbackAction *action)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>GLRender</name>
      <anchorfile>classSoAntiSquish.html</anchorfile>
      <anchor>a2681fcaee3e9fe97cb1162e14e5333bc</anchor>
      <arglist>(SoGLRenderAction *action)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>getBoundingBox</name>
      <anchorfile>classSoAntiSquish.html</anchorfile>
      <anchor>a78d48e6a4e1e736d074f1ba199d10b45</anchor>
      <arglist>(SoGetBoundingBoxAction *action)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>getMatrix</name>
      <anchorfile>classSoAntiSquish.html</anchorfile>
      <anchor>a7960bb46f40ff784d69bca61a7494b05</anchor>
      <arglist>(SoGetMatrixAction *action)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>pick</name>
      <anchorfile>classSoAntiSquish.html</anchorfile>
      <anchor>adb7ca96c12f3465adc814439f9662307</anchor>
      <arglist>(SoPickAction *action)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>SbMatrix</type>
      <name>getUnsquishingMatrix</name>
      <anchorfile>classSoAntiSquish.html</anchorfile>
      <anchor>a20143231ceb173a193544c58f9404543</anchor>
      <arglist>(const SbMatrix &amp;squishedmatrix, const SbBool calcinverse, SbMatrix &amp;getinverse)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>SoTransformation</name>
      <anchorfile>classSoTransformation.html</anchorfile>
      <anchor>a3ea84d9186777f1a3f657abb60e31025</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~SoTransformation</name>
      <anchorfile>classSoTransformation.html</anchorfile>
      <anchor>a81c406afcde1940b52cf610b7b615f81</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoAppearanceKit</name>
    <filename>classSoAppearanceKit.html</filename>
    <base>SoBaseKit</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classSoAppearanceKit.html</anchorfile>
      <anchor>a9988d8bc10b788df867c41dec500d258</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const SoNodekitCatalog *</type>
      <name>getNodekitCatalog</name>
      <anchorfile>classSoAppearanceKit.html</anchorfile>
      <anchor>a33e7c3acda4639e12a18110ecbf14206</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoAppearanceKit</name>
      <anchorfile>classSoAppearanceKit.html</anchorfile>
      <anchor>a2f85da1bcbcf0455757b9877d4779f4a</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoBaseKit</name>
      <anchorfile>classSoBaseKit.html</anchorfile>
      <anchor>a4dec0b9a34a39eaf52a295e2f1ec54ad</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SoNode *</type>
      <name>getPart</name>
      <anchorfile>classSoBaseKit.html</anchorfile>
      <anchor>ae48bff9f8e65610b531509e5b68dbc60</anchor>
      <arglist>(const SbName &amp;partname, SbBool makeifneeded)</arglist>
    </member>
    <member kind="function">
      <type>SbString</type>
      <name>getPartString</name>
      <anchorfile>classSoBaseKit.html</anchorfile>
      <anchor>ada02ebb37e902287724ef764cb010c03</anchor>
      <arglist>(const SoBase *part)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SoNodeKitPath *</type>
      <name>createPathToPart</name>
      <anchorfile>classSoBaseKit.html</anchorfile>
      <anchor>a57d3e0d10243896d1230e83d21ecd1c4</anchor>
      <arglist>(const SbName &amp;partname, SbBool makeifneeded, const SoPath *pathtoextend=NULL)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>setPart</name>
      <anchorfile>classSoBaseKit.html</anchorfile>
      <anchor>ab3f42ab04032e4f420625d314b606ae6</anchor>
      <arglist>(const SbName &amp;partname, SoNode *from)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>set</name>
      <anchorfile>classSoBaseKit.html</anchorfile>
      <anchor>af95e20233ed052d76be5100ab59899d6</anchor>
      <arglist>(const char *namevaluepairliststring)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>set</name>
      <anchorfile>classSoBaseKit.html</anchorfile>
      <anchor>ae7cd4c0dd7cc63e1f77a0aa682aea131</anchor>
      <arglist>(const char *partnamestring, const char *parameterstring)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>doAction</name>
      <anchorfile>classSoBaseKit.html</anchorfile>
      <anchor>a81fbcf9e1f0d540863eee8ef7f6adc99</anchor>
      <arglist>(SoAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>callback</name>
      <anchorfile>classSoBaseKit.html</anchorfile>
      <anchor>a1addad3c257bb56a44cba69123ee8bad</anchor>
      <arglist>(SoCallbackAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>GLRender</name>
      <anchorfile>classSoBaseKit.html</anchorfile>
      <anchor>a46ac002f670fe64bc68dcac902585482</anchor>
      <arglist>(SoGLRenderAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>getBoundingBox</name>
      <anchorfile>classSoBaseKit.html</anchorfile>
      <anchor>a33297f85e39ae607f19a6cc6010109a7</anchor>
      <arglist>(SoGetBoundingBoxAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>getMatrix</name>
      <anchorfile>classSoBaseKit.html</anchorfile>
      <anchor>aa26377f9df575c8f8aec2e89892ba2c3</anchor>
      <arglist>(SoGetMatrixAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>handleEvent</name>
      <anchorfile>classSoBaseKit.html</anchorfile>
      <anchor>a9f4713081d8019982c2d32b289028f9b</anchor>
      <arglist>(SoHandleEventAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>rayPick</name>
      <anchorfile>classSoBaseKit.html</anchorfile>
      <anchor>a4cec6a00edccd42396e5a01fc256ddff</anchor>
      <arglist>(SoRayPickAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>search</name>
      <anchorfile>classSoBaseKit.html</anchorfile>
      <anchor>af6c97be07ab6ad0707eb3f4560b33438</anchor>
      <arglist>(SoSearchAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>write</name>
      <anchorfile>classSoBaseKit.html</anchorfile>
      <anchor>a0a2780f431dcdebfbe1c7e8caca412fd</anchor>
      <arglist>(SoWriteAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>getPrimitiveCount</name>
      <anchorfile>classSoBaseKit.html</anchorfile>
      <anchor>a7601b8a704fecb1f848b12ccf6eb190b</anchor>
      <arglist>(SoGetPrimitiveCountAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SoChildList *</type>
      <name>getChildren</name>
      <anchorfile>classSoBaseKit.html</anchorfile>
      <anchor>a6379d00b14e5b257a19773e76f45163a</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>printDiagram</name>
      <anchorfile>classSoBaseKit.html</anchorfile>
      <anchor>a4b6e08a286e936da9f50c40b320ca6f6</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>printSubDiagram</name>
      <anchorfile>classSoBaseKit.html</anchorfile>
      <anchor>add060d40bf336aeddd867a14c88cf7c8</anchor>
      <arglist>(const SbName &amp;rootname, int level)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>printTable</name>
      <anchorfile>classSoBaseKit.html</anchorfile>
      <anchor>a2ad93cb4c60b167c2ac58c6f8ec601fa</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>addWriteReference</name>
      <anchorfile>classSoBaseKit.html</anchorfile>
      <anchor>a87a63c4f45dd2a46b9af1b7c76682a06</anchor>
      <arglist>(SoOutput *out, SbBool isfromfield=FALSE)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>forceChildDrivenWriteRefs</name>
      <anchorfile>classSoBaseKit.html</anchorfile>
      <anchor>af619ae19764e72989fc7c3382e27dc01</anchor>
      <arglist>(SoOutput *out)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const SoNodekitCatalog *</type>
      <name>getClassNodekitCatalog</name>
      <anchorfile>classSoBaseKit.html</anchorfile>
      <anchor>a022c621ef5ba06480cdbc7b58086bb30</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SbBool</type>
      <name>isSearchingChildren</name>
      <anchorfile>classSoBaseKit.html</anchorfile>
      <anchor>a8a5747aebe003b3776849165d485ceec</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>setSearchingChildren</name>
      <anchorfile>classSoBaseKit.html</anchorfile>
      <anchor>ac713693906550abdc31e5013853e8f9f</anchor>
      <arglist>(const SbBool newval)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual const SoFieldData *</type>
      <name>getFieldData</name>
      <anchorfile>classSoAppearanceKit.html</anchorfile>
      <anchor>a33ee7681c99c0e66c7d846158f6c2054</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~SoAppearanceKit</name>
      <anchorfile>classSoAppearanceKit.html</anchorfile>
      <anchor>aa60b9412c5e5fb507bc4dd614125dda9</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~SoBaseKit</name>
      <anchorfile>classSoBaseKit.html</anchorfile>
      <anchor>a2fdc22950499677d862dde300f7348c5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual SoNode *</type>
      <name>addToCopyDict</name>
      <anchorfile>classSoBaseKit.html</anchorfile>
      <anchor>a457b355a188c8c1773c9f95586e5d2d4</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>copyContents</name>
      <anchorfile>classSoBaseKit.html</anchorfile>
      <anchor>af01f71c1044cf4f7cd7a3750702889cd</anchor>
      <arglist>(const SoFieldContainer *fromfc, SbBool copyconnections)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>SoGroup *</type>
      <name>getContainerNode</name>
      <anchorfile>classSoBaseKit.html</anchorfile>
      <anchor>a6523a1f5133a44151a5c85a488fd6da2</anchor>
      <arglist>(const SbName &amp;listname, SbBool makeifneeded=TRUE)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual SoNode *</type>
      <name>getAnyPart</name>
      <anchorfile>classSoBaseKit.html</anchorfile>
      <anchor>a58abf39790879ae7dd38c70c43081455</anchor>
      <arglist>(const SbName &amp;partname, SbBool makeifneeded, SbBool leafcheck=FALSE, SbBool publiccheck=FALSE)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual SoNodeKitPath *</type>
      <name>createPathToAnyPart</name>
      <anchorfile>classSoBaseKit.html</anchorfile>
      <anchor>aceea85bcbbce8b9041ef7e69e116736c</anchor>
      <arglist>(const SbName &amp;partname, SbBool makeifneeded, SbBool leafcheck=FALSE, SbBool publiccheck=FALSE, const SoPath *pathtoextend=NULL)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>setAnyPart</name>
      <anchorfile>classSoBaseKit.html</anchorfile>
      <anchor>af84407cec5591140bab6b16ceae7c76e</anchor>
      <arglist>(const SbName &amp;partname, SoNode *from, SbBool anypart=TRUE)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>createNodekitPartsList</name>
      <anchorfile>classSoBaseKit.html</anchorfile>
      <anchor>a4291b8c74c2922317d35e83b8fad56c4</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>createFieldList</name>
      <anchorfile>classSoBaseKit.html</anchorfile>
      <anchor>a666d821feed9939f9cc00faef6ad854a</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>createDefaultParts</name>
      <anchorfile>classSoBaseKit.html</anchorfile>
      <anchor>a4125f12156cad5257100bc582f08604d</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>const SoNodekitParts *</type>
      <name>getNodekitPartsList</name>
      <anchorfile>classSoBaseKit.html</anchorfile>
      <anchor>abd6bd994e3319463a4cf7e7fc6af0091</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" protection="protected">
      <type>const SbList&lt; SoSFNode * &gt; &amp;</type>
      <name>getCatalogInstances</name>
      <anchorfile>classSoBaseKit.html</anchorfile>
      <anchor>a0b7c058487261a23998999eadfc05fda</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>catalogError</name>
      <anchorfile>classSoBaseKit.html</anchorfile>
      <anchor>a5f63886df8a0cb1072eebdc775adee98</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>setUpConnections</name>
      <anchorfile>classSoBaseKit.html</anchorfile>
      <anchor>ad0dfa76f0a788985303733bbcc40f41b</anchor>
      <arglist>(SbBool onoff, SbBool doitalways=FALSE)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>readInstance</name>
      <anchorfile>classSoBaseKit.html</anchorfile>
      <anchor>ad102080de639b4e27df578660305cf4d</anchor>
      <arglist>(SoInput *in, unsigned short flags)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>setDefaultOnNonWritingFields</name>
      <anchorfile>classSoBaseKit.html</anchorfile>
      <anchor>a7760408922615010fea9979e5bc2ef00</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>countMyFields</name>
      <anchorfile>classSoBaseKit.html</anchorfile>
      <anchor>abdbff25ca69acf6c96da402a8245f44a</anchor>
      <arglist>(SoOutput *out)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>setPart</name>
      <anchorfile>classSoBaseKit.html</anchorfile>
      <anchor>a803697aab11a8b4ced0d51d6eaa20882</anchor>
      <arglist>(const int partNum, SoNode *node)</arglist>
    </member>
    <member kind="function" protection="protected" static="yes">
      <type>static const SoNodekitCatalog **</type>
      <name>getClassNodekitCatalogPtr</name>
      <anchorfile>classSoBaseKit.html</anchorfile>
      <anchor>a98eba60b232f47d280ea53c1aedc7d2f</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SoChildList *</type>
      <name>children</name>
      <anchorfile>classSoBaseKit.html</anchorfile>
      <anchor>ae4ab33e30abfa604966d85aa9be58fcd</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbBool</type>
      <name>connectionsSetUp</name>
      <anchorfile>classSoBaseKit.html</anchorfile>
      <anchor>a318dfc1790c5762ea18979af0ea43e8e</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoArray</name>
    <filename>classSoArray.html</filename>
    <base>SoGroup</base>
    <member kind="enumeration">
      <type></type>
      <name>Origin</name>
      <anchorfile>classSoArray.html</anchorfile>
      <anchor>acdc932cbda633b70e4204b2c375e88e0</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classSoArray.html</anchorfile>
      <anchor>aca8fd6dbac653d1dab16e2f3fd17cd04</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoArray</name>
      <anchorfile>classSoArray.html</anchorfile>
      <anchor>a7b5b19902e1608e5ae0d4e0c316ff53b</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>affectsState</name>
      <anchorfile>classSoArray.html</anchorfile>
      <anchor>a3f1ea72bd413dd99b3a1a098dda034fa</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>doAction</name>
      <anchorfile>classSoArray.html</anchorfile>
      <anchor>a50540c8e3a3a5b5be3ac912ea2cdbc1f</anchor>
      <arglist>(SoAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>callback</name>
      <anchorfile>classSoArray.html</anchorfile>
      <anchor>aa61d05d06738bbb23731bf142de990be</anchor>
      <arglist>(SoCallbackAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>GLRender</name>
      <anchorfile>classSoArray.html</anchorfile>
      <anchor>ad89401e284d38c6f420156ef9ed36058</anchor>
      <arglist>(SoGLRenderAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>pick</name>
      <anchorfile>classSoArray.html</anchorfile>
      <anchor>a818571654048a878fe8ab8c47235a7b3</anchor>
      <arglist>(SoPickAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>getBoundingBox</name>
      <anchorfile>classSoArray.html</anchorfile>
      <anchor>a089a7ce14fd5520045cdb7f09ab142f8</anchor>
      <arglist>(SoGetBoundingBoxAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>handleEvent</name>
      <anchorfile>classSoArray.html</anchorfile>
      <anchor>a0f247778200f239aaf14672dc5bb2ec5</anchor>
      <arglist>(SoHandleEventAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>getMatrix</name>
      <anchorfile>classSoArray.html</anchorfile>
      <anchor>a27043b61deecca1ab00d7e74b6ae24f7</anchor>
      <arglist>(SoGetMatrixAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>search</name>
      <anchorfile>classSoArray.html</anchorfile>
      <anchor>ada3660b662f2742c4820b776dc5e89ae</anchor>
      <arglist>(SoSearchAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>getPrimitiveCount</name>
      <anchorfile>classSoArray.html</anchorfile>
      <anchor>a6733adb6f1458ea049b180420b793ae3</anchor>
      <arglist>(SoGetPrimitiveCountAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>audioRender</name>
      <anchorfile>classSoArray.html</anchorfile>
      <anchor>a58ddb72bd94d39fcc36cd426e2ee7aa7</anchor>
      <arglist>(SoAudioRenderAction *action)</arglist>
    </member>
    <member kind="variable">
      <type>SoSFEnum</type>
      <name>origin</name>
      <anchorfile>classSoArray.html</anchorfile>
      <anchor>aed1969dc01b91311a250b6d81c7803e1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoSFShort</type>
      <name>numElements1</name>
      <anchorfile>classSoArray.html</anchorfile>
      <anchor>aace726981980dae1ef63db4dab741332</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoSFShort</type>
      <name>numElements2</name>
      <anchorfile>classSoArray.html</anchorfile>
      <anchor>a6e3d902db8a5e82c46b1b1519fced98c</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoSFShort</type>
      <name>numElements3</name>
      <anchorfile>classSoArray.html</anchorfile>
      <anchor>a4333cf0af1c029f90f09ad10adec1e43</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoSFVec3f</type>
      <name>separation1</name>
      <anchorfile>classSoArray.html</anchorfile>
      <anchor>a88174cbcd5f8b5aa814e0ded07b7fd93</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoSFVec3f</type>
      <name>separation2</name>
      <anchorfile>classSoArray.html</anchorfile>
      <anchor>a7336e5f41c2f204be13a9ff9feabde8c</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoSFVec3f</type>
      <name>separation3</name>
      <anchorfile>classSoArray.html</anchorfile>
      <anchor>a4077b7549292861935bb568fbe61df43</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual const SoFieldData *</type>
      <name>getFieldData</name>
      <anchorfile>classSoArray.html</anchorfile>
      <anchor>ab2392814423781627264fe1207f70fa9</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~SoArray</name>
      <anchorfile>classSoArray.html</anchorfile>
      <anchor>a70f44e6acafd73e4d9313c5da8194d0f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>readInstance</name>
      <anchorfile>classSoGroup.html</anchorfile>
      <anchor>a3c6b5609d4c6e5ec4ff5fe5797e15fed</anchor>
      <arglist>(SoInput *in, unsigned short flags)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoAsciiText</name>
    <filename>classSoAsciiText.html</filename>
    <base>SoShape</base>
    <member kind="enumeration">
      <type></type>
      <name>Justification</name>
      <anchorfile>classSoAsciiText.html</anchorfile>
      <anchor>a1e1f759dd2b359aa0bd87d26e79a3b56</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>LEFT</name>
      <anchorfile>classSoAsciiText.html</anchorfile>
      <anchor>a1e1f759dd2b359aa0bd87d26e79a3b56a93e6a2224d1a4cc937e3b1e9d767656f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>RIGHT</name>
      <anchorfile>classSoAsciiText.html</anchorfile>
      <anchor>a1e1f759dd2b359aa0bd87d26e79a3b56a9144235c28d36468b935cf443e491f04</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>CENTER</name>
      <anchorfile>classSoAsciiText.html</anchorfile>
      <anchor>a1e1f759dd2b359aa0bd87d26e79a3b56af246d2695e0a7ce61fc77e888a46ea39</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>TriangleShape</name>
      <anchorfile>classSoShape.html</anchorfile>
      <anchor>a997e88ea175786836687c5f2e99aebc7</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classSoAsciiText.html</anchorfile>
      <anchor>a495ec70c2e4085c9ffe5b43d68a7fca9</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoAsciiText</name>
      <anchorfile>classSoAsciiText.html</anchorfile>
      <anchor>a2c599144d2e23922e86c97618a3e1380</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>GLRender</name>
      <anchorfile>classSoAsciiText.html</anchorfile>
      <anchor>a77e0052bfb8b272e18544f3049ec5d3d</anchor>
      <arglist>(SoGLRenderAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>getPrimitiveCount</name>
      <anchorfile>classSoAsciiText.html</anchorfile>
      <anchor>a4110cfb8b219662d4d6eeebc5a7460bb</anchor>
      <arglist>(SoGetPrimitiveCountAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>affectsState</name>
      <anchorfile>classSoShape.html</anchorfile>
      <anchor>a2dcecc96ec05d4e1f534edb668532695</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>getBoundingBox</name>
      <anchorfile>classSoShape.html</anchorfile>
      <anchor>a364f51dbdd81c7e432afb9a94e2d12f5</anchor>
      <arglist>(SoGetBoundingBoxAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>rayPick</name>
      <anchorfile>classSoShape.html</anchorfile>
      <anchor>af24558c23bc709b2a28bb2931d91a94a</anchor>
      <arglist>(SoRayPickAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>callback</name>
      <anchorfile>classSoShape.html</anchorfile>
      <anchor>ac894fd8fd34d1ddf41e5d65738dd1d6e</anchor>
      <arglist>(SoCallbackAction *action)</arglist>
    </member>
    <member kind="function">
      <type>const SoBoundingBoxCache *</type>
      <name>getBoundingBoxCache</name>
      <anchorfile>classSoShape.html</anchorfile>
      <anchor>a652f5ff1da23ffd399e604a56c7d1b6c</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>getScreenSize</name>
      <anchorfile>classSoShape.html</anchorfile>
      <anchor>aef78da6f6a367067cd80b96ddbb7c193</anchor>
      <arglist>(SoState *const state, const SbBox3f &amp;boundingbox, SbVec2s &amp;rectsize)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static float</type>
      <name>getDecimatedComplexity</name>
      <anchorfile>classSoShape.html</anchorfile>
      <anchor>aa44ae544a11257933115c73243b7fe6e</anchor>
      <arglist>(SoState *state, float complexity)</arglist>
    </member>
    <member kind="variable">
      <type>SoMFString</type>
      <name>string</name>
      <anchorfile>classSoAsciiText.html</anchorfile>
      <anchor>a39b13f6d7cf678cb2b362c0150ea1161</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoSFFloat</type>
      <name>spacing</name>
      <anchorfile>classSoAsciiText.html</anchorfile>
      <anchor>a75f0c5fb74d94a478e2862c1a9ca5a2f</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoSFEnum</type>
      <name>justification</name>
      <anchorfile>classSoAsciiText.html</anchorfile>
      <anchor>a65d9c0914d0e6873df20e305daf2791a</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoMFFloat</type>
      <name>width</name>
      <anchorfile>classSoAsciiText.html</anchorfile>
      <anchor>a57afac053033f78fc5e129ea497d67f8</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual const SoFieldData *</type>
      <name>getFieldData</name>
      <anchorfile>classSoAsciiText.html</anchorfile>
      <anchor>a9ff48b7ed9d9fa022a592ec05dd38750</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~SoAsciiText</name>
      <anchorfile>classSoAsciiText.html</anchorfile>
      <anchor>a1012506235aacfcd44742bc392151b6d</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>computeBBox</name>
      <anchorfile>classSoAsciiText.html</anchorfile>
      <anchor>a032afb99a96d7a09f42984bdb7a94f3f</anchor>
      <arglist>(SoAction *action, SbBox3f &amp;box, SbVec3f &amp;center)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>generatePrimitives</name>
      <anchorfile>classSoAsciiText.html</anchorfile>
      <anchor>a5946a656ae3ce21387f61c8d20de4695</anchor>
      <arglist>(SoAction *)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual SoDetail *</type>
      <name>createTriangleDetail</name>
      <anchorfile>classSoAsciiText.html</anchorfile>
      <anchor>a54d71fd1dd17941fdfc3f2cebfdaf3b5</anchor>
      <arglist>(SoRayPickAction *action, const SoPrimitiveVertex *v1, const SoPrimitiveVertex *v2, const SoPrimitiveVertex *v3, SoPickedPoint *pp)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>notify</name>
      <anchorfile>classSoAsciiText.html</anchorfile>
      <anchor>a73635e735ace0c83a8d6cc2322248154</anchor>
      <arglist>(SoNotList *list)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>SoShape</name>
      <anchorfile>classSoShape.html</anchorfile>
      <anchor>a2e0c814c0033fd77b4214bd4a5d6126d</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~SoShape</name>
      <anchorfile>classSoShape.html</anchorfile>
      <anchor>a813e5f88f7ae3fc672e5c1d28b5738dd</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>float</type>
      <name>getComplexityValue</name>
      <anchorfile>classSoShape.html</anchorfile>
      <anchor>aee602594427f297930af998787853be1</anchor>
      <arglist>(SoAction *action)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>shouldGLRender</name>
      <anchorfile>classSoShape.html</anchorfile>
      <anchor>a965388c62914e3dbc62122a2b897bd2c</anchor>
      <arglist>(SoGLRenderAction *action)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>beginSolidShape</name>
      <anchorfile>classSoShape.html</anchorfile>
      <anchor>a5b470083dbf7d24a40027f473236c199</anchor>
      <arglist>(SoGLRenderAction *action)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>endSolidShape</name>
      <anchorfile>classSoShape.html</anchorfile>
      <anchor>a200c7b885d33d9dd8dfcba0a0dd8b029</anchor>
      <arglist>(SoGLRenderAction *action)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>GLRenderBoundingBox</name>
      <anchorfile>classSoShape.html</anchorfile>
      <anchor>ab1cf8b2706e282ec22983c0f30d392eb</anchor>
      <arglist>(SoGLRenderAction *action)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>SbBool</type>
      <name>shouldPrimitiveCount</name>
      <anchorfile>classSoShape.html</anchorfile>
      <anchor>aadb029a1f8ba021db9438db79ace8b62</anchor>
      <arglist>(SoGetPrimitiveCountAction *action)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>SbBool</type>
      <name>shouldRayPick</name>
      <anchorfile>classSoShape.html</anchorfile>
      <anchor>ac0d7e0481558d69bbbf104a9df55b8a6</anchor>
      <arglist>(SoRayPickAction *const action)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>computeObjectSpaceRay</name>
      <anchorfile>classSoShape.html</anchorfile>
      <anchor>a413c3ad407a64c76ee88095daa29f353</anchor>
      <arglist>(SoRayPickAction *const action)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>computeObjectSpaceRay</name>
      <anchorfile>classSoShape.html</anchorfile>
      <anchor>a28f3a842938cb18d1b8cb173765e7387</anchor>
      <arglist>(SoRayPickAction *const action, const SbMatrix &amp;matrix)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual SoDetail *</type>
      <name>createLineSegmentDetail</name>
      <anchorfile>classSoShape.html</anchorfile>
      <anchor>a8e4d78ff576a82d6aa09b9e13d49e08f</anchor>
      <arglist>(SoRayPickAction *action, const SoPrimitiveVertex *v1, const SoPrimitiveVertex *v2, SoPickedPoint *pp)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual SoDetail *</type>
      <name>createPointDetail</name>
      <anchorfile>classSoShape.html</anchorfile>
      <anchor>a1cd96e88309e6b7e8443d16e159d31f7</anchor>
      <arglist>(SoRayPickAction *action, const SoPrimitiveVertex *v, SoPickedPoint *pp)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>invokeTriangleCallbacks</name>
      <anchorfile>classSoShape.html</anchorfile>
      <anchor>a35d5b408cab8a05de63d183b180e7fc0</anchor>
      <arglist>(SoAction *const action, const SoPrimitiveVertex *const v1, const SoPrimitiveVertex *const v2, const SoPrimitiveVertex *const v3)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>invokeLineSegmentCallbacks</name>
      <anchorfile>classSoShape.html</anchorfile>
      <anchor>a1fd152ec576882405fe393f70a0227ad</anchor>
      <arglist>(SoAction *const action, const SoPrimitiveVertex *const v1, const SoPrimitiveVertex *const v2)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>invokePointCallbacks</name>
      <anchorfile>classSoShape.html</anchorfile>
      <anchor>a19965c48b407c106cb22525fb2a30c08</anchor>
      <arglist>(SoAction *const action, const SoPrimitiveVertex *const v)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>beginShape</name>
      <anchorfile>classSoShape.html</anchorfile>
      <anchor>a29bf3cc5dc893fc6d5d7885a21c82413</anchor>
      <arglist>(SoAction *const action, const TriangleShape shapetype, SoDetail *const detail=NULL)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>shapeVertex</name>
      <anchorfile>classSoShape.html</anchorfile>
      <anchor>a1f6330ca029019e4dc80ef0b892c67f3</anchor>
      <arglist>(const SoPrimitiveVertex *const v)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>endShape</name>
      <anchorfile>classSoShape.html</anchorfile>
      <anchor>a0b29b0370b95448cbbeb06c4ce2fa889</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>generateVertex</name>
      <anchorfile>classSoShape.html</anchorfile>
      <anchor>a6a6c2103f025926c81550bce6d7689a5</anchor>
      <arglist>(SoPrimitiveVertex *const pv, const SbVec3f &amp;point, const SbBool useTexFunc, const SoMultiTextureCoordinateElement *const tce, const float s, const float t, const SbVec3f &amp;normal)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>generateVertex</name>
      <anchorfile>classSoShape.html</anchorfile>
      <anchor>aca7c9bdc209a068cbbc9ce2f70bdec87</anchor>
      <arglist>(SoPrimitiveVertex *const pv, const SbVec3f &amp;point, const SbBool useTexFunc, const SoMultiTextureCoordinateElement *const tce, const float s, const float t, const float r, const SbVec3f &amp;normal)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>SbBool</type>
      <name>startVertexArray</name>
      <anchorfile>classSoShape.html</anchorfile>
      <anchor>ae6960f1e9dfc812eb88d5109ea55b935</anchor>
      <arglist>(SoGLRenderAction *action, const SoCoordinateElement *coords, const SbVec3f *pervertexnormals, const SbBool texpervertex, const SbBool colorpervertex)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>finishVertexArray</name>
      <anchorfile>classSoShape.html</anchorfile>
      <anchor>a25bfbc335977c789643a22abd64982e7</anchor>
      <arglist>(SoGLRenderAction *action, const SbBool vbo, const SbBool normpervertex, const SbBool texpervertex, const SbBool colorpervertex)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoAudioDevice</name>
    <filename>classSoAudioDevice.html</filename>
    <member kind="function">
      <type>SbBool</type>
      <name>init</name>
      <anchorfile>classSoAudioDevice.html</anchorfile>
      <anchor>a45a8be37994dda2c4229d2b1a5cd7ac6</anchor>
      <arglist>(const SbString &amp;devicetype, const SbString &amp;devicename)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>enable</name>
      <anchorfile>classSoAudioDevice.html</anchorfile>
      <anchor>a0309d5f5df046decf3f5d4d6f340225a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>disable</name>
      <anchorfile>classSoAudioDevice.html</anchorfile>
      <anchor>aafb8608616f0832f8704755a94b93c43</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isEnabled</name>
      <anchorfile>classSoAudioDevice.html</anchorfile>
      <anchor>a41606af51e505f617a07b7dcf2f357a2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>haveSound</name>
      <anchorfile>classSoAudioDevice.html</anchorfile>
      <anchor>a57c79f296ba85c130375e05720833dfb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SoAudioDevice *</type>
      <name>instance</name>
      <anchorfile>classSoAudioDevice.html</anchorfile>
      <anchor>a0bfd99bcdbf38a42bb6d8f638f052b27</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoAudioRenderAction</name>
    <filename>classSoAudioRenderAction.html</filename>
    <base>SoAction</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classSoAudioRenderAction.html</anchorfile>
      <anchor>a8fd9cf93f3c998d6c98795a61501737b</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>addMethod</name>
      <anchorfile>classSoAudioRenderAction.html</anchorfile>
      <anchor>a41696bf9c222a3ec3835f2023b954fbc</anchor>
      <arglist>(const SoType type, SoActionMethod method)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>enableElement</name>
      <anchorfile>classSoAudioRenderAction.html</anchorfile>
      <anchor>a2ee7798c45ca224841a6514b3785657d</anchor>
      <arglist>(const SoType type, const int stackindex)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual const SoEnabledElementsList &amp;</type>
      <name>getEnabledElements</name>
      <anchorfile>classSoAudioRenderAction.html</anchorfile>
      <anchor>a142322b30e51c138cb86b01199bf0ffe</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>beginTraversal</name>
      <anchorfile>classSoAudioRenderAction.html</anchorfile>
      <anchor>a5e71df0b308b84614713774a261aafd1</anchor>
      <arglist>(SoNode *node)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoAuditorList</name>
    <filename>classSoAuditorList.html</filename>
    <base protection="private">SbPList</base>
    <member kind="function">
      <type></type>
      <name>SoAuditorList</name>
      <anchorfile>classSoAuditorList.html</anchorfile>
      <anchor>a6f992c93f093705896839da9dcec97f1</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SoAuditorList</name>
      <anchorfile>classSoAuditorList.html</anchorfile>
      <anchor>ad1393662d564c52e779a90d227b5d8c7</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSoAuditorList.html</anchorfile>
      <anchor>a3f9378c99629764bde0a6770d193d5d4</anchor>
      <arglist>(void *const auditor, const SoNotRec::Type type)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set</name>
      <anchorfile>classSoAuditorList.html</anchorfile>
      <anchor>a703cd04bd3acecab96a7d21342f0e6c7</anchor>
      <arglist>(const int index, void *const auditor, const SoNotRec::Type type)</arglist>
    </member>
    <member kind="function">
      <type>void *</type>
      <name>getObject</name>
      <anchorfile>classSoAuditorList.html</anchorfile>
      <anchor>ad51c760da2feb9032d23deee9289526e</anchor>
      <arglist>(const int index) const </arglist>
    </member>
    <member kind="function">
      <type>SoNotRec::Type</type>
      <name>getType</name>
      <anchorfile>classSoAuditorList.html</anchorfile>
      <anchor>ac6d34218032e813f79cf457e2bf5dd58</anchor>
      <arglist>(const int index) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getLength</name>
      <anchorfile>classSoAuditorList.html</anchorfile>
      <anchor>a8e34166342dcd9cca4fc715b85954898</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>find</name>
      <anchorfile>classSoAuditorList.html</anchorfile>
      <anchor>ae5685a3ed1e4b0facf7a8181cbce02b1</anchor>
      <arglist>(void *const auditor, const SoNotRec::Type type) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSoAuditorList.html</anchorfile>
      <anchor>aed76eab222da67d308b2fb012dda1517</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSoAuditorList.html</anchorfile>
      <anchor>a1c49ce1ecbbac680df0dc71f34fc96b1</anchor>
      <arglist>(void *const auditor, const SoNotRec::Type type)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>notify</name>
      <anchorfile>classSoAuditorList.html</anchorfile>
      <anchor>a1380a2cc3f2e8c73fd6c0dee02bd43fa</anchor>
      <arglist>(SoNotList *l)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoBase</name>
    <filename>classSoBase.html</filename>
    <member kind="function" virtualness="pure">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classSoBase.html</anchorfile>
      <anchor>a873b521c1386368d4d63ff893856590a</anchor>
      <arglist>(void) const =0</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>startNotify</name>
      <anchorfile>classSoBase.html</anchorfile>
      <anchor>ad8b4821e5eb780f9098d4b1a866e6a63</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>notify</name>
      <anchorfile>classSoBase.html</anchorfile>
      <anchor>a9f7fb26481bfb35d5821acfef0fc10b5</anchor>
      <arglist>(SoNotList *l)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>addWriteReference</name>
      <anchorfile>classSoBase.html</anchorfile>
      <anchor>a4dce35007a2d2f2c01e9e7200ca17327</anchor>
      <arglist>(SoOutput *out, SbBool isfromfield=FALSE)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="pure">
      <type>virtual SbBool</type>
      <name>readInstance</name>
      <anchorfile>classSoBase.html</anchorfile>
      <anchor>ab4953769f9d9dd210153228a2f096a67</anchor>
      <arglist>(SoInput *input, unsigned short flags)=0</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoBaseColor</name>
    <filename>classSoBaseColor.html</filename>
    <base>SoNode</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classSoBaseColor.html</anchorfile>
      <anchor>ad80fa1bc4c651ef768e43c68c22ecec0</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoBaseColor</name>
      <anchorfile>classSoBaseColor.html</anchorfile>
      <anchor>a9b8a2851a627e5d0f13c2bfa01b4e946</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>doAction</name>
      <anchorfile>classSoBaseColor.html</anchorfile>
      <anchor>af22bccd6d0e6a2f767a2dae0568a14cf</anchor>
      <arglist>(SoAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>GLRender</name>
      <anchorfile>classSoBaseColor.html</anchorfile>
      <anchor>a477ad8cefdafb691656898a65baf8834</anchor>
      <arglist>(SoGLRenderAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>callback</name>
      <anchorfile>classSoBaseColor.html</anchorfile>
      <anchor>a0b9ca17bd0924ad8760c89e61fb0de9a</anchor>
      <arglist>(SoCallbackAction *action)</arglist>
    </member>
    <member kind="variable">
      <type>SoMFColor</type>
      <name>rgb</name>
      <anchorfile>classSoBaseColor.html</anchorfile>
      <anchor>a72782aa59618de4c0ed7cea219036030</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual const SoFieldData *</type>
      <name>getFieldData</name>
      <anchorfile>classSoBaseColor.html</anchorfile>
      <anchor>a821fd46ddf63be25ecd42aae7fbcb49f</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~SoBaseColor</name>
      <anchorfile>classSoBaseColor.html</anchorfile>
      <anchor>a34e74578cb1987f3fe0e25e20724e763</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoBaseKit</name>
    <filename>classSoBaseKit.html</filename>
    <base>SoNode</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classSoBaseKit.html</anchorfile>
      <anchor>ae070d630e20daab3372d50b3cfb0157e</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const SoNodekitCatalog *</type>
      <name>getNodekitCatalog</name>
      <anchorfile>classSoBaseKit.html</anchorfile>
      <anchor>a550dafdf087c143cd3d2c576dba2bde0</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual const SoFieldData *</type>
      <name>getFieldData</name>
      <anchorfile>classSoBaseKit.html</anchorfile>
      <anchor>a7197aa641e06306d154ed842c8525173</anchor>
      <arglist>(void) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoBaseList</name>
    <filename>classSoBaseList.html</filename>
    <base>SbPList</base>
    <member kind="function">
      <type></type>
      <name>SoBaseList</name>
      <anchorfile>classSoBaseList.html</anchorfile>
      <anchor>a3486d0f2af4a5d21b14cad5979ebd4dd</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoBaseList</name>
      <anchorfile>classSoBaseList.html</anchorfile>
      <anchor>af1a9c4a0b40a2bd262b20024297647e1</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoBaseList</name>
      <anchorfile>classSoBaseList.html</anchorfile>
      <anchor>a667665378cab8a89ff6cd652153bea2b</anchor>
      <arglist>(const SoBaseList &amp;l)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SoBaseList</name>
      <anchorfile>classSoBaseList.html</anchorfile>
      <anchor>ae8573b49d121c4ccf9c0a9ce4a455ea4</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSoBaseList.html</anchorfile>
      <anchor>ae6ffbeb73abd30d7a93097b603d89492</anchor>
      <arglist>(SoBase *ptr)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSoBaseList.html</anchorfile>
      <anchor>ab47bf977ff1edcd838e349dac115e0ce</anchor>
      <arglist>(SoBase *ptr, const int addbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSoBaseList.html</anchorfile>
      <anchor>a3b39dc3c7de744e4f21f62070f26ad32</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeItem</name>
      <anchorfile>classSoBaseList.html</anchorfile>
      <anchor>a292f89ba8e91c0f40eac4425334273db</anchor>
      <arglist>(SoBase *item)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>truncate</name>
      <anchorfile>classSoBaseList.html</anchorfile>
      <anchor>aaa8544a32493ea5d51779b91d580a39c</anchor>
      <arglist>(const int length)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSoBaseList.html</anchorfile>
      <anchor>a160af6eac3036a7937e126c00bfafa2e</anchor>
      <arglist>(const SoBaseList &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SoBaseList &amp;</type>
      <name>operator=</name>
      <anchorfile>classSoBaseList.html</anchorfile>
      <anchor>aa065a85a57c872e79cbb69d6e9252a7b</anchor>
      <arglist>(const SoBaseList &amp;l)</arglist>
    </member>
    <member kind="function">
      <type>SoBase *</type>
      <name>operator[]</name>
      <anchorfile>classSoBaseList.html</anchorfile>
      <anchor>aceb4ba527a5c7cda7967dd480aa6ae91</anchor>
      <arglist>(const int i) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set</name>
      <anchorfile>classSoBaseList.html</anchorfile>
      <anchor>a3acf108ae68ca1e7695ed99503d4a086</anchor>
      <arglist>(const int i, SoBase *const ptr)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addReferences</name>
      <anchorfile>classSoBaseList.html</anchorfile>
      <anchor>a10a75e460fe584d961e3003793825c7f</anchor>
      <arglist>(const SbBool flag)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isReferencing</name>
      <anchorfile>classSoBaseList.html</anchorfile>
      <anchor>a9cc6538833e9e519569cdb9ecc09a6ef</anchor>
      <arglist>(void) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoBBoxModelMatrixElement</name>
    <filename>classSoBBoxModelMatrixElement.html</filename>
    <base>SoModelMatrixElement</base>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>init</name>
      <anchorfile>classSoBBoxModelMatrixElement.html</anchorfile>
      <anchor>a15eaea67077eed69f48ed81720588a52</anchor>
      <arglist>(SoState *state)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>push</name>
      <anchorfile>classSoBBoxModelMatrixElement.html</anchorfile>
      <anchor>a4adcfd22e2132c6dd8cbd3b8680c44ed</anchor>
      <arglist>(SoState *state)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>matches</name>
      <anchorfile>classSoModelMatrixElement.html</anchorfile>
      <anchor>ad6870e1218a12bea88feef88c000119b</anchor>
      <arglist>(const SoElement *element) const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void *</type>
      <name>createInstance</name>
      <anchorfile>classSoBBoxModelMatrixElement.html</anchorfile>
      <anchor>aa03c96ef8049aa22bbefdc1683fca18f</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>initClass</name>
      <anchorfile>classSoBBoxModelMatrixElement.html</anchorfile>
      <anchor>a0d3373135b35d3cef7ecf39f97c268b9</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>reset</name>
      <anchorfile>classSoBBoxModelMatrixElement.html</anchorfile>
      <anchor>a289630f7f5444278cbcf19e6ac6da5bd</anchor>
      <arglist>(SoState *const state, SoNode *const node)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>pushMatrix</name>
      <anchorfile>classSoBBoxModelMatrixElement.html</anchorfile>
      <anchor>a36dad6f78ca7ae0ee8e62967456a7077</anchor>
      <arglist>(SoState *const state, SbMatrix &amp;matrix, SbMatrix &amp;localmatrix)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>popMatrix</name>
      <anchorfile>classSoBBoxModelMatrixElement.html</anchorfile>
      <anchor>a4cf983b73f10499c278cc9778f1be484</anchor>
      <arglist>(SoState *const state, const SbMatrix &amp;matrix, const SbMatrix &amp;localmatrix)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void *</type>
      <name>createInstance</name>
      <anchorfile>classSoModelMatrixElement.html</anchorfile>
      <anchor>a50d693a5f72396e8589bad3f8d841995</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>initClass</name>
      <anchorfile>classSoModelMatrixElement.html</anchorfile>
      <anchor>a49d5dde7895ca8292d698183dd369b4b</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>makeIdentity</name>
      <anchorfile>classSoModelMatrixElement.html</anchorfile>
      <anchor>a2cc625ee1fef2e98d004e6555180621b</anchor>
      <arglist>(SoState *const state, SoNode *const node)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>set</name>
      <anchorfile>classSoModelMatrixElement.html</anchorfile>
      <anchor>a2ef3e342f32057026cb0b4fbe4555a97</anchor>
      <arglist>(SoState *const state, SoNode *const node, const SbMatrix &amp;matrix)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>setCullMatrix</name>
      <anchorfile>classSoModelMatrixElement.html</anchorfile>
      <anchor>a38e45c2cc47c23951f66ca2713ae76b0</anchor>
      <arglist>(SoState *state, SoNode *node, const SbMatrix &amp;matrix)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>mult</name>
      <anchorfile>classSoModelMatrixElement.html</anchorfile>
      <anchor>ad8d397e4c84b3850c360189d652848bd</anchor>
      <arglist>(SoState *const state, SoNode *const node, const SbMatrix &amp;matrix)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>translateBy</name>
      <anchorfile>classSoModelMatrixElement.html</anchorfile>
      <anchor>a31c41c27be76256e386a8726bccead53</anchor>
      <arglist>(SoState *const state, SoNode *const node, const SbVec3f &amp;translation)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>rotateBy</name>
      <anchorfile>classSoModelMatrixElement.html</anchorfile>
      <anchor>a73b442f437c7fcc3ed70380216bc0f9d</anchor>
      <arglist>(SoState *const state, SoNode *const node, const SbRotation &amp;rotation)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>scaleBy</name>
      <anchorfile>classSoModelMatrixElement.html</anchorfile>
      <anchor>ae502b32733b77312ac677b37885f10c4</anchor>
      <arglist>(SoState *const state, SoNode *const node, const SbVec3f &amp;scaleFactor)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SbMatrix</type>
      <name>pushMatrix</name>
      <anchorfile>classSoModelMatrixElement.html</anchorfile>
      <anchor>a19feac92a02478944e4a57949d74d7cc</anchor>
      <arglist>(SoState *const state)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>popMatrix</name>
      <anchorfile>classSoModelMatrixElement.html</anchorfile>
      <anchor>a750eaca9a6c7f8b178b916660c4ee73b</anchor>
      <arglist>(SoState *const state, const SbMatrix &amp;matrix)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const SbMatrix &amp;</type>
      <name>getCombinedCullMatrix</name>
      <anchorfile>classSoModelMatrixElement.html</anchorfile>
      <anchor>a52049c47d52229e86dd02bb59691e075</anchor>
      <arglist>(SoState *const state)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const SbMatrix &amp;</type>
      <name>get</name>
      <anchorfile>classSoModelMatrixElement.html</anchorfile>
      <anchor>a7477ff80cb3894b610d2d1c984b766fc</anchor>
      <arglist>(SoState *const state)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const SbMatrix &amp;</type>
      <name>get</name>
      <anchorfile>classSoModelMatrixElement.html</anchorfile>
      <anchor>a493f1e0912766fd0e5de828e70d575f2</anchor>
      <arglist>(SoState *const state, SbBool &amp;isIdentity)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~SoBBoxModelMatrixElement</name>
      <anchorfile>classSoBBoxModelMatrixElement.html</anchorfile>
      <anchor>a6886a6a2bdc272510da372209d75893f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>makeEltIdentity</name>
      <anchorfile>classSoBBoxModelMatrixElement.html</anchorfile>
      <anchor>a5a3b2a767924bcf2554f36f36d4dde76</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>setElt</name>
      <anchorfile>classSoBBoxModelMatrixElement.html</anchorfile>
      <anchor>af1c4c0a865546839e5025d835a36f8ce</anchor>
      <arglist>(const SbMatrix &amp;matrix)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>multElt</name>
      <anchorfile>classSoBBoxModelMatrixElement.html</anchorfile>
      <anchor>a1ccef4dcfefb3e9f85d4fdd77c2321ba</anchor>
      <arglist>(const SbMatrix &amp;matrix)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>translateEltBy</name>
      <anchorfile>classSoBBoxModelMatrixElement.html</anchorfile>
      <anchor>a5f36ee5aa3f959a9890f2d142c9c9cb5</anchor>
      <arglist>(const SbVec3f &amp;translation)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>rotateEltBy</name>
      <anchorfile>classSoBBoxModelMatrixElement.html</anchorfile>
      <anchor>a12a1db6ebeae100e2f48cc7552c8a5f7</anchor>
      <arglist>(const SbRotation &amp;translation)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>scaleEltBy</name>
      <anchorfile>classSoBBoxModelMatrixElement.html</anchorfile>
      <anchor>ad496b68f01274d470c2f5532374a1e6f</anchor>
      <arglist>(const SbVec3f &amp;scaleFactor)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual SbMatrix</type>
      <name>pushMatrixElt</name>
      <anchorfile>classSoBBoxModelMatrixElement.html</anchorfile>
      <anchor>ae353c09d60721257b873832eeb61d004</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>popMatrixElt</name>
      <anchorfile>classSoBBoxModelMatrixElement.html</anchorfile>
      <anchor>a35ddde7c21415a5fb0021032a50806dd</anchor>
      <arglist>(const SbMatrix &amp;matrix)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~SoModelMatrixElement</name>
      <anchorfile>classSoModelMatrixElement.html</anchorfile>
      <anchor>ad47f555d0e5c27ae3a3c3d17f34105cb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbMatrix</type>
      <name>modelMatrix</name>
      <anchorfile>classSoModelMatrixElement.html</anchorfile>
      <anchor>ac9878e25b31bb12dda820a087fd5bb42</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbMatrix</type>
      <name>cullMatrix</name>
      <anchorfile>classSoModelMatrixElement.html</anchorfile>
      <anchor>a5b52ccf0eb62a7167eb182b4c8250ced</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbMatrix</type>
      <name>combinedMatrix</name>
      <anchorfile>classSoModelMatrixElement.html</anchorfile>
      <anchor>a3c84684bb726967bfbdd18b80cb6c414</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>uint32_t</type>
      <name>flags</name>
      <anchorfile>classSoModelMatrixElement.html</anchorfile>
      <anchor>aa9a346dcf9615bfb89bf6a978acc5e8f</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoBlinker</name>
    <filename>classSoBlinker.html</filename>
    <base>SoSwitch</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classSoBlinker.html</anchorfile>
      <anchor>ae536b076c9ce9bc274b13e322fe30af5</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoBlinker</name>
      <anchorfile>classSoBlinker.html</anchorfile>
      <anchor>ac682f4af4b7ef19b2336a208b2302d59</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>getBoundingBox</name>
      <anchorfile>classSoBlinker.html</anchorfile>
      <anchor>a7505fbf740f65a3f76d80cdbf675aa9a</anchor>
      <arglist>(SoGetBoundingBoxAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>write</name>
      <anchorfile>classSoBlinker.html</anchorfile>
      <anchor>a98b65184d01411e6f4971f1f1bbae919</anchor>
      <arglist>(SoWriteAction *action)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoSwitch</name>
      <anchorfile>classSoSwitch.html</anchorfile>
      <anchor>ac19a2ab1b2ebb6fa536de922e92b9d6c</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoSwitch</name>
      <anchorfile>classSoSwitch.html</anchorfile>
      <anchor>affb4f0a9960cc79c27e4f4bda14b37a0</anchor>
      <arglist>(int numchildren)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>affectsState</name>
      <anchorfile>classSoSwitch.html</anchorfile>
      <anchor>a3f0061b3a32cb55405ec28f39ba094ea</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>doAction</name>
      <anchorfile>classSoSwitch.html</anchorfile>
      <anchor>a91514c3299981f6138c6a9972e34ff4c</anchor>
      <arglist>(SoAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>callback</name>
      <anchorfile>classSoSwitch.html</anchorfile>
      <anchor>a67630373f315058d8000b1986ecac8ab</anchor>
      <arglist>(SoCallbackAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>GLRender</name>
      <anchorfile>classSoSwitch.html</anchorfile>
      <anchor>a68274138ca68093e47dafdf845c7efc6</anchor>
      <arglist>(SoGLRenderAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>pick</name>
      <anchorfile>classSoSwitch.html</anchorfile>
      <anchor>aeeefee4bb66d1c809d5d831409ae087d</anchor>
      <arglist>(SoPickAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>handleEvent</name>
      <anchorfile>classSoSwitch.html</anchorfile>
      <anchor>aa60dbaffc7675e1e7c1281490db7f982</anchor>
      <arglist>(SoHandleEventAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>getMatrix</name>
      <anchorfile>classSoSwitch.html</anchorfile>
      <anchor>a11b63f0481af4a33df554d1c0a0fe233</anchor>
      <arglist>(SoGetMatrixAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>search</name>
      <anchorfile>classSoSwitch.html</anchorfile>
      <anchor>a1f54d63b548492bea3e8354aeec6f8d8</anchor>
      <arglist>(SoSearchAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>getPrimitiveCount</name>
      <anchorfile>classSoSwitch.html</anchorfile>
      <anchor>a76c5383ea5e8755929bde677a8e3b01a</anchor>
      <arglist>(SoGetPrimitiveCountAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>audioRender</name>
      <anchorfile>classSoSwitch.html</anchorfile>
      <anchor>a0d064899e143e24586b7a0f5cef4702b</anchor>
      <arglist>(SoAudioRenderAction *action)</arglist>
    </member>
    <member kind="variable">
      <type>SoSFFloat</type>
      <name>speed</name>
      <anchorfile>classSoBlinker.html</anchorfile>
      <anchor>a09afe0397af89eb72ba8056df9b48396</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoSFBool</type>
      <name>on</name>
      <anchorfile>classSoBlinker.html</anchorfile>
      <anchor>ade55994146d014b6f957d31b40f21663</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoSFInt32</type>
      <name>whichChild</name>
      <anchorfile>classSoSwitch.html</anchorfile>
      <anchor>a28c5635defb50ef668d9b9a806ec1a26</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual const SoFieldData *</type>
      <name>getFieldData</name>
      <anchorfile>classSoBlinker.html</anchorfile>
      <anchor>ae29b97867b26773058c76e539326aace</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~SoBlinker</name>
      <anchorfile>classSoBlinker.html</anchorfile>
      <anchor>aa24a0ac4542971c354447597040e640f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>notify</name>
      <anchorfile>classSoBlinker.html</anchorfile>
      <anchor>ab8a4502b4479244ab975cd213017b524</anchor>
      <arglist>(SoNotList *nl)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~SoSwitch</name>
      <anchorfile>classSoSwitch.html</anchorfile>
      <anchor>a038f47cb116132919bb1d785c5fa8b27</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>traverseChildren</name>
      <anchorfile>classSoSwitch.html</anchorfile>
      <anchor>a950b9981ab3509619bc69f1415323d99</anchor>
      <arglist>(SoAction *action)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoBoolOperation</name>
    <filename>classSoBoolOperation.html</filename>
    <base>SoEngine</base>
    <member kind="enumeration">
      <type></type>
      <name>Operation</name>
      <anchorfile>classSoBoolOperation.html</anchorfile>
      <anchor>a670d9a9ba8cbd9a70b15095993705749</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>CLEAR</name>
      <anchorfile>classSoBoolOperation.html</anchorfile>
      <anchor>a670d9a9ba8cbd9a70b15095993705749a582e5adf86d315c82c3f5762a29c8249</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SET</name>
      <anchorfile>classSoBoolOperation.html</anchorfile>
      <anchor>a670d9a9ba8cbd9a70b15095993705749ab13cf22c3851d398672653cb3e1dca8c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>A</name>
      <anchorfile>classSoBoolOperation.html</anchorfile>
      <anchor>a670d9a9ba8cbd9a70b15095993705749a1addd7ed358bd31cc77b38b4c3007286</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>NOT_A</name>
      <anchorfile>classSoBoolOperation.html</anchorfile>
      <anchor>a670d9a9ba8cbd9a70b15095993705749a89f42665a1644553d2b863efb57d9881</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>B</name>
      <anchorfile>classSoBoolOperation.html</anchorfile>
      <anchor>a670d9a9ba8cbd9a70b15095993705749a7c06cd121526ebeb2f440e3b93646e67</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>NOT_B</name>
      <anchorfile>classSoBoolOperation.html</anchorfile>
      <anchor>a670d9a9ba8cbd9a70b15095993705749a58c0b0a29d729c1a1184540cc2d5c378</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>A_OR_B</name>
      <anchorfile>classSoBoolOperation.html</anchorfile>
      <anchor>a670d9a9ba8cbd9a70b15095993705749a0c90e33a5638d3b7dd41a6658593abbe</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>NOT_A_OR_B</name>
      <anchorfile>classSoBoolOperation.html</anchorfile>
      <anchor>a670d9a9ba8cbd9a70b15095993705749af90a69b19067c8fdebc0085eff5d8cf5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>A_OR_NOT_B</name>
      <anchorfile>classSoBoolOperation.html</anchorfile>
      <anchor>a670d9a9ba8cbd9a70b15095993705749a4c9fd23af02f8a714006e3994a505976</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>NOT_A_OR_NOT_B</name>
      <anchorfile>classSoBoolOperation.html</anchorfile>
      <anchor>a670d9a9ba8cbd9a70b15095993705749a841a7ded81102a70a6415f688e280e16</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>A_AND_B</name>
      <anchorfile>classSoBoolOperation.html</anchorfile>
      <anchor>a670d9a9ba8cbd9a70b15095993705749a339d1855260c12b0f6d01cddf49af74d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>NOT_A_AND_B</name>
      <anchorfile>classSoBoolOperation.html</anchorfile>
      <anchor>a670d9a9ba8cbd9a70b15095993705749ab7e4bfb2ba8cc68722c961b914394b20</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>A_AND_NOT_B</name>
      <anchorfile>classSoBoolOperation.html</anchorfile>
      <anchor>a670d9a9ba8cbd9a70b15095993705749a5736f204ee0b7e724263cf98b9915441</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>NOT_A_AND_NOT_B</name>
      <anchorfile>classSoBoolOperation.html</anchorfile>
      <anchor>a670d9a9ba8cbd9a70b15095993705749a7a7206a8d8e6e0c8d8893d722d6a3837</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>A_EQUALS_B</name>
      <anchorfile>classSoBoolOperation.html</anchorfile>
      <anchor>a670d9a9ba8cbd9a70b15095993705749a763b56a7109154cb07fc884b365b9bb1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>A_NOT_EQUALS_B</name>
      <anchorfile>classSoBoolOperation.html</anchorfile>
      <anchor>a670d9a9ba8cbd9a70b15095993705749a4db943f963db7ce734fda495c9f7f574</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classSoBoolOperation.html</anchorfile>
      <anchor>a77191bac4d0f75b586c9e62674af4814</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const SoFieldData *</type>
      <name>getFieldData</name>
      <anchorfile>classSoBoolOperation.html</anchorfile>
      <anchor>a9120883da508d146f987b671f4b5884d</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const SoEngineOutputData *</type>
      <name>getOutputData</name>
      <anchorfile>classSoBoolOperation.html</anchorfile>
      <anchor>a02a08f4792dea2c36572bdcdacd2dd8a</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoBoolOperation</name>
      <anchorfile>classSoBoolOperation.html</anchorfile>
      <anchor>a2d63071a747ca5c813eaf95dfa5a36cb</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>evaluateWrapper</name>
      <anchorfile>classSoEngine.html</anchorfile>
      <anchor>a2af42fdbb183c7cf0f531e3cf268403f</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual int</type>
      <name>getOutputs</name>
      <anchorfile>classSoEngine.html</anchorfile>
      <anchor>a226168cb400109f7e5c36a003252534c</anchor>
      <arglist>(SoEngineOutputList &amp;l) const </arglist>
    </member>
    <member kind="function">
      <type>SoEngineOutput *</type>
      <name>getOutput</name>
      <anchorfile>classSoEngine.html</anchorfile>
      <anchor>a69d8d8a034385e261644082fb89a9675</anchor>
      <arglist>(const SbName &amp;outputname) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>getOutputName</name>
      <anchorfile>classSoEngine.html</anchorfile>
      <anchor>af2f71d234e0f79bd5618a9ed3ebaae9a</anchor>
      <arglist>(const SoEngineOutput *output, SbName &amp;outputname) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isNotifying</name>
      <anchorfile>classSoEngine.html</anchorfile>
      <anchor>a38fc62b2351f0a432b8fd8fdda36d69a</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>notify</name>
      <anchorfile>classSoEngine.html</anchorfile>
      <anchor>a109be36b28a7523d5b3942bb6c0f4bf9</anchor>
      <arglist>(SoNotList *nl)</arglist>
    </member>
    <member kind="function">
      <type>SoEngine *</type>
      <name>copy</name>
      <anchorfile>classSoEngine.html</anchorfile>
      <anchor>a83703b45c249f08aacbbab15f92b63b3</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SoFieldContainer *</type>
      <name>copyThroughConnection</name>
      <anchorfile>classSoEngine.html</anchorfile>
      <anchor>a5ffb2c0e2971ecc4496875b723a8ba5d</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>shouldCopy</name>
      <anchorfile>classSoEngine.html</anchorfile>
      <anchor>a4d2b36cd1fed10393c6efe5fe3d9e5b2</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>writeInstance</name>
      <anchorfile>classSoEngine.html</anchorfile>
      <anchor>a1bbe7bf1a626ca76a3f7b09c6a0e4df8</anchor>
      <arglist>(SoOutput *out)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>copyContents</name>
      <anchorfile>classSoFieldContainer.html</anchorfile>
      <anchor>af74b2eb05fc0ee8493c46437717e8261</anchor>
      <arglist>(const SoFieldContainer *from, SbBool copyconnections)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>initClasses</name>
      <anchorfile>classSoEngine.html</anchorfile>
      <anchor>aef6508694331d19b7dd81bb7e7b301a4</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SoEngine *</type>
      <name>getByName</name>
      <anchorfile>classSoEngine.html</anchorfile>
      <anchor>af08d59d0da056f58fd5cfe67c2c3391f</anchor>
      <arglist>(const SbName &amp;name)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static int</type>
      <name>getByName</name>
      <anchorfile>classSoEngine.html</anchorfile>
      <anchor>ab4c77b10bd95e1e9fe5a82ba968f534d</anchor>
      <arglist>(const SbName &amp;name, SoEngineList &amp;el)</arglist>
    </member>
    <member kind="variable">
      <type>SoMFBool</type>
      <name>a</name>
      <anchorfile>classSoBoolOperation.html</anchorfile>
      <anchor>a50798f4ca280a3be7e252903d5bfa373</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoMFBool</type>
      <name>b</name>
      <anchorfile>classSoBoolOperation.html</anchorfile>
      <anchor>aace01f5778ec26d120e62a2c62676a3a</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoMFEnum</type>
      <name>operation</name>
      <anchorfile>classSoBoolOperation.html</anchorfile>
      <anchor>afc11ea7282fa4026ee17d83230cf90e9</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoEngineOutput</type>
      <name>output</name>
      <anchorfile>classSoBoolOperation.html</anchorfile>
      <anchor>a1af0efc4e6e45ccba7b232f0ef89f7f3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoEngineOutput</type>
      <name>inverse</name>
      <anchorfile>classSoBoolOperation.html</anchorfile>
      <anchor>a39b853fba79fcb2fdd87973d69bd4ed9</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~SoBoolOperation</name>
      <anchorfile>classSoBoolOperation.html</anchorfile>
      <anchor>a1ca2059bbb608da2e939cf88d29ede6e</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>SoEngine</name>
      <anchorfile>classSoEngine.html</anchorfile>
      <anchor>a1ba077f0116dceeef172a5c3984887cd</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~SoEngine</name>
      <anchorfile>classSoEngine.html</anchorfile>
      <anchor>a3d404af815afb6343436bcef39a1fa7e</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>readInstance</name>
      <anchorfile>classSoEngine.html</anchorfile>
      <anchor>a946da90b09c1a79aefc9b2ca134fb3f3</anchor>
      <arglist>(SoInput *in, unsigned short flags)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>inputChanged</name>
      <anchorfile>classSoEngine.html</anchorfile>
      <anchor>af261c3acd47d3cfab447b1a0b19b583d</anchor>
      <arglist>(SoField *which)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>writeOutputTypes</name>
      <anchorfile>classSoEngine.html</anchorfile>
      <anchor>a5e9b96d9a944eb8f819dbe3331274c86</anchor>
      <arglist>(SoOutput *out)</arglist>
    </member>
    <member kind="function" protection="protected" static="yes">
      <type>static const SoFieldData **</type>
      <name>getInputDataPtr</name>
      <anchorfile>classSoEngine.html</anchorfile>
      <anchor>a05496135cd39c80a3a1bd214f37faa05</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="protected" static="yes">
      <type>static const SoEngineOutputData **</type>
      <name>getOutputDataPtr</name>
      <anchorfile>classSoEngine.html</anchorfile>
      <anchor>aebc8dc3627c56137fd9d6d27fd6a7055</anchor>
      <arglist>(void)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoBoundingBoxCache</name>
    <filename>classSoBoundingBoxCache.html</filename>
    <base>SoCache</base>
    <member kind="function">
      <type></type>
      <name>SoBoundingBoxCache</name>
      <anchorfile>classSoBoundingBoxCache.html</anchorfile>
      <anchor>a65b0d579a164758285cd0b5da54819f5</anchor>
      <arglist>(SoState *state)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~SoBoundingBoxCache</name>
      <anchorfile>classSoBoundingBoxCache.html</anchorfile>
      <anchor>af47bbd4e17ed9c84c6fc9f27c7fec11f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set</name>
      <anchorfile>classSoBoundingBoxCache.html</anchorfile>
      <anchor>ab999a86b9e2140e1bdd6a94aded4c239</anchor>
      <arglist>(const SbXfBox3f &amp;boundingbox, SbBool centerset, const SbVec3f &amp;centerpoint)</arglist>
    </member>
    <member kind="function">
      <type>const SbXfBox3f &amp;</type>
      <name>getBox</name>
      <anchorfile>classSoBoundingBoxCache.html</anchorfile>
      <anchor>a2e5df0a330b2d2688b0ceab23519feeb</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const SbBox3f &amp;</type>
      <name>getProjectedBox</name>
      <anchorfile>classSoBoundingBoxCache.html</anchorfile>
      <anchor>a8b6221f47bad7cb2631868af49218bff</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isCenterSet</name>
      <anchorfile>classSoBoundingBoxCache.html</anchorfile>
      <anchor>a3fdeccdd6ef163ecf69f7493eb54ba76</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>const SbVec3f &amp;</type>
      <name>getCenter</name>
      <anchorfile>classSoBoundingBoxCache.html</anchorfile>
      <anchor>afb7d06facbd99408692cc2791b596bce</anchor>
      <arglist>() const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>hasLinesOrPoints</name>
      <anchorfile>classSoBoundingBoxCache.html</anchorfile>
      <anchor>ad7c1903891a3234e6faae5d6e85f926c</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoCache</name>
      <anchorfile>classSoCache.html</anchorfile>
      <anchor>a545dadd5bed78d7c9ab756bb1c430b3f</anchor>
      <arglist>(SoState *const state)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>ref</name>
      <anchorfile>classSoCache.html</anchorfile>
      <anchor>a6d89e9e44ebb048684bb19af60e24215</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unref</name>
      <anchorfile>classSoCache.html</anchorfile>
      <anchor>a1d52d8862edbda098a42a2196215b0a2</anchor>
      <arglist>(SoState *state=NULL)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addElement</name>
      <anchorfile>classSoCache.html</anchorfile>
      <anchor>acbee322cd97c3779a44631d481311212</anchor>
      <arglist>(const SoElement *const elem)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>addCacheDependency</name>
      <anchorfile>classSoCache.html</anchorfile>
      <anchor>a9e6597415be84754904ddc928668ed2b</anchor>
      <arglist>(const SoState *state, SoCache *cache)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>isValid</name>
      <anchorfile>classSoCache.html</anchorfile>
      <anchor>a9a6746b710871f5acac8f406fadd5e00</anchor>
      <arglist>(const SoState *state) const </arglist>
    </member>
    <member kind="function">
      <type>const SoElement *</type>
      <name>getInvalidElement</name>
      <anchorfile>classSoCache.html</anchorfile>
      <anchor>a8668d9413ff41b5df9c3c1085271c723</anchor>
      <arglist>(const SoState *const state) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>invalidate</name>
      <anchorfile>classSoCache.html</anchorfile>
      <anchor>a6c8892faf5317b9ad1fb19e9acabd504</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>setHasLinesOrPoints</name>
      <anchorfile>classSoBoundingBoxCache.html</anchorfile>
      <anchor>a268c9a0fd7394043a612dac55c67d401</anchor>
      <arglist>(SoState *state)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>destroy</name>
      <anchorfile>classSoCache.html</anchorfile>
      <anchor>acef65de016e260bcd57ef308b3552735</anchor>
      <arglist>(SoState *state)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~SoCache</name>
      <anchorfile>classSoCache.html</anchorfile>
      <anchor>a986f9bab8a17b466a36c22eaabd17259</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoBoxHighlightRenderAction</name>
    <filename>classSoBoxHighlightRenderAction.html</filename>
    <base>SoGLRenderAction</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classSoBoxHighlightRenderAction.html</anchorfile>
      <anchor>ad44a737711a0567e39cb78a6433639d9</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoBoxHighlightRenderAction</name>
      <anchorfile>classSoBoxHighlightRenderAction.html</anchorfile>
      <anchor>a43b51164ffccc8f0d68af915d4eff43f</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoBoxHighlightRenderAction</name>
      <anchorfile>classSoBoxHighlightRenderAction.html</anchorfile>
      <anchor>aa55d617673af1bb7fbad8a158b345361</anchor>
      <arglist>(const SbViewportRegion &amp;viewportregion)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~SoBoxHighlightRenderAction</name>
      <anchorfile>classSoBoxHighlightRenderAction.html</anchorfile>
      <anchor>a0a84e1810b7dfc089c2f16862bf895e2</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>apply</name>
      <anchorfile>classSoBoxHighlightRenderAction.html</anchorfile>
      <anchor>a8c98c5bdcf5f324d857bc29b19de7766</anchor>
      <arglist>(SoNode *node)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>apply</name>
      <anchorfile>classSoBoxHighlightRenderAction.html</anchorfile>
      <anchor>a20fd76cb746235d52fc47a0219b87100</anchor>
      <arglist>(SoPath *path)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>apply</name>
      <anchorfile>classSoBoxHighlightRenderAction.html</anchorfile>
      <anchor>a6e860c6b846b518c053cbc2ee6a601c6</anchor>
      <arglist>(const SoPathList &amp;pathlist, SbBool obeysrules=FALSE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setVisible</name>
      <anchorfile>classSoBoxHighlightRenderAction.html</anchorfile>
      <anchor>acd568441f316b3752ee53ab317f1e77a</anchor>
      <arglist>(const SbBool visible)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isVisible</name>
      <anchorfile>classSoBoxHighlightRenderAction.html</anchorfile>
      <anchor>aeed036eef850528c5aca3d261695b9ec</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setColor</name>
      <anchorfile>classSoBoxHighlightRenderAction.html</anchorfile>
      <anchor>aaa369def0462c4c4d509a339817780ea</anchor>
      <arglist>(const SbColor &amp;color)</arglist>
    </member>
    <member kind="function">
      <type>const SbColor &amp;</type>
      <name>getColor</name>
      <anchorfile>classSoBoxHighlightRenderAction.html</anchorfile>
      <anchor>ae3ec6afa20d986322987c360ea8fa66c</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setLinePattern</name>
      <anchorfile>classSoBoxHighlightRenderAction.html</anchorfile>
      <anchor>a0f043a47508cef2b985ec06beb0a48b8</anchor>
      <arglist>(unsigned short pattern)</arglist>
    </member>
    <member kind="function">
      <type>unsigned short</type>
      <name>getLinePattern</name>
      <anchorfile>classSoBoxHighlightRenderAction.html</anchorfile>
      <anchor>a2b62e4331435d90724d55e8565280776</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setLineWidth</name>
      <anchorfile>classSoBoxHighlightRenderAction.html</anchorfile>
      <anchor>a0113077fd54eab84dff57aee91623b76</anchor>
      <arglist>(const float width)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getLineWidth</name>
      <anchorfile>classSoBoxHighlightRenderAction.html</anchorfile>
      <anchor>a88a45152432bc1264d84f6cc14c1cc94</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoGLRenderAction</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>a172532085adc5c2d5bc5dcc11b51577b</anchor>
      <arglist>(const SbViewportRegion &amp;viewportregion)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~SoGLRenderAction</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>afc88a624ab38cd5e0e2d37f462906e0e</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setViewportRegion</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>adc75a9c2226604ef9cb8deaadcdafe81</anchor>
      <arglist>(const SbViewportRegion &amp;newregion)</arglist>
    </member>
    <member kind="function">
      <type>const SbViewportRegion &amp;</type>
      <name>getViewportRegion</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>a0e11c2e85f92794d5c44c6a85573ade3</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setUpdateArea</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>afacefd8a75c0e97bcfb5e0ad0b86e800</anchor>
      <arglist>(const SbVec2f &amp;origin, const SbVec2f &amp;size)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getUpdateArea</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>a581f28c513031b866c3e92ddd87a9b3d</anchor>
      <arglist>(SbVec2f &amp;origin, SbVec2f &amp;size) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAbortCallback</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>abaa6b6775b84984ca68a35484d072525</anchor>
      <arglist>(SoGLRenderAbortCB *const func, void *const userdata)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getAbortCallback</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>aa8a697ab67c52d374018957297b3945d</anchor>
      <arglist>(SoGLRenderAbortCB *&amp;func_out, void *&amp;userdata_out) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTransparencyType</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>a566bc8a65b02c8220f7e2472c25bc233</anchor>
      <arglist>(const TransparencyType type)</arglist>
    </member>
    <member kind="function">
      <type>TransparencyType</type>
      <name>getTransparencyType</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>affd7c9e198d9b7d2478b30c68c2b8ef4</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTransparentDelayedObjectRenderType</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>a50c4aeaf0d9a74f6759dfaa788f302da</anchor>
      <arglist>(TransparentDelayedObjectRenderType type)</arglist>
    </member>
    <member kind="function">
      <type>TransparentDelayedObjectRenderType</type>
      <name>getTransparentDelayedObjectRenderType</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>a1a0263b278da003e6105f4031351a68b</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSmoothing</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>a4da74726ed6caf63cc94aec9a5dd70eb</anchor>
      <arglist>(const SbBool smooth)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isSmoothing</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>af8ef534cc93cd3d3dc6e15834e64cb85</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setNumPasses</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>abaef725b835c9d34db262f85ce92c860</anchor>
      <arglist>(const int num)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getNumPasses</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>a9191b685cc82431618408805ab5bde2b</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPassUpdate</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>a082c3841d340835436198e494b46f102</anchor>
      <arglist>(const SbBool flag)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isPassUpdate</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>a6fe1ecca5e793589055b3ced5c6aa297</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPassCallback</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>a041614dfb0ee1edcb1f8af1a584eb1de</anchor>
      <arglist>(SoGLRenderPassCB *const func, void *const userdata)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCacheContext</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>af6f24d1fc081580be4c02ad375635f99</anchor>
      <arglist>(const uint32_t context)</arglist>
    </member>
    <member kind="function">
      <type>uint32_t</type>
      <name>getCacheContext</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>a6e7919ad5b1d060574366220a414b9e5</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addDelayedPath</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>a0088b567ca6ec701ecab30a116426e68</anchor>
      <arglist>(SoPath *path)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isRenderingDelayedPaths</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>ab02f91427c8194851aed4f677e68c44a</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>handleTransparency</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>ad0b9db9eacd7c8bea499c3ebe68a27ca</anchor>
      <arglist>(SbBool istransparent=FALSE)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCurPass</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>a0b07a3b0378f502ec2da28460ad5cf00</anchor>
      <arglist>(const int passnum, const int numpasses)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getCurPass</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>afa8670b872d4eb17c2c32dbb5e4fe15a</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>abortNow</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>a47e743b1b44badaa40f163e8bcbccd35</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setRenderingIsRemote</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>ad2965b6bf4205683149f972bc8091537</anchor>
      <arglist>(SbBool isremote)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>getRenderingIsRemote</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>ae66a5eb37c12491f6c1bc3773dbb8d4d</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>invalidateState</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>a58a967ade8581eaf4f4b1a82c7565e47</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addPreRenderCallback</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>a52ceaef1d177334d3ba0302d491e9e7d</anchor>
      <arglist>(SoGLPreRenderCB *func, void *userdata)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removePreRenderCallback</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>a68c075ecbf3dc42e3bb4333f54d57a26</anchor>
      <arglist>(SoGLPreRenderCB *func, void *userdata)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSortedLayersNumPasses</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>a6114e3e6126cb0ed9eb66b43526960b7</anchor>
      <arglist>(int num)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getSortedLayersNumPasses</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>a7ba148eb97c57efea5c9d65e90bcba99</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setSortedObjectOrderStrategy</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>ab12ce52b2037e12dc42ca3cab295af4a</anchor>
      <arglist>(const SortedObjectOrderStrategy strategy, SoGLSortedObjectOrderCB *cb=NULL, void *closure=NULL)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setDelayedObjDepthWrite</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>aedc982d84f8bb5cd6cca4705ab53c6cb</anchor>
      <arglist>(SbBool write)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>getDelayedObjDepthWrite</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>a7054561b878107b23e8bf1d520a6756e</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isRenderingTranspPaths</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>a1b1f112bcba63ca8744a210f7f13ec53</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isRenderingTranspBackfaces</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>a55c36357d6c439f4901e34710a638ee2</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>addMethod</name>
      <anchorfile>classSoBoxHighlightRenderAction.html</anchorfile>
      <anchor>a94998a6d24637404042e4962c25bec95</anchor>
      <arglist>(const SoType type, SoActionMethod method)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>enableElement</name>
      <anchorfile>classSoBoxHighlightRenderAction.html</anchorfile>
      <anchor>a01aa20819eef7627646e404b57f85582</anchor>
      <arglist>(const SoType type, const int stackindex)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>addMethod</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>a9dafa39fdca32aa9c93f115fa470c6c8</anchor>
      <arglist>(const SoType type, SoActionMethod method)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>enableElement</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>ac1849c3c06b55087e5eab6be6db5c10a</anchor>
      <arglist>(const SoType type, const int stackindex)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual const SoEnabledElementsList &amp;</type>
      <name>getEnabledElements</name>
      <anchorfile>classSoBoxHighlightRenderAction.html</anchorfile>
      <anchor>a5959321654d95ff5b355322955b3f94f</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>beginTraversal</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>a5abd36c42d1bc03f99410bc7e75b463f</anchor>
      <arglist>(SoNode *node)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>endTraversal</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>a8f60e31488b81431d9909d390b18b649</anchor>
      <arglist>(SoNode *node)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbBool</type>
      <name>hlVisible</name>
      <anchorfile>classSoBoxHighlightRenderAction.html</anchorfile>
      <anchor>a3dab10ba7c71802379899c6dd6b8ef0b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>TransparencyType</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>ab318debd5fb749f9fcc16487522b860c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SCREEN_DOOR</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>ab318debd5fb749f9fcc16487522b860ca85b730dde06333632ba11faaa4ea6065</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>ADD</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>ab318debd5fb749f9fcc16487522b860caef8642833b3f74d1891f981d299fe402</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>DELAYED_ADD</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>ab318debd5fb749f9fcc16487522b860ca50db8d25f88f0e2b9a5cbcb3bfac652b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SORTED_OBJECT_ADD</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>ab318debd5fb749f9fcc16487522b860ca72a317c8d7011d1685533cbf92ad097f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>BLEND</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>ab318debd5fb749f9fcc16487522b860ca097026a11757fcb96ddb52e51850f244</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>DELAYED_BLEND</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>ab318debd5fb749f9fcc16487522b860cadbc8dd4b5600709df598ab300699bc26</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SORTED_OBJECT_BLEND</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>ab318debd5fb749f9fcc16487522b860ca46d3d452475893e784b18b21a2f587f2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SORTED_OBJECT_SORTED_TRIANGLE_ADD</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>ab318debd5fb749f9fcc16487522b860cac636aa256a6893c78796376f482210a4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SORTED_OBJECT_SORTED_TRIANGLE_BLEND</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>ab318debd5fb749f9fcc16487522b860ca85eeb15a9ae8ff2e08e19004f54103db</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>NONE</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>ab318debd5fb749f9fcc16487522b860ca99990d4157e3622b968773e9892b87c2</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SORTED_LAYERS_BLEND</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>ab318debd5fb749f9fcc16487522b860ca10f40549a0473dbc8692c998b41feef5</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>TransparentDelayedObjectRenderType</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>aca1a078631b10e969ddcb4a156b93863</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>ONE_PASS</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>aca1a078631b10e969ddcb4a156b93863a9c36bc5510e0673aac2d2cd8105b824b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>NONSOLID_SEPARATE_BACKFACE_PASS</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>aca1a078631b10e969ddcb4a156b93863aee00f0cc1104f13934bc9fc793ea63cd</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>AbortCode</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>a016763ba5e313424f2450aa41693e8f6</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>CONTINUE</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>a016763ba5e313424f2450aa41693e8f6ac45fb1cc909525052e4b7b5e4e534e2b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>ABORT</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>a016763ba5e313424f2450aa41693e8f6afc27fe42f07f195a259be7c8e4613b6e</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>PRUNE</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>a016763ba5e313424f2450aa41693e8f6a4817d1d831b24cf068da57e4c9214917</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>DELAY</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>a016763ba5e313424f2450aa41693e8f6abbd4e7ce1b7626971c354527309f9f29</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>SortedObjectOrderStrategy</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>af673acee2953f6f6701e38c21e2f9ee0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>BBOX_CENTER</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>af673acee2953f6f6701e38c21e2f9ee0afde6c04bf7846497133f1a26fa4e4d43</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>BBOX_CLOSEST_CORNER</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>af673acee2953f6f6701e38c21e2f9ee0a21a0ba46b74cac56cfae3ccabc0c0c96</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>BBOX_FARTHEST_CORNER</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>af673acee2953f6f6701e38c21e2f9ee0a72d3e8ea4615b927a3391b4b8d339d67</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>CUSTOM_CALLBACK</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>af673acee2953f6f6701e38c21e2f9ee0a9ab2d71ae6738a554f1f16d48125cc44</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>AbortCode</type>
      <name>SoGLRenderAbortCB</name>
      <anchorfile>classSoGLRenderAction.html</anchorfile>
      <anchor>ae38cb7794e7fe3de95ebe385a1e00f04</anchor>
      <arglist>(void *userdata)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoBumpMap</name>
    <filename>classSoBumpMap.html</filename>
    <base>SoNode</base>
    <member kind="enumeration">
      <type></type>
      <name>Wrap</name>
      <anchorfile>classSoBumpMap.html</anchorfile>
      <anchor>ac7c4517f5b783c57d980b9f5659cc11f</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>REPEAT</name>
      <anchorfile>classSoBumpMap.html</anchorfile>
      <anchor>ac7c4517f5b783c57d980b9f5659cc11fa37bf0078be854152a579099da00d6b1b</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>CLAMP</name>
      <anchorfile>classSoBumpMap.html</anchorfile>
      <anchor>ac7c4517f5b783c57d980b9f5659cc11fa07d5d1434c4d069e24820210f0d7ea83</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classSoBumpMap.html</anchorfile>
      <anchor>a29d112c550ba0d47bdca9fce2530fab5</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoBumpMap</name>
      <anchorfile>classSoBumpMap.html</anchorfile>
      <anchor>a7cc603594f50682e382fbbd39cf7e22f</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>doAction</name>
      <anchorfile>classSoBumpMap.html</anchorfile>
      <anchor>aaaf6f373d4bb1dc95a95fc0ef601e053</anchor>
      <arglist>(SoAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>GLRender</name>
      <anchorfile>classSoBumpMap.html</anchorfile>
      <anchor>ae1908738776ef66a68671934eca72de2</anchor>
      <arglist>(SoGLRenderAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>callback</name>
      <anchorfile>classSoBumpMap.html</anchorfile>
      <anchor>adaa9a06912111adea2ae64564fecc775</anchor>
      <arglist>(SoCallbackAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>rayPick</name>
      <anchorfile>classSoBumpMap.html</anchorfile>
      <anchor>aa2d9a039d55f151de92b44adef6aed8d</anchor>
      <arglist>(SoRayPickAction *action)</arglist>
    </member>
    <member kind="variable">
      <type>SoSFString</type>
      <name>filename</name>
      <anchorfile>classSoBumpMap.html</anchorfile>
      <anchor>a90c6e969bfc52a34b372e2c894bdb3b5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoSFImage</type>
      <name>image</name>
      <anchorfile>classSoBumpMap.html</anchorfile>
      <anchor>a460193dbe316259055d284aa82870d98</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoSFEnum</type>
      <name>wrapS</name>
      <anchorfile>classSoBumpMap.html</anchorfile>
      <anchor>a33875776f1a75f61716277dcead04e84</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoSFEnum</type>
      <name>wrapT</name>
      <anchorfile>classSoBumpMap.html</anchorfile>
      <anchor>abb66a0d5d7be23ca6a81b33dd89066b7</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual const SoFieldData *</type>
      <name>getFieldData</name>
      <anchorfile>classSoBumpMap.html</anchorfile>
      <anchor>ae27a1a74e760c6224252018ba5cced13</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~SoBumpMap</name>
      <anchorfile>classSoBumpMap.html</anchorfile>
      <anchor>a5b38dd9da523facf13e8d7a9f33915cc</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>readInstance</name>
      <anchorfile>classSoBumpMap.html</anchorfile>
      <anchor>aa67d4cbc2e27109b5fc5bf13fe93f191</anchor>
      <arglist>(SoInput *in, unsigned short flags)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>notify</name>
      <anchorfile>classSoBumpMap.html</anchorfile>
      <anchor>afa642140ca8ca825bfa34cea5dd52834</anchor>
      <arglist>(SoNotList *list)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoBumpMapCoordinate</name>
    <filename>classSoBumpMapCoordinate.html</filename>
    <base>SoNode</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classSoBumpMapCoordinate.html</anchorfile>
      <anchor>abe81b3c23ca6fb2c436f53a049dcee6d</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoBumpMapCoordinate</name>
      <anchorfile>classSoBumpMapCoordinate.html</anchorfile>
      <anchor>ad06c128b19de777306b6456dc2df54a0</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>doAction</name>
      <anchorfile>classSoBumpMapCoordinate.html</anchorfile>
      <anchor>a3ddb991756531c6f01623596b2cb39e8</anchor>
      <arglist>(SoAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>GLRender</name>
      <anchorfile>classSoBumpMapCoordinate.html</anchorfile>
      <anchor>a5be99d247606409f7fac2c493e1ce6eb</anchor>
      <arglist>(SoGLRenderAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>callback</name>
      <anchorfile>classSoBumpMapCoordinate.html</anchorfile>
      <anchor>a24b72d0fc8cd2f2322f2a931db48f60a</anchor>
      <arglist>(SoCallbackAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>pick</name>
      <anchorfile>classSoBumpMapCoordinate.html</anchorfile>
      <anchor>ae5d73d9ec6d668ccafe487ecf09da5d7</anchor>
      <arglist>(SoPickAction *action)</arglist>
    </member>
    <member kind="variable">
      <type>SoMFVec2f</type>
      <name>point</name>
      <anchorfile>classSoBumpMapCoordinate.html</anchorfile>
      <anchor>a39ff5189d691e9722a8f011782bacee0</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual const SoFieldData *</type>
      <name>getFieldData</name>
      <anchorfile>classSoBumpMapCoordinate.html</anchorfile>
      <anchor>ad88d368502e1787651e0aeacb4e760bc</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~SoBumpMapCoordinate</name>
      <anchorfile>classSoBumpMapCoordinate.html</anchorfile>
      <anchor>a9f8005df016515ab8fac4c3281de0a30</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoBumpMapCoordinateElement</name>
    <filename>classSoBumpMapCoordinateElement.html</filename>
    <base>SoReplacedElement</base>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>init</name>
      <anchorfile>classSoBumpMapCoordinateElement.html</anchorfile>
      <anchor>add7b6c34153ef7b7959df359da76a65f</anchor>
      <arglist>(SoState *state)</arglist>
    </member>
    <member kind="function">
      <type>int32_t</type>
      <name>getNum</name>
      <anchorfile>classSoBumpMapCoordinateElement.html</anchorfile>
      <anchor>a592d14e489a4f6f995dd1c111c9e6a84</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>const SbVec2f &amp;</type>
      <name>get</name>
      <anchorfile>classSoBumpMapCoordinateElement.html</anchorfile>
      <anchor>abc557eae166a96d9d75bd06577d81d46</anchor>
      <arglist>(const int index) const </arglist>
    </member>
    <member kind="function">
      <type>const SbVec2f *</type>
      <name>getArrayPtr</name>
      <anchorfile>classSoBumpMapCoordinateElement.html</anchorfile>
      <anchor>ac33fd5493bb2bcb3f46c050d2bfbc516</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void *</type>
      <name>createInstance</name>
      <anchorfile>classSoBumpMapCoordinateElement.html</anchorfile>
      <anchor>ab135722666836a43f3c5b8d81fb6969d</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>initClass</name>
      <anchorfile>classSoBumpMapCoordinateElement.html</anchorfile>
      <anchor>a89f42b05c0e2b5630a42ceb3538a74db</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>set</name>
      <anchorfile>classSoBumpMapCoordinateElement.html</anchorfile>
      <anchor>acf4a5c23a36f257b0a6f09ab9024666f</anchor>
      <arglist>(SoState *state, SoNode *node, const int32_t numcoords, const SbVec2f *coords)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const SoBumpMapCoordinateElement *</type>
      <name>getInstance</name>
      <anchorfile>classSoBumpMapCoordinateElement.html</anchorfile>
      <anchor>af2895bf773de4a999eafbd5ab172380a</anchor>
      <arglist>(SoState *state)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~SoBumpMapCoordinateElement</name>
      <anchorfile>classSoBumpMapCoordinateElement.html</anchorfile>
      <anchor>ac6b9d4348ebe96c0b79cf1d8ea8b3032</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int32_t</type>
      <name>numcoords</name>
      <anchorfile>classSoBumpMapCoordinateElement.html</anchorfile>
      <anchor>acd8751154cc0c66da9e069ee42e63afe</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>const SbVec2f *</type>
      <name>coords</name>
      <anchorfile>classSoBumpMapCoordinateElement.html</anchorfile>
      <anchor>ad5c80105a941dbccbfb14a9853d80f9b</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoBumpMapElement</name>
    <filename>classSoBumpMapElement.html</filename>
    <base>SoReplacedElement</base>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>init</name>
      <anchorfile>classSoBumpMapElement.html</anchorfile>
      <anchor>a3c203c3ae5b0d348ee04304ed34a4c8a</anchor>
      <arglist>(SoState *state)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void *</type>
      <name>createInstance</name>
      <anchorfile>classSoBumpMapElement.html</anchorfile>
      <anchor>abebd9d7996adf47f1220dfbd7c3231bb</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>initClass</name>
      <anchorfile>classSoBumpMapElement.html</anchorfile>
      <anchor>a2790850d0e35493a21f416773290ec6c</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>set</name>
      <anchorfile>classSoBumpMapElement.html</anchorfile>
      <anchor>aee155ed0ff0569d1279511d32c66555b</anchor>
      <arglist>(SoState *state, SoNode *node, SoGLImage *image)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SoGLImage *</type>
      <name>get</name>
      <anchorfile>classSoBumpMapElement.html</anchorfile>
      <anchor>a1ffd7a7e4037cc81566c33b259470057</anchor>
      <arglist>(SoState *const state)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~SoBumpMapElement</name>
      <anchorfile>classSoBumpMapElement.html</anchorfile>
      <anchor>a24245a1827ce87649eca3587a6840124</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>setElt</name>
      <anchorfile>classSoBumpMapElement.html</anchorfile>
      <anchor>a4ebfa2548f3378b46b20b62bd4f239a9</anchor>
      <arglist>(SoGLImage *image)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoBumpMapMatrixElement</name>
    <filename>classSoBumpMapMatrixElement.html</filename>
    <base>SoAccumulatedElement</base>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>init</name>
      <anchorfile>classSoBumpMapMatrixElement.html</anchorfile>
      <anchor>aa293b1111c3a3e5d1692fa0051a15e3c</anchor>
      <arglist>(SoState *state)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>push</name>
      <anchorfile>classSoBumpMapMatrixElement.html</anchorfile>
      <anchor>a057803ba1966960103cda3da624182cb</anchor>
      <arglist>(SoState *state)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void *</type>
      <name>createInstance</name>
      <anchorfile>classSoBumpMapMatrixElement.html</anchorfile>
      <anchor>a164a1a78f5139798c9289423c5eac79f</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>makeIdentity</name>
      <anchorfile>classSoBumpMapMatrixElement.html</anchorfile>
      <anchor>a7db862cef59b6c71a02376325231ab1b</anchor>
      <arglist>(SoState *const state, SoNode *const node)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>set</name>
      <anchorfile>classSoBumpMapMatrixElement.html</anchorfile>
      <anchor>acf3df2266d4e39574adea21ac3e03392</anchor>
      <arglist>(SoState *const state, SoNode *const node, const SbMatrix &amp;matrix)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>mult</name>
      <anchorfile>classSoBumpMapMatrixElement.html</anchorfile>
      <anchor>a7b6220d48fd1a73929a34df2d9f02e35</anchor>
      <arglist>(SoState *const state, SoNode *const node, const SbMatrix &amp;matrix)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>translateBy</name>
      <anchorfile>classSoBumpMapMatrixElement.html</anchorfile>
      <anchor>ae3e9b8b99cf15bac328c624d91706133</anchor>
      <arglist>(SoState *const state, SoNode *const node, const SbVec3f &amp;translation)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>rotateBy</name>
      <anchorfile>classSoBumpMapMatrixElement.html</anchorfile>
      <anchor>a930a3d97def85ff42bbeb90e0f70b7f3</anchor>
      <arglist>(SoState *const state, SoNode *const node, const SbRotation &amp;rotation)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>scaleBy</name>
      <anchorfile>classSoBumpMapMatrixElement.html</anchorfile>
      <anchor>af26726f0d403d2cf22af70568492dbd1</anchor>
      <arglist>(SoState *const state, SoNode *const node, const SbVec3f &amp;scaleFactor)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const SbMatrix &amp;</type>
      <name>get</name>
      <anchorfile>classSoBumpMapMatrixElement.html</anchorfile>
      <anchor>af4f7b9d1cede3667b4938b155db8b60f</anchor>
      <arglist>(SoState *const state)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~SoBumpMapMatrixElement</name>
      <anchorfile>classSoBumpMapMatrixElement.html</anchorfile>
      <anchor>ab638b2fda49cc1c6eae1cfab8573709c</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>makeEltIdentity</name>
      <anchorfile>classSoBumpMapMatrixElement.html</anchorfile>
      <anchor>a3b554b7c461b2290309760d29a8458d1</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>setElt</name>
      <anchorfile>classSoBumpMapMatrixElement.html</anchorfile>
      <anchor>ab3ad70a396eb808612267e06baa323b3</anchor>
      <arglist>(const SbMatrix &amp;matrix)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>multElt</name>
      <anchorfile>classSoBumpMapMatrixElement.html</anchorfile>
      <anchor>a5ecd67021d618048bab3f7b133e2efae</anchor>
      <arglist>(const SbMatrix &amp;matrix)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>translateEltBy</name>
      <anchorfile>classSoBumpMapMatrixElement.html</anchorfile>
      <anchor>a5f43105192d70120959997618e815995</anchor>
      <arglist>(const SbVec3f &amp;translation)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>rotateEltBy</name>
      <anchorfile>classSoBumpMapMatrixElement.html</anchorfile>
      <anchor>afaecd63e866c58535ff8fbff8ddcba4d</anchor>
      <arglist>(const SbRotation &amp;rotation)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>scaleEltBy</name>
      <anchorfile>classSoBumpMapMatrixElement.html</anchorfile>
      <anchor>a6985bb7500b0f39d4f9409fe505c55ba</anchor>
      <arglist>(const SbVec3f &amp;scaleFactor)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual const SbMatrix &amp;</type>
      <name>getElt</name>
      <anchorfile>classSoBumpMapMatrixElement.html</anchorfile>
      <anchor>a16d5a1f505fd5de233e7adb500bfa612</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbMatrix</type>
      <name>bumpMapMatrix</name>
      <anchorfile>classSoBumpMapMatrixElement.html</anchorfile>
      <anchor>a6ac358709c40e101e099f4f31636d436</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoBumpMapTransform</name>
    <filename>classSoBumpMapTransform.html</filename>
    <base>SoNode</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classSoBumpMapTransform.html</anchorfile>
      <anchor>a6dd8ab4f265cdf233fb9aa7124b8a6ac</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoBumpMapTransform</name>
      <anchorfile>classSoBumpMapTransform.html</anchorfile>
      <anchor>a771e729e1eb58ddc56062c81b05ade9a</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>doAction</name>
      <anchorfile>classSoBumpMapTransform.html</anchorfile>
      <anchor>a9fe9a1b39e141b8e1e0bdff919efbbfc</anchor>
      <arglist>(SoAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>callback</name>
      <anchorfile>classSoBumpMapTransform.html</anchorfile>
      <anchor>a6662c5840cbe1c247885af08af184f3f</anchor>
      <arglist>(SoCallbackAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>GLRender</name>
      <anchorfile>classSoBumpMapTransform.html</anchorfile>
      <anchor>a961ed16d6fbf74c20e80eb4b7164c322</anchor>
      <arglist>(SoGLRenderAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>getMatrix</name>
      <anchorfile>classSoBumpMapTransform.html</anchorfile>
      <anchor>a99c714e951829289995e3a4ea4cb5fbd</anchor>
      <arglist>(SoGetMatrixAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>pick</name>
      <anchorfile>classSoBumpMapTransform.html</anchorfile>
      <anchor>aabbef89b062b2dab4a780cf68c8cb33e</anchor>
      <arglist>(SoPickAction *action)</arglist>
    </member>
    <member kind="variable">
      <type>SoSFVec2f</type>
      <name>translation</name>
      <anchorfile>classSoBumpMapTransform.html</anchorfile>
      <anchor>ad45a8a96e6b336aae105dc25a004cb50</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoSFFloat</type>
      <name>rotation</name>
      <anchorfile>classSoBumpMapTransform.html</anchorfile>
      <anchor>a38a5995aa1f5a0bc57fca57d892ea1fa</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoSFVec2f</type>
      <name>scaleFactor</name>
      <anchorfile>classSoBumpMapTransform.html</anchorfile>
      <anchor>a59bff48325057f2091158509bb17b8b0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoSFVec2f</type>
      <name>center</name>
      <anchorfile>classSoBumpMapTransform.html</anchorfile>
      <anchor>add296c3848291aeec17005077b52856f</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual const SoFieldData *</type>
      <name>getFieldData</name>
      <anchorfile>classSoBumpMapTransform.html</anchorfile>
      <anchor>a70354346f863edeff08b37d373bedcdc</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~SoBumpMapTransform</name>
      <anchorfile>classSoBumpMapTransform.html</anchorfile>
      <anchor>a4d79967e2bc55c6dd3eae8684fda07ed</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoBundle</name>
    <filename>classSoBundle.html</filename>
    <member kind="function" protection="protected">
      <type></type>
      <name>SoBundle</name>
      <anchorfile>classSoBundle.html</anchorfile>
      <anchor>ab28d88df773d84fca7c598416725ef9b</anchor>
      <arglist>(SoAction *action)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>~SoBundle</name>
      <anchorfile>classSoBundle.html</anchorfile>
      <anchor>a7041a50265d70d61451ac271ebe7f291</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SoState *</type>
      <name>state</name>
      <anchorfile>classSoBundle.html</anchorfile>
      <anchor>af1885d6a2c51dd01d6bbb338c9cf0118</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoButtonEvent</name>
    <filename>classSoButtonEvent.html</filename>
    <base>SoEvent</base>
    <member kind="enumeration">
      <type></type>
      <name>State</name>
      <anchorfile>classSoButtonEvent.html</anchorfile>
      <anchor>a3d1c79afafa1a7bcea5008ee132923b3</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UP</name>
      <anchorfile>classSoButtonEvent.html</anchorfile>
      <anchor>a3d1c79afafa1a7bcea5008ee132923b3aca2b62447e336e0c5439f3ad4853fa63</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>DOWN</name>
      <anchorfile>classSoButtonEvent.html</anchorfile>
      <anchor>a3d1c79afafa1a7bcea5008ee132923b3ae9d7559498d47e935b79d43759fc3dbb</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>UNKNOWN</name>
      <anchorfile>classSoButtonEvent.html</anchorfile>
      <anchor>a3d1c79afafa1a7bcea5008ee132923b3a7f05040166601a1551c7dc11d48369e0</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classSoButtonEvent.html</anchorfile>
      <anchor>a40002d1c016bd24cae1b23fb55d5a36a</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoButtonEvent</name>
      <anchorfile>classSoButtonEvent.html</anchorfile>
      <anchor>ac38b34ea72bf9fff5b48cd805093e801</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~SoButtonEvent</name>
      <anchorfile>classSoButtonEvent.html</anchorfile>
      <anchor>ac4f44f6cde4311ff95e5ff515415e623</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setState</name>
      <anchorfile>classSoButtonEvent.html</anchorfile>
      <anchor>a1a0ddb89d141d2944c726749e4eeac23</anchor>
      <arglist>(State state)</arglist>
    </member>
    <member kind="function">
      <type>State</type>
      <name>getState</name>
      <anchorfile>classSoButtonEvent.html</anchorfile>
      <anchor>a8abeb16d105a4b2535ce350cd11c349e</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoEvent</name>
      <anchorfile>classSoEvent.html</anchorfile>
      <anchor>ae9ac18892cee75c2a163dbfeadcd7395</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~SoEvent</name>
      <anchorfile>classSoEvent.html</anchorfile>
      <anchor>ab1e0f6c4d7385d07a72550723025c25e</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isOfType</name>
      <anchorfile>classSoEvent.html</anchorfile>
      <anchor>a90af490dc5f9658009893611447dfb9f</anchor>
      <arglist>(SoType type) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTime</name>
      <anchorfile>classSoEvent.html</anchorfile>
      <anchor>a995b16f7948b24bcfac15ca1d50cd2a3</anchor>
      <arglist>(const SbTime t)</arglist>
    </member>
    <member kind="function">
      <type>SbTime</type>
      <name>getTime</name>
      <anchorfile>classSoEvent.html</anchorfile>
      <anchor>a1580fa84798542f8c43884f1affe5984</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPosition</name>
      <anchorfile>classSoEvent.html</anchorfile>
      <anchor>a849416b6d6bf7f844f6ac36b2eeb9a30</anchor>
      <arglist>(const SbVec2s &amp;p)</arglist>
    </member>
    <member kind="function">
      <type>const SbVec2s &amp;</type>
      <name>getPosition</name>
      <anchorfile>classSoEvent.html</anchorfile>
      <anchor>ac70e545b18850b5053cccd2814ad31a1</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>const SbVec2s</type>
      <name>getPosition</name>
      <anchorfile>classSoEvent.html</anchorfile>
      <anchor>a9a90056b0e35ee3b3841c793098d1348</anchor>
      <arglist>(const SbViewportRegion &amp;vpRgn) const </arglist>
    </member>
    <member kind="function">
      <type>const SbVec2f</type>
      <name>getNormalizedPosition</name>
      <anchorfile>classSoEvent.html</anchorfile>
      <anchor>ac4e0475125a5c27625717020de187079</anchor>
      <arglist>(const SbViewportRegion &amp;vpRgn) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setShiftDown</name>
      <anchorfile>classSoEvent.html</anchorfile>
      <anchor>aa17052cc953fa3693e14d597d36f3793</anchor>
      <arglist>(SbBool isDown)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>wasShiftDown</name>
      <anchorfile>classSoEvent.html</anchorfile>
      <anchor>a02dd3f8f59a7f32b2052918c4138647c</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCtrlDown</name>
      <anchorfile>classSoEvent.html</anchorfile>
      <anchor>a737a56e86521b7d535ee9ed536d45638</anchor>
      <arglist>(SbBool isDown)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>wasCtrlDown</name>
      <anchorfile>classSoEvent.html</anchorfile>
      <anchor>a3c95b2d28519cc1647231ba177c3d923</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setAltDown</name>
      <anchorfile>classSoEvent.html</anchorfile>
      <anchor>a64089d0de8c4dd7ba544af64fb24d53d</anchor>
      <arglist>(SbBool isDown)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>wasAltDown</name>
      <anchorfile>classSoEvent.html</anchorfile>
      <anchor>a1583e93498f88c6fc92969ccc5b69d87</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>initClass</name>
      <anchorfile>classSoButtonEvent.html</anchorfile>
      <anchor>a9e3ee8610f57b1c1ff9c8250a1f7c8d7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SbBool</type>
      <name>enumToString</name>
      <anchorfile>classSoButtonEvent.html</anchorfile>
      <anchor>a7af3185c4b852bbb1a91d7476c1c3508</anchor>
      <arglist>(State enumval, SbString &amp;stringrep)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SoType</type>
      <name>getClassTypeId</name>
      <anchorfile>classSoEvent.html</anchorfile>
      <anchor>a745a76593ca05c87c625b6a4c9aef5ce</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>initClass</name>
      <anchorfile>classSoEvent.html</anchorfile>
      <anchor>aaf846d32f74e0843edf78114ec243cee</anchor>
      <arglist>(void)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoCache</name>
    <filename>classSoCache.html</filename>
  </compound>
  <compound kind="class">
    <name>SoCacheElement</name>
    <filename>classSoCacheElement.html</filename>
    <base>SoElement</base>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>init</name>
      <anchorfile>classSoCacheElement.html</anchorfile>
      <anchor>af8cd18c33e04c16857946dfdfd5767d5</anchor>
      <arglist>(SoState *state)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>push</name>
      <anchorfile>classSoCacheElement.html</anchorfile>
      <anchor>ace78012f17d24c7e0c9e048075b64079</anchor>
      <arglist>(SoState *state)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>pop</name>
      <anchorfile>classSoCacheElement.html</anchorfile>
      <anchor>a20be082ad1782056c80fbff5626200d5</anchor>
      <arglist>(SoState *state, const SoElement *prevTopElement)</arglist>
    </member>
    <member kind="function">
      <type>SoCache *</type>
      <name>getCache</name>
      <anchorfile>classSoCacheElement.html</anchorfile>
      <anchor>aaaec4bbef15ac9143591412c9dbd8e01</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>matches</name>
      <anchorfile>classSoCacheElement.html</anchorfile>
      <anchor>a52bf764661c857b1dcdf4ebbb285a086</anchor>
      <arglist>(const SoElement *element) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SoElement *</type>
      <name>copyMatchInfo</name>
      <anchorfile>classSoCacheElement.html</anchorfile>
      <anchor>ad069b063c0fbc029190eb8e6b82b710d</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SoCacheElement *</type>
      <name>getNextCacheElement</name>
      <anchorfile>classSoCacheElement.html</anchorfile>
      <anchor>a6dcb7cbdaba1037a964b0079b049fe3e</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void *</type>
      <name>createInstance</name>
      <anchorfile>classSoCacheElement.html</anchorfile>
      <anchor>aa813698879092429afd9a53bb79330e4</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>set</name>
      <anchorfile>classSoCacheElement.html</anchorfile>
      <anchor>aeed0ab875e5b0685a35f52f0e4a9e8ab</anchor>
      <arglist>(SoState *const state, SoCache *const cache)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SbBool</type>
      <name>anyOpen</name>
      <anchorfile>classSoCacheElement.html</anchorfile>
      <anchor>a12076d2a83de20e3262c6ec745665143</anchor>
      <arglist>(SoState *const state)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>invalidate</name>
      <anchorfile>classSoCacheElement.html</anchorfile>
      <anchor>ae5bb362708736eee685119d0601970e6</anchor>
      <arglist>(SoState *const state)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>addElement</name>
      <anchorfile>classSoCacheElement.html</anchorfile>
      <anchor>a109f8c7854a4c38159c5ae3aed236f8b</anchor>
      <arglist>(SoState *const state, const SoElement *const element)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>addCacheDependency</name>
      <anchorfile>classSoCacheElement.html</anchorfile>
      <anchor>a8135dd12474afadc05c5706417f81ede</anchor>
      <arglist>(SoState *const state, SoCache *const cache)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SbBool</type>
      <name>setInvalid</name>
      <anchorfile>classSoCacheElement.html</anchorfile>
      <anchor>a6082e45336953d996d9f5738d908a9fd</anchor>
      <arglist>(const SbBool newvalue)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SoCache *</type>
      <name>getCurrentCache</name>
      <anchorfile>classSoCacheElement.html</anchorfile>
      <anchor>a50d59658976f8d8a505227cb3d3b5d9c</anchor>
      <arglist>(SoState *const state)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~SoCacheElement</name>
      <anchorfile>classSoCacheElement.html</anchorfile>
      <anchor>ab44e537adf722def23c94a9767029776</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoCacheHint</name>
    <filename>classSoCacheHint.html</filename>
    <base>SoNode</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classSoCacheHint.html</anchorfile>
      <anchor>ae6643d391026717ce1e9deac8c7c631a</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoCacheHint</name>
      <anchorfile>classSoCacheHint.html</anchorfile>
      <anchor>a8271e5aed2599c41abd9f5a45e677d49</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>doAction</name>
      <anchorfile>classSoCacheHint.html</anchorfile>
      <anchor>a66ea9ebe1342630dfff12d64eeca2535</anchor>
      <arglist>(SoAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>GLRender</name>
      <anchorfile>classSoCacheHint.html</anchorfile>
      <anchor>a82a9805bf7e670dcb2517fd817a96f3a</anchor>
      <arglist>(SoGLRenderAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>callback</name>
      <anchorfile>classSoCacheHint.html</anchorfile>
      <anchor>a4582500c20ef5aa1e7ba7b5a2a390f8c</anchor>
      <arglist>(SoCallbackAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>getBoundingBox</name>
      <anchorfile>classSoCacheHint.html</anchorfile>
      <anchor>aed5ebefcb5a17fc2d47412df597a8f57</anchor>
      <arglist>(SoGetBoundingBoxAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>pick</name>
      <anchorfile>classSoCacheHint.html</anchorfile>
      <anchor>a31bd0bce8cc1cdc37cd0b6eb820b7a3a</anchor>
      <arglist>(SoPickAction *action)</arglist>
    </member>
    <member kind="variable">
      <type>SoSFFloat</type>
      <name>memValue</name>
      <anchorfile>classSoCacheHint.html</anchorfile>
      <anchor>a541f79f8019800658ee399899d051d58</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoSFFloat</type>
      <name>gfxValue</name>
      <anchorfile>classSoCacheHint.html</anchorfile>
      <anchor>a404368e5578ee9b8ff01ae211eb631b0</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual const SoFieldData *</type>
      <name>getFieldData</name>
      <anchorfile>classSoCacheHint.html</anchorfile>
      <anchor>aa715e8dacc0b374df33575622460dc4c</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~SoCacheHint</name>
      <anchorfile>classSoCacheHint.html</anchorfile>
      <anchor>a5b27dc46ce3c31341ce11a43be7d6484</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoCalculator</name>
    <filename>classSoCalculator.html</filename>
    <base>SoEngine</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classSoCalculator.html</anchorfile>
      <anchor>a09d1a28f1bdc440b5db9f41d31008c11</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const SoFieldData *</type>
      <name>getFieldData</name>
      <anchorfile>classSoCalculator.html</anchorfile>
      <anchor>a0aa0bbeb9fdcd68b67bc502241022f8b</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const SoEngineOutputData *</type>
      <name>getOutputData</name>
      <anchorfile>classSoCalculator.html</anchorfile>
      <anchor>a487a13f63137689b1b3cde71db0908cc</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoCalculator</name>
      <anchorfile>classSoCalculator.html</anchorfile>
      <anchor>a792ba9073ca014317ada73bee9c97183</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="variable">
      <type>SoMFFloat</type>
      <name>a</name>
      <anchorfile>classSoCalculator.html</anchorfile>
      <anchor>a8334a05f1d4ad8a76233ab1227613c26</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoMFFloat</type>
      <name>b</name>
      <anchorfile>classSoCalculator.html</anchorfile>
      <anchor>ab8dcece3f0627bc900f37455726ceb0b</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoMFFloat</type>
      <name>c</name>
      <anchorfile>classSoCalculator.html</anchorfile>
      <anchor>a5320d1f469afc91138d57bd08aa8498c</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoMFFloat</type>
      <name>d</name>
      <anchorfile>classSoCalculator.html</anchorfile>
      <anchor>ad06a1196f4dcb1031691439cd222edc2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoMFFloat</type>
      <name>e</name>
      <anchorfile>classSoCalculator.html</anchorfile>
      <anchor>afdc2df292e3699506ac21beb4d34a8d8</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoMFFloat</type>
      <name>f</name>
      <anchorfile>classSoCalculator.html</anchorfile>
      <anchor>aa47315dc25780b728d6bda6819dffa16</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoMFFloat</type>
      <name>g</name>
      <anchorfile>classSoCalculator.html</anchorfile>
      <anchor>a402abec5696b8ab6098a4996d428de5f</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoMFFloat</type>
      <name>h</name>
      <anchorfile>classSoCalculator.html</anchorfile>
      <anchor>acc6bd0bcaf1ab8c1744a0a41c0340c1e</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoMFVec3f</type>
      <name>A</name>
      <anchorfile>classSoCalculator.html</anchorfile>
      <anchor>a78b6958e185647f1efcf8dc37a39b461</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoMFVec3f</type>
      <name>B</name>
      <anchorfile>classSoCalculator.html</anchorfile>
      <anchor>ac275feac67d7994c577cc056da4afc99</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoMFVec3f</type>
      <name>C</name>
      <anchorfile>classSoCalculator.html</anchorfile>
      <anchor>a389621e579a69e8333b42542b14c6ce7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoMFVec3f</type>
      <name>D</name>
      <anchorfile>classSoCalculator.html</anchorfile>
      <anchor>aa4835d39b560519b4411dc82e04dd108</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoMFVec3f</type>
      <name>E</name>
      <anchorfile>classSoCalculator.html</anchorfile>
      <anchor>a28491e70e17ab85cd83c672b09c72896</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoMFVec3f</type>
      <name>F</name>
      <anchorfile>classSoCalculator.html</anchorfile>
      <anchor>a670956d1280443971d637a6d4fb0ec6c</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoMFVec3f</type>
      <name>G</name>
      <anchorfile>classSoCalculator.html</anchorfile>
      <anchor>a4e10c288d19f6753905a9a6ea6e36797</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoMFVec3f</type>
      <name>H</name>
      <anchorfile>classSoCalculator.html</anchorfile>
      <anchor>a43899d76776d5b34f50f26adc60c8027</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoMFString</type>
      <name>expression</name>
      <anchorfile>classSoCalculator.html</anchorfile>
      <anchor>a7cfb2b420f077abf4726ada17be26e0e</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoEngineOutput</type>
      <name>oa</name>
      <anchorfile>classSoCalculator.html</anchorfile>
      <anchor>ad0b4e58a658ee51d1a1857b6ec5118a1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoEngineOutput</type>
      <name>ob</name>
      <anchorfile>classSoCalculator.html</anchorfile>
      <anchor>ad3b448b93813d089c095b58480e1c0ad</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoEngineOutput</type>
      <name>oc</name>
      <anchorfile>classSoCalculator.html</anchorfile>
      <anchor>adf922a722a33ed51f13f9ea9747e7a20</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoEngineOutput</type>
      <name>od</name>
      <anchorfile>classSoCalculator.html</anchorfile>
      <anchor>afbfa34f10b51a3a41096c1ffe74d6cf4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoEngineOutput</type>
      <name>oA</name>
      <anchorfile>classSoCalculator.html</anchorfile>
      <anchor>a6b200d36871a6093f5eca0b8b81f4842</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoEngineOutput</type>
      <name>oB</name>
      <anchorfile>classSoCalculator.html</anchorfile>
      <anchor>ac5e01d8c507dea3b037b1f81f42f6560</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoEngineOutput</type>
      <name>oC</name>
      <anchorfile>classSoCalculator.html</anchorfile>
      <anchor>a5788e010ccd9647bbdb1cde3200e8a26</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoEngineOutput</type>
      <name>oD</name>
      <anchorfile>classSoCalculator.html</anchorfile>
      <anchor>aeef28bf98cb865de73164bc417aec4f4</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~SoCalculator</name>
      <anchorfile>classSoCalculator.html</anchorfile>
      <anchor>af16d5b5c1dc3be31edd581d4eeae3aa6</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>inputChanged</name>
      <anchorfile>classSoCalculator.html</anchorfile>
      <anchor>a43e3022159bc59a24931b01b625ac226</anchor>
      <arglist>(SoField *which)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoCallback</name>
    <filename>classSoCallback.html</filename>
    <base>SoNode</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classSoCallback.html</anchorfile>
      <anchor>a84587f85b568c37bad29cac35cc838f6</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoCallback</name>
      <anchorfile>classSoCallback.html</anchorfile>
      <anchor>af1e3717dfd82737b6f1d864748857130</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCallback</name>
      <anchorfile>classSoCallback.html</anchorfile>
      <anchor>a7a8f2dc97c80d06895f313fa8095a830</anchor>
      <arglist>(SoCallbackCB *function, void *userdata=NULL)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>doAction</name>
      <anchorfile>classSoCallback.html</anchorfile>
      <anchor>adf55248b1f7143dc6d2dcc31111b45b0</anchor>
      <arglist>(SoAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>callback</name>
      <anchorfile>classSoCallback.html</anchorfile>
      <anchor>ada7436c6fa43de30e8e6455ba73976e1</anchor>
      <arglist>(SoCallbackAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>GLRender</name>
      <anchorfile>classSoCallback.html</anchorfile>
      <anchor>aa798e7241f78846396ca35d49f149b4e</anchor>
      <arglist>(SoGLRenderAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>getBoundingBox</name>
      <anchorfile>classSoCallback.html</anchorfile>
      <anchor>a62c7151753420cbc003acc63496449aa</anchor>
      <arglist>(SoGetBoundingBoxAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>getMatrix</name>
      <anchorfile>classSoCallback.html</anchorfile>
      <anchor>ac1824b7b11b5b2f260e97ef60dea3f5b</anchor>
      <arglist>(SoGetMatrixAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>handleEvent</name>
      <anchorfile>classSoCallback.html</anchorfile>
      <anchor>ae69baac6f29f0d94429fe6253ffca0c0</anchor>
      <arglist>(SoHandleEventAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>pick</name>
      <anchorfile>classSoCallback.html</anchorfile>
      <anchor>a22c8477f100e3f4f3efb90a494dfa9bb</anchor>
      <arglist>(SoPickAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>search</name>
      <anchorfile>classSoCallback.html</anchorfile>
      <anchor>a26d33623e4a355bce4fd46b3316f4b92</anchor>
      <arglist>(SoSearchAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>write</name>
      <anchorfile>classSoCallback.html</anchorfile>
      <anchor>a0ffbc601aef9287e1d6f87f1230c41b6</anchor>
      <arglist>(SoWriteAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>getPrimitiveCount</name>
      <anchorfile>classSoCallback.html</anchorfile>
      <anchor>ac2ff7785721bf7dd5850981547a45260</anchor>
      <arglist>(SoGetPrimitiveCountAction *action)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual const SoFieldData *</type>
      <name>getFieldData</name>
      <anchorfile>classSoCallback.html</anchorfile>
      <anchor>a6994652394fe420ef8719507950f315c</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~SoCallback</name>
      <anchorfile>classSoCallback.html</anchorfile>
      <anchor>ae7b6450e33376133968b8b07cb83c614</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>copyContents</name>
      <anchorfile>classSoCallback.html</anchorfile>
      <anchor>a339f6aee8c6f1386bc3bb3cee46dc086</anchor>
      <arglist>(const SoFieldContainer *from, SbBool copyconnections)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoCallbackAction</name>
    <filename>classSoCallbackAction.html</filename>
    <base>SoAction</base>
    <member kind="enumeration">
      <type></type>
      <name>Response</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>a0aebf2c58836079af765be8e2ba4973d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>CONTINUE</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>a0aebf2c58836079af765be8e2ba4973da0d938b2f29d1633097595c14d4cd87cc</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>ABORT</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>a0aebf2c58836079af765be8e2ba4973daf47cac7f924fcfd67b6ce7b710caf8b4</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>PRUNE</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>a0aebf2c58836079af765be8e2ba4973da8848d4ddd907d87c7336c119cf8d5cee</anchor>
      <arglist></arglist>
    </member>
    <member kind="typedef">
      <type>Response</type>
      <name>SoCallbackActionCB</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>ae6fdf843f4157cbc3ff98c5d711e9de7</anchor>
      <arglist>(void *userdata, SoCallbackAction *action, const SoNode *node)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>a4147d651e563a9ae9fd08ad2395e1cfe</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoCallbackAction</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>ad7da5f0d08e5c9b37df8ffdaf87631fe</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoCallbackAction</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>a2b50588d8902f28efa53ca0b5b8e0191</anchor>
      <arglist>(const SbViewportRegion &amp;vp)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~SoCallbackAction</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>a0c4030b6813d7ed75647656eabda5607</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setViewportRegion</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>a13fd51ff971b2c2ddddd49537202e8a1</anchor>
      <arglist>(const SbViewportRegion &amp;vp)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addPreCallback</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>abb911a2b72f56a19d0dd40819e7d351f</anchor>
      <arglist>(const SoType type, SoCallbackActionCB *cb, void *userdata)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addPostCallback</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>ad98c249636448c4947947e2faf7de570</anchor>
      <arglist>(const SoType type, SoCallbackActionCB *cb, void *userdata)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addPreTailCallback</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>aa4eaa1f93b4ea5514b4253ff738a3c90</anchor>
      <arglist>(SoCallbackActionCB *cb, void *userdata)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addPostTailCallback</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>ae85004e2f61a0f75465fc19001bb38bb</anchor>
      <arglist>(SoCallbackActionCB *cb, void *userdata)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addTriangleCallback</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>a7a71315cb4b24a5cd83dbbdbfc0d2a3e</anchor>
      <arglist>(const SoType type, SoTriangleCB *cb, void *userdata)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addLineSegmentCallback</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>ae12e0c958fa491e15fed955af19788b8</anchor>
      <arglist>(const SoType type, SoLineSegmentCB *cb, void *userdata)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addPointCallback</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>ab8ac10a541dbe2e65e6a0dd64a1aec6b</anchor>
      <arglist>(const SoType type, SoPointCB *cb, void *userdata)</arglist>
    </member>
    <member kind="function">
      <type>SoDecimationTypeElement::Type</type>
      <name>getDecimationType</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>a6ca5e51faefd2275f8b11f917f3b30f6</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getDecimationPercentage</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>a3be9dcc5feb21c6b85311f3264c21ee0</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getComplexity</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>accb844489a863930369c88d8cb20d834</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SoComplexity::Type</type>
      <name>getComplexityType</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>a51912ef09f5b593bf53ad507e291e546</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>int32_t</type>
      <name>getNumCoordinates</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>a0f4f484d1ea566f2dbd20018e57248a8</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>const SbVec3f &amp;</type>
      <name>getCoordinate3</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>a8a39bfbf7635e0d9b197c035442f3172</anchor>
      <arglist>(const int index) const </arglist>
    </member>
    <member kind="function">
      <type>const SbVec4f &amp;</type>
      <name>getCoordinate4</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>a6a9c98c830d27ff7a738eb8881beed4b</anchor>
      <arglist>(const int index) const </arglist>
    </member>
    <member kind="function">
      <type>SoDrawStyle::Style</type>
      <name>getDrawStyle</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>a393b8dd8676ab668a4f3bbbd6074e35e</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>unsigned short</type>
      <name>getLinePattern</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>a99e6c72fc29b6e80c478938422ef55aa</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getLineWidth</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>aaad9afbb2e101db088dd9dc1023f4f48</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getPointSize</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>a0c7db492edf17022a34d79d19561b1af</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>const SbName &amp;</type>
      <name>getFontName</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>a86f8f698339a65df8bb55c455bc60453</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getFontSize</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>a6cdaa2b59d78811ed6b481645673097e</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SoLightModel::Model</type>
      <name>getLightModel</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>af2a271cfa3ddf13566e08962291fca10</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>const SbVec3f &amp;</type>
      <name>getLightAttenuation</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>a1169cad45b91391be63ef26ac433dc2b</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getMaterial</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>a8eb5c30c849bf3c54a7cf574082db6e8</anchor>
      <arglist>(SbColor &amp;ambient, SbColor &amp;diffuse, SbColor &amp;specular, SbColor &amp;emission, float &amp;shininess, float &amp;transparency, const int index=0) const </arglist>
    </member>
    <member kind="function">
      <type>SoMaterialBinding::Binding</type>
      <name>getMaterialBinding</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>a470470892e78a3d964b1df465d65ddb3</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>uint32_t</type>
      <name>getNumNormals</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>ac65b1d41b61672ced9e81b86de86933f</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>const SbVec3f &amp;</type>
      <name>getNormal</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>a16ee3746295ce69c287bf864748b2a03</anchor>
      <arglist>(const int index) const </arglist>
    </member>
    <member kind="function">
      <type>SoNormalBinding::Binding</type>
      <name>getNormalBinding</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>a49ab7d79d0fc4a6d25711caded6cd241</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>int32_t</type>
      <name>getNumProfileCoordinates</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>adce6af2840cdfecc3e24ced46126a948</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>const SbVec2f &amp;</type>
      <name>getProfileCoordinate2</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>add48b7bb9f9fec04a8a5f9bf8f03d459</anchor>
      <arglist>(const int index) const </arglist>
    </member>
    <member kind="function">
      <type>const SbVec3f &amp;</type>
      <name>getProfileCoordinate3</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>a42d4853b5026d34a2dbcd8d83b3fd2b7</anchor>
      <arglist>(const int index) const </arglist>
    </member>
    <member kind="function">
      <type>const SoNodeList &amp;</type>
      <name>getProfile</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>ac798cc8b045de3361b1a21b8b1dc16e0</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SoShapeHints::VertexOrdering</type>
      <name>getVertexOrdering</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>a5ba17eb4452bb70dbe03a836661f2266</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SoShapeHints::ShapeType</type>
      <name>getShapeType</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>ad8bc47df507393b4863aaf0c520cf364</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SoShapeHints::FaceType</type>
      <name>getFaceType</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>a6ea068d16af4fdee95555e4d79562990</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getCreaseAngle</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>ac7976c69f158ad96223f3c447690c596</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>int32_t</type>
      <name>getNumTextureCoordinates</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>aba6c6ec6dc89872fa72c42be4a08f4e5</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>const SbVec2f &amp;</type>
      <name>getTextureCoordinate2</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>ac545ae2032fbf711af1c364b39838a43</anchor>
      <arglist>(const int index) const </arglist>
    </member>
    <member kind="function">
      <type>const SbVec3f &amp;</type>
      <name>getTextureCoordinate3</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>a20734400b70a0c83a6df5ddd1cef95ba</anchor>
      <arglist>(const int index) const </arglist>
    </member>
    <member kind="function">
      <type>const SbVec4f &amp;</type>
      <name>getTextureCoordinate4</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>a6f47244d3d882f942e2884bc8cdcf6fc</anchor>
      <arglist>(const int index) const </arglist>
    </member>
    <member kind="function">
      <type>SoTextureCoordinateBinding::Binding</type>
      <name>getTextureCoordinateBinding</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>aab53bce467ef67246504a5de9abe35c7</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>const SbColor &amp;</type>
      <name>getTextureBlendColor</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>ac404646053d303d8dcc866ed25a3c892</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>const unsigned char *</type>
      <name>getTextureImage</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>ac551dec60b98285e88e8744ab34d4820</anchor>
      <arglist>(SbVec2s &amp;size, int &amp;numcomps) const </arglist>
    </member>
    <member kind="function">
      <type>const unsigned char *</type>
      <name>getTextureImage</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>a1ed671f594d20a608dccf47f00ec19c2</anchor>
      <arglist>(SbVec3s &amp;size, int &amp;numcomps) const </arglist>
    </member>
    <member kind="function">
      <type>const SbMatrix &amp;</type>
      <name>getTextureMatrix</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>a7ed6e8dfe4046afca3a2bba9099769ab</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SoTexture2::Model</type>
      <name>getTextureModel</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>a0968c3970c63246cd10c11d3d3d25a2c</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SoTexture2::Wrap</type>
      <name>getTextureWrapS</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>a380b20fb9139f2acdcaccd0d7709f5cd</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SoTexture2::Wrap</type>
      <name>getTextureWrapT</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>a2870fb696ac5abbf0eb734e37579de1e</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SoTexture2::Wrap</type>
      <name>getTextureWrapR</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>a2c5feb85d89c2669a2520421387417f5</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>const SbMatrix &amp;</type>
      <name>getModelMatrix</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>aabdad873751e3c73e1798c7c3f3411fa</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SoUnits::Units</type>
      <name>getUnits</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>a8d14ba3252e977a558cda71598133671</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getFocalDistance</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>a3bd6f1ad6e1d2fa2bd9fdd53b6202cfb</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>const SbMatrix &amp;</type>
      <name>getProjectionMatrix</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>ab20b90ab8a3b6e073b336f193e633b82</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>const SbMatrix &amp;</type>
      <name>getViewingMatrix</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>a076a40c5e60e62b75f23ef47bbe2a170</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>const SbViewVolume &amp;</type>
      <name>getViewVolume</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>a10bcfe2c754f6802ae1a099ad8b595e3</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>const SbViewportRegion &amp;</type>
      <name>getViewportRegion</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>a930eec066ea2d2ded4d1eca62ecb1290</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SoPickStyle::Style</type>
      <name>getPickStyle</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>a3daa267b5b0c462ea2fe41a61ec26b17</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>int32_t</type>
      <name>getSwitch</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>aaf9b8f52666ca3c0ccfd6572bd6cda49</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>Response</type>
      <name>getCurrentResponse</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>a4f9efd32750fa5eb4d01cfca636f6bf1</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>invokePreCallbacks</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>ade92a80d2c2ebc22f0ca871f2296fc35</anchor>
      <arglist>(const SoNode *const node)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>invokePostCallbacks</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>a55e55017fe21f07be7191054850e4214</anchor>
      <arglist>(const SoNode *const node)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>invokeTriangleCallbacks</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>ad162287962a03211d167f248166878d2</anchor>
      <arglist>(const SoShape *const shape, const SoPrimitiveVertex *const v1, const SoPrimitiveVertex *const v2, const SoPrimitiveVertex *const v3)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>invokeLineSegmentCallbacks</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>ac8793751f83619ca3318c8dd48e9de5f</anchor>
      <arglist>(const SoShape *const shape, const SoPrimitiveVertex *const v1, const SoPrimitiveVertex *const v2)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>invokePointCallbacks</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>afe7c4ff2165b9475bd28f7ac654d47e9</anchor>
      <arglist>(const SoShape *const shape, const SoPrimitiveVertex *const v)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>shouldGeneratePrimitives</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>a06ce97cd16478fc8f4ca4b8f6bfbcfb8</anchor>
      <arglist>(const SoShape *shape) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SoNode *</type>
      <name>getCurPathTail</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>a638952a8cd942fde3065ce043fef50c2</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setCurrentNode</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>aaea936b682da09a8df2ae87a5edba03f</anchor>
      <arglist>(SoNode *const node)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>addMethod</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>a918fb4200f40611c516ab03a7fd2b4ba</anchor>
      <arglist>(const SoType type, SoActionMethod method)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>enableElement</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>afa5867c40c10cfe78a38267ee8aae254</anchor>
      <arglist>(const SoType type, const int stackindex)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual const SoEnabledElementsList &amp;</type>
      <name>getEnabledElements</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>a0c5687a290a4c5bd5402f9c6e0791b66</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>beginTraversal</name>
      <anchorfile>classSoCallbackAction.html</anchorfile>
      <anchor>a20de90ba2439c6f83e350d2bab64e4d4</anchor>
      <arglist>(SoNode *node)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoCallbackList</name>
    <filename>classSoCallbackList.html</filename>
    <member kind="function">
      <type></type>
      <name>SoCallbackList</name>
      <anchorfile>classSoCallbackList.html</anchorfile>
      <anchor>accb308b0e556f22f4c3d7e5ae0a66a86</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SoCallbackList</name>
      <anchorfile>classSoCallbackList.html</anchorfile>
      <anchor>a75c30a6495ff8014147c02974039725a</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addCallback</name>
      <anchorfile>classSoCallbackList.html</anchorfile>
      <anchor>a090abfa5f4fce2518249261a66ae3e6d</anchor>
      <arglist>(SoCallbackListCB *f, void *userData=NULL)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeCallback</name>
      <anchorfile>classSoCallbackList.html</anchorfile>
      <anchor>aec35f7d7aeadcdf4d557574e865fc0f6</anchor>
      <arglist>(SoCallbackListCB *f, void *userdata=NULL)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>clearCallbacks</name>
      <anchorfile>classSoCallbackList.html</anchorfile>
      <anchor>a4a0226868b1669e3ebf432142c09d5e5</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getNumCallbacks</name>
      <anchorfile>classSoCallbackList.html</anchorfile>
      <anchor>a942e1a2506aa23e0c0c9b74ce8c693af</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>invokeCallbacks</name>
      <anchorfile>classSoCallbackList.html</anchorfile>
      <anchor>a1a310491a27b615e968e84eb484368f4</anchor>
      <arglist>(void *callbackdata)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoCamera</name>
    <filename>classSoCamera.html</filename>
    <base>SoNode</base>
    <member kind="enumeration">
      <type></type>
      <name>ViewportMapping</name>
      <anchorfile>classSoCamera.html</anchorfile>
      <anchor>a46fd7a2f6e8ca20e44682d005e0bb44c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>StereoMode</name>
      <anchorfile>classSoCamera.html</anchorfile>
      <anchor>ae1516a54c7328d42694db1c5b62912ec</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>MONOSCOPIC</name>
      <anchorfile>classSoCamera.html</anchorfile>
      <anchor>ae1516a54c7328d42694db1c5b62912ecac0ec11eb92040c20ae1b0ade59672849</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>LEFT_VIEW</name>
      <anchorfile>classSoCamera.html</anchorfile>
      <anchor>ae1516a54c7328d42694db1c5b62912eca4570af92101f1849e922b8b00a796752</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>RIGHT_VIEW</name>
      <anchorfile>classSoCamera.html</anchorfile>
      <anchor>ae1516a54c7328d42694db1c5b62912eca1bcb572494c5a757d7978b082357da77</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classSoCamera.html</anchorfile>
      <anchor>ad6a7f8c956fcc53225d0c90015ef28d3</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SbViewVolume</type>
      <name>getViewVolume</name>
      <anchorfile>classSoCamera.html</anchorfile>
      <anchor>af452319dd477054863b45f012c2fde68</anchor>
      <arglist>(const SbViewportRegion &amp;vp, SbViewportRegion &amp;resultvp, const SbMatrix &amp;mm=SbMatrix::identity()) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pointAt</name>
      <anchorfile>classSoCamera.html</anchorfile>
      <anchor>a0419569e203a18c84870f288d79af31d</anchor>
      <arglist>(const SbVec3f &amp;targetpoint)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pointAt</name>
      <anchorfile>classSoCamera.html</anchorfile>
      <anchor>adac554b0c5d8ea465f539d704834f651</anchor>
      <arglist>(const SbVec3f &amp;targetpoint, const SbVec3f &amp;upvector)</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>scaleHeight</name>
      <anchorfile>classSoCamera.html</anchorfile>
      <anchor>a2a860095b69cc575ba845d4e228956f3</anchor>
      <arglist>(float scalefactor)=0</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual SbViewVolume</type>
      <name>getViewVolume</name>
      <anchorfile>classSoCamera.html</anchorfile>
      <anchor>a9dabd51ab0445cdca516180df63a6fee</anchor>
      <arglist>(float useaspectratio=0.0f) const =0</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>viewAll</name>
      <anchorfile>classSoCamera.html</anchorfile>
      <anchor>af04cc1f085e997c65832da9ddcd5a6aa</anchor>
      <arglist>(SoNode *const sceneroot, const SbViewportRegion &amp;vpregion, const float slack=1.0f)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>viewAll</name>
      <anchorfile>classSoCamera.html</anchorfile>
      <anchor>ab10a2218561a9c6e82910cb6ded50118</anchor>
      <arglist>(SoPath *const path, const SbViewportRegion &amp;vpregion, const float slack=1.0f)</arglist>
    </member>
    <member kind="function">
      <type>SbViewportRegion</type>
      <name>getViewportBounds</name>
      <anchorfile>classSoCamera.html</anchorfile>
      <anchor>aa3e6738f99a7d5e7f5b7420a8515d669</anchor>
      <arglist>(const SbViewportRegion &amp;region) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setStereoMode</name>
      <anchorfile>classSoCamera.html</anchorfile>
      <anchor>a22e40f356f2ff2055b2a4b0f65c3aea6</anchor>
      <arglist>(StereoMode mode)</arglist>
    </member>
    <member kind="function">
      <type>StereoMode</type>
      <name>getStereoMode</name>
      <anchorfile>classSoCamera.html</anchorfile>
      <anchor>a83754e152b2f65542e6c06428b779dd2</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setStereoAdjustment</name>
      <anchorfile>classSoCamera.html</anchorfile>
      <anchor>a6ed2d2527604e86cc8be234b1e429991</anchor>
      <arglist>(float adjustment)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getStereoAdjustment</name>
      <anchorfile>classSoCamera.html</anchorfile>
      <anchor>aee529c67134126a1fd9e8bad918e1680</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setBalanceAdjustment</name>
      <anchorfile>classSoCamera.html</anchorfile>
      <anchor>a8d44d94fa463088b2ddfedff2ea72364</anchor>
      <arglist>(float adjustment)</arglist>
    </member>
    <member kind="function">
      <type>float</type>
      <name>getBalanceAdjustment</name>
      <anchorfile>classSoCamera.html</anchorfile>
      <anchor>ad92d00e82e26432a45679183a343fcc8</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>doAction</name>
      <anchorfile>classSoCamera.html</anchorfile>
      <anchor>a413c4165d5065112db4c27687d9a58bf</anchor>
      <arglist>(SoAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>callback</name>
      <anchorfile>classSoCamera.html</anchorfile>
      <anchor>a7a55d20de9f29df22645ea8eab07bd9f</anchor>
      <arglist>(SoCallbackAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>GLRender</name>
      <anchorfile>classSoCamera.html</anchorfile>
      <anchor>a0e43b194b29f65bf2ffc97b29de634f2</anchor>
      <arglist>(SoGLRenderAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>audioRender</name>
      <anchorfile>classSoCamera.html</anchorfile>
      <anchor>a826bfd39750a3c7300c9c0162eb04688</anchor>
      <arglist>(SoAudioRenderAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>getBoundingBox</name>
      <anchorfile>classSoCamera.html</anchorfile>
      <anchor>a4731c977a5d5ef3848071509af281f6b</anchor>
      <arglist>(SoGetBoundingBoxAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>handleEvent</name>
      <anchorfile>classSoCamera.html</anchorfile>
      <anchor>a40dec90ae09d74656b04fb5bc170d4f0</anchor>
      <arglist>(SoHandleEventAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>rayPick</name>
      <anchorfile>classSoCamera.html</anchorfile>
      <anchor>af1b340a2532c40eebcb6386ba226d782</anchor>
      <arglist>(SoRayPickAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>getPrimitiveCount</name>
      <anchorfile>classSoCamera.html</anchorfile>
      <anchor>a70260457d32bb6d8d0a7734b248f55b4</anchor>
      <arglist>(SoGetPrimitiveCountAction *action)</arglist>
    </member>
    <member kind="function" virtualness="pure">
      <type>virtual void</type>
      <name>viewBoundingBox</name>
      <anchorfile>classSoCamera.html</anchorfile>
      <anchor>ab04c2ed686b698bee525eaf29aca0f64</anchor>
      <arglist>(const SbBox3f &amp;box, float aspect, float slack)=0</arglist>
    </member>
    <member kind="variable">
      <type>SoSFEnum</type>
      <name>viewportMapping</name>
      <anchorfile>classSoCamera.html</anchorfile>
      <anchor>abc6c62bbca8a24dd686a3fbb19adec2b</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoSFVec3f</type>
      <name>position</name>
      <anchorfile>classSoCamera.html</anchorfile>
      <anchor>a1346f4606c4fd282818b4b7701bfeca9</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoSFRotation</type>
      <name>orientation</name>
      <anchorfile>classSoCamera.html</anchorfile>
      <anchor>a1e0dc74890db39d4c8ec2194ec7ab4a7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoSFFloat</type>
      <name>aspectRatio</name>
      <anchorfile>classSoCamera.html</anchorfile>
      <anchor>a377ac1c352e965864712bcc5ad0459df</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoSFFloat</type>
      <name>nearDistance</name>
      <anchorfile>classSoCamera.html</anchorfile>
      <anchor>a96b1bd10731d0a5b8addf3368a8ba53a</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoSFFloat</type>
      <name>farDistance</name>
      <anchorfile>classSoCamera.html</anchorfile>
      <anchor>a34890d0e76849f4ce27beefae287f471</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoSFFloat</type>
      <name>focalDistance</name>
      <anchorfile>classSoCamera.html</anchorfile>
      <anchor>a59fda50eb01e55536d3a603f6590fd2c</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual const SoFieldData *</type>
      <name>getFieldData</name>
      <anchorfile>classSoCamera.html</anchorfile>
      <anchor>a08e0214079cfc559cf85c260d5d74511</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>SoCamera</name>
      <anchorfile>classSoCamera.html</anchorfile>
      <anchor>afe2aa3972f415c77eb0a61eb8a2ed0ce</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~SoCamera</name>
      <anchorfile>classSoCamera.html</anchorfile>
      <anchor>a1d8a58f827233bab4fe735b786ef986f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>jitter</name>
      <anchorfile>classSoCamera.html</anchorfile>
      <anchor>a7d06e8321c4f7fe394ceee5fc7866f11</anchor>
      <arglist>(int numpasses, int curpass, const SbViewportRegion &amp;vpreg, SbVec3f &amp;jitteramount) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoCameraKit</name>
    <filename>classSoCameraKit.html</filename>
    <base>SoBaseKit</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classSoCameraKit.html</anchorfile>
      <anchor>a8cc7be82416dcf7b3b281f2a0541f8a6</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const SoNodekitCatalog *</type>
      <name>getNodekitCatalog</name>
      <anchorfile>classSoCameraKit.html</anchorfile>
      <anchor>a048151f31acf60bfce15e2cfa7ab45f7</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoCameraKit</name>
      <anchorfile>classSoCameraKit.html</anchorfile>
      <anchor>a0a910b4788271ab679a209e2177a6c2f</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual const SoFieldData *</type>
      <name>getFieldData</name>
      <anchorfile>classSoCameraKit.html</anchorfile>
      <anchor>a17c3a2f6bf6a613fa8b079e30212531f</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~SoCameraKit</name>
      <anchorfile>classSoCameraKit.html</anchorfile>
      <anchor>a6a4a768d36e3c28a0502b8cbb3738d33</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoCenterballDragger</name>
    <filename>classSoCenterballDragger.html</filename>
    <base>SoDragger</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classSoCenterballDragger.html</anchorfile>
      <anchor>adea2b24256c50a299b17b5f7ee1897a8</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const SoNodekitCatalog *</type>
      <name>getNodekitCatalog</name>
      <anchorfile>classSoCenterballDragger.html</anchorfile>
      <anchor>aa0e42f2ef998596e3f007efab5c267a9</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoCenterballDragger</name>
      <anchorfile>classSoCenterballDragger.html</anchorfile>
      <anchor>ae20ff9682e8b592413299eacfaab0b33</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>saveStartParameters</name>
      <anchorfile>classSoCenterballDragger.html</anchorfile>
      <anchor>a934f32e493beaca4ad9a4902d8cb7a75</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>callback</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>a0849979a0ac2a1668aafb79454450eb8</anchor>
      <arglist>(SoCallbackAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>GLRender</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>ac7b6197387c2f6afbab953810c53df84</anchor>
      <arglist>(SoGLRenderAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>rayPick</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>a5223be55ff1d7e5782f734cb5523a6c9</anchor>
      <arglist>(SoRayPickAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>search</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>ac0b672a2e282c740c31c9ad9d8b8caa2</anchor>
      <arglist>(SoSearchAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>write</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>ae165ab1af26004fb2c44d0928fa1be25</anchor>
      <arglist>(SoWriteAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>getPrimitiveCount</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>a223837de2231bbd3df15fecd1ce5900a</anchor>
      <arglist>(SoGetPrimitiveCountAction *action)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setProjectorEpsilon</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>ab3ffef1deec5922c65168876c6edf460</anchor>
      <arglist>(const float epsilon)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addStartCallback</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>a8b2d2084710f60e615420d7b6787bbc2</anchor>
      <arglist>(SoDraggerCB *func, void *data=NULL)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeStartCallback</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>ae00e9e57f085a8f76aa16a5b6e0b1230</anchor>
      <arglist>(SoDraggerCB *func, void *data=NULL)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addMotionCallback</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>ac0517769322f58ec7c845d7e3e4a404d</anchor>
      <arglist>(SoDraggerCB *func, void *data=NULL)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeMotionCallback</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>afaaececc9dc22bc61f0e9d2008f516c3</anchor>
      <arglist>(SoDraggerCB *func, void *data=NULL)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addFinishCallback</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>a79adb2dc857a4658627a97c0343a268d</anchor>
      <arglist>(SoDraggerCB *func, void *data=NULL)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeFinishCallback</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>a951623ea7527a67b78fe270549acf6e0</anchor>
      <arglist>(SoDraggerCB *func, void *data=NULL)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addValueChangedCallback</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>a9fecd19fe8dd6ee0f33313f0aca4f366</anchor>
      <arglist>(SoDraggerCB *func, void *data=NULL)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeValueChangedCallback</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>a36c578d4ba2f222507a02af838dee8a2</anchor>
      <arglist>(SoDraggerCB *func, void *data=NULL)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMinGesture</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>a0f32b086413f00d08c500eabbf14cc55</anchor>
      <arglist>(int pixels)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getMinGesture</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>ac075d129602b4abdd29e76871385d121</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>enableValueChangedCallbacks</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>ac9b06cd585ddf05ae29cb706dd7c9675</anchor>
      <arglist>(SbBool newval)</arglist>
    </member>
    <member kind="function">
      <type>const SbMatrix &amp;</type>
      <name>getMotionMatrix</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>a480a493bc4d4202af034e7b9b2019815</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addOtherEventCallback</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>a457e60b7a34b2063ef23426b6225c54e</anchor>
      <arglist>(SoDraggerCB *func, void *data=NULL)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removeOtherEventCallback</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>aa9535e0b23caf155aacb6d96b3d6d418</anchor>
      <arglist>(SoDraggerCB *func, void *data=NULL)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>registerChildDragger</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>a1533542fa61931e47e3bd24249df8b3c</anchor>
      <arglist>(SoDragger *child)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unregisterChildDragger</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>aa42ef5a835a31685215bc70d3d6b4274</anchor>
      <arglist>(SoDragger *child)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>registerChildDraggerMovingIndependently</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>a2df00ef00554bcfe194179b3bf8ab9a2</anchor>
      <arglist>(SoDragger *child)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>unregisterChildDraggerMovingIndependently</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>a29e4050c87c047de835fd0c3e9b2134e</anchor>
      <arglist>(SoDragger *child)</arglist>
    </member>
    <member kind="function">
      <type>SbMatrix</type>
      <name>getLocalToWorldMatrix</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>abe5e0efec810954d18f51cacfee6104d</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>SbMatrix</type>
      <name>getWorldToLocalMatrix</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>af6863eacde8a13c38d50cd48bb59867c</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f</type>
      <name>getLocalStartingPoint</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>ab9a499454ab4e0b5a9c05b75881cb242</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>SbVec3f</type>
      <name>getWorldStartingPoint</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>ab7c24a8e66358d591a734faacbc24cc1</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getPartToLocalMatrix</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>a83ed4b69730c2246f88e4bde8b72b9b6</anchor>
      <arglist>(const SbName &amp;partname, SbMatrix &amp;parttolocalmatrix, SbMatrix &amp;localtopartmatrix)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>transformMatrixLocalToWorld</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>ab93ae5975ab82fbe88180df4525ebe1e</anchor>
      <arglist>(const SbMatrix &amp;frommatrix, SbMatrix &amp;tomatrix)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>transformMatrixWorldToLocal</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>a9c564861277072608e29b1c6d5ba8645</anchor>
      <arglist>(const SbMatrix &amp;frommatrix, SbMatrix &amp;tomatrix)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>transformMatrixToLocalSpace</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>a7b13f37e194daf3ee5e1a022b7c4dbe4</anchor>
      <arglist>(const SbMatrix &amp;frommatrix, SbMatrix &amp;tomatrix, const SbName &amp;fromspacepartname)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setMotionMatrix</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>ab83eaa55e4c2093594f5236cc4932dc2</anchor>
      <arglist>(const SbMatrix &amp;newmatrix)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>valueChanged</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>a6117eca20390155a450d62d99b41c6f8</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SbMatrix &amp;</type>
      <name>getStartMotionMatrix</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>ab24a03b1a24ae24aa65ee40f1bb1b170</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SoPath *</type>
      <name>getPickPath</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>a5fdba6252dd6dac3ee024e0441ba08c0</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>const SoEvent *</type>
      <name>getEvent</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>acb11f0192517060a37b258985107ee80</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>SoPath *</type>
      <name>createPathToThis</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>adab411d63e761b7b9d9a4c5b12271cea</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>const SoPath *</type>
      <name>getSurrogatePartPickedOwner</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>a380674cb4fcaca667796b14585564920</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>const SbName &amp;</type>
      <name>getSurrogatePartPickedName</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>ac8d75e080e63a6f5f3a0f7020c88a3df</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>const SoPath *</type>
      <name>getSurrogatePartPickedPath</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>a6df11eee6bd753618faa9600a8c007a1</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setStartingPoint</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>a446f19479cbf0613c94c58483b82082d</anchor>
      <arglist>(const SoPickedPoint *newpoint)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setStartingPoint</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>a91da7806b51319c0e248f26a95dd7da2</anchor>
      <arglist>(const SbVec3f &amp;newpoint)</arglist>
    </member>
    <member kind="function">
      <type>const SbViewVolume &amp;</type>
      <name>getViewVolume</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>a63c6047ec329569454e6f6c3c0ff5089</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setViewVolume</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>ac97a3e1f1d3d0c733dacf67a88c95e12</anchor>
      <arglist>(const SbViewVolume &amp;vol)</arglist>
    </member>
    <member kind="function">
      <type>const SbViewportRegion &amp;</type>
      <name>getViewportRegion</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>a07c680123d27c0d2f3a848dc1a765b5e</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setViewportRegion</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>a984519db2bd69dc0cfb5ae27a57d39da</anchor>
      <arglist>(const SbViewportRegion &amp;reg)</arglist>
    </member>
    <member kind="function">
      <type>SoHandleEventAction *</type>
      <name>getHandleEventAction</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>a20fd7d4f461ef86fa688a69e554ab0bb</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setHandleEventAction</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>a46ce71e08a9ac09d42521f60e1b5b795</anchor>
      <arglist>(SoHandleEventAction *newAction)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setTempPathToThis</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>a966b9d325e50c367ffed15aadfe51f9e</anchor>
      <arglist>(const SoPath *somethingclose)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>grabEventsSetup</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>accbb8d732a2f501deff37b5a1e4083c7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>grabEventsCleanup</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>a40624b149275583541b4658326d6ea28</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>workFieldsIntoTransform</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>a848dfd24b9f14d6250f631556defe841</anchor>
      <arglist>(SbMatrix &amp;mtx)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setFrontOnProjector</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>a11646a5bcfc56f18afdde7a9a59ba985</anchor>
      <arglist>(ProjectorFrontSetting newval)</arglist>
    </member>
    <member kind="function">
      <type>ProjectorFrontSetting</type>
      <name>getFrontOnProjector</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>ab29aecdb558e595d70ee681fc762710a</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoInteractionKit</name>
      <anchorfile>classSoInteractionKit.html</anchorfile>
      <anchor>a89f2357a132e87e78e0c469eb4b659ea</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>setPartAsPath</name>
      <anchorfile>classSoInteractionKit.html</anchorfile>
      <anchor>af86aa8628f3966b61997c5a404d1efa2</anchor>
      <arglist>(const SbName &amp;partname, SoPath *path)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>setPartAsDefault</name>
      <anchorfile>classSoInteractionKit.html</anchorfile>
      <anchor>a1aae5cdef63005f5c7251d3991119b60</anchor>
      <arglist>(const SbName &amp;partname, SoNode *node, SbBool onlyifdefault=TRUE)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>setPartAsDefault</name>
      <anchorfile>classSoInteractionKit.html</anchorfile>
      <anchor>a4d58c83525c45acaab52b0db52008cf7</anchor>
      <arglist>(const SbName &amp;partname, const SbName &amp;nodename, SbBool onlyifdefault=TRUE)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isPathSurrogateInMySubgraph</name>
      <anchorfile>classSoInteractionKit.html</anchorfile>
      <anchor>ab4faa09f926a2c4774138ce006f578fc</anchor>
      <arglist>(const SoPath *path, SoPath *&amp;pathToOwner, SbName &amp;surrogatename, SoPath *&amp;surrogatepath, SbBool fillargs=TRUE)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isPathSurrogateInMySubgraph</name>
      <anchorfile>classSoInteractionKit.html</anchorfile>
      <anchor>ae48169cf808f6c01a4d7fbbc44efa955</anchor>
      <arglist>(const SoPath *path)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>setPart</name>
      <anchorfile>classSoInteractionKit.html</anchorfile>
      <anchor>af09e99ef2289df877b95e4b7f4fe177d</anchor>
      <arglist>(const SbName &amp;partname, SoNode *from)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>setMinScale</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>a35be28bdfe4fa34e7c7251726c0dae22</anchor>
      <arglist>(float newminscale)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static float</type>
      <name>getMinScale</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>a5af4d13935e41873783d8611021ced6c</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>workValuesIntoTransform</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>a9d27ed39a52e5844f7c84ab4324090b4</anchor>
      <arglist>(SbMatrix &amp;mtx, const SbVec3f *translationptr, const SbRotation *rotationptr, const SbVec3f *scalefactorptr, const SbRotation *scaleorientationptr, const SbVec3f *centerptr)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>getTransformFast</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>a866ac61bb63a9e26e8fbeaef3b260111</anchor>
      <arglist>(SbMatrix &amp;mtx, SbVec3f &amp;translation, SbRotation &amp;rotation, SbVec3f &amp;scalefactor, SbRotation &amp;scaleorientation, const SbVec3f &amp;center)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>getTransformFast</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>ae73b0045c2b30e7edb86391a461b2a63</anchor>
      <arglist>(SbMatrix &amp;mtx, SbVec3f &amp;translation, SbRotation &amp;rotation, SbVec3f &amp;scalefactor, SbRotation &amp;scaleorientation)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SbMatrix</type>
      <name>appendTranslation</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>abbcb4cdb3e1542a6896af65a9395f50c</anchor>
      <arglist>(const SbMatrix &amp;mtx, const SbVec3f &amp;translation, const SbMatrix *conversion=NULL)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SbMatrix</type>
      <name>appendScale</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>a58abbcf51017c8756d96e54ff2005a62</anchor>
      <arglist>(const SbMatrix &amp;mtx, const SbVec3f &amp;scale, const SbVec3f &amp;scalecenter, const SbMatrix *conversion=NULL)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SbMatrix</type>
      <name>appendRotation</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>a444ce113b549f9808fdbff77514b3458</anchor>
      <arglist>(const SbMatrix &amp;mtx, const SbRotation &amp;rot, const SbVec3f &amp;rotcenter, const SbMatrix *conversion=NULL)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>initClass</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>a619901374bbc6824c05e53a7b5f114b6</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>initClasses</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>a6ad76dc427dc903678e1e4936bbc7785</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>setSwitchValue</name>
      <anchorfile>classSoInteractionKit.html</anchorfile>
      <anchor>af522e6bc4f5ec32a6b40a0edf22f954f</anchor>
      <arglist>(SoNode *node, const int newVal)</arglist>
    </member>
    <member kind="variable">
      <type>SoSFRotation</type>
      <name>rotation</name>
      <anchorfile>classSoCenterballDragger.html</anchorfile>
      <anchor>aaf87147f502dac6649b27f699382e3d5</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoSFVec3f</type>
      <name>center</name>
      <anchorfile>classSoCenterballDragger.html</anchorfile>
      <anchor>af7bbdde79e7a2be60c45a3604fc49b95</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoSFBool</type>
      <name>isActive</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>a3104dec7dff57c310ea42207fd50a76c</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoSFEnum</type>
      <name>renderCaching</name>
      <anchorfile>classSoInteractionKit.html</anchorfile>
      <anchor>a0721d44115e135e704899180f9dd1ea3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoSFEnum</type>
      <name>boundingBoxCaching</name>
      <anchorfile>classSoInteractionKit.html</anchorfile>
      <anchor>a8003282ce3a8bd37a1642472fcc81135</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoSFEnum</type>
      <name>renderCulling</name>
      <anchorfile>classSoInteractionKit.html</anchorfile>
      <anchor>a88e5e2140949e46cc6a82aad104a779d</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoSFEnum</type>
      <name>pickCulling</name>
      <anchorfile>classSoInteractionKit.html</anchorfile>
      <anchor>aa630983b94260156b2e8e3d7be5f633a</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual const SoFieldData *</type>
      <name>getFieldData</name>
      <anchorfile>classSoCenterballDragger.html</anchorfile>
      <anchor>ad18e94ab4b49186f97921b1645597267</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~SoCenterballDragger</name>
      <anchorfile>classSoCenterballDragger.html</anchorfile>
      <anchor>afa8bf763b60ba2ab5a7669aa6b8da266</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>transferCenterDraggerMotion</name>
      <anchorfile>classSoCenterballDragger.html</anchorfile>
      <anchor>a74d4721d078e56f2721d0c2c61e1f2e9</anchor>
      <arglist>(SoDragger *childdragger)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>setSwitches</name>
      <anchorfile>classSoCenterballDragger.html</anchorfile>
      <anchor>af2053f632eac0cca6c4d4c087dd9eef8</anchor>
      <arglist>(SoDragger *activechild)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>setUpConnections</name>
      <anchorfile>classSoCenterballDragger.html</anchorfile>
      <anchor>a16a54b05f6f075b0c880fc8b9bf3b489</anchor>
      <arglist>(SbBool onoff, SbBool doitalways=FALSE)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>setDefaultOnNonWritingFields</name>
      <anchorfile>classSoCenterballDragger.html</anchorfile>
      <anchor>af3e5b4053a778531168fc1d294cf62cf</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>getBoundingBox</name>
      <anchorfile>classSoCenterballDragger.html</anchorfile>
      <anchor>ae6ce696b4fe4867a9d937b3ca2332979</anchor>
      <arglist>(SoGetBoundingBoxAction *action)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>getMatrix</name>
      <anchorfile>classSoCenterballDragger.html</anchorfile>
      <anchor>ad5b948c30fba5a66e3454187f05d7266</anchor>
      <arglist>(SoGetMatrixAction *action)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type></type>
      <name>SoDragger</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>a59e6729622d54554dc14ab8a105efde2</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~SoDragger</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>af6417fd1cf52a391ee8469f86d9ffd57</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>SbVec2f</type>
      <name>getNormalizedLocaterPosition</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>ab17562433812d4041cae9ecee4b736e1</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>SbVec2s</type>
      <name>getLocaterPosition</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>a0fd6089ae6639692defd470746aec7c2</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>SbVec2s</type>
      <name>getStartLocaterPosition</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>a9c3f74c67b63019a9547ebb314a0cc2c</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>setStartLocaterPosition</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>a8d389e453416f6f90f4cc103c06fe764</anchor>
      <arglist>(SbVec2s p)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>SbBool</type>
      <name>isAdequateConstraintMotion</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>a017aa7024e37f667753431da394dc189</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>shouldGrabBasedOnSurrogate</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>a7086e5aaf6859e29754300526ba51482</anchor>
      <arglist>(const SoPath *pickpath, const SoPath *surrogatepath)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>setCameraInfo</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>ae59c9f2f54b51627e3e973f61112620e</anchor>
      <arglist>(SoAction *action)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>handleEvent</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>ade6fda8dfab62ed95aae397fd01086ce</anchor>
      <arglist>(SoHandleEventAction *ha)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>transferMotion</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>a8011293c936aa66fbb79d48b05ae1cdf</anchor>
      <arglist>(SoDragger *child)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>setIgnoreInBbox</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>a1fef53e79cdf180fcf3f2f05a7010b29</anchor>
      <arglist>(SbBool newval)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>SbBool</type>
      <name>isIgnoreInBbox</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>ae67d944d4b6b8406292f5d8ee50c49f5</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>setActiveChildDragger</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>a0af97dcab6595eceb8771d8113bcf7be</anchor>
      <arglist>(SoDragger *newchilddragger)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>SoDragger *</type>
      <name>getActiveChildDragger</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>aac57e29eba1fd57e69dc38cea581a4d2</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>updateDraggerCache</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>a0cae8dd9ec1f83c5503782d2a6498f18</anchor>
      <arglist>(const SoPath *path)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~SoInteractionKit</name>
      <anchorfile>classSoInteractionKit.html</anchorfile>
      <anchor>afa91e31fbc7622aeb2195b5a1d80b865</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>copyContents</name>
      <anchorfile>classSoInteractionKit.html</anchorfile>
      <anchor>a6b198096ba44831447dbf3b5bda9c702</anchor>
      <arglist>(const SoFieldContainer *fromFC, SbBool copyConnections)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>setPart</name>
      <anchorfile>classSoInteractionKit.html</anchorfile>
      <anchor>a4e363d704bf0caf9cbfa1ebd36d7818a</anchor>
      <arglist>(const int partNum, SoNode *node)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>readInstance</name>
      <anchorfile>classSoInteractionKit.html</anchorfile>
      <anchor>a652933434f6384c41475cc80de6c893f</anchor>
      <arglist>(SoInput *in, unsigned short flags)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>setAnyPartAsDefault</name>
      <anchorfile>classSoInteractionKit.html</anchorfile>
      <anchor>a83330aafe32b8f3e5377311084237ffb</anchor>
      <arglist>(const SbName &amp;partname, SoNode *node, SbBool anypart=TRUE, SbBool onlyifdefault=TRUE)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>setAnyPartAsDefault</name>
      <anchorfile>classSoInteractionKit.html</anchorfile>
      <anchor>afc3e0a82b1ff5e729b74ae78dbb3adf9</anchor>
      <arglist>(const SbName &amp;partname, const SbName &amp;nodename, SbBool anypart=TRUE, SbBool onlyifdefault=TRUE)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>SbBool</type>
      <name>setAnySurrogatePath</name>
      <anchorfile>classSoInteractionKit.html</anchorfile>
      <anchor>a52e0a4c5ce9ab959259de3cf4f9a6d54</anchor>
      <arglist>(const SbName &amp;name, SoPath *path, SbBool leafcheck=FALSE, SbBool publiccheck=FALSE)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>connectSeparatorFields</name>
      <anchorfile>classSoInteractionKit.html</anchorfile>
      <anchor>a38e43e95f0f95dc42e5437ffc413328d</anchor>
      <arglist>(SoSeparator *dest, SbBool onOff)</arglist>
    </member>
    <member kind="function" protection="protected" static="yes">
      <type>static void</type>
      <name>fieldSensorCB</name>
      <anchorfile>classSoCenterballDragger.html</anchorfile>
      <anchor>a1d2bbf65cb113390ad96e43438f945e8</anchor>
      <arglist>(void *f, SoSensor *s)</arglist>
    </member>
    <member kind="function" protection="protected" static="yes">
      <type>static void</type>
      <name>valueChangedCB</name>
      <anchorfile>classSoCenterballDragger.html</anchorfile>
      <anchor>ab9c32d37339732608adc74cd547d7678</anchor>
      <arglist>(void *f, SoDragger *d)</arglist>
    </member>
    <member kind="function" protection="protected" static="yes">
      <type>static void</type>
      <name>kidStartCB</name>
      <anchorfile>classSoCenterballDragger.html</anchorfile>
      <anchor>a381b809109c06c3a29b2d19f5dbb810f</anchor>
      <arglist>(void *f, SoDragger *d)</arglist>
    </member>
    <member kind="function" protection="protected" static="yes">
      <type>static void</type>
      <name>kidFinishCB</name>
      <anchorfile>classSoCenterballDragger.html</anchorfile>
      <anchor>a1865b1a96fee759819d3699aa6361351</anchor>
      <arglist>(void *f, SoDragger *d)</arglist>
    </member>
    <member kind="function" protection="protected" static="yes">
      <type>static void</type>
      <name>childTransferMotionAndValueChangedCB</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>ae45c275f020dd239b121c55ff3e30adf</anchor>
      <arglist>(void *, SoDragger *)</arglist>
    </member>
    <member kind="function" protection="protected" static="yes">
      <type>static void</type>
      <name>childValueChangedCB</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>a8249524f6e707c5fad6a9b20ec7ca5c3</anchor>
      <arglist>(void *, SoDragger *)</arglist>
    </member>
    <member kind="function" protection="protected" static="yes">
      <type>static void</type>
      <name>childStartCB</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>a7cc2bdaa503ddca69f5855a55c384a33</anchor>
      <arglist>(void *, SoDragger *)</arglist>
    </member>
    <member kind="function" protection="protected" static="yes">
      <type>static void</type>
      <name>childMotionCB</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>afcb708c2d39b171cd537b71442edac12</anchor>
      <arglist>(void *, SoDragger *)</arglist>
    </member>
    <member kind="function" protection="protected" static="yes">
      <type>static void</type>
      <name>childFinishCB</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>a75245b3558fe16f8e0d865fd6d0670ab</anchor>
      <arglist>(void *, SoDragger *)</arglist>
    </member>
    <member kind="function" protection="protected" static="yes">
      <type>static void</type>
      <name>childOtherEventCB</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>ad9c9cf2b00f156fa3eef05de8bd8a597</anchor>
      <arglist>(void *, SoDragger *)</arglist>
    </member>
    <member kind="function" protection="protected" static="yes">
      <type>static void</type>
      <name>readDefaultParts</name>
      <anchorfile>classSoInteractionKit.html</anchorfile>
      <anchor>a9ae7ec2912714a3606285cdcba5ff37b</anchor>
      <arglist>(const char *fileName, const char defaultBuffer[], int defBufSize)</arglist>
    </member>
    <member kind="function" protection="protected" static="yes">
      <type>static void</type>
      <name>fieldSensorCB</name>
      <anchorfile>classSoInteractionKit.html</anchorfile>
      <anchor>ab50592dc32eb0e91b65fb7cc3e558ed2</anchor>
      <arglist>(void *, SoSensor *)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SoFieldSensor *</type>
      <name>rotFieldSensor</name>
      <anchorfile>classSoCenterballDragger.html</anchorfile>
      <anchor>a5673c2a903f475d1f970d2fd3fbf6f2d</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SoFieldSensor *</type>
      <name>centerFieldSensor</name>
      <anchorfile>classSoCenterballDragger.html</anchorfile>
      <anchor>ae48263d9c8be83817c3a965a6820ff11</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SoFieldSensor *</type>
      <name>fieldSensor</name>
      <anchorfile>classSoInteractionKit.html</anchorfile>
      <anchor>a0b07989dbb5ee24fef77500fb1248dab</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SoSeparator *</type>
      <name>oldTopSep</name>
      <anchorfile>classSoInteractionKit.html</anchorfile>
      <anchor>a27b4f1a6b40cdfd9c5ea94a7d59f8fc8</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>ProjectorFrontSetting</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>afdfe9d11fcbde8e42fff713907f6c7a1</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>FRONT</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>afdfe9d11fcbde8e42fff713907f6c7a1a9afe09d041b239cbfda699703db89f2a</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>BACK</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>afdfe9d11fcbde8e42fff713907f6c7a1a1740183c2afc21c9650e8c0ab7647750</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>USE_PICK</name>
      <anchorfile>classSoDragger.html</anchorfile>
      <anchor>afdfe9d11fcbde8e42fff713907f6c7a1a147e0fac0b67cf918a1b3ed8a77f07c0</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumeration">
      <type></type>
      <name>CacheEnabled</name>
      <anchorfile>classSoInteractionKit.html</anchorfile>
      <anchor>a6e3b312f001982687c6ead6f70e505b4</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoCenterballManip</name>
    <filename>classSoCenterballManip.html</filename>
    <base>SoTransformManip</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classSoCenterballManip.html</anchorfile>
      <anchor>a5bb0ece1edbfcebb3ed47c564029b700</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoCenterballManip</name>
      <anchorfile>classSoCenterballManip.html</anchorfile>
      <anchor>a93c60e150d3ece7ce0a7c2c579aaace9</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoTransformManip</name>
      <anchorfile>classSoTransformManip.html</anchorfile>
      <anchor>ad34ed99c114a7f31b210c9018e628c40</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>SoDragger *</type>
      <name>getDragger</name>
      <anchorfile>classSoTransformManip.html</anchorfile>
      <anchor>a0df7cf0b388b8f23600a5c8f5a7be41b</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>replaceNode</name>
      <anchorfile>classSoTransformManip.html</anchorfile>
      <anchor>aa3035a324a6d39c037f1754e61a8cee9</anchor>
      <arglist>(SoPath *p)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>replaceManip</name>
      <anchorfile>classSoTransformManip.html</anchorfile>
      <anchor>a84dcf0cb3e159ac1fdcfc23a2411528a</anchor>
      <arglist>(SoPath *p, SoTransform *newone) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>doAction</name>
      <anchorfile>classSoTransformManip.html</anchorfile>
      <anchor>a65ee82324fe763ebbb67db148362f052</anchor>
      <arglist>(SoAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>callback</name>
      <anchorfile>classSoTransformManip.html</anchorfile>
      <anchor>a445883ede479f83c6067350950ea0ed4</anchor>
      <arglist>(SoCallbackAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>GLRender</name>
      <anchorfile>classSoTransformManip.html</anchorfile>
      <anchor>a576c1ef21dfd9a12e7d8bfb2045c29d3</anchor>
      <arglist>(SoGLRenderAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>getBoundingBox</name>
      <anchorfile>classSoTransformManip.html</anchorfile>
      <anchor>aea2aec22ec5044fdf7713e0742dc962c</anchor>
      <arglist>(SoGetBoundingBoxAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>getMatrix</name>
      <anchorfile>classSoTransformManip.html</anchorfile>
      <anchor>a841073e74c32900e22a0e3e2ca124b0f</anchor>
      <arglist>(SoGetMatrixAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>handleEvent</name>
      <anchorfile>classSoTransformManip.html</anchorfile>
      <anchor>a6b5dbf7417c79665eab27a94a4d19578</anchor>
      <arglist>(SoHandleEventAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>pick</name>
      <anchorfile>classSoTransformManip.html</anchorfile>
      <anchor>a65859a478f91ffd2b557da90793b01e0</anchor>
      <arglist>(SoPickAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>search</name>
      <anchorfile>classSoTransformManip.html</anchorfile>
      <anchor>a9f9f91b4b12c88f80559951dd28f367c</anchor>
      <arglist>(SoSearchAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SoChildList *</type>
      <name>getChildren</name>
      <anchorfile>classSoTransformManip.html</anchorfile>
      <anchor>a732b82f220281d1c376bbf398601863a</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoTransform</name>
      <anchorfile>classSoTransform.html</anchorfile>
      <anchor>aee314730f294bfc896e56681b71fe736</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pointAt</name>
      <anchorfile>classSoTransform.html</anchorfile>
      <anchor>ae96ad1b916606f3ba482ae92f5ba18bf</anchor>
      <arglist>(const SbVec3f &amp;frompoint, const SbVec3f &amp;topoint)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getScaleSpaceMatrix</name>
      <anchorfile>classSoTransform.html</anchorfile>
      <anchor>a63f9dab20f9a27e3e384147bd9a8f148</anchor>
      <arglist>(SbMatrix &amp;mat, SbMatrix &amp;inv) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getRotationSpaceMatrix</name>
      <anchorfile>classSoTransform.html</anchorfile>
      <anchor>acafdf80acf9d67ccd27daa8c481f5c70</anchor>
      <arglist>(SbMatrix &amp;mat, SbMatrix &amp;inv) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getTranslationSpaceMatrix</name>
      <anchorfile>classSoTransform.html</anchorfile>
      <anchor>a4b68f1284bc29f13c6d9707433cbbaf1</anchor>
      <arglist>(SbMatrix &amp;mat, SbMatrix &amp;inv) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>multLeft</name>
      <anchorfile>classSoTransform.html</anchorfile>
      <anchor>a37046e7f913d40f99a7002ad6dcea62f</anchor>
      <arglist>(const SbMatrix &amp;mat)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>multRight</name>
      <anchorfile>classSoTransform.html</anchorfile>
      <anchor>ae4bc3cc7d17a0d75a94653e2dcde270f</anchor>
      <arglist>(const SbMatrix &amp;mat)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>combineLeft</name>
      <anchorfile>classSoTransform.html</anchorfile>
      <anchor>ad66dc0b2f6b2c7ce996e6ac87c1efe08</anchor>
      <arglist>(SoTransformation *nodeonright)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>combineRight</name>
      <anchorfile>classSoTransform.html</anchorfile>
      <anchor>a09c8cda47698d289028330d7f4ed5d85</anchor>
      <arglist>(SoTransformation *nodeonleft)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setMatrix</name>
      <anchorfile>classSoTransform.html</anchorfile>
      <anchor>a6320cc1f0d5c6050ce5d68f474fd4516</anchor>
      <arglist>(const SbMatrix &amp;mat)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>recenter</name>
      <anchorfile>classSoTransform.html</anchorfile>
      <anchor>af170765422c7cac5088448c295750376</anchor>
      <arglist>(const SbVec3f &amp;newcenter)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>getPrimitiveCount</name>
      <anchorfile>classSoTransform.html</anchorfile>
      <anchor>a9b133b39f6c92ef0c11bbd37f18ae6bc</anchor>
      <arglist>(SoGetPrimitiveCountAction *action)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual const SoFieldData *</type>
      <name>getFieldData</name>
      <anchorfile>classSoCenterballManip.html</anchorfile>
      <anchor>ad7b53fd16811ef9f0f2786f84c43c3de</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~SoCenterballManip</name>
      <anchorfile>classSoCenterballManip.html</anchorfile>
      <anchor>abcad2cae7c6edd2e9e9dba7b9f238747</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~SoTransformManip</name>
      <anchorfile>classSoTransformManip.html</anchorfile>
      <anchor>a22fce6b970baa77c5339f929aabb9d90</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>setDragger</name>
      <anchorfile>classSoTransformManip.html</anchorfile>
      <anchor>a342d5abdfc9a61e883459ef4529d7af7</anchor>
      <arglist>(SoDragger *newdragger)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>copyContents</name>
      <anchorfile>classSoTransformManip.html</anchorfile>
      <anchor>aea958acd64a43b0461bc104708c451c3</anchor>
      <arglist>(const SoFieldContainer *fromfc, SbBool copyconnections)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>attachSensors</name>
      <anchorfile>classSoTransformManip.html</anchorfile>
      <anchor>ac84ee0d4eeee8d727b75da2d843d18ed</anchor>
      <arglist>(const SbBool onoff)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~SoTransform</name>
      <anchorfile>classSoTransform.html</anchorfile>
      <anchor>a0727452cecd58c765d49b4191e1b8c03</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" static="yes">
      <type>static void</type>
      <name>transferFieldValues</name>
      <anchorfile>classSoTransformManip.html</anchorfile>
      <anchor>a95639f7c920ff38f9d603a4afc0c6e47</anchor>
      <arglist>(const SoTransform *from, SoTransform *to)</arglist>
    </member>
    <member kind="function" protection="protected" static="yes">
      <type>static void</type>
      <name>valueChangedCB</name>
      <anchorfile>classSoTransformManip.html</anchorfile>
      <anchor>a03c9f1f0f7bebec4e9598a811748c40e</anchor>
      <arglist>(void *f, SoDragger *d)</arglist>
    </member>
    <member kind="function" protection="protected" static="yes">
      <type>static void</type>
      <name>fieldSensorCB</name>
      <anchorfile>classSoTransformManip.html</anchorfile>
      <anchor>afb1c212fdd2179fa29ec7721d3447328</anchor>
      <arglist>(void *f, SoSensor *d)</arglist>
    </member>
    <member kind="variable">
      <type>SoSFVec3f</type>
      <name>translation</name>
      <anchorfile>classSoTransform.html</anchorfile>
      <anchor>af836257673b4b8ab61d7bc4807c8f69b</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoSFRotation</type>
      <name>rotation</name>
      <anchorfile>classSoTransform.html</anchorfile>
      <anchor>a357007d906d1680a72cd73cf974a6869</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoSFVec3f</type>
      <name>scaleFactor</name>
      <anchorfile>classSoTransform.html</anchorfile>
      <anchor>aa809e7560e35a236d792aad44ebe01c8</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoSFRotation</type>
      <name>scaleOrientation</name>
      <anchorfile>classSoTransform.html</anchorfile>
      <anchor>a64249aa497425cd98e6f789a0f0ffa89</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoSFVec3f</type>
      <name>center</name>
      <anchorfile>classSoTransform.html</anchorfile>
      <anchor>a25a62186a483f0b79f072532e6c88a6d</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SoFieldSensor *</type>
      <name>rotateFieldSensor</name>
      <anchorfile>classSoTransformManip.html</anchorfile>
      <anchor>a8685cd2bfa5494b5cda66d21498178db</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SoFieldSensor *</type>
      <name>translFieldSensor</name>
      <anchorfile>classSoTransformManip.html</anchorfile>
      <anchor>ad1abf8317db57c15e3b5d359b0c6efd6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SoFieldSensor *</type>
      <name>scaleFieldSensor</name>
      <anchorfile>classSoTransformManip.html</anchorfile>
      <anchor>a20a6aa319d0becb44755fc51c7aa87e3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SoFieldSensor *</type>
      <name>centerFieldSensor</name>
      <anchorfile>classSoTransformManip.html</anchorfile>
      <anchor>afb882172a345c4b3ec2a3a3ad467d5b4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SoFieldSensor *</type>
      <name>scaleOrientFieldSensor</name>
      <anchorfile>classSoTransformManip.html</anchorfile>
      <anchor>a4731f0b05d5e14902980402573798ce0</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SoChildList *</type>
      <name>children</name>
      <anchorfile>classSoTransformManip.html</anchorfile>
      <anchor>a4bb8e2b4b526986090bdf739e0903e9a</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoChildList</name>
    <filename>classSoChildList.html</filename>
    <base>SoNodeList</base>
    <member kind="function">
      <type></type>
      <name>SoChildList</name>
      <anchorfile>classSoChildList.html</anchorfile>
      <anchor>ac69057ffe3be0d879222d7537cb4678b</anchor>
      <arglist>(SoNode *const parent)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoChildList</name>
      <anchorfile>classSoChildList.html</anchorfile>
      <anchor>a1bf51909c3d537e78b5f7c6a40547356</anchor>
      <arglist>(SoNode *const parent, const int size)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoChildList</name>
      <anchorfile>classSoChildList.html</anchorfile>
      <anchor>a78927429fd796efa62ed69641023f3ea</anchor>
      <arglist>(SoNode *const parent, const SoChildList &amp;cl)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SoChildList</name>
      <anchorfile>classSoChildList.html</anchorfile>
      <anchor>a8a87a9f8b278052a9fe3f858cee077ad</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSoChildList.html</anchorfile>
      <anchor>abe278cc582d5688ff633799b64be16ac</anchor>
      <arglist>(SoNode *const node)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>insert</name>
      <anchorfile>classSoChildList.html</anchorfile>
      <anchor>a12c05cc49cf496fba99f037c2948b47d</anchor>
      <arglist>(SoNode *const ptr, const int addbefore)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>remove</name>
      <anchorfile>classSoChildList.html</anchorfile>
      <anchor>a90856979bdc9a6ae323c38123485e704</anchor>
      <arglist>(const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>copy</name>
      <anchorfile>classSoChildList.html</anchorfile>
      <anchor>a0ddfd394cf8326ea1e5753579a4c2709</anchor>
      <arglist>(const SoChildList &amp;cl)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>set</name>
      <anchorfile>classSoChildList.html</anchorfile>
      <anchor>ac2746b512d935774934eb0869851362a</anchor>
      <arglist>(const int index, SoNode *const node)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>traverseInPath</name>
      <anchorfile>classSoChildList.html</anchorfile>
      <anchor>a6925cc43313d082b086c99df35692a04</anchor>
      <arglist>(SoAction *const action, const int numindices, const int *indices)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>traverse</name>
      <anchorfile>classSoChildList.html</anchorfile>
      <anchor>aca4a3b907bceaa6e47691933bf23ef40</anchor>
      <arglist>(SoAction *const action)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>traverse</name>
      <anchorfile>classSoChildList.html</anchorfile>
      <anchor>ae485442e6c8e626a0b9d376dda9a9a0b</anchor>
      <arglist>(SoAction *const action, const int index)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>traverse</name>
      <anchorfile>classSoChildList.html</anchorfile>
      <anchor>a6fc486e01df51cbccbede4d45ad4ee8a</anchor>
      <arglist>(SoAction *const action, SoNode *node)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>traverse</name>
      <anchorfile>classSoChildList.html</anchorfile>
      <anchor>addcc9b1041879aa9c8c0b0f30d8298e8</anchor>
      <arglist>(SoAction *const action, const int first, const int last)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addPathAuditor</name>
      <anchorfile>classSoChildList.html</anchorfile>
      <anchor>a67cc8c889977a74f0f81ca95c7515c08</anchor>
      <arglist>(SoPath *const path)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removePathAuditor</name>
      <anchorfile>classSoChildList.html</anchorfile>
      <anchor>a725b5c4126c09ce0061a2c73b37f859a</anchor>
      <arglist>(SoPath *const path)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoNodeList</name>
      <anchorfile>classSoNodeList.html</anchorfile>
      <anchor>a5f8cdd4e4ce2f1751e860e2198bc6fac</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoNodeList</name>
      <anchorfile>classSoNodeList.html</anchorfile>
      <anchor>a6adf637a2512b3ddf507afc4bce993c9</anchor>
      <arglist>(const int size)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoNodeList</name>
      <anchorfile>classSoNodeList.html</anchorfile>
      <anchor>a44082be280e347a8d20e65f951ca8cb8</anchor>
      <arglist>(const SoNodeList &amp;nl)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SoNodeList</name>
      <anchorfile>classSoNodeList.html</anchorfile>
      <anchor>a23d4ce6d0bd24a1fc8cf1b76a2a5613b</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>append</name>
      <anchorfile>classSoNodeList.html</anchorfile>
      <anchor>a75c055cb0e44b6faad0f0fe01688a752</anchor>
      <arglist>(SoNode *const ptr)</arglist>
    </member>
    <member kind="function">
      <type>SoNode *</type>
      <name>operator[]</name>
      <anchorfile>classSoNodeList.html</anchorfile>
      <anchor>aff6941aea09bc6fc309f25e05b598b95</anchor>
      <arglist>(const int i) const </arglist>
    </member>
    <member kind="function">
      <type>SoNodeList &amp;</type>
      <name>operator=</name>
      <anchorfile>classSoNodeList.html</anchorfile>
      <anchor>a65ecde95f13d4bc0a7a8aaba759748ca</anchor>
      <arglist>(const SoNodeList &amp;nl)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoClipPlane</name>
    <filename>classSoClipPlane.html</filename>
    <base>SoNode</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classSoClipPlane.html</anchorfile>
      <anchor>a51ec7a77e639a3d6a829750232e849de</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoClipPlane</name>
      <anchorfile>classSoClipPlane.html</anchorfile>
      <anchor>ad09e2c436c0068b983902f805baa49c2</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>doAction</name>
      <anchorfile>classSoClipPlane.html</anchorfile>
      <anchor>a7657740c57fe05d9844580e95bc67bcc</anchor>
      <arglist>(SoAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>GLRender</name>
      <anchorfile>classSoClipPlane.html</anchorfile>
      <anchor>a9bb4e5e3ce200a8b281c883dcd7193a3</anchor>
      <arglist>(SoGLRenderAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>callback</name>
      <anchorfile>classSoClipPlane.html</anchorfile>
      <anchor>ad0e6338cf8f776eda3c13650da10491f</anchor>
      <arglist>(SoCallbackAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>pick</name>
      <anchorfile>classSoClipPlane.html</anchorfile>
      <anchor>a219ed7a778ec5e69646235b50cec0ea4</anchor>
      <arglist>(SoPickAction *action)</arglist>
    </member>
    <member kind="variable">
      <type>SoSFPlane</type>
      <name>plane</name>
      <anchorfile>classSoClipPlane.html</anchorfile>
      <anchor>a60ec8bf21c21aaae3cbe926c9910ceef</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoSFBool</type>
      <name>on</name>
      <anchorfile>classSoClipPlane.html</anchorfile>
      <anchor>ae4c28645eb38133124d4096d8e4ed040</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual const SoFieldData *</type>
      <name>getFieldData</name>
      <anchorfile>classSoClipPlane.html</anchorfile>
      <anchor>ad2ea084b63178302437cff79caf353c7</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~SoClipPlane</name>
      <anchorfile>classSoClipPlane.html</anchorfile>
      <anchor>a4e46adb1f703b6b083d5a63c220381ab</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoClipPlaneElement</name>
    <filename>classSoClipPlaneElement.html</filename>
    <base>SoAccumulatedElement</base>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>init</name>
      <anchorfile>classSoClipPlaneElement.html</anchorfile>
      <anchor>a815e912ed809503b1082a9ca2b7b8cd0</anchor>
      <arglist>(SoState *state)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>push</name>
      <anchorfile>classSoClipPlaneElement.html</anchorfile>
      <anchor>a29e776c9a60babfea4604d15f217b6ed</anchor>
      <arglist>(SoState *state)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getNum</name>
      <anchorfile>classSoClipPlaneElement.html</anchorfile>
      <anchor>a9b8dc09b165eba350f49c0f3243af07d</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>const SbPlane &amp;</type>
      <name>get</name>
      <anchorfile>classSoClipPlaneElement.html</anchorfile>
      <anchor>adefaa96f5d492350251061c68ad98d0d</anchor>
      <arglist>(const int index, const SbBool inworldspace=TRUE) const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void *</type>
      <name>createInstance</name>
      <anchorfile>classSoClipPlaneElement.html</anchorfile>
      <anchor>ab9df0dac94042649fc5c97f49f12be3f</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>add</name>
      <anchorfile>classSoClipPlaneElement.html</anchorfile>
      <anchor>a823d2609fe19b06616b2a337a91a85ba</anchor>
      <arglist>(SoState *const state, SoNode *const node, const SbPlane &amp;plane)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static const SoClipPlaneElement *</type>
      <name>getInstance</name>
      <anchorfile>classSoClipPlaneElement.html</anchorfile>
      <anchor>a561a6b52236f50294bb65651059de17e</anchor>
      <arglist>(SoState *const state)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~SoClipPlaneElement</name>
      <anchorfile>classSoClipPlaneElement.html</anchorfile>
      <anchor>ad91474f7ef24ab0075949573a0212fab</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>addToElt</name>
      <anchorfile>classSoClipPlaneElement.html</anchorfile>
      <anchor>a5ff2052d792ededdfd9e83382dc0999b</anchor>
      <arglist>(const SbPlane &amp;plane, const SbMatrix &amp;modelmatrix)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SbList&lt; so_plane_data &gt;</type>
      <name>planes</name>
      <anchorfile>classSoClipPlaneElement.html</anchorfile>
      <anchor>aa9bc5c488621a31930a3c84d31d2dc22</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>startIndex</name>
      <anchorfile>classSoClipPlaneElement.html</anchorfile>
      <anchor>aa934c14955eb6a5b459b4897b0032953</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoClipPlaneManip</name>
    <filename>classSoClipPlaneManip.html</filename>
    <base>SoClipPlane</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classSoClipPlaneManip.html</anchorfile>
      <anchor>ad601d6d116cb2c96aad5e09af9f601ea</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoClipPlaneManip</name>
      <anchorfile>classSoClipPlaneManip.html</anchorfile>
      <anchor>a454888f25c6085fde413315ad3d928c7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>SoDragger *</type>
      <name>getDragger</name>
      <anchorfile>classSoClipPlaneManip.html</anchorfile>
      <anchor>a03728b7e4e1ec9b58af114864bbd69d4</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setValue</name>
      <anchorfile>classSoClipPlaneManip.html</anchorfile>
      <anchor>a50c3d70ae9aa64866f43818e79c75fe5</anchor>
      <arglist>(const SbBox3f &amp;box, const SbVec3f &amp;planenormal, float draggerscalefactor)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>replaceNode</name>
      <anchorfile>classSoClipPlaneManip.html</anchorfile>
      <anchor>af7e248c396ab18fc222bba7ae2f8e97c</anchor>
      <arglist>(SoPath *p)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>replaceManip</name>
      <anchorfile>classSoClipPlaneManip.html</anchorfile>
      <anchor>a334a6fecefa52888f3ae9112ccc2c9c6</anchor>
      <arglist>(SoPath *p, SoClipPlane *newone) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>doAction</name>
      <anchorfile>classSoClipPlaneManip.html</anchorfile>
      <anchor>a4dfd8d4764b544e7cdcfaaa6b48aa8a4</anchor>
      <arglist>(SoAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>callback</name>
      <anchorfile>classSoClipPlaneManip.html</anchorfile>
      <anchor>ad743a4e6b71fb7ca58358a631fb79c01</anchor>
      <arglist>(SoCallbackAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>GLRender</name>
      <anchorfile>classSoClipPlaneManip.html</anchorfile>
      <anchor>a5596e521a04dc190a79e0ad4754554ef</anchor>
      <arglist>(SoGLRenderAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>getBoundingBox</name>
      <anchorfile>classSoClipPlaneManip.html</anchorfile>
      <anchor>a88e55ea3c526761c3091e691762b289b</anchor>
      <arglist>(SoGetBoundingBoxAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>getMatrix</name>
      <anchorfile>classSoClipPlaneManip.html</anchorfile>
      <anchor>a6e108bc457f0351746bf11303849ad41</anchor>
      <arglist>(SoGetMatrixAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>handleEvent</name>
      <anchorfile>classSoClipPlaneManip.html</anchorfile>
      <anchor>afc1efed45bbe9590bd4663537a94a8bc</anchor>
      <arglist>(SoHandleEventAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>pick</name>
      <anchorfile>classSoClipPlaneManip.html</anchorfile>
      <anchor>a1fdc2a28dece3ca5a1fc5edcc6972713</anchor>
      <arglist>(SoPickAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>search</name>
      <anchorfile>classSoClipPlaneManip.html</anchorfile>
      <anchor>ae3f713406292d4994636a8bb59a2e7b2</anchor>
      <arglist>(SoSearchAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SoChildList *</type>
      <name>getChildren</name>
      <anchorfile>classSoClipPlaneManip.html</anchorfile>
      <anchor>aa1821bc949023f72532d53506f825d13</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="variable">
      <type>SoSFVec3f</type>
      <name>draggerPosition</name>
      <anchorfile>classSoClipPlaneManip.html</anchorfile>
      <anchor>ad80b29ea97bcbf8d37f84cc77854066a</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual const SoFieldData *</type>
      <name>getFieldData</name>
      <anchorfile>classSoClipPlaneManip.html</anchorfile>
      <anchor>ac172d56b880daf5d9b2e8e1b73ce1915</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~SoClipPlaneManip</name>
      <anchorfile>classSoClipPlaneManip.html</anchorfile>
      <anchor>a43b9ced9441b15aa04989b303b6bee9a</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" protection="protected">
      <type>void</type>
      <name>setDragger</name>
      <anchorfile>classSoClipPlaneManip.html</anchorfile>
      <anchor>aa93a419279015b34d4719a5f2b4e3919</anchor>
      <arglist>(SoDragger *newdragger)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>copyContents</name>
      <anchorfile>classSoClipPlaneManip.html</anchorfile>
      <anchor>a772bc9131c912fda2de525ea17e51679</anchor>
      <arglist>(const SoFieldContainer *fromfc, SbBool copyconnections)</arglist>
    </member>
    <member kind="function" protection="protected" static="yes">
      <type>static void</type>
      <name>valueChangedCB</name>
      <anchorfile>classSoClipPlaneManip.html</anchorfile>
      <anchor>a548d74022ed9b72beee359c5a5e20b53</anchor>
      <arglist>(void *f, SoDragger *d)</arglist>
    </member>
    <member kind="function" protection="protected" static="yes">
      <type>static void</type>
      <name>fieldSensorCB</name>
      <anchorfile>classSoClipPlaneManip.html</anchorfile>
      <anchor>a5b2ec1e98642e4eed697e933086688ff</anchor>
      <arglist>(void *f, SoSensor *d)</arglist>
    </member>
    <member kind="function" protection="protected" static="yes">
      <type>static void</type>
      <name>transferFieldValues</name>
      <anchorfile>classSoClipPlaneManip.html</anchorfile>
      <anchor>a7787363cec7a1a55b595ae3285750da9</anchor>
      <arglist>(const SoClipPlane *from, SoClipPlane *to)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SoFieldSensor *</type>
      <name>planeFieldSensor</name>
      <anchorfile>classSoClipPlaneManip.html</anchorfile>
      <anchor>ae6c42644176b5c854cbb7aeaee0b9403</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SoFieldSensor *</type>
      <name>onFieldSensor</name>
      <anchorfile>classSoClipPlaneManip.html</anchorfile>
      <anchor>af52b97e5076fd587f0740a4d7b3a1100</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SoFieldSensor *</type>
      <name>draggerPosFieldSensor</name>
      <anchorfile>classSoClipPlaneManip.html</anchorfile>
      <anchor>ac629f2996c378d700be0c52f0c4c5166</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>SoChildList *</type>
      <name>children</name>
      <anchorfile>classSoClipPlaneManip.html</anchorfile>
      <anchor>aa15afeb6a06f3e5d37924e6f714508ca</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoColorIndex</name>
    <filename>classSoColorIndex.html</filename>
    <base>SoNode</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classSoColorIndex.html</anchorfile>
      <anchor>a2b7da754f7a1c07ceb340c35327a503b</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoColorIndex</name>
      <anchorfile>classSoColorIndex.html</anchorfile>
      <anchor>ad849bbf901737e7d309000ba85312c4a</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>GLRender</name>
      <anchorfile>classSoColorIndex.html</anchorfile>
      <anchor>a871c12986eeb3d727e5f830eecd4731a</anchor>
      <arglist>(SoGLRenderAction *action)</arglist>
    </member>
    <member kind="variable">
      <type>SoMFInt32</type>
      <name>index</name>
      <anchorfile>classSoColorIndex.html</anchorfile>
      <anchor>ae82a0f33260c1803c4655b82ca3bc4aa</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual const SoFieldData *</type>
      <name>getFieldData</name>
      <anchorfile>classSoColorIndex.html</anchorfile>
      <anchor>a537a8f4ab474bd93cfba5dcd9102fb83</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~SoColorIndex</name>
      <anchorfile>classSoColorIndex.html</anchorfile>
      <anchor>ad758926dcb15e4de0cb40513363e1659</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoCompactPathList</name>
    <filename>classSoCompactPathList.html</filename>
    <member kind="function">
      <type></type>
      <name>SoCompactPathList</name>
      <anchorfile>classSoCompactPathList.html</anchorfile>
      <anchor>a6eb6fabce6904c275958667be7f6aca7</anchor>
      <arglist>(const SoPathList &amp;list)</arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>~SoCompactPathList</name>
      <anchorfile>classSoCompactPathList.html</anchorfile>
      <anchor>a26ce75febf724a4fda427e0df5dc9b63</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>reset</name>
      <anchorfile>classSoCompactPathList.html</anchorfile>
      <anchor>aa8fc24ca3fffcc5ca475c2b3319ea59d</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>getChildren</name>
      <anchorfile>classSoCompactPathList.html</anchorfile>
      <anchor>a20d45ec11750d3859a85d1bd80fb0175</anchor>
      <arglist>(int &amp;numindices, const int *&amp;indices)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>push</name>
      <anchorfile>classSoCompactPathList.html</anchorfile>
      <anchor>adae29b87117103187c9572d70d1f8e68</anchor>
      <arglist>(int childindex)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>pop</name>
      <anchorfile>classSoCompactPathList.html</anchorfile>
      <anchor>ac30184420ca1313ae5e978182a7a4c3f</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getDepth</name>
      <anchorfile>classSoCompactPathList.html</anchorfile>
      <anchor>a3fc758e21fec05be9a65be5fce41b184</anchor>
      <arglist>(void) const </arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoComplexity</name>
    <filename>classSoComplexity.html</filename>
    <base>SoNode</base>
    <member kind="enumeration">
      <type></type>
      <name>Type</name>
      <anchorfile>classSoComplexity.html</anchorfile>
      <anchor>a2ff546b75ae833a1ec12a95324868a58</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>OBJECT_SPACE</name>
      <anchorfile>classSoComplexity.html</anchorfile>
      <anchor>a2ff546b75ae833a1ec12a95324868a58ab4693c439c837b465befd52ad247674d</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>SCREEN_SPACE</name>
      <anchorfile>classSoComplexity.html</anchorfile>
      <anchor>a2ff546b75ae833a1ec12a95324868a58a01f46fab18e8677d9b68b211505a842c</anchor>
      <arglist></arglist>
    </member>
    <member kind="enumvalue">
      <type>@</type>
      <name>BOUNDING_BOX</name>
      <anchorfile>classSoComplexity.html</anchorfile>
      <anchor>a2ff546b75ae833a1ec12a95324868a58a971ff929e8c652bf80290f8870b492ea</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classSoComplexity.html</anchorfile>
      <anchor>a044611826c1a1965d171c6502d04653a</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoComplexity</name>
      <anchorfile>classSoComplexity.html</anchorfile>
      <anchor>ae0318b0c164e7f36187a04b788446160</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>doAction</name>
      <anchorfile>classSoComplexity.html</anchorfile>
      <anchor>aefb72a95a2b08c7fc678569d560c54b3</anchor>
      <arglist>(SoAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>callback</name>
      <anchorfile>classSoComplexity.html</anchorfile>
      <anchor>adac713794594abaf176539ed97ec9bf8</anchor>
      <arglist>(SoCallbackAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>getBoundingBox</name>
      <anchorfile>classSoComplexity.html</anchorfile>
      <anchor>a15784b488df23cb49213f5a67cd0fa9c</anchor>
      <arglist>(SoGetBoundingBoxAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>GLRender</name>
      <anchorfile>classSoComplexity.html</anchorfile>
      <anchor>ad312f090454b736e279067043469b9af</anchor>
      <arglist>(SoGLRenderAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>pick</name>
      <anchorfile>classSoComplexity.html</anchorfile>
      <anchor>ae95a4ebdaf1fff4abadbbf4a3081979e</anchor>
      <arglist>(SoPickAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>getPrimitiveCount</name>
      <anchorfile>classSoComplexity.html</anchorfile>
      <anchor>a3d61d0edaf611f2aa11bc00109b25d27</anchor>
      <arglist>(SoGetPrimitiveCountAction *action)</arglist>
    </member>
    <member kind="variable">
      <type>SoSFEnum</type>
      <name>type</name>
      <anchorfile>classSoComplexity.html</anchorfile>
      <anchor>a6bd8d0a1658ae2055dfe49dbcfb07d72</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoSFFloat</type>
      <name>value</name>
      <anchorfile>classSoComplexity.html</anchorfile>
      <anchor>a0679d84b90988ecd1f0c8874d1368b6e</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoSFFloat</type>
      <name>textureQuality</name>
      <anchorfile>classSoComplexity.html</anchorfile>
      <anchor>ab0645588ad9a9fa84b769e98455eee24</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual const SoFieldData *</type>
      <name>getFieldData</name>
      <anchorfile>classSoComplexity.html</anchorfile>
      <anchor>af03af62575abe571ffbeb503e9cd2ba3</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~SoComplexity</name>
      <anchorfile>classSoComplexity.html</anchorfile>
      <anchor>a5c18627f1d67aec02c8af4d471beaf7a</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoComplexityElement</name>
    <filename>classSoComplexityElement.html</filename>
    <base>SoFloatElement</base>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>init</name>
      <anchorfile>classSoComplexityElement.html</anchorfile>
      <anchor>a2bf5f3bf07dff945dca30929f1d60743</anchor>
      <arglist>(SoState *state)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SbBool</type>
      <name>matches</name>
      <anchorfile>classSoFloatElement.html</anchorfile>
      <anchor>ac0440db3401a0e11feba773c11fa0903</anchor>
      <arglist>(const SoElement *element) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SoElement *</type>
      <name>copyMatchInfo</name>
      <anchorfile>classSoFloatElement.html</anchorfile>
      <anchor>ab8682b820fa7653322335bb40fc72777</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>print</name>
      <anchorfile>classSoFloatElement.html</anchorfile>
      <anchor>afd624d54625fca2886bbe0b8890d259e</anchor>
      <arglist>(FILE *file) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>setElt</name>
      <anchorfile>classSoFloatElement.html</anchorfile>
      <anchor>a16b947ef6a885245ef4d44ca46a017be</anchor>
      <arglist>(float value)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void *</type>
      <name>createInstance</name>
      <anchorfile>classSoComplexityElement.html</anchorfile>
      <anchor>ac64f6ea688187960bbb1ae33b6d8ad93</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>initClass</name>
      <anchorfile>classSoComplexityElement.html</anchorfile>
      <anchor>a5660e34775c488b2d7d57f4768ee7502</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>set</name>
      <anchorfile>classSoComplexityElement.html</anchorfile>
      <anchor>a2448597cd377c1b9572c21e2ba96de5b</anchor>
      <arglist>(SoState *const state, SoNode *const node, const float complexity)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>set</name>
      <anchorfile>classSoComplexityElement.html</anchorfile>
      <anchor>ae9648e87071435bc4df17bb96423f3d9</anchor>
      <arglist>(SoState *const state, const float complexity)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static float</type>
      <name>get</name>
      <anchorfile>classSoComplexityElement.html</anchorfile>
      <anchor>ac7aff009b0643cecfe1bef2ae991f2d9</anchor>
      <arglist>(SoState *const state)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static float</type>
      <name>getDefault</name>
      <anchorfile>classSoComplexityElement.html</anchorfile>
      <anchor>acb47ce91b37a2c3f5c4db999decc6078</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>set</name>
      <anchorfile>classSoFloatElement.html</anchorfile>
      <anchor>affbf73ad04a368a6e171241d70cb66fd</anchor>
      <arglist>(const int stackIndex, SoState *const state, SoNode *const node, const float value)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>set</name>
      <anchorfile>classSoFloatElement.html</anchorfile>
      <anchor>abc4ccd99031a44ad46ad293e1731d691</anchor>
      <arglist>(const int stackIndex, SoState *const state, const float value)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static float</type>
      <name>get</name>
      <anchorfile>classSoFloatElement.html</anchorfile>
      <anchor>aba199d41bb48de8528aeb9fa9b413d57</anchor>
      <arglist>(const int stackIndex, SoState *const state)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~SoComplexityElement</name>
      <anchorfile>classSoComplexityElement.html</anchorfile>
      <anchor>a3b04fa19f7630007cdc1e193438da83f</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~SoFloatElement</name>
      <anchorfile>classSoFloatElement.html</anchorfile>
      <anchor>a34b62e52236b3b2201039af2b1e7fbc2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>float</type>
      <name>data</name>
      <anchorfile>classSoFloatElement.html</anchorfile>
      <anchor>a99e4dbb7cb48a8eab24eeaabc44f47f5</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoComplexityTypeElement</name>
    <filename>classSoComplexityTypeElement.html</filename>
    <base>SoInt32Element</base>
    <member kind="enumeration">
      <type></type>
      <name>Type</name>
      <anchorfile>classSoComplexityTypeElement.html</anchorfile>
      <anchor>a5d7dd88dc55b157955d92b3a2ea712a2</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>init</name>
      <anchorfile>classSoComplexityTypeElement.html</anchorfile>
      <anchor>ad103cffd7e26efec256819ac4ace3a51</anchor>
      <arglist>(SoState *state)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void *</type>
      <name>createInstance</name>
      <anchorfile>classSoComplexityTypeElement.html</anchorfile>
      <anchor>a4e984020be5de6ea8b3831a3246a2943</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>initClass</name>
      <anchorfile>classSoComplexityTypeElement.html</anchorfile>
      <anchor>ad266fba7df830bf1d49d6207689e106f</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>set</name>
      <anchorfile>classSoComplexityTypeElement.html</anchorfile>
      <anchor>ae9eccf3187aba058b627090f6ab05e79</anchor>
      <arglist>(SoState *const state, SoNode *const node, const Type type)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>set</name>
      <anchorfile>classSoComplexityTypeElement.html</anchorfile>
      <anchor>a958c16891d8bafa02a1049d9474da898</anchor>
      <arglist>(SoState *const state, const Type type)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Type</type>
      <name>get</name>
      <anchorfile>classSoComplexityTypeElement.html</anchorfile>
      <anchor>ad3f1e63cc835ae0de343d12ae4209805</anchor>
      <arglist>(SoState *const state)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static Type</type>
      <name>getDefault</name>
      <anchorfile>classSoComplexityTypeElement.html</anchorfile>
      <anchor>af21048833bc5733eaae25791cea388c2</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~SoComplexityTypeElement</name>
      <anchorfile>classSoComplexityTypeElement.html</anchorfile>
      <anchor>adeb898d66e4068c3927510aefe28f62b</anchor>
      <arglist>()</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoComposeMatrix</name>
    <filename>classSoComposeMatrix.html</filename>
    <base>SoEngine</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classSoComposeMatrix.html</anchorfile>
      <anchor>a9cf5070481d5d159150905ae1ab77318</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const SoFieldData *</type>
      <name>getFieldData</name>
      <anchorfile>classSoComposeMatrix.html</anchorfile>
      <anchor>aecc409119fd515d993ce25b2d7539ed1</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const SoEngineOutputData *</type>
      <name>getOutputData</name>
      <anchorfile>classSoComposeMatrix.html</anchorfile>
      <anchor>a06f1eb5daf6c749908dae8973f67fc2b</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="variable">
      <type>SoMFVec3f</type>
      <name>translation</name>
      <anchorfile>classSoComposeMatrix.html</anchorfile>
      <anchor>acd4debbac4b084fa2e639bd95e8149c9</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoMFRotation</type>
      <name>rotation</name>
      <anchorfile>classSoComposeMatrix.html</anchorfile>
      <anchor>aa6f2a9a411ad75950ac42450296afa2d</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoMFVec3f</type>
      <name>scaleFactor</name>
      <anchorfile>classSoComposeMatrix.html</anchorfile>
      <anchor>a6241cd91c130e3e1484b5589d265fec2</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoMFRotation</type>
      <name>scaleOrientation</name>
      <anchorfile>classSoComposeMatrix.html</anchorfile>
      <anchor>a4eb4b89be7dcf4b4929602e79c7dd1c3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoMFVec3f</type>
      <name>center</name>
      <anchorfile>classSoComposeMatrix.html</anchorfile>
      <anchor>a67c1b08794ce59ac89f390fcf236d3c7</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoEngineOutput</type>
      <name>matrix</name>
      <anchorfile>classSoComposeMatrix.html</anchorfile>
      <anchor>a4979bd73e735eba2b4b54f83e6d3de3a</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoComposeRotation</name>
    <filename>classSoComposeRotation.html</filename>
    <base>SoEngine</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classSoComposeRotation.html</anchorfile>
      <anchor>aec69fbfdd7bafa6e442fecb9b7b3c094</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const SoFieldData *</type>
      <name>getFieldData</name>
      <anchorfile>classSoComposeRotation.html</anchorfile>
      <anchor>a3f05a25566577821fe4594893dbf198b</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const SoEngineOutputData *</type>
      <name>getOutputData</name>
      <anchorfile>classSoComposeRotation.html</anchorfile>
      <anchor>ae4c44f2371693e33a1b75dcd99cd01c8</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="variable">
      <type>SoMFVec3f</type>
      <name>axis</name>
      <anchorfile>classSoComposeRotation.html</anchorfile>
      <anchor>a2ac1f3e7e63b34013c4d6d058a38f89e</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoMFFloat</type>
      <name>angle</name>
      <anchorfile>classSoComposeRotation.html</anchorfile>
      <anchor>a8cf4a24617302598dc83846665098770</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoEngineOutput</type>
      <name>rotation</name>
      <anchorfile>classSoComposeRotation.html</anchorfile>
      <anchor>a453ba00842471d10f7f18b31772445e5</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoComposeRotationFromTo</name>
    <filename>classSoComposeRotationFromTo.html</filename>
    <base>SoEngine</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classSoComposeRotationFromTo.html</anchorfile>
      <anchor>a71a8b55b9f4fb15924825cd4594413ed</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const SoFieldData *</type>
      <name>getFieldData</name>
      <anchorfile>classSoComposeRotationFromTo.html</anchorfile>
      <anchor>a58d8070ec26921674fc34273d2e1a491</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const SoEngineOutputData *</type>
      <name>getOutputData</name>
      <anchorfile>classSoComposeRotationFromTo.html</anchorfile>
      <anchor>ac28a0f580d43243acac88b2592436de1</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="variable">
      <type>SoMFVec3f</type>
      <name>from</name>
      <anchorfile>classSoComposeRotationFromTo.html</anchorfile>
      <anchor>a054cc01b1fc1f12967ec90f76f818d12</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoMFVec3f</type>
      <name>to</name>
      <anchorfile>classSoComposeRotationFromTo.html</anchorfile>
      <anchor>ac1727a4557c1112a6c1c64ee0e47bb59</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoEngineOutput</type>
      <name>rotation</name>
      <anchorfile>classSoComposeRotationFromTo.html</anchorfile>
      <anchor>a94744bf83f27899aa73d43435f6fa8b2</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoComposeVec2f</name>
    <filename>classSoComposeVec2f.html</filename>
    <base>SoEngine</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classSoComposeVec2f.html</anchorfile>
      <anchor>a1d61d913defede7ce0dd8a2ca6bd6368</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const SoFieldData *</type>
      <name>getFieldData</name>
      <anchorfile>classSoComposeVec2f.html</anchorfile>
      <anchor>aeb10e597f43c5076a534642e7ba8dfc6</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const SoEngineOutputData *</type>
      <name>getOutputData</name>
      <anchorfile>classSoComposeVec2f.html</anchorfile>
      <anchor>a0d4154e8dbeb3c9bbe073a1c730ee2c2</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="variable">
      <type>SoMFFloat</type>
      <name>x</name>
      <anchorfile>classSoComposeVec2f.html</anchorfile>
      <anchor>a711fa19eff02c31b977178fd053c085e</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoMFFloat</type>
      <name>y</name>
      <anchorfile>classSoComposeVec2f.html</anchorfile>
      <anchor>a40c2c2048e64a22b40ae61218971b007</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoEngineOutput</type>
      <name>vector</name>
      <anchorfile>classSoComposeVec2f.html</anchorfile>
      <anchor>acd493c780c5f9369ad623f457212c7da</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoComposeVec3f</name>
    <filename>classSoComposeVec3f.html</filename>
    <base>SoEngine</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classSoComposeVec3f.html</anchorfile>
      <anchor>a82d37615ece25fc7f747635284350ab3</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const SoFieldData *</type>
      <name>getFieldData</name>
      <anchorfile>classSoComposeVec3f.html</anchorfile>
      <anchor>a8ef296e73b40015f4a35c41bbe944cf1</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const SoEngineOutputData *</type>
      <name>getOutputData</name>
      <anchorfile>classSoComposeVec3f.html</anchorfile>
      <anchor>a5116bea614eb8dfeb14570430d65144c</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="variable">
      <type>SoMFFloat</type>
      <name>x</name>
      <anchorfile>classSoComposeVec3f.html</anchorfile>
      <anchor>af35cac54bec7b467c585d19f9b3f6793</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoMFFloat</type>
      <name>y</name>
      <anchorfile>classSoComposeVec3f.html</anchorfile>
      <anchor>a9033ad7b14ece698957f2bf409024fba</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoMFFloat</type>
      <name>z</name>
      <anchorfile>classSoComposeVec3f.html</anchorfile>
      <anchor>a3bbdc4e6eacd1e3bc0ef1744580d4db1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoEngineOutput</type>
      <name>vector</name>
      <anchorfile>classSoComposeVec3f.html</anchorfile>
      <anchor>a63bcb8f88c7131e0b2e417f57dca96d5</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoComposeVec4f</name>
    <filename>classSoComposeVec4f.html</filename>
    <base>SoEngine</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classSoComposeVec4f.html</anchorfile>
      <anchor>a469a1324e0319c959bbadee3303736d9</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const SoFieldData *</type>
      <name>getFieldData</name>
      <anchorfile>classSoComposeVec4f.html</anchorfile>
      <anchor>a3c7e75111eeb7a4e64773e79b6bb70c8</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const SoEngineOutputData *</type>
      <name>getOutputData</name>
      <anchorfile>classSoComposeVec4f.html</anchorfile>
      <anchor>ac434c69e7c0bd58bdcc4a1c7b0abeda8</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="variable">
      <type>SoMFFloat</type>
      <name>x</name>
      <anchorfile>classSoComposeVec4f.html</anchorfile>
      <anchor>a4536a5a1f774bb3466e8f6834ee1c82e</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoMFFloat</type>
      <name>y</name>
      <anchorfile>classSoComposeVec4f.html</anchorfile>
      <anchor>abcd64f7576d0d203fd4a1f64881ebd4d</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoMFFloat</type>
      <name>z</name>
      <anchorfile>classSoComposeVec4f.html</anchorfile>
      <anchor>afdf729bfa8dadce997080f1849a77c21</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoMFFloat</type>
      <name>w</name>
      <anchorfile>classSoComposeVec4f.html</anchorfile>
      <anchor>a6d8ae29a09880d5e9aff6b47f01c48f3</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoEngineOutput</type>
      <name>vector</name>
      <anchorfile>classSoComposeVec4f.html</anchorfile>
      <anchor>adf4c81fbcd4cbefbe717d633506081fe</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoComputeBoundingBox</name>
    <filename>classSoComputeBoundingBox.html</filename>
    <base>SoEngine</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classSoComputeBoundingBox.html</anchorfile>
      <anchor>aaa9aa048ef7fc54cb4de4f3002ba57de</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const SoFieldData *</type>
      <name>getFieldData</name>
      <anchorfile>classSoComputeBoundingBox.html</anchorfile>
      <anchor>a4ed1f783d5598ee5f38b6c06713b1671</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const SoEngineOutputData *</type>
      <name>getOutputData</name>
      <anchorfile>classSoComputeBoundingBox.html</anchorfile>
      <anchor>a098477549ad09755439879b5fc8780fe</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoComputeBoundingBox</name>
      <anchorfile>classSoComputeBoundingBox.html</anchorfile>
      <anchor>aadfc510515d7fde40abee1c9de43620c</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setViewportRegion</name>
      <anchorfile>classSoComputeBoundingBox.html</anchorfile>
      <anchor>a97426b05730655d25703225023f2f351</anchor>
      <arglist>(const SbViewportRegion &amp;vpr)</arglist>
    </member>
    <member kind="function">
      <type>const SbViewportRegion &amp;</type>
      <name>getViewportRegion</name>
      <anchorfile>classSoComputeBoundingBox.html</anchorfile>
      <anchor>a8124629bce7d0e91645daea77bd2ccd5</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="variable">
      <type>SoSFNode</type>
      <name>node</name>
      <anchorfile>classSoComputeBoundingBox.html</anchorfile>
      <anchor>a23f40c99e64e982e2d3a88a1f9b551b1</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoSFPath</type>
      <name>path</name>
      <anchorfile>classSoComputeBoundingBox.html</anchorfile>
      <anchor>ad4ca97e8aa530cdc447b6993ac4ec280</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoEngineOutput</type>
      <name>min</name>
      <anchorfile>classSoComputeBoundingBox.html</anchorfile>
      <anchor>a320568a6746c591421bcfddddaf3b3c4</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoEngineOutput</type>
      <name>max</name>
      <anchorfile>classSoComputeBoundingBox.html</anchorfile>
      <anchor>ae77a1fbd8d0c7aa08afcb742a0ed2f45</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoEngineOutput</type>
      <name>boxCenter</name>
      <anchorfile>classSoComputeBoundingBox.html</anchorfile>
      <anchor>af32d6c301face83701ce3977d959add6</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoEngineOutput</type>
      <name>objectCenter</name>
      <anchorfile>classSoComputeBoundingBox.html</anchorfile>
      <anchor>accd5aff5caa72d580e74002aff2f5074</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~SoComputeBoundingBox</name>
      <anchorfile>classSoComputeBoundingBox.html</anchorfile>
      <anchor>ae01abc974aa47c26299dbc9f38869dba</anchor>
      <arglist>(void)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoConcatenate</name>
    <filename>classSoConcatenate.html</filename>
    <base>SoEngine</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classSoConcatenate.html</anchorfile>
      <anchor>a5efc269c30f81b148f1003dd3ec6b776</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const SoFieldData *</type>
      <name>getFieldData</name>
      <anchorfile>classSoConcatenate.html</anchorfile>
      <anchor>aa03d6d50d714b1aeacb25f272572b289</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual const SoEngineOutputData *</type>
      <name>getOutputData</name>
      <anchorfile>classSoConcatenate.html</anchorfile>
      <anchor>ab03cb8e5ef5a27ca116deffc37dc5961</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoConcatenate</name>
      <anchorfile>classSoConcatenate.html</anchorfile>
      <anchor>a1f245d172d0c83845a74228a60a4100e</anchor>
      <arglist>(SoType inputType)</arglist>
    </member>
    <member kind="variable">
      <type>SoMField *</type>
      <name>input</name>
      <anchorfile>classSoConcatenate.html</anchorfile>
      <anchor>a02d6a2b555cd040e0f4c512c86d88b0e</anchor>
      <arglist>[NUMINPUTS]</arglist>
    </member>
    <member kind="variable">
      <type>SoEngineOutput *</type>
      <name>output</name>
      <anchorfile>classSoConcatenate.html</anchorfile>
      <anchor>a2963c32a0e673b1161544158cb0b0826</anchor>
      <arglist></arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoCone</name>
    <filename>classSoCone.html</filename>
    <base>SoShape</base>
    <member kind="enumeration">
      <type></type>
      <name>Part</name>
      <anchorfile>classSoCone.html</anchorfile>
      <anchor>a16fd6ddab267c269e269a883bb2774c1</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classSoCone.html</anchorfile>
      <anchor>aeda3349ee060a45da18707cf892bc57d</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoCone</name>
      <anchorfile>classSoCone.html</anchorfile>
      <anchor>a194d82469bf653f5e361cb262d772fae</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>addPart</name>
      <anchorfile>classSoCone.html</anchorfile>
      <anchor>a6bd8132e809b5d63e75579c180dfec7e</anchor>
      <arglist>(SoCone::Part part)</arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>removePart</name>
      <anchorfile>classSoCone.html</anchorfile>
      <anchor>aeed3e4496529a3c4eb8b0398e385d943</anchor>
      <arglist>(SoCone::Part part)</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>hasPart</name>
      <anchorfile>classSoCone.html</anchorfile>
      <anchor>a310c7878562ab797a53229bbc2e96d0e</anchor>
      <arglist>(SoCone::Part part) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>GLRender</name>
      <anchorfile>classSoCone.html</anchorfile>
      <anchor>a19cc4033b8b852a85c7000b49bc92ee5</anchor>
      <arglist>(SoGLRenderAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>rayPick</name>
      <anchorfile>classSoCone.html</anchorfile>
      <anchor>a872dddcbf2abc1f88c192a3fd60b4bb4</anchor>
      <arglist>(SoRayPickAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>getPrimitiveCount</name>
      <anchorfile>classSoCone.html</anchorfile>
      <anchor>a8b72db44472e853bfc9c52b643006eef</anchor>
      <arglist>(SoGetPrimitiveCountAction *action)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual void</type>
      <name>notify</name>
      <anchorfile>classSoShape.html</anchorfile>
      <anchor>a954e546c49b3078934c159d05836cfa3</anchor>
      <arglist>(SoNotList *nl)</arglist>
    </member>
    <member kind="variable">
      <type>SoSFBitMask</type>
      <name>parts</name>
      <anchorfile>classSoCone.html</anchorfile>
      <anchor>ae8b026c6f0e7747321e52b456a76fd11</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoSFFloat</type>
      <name>bottomRadius</name>
      <anchorfile>classSoCone.html</anchorfile>
      <anchor>a6fec355e686bdbed995d478a8aef7236</anchor>
      <arglist></arglist>
    </member>
    <member kind="variable">
      <type>SoSFFloat</type>
      <name>height</name>
      <anchorfile>classSoCone.html</anchorfile>
      <anchor>a39bac3fb3f787a8a0a375fa2ca855060</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual const SoFieldData *</type>
      <name>getFieldData</name>
      <anchorfile>classSoCone.html</anchorfile>
      <anchor>a8aad37e099b8a017e7c6631be9c6d883</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual</type>
      <name>~SoCone</name>
      <anchorfile>classSoCone.html</anchorfile>
      <anchor>ad4870bcfbf408b8bfe38862e9fbbf8f5</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>generatePrimitives</name>
      <anchorfile>classSoCone.html</anchorfile>
      <anchor>a5030822da35b640ff56d89e89c451a14</anchor>
      <arglist>(SoAction *action)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual void</type>
      <name>computeBBox</name>
      <anchorfile>classSoCone.html</anchorfile>
      <anchor>a8d93b12a5f789dd0c3029fad09f672ea</anchor>
      <arglist>(SoAction *action, SbBox3f &amp;box, SbVec3f &amp;center)</arglist>
    </member>
    <member kind="function" protection="protected" virtualness="virtual">
      <type>virtual SoDetail *</type>
      <name>createTriangleDetail</name>
      <anchorfile>classSoShape.html</anchorfile>
      <anchor>a7e62fb1ce714c316cd20c789bbc4d598</anchor>
      <arglist>(SoRayPickAction *action, const SoPrimitiveVertex *v1, const SoPrimitiveVertex *v2, const SoPrimitiveVertex *v3, SoPickedPoint *pp)</arglist>
    </member>
  </compound>
  <compound kind="class">
    <name>SoConeDetail</name>
    <filename>classSoConeDetail.html</filename>
    <base>SoDetail</base>
    <member kind="function" virtualness="virtual">
      <type>virtual SoType</type>
      <name>getTypeId</name>
      <anchorfile>classSoConeDetail.html</anchorfile>
      <anchor>a6b8c8f399291d4aee3a5109acc37a6fd</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type></type>
      <name>SoConeDetail</name>
      <anchorfile>classSoConeDetail.html</anchorfile>
      <anchor>a4d6065d857e82a14d848dc555b2d7023</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~SoConeDetail</name>
      <anchorfile>classSoConeDetail.html</anchorfile>
      <anchor>a2e90a7d984df1d8782b7165e6daa6192</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual SoDetail *</type>
      <name>copy</name>
      <anchorfile>classSoConeDetail.html</anchorfile>
      <anchor>ab2c53c6ec06e72c1206da006b32eeed0</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function">
      <type>void</type>
      <name>setPart</name>
      <anchorfile>classSoConeDetail.html</anchorfile>
      <anchor>ab6c3f74ee6937f7b08acf0f33ab2078a</anchor>
      <arglist>(const int part)</arglist>
    </member>
    <member kind="function">
      <type>int</type>
      <name>getPart</name>
      <anchorfile>classSoConeDetail.html</anchorfile>
      <anchor>a6ddf0ec35e8221562732ce5715527e1e</anchor>
      <arglist>(void) const </arglist>
    </member>
    <member kind="function" virtualness="virtual">
      <type>virtual</type>
      <name>~SoDetail</name>
      <anchorfile>classSoDetail.html</anchorfile>
      <anchor>a7584286c482e7f9ddfce80e2ea02d7fa</anchor>
      <arglist>()</arglist>
    </member>
    <member kind="function">
      <type>SbBool</type>
      <name>isOfType</name>
      <anchorfile>classSoDetail.html</anchorfile>
      <anchor>a176df4de779d768b8c30215e9d97ea29</anchor>
      <arglist>(const SoType type) const </arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>initClass</name>
      <anchorfile>classSoDetail.html</anchorfile>
      <anchor>a7867506c649488dd52b0569d807cbc28</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static void</type>
      <name>initClasses</name>
      <anchorfile>classSoDetail.html</anchorfile>
      <anchor>a54ac808db82da0f072ef8f8aa00181f7</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="function" static="yes">
      <type>static SoType</type>
      <name>getClassTypeId</name>
      <anchorfile>classSoDetail.html</anchorfile>
      <anchor>a73a661514c9e90826d521597121ba491</anchor>
      <arglist>(void)</arglist>
    </member>
    <member kind="variable" protection="protected">
      <type>int</type>
      <name>part</name>
      <anchorfile>classSoConeDetail.html</anchorfile>
      <anchor>a89ae24cd075b24033d6857e2cca1c7fd</anchor>
      <arglist></arglist>
    </member>
    <member kind="function" p