/* certs_test_sm.h */
/* This file was generated using: ./gencertbuf.pl */

#ifndef WOLFSSL_CERTS_TEST_SM_H
#define WOLFSSL_CERTS_TEST_SM_H

#if defined(WOLFSSL_SM2) || defined(WOLFSSL_SM3) || defined(WOLFSSL_SM4)

    /* DER Certs Begin */

/* ./certs/sm2/ca-sm2.der */
static const unsigned char ca_sm2_der[] =
{
        0x30, 0x82, 0x02, 0x96, 0x30, 0x82, 0x02, 0x3C, 0xA0, 0x03,
        0x02, 0x01, 0x02, 0x02, 0x01, 0x01, 0x30, 0x0A, 0x06, 0x08,
        0x2A, 0x81, 0x1C, 0xCF, 0x55, 0x01, 0x83, 0x75, 0x30, 0x81,
        0x95, 0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06,
        0x13, 0x02, 0x55, 0x53, 0x31, 0x10, 0x30, 0x0E, 0x06, 0x03,
        0x55, 0x04, 0x08, 0x0C, 0x07, 0x4D, 0x6F, 0x6E, 0x74, 0x61,
        0x6E, 0x61, 0x31, 0x10, 0x30, 0x0E, 0x06, 0x03, 0x55, 0x04,
        0x07, 0x0C, 0x07, 0x42, 0x6F, 0x7A, 0x65, 0x6D, 0x61, 0x6E,
        0x31, 0x14, 0x30, 0x12, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x0C,
        0x0B, 0x77, 0x6F, 0x6C, 0x66, 0x53, 0x53, 0x4C, 0x5F, 0x53,
        0x4D, 0x32, 0x31, 0x11, 0x30, 0x0F, 0x06, 0x03, 0x55, 0x04,
        0x0B, 0x0C, 0x08, 0x52, 0x6F, 0x6F, 0x74, 0x2D, 0x53, 0x4D,
        0x32, 0x31, 0x18, 0x30, 0x16, 0x06, 0x03, 0x55, 0x04, 0x03,
        0x0C, 0x0F, 0x77, 0x77, 0x77, 0x2E, 0x77, 0x6F, 0x6C, 0x66,
        0x73, 0x73, 0x6C, 0x2E, 0x63, 0x6F, 0x6D, 0x31, 0x1F, 0x30,
        0x1D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01,
        0x09, 0x01, 0x16, 0x10, 0x69, 0x6E, 0x66, 0x6F, 0x40, 0x77,
        0x6F, 0x6C, 0x66, 0x73, 0x73, 0x6C, 0x2E, 0x63, 0x6F, 0x6D,
        0x30, 0x1E, 0x17, 0x0D, 0x32, 0x33, 0x30, 0x32, 0x31, 0x35,
        0x30, 0x36, 0x32, 0x33, 0x30, 0x37, 0x5A, 0x17, 0x0D, 0x32,
        0x35, 0x31, 0x31, 0x31, 0x31, 0x30, 0x36, 0x32, 0x33, 0x30,
        0x37, 0x5A, 0x30, 0x81, 0xAC, 0x31, 0x0B, 0x30, 0x09, 0x06,
        0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x55, 0x53, 0x31, 0x10,
        0x30, 0x0E, 0x06, 0x03, 0x55, 0x04, 0x08, 0x0C, 0x07, 0x4D,
        0x6F, 0x6E, 0x74, 0x61, 0x6E, 0x61, 0x31, 0x10, 0x30, 0x0E,
        0x06, 0x03, 0x55, 0x04, 0x07, 0x0C, 0x07, 0x42, 0x6F, 0x7A,
        0x65, 0x6D, 0x61, 0x6E, 0x31, 0x14, 0x30, 0x12, 0x06, 0x03,
        0x55, 0x04, 0x0A, 0x0C, 0x0B, 0x77, 0x6F, 0x6C, 0x66, 0x53,
        0x53, 0x4C, 0x5F, 0x73, 0x6D, 0x32, 0x31, 0x0F, 0x30, 0x0D,
        0x06, 0x03, 0x55, 0x04, 0x0B, 0x0C, 0x06, 0x43, 0x41, 0x2D,
        0x73, 0x6D, 0x32, 0x31, 0x18, 0x30, 0x16, 0x06, 0x03, 0x55,
        0x04, 0x03, 0x0C, 0x0F, 0x77, 0x77, 0x77, 0x2E, 0x77, 0x6F,
        0x6C, 0x66, 0x73, 0x73, 0x6C, 0x2E, 0x63, 0x6F, 0x6D, 0x31,
        0x1F, 0x30, 0x1D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7,
        0x0D, 0x01, 0x09, 0x01, 0x16, 0x10, 0x69, 0x6E, 0x66, 0x6F,
        0x40, 0x77, 0x6F, 0x6C, 0x66, 0x73, 0x73, 0x6C, 0x2E, 0x63,
        0x6F, 0x6D, 0x31, 0x17, 0x30, 0x15, 0x06, 0x0A, 0x09, 0x92,
        0x26, 0x89, 0x93, 0xF2, 0x2C, 0x64, 0x01, 0x01, 0x0C, 0x07,
        0x77, 0x6F, 0x6C, 0x66, 0x53, 0x53, 0x4C, 0x30, 0x5A, 0x30,
        0x14, 0x06, 0x08, 0x2A, 0x81, 0x1C, 0xCF, 0x55, 0x01, 0x82,
        0x2D, 0x06, 0x08, 0x2A, 0x81, 0x1C, 0xCF, 0x55, 0x01, 0x82,
        0x2D, 0x03, 0x42, 0x00, 0x04, 0x21, 0x92, 0xF7, 0xCB, 0x24,
        0xDF, 0x64, 0x4D, 0xBA, 0xAB, 0x66, 0x7B, 0x83, 0x75, 0xA9,
        0x29, 0xE7, 0xFF, 0x64, 0x63, 0xB6, 0xD5, 0x42, 0x80, 0x20,
        0xBD, 0xE2, 0xE2, 0x02, 0x12, 0x3B, 0x8E, 0xB4, 0x00, 0x95,
        0x09, 0x80, 0xCB, 0x56, 0xED, 0x4B, 0xCA, 0x8D, 0x57, 0xE6,
        0xAE, 0x05, 0xD3, 0x76, 0x27, 0x63, 0x71, 0x39, 0x89, 0xB7,
        0x69, 0xE6, 0x48, 0x80, 0xAE, 0xD1, 0xA9, 0x48, 0x12, 0xA3,
        0x63, 0x30, 0x61, 0x30, 0x1D, 0x06, 0x03, 0x55, 0x1D, 0x0E,
        0x04, 0x16, 0x04, 0x14, 0x47, 0x0A, 0x48, 0x7E, 0xBB, 0x02,
        0xA8, 0x5A, 0x26, 0x57, 0x2B, 0x19, 0xA9, 0x7B, 0x61, 0x8B,
        0x7F, 0x5D, 0x99, 0x6E, 0x30, 0x1F, 0x06, 0x03, 0x55, 0x1D,
        0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x34, 0x1D, 0x79,
        0x44, 0x15, 0x79, 0xA1, 0xB1, 0x63, 0x99, 0xE3, 0xED, 0x65,
        0x7C, 0x64, 0x89, 0x80, 0xFF, 0xB8, 0xEC, 0x30, 0x0F, 0x06,
        0x03, 0x55, 0x1D, 0x13, 0x01, 0x01, 0xFF, 0x04, 0x05, 0x30,
        0x03, 0x01, 0x01, 0xFF, 0x30, 0x0E, 0x06, 0x03, 0x55, 0x1D,
        0x0F, 0x01, 0x01, 0xFF, 0x04, 0x04, 0x03, 0x02, 0x01, 0x86,
        0x30, 0x0A, 0x06, 0x08, 0x2A, 0x81, 0x1C, 0xCF, 0x55, 0x01,
        0x83, 0x75, 0x03, 0x48, 0x00, 0x30, 0x45, 0x02, 0x20, 0x47,
        0x4E, 0x00, 0x03, 0xAB, 0x34, 0xA1, 0xAF, 0x59, 0x39, 0x8F,
        0x60, 0x36, 0xBF, 0x89, 0x88, 0x42, 0x41, 0x27, 0xC1, 0xDD,
        0x57, 0xC9, 0x79, 0xCB, 0x1F, 0x56, 0x5C, 0x16, 0xB5, 0x28,
        0xBD, 0x02, 0x21, 0x00, 0x8B, 0x2E, 0x25, 0xEB, 0x21, 0x9B,
        0xA9, 0x2B, 0xA6, 0x6A, 0x5B, 0xDB, 0xA7, 0xC7, 0x2B, 0x11,
        0xDF, 0x73, 0x15, 0xAD, 0xE4, 0xC5, 0xC3, 0xC2, 0xF3, 0xB4,
        0xB4, 0x67, 0xAF, 0xD7, 0x51, 0x1C
};
#define sizeof_ca_sm2_der (sizeof(ca_sm2_der))

/* ./certs/sm2/ca-sm2-key.der */
static const unsigned char ca_sm2_key_der[] =
{
        0x30, 0x5A, 0x30, 0x14, 0x06, 0x08, 0x2A, 0x81, 0x1C, 0xCF,
        0x55, 0x01, 0x82, 0x2D, 0x06, 0x08, 0x2A, 0x81, 0x1C, 0xCF,
        0x55, 0x01, 0x82, 0x2D, 0x03, 0x42, 0x00, 0x04, 0x21, 0x92,
        0xF7, 0xCB, 0x24, 0xDF, 0x64, 0x4D, 0xBA, 0xAB, 0x66, 0x7B,
        0x83, 0x75, 0xA9, 0x29, 0xE7, 0xFF, 0x64, 0x63, 0xB6, 0xD5,
        0x42, 0x80, 0x20, 0xBD, 0xE2, 0xE2, 0x02, 0x12, 0x3B, 0x8E,
        0xB4, 0x00, 0x95, 0x09, 0x80, 0xCB, 0x56, 0xED, 0x4B, 0xCA,
        0x8D, 0x57, 0xE6, 0xAE, 0x05, 0xD3, 0x76, 0x27, 0x63, 0x71,
        0x39, 0x89, 0xB7, 0x69, 0xE6, 0x48, 0x80, 0xAE, 0xD1, 0xA9,
        0x48, 0x12
};
#define sizeof_ca_sm2_key_der (sizeof(ca_sm2_key_der))

/* ./certs/sm2/ca-sm2-priv.der */
static const unsigned char ca_sm2_priv_der[] =
{
        0x30, 0x77, 0x02, 0x01, 0x01, 0x04, 0x20, 0x8F, 0xB9, 0xB8,
        0x40, 0x19, 0x0E, 0x21, 0x39, 0xEB, 0xE8, 0x08, 0x7C, 0xFD,
        0xD8, 0xA1, 0x05, 0x93, 0xA4, 0x35, 0x2C, 0xD1, 0x80, 0xE3,
        0xBF, 0x7E, 0x48, 0x47, 0xE4, 0x05, 0x0D, 0x09, 0x41, 0xA0,
        0x0A, 0x06, 0x08, 0x2A, 0x81, 0x1C, 0xCF, 0x55, 0x01, 0x82,
        0x2D, 0xA1, 0x44, 0x03, 0x42, 0x00, 0x04, 0x21, 0x92, 0xF7,
        0xCB, 0x24, 0xDF, 0x64, 0x4D, 0xBA, 0xAB, 0x66, 0x7B, 0x83,
        0x75, 0xA9, 0x29, 0xE7, 0xFF, 0x64, 0x63, 0xB6, 0xD5, 0x42,
        0x80, 0x20, 0xBD, 0xE2, 0xE2, 0x02, 0x12, 0x3B, 0x8E, 0xB4,
        0x00, 0x95, 0x09, 0x80, 0xCB, 0x56, 0xED, 0x4B, 0xCA, 0x8D,
        0x57, 0xE6, 0xAE, 0x05, 0xD3, 0x76, 0x27, 0x63, 0x71, 0x39,
        0x89, 0xB7, 0x69, 0xE6, 0x48, 0x80, 0xAE, 0xD1, 0xA9, 0x48,
        0x12
};
#define sizeof_ca_sm2_priv_der (sizeof(ca_sm2_priv_der))

/* ./certs/sm2/client-sm2.der */
static const unsigned char client_sm2_der[] =
{
        0x30, 0x82, 0x03, 0xC9, 0x30, 0x82, 0x03, 0x6E, 0xA0, 0x03,
        0x02, 0x01, 0x02, 0x02, 0x14, 0x60, 0xA0, 0x4A, 0x0B, 0x36,
        0xEB, 0x7D, 0xE1, 0x3F, 0x74, 0x29, 0xA9, 0x29, 0xB4, 0x05,
        0x6C, 0x17, 0xF7, 0xA6, 0xD4, 0x30, 0x0A, 0x06, 0x08, 0x2A,
        0x81, 0x1C, 0xCF, 0x55, 0x01, 0x83, 0x75, 0x30, 0x81, 0xB0,
        0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13,
        0x02, 0x55, 0x53, 0x31, 0x10, 0x30, 0x0E, 0x06, 0x03, 0x55,
        0x04, 0x08, 0x0C, 0x07, 0x4D, 0x6F, 0x6E, 0x74, 0x61, 0x6E,
        0x61, 0x31, 0x10, 0x30, 0x0E, 0x06, 0x03, 0x55, 0x04, 0x07,
        0x0C, 0x07, 0x42, 0x6F, 0x7A, 0x65, 0x6D, 0x61, 0x6E, 0x31,
        0x14, 0x30, 0x12, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x0C, 0x0B,
        0x77, 0x6F, 0x6C, 0x66, 0x53, 0x53, 0x4C, 0x5F, 0x73, 0x6D,
        0x32, 0x31, 0x13, 0x30, 0x11, 0x06, 0x03, 0x55, 0x04, 0x0B,
        0x0C, 0x0A, 0x43, 0x6C, 0x69, 0x65, 0x6E, 0x74, 0x2D, 0x73,
        0x6D, 0x32, 0x31, 0x18, 0x30, 0x16, 0x06, 0x03, 0x55, 0x04,
        0x03, 0x0C, 0x0F, 0x77, 0x77, 0x77, 0x2E, 0x77, 0x6F, 0x6C,
        0x66, 0x73, 0x73, 0x6C, 0x2E, 0x63, 0x6F, 0x6D, 0x31, 0x1F,
        0x30, 0x1D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D,
        0x01, 0x09, 0x01, 0x16, 0x10, 0x69, 0x6E, 0x66, 0x6F, 0x40,
        0x77, 0x6F, 0x6C, 0x66, 0x73, 0x73, 0x6C, 0x2E, 0x63, 0x6F,
        0x6D, 0x31, 0x17, 0x30, 0x15, 0x06, 0x0A, 0x09, 0x92, 0x26,
        0x89, 0x93, 0xF2, 0x2C, 0x64, 0x01, 0x01, 0x0C, 0x07, 0x77,
        0x6F, 0x6C, 0x66, 0x53, 0x53, 0x4C, 0x30, 0x1E, 0x17, 0x0D,
        0x32, 0x33, 0x30, 0x32, 0x31, 0x35, 0x30, 0x36, 0x32, 0x33,
        0x30, 0x37, 0x5A, 0x17, 0x0D, 0x32, 0x35, 0x31, 0x31, 0x31,
        0x31, 0x30, 0x36, 0x32, 0x33, 0x30, 0x37, 0x5A, 0x30, 0x81,
        0xB0, 0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06,
        0x13, 0x02, 0x55, 0x53, 0x31, 0x10, 0x30, 0x0E, 0x06, 0x03,
        0x55, 0x04, 0x08, 0x0C, 0x07, 0x4D, 0x6F, 0x6E, 0x74, 0x61,
        0x6E, 0x61, 0x31, 0x10, 0x30, 0x0E, 0x06, 0x03, 0x55, 0x04,
        0x07, 0x0C, 0x07, 0x42, 0x6F, 0x7A, 0x65, 0x6D, 0x61, 0x6E,
        0x31, 0x14, 0x30, 0x12, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x0C,
        0x0B, 0x77, 0x6F, 0x6C, 0x66, 0x53, 0x53, 0x4C, 0x5F, 0x73,
        0x6D, 0x32, 0x31, 0x13, 0x30, 0x11, 0x06, 0x03, 0x55, 0x04,
        0x0B, 0x0C, 0x0A, 0x43, 0x6C, 0x69, 0x65, 0x6E, 0x74, 0x2D,
        0x73, 0x6D, 0x32, 0x31, 0x18, 0x30, 0x16, 0x06, 0x03, 0x55,
        0x04, 0x03, 0x0C, 0x0F, 0x77, 0x77, 0x77, 0x2E, 0x77, 0x6F,
        0x6C, 0x66, 0x73, 0x73, 0x6C, 0x2E, 0x63, 0x6F, 0x6D, 0x31,
        0x1F, 0x30, 0x1D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7,
        0x0D, 0x01, 0x09, 0x01, 0x16, 0x10, 0x69, 0x6E, 0x66, 0x6F,
        0x40, 0x77, 0x6F, 0x6C, 0x66, 0x73, 0x73, 0x6C, 0x2E, 0x63,
        0x6F, 0x6D, 0x31, 0x17, 0x30, 0x15, 0x06, 0x0A, 0x09, 0x92,
        0x26, 0x89, 0x93, 0xF2, 0x2C, 0x64, 0x01, 0x01, 0x0C, 0x07,
        0x77, 0x6F, 0x6C, 0x66, 0x53, 0x53, 0x4C, 0x30, 0x5A, 0x30,
        0x14, 0x06, 0x08, 0x2A, 0x81, 0x1C, 0xCF, 0x55, 0x01, 0x82,
        0x2D, 0x06, 0x08, 0x2A, 0x81, 0x1C, 0xCF, 0x55, 0x01, 0x82,
        0x2D, 0x03, 0x42, 0x00, 0x04, 0x3A, 0x1D, 0xE8, 0xCB, 0x4B,
        0xD3, 0x2E, 0x3F, 0x4B, 0x07, 0x3F, 0xB0, 0x21, 0xFE, 0xC5,
        0x9E, 0xD9, 0xCA, 0x3A, 0x93, 0x93, 0x95, 0x76, 0x1D, 0x30,
        0xD9, 0x0B, 0xF5, 0x56, 0xED, 0x19, 0x60, 0xED, 0x01, 0x4C,
        0xF6, 0x67, 0x1D, 0xF1, 0xAC, 0xA8, 0x74, 0x0D, 0xB2, 0x77,
        0xC8, 0x49, 0x38, 0xE4, 0xFF, 0x4C, 0xEF, 0x8D, 0x6D, 0x87,
        0xF6, 0x4E, 0xC7, 0xF8, 0x39, 0x74, 0x70, 0x70, 0xB5, 0xA3,
        0x82, 0x01, 0x61, 0x30, 0x82, 0x01, 0x5D, 0x30, 0x1D, 0x06,
        0x03, 0x55, 0x1D, 0x0E, 0x04, 0x16, 0x04, 0x14, 0xE4, 0x21,
        0xB2, 0xC5, 0xE5, 0xD4, 0x9E, 0x82, 0xCA, 0xF8, 0x67, 0xF2,
        0x28, 0x99, 0xF6, 0x85, 0xE8, 0xF1, 0x55, 0xEF, 0x30, 0x81,
        0xF0, 0x06, 0x03, 0x55, 0x1D, 0x23, 0x04, 0x81, 0xE8, 0x30,
        0x81, 0xE5, 0x80, 0x14, 0xE4, 0x21, 0xB2, 0xC5, 0xE5, 0xD4,
        0x9E, 0x82, 0xCA, 0xF8, 0x67, 0xF2, 0x28, 0x99, 0xF6, 0x85,
        0xE8, 0xF1, 0x55, 0xEF, 0xA1, 0x81, 0xB6, 0xA4, 0x81, 0xB3,
        0x30, 0x81, 0xB0, 0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 0x55,
        0x04, 0x06, 0x13, 0x02, 0x55, 0x53, 0x31, 0x10, 0x30, 0x0E,
        0x06, 0x03, 0x55, 0x04, 0x08, 0x0C, 0x07, 0x4D, 0x6F, 0x6E,
        0x74, 0x61, 0x6E, 0x61, 0x31, 0x10, 0x30, 0x0E, 0x06, 0x03,
        0x55, 0x04, 0x07, 0x0C, 0x07, 0x42, 0x6F, 0x7A, 0x65, 0x6D,
        0x61, 0x6E, 0x31, 0x14, 0x30, 0x12, 0x06, 0x03, 0x55, 0x04,
        0x0A, 0x0C, 0x0B, 0x77, 0x6F, 0x6C, 0x66, 0x53, 0x53, 0x4C,
        0x5F, 0x73, 0x6D, 0x32, 0x31, 0x13, 0x30, 0x11, 0x06, 0x03,
        0x55, 0x04, 0x0B, 0x0C, 0x0A, 0x43, 0x6C, 0x69, 0x65, 0x6E,
        0x74, 0x2D, 0x73, 0x6D, 0x32, 0x31, 0x18, 0x30, 0x16, 0x06,
        0x03, 0x55, 0x04, 0x03, 0x0C, 0x0F, 0x77, 0x77, 0x77, 0x2E,
        0x77, 0x6F, 0x6C, 0x66, 0x73, 0x73, 0x6C, 0x2E, 0x63, 0x6F,
        0x6D, 0x31, 0x1F, 0x30, 0x1D, 0x06, 0x09, 0x2A, 0x86, 0x48,
        0x86, 0xF7, 0x0D, 0x01, 0x09, 0x01, 0x16, 0x10, 0x69, 0x6E,
        0x66, 0x6F, 0x40, 0x77, 0x6F, 0x6C, 0x66, 0x73, 0x73, 0x6C,
        0x2E, 0x63, 0x6F, 0x6D, 0x31, 0x17, 0x30, 0x15, 0x06, 0x0A,
        0x09, 0x92, 0x26, 0x89, 0x93, 0xF2, 0x2C, 0x64, 0x01, 0x01,
        0x0C, 0x07, 0x77, 0x6F, 0x6C, 0x66, 0x53, 0x53, 0x4C, 0x82,
        0x14, 0x60, 0xA0, 0x4A, 0x0B, 0x36, 0xEB, 0x7D, 0xE1, 0x3F,
        0x74, 0x29, 0xA9, 0x29, 0xB4, 0x05, 0x6C, 0x17, 0xF7, 0xA6,
        0xD4, 0x30, 0x0C, 0x06, 0x03, 0x55, 0x1D, 0x13, 0x04, 0x05,
        0x30, 0x03, 0x01, 0x01, 0xFF, 0x30, 0x1C, 0x06, 0x03, 0x55,
        0x1D, 0x11, 0x04, 0x15, 0x30, 0x13, 0x82, 0x0B, 0x65, 0x78,
        0x61, 0x6D, 0x70, 0x6C, 0x65, 0x2E, 0x63, 0x6F, 0x6D, 0x87,
        0x04, 0x7F, 0x00, 0x00, 0x01, 0x30, 0x1D, 0x06, 0x03, 0x55,
        0x1D, 0x25, 0x04, 0x16, 0x30, 0x14, 0x06, 0x08, 0x2B, 0x06,
        0x01, 0x05, 0x05, 0x07, 0x03, 0x01, 0x06, 0x08, 0x2B, 0x06,
        0x01, 0x05, 0x05, 0x07, 0x03, 0x02, 0x30, 0x0A, 0x06, 0x08,
        0x2A, 0x81, 0x1C, 0xCF, 0x55, 0x01, 0x83, 0x75, 0x03, 0x49,
        0x00, 0x30, 0x46, 0x02, 0x21, 0x00, 0x8F, 0xB2, 0xB5, 0x95,
        0x8F, 0x79, 0xF6, 0x5E, 0x75, 0xE5, 0xC5, 0xE9, 0x9A, 0x12,
        0xD2, 0x0F, 0x78, 0x9F, 0xC0, 0x1D, 0x8D, 0x1C, 0xBE, 0x6B,
        0x0C, 0xF1, 0xF5, 0x57, 0x60, 0xDB, 0x91, 0x4F, 0x02, 0x21,
        0x00, 0x87, 0x5E, 0x7D, 0xE4, 0xD6, 0x3A, 0xBB, 0x7B, 0x98,
        0x27, 0x85, 0xDE, 0x7A, 0xF0, 0x21, 0xE2, 0x66, 0xA1, 0x9F,
        0x26, 0xE0, 0xDD, 0x86, 0x23, 0xB4, 0xC8, 0xC0, 0x46, 0x5A,
        0xF2, 0x49, 0x8D
};
#define sizeof_client_sm2_der (sizeof(client_sm2_der))

/* ./certs/sm2/client-sm2-key.der */
static const unsigned char client_sm2_key_der[] =
{
        0x30, 0x5A, 0x30, 0x14, 0x06, 0x08, 0x2A, 0x81, 0x1C, 0xCF,
        0x55, 0x01, 0x82, 0x2D, 0x06, 0x08, 0x2A, 0x81, 0x1C, 0xCF,
        0x55, 0x01, 0x82, 0x2D, 0x03, 0x42, 0x00, 0x04, 0x3A, 0x1D,
        0xE8, 0xCB, 0x4B, 0xD3, 0x2E, 0x3F, 0x4B, 0x07, 0x3F, 0xB0,
        0x21, 0xFE, 0xC5, 0x9E, 0xD9, 0xCA, 0x3A, 0x93, 0x93, 0x95,
        0x76, 0x1D, 0x30, 0xD9, 0x0B, 0xF5, 0x56, 0xED, 0x19, 0x60,
        0xED, 0x01, 0x4C, 0xF6, 0x67, 0x1D, 0xF1, 0xAC, 0xA8, 0x74,
        0x0D, 0xB2, 0x77, 0xC8, 0x49, 0x38, 0xE4, 0xFF, 0x4C, 0xEF,
        0x8D, 0x6D, 0x87, 0xF6, 0x4E, 0xC7, 0xF8, 0x39, 0x74, 0x70,
        0x70, 0xB5
};
#define sizeof_client_sm2_key_der (sizeof(client_sm2_key_der))

/* ./certs/sm2/client-sm2-priv.der */
static const unsigned char client_sm2_priv_der[] =
{
        0x30, 0x77, 0x02, 0x01, 0x01, 0x04, 0x20, 0xD0, 0xA2, 0xDF,
        0x49, 0x7A, 0x2D, 0xDF, 0x02, 0xC9, 0xCE, 0xB7, 0xF2, 0x37,
        0x02, 0x0D, 0xDD, 0xFC, 0x08, 0xB8, 0xDE, 0x14, 0x93, 0x7A,
        0x53, 0x26, 0x49, 0xD5, 0xFE, 0x02, 0xD9, 0xF3, 0x71, 0xA0,
        0x0A, 0x06, 0x08, 0x2A, 0x81, 0x1C, 0xCF, 0x55, 0x01, 0x82,
        0x2D, 0xA1, 0x44, 0x03, 0x42, 0x00, 0x04, 0x3A, 0x1D, 0xE8,
        0xCB, 0x4B, 0xD3, 0x2E, 0x3F, 0x4B, 0x07, 0x3F, 0xB0, 0x21,
        0xFE, 0xC5, 0x9E, 0xD9, 0xCA, 0x3A, 0x93, 0x93, 0x95, 0x76,
        0x1D, 0x30, 0xD9, 0x0B, 0xF5, 0x56, 0xED, 0x19, 0x60, 0xED,
        0x01, 0x4C, 0xF6, 0x67, 0x1D, 0xF1, 0xAC, 0xA8, 0x74, 0x0D,
        0xB2, 0x77, 0xC8, 0x49, 0x38, 0xE4, 0xFF, 0x4C, 0xEF, 0x8D,
        0x6D, 0x87, 0xF6, 0x4E, 0xC7, 0xF8, 0x39, 0x74, 0x70, 0x70,
        0xB5
};
#define sizeof_client_sm2_priv_der (sizeof(client_sm2_priv_der))

/* ./certs/sm2/root-sm2.der */
static const unsigned char root_sm2_der[] =
{
        0x30, 0x82, 0x02, 0x91, 0x30, 0x82, 0x02, 0x38, 0xA0, 0x03,
        0x02, 0x01, 0x02, 0x02, 0x14, 0x74, 0x9C, 0xDD, 0xA4, 0xB2,
        0x67, 0x26, 0x57, 0x29, 0xFB, 0xE9, 0x13, 0x54, 0xE0, 0x34,
        0x08, 0x03, 0x2B, 0x70, 0xA9, 0x30, 0x0A, 0x06, 0x08, 0x2A,
        0x81, 0x1C, 0xCF, 0x55, 0x01, 0x83, 0x75, 0x30, 0x81, 0x95,
        0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13,
        0x02, 0x55, 0x53, 0x31, 0x10, 0x30, 0x0E, 0x06, 0x03, 0x55,
        0x04, 0x08, 0x0C, 0x07, 0x4D, 0x6F, 0x6E, 0x74, 0x61, 0x6E,
        0x61, 0x31, 0x10, 0x30, 0x0E, 0x06, 0x03, 0x55, 0x04, 0x07,
        0x0C, 0x07, 0x42, 0x6F, 0x7A, 0x65, 0x6D, 0x61, 0x6E, 0x31,
        0x14, 0x30, 0x12, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x0C, 0x0B,
        0x77, 0x6F, 0x6C, 0x66, 0x53, 0x53, 0x4C, 0x5F, 0x53, 0x4D,
        0x32, 0x31, 0x11, 0x30, 0x0F, 0x06, 0x03, 0x55, 0x04, 0x0B,
        0x0C, 0x08, 0x52, 0x6F, 0x6F, 0x74, 0x2D, 0x53, 0x4D, 0x32,
        0x31, 0x18, 0x30, 0x16, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0C,
        0x0F, 0x77, 0x77, 0x77, 0x2E, 0x77, 0x6F, 0x6C, 0x66, 0x73,
        0x73, 0x6C, 0x2E, 0x63, 0x6F, 0x6D, 0x31, 0x1F, 0x30, 0x1D,
        0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x09,
        0x01, 0x16, 0x10, 0x69, 0x6E, 0x66, 0x6F, 0x40, 0x77, 0x6F,
        0x6C, 0x66, 0x73, 0x73, 0x6C, 0x2E, 0x63, 0x6F, 0x6D, 0x30,
        0x1E, 0x17, 0x0D, 0x32, 0x33, 0x30, 0x32, 0x31, 0x35, 0x30,
        0x36, 0x32, 0x33, 0x30, 0x37, 0x5A, 0x17, 0x0D, 0x32, 0x35,
        0x31, 0x31, 0x31, 0x31, 0x30, 0x36, 0x32, 0x33, 0x30, 0x37,
        0x5A, 0x30, 0x81, 0x95, 0x31, 0x0B, 0x30, 0x09, 0x06, 0x03,
        0x55, 0x04, 0x06, 0x13, 0x02, 0x55, 0x53, 0x31, 0x10, 0x30,
        0x0E, 0x06, 0x03, 0x55, 0x04, 0x08, 0x0C, 0x07, 0x4D, 0x6F,
        0x6E, 0x74, 0x61, 0x6E, 0x61, 0x31, 0x10, 0x30, 0x0E, 0x06,
        0x03, 0x55, 0x04, 0x07, 0x0C, 0x07, 0x42, 0x6F, 0x7A, 0x65,
        0x6D, 0x61, 0x6E, 0x31, 0x14, 0x30, 0x12, 0x06, 0x03, 0x55,
        0x04, 0x0A, 0x0C, 0x0B, 0x77, 0x6F, 0x6C, 0x66, 0x53, 0x53,
        0x4C, 0x5F, 0x53, 0x4D, 0x32, 0x31, 0x11, 0x30, 0x0F, 0x06,
        0x03, 0x55, 0x04, 0x0B, 0x0C, 0x08, 0x52, 0x6F, 0x6F, 0x74,
        0x2D, 0x53, 0x4D, 0x32, 0x31, 0x18, 0x30, 0x16, 0x06, 0x03,
        0x55, 0x04, 0x03, 0x0C, 0x0F, 0x77, 0x77, 0x77, 0x2E, 0x77,
        0x6F, 0x6C, 0x66, 0x73, 0x73, 0x6C, 0x2E, 0x63, 0x6F, 0x6D,
        0x31, 0x1F, 0x30, 0x1D, 0x06, 0x09, 0x2A, 0x86, 0x48, 0x86,
        0xF7, 0x0D, 0x01, 0x09, 0x01, 0x16, 0x10, 0x69, 0x6E, 0x66,
        0x6F, 0x40, 0x77, 0x6F, 0x6C, 0x66, 0x73, 0x73, 0x6C, 0x2E,
        0x63, 0x6F, 0x6D, 0x30, 0x5A, 0x30, 0x14, 0x06, 0x08, 0x2A,
        0x81, 0x1C, 0xCF, 0x55, 0x01, 0x82, 0x2D, 0x06, 0x08, 0x2A,
        0x81, 0x1C, 0xCF, 0x55, 0x01, 0x82, 0x2D, 0x03, 0x42, 0x00,
        0x04, 0xBB, 0x9C, 0x75, 0x8C, 0xF7, 0x17, 0xF8, 0x48, 0xAB,
        0xF7, 0xF6, 0xDB, 0x0D, 0x9A, 0x8D, 0x9F, 0xC2, 0xD1, 0x47,
        0x97, 0x95, 0x0B, 0x4E, 0xE6, 0x57, 0xEC, 0xC5, 0xF8, 0x57,
        0x54, 0x71, 0x39, 0x3C, 0x79, 0xE1, 0x40, 0x3F, 0xB6, 0x51,
        0xE9, 0x7C, 0xC7, 0xDA, 0x2D, 0xEF, 0xD2, 0xE8, 0x79, 0x81,
        0x7B, 0xAB, 0xA3, 0x5F, 0x6B, 0x2A, 0x6C, 0x97, 0x1A, 0x5E,
        0x8E, 0xD9, 0xD0, 0xCC, 0x04, 0xA3, 0x63, 0x30, 0x61, 0x30,
        0x1D, 0x06, 0x03, 0x55, 0x1D, 0x0E, 0x04, 0x16, 0x04, 0x14,
        0x34, 0x1D, 0x79, 0x44, 0x15, 0x79, 0xA1, 0xB1, 0x63, 0x99,
        0xE3, 0xED, 0x65, 0x7C, 0x64, 0x89, 0x80, 0xFF, 0xB8, 0xEC,
        0x30, 0x1F, 0x06, 0x03, 0x55, 0x1D, 0x23, 0x04, 0x18, 0x30,
        0x16, 0x80, 0x14, 0x34, 0x1D, 0x79, 0x44, 0x15, 0x79, 0xA1,
        0xB1, 0x63, 0x99, 0xE3, 0xED, 0x65, 0x7C, 0x64, 0x89, 0x80,
        0xFF, 0xB8, 0xEC, 0x30, 0x0F, 0x06, 0x03, 0x55, 0x1D, 0x13,
        0x01, 0x01, 0xFF, 0x04, 0x05, 0x30, 0x03, 0x01, 0x01, 0xFF,
        0x30, 0x0E, 0x06, 0x03, 0x55, 0x1D, 0x0F, 0x01, 0x01, 0xFF,
        0x04, 0x04, 0x03, 0x02, 0x01, 0x86, 0x30, 0x0A, 0x06, 0x08,
        0x2A, 0x81, 0x1C, 0xCF, 0x55, 0x01, 0x83, 0x75, 0x03, 0x47,
        0x00, 0x30, 0x44, 0x02, 0x20, 0x03, 0x27, 0x29, 0xF0, 0xEF,
        0x78, 0x26, 0xA1, 0x1A, 0x6A, 0x1E, 0x88, 0x81, 0xE7, 0x83,
        0x72, 0x5F, 0x3E, 0xE6, 0x08, 0xE8, 0x14, 0x68, 0xBF, 0x4B,
        0x0F, 0x68, 0x52, 0x92, 0xAA, 0x8F, 0xA1, 0x02, 0x20, 0x0B,
        0xFE, 0x1B, 0x14, 0xBA, 0x51, 0x82, 0x65, 0x06, 0xBB, 0x22,
        0xD8, 0x1A, 0xA7, 0x9F, 0x54, 0x62, 0xEB, 0x8D, 0xB2, 0xD5,
        0x13, 0xB3, 0xB8, 0xA2, 0xF3, 0x14, 0x44, 0xB2, 0xA0, 0x21,
        0xD0
};
#define sizeof_root_sm2_der (sizeof(root_sm2_der))

/* ./certs/sm2/root-sm2-key.der */
static const unsigned char root_sm2_key_der[] =
{
        0x30, 0x5A, 0x30, 0x14, 0x06, 0x08, 0x2A, 0x81, 0x1C, 0xCF,
        0x55, 0x01, 0x82, 0x2D, 0x06, 0x08, 0x2A, 0x81, 0x1C, 0xCF,
        0x55, 0x01, 0x82, 0x2D, 0x03, 0x42, 0x00, 0x04, 0xBB, 0x9C,
        0x75, 0x8C, 0xF7, 0x17, 0xF8, 0x48, 0xAB, 0xF7, 0xF6, 0xDB,
        0x0D, 0x9A, 0x8D, 0x9F, 0xC2, 0xD1, 0x47, 0x97, 0x95, 0x0B,
        0x4E, 0xE6, 0x57, 0xEC, 0xC5, 0xF8, 0x57, 0x54, 0x71, 0x39,
        0x3C, 0x79, 0xE1, 0x40, 0x3F, 0xB6, 0x51, 0xE9, 0x7C, 0xC7,
        0xDA, 0x2D, 0xEF, 0xD2, 0xE8, 0x79, 0x81, 0x7B, 0xAB, 0xA3,
        0x5F, 0x6B, 0x2A, 0x6C, 0x97, 0x1A, 0x5E, 0x8E, 0xD9, 0xD0,
        0xCC, 0x04
};
#define sizeof_root_sm2_key_der (sizeof(root_sm2_key_der))

/* ./certs/sm2/root-sm2-priv.der */
static const unsigned char root_sm2_priv_der[] =
{
        0x30, 0x77, 0x02, 0x01, 0x01, 0x04, 0x20, 0xC6, 0x6B, 0x34,
        0x4C, 0x33, 0x37, 0x5B, 0x64, 0x16, 0x5A, 0x7F, 0x04, 0xF9,
        0xFC, 0x87, 0x30, 0xD1, 0x15, 0xBA, 0x58, 0x78, 0xEE, 0x07,
        0x98, 0x20, 0x26, 0xE1, 0x06, 0x8D, 0x51, 0x8A, 0x28, 0xA0,
        0x0A, 0x06, 0x08, 0x2A, 0x81, 0x1C, 0xCF, 0x55, 0x01, 0x82,
        0x2D, 0xA1, 0x44, 0x03, 0x42, 0x00, 0x04, 0xBB, 0x9C, 0x75,
        0x8C, 0xF7, 0x17, 0xF8, 0x48, 0xAB, 0xF7, 0xF6, 0xDB, 0x0D,
        0x9A, 0x8D, 0x9F, 0xC2, 0xD1, 0x47, 0x97, 0x95, 0x0B, 0x4E,
        0xE6, 0x57, 0xEC, 0xC5, 0xF8, 0x57, 0x54, 0x71, 0x39, 0x3C,
        0x79, 0xE1, 0x40, 0x3F, 0xB6, 0x51, 0xE9, 0x7C, 0xC7, 0xDA,
        0x2D, 0xEF, 0xD2, 0xE8, 0x79, 0x81, 0x7B, 0xAB, 0xA3, 0x5F,
        0x6B, 0x2A, 0x6C, 0x97, 0x1A, 0x5E, 0x8E, 0xD9, 0xD0, 0xCC,
        0x04
};
#define sizeof_root_sm2_priv_der (sizeof(root_sm2_priv_der))

/* ./certs/sm2/server-sm2.der */
static const unsigned char server_sm2_der[] =
{
        0x30, 0x82, 0x02, 0xD8, 0x30, 0x82, 0x02, 0x7E, 0xA0, 0x03,
        0x02, 0x01, 0x02, 0x02, 0x01, 0x01, 0x30, 0x0A, 0x06, 0x08,
        0x2A, 0x81, 0x1C, 0xCF, 0x55, 0x01, 0x83, 0x75, 0x30, 0x81,
        0xAC, 0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06,
        0x13, 0x02, 0x55, 0x53, 0x31, 0x10, 0x30, 0x0E, 0x06, 0x03,
        0x55, 0x04, 0x08, 0x0C, 0x07, 0x4D, 0x6F, 0x6E, 0x74, 0x61,
        0x6E, 0x61, 0x31, 0x10, 0x30, 0x0E, 0x06, 0x03, 0x55, 0x04,
        0x07, 0x0C, 0x07, 0x42, 0x6F, 0x7A, 0x65, 0x6D, 0x61, 0x6E,
        0x31, 0x14, 0x30, 0x12, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x0C,
        0x0B, 0x77, 0x6F, 0x6C, 0x66, 0x53, 0x53, 0x4C, 0x5F, 0x73,
        0x6D, 0x32, 0x31, 0x0F, 0x30, 0x0D, 0x06, 0x03, 0x55, 0x04,
        0x0B, 0x0C, 0x06, 0x43, 0x41, 0x2D, 0x73, 0x6D, 0x32, 0x31,
        0x18, 0x30, 0x16, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0C, 0x0F,
        0x77, 0x77, 0x77, 0x2E, 0x77, 0x6F, 0x6C, 0x66, 0x73, 0x73,
        0x6C, 0x2E, 0x63, 0x6F, 0x6D, 0x31, 0x1F, 0x30, 0x1D, 0x06,
        0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x09, 0x01,
        0x16, 0x10, 0x69, 0x6E, 0x66, 0x6F, 0x40, 0x77, 0x6F, 0x6C,
        0x66, 0x73, 0x73, 0x6C, 0x2E, 0x63, 0x6F, 0x6D, 0x31, 0x17,
        0x30, 0x15, 0x06, 0x0A, 0x09, 0x92, 0x26, 0x89, 0x93, 0xF2,
        0x2C, 0x64, 0x01, 0x01, 0x0C, 0x07, 0x77, 0x6F, 0x6C, 0x66,
        0x53, 0x53, 0x4C, 0x30, 0x1E, 0x17, 0x0D, 0x32, 0x33, 0x30,
        0x32, 0x31, 0x35, 0x30, 0x36, 0x32, 0x33, 0x30, 0x37, 0x5A,
        0x17, 0x0D, 0x32, 0x35, 0x31, 0x31, 0x31, 0x31, 0x30, 0x36,
        0x32, 0x33, 0x30, 0x37, 0x5A, 0x30, 0x81, 0xB0, 0x31, 0x0B,
        0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x55,
        0x53, 0x31, 0x10, 0x30, 0x0E, 0x06, 0x03, 0x55, 0x04, 0x08,
        0x0C, 0x07, 0x4D, 0x6F, 0x6E, 0x74, 0x61, 0x6E, 0x61, 0x31,
        0x10, 0x30, 0x0E, 0x06, 0x03, 0x55, 0x04, 0x07, 0x0C, 0x07,
        0x42, 0x6F, 0x7A, 0x65, 0x6D, 0x61, 0x6E, 0x31, 0x14, 0x30,
        0x12, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x0C, 0x0B, 0x77, 0x6F,
        0x6C, 0x66, 0x53, 0x53, 0x4C, 0x5F, 0x73, 0x6D, 0x32, 0x31,
        0x13, 0x30, 0x11, 0x06, 0x03, 0x55, 0x04, 0x0B, 0x0C, 0x0A,
        0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x2D, 0x73, 0x6D, 0x32,
        0x31, 0x18, 0x30, 0x16, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0C,
        0x0F, 0x77, 0x77, 0x77, 0x2E, 0x77, 0x6F, 0x6C, 0x66, 0x73,
        0x73, 0x6C, 0x2E, 0x63, 0x6F, 0x6D, 0x31, 0x1F, 0x30, 0x1D,
        0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x09,
        0x01, 0x16, 0x10, 0x69, 0x6E, 0x66, 0x6F, 0x40, 0x77, 0x6F,
        0x6C, 0x66, 0x73, 0x73, 0x6C, 0x2E, 0x63, 0x6F, 0x6D, 0x31,
        0x17, 0x30, 0x15, 0x06, 0x0A, 0x09, 0x92, 0x26, 0x89, 0x93,
        0xF2, 0x2C, 0x64, 0x01, 0x01, 0x0C, 0x07, 0x77, 0x6F, 0x6C,
        0x66, 0x53, 0x53, 0x4C, 0x30, 0x5A, 0x30, 0x14, 0x06, 0x08,
        0x2A, 0x81, 0x1C, 0xCF, 0x55, 0x01, 0x82, 0x2D, 0x06, 0x08,
        0x2A, 0x81, 0x1C, 0xCF, 0x55, 0x01, 0x82, 0x2D, 0x03, 0x42,
        0x00, 0x04, 0x94, 0x70, 0x2B, 0x46, 0xE4, 0x5E, 0x0F, 0x41,
        0xFB, 0x8F, 0x2D, 0x34, 0x0A, 0x41, 0x40, 0x19, 0x5E, 0xFB,
        0xD4, 0x1D, 0x11, 0xAC, 0xFA, 0xF5, 0x93, 0x37, 0xC6, 0xFA,
        0x87, 0x08, 0xF7, 0x16, 0x1F, 0x2C, 0xCE, 0x30, 0x40, 0x9D,
        0x4F, 0xA6, 0x2A, 0x0A, 0xA1, 0xD6, 0x95, 0x33, 0xC3, 0xA6,
        0x03, 0x98, 0xE6, 0x8D, 0x05, 0x34, 0xB0, 0x97, 0x0C, 0xDE,
        0xA4, 0xC7, 0xCF, 0x53, 0x8F, 0xD1, 0xA3, 0x81, 0x89, 0x30,
        0x81, 0x86, 0x30, 0x1D, 0x06, 0x03, 0x55, 0x1D, 0x0E, 0x04,
        0x16, 0x04, 0x14, 0x67, 0xAE, 0x60, 0xFF, 0x7E, 0x1B, 0x0F,
        0x95, 0xAE, 0x1F, 0x82, 0x59, 0xF2, 0x6C, 0x56, 0x2D, 0x93,
        0xEF, 0x17, 0x32, 0x30, 0x1F, 0x06, 0x03, 0x55, 0x1D, 0x23,
        0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x47, 0x0A, 0x48, 0x7E,
        0xBB, 0x02, 0xA8, 0x5A, 0x26, 0x57, 0x2B, 0x19, 0xA9, 0x7B,
        0x61, 0x8B, 0x7F, 0x5D, 0x99, 0x6E, 0x30, 0x0C, 0x06, 0x03,
        0x55, 0x1D, 0x13, 0x01, 0x01, 0xFF, 0x04, 0x02, 0x30, 0x00,
        0x30, 0x0E, 0x06, 0x03, 0x55, 0x1D, 0x0F, 0x01, 0x01, 0xFF,
        0x04, 0x04, 0x03, 0x02, 0x03, 0xA8, 0x30, 0x13, 0x06, 0x03,
        0x55, 0x1D, 0x25, 0x04, 0x0C, 0x30, 0x0A, 0x06, 0x08, 0x2B,
        0x06, 0x01, 0x05, 0x05, 0x07, 0x03, 0x01, 0x30, 0x11, 0x06,
        0x09, 0x60, 0x86, 0x48, 0x01, 0x86, 0xF8, 0x42, 0x01, 0x01,
        0x04, 0x04, 0x03, 0x02, 0x06, 0x40, 0x30, 0x0A, 0x06, 0x08,
        0x2A, 0x81, 0x1C, 0xCF, 0x55, 0x01, 0x83, 0x75, 0x03, 0x48,
        0x00, 0x30, 0x45, 0x02, 0x20, 0x1B, 0xCA, 0x94, 0x28, 0x7F,
        0xF6, 0xB2, 0x0D, 0x31, 0x43, 0x50, 0xE1, 0xD5, 0x34, 0x17,
        0xDD, 0xAF, 0x3A, 0xDE, 0x81, 0x06, 0x67, 0x9A, 0xB3, 0x06,
        0x22, 0x7E, 0x64, 0xEC, 0xFD, 0x0E, 0xB9, 0x02, 0x21, 0x00,
        0xA1, 0x48, 0xA8, 0x32, 0xD1, 0x05, 0x09, 0x6B, 0x1C, 0xEB,
        0x89, 0x12, 0x66, 0xD8, 0x38, 0xA1, 0xC4, 0x5C, 0x89, 0x09,
        0x0F, 0xFD, 0xE9, 0xC0, 0x3B, 0x1D, 0xFB, 0xCD, 0xB5, 0x4C,
        0x31, 0x68
};
#define sizeof_server_sm2_der (sizeof(server_sm2_der))

/* ./certs/sm2/server-sm2-cert.der */
static const unsigned char server_sm2_cert_der[] =
{
        0x30, 0x82, 0x02, 0xD8, 0x30, 0x82, 0x02, 0x7E, 0xA0, 0x03,
        0x02, 0x01, 0x02, 0x02, 0x01, 0x01, 0x30, 0x0A, 0x06, 0x08,
        0x2A, 0x81, 0x1C, 0xCF, 0x55, 0x01, 0x83, 0x75, 0x30, 0x81,
        0xAC, 0x31, 0x0B, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06,
        0x13, 0x02, 0x55, 0x53, 0x31, 0x10, 0x30, 0x0E, 0x06, 0x03,
        0x55, 0x04, 0x08, 0x0C, 0x07, 0x4D, 0x6F, 0x6E, 0x74, 0x61,
        0x6E, 0x61, 0x31, 0x10, 0x30, 0x0E, 0x06, 0x03, 0x55, 0x04,
        0x07, 0x0C, 0x07, 0x42, 0x6F, 0x7A, 0x65, 0x6D, 0x61, 0x6E,
        0x31, 0x14, 0x30, 0x12, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x0C,
        0x0B, 0x77, 0x6F, 0x6C, 0x66, 0x53, 0x53, 0x4C, 0x5F, 0x73,
        0x6D, 0x32, 0x31, 0x0F, 0x30, 0x0D, 0x06, 0x03, 0x55, 0x04,
        0x0B, 0x0C, 0x06, 0x43, 0x41, 0x2D, 0x73, 0x6D, 0x32, 0x31,
        0x18, 0x30, 0x16, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0C, 0x0F,
        0x77, 0x77, 0x77, 0x2E, 0x77, 0x6F, 0x6C, 0x66, 0x73, 0x73,
        0x6C, 0x2E, 0x63, 0x6F, 0x6D, 0x31, 0x1F, 0x30, 0x1D, 0x06,
        0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x09, 0x01,
        0x16, 0x10, 0x69, 0x6E, 0x66, 0x6F, 0x40, 0x77, 0x6F, 0x6C,
        0x66, 0x73, 0x73, 0x6C, 0x2E, 0x63, 0x6F, 0x6D, 0x31, 0x17,
        0x30, 0x15, 0x06, 0x0A, 0x09, 0x92, 0x26, 0x89, 0x93, 0xF2,
        0x2C, 0x64, 0x01, 0x01, 0x0C, 0x07, 0x77, 0x6F, 0x6C, 0x66,
        0x53, 0x53, 0x4C, 0x30, 0x1E, 0x17, 0x0D, 0x32, 0x33, 0x30,
        0x32, 0x31, 0x35, 0x30, 0x36, 0x32, 0x33, 0x30, 0x37, 0x5A,
        0x17, 0x0D, 0x32, 0x35, 0x31, 0x31, 0x31, 0x31, 0x30, 0x36,
        0x32, 0x33, 0x30, 0x37, 0x5A, 0x30, 0x81, 0xB0, 0x31, 0x0B,
        0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x55,
        0x53, 0x31, 0x10, 0x30, 0x0E, 0x06, 0x03, 0x55, 0x04, 0x08,
        0x0C, 0x07, 0x4D, 0x6F, 0x6E, 0x74, 0x61, 0x6E, 0x61, 0x31,
        0x10, 0x30, 0x0E, 0x06, 0x03, 0x55, 0x04, 0x07, 0x0C, 0x07,
        0x42, 0x6F, 0x7A, 0x65, 0x6D, 0x61, 0x6E, 0x31, 0x14, 0x30,
        0x12, 0x06, 0x03, 0x55, 0x04, 0x0A, 0x0C, 0x0B, 0x77, 0x6F,
        0x6C, 0x66, 0x53, 0x53, 0x4C, 0x5F, 0x73, 0x6D, 0x32, 0x31,
        0x13, 0x30, 0x11, 0x06, 0x03, 0x55, 0x04, 0x0B, 0x0C, 0x0A,
        0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x2D, 0x73, 0x6D, 0x32,
        0x31, 0x18, 0x30, 0x16, 0x06, 0x03, 0x55, 0x04, 0x03, 0x0C,
        0x0F, 0x77, 0x77, 0x77, 0x2E, 0x77, 0x6F, 0x6C, 0x66, 0x73,
        0x73, 0x6C, 0x2E, 0x63, 0x6F, 0x6D, 0x31, 0x1F, 0x30, 0x1D,
        0x06, 0x09, 0x2A, 0x86, 0x48, 0x86, 0xF7, 0x0D, 0x01, 0x09,
        0x01, 0x16, 0x10, 0x69, 0x6E, 0x66, 0x6F, 0x40, 0x77, 0x6F,
        0x6C, 0x66, 0x73, 0x73, 0x6C, 0x2E, 0x63, 0x6F, 0x6D, 0x31,
        0x17, 0x30, 0x15, 0x06, 0x0A, 0x09, 0x92, 0x26, 0x89, 0x93,
        0xF2, 0x2C, 0x64, 0x01, 0x01, 0x0C, 0x07, 0x77, 0x6F, 0x6C,
        0x66, 0x53, 0x53, 0x4C, 0x30, 0x5A, 0x30, 0x14, 0x06, 0x08,
        0x2A, 0x81, 0x1C, 0xCF, 0x55, 0x01, 0x82, 0x2D, 0x06, 0x08,
        0x2A, 0x81, 0x1C, 0xCF, 0x55, 0x01, 0x82, 0x2D, 0x03, 0x42,
        0x00, 0x04, 0x94, 0x70, 0x2B, 0x46, 0xE4, 0x5E, 0x0F, 0x41,
        0xFB, 0x8F, 0x2D, 0x34, 0x0A, 0x41, 0x40, 0x19, 0x5E, 0xFB,
        0xD4, 0x1D, 0x11, 0xAC, 0xFA, 0xF5, 0x93, 0x37, 0xC6, 0xFA,
        0x87, 0x08, 0xF7, 0x16, 0x1F, 0x2C, 0xCE, 0x30, 0x40, 0x9D,
        0x4F, 0xA6, 0x2A, 0x0A, 0xA1, 0xD6, 0x95, 0x33, 0xC3, 0xA6,
        0x03, 0x98, 0xE6, 0x8D, 0x05, 0x34, 0xB0, 0x97, 0x0C, 0xDE,
        0xA4, 0xC7, 0xCF, 0x53, 0x8F, 0xD1, 0xA3, 0x81, 0x89, 0x30,
        0x81, 0x86, 0x30, 0x1D, 0x06, 0x03, 0x55, 0x1D, 0x0E, 0x04,
        0x16, 0x04, 0x14, 0x67, 0xAE, 0x60, 0xFF, 0x7E, 0x1B, 0x0F,
        0x95, 0xAE, 0x1F, 0x82, 0x59, 0xF2, 0x6C, 0x56, 0x2D, 0x93,
        0xEF, 0x17, 0x32, 0x30, 0x1F, 0x06, 0x03, 0x55, 0x1D, 0x23,
        0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x47, 0x0A, 0x48, 0x7E,
        0xBB, 0x02, 0xA8, 0x5A, 0x26, 0x57, 0x2B, 0x19, 0xA9, 0x7B,
        0x61, 0x8B, 0x7F, 0x5D, 0x99, 0x6E, 0x30, 0x0C, 0x06, 0x03,
        0x55, 0x1D, 0x13, 0x01, 0x01, 0xFF, 0x04, 0x02, 0x30, 0x00,
        0x30, 0x0E, 0x06, 0x03, 0x55, 0x1D, 0x0F, 0x01, 0x01, 0xFF,
        0x04, 0x04, 0x03, 0x02, 0x03, 0xA8, 0x30, 0x13, 0x06, 0x03,
        0x55, 0x1D, 0x25, 0x04, 0x0C, 0x30, 0x0A, 0x06, 0x08, 0x2B,
        0x06, 0x01, 0x05, 0x05, 0x07, 0x03, 0x01, 0x30, 0x11, 0x06,
        0x09, 0x60, 0x86, 0x48, 0x01, 0x86, 0xF8, 0x42, 0x01, 0x01,
        0x04, 0x04, 0x03, 0x02, 0x06, 0x40, 0x30, 0x0A, 0x06, 0x08,
        0x2A, 0x81, 0x1C, 0xCF, 0x55, 0x01, 0x83, 0x75, 0x03, 0x48,
        0x00, 0x30, 0x45, 0x02, 0x20, 0x1B, 0xCA, 0x94, 0x28, 0x7F,
        0xF6, 0xB2, 0x0D, 0x31, 0x43, 0x50, 0xE1, 0xD5, 0x34, 0x17,
        0xDD, 0xAF, 0x3A, 0xDE, 0x81, 0x06, 0x67, 0x9A, 0xB3, 0x06,
        0x22, 0x7E, 0x64, 0xEC, 0xFD, 0x0E, 0xB9, 0x02, 0x21, 0x00,
        0xA1, 0x48, 0xA8, 0x32, 0xD1, 0x05, 0x09, 0x6B, 0x1C, 0xEB,
        0x89, 0x12, 0x66, 0xD8, 0x38, 0xA1, 0xC4, 0x5C, 0x89, 0x09,
        0x0F, 0xFD, 0xE9, 0xC0, 0x3B, 0x1D, 0xFB, 0xCD, 0xB5, 0x4C,
        0x31, 0x68
};
#define sizeof_server_sm2_cert_der (sizeof(server_sm2_cert_der))

/* ./certs/sm2/server-sm2-key.der */
static const unsigned char server_sm2_key_der[] =
{
        0x30, 0x5A, 0x30, 0x14, 0x06, 0x08, 0x2A, 0x81, 0x1C, 0xCF,
        0x55, 0x01, 0x82, 0x2D, 0x06, 0x08, 0x2A, 0x81, 0x1C, 0xCF,
        0x55, 0x01, 0x82, 0x2D, 0x03, 0x42, 0x00, 0x04, 0x94, 0x70,
        0x2B, 0x46, 0xE4, 0x5E, 0x0F, 0x41, 0xFB, 0x8F, 0x2D, 0x34,
        0x0A, 0x41, 0x40, 0x19, 0x5E, 0xFB, 0xD4, 0x1D, 0x11, 0xAC,
        0xFA, 0xF5, 0x93, 0x37, 0xC6, 0xFA, 0x87, 0x08, 0xF7, 0x16,
        0x1F, 0x2C, 0xCE, 0x30, 0x40, 0x9D, 0x4F, 0xA6, 0x2A, 0x0A,
        0xA1, 0xD6, 0x95, 0x33, 0xC3, 0xA6, 0x03, 0x98, 0xE6, 0x8D,
        0x05, 0x34, 0xB0, 0x97, 0x0C, 0xDE, 0xA4, 0xC7, 0xCF, 0x53,
        0x8F, 0xD1
};
#define sizeof_server_sm2_key_der (sizeof(server_sm2_key_der))

/* ./certs/sm2/server-sm2-priv.der */
static const unsigned char server_sm2_priv_der[] =
{
        0x30, 0x77, 0x02, 0x01, 0x01, 0x04, 0x20, 0xD7, 0x33, 0xC1,
        0xA1, 0x71, 0x98, 0xDA, 0x43, 0x81, 0x0D, 0x70, 0x42, 0x88,
        0x63, 0xD0, 0x4C, 0x7E, 0x0F, 0x8A, 0x9B, 0x2D, 0xDA, 0x15,
        0xAA, 0x0E, 0x5A, 0xFA, 0xED, 0x77, 0x3A, 0x43, 0xA8, 0xA0,
        0x0A, 0x06, 0x08, 0x2A, 0x81, 0x1C, 0xCF, 0x55, 0x01, 0x82,
        0x2D, 0xA1, 0x44, 0x03, 0x42, 0x00, 0x04, 0x94, 0x70, 0x2B,
        0x46, 0xE4, 0x5E, 0x0F, 0x41, 0xFB, 0x8F, 0x2D, 0x34, 0x0A,
        0x41, 0x40, 0x19, 0x5E, 0xFB, 0xD4, 0x1D, 0x11, 0xAC, 0xFA,
        0xF5, 0x93, 0x37, 0xC6, 0xFA, 0x87, 0x08, 0xF7, 0x16, 0x1F,
        0x2C, 0xCE, 0x30, 0x40, 0x9D, 0x4F, 0xA6, 0x2A, 0x0A, 0xA1,
        0xD6, 0x95, 0x33, 0xC3, 0xA6, 0x03, 0x98, 0xE6, 0x8D, 0x05,
        0x34, 0xB0, 0x97, 0x0C, 0xDE, 0xA4, 0xC7, 0xCF, 0x53, 0x8F,
        0xD1
};
#define sizeof_server_sm2_priv_der (sizeof(server_sm2_priv_der))

    /* DER Certs End */

#ifdef WOLFSSL_NO_PEM

    /* SM PEM Certs disabled */

#else

/* ./certs/sm2/ca-sm2.pem */
static const unsigned char ca_sm2[] =
{
        0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
        0x65, 0x3A, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x44, 0x61, 0x74,
        0x61, 0x3A, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6F, 0x6E, 0x3A, 0x20,
        0x33, 0x20, 0x28, 0x30, 0x78, 0x32, 0x29, 0x0A, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x53, 0x65, 0x72, 0x69,
        0x61, 0x6C, 0x20, 0x4E, 0x75, 0x6D, 0x62, 0x65, 0x72, 0x3A,
        0x20, 0x31, 0x20, 0x28, 0x30, 0x78, 0x31, 0x29, 0x0A, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x53, 0x69, 0x67,
        0x6E, 0x61, 0x74, 0x75, 0x72, 0x65, 0x20, 0x41, 0x6C, 0x67,
        0x6F, 0x72, 0x69, 0x74, 0x68, 0x6D, 0x3A, 0x20, 0x53, 0x4D,
        0x32, 0x2D, 0x77, 0x69, 0x74, 0x68, 0x2D, 0x53, 0x4D, 0x33,
        0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x49,
        0x73, 0x73, 0x75, 0x65, 0x72, 0x3A, 0x20, 0x43, 0x20, 0x3D,
        0x20, 0x55, 0x53, 0x2C, 0x20, 0x53, 0x54, 0x20, 0x3D, 0x20,
        0x4D, 0x6F, 0x6E, 0x74, 0x61, 0x6E, 0x61, 0x2C, 0x20, 0x4C,
        0x20, 0x3D, 0x20, 0x42, 0x6F, 0x7A, 0x65, 0x6D, 0x61, 0x6E,
        0x2C, 0x20, 0x4F, 0x20, 0x3D, 0x20, 0x77, 0x6F, 0x6C, 0x66,
        0x53, 0x53, 0x4C, 0x5F, 0x53, 0x4D, 0x32, 0x2C, 0x20, 0x4F,
        0x55, 0x20, 0x3D, 0x20, 0x52, 0x6F, 0x6F, 0x74, 0x2D, 0x53,
        0x4D, 0x32, 0x2C, 0x20, 0x43, 0x4E, 0x20, 0x3D, 0x20, 0x77,
        0x77, 0x77, 0x2E, 0x77, 0x6F, 0x6C, 0x66, 0x73, 0x73, 0x6C,
        0x2E, 0x63, 0x6F, 0x6D, 0x2C, 0x20, 0x65, 0x6D, 0x61, 0x69,
        0x6C, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x20, 0x3D,
        0x20, 0x69, 0x6E, 0x66, 0x6F, 0x40, 0x77, 0x6F, 0x6C, 0x66,
        0x73, 0x73, 0x6C, 0x2E, 0x63, 0x6F, 0x6D, 0x0A, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x56, 0x61, 0x6C, 0x69,
        0x64, 0x69, 0x74, 0x79, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x4E, 0x6F, 0x74,
        0x20, 0x42, 0x65, 0x66, 0x6F, 0x72, 0x65, 0x3A, 0x20, 0x46,
        0x65, 0x62, 0x20, 0x31, 0x35, 0x20, 0x30, 0x36, 0x3A, 0x32,
        0x33, 0x3A, 0x30, 0x37, 0x20, 0x32, 0x30, 0x32, 0x33, 0x20,
        0x47, 0x4D, 0x54, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x4E, 0x6F, 0x74, 0x20,
        0x41, 0x66, 0x74, 0x65, 0x72, 0x20, 0x3A, 0x20, 0x4E, 0x6F,
        0x76, 0x20, 0x31, 0x31, 0x20, 0x30, 0x36, 0x3A, 0x32, 0x33,
        0x3A, 0x30, 0x37, 0x20, 0x32, 0x30, 0x32, 0x35, 0x20, 0x47,
        0x4D, 0x54, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x53, 0x75, 0x62, 0x6A, 0x65, 0x63, 0x74, 0x3A, 0x20,
        0x43, 0x20, 0x3D, 0x20, 0x55, 0x53, 0x2C, 0x20, 0x53, 0x54,
        0x20, 0x3D, 0x20, 0x4D, 0x6F, 0x6E, 0x74, 0x61, 0x6E, 0x61,
        0x2C, 0x20, 0x4C, 0x20, 0x3D, 0x20, 0x42, 0x6F, 0x7A, 0x65,
        0x6D, 0x61, 0x6E, 0x2C, 0x20, 0x4F, 0x20, 0x3D, 0x20, 0x77,
        0x6F, 0x6C, 0x66, 0x53, 0x53, 0x4C, 0x5F, 0x73, 0x6D, 0x32,
        0x2C, 0x20, 0x4F, 0x55, 0x20, 0x3D, 0x20, 0x43, 0x41, 0x2D,
        0x73, 0x6D, 0x32, 0x2C, 0x20, 0x43, 0x4E, 0x20, 0x3D, 0x20,
        0x77, 0x77, 0x77, 0x2E, 0x77, 0x6F, 0x6C, 0x66, 0x73, 0x73,
        0x6C, 0x2E, 0x63, 0x6F, 0x6D, 0x2C, 0x20, 0x65, 0x6D, 0x61,
        0x69, 0x6C, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x20,
        0x3D, 0x20, 0x69, 0x6E, 0x66, 0x6F, 0x40, 0x77, 0x6F, 0x6C,
        0x66, 0x73, 0x73, 0x6C, 0x2E, 0x63, 0x6F, 0x6D, 0x2C, 0x20,
        0x55, 0x49, 0x44, 0x20, 0x3D, 0x20, 0x77, 0x6F, 0x6C, 0x66,
        0x53, 0x53, 0x4C, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x53, 0x75, 0x62, 0x6A, 0x65, 0x63, 0x74, 0x20,
        0x50, 0x75, 0x62, 0x6C, 0x69, 0x63, 0x20, 0x4B, 0x65, 0x79,
        0x20, 0x49, 0x6E, 0x66, 0x6F, 0x3A, 0x0A, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x50,
        0x75, 0x62, 0x6C, 0x69, 0x63, 0x20, 0x4B, 0x65, 0x79, 0x20,
        0x41, 0x6C, 0x67, 0x6F, 0x72, 0x69, 0x74, 0x68, 0x6D, 0x3A,
        0x20, 0x73, 0x6D, 0x32, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x50, 0x75, 0x62, 0x6C, 0x69, 0x63, 0x2D, 0x4B, 0x65,
        0x79, 0x3A, 0x20, 0x28, 0x32, 0x35, 0x36, 0x20, 0x62, 0x69,
        0x74, 0x29, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x70,
        0x75, 0x62, 0x3A, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x30, 0x34, 0x3A, 0x32, 0x31, 0x3A,
        0x39, 0x32, 0x3A, 0x66, 0x37, 0x3A, 0x63, 0x62, 0x3A, 0x32,
        0x34, 0x3A, 0x64, 0x66, 0x3A, 0x36, 0x34, 0x3A, 0x34, 0x64,
        0x3A, 0x62, 0x61, 0x3A, 0x61, 0x62, 0x3A, 0x36, 0x36, 0x3A,
        0x37, 0x62, 0x3A, 0x38, 0x33, 0x3A, 0x37, 0x35, 0x3A, 0x0A,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x61, 0x39, 0x3A, 0x32, 0x39, 0x3A, 0x65, 0x37, 0x3A, 0x66,
        0x66, 0x3A, 0x36, 0x34, 0x3A, 0x36, 0x33, 0x3A, 0x62, 0x36,
        0x3A, 0x64, 0x35, 0x3A, 0x34, 0x32, 0x3A, 0x38, 0x30, 0x3A,
        0x32, 0x30, 0x3A, 0x62, 0x64, 0x3A, 0x65, 0x32, 0x3A, 0x65,
        0x32, 0x3A, 0x30, 0x32, 0x3A, 0x0A, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x31, 0x32, 0x3A, 0x33,
        0x62, 0x3A, 0x38, 0x65, 0x3A, 0x62, 0x34, 0x3A, 0x30, 0x30,
        0x3A, 0x39, 0x35, 0x3A, 0x30, 0x39, 0x3A, 0x38, 0x30, 0x3A,
        0x63, 0x62, 0x3A, 0x35, 0x36, 0x3A, 0x65, 0x64, 0x3A, 0x34,
        0x62, 0x3A, 0x63, 0x61, 0x3A, 0x38, 0x64, 0x3A, 0x35, 0x37,
        0x3A, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x65, 0x36, 0x3A, 0x61, 0x65, 0x3A, 0x30, 0x35,
        0x3A, 0x64, 0x33, 0x3A, 0x37, 0x36, 0x3A, 0x32, 0x37, 0x3A,
        0x36, 0x33, 0x3A, 0x37, 0x31, 0x3A, 0x33, 0x39, 0x3A, 0x38,
        0x39, 0x3A, 0x62, 0x37, 0x3A, 0x36, 0x39, 0x3A, 0x65, 0x36,
        0x3A, 0x34, 0x38, 0x3A, 0x38, 0x30, 0x3A, 0x0A, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x61, 0x65,
        0x3A, 0x64, 0x31, 0x3A, 0x61, 0x39, 0x3A, 0x34, 0x38, 0x3A,
        0x31, 0x32, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x41,
        0x53, 0x4E, 0x31, 0x20, 0x4F, 0x49, 0x44, 0x3A, 0x20, 0x53,
        0x4D, 0x32, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x58, 0x35, 0x30, 0x39, 0x76, 0x33, 0x20, 0x65, 0x78,
        0x74, 0x65, 0x6E, 0x73, 0x69, 0x6F, 0x6E, 0x73, 0x3A, 0x0A,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x58, 0x35, 0x30, 0x39, 0x76, 0x33, 0x20, 0x53,
        0x75, 0x62, 0x6A, 0x65, 0x63, 0x74, 0x20, 0x4B, 0x65, 0x79,
        0x20, 0x49, 0x64, 0x65, 0x6E, 0x74, 0x69, 0x66, 0x69, 0x65,
        0x72, 0x3A, 0x20, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x34, 0x37, 0x3A, 0x30, 0x41, 0x3A, 0x34, 0x38, 0x3A, 0x37,
        0x45, 0x3A, 0x42, 0x42, 0x3A, 0x30, 0x32, 0x3A, 0x41, 0x38,
        0x3A, 0x35, 0x41, 0x3A, 0x32, 0x36, 0x3A, 0x35, 0x37, 0x3A,
        0x32, 0x42, 0x3A, 0x31, 0x39, 0x3A, 0x41, 0x39, 0x3A, 0x37,
        0x42, 0x3A, 0x36, 0x31, 0x3A, 0x38, 0x42, 0x3A, 0x37, 0x46,
        0x3A, 0x35, 0x44, 0x3A, 0x39, 0x39, 0x3A, 0x36, 0x45, 0x0A,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x58, 0x35, 0x30, 0x39, 0x76, 0x33, 0x20, 0x41,
        0x75, 0x74, 0x68, 0x6F, 0x72, 0x69, 0x74, 0x79, 0x20, 0x4B,
        0x65, 0x79, 0x20, 0x49, 0x64, 0x65, 0x6E, 0x74, 0x69, 0x66,
        0x69, 0x65, 0x72, 0x3A, 0x20, 0x0A, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x33, 0x34, 0x3A, 0x31, 0x44, 0x3A, 0x37, 0x39,
        0x3A, 0x34, 0x34, 0x3A, 0x31, 0x35, 0x3A, 0x37, 0x39, 0x3A,
        0x41, 0x31, 0x3A, 0x42, 0x31, 0x3A, 0x36, 0x33, 0x3A, 0x39,
        0x39, 0x3A, 0x45, 0x33, 0x3A, 0x45, 0x44, 0x3A, 0x36, 0x35,
        0x3A, 0x37, 0x43, 0x3A, 0x36, 0x34, 0x3A, 0x38, 0x39, 0x3A,
        0x38, 0x30, 0x3A, 0x46, 0x46, 0x3A, 0x42, 0x38, 0x3A, 0x45,
        0x43, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x58, 0x35, 0x30, 0x39, 0x76, 0x33,
        0x20, 0x42, 0x61, 0x73, 0x69, 0x63, 0x20, 0x43, 0x6F, 0x6E,
        0x73, 0x74, 0x72, 0x61, 0x69, 0x6E, 0x74, 0x73, 0x3A, 0x20,
        0x63, 0x72, 0x69, 0x74, 0x69, 0x63, 0x61, 0x6C, 0x0A, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x43, 0x41, 0x3A, 0x54, 0x52,
        0x55, 0x45, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x58, 0x35, 0x30, 0x39, 0x76,
        0x33, 0x20, 0x4B, 0x65, 0x79, 0x20, 0x55, 0x73, 0x61, 0x67,
        0x65, 0x3A, 0x20, 0x63, 0x72, 0x69, 0x74, 0x69, 0x63, 0x61,
        0x6C, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x44, 0x69,
        0x67, 0x69, 0x74, 0x61, 0x6C, 0x20, 0x53, 0x69, 0x67, 0x6E,
        0x61, 0x74, 0x75, 0x72, 0x65, 0x2C, 0x20, 0x43, 0x65, 0x72,
        0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x20, 0x53,
        0x69, 0x67, 0x6E, 0x2C, 0x20, 0x43, 0x52, 0x4C, 0x20, 0x53,
        0x69, 0x67, 0x6E, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x53, 0x69,
        0x67, 0x6E, 0x61, 0x74, 0x75, 0x72, 0x65, 0x20, 0x41, 0x6C,
        0x67, 0x6F, 0x72, 0x69, 0x74, 0x68, 0x6D, 0x3A, 0x20, 0x53,
        0x4D, 0x32, 0x2D, 0x77, 0x69, 0x74, 0x68, 0x2D, 0x53, 0x4D,
        0x33, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x53, 0x69, 0x67, 0x6E,
        0x61, 0x74, 0x75, 0x72, 0x65, 0x20, 0x56, 0x61, 0x6C, 0x75,
        0x65, 0x3A, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x33, 0x30, 0x3A, 0x34, 0x35, 0x3A, 0x30, 0x32, 0x3A,
        0x32, 0x30, 0x3A, 0x34, 0x37, 0x3A, 0x34, 0x65, 0x3A, 0x30,
        0x30, 0x3A, 0x30, 0x33, 0x3A, 0x61, 0x62, 0x3A, 0x33, 0x34,
        0x3A, 0x61, 0x31, 0x3A, 0x61, 0x66, 0x3A, 0x35, 0x39, 0x3A,
        0x33, 0x39, 0x3A, 0x38, 0x66, 0x3A, 0x36, 0x30, 0x3A, 0x33,
        0x36, 0x3A, 0x62, 0x66, 0x3A, 0x0A, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x38, 0x39, 0x3A, 0x38, 0x38, 0x3A,
        0x34, 0x32, 0x3A, 0x34, 0x31, 0x3A, 0x32, 0x37, 0x3A, 0x63,
        0x31, 0x3A, 0x64, 0x64, 0x3A, 0x35, 0x37, 0x3A, 0x63, 0x39,
        0x3A, 0x37, 0x39, 0x3A, 0x63, 0x62, 0x3A, 0x31, 0x66, 0x3A,
        0x35, 0x36, 0x3A, 0x35, 0x63, 0x3A, 0x31, 0x36, 0x3A, 0x62,
        0x35, 0x3A, 0x32, 0x38, 0x3A, 0x62, 0x64, 0x3A, 0x0A, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x30, 0x32, 0x3A,
        0x32, 0x31, 0x3A, 0x30, 0x30, 0x3A, 0x38, 0x62, 0x3A, 0x32,
        0x65, 0x3A, 0x32, 0x35, 0x3A, 0x65, 0x62, 0x3A, 0x32, 0x31,
        0x3A, 0x39, 0x62, 0x3A, 0x61, 0x39, 0x3A, 0x32, 0x62, 0x3A,
        0x61, 0x36, 0x3A, 0x36, 0x61, 0x3A, 0x35, 0x62, 0x3A, 0x64,
        0x62, 0x3A, 0x61, 0x37, 0x3A, 0x63, 0x37, 0x3A, 0x32, 0x62,
        0x3A, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x31, 0x31, 0x3A, 0x64, 0x66, 0x3A, 0x37, 0x33, 0x3A, 0x31,
        0x35, 0x3A, 0x61, 0x64, 0x3A, 0x65, 0x34, 0x3A, 0x63, 0x35,
        0x3A, 0x63, 0x33, 0x3A, 0x63, 0x32, 0x3A, 0x66, 0x33, 0x3A,
        0x62, 0x34, 0x3A, 0x62, 0x34, 0x3A, 0x36, 0x37, 0x3A, 0x61,
        0x66, 0x3A, 0x64, 0x37, 0x3A, 0x35, 0x31, 0x3A, 0x31, 0x63,
        0x0A, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x42, 0x45, 0x47, 0x49,
        0x4E, 0x20, 0x43, 0x45, 0x52, 0x54, 0x49, 0x46, 0x49, 0x43,
        0x41, 0x54, 0x45, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x0A, 0x4D,
        0x49, 0x49, 0x43, 0x6C, 0x6A, 0x43, 0x43, 0x41, 0x6A, 0x79,
        0x67, 0x41, 0x77, 0x49, 0x42, 0x41, 0x67, 0x49, 0x42, 0x41,
        0x54, 0x41, 0x4B, 0x42, 0x67, 0x67, 0x71, 0x67, 0x52, 0x7A,
        0x50, 0x56, 0x51, 0x47, 0x44, 0x64, 0x54, 0x43, 0x42, 0x6C,
        0x54, 0x45, 0x4C, 0x4D, 0x41, 0x6B, 0x47, 0x41, 0x31, 0x55,
        0x45, 0x42, 0x68, 0x4D, 0x43, 0x56, 0x56, 0x4D, 0x78, 0x45,
        0x44, 0x41, 0x4F, 0x0A, 0x42, 0x67, 0x4E, 0x56, 0x42, 0x41,
        0x67, 0x4D, 0x42, 0x30, 0x31, 0x76, 0x62, 0x6E, 0x52, 0x68,
        0x62, 0x6D, 0x45, 0x78, 0x45, 0x44, 0x41, 0x4F, 0x42, 0x67,
        0x4E, 0x56, 0x42, 0x41, 0x63, 0x4D, 0x42, 0x30, 0x4A, 0x76,
        0x65, 0x6D, 0x56, 0x74, 0x59, 0x57, 0x34, 0x78, 0x46, 0x44,
        0x41, 0x53, 0x42, 0x67, 0x4E, 0x56, 0x42, 0x41, 0x6F, 0x4D,
        0x43, 0x33, 0x64, 0x76, 0x62, 0x47, 0x5A, 0x54, 0x0A, 0x55,
        0x30, 0x78, 0x66, 0x55, 0x30, 0x30, 0x79, 0x4D, 0x52, 0x45,
        0x77, 0x44, 0x77, 0x59, 0x44, 0x56, 0x51, 0x51, 0x4C, 0x44,
        0x41, 0x68, 0x53, 0x62, 0x32, 0x39, 0x30, 0x4C, 0x56, 0x4E,
        0x4E, 0x4D, 0x6A, 0x45, 0x59, 0x4D, 0x42, 0x59, 0x47, 0x41,
        0x31, 0x55, 0x45, 0x41, 0x77, 0x77, 0x50, 0x64, 0x33, 0x64,
        0x33, 0x4C, 0x6E, 0x64, 0x76, 0x62, 0x47, 0x5A, 0x7A, 0x63,
        0x32, 0x77, 0x75, 0x0A, 0x59, 0x32, 0x39, 0x74, 0x4D, 0x52,
        0x38, 0x77, 0x48, 0x51, 0x59, 0x4A, 0x4B, 0x6F, 0x5A, 0x49,
        0x68, 0x76, 0x63, 0x4E, 0x41, 0x51, 0x6B, 0x42, 0x46, 0x68,
        0x42, 0x70, 0x62, 0x6D, 0x5A, 0x76, 0x51, 0x48, 0x64, 0x76,
        0x62, 0x47, 0x5A, 0x7A, 0x63, 0x32, 0x77, 0x75, 0x59, 0x32,
        0x39, 0x74, 0x4D, 0x42, 0x34, 0x58, 0x44, 0x54, 0x49, 0x7A,
        0x4D, 0x44, 0x49, 0x78, 0x4E, 0x54, 0x41, 0x32, 0x0A, 0x4D,
        0x6A, 0x4D, 0x77, 0x4E, 0x31, 0x6F, 0x58, 0x44, 0x54, 0x49,
        0x31, 0x4D, 0x54, 0x45, 0x78, 0x4D, 0x54, 0x41, 0x32, 0x4D,
        0x6A, 0x4D, 0x77, 0x4E, 0x31, 0x6F, 0x77, 0x67, 0x61, 0x77,
        0x78, 0x43, 0x7A, 0x41, 0x4A, 0x42, 0x67, 0x4E, 0x56, 0x42,
        0x41, 0x59, 0x54, 0x41, 0x6C, 0x56, 0x54, 0x4D, 0x52, 0x41,
        0x77, 0x44, 0x67, 0x59, 0x44, 0x56, 0x51, 0x51, 0x49, 0x44,
        0x41, 0x64, 0x4E, 0x0A, 0x62, 0x32, 0x35, 0x30, 0x59, 0x57,
        0x35, 0x68, 0x4D, 0x52, 0x41, 0x77, 0x44, 0x67, 0x59, 0x44,
        0x56, 0x51, 0x51, 0x48, 0x44, 0x41, 0x64, 0x43, 0x62, 0x33,
        0x70, 0x6C, 0x62, 0x57, 0x46, 0x75, 0x4D, 0x52, 0x51, 0x77,
        0x45, 0x67, 0x59, 0x44, 0x56, 0x51, 0x51, 0x4B, 0x44, 0x41,
        0x74, 0x33, 0x62, 0x32, 0x78, 0x6D, 0x55, 0x31, 0x4E, 0x4D,
        0x58, 0x33, 0x4E, 0x74, 0x4D, 0x6A, 0x45, 0x50, 0x0A, 0x4D,
        0x41, 0x30, 0x47, 0x41, 0x31, 0x55, 0x45, 0x43, 0x77, 0x77,
        0x47, 0x51, 0x30, 0x45, 0x74, 0x63, 0x32, 0x30, 0x79, 0x4D,
        0x52, 0x67, 0x77, 0x46, 0x67, 0x59, 0x44, 0x56, 0x51, 0x51,
        0x44, 0x44, 0x41, 0x39, 0x33, 0x64, 0x33, 0x63, 0x75, 0x64,
        0x32, 0x39, 0x73, 0x5A, 0x6E, 0x4E, 0x7A, 0x62, 0x43, 0x35,
        0x6A, 0x62, 0x32, 0x30, 0x78, 0x48, 0x7A, 0x41, 0x64, 0x42,
        0x67, 0x6B, 0x71, 0x0A, 0x68, 0x6B, 0x69, 0x47, 0x39, 0x77,
        0x30, 0x42, 0x43, 0x51, 0x45, 0x57, 0x45, 0x47, 0x6C, 0x75,
        0x5A, 0x6D, 0x39, 0x41, 0x64, 0x32, 0x39, 0x73, 0x5A, 0x6E,
        0x4E, 0x7A, 0x62, 0x43, 0x35, 0x6A, 0x62, 0x32, 0x30, 0x78,
        0x46, 0x7A, 0x41, 0x56, 0x42, 0x67, 0x6F, 0x4A, 0x6B, 0x69,
        0x61, 0x4A, 0x6B, 0x2F, 0x49, 0x73, 0x5A, 0x41, 0x45, 0x42,
        0x44, 0x41, 0x64, 0x33, 0x62, 0x32, 0x78, 0x6D, 0x0A, 0x55,
        0x31, 0x4E, 0x4D, 0x4D, 0x46, 0x6F, 0x77, 0x46, 0x41, 0x59,
        0x49, 0x4B, 0x6F, 0x45, 0x63, 0x7A, 0x31, 0x55, 0x42, 0x67,
        0x69, 0x30, 0x47, 0x43, 0x43, 0x71, 0x42, 0x48, 0x4D, 0x39,
        0x56, 0x41, 0x59, 0x49, 0x74, 0x41, 0x30, 0x49, 0x41, 0x42,
        0x43, 0x47, 0x53, 0x39, 0x38, 0x73, 0x6B, 0x33, 0x32, 0x52,
        0x4E, 0x75, 0x71, 0x74, 0x6D, 0x65, 0x34, 0x4E, 0x31, 0x71,
        0x53, 0x6E, 0x6E, 0x0A, 0x2F, 0x32, 0x52, 0x6A, 0x74, 0x74,
        0x56, 0x43, 0x67, 0x43, 0x43, 0x39, 0x34, 0x75, 0x49, 0x43,
        0x45, 0x6A, 0x75, 0x4F, 0x74, 0x41, 0x43, 0x56, 0x43, 0x59,
        0x44, 0x4C, 0x56, 0x75, 0x31, 0x4C, 0x79, 0x6F, 0x31, 0x58,
        0x35, 0x71, 0x34, 0x46, 0x30, 0x33, 0x59, 0x6E, 0x59, 0x33,
        0x45, 0x35, 0x69, 0x62, 0x64, 0x70, 0x35, 0x6B, 0x69, 0x41,
        0x72, 0x74, 0x47, 0x70, 0x53, 0x42, 0x4B, 0x6A, 0x0A, 0x59,
        0x7A, 0x42, 0x68, 0x4D, 0x42, 0x30, 0x47, 0x41, 0x31, 0x55,
        0x64, 0x44, 0x67, 0x51, 0x57, 0x42, 0x42, 0x52, 0x48, 0x43,
        0x6B, 0x68, 0x2B, 0x75, 0x77, 0x4B, 0x6F, 0x57, 0x69, 0x5A,
        0x58, 0x4B, 0x78, 0x6D, 0x70, 0x65, 0x32, 0x47, 0x4C, 0x66,
        0x31, 0x32, 0x5A, 0x62, 0x6A, 0x41, 0x66, 0x42, 0x67, 0x4E,
        0x56, 0x48, 0x53, 0x4D, 0x45, 0x47, 0x44, 0x41, 0x57, 0x67,
        0x42, 0x51, 0x30, 0x0A, 0x48, 0x58, 0x6C, 0x45, 0x46, 0x58,
        0x6D, 0x68, 0x73, 0x57, 0x4F, 0x5A, 0x34, 0x2B, 0x31, 0x6C,
        0x66, 0x47, 0x53, 0x4A, 0x67, 0x50, 0x2B, 0x34, 0x37, 0x44,
        0x41, 0x50, 0x42, 0x67, 0x4E, 0x56, 0x48, 0x52, 0x4D, 0x42,
        0x41, 0x66, 0x38, 0x45, 0x42, 0x54, 0x41, 0x44, 0x41, 0x51,
        0x48, 0x2F, 0x4D, 0x41, 0x34, 0x47, 0x41, 0x31, 0x55, 0x64,
        0x44, 0x77, 0x45, 0x42, 0x2F, 0x77, 0x51, 0x45, 0x0A, 0x41,
        0x77, 0x49, 0x42, 0x68, 0x6A, 0x41, 0x4B, 0x42, 0x67, 0x67,
        0x71, 0x67, 0x52, 0x7A, 0x50, 0x56, 0x51, 0x47, 0x44, 0x64,
        0x51, 0x4E, 0x49, 0x41, 0x44, 0x42, 0x46, 0x41, 0x69, 0x42,
        0x48, 0x54, 0x67, 0x41, 0x44, 0x71, 0x7A, 0x53, 0x68, 0x72,
        0x31, 0x6B, 0x35, 0x6A, 0x32, 0x41, 0x32, 0x76, 0x34, 0x6D,
        0x49, 0x51, 0x6B, 0x45, 0x6E, 0x77, 0x64, 0x31, 0x58, 0x79,
        0x58, 0x6E, 0x4C, 0x0A, 0x48, 0x31, 0x5A, 0x63, 0x46, 0x72,
        0x55, 0x6F, 0x76, 0x51, 0x49, 0x68, 0x41, 0x49, 0x73, 0x75,
        0x4A, 0x65, 0x73, 0x68, 0x6D, 0x36, 0x6B, 0x72, 0x70, 0x6D,
        0x70, 0x62, 0x32, 0x36, 0x66, 0x48, 0x4B, 0x78, 0x48, 0x66,
        0x63, 0x78, 0x57, 0x74, 0x35, 0x4D, 0x58, 0x44, 0x77, 0x76,
        0x4F, 0x30, 0x74, 0x47, 0x65, 0x76, 0x31, 0x31, 0x45, 0x63,
        0x0A, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x45, 0x4E, 0x44, 0x20,
        0x43, 0x45, 0x52, 0x54, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54,
        0x45, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x0A
};
#define sizeof_ca_sm2 (sizeof(ca_sm2))

/* ./certs/sm2/ca-sm2-key.pem */
static const unsigned char ca_sm2_key[] =
{
        0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x42, 0x45, 0x47, 0x49, 0x4E,
        0x20, 0x50, 0x55, 0x42, 0x4C, 0x49, 0x43, 0x20, 0x4B, 0x45,
        0x59, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x0A, 0x4D, 0x46, 0x6F,
        0x77, 0x46, 0x41, 0x59, 0x49, 0x4B, 0x6F, 0x45, 0x63, 0x7A,
        0x31, 0x55, 0x42, 0x67, 0x69, 0x30, 0x47, 0x43, 0x43, 0x71,
        0x42, 0x48, 0x4D, 0x39, 0x56, 0x41, 0x59, 0x49, 0x74, 0x41,
        0x30, 0x49, 0x41, 0x42, 0x43, 0x47, 0x53, 0x39, 0x38, 0x73,
        0x6B, 0x33, 0x32, 0x52, 0x4E, 0x75, 0x71, 0x74, 0x6D, 0x65,
        0x34, 0x4E, 0x31, 0x71, 0x53, 0x6E, 0x6E, 0x2F, 0x32, 0x52,
        0x6A, 0x0A, 0x74, 0x74, 0x56, 0x43, 0x67, 0x43, 0x43, 0x39,
        0x34, 0x75, 0x49, 0x43, 0x45, 0x6A, 0x75, 0x4F, 0x74, 0x41,
        0x43, 0x56, 0x43, 0x59, 0x44, 0x4C, 0x56, 0x75, 0x31, 0x4C,
        0x79, 0x6F, 0x31, 0x58, 0x35, 0x71, 0x34, 0x46, 0x30, 0x33,
        0x59, 0x6E, 0x59, 0x33, 0x45, 0x35, 0x69, 0x62, 0x64, 0x70,
        0x35, 0x6B, 0x69, 0x41, 0x72, 0x74, 0x47, 0x70, 0x53, 0x42,
        0x49, 0x3D, 0x0A, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x45, 0x4E,
        0x44, 0x20, 0x50, 0x55, 0x42, 0x4C, 0x49, 0x43, 0x20, 0x4B,
        0x45, 0x59, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x0A
};
#define sizeof_ca_sm2_key (sizeof(ca_sm2_key))

/* ./certs/sm2/ca-sm2-priv.pem */
static const unsigned char ca_sm2_priv[] =
{
        0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x42, 0x45, 0x47, 0x49, 0x4E,
        0x20, 0x50, 0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x20, 0x4B,
        0x45, 0x59, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x0A, 0x4D, 0x49,
        0x47, 0x49, 0x41, 0x67, 0x45, 0x41, 0x4D, 0x42, 0x51, 0x47,
        0x43, 0x43, 0x71, 0x42, 0x48, 0x4D, 0x39, 0x56, 0x41, 0x59,
        0x49, 0x74, 0x42, 0x67, 0x67, 0x71, 0x67, 0x52, 0x7A, 0x50,
        0x56, 0x51, 0x47, 0x43, 0x4C, 0x51, 0x52, 0x74, 0x4D, 0x47,
        0x73, 0x43, 0x41, 0x51, 0x45, 0x45, 0x49, 0x49, 0x2B, 0x35,
        0x75, 0x45, 0x41, 0x5A, 0x44, 0x69, 0x45, 0x35, 0x36, 0x2B,
        0x67, 0x49, 0x0A, 0x66, 0x50, 0x33, 0x59, 0x6F, 0x51, 0x57,
        0x54, 0x70, 0x44, 0x55, 0x73, 0x30, 0x59, 0x44, 0x6A, 0x76,
        0x33, 0x35, 0x49, 0x52, 0x2B, 0x51, 0x46, 0x44, 0x51, 0x6C,
        0x42, 0x6F, 0x55, 0x51, 0x44, 0x51, 0x67, 0x41, 0x45, 0x49,
        0x5A, 0x4C, 0x33, 0x79, 0x79, 0x54, 0x66, 0x5A, 0x45, 0x32,
        0x36, 0x71, 0x32, 0x5A, 0x37, 0x67, 0x33, 0x57, 0x70, 0x4B,
        0x65, 0x66, 0x2F, 0x5A, 0x47, 0x4F, 0x32, 0x0A, 0x31, 0x55,
        0x4B, 0x41, 0x49, 0x4C, 0x33, 0x69, 0x34, 0x67, 0x49, 0x53,
        0x4F, 0x34, 0x36, 0x30, 0x41, 0x4A, 0x55, 0x4A, 0x67, 0x4D,
        0x74, 0x57, 0x37, 0x55, 0x76, 0x4B, 0x6A, 0x56, 0x66, 0x6D,
        0x72, 0x67, 0x58, 0x54, 0x64, 0x69, 0x64, 0x6A, 0x63, 0x54,
        0x6D, 0x4A, 0x74, 0x32, 0x6E, 0x6D, 0x53, 0x49, 0x43, 0x75,
        0x30, 0x61, 0x6C, 0x49, 0x45, 0x67, 0x3D, 0x3D, 0x0A, 0x2D,
        0x2D, 0x2D, 0x2D, 0x2D, 0x45, 0x4E, 0x44, 0x20, 0x50, 0x52,
        0x49, 0x56, 0x41, 0x54, 0x45, 0x20, 0x4B, 0x45, 0x59, 0x2D,
        0x2D, 0x2D, 0x2D, 0x2D, 0x0A
};
#define sizeof_ca_sm2_priv (sizeof(ca_sm2_priv))

/* ./certs/sm2/client-sm2.pem */
static const unsigned char client_sm2[] =
{
        0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
        0x65, 0x3A, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x44, 0x61, 0x74,
        0x61, 0x3A, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6F, 0x6E, 0x3A, 0x20,
        0x33, 0x20, 0x28, 0x30, 0x78, 0x32, 0x29, 0x0A, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x53, 0x65, 0x72, 0x69,
        0x61, 0x6C, 0x20, 0x4E, 0x75, 0x6D, 0x62, 0x65, 0x72, 0x3A,
        0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x36, 0x30, 0x3A, 0x61, 0x30, 0x3A, 0x34,
        0x61, 0x3A, 0x30, 0x62, 0x3A, 0x33, 0x36, 0x3A, 0x65, 0x62,
        0x3A, 0x37, 0x64, 0x3A, 0x65, 0x31, 0x3A, 0x33, 0x66, 0x3A,
        0x37, 0x34, 0x3A, 0x32, 0x39, 0x3A, 0x61, 0x39, 0x3A, 0x32,
        0x39, 0x3A, 0x62, 0x34, 0x3A, 0x30, 0x35, 0x3A, 0x36, 0x63,
        0x3A, 0x31, 0x37, 0x3A, 0x66, 0x37, 0x3A, 0x61, 0x36, 0x3A,
        0x64, 0x34, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x53, 0x69, 0x67, 0x6E, 0x61, 0x74, 0x75, 0x72, 0x65,
        0x20, 0x41, 0x6C, 0x67, 0x6F, 0x72, 0x69, 0x74, 0x68, 0x6D,
        0x3A, 0x20, 0x53, 0x4D, 0x32, 0x2D, 0x77, 0x69, 0x74, 0x68,
        0x2D, 0x53, 0x4D, 0x33, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x49, 0x73, 0x73, 0x75, 0x65, 0x72, 0x3A,
        0x20, 0x43, 0x20, 0x3D, 0x20, 0x55, 0x53, 0x2C, 0x20, 0x53,
        0x54, 0x20, 0x3D, 0x20, 0x4D, 0x6F, 0x6E, 0x74, 0x61, 0x6E,
        0x61, 0x2C, 0x20, 0x4C, 0x20, 0x3D, 0x20, 0x42, 0x6F, 0x7A,
        0x65, 0x6D, 0x61, 0x6E, 0x2C, 0x20, 0x4F, 0x20, 0x3D, 0x20,
        0x77, 0x6F, 0x6C, 0x66, 0x53, 0x53, 0x4C, 0x5F, 0x73, 0x6D,
        0x32, 0x2C, 0x20, 0x4F, 0x55, 0x20, 0x3D, 0x20, 0x43, 0x6C,
        0x69, 0x65, 0x6E, 0x74, 0x2D, 0x73, 0x6D, 0x32, 0x2C, 0x20,
        0x43, 0x4E, 0x20, 0x3D, 0x20, 0x77, 0x77, 0x77, 0x2E, 0x77,
        0x6F, 0x6C, 0x66, 0x73, 0x73, 0x6C, 0x2E, 0x63, 0x6F, 0x6D,
        0x2C, 0x20, 0x65, 0x6D, 0x61, 0x69, 0x6C, 0x41, 0x64, 0x64,
        0x72, 0x65, 0x73, 0x73, 0x20, 0x3D, 0x20, 0x69, 0x6E, 0x66,
        0x6F, 0x40, 0x77, 0x6F, 0x6C, 0x66, 0x73, 0x73, 0x6C, 0x2E,
        0x63, 0x6F, 0x6D, 0x2C, 0x20, 0x55, 0x49, 0x44, 0x20, 0x3D,
        0x20, 0x77, 0x6F, 0x6C, 0x66, 0x53, 0x53, 0x4C, 0x0A, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x56, 0x61, 0x6C,
        0x69, 0x64, 0x69, 0x74, 0x79, 0x0A, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x4E, 0x6F,
        0x74, 0x20, 0x42, 0x65, 0x66, 0x6F, 0x72, 0x65, 0x3A, 0x20,
        0x46, 0x65, 0x62, 0x20, 0x31, 0x35, 0x20, 0x30, 0x36, 0x3A,
        0x32, 0x33, 0x3A, 0x30, 0x37, 0x20, 0x32, 0x30, 0x32, 0x33,
        0x20, 0x47, 0x4D, 0x54, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x4E, 0x6F, 0x74,
        0x20, 0x41, 0x66, 0x74, 0x65, 0x72, 0x20, 0x3A, 0x20, 0x4E,
        0x6F, 0x76, 0x20, 0x31, 0x31, 0x20, 0x30, 0x36, 0x3A, 0x32,
        0x33, 0x3A, 0x30, 0x37, 0x20, 0x32, 0x30, 0x32, 0x35, 0x20,
        0x47, 0x4D, 0x54, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x53, 0x75, 0x62, 0x6A, 0x65, 0x63, 0x74, 0x3A,
        0x20, 0x43, 0x20, 0x3D, 0x20, 0x55, 0x53, 0x2C, 0x20, 0x53,
        0x54, 0x20, 0x3D, 0x20, 0x4D, 0x6F, 0x6E, 0x74, 0x61, 0x6E,
        0x61, 0x2C, 0x20, 0x4C, 0x20, 0x3D, 0x20, 0x42, 0x6F, 0x7A,
        0x65, 0x6D, 0x61, 0x6E, 0x2C, 0x20, 0x4F, 0x20, 0x3D, 0x20,
        0x77, 0x6F, 0x6C, 0x66, 0x53, 0x53, 0x4C, 0x5F, 0x73, 0x6D,
        0x32, 0x2C, 0x20, 0x4F, 0x55, 0x20, 0x3D, 0x20, 0x43, 0x6C,
        0x69, 0x65, 0x6E, 0x74, 0x2D, 0x73, 0x6D, 0x32, 0x2C, 0x20,
        0x43, 0x4E, 0x20, 0x3D, 0x20, 0x77, 0x77, 0x77, 0x2E, 0x77,
        0x6F, 0x6C, 0x66, 0x73, 0x73, 0x6C, 0x2E, 0x63, 0x6F, 0x6D,
        0x2C, 0x20, 0x65, 0x6D, 0x61, 0x69, 0x6C, 0x41, 0x64, 0x64,
        0x72, 0x65, 0x73, 0x73, 0x20, 0x3D, 0x20, 0x69, 0x6E, 0x66,
        0x6F, 0x40, 0x77, 0x6F, 0x6C, 0x66, 0x73, 0x73, 0x6C, 0x2E,
        0x63, 0x6F, 0x6D, 0x2C, 0x20, 0x55, 0x49, 0x44, 0x20, 0x3D,
        0x20, 0x77, 0x6F, 0x6C, 0x66, 0x53, 0x53, 0x4C, 0x0A, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x53, 0x75, 0x62,
        0x6A, 0x65, 0x63, 0x74, 0x20, 0x50, 0x75, 0x62, 0x6C, 0x69,
        0x63, 0x20, 0x4B, 0x65, 0x79, 0x20, 0x49, 0x6E, 0x66, 0x6F,
        0x3A, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x50, 0x75, 0x62, 0x6C, 0x69, 0x63,
        0x20, 0x4B, 0x65, 0x79, 0x20, 0x41, 0x6C, 0x67, 0x6F, 0x72,
        0x69, 0x74, 0x68, 0x6D, 0x3A, 0x20, 0x73, 0x6D, 0x32, 0x0A,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x50, 0x75, 0x62, 0x6C,
        0x69, 0x63, 0x2D, 0x4B, 0x65, 0x79, 0x3A, 0x20, 0x28, 0x32,
        0x35, 0x36, 0x20, 0x62, 0x69, 0x74, 0x29, 0x0A, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x70, 0x75, 0x62, 0x3A, 0x0A, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x30,
        0x34, 0x3A, 0x33, 0x61, 0x3A, 0x31, 0x64, 0x3A, 0x65, 0x38,
        0x3A, 0x63, 0x62, 0x3A, 0x34, 0x62, 0x3A, 0x64, 0x33, 0x3A,
        0x32, 0x65, 0x3A, 0x33, 0x66, 0x3A, 0x34, 0x62, 0x3A, 0x30,
        0x37, 0x3A, 0x33, 0x66, 0x3A, 0x62, 0x30, 0x3A, 0x32, 0x31,
        0x3A, 0x66, 0x65, 0x3A, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x63, 0x35, 0x3A, 0x39, 0x65,
        0x3A, 0x64, 0x39, 0x3A, 0x63, 0x61, 0x3A, 0x33, 0x61, 0x3A,
        0x39, 0x33, 0x3A, 0x39, 0x33, 0x3A, 0x39, 0x35, 0x3A, 0x37,
        0x36, 0x3A, 0x31, 0x64, 0x3A, 0x33, 0x30, 0x3A, 0x64, 0x39,
        0x3A, 0x30, 0x62, 0x3A, 0x66, 0x35, 0x3A, 0x35, 0x36, 0x3A,
        0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x65, 0x64, 0x3A, 0x31, 0x39, 0x3A, 0x36, 0x30, 0x3A,
        0x65, 0x64, 0x3A, 0x30, 0x31, 0x3A, 0x34, 0x63, 0x3A, 0x66,
        0x36, 0x3A, 0x36, 0x37, 0x3A, 0x31, 0x64, 0x3A, 0x66, 0x31,
        0x3A, 0x61, 0x63, 0x3A, 0x61, 0x38, 0x3A, 0x37, 0x34, 0x3A,
        0x30, 0x64, 0x3A, 0x62, 0x32, 0x3A, 0x0A, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x37, 0x37, 0x3A,
        0x63, 0x38, 0x3A, 0x34, 0x39, 0x3A, 0x33, 0x38, 0x3A, 0x65,
        0x34, 0x3A, 0x66, 0x66, 0x3A, 0x34, 0x63, 0x3A, 0x65, 0x66,
        0x3A, 0x38, 0x64, 0x3A, 0x36, 0x64, 0x3A, 0x38, 0x37, 0x3A,
        0x66, 0x36, 0x3A, 0x34, 0x65, 0x3A, 0x63, 0x37, 0x3A, 0x66,
        0x38, 0x3A, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x33, 0x39, 0x3A, 0x37, 0x34, 0x3A, 0x37,
        0x30, 0x3A, 0x37, 0x30, 0x3A, 0x62, 0x35, 0x0A, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x41, 0x53, 0x4E, 0x31, 0x20, 0x4F,
        0x49, 0x44, 0x3A, 0x20, 0x53, 0x4D, 0x32, 0x0A, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x58, 0x35, 0x30, 0x39,
        0x76, 0x33, 0x20, 0x65, 0x78, 0x74, 0x65, 0x6E, 0x73, 0x69,
        0x6F, 0x6E, 0x73, 0x3A, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x58, 0x35, 0x30,
        0x39, 0x76, 0x33, 0x20, 0x53, 0x75, 0x62, 0x6A, 0x65, 0x63,
        0x74, 0x20, 0x4B, 0x65, 0x79, 0x20, 0x49, 0x64, 0x65, 0x6E,
        0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x3A, 0x20, 0x0A, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x45, 0x34, 0x3A, 0x32, 0x31,
        0x3A, 0x42, 0x32, 0x3A, 0x43, 0x35, 0x3A, 0x45, 0x35, 0x3A,
        0x44, 0x34, 0x3A, 0x39, 0x45, 0x3A, 0x38, 0x32, 0x3A, 0x43,
        0x41, 0x3A, 0x46, 0x38, 0x3A, 0x36, 0x37, 0x3A, 0x46, 0x32,
        0x3A, 0x32, 0x38, 0x3A, 0x39, 0x39, 0x3A, 0x46, 0x36, 0x3A,
        0x38, 0x35, 0x3A, 0x45, 0x38, 0x3A, 0x46, 0x31, 0x3A, 0x35,
        0x35, 0x3A, 0x45, 0x46, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x58, 0x35, 0x30,
        0x39, 0x76, 0x33, 0x20, 0x41, 0x75, 0x74, 0x68, 0x6F, 0x72,
        0x69, 0x74, 0x79, 0x20, 0x4B, 0x65, 0x79, 0x20, 0x49, 0x64,
        0x65, 0x6E, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x3A, 0x20,
        0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x6B, 0x65, 0x79,
        0x69, 0x64, 0x3A, 0x45, 0x34, 0x3A, 0x32, 0x31, 0x3A, 0x42,
        0x32, 0x3A, 0x43, 0x35, 0x3A, 0x45, 0x35, 0x3A, 0x44, 0x34,
        0x3A, 0x39, 0x45, 0x3A, 0x38, 0x32, 0x3A, 0x43, 0x41, 0x3A,
        0x46, 0x38, 0x3A, 0x36, 0x37, 0x3A, 0x46, 0x32, 0x3A, 0x32,
        0x38, 0x3A, 0x39, 0x39, 0x3A, 0x46, 0x36, 0x3A, 0x38, 0x35,
        0x3A, 0x45, 0x38, 0x3A, 0x46, 0x31, 0x3A, 0x35, 0x35, 0x3A,
        0x45, 0x46, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x44,
        0x69, 0x72, 0x4E, 0x61, 0x6D, 0x65, 0x3A, 0x2F, 0x43, 0x3D,
        0x55, 0x53, 0x2F, 0x53, 0x54, 0x3D, 0x4D, 0x6F, 0x6E, 0x74,
        0x61, 0x6E, 0x61, 0x2F, 0x4C, 0x3D, 0x42, 0x6F, 0x7A, 0x65,
        0x6D, 0x61, 0x6E, 0x2F, 0x4F, 0x3D, 0x77, 0x6F, 0x6C, 0x66,
        0x53, 0x53, 0x4C, 0x5F, 0x73, 0x6D, 0x32, 0x2F, 0x4F, 0x55,
        0x3D, 0x43, 0x6C, 0x69, 0x65, 0x6E, 0x74, 0x2D, 0x73, 0x6D,
        0x32, 0x2F, 0x43, 0x4E, 0x3D, 0x77, 0x77, 0x77, 0x2E, 0x77,
        0x6F, 0x6C, 0x66, 0x73, 0x73, 0x6C, 0x2E, 0x63, 0x6F, 0x6D,
        0x2F, 0x65, 0x6D, 0x61, 0x69, 0x6C, 0x41, 0x64, 0x64, 0x72,
        0x65, 0x73, 0x73, 0x3D, 0x69, 0x6E, 0x66, 0x6F, 0x40, 0x77,
        0x6F, 0x6C, 0x66, 0x73, 0x73, 0x6C, 0x2E, 0x63, 0x6F, 0x6D,
        0x2F, 0x55, 0x49, 0x44, 0x3D, 0x77, 0x6F, 0x6C, 0x66, 0x53,
        0x53, 0x4C, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x73,
        0x65, 0x72, 0x69, 0x61, 0x6C, 0x3A, 0x36, 0x30, 0x3A, 0x41,
        0x30, 0x3A, 0x34, 0x41, 0x3A, 0x30, 0x42, 0x3A, 0x33, 0x36,
        0x3A, 0x45, 0x42, 0x3A, 0x37, 0x44, 0x3A, 0x45, 0x31, 0x3A,
        0x33, 0x46, 0x3A, 0x37, 0x34, 0x3A, 0x32, 0x39, 0x3A, 0x41,
        0x39, 0x3A, 0x32, 0x39, 0x3A, 0x42, 0x34, 0x3A, 0x30, 0x35,
        0x3A, 0x36, 0x43, 0x3A, 0x31, 0x37, 0x3A, 0x46, 0x37, 0x3A,
        0x41, 0x36, 0x3A, 0x44, 0x34, 0x0A, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x58, 0x35,
        0x30, 0x39, 0x76, 0x33, 0x20, 0x42, 0x61, 0x73, 0x69, 0x63,
        0x20, 0x43, 0x6F, 0x6E, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6E,
        0x74, 0x73, 0x3A, 0x20, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x43, 0x41, 0x3A, 0x54, 0x52, 0x55, 0x45, 0x0A, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x58, 0x35, 0x30, 0x39, 0x76, 0x33, 0x20, 0x53, 0x75,
        0x62, 0x6A, 0x65, 0x63, 0x74, 0x20, 0x41, 0x6C, 0x74, 0x65,
        0x72, 0x6E, 0x61, 0x74, 0x69, 0x76, 0x65, 0x20, 0x4E, 0x61,
        0x6D, 0x65, 0x3A, 0x20, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x44, 0x4E, 0x53, 0x3A, 0x65, 0x78, 0x61, 0x6D, 0x70,
        0x6C, 0x65, 0x2E, 0x63, 0x6F, 0x6D, 0x2C, 0x20, 0x49, 0x50,
        0x20, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x3A, 0x31,
        0x32, 0x37, 0x2E, 0x30, 0x2E, 0x30, 0x2E, 0x31, 0x0A, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x58, 0x35, 0x30, 0x39, 0x76, 0x33, 0x20, 0x45, 0x78,
        0x74, 0x65, 0x6E, 0x64, 0x65, 0x64, 0x20, 0x4B, 0x65, 0x79,
        0x20, 0x55, 0x73, 0x61, 0x67, 0x65, 0x3A, 0x20, 0x0A, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x54, 0x4C, 0x53, 0x20, 0x57,
        0x65, 0x62, 0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20,
        0x41, 0x75, 0x74, 0x68, 0x65, 0x6E, 0x74, 0x69, 0x63, 0x61,
        0x74, 0x69, 0x6F, 0x6E, 0x2C, 0x20, 0x54, 0x4C, 0x53, 0x20,
        0x57, 0x65, 0x62, 0x20, 0x43, 0x6C, 0x69, 0x65, 0x6E, 0x74,
        0x20, 0x41, 0x75, 0x74, 0x68, 0x65, 0x6E, 0x74, 0x69, 0x63,
        0x61, 0x74, 0x69, 0x6F, 0x6E, 0x0A, 0x20, 0x20, 0x20, 0x20,
        0x53, 0x69, 0x67, 0x6E, 0x61, 0x74, 0x75, 0x72, 0x65, 0x20,
        0x41, 0x6C, 0x67, 0x6F, 0x72, 0x69, 0x74, 0x68, 0x6D, 0x3A,
        0x20, 0x53, 0x4D, 0x32, 0x2D, 0x77, 0x69, 0x74, 0x68, 0x2D,
        0x53, 0x4D, 0x33, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x53, 0x69,
        0x67, 0x6E, 0x61, 0x74, 0x75, 0x72, 0x65, 0x20, 0x56, 0x61,
        0x6C, 0x75, 0x65, 0x3A, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x33, 0x30, 0x3A, 0x34, 0x36, 0x3A, 0x30,
        0x32, 0x3A, 0x32, 0x31, 0x3A, 0x30, 0x30, 0x3A, 0x38, 0x66,
        0x3A, 0x62, 0x32, 0x3A, 0x62, 0x35, 0x3A, 0x39, 0x35, 0x3A,
        0x38, 0x66, 0x3A, 0x37, 0x39, 0x3A, 0x66, 0x36, 0x3A, 0x35,
        0x65, 0x3A, 0x37, 0x35, 0x3A, 0x65, 0x35, 0x3A, 0x63, 0x35,
        0x3A, 0x65, 0x39, 0x3A, 0x39, 0x61, 0x3A, 0x0A, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x31, 0x32, 0x3A, 0x64,
        0x32, 0x3A, 0x30, 0x66, 0x3A, 0x37, 0x38, 0x3A, 0x39, 0x66,
        0x3A, 0x63, 0x30, 0x3A, 0x31, 0x64, 0x3A, 0x38, 0x64, 0x3A,
        0x31, 0x63, 0x3A, 0x62, 0x65, 0x3A, 0x36, 0x62, 0x3A, 0x30,
        0x63, 0x3A, 0x66, 0x31, 0x3A, 0x66, 0x35, 0x3A, 0x35, 0x37,
        0x3A, 0x36, 0x30, 0x3A, 0x64, 0x62, 0x3A, 0x39, 0x31, 0x3A,
        0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x34,
        0x66, 0x3A, 0x30, 0x32, 0x3A, 0x32, 0x31, 0x3A, 0x30, 0x30,
        0x3A, 0x38, 0x37, 0x3A, 0x35, 0x65, 0x3A, 0x37, 0x64, 0x3A,
        0x65, 0x34, 0x3A, 0x64, 0x36, 0x3A, 0x33, 0x61, 0x3A, 0x62,
        0x62, 0x3A, 0x37, 0x62, 0x3A, 0x39, 0x38, 0x3A, 0x32, 0x37,
        0x3A, 0x38, 0x35, 0x3A, 0x64, 0x65, 0x3A, 0x37, 0x61, 0x3A,
        0x66, 0x30, 0x3A, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x32, 0x31, 0x3A, 0x65, 0x32, 0x3A, 0x36, 0x36,
        0x3A, 0x61, 0x31, 0x3A, 0x39, 0x66, 0x3A, 0x32, 0x36, 0x3A,
        0x65, 0x30, 0x3A, 0x64, 0x64, 0x3A, 0x38, 0x36, 0x3A, 0x32,
        0x33, 0x3A, 0x62, 0x34, 0x3A, 0x63, 0x38, 0x3A, 0x63, 0x30,
        0x3A, 0x34, 0x36, 0x3A, 0x35, 0x61, 0x3A, 0x66, 0x32, 0x3A,
        0x34, 0x39, 0x3A, 0x38, 0x64, 0x0A, 0x2D, 0x2D, 0x2D, 0x2D,
        0x2D, 0x42, 0x45, 0x47, 0x49, 0x4E, 0x20, 0x43, 0x45, 0x52,
        0x54, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x45, 0x2D, 0x2D,
        0x2D, 0x2D, 0x2D, 0x0A, 0x4D, 0x49, 0x49, 0x44, 0x79, 0x54,
        0x43, 0x43, 0x41, 0x32, 0x36, 0x67, 0x41, 0x77, 0x49, 0x42,
        0x41, 0x67, 0x49, 0x55, 0x59, 0x4B, 0x42, 0x4B, 0x43, 0x7A,
        0x62, 0x72, 0x66, 0x65, 0x45, 0x2F, 0x64, 0x43, 0x6D, 0x70,
        0x4B, 0x62, 0x51, 0x46, 0x62, 0x42, 0x66, 0x33, 0x70, 0x74,
        0x51, 0x77, 0x43, 0x67, 0x59, 0x49, 0x4B, 0x6F, 0x45, 0x63,
        0x7A, 0x31, 0x55, 0x42, 0x67, 0x33, 0x55, 0x77, 0x0A, 0x67,
        0x62, 0x41, 0x78, 0x43, 0x7A, 0x41, 0x4A, 0x42, 0x67, 0x4E,
        0x56, 0x42, 0x41, 0x59, 0x54, 0x41, 0x6C, 0x56, 0x54, 0x4D,
        0x52, 0x41, 0x77, 0x44, 0x67, 0x59, 0x44, 0x56, 0x51, 0x51,
        0x49, 0x44, 0x41, 0x64, 0x4E, 0x62, 0x32, 0x35, 0x30, 0x59,
        0x57, 0x35, 0x68, 0x4D, 0x52, 0x41, 0x77, 0x44, 0x67, 0x59,
        0x44, 0x56, 0x51, 0x51, 0x48, 0x44, 0x41, 0x64, 0x43, 0x62,
        0x33, 0x70, 0x6C, 0x0A, 0x62, 0x57, 0x46, 0x75, 0x4D, 0x52,
        0x51, 0x77, 0x45, 0x67, 0x59, 0x44, 0x56, 0x51, 0x51, 0x4B,
        0x44, 0x41, 0x74, 0x33, 0x62, 0x32, 0x78, 0x6D, 0x55, 0x31,
        0x4E, 0x4D, 0x58, 0x33, 0x4E, 0x74, 0x4D, 0x6A, 0x45, 0x54,
        0x4D, 0x42, 0x45, 0x47, 0x41, 0x31, 0x55, 0x45, 0x43, 0x77,
        0x77, 0x4B, 0x51, 0x32, 0x78, 0x70, 0x5A, 0x57, 0x35, 0x30,
        0x4C, 0x58, 0x4E, 0x74, 0x4D, 0x6A, 0x45, 0x59, 0x0A, 0x4D,
        0x42, 0x59, 0x47, 0x41, 0x31, 0x55, 0x45, 0x41, 0x77, 0x77,
        0x50, 0x64, 0x33, 0x64, 0x33, 0x4C, 0x6E, 0x64, 0x76, 0x62,
        0x47, 0x5A, 0x7A, 0x63, 0x32, 0x77, 0x75, 0x59, 0x32, 0x39,
        0x74, 0x4D, 0x52, 0x38, 0x77, 0x48, 0x51, 0x59, 0x4A, 0x4B,
        0x6F, 0x5A, 0x49, 0x68, 0x76, 0x63, 0x4E, 0x41, 0x51, 0x6B,
        0x42, 0x46, 0x68, 0x42, 0x70, 0x62, 0x6D, 0x5A, 0x76, 0x51,
        0x48, 0x64, 0x76, 0x0A, 0x62, 0x47, 0x5A, 0x7A, 0x63, 0x32,
        0x77, 0x75, 0x59, 0x32, 0x39, 0x74, 0x4D, 0x52, 0x63, 0x77,
        0x46, 0x51, 0x59, 0x4B, 0x43, 0x5A, 0x49, 0x6D, 0x69, 0x5A,
        0x50, 0x79, 0x4C, 0x47, 0x51, 0x42, 0x41, 0x51, 0x77, 0x48,
        0x64, 0x32, 0x39, 0x73, 0x5A, 0x6C, 0x4E, 0x54, 0x54, 0x44,
        0x41, 0x65, 0x46, 0x77, 0x30, 0x79, 0x4D, 0x7A, 0x41, 0x79,
        0x4D, 0x54, 0x55, 0x77, 0x4E, 0x6A, 0x49, 0x7A, 0x0A, 0x4D,
        0x44, 0x64, 0x61, 0x46, 0x77, 0x30, 0x79, 0x4E, 0x54, 0x45,
        0x78, 0x4D, 0x54, 0x45, 0x77, 0x4E, 0x6A, 0x49, 0x7A, 0x4D,
        0x44, 0x64, 0x61, 0x4D, 0x49, 0x47, 0x77, 0x4D, 0x51, 0x73,
        0x77, 0x43, 0x51, 0x59, 0x44, 0x56, 0x51, 0x51, 0x47, 0x45,
        0x77, 0x4A, 0x56, 0x55, 0x7A, 0x45, 0x51, 0x4D, 0x41, 0x34,
        0x47, 0x41, 0x31, 0x55, 0x45, 0x43, 0x41, 0x77, 0x48, 0x54,
        0x57, 0x39, 0x75, 0x0A, 0x64, 0x47, 0x46, 0x75, 0x59, 0x54,
        0x45, 0x51, 0x4D, 0x41, 0x34, 0x47, 0x41, 0x31, 0x55, 0x45,
        0x42, 0x77, 0x77, 0x48, 0x51, 0x6D, 0x39, 0x36, 0x5A, 0x57,
        0x31, 0x68, 0x62, 0x6A, 0x45, 0x55, 0x4D, 0x42, 0x49, 0x47,
        0x41, 0x31, 0x55, 0x45, 0x43, 0x67, 0x77, 0x4C, 0x64, 0x32,
        0x39, 0x73, 0x5A, 0x6C, 0x4E, 0x54, 0x54, 0x46, 0x39, 0x7A,
        0x62, 0x54, 0x49, 0x78, 0x45, 0x7A, 0x41, 0x52, 0x0A, 0x42,
        0x67, 0x4E, 0x56, 0x42, 0x41, 0x73, 0x4D, 0x43, 0x6B, 0x4E,
        0x73, 0x61, 0x57, 0x56, 0x75, 0x64, 0x43, 0x31, 0x7A, 0x62,
        0x54, 0x49, 0x78, 0x47, 0x44, 0x41, 0x57, 0x42, 0x67, 0x4E,
        0x56, 0x42, 0x41, 0x4D, 0x4D, 0x44, 0x33, 0x64, 0x33, 0x64,
        0x79, 0x35, 0x33, 0x62, 0x32, 0x78, 0x6D, 0x63, 0x33, 0x4E,
        0x73, 0x4C, 0x6D, 0x4E, 0x76, 0x62, 0x54, 0x45, 0x66, 0x4D,
        0x42, 0x30, 0x47, 0x0A, 0x43, 0x53, 0x71, 0x47, 0x53, 0x49,
        0x62, 0x33, 0x44, 0x51, 0x45, 0x4A, 0x41, 0x52, 0x59, 0x51,
        0x61, 0x57, 0x35, 0x6D, 0x62, 0x30, 0x42, 0x33, 0x62, 0x32,
        0x78, 0x6D, 0x63, 0x33, 0x4E, 0x73, 0x4C, 0x6D, 0x4E, 0x76,
        0x62, 0x54, 0x45, 0x58, 0x4D, 0x42, 0x55, 0x47, 0x43, 0x67,
        0x6D, 0x53, 0x4A, 0x6F, 0x6D, 0x54, 0x38, 0x69, 0x78, 0x6B,
        0x41, 0x51, 0x45, 0x4D, 0x42, 0x33, 0x64, 0x76, 0x0A, 0x62,
        0x47, 0x5A, 0x54, 0x55, 0x30, 0x77, 0x77, 0x57, 0x6A, 0x41,
        0x55, 0x42, 0x67, 0x67, 0x71, 0x67, 0x52, 0x7A, 0x50, 0x56,
        0x51, 0x47, 0x43, 0x4C, 0x51, 0x59, 0x49, 0x4B, 0x6F, 0x45,
        0x63, 0x7A, 0x31, 0x55, 0x42, 0x67, 0x69, 0x30, 0x44, 0x51,
        0x67, 0x41, 0x45, 0x4F, 0x68, 0x33, 0x6F, 0x79, 0x30, 0x76,
        0x54, 0x4C, 0x6A, 0x39, 0x4C, 0x42, 0x7A, 0x2B, 0x77, 0x49,
        0x66, 0x37, 0x46, 0x0A, 0x6E, 0x74, 0x6E, 0x4B, 0x4F, 0x70,
        0x4F, 0x54, 0x6C, 0x58, 0x59, 0x64, 0x4D, 0x4E, 0x6B, 0x4C,
        0x39, 0x56, 0x62, 0x74, 0x47, 0x57, 0x44, 0x74, 0x41, 0x55,
        0x7A, 0x32, 0x5A, 0x78, 0x33, 0x78, 0x72, 0x4B, 0x68, 0x30,
        0x44, 0x62, 0x4A, 0x33, 0x79, 0x45, 0x6B, 0x34, 0x35, 0x50,
        0x39, 0x4D, 0x37, 0x34, 0x31, 0x74, 0x68, 0x2F, 0x5A, 0x4F,
        0x78, 0x2F, 0x67, 0x35, 0x64, 0x48, 0x42, 0x77, 0x0A, 0x74,
        0x61, 0x4F, 0x43, 0x41, 0x57, 0x45, 0x77, 0x67, 0x67, 0x46,
        0x64, 0x4D, 0x42, 0x30, 0x47, 0x41, 0x31, 0x55, 0x64, 0x44,
        0x67, 0x51, 0x57, 0x42, 0x42, 0x54, 0x6B, 0x49, 0x62, 0x4C,
        0x46, 0x35, 0x64, 0x53, 0x65, 0x67, 0x73, 0x72, 0x34, 0x5A,
        0x2F, 0x49, 0x6F, 0x6D, 0x66, 0x61, 0x46, 0x36, 0x50, 0x46,
        0x56, 0x37, 0x7A, 0x43, 0x42, 0x38, 0x41, 0x59, 0x44, 0x56,
        0x52, 0x30, 0x6A, 0x0A, 0x42, 0x49, 0x48, 0x6F, 0x4D, 0x49,
        0x48, 0x6C, 0x67, 0x42, 0x54, 0x6B, 0x49, 0x62, 0x4C, 0x46,
        0x35, 0x64, 0x53, 0x65, 0x67, 0x73, 0x72, 0x34, 0x5A, 0x2F,
        0x49, 0x6F, 0x6D, 0x66, 0x61, 0x46, 0x36, 0x50, 0x46, 0x56,
        0x37, 0x36, 0x47, 0x42, 0x74, 0x71, 0x53, 0x42, 0x73, 0x7A,
        0x43, 0x42, 0x73, 0x44, 0x45, 0x4C, 0x4D, 0x41, 0x6B, 0x47,
        0x41, 0x31, 0x55, 0x45, 0x42, 0x68, 0x4D, 0x43, 0x0A, 0x56,
        0x56, 0x4D, 0x78, 0x45, 0x44, 0x41, 0x4F, 0x42, 0x67, 0x4E,
        0x56, 0x42, 0x41, 0x67, 0x4D, 0x42, 0x30, 0x31, 0x76, 0x62,
        0x6E, 0x52, 0x68, 0x62, 0x6D, 0x45, 0x78, 0x45, 0x44, 0x41,
        0x4F, 0x42, 0x67, 0x4E, 0x56, 0x42, 0x41, 0x63, 0x4D, 0x42,
        0x30, 0x4A, 0x76, 0x65, 0x6D, 0x56, 0x74, 0x59, 0x57, 0x34,
        0x78, 0x46, 0x44, 0x41, 0x53, 0x42, 0x67, 0x4E, 0x56, 0x42,
        0x41, 0x6F, 0x4D, 0x0A, 0x43, 0x33, 0x64, 0x76, 0x62, 0x47,
        0x5A, 0x54, 0x55, 0x30, 0x78, 0x66, 0x63, 0x32, 0x30, 0x79,
        0x4D, 0x52, 0x4D, 0x77, 0x45, 0x51, 0x59, 0x44, 0x56, 0x51,
        0x51, 0x4C, 0x44, 0x41, 0x70, 0x44, 0x62, 0x47, 0x6C, 0x6C,
        0x62, 0x6E, 0x51, 0x74, 0x63, 0x32, 0x30, 0x79, 0x4D, 0x52,
        0x67, 0x77, 0x46, 0x67, 0x59, 0x44, 0x56, 0x51, 0x51, 0x44,
        0x44, 0x41, 0x39, 0x33, 0x64, 0x33, 0x63, 0x75, 0x0A, 0x64,
        0x32, 0x39, 0x73, 0x5A, 0x6E, 0x4E, 0x7A, 0x62, 0x43, 0x35,
        0x6A, 0x62, 0x32, 0x30, 0x78, 0x48, 0x7A, 0x41, 0x64, 0x42,
        0x67, 0x6B, 0x71, 0x68, 0x6B, 0x69, 0x47, 0x39, 0x77, 0x30,
        0x42, 0x43, 0x51, 0x45, 0x57, 0x45, 0x47, 0x6C, 0x75, 0x5A,
        0x6D, 0x39, 0x41, 0x64, 0x32, 0x39, 0x73, 0x5A, 0x6E, 0x4E,
        0x7A, 0x62, 0x43, 0x35, 0x6A, 0x62, 0x32, 0x30, 0x78, 0x46,
        0x7A, 0x41, 0x56, 0x0A, 0x42, 0x67, 0x6F, 0x4A, 0x6B, 0x69,
        0x61, 0x4A, 0x6B, 0x2F, 0x49, 0x73, 0x5A, 0x41, 0x45, 0x42,
        0x44, 0x41, 0x64, 0x33, 0x62, 0x32, 0x78, 0x6D, 0x55, 0x31,
        0x4E, 0x4D, 0x67, 0x68, 0x52, 0x67, 0x6F, 0x45, 0x6F, 0x4C,
        0x4E, 0x75, 0x74, 0x39, 0x34, 0x54, 0x39, 0x30, 0x4B, 0x61,
        0x6B, 0x70, 0x74, 0x41, 0x56, 0x73, 0x46, 0x2F, 0x65, 0x6D,
        0x31, 0x44, 0x41, 0x4D, 0x42, 0x67, 0x4E, 0x56, 0x0A, 0x48,
        0x52, 0x4D, 0x45, 0x42, 0x54, 0x41, 0x44, 0x41, 0x51, 0x48,
        0x2F, 0x4D, 0x42, 0x77, 0x47, 0x41, 0x31, 0x55, 0x64, 0x45,
        0x51, 0x51, 0x56, 0x4D, 0x42, 0x4F, 0x43, 0x43, 0x32, 0x56,
        0x34, 0x59, 0x57, 0x31, 0x77, 0x62, 0x47, 0x55, 0x75, 0x59,
        0x32, 0x39, 0x74, 0x68, 0x77, 0x52, 0x2F, 0x41, 0x41, 0x41,
        0x42, 0x4D, 0x42, 0x30, 0x47, 0x41, 0x31, 0x55, 0x64, 0x4A,
        0x51, 0x51, 0x57, 0x0A, 0x4D, 0x42, 0x51, 0x47, 0x43, 0x43,
        0x73, 0x47, 0x41, 0x51, 0x55, 0x46, 0x42, 0x77, 0x4D, 0x42,
        0x42, 0x67, 0x67, 0x72, 0x42, 0x67, 0x45, 0x46, 0x42, 0x51,
        0x63, 0x44, 0x41, 0x6A, 0x41, 0x4B, 0x42, 0x67, 0x67, 0x71,
        0x67, 0x52, 0x7A, 0x50, 0x56, 0x51, 0x47, 0x44, 0x64, 0x51,
        0x4E, 0x4A, 0x41, 0x44, 0x42, 0x47, 0x41, 0x69, 0x45, 0x41,
        0x6A, 0x37, 0x4B, 0x31, 0x6C, 0x59, 0x39, 0x35, 0x0A, 0x39,
        0x6C, 0x35, 0x31, 0x35, 0x63, 0x58, 0x70, 0x6D, 0x68, 0x4C,
        0x53, 0x44, 0x33, 0x69, 0x66, 0x77, 0x42, 0x32, 0x4E, 0x48,
        0x4C, 0x35, 0x72, 0x44, 0x50, 0x48, 0x31, 0x56, 0x32, 0x44,
        0x62, 0x6B, 0x55, 0x38, 0x43, 0x49, 0x51, 0x43, 0x48, 0x58,
        0x6E, 0x33, 0x6B, 0x31, 0x6A, 0x71, 0x37, 0x65, 0x35, 0x67,
        0x6E, 0x68, 0x64, 0x35, 0x36, 0x38, 0x43, 0x48, 0x69, 0x5A,
        0x71, 0x47, 0x66, 0x0A, 0x4A, 0x75, 0x44, 0x64, 0x68, 0x69,
        0x4F, 0x30, 0x79, 0x4D, 0x42, 0x47, 0x57, 0x76, 0x4A, 0x4A,
        0x6A, 0x51, 0x3D, 0x3D, 0x0A, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
        0x45, 0x4E, 0x44, 0x20, 0x43, 0x45, 0x52, 0x54, 0x49, 0x46,
        0x49, 0x43, 0x41, 0x54, 0x45, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
        0x0A
};
#define sizeof_client_sm2 (sizeof(client_sm2))

/* ./certs/sm2/client-sm2-key.pem */
static const unsigned char client_sm2_key[] =
{
        0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x42, 0x45, 0x47, 0x49, 0x4E,
        0x20, 0x50, 0x55, 0x42, 0x4C, 0x49, 0x43, 0x20, 0x4B, 0x45,
        0x59, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x0A, 0x4D, 0x46, 0x6F,
        0x77, 0x46, 0x41, 0x59, 0x49, 0x4B, 0x6F, 0x45, 0x63, 0x7A,
        0x31, 0x55, 0x42, 0x67, 0x69, 0x30, 0x47, 0x43, 0x43, 0x71,
        0x42, 0x48, 0x4D, 0x39, 0x56, 0x41, 0x59, 0x49, 0x74, 0x41,
        0x30, 0x49, 0x41, 0x42, 0x44, 0x6F, 0x64, 0x36, 0x4D, 0x74,
        0x4C, 0x30, 0x79, 0x34, 0x2F, 0x53, 0x77, 0x63, 0x2F, 0x73,
        0x43, 0x48, 0x2B, 0x78, 0x5A, 0x37, 0x5A, 0x79, 0x6A, 0x71,
        0x54, 0x0A, 0x6B, 0x35, 0x56, 0x32, 0x48, 0x54, 0x44, 0x5A,
        0x43, 0x2F, 0x56, 0x57, 0x37, 0x52, 0x6C, 0x67, 0x37, 0x51,
        0x46, 0x4D, 0x39, 0x6D, 0x63, 0x64, 0x38, 0x61, 0x79, 0x6F,
        0x64, 0x41, 0x32, 0x79, 0x64, 0x38, 0x68, 0x4A, 0x4F, 0x4F,
        0x54, 0x2F, 0x54, 0x4F, 0x2B, 0x4E, 0x62, 0x59, 0x66, 0x32,
        0x54, 0x73, 0x66, 0x34, 0x4F, 0x58, 0x52, 0x77, 0x63, 0x4C,
        0x55, 0x3D, 0x0A, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x45, 0x4E,
        0x44, 0x20, 0x50, 0x55, 0x42, 0x4C, 0x49, 0x43, 0x20, 0x4B,
        0x45, 0x59, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x0A
};
#define sizeof_client_sm2_key (sizeof(client_sm2_key))

/* ./certs/sm2/client-sm2-priv.pem */
static const unsigned char client_sm2_priv[] =
{
        0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x42, 0x45, 0x47, 0x49, 0x4E,
        0x20, 0x50, 0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x20, 0x4B,
        0x45, 0x59, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x0A, 0x4D, 0x49,
        0x47, 0x49, 0x41, 0x67, 0x45, 0x41, 0x4D, 0x42, 0x51, 0x47,
        0x43, 0x43, 0x71, 0x42, 0x48, 0x4D, 0x39, 0x56, 0x41, 0x59,
        0x49, 0x74, 0x42, 0x67, 0x67, 0x71, 0x67, 0x52, 0x7A, 0x50,
        0x56, 0x51, 0x47, 0x43, 0x4C, 0x51, 0x52, 0x74, 0x4D, 0x47,
        0x73, 0x43, 0x41, 0x51, 0x45, 0x45, 0x49, 0x4E, 0x43, 0x69,
        0x33, 0x30, 0x6C, 0x36, 0x4C, 0x64, 0x38, 0x43, 0x79, 0x63,
        0x36, 0x33, 0x0A, 0x38, 0x6A, 0x63, 0x43, 0x44, 0x64, 0x33,
        0x38, 0x43, 0x4C, 0x6A, 0x65, 0x46, 0x4A, 0x4E, 0x36, 0x55,
        0x79, 0x5A, 0x4A, 0x31, 0x66, 0x34, 0x43, 0x32, 0x66, 0x4E,
        0x78, 0x6F, 0x55, 0x51, 0x44, 0x51, 0x67, 0x41, 0x45, 0x4F,
        0x68, 0x33, 0x6F, 0x79, 0x30, 0x76, 0x54, 0x4C, 0x6A, 0x39,
        0x4C, 0x42, 0x7A, 0x2B, 0x77, 0x49, 0x66, 0x37, 0x46, 0x6E,
        0x74, 0x6E, 0x4B, 0x4F, 0x70, 0x4F, 0x54, 0x0A, 0x6C, 0x58,
        0x59, 0x64, 0x4D, 0x4E, 0x6B, 0x4C, 0x39, 0x56, 0x62, 0x74,
        0x47, 0x57, 0x44, 0x74, 0x41, 0x55, 0x7A, 0x32, 0x5A, 0x78,
        0x33, 0x78, 0x72, 0x4B, 0x68, 0x30, 0x44, 0x62, 0x4A, 0x33,
        0x79, 0x45, 0x6B, 0x34, 0x35, 0x50, 0x39, 0x4D, 0x37, 0x34,
        0x31, 0x74, 0x68, 0x2F, 0x5A, 0x4F, 0x78, 0x2F, 0x67, 0x35,
        0x64, 0x48, 0x42, 0x77, 0x74, 0x51, 0x3D, 0x3D, 0x0A, 0x2D,
        0x2D, 0x2D, 0x2D, 0x2D, 0x45, 0x4E, 0x44, 0x20, 0x50, 0x52,
        0x49, 0x56, 0x41, 0x54, 0x45, 0x20, 0x4B, 0x45, 0x59, 0x2D,
        0x2D, 0x2D, 0x2D, 0x2D, 0x0A
};
#define sizeof_client_sm2_priv (sizeof(client_sm2_priv))

/* ./certs/sm2/root-sm2.pem */
static const unsigned char root_sm2[] =
{
        0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
        0x65, 0x3A, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x44, 0x61, 0x74,
        0x61, 0x3A, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6F, 0x6E, 0x3A, 0x20,
        0x33, 0x20, 0x28, 0x30, 0x78, 0x32, 0x29, 0x0A, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x53, 0x65, 0x72, 0x69,
        0x61, 0x6C, 0x20, 0x4E, 0x75, 0x6D, 0x62, 0x65, 0x72, 0x3A,
        0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x37, 0x34, 0x3A, 0x39, 0x63, 0x3A, 0x64,
        0x64, 0x3A, 0x61, 0x34, 0x3A, 0x62, 0x32, 0x3A, 0x36, 0x37,
        0x3A, 0x32, 0x36, 0x3A, 0x35, 0x37, 0x3A, 0x32, 0x39, 0x3A,
        0x66, 0x62, 0x3A, 0x65, 0x39, 0x3A, 0x31, 0x33, 0x3A, 0x35,
        0x34, 0x3A, 0x65, 0x30, 0x3A, 0x33, 0x34, 0x3A, 0x30, 0x38,
        0x3A, 0x30, 0x33, 0x3A, 0x32, 0x62, 0x3A, 0x37, 0x30, 0x3A,
        0x61, 0x39, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x53, 0x69, 0x67, 0x6E, 0x61, 0x74, 0x75, 0x72, 0x65,
        0x20, 0x41, 0x6C, 0x67, 0x6F, 0x72, 0x69, 0x74, 0x68, 0x6D,
        0x3A, 0x20, 0x53, 0x4D, 0x32, 0x2D, 0x77, 0x69, 0x74, 0x68,
        0x2D, 0x53, 0x4D, 0x33, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x49, 0x73, 0x73, 0x75, 0x65, 0x72, 0x3A,
        0x20, 0x43, 0x20, 0x3D, 0x20, 0x55, 0x53, 0x2C, 0x20, 0x53,
        0x54, 0x20, 0x3D, 0x20, 0x4D, 0x6F, 0x6E, 0x74, 0x61, 0x6E,
        0x61, 0x2C, 0x20, 0x4C, 0x20, 0x3D, 0x20, 0x42, 0x6F, 0x7A,
        0x65, 0x6D, 0x61, 0x6E, 0x2C, 0x20, 0x4F, 0x20, 0x3D, 0x20,
        0x77, 0x6F, 0x6C, 0x66, 0x53, 0x53, 0x4C, 0x5F, 0x53, 0x4D,
        0x32, 0x2C, 0x20, 0x4F, 0x55, 0x20, 0x3D, 0x20, 0x52, 0x6F,
        0x6F, 0x74, 0x2D, 0x53, 0x4D, 0x32, 0x2C, 0x20, 0x43, 0x4E,
        0x20, 0x3D, 0x20, 0x77, 0x77, 0x77, 0x2E, 0x77, 0x6F, 0x6C,
        0x66, 0x73, 0x73, 0x6C, 0x2E, 0x63, 0x6F, 0x6D, 0x2C, 0x20,
        0x65, 0x6D, 0x61, 0x69, 0x6C, 0x41, 0x64, 0x64, 0x72, 0x65,
        0x73, 0x73, 0x20, 0x3D, 0x20, 0x69, 0x6E, 0x66, 0x6F, 0x40,
        0x77, 0x6F, 0x6C, 0x66, 0x73, 0x73, 0x6C, 0x2E, 0x63, 0x6F,
        0x6D, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x56, 0x61, 0x6C, 0x69, 0x64, 0x69, 0x74, 0x79, 0x0A, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x4E, 0x6F, 0x74, 0x20, 0x42, 0x65, 0x66, 0x6F, 0x72,
        0x65, 0x3A, 0x20, 0x46, 0x65, 0x62, 0x20, 0x31, 0x35, 0x20,
        0x30, 0x36, 0x3A, 0x32, 0x33, 0x3A, 0x30, 0x37, 0x20, 0x32,
        0x30, 0x32, 0x33, 0x20, 0x47, 0x4D, 0x54, 0x0A, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x4E, 0x6F, 0x74, 0x20, 0x41, 0x66, 0x74, 0x65, 0x72, 0x20,
        0x3A, 0x20, 0x4E, 0x6F, 0x76, 0x20, 0x31, 0x31, 0x20, 0x30,
        0x36, 0x3A, 0x32, 0x33, 0x3A, 0x30, 0x37, 0x20, 0x32, 0x30,
        0x32, 0x35, 0x20, 0x47, 0x4D, 0x54, 0x0A, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x53, 0x75, 0x62, 0x6A, 0x65,
        0x63, 0x74, 0x3A, 0x20, 0x43, 0x20, 0x3D, 0x20, 0x55, 0x53,
        0x2C, 0x20, 0x53, 0x54, 0x20, 0x3D, 0x20, 0x4D, 0x6F, 0x6E,
        0x74, 0x61, 0x6E, 0x61, 0x2C, 0x20, 0x4C, 0x20, 0x3D, 0x20,
        0x42, 0x6F, 0x7A, 0x65, 0x6D, 0x61, 0x6E, 0x2C, 0x20, 0x4F,
        0x20, 0x3D, 0x20, 0x77, 0x6F, 0x6C, 0x66, 0x53, 0x53, 0x4C,
        0x5F, 0x53, 0x4D, 0x32, 0x2C, 0x20, 0x4F, 0x55, 0x20, 0x3D,
        0x20, 0x52, 0x6F, 0x6F, 0x74, 0x2D, 0x53, 0x4D, 0x32, 0x2C,
        0x20, 0x43, 0x4E, 0x20, 0x3D, 0x20, 0x77, 0x77, 0x77, 0x2E,
        0x77, 0x6F, 0x6C, 0x66, 0x73, 0x73, 0x6C, 0x2E, 0x63, 0x6F,
        0x6D, 0x2C, 0x20, 0x65, 0x6D, 0x61, 0x69, 0x6C, 0x41, 0x64,
        0x64, 0x72, 0x65, 0x73, 0x73, 0x20, 0x3D, 0x20, 0x69, 0x6E,
        0x66, 0x6F, 0x40, 0x77, 0x6F, 0x6C, 0x66, 0x73, 0x73, 0x6C,
        0x2E, 0x63, 0x6F, 0x6D, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x53, 0x75, 0x62, 0x6A, 0x65, 0x63, 0x74,
        0x20, 0x50, 0x75, 0x62, 0x6C, 0x69, 0x63, 0x20, 0x4B, 0x65,
        0x79, 0x20, 0x49, 0x6E, 0x66, 0x6F, 0x3A, 0x0A, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x50, 0x75, 0x62, 0x6C, 0x69, 0x63, 0x20, 0x4B, 0x65, 0x79,
        0x20, 0x41, 0x6C, 0x67, 0x6F, 0x72, 0x69, 0x74, 0x68, 0x6D,
        0x3A, 0x20, 0x73, 0x6D, 0x32, 0x0A, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x50, 0x75, 0x62, 0x6C, 0x69, 0x63, 0x2D, 0x4B,
        0x65, 0x79, 0x3A, 0x20, 0x28, 0x32, 0x35, 0x36, 0x20, 0x62,
        0x69, 0x74, 0x29, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x70, 0x75, 0x62, 0x3A, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x30, 0x34, 0x3A, 0x62, 0x62,
        0x3A, 0x39, 0x63, 0x3A, 0x37, 0x35, 0x3A, 0x38, 0x63, 0x3A,
        0x66, 0x37, 0x3A, 0x31, 0x37, 0x3A, 0x66, 0x38, 0x3A, 0x34,
        0x38, 0x3A, 0x61, 0x62, 0x3A, 0x66, 0x37, 0x3A, 0x66, 0x36,
        0x3A, 0x64, 0x62, 0x3A, 0x30, 0x64, 0x3A, 0x39, 0x61, 0x3A,
        0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x38, 0x64, 0x3A, 0x39, 0x66, 0x3A, 0x63, 0x32, 0x3A,
        0x64, 0x31, 0x3A, 0x34, 0x37, 0x3A, 0x39, 0x37, 0x3A, 0x39,
        0x35, 0x3A, 0x30, 0x62, 0x3A, 0x34, 0x65, 0x3A, 0x65, 0x36,
        0x3A, 0x35, 0x37, 0x3A, 0x65, 0x63, 0x3A, 0x63, 0x35, 0x3A,
        0x66, 0x38, 0x3A, 0x35, 0x37, 0x3A, 0x0A, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x35, 0x34, 0x3A,
        0x37, 0x31, 0x3A, 0x33, 0x39, 0x3A, 0x33, 0x63, 0x3A, 0x37,
        0x39, 0x3A, 0x65, 0x31, 0x3A, 0x34, 0x30, 0x3A, 0x33, 0x66,
        0x3A, 0x62, 0x36, 0x3A, 0x35, 0x31, 0x3A, 0x65, 0x39, 0x3A,
        0x37, 0x63, 0x3A, 0x63, 0x37, 0x3A, 0x64, 0x61, 0x3A, 0x32,
        0x64, 0x3A, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x65, 0x66, 0x3A, 0x64, 0x32, 0x3A, 0x65,
        0x38, 0x3A, 0x37, 0x39, 0x3A, 0x38, 0x31, 0x3A, 0x37, 0x62,
        0x3A, 0x61, 0x62, 0x3A, 0x61, 0x33, 0x3A, 0x35, 0x66, 0x3A,
        0x36, 0x62, 0x3A, 0x32, 0x61, 0x3A, 0x36, 0x63, 0x3A, 0x39,
        0x37, 0x3A, 0x31, 0x61, 0x3A, 0x35, 0x65, 0x3A, 0x0A, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x38,
        0x65, 0x3A, 0x64, 0x39, 0x3A, 0x64, 0x30, 0x3A, 0x63, 0x63,
        0x3A, 0x30, 0x34, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x41, 0x53, 0x4E, 0x31, 0x20, 0x4F, 0x49, 0x44, 0x3A, 0x20,
        0x53, 0x4D, 0x32, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x58, 0x35, 0x30, 0x39, 0x76, 0x33, 0x20, 0x65,
        0x78, 0x74, 0x65, 0x6E, 0x73, 0x69, 0x6F, 0x6E, 0x73, 0x3A,
        0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x58, 0x35, 0x30, 0x39, 0x76, 0x33, 0x20,
        0x53, 0x75, 0x62, 0x6A, 0x65, 0x63, 0x74, 0x20, 0x4B, 0x65,
        0x79, 0x20, 0x49, 0x64, 0x65, 0x6E, 0x74, 0x69, 0x66, 0x69,
        0x65, 0x72, 0x3A, 0x20, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x33, 0x34, 0x3A, 0x31, 0x44, 0x3A, 0x37, 0x39, 0x3A,
        0x34, 0x34, 0x3A, 0x31, 0x35, 0x3A, 0x37, 0x39, 0x3A, 0x41,
        0x31, 0x3A, 0x42, 0x31, 0x3A, 0x36, 0x33, 0x3A, 0x39, 0x39,
        0x3A, 0x45, 0x33, 0x3A, 0x45, 0x44, 0x3A, 0x36, 0x35, 0x3A,
        0x37, 0x43, 0x3A, 0x36, 0x34, 0x3A, 0x38, 0x39, 0x3A, 0x38,
        0x30, 0x3A, 0x46, 0x46, 0x3A, 0x42, 0x38, 0x3A, 0x45, 0x43,
        0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x58, 0x35, 0x30, 0x39, 0x76, 0x33, 0x20,
        0x41, 0x75, 0x74, 0x68, 0x6F, 0x72, 0x69, 0x74, 0x79, 0x20,
        0x4B, 0x65, 0x79, 0x20, 0x49, 0x64, 0x65, 0x6E, 0x74, 0x69,
        0x66, 0x69, 0x65, 0x72, 0x3A, 0x20, 0x0A, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x33, 0x34, 0x3A, 0x31, 0x44, 0x3A, 0x37,
        0x39, 0x3A, 0x34, 0x34, 0x3A, 0x31, 0x35, 0x3A, 0x37, 0x39,
        0x3A, 0x41, 0x31, 0x3A, 0x42, 0x31, 0x3A, 0x36, 0x33, 0x3A,
        0x39, 0x39, 0x3A, 0x45, 0x33, 0x3A, 0x45, 0x44, 0x3A, 0x36,
        0x35, 0x3A, 0x37, 0x43, 0x3A, 0x36, 0x34, 0x3A, 0x38, 0x39,
        0x3A, 0x38, 0x30, 0x3A, 0x46, 0x46, 0x3A, 0x42, 0x38, 0x3A,
        0x45, 0x43, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x58, 0x35, 0x30, 0x39, 0x76,
        0x33, 0x20, 0x42, 0x61, 0x73, 0x69, 0x63, 0x20, 0x43, 0x6F,
        0x6E, 0x73, 0x74, 0x72, 0x61, 0x69, 0x6E, 0x74, 0x73, 0x3A,
        0x20, 0x63, 0x72, 0x69, 0x74, 0x69, 0x63, 0x61, 0x6C, 0x0A,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x43, 0x41, 0x3A, 0x54,
        0x52, 0x55, 0x45, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x58, 0x35, 0x30, 0x39,
        0x76, 0x33, 0x20, 0x4B, 0x65, 0x79, 0x20, 0x55, 0x73, 0x61,
        0x67, 0x65, 0x3A, 0x20, 0x63, 0x72, 0x69, 0x74, 0x69, 0x63,
        0x61, 0x6C, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x44,
        0x69, 0x67, 0x69, 0x74, 0x61, 0x6C, 0x20, 0x53, 0x69, 0x67,
        0x6E, 0x61, 0x74, 0x75, 0x72, 0x65, 0x2C, 0x20, 0x43, 0x65,
        0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x20,
        0x53, 0x69, 0x67, 0x6E, 0x2C, 0x20, 0x43, 0x52, 0x4C, 0x20,
        0x53, 0x69, 0x67, 0x6E, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x53,
        0x69, 0x67, 0x6E, 0x61, 0x74, 0x75, 0x72, 0x65, 0x20, 0x41,
        0x6C, 0x67, 0x6F, 0x72, 0x69, 0x74, 0x68, 0x6D, 0x3A, 0x20,
        0x53, 0x4D, 0x32, 0x2D, 0x77, 0x69, 0x74, 0x68, 0x2D, 0x53,
        0x4D, 0x33, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x53, 0x69, 0x67,
        0x6E, 0x61, 0x74, 0x75, 0x72, 0x65, 0x20, 0x56, 0x61, 0x6C,
        0x75, 0x65, 0x3A, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x33, 0x30, 0x3A, 0x34, 0x34, 0x3A, 0x30, 0x32,
        0x3A, 0x32, 0x30, 0x3A, 0x30, 0x33, 0x3A, 0x32, 0x37, 0x3A,
        0x32, 0x39, 0x3A, 0x66, 0x30, 0x3A, 0x65, 0x66, 0x3A, 0x37,
        0x38, 0x3A, 0x32, 0x36, 0x3A, 0x61, 0x31, 0x3A, 0x31, 0x61,
        0x3A, 0x36, 0x61, 0x3A, 0x31, 0x65, 0x3A, 0x38, 0x38, 0x3A,
        0x38, 0x31, 0x3A, 0x65, 0x37, 0x3A, 0x0A, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x38, 0x33, 0x3A, 0x37, 0x32,
        0x3A, 0x35, 0x66, 0x3A, 0x33, 0x65, 0x3A, 0x65, 0x36, 0x3A,
        0x30, 0x38, 0x3A, 0x65, 0x38, 0x3A, 0x31, 0x34, 0x3A, 0x36,
        0x38, 0x3A, 0x62, 0x66, 0x3A, 0x34, 0x62, 0x3A, 0x30, 0x66,
        0x3A, 0x36, 0x38, 0x3A, 0x35, 0x32, 0x3A, 0x39, 0x32, 0x3A,
        0x61, 0x61, 0x3A, 0x38, 0x66, 0x3A, 0x61, 0x31, 0x3A, 0x0A,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x30, 0x32,
        0x3A, 0x32, 0x30, 0x3A, 0x30, 0x62, 0x3A, 0x66, 0x65, 0x3A,
        0x31, 0x62, 0x3A, 0x31, 0x34, 0x3A, 0x62, 0x61, 0x3A, 0x35,
        0x31, 0x3A, 0x38, 0x32, 0x3A, 0x36, 0x35, 0x3A, 0x30, 0x36,
        0x3A, 0x62, 0x62, 0x3A, 0x32, 0x32, 0x3A, 0x64, 0x38, 0x3A,
        0x31, 0x61, 0x3A, 0x61, 0x37, 0x3A, 0x39, 0x66, 0x3A, 0x35,
        0x34, 0x3A, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x36, 0x32, 0x3A, 0x65, 0x62, 0x3A, 0x38, 0x64, 0x3A,
        0x62, 0x32, 0x3A, 0x64, 0x35, 0x3A, 0x31, 0x33, 0x3A, 0x62,
        0x33, 0x3A, 0x62, 0x38, 0x3A, 0x61, 0x32, 0x3A, 0x66, 0x33,
        0x3A, 0x31, 0x34, 0x3A, 0x34, 0x34, 0x3A, 0x62, 0x32, 0x3A,
        0x61, 0x30, 0x3A, 0x32, 0x31, 0x3A, 0x64, 0x30, 0x0A, 0x2D,
        0x2D, 0x2D, 0x2D, 0x2D, 0x42, 0x45, 0x47, 0x49, 0x4E, 0x20,
        0x43, 0x45, 0x52, 0x54, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54,
        0x45, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x0A, 0x4D, 0x49, 0x49,
        0x43, 0x6B, 0x54, 0x43, 0x43, 0x41, 0x6A, 0x69, 0x67, 0x41,
        0x77, 0x49, 0x42, 0x41, 0x67, 0x49, 0x55, 0x64, 0x4A, 0x7A,
        0x64, 0x70, 0x4C, 0x4A, 0x6E, 0x4A, 0x6C, 0x63, 0x70, 0x2B,
        0x2B, 0x6B, 0x54, 0x56, 0x4F, 0x41, 0x30, 0x43, 0x41, 0x4D,
        0x72, 0x63, 0x4B, 0x6B, 0x77, 0x43, 0x67, 0x59, 0x49, 0x4B,
        0x6F, 0x45, 0x63, 0x7A, 0x31, 0x55, 0x42, 0x67, 0x33, 0x55,
        0x77, 0x0A, 0x67, 0x5A, 0x55, 0x78, 0x43, 0x7A, 0x41, 0x4A,
        0x42, 0x67, 0x4E, 0x56, 0x42, 0x41, 0x59, 0x54, 0x41, 0x6C,
        0x56, 0x54, 0x4D, 0x52, 0x41, 0x77, 0x44, 0x67, 0x59, 0x44,
        0x56, 0x51, 0x51, 0x49, 0x44, 0x41, 0x64, 0x4E, 0x62, 0x32,
        0x35, 0x30, 0x59, 0x57, 0x35, 0x68, 0x4D, 0x52, 0x41, 0x77,
        0x44, 0x67, 0x59, 0x44, 0x56, 0x51, 0x51, 0x48, 0x44, 0x41,
        0x64, 0x43, 0x62, 0x33, 0x70, 0x6C, 0x0A, 0x62, 0x57, 0x46,
        0x75, 0x4D, 0x52, 0x51, 0x77, 0x45, 0x67, 0x59, 0x44, 0x56,
        0x51, 0x51, 0x4B, 0x44, 0x41, 0x74, 0x33, 0x62, 0x32, 0x78,
        0x6D, 0x55, 0x31, 0x4E, 0x4D, 0x58, 0x31, 0x4E, 0x4E, 0x4D,
        0x6A, 0x45, 0x52, 0x4D, 0x41, 0x38, 0x47, 0x41, 0x31, 0x55,
        0x45, 0x43, 0x77, 0x77, 0x49, 0x55, 0x6D, 0x39, 0x76, 0x64,
        0x43, 0x31, 0x54, 0x54, 0x54, 0x49, 0x78, 0x47, 0x44, 0x41,
        0x57, 0x0A, 0x42, 0x67, 0x4E, 0x56, 0x42, 0x41, 0x4D, 0x4D,
        0x44, 0x33, 0x64, 0x33, 0x64, 0x79, 0x35, 0x33, 0x62, 0x32,
        0x78, 0x6D, 0x63, 0x33, 0x4E, 0x73, 0x4C, 0x6D, 0x4E, 0x76,
        0x62, 0x54, 0x45, 0x66, 0x4D, 0x42, 0x30, 0x47, 0x43, 0x53,
        0x71, 0x47, 0x53, 0x49, 0x62, 0x33, 0x44, 0x51, 0x45, 0x4A,
        0x41, 0x52, 0x59, 0x51, 0x61, 0x57, 0x35, 0x6D, 0x62, 0x30,
        0x42, 0x33, 0x62, 0x32, 0x78, 0x6D, 0x0A, 0x63, 0x33, 0x4E,
        0x73, 0x4C, 0x6D, 0x4E, 0x76, 0x62, 0x54, 0x41, 0x65, 0x46,
        0x77, 0x30, 0x79, 0x4D, 0x7A, 0x41, 0x79, 0x4D, 0x54, 0x55,
        0x77, 0x4E, 0x6A, 0x49, 0x7A, 0x4D, 0x44, 0x64, 0x61, 0x46,
        0x77, 0x30, 0x79, 0x4E, 0x54, 0x45, 0x78, 0x4D, 0x54, 0x45,
        0x77, 0x4E, 0x6A, 0x49, 0x7A, 0x4D, 0x44, 0x64, 0x61, 0x4D,
        0x49, 0x47, 0x56, 0x4D, 0x51, 0x73, 0x77, 0x43, 0x51, 0x59,
        0x44, 0x0A, 0x56, 0x51, 0x51, 0x47, 0x45, 0x77, 0x4A, 0x56,
        0x55, 0x7A, 0x45, 0x51, 0x4D, 0x41, 0x34, 0x47, 0x41, 0x31,
        0x55, 0x45, 0x43, 0x41, 0x77, 0x48, 0x54, 0x57, 0x39, 0x75,
        0x64, 0x47, 0x46, 0x75, 0x59, 0x54, 0x45, 0x51, 0x4D, 0x41,
        0x34, 0x47, 0x41, 0x31, 0x55, 0x45, 0x42, 0x77, 0x77, 0x48,
        0x51, 0x6D, 0x39, 0x36, 0x5A, 0x57, 0x31, 0x68, 0x62, 0x6A,
        0x45, 0x55, 0x4D, 0x42, 0x49, 0x47, 0x0A, 0x41, 0x31, 0x55,
        0x45, 0x43, 0x67, 0x77, 0x4C, 0x64, 0x32, 0x39, 0x73, 0x5A,
        0x6C, 0x4E, 0x54, 0x54, 0x46, 0x39, 0x54, 0x54, 0x54, 0x49,
        0x78, 0x45, 0x54, 0x41, 0x50, 0x42, 0x67, 0x4E, 0x56, 0x42,
        0x41, 0x73, 0x4D, 0x43, 0x46, 0x4A, 0x76, 0x62, 0x33, 0x51,
        0x74, 0x55, 0x30, 0x30, 0x79, 0x4D, 0x52, 0x67, 0x77, 0x46,
        0x67, 0x59, 0x44, 0x56, 0x51, 0x51, 0x44, 0x44, 0x41, 0x39,
        0x33, 0x0A, 0x64, 0x33, 0x63, 0x75, 0x64, 0x32, 0x39, 0x73,
        0x5A, 0x6E, 0x4E, 0x7A, 0x62, 0x43, 0x35, 0x6A, 0x62, 0x32,
        0x30, 0x78, 0x48, 0x7A, 0x41, 0x64, 0x42, 0x67, 0x6B, 0x71,
        0x68, 0x6B, 0x69, 0x47, 0x39, 0x77, 0x30, 0x42, 0x43, 0x51,
        0x45, 0x57, 0x45, 0x47, 0x6C, 0x75, 0x5A, 0x6D, 0x39, 0x41,
        0x64, 0x32, 0x39, 0x73, 0x5A, 0x6E, 0x4E, 0x7A, 0x62, 0x43,
        0x35, 0x6A, 0x62, 0x32, 0x30, 0x77, 0x0A, 0x57, 0x6A, 0x41,
        0x55, 0x42, 0x67, 0x67, 0x71, 0x67, 0x52, 0x7A, 0x50, 0x56,
        0x51, 0x47, 0x43, 0x4C, 0x51, 0x59, 0x49, 0x4B, 0x6F, 0x45,
        0x63, 0x7A, 0x31, 0x55, 0x42, 0x67, 0x69, 0x30, 0x44, 0x51,
        0x67, 0x41, 0x45, 0x75, 0x35, 0x78, 0x31, 0x6A, 0x50, 0x63,
        0x58, 0x2B, 0x45, 0x69, 0x72, 0x39, 0x2F, 0x62, 0x62, 0x44,
        0x5A, 0x71, 0x4E, 0x6E, 0x38, 0x4C, 0x52, 0x52, 0x35, 0x65,
        0x56, 0x0A, 0x43, 0x30, 0x37, 0x6D, 0x56, 0x2B, 0x7A, 0x46,
        0x2B, 0x46, 0x64, 0x55, 0x63, 0x54, 0x6B, 0x38, 0x65, 0x65,
        0x46, 0x41, 0x50, 0x37, 0x5A, 0x52, 0x36, 0x58, 0x7A, 0x48,
        0x32, 0x69, 0x33, 0x76, 0x30, 0x75, 0x68, 0x35, 0x67, 0x58,
        0x75, 0x72, 0x6F, 0x31, 0x39, 0x72, 0x4B, 0x6D, 0x79, 0x58,
        0x47, 0x6C, 0x36, 0x4F, 0x32, 0x64, 0x44, 0x4D, 0x42, 0x4B,
        0x4E, 0x6A, 0x4D, 0x47, 0x45, 0x77, 0x0A, 0x48, 0x51, 0x59,
        0x44, 0x56, 0x52, 0x30, 0x4F, 0x42, 0x42, 0x59, 0x45, 0x46,
        0x44, 0x51, 0x64, 0x65, 0x55, 0x51, 0x56, 0x65, 0x61, 0x47,
        0x78, 0x59, 0x35, 0x6E, 0x6A, 0x37, 0x57, 0x56, 0x38, 0x5A,
        0x49, 0x6D, 0x41, 0x2F, 0x37, 0x6A, 0x73, 0x4D, 0x42, 0x38,
        0x47, 0x41, 0x31, 0x55, 0x64, 0x49, 0x77, 0x51, 0x59, 0x4D,
        0x42, 0x61, 0x41, 0x46, 0x44, 0x51, 0x64, 0x65, 0x55, 0x51,
        0x56, 0x0A, 0x65, 0x61, 0x47, 0x78, 0x59, 0x35, 0x6E, 0x6A,
        0x37, 0x57, 0x56, 0x38, 0x5A, 0x49, 0x6D, 0x41, 0x2F, 0x37,
        0x6A, 0x73, 0x4D, 0x41, 0x38, 0x47, 0x41, 0x31, 0x55, 0x64,
        0x45, 0x77, 0x45, 0x42, 0x2F, 0x77, 0x51, 0x46, 0x4D, 0x41,
        0x4D, 0x42, 0x41, 0x66, 0x38, 0x77, 0x44, 0x67, 0x59, 0x44,
        0x56, 0x52, 0x30, 0x50, 0x41, 0x51, 0x48, 0x2F, 0x42, 0x41,
        0x51, 0x44, 0x41, 0x67, 0x47, 0x47, 0x0A, 0x4D, 0x41, 0x6F,
        0x47, 0x43, 0x43, 0x71, 0x42, 0x48, 0x4D, 0x39, 0x56, 0x41,
        0x59, 0x4E, 0x31, 0x41, 0x30, 0x63, 0x41, 0x4D, 0x45, 0x51,
        0x43, 0x49, 0x41, 0x4D, 0x6E, 0x4B, 0x66, 0x44, 0x76, 0x65,
        0x43, 0x61, 0x68, 0x47, 0x6D, 0x6F, 0x65, 0x69, 0x49, 0x48,
        0x6E, 0x67, 0x33, 0x4A, 0x66, 0x50, 0x75, 0x59, 0x49, 0x36,
        0x42, 0x52, 0x6F, 0x76, 0x30, 0x73, 0x50, 0x61, 0x46, 0x4B,
        0x53, 0x0A, 0x71, 0x6F, 0x2B, 0x68, 0x41, 0x69, 0x41, 0x4C,
        0x2F, 0x68, 0x73, 0x55, 0x75, 0x6C, 0x47, 0x43, 0x5A, 0x51,
        0x61, 0x37, 0x49, 0x74, 0x67, 0x61, 0x70, 0x35, 0x39, 0x55,
        0x59, 0x75, 0x75, 0x4E, 0x73, 0x74, 0x55, 0x54, 0x73, 0x37,
        0x69, 0x69, 0x38, 0x78, 0x52, 0x45, 0x73, 0x71, 0x41, 0x68,
        0x30, 0x41, 0x3D, 0x3D, 0x0A, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
        0x45, 0x4E, 0x44, 0x20, 0x43, 0x45, 0x52, 0x54, 0x49, 0x46,
        0x49, 0x43, 0x41, 0x54, 0x45, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D,
        0x0A
};
#define sizeof_root_sm2 (sizeof(root_sm2))

/* ./certs/sm2/root-sm2-key.pem */
static const unsigned char root_sm2_key[] =
{
        0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x42, 0x45, 0x47, 0x49, 0x4E,
        0x20, 0x50, 0x55, 0x42, 0x4C, 0x49, 0x43, 0x20, 0x4B, 0x45,
        0x59, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x0A, 0x4D, 0x46, 0x6F,
        0x77, 0x46, 0x41, 0x59, 0x49, 0x4B, 0x6F, 0x45, 0x63, 0x7A,
        0x31, 0x55, 0x42, 0x67, 0x69, 0x30, 0x47, 0x43, 0x43, 0x71,
        0x42, 0x48, 0x4D, 0x39, 0x56, 0x41, 0x59, 0x49, 0x74, 0x41,
        0x30, 0x49, 0x41, 0x42, 0x4C, 0x75, 0x63, 0x64, 0x59, 0x7A,
        0x33, 0x46, 0x2F, 0x68, 0x49, 0x71, 0x2F, 0x66, 0x32, 0x32,
        0x77, 0x32, 0x61, 0x6A, 0x5A, 0x2F, 0x43, 0x30, 0x55, 0x65,
        0x58, 0x0A, 0x6C, 0x51, 0x74, 0x4F, 0x35, 0x6C, 0x66, 0x73,
        0x78, 0x66, 0x68, 0x58, 0x56, 0x48, 0x45, 0x35, 0x50, 0x48,
        0x6E, 0x68, 0x51, 0x44, 0x2B, 0x32, 0x55, 0x65, 0x6C, 0x38,
        0x78, 0x39, 0x6F, 0x74, 0x37, 0x39, 0x4C, 0x6F, 0x65, 0x59,
        0x46, 0x37, 0x71, 0x36, 0x4E, 0x66, 0x61, 0x79, 0x70, 0x73,
        0x6C, 0x78, 0x70, 0x65, 0x6A, 0x74, 0x6E, 0x51, 0x7A, 0x41,
        0x51, 0x3D, 0x0A, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x45, 0x4E,
        0x44, 0x20, 0x50, 0x55, 0x42, 0x4C, 0x49, 0x43, 0x20, 0x4B,
        0x45, 0x59, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x0A
};
#define sizeof_root_sm2_key (sizeof(root_sm2_key))

/* ./certs/sm2/root-sm2-priv.pem */
static const unsigned char root_sm2_priv[] =
{
        0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x42, 0x45, 0x47, 0x49, 0x4E,
        0x20, 0x50, 0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x20, 0x4B,
        0x45, 0x59, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x0A, 0x4D, 0x49,
        0x47, 0x49, 0x41, 0x67, 0x45, 0x41, 0x4D, 0x42, 0x51, 0x47,
        0x43, 0x43, 0x71, 0x42, 0x48, 0x4D, 0x39, 0x56, 0x41, 0x59,
        0x49, 0x74, 0x42, 0x67, 0x67, 0x71, 0x67, 0x52, 0x7A, 0x50,
        0x56, 0x51, 0x47, 0x43, 0x4C, 0x51, 0x52, 0x74, 0x4D, 0x47,
        0x73, 0x43, 0x41, 0x51, 0x45, 0x45, 0x49, 0x4D, 0x5A, 0x72,
        0x4E, 0x45, 0x77, 0x7A, 0x4E, 0x31, 0x74, 0x6B, 0x46, 0x6C,
        0x70, 0x2F, 0x0A, 0x42, 0x50, 0x6E, 0x38, 0x68, 0x7A, 0x44,
        0x52, 0x46, 0x62, 0x70, 0x59, 0x65, 0x4F, 0x34, 0x48, 0x6D,
        0x43, 0x41, 0x6D, 0x34, 0x51, 0x61, 0x4E, 0x55, 0x59, 0x6F,
        0x6F, 0x6F, 0x55, 0x51, 0x44, 0x51, 0x67, 0x41, 0x45, 0x75,
        0x35, 0x78, 0x31, 0x6A, 0x50, 0x63, 0x58, 0x2B, 0x45, 0x69,
        0x72, 0x39, 0x2F, 0x62, 0x62, 0x44, 0x5A, 0x71, 0x4E, 0x6E,
        0x38, 0x4C, 0x52, 0x52, 0x35, 0x65, 0x56, 0x0A, 0x43, 0x30,
        0x37, 0x6D, 0x56, 0x2B, 0x7A, 0x46, 0x2B, 0x46, 0x64, 0x55,
        0x63, 0x54, 0x6B, 0x38, 0x65, 0x65, 0x46, 0x41, 0x50, 0x37,
        0x5A, 0x52, 0x36, 0x58, 0x7A, 0x48, 0x32, 0x69, 0x33, 0x76,
        0x30, 0x75, 0x68, 0x35, 0x67, 0x58, 0x75, 0x72, 0x6F, 0x31,
        0x39, 0x72, 0x4B, 0x6D, 0x79, 0x58, 0x47, 0x6C, 0x36, 0x4F,
        0x32, 0x64, 0x44, 0x4D, 0x42, 0x41, 0x3D, 0x3D, 0x0A, 0x2D,
        0x2D, 0x2D, 0x2D, 0x2D, 0x45, 0x4E, 0x44, 0x20, 0x50, 0x52,
        0x49, 0x56, 0x41, 0x54, 0x45, 0x20, 0x4B, 0x45, 0x59, 0x2D,
        0x2D, 0x2D, 0x2D, 0x2D, 0x0A
};
#define sizeof_root_sm2_priv (sizeof(root_sm2_priv))

/* ./certs/sm2/self-sm2-cert.pem */
static const unsigned char self_sm2_cert[] =
{
        0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
        0x65, 0x3A, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x44, 0x61, 0x74,
        0x61, 0x3A, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6F, 0x6E, 0x3A, 0x20,
        0x33, 0x20, 0x28, 0x30, 0x78, 0x32, 0x29, 0x0A, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x53, 0x65, 0x72, 0x69,
        0x61, 0x6C, 0x20, 0x4E, 0x75, 0x6D, 0x62, 0x65, 0x72, 0x3A,
        0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x30, 0x36, 0x3A, 0x37, 0x62, 0x3A, 0x33,
        0x61, 0x3A, 0x35, 0x64, 0x3A, 0x63, 0x66, 0x3A, 0x32, 0x32,
        0x3A, 0x61, 0x39, 0x3A, 0x36, 0x64, 0x3A, 0x36, 0x64, 0x3A,
        0x37, 0x38, 0x3A, 0x32, 0x62, 0x3A, 0x31, 0x30, 0x3A, 0x30,
        0x31, 0x3A, 0x35, 0x31, 0x3A, 0x62, 0x36, 0x3A, 0x34, 0x63,
        0x3A, 0x64, 0x34, 0x3A, 0x38, 0x32, 0x3A, 0x61, 0x32, 0x3A,
        0x61, 0x31, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x53, 0x69, 0x67, 0x6E, 0x61, 0x74, 0x75, 0x72, 0x65,
        0x20, 0x41, 0x6C, 0x67, 0x6F, 0x72, 0x69, 0x74, 0x68, 0x6D,
        0x3A, 0x20, 0x53, 0x4D, 0x32, 0x2D, 0x77, 0x69, 0x74, 0x68,
        0x2D, 0x53, 0x4D, 0x33, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x49, 0x73, 0x73, 0x75, 0x65, 0x72, 0x3A,
        0x20, 0x43, 0x20, 0x3D, 0x20, 0x41, 0x55, 0x2C, 0x20, 0x53,
        0x54, 0x20, 0x3D, 0x20, 0x51, 0x4C, 0x44, 0x2C, 0x20, 0x4F,
        0x20, 0x3D, 0x20, 0x77, 0x6F, 0x6C, 0x66, 0x53, 0x53, 0x4C,
        0x2C, 0x20, 0x4F, 0x55, 0x20, 0x3D, 0x20, 0x54, 0x65, 0x73,
        0x74, 0x69, 0x6E, 0x67, 0x2C, 0x20, 0x43, 0x4E, 0x20, 0x3D,
        0x20, 0x77, 0x6F, 0x6C, 0x66, 0x73, 0x73, 0x6C, 0x2D, 0x64,
        0x65, 0x76, 0x2D, 0x73, 0x6D, 0x32, 0x2C, 0x20, 0x65, 0x6D,
        0x61, 0x69, 0x6C, 0x41, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73,
        0x20, 0x3D, 0x20, 0x69, 0x6E, 0x66, 0x6F, 0x40, 0x77, 0x6F,
        0x6C, 0x66, 0x73, 0x73, 0x6C, 0x2E, 0x63, 0x6F, 0x6D, 0x2C,
        0x20, 0x55, 0x49, 0x44, 0x20, 0x3D, 0x20, 0x77, 0x6F, 0x6C,
        0x66, 0x53, 0x53, 0x4C, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x56, 0x61, 0x6C, 0x69, 0x64, 0x69, 0x74,
        0x79, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x4E, 0x6F, 0x74, 0x20, 0x42, 0x65,
        0x66, 0x6F, 0x72, 0x65, 0x3A, 0x20, 0x4E, 0x6F, 0x76, 0x20,
        0x32, 0x32, 0x20, 0x32, 0x31, 0x3A, 0x32, 0x38, 0x3A, 0x33,
        0x37, 0x20, 0x32, 0x30, 0x32, 0x33, 0x20, 0x47, 0x4D, 0x54,
        0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x4E, 0x6F, 0x74, 0x20, 0x41, 0x66, 0x74,
        0x65, 0x72, 0x20, 0x3A, 0x20, 0x41, 0x75, 0x67, 0x20, 0x31,
        0x38, 0x20, 0x32, 0x31, 0x3A, 0x32, 0x38, 0x3A, 0x33, 0x37,
        0x20, 0x32, 0x30, 0x32, 0x36, 0x20, 0x47, 0x4D, 0x54, 0x0A,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x53, 0x75,
        0x62, 0x6A, 0x65, 0x63, 0x74, 0x3A, 0x20, 0x43, 0x20, 0x3D,
        0x20, 0x41, 0x55, 0x2C, 0x20, 0x53, 0x54, 0x20, 0x3D, 0x20,
        0x51, 0x4C, 0x44, 0x2C, 0x20, 0x4F, 0x20, 0x3D, 0x20, 0x77,
        0x6F, 0x6C, 0x66, 0x53, 0x53, 0x4C, 0x2C, 0x20, 0x4F, 0x55,
        0x20, 0x3D, 0x20, 0x54, 0x65, 0x73, 0x74, 0x69, 0x6E, 0x67,
        0x2C, 0x20, 0x43, 0x4E, 0x20, 0x3D, 0x20, 0x77, 0x6F, 0x6C,
        0x66, 0x73, 0x73, 0x6C, 0x2D, 0x64, 0x65, 0x76, 0x2D, 0x73,
        0x6D, 0x32, 0x2C, 0x20, 0x65, 0x6D, 0x61, 0x69, 0x6C, 0x41,
        0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x20, 0x3D, 0x20, 0x69,
        0x6E, 0x66, 0x6F, 0x40, 0x77, 0x6F, 0x6C, 0x66, 0x73, 0x73,
        0x6C, 0x2E, 0x63, 0x6F, 0x6D, 0x2C, 0x20, 0x55, 0x49, 0x44,
        0x20, 0x3D, 0x20, 0x77, 0x6F, 0x6C, 0x66, 0x53, 0x53, 0x4C,
        0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x53,
        0x75, 0x62, 0x6A, 0x65, 0x63, 0x74, 0x20, 0x50, 0x75, 0x62,
        0x6C, 0x69, 0x63, 0x20, 0x4B, 0x65, 0x79, 0x20, 0x49, 0x6E,
        0x66, 0x6F, 0x3A, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x50, 0x75, 0x62, 0x6C,
        0x69, 0x63, 0x20, 0x4B, 0x65, 0x79, 0x20, 0x41, 0x6C, 0x67,
        0x6F, 0x72, 0x69, 0x74, 0x68, 0x6D, 0x3A, 0x20, 0x69, 0x64,
        0x2D, 0x65, 0x63, 0x50, 0x75, 0x62, 0x6C, 0x69, 0x63, 0x4B,
        0x65, 0x79, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x50,
        0x75, 0x62, 0x6C, 0x69, 0x63, 0x2D, 0x4B, 0x65, 0x79, 0x3A,
        0x20, 0x28, 0x32, 0x35, 0x36, 0x20, 0x62, 0x69, 0x74, 0x29,
        0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x70, 0x75, 0x62,
        0x3A, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x30, 0x34, 0x3A, 0x64, 0x38, 0x3A, 0x63, 0x34,
        0x3A, 0x61, 0x31, 0x3A, 0x66, 0x31, 0x3A, 0x30, 0x62, 0x3A,
        0x38, 0x62, 0x3A, 0x38, 0x64, 0x3A, 0x63, 0x34, 0x3A, 0x37,
        0x64, 0x3A, 0x64, 0x63, 0x3A, 0x64, 0x34, 0x3A, 0x36, 0x35,
        0x3A, 0x62, 0x39, 0x3A, 0x61, 0x35, 0x3A, 0x0A, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x35, 0x35,
        0x3A, 0x34, 0x65, 0x3A, 0x66, 0x62, 0x3A, 0x61, 0x63, 0x3A,
        0x33, 0x33, 0x3A, 0x61, 0x62, 0x3A, 0x39, 0x62, 0x3A, 0x34,
        0x33, 0x3A, 0x39, 0x34, 0x3A, 0x34, 0x63, 0x3A, 0x34, 0x38,
        0x3A, 0x34, 0x30, 0x3A, 0x31, 0x62, 0x3A, 0x33, 0x33, 0x3A,
        0x64, 0x39, 0x3A, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x31, 0x62, 0x3A, 0x63, 0x63, 0x3A,
        0x33, 0x31, 0x3A, 0x63, 0x31, 0x3A, 0x38, 0x32, 0x3A, 0x35,
        0x36, 0x3A, 0x33, 0x66, 0x3A, 0x62, 0x30, 0x3A, 0x63, 0x30,
        0x3A, 0x36, 0x62, 0x3A, 0x39, 0x35, 0x3A, 0x34, 0x30, 0x3A,
        0x35, 0x31, 0x3A, 0x66, 0x64, 0x3A, 0x38, 0x38, 0x3A, 0x0A,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x30, 0x32, 0x3A, 0x30, 0x31, 0x3A, 0x62, 0x31, 0x3A, 0x62,
        0x30, 0x3A, 0x39, 0x34, 0x3A, 0x36, 0x63, 0x3A, 0x30, 0x36,
        0x3A, 0x65, 0x62, 0x3A, 0x61, 0x37, 0x3A, 0x64, 0x61, 0x3A,
        0x38, 0x65, 0x3A, 0x65, 0x65, 0x3A, 0x37, 0x30, 0x3A, 0x62,
        0x36, 0x3A, 0x65, 0x35, 0x3A, 0x0A, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x62, 0x62, 0x3A, 0x62,
        0x34, 0x3A, 0x31, 0x65, 0x3A, 0x65, 0x37, 0x3A, 0x62, 0x34,
        0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x41, 0x53, 0x4E,
        0x31, 0x20, 0x4F, 0x49, 0x44, 0x3A, 0x20, 0x53, 0x4D, 0x32,
        0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x58,
        0x35, 0x30, 0x39, 0x76, 0x33, 0x20, 0x65, 0x78, 0x74, 0x65,
        0x6E, 0x73, 0x69, 0x6F, 0x6E, 0x73, 0x3A, 0x0A, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x58, 0x35, 0x30, 0x39, 0x76, 0x33, 0x20, 0x53, 0x75, 0x62,
        0x6A, 0x65, 0x63, 0x74, 0x20, 0x4B, 0x65, 0x79, 0x20, 0x49,
        0x64, 0x65, 0x6E, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x3A,
        0x20, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x36, 0x45,
        0x3A, 0x39, 0x37, 0x3A, 0x45, 0x38, 0x3A, 0x39, 0x38, 0x3A,
        0x42, 0x36, 0x3A, 0x35, 0x42, 0x3A, 0x42, 0x36, 0x3A, 0x41,
        0x45, 0x3A, 0x38, 0x37, 0x3A, 0x30, 0x34, 0x3A, 0x44, 0x42,
        0x3A, 0x31, 0x34, 0x3A, 0x35, 0x36, 0x3A, 0x36, 0x36, 0x3A,
        0x31, 0x36, 0x3A, 0x46, 0x34, 0x3A, 0x42, 0x38, 0x3A, 0x32,
        0x44, 0x3A, 0x38, 0x43, 0x3A, 0x46, 0x32, 0x0A, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x58, 0x35, 0x30, 0x39, 0x76, 0x33, 0x20, 0x41, 0x75, 0x74,
        0x68, 0x6F, 0x72, 0x69, 0x74, 0x79, 0x20, 0x4B, 0x65, 0x79,
        0x20, 0x49, 0x64, 0x65, 0x6E, 0x74, 0x69, 0x66, 0x69, 0x65,
        0x72, 0x3A, 0x20, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x36, 0x45, 0x3A, 0x39, 0x37, 0x3A, 0x45, 0x38, 0x3A, 0x39,
        0x38, 0x3A, 0x42, 0x36, 0x3A, 0x35, 0x42, 0x3A, 0x42, 0x36,
        0x3A, 0x41, 0x45, 0x3A, 0x38, 0x37, 0x3A, 0x30, 0x34, 0x3A,
        0x44, 0x42, 0x3A, 0x31, 0x34, 0x3A, 0x35, 0x36, 0x3A, 0x36,
        0x36, 0x3A, 0x31, 0x36, 0x3A, 0x46, 0x34, 0x3A, 0x42, 0x38,
        0x3A, 0x32, 0x44, 0x3A, 0x38, 0x43, 0x3A, 0x46, 0x32, 0x0A,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x58, 0x35, 0x30, 0x39, 0x76, 0x33, 0x20, 0x42,
        0x61, 0x73, 0x69, 0x63, 0x20, 0x43, 0x6F, 0x6E, 0x73, 0x74,
        0x72, 0x61, 0x69, 0x6E, 0x74, 0x73, 0x3A, 0x20, 0x63, 0x72,
        0x69, 0x74, 0x69, 0x63, 0x61, 0x6C, 0x0A, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x43, 0x41, 0x3A, 0x54, 0x52, 0x55, 0x45,
        0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x58, 0x35, 0x30, 0x39, 0x76, 0x33, 0x20,
        0x4B, 0x65, 0x79, 0x20, 0x55, 0x73, 0x61, 0x67, 0x65, 0x3A,
        0x20, 0x63, 0x72, 0x69, 0x74, 0x69, 0x63, 0x61, 0x6C, 0x0A,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x44, 0x69, 0x67, 0x69,
        0x74, 0x61, 0x6C, 0x20, 0x53, 0x69, 0x67, 0x6E, 0x61, 0x74,
        0x75, 0x72, 0x65, 0x2C, 0x20, 0x43, 0x65, 0x72, 0x74, 0x69,
        0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x20, 0x53, 0x69, 0x67,
        0x6E, 0x2C, 0x20, 0x43, 0x52, 0x4C, 0x20, 0x53, 0x69, 0x67,
        0x6E, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x53, 0x69, 0x67, 0x6E,
        0x61, 0x74, 0x75, 0x72, 0x65, 0x20, 0x41, 0x6C, 0x67, 0x6F,
        0x72, 0x69, 0x74, 0x68, 0x6D, 0x3A, 0x20, 0x53, 0x4D, 0x32,
        0x2D, 0x77, 0x69, 0x74, 0x68, 0x2D, 0x53, 0x4D, 0x33, 0x0A,
        0x20, 0x20, 0x20, 0x20, 0x53, 0x69, 0x67, 0x6E, 0x61, 0x74,
        0x75, 0x72, 0x65, 0x20, 0x56, 0x61, 0x6C, 0x75, 0x65, 0x3A,
        0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x33,
        0x30, 0x3A, 0x34, 0x34, 0x3A, 0x30, 0x32, 0x3A, 0x32, 0x30,
        0x3A, 0x30, 0x66, 0x3A, 0x63, 0x33, 0x3A, 0x32, 0x63, 0x3A,
        0x33, 0x36, 0x3A, 0x65, 0x33, 0x3A, 0x39, 0x66, 0x3A, 0x31,
        0x63, 0x3A, 0x65, 0x39, 0x3A, 0x36, 0x38, 0x3A, 0x31, 0x63,
        0x3A, 0x33, 0x62, 0x3A, 0x34, 0x33, 0x3A, 0x31, 0x38, 0x3A,
        0x35, 0x62, 0x3A, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x63, 0x39, 0x3A, 0x38, 0x66, 0x3A, 0x65, 0x34,
        0x3A, 0x66, 0x61, 0x3A, 0x64, 0x64, 0x3A, 0x33, 0x33, 0x3A,
        0x63, 0x31, 0x3A, 0x62, 0x38, 0x3A, 0x31, 0x63, 0x3A, 0x64,
        0x33, 0x3A, 0x64, 0x34, 0x3A, 0x36, 0x31, 0x3A, 0x33, 0x33,
        0x3A, 0x66, 0x38, 0x3A, 0x33, 0x37, 0x3A, 0x39, 0x64, 0x3A,
        0x35, 0x61, 0x3A, 0x66, 0x34, 0x3A, 0x0A, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x30, 0x32, 0x3A, 0x32, 0x30,
        0x3A, 0x33, 0x61, 0x3A, 0x62, 0x39, 0x3A, 0x61, 0x38, 0x3A,
        0x34, 0x33, 0x3A, 0x38, 0x30, 0x3A, 0x63, 0x66, 0x3A, 0x33,
        0x38, 0x3A, 0x32, 0x35, 0x3A, 0x65, 0x39, 0x3A, 0x36, 0x34,
        0x3A, 0x64, 0x38, 0x3A, 0x32, 0x36, 0x3A, 0x34, 0x37, 0x3A,
        0x39, 0x64, 0x3A, 0x35, 0x30, 0x3A, 0x30, 0x34, 0x3A, 0x0A,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x30, 0x63,
        0x3A, 0x38, 0x61, 0x3A, 0x65, 0x38, 0x3A, 0x61, 0x32, 0x3A,
        0x34, 0x32, 0x3A, 0x65, 0x38, 0x3A, 0x36, 0x33, 0x3A, 0x64,
        0x64, 0x3A, 0x35, 0x33, 0x3A, 0x39, 0x34, 0x3A, 0x37, 0x64,
        0x3A, 0x33, 0x38, 0x3A, 0x36, 0x64, 0x3A, 0x35, 0x32, 0x3A,
        0x37, 0x30, 0x3A, 0x66, 0x64, 0x0A, 0x2D, 0x2D, 0x2D, 0x2D,
        0x2D, 0x42, 0x45, 0x47, 0x49, 0x4E, 0x20, 0x43, 0x45, 0x52,
        0x54, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x45, 0x2D, 0x2D,
        0x2D, 0x2D, 0x2D, 0x0A, 0x4D, 0x49, 0x49, 0x43, 0x6A, 0x44,
        0x43, 0x43, 0x41, 0x6A, 0x4F, 0x67, 0x41, 0x77, 0x49, 0x42,
        0x41, 0x67, 0x49, 0x55, 0x42, 0x6E, 0x73, 0x36, 0x58, 0x63,
        0x38, 0x69, 0x71, 0x57, 0x31, 0x74, 0x65, 0x43, 0x73, 0x51,
        0x41, 0x56, 0x47, 0x32, 0x54, 0x4E, 0x53, 0x43, 0x6F, 0x71,
        0x45, 0x77, 0x43, 0x67, 0x59, 0x49, 0x4B, 0x6F, 0x45, 0x63,
        0x7A, 0x31, 0x55, 0x42, 0x67, 0x33, 0x55, 0x77, 0x0A, 0x67,
        0x5A, 0x4D, 0x78, 0x43, 0x7A, 0x41, 0x4A, 0x42, 0x67, 0x4E,
        0x56, 0x42, 0x41, 0x59, 0x54, 0x41, 0x6B, 0x46, 0x56, 0x4D,
        0x51, 0x77, 0x77, 0x43, 0x67, 0x59, 0x44, 0x56, 0x51, 0x51,
        0x49, 0x44, 0x41, 0x4E, 0x52, 0x54, 0x45, 0x51, 0x78, 0x45,
        0x44, 0x41, 0x4F, 0x42, 0x67, 0x4E, 0x56, 0x42, 0x41, 0x6F,
        0x4D, 0x42, 0x33, 0x64, 0x76, 0x62, 0x47, 0x5A, 0x54, 0x55,
        0x30, 0x77, 0x78, 0x0A, 0x45, 0x44, 0x41, 0x4F, 0x42, 0x67,
        0x4E, 0x56, 0x42, 0x41, 0x73, 0x4D, 0x42, 0x31, 0x52, 0x6C,
        0x63, 0x33, 0x52, 0x70, 0x62, 0x6D, 0x63, 0x78, 0x47, 0x44,
        0x41, 0x57, 0x42, 0x67, 0x4E, 0x56, 0x42, 0x41, 0x4D, 0x4D,
        0x44, 0x33, 0x64, 0x76, 0x62, 0x47, 0x5A, 0x7A, 0x63, 0x32,
        0x77, 0x74, 0x5A, 0x47, 0x56, 0x32, 0x4C, 0x58, 0x4E, 0x74,
        0x4D, 0x6A, 0x45, 0x66, 0x4D, 0x42, 0x30, 0x47, 0x0A, 0x43,
        0x53, 0x71, 0x47, 0x53, 0x49, 0x62, 0x33, 0x44, 0x51, 0x45,
        0x4A, 0x41, 0x52, 0x59, 0x51, 0x61, 0x57, 0x35, 0x6D, 0x62,
        0x30, 0x42, 0x33, 0x62, 0x32, 0x78, 0x6D, 0x63, 0x33, 0x4E,
        0x73, 0x4C, 0x6D, 0x4E, 0x76, 0x62, 0x54, 0x45, 0x58, 0x4D,
        0x42, 0x55, 0x47, 0x43, 0x67, 0x6D, 0x53, 0x4A, 0x6F, 0x6D,
        0x54, 0x38, 0x69, 0x78, 0x6B, 0x41, 0x51, 0x45, 0x4D, 0x42,
        0x33, 0x64, 0x76, 0x0A, 0x62, 0x47, 0x5A, 0x54, 0x55, 0x30,
        0x77, 0x77, 0x48, 0x68, 0x63, 0x4E, 0x4D, 0x6A, 0x4D, 0x78,
        0x4D, 0x54, 0x49, 0x79, 0x4D, 0x6A, 0x45, 0x79, 0x4F, 0x44,
        0x4D, 0x33, 0x57, 0x68, 0x63, 0x4E, 0x4D, 0x6A, 0x59, 0x77,
        0x4F, 0x44, 0x45, 0x34, 0x4D, 0x6A, 0x45, 0x79, 0x4F, 0x44,
        0x4D, 0x33, 0x57, 0x6A, 0x43, 0x42, 0x6B, 0x7A, 0x45, 0x4C,
        0x4D, 0x41, 0x6B, 0x47, 0x41, 0x31, 0x55, 0x45, 0x0A, 0x42,
        0x68, 0x4D, 0x43, 0x51, 0x56, 0x55, 0x78, 0x44, 0x44, 0x41,
        0x4B, 0x42, 0x67, 0x4E, 0x56, 0x42, 0x41, 0x67, 0x4D, 0x41,
        0x31, 0x46, 0x4D, 0x52, 0x44, 0x45, 0x51, 0x4D, 0x41, 0x34,
        0x47, 0x41, 0x31, 0x55, 0x45, 0x43, 0x67, 0x77, 0x48, 0x64,
        0x32, 0x39, 0x73, 0x5A, 0x6C, 0x4E, 0x54, 0x54, 0x44, 0x45,
        0x51, 0x4D, 0x41, 0x34, 0x47, 0x41, 0x31, 0x55, 0x45, 0x43,
        0x77, 0x77, 0x48, 0x0A, 0x56, 0x47, 0x56, 0x7A, 0x64, 0x47,
        0x6C, 0x75, 0x5A, 0x7A, 0x45, 0x59, 0x4D, 0x42, 0x59, 0x47,
        0x41, 0x31, 0x55, 0x45, 0x41, 0x77, 0x77, 0x50, 0x64, 0x32,
        0x39, 0x73, 0x5A, 0x6E, 0x4E, 0x7A, 0x62, 0x43, 0x31, 0x6B,
        0x5A, 0x58, 0x59, 0x74, 0x63, 0x32, 0x30, 0x79, 0x4D, 0x52,
        0x38, 0x77, 0x48, 0x51, 0x59, 0x4A, 0x4B, 0x6F, 0x5A, 0x49,
        0x68, 0x76, 0x63, 0x4E, 0x41, 0x51, 0x6B, 0x42, 0x0A, 0x46,
        0x68, 0x42, 0x70, 0x62, 0x6D, 0x5A, 0x76, 0x51, 0x48, 0x64,
        0x76, 0x62, 0x47, 0x5A, 0x7A, 0x63, 0x32, 0x77, 0x75, 0x59,
        0x32, 0x39, 0x74, 0x4D, 0x52, 0x63, 0x77, 0x46, 0x51, 0x59,
        0x4B, 0x43, 0x5A, 0x49, 0x6D, 0x69, 0x5A, 0x50, 0x79, 0x4C,
        0x47, 0x51, 0x42, 0x41, 0x51, 0x77, 0x48, 0x64, 0x32, 0x39,
        0x73, 0x5A, 0x6C, 0x4E, 0x54, 0x54, 0x44, 0x42, 0x5A, 0x4D,
        0x42, 0x4D, 0x47, 0x0A, 0x42, 0x79, 0x71, 0x47, 0x53, 0x4D,
        0x34, 0x39, 0x41, 0x67, 0x45, 0x47, 0x43, 0x43, 0x71, 0x42,
        0x48, 0x4D, 0x39, 0x56, 0x41, 0x59, 0x49, 0x74, 0x41, 0x30,
        0x49, 0x41, 0x42, 0x4E, 0x6A, 0x45, 0x6F, 0x66, 0x45, 0x4C,
        0x69, 0x34, 0x33, 0x45, 0x66, 0x64, 0x7A, 0x55, 0x5A, 0x62,
        0x6D, 0x6C, 0x56, 0x55, 0x37, 0x37, 0x72, 0x44, 0x4F, 0x72,
        0x6D, 0x30, 0x4F, 0x55, 0x54, 0x45, 0x68, 0x41, 0x0A, 0x47,
        0x7A, 0x50, 0x5A, 0x47, 0x38, 0x77, 0x78, 0x77, 0x59, 0x4A,
        0x57, 0x50, 0x37, 0x44, 0x41, 0x61, 0x35, 0x56, 0x41, 0x55,
        0x66, 0x32, 0x49, 0x41, 0x67, 0x47, 0x78, 0x73, 0x4A, 0x52,
        0x73, 0x42, 0x75, 0x75, 0x6E, 0x32, 0x6F, 0x37, 0x75, 0x63,
        0x4C, 0x62, 0x6C, 0x75, 0x37, 0x51, 0x65, 0x35, 0x37, 0x53,
        0x6A, 0x59, 0x7A, 0x42, 0x68, 0x4D, 0x42, 0x30, 0x47, 0x41,
        0x31, 0x55, 0x64, 0x0A, 0x44, 0x67, 0x51, 0x57, 0x42, 0x42,
        0x52, 0x75, 0x6C, 0x2B, 0x69, 0x59, 0x74, 0x6C, 0x75, 0x32,
        0x72, 0x6F, 0x63, 0x45, 0x32, 0x78, 0x52, 0x57, 0x5A, 0x68,
        0x62, 0x30, 0x75, 0x43, 0x32, 0x4D, 0x38, 0x6A, 0x41, 0x66,
        0x42, 0x67, 0x4E, 0x56, 0x48, 0x53, 0x4D, 0x45, 0x47, 0x44,
        0x41, 0x57, 0x67, 0x42, 0x52, 0x75, 0x6C, 0x2B, 0x69, 0x59,
        0x74, 0x6C, 0x75, 0x32, 0x72, 0x6F, 0x63, 0x45, 0x0A, 0x32,
        0x78, 0x52, 0x57, 0x5A, 0x68, 0x62, 0x30, 0x75, 0x43, 0x32,
        0x4D, 0x38, 0x6A, 0x41, 0x50, 0x42, 0x67, 0x4E, 0x56, 0x48,
        0x52, 0x4D, 0x42, 0x41, 0x66, 0x38, 0x45, 0x42, 0x54, 0x41,
        0x44, 0x41, 0x51, 0x48, 0x2F, 0x4D, 0x41, 0x34, 0x47, 0x41,
        0x31, 0x55, 0x64, 0x44, 0x77, 0x45, 0x42, 0x2F, 0x77, 0x51,
        0x45, 0x41, 0x77, 0x49, 0x42, 0x68, 0x6A, 0x41, 0x4B, 0x42,
        0x67, 0x67, 0x71, 0x0A, 0x67, 0x52, 0x7A, 0x50, 0x56, 0x51,
        0x47, 0x44, 0x64, 0x51, 0x4E, 0x48, 0x41, 0x44, 0x42, 0x45,
        0x41, 0x69, 0x41, 0x50, 0x77, 0x79, 0x77, 0x32, 0x34, 0x35,
        0x38, 0x63, 0x36, 0x57, 0x67, 0x63, 0x4F, 0x30, 0x4D, 0x59,
        0x57, 0x38, 0x6D, 0x50, 0x35, 0x50, 0x72, 0x64, 0x4D, 0x38,
        0x47, 0x34, 0x48, 0x4E, 0x50, 0x55, 0x59, 0x54, 0x50, 0x34,
        0x4E, 0x35, 0x31, 0x61, 0x39, 0x41, 0x49, 0x67, 0x0A, 0x4F,
        0x72, 0x6D, 0x6F, 0x51, 0x34, 0x44, 0x50, 0x4F, 0x43, 0x58,
        0x70, 0x5A, 0x4E, 0x67, 0x6D, 0x52, 0x35, 0x31, 0x51, 0x42,
        0x41, 0x79, 0x4B, 0x36, 0x4B, 0x4A, 0x43, 0x36, 0x47, 0x50,
        0x64, 0x55, 0x35, 0x52, 0x39, 0x4F, 0x47, 0x31, 0x53, 0x63,
        0x50, 0x30, 0x3D, 0x0A, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x45,
        0x4E, 0x44, 0x20, 0x43, 0x45, 0x52, 0x54, 0x49, 0x46, 0x49,
        0x43, 0x41, 0x54, 0x45, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x0A

};
#define sizeof_self_sm2_cert (sizeof(self_sm2_cert))

/* ./certs/sm2/self-sm2-key.pem */
static const unsigned char self_sm2_key[] =
{
        0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x42, 0x45, 0x47, 0x49, 0x4E,
        0x20, 0x50, 0x55, 0x42, 0x4C, 0x49, 0x43, 0x20, 0x4B, 0x45,
        0x59, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x0A, 0x4D, 0x46, 0x6B,
        0x77, 0x45, 0x77, 0x59, 0x48, 0x4B, 0x6F, 0x5A, 0x49, 0x7A,
        0x6A, 0x30, 0x43, 0x41, 0x51, 0x59, 0x49, 0x4B, 0x6F, 0x45,
        0x63, 0x7A, 0x31, 0x55, 0x42, 0x67, 0x69, 0x30, 0x44, 0x51,
        0x67, 0x41, 0x45, 0x32, 0x4D, 0x53, 0x68, 0x38, 0x51, 0x75,
        0x4C, 0x6A, 0x63, 0x52, 0x39, 0x33, 0x4E, 0x52, 0x6C, 0x75,
        0x61, 0x56, 0x56, 0x54, 0x76, 0x75, 0x73, 0x4D, 0x36, 0x75,
        0x62, 0x0A, 0x51, 0x35, 0x52, 0x4D, 0x53, 0x45, 0x41, 0x62,
        0x4D, 0x39, 0x6B, 0x62, 0x7A, 0x44, 0x48, 0x42, 0x67, 0x6C,
        0x59, 0x2F, 0x73, 0x4D, 0x42, 0x72, 0x6C, 0x55, 0x42, 0x52,
        0x2F, 0x59, 0x67, 0x43, 0x41, 0x62, 0x47, 0x77, 0x6C, 0x47,
        0x77, 0x47, 0x36, 0x36, 0x66, 0x61, 0x6A, 0x75, 0x35, 0x77,
        0x74, 0x75, 0x57, 0x37, 0x74, 0x42, 0x37, 0x6E, 0x74, 0x41,
        0x3D, 0x3D, 0x0A, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x45, 0x4E,
        0x44, 0x20, 0x50, 0x55, 0x42, 0x4C, 0x49, 0x43, 0x20, 0x4B,
        0x45, 0x59, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x0A
};
#define sizeof_self_sm2_key (sizeof(self_sm2_key))

/* ./certs/sm2/self-sm2-priv.pem */
static const unsigned char self_sm2_priv[] =
{
        0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x42, 0x45, 0x47, 0x49, 0x4E,
        0x20, 0x50, 0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x20, 0x4B,
        0x45, 0x59, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x0A, 0x4D, 0x49,
        0x47, 0x54, 0x41, 0x67, 0x45, 0x41, 0x4D, 0x42, 0x4D, 0x47,
        0x42, 0x79, 0x71, 0x47, 0x53, 0x4D, 0x34, 0x39, 0x41, 0x67,
        0x45, 0x47, 0x43, 0x43, 0x71, 0x42, 0x48, 0x4D, 0x39, 0x56,
        0x41, 0x59, 0x49, 0x74, 0x42, 0x48, 0x6B, 0x77, 0x64, 0x77,
        0x49, 0x42, 0x41, 0x51, 0x51, 0x67, 0x30, 0x4A, 0x77, 0x6F,
        0x57, 0x68, 0x58, 0x57, 0x4A, 0x51, 0x32, 0x32, 0x58, 0x39,
        0x47, 0x68, 0x0A, 0x41, 0x57, 0x36, 0x30, 0x44, 0x74, 0x41,
        0x32, 0x2B, 0x68, 0x58, 0x38, 0x71, 0x51, 0x54, 0x6C, 0x46,
        0x36, 0x48, 0x51, 0x4C, 0x79, 0x6E, 0x57, 0x2F, 0x6D, 0x71,
        0x67, 0x43, 0x67, 0x59, 0x49, 0x4B, 0x6F, 0x45, 0x63, 0x7A,
        0x31, 0x55, 0x42, 0x67, 0x69, 0x32, 0x68, 0x52, 0x41, 0x4E,
        0x43, 0x41, 0x41, 0x54, 0x59, 0x78, 0x4B, 0x48, 0x78, 0x43,
        0x34, 0x75, 0x4E, 0x78, 0x48, 0x33, 0x63, 0x0A, 0x31, 0x47,
        0x57, 0x35, 0x70, 0x56, 0x56, 0x4F, 0x2B, 0x36, 0x77, 0x7A,
        0x71, 0x35, 0x74, 0x44, 0x6C, 0x45, 0x78, 0x49, 0x51, 0x42,
        0x73, 0x7A, 0x32, 0x52, 0x76, 0x4D, 0x4D, 0x63, 0x47, 0x43,
        0x56, 0x6A, 0x2B, 0x77, 0x77, 0x47, 0x75, 0x56, 0x51, 0x46,
        0x48, 0x39, 0x69, 0x41, 0x49, 0x42, 0x73, 0x62, 0x43, 0x55,
        0x62, 0x41, 0x62, 0x72, 0x70, 0x39, 0x71, 0x4F, 0x37, 0x6E,
        0x43, 0x32, 0x0A, 0x35, 0x62, 0x75, 0x30, 0x48, 0x75, 0x65,
        0x30, 0x0A, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x45, 0x4E, 0x44,
        0x20, 0x50, 0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x20, 0x4B,
        0x45, 0x59, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x0A
};
#define sizeof_self_sm2_priv (sizeof(self_sm2_priv))

/* ./certs/sm2/server-sm2.pem */
static const unsigned char server_sm2[] =
{
        0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
        0x65, 0x3A, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x44, 0x61, 0x74,
        0x61, 0x3A, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6F, 0x6E, 0x3A, 0x20,
        0x33, 0x20, 0x28, 0x30, 0x78, 0x32, 0x29, 0x0A, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x53, 0x65, 0x72, 0x69,
        0x61, 0x6C, 0x20, 0x4E, 0x75, 0x6D, 0x62, 0x65, 0x72, 0x3A,
        0x20, 0x31, 0x20, 0x28, 0x30, 0x78, 0x31, 0x29, 0x0A, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x53, 0x69, 0x67,
        0x6E, 0x61, 0x74, 0x75, 0x72, 0x65, 0x20, 0x41, 0x6C, 0x67,
        0x6F, 0x72, 0x69, 0x74, 0x68, 0x6D, 0x3A, 0x20, 0x53, 0x4D,
        0x32, 0x2D, 0x77, 0x69, 0x74, 0x68, 0x2D, 0x53, 0x4D, 0x33,
        0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x49,
        0x73, 0x73, 0x75, 0x65, 0x72, 0x3A, 0x20, 0x43, 0x20, 0x3D,
        0x20, 0x55, 0x53, 0x2C, 0x20, 0x53, 0x54, 0x20, 0x3D, 0x20,
        0x4D, 0x6F, 0x6E, 0x74, 0x61, 0x6E, 0x61, 0x2C, 0x20, 0x4C,
        0x20, 0x3D, 0x20, 0x42, 0x6F, 0x7A, 0x65, 0x6D, 0x61, 0x6E,
        0x2C, 0x20, 0x4F, 0x20, 0x3D, 0x20, 0x77, 0x6F, 0x6C, 0x66,
        0x53, 0x53, 0x4C, 0x5F, 0x73, 0x6D, 0x32, 0x2C, 0x20, 0x4F,
        0x55, 0x20, 0x3D, 0x20, 0x43, 0x41, 0x2D, 0x73, 0x6D, 0x32,
        0x2C, 0x20, 0x43, 0x4E, 0x20, 0x3D, 0x20, 0x77, 0x77, 0x77,
        0x2E, 0x77, 0x6F, 0x6C, 0x66, 0x73, 0x73, 0x6C, 0x2E, 0x63,
        0x6F, 0x6D, 0x2C, 0x20, 0x65, 0x6D, 0x61, 0x69, 0x6C, 0x41,
        0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x20, 0x3D, 0x20, 0x69,
        0x6E, 0x66, 0x6F, 0x40, 0x77, 0x6F, 0x6C, 0x66, 0x73, 0x73,
        0x6C, 0x2E, 0x63, 0x6F, 0x6D, 0x2C, 0x20, 0x55, 0x49, 0x44,
        0x20, 0x3D, 0x20, 0x77, 0x6F, 0x6C, 0x66, 0x53, 0x53, 0x4C,
        0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x56,
        0x61, 0x6C, 0x69, 0x64, 0x69, 0x74, 0x79, 0x0A, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x4E, 0x6F, 0x74, 0x20, 0x42, 0x65, 0x66, 0x6F, 0x72, 0x65,
        0x3A, 0x20, 0x46, 0x65, 0x62, 0x20, 0x31, 0x35, 0x20, 0x30,
        0x36, 0x3A, 0x32, 0x33, 0x3A, 0x30, 0x37, 0x20, 0x32, 0x30,
        0x32, 0x33, 0x20, 0x47, 0x4D, 0x54, 0x0A, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x4E,
        0x6F, 0x74, 0x20, 0x41, 0x66, 0x74, 0x65, 0x72, 0x20, 0x3A,
        0x20, 0x4E, 0x6F, 0x76, 0x20, 0x31, 0x31, 0x20, 0x30, 0x36,
        0x3A, 0x32, 0x33, 0x3A, 0x30, 0x37, 0x20, 0x32, 0x30, 0x32,
        0x35, 0x20, 0x47, 0x4D, 0x54, 0x0A, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x53, 0x75, 0x62, 0x6A, 0x65, 0x63,
        0x74, 0x3A, 0x20, 0x43, 0x20, 0x3D, 0x20, 0x55, 0x53, 0x2C,
        0x20, 0x53, 0x54, 0x20, 0x3D, 0x20, 0x4D, 0x6F, 0x6E, 0x74,
        0x61, 0x6E, 0x61, 0x2C, 0x20, 0x4C, 0x20, 0x3D, 0x20, 0x42,
        0x6F, 0x7A, 0x65, 0x6D, 0x61, 0x6E, 0x2C, 0x20, 0x4F, 0x20,
        0x3D, 0x20, 0x77, 0x6F, 0x6C, 0x66, 0x53, 0x53, 0x4C, 0x5F,
        0x73, 0x6D, 0x32, 0x2C, 0x20, 0x4F, 0x55, 0x20, 0x3D, 0x20,
        0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x2D, 0x73, 0x6D, 0x32,
        0x2C, 0x20, 0x43, 0x4E, 0x20, 0x3D, 0x20, 0x77, 0x77, 0x77,
        0x2E, 0x77, 0x6F, 0x6C, 0x66, 0x73, 0x73, 0x6C, 0x2E, 0x63,
        0x6F, 0x6D, 0x2C, 0x20, 0x65, 0x6D, 0x61, 0x69, 0x6C, 0x41,
        0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x20, 0x3D, 0x20, 0x69,
        0x6E, 0x66, 0x6F, 0x40, 0x77, 0x6F, 0x6C, 0x66, 0x73, 0x73,
        0x6C, 0x2E, 0x63, 0x6F, 0x6D, 0x2C, 0x20, 0x55, 0x49, 0x44,
        0x20, 0x3D, 0x20, 0x77, 0x6F, 0x6C, 0x66, 0x53, 0x53, 0x4C,
        0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x53,
        0x75, 0x62, 0x6A, 0x65, 0x63, 0x74, 0x20, 0x50, 0x75, 0x62,
        0x6C, 0x69, 0x63, 0x20, 0x4B, 0x65, 0x79, 0x20, 0x49, 0x6E,
        0x66, 0x6F, 0x3A, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x50, 0x75, 0x62, 0x6C,
        0x69, 0x63, 0x20, 0x4B, 0x65, 0x79, 0x20, 0x41, 0x6C, 0x67,
        0x6F, 0x72, 0x69, 0x74, 0x68, 0x6D, 0x3A, 0x20, 0x73, 0x6D,
        0x32, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x50, 0x75,
        0x62, 0x6C, 0x69, 0x63, 0x2D, 0x4B, 0x65, 0x79, 0x3A, 0x20,
        0x28, 0x32, 0x35, 0x36, 0x20, 0x62, 0x69, 0x74, 0x29, 0x0A,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x70, 0x75, 0x62, 0x3A,
        0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x30, 0x34, 0x3A, 0x39, 0x34, 0x3A, 0x37, 0x30, 0x3A,
        0x32, 0x62, 0x3A, 0x34, 0x36, 0x3A, 0x65, 0x34, 0x3A, 0x35,
        0x65, 0x3A, 0x30, 0x66, 0x3A, 0x34, 0x31, 0x3A, 0x66, 0x62,
        0x3A, 0x38, 0x66, 0x3A, 0x32, 0x64, 0x3A, 0x33, 0x34, 0x3A,
        0x30, 0x61, 0x3A, 0x34, 0x31, 0x3A, 0x0A, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x34, 0x30, 0x3A,
        0x31, 0x39, 0x3A, 0x35, 0x65, 0x3A, 0x66, 0x62, 0x3A, 0x64,
        0x34, 0x3A, 0x31, 0x64, 0x3A, 0x31, 0x31, 0x3A, 0x61, 0x63,
        0x3A, 0x66, 0x61, 0x3A, 0x66, 0x35, 0x3A, 0x39, 0x33, 0x3A,
        0x33, 0x37, 0x3A, 0x63, 0x36, 0x3A, 0x66, 0x61, 0x3A, 0x38,
        0x37, 0x3A, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x30, 0x38, 0x3A, 0x66, 0x37, 0x3A, 0x31,
        0x36, 0x3A, 0x31, 0x66, 0x3A, 0x32, 0x63, 0x3A, 0x63, 0x65,
        0x3A, 0x33, 0x30, 0x3A, 0x34, 0x30, 0x3A, 0x39, 0x64, 0x3A,
        0x34, 0x66, 0x3A, 0x61, 0x36, 0x3A, 0x32, 0x61, 0x3A, 0x30,
        0x61, 0x3A, 0x61, 0x31, 0x3A, 0x64, 0x36, 0x3A, 0x0A, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x39,
        0x35, 0x3A, 0x33, 0x33, 0x3A, 0x63, 0x33, 0x3A, 0x61, 0x36,
        0x3A, 0x30, 0x33, 0x3A, 0x39, 0x38, 0x3A, 0x65, 0x36, 0x3A,
        0x38, 0x64, 0x3A, 0x30, 0x35, 0x3A, 0x33, 0x34, 0x3A, 0x62,
        0x30, 0x3A, 0x39, 0x37, 0x3A, 0x30, 0x63, 0x3A, 0x64, 0x65,
        0x3A, 0x61, 0x34, 0x3A, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x63, 0x37, 0x3A, 0x63, 0x66,
        0x3A, 0x35, 0x33, 0x3A, 0x38, 0x66, 0x3A, 0x64, 0x31, 0x0A,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x41, 0x53, 0x4E, 0x31,
        0x20, 0x4F, 0x49, 0x44, 0x3A, 0x20, 0x53, 0x4D, 0x32, 0x0A,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x58, 0x35,
        0x30, 0x39, 0x76, 0x33, 0x20, 0x65, 0x78, 0x74, 0x65, 0x6E,
        0x73, 0x69, 0x6F, 0x6E, 0x73, 0x3A, 0x0A, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x58,
        0x35, 0x30, 0x39, 0x76, 0x33, 0x20, 0x53, 0x75, 0x62, 0x6A,
        0x65, 0x63, 0x74, 0x20, 0x4B, 0x65, 0x79, 0x20, 0x49, 0x64,
        0x65, 0x6E, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x3A, 0x20,
        0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x36, 0x37, 0x3A,
        0x41, 0x45, 0x3A, 0x36, 0x30, 0x3A, 0x46, 0x46, 0x3A, 0x37,
        0x45, 0x3A, 0x31, 0x42, 0x3A, 0x30, 0x46, 0x3A, 0x39, 0x35,
        0x3A, 0x41, 0x45, 0x3A, 0x31, 0x46, 0x3A, 0x38, 0x32, 0x3A,
        0x35, 0x39, 0x3A, 0x46, 0x32, 0x3A, 0x36, 0x43, 0x3A, 0x35,
        0x36, 0x3A, 0x32, 0x44, 0x3A, 0x39, 0x33, 0x3A, 0x45, 0x46,
        0x3A, 0x31, 0x37, 0x3A, 0x33, 0x32, 0x0A, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x58,
        0x35, 0x30, 0x39, 0x76, 0x33, 0x20, 0x41, 0x75, 0x74, 0x68,
        0x6F, 0x72, 0x69, 0x74, 0x79, 0x20, 0x4B, 0x65, 0x79, 0x20,
        0x49, 0x64, 0x65, 0x6E, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72,
        0x3A, 0x20, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x34,
        0x37, 0x3A, 0x30, 0x41, 0x3A, 0x34, 0x38, 0x3A, 0x37, 0x45,
        0x3A, 0x42, 0x42, 0x3A, 0x30, 0x32, 0x3A, 0x41, 0x38, 0x3A,
        0x35, 0x41, 0x3A, 0x32, 0x36, 0x3A, 0x35, 0x37, 0x3A, 0x32,
        0x42, 0x3A, 0x31, 0x39, 0x3A, 0x41, 0x39, 0x3A, 0x37, 0x42,
        0x3A, 0x36, 0x31, 0x3A, 0x38, 0x42, 0x3A, 0x37, 0x46, 0x3A,
        0x35, 0x44, 0x3A, 0x39, 0x39, 0x3A, 0x36, 0x45, 0x0A, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x58, 0x35, 0x30, 0x39, 0x76, 0x33, 0x20, 0x42, 0x61,
        0x73, 0x69, 0x63, 0x20, 0x43, 0x6F, 0x6E, 0x73, 0x74, 0x72,
        0x61, 0x69, 0x6E, 0x74, 0x73, 0x3A, 0x20, 0x63, 0x72, 0x69,
        0x74, 0x69, 0x63, 0x61, 0x6C, 0x0A, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x43, 0x41, 0x3A, 0x46, 0x41, 0x4C, 0x53, 0x45,
        0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x58, 0x35, 0x30, 0x39, 0x76, 0x33, 0x20,
        0x4B, 0x65, 0x79, 0x20, 0x55, 0x73, 0x61, 0x67, 0x65, 0x3A,
        0x20, 0x63, 0x72, 0x69, 0x74, 0x69, 0x63, 0x61, 0x6C, 0x0A,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x44, 0x69, 0x67, 0x69,
        0x74, 0x61, 0x6C, 0x20, 0x53, 0x69, 0x67, 0x6E, 0x61, 0x74,
        0x75, 0x72, 0x65, 0x2C, 0x20, 0x4B, 0x65, 0x79, 0x20, 0x45,
        0x6E, 0x63, 0x69, 0x70, 0x68, 0x65, 0x72, 0x6D, 0x65, 0x6E,
        0x74, 0x2C, 0x20, 0x4B, 0x65, 0x79, 0x20, 0x41, 0x67, 0x72,
        0x65, 0x65, 0x6D, 0x65, 0x6E, 0x74, 0x0A, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x58,
        0x35, 0x30, 0x39, 0x76, 0x33, 0x20, 0x45, 0x78, 0x74, 0x65,
        0x6E, 0x64, 0x65, 0x64, 0x20, 0x4B, 0x65, 0x79, 0x20, 0x55,
        0x73, 0x61, 0x67, 0x65, 0x3A, 0x20, 0x0A, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x54, 0x4C, 0x53, 0x20, 0x57, 0x65, 0x62,
        0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x41, 0x75,
        0x74, 0x68, 0x65, 0x6E, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69,
        0x6F, 0x6E, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x4E, 0x65, 0x74, 0x73, 0x63,
        0x61, 0x70, 0x65, 0x20, 0x43, 0x65, 0x72, 0x74, 0x20, 0x54,
        0x79, 0x70, 0x65, 0x3A, 0x20, 0x0A, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x53, 0x53, 0x4C, 0x20, 0x53, 0x65, 0x72, 0x76,
        0x65, 0x72, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x53, 0x69, 0x67,
        0x6E, 0x61, 0x74, 0x75, 0x72, 0x65, 0x20, 0x41, 0x6C, 0x67,
        0x6F, 0x72, 0x69, 0x74, 0x68, 0x6D, 0x3A, 0x20, 0x53, 0x4D,
        0x32, 0x2D, 0x77, 0x69, 0x74, 0x68, 0x2D, 0x53, 0x4D, 0x33,
        0x0A, 0x20, 0x20, 0x20, 0x20, 0x53, 0x69, 0x67, 0x6E, 0x61,
        0x74, 0x75, 0x72, 0x65, 0x20, 0x56, 0x61, 0x6C, 0x75, 0x65,
        0x3A, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x33, 0x30, 0x3A, 0x34, 0x35, 0x3A, 0x30, 0x32, 0x3A, 0x32,
        0x30, 0x3A, 0x31, 0x62, 0x3A, 0x63, 0x61, 0x3A, 0x39, 0x34,
        0x3A, 0x32, 0x38, 0x3A, 0x37, 0x66, 0x3A, 0x66, 0x36, 0x3A,
        0x62, 0x32, 0x3A, 0x30, 0x64, 0x3A, 0x33, 0x31, 0x3A, 0x34,
        0x33, 0x3A, 0x35, 0x30, 0x3A, 0x65, 0x31, 0x3A, 0x64, 0x35,
        0x3A, 0x33, 0x34, 0x3A, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x31, 0x37, 0x3A, 0x64, 0x64, 0x3A, 0x61,
        0x66, 0x3A, 0x33, 0x61, 0x3A, 0x64, 0x65, 0x3A, 0x38, 0x31,
        0x3A, 0x30, 0x36, 0x3A, 0x36, 0x37, 0x3A, 0x39, 0x61, 0x3A,
        0x62, 0x33, 0x3A, 0x30, 0x36, 0x3A, 0x32, 0x32, 0x3A, 0x37,
        0x65, 0x3A, 0x36, 0x34, 0x3A, 0x65, 0x63, 0x3A, 0x66, 0x64,
        0x3A, 0x30, 0x65, 0x3A, 0x62, 0x39, 0x3A, 0x0A, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x30, 0x32, 0x3A, 0x32,
        0x31, 0x3A, 0x30, 0x30, 0x3A, 0x61, 0x31, 0x3A, 0x34, 0x38,
        0x3A, 0x61, 0x38, 0x3A, 0x33, 0x32, 0x3A, 0x64, 0x31, 0x3A,
        0x30, 0x35, 0x3A, 0x30, 0x39, 0x3A, 0x36, 0x62, 0x3A, 0x31,
        0x63, 0x3A, 0x65, 0x62, 0x3A, 0x38, 0x39, 0x3A, 0x31, 0x32,
        0x3A, 0x36, 0x36, 0x3A, 0x64, 0x38, 0x3A, 0x33, 0x38, 0x3A,
        0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x61,
        0x31, 0x3A, 0x63, 0x34, 0x3A, 0x35, 0x63, 0x3A, 0x38, 0x39,
        0x3A, 0x30, 0x39, 0x3A, 0x30, 0x66, 0x3A, 0x66, 0x64, 0x3A,
        0x65, 0x39, 0x3A, 0x63, 0x30, 0x3A, 0x33, 0x62, 0x3A, 0x31,
        0x64, 0x3A, 0x66, 0x62, 0x3A, 0x63, 0x64, 0x3A, 0x62, 0x35,
        0x3A, 0x34, 0x63, 0x3A, 0x33, 0x31, 0x3A, 0x36, 0x38, 0x0A,
        0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x42, 0x45, 0x47, 0x49, 0x4E,
        0x20, 0x43, 0x45, 0x52, 0x54, 0x49, 0x46, 0x49, 0x43, 0x41,
        0x54, 0x45, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x0A, 0x4D, 0x49,
        0x49, 0x43, 0x32, 0x44, 0x43, 0x43, 0x41, 0x6E, 0x36, 0x67,
        0x41, 0x77, 0x49, 0x42, 0x41, 0x67, 0x49, 0x42, 0x41, 0x54,
        0x41, 0x4B, 0x42, 0x67, 0x67, 0x71, 0x67, 0x52, 0x7A, 0x50,
        0x56, 0x51, 0x47, 0x44, 0x64, 0x54, 0x43, 0x42, 0x72, 0x44,
        0x45, 0x4C, 0x4D, 0x41, 0x6B, 0x47, 0x41, 0x31, 0x55, 0x45,
        0x42, 0x68, 0x4D, 0x43, 0x56, 0x56, 0x4D, 0x78, 0x45, 0x44,
        0x41, 0x4F, 0x0A, 0x42, 0x67, 0x4E, 0x56, 0x42, 0x41, 0x67,
        0x4D, 0x42, 0x30, 0x31, 0x76, 0x62, 0x6E, 0x52, 0x68, 0x62,
        0x6D, 0x45, 0x78, 0x45, 0x44, 0x41, 0x4F, 0x42, 0x67, 0x4E,
        0x56, 0x42, 0x41, 0x63, 0x4D, 0x42, 0x30, 0x4A, 0x76, 0x65,
        0x6D, 0x56, 0x74, 0x59, 0x57, 0x34, 0x78, 0x46, 0x44, 0x41,
        0x53, 0x42, 0x67, 0x4E, 0x56, 0x42, 0x41, 0x6F, 0x4D, 0x43,
        0x33, 0x64, 0x76, 0x62, 0x47, 0x5A, 0x54, 0x0A, 0x55, 0x30,
        0x78, 0x66, 0x63, 0x32, 0x30, 0x79, 0x4D, 0x51, 0x38, 0x77,
        0x44, 0x51, 0x59, 0x44, 0x56, 0x51, 0x51, 0x4C, 0x44, 0x41,
        0x5A, 0x44, 0x51, 0x53, 0x31, 0x7A, 0x62, 0x54, 0x49, 0x78,
        0x47, 0x44, 0x41, 0x57, 0x42, 0x67, 0x4E, 0x56, 0x42, 0x41,
        0x4D, 0x4D, 0x44, 0x33, 0x64, 0x33, 0x64, 0x79, 0x35, 0x33,
        0x62, 0x32, 0x78, 0x6D, 0x63, 0x33, 0x4E, 0x73, 0x4C, 0x6D,
        0x4E, 0x76, 0x0A, 0x62, 0x54, 0x45, 0x66, 0x4D, 0x42, 0x30,
        0x47, 0x43, 0x53, 0x71, 0x47, 0x53, 0x49, 0x62, 0x33, 0x44,
        0x51, 0x45, 0x4A, 0x41, 0x52, 0x59, 0x51, 0x61, 0x57, 0x35,
        0x6D, 0x62, 0x30, 0x42, 0x33, 0x62, 0x32, 0x78, 0x6D, 0x63,
        0x33, 0x4E, 0x73, 0x4C, 0x6D, 0x4E, 0x76, 0x62, 0x54, 0x45,
        0x58, 0x4D, 0x42, 0x55, 0x47, 0x43, 0x67, 0x6D, 0x53, 0x4A,
        0x6F, 0x6D, 0x54, 0x38, 0x69, 0x78, 0x6B, 0x0A, 0x41, 0x51,
        0x45, 0x4D, 0x42, 0x33, 0x64, 0x76, 0x62, 0x47, 0x5A, 0x54,
        0x55, 0x30, 0x77, 0x77, 0x48, 0x68, 0x63, 0x4E, 0x4D, 0x6A,
        0x4D, 0x77, 0x4D, 0x6A, 0x45, 0x31, 0x4D, 0x44, 0x59, 0x79,
        0x4D, 0x7A, 0x41, 0x33, 0x57, 0x68, 0x63, 0x4E, 0x4D, 0x6A,
        0x55, 0x78, 0x4D, 0x54, 0x45, 0x78, 0x4D, 0x44, 0x59, 0x79,
        0x4D, 0x7A, 0x41, 0x33, 0x57, 0x6A, 0x43, 0x42, 0x73, 0x44,
        0x45, 0x4C, 0x0A, 0x4D, 0x41, 0x6B, 0x47, 0x41, 0x31, 0x55,
        0x45, 0x42, 0x68, 0x4D, 0x43, 0x56, 0x56, 0x4D, 0x78, 0x45,
        0x44, 0x41, 0x4F, 0x42, 0x67, 0x4E, 0x56, 0x42, 0x41, 0x67,
        0x4D, 0x42, 0x30, 0x31, 0x76, 0x62, 0x6E, 0x52, 0x68, 0x62,
        0x6D, 0x45, 0x78, 0x45, 0x44, 0x41, 0x4F, 0x42, 0x67, 0x4E,
        0x56, 0x42, 0x41, 0x63, 0x4D, 0x42, 0x30, 0x4A, 0x76, 0x65,
        0x6D, 0x56, 0x74, 0x59, 0x57, 0x34, 0x78, 0x0A, 0x46, 0x44,
        0x41, 0x53, 0x42, 0x67, 0x4E, 0x56, 0x42, 0x41, 0x6F, 0x4D,
        0x43, 0x33, 0x64, 0x76, 0x62, 0x47, 0x5A, 0x54, 0x55, 0x30,
        0x78, 0x66, 0x63, 0x32, 0x30, 0x79, 0x4D, 0x52, 0x4D, 0x77,
        0x45, 0x51, 0x59, 0x44, 0x56, 0x51, 0x51, 0x4C, 0x44, 0x41,
        0x70, 0x54, 0x5A, 0x58, 0x4A, 0x32, 0x5A, 0x58, 0x49, 0x74,
        0x63, 0x32, 0x30, 0x79, 0x4D, 0x52, 0x67, 0x77, 0x46, 0x67,
        0x59, 0x44, 0x0A, 0x56, 0x51, 0x51, 0x44, 0x44, 0x41, 0x39,
        0x33, 0x64, 0x33, 0x63, 0x75, 0x64, 0x32, 0x39, 0x73, 0x5A,
        0x6E, 0x4E, 0x7A, 0x62, 0x43, 0x35, 0x6A, 0x62, 0x32, 0x30,
        0x78, 0x48, 0x7A, 0x41, 0x64, 0x42, 0x67, 0x6B, 0x71, 0x68,
        0x6B, 0x69, 0x47, 0x39, 0x77, 0x30, 0x42, 0x43, 0x51, 0x45,
        0x57, 0x45, 0x47, 0x6C, 0x75, 0x5A, 0x6D, 0x39, 0x41, 0x64,
        0x32, 0x39, 0x73, 0x5A, 0x6E, 0x4E, 0x7A, 0x0A, 0x62, 0x43,
        0x35, 0x6A, 0x62, 0x32, 0x30, 0x78, 0x46, 0x7A, 0x41, 0x56,
        0x42, 0x67, 0x6F, 0x4A, 0x6B, 0x69, 0x61, 0x4A, 0x6B, 0x2F,
        0x49, 0x73, 0x5A, 0x41, 0x45, 0x42, 0x44, 0x41, 0x64, 0x33,
        0x62, 0x32, 0x78, 0x6D, 0x55, 0x31, 0x4E, 0x4D, 0x4D, 0x46,
        0x6F, 0x77, 0x46, 0x41, 0x59, 0x49, 0x4B, 0x6F, 0x45, 0x63,
        0x7A, 0x31, 0x55, 0x42, 0x67, 0x69, 0x30, 0x47, 0x43, 0x43,
        0x71, 0x42, 0x0A, 0x48, 0x4D, 0x39, 0x56, 0x41, 0x59, 0x49,
        0x74, 0x41, 0x30, 0x49, 0x41, 0x42, 0x4A, 0x52, 0x77, 0x4B,
        0x30, 0x62, 0x6B, 0x58, 0x67, 0x39, 0x42, 0x2B, 0x34, 0x38,
        0x74, 0x4E, 0x41, 0x70, 0x42, 0x51, 0x42, 0x6C, 0x65, 0x2B,
        0x39, 0x51, 0x64, 0x45, 0x61, 0x7A, 0x36, 0x39, 0x5A, 0x4D,
        0x33, 0x78, 0x76, 0x71, 0x48, 0x43, 0x50, 0x63, 0x57, 0x48,
        0x79, 0x7A, 0x4F, 0x4D, 0x45, 0x43, 0x64, 0x0A, 0x54, 0x36,
        0x59, 0x71, 0x43, 0x71, 0x48, 0x57, 0x6C, 0x54, 0x50, 0x44,
        0x70, 0x67, 0x4F, 0x59, 0x35, 0x6F, 0x30, 0x46, 0x4E, 0x4C,
        0x43, 0x58, 0x44, 0x4E, 0x36, 0x6B, 0x78, 0x38, 0x39, 0x54,
        0x6A, 0x39, 0x47, 0x6A, 0x67, 0x59, 0x6B, 0x77, 0x67, 0x59,
        0x59, 0x77, 0x48, 0x51, 0x59, 0x44, 0x56, 0x52, 0x30, 0x4F,
        0x42, 0x42, 0x59, 0x45, 0x46, 0x47, 0x65, 0x75, 0x59, 0x50,
        0x39, 0x2B, 0x0A, 0x47, 0x77, 0x2B, 0x56, 0x72, 0x68, 0x2B,
        0x43, 0x57, 0x66, 0x4A, 0x73, 0x56, 0x69, 0x32, 0x54, 0x37,
        0x78, 0x63, 0x79, 0x4D, 0x42, 0x38, 0x47, 0x41, 0x31, 0x55,
        0x64, 0x49, 0x77, 0x51, 0x59, 0x4D, 0x42, 0x61, 0x41, 0x46,
        0x45, 0x63, 0x4B, 0x53, 0x48, 0x36, 0x37, 0x41, 0x71, 0x68,
        0x61, 0x4A, 0x6C, 0x63, 0x72, 0x47, 0x61, 0x6C, 0x37, 0x59,
        0x59, 0x74, 0x2F, 0x58, 0x5A, 0x6C, 0x75, 0x0A, 0x4D, 0x41,
        0x77, 0x47, 0x41, 0x31, 0x55, 0x64, 0x45, 0x77, 0x45, 0x42,
        0x2F, 0x77, 0x51, 0x43, 0x4D, 0x41, 0x41, 0x77, 0x44, 0x67,
        0x59, 0x44, 0x56, 0x52, 0x30, 0x50, 0x41, 0x51, 0x48, 0x2F,
        0x42, 0x41, 0x51, 0x44, 0x41, 0x67, 0x4F, 0x6F, 0x4D, 0x42,
        0x4D, 0x47, 0x41, 0x31, 0x55, 0x64, 0x4A, 0x51, 0x51, 0x4D,
        0x4D, 0x41, 0x6F, 0x47, 0x43, 0x43, 0x73, 0x47, 0x41, 0x51,
        0x55, 0x46, 0x0A, 0x42, 0x77, 0x4D, 0x42, 0x4D, 0x42, 0x45,
        0x47, 0x43, 0x57, 0x43, 0x47, 0x53, 0x41, 0x47, 0x47, 0x2B,
        0x45, 0x49, 0x42, 0x41, 0x51, 0x51, 0x45, 0x41, 0x77, 0x49,
        0x47, 0x51, 0x44, 0x41, 0x4B, 0x42, 0x67, 0x67, 0x71, 0x67,
        0x52, 0x7A, 0x50, 0x56, 0x51, 0x47, 0x44, 0x64, 0x51, 0x4E,
        0x49, 0x41, 0x44, 0x42, 0x46, 0x41, 0x69, 0x41, 0x62, 0x79,
        0x70, 0x51, 0x6F, 0x66, 0x2F, 0x61, 0x79, 0x0A, 0x44, 0x54,
        0x46, 0x44, 0x55, 0x4F, 0x48, 0x56, 0x4E, 0x42, 0x66, 0x64,
        0x72, 0x7A, 0x72, 0x65, 0x67, 0x51, 0x5A, 0x6E, 0x6D, 0x72,
        0x4D, 0x47, 0x49, 0x6E, 0x35, 0x6B, 0x37, 0x50, 0x30, 0x4F,
        0x75, 0x51, 0x49, 0x68, 0x41, 0x4B, 0x46, 0x49, 0x71, 0x44,
        0x4C, 0x52, 0x42, 0x51, 0x6C, 0x72, 0x48, 0x4F, 0x75, 0x4A,
        0x45, 0x6D, 0x62, 0x59, 0x4F, 0x4B, 0x48, 0x45, 0x58, 0x49,
        0x6B, 0x4A, 0x0A, 0x44, 0x2F, 0x33, 0x70, 0x77, 0x44, 0x73,
        0x64, 0x2B, 0x38, 0x32, 0x31, 0x54, 0x44, 0x46, 0x6F, 0x0A,
        0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x45, 0x4E, 0x44, 0x20, 0x43,
        0x45, 0x52, 0x54, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x45,
        0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x0A, 0x43, 0x65, 0x72, 0x74,
        0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x65, 0x3A, 0x0A, 0x20,
        0x20, 0x20, 0x20, 0x44, 0x61, 0x74, 0x61, 0x3A, 0x0A, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x56, 0x65, 0x72,
        0x73, 0x69, 0x6F, 0x6E, 0x3A, 0x20, 0x33, 0x20, 0x28, 0x30,
        0x78, 0x32, 0x29, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x53, 0x65, 0x72, 0x69, 0x61, 0x6C, 0x20, 0x4E,
        0x75, 0x6D, 0x62, 0x65, 0x72, 0x3A, 0x20, 0x31, 0x20, 0x28,
        0x30, 0x78, 0x31, 0x29, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x53, 0x69, 0x67, 0x6E, 0x61, 0x74, 0x75,
        0x72, 0x65, 0x20, 0x41, 0x6C, 0x67, 0x6F, 0x72, 0x69, 0x74,
        0x68, 0x6D, 0x3A, 0x20, 0x53, 0x4D, 0x32, 0x2D, 0x77, 0x69,
        0x74, 0x68, 0x2D, 0x53, 0x4D, 0x33, 0x0A, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x49, 0x73, 0x73, 0x75, 0x65,
        0x72, 0x3A, 0x20, 0x43, 0x20, 0x3D, 0x20, 0x55, 0x53, 0x2C,
        0x20, 0x53, 0x54, 0x20, 0x3D, 0x20, 0x4D, 0x6F, 0x6E, 0x74,
        0x61, 0x6E, 0x61, 0x2C, 0x20, 0x4C, 0x20, 0x3D, 0x20, 0x42,
        0x6F, 0x7A, 0x65, 0x6D, 0x61, 0x6E, 0x2C, 0x20, 0x4F, 0x20,
        0x3D, 0x20, 0x77, 0x6F, 0x6C, 0x66, 0x53, 0x53, 0x4C, 0x5F,
        0x53, 0x4D, 0x32, 0x2C, 0x20, 0x4F, 0x55, 0x20, 0x3D, 0x20,
        0x52, 0x6F, 0x6F, 0x74, 0x2D, 0x53, 0x4D, 0x32, 0x2C, 0x20,
        0x43, 0x4E, 0x20, 0x3D, 0x20, 0x77, 0x77, 0x77, 0x2E, 0x77,
        0x6F, 0x6C, 0x66, 0x73, 0x73, 0x6C, 0x2E, 0x63, 0x6F, 0x6D,
        0x2C, 0x20, 0x65, 0x6D, 0x61, 0x69, 0x6C, 0x41, 0x64, 0x64,
        0x72, 0x65, 0x73, 0x73, 0x20, 0x3D, 0x20, 0x69, 0x6E, 0x66,
        0x6F, 0x40, 0x77, 0x6F, 0x6C, 0x66, 0x73, 0x73, 0x6C, 0x2E,
        0x63, 0x6F, 0x6D, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x56, 0x61, 0x6C, 0x69, 0x64, 0x69, 0x74, 0x79,
        0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x4E, 0x6F, 0x74, 0x20, 0x42, 0x65, 0x66,
        0x6F, 0x72, 0x65, 0x3A, 0x20, 0x46, 0x65, 0x62, 0x20, 0x31,
        0x35, 0x20, 0x30, 0x36, 0x3A, 0x32, 0x33, 0x3A, 0x30, 0x37,
        0x20, 0x32, 0x30, 0x32, 0x33, 0x20, 0x47, 0x4D, 0x54, 0x0A,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x4E, 0x6F, 0x74, 0x20, 0x41, 0x66, 0x74, 0x65,
        0x72, 0x20, 0x3A, 0x20, 0x4E, 0x6F, 0x76, 0x20, 0x31, 0x31,
        0x20, 0x30, 0x36, 0x3A, 0x32, 0x33, 0x3A, 0x30, 0x37, 0x20,
        0x32, 0x30, 0x32, 0x35, 0x20, 0x47, 0x4D, 0x54, 0x0A, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x53, 0x75, 0x62,
        0x6A, 0x65, 0x63, 0x74, 0x3A, 0x20, 0x43, 0x20, 0x3D, 0x20,
        0x55, 0x53, 0x2C, 0x20, 0x53, 0x54, 0x20, 0x3D, 0x20, 0x4D,
        0x6F, 0x6E, 0x74, 0x61, 0x6E, 0x61, 0x2C, 0x20, 0x4C, 0x20,
        0x3D, 0x20, 0x42, 0x6F, 0x7A, 0x65, 0x6D, 0x61, 0x6E, 0x2C,
        0x20, 0x4F, 0x20, 0x3D, 0x20, 0x77, 0x6F, 0x6C, 0x66, 0x53,
        0x53, 0x4C, 0x5F, 0x73, 0x6D, 0x32, 0x2C, 0x20, 0x4F, 0x55,
        0x20, 0x3D, 0x20, 0x43, 0x41, 0x2D, 0x73, 0x6D, 0x32, 0x2C,
        0x20, 0x43, 0x4E, 0x20, 0x3D, 0x20, 0x77, 0x77, 0x77, 0x2E,
        0x77, 0x6F, 0x6C, 0x66, 0x73, 0x73, 0x6C, 0x2E, 0x63, 0x6F,
        0x6D, 0x2C, 0x20, 0x65, 0x6D, 0x61, 0x69, 0x6C, 0x41, 0x64,
        0x64, 0x72, 0x65, 0x73, 0x73, 0x20, 0x3D, 0x20, 0x69, 0x6E,
        0x66, 0x6F, 0x40, 0x77, 0x6F, 0x6C, 0x66, 0x73, 0x73, 0x6C,
        0x2E, 0x63, 0x6F, 0x6D, 0x2C, 0x20, 0x55, 0x49, 0x44, 0x20,
        0x3D, 0x20, 0x77, 0x6F, 0x6C, 0x66, 0x53, 0x53, 0x4C, 0x0A,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x53, 0x75,
        0x62, 0x6A, 0x65, 0x63, 0x74, 0x20, 0x50, 0x75, 0x62, 0x6C,
        0x69, 0x63, 0x20, 0x4B, 0x65, 0x79, 0x20, 0x49, 0x6E, 0x66,
        0x6F, 0x3A, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x50, 0x75, 0x62, 0x6C, 0x69,
        0x63, 0x20, 0x4B, 0x65, 0x79, 0x20, 0x41, 0x6C, 0x67, 0x6F,
        0x72, 0x69, 0x74, 0x68, 0x6D, 0x3A, 0x20, 0x73, 0x6D, 0x32,
        0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x50, 0x75, 0x62,
        0x6C, 0x69, 0x63, 0x2D, 0x4B, 0x65, 0x79, 0x3A, 0x20, 0x28,
        0x32, 0x35, 0x36, 0x20, 0x62, 0x69, 0x74, 0x29, 0x0A, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x70, 0x75, 0x62, 0x3A, 0x0A,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x30, 0x34, 0x3A, 0x32, 0x31, 0x3A, 0x39, 0x32, 0x3A, 0x66,
        0x37, 0x3A, 0x63, 0x62, 0x3A, 0x32, 0x34, 0x3A, 0x64, 0x66,
        0x3A, 0x36, 0x34, 0x3A, 0x34, 0x64, 0x3A, 0x62, 0x61, 0x3A,
        0x61, 0x62, 0x3A, 0x36, 0x36, 0x3A, 0x37, 0x62, 0x3A, 0x38,
        0x33, 0x3A, 0x37, 0x35, 0x3A, 0x0A, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x61, 0x39, 0x3A, 0x32,
        0x39, 0x3A, 0x65, 0x37, 0x3A, 0x66, 0x66, 0x3A, 0x36, 0x34,
        0x3A, 0x36, 0x33, 0x3A, 0x62, 0x36, 0x3A, 0x64, 0x35, 0x3A,
        0x34, 0x32, 0x3A, 0x38, 0x30, 0x3A, 0x32, 0x30, 0x3A, 0x62,
        0x64, 0x3A, 0x65, 0x32, 0x3A, 0x65, 0x32, 0x3A, 0x30, 0x32,
        0x3A, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x31, 0x32, 0x3A, 0x33, 0x62, 0x3A, 0x38, 0x65,
        0x3A, 0x62, 0x34, 0x3A, 0x30, 0x30, 0x3A, 0x39, 0x35, 0x3A,
        0x30, 0x39, 0x3A, 0x38, 0x30, 0x3A, 0x63, 0x62, 0x3A, 0x35,
        0x36, 0x3A, 0x65, 0x64, 0x3A, 0x34, 0x62, 0x3A, 0x63, 0x61,
        0x3A, 0x38, 0x64, 0x3A, 0x35, 0x37, 0x3A, 0x0A, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x65, 0x36,
        0x3A, 0x61, 0x65, 0x3A, 0x30, 0x35, 0x3A, 0x64, 0x33, 0x3A,
        0x37, 0x36, 0x3A, 0x32, 0x37, 0x3A, 0x36, 0x33, 0x3A, 0x37,
        0x31, 0x3A, 0x33, 0x39, 0x3A, 0x38, 0x39, 0x3A, 0x62, 0x37,
        0x3A, 0x36, 0x39, 0x3A, 0x65, 0x36, 0x3A, 0x34, 0x38, 0x3A,
        0x38, 0x30, 0x3A, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x61, 0x65, 0x3A, 0x64, 0x31, 0x3A,
        0x61, 0x39, 0x3A, 0x34, 0x38, 0x3A, 0x31, 0x32, 0x0A, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x41, 0x53, 0x4E, 0x31, 0x20,
        0x4F, 0x49, 0x44, 0x3A, 0x20, 0x53, 0x4D, 0x32, 0x0A, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x58, 0x35, 0x30,
        0x39, 0x76, 0x33, 0x20, 0x65, 0x78, 0x74, 0x65, 0x6E, 0x73,
        0x69, 0x6F, 0x6E, 0x73, 0x3A, 0x0A, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x58, 0x35,
        0x30, 0x39, 0x76, 0x33, 0x20, 0x53, 0x75, 0x62, 0x6A, 0x65,
        0x63, 0x74, 0x20, 0x4B, 0x65, 0x79, 0x20, 0x49, 0x64, 0x65,
        0x6E, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x3A, 0x20, 0x0A,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x34, 0x37, 0x3A, 0x30,
        0x41, 0x3A, 0x34, 0x38, 0x3A, 0x37, 0x45, 0x3A, 0x42, 0x42,
        0x3A, 0x30, 0x32, 0x3A, 0x41, 0x38, 0x3A, 0x35, 0x41, 0x3A,
        0x32, 0x36, 0x3A, 0x35, 0x37, 0x3A, 0x32, 0x42, 0x3A, 0x31,
        0x39, 0x3A, 0x41, 0x39, 0x3A, 0x37, 0x42, 0x3A, 0x36, 0x31,
        0x3A, 0x38, 0x42, 0x3A, 0x37, 0x46, 0x3A, 0x35, 0x44, 0x3A,
        0x39, 0x39, 0x3A, 0x36, 0x45, 0x0A, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x58, 0x35,
        0x30, 0x39, 0x76, 0x33, 0x20, 0x41, 0x75, 0x74, 0x68, 0x6F,
        0x72, 0x69, 0x74, 0x79, 0x20, 0x4B, 0x65, 0x79, 0x20, 0x49,
        0x64, 0x65, 0x6E, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x3A,
        0x20, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x33, 0x34,
        0x3A, 0x31, 0x44, 0x3A, 0x37, 0x39, 0x3A, 0x34, 0x34, 0x3A,
        0x31, 0x35, 0x3A, 0x37, 0x39, 0x3A, 0x41, 0x31, 0x3A, 0x42,
        0x31, 0x3A, 0x36, 0x33, 0x3A, 0x39, 0x39, 0x3A, 0x45, 0x33,
        0x3A, 0x45, 0x44, 0x3A, 0x36, 0x35, 0x3A, 0x37, 0x43, 0x3A,
        0x36, 0x34, 0x3A, 0x38, 0x39, 0x3A, 0x38, 0x30, 0x3A, 0x46,
        0x46, 0x3A, 0x42, 0x38, 0x3A, 0x45, 0x43, 0x0A, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x58, 0x35, 0x30, 0x39, 0x76, 0x33, 0x20, 0x42, 0x61, 0x73,
        0x69, 0x63, 0x20, 0x43, 0x6F, 0x6E, 0x73, 0x74, 0x72, 0x61,
        0x69, 0x6E, 0x74, 0x73, 0x3A, 0x20, 0x63, 0x72, 0x69, 0x74,
        0x69, 0x63, 0x61, 0x6C, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x43, 0x41, 0x3A, 0x54, 0x52, 0x55, 0x45, 0x0A, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x58, 0x35, 0x30, 0x39, 0x76, 0x33, 0x20, 0x4B, 0x65,
        0x79, 0x20, 0x55, 0x73, 0x61, 0x67, 0x65, 0x3A, 0x20, 0x63,
        0x72, 0x69, 0x74, 0x69, 0x63, 0x61, 0x6C, 0x0A, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x44, 0x69, 0x67, 0x69, 0x74, 0x61,
        0x6C, 0x20, 0x53, 0x69, 0x67, 0x6E, 0x61, 0x74, 0x75, 0x72,
        0x65, 0x2C, 0x20, 0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69,
        0x63, 0x61, 0x74, 0x65, 0x20, 0x53, 0x69, 0x67, 0x6E, 0x2C,
        0x20, 0x43, 0x52, 0x4C, 0x20, 0x53, 0x69, 0x67, 0x6E, 0x0A,
        0x20, 0x20, 0x20, 0x20, 0x53, 0x69, 0x67, 0x6E, 0x61, 0x74,
        0x75, 0x72, 0x65, 0x20, 0x41, 0x6C, 0x67, 0x6F, 0x72, 0x69,
        0x74, 0x68, 0x6D, 0x3A, 0x20, 0x53, 0x4D, 0x32, 0x2D, 0x77,
        0x69, 0x74, 0x68, 0x2D, 0x53, 0x4D, 0x33, 0x0A, 0x20, 0x20,
        0x20, 0x20, 0x53, 0x69, 0x67, 0x6E, 0x61, 0x74, 0x75, 0x72,
        0x65, 0x20, 0x56, 0x61, 0x6C, 0x75, 0x65, 0x3A, 0x0A, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x33, 0x30, 0x3A,
        0x34, 0x35, 0x3A, 0x30, 0x32, 0x3A, 0x32, 0x30, 0x3A, 0x34,
        0x37, 0x3A, 0x34, 0x65, 0x3A, 0x30, 0x30, 0x3A, 0x30, 0x33,
        0x3A, 0x61, 0x62, 0x3A, 0x33, 0x34, 0x3A, 0x61, 0x31, 0x3A,
        0x61, 0x66, 0x3A, 0x35, 0x39, 0x3A, 0x33, 0x39, 0x3A, 0x38,
        0x66, 0x3A, 0x36, 0x30, 0x3A, 0x33, 0x36, 0x3A, 0x62, 0x66,
        0x3A, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x38, 0x39, 0x3A, 0x38, 0x38, 0x3A, 0x34, 0x32, 0x3A, 0x34,
        0x31, 0x3A, 0x32, 0x37, 0x3A, 0x63, 0x31, 0x3A, 0x64, 0x64,
        0x3A, 0x35, 0x37, 0x3A, 0x63, 0x39, 0x3A, 0x37, 0x39, 0x3A,
        0x63, 0x62, 0x3A, 0x31, 0x66, 0x3A, 0x35, 0x36, 0x3A, 0x35,
        0x63, 0x3A, 0x31, 0x36, 0x3A, 0x62, 0x35, 0x3A, 0x32, 0x38,
        0x3A, 0x62, 0x64, 0x3A, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x30, 0x32, 0x3A, 0x32, 0x31, 0x3A, 0x30,
        0x30, 0x3A, 0x38, 0x62, 0x3A, 0x32, 0x65, 0x3A, 0x32, 0x35,
        0x3A, 0x65, 0x62, 0x3A, 0x32, 0x31, 0x3A, 0x39, 0x62, 0x3A,
        0x61, 0x39, 0x3A, 0x32, 0x62, 0x3A, 0x61, 0x36, 0x3A, 0x36,
        0x61, 0x3A, 0x35, 0x62, 0x3A, 0x64, 0x62, 0x3A, 0x61, 0x37,
        0x3A, 0x63, 0x37, 0x3A, 0x32, 0x62, 0x3A, 0x0A, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x31, 0x31, 0x3A, 0x64,
        0x66, 0x3A, 0x37, 0x33, 0x3A, 0x31, 0x35, 0x3A, 0x61, 0x64,
        0x3A, 0x65, 0x34, 0x3A, 0x63, 0x35, 0x3A, 0x63, 0x33, 0x3A,
        0x63, 0x32, 0x3A, 0x66, 0x33, 0x3A, 0x62, 0x34, 0x3A, 0x62,
        0x34, 0x3A, 0x36, 0x37, 0x3A, 0x61, 0x66, 0x3A, 0x64, 0x37,
        0x3A, 0x35, 0x31, 0x3A, 0x31, 0x63, 0x0A, 0x2D, 0x2D, 0x2D,
        0x2D, 0x2D, 0x42, 0x45, 0x47, 0x49, 0x4E, 0x20, 0x43, 0x45,
        0x52, 0x54, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x45, 0x2D,
        0x2D, 0x2D, 0x2D, 0x2D, 0x0A, 0x4D, 0x49, 0x49, 0x43, 0x6C,
        0x6A, 0x43, 0x43, 0x41, 0x6A, 0x79, 0x67, 0x41, 0x77, 0x49,
        0x42, 0x41, 0x67, 0x49, 0x42, 0x41, 0x54, 0x41, 0x4B, 0x42,
        0x67, 0x67, 0x71, 0x67, 0x52, 0x7A, 0x50, 0x56, 0x51, 0x47,
        0x44, 0x64, 0x54, 0x43, 0x42, 0x6C, 0x54, 0x45, 0x4C, 0x4D,
        0x41, 0x6B, 0x47, 0x41, 0x31, 0x55, 0x45, 0x42, 0x68, 0x4D,
        0x43, 0x56, 0x56, 0x4D, 0x78, 0x45, 0x44, 0x41, 0x4F, 0x0A,
        0x42, 0x67, 0x4E, 0x56, 0x42, 0x41, 0x67, 0x4D, 0x42, 0x30,
        0x31, 0x76, 0x62, 0x6E, 0x52, 0x68, 0x62, 0x6D, 0x45, 0x78,
        0x45, 0x44, 0x41, 0x4F, 0x42, 0x67, 0x4E, 0x56, 0x42, 0x41,
        0x63, 0x4D, 0x42, 0x30, 0x4A, 0x76, 0x65, 0x6D, 0x56, 0x74,
        0x59, 0x57, 0x34, 0x78, 0x46, 0x44, 0x41, 0x53, 0x42, 0x67,
        0x4E, 0x56, 0x42, 0x41, 0x6F, 0x4D, 0x43, 0x33, 0x64, 0x76,
        0x62, 0x47, 0x5A, 0x54, 0x0A, 0x55, 0x30, 0x78, 0x66, 0x55,
        0x30, 0x30, 0x79, 0x4D, 0x52, 0x45, 0x77, 0x44, 0x77, 0x59,
        0x44, 0x56, 0x51, 0x51, 0x4C, 0x44, 0x41, 0x68, 0x53, 0x62,
        0x32, 0x39, 0x30, 0x4C, 0x56, 0x4E, 0x4E, 0x4D, 0x6A, 0x45,
        0x59, 0x4D, 0x42, 0x59, 0x47, 0x41, 0x31, 0x55, 0x45, 0x41,
        0x77, 0x77, 0x50, 0x64, 0x33, 0x64, 0x33, 0x4C, 0x6E, 0x64,
        0x76, 0x62, 0x47, 0x5A, 0x7A, 0x63, 0x32, 0x77, 0x75, 0x0A,
        0x59, 0x32, 0x39, 0x74, 0x4D, 0x52, 0x38, 0x77, 0x48, 0x51,
        0x59, 0x4A, 0x4B, 0x6F, 0x5A, 0x49, 0x68, 0x76, 0x63, 0x4E,
        0x41, 0x51, 0x6B, 0x42, 0x46, 0x68, 0x42, 0x70, 0x62, 0x6D,
        0x5A, 0x76, 0x51, 0x48, 0x64, 0x76, 0x62, 0x47, 0x5A, 0x7A,
        0x63, 0x32, 0x77, 0x75, 0x59, 0x32, 0x39, 0x74, 0x4D, 0x42,
        0x34, 0x58, 0x44, 0x54, 0x49, 0x7A, 0x4D, 0x44, 0x49, 0x78,
        0x4E, 0x54, 0x41, 0x32, 0x0A, 0x4D, 0x6A, 0x4D, 0x77, 0x4E,
        0x31, 0x6F, 0x58, 0x44, 0x54, 0x49, 0x31, 0x4D, 0x54, 0x45,
        0x78, 0x4D, 0x54, 0x41, 0x32, 0x4D, 0x6A, 0x4D, 0x77, 0x4E,
        0x31, 0x6F, 0x77, 0x67, 0x61, 0x77, 0x78, 0x43, 0x7A, 0x41,
        0x4A, 0x42, 0x67, 0x4E, 0x56, 0x42, 0x41, 0x59, 0x54, 0x41,
        0x6C, 0x56, 0x54, 0x4D, 0x52, 0x41, 0x77, 0x44, 0x67, 0x59,
        0x44, 0x56, 0x51, 0x51, 0x49, 0x44, 0x41, 0x64, 0x4E, 0x0A,
        0x62, 0x32, 0x35, 0x30, 0x59, 0x57, 0x35, 0x68, 0x4D, 0x52,
        0x41, 0x77, 0x44, 0x67, 0x59, 0x44, 0x56, 0x51, 0x51, 0x48,
        0x44, 0x41, 0x64, 0x43, 0x62, 0x33, 0x70, 0x6C, 0x62, 0x57,
        0x46, 0x75, 0x4D, 0x52, 0x51, 0x77, 0x45, 0x67, 0x59, 0x44,
        0x56, 0x51, 0x51, 0x4B, 0x44, 0x41, 0x74, 0x33, 0x62, 0x32,
        0x78, 0x6D, 0x55, 0x31, 0x4E, 0x4D, 0x58, 0x33, 0x4E, 0x74,
        0x4D, 0x6A, 0x45, 0x50, 0x0A, 0x4D, 0x41, 0x30, 0x47, 0x41,
        0x31, 0x55, 0x45, 0x43, 0x77, 0x77, 0x47, 0x51, 0x30, 0x45,
        0x74, 0x63, 0x32, 0x30, 0x79, 0x4D, 0x52, 0x67, 0x77, 0x46,
        0x67, 0x59, 0x44, 0x56, 0x51, 0x51, 0x44, 0x44, 0x41, 0x39,
        0x33, 0x64, 0x33, 0x63, 0x75, 0x64, 0x32, 0x39, 0x73, 0x5A,
        0x6E, 0x4E, 0x7A, 0x62, 0x43, 0x35, 0x6A, 0x62, 0x32, 0x30,
        0x78, 0x48, 0x7A, 0x41, 0x64, 0x42, 0x67, 0x6B, 0x71, 0x0A,
        0x68, 0x6B, 0x69, 0x47, 0x39, 0x77, 0x30, 0x42, 0x43, 0x51,
        0x45, 0x57, 0x45, 0x47, 0x6C, 0x75, 0x5A, 0x6D, 0x39, 0x41,
        0x64, 0x32, 0x39, 0x73, 0x5A, 0x6E, 0x4E, 0x7A, 0x62, 0x43,
        0x35, 0x6A, 0x62, 0x32, 0x30, 0x78, 0x46, 0x7A, 0x41, 0x56,
        0x42, 0x67, 0x6F, 0x4A, 0x6B, 0x69, 0x61, 0x4A, 0x6B, 0x2F,
        0x49, 0x73, 0x5A, 0x41, 0x45, 0x42, 0x44, 0x41, 0x64, 0x33,
        0x62, 0x32, 0x78, 0x6D, 0x0A, 0x55, 0x31, 0x4E, 0x4D, 0x4D,
        0x46, 0x6F, 0x77, 0x46, 0x41, 0x59, 0x49, 0x4B, 0x6F, 0x45,
        0x63, 0x7A, 0x31, 0x55, 0x42, 0x67, 0x69, 0x30, 0x47, 0x43,
        0x43, 0x71, 0x42, 0x48, 0x4D, 0x39, 0x56, 0x41, 0x59, 0x49,
        0x74, 0x41, 0x30, 0x49, 0x41, 0x42, 0x43, 0x47, 0x53, 0x39,
        0x38, 0x73, 0x6B, 0x33, 0x32, 0x52, 0x4E, 0x75, 0x71, 0x74,
        0x6D, 0x65, 0x34, 0x4E, 0x31, 0x71, 0x53, 0x6E, 0x6E, 0x0A,
        0x2F, 0x32, 0x52, 0x6A, 0x74, 0x74, 0x56, 0x43, 0x67, 0x43,
        0x43, 0x39, 0x34, 0x75, 0x49, 0x43, 0x45, 0x6A, 0x75, 0x4F,
        0x74, 0x41, 0x43, 0x56, 0x43, 0x59, 0x44, 0x4C, 0x56, 0x75,
        0x31, 0x4C, 0x79, 0x6F, 0x31, 0x58, 0x35, 0x71, 0x34, 0x46,
        0x30, 0x33, 0x59, 0x6E, 0x59, 0x33, 0x45, 0x35, 0x69, 0x62,
        0x64, 0x70, 0x35, 0x6B, 0x69, 0x41, 0x72, 0x74, 0x47, 0x70,
        0x53, 0x42, 0x4B, 0x6A, 0x0A, 0x59, 0x7A, 0x42, 0x68, 0x4D,
        0x42, 0x30, 0x47, 0x41, 0x31, 0x55, 0x64, 0x44, 0x67, 0x51,
        0x57, 0x42, 0x42, 0x52, 0x48, 0x43, 0x6B, 0x68, 0x2B, 0x75,
        0x77, 0x4B, 0x6F, 0x57, 0x69, 0x5A, 0x58, 0x4B, 0x78, 0x6D,
        0x70, 0x65, 0x32, 0x47, 0x4C, 0x66, 0x31, 0x32, 0x5A, 0x62,
        0x6A, 0x41, 0x66, 0x42, 0x67, 0x4E, 0x56, 0x48, 0x53, 0x4D,
        0x45, 0x47, 0x44, 0x41, 0x57, 0x67, 0x42, 0x51, 0x30, 0x0A,
        0x48, 0x58, 0x6C, 0x45, 0x46, 0x58, 0x6D, 0x68, 0x73, 0x57,
        0x4F, 0x5A, 0x34, 0x2B, 0x31, 0x6C, 0x66, 0x47, 0x53, 0x4A,
        0x67, 0x50, 0x2B, 0x34, 0x37, 0x44, 0x41, 0x50, 0x42, 0x67,
        0x4E, 0x56, 0x48, 0x52, 0x4D, 0x42, 0x41, 0x66, 0x38, 0x45,
        0x42, 0x54, 0x41, 0x44, 0x41, 0x51, 0x48, 0x2F, 0x4D, 0x41,
        0x34, 0x47, 0x41, 0x31, 0x55, 0x64, 0x44, 0x77, 0x45, 0x42,
        0x2F, 0x77, 0x51, 0x45, 0x0A, 0x41, 0x77, 0x49, 0x42, 0x68,
        0x6A, 0x41, 0x4B, 0x42, 0x67, 0x67, 0x71, 0x67, 0x52, 0x7A,
        0x50, 0x56, 0x51, 0x47, 0x44, 0x64, 0x51, 0x4E, 0x49, 0x41,
        0x44, 0x42, 0x46, 0x41, 0x69, 0x42, 0x48, 0x54, 0x67, 0x41,
        0x44, 0x71, 0x7A, 0x53, 0x68, 0x72, 0x31, 0x6B, 0x35, 0x6A,
        0x32, 0x41, 0x32, 0x76, 0x34, 0x6D, 0x49, 0x51, 0x6B, 0x45,
        0x6E, 0x77, 0x64, 0x31, 0x58, 0x79, 0x58, 0x6E, 0x4C, 0x0A,
        0x48, 0x31, 0x5A, 0x63, 0x46, 0x72, 0x55, 0x6F, 0x76, 0x51,
        0x49, 0x68, 0x41, 0x49, 0x73, 0x75, 0x4A, 0x65, 0x73, 0x68,
        0x6D, 0x36, 0x6B, 0x72, 0x70, 0x6D, 0x70, 0x62, 0x32, 0x36,
        0x66, 0x48, 0x4B, 0x78, 0x48, 0x66, 0x63, 0x78, 0x57, 0x74,
        0x35, 0x4D, 0x58, 0x44, 0x77, 0x76, 0x4F, 0x30, 0x74, 0x47,
        0x65, 0x76, 0x31, 0x31, 0x45, 0x63, 0x0A, 0x2D, 0x2D, 0x2D,
        0x2D, 0x2D, 0x45, 0x4E, 0x44, 0x20, 0x43, 0x45, 0x52, 0x54,
        0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x45, 0x2D, 0x2D, 0x2D,
        0x2D, 0x2D, 0x0A
};
#define sizeof_server_sm2 (sizeof(server_sm2))

/* ./certs/sm2/server-sm2-cert.pem */
static const unsigned char server_sm2_cert[] =
{
        0x43, 0x65, 0x72, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
        0x65, 0x3A, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x44, 0x61, 0x74,
        0x61, 0x3A, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6F, 0x6E, 0x3A, 0x20,
        0x33, 0x20, 0x28, 0x30, 0x78, 0x32, 0x29, 0x0A, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x53, 0x65, 0x72, 0x69,
        0x61, 0x6C, 0x20, 0x4E, 0x75, 0x6D, 0x62, 0x65, 0x72, 0x3A,
        0x20, 0x31, 0x20, 0x28, 0x30, 0x78, 0x31, 0x29, 0x0A, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x53, 0x69, 0x67,
        0x6E, 0x61, 0x74, 0x75, 0x72, 0x65, 0x20, 0x41, 0x6C, 0x67,
        0x6F, 0x72, 0x69, 0x74, 0x68, 0x6D, 0x3A, 0x20, 0x53, 0x4D,
        0x32, 0x2D, 0x77, 0x69, 0x74, 0x68, 0x2D, 0x53, 0x4D, 0x33,
        0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x49,
        0x73, 0x73, 0x75, 0x65, 0x72, 0x3A, 0x20, 0x43, 0x20, 0x3D,
        0x20, 0x55, 0x53, 0x2C, 0x20, 0x53, 0x54, 0x20, 0x3D, 0x20,
        0x4D, 0x6F, 0x6E, 0x74, 0x61, 0x6E, 0x61, 0x2C, 0x20, 0x4C,
        0x20, 0x3D, 0x20, 0x42, 0x6F, 0x7A, 0x65, 0x6D, 0x61, 0x6E,
        0x2C, 0x20, 0x4F, 0x20, 0x3D, 0x20, 0x77, 0x6F, 0x6C, 0x66,
        0x53, 0x53, 0x4C, 0x5F, 0x73, 0x6D, 0x32, 0x2C, 0x20, 0x4F,
        0x55, 0x20, 0x3D, 0x20, 0x43, 0x41, 0x2D, 0x73, 0x6D, 0x32,
        0x2C, 0x20, 0x43, 0x4E, 0x20, 0x3D, 0x20, 0x77, 0x77, 0x77,
        0x2E, 0x77, 0x6F, 0x6C, 0x66, 0x73, 0x73, 0x6C, 0x2E, 0x63,
        0x6F, 0x6D, 0x2C, 0x20, 0x65, 0x6D, 0x61, 0x69, 0x6C, 0x41,
        0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x20, 0x3D, 0x20, 0x69,
        0x6E, 0x66, 0x6F, 0x40, 0x77, 0x6F, 0x6C, 0x66, 0x73, 0x73,
        0x6C, 0x2E, 0x63, 0x6F, 0x6D, 0x2C, 0x20, 0x55, 0x49, 0x44,
        0x20, 0x3D, 0x20, 0x77, 0x6F, 0x6C, 0x66, 0x53, 0x53, 0x4C,
        0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x56,
        0x61, 0x6C, 0x69, 0x64, 0x69, 0x74, 0x79, 0x0A, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x4E, 0x6F, 0x74, 0x20, 0x42, 0x65, 0x66, 0x6F, 0x72, 0x65,
        0x3A, 0x20, 0x46, 0x65, 0x62, 0x20, 0x31, 0x35, 0x20, 0x30,
        0x36, 0x3A, 0x32, 0x33, 0x3A, 0x30, 0x37, 0x20, 0x32, 0x30,
        0x32, 0x33, 0x20, 0x47, 0x4D, 0x54, 0x0A, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x4E,
        0x6F, 0x74, 0x20, 0x41, 0x66, 0x74, 0x65, 0x72, 0x20, 0x3A,
        0x20, 0x4E, 0x6F, 0x76, 0x20, 0x31, 0x31, 0x20, 0x30, 0x36,
        0x3A, 0x32, 0x33, 0x3A, 0x30, 0x37, 0x20, 0x32, 0x30, 0x32,
        0x35, 0x20, 0x47, 0x4D, 0x54, 0x0A, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x53, 0x75, 0x62, 0x6A, 0x65, 0x63,
        0x74, 0x3A, 0x20, 0x43, 0x20, 0x3D, 0x20, 0x55, 0x53, 0x2C,
        0x20, 0x53, 0x54, 0x20, 0x3D, 0x20, 0x4D, 0x6F, 0x6E, 0x74,
        0x61, 0x6E, 0x61, 0x2C, 0x20, 0x4C, 0x20, 0x3D, 0x20, 0x42,
        0x6F, 0x7A, 0x65, 0x6D, 0x61, 0x6E, 0x2C, 0x20, 0x4F, 0x20,
        0x3D, 0x20, 0x77, 0x6F, 0x6C, 0x66, 0x53, 0x53, 0x4C, 0x5F,
        0x73, 0x6D, 0x32, 0x2C, 0x20, 0x4F, 0x55, 0x20, 0x3D, 0x20,
        0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x2D, 0x73, 0x6D, 0x32,
        0x2C, 0x20, 0x43, 0x4E, 0x20, 0x3D, 0x20, 0x77, 0x77, 0x77,
        0x2E, 0x77, 0x6F, 0x6C, 0x66, 0x73, 0x73, 0x6C, 0x2E, 0x63,
        0x6F, 0x6D, 0x2C, 0x20, 0x65, 0x6D, 0x61, 0x69, 0x6C, 0x41,
        0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x20, 0x3D, 0x20, 0x69,
        0x6E, 0x66, 0x6F, 0x40, 0x77, 0x6F, 0x6C, 0x66, 0x73, 0x73,
        0x6C, 0x2E, 0x63, 0x6F, 0x6D, 0x2C, 0x20, 0x55, 0x49, 0x44,
        0x20, 0x3D, 0x20, 0x77, 0x6F, 0x6C, 0x66, 0x53, 0x53, 0x4C,
        0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x53,
        0x75, 0x62, 0x6A, 0x65, 0x63, 0x74, 0x20, 0x50, 0x75, 0x62,
        0x6C, 0x69, 0x63, 0x20, 0x4B, 0x65, 0x79, 0x20, 0x49, 0x6E,
        0x66, 0x6F, 0x3A, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x50, 0x75, 0x62, 0x6C,
        0x69, 0x63, 0x20, 0x4B, 0x65, 0x79, 0x20, 0x41, 0x6C, 0x67,
        0x6F, 0x72, 0x69, 0x74, 0x68, 0x6D, 0x3A, 0x20, 0x73, 0x6D,
        0x32, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x50, 0x75,
        0x62, 0x6C, 0x69, 0x63, 0x2D, 0x4B, 0x65, 0x79, 0x3A, 0x20,
        0x28, 0x32, 0x35, 0x36, 0x20, 0x62, 0x69, 0x74, 0x29, 0x0A,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x70, 0x75, 0x62, 0x3A,
        0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x30, 0x34, 0x3A, 0x39, 0x34, 0x3A, 0x37, 0x30, 0x3A,
        0x32, 0x62, 0x3A, 0x34, 0x36, 0x3A, 0x65, 0x34, 0x3A, 0x35,
        0x65, 0x3A, 0x30, 0x66, 0x3A, 0x34, 0x31, 0x3A, 0x66, 0x62,
        0x3A, 0x38, 0x66, 0x3A, 0x32, 0x64, 0x3A, 0x33, 0x34, 0x3A,
        0x30, 0x61, 0x3A, 0x34, 0x31, 0x3A, 0x0A, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x34, 0x30, 0x3A,
        0x31, 0x39, 0x3A, 0x35, 0x65, 0x3A, 0x66, 0x62, 0x3A, 0x64,
        0x34, 0x3A, 0x31, 0x64, 0x3A, 0x31, 0x31, 0x3A, 0x61, 0x63,
        0x3A, 0x66, 0x61, 0x3A, 0x66, 0x35, 0x3A, 0x39, 0x33, 0x3A,
        0x33, 0x37, 0x3A, 0x63, 0x36, 0x3A, 0x66, 0x61, 0x3A, 0x38,
        0x37, 0x3A, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x30, 0x38, 0x3A, 0x66, 0x37, 0x3A, 0x31,
        0x36, 0x3A, 0x31, 0x66, 0x3A, 0x32, 0x63, 0x3A, 0x63, 0x65,
        0x3A, 0x33, 0x30, 0x3A, 0x34, 0x30, 0x3A, 0x39, 0x64, 0x3A,
        0x34, 0x66, 0x3A, 0x61, 0x36, 0x3A, 0x32, 0x61, 0x3A, 0x30,
        0x61, 0x3A, 0x61, 0x31, 0x3A, 0x64, 0x36, 0x3A, 0x0A, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x39,
        0x35, 0x3A, 0x33, 0x33, 0x3A, 0x63, 0x33, 0x3A, 0x61, 0x36,
        0x3A, 0x30, 0x33, 0x3A, 0x39, 0x38, 0x3A, 0x65, 0x36, 0x3A,
        0x38, 0x64, 0x3A, 0x30, 0x35, 0x3A, 0x33, 0x34, 0x3A, 0x62,
        0x30, 0x3A, 0x39, 0x37, 0x3A, 0x30, 0x63, 0x3A, 0x64, 0x65,
        0x3A, 0x61, 0x34, 0x3A, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x63, 0x37, 0x3A, 0x63, 0x66,
        0x3A, 0x35, 0x33, 0x3A, 0x38, 0x66, 0x3A, 0x64, 0x31, 0x0A,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x41, 0x53, 0x4E, 0x31,
        0x20, 0x4F, 0x49, 0x44, 0x3A, 0x20, 0x53, 0x4D, 0x32, 0x0A,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x58, 0x35,
        0x30, 0x39, 0x76, 0x33, 0x20, 0x65, 0x78, 0x74, 0x65, 0x6E,
        0x73, 0x69, 0x6F, 0x6E, 0x73, 0x3A, 0x0A, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x58,
        0x35, 0x30, 0x39, 0x76, 0x33, 0x20, 0x53, 0x75, 0x62, 0x6A,
        0x65, 0x63, 0x74, 0x20, 0x4B, 0x65, 0x79, 0x20, 0x49, 0x64,
        0x65, 0x6E, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72, 0x3A, 0x20,
        0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x36, 0x37, 0x3A,
        0x41, 0x45, 0x3A, 0x36, 0x30, 0x3A, 0x46, 0x46, 0x3A, 0x37,
        0x45, 0x3A, 0x31, 0x42, 0x3A, 0x30, 0x46, 0x3A, 0x39, 0x35,
        0x3A, 0x41, 0x45, 0x3A, 0x31, 0x46, 0x3A, 0x38, 0x32, 0x3A,
        0x35, 0x39, 0x3A, 0x46, 0x32, 0x3A, 0x36, 0x43, 0x3A, 0x35,
        0x36, 0x3A, 0x32, 0x44, 0x3A, 0x39, 0x33, 0x3A, 0x45, 0x46,
        0x3A, 0x31, 0x37, 0x3A, 0x33, 0x32, 0x0A, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x58,
        0x35, 0x30, 0x39, 0x76, 0x33, 0x20, 0x41, 0x75, 0x74, 0x68,
        0x6F, 0x72, 0x69, 0x74, 0x79, 0x20, 0x4B, 0x65, 0x79, 0x20,
        0x49, 0x64, 0x65, 0x6E, 0x74, 0x69, 0x66, 0x69, 0x65, 0x72,
        0x3A, 0x20, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x34,
        0x37, 0x3A, 0x30, 0x41, 0x3A, 0x34, 0x38, 0x3A, 0x37, 0x45,
        0x3A, 0x42, 0x42, 0x3A, 0x30, 0x32, 0x3A, 0x41, 0x38, 0x3A,
        0x35, 0x41, 0x3A, 0x32, 0x36, 0x3A, 0x35, 0x37, 0x3A, 0x32,
        0x42, 0x3A, 0x31, 0x39, 0x3A, 0x41, 0x39, 0x3A, 0x37, 0x42,
        0x3A, 0x36, 0x31, 0x3A, 0x38, 0x42, 0x3A, 0x37, 0x46, 0x3A,
        0x35, 0x44, 0x3A, 0x39, 0x39, 0x3A, 0x36, 0x45, 0x0A, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x58, 0x35, 0x30, 0x39, 0x76, 0x33, 0x20, 0x42, 0x61,
        0x73, 0x69, 0x63, 0x20, 0x43, 0x6F, 0x6E, 0x73, 0x74, 0x72,
        0x61, 0x69, 0x6E, 0x74, 0x73, 0x3A, 0x20, 0x63, 0x72, 0x69,
        0x74, 0x69, 0x63, 0x61, 0x6C, 0x0A, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x43, 0x41, 0x3A, 0x46, 0x41, 0x4C, 0x53, 0x45,
        0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x58, 0x35, 0x30, 0x39, 0x76, 0x33, 0x20,
        0x4B, 0x65, 0x79, 0x20, 0x55, 0x73, 0x61, 0x67, 0x65, 0x3A,
        0x20, 0x63, 0x72, 0x69, 0x74, 0x69, 0x63, 0x61, 0x6C, 0x0A,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x44, 0x69, 0x67, 0x69,
        0x74, 0x61, 0x6C, 0x20, 0x53, 0x69, 0x67, 0x6E, 0x61, 0x74,
        0x75, 0x72, 0x65, 0x2C, 0x20, 0x4B, 0x65, 0x79, 0x20, 0x45,
        0x6E, 0x63, 0x69, 0x70, 0x68, 0x65, 0x72, 0x6D, 0x65, 0x6E,
        0x74, 0x2C, 0x20, 0x4B, 0x65, 0x79, 0x20, 0x41, 0x67, 0x72,
        0x65, 0x65, 0x6D, 0x65, 0x6E, 0x74, 0x0A, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x58,
        0x35, 0x30, 0x39, 0x76, 0x33, 0x20, 0x45, 0x78, 0x74, 0x65,
        0x6E, 0x64, 0x65, 0x64, 0x20, 0x4B, 0x65, 0x79, 0x20, 0x55,
        0x73, 0x61, 0x67, 0x65, 0x3A, 0x20, 0x0A, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x54, 0x4C, 0x53, 0x20, 0x57, 0x65, 0x62,
        0x20, 0x53, 0x65, 0x72, 0x76, 0x65, 0x72, 0x20, 0x41, 0x75,
        0x74, 0x68, 0x65, 0x6E, 0x74, 0x69, 0x63, 0x61, 0x74, 0x69,
        0x6F, 0x6E, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x4E, 0x65, 0x74, 0x73, 0x63,
        0x61, 0x70, 0x65, 0x20, 0x43, 0x65, 0x72, 0x74, 0x20, 0x54,
        0x79, 0x70, 0x65, 0x3A, 0x20, 0x0A, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x53, 0x53, 0x4C, 0x20, 0x53, 0x65, 0x72, 0x76,
        0x65, 0x72, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x53, 0x69, 0x67,
        0x6E, 0x61, 0x74, 0x75, 0x72, 0x65, 0x20, 0x41, 0x6C, 0x67,
        0x6F, 0x72, 0x69, 0x74, 0x68, 0x6D, 0x3A, 0x20, 0x53, 0x4D,
        0x32, 0x2D, 0x77, 0x69, 0x74, 0x68, 0x2D, 0x53, 0x4D, 0x33,
        0x0A, 0x20, 0x20, 0x20, 0x20, 0x53, 0x69, 0x67, 0x6E, 0x61,
        0x74, 0x75, 0x72, 0x65, 0x20, 0x56, 0x61, 0x6C, 0x75, 0x65,
        0x3A, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x33, 0x30, 0x3A, 0x34, 0x35, 0x3A, 0x30, 0x32, 0x3A, 0x32,
        0x30, 0x3A, 0x31, 0x62, 0x3A, 0x63, 0x61, 0x3A, 0x39, 0x34,
        0x3A, 0x32, 0x38, 0x3A, 0x37, 0x66, 0x3A, 0x66, 0x36, 0x3A,
        0x62, 0x32, 0x3A, 0x30, 0x64, 0x3A, 0x33, 0x31, 0x3A, 0x34,
        0x33, 0x3A, 0x35, 0x30, 0x3A, 0x65, 0x31, 0x3A, 0x64, 0x35,
        0x3A, 0x33, 0x34, 0x3A, 0x0A, 0x20, 0x20, 0x20, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x31, 0x37, 0x3A, 0x64, 0x64, 0x3A, 0x61,
        0x66, 0x3A, 0x33, 0x61, 0x3A, 0x64, 0x65, 0x3A, 0x38, 0x31,
        0x3A, 0x30, 0x36, 0x3A, 0x36, 0x37, 0x3A, 0x39, 0x61, 0x3A,
        0x62, 0x33, 0x3A, 0x30, 0x36, 0x3A, 0x32, 0x32, 0x3A, 0x37,
        0x65, 0x3A, 0x36, 0x34, 0x3A, 0x65, 0x63, 0x3A, 0x66, 0x64,
        0x3A, 0x30, 0x65, 0x3A, 0x62, 0x39, 0x3A, 0x0A, 0x20, 0x20,
        0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x30, 0x32, 0x3A, 0x32,
        0x31, 0x3A, 0x30, 0x30, 0x3A, 0x61, 0x31, 0x3A, 0x34, 0x38,
        0x3A, 0x61, 0x38, 0x3A, 0x33, 0x32, 0x3A, 0x64, 0x31, 0x3A,
        0x30, 0x35, 0x3A, 0x30, 0x39, 0x3A, 0x36, 0x62, 0x3A, 0x31,
        0x63, 0x3A, 0x65, 0x62, 0x3A, 0x38, 0x39, 0x3A, 0x31, 0x32,
        0x3A, 0x36, 0x36, 0x3A, 0x64, 0x38, 0x3A, 0x33, 0x38, 0x3A,
        0x0A, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x20, 0x61,
        0x31, 0x3A, 0x63, 0x34, 0x3A, 0x35, 0x63, 0x3A, 0x38, 0x39,
        0x3A, 0x30, 0x39, 0x3A, 0x30, 0x66, 0x3A, 0x66, 0x64, 0x3A,
        0x65, 0x39, 0x3A, 0x63, 0x30, 0x3A, 0x33, 0x62, 0x3A, 0x31,
        0x64, 0x3A, 0x66, 0x62, 0x3A, 0x63, 0x64, 0x3A, 0x62, 0x35,
        0x3A, 0x34, 0x63, 0x3A, 0x33, 0x31, 0x3A, 0x36, 0x38, 0x0A,
        0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x42, 0x45, 0x47, 0x49, 0x4E,
        0x20, 0x43, 0x45, 0x52, 0x54, 0x49, 0x46, 0x49, 0x43, 0x41,
        0x54, 0x45, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x0A, 0x4D, 0x49,
        0x49, 0x43, 0x32, 0x44, 0x43, 0x43, 0x41, 0x6E, 0x36, 0x67,
        0x41, 0x77, 0x49, 0x42, 0x41, 0x67, 0x49, 0x42, 0x41, 0x54,
        0x41, 0x4B, 0x42, 0x67, 0x67, 0x71, 0x67, 0x52, 0x7A, 0x50,
        0x56, 0x51, 0x47, 0x44, 0x64, 0x54, 0x43, 0x42, 0x72, 0x44,
        0x45, 0x4C, 0x4D, 0x41, 0x6B, 0x47, 0x41, 0x31, 0x55, 0x45,
        0x42, 0x68, 0x4D, 0x43, 0x56, 0x56, 0x4D, 0x78, 0x45, 0x44,
        0x41, 0x4F, 0x0A, 0x42, 0x67, 0x4E, 0x56, 0x42, 0x41, 0x67,
        0x4D, 0x42, 0x30, 0x31, 0x76, 0x62, 0x6E, 0x52, 0x68, 0x62,
        0x6D, 0x45, 0x78, 0x45, 0x44, 0x41, 0x4F, 0x42, 0x67, 0x4E,
        0x56, 0x42, 0x41, 0x63, 0x4D, 0x42, 0x30, 0x4A, 0x76, 0x65,
        0x6D, 0x56, 0x74, 0x59, 0x57, 0x34, 0x78, 0x46, 0x44, 0x41,
        0x53, 0x42, 0x67, 0x4E, 0x56, 0x42, 0x41, 0x6F, 0x4D, 0x43,
        0x33, 0x64, 0x76, 0x62, 0x47, 0x5A, 0x54, 0x0A, 0x55, 0x30,
        0x78, 0x66, 0x63, 0x32, 0x30, 0x79, 0x4D, 0x51, 0x38, 0x77,
        0x44, 0x51, 0x59, 0x44, 0x56, 0x51, 0x51, 0x4C, 0x44, 0x41,
        0x5A, 0x44, 0x51, 0x53, 0x31, 0x7A, 0x62, 0x54, 0x49, 0x78,
        0x47, 0x44, 0x41, 0x57, 0x42, 0x67, 0x4E, 0x56, 0x42, 0x41,
        0x4D, 0x4D, 0x44, 0x33, 0x64, 0x33, 0x64, 0x79, 0x35, 0x33,
        0x62, 0x32, 0x78, 0x6D, 0x63, 0x33, 0x4E, 0x73, 0x4C, 0x6D,
        0x4E, 0x76, 0x0A, 0x62, 0x54, 0x45, 0x66, 0x4D, 0x42, 0x30,
        0x47, 0x43, 0x53, 0x71, 0x47, 0x53, 0x49, 0x62, 0x33, 0x44,
        0x51, 0x45, 0x4A, 0x41, 0x52, 0x59, 0x51, 0x61, 0x57, 0x35,
        0x6D, 0x62, 0x30, 0x42, 0x33, 0x62, 0x32, 0x78, 0x6D, 0x63,
        0x33, 0x4E, 0x73, 0x4C, 0x6D, 0x4E, 0x76, 0x62, 0x54, 0x45,
        0x58, 0x4D, 0x42, 0x55, 0x47, 0x43, 0x67, 0x6D, 0x53, 0x4A,
        0x6F, 0x6D, 0x54, 0x38, 0x69, 0x78, 0x6B, 0x0A, 0x41, 0x51,
        0x45, 0x4D, 0x42, 0x33, 0x64, 0x76, 0x62, 0x47, 0x5A, 0x54,
        0x55, 0x30, 0x77, 0x77, 0x48, 0x68, 0x63, 0x4E, 0x4D, 0x6A,
        0x4D, 0x77, 0x4D, 0x6A, 0x45, 0x31, 0x4D, 0x44, 0x59, 0x79,
        0x4D, 0x7A, 0x41, 0x33, 0x57, 0x68, 0x63, 0x4E, 0x4D, 0x6A,
        0x55, 0x78, 0x4D, 0x54, 0x45, 0x78, 0x4D, 0x44, 0x59, 0x79,
        0x4D, 0x7A, 0x41, 0x33, 0x57, 0x6A, 0x43, 0x42, 0x73, 0x44,
        0x45, 0x4C, 0x0A, 0x4D, 0x41, 0x6B, 0x47, 0x41, 0x31, 0x55,
        0x45, 0x42, 0x68, 0x4D, 0x43, 0x56, 0x56, 0x4D, 0x78, 0x45,
        0x44, 0x41, 0x4F, 0x42, 0x67, 0x4E, 0x56, 0x42, 0x41, 0x67,
        0x4D, 0x42, 0x30, 0x31, 0x76, 0x62, 0x6E, 0x52, 0x68, 0x62,
        0x6D, 0x45, 0x78, 0x45, 0x44, 0x41, 0x4F, 0x42, 0x67, 0x4E,
        0x56, 0x42, 0x41, 0x63, 0x4D, 0x42, 0x30, 0x4A, 0x76, 0x65,
        0x6D, 0x56, 0x74, 0x59, 0x57, 0x34, 0x78, 0x0A, 0x46, 0x44,
        0x41, 0x53, 0x42, 0x67, 0x4E, 0x56, 0x42, 0x41, 0x6F, 0x4D,
        0x43, 0x33, 0x64, 0x76, 0x62, 0x47, 0x5A, 0x54, 0x55, 0x30,
        0x78, 0x66, 0x63, 0x32, 0x30, 0x79, 0x4D, 0x52, 0x4D, 0x77,
        0x45, 0x51, 0x59, 0x44, 0x56, 0x51, 0x51, 0x4C, 0x44, 0x41,
        0x70, 0x54, 0x5A, 0x58, 0x4A, 0x32, 0x5A, 0x58, 0x49, 0x74,
        0x63, 0x32, 0x30, 0x79, 0x4D, 0x52, 0x67, 0x77, 0x46, 0x67,
        0x59, 0x44, 0x0A, 0x56, 0x51, 0x51, 0x44, 0x44, 0x41, 0x39,
        0x33, 0x64, 0x33, 0x63, 0x75, 0x64, 0x32, 0x39, 0x73, 0x5A,
        0x6E, 0x4E, 0x7A, 0x62, 0x43, 0x35, 0x6A, 0x62, 0x32, 0x30,
        0x78, 0x48, 0x7A, 0x41, 0x64, 0x42, 0x67, 0x6B, 0x71, 0x68,
        0x6B, 0x69, 0x47, 0x39, 0x77, 0x30, 0x42, 0x43, 0x51, 0x45,
        0x57, 0x45, 0x47, 0x6C, 0x75, 0x5A, 0x6D, 0x39, 0x41, 0x64,
        0x32, 0x39, 0x73, 0x5A, 0x6E, 0x4E, 0x7A, 0x0A, 0x62, 0x43,
        0x35, 0x6A, 0x62, 0x32, 0x30, 0x78, 0x46, 0x7A, 0x41, 0x56,
        0x42, 0x67, 0x6F, 0x4A, 0x6B, 0x69, 0x61, 0x4A, 0x6B, 0x2F,
        0x49, 0x73, 0x5A, 0x41, 0x45, 0x42, 0x44, 0x41, 0x64, 0x33,
        0x62, 0x32, 0x78, 0x6D, 0x55, 0x31, 0x4E, 0x4D, 0x4D, 0x46,
        0x6F, 0x77, 0x46, 0x41, 0x59, 0x49, 0x4B, 0x6F, 0x45, 0x63,
        0x7A, 0x31, 0x55, 0x42, 0x67, 0x69, 0x30, 0x47, 0x43, 0x43,
        0x71, 0x42, 0x0A, 0x48, 0x4D, 0x39, 0x56, 0x41, 0x59, 0x49,
        0x74, 0x41, 0x30, 0x49, 0x41, 0x42, 0x4A, 0x52, 0x77, 0x4B,
        0x30, 0x62, 0x6B, 0x58, 0x67, 0x39, 0x42, 0x2B, 0x34, 0x38,
        0x74, 0x4E, 0x41, 0x70, 0x42, 0x51, 0x42, 0x6C, 0x65, 0x2B,
        0x39, 0x51, 0x64, 0x45, 0x61, 0x7A, 0x36, 0x39, 0x5A, 0x4D,
        0x33, 0x78, 0x76, 0x71, 0x48, 0x43, 0x50, 0x63, 0x57, 0x48,
        0x79, 0x7A, 0x4F, 0x4D, 0x45, 0x43, 0x64, 0x0A, 0x54, 0x36,
        0x59, 0x71, 0x43, 0x71, 0x48, 0x57, 0x6C, 0x54, 0x50, 0x44,
        0x70, 0x67, 0x4F, 0x59, 0x35, 0x6F, 0x30, 0x46, 0x4E, 0x4C,
        0x43, 0x58, 0x44, 0x4E, 0x36, 0x6B, 0x78, 0x38, 0x39, 0x54,
        0x6A, 0x39, 0x47, 0x6A, 0x67, 0x59, 0x6B, 0x77, 0x67, 0x59,
        0x59, 0x77, 0x48, 0x51, 0x59, 0x44, 0x56, 0x52, 0x30, 0x4F,
        0x42, 0x42, 0x59, 0x45, 0x46, 0x47, 0x65, 0x75, 0x59, 0x50,
        0x39, 0x2B, 0x0A, 0x47, 0x77, 0x2B, 0x56, 0x72, 0x68, 0x2B,
        0x43, 0x57, 0x66, 0x4A, 0x73, 0x56, 0x69, 0x32, 0x54, 0x37,
        0x78, 0x63, 0x79, 0x4D, 0x42, 0x38, 0x47, 0x41, 0x31, 0x55,
        0x64, 0x49, 0x77, 0x51, 0x59, 0x4D, 0x42, 0x61, 0x41, 0x46,
        0x45, 0x63, 0x4B, 0x53, 0x48, 0x36, 0x37, 0x41, 0x71, 0x68,
        0x61, 0x4A, 0x6C, 0x63, 0x72, 0x47, 0x61, 0x6C, 0x37, 0x59,
        0x59, 0x74, 0x2F, 0x58, 0x5A, 0x6C, 0x75, 0x0A, 0x4D, 0x41,
        0x77, 0x47, 0x41, 0x31, 0x55, 0x64, 0x45, 0x77, 0x45, 0x42,
        0x2F, 0x77, 0x51, 0x43, 0x4D, 0x41, 0x41, 0x77, 0x44, 0x67,
        0x59, 0x44, 0x56, 0x52, 0x30, 0x50, 0x41, 0x51, 0x48, 0x2F,
        0x42, 0x41, 0x51, 0x44, 0x41, 0x67, 0x4F, 0x6F, 0x4D, 0x42,
        0x4D, 0x47, 0x41, 0x31, 0x55, 0x64, 0x4A, 0x51, 0x51, 0x4D,
        0x4D, 0x41, 0x6F, 0x47, 0x43, 0x43, 0x73, 0x47, 0x41, 0x51,
        0x55, 0x46, 0x0A, 0x42, 0x77, 0x4D, 0x42, 0x4D, 0x42, 0x45,
        0x47, 0x43, 0x57, 0x43, 0x47, 0x53, 0x41, 0x47, 0x47, 0x2B,
        0x45, 0x49, 0x42, 0x41, 0x51, 0x51, 0x45, 0x41, 0x77, 0x49,
        0x47, 0x51, 0x44, 0x41, 0x4B, 0x42, 0x67, 0x67, 0x71, 0x67,
        0x52, 0x7A, 0x50, 0x56, 0x51, 0x47, 0x44, 0x64, 0x51, 0x4E,
        0x49, 0x41, 0x44, 0x42, 0x46, 0x41, 0x69, 0x41, 0x62, 0x79,
        0x70, 0x51, 0x6F, 0x66, 0x2F, 0x61, 0x79, 0x0A, 0x44, 0x54,
        0x46, 0x44, 0x55, 0x4F, 0x48, 0x56, 0x4E, 0x42, 0x66, 0x64,
        0x72, 0x7A, 0x72, 0x65, 0x67, 0x51, 0x5A, 0x6E, 0x6D, 0x72,
        0x4D, 0x47, 0x49, 0x6E, 0x35, 0x6B, 0x37, 0x50, 0x30, 0x4F,
        0x75, 0x51, 0x49, 0x68, 0x41, 0x4B, 0x46, 0x49, 0x71, 0x44,
        0x4C, 0x52, 0x42, 0x51, 0x6C, 0x72, 0x48, 0x4F, 0x75, 0x4A,
        0x45, 0x6D, 0x62, 0x59, 0x4F, 0x4B, 0x48, 0x45, 0x58, 0x49,
        0x6B, 0x4A, 0x0A, 0x44, 0x2F, 0x33, 0x70, 0x77, 0x44, 0x73,
        0x64, 0x2B, 0x38, 0x32, 0x31, 0x54, 0x44, 0x46, 0x6F, 0x0A,
        0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x45, 0x4E, 0x44, 0x20, 0x43,
        0x45, 0x52, 0x54, 0x49, 0x46, 0x49, 0x43, 0x41, 0x54, 0x45,
        0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x0A
};
#define sizeof_server_sm2_cert (sizeof(server_sm2_cert))

/* ./certs/sm2/server-sm2-key.pem */
static const unsigned char server_sm2_key[] =
{
        0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x42, 0x45, 0x47, 0x49, 0x4E,
        0x20, 0x50, 0x55, 0x42, 0x4C, 0x49, 0x43, 0x20, 0x4B, 0x45,
        0x59, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x0A, 0x4D, 0x46, 0x6F,
        0x77, 0x46, 0x41, 0x59, 0x49, 0x4B, 0x6F, 0x45, 0x63, 0x7A,
        0x31, 0x55, 0x42, 0x67, 0x69, 0x30, 0x47, 0x43, 0x43, 0x71,
        0x42, 0x48, 0x4D, 0x39, 0x56, 0x41, 0x59, 0x49, 0x74, 0x41,
        0x30, 0x49, 0x41, 0x42, 0x4A, 0x52, 0x77, 0x4B, 0x30, 0x62,
        0x6B, 0x58, 0x67, 0x39, 0x42, 0x2B, 0x34, 0x38, 0x74, 0x4E,
        0x41, 0x70, 0x42, 0x51, 0x42, 0x6C, 0x65, 0x2B, 0x39, 0x51,
        0x64, 0x0A, 0x45, 0x61, 0x7A, 0x36, 0x39, 0x5A, 0x4D, 0x33,
        0x78, 0x76, 0x71, 0x48, 0x43, 0x50, 0x63, 0x57, 0x48, 0x79,
        0x7A, 0x4F, 0x4D, 0x45, 0x43, 0x64, 0x54, 0x36, 0x59, 0x71,
        0x43, 0x71, 0x48, 0x57, 0x6C, 0x54, 0x50, 0x44, 0x70, 0x67,
        0x4F, 0x59, 0x35, 0x6F, 0x30, 0x46, 0x4E, 0x4C, 0x43, 0x58,
        0x44, 0x4E, 0x36, 0x6B, 0x78, 0x38, 0x39, 0x54, 0x6A, 0x39,
        0x45, 0x3D, 0x0A, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x45, 0x4E,
        0x44, 0x20, 0x50, 0x55, 0x42, 0x4C, 0x49, 0x43, 0x20, 0x4B,
        0x45, 0x59, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x0A
};
#define sizeof_server_sm2_key (sizeof(server_sm2_key))

/* ./certs/sm2/server-sm2-priv.pem */
static const unsigned char server_sm2_priv[] =
{
        0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x42, 0x45, 0x47, 0x49, 0x4E,
        0x20, 0x50, 0x52, 0x49, 0x56, 0x41, 0x54, 0x45, 0x20, 0x4B,
        0x45, 0x59, 0x2D, 0x2D, 0x2D, 0x2D, 0x2D, 0x0A, 0x4D, 0x49,
        0x47, 0x49, 0x41, 0x67, 0x45, 0x41, 0x4D, 0x42, 0x51, 0x47,
        0x43, 0x43, 0x71, 0x42, 0x48, 0x4D, 0x39, 0x56, 0x41, 0x59,
        0x49, 0x74, 0x42, 0x67, 0x67, 0x71, 0x67, 0x52, 0x7A, 0x50,
        0x56, 0x51, 0x47, 0x43, 0x4C, 0x51, 0x52, 0x74, 0x4D, 0x47,
        0x73, 0x43, 0x41, 0x51, 0x45, 0x45, 0x49, 0x4E, 0x63, 0x7A,
        0x77, 0x61, 0x46, 0x78, 0x6D, 0x4E, 0x70, 0x44, 0x67, 0x51,
        0x31, 0x77, 0x0A, 0x51, 0x6F, 0x68, 0x6A, 0x30, 0x45, 0x78,
        0x2B, 0x44, 0x34, 0x71, 0x62, 0x4C, 0x64, 0x6F, 0x56, 0x71,
        0x67, 0x35, 0x61, 0x2B, 0x75, 0x31, 0x33, 0x4F, 0x6B, 0x4F,
        0x6F, 0x6F, 0x55, 0x51, 0x44, 0x51, 0x67, 0x41, 0x45, 0x6C,
        0x48, 0x41, 0x72, 0x52, 0x75, 0x52, 0x65, 0x44, 0x30, 0x48,
        0x37, 0x6A, 0x79, 0x30, 0x30, 0x43, 0x6B, 0x46, 0x41, 0x47,
        0x56, 0x37, 0x37, 0x31, 0x42, 0x30, 0x52, 0x0A, 0x72, 0x50,
        0x72, 0x31, 0x6B, 0x7A, 0x66, 0x47, 0x2B, 0x6F, 0x63, 0x49,
        0x39, 0x78, 0x59, 0x66, 0x4C, 0x4D, 0x34, 0x77, 0x51, 0x4A,
        0x31, 0x50, 0x70, 0x69, 0x6F, 0x4B, 0x6F, 0x64, 0x61, 0x56,
        0x4D, 0x38, 0x4F, 0x6D, 0x41, 0x35, 0x6A, 0x6D, 0x6A, 0x51,
        0x55, 0x30, 0x73, 0x4A, 0x63, 0x4D, 0x33, 0x71, 0x54, 0x48,
        0x7A, 0x31, 0x4F, 0x50, 0x30, 0x51, 0x3D, 0x3D, 0x0A, 0x2D,
        0x2D, 0x2D, 0x2D, 0x2D, 0x45, 0x4E, 0x44, 0x20, 0x50, 0x52,
        0x49, 0x56, 0x41, 0x54, 0x45, 0x20, 0x4B, 0x45, 0x59, 0x2D,
        0x2D, 0x2D, 0x2D, 0x2D, 0x0A
};
#define sizeof_server_sm2_priv (sizeof(server_sm2_priv))

#endif /* WOLFSSL_NO_PEM */

#endif /* WOLFSSL_SM2 || WOLFSSL_SM3 || WOLFSSL_SM4 */
#endif /* WOLFSSL_CERTS_TEST_SM_H */
