/* ========================================================================= */
/**
 * @file toolkit.h
 *
 * See @ref toolkit_page for documentation.
 *
 * @copyright
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
#ifndef __WLMTK_TOOLKIT_H__
#define __WLMTK_TOOLKIT_H__

#include "gfxbuf.h"
#include "primitives.h"
#include "style.h"
#include "util.h"

#include <libbase/libbase.h>
#include <wayland-server.h>

#include "bordered.h"
#include "box.h"
#include "buffer.h"
#include "button.h"
#include "container.h"
#include "content.h"
#include "dock.h"
#include "element.h"
#include "env.h"
#include "fsm.h"
#include "image.h"
#include "input.h"
#include "lock.h"
#include "menu.h"
#include "menu_item.h"
#include "pane.h"
#include "panel.h"
#include "popup.h"
#include "rectangle.h"
#include "resizebar.h"
#include "resizebar_area.h"
#include "root.h"
#include "surface.h"
#include "tile.h"
#include "titlebar.h"
#include "titlebar_button.h"
#include "titlebar_title.h"
#include "util.h"
#include "window.h"
#include "workspace.h"

#ifdef __cplusplus
extern "C" {
#endif  // __cplusplus


#ifdef __cplusplus
}  // extern "C"
#endif  // __cplusplus

#endif /* __WLMTK_TOOLKIT_H__ */
/* == End of toolkit.h ===================================================== */
