## TFSA-2022-141: Integer overflow in math ops

### CVE Number
CVE-2022-36015

### Impact
When [`RangeSize`](https://github.com/tensorflow/tensorflow/blob/master/tensorflow/core/ops/math_ops.cc) receives values that do not fit into an `int64_t`, it crashes.
```cpp
  auto size = (std::is_integral<T>::value
                   ? ((Eigen::numext::abs(limit - start) +
                       Eigen::numext::abs(delta) - T(1)) /
                      Eigen::numext::abs(delta))
                   : (Eigen::numext::ceil(
                         Eigen::numext::abs((limit - start) / delta))));

  // This check does not cover all cases.
  if (size > std::numeric_limits<int64_t>::max()) {
    return errors::InvalidArgument("Requires ((limit - start) / delta) <= ",
                                   std::numeric_limits<int64_t>::max());
  }

  c->set_output(0, c->Vector(static_cast<int64_t>(size)));
  return OkStatus();
}
```

### Patches
We have patched the issue in GitHub commit [37e64539cd29fcfb814c4451152a60f5d107b0f0](https://github.com/tensorflow/tensorflow/commit/37e64539cd29fcfb814c4451152a60f5d107b0f0).
The fix will be included in TensorFlow 2.10.0. We will also cherrypick this commit on TensorFlow 2.9.1, TensorFlow 2.8.1, and TensorFlow 2.7.2, as these are also affected and still in supported range.


### For more information
Please consult [our security guide](https://github.com/tensorflow/tensorflow/blob/master/SECURITY.md) for more information regarding the security model and how to contact us with issues and questions.
