package vpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeletionProtection invokes the vpc.DeletionProtection API synchronously
func (client *Client) DeletionProtection(request *DeletionProtectionRequest) (response *DeletionProtectionResponse, err error) {
	response = CreateDeletionProtectionResponse()
	err = client.DoAction(request, response)
	return
}

// DeletionProtectionWithChan invokes the vpc.DeletionProtection API asynchronously
func (client *Client) DeletionProtectionWithChan(request *DeletionProtectionRequest) (<-chan *DeletionProtectionResponse, <-chan error) {
	responseChan := make(chan *DeletionProtectionResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeletionProtection(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeletionProtectionWithCallback invokes the vpc.DeletionProtection API asynchronously
func (client *Client) DeletionProtectionWithCallback(request *DeletionProtectionRequest, callback func(response *DeletionProtectionResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeletionProtectionResponse
		var err error
		defer close(result)
		response, err = client.DeletionProtection(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeletionProtectionRequest is the request struct for api DeletionProtection
type DeletionProtectionRequest struct {
	*requests.RpcRequest
	ResourceOwnerId      requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken          string           `position:"Query" name:"ClientToken"`
	ProtectionEnable     requests.Boolean `position:"Query" name:"ProtectionEnable"`
	Type                 string           `position:"Query" name:"Type"`
	ResourceOwnerAccount string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerId              requests.Integer `position:"Query" name:"OwnerId"`
	InstanceId           string           `position:"Query" name:"InstanceId"`
}

// DeletionProtectionResponse is the response struct for api DeletionProtection
type DeletionProtectionResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeletionProtectionRequest creates a request to invoke DeletionProtection API
func CreateDeletionProtectionRequest() (request *DeletionProtectionRequest) {
	request = &DeletionProtectionRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Vpc", "2016-04-28", "DeletionProtection", "vpc", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDeletionProtectionResponse creates a response to parse from DeletionProtection response
func CreateDeletionProtectionResponse() (response *DeletionProtectionResponse) {
	response = &DeletionProtectionResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
