/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.util;

import com.sourceforge.knecs.util.CMCSProperties;
import com.sourceforge.knecs.util.LoggerUtils;
import java.net.URL;
import java.util.logging.Logger;

public class UrlUtils {
    protected static Logger mLogger = LoggerUtils.getLogger();

    public static String getParentDir(String url) {
        return UrlUtils.getParentDir(url, null);
    }

    public static String getParentDir(String url, String server) {
        String parentPath;
        String fUrl = UrlUtils.formatURL(new String(url), server);
        String ret = "";
        String serv = UrlUtils.getServer(fUrl);
        String path = UrlUtils.getPath(fUrl);
        int slash = path.lastIndexOf("/");
        if (slash != -1 && path.length() > 1 && (parentPath = path.substring(0, slash)).length() > 0) {
            ret = serv + parentPath;
        }
        return ret;
    }

    public static String formatURL(String url) {
        return UrlUtils.formatURL(url, null);
    }

    public static String formatURL(String url, String urlWithServer) {
        String newurl = null;
        if (url != null) {
            newurl = UrlUtils.fixSlashes(new String(url));
            if ((newurl = newurl.trim()).endsWith("/")) {
                newurl = newurl.substring(0, newurl.length() - 1);
            }
            newurl = UrlUtils.addServer(newurl, urlWithServer);
        }
        return newurl;
    }

    public static String addServer(String url, String urlWithServer) {
        String ret = UrlUtils.fixSlashes(new String(url));
        if (!ret.startsWith("http")) {
            String server = UrlUtils.fixSlashes(urlWithServer);
            if (!ret.startsWith("/")) {
                ret = "/" + ret;
            }
            CMCSProperties props = CMCSProperties.getCMCSProperties();
            String cmcsServer = props.getProperty("samserver");
            if (server == null) {
                server = cmcsServer;
            }
            String contextPath = UrlUtils.getPath(server);
            server = UrlUtils.getServer(server);
            if (contextPath == null || contextPath.equals("")) {
                contextPath = UrlUtils.getPath(cmcsServer);
            }
            if (contextPath != null && !ret.startsWith(contextPath)) {
                if (contextPath.endsWith("/")) {
                    contextPath = contextPath.substring(0, server.length() - 1);
                }
                ret = contextPath + ret;
            }
            if (server.endsWith("/")) {
                server = server.substring(0, server.length() - 1);
            }
            ret = server + ret;
        }
        return ret;
    }

    public static String getServer(String urlstr) {
        String server = "";
        urlstr = UrlUtils.fixSlashes(urlstr);
        try {
            URL url = new URL(urlstr);
            String protocol = url.getProtocol();
            String host = url.getHost();
            int port = url.getPort();
            if (protocol != null) {
                server = protocol;
            }
            if (host != null) {
                server = server + ":" + "/" + "/" + host;
            }
            if (port != -1) {
                server = server + ":" + port;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return server;
    }

    public static String getServerTopPath(String urlstr) {
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        String webappName = UrlUtils.getPath(props.getProperty("samserver"));
        return UrlUtils.getServer(urlstr) + webappName + "/files/";
    }

    public static String getHost(String urlstr) {
        String host = "";
        urlstr = UrlUtils.fixSlashes(urlstr);
        try {
            URL url = new URL(urlstr);
            host = url.getHost();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return host;
    }

    public static String getQuery(String urlstr) {
        String query = "";
        urlstr = UrlUtils.fixSlashes(urlstr);
        try {
            URL url = new URL(urlstr);
            query = url.getQuery();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return query;
    }

    public static String getPath(String urlstr) {
        String path = "";
        urlstr = UrlUtils.fixSlashes(urlstr);
        try {
            URL url = new URL(urlstr);
            path = url.getPath();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return path;
    }

    public static String getPathRelativeToWebapp(String urlstr) {
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        String webappName = UrlUtils.getPath(props.getProperty("samserver"));
        String path = UrlUtils.getPath(urlstr);
        if (path.startsWith(webappName)) {
            path = path.substring(webappName.length());
        }
        return path;
    }

    public static String getFileName(String urlstr) {
        String url = UrlUtils.formatURL(new String(urlstr), null);
        int slash = url.lastIndexOf("/");
        String ret = slash != -1 ? url.substring(slash + 1) : url;
        return ret;
    }

    public static String fixSlashes(String url) {
        String ret = url;
        if (ret != null) {
            ret = url.replace('\\', '/');
        }
        return ret;
    }
}

