"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SimpleListItem = void 0;
const tslib_1 = require("tslib");
const jsx_runtime_1 = require("react/jsx-runtime");
const react_1 = require("react");
const react_styles_1 = require("@patternfly/react-styles");
const simple_list_1 = tslib_1.__importDefault(require("@patternfly/react-styles/css/components/SimpleList/simple-list"));
const SimpleList_1 = require("./SimpleList");
class SimpleListItem extends react_1.Component {
    constructor() {
        super(...arguments);
        this.ref = (0, react_1.createRef)();
    }
    render() {
        const _a = this.props, { children, isActive, className, component: Component, componentClassName, componentProps, onClick, type, href, 
        // eslint-disable-next-line @typescript-eslint/no-unused-vars
        itemId } = _a, props = tslib_1.__rest(_a, ["children", "isActive", "className", "component", "componentClassName", "componentProps", "onClick", "type", "href", "itemId"]);
        return ((0, jsx_runtime_1.jsx)(SimpleList_1.SimpleListContext.Consumer, { children: ({ currentRef, updateCurrentRef, isControlled }) => {
                const isButton = Component === 'button';
                const isCurrentItem = this.ref && currentRef && isControlled ? currentRef.current === this.ref.current : isActive;
                const additionalComponentProps = isButton
                    ? {
                        type
                    }
                    : {
                        tabIndex: 0,
                        href
                    };
                return ((0, jsx_runtime_1.jsx)("li", Object.assign({ className: (0, react_styles_1.css)('pf-v6-c-simple-list__item', className) }, props, { children: (0, jsx_runtime_1.jsx)(Component, Object.assign({ className: (0, react_styles_1.css)(simple_list_1.default.simpleListItemLink, isCurrentItem && simple_list_1.default.modifiers.current, !isButton && simple_list_1.default.modifiers.link, componentClassName), onClick: (evt) => {
                            onClick(evt);
                            updateCurrentRef(this.ref, this.props);
                        }, ref: this.ref }, componentProps, additionalComponentProps, { children: children })) })));
            } }));
    }
}
exports.SimpleListItem = SimpleListItem;
SimpleListItem.displayName = 'SimpleListItem';
SimpleListItem.defaultProps = {
    children: null,
    className: '',
    isActive: false,
    component: 'button',
    componentClassName: '',
    type: 'button',
    href: '',
    onClick: () => { }
};
//# sourceMappingURL=SimpleListItem.js.map