//
// Test.Mono.Messaging.RabbitMQ
//
// Authors:
//	  Michael Barker (mike@middlesoft.co.uk)
//
// (C) 2008 Michael Barker
//

//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//

using System;

using Mono.Messaging;
using Mono.Messaging.RabbitMQ;

using NUnit.Framework;

namespace MonoTests.Mono.Messaging.RabbitMQ
{
	[TestFixture]
	public class RabbitMQMessagingProviderTest {
		
		[Test]
		public void CreateMessage ()
		{
			IMessagingProvider p = new RabbitMQMessagingProvider ();
			IMessage m = p.CreateMessage ();
			Assert.IsNotNull (m);   
		}
		
		[Test]
		public void GetMessageQueue ()
		{
			IMessagingProvider p = new RabbitMQMessagingProvider ();
			IMessageQueue q = p.CreateMessageQueue (QueueReference.DEFAULT, true);
			Assert.IsNotNull (q);   
		}
		
		[Test]
		public void GetProvider ()
		{
			IMessagingProvider p = MessagingProviderLocator.GetProvider ();
			Assert.IsNotNull (p);
		}
		
	}
}
