/* This file generated from tools/Generate-Collation-Data.raku */
struct collation_key {
    MVMuint32 primary :16;
    MVMuint32 tertiary :5;
    MVMuint32 special :1;
    MVMuint32 secondary :9;
};
struct sub_node {
    MVMuint32 codepoint :18;
    MVMuint32 collation_key_link :14;
    MVMuint32 sub_node_link :13;
    MVMuint32 sub_node_elems :13;
    MVMuint32 collation_key_elems :5;
};
typedef struct sub_node sub_node;
#define main_nodes_elems 4828
#define starter_main_nodes_elems 3864
#define codepoint_sequence_no_max 3
#define special_collation_keys_elems 10704
/* Data from PropList.txt */
MVM_STATIC_INLINE MVMuint32 is_unified_ideograph (MVMCodepoint cp) {
    return
       (0x3400  <= cp && cp <= 0x4DBF ) /* 3400..4DBF Unified_Ideograph # Lo [6592] CJK UNIFIED IDEOGRAPH-3400..CJK UNIFIED IDEOGRAPH-4DBF */
    || (0x4E00  <= cp && cp <= 0x9FFF ) /* 4E00..9FFF Unified_Ideograph # Lo [20992] CJK UNIFIED IDEOGRAPH-4E00..CJK UNIFIED IDEOGRAPH-9FFF */
    || (0xFA0E  <= cp && cp <= 0xFA0F ) /* FA0E..FA0F Unified_Ideograph # Lo   [2] CJK COMPATIBILITY IDEOGRAPH-FA0E..CJK COMPATIBILITY IDEOGRAPH-FA0F */
    || (0xFA11                   == cp) /* FA11..FA11 Unified_Ideograph # Lo       CJK COMPATIBILITY IDEOGRAPH-FA11 */
    || (0xFA13  <= cp && cp <= 0xFA14 ) /* FA13..FA14 Unified_Ideograph # Lo   [2] CJK COMPATIBILITY IDEOGRAPH-FA13..CJK COMPATIBILITY IDEOGRAPH-FA14 */
    || (0xFA1F                   == cp) /* FA1F..FA1F Unified_Ideograph # Lo       CJK COMPATIBILITY IDEOGRAPH-FA1F */
    || (0xFA21                   == cp) /* FA21..FA21 Unified_Ideograph # Lo       CJK COMPATIBILITY IDEOGRAPH-FA21 */
    || (0xFA23  <= cp && cp <= 0xFA24 ) /* FA23..FA24 Unified_Ideograph # Lo   [2] CJK COMPATIBILITY IDEOGRAPH-FA23..CJK COMPATIBILITY IDEOGRAPH-FA24 */
    || (0xFA27  <= cp && cp <= 0xFA29 ) /* FA27..FA29 Unified_Ideograph # Lo   [3] CJK COMPATIBILITY IDEOGRAPH-FA27..CJK COMPATIBILITY IDEOGRAPH-FA29 */
    || (0x20000 <= cp && cp <= 0x2A6DF) /* 20000..2A6DF Unified_Ideograph # Lo [42720] CJK UNIFIED IDEOGRAPH-20000..CJK UNIFIED IDEOGRAPH-2A6DF */
    || (0x2A700 <= cp && cp <= 0x2B739) /* 2A700..2B739 Unified_Ideograph # Lo [4154] CJK UNIFIED IDEOGRAPH-2A700..CJK UNIFIED IDEOGRAPH-2B739 */
    || (0x2B740 <= cp && cp <= 0x2B81D) /* 2B740..2B81D Unified_Ideograph # Lo [222] CJK UNIFIED IDEOGRAPH-2B740..CJK UNIFIED IDEOGRAPH-2B81D */
    || (0x2B820 <= cp && cp <= 0x2CEA1) /* 2B820..2CEA1 Unified_Ideograph # Lo [5762] CJK UNIFIED IDEOGRAPH-2B820..CJK UNIFIED IDEOGRAPH-2CEA1 */
    || (0x2CEB0 <= cp && cp <= 0x2EBE0) /* 2CEB0..2EBE0 Unified_Ideograph # Lo [7473] CJK UNIFIED IDEOGRAPH-2CEB0..CJK UNIFIED IDEOGRAPH-2EBE0 */
    || (0x30000 <= cp && cp <= 0x3134A) /* 30000..3134A Unified_Ideograph # Lo [4939] CJK UNIFIED IDEOGRAPH-30000..CJK UNIFIED IDEOGRAPH-3134A */
    || (0x31350 <= cp && cp <= 0x323AF) /* 31350..323AF Unified_Ideograph # Lo [4192] CJK UNIFIED IDEOGRAPH-31350..CJK UNIFIED IDEOGRAPH-323AF */
    ;
}

/* Data from Blocks.txt */
MVM_STATIC_INLINE MVMuint32 is_Assigned_Block_Nushu (MVMCodepoint cp) {
    return
       (0x1B170 <= cp && cp <= 0x1B2FF) /* 1B170..1B2FF Nushu                              */
    ;
}

/* Data from Blocks.txt */
MVM_STATIC_INLINE MVMuint32 is_Block_Tangut (MVMCodepoint cp) {
    return
       (0x17000 <= cp && cp <= 0x187FF) /* 17000..187FF Tangut                             */
    || (0x18800 <= cp && cp <= 0x18AFF) /* 18800..18AFF Tangut Components                  */
    ;
}

/* Data from Blocks.txt */
MVM_STATIC_INLINE MVMuint32 is_Block_CJK_Unified_Ideographs_OR_CJK_Compatibility_Ideographs (MVMCodepoint cp) {
    return
       (0x4E00  <= cp && cp <= 0x9FFF ) /* 4E00..9FFF CJK Unified Ideographs             */
    || (0xF900  <= cp && cp <= 0xFAFF ) /* F900..FAFF CJK Compatibility Ideographs       */
    ;
}

sub_node main_nodes[4828] = {
{76,0,3864,1,0},{108,0,3865,1,0},{188,4,0,0,3},{189,7,0,0,3},{190,10,0,0,3},
{192,13,0,0,2},{193,15,0,0,2},{194,17,0,0,2},{195,19,0,0,2},{196,21,0,0,2},{197,
23,0,0,2},{198,25,0,0,3},{199,28,0,0,2},{200,30,0,0,2},{201,32,0,0,2},{202,34,0,
0,2},{203,36,0,0,2},{204,38,0,0,2},{205,40,0,0,2},{206,42,0,0,2},{207,44,0,0,2},
{208,46,0,0,2},{209,48,0,0,2},{210,50,0,0,2},{211,52,0,0,2},{212,54,0,0,2},{213,
56,0,0,2},{214,58,0,0,2},{216,60,0,0,2},{217,62,0,0,2},{218,64,0,0,2},{219,66,0,
0,2},{220,68,0,0,2},{221,70,0,0,2},{223,72,0,0,3},{224,75,0,0,2},{225,77,0,0,2},
{226,79,0,0,2},{227,81,0,0,2},{228,83,0,0,2},{229,85,0,0,2},{230,87,0,0,3},{231,
90,0,0,2},{232,92,0,0,2},{233,94,0,0,2},{234,96,0,0,2},{235,98,0,0,2},{236,100,
0,0,2},{237,102,0,0,2},{238,104,0,0,2},{239,106,0,0,2},{240,108,0,0,2},{241,110,
0,0,2},{242,112,0,0,2},{243,114,0,0,2},{244,116,0,0,2},{245,118,0,0,2},{246,120,
0,0,2},{248,122,0,0,2},{249,124,0,0,2},{250,126,0,0,2},{251,128,0,0,2},{252,130,
0,0,2},{253,132,0,0,2},{255,134,0,0,2},{256,136,0,0,2},{257,138,0,0,2},{258,140,
0,0,2},{259,142,0,0,2},{260,144,0,0,2},{261,146,0,0,2},{262,148,0,0,2},{263,150,
0,0,2},{264,152,0,0,2},{265,154,0,0,2},{266,156,0,0,2},{267,158,0,0,2},{268,160,
0,0,2},{269,162,0,0,2},{270,164,0,0,2},{271,166,0,0,2},{272,168,0,0,2},{273,170,
0,0,2},{274,172,0,0,2},{275,174,0,0,2},{276,176,0,0,2},{277,178,0,0,2},{278,180,
0,0,2},{279,182,0,0,2},{280,184,0,0,2},{281,186,0,0,2},{282,188,0,0,2},{283,190,
0,0,2},{284,192,0,0,2},{285,194,0,0,2},{286,196,0,0,2},{287,198,0,0,2},{288,200,
0,0,2},{289,202,0,0,2},{290,204,0,0,2},{291,206,0,0,2},{292,208,0,0,2},{293,210,
0,0,2},{294,212,0,0,2},{295,214,0,0,2},{296,216,0,0,2},{297,218,0,0,2},{298,220,
0,0,2},{299,222,0,0,2},{300,224,0,0,2},{301,226,0,0,2},{302,228,0,0,2},{303,230,
0,0,2},{304,232,0,0,2},{306,234,0,0,2},{307,236,0,0,2},{308,238,0,0,2},{309,240,
0,0,2},{310,242,0,0,2},{311,244,0,0,2},{313,246,0,0,2},{314,248,0,0,2},{315,250,
0,0,2},{316,252,0,0,2},{317,254,0,0,2},{318,256,0,0,2},{319,258,0,0,2},{320,260,
0,0,2},{321,262,0,0,2},{322,264,0,0,2},{323,266,0,0,2},{324,268,0,0,2},{325,270,
0,0,2},{326,272,0,0,2},{327,274,0,0,2},{328,276,0,0,2},{329,278,0,0,2},{332,280,
0,0,2},{333,282,0,0,2},{334,284,0,0,2},{335,286,0,0,2},{336,288,0,0,2},{337,290,
0,0,2},{338,292,0,0,3},{339,295,0,0,3},{340,298,0,0,2},{341,300,0,0,2},{342,302,
0,0,2},{343,304,0,0,2},{344,306,0,0,2},{345,308,0,0,2},{346,310,0,0,2},{347,312,
0,0,2},{348,314,0,0,2},{349,316,0,0,2},{350,318,0,0,2},{351,320,0,0,2},{352,322,
0,0,2},{353,324,0,0,2},{354,326,0,0,2},{355,328,0,0,2},{356,330,0,0,2},{357,332,
0,0,2},{360,334,0,0,2},{361,336,0,0,2},{362,338,0,0,2},{363,340,0,0,2},{364,342,
0,0,2},{365,344,0,0,2},{366,346,0,0,2},{367,348,0,0,2},{368,350,0,0,2},{369,352,
0,0,2},{370,354,0,0,2},{371,356,0,0,2},{372,358,0,0,2},{373,360,0,0,2},{374,362,
0,0,2},{375,364,0,0,2},{376,366,0,0,2},{377,368,0,0,2},{378,370,0,0,2},{379,372,
0,0,2},{380,374,0,0,2},{381,376,0,0,2},{382,378,0,0,2},{383,380,0,0,2},{397,382,
0,0,2},{416,384,0,0,2},{417,386,0,0,2},{431,388,0,0,2},{432,390,0,0,2},{446,392,
0,0,2},{452,394,0,0,3},{453,397,0,0,3},{454,400,0,0,3},{455,403,0,0,2},{456,405,
0,0,2},{457,407,0,0,2},{458,409,0,0,2},{459,411,0,0,2},{460,413,0,0,2},{461,415,
0,0,2},{462,417,0,0,2},{463,419,0,0,2},{464,421,0,0,2},{465,423,0,0,2},{466,425,
0,0,2},{467,427,0,0,2},{468,429,0,0,2},{469,431,0,0,3},{470,434,0,0,3},{471,437,
0,0,3},{472,440,0,0,3},{473,443,0,0,3},{474,446,0,0,3},{475,449,0,0,3},{476,452,
0,0,3},{478,455,0,0,3},{479,458,0,0,3},{480,461,0,0,3},{481,464,0,0,3},{482,467,
0,0,4},{483,471,0,0,4},{486,475,0,0,2},{487,477,0,0,2},{488,479,0,0,2},{489,481,
0,0,2},{490,483,0,0,2},{491,485,0,0,2},{492,487,0,0,3},{493,490,0,0,3},{494,493,
0,0,2},{495,495,0,0,2},{496,497,0,0,2},{497,499,0,0,2},{498,501,0,0,2},{499,503,
0,0,2},{500,505,0,0,2},{501,507,0,0,2},{504,509,0,0,2},{505,511,0,0,2},{506,513,
0,0,3},{507,516,0,0,3},{508,519,0,0,4},{509,523,0,0,4},{510,527,0,0,3},{511,530,
0,0,3},{512,533,0,0,2},{513,535,0,0,2},{514,537,0,0,2},{515,539,0,0,2},{516,541,
0,0,2},{517,543,0,0,2},{518,545,0,0,2},{519,547,0,0,2},{520,549,0,0,2},{521,551,
0,0,2},{522,553,0,0,2},{523,555,0,0,2},{524,557,0,0,2},{525,559,0,0,2},{526,561,
0,0,2},{527,563,0,0,2},{528,565,0,0,2},{529,567,0,0,2},{530,569,0,0,2},{531,571,
0,0,2},{532,573,0,0,2},{533,575,0,0,2},{534,577,0,0,2},{535,579,0,0,2},{536,581,
0,0,2},{537,583,0,0,2},{538,585,0,0,2},{539,587,0,0,2},{542,589,0,0,2},{543,591,
0,0,2},{550,593,0,0,2},{551,595,0,0,2},{552,597,0,0,2},{553,599,0,0,2},{554,601,
0,0,3},{555,604,0,0,3},{556,607,0,0,3},{557,610,0,0,3},{558,613,0,0,2},{559,615,
0,0,2},{560,617,0,0,3},{561,620,0,0,3},{562,623,0,0,2},{563,625,0,0,2},{568,627,
0,0,2},{569,629,0,0,2},{675,631,0,0,2},{676,633,0,0,2},{677,635,0,0,2},{678,637,
0,0,2},{679,639,0,0,2},{680,641,0,0,2},{681,643,0,0,2},{682,645,0,0,2},{683,647,
0,0,2},{776,0,3866,1,0},{901,651,0,0,2},{902,653,0,0,2},{904,655,0,0,2},{905,
657,0,0,2},{906,659,0,0,2},{908,661,0,0,2},{910,663,0,0,2},{911,665,0,0,2},{912,
667,0,0,3},{938,670,0,0,2},{939,672,0,0,2},{940,674,0,0,2},{941,676,0,0,2},{942,
678,0,0,2},{943,680,0,0,2},{944,682,0,0,3},{970,685,0,0,2},{971,687,0,0,2},{972,
689,0,0,2},{973,691,0,0,2},{974,693,0,0,2},{975,695,0,0,3},{979,698,0,0,2},{980,
700,0,0,2},{983,702,0,0,3},{1024,705,0,0,2},{1025,707,0,0,2},{1027,709,0,0,2},
{1031,711,0,0,2},{1036,713,0,0,2},{1037,715,0,0,2},{1038,717,0,0,2},{1104,719,0,
0,2},{1105,721,0,0,2},{1107,723,0,0,2},{1111,725,0,0,2},{1116,727,0,0,2},{1117,
729,0,0,2},{1118,731,0,0,2},{1142,733,0,0,2},{1143,735,0,0,2},{1168,737,0,0,2},
{1169,739,0,0,2},{1217,741,0,0,2},{1218,743,0,0,2},{1232,745,0,0,2},{1233,747,0,
0,2},{1234,749,0,0,2},{1235,751,0,0,2},{1238,753,0,0,2},{1239,755,0,0,2},{1242,
757,0,0,2},{1243,759,0,0,2},{1244,761,0,0,2},{1245,763,0,0,2},{1246,765,0,0,2},
{1247,767,0,0,2},{1250,769,0,0,2},{1251,771,0,0,2},{1252,773,0,0,2},{1253,775,0,
0,2},{1254,777,0,0,2},{1255,779,0,0,2},{1258,781,0,0,2},{1259,783,0,0,2},{1260,
785,0,0,2},{1261,787,0,0,2},{1262,789,0,0,2},{1263,791,0,0,2},{1264,793,0,0,2},
{1265,795,0,0,2},{1266,797,0,0,2},{1267,799,0,0,2},{1268,801,0,0,2},{1269,803,0,
0,2},{1272,805,0,0,2},{1273,807,0,0,2},{1415,809,0,0,2},{1488,0,3867,3,0},{1489,
0,3870,2,0},{1490,0,3872,1,0},{1491,0,3873,1,0},{1492,0,3874,1,0},{1493,0,3875,
2,0},{1494,0,3877,1,0},{1496,0,3878,1,0},{1497,0,3879,2,0},{1498,0,3881,1,0},
{1499,0,3882,2,0},{1500,0,3884,1,0},{1502,0,3885,1,0},{1504,0,3886,1,0},{1505,0,
3887,1,0},{1507,0,3888,1,0},{1508,0,3889,2,0},{1510,0,3891,1,0},{1511,0,3892,1,
0},{1512,0,3893,1,0},{1513,0,3894,3,0},{1514,0,3899,1,0},{1519,879,0,0,4},{1520,
883,0,0,2},{1521,885,0,0,2},{1522,887,3900,1,2},{1653,892,0,0,2},{1654,894,0,0,
2},{1655,896,0,0,2},{1656,898,0,0,2},{1728,900,0,0,2},{1730,902,0,0,2},{1747,
904,0,0,2},{1789,906,0,0,2},{1790,908,0,0,2},{1812,910,0,0,2},{1820,912,0,0,2},
{1831,914,0,0,2},{1837,916,0,0,2},{1838,918,0,0,2},{1839,920,0,0,2},{2024,922,0,
0,2},{2025,924,0,0,2},{2026,926,0,0,2},{2325,0,3901,1,0},{2326,0,3902,1,0},
{2327,0,3903,1,0},{2332,0,3904,1,0},{2337,0,3905,1,0},{2338,0,3906,1,0},{2345,
940,0,0,2},{2347,0,3907,1,0},{2351,0,3908,1,0},{2353,946,0,0,2},{2356,948,0,0,
2},{2465,0,3909,1,0},{2466,0,3910,1,0},{2479,0,3911,1,0},{2510,956,0,0,2},{2582,
0,3912,1,0},{2583,0,3913,1,0},{2588,0,3914,1,0},{2603,0,3915,1,0},{2610,0,3916,
1,0},{2616,0,3917,1,0},{2849,0,3918,1,0},{2850,0,3919,1,0},{3165,974,0,0,2},
{3293,976,0,0,2},{3406,978,0,0,2},{3412,980,0,0,2},{3413,982,0,0,2},{3414,984,0,
0,2},{3450,986,0,0,2},{3451,988,0,0,2},{3452,990,0,0,2},{3453,992,0,0,2},{3454,
994,0,0,2},{3455,996,0,0,2},{3648,0,3920,46,0},{3649,0,3966,46,0},{3650,0,4012,
46,0},{3651,0,4058,46,0},{3652,0,4104,46,0},{3661,0,4150,1,0},{3776,0,4151,45,
0},{3777,0,4196,45,0},{3778,0,4241,45,0},{3779,0,4286,45,0},{3780,0,4331,45,0},
{3789,0,4376,1,0},{3804,1920,0,0,2},{3805,1922,0,0,2},{3840,1924,0,0,3},{3904,0,
4377,1,0},{3906,0,4378,1,0},{3916,0,4379,1,0},{3921,0,4380,1,0},{3926,0,4381,1,
0},{3931,0,4382,1,0},{3946,1939,0,0,2},{3953,0,4383,3,0},{3984,0,4386,1,0},
{3986,0,4387,1,0},{3996,0,4388,1,0},{4001,0,4389,1,0},{4006,0,4390,1,0},{4011,0,
4391,1,0},{4018,0,4392,2,0},{4019,0,4395,2,0},{4026,1960,0,0,2},{4027,1962,0,0,
2},{4028,1964,0,0,2},{4159,1966,0,0,3},{5793,1969,0,0,2},{5796,1971,0,0,2},
{5797,1973,0,0,2},{5799,1975,0,0,2},{5801,1977,0,0,2},{5804,1979,0,0,2},{5805,
1981,0,0,2},{5806,1983,0,0,2},{5811,1985,0,0,2},{5812,1987,0,0,2},{5813,1989,0,
0,2},{5814,1991,0,0,2},{5819,1993,0,0,2},{5820,1995,0,0,2},{5821,1997,0,0,2},
{5823,1999,0,0,2},{5824,2001,0,0,2},{5826,2003,0,0,2},{5828,2005,0,0,2},{5830,
2007,0,0,2},{5835,2009,0,0,2},{5836,2011,0,0,2},{5837,2013,0,0,2},{5838,2015,0,
0,2},{5840,2017,0,0,2},{5841,2019,0,0,2},{5843,2021,0,0,2},{5844,2023,0,0,2},
{5845,2025,0,0,2},{5848,2027,0,0,2},{5849,2029,0,0,2},{5851,2031,0,0,2},{5853,
2033,0,0,2},{5863,2035,0,0,2},{5864,2037,0,0,2},{5865,2039,0,0,2},{5866,2041,0,
0,2},{5870,2043,0,0,2},{5871,2045,0,0,4},{5872,2049,0,0,2},{6429,2051,0,0,2},
{6430,2053,0,0,2},{6581,0,4398,44,0},{6582,0,4442,44,0},{6583,0,4486,44,0},
{6586,0,4530,44,0},{6622,2407,0,0,2},{6623,2409,0,0,3},{6740,2412,0,0,3},{6860,
2415,0,0,2},{6861,2417,0,0,2},{6862,2419,0,0,2},{6988,2421,0,0,3},{7469,2424,0,
0,3},{7545,2427,0,0,2},{7546,2429,0,0,3},{7582,2432,0,0,2},{7635,2434,0,0,2},
{7636,2436,0,0,3},{7637,2439,0,0,2},{7638,2441,0,0,2},{7639,2443,0,0,2},{7640,
2445,0,0,2},{7641,2447,0,0,2},{7651,2449,0,0,2},{7653,2451,0,0,2},{7661,2453,0,
0,2},{7664,2455,0,0,2},{7666,2457,0,0,2},{7667,2459,0,0,2},{7668,2461,0,0,2},
{7680,2463,0,0,2},{7681,2465,0,0,2},{7682,2467,0,0,2},{7683,2469,0,0,2},{7684,
2471,0,0,2},{7685,2473,0,0,2},{7686,2475,0,0,2},{7687,2477,0,0,2},{7688,2479,0,
0,3},{7689,2482,0,0,3},{7690,2485,0,0,2},{7691,2487,0,0,2},{7692,2489,0,0,2},
{7693,2491,0,0,2},{7694,2493,0,0,2},{7695,2495,0,0,2},{7696,2497,0,0,2},{7697,
2499,0,0,2},{7698,2501,0,0,2},{7699,2503,0,0,2},{7700,2505,0,0,3},{7701,2508,0,
0,3},{7702,2511,0,0,3},{7703,2514,0,0,3},{7704,2517,0,0,2},{7705,2519,0,0,2},
{7706,2521,0,0,2},{7707,2523,0,0,2},{7708,2525,0,0,3},{7709,2528,0,0,3},{7710,
2531,0,0,2},{7711,2533,0,0,2},{7712,2535,0,0,2},{7713,2537,0,0,2},{7714,2539,0,
0,2},{7715,2541,0,0,2},{7716,2543,0,0,2},{7717,2545,0,0,2},{7718,2547,0,0,2},
{7719,2549,0,0,2},{7720,2551,0,0,2},{7721,2553,0,0,2},{7722,2555,0,0,2},{7723,
2557,0,0,2},{7724,2559,0,0,2},{7725,2561,0,0,2},{7726,2563,0,0,3},{7727,2566,0,
0,3},{7728,2569,0,0,2},{7729,2571,0,0,2},{7730,2573,0,0,2},{7731,2575,0,0,2},
{7732,2577,0,0,2},{7733,2579,0,0,2},{7734,2581,0,0,2},{7735,2583,0,0,2},{7736,
2585,0,0,3},{7737,2588,0,0,3},{7738,2591,0,0,2},{7739,2593,0,0,2},{7740,2595,0,
0,2},{7741,2597,0,0,2},{7742,2599,0,0,2},{7743,2601,0,0,2},{7744,2603,0,0,2},
{7745,2605,0,0,2},{7746,2607,0,0,2},{7747,2609,0,0,2},{7748,2611,0,0,2},{7749,
2613,0,0,2},{7750,2615,0,0,2},{7751,2617,0,0,2},{7752,2619,0,0,2},{7753,2621,0,
0,2},{7754,2623,0,0,2},{7755,2625,0,0,2},{7756,2627,0,0,3},{7757,2630,0,0,3},
{7758,2633,0,0,3},{7759,2636,0,0,3},{7760,2639,0,0,3},{7761,2642,0,0,3},{7762,
2645,0,0,3},{7763,2648,0,0,3},{7764,2651,0,0,2},{7765,2653,0,0,2},{7766,2655,0,
0,2},{7767,2657,0,0,2},{7768,2659,0,0,2},{7769,2661,0,0,2},{7770,2663,0,0,2},
{7771,2665,0,0,2},{7772,2667,0,0,3},{7773,2670,0,0,3},{7774,2673,0,0,2},{7775,
2675,0,0,2},{7776,2677,0,0,2},{7777,2679,0,0,2},{7778,2681,0,0,2},{7779,2683,0,
0,2},{7780,2685,0,0,3},{7781,2688,0,0,3},{7782,2691,0,0,3},{7783,2694,0,0,3},
{7784,2697,0,0,3},{7785,2700,0,0,3},{7786,2703,0,0,2},{7787,2705,0,0,2},{7788,
2707,0,0,2},{7789,2709,0,0,2},{7790,2711,0,0,2},{7791,2713,0,0,2},{7792,2715,0,
0,2},{7793,2717,0,0,2},{7794,2719,0,0,2},{7795,2721,0,0,2},{7796,2723,0,0,2},
{7797,2725,0,0,2},{7798,2727,0,0,2},{7799,2729,0,0,2},{7800,2731,0,0,3},{7801,
2734,0,0,3},{7802,2737,0,0,3},{7803,2740,0,0,3},{7804,2743,0,0,2},{7805,2745,0,
0,2},{7806,2747,0,0,2},{7807,2749,0,0,2},{7808,2751,0,0,2},{7809,2753,0,0,2},
{7810,2755,0,0,2},{7811,2757,0,0,2},{7812,2759,0,0,2},{7813,2761,0,0,2},{7814,
2763,0,0,2},{7815,2765,0,0,2},{7816,2767,0,0,2},{7817,2769,0,0,2},{7818,2771,0,
0,2},{7819,2773,0,0,2},{7820,2775,0,0,2},{7821,2777,0,0,2},{7822,2779,0,0,2},
{7823,2781,0,0,2},{7824,2783,0,0,2},{7825,2785,0,0,2},{7826,2787,0,0,2},{7827,
2789,0,0,2},{7828,2791,0,0,2},{7829,2793,0,0,2},{7830,2795,0,0,2},{7831,2797,0,
0,2},{7832,2799,0,0,2},{7833,2801,0,0,2},{7834,2803,0,0,2},{7835,2805,0,0,3},
{7838,2808,0,0,3},{7840,2811,0,0,2},{7841,2813,0,0,2},{7842,2815,0,0,2},{7843,
2817,0,0,2},{7844,2819,0,0,3},{7845,2822,0,0,3},{7846,2825,0,0,3},{7847,2828,0,
0,3},{7848,2831,0,0,3},{7849,2834,0,0,3},{7850,2837,0,0,3},{7851,2840,0,0,3},
{7852,2843,0,0,3},{7853,2846,0,0,3},{7854,2849,0,0,3},{7855,2852,0,0,3},{7856,
2855,0,0,3},{7857,2858,0,0,3},{7858,2861,0,0,3},{7859,2864,0,0,3},{7860,2867,0,
0,3},{7861,2870,0,0,3},{7862,2873,0,0,3},{7863,2876,0,0,3},{7864,2879,0,0,2},
{7865,2881,0,0,2},{7866,2883,0,0,2},{7867,2885,0,0,2},{7868,2887,0,0,2},{7869,
2889,0,0,2},{7870,2891,0,0,3},{7871,2894,0,0,3},{7872,2897,0,0,3},{7873,2900,0,
0,3},{7874,2903,0,0,3},{7875,2906,0,0,3},{7876,2909,0,0,3},{7877,2912,0,0,3},
{7878,2915,0,0,3},{7879,2918,0,0,3},{7880,2921,0,0,2},{7881,2923,0,0,2},{7882,
2925,0,0,2},{7883,2927,0,0,2},{7884,2929,0,0,2},{7885,2931,0,0,2},{7886,2933,0,
0,2},{7887,2935,0,0,2},{7888,2937,0,0,3},{7889,2940,0,0,3},{7890,2943,0,0,3},
{7891,2946,0,0,3},{7892,2949,0,0,3},{7893,2952,0,0,3},{7894,2955,0,0,3},{7895,
2958,0,0,3},{7896,2961,0,0,3},{7897,2964,0,0,3},{7898,2967,0,0,3},{7899,2970,0,
0,3},{7900,2973,0,0,3},{7901,2976,0,0,3},{7902,2979,0,0,3},{7903,2982,0,0,3},
{7904,2985,0,0,3},{7905,2988,0,0,3},{7906,2991,0,0,3},{7907,2994,0,0,3},{7908,
2997,0,0,2},{7909,2999,0,0,2},{7910,3001,0,0,2},{7911,3003,0,0,2},{7912,3005,0,
0,3},{7913,3008,0,0,3},{7914,3011,0,0,3},{7915,3014,0,0,3},{7916,3017,0,0,3},
{7917,3020,0,0,3},{7918,3023,0,0,3},{7919,3026,0,0,3},{7920,3029,0,0,3},{7921,
3032,0,0,3},{7922,3035,0,0,2},{7923,3037,0,0,2},{7924,3039,0,0,2},{7925,3041,0,
0,2},{7926,3043,0,0,2},{7927,3045,0,0,2},{7928,3047,0,0,2},{7929,3049,0,0,2},
{7930,3051,0,0,2},{7931,3053,0,0,2},{7936,3055,0,0,2},{7937,3057,0,0,2},{7938,
3059,0,0,3},{7939,3062,0,0,3},{7940,3065,0,0,3},{7941,3068,0,0,3},{7942,3071,0,
0,3},{7943,3074,0,0,3},{7944,3077,0,0,2},{7945,3079,0,0,2},{7946,3081,0,0,3},
{7947,3084,0,0,3},{7948,3087,0,0,3},{7949,3090,0,0,3},{7950,3093,0,0,3},{7951,
3096,0,0,3},{7952,3099,0,0,2},{7953,3101,0,0,2},{7954,3103,0,0,3},{7955,3106,0,
0,3},{7956,3109,0,0,3},{7957,3112,0,0,3},{7960,3115,0,0,2},{7961,3117,0,0,2},
{7962,3119,0,0,3},{7963,3122,0,0,3},{7964,3125,0,0,3},{7965,3128,0,0,3},{7968,
3131,0,0,2},{7969,3133,0,0,2},{7970,3135,0,0,3},{7971,3138,0,0,3},{7972,3141,0,
0,3},{7973,3144,0,0,3},{7974,3147,0,0,3},{7975,3150,0,0,3},{7976,3153,0,0,2},
{7977,3155,0,0,2},{7978,3157,0,0,3},{7979,3160,0,0,3},{7980,3163,0,0,3},{7981,
3166,0,0,3},{7982,3169,0,0,3},{7983,3172,0,0,3},{7984,3175,0,0,2},{7985,3177,0,
0,2},{7986,3179,0,0,3},{7987,3182,0,0,3},{7988,3185,0,0,3},{7989,3188,0,0,3},
{7990,3191,0,0,3},{7991,3194,0,0,3},{7992,3197,0,0,2},{7993,3199,0,0,2},{7994,
3201,0,0,3},{7995,3204,0,0,3},{7996,3207,0,0,3},{7997,3210,0,0,3},{7998,3213,0,
0,3},{7999,3216,0,0,3},{8000,3219,0,0,2},{8001,3221,0,0,2},{8002,3223,0,0,3},
{8003,3226,0,0,3},{8004,3229,0,0,3},{8005,3232,0,0,3},{8008,3235,0,0,2},{8009,
3237,0,0,2},{8010,3239,0,0,3},{8011,3242,0,0,3},{8012,3245,0,0,3},{8013,3248,0,
0,3},{8016,3251,0,0,2},{8017,3253,0,0,2},{8018,3255,0,0,3},{8019,3258,0,0,3},
{8020,3261,0,0,3},{8021,3264,0,0,3},{8022,3267,0,0,3},{8023,3270,0,0,3},{8025,
3273,0,0,2},{8027,3275,0,0,3},{8029,3278,0,0,3},{8031,3281,0,0,3},{8032,3284,0,
0,2},{8033,3286,0,0,2},{8034,3288,0,0,3},{8035,3291,0,0,3},{8036,3294,0,0,3},
{8037,3297,0,0,3},{8038,3300,0,0,3},{8039,3303,0,0,3},{8040,3306,0,0,2},{8041,
3308,0,0,2},{8042,3310,0,0,3},{8043,3313,0,0,3},{8044,3316,0,0,3},{8045,3319,0,
0,3},{8046,3322,0,0,3},{8047,3325,0,0,3},{8048,3328,0,0,2},{8050,3330,0,0,2},
{8052,3332,0,0,2},{8054,3334,0,0,2},{8056,3336,0,0,2},{8058,3338,0,0,2},{8060,
3340,0,0,2},{8064,3342,0,0,3},{8065,3345,0,0,3},{8066,3348,0,0,4},{8067,3352,0,
0,4},{8068,3356,0,0,4},{8069,3360,0,0,4},{8070,3364,0,0,4},{8071,3368,0,0,4},
{8072,3372,0,0,3},{8073,3375,0,0,3},{8074,3378,0,0,4},{8075,3382,0,0,4},{8076,
3386,0,0,4},{8077,3390,0,0,4},{8078,3394,0,0,4},{8079,3398,0,0,4},{8080,3402,0,
0,3},{8081,3405,0,0,3},{8082,3408,0,0,4},{8083,3412,0,0,4},{8084,3416,0,0,4},
{8085,3420,0,0,4},{8086,3424,0,0,4},{8087,3428,0,0,4},{8088,3432,0,0,3},{8089,
3435,0,0,3},{8090,3438,0,0,4},{8091,3442,0,0,4},{8092,3446,0,0,4},{8093,3450,0,
0,4},{8094,3454,0,0,4},{8095,3458,0,0,4},{8096,3462,0,0,3},{8097,3465,0,0,3},
{8098,3468,0,0,4},{8099,3472,0,0,4},{8100,3476,0,0,4},{8101,3480,0,0,4},{8102,
3484,0,0,4},{8103,3488,0,0,4},{8104,3492,0,0,3},{8105,3495,0,0,3},{8106,3498,0,
0,4},{8107,3502,0,0,4},{8108,3506,0,0,4},{8109,3510,0,0,4},{8110,3514,0,0,4},
{8111,3518,0,0,4},{8112,3522,0,0,2},{8113,3524,0,0,2},{8114,3526,0,0,3},{8115,
3529,0,0,2},{8116,3531,0,0,3},{8118,3534,0,0,2},{8119,3536,0,0,3},{8120,3539,0,
0,2},{8121,3541,0,0,2},{8122,3543,0,0,2},{8124,3545,0,0,2},{8129,3547,0,0,2},
{8130,3549,0,0,3},{8131,3552,0,0,2},{8132,3554,0,0,3},{8134,3557,0,0,2},{8135,
3559,0,0,3},{8136,3562,0,0,2},{8138,3564,0,0,2},{8140,3566,0,0,2},{8141,3568,0,
0,2},{8142,3570,0,0,2},{8143,3572,0,0,2},{8144,3574,0,0,2},{8145,3576,0,0,2},
{8146,3578,0,0,3},{8150,3581,0,0,2},{8151,3583,0,0,3},{8152,3586,0,0,2},{8153,
3588,0,0,2},{8154,3590,0,0,2},{8157,3592,0,0,2},{8158,3594,0,0,2},{8159,3596,0,
0,2},{8160,3598,0,0,2},{8161,3600,0,0,2},{8162,3602,0,0,3},{8164,3605,0,0,2},
{8165,3607,0,0,2},{8166,3609,0,0,2},{8167,3611,0,0,3},{8168,3614,0,0,2},{8169,
3616,0,0,2},{8170,3618,0,0,2},{8172,3620,0,0,2},{8173,3622,0,0,2},{8178,3624,0,
0,3},{8179,3627,0,0,2},{8180,3629,0,0,3},{8182,3632,0,0,2},{8183,3634,0,0,3},
{8184,3637,0,0,2},{8186,3639,0,0,2},{8188,3641,0,0,2},{8229,3643,0,0,2},{8230,
3645,0,0,3},{8243,3648,0,0,2},{8244,3650,0,0,3},{8246,3653,0,0,2},{8247,3655,0,
0,3},{8252,3658,0,0,2},{8263,3660,0,0,2},{8264,3662,0,0,2},{8265,3664,0,0,2},
{8279,3666,0,0,4},{8360,3670,0,0,2},{8448,3672,0,0,3},{8449,3675,0,0,3},{8451,
3678,0,0,2},{8453,3680,0,0,3},{8454,3683,0,0,3},{8457,3686,0,0,2},{8463,3688,0,
0,2},{8470,3690,0,0,2},{8480,3692,0,0,2},{8481,3694,0,0,3},{8482,3697,0,0,2},
{8507,3699,0,0,3},{8525,3702,0,0,3},{8528,3705,0,0,3},{8529,3708,0,0,3},{8530,
3711,0,0,4},{8531,3715,0,0,3},{8532,3718,0,0,3},{8533,3721,0,0,3},{8534,3724,0,
0,3},{8535,3727,0,0,3},{8536,3730,0,0,3},{8537,3733,0,0,3},{8538,3736,0,0,3},
{8539,3739,0,0,3},{8540,3742,0,0,3},{8541,3745,0,0,3},{8542,3748,0,0,3},{8543,
3751,0,0,2},{8545,3753,0,0,2},{8546,3755,0,0,3},{8547,3758,0,0,2},{8549,3760,0,
0,2},{8550,3762,0,0,3},{8551,3765,0,0,4},{8552,3769,0,0,2},{8554,3771,0,0,2},
{8555,3773,0,0,3},{8561,3776,0,0,2},{8562,3778,0,0,3},{8563,3781,0,0,2},{8565,
3783,0,0,2},{8566,3785,0,0,3},{8567,3788,0,0,4},{8568,3792,0,0,2},{8570,3794,0,
0,2},{8571,3796,0,0,3},{8585,3799,0,0,3},{8602,3802,0,0,2},{8603,3804,0,0,2},
{8622,3806,0,0,2},{8653,3808,0,0,2},{8654,3810,0,0,2},{8655,3812,0,0,2},{8708,
3814,0,0,2},{8713,3816,0,0,2},{8716,3818,0,0,2},{8740,3820,0,0,2},{8742,3822,0,
0,2},{8748,3824,0,0,2},{8749,3826,0,0,3},{8751,3829,0,0,2},{8752,3831,0,0,3},
{8769,3834,0,0,2},{8772,3836,0,0,2},{8775,3838,0,0,2},{8777,3840,0,0,2},{8800,
3842,0,0,2},{8802,3844,0,0,2},{8813,3846,0,0,2},{8814,3848,0,0,2},{8815,3850,0,
0,2},{8816,3852,0,0,2},{8817,3854,0,0,2},{8820,3856,0,0,2},{8821,3858,0,0,2},
{8824,3860,0,0,2},{8825,3862,0,0,2},{8832,3864,0,0,2},{8833,3866,0,0,2},{8836,
3868,0,0,2},{8837,3870,0,0,2},{8840,3872,0,0,2},{8841,3874,0,0,2},{8876,3876,0,
0,2},{8877,3878,0,0,2},{8878,3880,0,0,2},{8879,3882,0,0,2},{8928,3884,0,0,2},
{8929,3886,0,0,2},{8930,3888,0,0,2},{8931,3890,0,0,2},{8938,3892,0,0,2},{8939,
3894,0,0,2},{8940,3896,0,0,2},{8941,3898,0,0,2},{9321,3900,0,0,2},{9322,3902,0,
0,2},{9323,3904,0,0,2},{9324,3906,0,0,2},{9325,3908,0,0,2},{9326,3910,0,0,2},
{9327,3912,0,0,2},{9328,3914,0,0,2},{9329,3916,0,0,2},{9330,3918,0,0,2},{9331,
3920,0,0,2},{9332,3922,0,0,3},{9333,3925,0,0,3},{9334,3928,0,0,3},{9335,3931,0,
0,3},{9336,3934,0,0,3},{9337,3937,0,0,3},{9338,3940,0,0,3},{9339,3943,0,0,3},
{9340,3946,0,0,3},{9341,3949,0,0,4},{9342,3953,0,0,4},{9343,3957,0,0,4},{9344,
3961,0,0,4},{9345,3965,0,0,4},{9346,3969,0,0,4},{9347,3973,0,0,4},{9348,3977,0,
0,4},{9349,3981,0,0,4},{9350,3985,0,0,4},{9351,3989,0,0,4},{9352,3993,0,0,2},
{9353,3995,0,0,2},{9354,3997,0,0,2},{9355,3999,0,0,2},{9356,4001,0,0,2},{9357,
4003,0,0,2},{9358,4005,0,0,2},{9359,4007,0,0,2},{9360,4009,0,0,2},{9361,4011,0,
0,3},{9362,4014,0,0,3},{9363,4017,0,0,3},{9364,4020,0,0,3},{9365,4023,0,0,3},
{9366,4026,0,0,3},{9367,4029,0,0,3},{9368,4032,0,0,3},{9369,4035,0,0,3},{9370,
4038,0,0,3},{9371,4041,0,0,3},{9372,4044,0,0,3},{9373,4047,0,0,3},{9374,4050,0,
0,3},{9375,4053,0,0,3},{9376,4056,0,0,3},{9377,4059,0,0,3},{9378,4062,0,0,3},
{9379,4065,0,0,3},{9380,4068,0,0,3},{9381,4071,0,0,3},{9382,4074,0,0,3},{9383,
4077,0,0,3},{9384,4080,0,0,3},{9385,4083,0,0,3},{9386,4086,0,0,3},{9387,4089,0,
0,3},{9388,4092,0,0,3},{9389,4095,0,0,3},{9390,4098,0,0,3},{9391,4101,0,0,3},
{9392,4104,0,0,3},{9393,4107,0,0,3},{9394,4110,0,0,3},{9395,4113,0,0,3},{9396,
4116,0,0,3},{9397,4119,0,0,3},{9451,4122,0,0,2},{9452,4124,0,0,2},{9453,4126,0,
0,2},{9454,4128,0,0,2},{9455,4130,0,0,2},{9456,4132,0,0,2},{9457,4134,0,0,2},
{9458,4136,0,0,2},{9459,4138,0,0,2},{9460,4140,0,0,2},{9470,4142,0,0,2},{10111,
4144,0,0,2},{10121,4146,0,0,2},{10131,4148,0,0,2},{10764,4150,0,0,4},{10868,
4154,0,0,3},{10869,4157,0,0,2},{10870,4159,0,0,3},{10973,0,4574,1,0},{11492,
4164,0,0,3},{11765,4167,0,0,2},{11904,4169,0,0,3},{11905,4172,0,0,3},{11906,
4175,0,0,2},{11907,4177,0,0,2},{11908,4179,0,0,3},{11909,4182,0,0,2},{11910,
4184,0,0,3},{11911,4187,0,0,3},{11912,4190,0,0,3},{11913,4193,0,0,2},{11914,
4195,0,0,3},{11915,4198,0,0,3},{11916,4201,0,0,3},{11917,4204,0,0,3},{11918,
4207,0,0,3},{11919,4210,0,0,2},{11920,4212,0,0,2},{11921,4214,0,0,3},{11922,
4217,0,0,2},{11923,4219,0,0,2},{11924,4221,0,0,2},{11925,4223,0,0,3},{11926,
4226,0,0,2},{11927,4228,0,0,3},{11928,4231,0,0,2},{11929,4233,0,0,2},{11931,
4235,0,0,2},{11932,4237,0,0,3},{11933,4240,0,0,3},{11934,4243,0,0,3},{11935,
4246,0,0,2},{11936,4248,0,0,2},{11937,4250,0,0,2},{11938,4252,0,0,2},{11939,
4254,0,0,2},{11940,4256,0,0,2},{11941,4258,0,0,3},{11942,4261,0,0,2},{11943,
4263,0,0,3},{11944,4266,0,0,2},{11945,4268,0,0,3},{11946,4271,0,0,3},{11947,
4274,0,0,3},{11948,4277,0,0,3},{11949,4280,0,0,2},{11950,4282,0,0,3},{11951,
4285,0,0,2},{11952,4287,0,0,2},{11953,4289,0,0,2},{11954,4291,0,0,2},{11955,
4293,0,0,3},{11956,4296,0,0,3},{11957,4299,0,0,3},{11958,4302,0,0,3},{11959,
4305,0,0,3},{11960,4308,0,0,2},{11961,4310,0,0,2},{11962,4312,0,0,2},{11963,
4314,0,0,3},{11964,4317,0,0,3},{11965,4320,0,0,3},{11966,4323,0,0,2},{11967,
4325,0,0,3},{11968,4328,0,0,3},{11969,4331,0,0,2},{11970,4333,0,0,2},{11971,
4335,0,0,2},{11972,4337,0,0,2},{11973,4339,0,0,2},{11974,4341,0,0,2},{11975,
4343,0,0,3},{11976,4346,0,0,2},{11977,4348,0,0,2},{11978,4350,0,0,3},{11979,
4353,0,0,2},{11980,4355,0,0,2},{11981,4357,0,0,3},{11982,4360,0,0,3},{11983,
4363,0,0,3},{11984,4366,0,0,2},{11985,4368,0,0,2},{11986,4370,0,0,2},{11987,
4372,0,0,2},{11988,4374,0,0,2},{11989,4376,0,0,3},{11990,4379,0,0,2},{11991,
4381,0,0,3},{11992,4384,0,0,2},{11993,4386,0,0,2},{11994,4388,0,0,2},{11995,
4390,0,0,2},{11996,4392,0,0,2},{11997,4394,0,0,2},{11998,4396,0,0,3},{11999,
4399,0,0,2},{12000,4401,0,0,2},{12001,4403,0,0,3},{12002,4406,0,0,2},{12003,
4408,0,0,3},{12004,4411,0,0,3},{12005,4414,0,0,2},{12006,4416,0,0,2},{12007,
4418,0,0,3},{12008,4421,0,0,2},{12009,4423,0,0,2},{12010,4425,0,0,2},{12011,
4427,0,0,3},{12012,4430,0,0,2},{12013,4432,0,0,3},{12014,4435,0,0,2},{12015,
4437,0,0,3},{12016,4440,0,0,2},{12017,4442,0,0,3},{12018,4445,0,0,3},{12019,
4448,0,0,2},{12032,4450,0,0,2},{12033,4452,0,0,2},{12034,4454,0,0,2},{12035,
4456,0,0,2},{12036,4458,0,0,2},{12037,4460,0,0,2},{12038,4462,0,0,2},{12039,
4464,0,0,2},{12040,4466,0,0,2},{12041,4468,0,0,2},{12042,4470,0,0,2},{12043,
4472,0,0,2},{12044,4474,0,0,2},{12045,4476,0,0,2},{12046,4478,0,0,2},{12047,
4480,0,0,2},{12048,4482,0,0,2},{12049,4484,0,0,2},{12050,4486,0,0,2},{12051,
4488,0,0,2},{12052,4490,0,0,2},{12053,4492,0,0,2},{12054,4494,0,0,2},{12055,
4496,0,0,2},{12056,4498,0,0,2},{12057,4500,0,0,2},{12058,4502,0,0,2},{12059,
4504,0,0,2},{12060,4506,0,0,2},{12061,4508,0,0,2},{12062,4510,0,0,2},{12063,
4512,0,0,2},{12064,4514,0,0,2},{12065,4516,0,0,2},{12066,4518,0,0,2},{12067,
4520,0,0,2},{12068,4522,0,0,2},{12069,4524,0,0,2},{12070,4526,0,0,2},{12071,
4528,0,0,2},{12072,4530,0,0,2},{12073,4532,0,0,2},{12074,4534,0,0,2},{12075,
4536,0,0,2},{12076,4538,0,0,2},{12077,4540,0,0,2},{12078,4542,0,0,2},{12079,
4544,0,0,2},{12080,4546,0,0,2},{12081,4548,0,0,2},{12082,4550,0,0,2},{12083,
4552,0,0,2},{12084,4554,0,0,2},{12085,4556,0,0,2},{12086,4558,0,0,2},{12087,
4560,0,0,2},{12088,4562,0,0,2},{12089,4564,0,0,2},{12090,4566,0,0,2},{12091,
4568,0,0,2},{12092,4570,0,0,2},{12093,4572,0,0,2},{12094,4574,0,0,2},{12095,
4576,0,0,2},{12096,4578,0,0,2},{12097,4580,0,0,2},{12098,4582,0,0,2},{12099,
4584,0,0,2},{12100,4586,0,0,2},{12101,4588,0,0,2},{12102,4590,0,0,2},{12103,
4592,0,0,2},{12104,4594,0,0,2},{12105,4596,0,0,2},{12106,4598,0,0,2},{12107,
4600,0,0,2},{12108,4602,0,0,2},{12109,4604,0,0,2},{12110,4606,0,0,2},{12111,
4608,0,0,2},{12112,4610,0,0,2},{12113,4612,0,0,2},{12114,4614,0,0,2},{12115,
4616,0,0,2},{12116,4618,0,0,2},{12117,4620,0,0,2},{12118,4622,0,0,2},{12119,
4624,0,0,2},{12120,4626,0,0,2},{12121,4628,0,0,2},{12122,4630,0,0,2},{12123,
4632,0,0,2},{12124,4634,0,0,2},{12125,4636,0,0,2},{12126,4638,0,0,2},{12127,
4640,0,0,2},{12128,4642,0,0,2},{12129,4644,0,0,2},{12130,4646,0,0,2},{12131,
4648,0,0,2},{12132,4650,0,0,2},{12133,4652,0,0,2},{12134,4654,0,0,2},{12135,
4656,0,0,2},{12136,4658,0,0,2},{12137,4660,0,0,2},{12138,4662,0,0,2},{12139,
4664,0,0,2},{12140,4666,0,0,2},{12141,4668,0,0,2},{12142,4670,0,0,2},{12143,
4672,0,0,2},{12144,4674,0,0,2},{12145,4676,0,0,2},{12146,4678,0,0,2},{12147,
4680,0,0,2},{12148,4682,0,0,2},{12149,4684,0,0,2},{12150,4686,0,0,2},{12151,
4688,0,0,2},{12152,4690,0,0,2},{12153,4692,0,0,2},{12154,4694,0,0,2},{12155,
4696,0,0,2},{12156,4698,0,0,2},{12157,4700,0,0,2},{12158,4702,0,0,2},{12159,
4704,0,0,2},{12160,4706,0,0,2},{12161,4708,0,0,2},{12162,4710,0,0,2},{12163,
4712,0,0,2},{12164,4714,0,0,2},{12165,4716,0,0,2},{12166,4718,0,0,2},{12167,
4720,0,0,2},{12168,4722,0,0,2},{12169,4724,0,0,2},{12170,4726,0,0,2},{12171,
4728,0,0,2},{12172,4730,0,0,2},{12173,4732,0,0,2},{12174,4734,0,0,2},{12175,
4736,0,0,2},{12176,4738,0,0,2},{12177,4740,0,0,2},{12178,4742,0,0,2},{12179,
4744,0,0,2},{12180,4746,0,0,2},{12181,4748,0,0,2},{12182,4750,0,0,2},{12183,
4752,0,0,2},{12184,4754,0,0,2},{12185,4756,0,0,2},{12186,4758,0,0,2},{12187,
4760,0,0,2},{12188,4762,0,0,2},{12189,4764,0,0,2},{12190,4766,0,0,2},{12191,
4768,0,0,2},{12192,4770,0,0,2},{12193,4772,0,0,2},{12194,4774,0,0,2},{12195,
4776,0,0,2},{12196,4778,0,0,2},{12197,4780,0,0,2},{12198,4782,0,0,2},{12199,
4784,0,0,2},{12200,4786,0,0,2},{12201,4788,0,0,2},{12202,4790,0,0,2},{12203,
4792,0,0,2},{12204,4794,0,0,2},{12205,4796,0,0,2},{12206,4798,0,0,2},{12207,
4800,0,0,2},{12208,4802,0,0,2},{12209,4804,0,0,2},{12210,4806,0,0,2},{12211,
4808,0,0,2},{12212,4810,0,0,2},{12213,4812,0,0,2},{12214,4814,0,0,2},{12215,
4816,0,0,2},{12216,4818,0,0,2},{12217,4820,0,0,2},{12218,4822,0,0,2},{12219,
4824,0,0,2},{12220,4826,0,0,2},{12221,4828,0,0,2},{12222,4830,0,0,2},{12223,
4832,0,0,2},{12224,4834,0,0,2},{12225,4836,0,0,2},{12226,4838,0,0,2},{12227,
4840,0,0,2},{12228,4842,0,0,2},{12229,4844,0,0,2},{12230,4846,0,0,2},{12231,
4848,0,0,2},{12232,4850,0,0,2},{12233,4852,0,0,2},{12234,4854,0,0,2},{12235,
4856,0,0,2},{12236,4858,0,0,2},{12237,4860,0,0,2},{12238,4862,0,0,2},{12239,
4864,0,0,2},{12240,4866,0,0,2},{12241,4868,0,0,2},{12242,4870,0,0,2},{12243,
4872,0,0,2},{12244,4874,0,0,2},{12245,4876,0,0,2},{12294,4878,0,0,2},{12338,
4880,0,0,2},{12340,4882,0,0,2},{12344,4884,0,0,2},{12345,4886,0,0,2},{12346,
4888,0,0,2},{12348,4890,0,0,2},{12364,4892,0,0,2},{12366,4894,0,0,2},{12368,
4896,0,0,2},{12370,4898,0,0,2},{12372,4900,0,0,2},{12374,4902,0,0,2},{12376,
4904,0,0,2},{12378,4906,0,0,2},{12380,4908,0,0,2},{12382,4910,0,0,2},{12384,
4912,0,0,2},{12386,4914,0,0,2},{12389,4916,0,0,2},{12391,4918,0,0,2},{12393,
4920,0,0,2},{12400,4922,0,0,2},{12401,4924,0,0,2},{12403,4926,0,0,2},{12404,
4928,0,0,2},{12406,4930,0,0,2},{12407,4932,0,0,2},{12409,4934,0,0,2},{12410,
4936,0,0,2},{12412,4938,0,0,2},{12413,4940,0,0,2},{12436,4942,0,0,2},{12446,
4944,0,0,2},{12447,4946,0,0,2},{12460,4948,0,0,2},{12462,4950,0,0,2},{12464,
4952,0,0,2},{12466,4954,0,0,2},{12468,4956,0,0,2},{12470,4958,0,0,2},{12472,
4960,0,0,2},{12474,4962,0,0,2},{12476,4964,0,0,2},{12478,4966,0,0,2},{12480,
4968,0,0,2},{12482,4970,0,0,2},{12485,4972,0,0,2},{12487,4974,0,0,2},{12489,
4976,0,0,2},{12496,4978,0,0,2},{12497,4980,0,0,2},{12499,4982,0,0,2},{12500,
4984,0,0,2},{12502,4986,0,0,2},{12503,4988,0,0,2},{12505,4990,0,0,2},{12506,
4992,0,0,2},{12508,4994,0,0,2},{12509,4996,0,0,2},{12532,4998,0,0,2},{12535,
5000,0,0,2},{12536,5002,0,0,2},{12537,5004,0,0,2},{12538,5006,0,0,2},{12542,
5008,0,0,2},{12543,5010,0,0,2},{12690,5012,0,0,2},{12691,5014,0,0,2},{12692,
5016,0,0,2},{12693,5018,0,0,2},{12694,5020,0,0,2},{12695,5022,0,0,2},{12696,
5024,0,0,2},{12697,5026,0,0,2},{12698,5028,0,0,2},{12699,5030,0,0,2},{12700,
5032,0,0,2},{12701,5034,0,0,2},{12702,5036,0,0,2},{12703,5038,0,0,2},{12704,
5040,0,0,2},{12705,5042,0,0,2},{12706,5044,0,0,2},{12707,5046,0,0,2},{12709,
5048,0,0,2},{12711,5050,0,0,2},{12712,5052,0,0,2},{12713,5054,0,0,2},{12714,
5056,0,0,2},{12715,5058,0,0,2},{12718,5060,0,0,2},{12719,5062,0,0,2},{12723,
5064,0,0,2},{12800,5066,0,0,3},{12801,5069,0,0,3},{12802,5072,0,0,3},{12803,
5075,0,0,3},{12804,5078,0,0,3},{12805,5081,0,0,3},{12806,5084,0,0,3},{12807,
5087,0,0,3},{12808,5090,0,0,3},{12809,5093,0,0,3},{12810,5096,0,0,3},{12811,
5099,0,0,3},{12812,5102,0,0,3},{12813,5105,0,0,3},{12814,5108,0,0,4},{12815,
5112,0,0,4},{12816,5116,0,0,4},{12817,5120,0,0,4},{12818,5124,0,0,4},{12819,
5128,0,0,4},{12820,5132,0,0,4},{12821,5136,0,0,4},{12822,5140,0,0,4},{12823,
5144,0,0,4},{12824,5148,0,0,4},{12825,5152,0,0,4},{12826,5156,0,0,4},{12827,
5160,0,0,4},{12828,5164,0,0,4},{12829,5168,0,0,7},{12830,5175,0,0,6},{12832,
5181,0,0,4},{12833,5185,0,0,4},{12834,5189,0,0,4},{12835,5193,0,0,4},{12836,
5197,0,0,4},{12837,5201,0,0,4},{12838,5205,0,0,4},{12839,5209,0,0,4},{12840,
5213,0,0,4},{12841,5217,0,0,4},{12842,5221,0,0,4},{12843,5225,0,0,4},{12844,
5229,0,0,4},{12845,5233,0,0,4},{12846,5237,0,0,4},{12847,5241,0,0,4},{12848,
5245,0,0,4},{12849,5249,0,0,4},{12850,5253,0,0,4},{12851,5257,0,0,4},{12852,
5261,0,0,4},{12853,5265,0,0,4},{12854,5269,0,0,4},{12855,5273,0,0,4},{12856,
5277,0,0,4},{12857,5281,0,0,4},{12858,5285,0,0,4},{12859,5289,0,0,4},{12860,
5293,0,0,4},{12861,5297,0,0,4},{12862,5301,0,0,4},{12863,5305,0,0,4},{12864,
5309,0,0,4},{12865,5313,0,0,4},{12866,5317,0,0,4},{12867,5321,0,0,4},{12868,
5325,0,0,2},{12869,5327,0,0,2},{12870,5329,0,0,2},{12871,5331,0,0,2},{12872,
5333,0,0,2},{12873,5335,0,0,2},{12874,5337,0,0,2},{12875,5339,0,0,2},{12876,
5341,0,0,2},{12877,5343,0,0,2},{12878,5345,0,0,2},{12879,5347,0,0,2},{12880,
5349,0,0,3},{12881,5352,0,0,2},{12882,5354,0,0,2},{12883,5356,0,0,2},{12884,
5358,0,0,2},{12885,5360,0,0,2},{12886,5362,0,0,2},{12887,5364,0,0,2},{12888,
5366,0,0,2},{12889,5368,0,0,2},{12890,5370,0,0,2},{12891,5372,0,0,2},{12892,
5374,0,0,2},{12893,5376,0,0,2},{12894,5378,0,0,2},{12895,5380,0,0,2},{12910,
5382,0,0,2},{12911,5384,0,0,2},{12912,5386,0,0,2},{12913,5388,0,0,2},{12914,
5390,0,0,2},{12915,5392,0,0,2},{12916,5394,0,0,2},{12917,5396,0,0,2},{12918,
5398,0,0,2},{12919,5400,0,0,2},{12920,5402,0,0,2},{12921,5404,0,0,2},{12922,
5406,0,0,2},{12923,5408,0,0,2},{12924,5410,0,0,5},{12925,5415,0,0,4},{12926,
5419,0,0,2},{12928,5421,0,0,2},{12929,5423,0,0,2},{12930,5425,0,0,2},{12931,
5427,0,0,2},{12932,5429,0,0,2},{12933,5431,0,0,2},{12934,5433,0,0,2},{12935,
5435,0,0,2},{12936,5437,0,0,2},{12937,5439,0,0,2},{12938,5441,0,0,2},{12939,
5443,0,0,2},{12940,5445,0,0,2},{12941,5447,0,0,2},{12942,5449,0,0,2},{12943,
5451,0,0,2},{12944,5453,0,0,2},{12945,5455,0,0,2},{12946,5457,0,0,2},{12947,
5459,0,0,2},{12948,5461,0,0,2},{12949,5463,0,0,2},{12950,5465,0,0,2},{12951,
5467,0,0,2},{12952,5469,0,0,2},{12953,5471,0,0,2},{12954,5473,0,0,2},{12955,
5475,0,0,2},{12956,5477,0,0,2},{12957,5479,0,0,2},{12958,5481,0,0,2},{12959,
5483,0,0,2},{12960,5485,0,0,2},{12961,5487,0,0,2},{12962,5489,0,0,2},{12963,
5491,0,0,2},{12964,5493,0,0,2},{12965,5495,0,0,2},{12966,5497,0,0,2},{12967,
5499,0,0,2},{12968,5501,0,0,2},{12969,5503,0,0,2},{12970,5505,0,0,2},{12971,
5507,0,0,2},{12972,5509,0,0,2},{12973,5511,0,0,2},{12974,5513,0,0,2},{12975,
5515,0,0,2},{12976,5517,0,0,2},{12977,5519,0,0,2},{12978,5521,0,0,2},{12979,
5523,0,0,2},{12980,5525,0,0,2},{12981,5527,0,0,2},{12982,5529,0,0,2},{12983,
5531,0,0,2},{12984,5533,0,0,2},{12985,5535,0,0,2},{12986,5537,0,0,2},{12987,
5539,0,0,2},{12988,5541,0,0,2},{12989,5543,0,0,2},{12990,5545,0,0,2},{12991,
5547,0,0,2},{12992,5549,0,0,3},{12993,5552,0,0,3},{12994,5555,0,0,3},{12995,
5558,0,0,3},{12996,5561,0,0,3},{12997,5564,0,0,3},{12998,5567,0,0,3},{12999,
5570,0,0,3},{13000,5573,0,0,3},{13001,5576,0,0,4},{13002,5580,0,0,4},{13003,
5584,0,0,4},{13004,5588,0,0,2},{13005,5590,0,0,3},{13006,5593,0,0,2},{13007,
5595,0,0,3},{13055,5598,0,0,4},{13056,5602,0,0,5},{13057,5607,0,0,4},{13058,
5611,0,0,5},{13059,5616,0,0,3},{13060,5619,0,0,5},{13061,5624,0,0,3},{13062,
5627,0,0,3},{13063,5630,0,0,6},{13064,5636,0,0,4},{13065,5640,0,0,3},{13066,
5643,0,0,3},{13067,5646,0,0,3},{13068,5649,0,0,4},{13069,5653,0,0,4},{13070,
5657,0,0,4},{13071,5661,0,0,4},{13072,5665,0,0,4},{13073,5669,0,0,4},{13074,
5673,0,0,4},{13075,5677,0,0,6},{13076,5683,0,0,2},{13077,5685,0,0,6},{13078,
5691,0,0,6},{13079,5697,0,0,5},{13080,5702,0,0,4},{13081,5706,0,0,6},{13082,
5712,0,0,6},{13083,5718,0,0,4},{13084,5722,0,0,3},{13085,5725,0,0,3},{13086,
5728,0,0,4},{13087,5732,0,0,4},{13088,5736,0,0,5},{13089,5741,0,0,5},{13090,
5746,0,0,3},{13091,5749,0,0,3},{13092,5752,0,0,4},{13093,5756,0,0,3},{13094,
5759,0,0,3},{13095,5762,0,0,2},{13096,5764,0,0,2},{13097,5766,0,0,3},{13098,
5769,0,0,3},{13099,5772,0,0,6},{13100,5778,0,0,4},{13101,5782,0,0,5},{13102,
5787,0,0,6},{13103,5793,0,0,4},{13104,5797,0,0,3},{13105,5800,0,0,3},{13106,
5803,0,0,6},{13107,5809,0,0,4},{13108,5813,0,0,6},{13109,5819,0,0,3},{13110,
5822,0,0,5},{13111,5827,0,0,3},{13112,5830,0,0,4},{13113,5834,0,0,3},{13114,
5837,0,0,4},{13115,5841,0,0,5},{13116,5846,0,0,4},{13117,5850,0,0,5},{13118,
5855,0,0,4},{13119,5859,0,0,2},{13120,5861,0,0,5},{13121,5866,0,0,3},{13122,
5869,0,0,3},{13123,5872,0,0,4},{13124,5876,0,0,3},{13125,5879,0,0,3},{13126,
5882,0,0,3},{13127,5885,0,0,5},{13128,5890,0,0,4},{13129,5894,0,0,2},{13130,
5896,0,0,6},{13131,5902,0,0,3},{13132,5905,0,0,5},{13133,5910,0,0,4},{13134,
5914,0,0,4},{13135,5918,0,0,3},{13136,5921,0,0,3},{13137,5924,0,0,4},{13138,
5928,0,0,2},{13139,5930,0,0,4},{13140,5934,0,0,5},{13141,5939,0,0,2},{13142,
5941,0,0,6},{13143,5947,0,0,3},{13144,5950,0,0,3},{13145,5953,0,0,3},{13146,
5956,0,0,3},{13147,5959,0,0,3},{13148,5962,0,0,3},{13149,5965,0,0,3},{13150,
5968,0,0,3},{13151,5971,0,0,3},{13152,5974,0,0,3},{13153,5977,0,0,3},{13154,
5980,0,0,4},{13155,5984,0,0,4},{13156,5988,0,0,4},{13157,5992,0,0,4},{13158,
5996,0,0,4},{13159,6000,0,0,4},{13160,6004,0,0,4},{13161,6008,0,0,4},{13162,
6012,0,0,4},{13163,6016,0,0,4},{13164,6020,0,0,4},{13165,6024,0,0,4},{13166,
6028,0,0,4},{13167,6032,0,0,4},{13168,6036,0,0,4},{13169,6040,0,0,3},{13170,
6043,0,0,2},{13171,6045,0,0,2},{13172,6047,0,0,3},{13173,6050,0,0,2},{13174,
6052,0,0,2},{13175,6054,0,0,2},{13176,6056,0,0,3},{13177,6059,0,0,3},{13178,
6062,0,0,2},{13179,6064,0,0,4},{13180,6068,0,0,4},{13181,6072,0,0,4},{13182,
6076,0,0,4},{13183,6080,0,0,8},{13184,6088,0,0,2},{13185,6090,0,0,2},{13186,
6092,0,0,2},{13187,6094,0,0,2},{13188,6096,0,0,2},{13189,6098,0,0,2},{13190,
6100,0,0,2},{13191,6102,0,0,2},{13192,6104,0,0,3},{13193,6107,0,0,4},{13194,
6111,0,0,2},{13195,6113,0,0,2},{13196,6115,0,0,2},{13197,6117,0,0,2},{13198,
6119,0,0,2},{13199,6121,0,0,2},{13200,6123,0,0,2},{13201,6125,0,0,3},{13202,
6128,0,0,3},{13203,6131,0,0,3},{13204,6134,0,0,3},{13205,6137,0,0,2},{13206,
6139,0,0,2},{13207,6141,0,0,2},{13208,6143,0,0,2},{13209,6145,0,0,2},{13210,
6147,0,0,2},{13211,6149,0,0,2},{13212,6151,0,0,2},{13213,6153,0,0,2},{13214,
6155,0,0,2},{13215,6157,0,0,3},{13216,6160,0,0,3},{13217,6163,0,0,2},{13218,
6165,0,0,3},{13219,6168,0,0,3},{13220,6171,0,0,3},{13221,6174,0,0,2},{13222,
6176,0,0,3},{13223,6179,0,0,3},{13224,6182,0,0,4},{13225,6186,0,0,2},{13226,
6188,0,0,3},{13227,6191,0,0,3},{13228,6194,0,0,3},{13229,6197,0,0,3},{13230,
6200,0,0,5},{13231,6205,0,0,6},{13232,6211,0,0,2},{13233,6213,0,0,2},{13234,
6215,0,0,2},{13235,6217,0,0,2},{13236,6219,0,0,2},{13237,6221,0,0,2},{13238,
6223,0,0,2},{13239,6225,0,0,2},{13240,6227,0,0,2},{13241,6229,0,0,2},{13242,
6231,0,0,2},{13243,6233,0,0,2},{13244,6235,0,0,2},{13245,6237,0,0,2},{13246,
6239,0,0,2},{13247,6241,0,0,2},{13248,6243,0,0,2},{13249,6245,0,0,2},{13250,
6247,0,0,4},{13251,6251,0,0,2},{13252,6253,0,0,2},{13253,6255,0,0,2},{13254,
6257,0,0,4},{13255,6261,0,0,3},{13256,6264,0,0,2},{13257,6266,0,0,2},{13258,
6268,0,0,2},{13259,6270,0,0,2},{13260,6272,0,0,2},{13261,6274,0,0,2},{13262,
6276,0,0,2},{13263,6278,0,0,2},{13264,6280,0,0,2},{13265,6282,0,0,2},{13266,
6284,0,0,3},{13267,6287,0,0,2},{13268,6289,0,0,2},{13269,6291,0,0,3},{13270,
6294,0,0,3},{13271,6297,0,0,2},{13272,6299,0,0,4},{13273,6303,0,0,3},{13274,
6306,0,0,2},{13275,6308,0,0,2},{13276,6310,0,0,2},{13277,6312,0,0,2},{13278,
6314,0,0,3},{13279,6317,0,0,3},{13280,6320,0,0,3},{13281,6323,0,0,3},{13282,
6326,0,0,3},{13283,6329,0,0,3},{13284,6332,0,0,3},{13285,6335,0,0,3},{13286,
6338,0,0,3},{13287,6341,0,0,3},{13288,6344,0,0,3},{13289,6347,0,0,4},{13290,
6351,0,0,4},{13291,6355,0,0,4},{13292,6359,0,0,4},{13293,6363,0,0,4},{13294,
6367,0,0,4},{13295,6371,0,0,4},{13296,6375,0,0,4},{13297,6379,0,0,4},{13298,
6383,0,0,4},{13299,6387,0,0,4},{13300,6391,0,0,4},{13301,6395,0,0,4},{13302,
6399,0,0,4},{13303,6403,0,0,4},{13304,6407,0,0,4},{13305,6411,0,0,4},{13306,
6415,0,0,4},{13307,6419,0,0,4},{13308,6423,0,0,4},{13309,6427,0,0,4},{13310,
6431,0,0,4},{13311,6435,0,0,3},{13470,6438,0,0,2},{13497,6440,0,0,2},{13499,
6442,0,0,2},{13535,6444,0,0,2},{13589,6446,0,0,2},{14062,6448,0,0,2},{14076,
6450,0,0,2},{14209,6452,0,0,2},{14383,6454,0,0,2},{14434,6456,0,0,2},{14460,
6458,0,0,2},{14535,6460,0,0,2},{14563,6462,0,0,2},{14620,6464,0,0,2},{14650,
6466,0,0,2},{14894,6468,0,0,2},{14956,6470,0,0,2},{15076,6472,0,0,2},{15112,
6474,0,0,2},{15129,6476,0,0,2},{15177,6478,0,0,2},{15261,6480,0,0,2},{15384,
6482,0,0,2},{15438,6484,0,0,2},{15667,6486,0,0,2},{15766,6488,0,0,2},{16044,
6490,0,0,2},{16056,6492,0,0,2},{16155,6494,0,0,2},{16380,6496,0,0,2},{16392,
6498,0,0,2},{16408,6500,0,0,2},{16441,6502,0,0,2},{16454,6504,0,0,2},{16534,
6506,0,0,2},{16611,6508,0,0,2},{16687,6510,0,0,2},{16898,6512,0,0,2},{16935,
6514,0,0,2},{17056,6516,0,0,2},{17153,6518,0,0,2},{17204,6520,0,0,2},{17241,
6522,0,0,2},{17365,6524,0,0,2},{17369,6526,0,0,2},{17419,6528,0,0,2},{17515,
6530,0,0,2},{17707,6532,0,0,2},{17757,6534,0,0,2},{17761,6536,0,0,2},{17771,
6538,0,0,2},{17879,6540,0,0,2},{17913,6542,0,0,2},{17973,6544,0,0,2},{18110,
6546,0,0,2},{18119,6548,0,0,2},{18837,6550,0,0,2},{18918,6552,0,0,2},{19054,
6554,0,0,2},{19062,6556,0,0,2},{19122,6558,0,0,2},{19251,6560,0,0,2},{19406,
6562,0,0,2},{19662,6564,0,0,2},{19693,6566,0,0,2},{19704,6568,0,0,2},{19798,
6570,0,0,2},{19981,6572,0,0,2},{20006,6574,0,0,2},{20018,6576,0,0,2},{20024,
6578,0,0,2},{20025,6580,0,0,2},{20029,6582,0,0,2},{20033,6584,0,0,2},{20098,
6586,0,0,2},{20102,6588,0,0,2},{20142,6590,0,0,2},{20160,6592,0,0,2},{20172,
6594,0,0,2},{20196,6596,0,0,2},{20320,6598,0,0,2},{20352,6600,0,0,2},{20358,
6602,0,0,2},{20363,6604,0,0,2},{20398,6606,0,0,2},{20411,6608,0,0,2},{20415,
6610,0,0,2},{20482,6612,0,0,2},{20523,6614,0,0,2},{20602,6616,0,0,2},{20633,
6618,0,0,2},{20687,6620,0,0,2},{20698,6622,0,0,2},{20711,6624,0,0,2},{20800,
6626,0,0,2},{20805,6628,0,0,2},{20813,6630,0,0,2},{20820,6632,0,0,2},{20836,
6634,0,0,2},{20839,6636,0,0,2},{20840,6638,0,0,2},{20841,6640,0,0,2},{20845,
6642,0,0,2},{20855,6644,0,0,2},{20864,6646,0,0,2},{20877,6648,0,0,2},{20882,
6650,0,0,2},{20885,6652,0,0,2},{20887,6654,0,0,2},{20900,6656,0,0,2},{20908,
6658,0,0,2},{20917,6660,0,0,2},{20919,6662,0,0,2},{20937,6664,0,0,2},{20940,
6666,0,0,2},{20956,6668,0,0,2},{20958,6670,0,0,2},{20981,6672,0,0,2},{20995,
6674,0,0,2},{20999,6676,0,0,2},{21015,6678,0,0,2},{21033,6680,0,0,2},{21050,
6682,0,0,2},{21051,6684,0,0,2},{21062,6686,0,0,2},{21106,6688,0,0,2},{21111,
6690,0,0,2},{21129,6692,0,0,2},{21147,6694,0,0,2},{21155,6696,0,0,2},{21171,
6698,0,0,2},{21191,6700,0,0,2},{21193,6702,0,0,2},{21202,6704,0,0,2},{21214,
6706,0,0,2},{21220,6708,0,0,2},{21237,6710,0,0,2},{21242,6712,0,0,2},{21253,
6714,0,0,2},{21254,6716,0,0,2},{21271,6718,0,0,2},{21311,6720,0,0,2},{21321,
6722,0,0,2},{21329,6724,0,0,2},{21338,6726,0,0,2},{21363,6728,0,0,2},{21365,
6730,0,0,2},{21373,6732,0,0,2},{21375,6734,0,0,2},{21443,6736,0,0,2},{21450,
6738,0,0,2},{21471,6740,0,0,2},{21477,6742,0,0,2},{21483,6744,0,0,2},{21489,
6746,0,0,2},{21510,6748,0,0,2},{21519,6750,0,0,2},{21533,6752,0,0,2},{21560,
6754,0,0,2},{21570,6756,0,0,2},{21576,6758,0,0,2},{21608,6760,0,0,2},{21662,
6762,0,0,2},{21666,6764,0,0,2},{21693,6766,0,0,2},{21750,6768,0,0,2},{21776,
6770,0,0,2},{21843,6772,0,0,2},{21845,6774,0,0,2},{21859,6776,0,0,2},{21892,
6778,0,0,2},{21895,6780,0,0,2},{21913,6782,0,0,2},{21917,6784,0,0,2},{21931,
6786,0,0,2},{21939,6788,0,0,2},{21952,6790,0,0,2},{21954,6792,0,0,2},{21986,
6794,0,0,2},{22022,6796,0,0,2},{22097,6798,0,0,2},{22120,6800,0,0,2},{22132,
6802,0,0,2},{22265,6804,0,0,2},{22294,6806,0,0,2},{22295,6808,0,0,2},{22411,
6810,0,0,2},{22478,6812,0,0,2},{22516,6814,0,0,2},{22541,6816,0,0,2},{22577,
6818,0,0,2},{22578,6820,0,0,2},{22592,6822,0,0,2},{22618,6824,0,0,2},{22622,
6826,0,0,2},{22696,6828,0,0,2},{22700,6830,0,0,2},{22707,6832,0,0,2},{22744,
6834,0,0,2},{22751,6836,0,0,2},{22766,6838,0,0,2},{22770,6840,0,0,2},{22775,
6842,0,0,2},{22790,6844,0,0,2},{22810,6846,0,0,2},{22818,6848,0,0,2},{22852,
6850,0,0,2},{22856,6852,0,0,2},{22865,6854,0,0,2},{22868,6856,0,0,2},{22882,
6858,0,0,2},{22899,6860,0,0,2},{23000,6862,0,0,2},{23020,6864,0,0,2},{23067,
6866,0,0,2},{23079,6868,0,0,2},{23138,6870,0,0,2},{23142,6872,0,0,2},{23221,
6874,0,0,2},{23304,6876,0,0,2},{23336,6878,0,0,2},{23358,6880,0,0,2},{23429,
6882,0,0,2},{23491,6884,0,0,2},{23512,6886,0,0,2},{23527,6888,0,0,2},{23534,
6890,0,0,2},{23539,6892,0,0,2},{23551,6894,0,0,2},{23558,6896,0,0,2},{23586,
6898,0,0,2},{23615,6900,0,0,2},{23648,6902,0,0,2},{23650,6904,0,0,2},{23652,
6906,0,0,2},{23653,6908,0,0,2},{23662,6910,0,0,2},{23693,6912,0,0,2},{23744,
6914,0,0,2},{23833,6916,0,0,2},{23875,6918,0,0,2},{23888,6920,0,0,2},{23915,
6922,0,0,2},{23918,6924,0,0,2},{23932,6926,0,0,2},{23986,6928,0,0,2},{23994,
6930,0,0,2},{24033,6932,0,0,2},{24034,6934,0,0,2},{24061,6936,0,0,2},{24104,
6938,0,0,2},{24125,6940,0,0,2},{24169,6942,0,0,2},{24180,6944,0,0,2},{24230,
6946,0,0,2},{24240,6948,0,0,2},{24243,6950,0,0,2},{24246,6952,0,0,2},{24265,
6954,0,0,2},{24266,6956,0,0,2},{24274,6958,0,0,2},{24275,6960,0,0,2},{24281,
6962,0,0,2},{24300,6964,0,0,2},{24318,6966,0,0,2},{24324,6968,0,0,2},{24354,
6970,0,0,2},{24403,6972,0,0,2},{24418,6974,0,0,2},{24425,6976,0,0,2},{24427,
6978,0,0,2},{24459,6980,0,0,2},{24474,6982,0,0,2},{24489,6984,0,0,2},{24493,
6986,0,0,2},{24525,6988,0,0,2},{24535,6990,0,0,2},{24565,6992,0,0,2},{24569,
6994,0,0,2},{24594,6996,0,0,2},{24604,6998,0,0,2},{24693,7000,0,0,2},{24705,
7002,0,0,2},{24724,7004,0,0,2},{24775,7006,0,0,2},{24792,7008,0,0,2},{24801,
7010,0,0,2},{24840,7012,0,0,2},{24900,7014,0,0,2},{24904,7016,0,0,2},{24908,
7018,0,0,2},{24910,7020,0,0,2},{24928,7022,0,0,2},{24936,7024,0,0,2},{24954,
7026,0,0,2},{24974,7028,0,0,2},{24976,7030,0,0,2},{24996,7032,0,0,2},{25007,
7034,0,0,2},{25010,7036,0,0,2},{25054,7038,0,0,2},{25074,7040,0,0,2},{25078,
7042,0,0,2},{25088,7044,0,0,2},{25104,7046,0,0,2},{25115,7048,0,0,2},{25134,
7050,0,0,2},{25140,7052,0,0,2},{25181,7054,0,0,2},{25265,7056,0,0,2},{25289,
7058,0,0,2},{25295,7060,0,0,2},{25299,7062,0,0,2},{25300,7064,0,0,2},{25340,
7066,0,0,2},{25342,7068,0,0,2},{25405,7070,0,0,2},{25424,7072,0,0,2},{25448,
7074,0,0,2},{25467,7076,0,0,2},{25475,7078,0,0,2},{25504,7080,0,0,2},{25513,
7082,0,0,2},{25540,7084,0,0,2},{25541,7086,0,0,2},{25572,7088,0,0,2},{25628,
7090,0,0,2},{25634,7092,0,0,2},{25682,7094,0,0,2},{25705,7096,0,0,2},{25719,
7098,0,0,2},{25726,7100,0,0,2},{25754,7102,0,0,2},{25757,7104,0,0,2},{25796,
7106,0,0,2},{25935,7108,0,0,2},{25942,7110,0,0,2},{25964,7112,0,0,2},{25976,
7114,0,0,2},{26009,7116,0,0,2},{26053,7118,0,0,2},{26082,7120,0,0,2},{26083,
7122,0,0,2},{26131,7124,0,0,2},{26185,7126,0,0,2},{26228,7128,0,0,2},{26248,
7130,0,0,2},{26257,7132,0,0,2},{26268,7134,0,0,2},{26292,7136,0,0,2},{26310,
7138,0,0,2},{26356,7140,0,0,2},{26360,7142,0,0,2},{26368,7144,0,0,2},{26391,
7146,0,0,2},{26395,7148,0,0,2},{26401,7150,0,0,2},{26446,7152,0,0,2},{26451,
7154,0,0,2},{26454,7156,0,0,2},{26462,7158,0,0,2},{26491,7160,0,0,2},{26501,
7162,0,0,2},{26519,7164,0,0,2},{26611,7166,0,0,2},{26618,7168,0,0,2},{26647,
7170,0,0,2},{26655,7172,0,0,2},{26706,7174,0,0,2},{26753,7176,0,0,2},{26757,
7178,0,0,2},{26766,7180,0,0,2},{26792,7182,0,0,2},{26900,7184,0,0,2},{26946,
7186,0,0,2},{27043,7188,0,0,2},{27114,7190,0,0,2},{27138,7192,0,0,2},{27155,
7194,0,0,2},{27304,7196,0,0,2},{27347,7198,0,0,2},{27355,7200,0,0,2},{27396,
7202,0,0,2},{27425,7204,0,0,2},{27476,7206,0,0,2},{27506,7208,0,0,2},{27511,
7210,0,0,2},{27513,7212,0,0,2},{27551,7214,0,0,2},{27566,7216,0,0,2},{27578,
7218,0,0,2},{27579,7220,0,0,2},{27726,7222,0,0,2},{27751,7224,0,0,2},{27784,
7226,0,0,2},{27839,7228,0,0,2},{27852,7230,0,0,2},{27853,7232,0,0,2},{27877,
7234,0,0,2},{27926,7236,0,0,2},{27931,7238,0,0,2},{27934,7240,0,0,2},{27956,
7242,0,0,2},{27966,7244,0,0,2},{27969,7246,0,0,2},{28009,7248,0,0,2},{28010,
7250,0,0,2},{28023,7252,0,0,2},{28024,7254,0,0,2},{28037,7256,0,0,2},{28107,
7258,0,0,2},{28122,7260,0,0,2},{28138,7262,0,0,2},{28153,7264,0,0,2},{28186,
7266,0,0,2},{28207,7268,0,0,2},{28270,7270,0,0,2},{28316,7272,0,0,2},{28346,
7274,0,0,2},{28359,7276,0,0,2},{28363,7278,0,0,2},{28369,7280,0,0,2},{28379,
7282,0,0,2},{28431,7284,0,0,2},{28450,7286,0,0,2},{28451,7288,0,0,2},{28526,
7290,0,0,2},{28614,7292,0,0,2},{28651,7294,0,0,2},{28670,7296,0,0,2},{28699,
7298,0,0,2},{28702,7300,0,0,2},{28729,7302,0,0,2},{28746,7304,0,0,2},{28784,
7306,0,0,2},{28791,7308,0,0,2},{28797,7310,0,0,2},{28825,7312,0,0,2},{28845,
7314,0,0,2},{28872,7316,0,0,2},{28889,7318,0,0,2},{28997,7320,0,0,2},{29001,
7322,0,0,2},{29038,7324,0,0,2},{29084,7326,0,0,2},{29134,7328,0,0,2},{29136,
7330,0,0,2},{29200,7332,0,0,2},{29211,7334,0,0,2},{29224,7336,0,0,2},{29227,
7338,0,0,2},{29237,7340,0,0,2},{29264,7342,0,0,2},{29282,7344,0,0,2},{29312,
7346,0,0,2},{29333,7348,0,0,2},{29359,7350,0,0,2},{29376,7352,0,0,2},{29436,
7354,0,0,2},{29482,7356,0,0,2},{29557,7358,0,0,2},{29562,7360,0,0,2},{29575,
7362,0,0,2},{29579,7364,0,0,2},{29605,7366,0,0,2},{29618,7368,0,0,2},{29662,
7370,0,0,2},{29702,7372,0,0,2},{29705,7374,0,0,2},{29730,7376,0,0,2},{29767,
7378,0,0,2},{29788,7380,0,0,2},{29801,7382,0,0,2},{29809,7384,0,0,2},{29829,
7386,0,0,2},{29833,7388,0,0,2},{29848,7390,0,0,2},{29898,7392,0,0,2},{29958,
7394,0,0,2},{29988,7396,0,0,2},{30011,7398,0,0,2},{30014,7400,0,0,2},{30041,
7402,0,0,2},{30053,7404,0,0,2},{30064,7406,0,0,2},{30178,7408,0,0,2},{30224,
7410,0,0,2},{30237,7412,0,0,2},{30239,7414,0,0,2},{30274,7416,0,0,2},{30313,
7418,0,0,2},{30410,7420,0,0,2},{30427,7422,0,0,2},{30439,7424,0,0,2},{30452,
7426,0,0,2},{30465,7428,0,0,2},{30494,7430,0,0,2},{30495,7432,0,0,2},{30528,
7434,0,0,2},{30538,7436,0,0,2},{30603,7438,0,0,2},{30631,7440,0,0,2},{30798,
7442,0,0,2},{30827,7444,0,0,2},{30860,7446,0,0,2},{30865,7448,0,0,2},{30922,
7450,0,0,2},{30924,7452,0,0,2},{30971,7454,0,0,2},{31018,7456,0,0,2},{31036,
7458,0,0,2},{31038,7460,0,0,2},{31048,7462,0,0,2},{31049,7464,0,0,2},{31056,
7466,0,0,2},{31062,7468,0,0,2},{31069,7470,0,0,2},{31070,7472,0,0,2},{31077,
7474,0,0,2},{31103,7476,0,0,2},{31117,7478,0,0,2},{31118,7480,0,0,2},{31119,
7482,0,0,2},{31150,7484,0,0,2},{31178,7486,0,0,2},{31211,7488,0,0,2},{31260,
7490,0,0,2},{31296,7492,0,0,2},{31306,7494,0,0,2},{31311,7496,0,0,2},{31361,
7498,0,0,2},{31409,7500,0,0,2},{31435,7502,0,0,2},{31470,7504,0,0,2},{31520,
7506,0,0,2},{31680,7508,0,0,2},{31686,7510,0,0,2},{31689,7512,0,0,2},{31806,
7514,0,0,2},{31840,7516,0,0,2},{31867,7518,0,0,2},{31890,7520,0,0,2},{31934,
7522,0,0,2},{31954,7524,0,0,2},{31958,7526,0,0,2},{31971,7528,0,0,2},{31975,
7530,0,0,2},{31976,7532,0,0,2},{32000,7534,0,0,2},{32016,7536,0,0,2},{32034,
7538,0,0,2},{32047,7540,0,0,2},{32091,7542,0,0,2},{32099,7544,0,0,2},{32160,
7546,0,0,2},{32190,7548,0,0,2},{32199,7550,0,0,2},{32244,7552,0,0,2},{32258,
7554,0,0,2},{32265,7556,0,0,2},{32311,7558,0,0,2},{32321,7560,0,0,2},{32325,
7562,0,0,2},{32574,7564,0,0,2},{32626,7566,0,0,2},{32633,7568,0,0,2},{32634,
7570,0,0,2},{32645,7572,0,0,2},{32661,7574,0,0,2},{32666,7576,0,0,2},{32701,
7578,0,0,2},{32762,7580,0,0,2},{32769,7582,0,0,2},{32773,7584,0,0,2},{32838,
7586,0,0,2},{32864,7588,0,0,2},{32879,7590,0,0,2},{32880,7592,0,0,2},{32894,
7594,0,0,2},{32907,7596,0,0,2},{32941,7598,0,0,2},{32946,7600,0,0,2},{33027,
7602,0,0,2},{33086,7604,0,0,2},{33240,7606,0,0,2},{33256,7608,0,0,2},{33261,
7610,0,0,2},{33281,7612,0,0,2},{33284,7614,0,0,2},{33304,7616,0,0,2},{33391,
7618,0,0,2},{33401,7620,0,0,2},{33419,7622,0,0,2},{33425,7624,0,0,2},{33437,
7626,0,0,2},{33457,7628,0,0,2},{33459,7630,0,0,2},{33469,7632,0,0,2},{33509,
7634,0,0,2},{33510,7636,0,0,2},{33565,7638,0,0,2},{33571,7640,0,0,2},{33590,
7642,0,0,2},{33618,7644,0,0,2},{33619,7646,0,0,2},{33635,7648,0,0,2},{33709,
7650,0,0,2},{33725,7652,0,0,2},{33737,7654,0,0,2},{33738,7656,0,0,2},{33740,
7658,0,0,2},{33756,7660,0,0,2},{33767,7662,0,0,2},{33775,7664,0,0,2},{33777,
7666,0,0,2},{33853,7668,0,0,2},{33865,7670,0,0,2},{33879,7672,0,0,2},{34030,
7674,0,0,2},{34033,7676,0,0,2},{34035,7678,0,0,2},{34044,7680,0,0,2},{34070,
7682,0,0,2},{34148,7684,0,0,2},{34253,7686,0,0,2},{34298,7688,0,0,2},{34310,
7690,0,0,2},{34322,7692,0,0,2},{34349,7694,0,0,2},{34367,7696,0,0,2},{34384,
7698,0,0,2},{34396,7700,0,0,2},{34407,7702,0,0,2},{34409,7704,0,0,2},{34440,
7706,0,0,2},{34473,7708,0,0,2},{34530,7710,0,0,2},{34574,7712,0,0,2},{34600,
7714,0,0,2},{34667,7716,0,0,2},{34681,7718,0,0,2},{34694,7720,0,0,2},{34746,
7722,0,0,2},{34785,7724,0,0,2},{34817,7726,0,0,2},{34847,7728,0,0,2},{34892,
7730,0,0,2},{34912,7732,0,0,2},{34915,7734,0,0,2},{35010,7736,0,0,2},{35023,
7738,0,0,2},{35031,7740,0,0,2},{35038,7742,0,0,2},{35041,7744,0,0,2},{35064,
7746,0,0,2},{35066,7748,0,0,2},{35088,7750,0,0,2},{35137,7752,0,0,2},{35172,
7754,0,0,2},{35206,7756,0,0,2},{35211,7758,0,0,2},{35222,7760,0,0,2},{35488,
7762,0,0,2},{35498,7764,0,0,2},{35519,7766,0,0,2},{35531,7768,0,0,2},{35538,
7770,0,0,2},{35542,7772,0,0,2},{35565,7774,0,0,2},{35576,7776,0,0,2},{35582,
7778,0,0,2},{35585,7780,0,0,2},{35641,7782,0,0,2},{35672,7784,0,0,2},{35712,
7786,0,0,2},{35722,7788,0,0,2},{35912,7790,0,0,2},{35925,7792,0,0,2},{36011,
7794,0,0,2},{36033,7796,0,0,2},{36034,7798,0,0,2},{36040,7800,0,0,2},{36051,
7802,0,0,2},{36104,7804,0,0,2},{36123,7806,0,0,2},{36215,7808,0,0,2},{36284,
7810,0,0,2},{36299,7812,0,0,2},{36335,7814,0,0,2},{36336,7816,0,0,2},{36554,
7818,0,0,2},{36564,7820,0,0,2},{36646,7822,0,0,2},{36650,7824,0,0,2},{36664,
7826,0,0,2},{36667,7828,0,0,2},{36706,7830,0,0,2},{36766,7832,0,0,2},{36784,
7834,0,0,2},{36790,7836,0,0,2},{36899,7838,0,0,2},{36920,7840,0,0,2},{36978,
7842,0,0,2},{36988,7844,0,0,2},{37007,7846,0,0,2},{37012,7848,0,0,2},{37070,
7850,0,0,2},{37086,7852,0,0,2},{37105,7854,0,0,2},{37117,7856,0,0,2},{37137,
7858,0,0,2},{37147,7860,0,0,2},{37226,7862,0,0,2},{37273,7864,0,0,2},{37300,
7866,0,0,2},{37324,7868,0,0,2},{37327,7870,0,0,2},{37329,7872,0,0,2},{37428,
7874,0,0,2},{37432,7876,0,0,2},{37494,7878,0,0,2},{37500,7880,0,0,2},{37591,
7882,0,0,2},{37592,7884,0,0,2},{37636,7886,0,0,2},{37706,7888,0,0,2},{37881,
7890,0,0,2},{37909,7892,0,0,2},{38283,7894,0,0,2},{38317,7896,0,0,2},{38327,
7898,0,0,2},{38446,7900,0,0,2},{38475,7902,0,0,2},{38477,7904,0,0,2},{38517,
7906,0,0,2},{38520,7908,0,0,2},{38524,7910,0,0,2},{38534,7912,0,0,2},{38563,
7914,0,0,2},{38583,7916,0,0,2},{38584,7918,0,0,2},{38595,7920,0,0,2},{38626,
7922,0,0,2},{38627,7924,0,0,2},{38646,7926,0,0,2},{38647,7928,0,0,2},{38691,
7930,0,0,2},{38706,7932,0,0,2},{38728,7934,0,0,2},{38742,7936,0,0,2},{38875,
7938,0,0,2},{38880,7940,0,0,2},{38911,7942,0,0,2},{38923,7944,0,0,2},{38936,
7946,0,0,2},{38953,7948,0,0,2},{38971,7950,0,0,2},{39006,7952,0,0,2},{39138,
7954,0,0,2},{39151,7956,0,0,2},{39164,7958,0,0,2},{39208,7960,0,0,2},{39209,
7962,0,0,2},{39335,7964,0,0,2},{39362,7966,0,0,2},{39409,7968,0,0,2},{39422,
7970,0,0,2},{39530,7972,0,0,2},{39698,7974,0,0,2},{39791,7976,0,0,2},{40000,
7978,0,0,2},{40023,7980,0,0,2},{40189,7982,0,0,2},{40295,7984,0,0,2},{40372,
7986,0,0,2},{40442,7988,0,0,2},{40478,7990,0,0,2},{40575,7992,0,0,2},{40599,
7994,0,0,2},{40607,7996,0,0,2},{40635,7998,0,0,2},{40654,8000,0,0,2},{40697,
8002,0,0,2},{40702,8004,0,0,2},{40709,8006,0,0,2},{40719,8008,0,0,2},{40726,
8010,0,0,2},{40763,8012,0,0,2},{40771,8014,0,0,2},{40845,8016,0,0,2},{40846,
8018,0,0,2},{40860,8020,0,0,2},{42515,8022,0,0,2},{42516,8024,0,0,2},{42517,
8026,0,0,2},{42518,8028,0,0,2},{42519,8030,0,0,2},{42520,8032,0,0,2},{42521,
8034,0,0,2},{42522,8036,0,0,2},{42523,8038,0,0,2},{42524,8040,0,0,2},{42525,
8042,0,0,2},{42526,8044,0,0,2},{42527,8046,0,0,2},{42614,8048,0,0,2},{42792,
8050,0,0,2},{42793,8052,0,0,2},{42802,8054,0,0,2},{42803,8056,0,0,2},{42804,
8058,0,0,2},{42805,8060,0,0,2},{42806,8062,0,0,2},{42807,8064,0,0,2},{42808,
8066,0,0,2},{42809,8068,0,0,2},{42810,8070,0,0,3},{42811,8073,0,0,3},{42812,
8076,0,0,2},{42813,8078,0,0,2},{42830,8080,0,0,2},{42831,8082,0,0,2},{42842,
8084,0,0,2},{42843,8086,0,0,2},{42848,8088,0,0,2},{42849,8090,0,0,2},{42873,
8092,0,0,2},{42874,8094,0,0,2},{42875,8096,0,0,2},{42876,8098,0,0,2},{42877,
8100,0,0,2},{42882,8102,0,0,2},{42883,8104,0,0,2},{42884,8106,0,0,2},{42885,
8108,0,0,2},{42886,8110,0,0,2},{42887,8112,0,0,2},{42906,8114,0,0,2},{42907,
8116,0,0,2},{42908,8118,0,0,2},{42909,8120,0,0,2},{42910,8122,0,0,2},{42911,
8124,0,0,2},{42912,8126,0,0,2},{42913,8128,0,0,2},{42914,8130,0,0,2},{42915,
8132,0,0,2},{42916,8134,0,0,2},{42917,8136,0,0,2},{42918,8138,0,0,2},{42919,
8140,0,0,2},{42920,8142,0,0,2},{42921,8144,0,0,2},{42944,8146,0,0,2},{42945,
8148,0,0,2},{42946,8150,0,0,2},{42947,8152,0,0,2},{42968,8154,0,0,2},{42969,
8156,0,0,2},{43000,8158,0,0,2},{43001,8160,0,0,3},{43701,0,4575,48,0},{43702,0,
4623,48,0},{43705,0,4671,48,0},{43707,0,4719,48,0},{43708,0,4767,48,0},{43878,
8643,0,0,2},{43879,8645,0,0,2},{64014,8647,0,0,2},{64015,8649,0,0,2},{64017,
8651,0,0,2},{64019,8653,0,0,2},{64020,8655,0,0,2},{64031,8657,0,0,2},{64033,
8659,0,0,2},{64035,8661,0,0,2},{64036,8663,0,0,2},{64039,8665,0,0,2},{64040,
8667,0,0,2},{64041,8669,0,0,2},{64256,8671,0,0,2},{64257,8673,0,0,2},{64258,
8675,0,0,2},{64259,8677,0,0,3},{64260,8680,0,0,3},{64261,8683,0,0,3},{64262,
8686,0,0,2},{64275,8688,0,0,2},{64276,8690,0,0,2},{64277,8692,0,0,2},{64278,
8694,0,0,2},{64279,8696,0,0,2},{64335,8698,0,0,2},{64420,8700,0,0,2},{64421,
8702,0,0,2},{64432,8704,0,0,2},{64433,8706,0,0,2},{64477,8708,0,0,2},{64490,
8710,0,0,2},{64491,8712,0,0,2},{64492,8714,0,0,2},{64493,8716,0,0,2},{64494,
8718,0,0,2},{64495,8720,0,0,2},{64496,8722,0,0,2},{64497,8724,0,0,2},{64498,
8726,0,0,2},{64499,8728,0,0,2},{64500,8730,0,0,2},{64501,8732,0,0,2},{64502,
8734,0,0,2},{64503,8736,0,0,2},{64504,8738,0,0,2},{64505,8740,0,0,2},{64506,
8742,0,0,2},{64507,8744,0,0,2},{64512,8746,0,0,2},{64513,8748,0,0,2},{64514,
8750,0,0,2},{64515,8752,0,0,2},{64516,8754,0,0,2},{64517,8756,0,0,2},{64518,
8758,0,0,2},{64519,8760,0,0,2},{64520,8762,0,0,2},{64521,8764,0,0,2},{64522,
8766,0,0,2},{64523,8768,0,0,2},{64524,8770,0,0,2},{64525,8772,0,0,2},{64526,
8774,0,0,2},{64527,8776,0,0,2},{64528,8778,0,0,2},{64529,8780,0,0,2},{64530,
8782,0,0,2},{64531,8784,0,0,2},{64532,8786,0,0,2},{64533,8788,0,0,2},{64534,
8790,0,0,2},{64535,8792,0,0,2},{64536,8794,0,0,2},{64537,8796,0,0,2},{64538,
8798,0,0,2},{64539,8800,0,0,2},{64540,8802,0,0,2},{64541,8804,0,0,2},{64542,
8806,0,0,2},{64543,8808,0,0,2},{64544,8810,0,0,2},{64545,8812,0,0,2},{64546,
8814,0,0,2},{64547,8816,0,0,2},{64548,8818,0,0,2},{64549,8820,0,0,2},{64550,
8822,0,0,2},{64551,8824,0,0,2},{64552,8826,0,0,2},{64553,8828,0,0,2},{64554,
8830,0,0,2},{64555,8832,0,0,2},{64556,8834,0,0,2},{64557,8836,0,0,2},{64558,
8838,0,0,2},{64559,8840,0,0,2},{64560,8842,0,0,2},{64561,8844,0,0,2},{64562,
8846,0,0,2},{64563,8848,0,0,2},{64564,8850,0,0,2},{64565,8852,0,0,2},{64566,
8854,0,0,2},{64567,8856,0,0,2},{64568,8858,0,0,2},{64569,8860,0,0,2},{64570,
8862,0,0,2},{64571,8864,0,0,2},{64572,8866,0,0,2},{64573,8868,0,0,2},{64574,
8870,0,0,2},{64575,8872,0,0,2},{64576,8874,0,0,2},{64577,8876,0,0,2},{64578,
8878,0,0,2},{64579,8880,0,0,2},{64580,8882,0,0,2},{64581,8884,0,0,2},{64582,
8886,0,0,2},{64583,8888,0,0,2},{64584,8890,0,0,2},{64585,8892,0,0,2},{64586,
8894,0,0,2},{64587,8896,0,0,2},{64588,8898,0,0,2},{64589,8900,0,0,2},{64590,
8902,0,0,2},{64591,8904,0,0,2},{64592,8906,0,0,2},{64593,8908,0,0,2},{64594,
8910,0,0,2},{64595,8912,0,0,2},{64596,8914,0,0,2},{64597,8916,0,0,2},{64598,
8918,0,0,2},{64599,8920,0,0,2},{64600,8922,0,0,2},{64601,8924,0,0,2},{64602,
8926,0,0,2},{64603,8928,0,0,2},{64604,8930,0,0,2},{64605,8932,0,0,2},{64606,
8934,0,0,2},{64607,8936,0,0,2},{64608,8938,0,0,2},{64609,8940,0,0,2},{64610,
8942,0,0,2},{64611,8944,0,0,2},{64612,8946,0,0,2},{64613,8948,0,0,2},{64614,
8950,0,0,2},{64615,8952,0,0,2},{64616,8954,0,0,2},{64617,8956,0,0,2},{64618,
8958,0,0,2},{64619,8960,0,0,2},{64620,8962,0,0,2},{64621,8964,0,0,2},{64622,
8966,0,0,2},{64623,8968,0,0,2},{64624,8970,0,0,2},{64625,8972,0,0,2},{64626,
8974,0,0,2},{64627,8976,0,0,2},{64628,8978,0,0,2},{64629,8980,0,0,2},{64630,
8982,0,0,2},{64631,8984,0,0,2},{64632,8986,0,0,2},{64633,8988,0,0,2},{64634,
8990,0,0,2},{64635,8992,0,0,2},{64636,8994,0,0,2},{64637,8996,0,0,2},{64638,
8998,0,0,2},{64639,9000,0,0,2},{64640,9002,0,0,2},{64641,9004,0,0,2},{64642,
9006,0,0,2},{64643,9008,0,0,2},{64644,9010,0,0,2},{64645,9012,0,0,2},{64646,
9014,0,0,2},{64647,9016,0,0,2},{64648,9018,0,0,2},{64649,9020,0,0,2},{64650,
9022,0,0,2},{64651,9024,0,0,2},{64652,9026,0,0,2},{64653,9028,0,0,2},{64654,
9030,0,0,2},{64655,9032,0,0,2},{64656,9034,0,0,2},{64657,9036,0,0,2},{64658,
9038,0,0,2},{64659,9040,0,0,2},{64660,9042,0,0,2},{64661,9044,0,0,2},{64662,
9046,0,0,2},{64663,9048,0,0,2},{64664,9050,0,0,2},{64665,9052,0,0,2},{64666,
9054,0,0,2},{64667,9056,0,0,2},{64668,9058,0,0,2},{64669,9060,0,0,2},{64670,
9062,0,0,2},{64671,9064,0,0,2},{64672,9066,0,0,2},{64673,9068,0,0,2},{64674,
9070,0,0,2},{64675,9072,0,0,2},{64676,9074,0,0,2},{64677,9076,0,0,2},{64678,
9078,0,0,2},{64679,9080,0,0,2},{64680,9082,0,0,2},{64681,9084,0,0,2},{64682,
9086,0,0,2},{64683,9088,0,0,2},{64684,9090,0,0,2},{64685,9092,0,0,2},{64686,
9094,0,0,2},{64687,9096,0,0,2},{64688,9098,0,0,2},{64689,9100,0,0,2},{64690,
9102,0,0,2},{64691,9104,0,0,2},{64692,9106,0,0,2},{64693,9108,0,0,2},{64694,
9110,0,0,2},{64695,9112,0,0,2},{64696,9114,0,0,2},{64697,9116,0,0,2},{64698,
9118,0,0,2},{64699,9120,0,0,2},{64700,9122,0,0,2},{64701,9124,0,0,2},{64702,
9126,0,0,2},{64703,9128,0,0,2},{64704,9130,0,0,2},{64705,9132,0,0,2},{64706,
9134,0,0,2},{64707,9136,0,0,2},{64708,9138,0,0,2},{64709,9140,0,0,2},{64710,
9142,0,0,2},{64711,9144,0,0,2},{64712,9146,0,0,2},{64713,9148,0,0,2},{64714,
9150,0,0,2},{64715,9152,0,0,2},{64716,9154,0,0,2},{64717,9156,0,0,2},{64718,
9158,0,0,2},{64719,9160,0,0,2},{64720,9162,0,0,2},{64721,9164,0,0,2},{64722,
9166,0,0,2},{64723,9168,0,0,2},{64724,9170,0,0,2},{64725,9172,0,0,2},{64726,
9174,0,0,2},{64727,9176,0,0,2},{64728,9178,0,0,2},{64729,9180,0,0,2},{64730,
9182,0,0,2},{64731,9184,0,0,2},{64732,9186,0,0,2},{64733,9188,0,0,2},{64734,
9190,0,0,2},{64735,9192,0,0,2},{64736,9194,0,0,2},{64737,9196,0,0,2},{64738,
9198,0,0,2},{64739,9200,0,0,2},{64740,9202,0,0,2},{64741,9204,0,0,2},{64742,
9206,0,0,2},{64743,9208,0,0,2},{64744,9210,0,0,2},{64745,9212,0,0,2},{64746,
9214,0,0,2},{64747,9216,0,0,2},{64748,9218,0,0,2},{64749,9220,0,0,2},{64750,
9222,0,0,2},{64751,9224,0,0,2},{64752,9226,0,0,2},{64753,9228,0,0,2},{64754,
9230,0,0,2},{64755,9232,0,0,2},{64756,9234,0,0,2},{64757,9236,0,0,2},{64758,
9238,0,0,2},{64759,9240,0,0,2},{64760,9242,0,0,2},{64761,9244,0,0,2},{64762,
9246,0,0,2},{64763,9248,0,0,2},{64764,9250,0,0,2},{64765,9252,0,0,2},{64766,
9254,0,0,2},{64767,9256,0,0,2},{64768,9258,0,0,2},{64769,9260,0,0,2},{64770,
9262,0,0,2},{64771,9264,0,0,2},{64772,9266,0,0,2},{64773,9268,0,0,2},{64774,
9270,0,0,2},{64775,9272,0,0,2},{64776,9274,0,0,2},{64777,9276,0,0,2},{64778,
9278,0,0,2},{64779,9280,0,0,2},{64780,9282,0,0,2},{64781,9284,0,0,2},{64782,
9286,0,0,2},{64783,9288,0,0,2},{64784,9290,0,0,2},{64785,9292,0,0,2},{64786,
9294,0,0,2},{64787,9296,0,0,2},{64788,9298,0,0,2},{64789,9300,0,0,2},{64790,
9302,0,0,2},{64791,9304,0,0,2},{64792,9306,0,0,2},{64793,9308,0,0,2},{64794,
9310,0,0,2},{64795,9312,0,0,2},{64796,9314,0,0,2},{64797,9316,0,0,2},{64798,
9318,0,0,2},{64799,9320,0,0,2},{64800,9322,0,0,2},{64801,9324,0,0,2},{64802,
9326,0,0,2},{64803,9328,0,0,2},{64804,9330,0,0,2},{64805,9332,0,0,2},{64806,
9334,0,0,2},{64807,9336,0,0,2},{64808,9338,0,0,2},{64809,9340,0,0,2},{64810,
9342,0,0,2},{64811,9344,0,0,2},{64812,9346,0,0,2},{64813,9348,0,0,2},{64814,
9350,0,0,2},{64815,9352,0,0,2},{64816,9354,0,0,2},{64817,9356,0,0,2},{64818,
9358,0,0,2},{64819,9360,0,0,2},{64820,9362,0,0,2},{64821,9364,0,0,2},{64822,
9366,0,0,2},{64823,9368,0,0,2},{64824,9370,0,0,2},{64825,9372,0,0,2},{64826,
9374,0,0,2},{64827,9376,0,0,2},{64828,9378,0,0,2},{64829,9380,0,0,2},{64848,
9382,0,0,3},{64849,9385,0,0,3},{64850,9388,0,0,3},{64851,9391,0,0,3},{64852,
9394,0,0,3},{64853,9397,0,0,3},{64854,9400,0,0,3},{64855,9403,0,0,3},{64856,
9406,0,0,3},{64857,9409,0,0,3},{64858,9412,0,0,3},{64859,9415,0,0,3},{64860,
9418,0,0,3},{64861,9421,0,0,3},{64862,9424,0,0,3},{64863,9427,0,0,3},{64864,
9430,0,0,3},{64865,9433,0,0,3},{64866,9436,0,0,3},{64867,9439,0,0,3},{64868,
9442,0,0,3},{64869,9445,0,0,3},{64870,9448,0,0,3},{64871,9451,0,0,3},{64872,
9454,0,0,3},{64873,9457,0,0,3},{64874,9460,0,0,3},{64875,9463,0,0,3},{64876,
9466,0,0,3},{64877,9469,0,0,3},{64878,9472,0,0,3},{64879,9475,0,0,3},{64880,
9478,0,0,3},{64881,9481,0,0,3},{64882,9484,0,0,3},{64883,9487,0,0,3},{64884,
9490,0,0,3},{64885,9493,0,0,3},{64886,9496,0,0,3},{64887,9499,0,0,3},{64888,
9502,0,0,3},{64889,9505,0,0,3},{64890,9508,0,0,3},{64891,9511,0,0,3},{64892,
9514,0,0,3},{64893,9517,0,0,3},{64894,9520,0,0,3},{64895,9523,0,0,3},{64896,
9526,0,0,3},{64897,9529,0,0,3},{64898,9532,0,0,3},{64899,9535,0,0,3},{64900,
9538,0,0,3},{64901,9541,0,0,3},{64902,9544,0,0,3},{64903,9547,0,0,3},{64904,
9550,0,0,3},{64905,9553,0,0,3},{64906,9556,0,0,3},{64907,9559,0,0,3},{64908,
9562,0,0,3},{64909,9565,0,0,3},{64910,9568,0,0,3},{64911,9571,0,0,3},{64914,
9574,0,0,3},{64915,9577,0,0,3},{64916,9580,0,0,3},{64917,9583,0,0,3},{64918,
9586,0,0,3},{64919,9589,0,0,3},{64920,9592,0,0,3},{64921,9595,0,0,3},{64922,
9598,0,0,3},{64923,9601,0,0,3},{64924,9604,0,0,3},{64925,9607,0,0,3},{64926,
9610,0,0,3},{64927,9613,0,0,3},{64928,9616,0,0,3},{64929,9619,0,0,3},{64930,
9622,0,0,3},{64931,9625,0,0,3},{64932,9628,0,0,3},{64933,9631,0,0,3},{64934,
9634,0,0,3},{64935,9637,0,0,3},{64936,9640,0,0,3},{64937,9643,0,0,3},{64938,
9646,0,0,3},{64939,9649,0,0,3},{64940,9652,0,0,3},{64941,9655,0,0,3},{64942,
9658,0,0,3},{64943,9661,0,0,3},{64944,9664,0,0,3},{64945,9667,0,0,3},{64946,
9670,0,0,3},{64947,9673,0,0,3},{64948,9676,0,0,3},{64949,9679,0,0,3},{64950,
9682,0,0,3},{64951,9685,0,0,3},{64952,9688,0,0,3},{64953,9691,0,0,3},{64954,
9694,0,0,3},{64955,9697,0,0,3},{64956,9700,0,0,3},{64957,9703,0,0,3},{64958,
9706,0,0,3},{64959,9709,0,0,3},{64960,9712,0,0,3},{64961,9715,0,0,3},{64962,
9718,0,0,3},{64963,9721,0,0,3},{64964,9724,0,0,3},{64965,9727,0,0,3},{64966,
9730,0,0,3},{64967,9733,0,0,3},{65008,9736,0,0,3},{65009,9739,0,0,3},{65010,
9742,0,0,4},{65011,9746,0,0,4},{65012,9750,0,0,4},{65013,9754,0,0,4},{65014,
9758,0,0,4},{65015,9762,0,0,4},{65016,9766,0,0,4},{65017,9770,0,0,3},{65018,
9773,0,0,18},{65019,9791,0,0,8},{65020,9799,0,0,4},{65049,9803,0,0,3},{65072,
9806,0,0,2},{65269,9808,0,0,2},{65270,9810,0,0,2},{65271,9812,0,0,2},{65272,
9814,0,0,2},{65273,9816,0,0,2},{65274,9818,0,0,2},{65275,9820,0,0,2},{65276,
9822,0,0,2},{67456,9824,0,0,2},{67459,9826,0,0,3},{67463,9829,0,0,2},{67464,
9831,0,0,2},{67465,9833,0,0,2},{67466,9835,0,0,2},{67472,9837,0,0,2},{67477,
9839,0,0,2},{67481,9841,0,0,2},{67482,9843,0,0,2},{67490,9845,0,0,2},{67499,
9847,0,0,2},{67500,9849,0,0,2},{67501,9851,0,0,2},{67502,9853,0,0,2},{67968,
9855,0,0,2},{67969,9857,0,0,2},{67970,9859,0,0,2},{67971,9861,0,0,2},{67972,
9863,0,0,2},{67973,9865,0,0,2},{67974,9867,0,0,2},{67975,9869,0,0,2},{67976,
9871,0,0,2},{67977,9873,0,0,2},{67978,9875,0,0,2},{67979,9877,0,0,2},{67980,
9879,0,0,2},{67981,9881,0,0,2},{67982,9883,0,0,2},{67983,9885,0,0,2},{67984,
9887,0,0,2},{67985,9889,0,0,2},{67986,9891,0,0,2},{67987,9893,0,0,2},{67988,
9895,0,0,2},{67989,9897,0,0,2},{67990,9899,0,0,2},{67991,9901,0,0,2},{67992,
9903,0,0,2},{67993,9905,0,0,2},{67994,9907,0,0,2},{67995,9909,0,0,2},{67996,
9911,0,0,2},{67997,9913,0,0,2},{68016,9915,0,0,2},{68296,9917,0,0,2},{68398,
9919,0,0,2},{68609,9921,0,0,2},{68612,9923,0,0,2},{68616,9925,0,0,2},{68618,
9927,0,0,2},{68620,9929,0,0,2},{68622,9931,0,0,2},{68624,9933,0,0,2},{68626,
9935,0,0,2},{68629,9937,0,0,2},{68631,9939,0,0,2},{68633,9941,0,0,2},{68635,
9943,0,0,2},{68637,9945,0,0,2},{68639,9947,0,0,2},{68645,9949,0,0,2},{68647,
9951,0,0,2},{68649,9953,0,0,2},{68651,9955,0,0,2},{68654,9957,0,0,2},{68659,
9959,0,0,2},{68661,9961,0,0,2},{68663,9963,0,0,2},{68665,9965,0,0,2},{68667,
9967,0,0,2},{68672,9969,0,0,2},{68674,9971,0,0,2},{68676,9973,0,0,2},{68678,
9975,0,0,2},{68737,9977,0,0,2},{68746,9979,0,0,2},{68747,9981,0,0,2},{68753,
9983,0,0,2},{68764,9985,0,0,2},{68766,9987,0,0,2},{68767,9989,0,0,2},{68771,
9991,0,0,2},{68779,9993,0,0,2},{68781,9995,0,0,2},{68801,9997,0,0,2},{68810,
9999,0,0,2},{68811,10001,0,0,2},{68817,10003,0,0,2},{68828,10005,0,0,2},{68830,
10007,0,0,2},{68831,10009,0,0,2},{68835,10011,0,0,2},{68843,10013,0,0,2},{68845,
10015,0,0,2},{69392,10017,0,0,2},{69395,10019,0,0,2},{69399,10021,0,0,2},{69404,
10023,0,0,2},{69415,10025,0,0,2},{69445,10027,0,0,2},{69622,10029,0,0,2},{69786,
10031,0,0,2},{69788,10033,0,0,2},{69803,10035,0,0,2},{71128,10037,0,0,2},{71129,
10039,0,0,2},{71130,10041,0,0,2},{71131,10043,0,0,2},{71132,10045,0,0,2},{71133,
10047,0,0,2},{71429,10049,0,0,2},{71446,10051,0,0,2},{71450,10053,0,0,2},{93844,
10055,0,0,2},{93845,10057,0,0,2},{93846,10059,0,0,2},{119127,0,4815,1,0},
{119128,0,4816,1,0},{119225,0,4822,1,0},{119226,0,4825,1,0},{122624,10096,0,0,
3},{122642,10099,0,0,2},{122647,10101,0,0,2},{122649,10103,0,0,2},{122652,10105,
0,0,2},{126129,10107,0,0,2},{126130,10109,0,0,2},{126255,10111,0,0,2},{126256,
10113,0,0,2},{126257,10115,0,0,2},{126258,10117,0,0,2},{126259,10119,0,0,2},
{126260,10121,0,0,2},{126261,10123,0,0,2},{126262,10125,0,0,2},{127232,10127,0,
0,2},{127233,10129,0,0,2},{127234,10131,0,0,2},{127235,10133,0,0,2},{127236,
10135,0,0,2},{127237,10137,0,0,2},{127238,10139,0,0,2},{127239,10141,0,0,2},
{127240,10143,0,0,2},{127241,10145,0,0,2},{127242,10147,0,0,2},{127248,10149,0,
0,3},{127249,10152,0,0,3},{127250,10155,0,0,3},{127251,10158,0,0,3},{127252,
10161,0,0,3},{127253,10164,0,0,3},{127254,10167,0,0,3},{127255,10170,0,0,3},
{127256,10173,0,0,3},{127257,10176,0,0,3},{127258,10179,0,0,3},{127259,10182,0,
0,3},{127260,10185,0,0,3},{127261,10188,0,0,3},{127262,10191,0,0,3},{127263,
10194,0,0,3},{127264,10197,0,0,3},{127265,10200,0,0,3},{127266,10203,0,0,3},
{127267,10206,0,0,3},{127268,10209,0,0,3},{127269,10212,0,0,3},{127270,10215,0,
0,3},{127271,10218,0,0,3},{127272,10221,0,0,3},{127273,10224,0,0,3},{127274,
10227,0,0,3},{127277,10230,0,0,2},{127278,10232,0,0,2},{127306,10234,0,0,2},
{127307,10236,0,0,2},{127308,10238,0,0,2},{127309,10240,0,0,2},{127310,10242,0,
0,3},{127311,10245,0,0,2},{127338,10247,0,0,2},{127339,10249,0,0,2},{127340,
10251,0,0,2},{127371,10253,0,0,2},{127372,10255,0,0,2},{127373,10257,0,0,2},
{127374,10259,0,0,2},{127375,10261,0,0,2},{127376,10263,0,0,2},{127377,10265,0,
0,2},{127378,10267,0,0,4},{127379,10271,0,0,4},{127380,10275,0,0,2},{127381,
10277,0,0,3},{127382,10280,0,0,2},{127383,10282,0,0,2},{127384,10284,0,0,3},
{127385,10287,0,0,3},{127386,10290,0,0,2},{127387,10292,0,0,2},{127388,10294,0,
0,7},{127389,10301,0,0,2},{127390,10303,0,0,2},{127391,10305,0,0,2},{127392,
10307,0,0,3},{127393,10310,0,0,3},{127394,10313,0,0,4},{127395,10317,0,0,3},
{127396,10320,0,0,4},{127398,10324,0,0,2},{127399,10326,0,0,3},{127400,10329,0,
0,6},{127401,10335,0,0,8},{127402,10343,0,0,3},{127403,10346,0,0,3},{127404,
10349,0,0,3},{127488,10352,0,0,2},{127489,10354,0,0,2},{127504,10356,0,0,2},
{127505,10358,0,0,2},{127506,10360,0,0,2},{127507,10362,0,0,2},{127508,10364,0,
0,2},{127509,10366,0,0,2},{127510,10368,0,0,2},{127511,10370,0,0,2},{127512,
10372,0,0,2},{127513,10374,0,0,2},{127514,10376,0,0,2},{127515,10378,0,0,2},
{127516,10380,0,0,2},{127517,10382,0,0,2},{127518,10384,0,0,2},{127519,10386,0,
0,2},{127520,10388,0,0,2},{127521,10390,0,0,2},{127522,10392,0,0,2},{127523,
10394,0,0,2},{127524,10396,0,0,2},{127525,10398,0,0,2},{127526,10400,0,0,2},
{127527,10402,0,0,2},{127528,10404,0,0,2},{127529,10406,0,0,2},{127530,10408,0,
0,2},{127531,10410,0,0,2},{127532,10412,0,0,2},{127533,10414,0,0,2},{127534,
10416,0,0,2},{127535,10418,0,0,2},{127536,10420,0,0,2},{127537,10422,0,0,2},
{127538,10424,0,0,2},{127539,10426,0,0,2},{127540,10428,0,0,2},{127541,10430,0,
0,2},{127542,10432,0,0,2},{127543,10434,0,0,2},{127544,10436,0,0,2},{127545,
10438,0,0,2},{127546,10440,0,0,2},{127547,10442,0,0,2},{127552,10444,0,0,4},
{127553,10448,0,0,4},{127554,10452,0,0,4},{127555,10456,0,0,4},{127556,10460,0,
0,4},{127557,10464,0,0,4},{127558,10468,0,0,4},{127559,10472,0,0,4},{127560,
10476,0,0,4},{127568,10480,0,0,2},{127569,10482,0,0,2},{131362,10484,0,0,2},
{132380,10486,0,0,2},{132389,10488,0,0,2},{132427,10490,0,0,2},{132666,10492,0,
0,2},{133124,10494,0,0,2},{133342,10496,0,0,2},{133676,10498,0,0,2},{133987,
10500,0,0,2},{136420,10502,0,0,2},{136872,10504,0,0,2},{136938,10506,0,0,2},
{137672,10508,0,0,2},{138008,10510,0,0,2},{138507,10512,0,0,2},{138724,10514,0,
0,2},{138726,10516,0,0,2},{139651,10518,0,0,2},{139679,10520,0,0,2},{140081,
10522,0,0,2},{141012,10524,0,0,2},{141380,10526,0,0,2},{141386,10528,0,0,2},
{142092,10530,0,0,2},{142321,10532,0,0,2},{143370,10534,0,0,2},{144056,10536,0,
0,2},{144223,10538,0,0,2},{144275,10540,0,0,2},{144284,10542,0,0,2},{144323,
10544,0,0,2},{144341,10546,0,0,2},{144493,10548,0,0,2},{145059,10550,0,0,2},
{145575,10552,0,0,2},{146061,10554,0,0,2},{146170,10556,0,0,2},{146620,10558,0,
0,2},{146718,10560,0,0,2},{147153,10562,0,0,2},{147294,10564,0,0,2},{147342,
10566,0,0,2},{148067,10568,0,0,2},{148206,10570,0,0,2},{148395,10572,0,0,2},
{149000,10574,0,0,2},{149301,10576,0,0,2},{149524,10578,0,0,2},{150582,10580,0,
0,2},{150674,10582,0,0,2},{151457,10584,0,0,2},{151480,10586,0,0,2},{151620,
10588,0,0,2},{151794,10590,0,0,2},{151795,10592,0,0,2},{151833,10594,0,0,2},
{151859,10596,0,0,2},{152137,10598,0,0,2},{152605,10600,0,0,2},{153126,10602,0,
0,2},{153242,10604,0,0,2},{153285,10606,0,0,2},{153980,10608,0,0,2},{154279,
10610,0,0,2},{154539,10612,0,0,2},{154752,10614,0,0,2},{154832,10616,0,0,2},
{155526,10618,0,0,2},{156122,10620,0,0,2},{156200,10622,0,0,2},{156231,10624,0,
0,2},{156377,10626,0,0,2},{156478,10628,0,0,2},{156890,10630,0,0,2},{156963,
10632,0,0,2},{157096,10634,0,0,2},{157607,10636,0,0,2},{157621,10638,0,0,2},
{158524,10640,0,0,2},{158774,10642,0,0,2},{158933,10644,0,0,2},{159083,10646,0,
0,2},{159532,10648,0,0,2},{159665,10650,0,0,2},{159954,10652,0,0,2},{160714,
10654,0,0,2},{161383,10656,0,0,2},{161966,10658,0,0,2},{162150,10660,0,0,2},
{162984,10662,0,0,2},{163539,10664,0,0,2},{163631,10666,0,0,2},{165330,10668,0,
0,2},{165357,10670,0,0,2},{165678,10672,0,0,2},{166906,10674,0,0,2},{167287,
10676,0,0,2},{168261,10678,0,0,2},{168415,10680,0,0,2},{168474,10682,0,0,2},
{168970,10684,0,0,2},{169110,10686,0,0,2},{169398,10688,0,0,2},{170800,10690,0,
0,2},{172238,10692,0,0,2},{172293,10694,0,0,2},{172558,10696,0,0,2},{172689,
10698,0,0,2},{172946,10700,0,0,2},{173568,10702,0,0,2},{183,0,0,0,2},{183,2,0,0,
2},{769,649,0,0,2},{1463,811,0,0,2},{1464,813,0,0,2},{1468,815,0,0,2},{1468,817,
0,0,2},{1471,819,0,0,2},{1468,821,0,0,2},{1468,823,0,0,2},{1468,825,0,0,2},
{1465,827,0,0,2},{1468,829,0,0,2},{1468,831,0,0,2},{1468,833,0,0,2},{1460,835,0,
0,2},{1468,837,0,0,2},{1468,839,0,0,2},{1468,841,0,0,2},{1471,843,0,0,2},{1468,
845,0,0,2},{1468,847,0,0,2},{1468,849,0,0,2},{1468,851,0,0,2},{1468,853,0,0,2},
{1468,855,0,0,2},{1471,857,0,0,2},{1468,859,0,0,2},{1468,861,0,0,2},{1468,863,0,
0,2},{1468,865,3895,2,2},{1473,867,0,0,3},{1474,870,0,0,3},{1473,873,0,0,2},
{1474,875,0,0,2},{1468,877,0,0,2},{1463,889,0,0,3},{2364,928,0,0,2},{2364,930,0,
0,2},{2364,932,0,0,2},{2364,934,0,0,2},{2364,936,0,0,2},{2364,938,0,0,2},{2364,
942,0,0,2},{2364,944,0,0,2},{2492,950,0,0,2},{2492,952,0,0,2},{2492,954,0,0,2},
{2620,958,0,0,2},{2620,960,0,0,2},{2620,962,0,0,2},{2620,964,0,0,2},{2620,966,0,
0,2},{2620,968,0,0,2},{2876,970,0,0,2},{2876,972,0,0,2},{3585,998,0,0,2},{3586,
1000,0,0,2},{3587,1002,0,0,2},{3588,1004,0,0,2},{3589,1006,0,0,2},{3590,1008,0,
0,2},{3591,1010,0,0,2},{3592,1012,0,0,2},{3593,1014,0,0,2},{3594,1016,0,0,2},
{3595,1018,0,0,2},{3596,1020,0,0,2},{3597,1022,0,0,2},{3598,1024,0,0,2},{3599,
1026,0,0,2},{3600,1028,0,0,2},{3601,1030,0,0,2},{3602,1032,0,0,2},{3603,1034,0,
0,2},{3604,1036,0,0,2},{3605,1038,0,0,2},{3606,1040,0,0,2},{3607,1042,0,0,2},
{3608,1044,0,0,2},{3609,1046,0,0,2},{3610,1048,0,0,2},{3611,1050,0,0,2},{3612,
1052,0,0,2},{3613,1054,0,0,2},{3614,1056,0,0,2},{3615,1058,0,0,2},{3616,1060,0,
0,2},{3617,1062,0,0,2},{3618,1064,0,0,2},{3619,1066,0,0,2},{3620,1068,0,0,2},
{3621,1070,0,0,2},{3622,1072,0,0,2},{3623,1074,0,0,2},{3624,1076,0,0,2},{3625,
1078,0,0,2},{3626,1080,0,0,2},{3627,1082,0,0,2},{3628,1084,0,0,2},{3629,1086,0,
0,2},{3630,1088,0,0,2},{3585,1090,0,0,2},{3586,1092,0,0,2},{3587,1094,0,0,2},
{3588,1096,0,0,2},{3589,1098,0,0,2},{3590,1100,0,0,2},{3591,1102,0,0,2},{3592,
1104,0,0,2},{3593,1106,0,0,2},{3594,1108,0,0,2},{3595,1110,0,0,2},{3596,1112,0,
0,2},{3597,1114,0,0,2},{3598,1116,0,0,2},{3599,1118,0,0,2},{3600,1120,0,0,2},
{3601,1122,0,0,2},{3602,1124,0,0,2},{3603,1126,0,0,2},{3604,1128,0,0,2},{3605,
1130,0,0,2},{3606,1132,0,0,2},{3607,1134,0,0,2},{3608,1136,0,0,2},{3609,1138,0,
0,2},{3610,1140,0,0,2},{3611,1142,0,0,2},{3612,1144,0,0,2},{3613,1146,0,0,2},
{3614,1148,0,0,2},{3615,1150,0,0,2},{3616,1152,0,0,2},{3617,1154,0,0,2},{3618,
1156,0,0,2},{3619,1158,0,0,2},{3620,1160,0,0,2},{3621,1162,0,0,2},{3622,1164,0,
0,2},{3623,1166,0,0,2},{3624,1168,0,0,2},{3625,1170,0,0,2},{3626,1172,0,0,2},
{3627,1174,0,0,2},{3628,1176,0,0,2},{3629,1178,0,0,2},{3630,1180,0,0,2},{3585,
1182,0,0,2},{3586,1184,0,0,2},{3587,1186,0,0,2},{3588,1188,0,0,2},{3589,1190,0,
0,2},{3590,1192,0,0,2},{3591,1194,0,0,2},{3592,1196,0,0,2},{3593,1198,0,0,2},
{3594,1200,0,0,2},{3595,1202,0,0,2},{3596,1204,0,0,2},{3597,1206,0,0,2},{3598,
1208,0,0,2},{3599,1210,0,0,2},{3600,1212,0,0,2},{3601,1214,0,0,2},{3602,1216,0,
0,2},{3603,1218,0,0,2},{3604,1220,0,0,2},{3605,1222,0,0,2},{3606,1224,0,0,2},
{3607,1226,0,0,2},{3608,1228,0,0,2},{3609,1230,0,0,2},{3610,1232,0,0,2},{3611,
1234,0,0,2},{3612,1236,0,0,2},{3613,1238,0,0,2},{3614,1240,0,0,2},{3615,1242,0,
0,2},{3616,1244,0,0,2},{3617,1246,0,0,2},{3618,1248,0,0,2},{3619,1250,0,0,2},
{3620,1252,0,0,2},{3621,1254,0,0,2},{3622,1256,0,0,2},{3623,1258,0,0,2},{3624,
1260,0,0,2},{3625,1262,0,0,2},{3626,1264,0,0,2},{3627,1266,0,0,2},{3628,1268,0,
0,2},{3629,1270,0,0,2},{3630,1272,0,0,2},{3585,1274,0,0,2},{3586,1276,0,0,2},
{3587,1278,0,0,2},{3588,1280,0,0,2},{3589,1282,0,0,2},{3590,1284,0,0,2},{3591,
1286,0,0,2},{3592,1288,0,0,2},{3593,1290,0,0,2},{3594,1292,0,0,2},{3595,1294,0,
0,2},{3596,1296,0,0,2},{3597,1298,0,0,2},{3598,1300,0,0,2},{3599,1302,0,0,2},
{3600,1304,0,0,2},{3601,1306,0,0,2},{3602,1308,0,0,2},{3603,1310,0,0,2},{3604,
1312,0,0,2},{3605,1314,0,0,2},{3606,1316,0,0,2},{3607,1318,0,0,2},{3608,1320,0,
0,2},{3609,1322,0,0,2},{3610,1324,0,0,2},{3611,1326,0,0,2},{3612,1328,0,0,2},
{3613,1330,0,0,2},{3614,1332,0,0,2},{3615,1334,0,0,2},{3616,1336,0,0,2},{3617,
1338,0,0,2},{3618,1340,0,0,2},{3619,1342,0,0,2},{3620,1344,0,0,2},{3621,1346,0,
0,2},{3622,1348,0,0,2},{3623,1350,0,0,2},{3624,1352,0,0,2},{3625,1354,0,0,2},
{3626,1356,0,0,2},{3627,1358,0,0,2},{3628,1360,0,0,2},{3629,1362,0,0,2},{3630,
1364,0,0,2},{3585,1366,0,0,2},{3586,1368,0,0,2},{3587,1370,0,0,2},{3588,1372,0,
0,2},{3589,1374,0,0,2},{3590,1376,0,0,2},{3591,1378,0,0,2},{3592,1380,0,0,2},
{3593,1382,0,0,2},{3594,1384,0,0,2},{3595,1386,0,0,2},{3596,1388,0,0,2},{3597,
1390,0,0,2},{3598,1392,0,0,2},{3599,1394,0,0,2},{3600,1396,0,0,2},{3601,1398,0,
0,2},{3602,1400,0,0,2},{3603,1402,0,0,2},{3604,1404,0,0,2},{3605,1406,0,0,2},
{3606,1408,0,0,2},{3607,1410,0,0,2},{3608,1412,0,0,2},{3609,1414,0,0,2},{3610,
1416,0,0,2},{3611,1418,0,0,2},{3612,1420,0,0,2},{3613,1422,0,0,2},{3614,1424,0,
0,2},{3615,1426,0,0,2},{3616,1428,0,0,2},{3617,1430,0,0,2},{3618,1432,0,0,2},
{3619,1434,0,0,2},{3620,1436,0,0,2},{3621,1438,0,0,2},{3622,1440,0,0,2},{3623,
1442,0,0,2},{3624,1444,0,0,2},{3625,1446,0,0,2},{3626,1448,0,0,2},{3627,1450,0,
0,2},{3628,1452,0,0,2},{3629,1454,0,0,2},{3630,1456,0,0,2},{3634,1458,0,0,1},
{3713,1459,0,0,2},{3714,1461,0,0,2},{3716,1463,0,0,2},{3718,1465,0,0,2},{3719,
1467,0,0,2},{3720,1469,0,0,2},{3721,1471,0,0,2},{3722,1473,0,0,2},{3724,1475,0,
0,2},{3725,1477,0,0,2},{3726,1479,0,0,2},{3727,1481,0,0,2},{3728,1483,0,0,2},
{3729,1485,0,0,2},{3730,1487,0,0,2},{3731,1489,0,0,2},{3732,1491,0,0,2},{3733,
1493,0,0,2},{3734,1495,0,0,2},{3735,1497,0,0,2},{3736,1499,0,0,2},{3737,1501,0,
0,2},{3738,1503,0,0,2},{3739,1505,0,0,2},{3740,1507,0,0,2},{3741,1509,0,0,2},
{3742,1511,0,0,2},{3743,1513,0,0,2},{3744,1515,0,0,2},{3745,1517,0,0,2},{3746,
1519,0,0,2},{3747,1521,0,0,2},{3749,1523,0,0,2},{3751,1525,0,0,2},{3752,1527,0,
0,2},{3753,1529,0,0,2},{3754,1531,0,0,2},{3755,1533,0,0,2},{3756,1535,0,0,2},
{3757,1537,0,0,2},{3758,1539,0,0,2},{3804,1541,0,0,3},{3805,1544,0,0,3},{3806,
1547,0,0,2},{3807,1549,0,0,2},{3713,1551,0,0,2},{3714,1553,0,0,2},{3716,1555,0,
0,2},{3718,1557,0,0,2},{3719,1559,0,0,2},{3720,1561,0,0,2},{3721,1563,0,0,2},
{3722,1565,0,0,2},{3724,1567,0,0,2},{3725,1569,0,0,2},{3726,1571,0,0,2},{3727,
1573,0,0,2},{3728,1575,0,0,2},{3729,1577,0,0,2},{3730,1579,0,0,2},{3731,1581,0,
0,2},{3732,1583,0,0,2},{3733,1585,0,0,2},{3734,1587,0,0,2},{3735,1589,0,0,2},
{3736,1591,0,0,2},{3737,1593,0,0,2},{3738,1595,0,0,2},{3739,1597,0,0,2},{3740,
1599,0,0,2},{3741,1601,0,0,2},{3742,1603,0,0,2},{3743,1605,0,0,2},{3744,1607,0,
0,2},{3745,1609,0,0,2},{3746,1611,0,0,2},{3747,1613,0,0,2},{3749,1615,0,0,2},
{3751,1617,0,0,2},{3752,1619,0,0,2},{3753,1621,0,0,2},{3754,1623,0,0,2},{3755,
1625,0,0,2},{3756,1627,0,0,2},{3757,1629,0,0,2},{3758,1631,0,0,2},{3804,1633,0,
0,3},{3805,1636,0,0,3},{3806,1639,0,0,2},{3807,1641,0,0,2},{3713,1643,0,0,2},
{3714,1645,0,0,2},{3716,1647,0,0,2},{3718,1649,0,0,2},{3719,1651,0,0,2},{3720,
1653,0,0,2},{3721,1655,0,0,2},{3722,1657,0,0,2},{3724,1659,0,0,2},{3725,1661,0,
0,2},{3726,1663,0,0,2},{3727,1665,0,0,2},{3728,1667,0,0,2},{3729,1669,0,0,2},
{3730,1671,0,0,2},{3731,1673,0,0,2},{3732,1675,0,0,2},{3733,1677,0,0,2},{3734,
1679,0,0,2},{3735,1681,0,0,2},{3736,1683,0,0,2},{3737,1685,0,0,2},{3738,1687,0,
0,2},{3739,1689,0,0,2},{3740,1691,0,0,2},{3741,1693,0,0,2},{3742,1695,0,0,2},
{3743,1697,0,0,2},{3744,1699,0,0,2},{3745,1701,0,0,2},{3746,1703,0,0,2},{3747,
1705,0,0,2},{3749,1707,0,0,2},{3751,1709,0,0,2},{3752,1711,0,0,2},{3753,1713,0,
0,2},{3754,1715,0,0,2},{3755,1717,0,0,2},{3756,1719,0,0,2},{3757,1721,0,0,2},
{3758,1723,0,0,2},{3804,1725,0,0,3},{3805,1728,0,0,3},{3806,1731,0,0,2},{3807,
1733,0,0,2},{3713,1735,0,0,2},{3714,1737,0,0,2},{3716,1739,0,0,2},{3718,1741,0,
0,2},{3719,1743,0,0,2},{3720,1745,0,0,2},{3721,1747,0,0,2},{3722,1749,0,0,2},
{3724,1751,0,0,2},{3725,1753,0,0,2},{3726,1755,0,0,2},{3727,1757,0,0,2},{3728,
1759,0,0,2},{3729,1761,0,0,2},{3730,1763,0,0,2},{3731,1765,0,0,2},{3732,1767,0,
0,2},{3733,1769,0,0,2},{3734,1771,0,0,2},{3735,1773,0,0,2},{3736,1775,0,0,2},
{3737,1777,0,0,2},{3738,1779,0,0,2},{3739,1781,0,0,2},{3740,1783,0,0,2},{3741,
1785,0,0,2},{3742,1787,0,0,2},{3743,1789,0,0,2},{3744,1791,0,0,2},{3745,1793,0,
0,2},{3746,1795,0,0,2},{3747,1797,0,0,2},{3749,1799,0,0,2},{3751,1801,0,0,2},
{3752,1803,0,0,2},{3753,1805,0,0,2},{3754,1807,0,0,2},{3755,1809,0,0,2},{3756,
1811,0,0,2},{3757,1813,0,0,2},{3758,1815,0,0,2},{3804,1817,0,0,3},{3805,1820,0,
0,3},{3806,1823,0,0,2},{3807,1825,0,0,2},{3713,1827,0,0,2},{3714,1829,0,0,2},
{3716,1831,0,0,2},{3718,1833,0,0,2},{3719,1835,0,0,2},{3720,1837,0,0,2},{3721,
1839,0,0,2},{3722,1841,0,0,2},{3724,1843,0,0,2},{3725,1845,0,0,2},{3726,1847,0,
0,2},{3727,1849,0,0,2},{3728,1851,0,0,2},{3729,1853,0,0,2},{3730,1855,0,0,2},
{3731,1857,0,0,2},{3732,1859,0,0,2},{3733,1861,0,0,2},{3734,1863,0,0,2},{3735,
1865,0,0,2},{3736,1867,0,0,2},{3737,1869,0,0,2},{3738,1871,0,0,2},{3739,1873,0,
0,2},{3740,1875,0,0,2},{3741,1877,0,0,2},{3742,1879,0,0,2},{3743,1881,0,0,2},
{3744,1883,0,0,2},{3745,1885,0,0,2},{3746,1887,0,0,2},{3747,1889,0,0,2},{3749,
1891,0,0,2},{3751,1893,0,0,2},{3752,1895,0,0,2},{3753,1897,0,0,2},{3754,1899,0,
0,2},{3755,1901,0,0,2},{3756,1903,0,0,2},{3757,1905,0,0,2},{3758,1907,0,0,2},
{3804,1909,0,0,3},{3805,1912,0,0,3},{3806,1915,0,0,2},{3807,1917,0,0,2},{3762,
1919,0,0,1},{4021,1927,0,0,2},{4023,1929,0,0,2},{4023,1931,0,0,2},{4023,1933,0,
0,2},{4023,1935,0,0,2},{4023,1937,0,0,2},{3954,1941,0,0,1},{3956,1942,0,0,1},
{3968,1943,0,0,1},{4021,1944,0,0,2},{4023,1946,0,0,2},{4023,1948,0,0,2},{4023,
1950,0,0,2},{4023,1952,0,0,2},{4023,1954,0,0,2},{3953,0,4393,1,0},{3968,1956,0,
0,1},{3968,1957,0,0,1},{3953,0,4396,1,0},{3968,1958,0,0,1},{3968,1959,0,0,1},
{6528,2055,0,0,2},{6529,2057,0,0,2},{6530,2059,0,0,2},{6531,2061,0,0,2},{6532,
2063,0,0,2},{6533,2065,0,0,2},{6534,2067,0,0,2},{6535,2069,0,0,2},{6536,2071,0,
0,2},{6537,2073,0,0,2},{6538,2075,0,0,2},{6539,2077,0,0,2},{6540,2079,0,0,2},
{6541,2081,0,0,2},{6542,2083,0,0,2},{6543,2085,0,0,2},{6544,2087,0,0,2},{6545,
2089,0,0,2},{6546,2091,0,0,2},{6547,2093,0,0,2},{6548,2095,0,0,2},{6549,2097,0,
0,2},{6550,2099,0,0,2},{6551,2101,0,0,2},{6552,2103,0,0,2},{6553,2105,0,0,2},
{6554,2107,0,0,2},{6555,2109,0,0,2},{6556,2111,0,0,2},{6557,2113,0,0,2},{6558,
2115,0,0,2},{6559,2117,0,0,2},{6560,2119,0,0,2},{6561,2121,0,0,2},{6562,2123,0,
0,2},{6563,2125,0,0,2},{6564,2127,0,0,2},{6565,2129,0,0,2},{6566,2131,0,0,2},
{6567,2133,0,0,2},{6568,2135,0,0,2},{6569,2137,0,0,2},{6570,2139,0,0,2},{6571,
2141,0,0,2},{6528,2143,0,0,2},{6529,2145,0,0,2},{6530,2147,0,0,2},{6531,2149,0,
0,2},{6532,2151,0,0,2},{6533,2153,0,0,2},{6534,2155,0,0,2},{6535,2157,0,0,2},
{6536,2159,0,0,2},{6537,2161,0,0,2},{6538,2163,0,0,2},{6539,2165,0,0,2},{6540,
2167,0,0,2},{6541,2169,0,0,2},{6542,2171,0,0,2},{6543,2173,0,0,2},{6544,2175,0,
0,2},{6545,2177,0,0,2},{6546,2179,0,0,2},{6547,2181,0,0,2},{6548,2183,0,0,2},
{6549,2185,0,0,2},{6550,2187,0,0,2},{6551,2189,0,0,2},{6552,2191,0,0,2},{6553,
2193,0,0,2},{6554,2195,0,0,2},{6555,2197,0,0,2},{6556,2199,0,0,2},{6557,2201,0,
0,2},{6558,2203,0,0,2},{6559,2205,0,0,2},{6560,2207,0,0,2},{6561,2209,0,0,2},
{6562,2211,0,0,2},{6563,2213,0,0,2},{6564,2215,0,0,2},{6565,2217,0,0,2},{6566,
2219,0,0,2},{6567,2221,0,0,2},{6568,2223,0,0,2},{6569,2225,0,0,2},{6570,2227,0,
0,2},{6571,2229,0,0,2},{6528,2231,0,0,2},{6529,2233,0,0,2},{6530,2235,0,0,2},
{6531,2237,0,0,2},{6532,2239,0,0,2},{6533,2241,0,0,2},{6534,2243,0,0,2},{6535,
2245,0,0,2},{6536,2247,0,0,2},{6537,2249,0,0,2},{6538,2251,0,0,2},{6539,2253,0,
0,2},{6540,2255,0,0,2},{6541,2257,0,0,2},{6542,2259,0,0,2},{6543,2261,0,0,2},
{6544,2263,0,0,2},{6545,2265,0,0,2},{6546,2267,0,0,2},{6547,2269,0,0,2},{6548,
2271,0,0,2},{6549,2273,0,0,2},{6550,2275,0,0,2},{6551,2277,0,0,2},{6552,2279,0,
0,2},{6553,2281,0,0,2},{6554,2283,0,0,2},{6555,2285,0,0,2},{6556,2287,0,0,2},
{6557,2289,0,0,2},{6558,2291,0,0,2},{6559,2293,0,0,2},{6560,2295,0,0,2},{6561,
2297,0,0,2},{6562,2299,0,0,2},{6563,2301,0,0,2},{6564,2303,0,0,2},{6565,2305,0,
0,2},{6566,2307,0,0,2},{6567,2309,0,0,2},{6568,2311,0,0,2},{6569,2313,0,0,2},
{6570,2315,0,0,2},{6571,2317,0,0,2},{6528,2319,0,0,2},{6529,2321,0,0,2},{6530,
2323,0,0,2},{6531,2325,0,0,2},{6532,2327,0,0,2},{6533,2329,0,0,2},{6534,2331,0,
0,2},{6535,2333,0,0,2},{6536,2335,0,0,2},{6537,2337,0,0,2},{6538,2339,0,0,2},
{6539,2341,0,0,2},{6540,2343,0,0,2},{6541,2345,0,0,2},{6542,2347,0,0,2},{6543,
2349,0,0,2},{6544,2351,0,0,2},{6545,2353,0,0,2},{6546,2355,0,0,2},{6547,2357,0,
0,2},{6548,2359,0,0,2},{6549,2361,0,0,2},{6550,2363,0,0,2},{6551,2365,0,0,2},
{6552,2367,0,0,2},{6553,2369,0,0,2},{6554,2371,0,0,2},{6555,2373,0,0,2},{6556,
2375,0,0,2},{6557,2377,0,0,2},{6558,2379,0,0,2},{6559,2381,0,0,2},{6560,2383,0,
0,2},{6561,2385,0,0,2},{6562,2387,0,0,2},{6563,2389,0,0,2},{6564,2391,0,0,2},
{6565,2393,0,0,2},{6566,2395,0,0,2},{6567,2397,0,0,2},{6568,2399,0,0,2},{6569,
2401,0,0,2},{6570,2403,0,0,2},{6571,2405,0,0,2},{824,4162,0,0,2},{43648,8163,0,
0,2},{43649,8165,0,0,2},{43650,8167,0,0,2},{43651,8169,0,0,2},{43652,8171,0,0,
2},{43653,8173,0,0,2},{43654,8175,0,0,2},{43655,8177,0,0,2},{43656,8179,0,0,2},
{43657,8181,0,0,2},{43658,8183,0,0,2},{43659,8185,0,0,2},{43660,8187,0,0,2},
{43661,8189,0,0,2},{43662,8191,0,0,2},{43663,8193,0,0,2},{43664,8195,0,0,2},
{43665,8197,0,0,2},{43666,8199,0,0,2},{43667,8201,0,0,2},{43668,8203,0,0,2},
{43669,8205,0,0,2},{43670,8207,0,0,2},{43671,8209,0,0,2},{43672,8211,0,0,2},
{43673,8213,0,0,2},{43674,8215,0,0,2},{43675,8217,0,0,2},{43676,8219,0,0,2},
{43677,8221,0,0,2},{43678,8223,0,0,2},{43679,8225,0,0,2},{43680,8227,0,0,2},
{43681,8229,0,0,2},{43682,8231,0,0,2},{43683,8233,0,0,2},{43684,8235,0,0,2},
{43685,8237,0,0,2},{43686,8239,0,0,2},{43687,8241,0,0,2},{43688,8243,0,0,2},
{43689,8245,0,0,2},{43690,8247,0,0,2},{43691,8249,0,0,2},{43692,8251,0,0,2},
{43693,8253,0,0,2},{43694,8255,0,0,2},{43695,8257,0,0,2},{43648,8259,0,0,2},
{43649,8261,0,0,2},{43650,8263,0,0,2},{43651,8265,0,0,2},{43652,8267,0,0,2},
{43653,8269,0,0,2},{43654,8271,0,0,2},{43655,8273,0,0,2},{43656,8275,0,0,2},
{43657,8277,0,0,2},{43658,8279,0,0,2},{43659,8281,0,0,2},{43660,8283,0,0,2},
{43661,8285,0,0,2},{43662,8287,0,0,2},{43663,8289,0,0,2},{43664,8291,0,0,2},
{43665,8293,0,0,2},{43666,8295,0,0,2},{43667,8297,0,0,2},{43668,8299,0,0,2},
{43669,8301,0,0,2},{43670,8303,0,0,2},{43671,8305,0,0,2},{43672,8307,0,0,2},
{43673,8309,0,0,2},{43674,8311,0,0,2},{43675,8313,0,0,2},{43676,8315,0,0,2},
{43677,8317,0,0,2},{43678,8319,0,0,2},{43679,8321,0,0,2},{43680,8323,0,0,2},
{43681,8325,0,0,2},{43682,8327,0,0,2},{43683,8329,0,0,2},{43684,8331,0,0,2},
{43685,8333,0,0,2},{43686,8335,0,0,2},{43687,8337,0,0,2},{43688,8339,0,0,2},
{43689,8341,0,0,2},{43690,8343,0,0,2},{43691,8345,0,0,2},{43692,8347,0,0,2},
{43693,8349,0,0,2},{43694,8351,0,0,2},{43695,8353,0,0,2},{43648,8355,0,0,2},
{43649,8357,0,0,2},{43650,8359,0,0,2},{43651,8361,0,0,2},{43652,8363,0,0,2},
{43653,8365,0,0,2},{43654,8367,0,0,2},{43655,8369,0,0,2},{43656,8371,0,0,2},
{43657,8373,0,0,2},{43658,8375,0,0,2},{43659,8377,0,0,2},{43660,8379,0,0,2},
{43661,8381,0,0,2},{43662,8383,0,0,2},{43663,8385,0,0,2},{43664,8387,0,0,2},
{43665,8389,0,0,2},{43666,8391,0,0,2},{43667,8393,0,0,2},{43668,8395,0,0,2},
{43669,8397,0,0,2},{43670,8399,0,0,2},{43671,8401,0,0,2},{43672,8403,0,0,2},
{43673,8405,0,0,2},{43674,8407,0,0,2},{43675,8409,0,0,2},{43676,8411,0,0,2},
{43677,8413,0,0,2},{43678,8415,0,0,2},{43679,8417,0,0,2},{43680,8419,0,0,2},
{43681,8421,0,0,2},{43682,8423,0,0,2},{43683,8425,0,0,2},{43684,8427,0,0,2},
{43685,8429,0,0,2},{43686,8431,0,0,2},{43687,8433,0,0,2},{43688,8435,0,0,2},
{43689,8437,0,0,2},{43690,8439,0,0,2},{43691,8441,0,0,2},{43692,8443,0,0,2},
{43693,8445,0,0,2},{43694,8447,0,0,2},{43695,8449,0,0,2},{43648,8451,0,0,2},
{43649,8453,0,0,2},{43650,8455,0,0,2},{43651,8457,0,0,2},{43652,8459,0,0,2},
{43653,8461,0,0,2},{43654,8463,0,0,2},{43655,8465,0,0,2},{43656,8467,0,0,2},
{43657,8469,0,0,2},{43658,8471,0,0,2},{43659,8473,0,0,2},{43660,8475,0,0,2},
{43661,8477,0,0,2},{43662,8479,0,0,2},{43663,8481,0,0,2},{43664,8483,0,0,2},
{43665,8485,0,0,2},{43666,8487,0,0,2},{43667,8489,0,0,2},{43668,8491,0,0,2},
{43669,8493,0,0,2},{43670,8495,0,0,2},{43671,8497,0,0,2},{43672,8499,0,0,2},
{43673,8501,0,0,2},{43674,8503,0,0,2},{43675,8505,0,0,2},{43676,8507,0,0,2},
{43677,8509,0,0,2},{43678,8511,0,0,2},{43679,8513,0,0,2},{43680,8515,0,0,2},
{43681,8517,0,0,2},{43682,8519,0,0,2},{43683,8521,0,0,2},{43684,8523,0,0,2},
{43685,8525,0,0,2},{43686,8527,0,0,2},{43687,8529,0,0,2},{43688,8531,0,0,2},
{43689,8533,0,0,2},{43690,8535,0,0,2},{43691,8537,0,0,2},{43692,8539,0,0,2},
{43693,8541,0,0,2},{43694,8543,0,0,2},{43695,8545,0,0,2},{43648,8547,0,0,2},
{43649,8549,0,0,2},{43650,8551,0,0,2},{43651,8553,0,0,2},{43652,8555,0,0,2},
{43653,8557,0,0,2},{43654,8559,0,0,2},{43655,8561,0,0,2},{43656,8563,0,0,2},
{43657,8565,0,0,2},{43658,8567,0,0,2},{43659,8569,0,0,2},{43660,8571,0,0,2},
{43661,8573,0,0,2},{43662,8575,0,0,2},{43663,8577,0,0,2},{43664,8579,0,0,2},
{43665,8581,0,0,2},{43666,8583,0,0,2},{43667,8585,0,0,2},{43668,8587,0,0,2},
{43669,8589,0,0,2},{43670,8591,0,0,2},{43671,8593,0,0,2},{43672,8595,0,0,2},
{43673,8597,0,0,2},{43674,8599,0,0,2},{43675,8601,0,0,2},{43676,8603,0,0,2},
{43677,8605,0,0,2},{43678,8607,0,0,2},{43679,8609,0,0,2},{43680,8611,0,0,2},
{43681,8613,0,0,2},{43682,8615,0,0,2},{43683,8617,0,0,2},{43684,8619,0,0,2},
{43685,8621,0,0,2},{43686,8623,0,0,2},{43687,8625,0,0,2},{43688,8627,0,0,2},
{43689,8629,0,0,2},{43690,8631,0,0,2},{43691,8633,0,0,2},{43692,8635,0,0,2},
{43693,8637,0,0,2},{43694,8639,0,0,2},{43695,8641,0,0,2},{119141,10061,0,0,2},
{119141,10063,4817,5,2},{119150,10065,0,0,3},{119151,10068,0,0,3},{119152,10071,
0,0,3},{119153,10074,0,0,3},{119154,10077,0,0,3},{119141,10080,4823,2,2},
{119150,10082,0,0,3},{119151,10085,0,0,3},{119141,10088,4826,2,2},{119150,10090,
0,0,3},{119151,10093,0,0,3}};

struct collation_key special_collation_keys[10704] = {
{8624,8,0,32},{0,2,0,280},{8624,2,0,32},{0,2,0,280},{8300,30,0,32},{1709,30,1,
32},{8303,30,0,32},{8300,30,0,32},{1709,30,1,32},{8301,30,0,32},{8302,30,0,32},
{1709,30,1,32},{8303,30,0,32},{8309,8,0,32},{0,2,0,37},{8309,8,0,32},{0,2,0,36},
{8309,8,0,32},{0,2,0,39},{8309,8,0,32},{0,2,0,45},{8309,8,0,32},{0,2,0,43},
{8309,8,0,32},{0,2,0,41},{8309,10,0,32},{0,4,0,280},{8411,10,0,32},{8361,8,0,
32},{0,2,0,48},{8411,8,0,32},{0,2,0,37},{8411,8,0,32},{0,2,0,36},{8411,8,0,32},
{0,2,0,39},{8411,8,0,32},{0,2,0,43},{8551,8,0,32},{0,2,0,37},{8551,8,0,32},{0,2,
0,36},{8551,8,0,32},{0,2,0,39},{8551,8,0,32},{0,2,0,43},{8383,10,0,32},{0,4,0,
280},{8695,8,0,32},{0,2,0,45},{8733,8,0,32},{0,2,0,37},{8733,8,0,32},{0,2,0,36},
{8733,8,0,32},{0,2,0,39},{8733,8,0,32},{0,2,0,45},{8733,8,0,32},{0,2,0,43},
{8733,8,0,32},{0,2,0,47},{8961,8,0,32},{0,2,0,37},{8961,8,0,32},{0,2,0,36},
{8961,8,0,32},{0,2,0,39},{8961,8,0,32},{0,2,0,43},{9049,8,0,32},{0,2,0,36},
{8886,4,0,32},{0,4,0,280},{8886,4,0,32},{8309,2,0,32},{0,2,0,37},{8309,2,0,32},
{0,2,0,36},{8309,2,0,32},{0,2,0,39},{8309,2,0,32},{0,2,0,45},{8309,2,0,32},{0,2,
0,43},{8309,2,0,32},{0,2,0,41},{8309,4,0,32},{0,4,0,280},{8411,4,0,32},{8361,2,
0,32},{0,2,0,48},{8411,2,0,32},{0,2,0,37},{8411,2,0,32},{0,2,0,36},{8411,2,0,
32},{0,2,0,39},{8411,2,0,32},{0,2,0,43},{8551,2,0,32},{0,2,0,37},{8551,2,0,32},
{0,2,0,36},{8551,2,0,32},{0,2,0,39},{8551,2,0,32},{0,2,0,43},{8383,4,0,32},{0,4,
0,280},{8695,2,0,32},{0,2,0,45},{8733,2,0,32},{0,2,0,37},{8733,2,0,32},{0,2,0,
36},{8733,2,0,32},{0,2,0,39},{8733,2,0,32},{0,2,0,45},{8733,2,0,32},{0,2,0,43},
{8733,2,0,32},{0,2,0,47},{8961,2,0,32},{0,2,0,37},{8961,2,0,32},{0,2,0,36},
{8961,2,0,32},{0,2,0,39},{8961,2,0,32},{0,2,0,43},{9049,2,0,32},{0,2,0,36},
{9049,2,0,32},{0,2,0,43},{8309,8,0,32},{0,2,0,50},{8309,2,0,32},{0,2,0,50},
{8309,8,0,32},{0,2,0,38},{8309,2,0,32},{0,2,0,38},{8309,8,0,32},{0,2,0,49},
{8309,2,0,32},{0,2,0,49},{8361,8,0,32},{0,2,0,36},{8361,2,0,32},{0,2,0,36},
{8361,8,0,32},{0,2,0,39},{8361,2,0,32},{0,2,0,39},{8361,8,0,32},{0,2,0,46},
{8361,2,0,32},{0,2,0,46},{8361,8,0,32},{0,2,0,40},{8361,2,0,32},{0,2,0,40},
{8383,8,0,32},{0,2,0,40},{8383,2,0,32},{0,2,0,40},{8383,8,0,32},{0,2,0,57},
{8383,2,0,32},{0,2,0,57},{8411,8,0,32},{0,2,0,50},{8411,2,0,32},{0,2,0,50},
{8411,8,0,32},{0,2,0,38},{8411,2,0,32},{0,2,0,38},{8411,8,0,32},{0,2,0,46},
{8411,2,0,32},{0,2,0,46},{8411,8,0,32},{0,2,0,49},{8411,2,0,32},{0,2,0,49},
{8411,8,0,32},{0,2,0,40},{8411,2,0,32},{0,2,0,40},{8485,8,0,32},{0,2,0,39},
{8485,2,0,32},{0,2,0,39},{8485,8,0,32},{0,2,0,38},{8485,2,0,32},{0,2,0,38},
{8485,8,0,32},{0,2,0,46},{8485,2,0,32},{0,2,0,46},{8485,8,0,32},{0,2,0,48},
{8485,2,0,32},{0,2,0,48},{8524,8,0,32},{0,2,0,39},{8524,2,0,32},{0,2,0,39},
{8524,8,0,32},{0,2,0,57},{8524,2,0,32},{0,2,0,57},{8551,8,0,32},{0,2,0,45},
{8551,2,0,32},{0,2,0,45},{8551,8,0,32},{0,2,0,50},{8551,2,0,32},{0,2,0,50},
{8551,8,0,32},{0,2,0,38},{8551,2,0,32},{0,2,0,38},{8551,8,0,32},{0,2,0,49},
{8551,2,0,32},{0,2,0,49},{8551,8,0,32},{0,2,0,46},{8551,10,0,32},{8579,10,0,32},
{8551,4,0,32},{8579,4,0,32},{8579,8,0,32},{0,2,0,39},{8579,2,0,32},{0,2,0,39},
{8604,8,0,32},{0,2,0,48},{8604,2,0,32},{0,2,0,48},{8624,8,0,32},{0,2,0,36},
{8624,2,0,32},{0,2,0,36},{8624,8,0,32},{0,2,0,48},{8624,2,0,32},{0,2,0,48},
{8624,8,0,32},{0,2,0,40},{8624,2,0,32},{0,2,0,40},{8624,8,0,32},{0,2,0,280},
{8624,2,0,32},{0,2,0,280},{8624,8,0,32},{0,2,0,57},{8624,2,0,32},{0,2,0,57},
{8695,8,0,32},{0,2,0,36},{8695,2,0,32},{0,2,0,36},{8695,8,0,32},{0,2,0,48},
{8695,2,0,32},{0,2,0,48},{8695,8,0,32},{0,2,0,40},{8695,2,0,32},{0,2,0,40},
{9167,4,0,32},{8695,4,0,32},{8733,8,0,32},{0,2,0,50},{8733,2,0,32},{0,2,0,50},
{8733,8,0,32},{0,2,0,38},{8733,2,0,32},{0,2,0,38},{8733,8,0,32},{0,2,0,44},
{8733,2,0,32},{0,2,0,44},{8733,10,0,32},{0,4,0,280},{8411,10,0,32},{8733,4,0,
32},{0,4,0,280},{8411,4,0,32},{8821,8,0,32},{0,2,0,36},{8821,2,0,32},{0,2,0,36},
{8821,8,0,32},{0,2,0,48},{8821,2,0,32},{0,2,0,48},{8821,8,0,32},{0,2,0,40},
{8821,2,0,32},{0,2,0,40},{8886,8,0,32},{0,2,0,36},{8886,2,0,32},{0,2,0,36},
{8886,8,0,32},{0,2,0,39},{8886,2,0,32},{0,2,0,39},{8886,8,0,32},{0,2,0,48},
{8886,2,0,32},{0,2,0,48},{8886,8,0,32},{0,2,0,40},{8886,2,0,32},{0,2,0,40},
{8927,8,0,32},{0,2,0,48},{8927,2,0,32},{0,2,0,48},{8927,8,0,32},{0,2,0,40},
{8927,2,0,32},{0,2,0,40},{8961,8,0,32},{0,2,0,45},{8961,2,0,32},{0,2,0,45},
{8961,8,0,32},{0,2,0,50},{8961,2,0,32},{0,2,0,50},{8961,8,0,32},{0,2,0,38},
{8961,2,0,32},{0,2,0,38},{8961,8,0,32},{0,2,0,41},{8961,2,0,32},{0,2,0,41},
{8961,8,0,32},{0,2,0,44},{8961,2,0,32},{0,2,0,44},{8961,8,0,32},{0,2,0,49},
{8961,2,0,32},{0,2,0,49},{9027,8,0,32},{0,2,0,39},{9027,2,0,32},{0,2,0,39},
{9049,8,0,32},{0,2,0,39},{9049,2,0,32},{0,2,0,39},{9049,8,0,32},{0,2,0,43},
{9071,8,0,32},{0,2,0,36},{9071,2,0,32},{0,2,0,36},{9071,8,0,32},{0,2,0,46},
{9071,2,0,32},{0,2,0,46},{9071,8,0,32},{0,2,0,40},{9071,2,0,32},{0,2,0,40},
{8886,4,0,32},{0,4,0,281},{9071,4,0,32},{9027,4,0,32},{8733,8,0,32},{0,2,0,63},
{8733,2,0,32},{0,2,0,63},{8961,8,0,32},{0,2,0,63},{8961,2,0,32},{0,2,0,63},
{8927,4,0,32},{8886,4,0,32},{8383,10,0,32},{9071,10,0,32},{0,4,0,40},{8383,10,0,
32},{9071,4,0,32},{0,4,0,40},{8383,4,0,32},{9071,4,0,32},{0,4,0,40},{8624,10,0,
32},{8579,10,0,32},{8624,10,0,32},{8579,4,0,32},{8624,4,0,32},{8579,4,0,32},
{8695,10,0,32},{8579,10,0,32},{8695,10,0,32},{8579,4,0,32},{8695,4,0,32},{8579,
4,0,32},{8309,8,0,32},{0,2,0,40},{8309,2,0,32},{0,2,0,40},{8551,8,0,32},{0,2,0,
40},{8551,2,0,32},{0,2,0,40},{8733,8,0,32},{0,2,0,40},{8733,2,0,32},{0,2,0,40},
{8961,8,0,32},{0,2,0,40},{8961,2,0,32},{0,2,0,40},{8961,8,0,32},{0,2,0,43},{0,2,
0,50},{8961,2,0,32},{0,2,0,43},{0,2,0,50},{8961,8,0,32},{0,2,0,43},{0,2,0,36},
{8961,2,0,32},{0,2,0,43},{0,2,0,36},{8961,8,0,32},{0,2,0,43},{0,2,0,40},{8961,2,
0,32},{0,2,0,43},{0,2,0,40},{8961,8,0,32},{0,2,0,43},{0,2,0,37},{8961,2,0,32},
{0,2,0,43},{0,2,0,37},{8309,8,0,32},{0,2,0,43},{0,2,0,50},{8309,2,0,32},{0,2,0,
43},{0,2,0,50},{8309,8,0,32},{0,2,0,46},{0,2,0,50},{8309,2,0,32},{0,2,0,46},{0,
2,0,50},{8309,10,0,32},{0,4,0,280},{8411,10,0,32},{0,2,0,50},{8309,4,0,32},{0,4,
0,280},{8411,4,0,32},{0,2,0,50},{8485,8,0,32},{0,2,0,40},{8485,2,0,32},{0,2,0,
40},{8604,8,0,32},{0,2,0,40},{8604,2,0,32},{0,2,0,40},{8733,8,0,32},{0,2,0,49},
{8733,2,0,32},{0,2,0,49},{8733,8,0,32},{0,2,0,49},{0,2,0,50},{8733,2,0,32},{0,2,
0,49},{0,2,0,50},{9100,8,0,32},{0,2,0,40},{9100,2,0,32},{0,2,0,40},{8579,2,0,
32},{0,2,0,40},{8383,10,0,32},{9071,10,0,32},{8383,10,0,32},{9071,4,0,32},{8383,
4,0,32},{9071,4,0,32},{8485,8,0,32},{0,2,0,36},{8485,2,0,32},{0,2,0,36},{8695,8,
0,32},{0,2,0,37},{8695,2,0,32},{0,2,0,37},{8309,8,0,32},{0,2,0,41},{0,2,0,36},
{8309,2,0,32},{0,2,0,41},{0,2,0,36},{8309,10,0,32},{0,4,0,280},{8411,10,0,32},
{0,2,0,36},{8309,4,0,32},{0,4,0,280},{8411,4,0,32},{0,2,0,36},{8733,8,0,32},{0,
2,0,47},{0,2,0,36},{8733,2,0,32},{0,2,0,47},{0,2,0,36},{8309,8,0,32},{0,2,0,60},
{8309,2,0,32},{0,2,0,60},{8309,8,0,32},{0,2,0,62},{8309,2,0,32},{0,2,0,62},
{8411,8,0,32},{0,2,0,60},{8411,2,0,32},{0,2,0,60},{8411,8,0,32},{0,2,0,62},
{8411,2,0,32},{0,2,0,62},{8551,8,0,32},{0,2,0,60},{8551,2,0,32},{0,2,0,60},
{8551,8,0,32},{0,2,0,62},{8551,2,0,32},{0,2,0,62},{8733,8,0,32},{0,2,0,60},
{8733,2,0,32},{0,2,0,60},{8733,8,0,32},{0,2,0,62},{8733,2,0,32},{0,2,0,62},
{8821,8,0,32},{0,2,0,60},{8821,2,0,32},{0,2,0,60},{8821,8,0,32},{0,2,0,62},
{8821,2,0,32},{0,2,0,62},{8961,8,0,32},{0,2,0,60},{8961,2,0,32},{0,2,0,60},
{8961,8,0,32},{0,2,0,62},{8961,2,0,32},{0,2,0,62},{8886,8,0,32},{0,2,0,69},
{8886,2,0,32},{0,2,0,69},{8927,8,0,32},{0,2,0,69},{8927,2,0,32},{0,2,0,69},
{8524,8,0,32},{0,2,0,40},{8524,2,0,32},{0,2,0,40},{8309,8,0,32},{0,2,0,46},
{8309,2,0,32},{0,2,0,46},{8411,8,0,32},{0,2,0,48},{8411,2,0,32},{0,2,0,48},
{8733,8,0,32},{0,2,0,43},{0,2,0,50},{8733,2,0,32},{0,2,0,43},{0,2,0,50},{8733,8,
0,32},{0,2,0,45},{0,2,0,50},{8733,2,0,32},{0,2,0,45},{0,2,0,50},{8733,8,0,32},
{0,2,0,46},{8733,2,0,32},{0,2,0,46},{8733,8,0,32},{0,2,0,46},{0,2,0,50},{8733,2,
0,32},{0,2,0,46},{0,2,0,50},{9049,8,0,32},{0,2,0,50},{9049,2,0,32},{0,2,0,50},
{8383,4,0,32},{8335,4,0,32},{8802,4,0,32},{8781,4,0,32},{8383,4,0,32},{9071,4,0,
32},{8383,4,0,32},{9100,4,0,32},{8383,4,0,32},{9090,4,0,32},{8927,4,0,32},{8886,
4,0,32},{8927,4,0,32},{8906,4,0,32},{8927,4,0,32},{8377,4,0,32},{8470,4,0,32},
{8726,4,0,32},{8624,4,0,32},{8886,4,0,32},{8624,4,0,32},{9071,4,0,32},{0,2,0,
43},{0,2,0,36},{1232,2,1,32},{0,2,0,36},{9229,8,0,32},{0,2,0,36},{9234,8,0,32},
{0,2,0,36},{9240,8,0,32},{0,2,0,36},{9242,8,0,32},{0,2,0,36},{9250,8,0,32},{0,2,
0,36},{9264,8,0,32},{0,2,0,36},{9269,8,0,32},{0,2,0,36},{9242,2,0,32},{0,2,0,
43},{0,2,0,36},{9242,8,0,32},{0,2,0,43},{9264,8,0,32},{0,2,0,43},{9229,2,0,32},
{0,2,0,36},{9234,2,0,32},{0,2,0,36},{9240,2,0,32},{0,2,0,36},{9242,2,0,32},{0,2,
0,36},{9264,2,0,32},{0,2,0,43},{0,2,0,36},{9242,2,0,32},{0,2,0,43},{9264,2,0,
32},{0,2,0,43},{9250,2,0,32},{0,2,0,36},{9264,2,0,32},{0,2,0,36},{9269,2,0,32},
{0,2,0,36},{9244,10,0,32},{9229,4,0,32},{9242,4,0,32},{9264,10,0,32},{0,2,0,36},
{9264,10,0,32},{0,2,0,43},{9244,4,0,32},{9229,4,0,32},{9242,4,0,32},{9390,8,0,
32},{0,2,0,37},{9390,8,0,32},{0,2,0,43},{9354,8,0,32},{0,2,0,36},{9436,8,0,32},
{0,2,0,43},{9450,8,0,32},{0,2,0,36},{9428,8,0,32},{0,2,0,37},{9585,8,0,32},{0,2,
0,38},{9390,2,0,32},{0,2,0,37},{9390,2,0,32},{0,2,0,43},{9354,2,0,32},{0,2,0,
36},{9436,2,0,32},{0,2,0,43},{9450,2,0,32},{0,2,0,36},{9428,2,0,32},{0,2,0,37},
{9585,2,0,32},{0,2,0,38},{9771,8,0,32},{0,2,0,60},{9771,2,0,32},{0,2,0,60},
{9354,10,0,32},{0,4,0,281},{9354,4,0,32},{0,4,0,281},{9398,8,0,32},{0,2,0,38},
{9398,2,0,32},{0,2,0,38},{9334,8,0,32},{0,2,0,38},{9334,2,0,32},{0,2,0,38},
{9334,8,0,32},{0,2,0,43},{9334,2,0,32},{0,2,0,43},{9390,8,0,32},{0,2,0,38},
{9390,2,0,32},{0,2,0,38},{9338,8,0,32},{0,2,0,43},{9338,2,0,32},{0,2,0,43},
{9398,8,0,32},{0,2,0,43},{9398,2,0,32},{0,2,0,43},{9408,8,0,32},{0,2,0,43},
{9408,2,0,32},{0,2,0,43},{9428,8,0,32},{0,2,0,50},{9428,2,0,32},{0,2,0,50},
{9428,8,0,32},{0,2,0,43},{9428,2,0,32},{0,2,0,43},{9531,8,0,32},{0,2,0,43},
{9531,2,0,32},{0,2,0,43},{9535,8,0,32},{0,2,0,43},{9535,2,0,32},{0,2,0,43},
{9721,8,0,32},{0,2,0,43},{9721,2,0,32},{0,2,0,43},{9585,8,0,32},{0,2,0,50},
{9585,2,0,32},{0,2,0,50},{9585,8,0,32},{0,2,0,43},{9585,2,0,32},{0,2,0,43},
{9585,8,0,32},{0,2,0,44},{9585,2,0,32},{0,2,0,44},{9656,8,0,32},{0,2,0,43},
{9656,2,0,32},{0,2,0,43},{9704,8,0,32},{0,2,0,43},{9704,2,0,32},{0,2,0,43},
{9962,4,0,32},{9992,4,0,32},{9998,2,0,32},{0,2,0,89},{9998,2,0,32},{0,2,0,90},
{9998,2,0,32},{0,2,0,95},{9999,2,0,32},{0,2,0,95},{9999,2,0,32},{0,2,0,96},
{10000,2,0,32},{0,2,0,95},{10001,2,0,32},{0,2,0,95},{10002,2,0,32},{0,2,0,95},
{10003,2,0,32},{0,2,0,91},{10003,2,0,32},{0,2,0,95},{10004,2,0,32},{0,2,0,95},
{10006,2,0,32},{0,2,0,95},{10007,2,0,32},{0,2,0,86},{10007,2,0,32},{0,2,0,95},
{10008,25,0,32},{0,2,0,95},{10008,2,0,32},{0,2,0,95},{10008,2,0,32},{0,2,0,96},
{10009,2,0,32},{0,2,0,95},{10010,2,0,32},{0,2,0,95},{10011,2,0,32},{0,2,0,95},
{10012,2,0,32},{0,2,0,95},{10014,25,0,32},{0,2,0,95},{10014,2,0,32},{0,2,0,95},
{10014,2,0,32},{0,2,0,96},{10015,2,0,32},{0,2,0,95},{10016,2,0,32},{0,2,0,95},
{10017,2,0,32},{0,2,0,95},{10018,2,0,32},{0,2,0,95},{10018,2,0,32},{0,2,0,95},
{0,2,0,94},{10018,2,0,32},{0,2,0,95},{0,2,0,93},{10018,2,0,32},{0,2,0,94},
{10018,2,0,32},{0,2,0,93},{10019,2,0,32},{0,2,0,95},{10007,4,0,32},{10002,4,0,
32},{10003,4,0,32},{10002,4,0,32},{10003,4,0,32},{10003,4,0,32},{10003,4,0,32},
{10007,4,0,32},{10007,4,0,32},{10007,4,0,32},{10007,4,0,32},{10007,4,0,32},{0,2,
0,89},{10068,4,0,32},{10082,4,0,32},{10068,4,0,32},{10271,4,0,32},{10068,4,0,
32},{10275,4,0,32},{10068,4,0,32},{10286,4,0,32},{10270,2,0,32},{0,2,0,131},
{10267,2,0,32},{0,2,0,131},{10300,2,0,32},{0,2,0,131},{10068,4,0,32},{0,4,0,
281},{10250,4,0,32},{0,4,0,281},{10306,4,0,32},{0,4,0,281},{10314,4,0,32},{0,4,
0,281},{10324,4,0,32},{0,4,0,281},{10305,4,0,32},{0,4,0,282},{10306,4,0,32},{0,
4,0,282},{10308,4,0,32},{0,4,0,282},{10429,4,0,32},{0,4,0,280},{10430,4,0,32},
{0,4,0,280},{10432,4,0,32},{0,4,0,280},{11015,2,0,32},{0,2,0,194},{11016,2,0,
32},{0,2,0,194},{11017,2,0,32},{0,2,0,194},{11023,2,0,32},{0,2,0,194},{11031,2,
0,32},{0,2,0,194},{11033,2,0,32},{0,2,0,194},{11039,2,0,32},{0,2,0,194},{11041,
2,0,32},{0,2,0,194},{11046,2,0,32},{0,2,0,194},{11048,2,0,32},{0,2,0,194},
{11050,2,0,32},{0,2,0,194},{11116,2,0,32},{0,2,0,194},{11117,2,0,32},{0,2,0,
194},{11129,2,0,32},{0,2,0,194},{11119,4,0,32},{11152,4,0,32},{11172,2,0,32},{0,
2,0,194},{11173,2,0,32},{0,2,0,194},{11178,2,0,32},{0,2,0,194},{11192,2,0,32},
{0,2,0,194},{11199,2,0,32},{0,2,0,194},{11168,2,0,32},{0,2,0,194},{11307,2,0,
32},{0,2,0,194},{11308,2,0,32},{0,2,0,194},{11435,4,0,32},{11469,4,0,32},{11507,
4,0,32},{11543,4,0,32},{11590,4,0,32},{11619,4,0,32},{11588,4,0,32},{11619,4,0,
32},{11589,4,0,32},{11619,4,0,32},{11598,4,0,32},{11619,4,0,32},{11577,4,0,32},
{11619,4,0,32},{11582,4,0,32},{11619,4,0,32},{11590,4,0,32},{11619,4,0,32},
{11591,4,0,32},{11619,4,0,32},{11597,4,0,32},{11619,4,0,32},{11563,4,0,32},
{11619,4,0,32},{13113,2,0,32},{13171,2,0,32},{13114,2,0,32},{13171,2,0,32},
{13115,2,0,32},{13171,2,0,32},{13116,2,0,32},{13171,2,0,32},{13117,2,0,32},
{13171,2,0,32},{13118,2,0,32},{13171,2,0,32},{13119,2,0,32},{13171,2,0,32},
{13120,2,0,32},{13171,2,0,32},{13121,2,0,32},{13171,2,0,32},{13122,2,0,32},
{13171,2,0,32},{13123,2,0,32},{13171,2,0,32},{13124,2,0,32},{13171,2,0,32},
{13125,2,0,32},{13171,2,0,32},{13126,2,0,32},{13171,2,0,32},{13127,2,0,32},
{13171,2,0,32},{13128,2,0,32},{13171,2,0,32},{13129,2,0,32},{13171,2,0,32},
{13130,2,0,32},{13171,2,0,32},{13131,2,0,32},{13171,2,0,32},{13132,2,0,32},
{13171,2,0,32},{13133,2,0,32},{13171,2,0,32},{13134,2,0,32},{13171,2,0,32},
{13135,2,0,32},{13171,2,0,32},{13136,2,0,32},{13171,2,0,32},{13137,2,0,32},
{13171,2,0,32},{13138,2,0,32},{13171,2,0,32},{13139,2,0,32},{13171,2,0,32},
{13140,2,0,32},{13171,2,0,32},{13141,2,0,32},{13171,2,0,32},{13142,2,0,32},
{13171,2,0,32},{13143,2,0,32},{13171,2,0,32},{13144,2,0,32},{13171,2,0,32},
{13145,2,0,32},{13171,2,0,32},{13146,2,0,32},{13171,2,0,32},{13147,2,0,32},
{13171,2,0,32},{13148,2,0,32},{13171,2,0,32},{13149,2,0,32},{13171,2,0,32},
{13150,2,0,32},{13171,2,0,32},{13151,2,0,32},{13171,2,0,32},{13152,2,0,32},
{13171,2,0,32},{13153,2,0,32},{13171,2,0,32},{13154,2,0,32},{13171,2,0,32},
{13155,2,0,32},{13171,2,0,32},{13156,2,0,32},{13171,2,0,32},{13157,2,0,32},
{13171,2,0,32},{13158,2,0,32},{13171,2,0,32},{13113,2,0,32},{13172,2,0,32},
{13114,2,0,32},{13172,2,0,32},{13115,2,0,32},{13172,2,0,32},{13116,2,0,32},
{13172,2,0,32},{13117,2,0,32},{13172,2,0,32},{13118,2,0,32},{13172,2,0,32},
{13119,2,0,32},{13172,2,0,32},{13120,2,0,32},{13172,2,0,32},{13121,2,0,32},
{13172,2,0,32},{13122,2,0,32},{13172,2,0,32},{13123,2,0,32},{13172,2,0,32},
{13124,2,0,32},{13172,2,0,32},{13125,2,0,32},{13172,2,0,32},{13126,2,0,32},
{13172,2,0,32},{13127,2,0,32},{13172,2,0,32},{13128,2,0,32},{13172,2,0,32},
{13129,2,0,32},{13172,2,0,32},{13130,2,0,32},{13172,2,0,32},{13131,2,0,32},
{13172,2,0,32},{13132,2,0,32},{13172,2,0,32},{13133,2,0,32},{13172,2,0,32},
{13134,2,0,32},{13172,2,0,32},{13135,2,0,32},{13172,2,0,32},{13136,2,0,32},
{13172,2,0,32},{13137,2,0,32},{13172,2,0,32},{13138,2,0,32},{13172,2,0,32},
{13139,2,0,32},{13172,2,0,32},{13140,2,0,32},{13172,2,0,32},{13141,2,0,32},
{13172,2,0,32},{13142,2,0,32},{13172,2,0,32},{13143,2,0,32},{13172,2,0,32},
{13144,2,0,32},{13172,2,0,32},{13145,2,0,32},{13172,2,0,32},{13146,2,0,32},
{13172,2,0,32},{13147,2,0,32},{13172,2,0,32},{13148,2,0,32},{13172,2,0,32},
{13149,2,0,32},{13172,2,0,32},{13150,2,0,32},{13172,2,0,32},{13151,2,0,32},
{13172,2,0,32},{13152,2,0,32},{13172,2,0,32},{13153,2,0,32},{13172,2,0,32},
{13154,2,0,32},{13172,2,0,32},{13155,2,0,32},{13172,2,0,32},{13156,2,0,32},
{13172,2,0,32},{13157,2,0,32},{13172,2,0,32},{13158,2,0,32},{13172,2,0,32},
{13113,2,0,32},{13173,2,0,32},{13114,2,0,32},{13173,2,0,32},{13115,2,0,32},
{13173,2,0,32},{13116,2,0,32},{13173,2,0,32},{13117,2,0,32},{13173,2,0,32},
{13118,2,0,32},{13173,2,0,32},{13119,2,0,32},{13173,2,0,32},{13120,2,0,32},
{13173,2,0,32},{13121,2,0,32},{13173,2,0,32},{13122,2,0,32},{13173,2,0,32},
{13123,2,0,32},{13173,2,0,32},{13124,2,0,32},{13173,2,0,32},{13125,2,0,32},
{13173,2,0,32},{13126,2,0,32},{13173,2,0,32},{13127,2,0,32},{13173,2,0,32},
{13128,2,0,32},{13173,2,0,32},{13129,2,0,32},{13173,2,0,32},{13130,2,0,32},
{13173,2,0,32},{13131,2,0,32},{13173,2,0,32},{13132,2,0,32},{13173,2,0,32},
{13133,2,0,32},{13173,2,0,32},{13134,2,0,32},{13173,2,0,32},{13135,2,0,32},
{13173,2,0,32},{13136,2,0,32},{13173,2,0,32},{13137,2,0,32},{13173,2,0,32},
{13138,2,0,32},{13173,2,0,32},{13139,2,0,32},{13173,2,0,32},{13140,2,0,32},
{13173,2,0,32},{13141,2,0,32},{13173,2,0,32},{13142,2,0,32},{13173,2,0,32},
{13143,2,0,32},{13173,2,0,32},{13144,2,0,32},{13173,2,0,32},{13145,2,0,32},
{13173,2,0,32},{13146,2,0,32},{13173,2,0,32},{13147,2,0,32},{13173,2,0,32},
{13148,2,0,32},{13173,2,0,32},{13149,2,0,32},{13173,2,0,32},{13150,2,0,32},
{13173,2,0,32},{13151,2,0,32},{13173,2,0,32},{13152,2,0,32},{13173,2,0,32},
{13153,2,0,32},{13173,2,0,32},{13154,2,0,32},{13173,2,0,32},{13155,2,0,32},
{13173,2,0,32},{13156,2,0,32},{13173,2,0,32},{13157,2,0,32},{13173,2,0,32},
{13158,2,0,32},{13173,2,0,32},{13113,2,0,32},{13174,2,0,32},{13114,2,0,32},
{13174,2,0,32},{13115,2,0,32},{13174,2,0,32},{13116,2,0,32},{13174,2,0,32},
{13117,2,0,32},{13174,2,0,32},{13118,2,0,32},{13174,2,0,32},{13119,2,0,32},
{13174,2,0,32},{13120,2,0,32},{13174,2,0,32},{13121,2,0,32},{13174,2,0,32},
{13122,2,0,32},{13174,2,0,32},{13123,2,0,32},{13174,2,0,32},{13124,2,0,32},
{13174,2,0,32},{13125,2,0,32},{13174,2,0,32},{13126,2,0,32},{13174,2,0,32},
{13127,2,0,32},{13174,2,0,32},{13128,2,0,32},{13174,2,0,32},{13129,2,0,32},
{13174,2,0,32},{13130,2,0,32},{13174,2,0,32},{13131,2,0,32},{13174,2,0,32},
{13132,2,0,32},{13174,2,0,32},{13133,2,0,32},{13174,2,0,32},{13134,2,0,32},
{13174,2,0,32},{13135,2,0,32},{13174,2,0,32},{13136,2,0,32},{13174,2,0,32},
{13137,2,0,32},{13174,2,0,32},{13138,2,0,32},{13174,2,0,32},{13139,2,0,32},
{13174,2,0,32},{13140,2,0,32},{13174,2,0,32},{13141,2,0,32},{13174,2,0,32},
{13142,2,0,32},{13174,2,0,32},{13143,2,0,32},{13174,2,0,32},{13144,2,0,32},
{13174,2,0,32},{13145,2,0,32},{13174,2,0,32},{13146,2,0,32},{13174,2,0,32},
{13147,2,0,32},{13174,2,0,32},{13148,2,0,32},{13174,2,0,32},{13149,2,0,32},
{13174,2,0,32},{13150,2,0,32},{13174,2,0,32},{13151,2,0,32},{13174,2,0,32},
{13152,2,0,32},{13174,2,0,32},{13153,2,0,32},{13174,2,0,32},{13154,2,0,32},
{13174,2,0,32},{13155,2,0,32},{13174,2,0,32},{13156,2,0,32},{13174,2,0,32},
{13157,2,0,32},{13174,2,0,32},{13158,2,0,32},{13174,2,0,32},{13113,2,0,32},
{13175,2,0,32},{13114,2,0,32},{13175,2,0,32},{13115,2,0,32},{13175,2,0,32},
{13116,2,0,32},{13175,2,0,32},{13117,2,0,32},{13175,2,0,32},{13118,2,0,32},
{13175,2,0,32},{13119,2,0,32},{13175,2,0,32},{13120,2,0,32},{13175,2,0,32},
{13121,2,0,32},{13175,2,0,32},{13122,2,0,32},{13175,2,0,32},{13123,2,0,32},
{13175,2,0,32},{13124,2,0,32},{13175,2,0,32},{13125,2,0,32},{13175,2,0,32},
{13126,2,0,32},{13175,2,0,32},{13127,2,0,32},{13175,2,0,32},{13128,2,0,32},
{13175,2,0,32},{13129,2,0,32},{13175,2,0,32},{13130,2,0,32},{13175,2,0,32},
{13131,2,0,32},{13175,2,0,32},{13132,2,0,32},{13175,2,0,32},{13133,2,0,32},
{13175,2,0,32},{13134,2,0,32},{13175,2,0,32},{13135,2,0,32},{13175,2,0,32},
{13136,2,0,32},{13175,2,0,32},{13137,2,0,32},{13175,2,0,32},{13138,2,0,32},
{13175,2,0,32},{13139,2,0,32},{13175,2,0,32},{13140,2,0,32},{13175,2,0,32},
{13141,2,0,32},{13175,2,0,32},{13142,2,0,32},{13175,2,0,32},{13143,2,0,32},
{13175,2,0,32},{13144,2,0,32},{13175,2,0,32},{13145,2,0,32},{13175,2,0,32},
{13146,2,0,32},{13175,2,0,32},{13147,2,0,32},{13175,2,0,32},{13148,2,0,32},
{13175,2,0,32},{13149,2,0,32},{13175,2,0,32},{13150,2,0,32},{13175,2,0,32},
{13151,2,0,32},{13175,2,0,32},{13152,2,0,32},{13175,2,0,32},{13153,2,0,32},
{13175,2,0,32},{13154,2,0,32},{13175,2,0,32},{13155,2,0,32},{13175,2,0,32},
{13156,2,0,32},{13175,2,0,32},{13157,2,0,32},{13175,2,0,32},{13158,2,0,32},
{13175,2,0,32},{13163,2,0,32},{13178,2,0,32},{13235,2,0,32},{13179,2,0,32},
{13235,2,0,32},{13180,2,0,32},{13235,2,0,32},{13181,2,0,32},{13235,2,0,32},
{13182,2,0,32},{13235,2,0,32},{13183,2,0,32},{13235,2,0,32},{13184,2,0,32},
{13235,2,0,32},{13186,2,0,32},{13235,2,0,32},{13187,2,0,32},{13235,2,0,32},
{13190,2,0,32},{13235,2,0,32},{13188,2,0,32},{13235,2,0,32},{13191,2,0,32},
{13235,2,0,32},{13192,2,0,32},{13235,2,0,32},{13193,2,0,32},{13235,2,0,32},
{13194,2,0,32},{13235,2,0,32},{13195,2,0,32},{13235,2,0,32},{13196,2,0,32},
{13235,2,0,32},{13197,2,0,32},{13235,2,0,32},{13198,2,0,32},{13235,2,0,32},
{13199,2,0,32},{13235,2,0,32},{13200,2,0,32},{13235,2,0,32},{13201,2,0,32},
{13235,2,0,32},{13202,2,0,32},{13235,2,0,32},{13203,2,0,32},{13235,2,0,32},
{13204,2,0,32},{13235,2,0,32},{13205,2,0,32},{13235,2,0,32},{13206,2,0,32},
{13235,2,0,32},{13207,2,0,32},{13235,2,0,32},{13208,2,0,32},{13235,2,0,32},
{13209,2,0,32},{13235,2,0,32},{13210,2,0,32},{13235,2,0,32},{13211,2,0,32},
{13235,2,0,32},{13212,2,0,32},{13235,2,0,32},{13213,2,0,32},{13235,2,0,32},
{13214,2,0,32},{13235,2,0,32},{13215,2,0,32},{13235,2,0,32},{13185,2,0,32},
{13235,2,0,32},{13216,2,0,32},{13235,2,0,32},{13217,2,0,32},{13235,2,0,32},
{13218,2,0,32},{13235,2,0,32},{13219,2,0,32},{13235,2,0,32},{13216,4,0,32},
{13201,4,0,32},{13235,2,0,32},{13216,4,0,32},{13209,4,0,32},{13235,2,0,32},
{13177,2,0,32},{13235,2,0,32},{13189,2,0,32},{13235,2,0,32},{13178,2,0,32},
{13236,2,0,32},{13179,2,0,32},{13236,2,0,32},{13180,2,0,32},{13236,2,0,32},
{13181,2,0,32},{13236,2,0,32},{13182,2,0,32},{13236,2,0,32},{13183,2,0,32},
{13236,2,0,32},{13184,2,0,32},{13236,2,0,32},{13186,2,0,32},{13236,2,0,32},
{13187,2,0,32},{13236,2,0,32},{13190,2,0,32},{13236,2,0,32},{13188,2,0,32},
{13236,2,0,32},{13191,2,0,32},{13236,2,0,32},{13192,2,0,32},{13236,2,0,32},
{13193,2,0,32},{13236,2,0,32},{13194,2,0,32},{13236,2,0,32},{13195,2,0,32},
{13236,2,0,32},{13196,2,0,32},{13236,2,0,32},{13197,2,0,32},{13236,2,0,32},
{13198,2,0,32},{13236,2,0,32},{13199,2,0,32},{13236,2,0,32},{13200,2,0,32},
{13236,2,0,32},{13201,2,0,32},{13236,2,0,32},{13202,2,0,32},{13236,2,0,32},
{13203,2,0,32},{13236,2,0,32},{13204,2,0,32},{13236,2,0,32},{13205,2,0,32},
{13236,2,0,32},{13206,2,0,32},{13236,2,0,32},{13207,2,0,32},{13236,2,0,32},
{13208,2,0,32},{13236,2,0,32},{13209,2,0,32},{13236,2,0,32},{13210,2,0,32},
{13236,2,0,32},{13211,2,0,32},{13236,2,0,32},{13212,2,0,32},{13236,2,0,32},
{13213,2,0,32},{13236,2,0,32},{13214,2,0,32},{13236,2,0,32},{13215,2,0,32},
{13236,2,0,32},{13185,2,0,32},{13236,2,0,32},{13216,2,0,32},{13236,2,0,32},
{13217,2,0,32},{13236,2,0,32},{13218,2,0,32},{13236,2,0,32},{13219,2,0,32},
{13236,2,0,32},{13216,4,0,32},{13201,4,0,32},{13236,2,0,32},{13216,4,0,32},
{13209,4,0,32},{13236,2,0,32},{13177,2,0,32},{13236,2,0,32},{13189,2,0,32},
{13236,2,0,32},{13178,2,0,32},{13237,2,0,32},{13179,2,0,32},{13237,2,0,32},
{13180,2,0,32},{13237,2,0,32},{13181,2,0,32},{13237,2,0,32},{13182,2,0,32},
{13237,2,0,32},{13183,2,0,32},{13237,2,0,32},{13184,2,0,32},{13237,2,0,32},
{13186,2,0,32},{13237,2,0,32},{13187,2,0,32},{13237,2,0,32},{13190,2,0,32},
{13237,2,0,32},{13188,2,0,32},{13237,2,0,32},{13191,2,0,32},{13237,2,0,32},
{13192,2,0,32},{13237,2,0,32},{13193,2,0,32},{13237,2,0,32},{13194,2,0,32},
{13237,2,0,32},{13195,2,0,32},{13237,2,0,32},{13196,2,0,32},{13237,2,0,32},
{13197,2,0,32},{13237,2,0,32},{13198,2,0,32},{13237,2,0,32},{13199,2,0,32},
{13237,2,0,32},{13200,2,0,32},{13237,2,0,32},{13201,2,0,32},{13237,2,0,32},
{13202,2,0,32},{13237,2,0,32},{13203,2,0,32},{13237,2,0,32},{13204,2,0,32},
{13237,2,0,32},{13205,2,0,32},{13237,2,0,32},{13206,2,0,32},{13237,2,0,32},
{13207,2,0,32},{13237,2,0,32},{13208,2,0,32},{13237,2,0,32},{13209,2,0,32},
{13237,2,0,32},{13210,2,0,32},{13237,2,0,32},{13211,2,0,32},{13237,2,0,32},
{13212,2,0,32},{13237,2,0,32},{13213,2,0,32},{13237,2,0,32},{13214,2,0,32},
{13237,2,0,32},{13215,2,0,32},{13237,2,0,32},{13185,2,0,32},{13237,2,0,32},
{13216,2,0,32},{13237,2,0,32},{13217,2,0,32},{13237,2,0,32},{13218,2,0,32},
{13237,2,0,32},{13219,2,0,32},{13237,2,0,32},{13216,4,0,32},{13201,4,0,32},
{13237,2,0,32},{13216,4,0,32},{13209,4,0,32},{13237,2,0,32},{13177,2,0,32},
{13237,2,0,32},{13189,2,0,32},{13237,2,0,32},{13178,2,0,32},{13238,2,0,32},
{13179,2,0,32},{13238,2,0,32},{13180,2,0,32},{13238,2,0,32},{13181,2,0,32},
{13238,2,0,32},{13182,2,0,32},{13238,2,0,32},{13183,2,0,32},{13238,2,0,32},
{13184,2,0,32},{13238,2,0,32},{13186,2,0,32},{13238,2,0,32},{13187,2,0,32},
{13238,2,0,32},{13190,2,0,32},{13238,2,0,32},{13188,2,0,32},{13238,2,0,32},
{13191,2,0,32},{13238,2,0,32},{13192,2,0,32},{13238,2,0,32},{13193,2,0,32},
{13238,2,0,32},{13194,2,0,32},{13238,2,0,32},{13195,2,0,32},{13238,2,0,32},
{13196,2,0,32},{13238,2,0,32},{13197,2,0,32},{13238,2,0,32},{13198,2,0,32},
{13238,2,0,32},{13199,2,0,32},{13238,2,0,32},{13200,2,0,32},{13238,2,0,32},
{13201,2,0,32},{13238,2,0,32},{13202,2,0,32},{13238,2,0,32},{13203,2,0,32},
{13238,2,0,32},{13204,2,0,32},{13238,2,0,32},{13205,2,0,32},{13238,2,0,32},
{13206,2,0,32},{13238,2,0,32},{13207,2,0,32},{13238,2,0,32},{13208,2,0,32},
{13238,2,0,32},{13209,2,0,32},{13238,2,0,32},{13210,2,0,32},{13238,2,0,32},
{13211,2,0,32},{13238,2,0,32},{13212,2,0,32},{13238,2,0,32},{13213,2,0,32},
{13238,2,0,32},{13214,2,0,32},{13238,2,0,32},{13215,2,0,32},{13238,2,0,32},
{13185,2,0,32},{13238,2,0,32},{13216,2,0,32},{13238,2,0,32},{13217,2,0,32},
{13238,2,0,32},{13218,2,0,32},{13238,2,0,32},{13219,2,0,32},{13238,2,0,32},
{13216,4,0,32},{13201,4,0,32},{13238,2,0,32},{13216,4,0,32},{13209,4,0,32},
{13238,2,0,32},{13177,2,0,32},{13238,2,0,32},{13189,2,0,32},{13238,2,0,32},
{13178,2,0,32},{13239,2,0,32},{13179,2,0,32},{13239,2,0,32},{13180,2,0,32},
{13239,2,0,32},{13181,2,0,32},{13239,2,0,32},{13182,2,0,32},{13239,2,0,32},
{13183,2,0,32},{13239,2,0,32},{13184,2,0,32},{13239,2,0,32},{13186,2,0,32},
{13239,2,0,32},{13187,2,0,32},{13239,2,0,32},{13190,2,0,32},{13239,2,0,32},
{13188,2,0,32},{13239,2,0,32},{13191,2,0,32},{13239,2,0,32},{13192,2,0,32},
{13239,2,0,32},{13193,2,0,32},{13239,2,0,32},{13194,2,0,32},{13239,2,0,32},
{13195,2,0,32},{13239,2,0,32},{13196,2,0,32},{13239,2,0,32},{13197,2,0,32},
{13239,2,0,32},{13198,2,0,32},{13239,2,0,32},{13199,2,0,32},{13239,2,0,32},
{13200,2,0,32},{13239,2,0,32},{13201,2,0,32},{13239,2,0,32},{13202,2,0,32},
{13239,2,0,32},{13203,2,0,32},{13239,2,0,32},{13204,2,0,32},{13239,2,0,32},
{13205,2,0,32},{13239,2,0,32},{13206,2,0,32},{13239,2,0,32},{13207,2,0,32},
{13239,2,0,32},{13208,2,0,32},{13239,2,0,32},{13209,2,0,32},{13239,2,0,32},
{13210,2,0,32},{13239,2,0,32},{13211,2,0,32},{13239,2,0,32},{13212,2,0,32},
{13239,2,0,32},{13213,2,0,32},{13239,2,0,32},{13214,2,0,32},{13239,2,0,32},
{13215,2,0,32},{13239,2,0,32},{13185,2,0,32},{13239,2,0,32},{13216,2,0,32},
{13239,2,0,32},{13217,2,0,32},{13239,2,0,32},{13218,2,0,32},{13239,2,0,32},
{13219,2,0,32},{13239,2,0,32},{13216,4,0,32},{13201,4,0,32},{13239,2,0,32},
{13216,4,0,32},{13209,4,0,32},{13239,2,0,32},{13177,2,0,32},{13239,2,0,32},
{13189,2,0,32},{13239,2,0,32},{13224,2,0,32},{13216,4,0,32},{13201,4,0,32},
{13216,4,0,32},{13209,4,0,32},{13377,4,0,32},{13400,4,0,32},{0,4,0,196},{13307,
2,0,32},{13372,2,0,32},{13312,2,0,32},{13376,2,0,32},{13328,2,0,32},{13376,2,0,
32},{13336,2,0,32},{13376,2,0,32},{13344,2,0,32},{13376,2,0,32},{13352,2,0,32},
{13376,2,0,32},{13364,4,0,32},{0,4,0,281},{13389,2,0,32},{13393,2,0,32},{13391,
2,0,32},{13308,2,0,32},{13372,2,0,32},{13313,2,0,32},{13376,2,0,32},{13329,2,0,
32},{13376,2,0,32},{13337,2,0,32},{13376,2,0,32},{13345,2,0,32},{13376,2,0,32},
{13353,2,0,32},{13376,2,0,32},{13395,2,0,32},{13394,2,0,32},{13397,2,0,32},
{13396,2,0,32},{13355,4,0,32},{0,4,0,281},{13363,4,0,32},{0,4,0,281},{13365,4,0,
32},{0,4,0,281},{14062,4,0,32},{14119,4,0,32},{14062,4,0,32},{15722,4,0,32},{0,
4,0,280},{15723,4,0,32},{0,4,0,280},{15723,4,0,32},{0,4,0,281},{15724,4,0,32},
{0,4,0,280},{15725,4,0,32},{0,4,0,280},{15725,4,0,32},{0,4,0,281},{15725,4,0,
32},{0,4,0,282},{15725,4,0,32},{0,4,0,283},{15730,4,0,32},{0,4,0,280},{15730,4,
0,32},{0,4,0,281},{15730,4,0,32},{0,4,0,282},{15730,4,0,32},{0,4,0,283},{15734,
4,0,32},{0,4,0,280},{15734,4,0,32},{0,4,0,281},{15734,4,0,32},{0,4,0,282},
{15735,4,0,32},{0,4,0,280},{15735,4,0,32},{0,4,0,281},{15736,4,0,32},{0,4,0,
280},{15738,4,0,32},{0,4,0,280},{15739,4,0,32},{0,4,0,280},{15743,4,0,32},{0,4,
0,280},{15743,4,0,32},{0,4,0,282},{15743,4,0,32},{0,4,0,283},{15743,4,0,32},{0,
4,0,284},{15745,4,0,32},{0,4,0,280},{15745,4,0,32},{0,4,0,281},{15746,4,0,32},
{0,4,0,280},{15746,4,0,32},{0,4,0,281},{15741,4,0,32},{0,4,0,280},{15749,4,0,
32},{0,4,0,280},{15749,4,0,32},{0,4,0,281},{15750,4,0,32},{0,4,0,280},{15751,4,
0,32},{0,4,0,280},{15767,4,0,32},{0,4,0,280},{15767,4,0,32},{0,4,0,281},{15733,
4,0,32},{0,4,0,280},{15743,4,0,32},{0,4,0,281},{15739,4,0,32},{15750,4,0,32},
{15749,4,0,32},{0,4,0,280},{15749,4,0,32},{0,4,0,280},{15724,4,0,32},{15724,4,0,
32},{13694,4,0,32},{13724,4,0,32},{13697,4,0,32},{13725,4,0,32},{14339,2,0,32},
{14388,2,0,32},{14340,2,0,32},{14388,2,0,32},{14341,2,0,32},{14388,2,0,32},
{14342,2,0,32},{14388,2,0,32},{14343,2,0,32},{14388,2,0,32},{14344,2,0,32},
{14388,2,0,32},{14345,2,0,32},{14388,2,0,32},{14346,2,0,32},{14388,2,0,32},
{14347,2,0,32},{14388,2,0,32},{14348,2,0,32},{14388,2,0,32},{14349,2,0,32},
{14388,2,0,32},{14350,2,0,32},{14388,2,0,32},{14351,2,0,32},{14388,2,0,32},
{14352,2,0,32},{14388,2,0,32},{14353,2,0,32},{14388,2,0,32},{14354,2,0,32},
{14388,2,0,32},{14355,2,0,32},{14388,2,0,32},{14356,2,0,32},{14388,2,0,32},
{14357,2,0,32},{14388,2,0,32},{14358,2,0,32},{14388,2,0,32},{14359,2,0,32},
{14388,2,0,32},{14360,2,0,32},{14388,2,0,32},{14361,2,0,32},{14388,2,0,32},
{14362,2,0,32},{14388,2,0,32},{14363,2,0,32},{14388,2,0,32},{14364,2,0,32},
{14388,2,0,32},{14365,2,0,32},{14388,2,0,32},{14366,2,0,32},{14388,2,0,32},
{14367,2,0,32},{14388,2,0,32},{14368,2,0,32},{14388,2,0,32},{14369,2,0,32},
{14388,2,0,32},{14370,2,0,32},{14388,2,0,32},{14371,2,0,32},{14388,2,0,32},
{14372,2,0,32},{14388,2,0,32},{14373,2,0,32},{14388,2,0,32},{14374,2,0,32},
{14388,2,0,32},{14375,2,0,32},{14388,2,0,32},{14376,2,0,32},{14388,2,0,32},
{14377,2,0,32},{14388,2,0,32},{14378,2,0,32},{14388,2,0,32},{14379,2,0,32},
{14388,2,0,32},{14380,2,0,32},{14388,2,0,32},{14381,2,0,32},{14388,2,0,32},
{14382,2,0,32},{14388,2,0,32},{14339,2,0,32},{14389,2,0,32},{14340,2,0,32},
{14389,2,0,32},{14341,2,0,32},{14389,2,0,32},{14342,2,0,32},{14389,2,0,32},
{14343,2,0,32},{14389,2,0,32},{14344,2,0,32},{14389,2,0,32},{14345,2,0,32},
{14389,2,0,32},{14346,2,0,32},{14389,2,0,32},{14347,2,0,32},{14389,2,0,32},
{14348,2,0,32},{14389,2,0,32},{14349,2,0,32},{14389,2,0,32},{14350,2,0,32},
{14389,2,0,32},{14351,2,0,32},{14389,2,0,32},{14352,2,0,32},{14389,2,0,32},
{14353,2,0,32},{14389,2,0,32},{14354,2,0,32},{14389,2,0,32},{14355,2,0,32},
{14389,2,0,32},{14356,2,0,32},{14389,2,0,32},{14357,2,0,32},{14389,2,0,32},
{14358,2,0,32},{14389,2,0,32},{14359,2,0,32},{14389,2,0,32},{14360,2,0,32},
{14389,2,0,32},{14361,2,0,32},{14389,2,0,32},{14362,2,0,32},{14389,2,0,32},
{14363,2,0,32},{14389,2,0,32},{14364,2,0,32},{14389,2,0,32},{14365,2,0,32},
{14389,2,0,32},{14366,2,0,32},{14389,2,0,32},{14367,2,0,32},{14389,2,0,32},
{14368,2,0,32},{14389,2,0,32},{14369,2,0,32},{14389,2,0,32},{14370,2,0,32},
{14389,2,0,32},{14371,2,0,32},{14389,2,0,32},{14372,2,0,32},{14389,2,0,32},
{14373,2,0,32},{14389,2,0,32},{14374,2,0,32},{14389,2,0,32},{14375,2,0,32},
{14389,2,0,32},{14376,2,0,32},{14389,2,0,32},{14377,2,0,32},{14389,2,0,32},
{14378,2,0,32},{14389,2,0,32},{14379,2,0,32},{14389,2,0,32},{14380,2,0,32},
{14389,2,0,32},{14381,2,0,32},{14389,2,0,32},{14382,2,0,32},{14389,2,0,32},
{14339,2,0,32},{14390,2,0,32},{14340,2,0,32},{14390,2,0,32},{14341,2,0,32},
{14390,2,0,32},{14342,2,0,32},{14390,2,0,32},{14343,2,0,32},{14390,2,0,32},
{14344,2,0,32},{14390,2,0,32},{14345,2,0,32},{14390,2,0,32},{14346,2,0,32},
{14390,2,0,32},{14347,2,0,32},{14390,2,0,32},{14348,2,0,32},{14390,2,0,32},
{14349,2,0,32},{14390,2,0,32},{14350,2,0,32},{14390,2,0,32},{14351,2,0,32},
{14390,2,0,32},{14352,2,0,32},{14390,2,0,32},{14353,2,0,32},{14390,2,0,32},
{14354,2,0,32},{14390,2,0,32},{14355,2,0,32},{14390,2,0,32},{14356,2,0,32},
{14390,2,0,32},{14357,2,0,32},{14390,2,0,32},{14358,2,0,32},{14390,2,0,32},
{14359,2,0,32},{14390,2,0,32},{14360,2,0,32},{14390,2,0,32},{14361,2,0,32},
{14390,2,0,32},{14362,2,0,32},{14390,2,0,32},{14363,2,0,32},{14390,2,0,32},
{14364,2,0,32},{14390,2,0,32},{14365,2,0,32},{14390,2,0,32},{14366,2,0,32},
{14390,2,0,32},{14367,2,0,32},{14390,2,0,32},{14368,2,0,32},{14390,2,0,32},
{14369,2,0,32},{14390,2,0,32},{14370,2,0,32},{14390,2,0,32},{14371,2,0,32},
{14390,2,0,32},{14372,2,0,32},{14390,2,0,32},{14373,2,0,32},{14390,2,0,32},
{14374,2,0,32},{14390,2,0,32},{14375,2,0,32},{14390,2,0,32},{14376,2,0,32},
{14390,2,0,32},{14377,2,0,32},{14390,2,0,32},{14378,2,0,32},{14390,2,0,32},
{14379,2,0,32},{14390,2,0,32},{14380,2,0,32},{14390,2,0,32},{14381,2,0,32},
{14390,2,0,32},{14382,2,0,32},{14390,2,0,32},{14339,2,0,32},{14393,2,0,32},
{14340,2,0,32},{14393,2,0,32},{14341,2,0,32},{14393,2,0,32},{14342,2,0,32},
{14393,2,0,32},{14343,2,0,32},{14393,2,0,32},{14344,2,0,32},{14393,2,0,32},
{14345,2,0,32},{14393,2,0,32},{14346,2,0,32},{14393,2,0,32},{14347,2,0,32},
{14393,2,0,32},{14348,2,0,32},{14393,2,0,32},{14349,2,0,32},{14393,2,0,32},
{14350,2,0,32},{14393,2,0,32},{14351,2,0,32},{14393,2,0,32},{14352,2,0,32},
{14393,2,0,32},{14353,2,0,32},{14393,2,0,32},{14354,2,0,32},{14393,2,0,32},
{14355,2,0,32},{14393,2,0,32},{14356,2,0,32},{14393,2,0,32},{14357,2,0,32},
{14393,2,0,32},{14358,2,0,32},{14393,2,0,32},{14359,2,0,32},{14393,2,0,32},
{14360,2,0,32},{14393,2,0,32},{14361,2,0,32},{14393,2,0,32},{14362,2,0,32},
{14393,2,0,32},{14363,2,0,32},{14393,2,0,32},{14364,2,0,32},{14393,2,0,32},
{14365,2,0,32},{14393,2,0,32},{14366,2,0,32},{14393,2,0,32},{14367,2,0,32},
{14393,2,0,32},{14368,2,0,32},{14393,2,0,32},{14369,2,0,32},{14393,2,0,32},
{14370,2,0,32},{14393,2,0,32},{14371,2,0,32},{14393,2,0,32},{14372,2,0,32},
{14393,2,0,32},{14373,2,0,32},{14393,2,0,32},{14374,2,0,32},{14393,2,0,32},
{14375,2,0,32},{14393,2,0,32},{14376,2,0,32},{14393,2,0,32},{14377,2,0,32},
{14393,2,0,32},{14378,2,0,32},{14393,2,0,32},{14379,2,0,32},{14393,2,0,32},
{14380,2,0,32},{14393,2,0,32},{14381,2,0,32},{14393,2,0,32},{14382,2,0,32},
{14393,2,0,32},{14367,4,0,32},{14389,4,0,32},{14367,4,0,32},{14389,4,0,32},
{14400,4,0,32},{14447,4,0,32},{14485,4,0,32},{14447,4,0,32},{8485,4,0,32},{0,4,
0,281},{8821,4,0,32},{0,4,0,281},{8927,4,0,32},{0,4,0,281},{14578,4,0,32},
{14624,4,0,32},{14580,4,0,32},{8309,20,0,32},{0,20,0,280},{8411,20,0,32},{8485,
4,0,32},{0,4,0,281},{8927,4,0,32},{0,4,0,280},{8524,4,0,32},{8383,20,0,32},{0,
20,0,280},{8309,4,0,32},{0,4,0,280},{8309,4,0,32},{0,4,0,280},{8411,4,0,32},
{8309,4,0,32},{8733,4,0,32},{8309,4,0,32},{9009,4,0,32},{8361,4,0,32},{0,4,0,
48},{8383,4,0,32},{0,4,0,281},{8383,4,0,32},{0,4,0,280},{8821,4,0,32},{0,4,0,
282},{8886,4,0,32},{0,4,0,281},{8733,4,0,32},{0,4,0,52},{8961,4,0,32},{0,4,0,
52},{8309,4,0,32},{0,4,0,43},{8733,4,0,32},{0,4,0,43},{8961,4,0,32},{0,4,0,43},
{8309,8,0,32},{0,2,0,68},{8309,2,0,32},{0,2,0,68},{8335,8,0,32},{0,2,0,46},
{8335,2,0,32},{0,2,0,46},{8335,8,0,32},{0,2,0,66},{8335,2,0,32},{0,2,0,66},
{8335,8,0,32},{0,2,0,73},{8335,2,0,32},{0,2,0,73},{8361,8,0,32},{0,2,0,48},{0,2,
0,36},{8361,2,0,32},{0,2,0,48},{0,2,0,36},{8383,8,0,32},{0,2,0,46},{8383,2,0,
32},{0,2,0,46},{8383,8,0,32},{0,2,0,66},{8383,2,0,32},{0,2,0,66},{8383,8,0,32},
{0,2,0,73},{8383,2,0,32},{0,2,0,73},{8383,8,0,32},{0,2,0,48},{8383,2,0,32},{0,2,
0,48},{8383,8,0,32},{0,2,0,70},{8383,2,0,32},{0,2,0,70},{8411,8,0,32},{0,2,0,
50},{0,2,0,37},{8411,2,0,32},{0,2,0,50},{0,2,0,37},{8411,8,0,32},{0,2,0,50},{0,
2,0,36},{8411,2,0,32},{0,2,0,50},{0,2,0,36},{8411,8,0,32},{0,2,0,70},{8411,2,0,
32},{0,2,0,70},{8411,8,0,32},{0,2,0,72},{8411,2,0,32},{0,2,0,72},{8411,8,0,32},
{0,2,0,48},{0,2,0,38},{8411,2,0,32},{0,2,0,48},{0,2,0,38},{8470,8,0,32},{0,2,0,
46},{8470,2,0,32},{0,2,0,46},{8485,8,0,32},{0,2,0,50},{8485,2,0,32},{0,2,0,50},
{8524,8,0,32},{0,2,0,46},{8524,2,0,32},{0,2,0,46},{8524,8,0,32},{0,2,0,66},
{8524,2,0,32},{0,2,0,66},{8524,8,0,32},{0,2,0,43},{8524,2,0,32},{0,2,0,43},
{8524,8,0,32},{0,2,0,48},{8524,2,0,32},{0,2,0,48},{8524,8,0,32},{0,2,0,71},
{8524,2,0,32},{0,2,0,71},{8551,8,0,32},{0,2,0,72},{8551,2,0,32},{0,2,0,72},
{8551,8,0,32},{0,2,0,43},{0,2,0,36},{8551,2,0,32},{0,2,0,43},{0,2,0,36},{8604,8,
0,32},{0,2,0,36},{8604,2,0,32},{0,2,0,36},{8604,8,0,32},{0,2,0,66},{8604,2,0,
32},{0,2,0,66},{8604,8,0,32},{0,2,0,73},{8604,2,0,32},{0,2,0,73},{8624,8,0,32},
{0,2,0,66},{8624,2,0,32},{0,2,0,66},{8624,8,0,32},{0,2,0,66},{0,2,0,50},{8624,2,
0,32},{0,2,0,66},{0,2,0,50},{8624,8,0,32},{0,2,0,73},{8624,2,0,32},{0,2,0,73},
{8624,8,0,32},{0,2,0,70},{8624,2,0,32},{0,2,0,70},{8680,8,0,32},{0,2,0,36},
{8680,2,0,32},{0,2,0,36},{8680,8,0,32},{0,2,0,46},{8680,2,0,32},{0,2,0,46},
{8680,8,0,32},{0,2,0,66},{8680,2,0,32},{0,2,0,66},{8695,8,0,32},{0,2,0,46},
{8695,2,0,32},{0,2,0,46},{8695,8,0,32},{0,2,0,66},{8695,2,0,32},{0,2,0,66},
{8695,8,0,32},{0,2,0,73},{8695,2,0,32},{0,2,0,73},{8695,8,0,32},{0,2,0,70},
{8695,2,0,32},{0,2,0,70},{8733,8,0,32},{0,2,0,45},{0,2,0,36},{8733,2,0,32},{0,2,
0,45},{0,2,0,36},{8733,8,0,32},{0,2,0,45},{0,2,0,43},{8733,2,0,32},{0,2,0,45},
{0,2,0,43},{8733,8,0,32},{0,2,0,50},{0,2,0,37},{8733,2,0,32},{0,2,0,50},{0,2,0,
37},{8733,8,0,32},{0,2,0,50},{0,2,0,36},{8733,2,0,32},{0,2,0,50},{0,2,0,36},
{8781,8,0,32},{0,2,0,36},{8781,2,0,32},{0,2,0,36},{8781,8,0,32},{0,2,0,46},
{8781,2,0,32},{0,2,0,46},{8821,8,0,32},{0,2,0,46},{8821,2,0,32},{0,2,0,46},
{8821,8,0,32},{0,2,0,66},{8821,2,0,32},{0,2,0,66},{8821,8,0,32},{0,2,0,66},{0,2,
0,50},{8821,2,0,32},{0,2,0,66},{0,2,0,50},{8821,8,0,32},{0,2,0,73},{8821,2,0,
32},{0,2,0,73},{8886,8,0,32},{0,2,0,46},{8886,2,0,32},{0,2,0,46},{8886,8,0,32},
{0,2,0,66},{8886,2,0,32},{0,2,0,66},{8886,8,0,32},{0,2,0,36},{0,2,0,46},{8886,2,
0,32},{0,2,0,36},{0,2,0,46},{8886,8,0,32},{0,2,0,40},{0,2,0,46},{8886,2,0,32},
{0,2,0,40},{0,2,0,46},{8886,8,0,32},{0,2,0,66},{0,2,0,46},{8886,2,0,32},{0,2,0,
66},{0,2,0,46},{8927,8,0,32},{0,2,0,46},{8927,2,0,32},{0,2,0,46},{8927,8,0,32},
{0,2,0,66},{8927,2,0,32},{0,2,0,66},{8927,8,0,32},{0,2,0,73},{8927,2,0,32},{0,2,
0,73},{8927,8,0,32},{0,2,0,70},{8927,2,0,32},{0,2,0,70},{8961,8,0,32},{0,2,0,
67},{8961,2,0,32},{0,2,0,67},{8961,8,0,32},{0,2,0,72},{8961,2,0,32},{0,2,0,72},
{8961,8,0,32},{0,2,0,70},{8961,2,0,32},{0,2,0,70},{8961,8,0,32},{0,2,0,45},{0,2,
0,36},{8961,2,0,32},{0,2,0,45},{0,2,0,36},{8961,8,0,32},{0,2,0,50},{0,2,0,43},
{8961,2,0,32},{0,2,0,50},{0,2,0,43},{9009,8,0,32},{0,2,0,45},{9009,2,0,32},{0,2,
0,45},{9009,8,0,32},{0,2,0,66},{9009,2,0,32},{0,2,0,66},{9027,8,0,32},{0,2,0,
37},{9027,2,0,32},{0,2,0,37},{9027,8,0,32},{0,2,0,36},{9027,2,0,32},{0,2,0,36},
{9027,8,0,32},{0,2,0,43},{9027,2,0,32},{0,2,0,43},{9027,8,0,32},{0,2,0,46},
{9027,2,0,32},{0,2,0,46},{9027,8,0,32},{0,2,0,66},{9027,2,0,32},{0,2,0,66},
{9037,8,0,32},{0,2,0,46},{9037,2,0,32},{0,2,0,46},{9037,8,0,32},{0,2,0,43},
{9037,2,0,32},{0,2,0,43},{9049,8,0,32},{0,2,0,46},{9049,2,0,32},{0,2,0,46},
{9071,8,0,32},{0,2,0,39},{9071,2,0,32},{0,2,0,39},{9071,8,0,32},{0,2,0,66},
{9071,2,0,32},{0,2,0,66},{9071,8,0,32},{0,2,0,73},{9071,2,0,32},{0,2,0,73},
{8524,2,0,32},{0,2,0,73},{8927,2,0,32},{0,2,0,43},{9027,2,0,32},{0,2,0,41},
{9049,2,0,32},{0,2,0,41},{8309,4,0,32},{9169,4,0,32},{8886,4,0,32},{0,4,0,281},
{0,2,0,46},{8886,10,0,32},{0,4,0,280},{8886,10,0,32},{8309,8,0,32},{0,2,0,66},
{8309,2,0,32},{0,2,0,66},{8309,8,0,32},{0,2,0,59},{8309,2,0,32},{0,2,0,59},
{8309,8,0,32},{0,2,0,39},{0,2,0,36},{8309,2,0,32},{0,2,0,39},{0,2,0,36},{8309,8,
0,32},{0,2,0,39},{0,2,0,37},{8309,2,0,32},{0,2,0,39},{0,2,0,37},{8309,8,0,32},
{0,2,0,39},{0,2,0,59},{8309,2,0,32},{0,2,0,39},{0,2,0,59},{8309,8,0,32},{0,2,0,
39},{0,2,0,45},{8309,2,0,32},{0,2,0,39},{0,2,0,45},{8309,8,0,32},{0,2,0,66},{0,
2,0,39},{8309,2,0,32},{0,2,0,66},{0,2,0,39},{8309,8,0,32},{0,2,0,38},{0,2,0,36},
{8309,2,0,32},{0,2,0,38},{0,2,0,36},{8309,8,0,32},{0,2,0,38},{0,2,0,37},{8309,2,
0,32},{0,2,0,38},{0,2,0,37},{8309,8,0,32},{0,2,0,38},{0,2,0,59},{8309,2,0,32},
{0,2,0,38},{0,2,0,59},{8309,8,0,32},{0,2,0,38},{0,2,0,45},{8309,2,0,32},{0,2,0,
38},{0,2,0,45},{8309,8,0,32},{0,2,0,66},{0,2,0,38},{8309,2,0,32},{0,2,0,66},{0,
2,0,38},{8411,8,0,32},{0,2,0,66},{8411,2,0,32},{0,2,0,66},{8411,8,0,32},{0,2,0,
59},{8411,2,0,32},{0,2,0,59},{8411,8,0,32},{0,2,0,45},{8411,2,0,32},{0,2,0,45},
{8411,8,0,32},{0,2,0,39},{0,2,0,36},{8411,2,0,32},{0,2,0,39},{0,2,0,36},{8411,8,
0,32},{0,2,0,39},{0,2,0,37},{8411,2,0,32},{0,2,0,39},{0,2,0,37},{8411,8,0,32},
{0,2,0,39},{0,2,0,59},{8411,2,0,32},{0,2,0,39},{0,2,0,59},{8411,8,0,32},{0,2,0,
39},{0,2,0,45},{8411,2,0,32},{0,2,0,39},{0,2,0,45},{8411,8,0,32},{0,2,0,66},{0,
2,0,39},{8411,2,0,32},{0,2,0,66},{0,2,0,39},{8551,8,0,32},{0,2,0,59},{8551,2,0,
32},{0,2,0,59},{8551,8,0,32},{0,2,0,66},{8551,2,0,32},{0,2,0,66},{8733,8,0,32},
{0,2,0,66},{8733,2,0,32},{0,2,0,66},{8733,8,0,32},{0,2,0,59},{8733,2,0,32},{0,2,
0,59},{8733,8,0,32},{0,2,0,39},{0,2,0,36},{8733,2,0,32},{0,2,0,39},{0,2,0,36},
{8733,8,0,32},{0,2,0,39},{0,2,0,37},{8733,2,0,32},{0,2,0,39},{0,2,0,37},{8733,8,
0,32},{0,2,0,39},{0,2,0,59},{8733,2,0,32},{0,2,0,39},{0,2,0,59},{8733,8,0,32},
{0,2,0,39},{0,2,0,45},{8733,2,0,32},{0,2,0,39},{0,2,0,45},{8733,8,0,32},{0,2,0,
66},{0,2,0,39},{8733,2,0,32},{0,2,0,66},{0,2,0,39},{8733,8,0,32},{0,2,0,63},{0,
2,0,36},{8733,2,0,32},{0,2,0,63},{0,2,0,36},{8733,8,0,32},{0,2,0,63},{0,2,0,37},
{8733,2,0,32},{0,2,0,63},{0,2,0,37},{8733,8,0,32},{0,2,0,63},{0,2,0,59},{8733,2,
0,32},{0,2,0,63},{0,2,0,59},{8733,8,0,32},{0,2,0,63},{0,2,0,45},{8733,2,0,32},
{0,2,0,63},{0,2,0,45},{8733,8,0,32},{0,2,0,63},{0,2,0,66},{8733,2,0,32},{0,2,0,
63},{0,2,0,66},{8961,8,0,32},{0,2,0,66},{8961,2,0,32},{0,2,0,66},{8961,8,0,32},
{0,2,0,59},{8961,2,0,32},{0,2,0,59},{8961,8,0,32},{0,2,0,63},{0,2,0,36},{8961,2,
0,32},{0,2,0,63},{0,2,0,36},{8961,8,0,32},{0,2,0,63},{0,2,0,37},{8961,2,0,32},
{0,2,0,63},{0,2,0,37},{8961,8,0,32},{0,2,0,63},{0,2,0,59},{8961,2,0,32},{0,2,0,
63},{0,2,0,59},{8961,8,0,32},{0,2,0,63},{0,2,0,45},{8961,2,0,32},{0,2,0,63},{0,
2,0,45},{8961,8,0,32},{0,2,0,63},{0,2,0,66},{8961,2,0,32},{0,2,0,63},{0,2,0,66},
{9049,8,0,32},{0,2,0,37},{9049,2,0,32},{0,2,0,37},{9049,8,0,32},{0,2,0,66},
{9049,2,0,32},{0,2,0,66},{9049,8,0,32},{0,2,0,59},{9049,2,0,32},{0,2,0,59},
{9049,8,0,32},{0,2,0,45},{9049,2,0,32},{0,2,0,45},{8624,10,0,32},{8624,10,0,32},
{8624,4,0,32},{8624,4,0,32},{9229,2,0,32},{0,2,0,34},{9229,2,0,32},{0,2,0,35},
{9229,2,0,32},{0,2,0,34},{0,2,0,37},{9229,2,0,32},{0,2,0,35},{0,2,0,37},{9229,2,
0,32},{0,2,0,34},{0,2,0,36},{9229,2,0,32},{0,2,0,35},{0,2,0,36},{9229,2,0,32},
{0,2,0,34},{0,2,0,42},{9229,2,0,32},{0,2,0,35},{0,2,0,42},{9229,8,0,32},{0,2,0,
34},{9229,8,0,32},{0,2,0,35},{9229,8,0,32},{0,2,0,34},{0,2,0,37},{9229,8,0,32},
{0,2,0,35},{0,2,0,37},{9229,8,0,32},{0,2,0,34},{0,2,0,36},{9229,8,0,32},{0,2,0,
35},{0,2,0,36},{9229,8,0,32},{0,2,0,34},{0,2,0,42},{9229,8,0,32},{0,2,0,35},{0,
2,0,42},{9234,2,0,32},{0,2,0,34},{9234,2,0,32},{0,2,0,35},{9234,2,0,32},{0,2,0,
34},{0,2,0,37},{9234,2,0,32},{0,2,0,35},{0,2,0,37},{9234,2,0,32},{0,2,0,34},{0,
2,0,36},{9234,2,0,32},{0,2,0,35},{0,2,0,36},{9234,8,0,32},{0,2,0,34},{9234,8,0,
32},{0,2,0,35},{9234,8,0,32},{0,2,0,34},{0,2,0,37},{9234,8,0,32},{0,2,0,35},{0,
2,0,37},{9234,8,0,32},{0,2,0,34},{0,2,0,36},{9234,8,0,32},{0,2,0,35},{0,2,0,36},
{9240,2,0,32},{0,2,0,34},{9240,2,0,32},{0,2,0,35},{9240,2,0,32},{0,2,0,34},{0,2,
0,37},{9240,2,0,32},{0,2,0,35},{0,2,0,37},{9240,2,0,32},{0,2,0,34},{0,2,0,36},
{9240,2,0,32},{0,2,0,35},{0,2,0,36},{9240,2,0,32},{0,2,0,34},{0,2,0,42},{9240,2,
0,32},{0,2,0,35},{0,2,0,42},{9240,8,0,32},{0,2,0,34},{9240,8,0,32},{0,2,0,35},
{9240,8,0,32},{0,2,0,34},{0,2,0,37},{9240,8,0,32},{0,2,0,35},{0,2,0,37},{9240,8,
0,32},{0,2,0,34},{0,2,0,36},{9240,8,0,32},{0,2,0,35},{0,2,0,36},{9240,8,0,32},
{0,2,0,34},{0,2,0,42},{9240,8,0,32},{0,2,0,35},{0,2,0,42},{9242,2,0,32},{0,2,0,
34},{9242,2,0,32},{0,2,0,35},{9242,2,0,32},{0,2,0,34},{0,2,0,37},{9242,2,0,32},
{0,2,0,35},{0,2,0,37},{9242,2,0,32},{0,2,0,34},{0,2,0,36},{9242,2,0,32},{0,2,0,
35},{0,2,0,36},{9242,2,0,32},{0,2,0,34},{0,2,0,42},{9242,2,0,32},{0,2,0,35},{0,
2,0,42},{9242,8,0,32},{0,2,0,34},{9242,8,0,32},{0,2,0,35},{9242,8,0,32},{0,2,0,
34},{0,2,0,37},{9242,8,0,32},{0,2,0,35},{0,2,0,37},{9242,8,0,32},{0,2,0,34},{0,
2,0,36},{9242,8,0,32},{0,2,0,35},{0,2,0,36},{9242,8,0,32},{0,2,0,34},{0,2,0,42},
{9242,8,0,32},{0,2,0,35},{0,2,0,42},{9250,2,0,32},{0,2,0,34},{9250,2,0,32},{0,2,
0,35},{9250,2,0,32},{0,2,0,34},{0,2,0,37},{9250,2,0,32},{0,2,0,35},{0,2,0,37},
{9250,2,0,32},{0,2,0,34},{0,2,0,36},{9250,2,0,32},{0,2,0,35},{0,2,0,36},{9250,8,
0,32},{0,2,0,34},{9250,8,0,32},{0,2,0,35},{9250,8,0,32},{0,2,0,34},{0,2,0,37},
{9250,8,0,32},{0,2,0,35},{0,2,0,37},{9250,8,0,32},{0,2,0,34},{0,2,0,36},{9250,8,
0,32},{0,2,0,35},{0,2,0,36},{9264,2,0,32},{0,2,0,34},{9264,2,0,32},{0,2,0,35},
{9264,2,0,32},{0,2,0,34},{0,2,0,37},{9264,2,0,32},{0,2,0,35},{0,2,0,37},{9264,2,
0,32},{0,2,0,34},{0,2,0,36},{9264,2,0,32},{0,2,0,35},{0,2,0,36},{9264,2,0,32},
{0,2,0,34},{0,2,0,42},{9264,2,0,32},{0,2,0,35},{0,2,0,42},{9264,8,0,32},{0,2,0,
35},{9264,8,0,32},{0,2,0,35},{0,2,0,37},{9264,8,0,32},{0,2,0,35},{0,2,0,36},
{9264,8,0,32},{0,2,0,35},{0,2,0,42},{9269,2,0,32},{0,2,0,34},{9269,2,0,32},{0,2,
0,35},{9269,2,0,32},{0,2,0,34},{0,2,0,37},{9269,2,0,32},{0,2,0,35},{0,2,0,37},
{9269,2,0,32},{0,2,0,34},{0,2,0,36},{9269,2,0,32},{0,2,0,35},{0,2,0,36},{9269,2,
0,32},{0,2,0,34},{0,2,0,42},{9269,2,0,32},{0,2,0,35},{0,2,0,42},{9269,8,0,32},
{0,2,0,34},{9269,8,0,32},{0,2,0,35},{9269,8,0,32},{0,2,0,34},{0,2,0,37},{9269,8,
0,32},{0,2,0,35},{0,2,0,37},{9269,8,0,32},{0,2,0,34},{0,2,0,36},{9269,8,0,32},
{0,2,0,35},{0,2,0,36},{9269,8,0,32},{0,2,0,34},{0,2,0,42},{9269,8,0,32},{0,2,0,
35},{0,2,0,42},{9229,2,0,32},{0,2,0,37},{9234,2,0,32},{0,2,0,37},{9240,2,0,32},
{0,2,0,37},{9242,2,0,32},{0,2,0,37},{9250,2,0,32},{0,2,0,37},{9264,2,0,32},{0,2,
0,37},{9269,2,0,32},{0,2,0,37},{9229,2,0,32},{0,2,0,34},{0,2,0,76},{9229,2,0,
32},{0,2,0,35},{0,2,0,76},{9229,2,0,32},{0,2,0,34},{0,2,0,37},{0,2,0,76},{9229,
2,0,32},{0,2,0,35},{0,2,0,37},{0,2,0,76},{9229,2,0,32},{0,2,0,34},{0,2,0,36},{0,
2,0,76},{9229,2,0,32},{0,2,0,35},{0,2,0,36},{0,2,0,76},{9229,2,0,32},{0,2,0,34},
{0,2,0,42},{0,2,0,76},{9229,2,0,32},{0,2,0,35},{0,2,0,42},{0,2,0,76},{9229,8,0,
32},{0,2,0,34},{0,2,0,76},{9229,8,0,32},{0,2,0,35},{0,2,0,76},{9229,8,0,32},{0,
2,0,34},{0,2,0,37},{0,2,0,76},{9229,8,0,32},{0,2,0,35},{0,2,0,37},{0,2,0,76},
{9229,8,0,32},{0,2,0,34},{0,2,0,36},{0,2,0,76},{9229,8,0,32},{0,2,0,35},{0,2,0,
36},{0,2,0,76},{9229,8,0,32},{0,2,0,34},{0,2,0,42},{0,2,0,76},{9229,8,0,32},{0,
2,0,35},{0,2,0,42},{0,2,0,76},{9240,2,0,32},{0,2,0,34},{0,2,0,76},{9240,2,0,32},
{0,2,0,35},{0,2,0,76},{9240,2,0,32},{0,2,0,34},{0,2,0,37},{0,2,0,76},{9240,2,0,
32},{0,2,0,35},{0,2,0,37},{0,2,0,76},{9240,2,0,32},{0,2,0,34},{0,2,0,36},{0,2,0,
76},{9240,2,0,32},{0,2,0,35},{0,2,0,36},{0,2,0,76},{9240,2,0,32},{0,2,0,34},{0,
2,0,42},{0,2,0,76},{9240,2,0,32},{0,2,0,35},{0,2,0,42},{0,2,0,76},{9240,8,0,32},
{0,2,0,34},{0,2,0,76},{9240,8,0,32},{0,2,0,35},{0,2,0,76},{9240,8,0,32},{0,2,0,
34},{0,2,0,37},{0,2,0,76},{9240,8,0,32},{0,2,0,35},{0,2,0,37},{0,2,0,76},{9240,
8,0,32},{0,2,0,34},{0,2,0,36},{0,2,0,76},{9240,8,0,32},{0,2,0,35},{0,2,0,36},{0,
2,0,76},{9240,8,0,32},{0,2,0,34},{0,2,0,42},{0,2,0,76},{9240,8,0,32},{0,2,0,35},
{0,2,0,42},{0,2,0,76},{9269,2,0,32},{0,2,0,34},{0,2,0,76},{9269,2,0,32},{0,2,0,
35},{0,2,0,76},{9269,2,0,32},{0,2,0,34},{0,2,0,37},{0,2,0,76},{9269,2,0,32},{0,
2,0,35},{0,2,0,37},{0,2,0,76},{9269,2,0,32},{0,2,0,34},{0,2,0,36},{0,2,0,76},
{9269,2,0,32},{0,2,0,35},{0,2,0,36},{0,2,0,76},{9269,2,0,32},{0,2,0,34},{0,2,0,
42},{0,2,0,76},{9269,2,0,32},{0,2,0,35},{0,2,0,42},{0,2,0,76},{9269,8,0,32},{0,
2,0,34},{0,2,0,76},{9269,8,0,32},{0,2,0,35},{0,2,0,76},{9269,8,0,32},{0,2,0,34},
{0,2,0,37},{0,2,0,76},{9269,8,0,32},{0,2,0,35},{0,2,0,37},{0,2,0,76},{9269,8,0,
32},{0,2,0,34},{0,2,0,36},{0,2,0,76},{9269,8,0,32},{0,2,0,35},{0,2,0,36},{0,2,0,
76},{9269,8,0,32},{0,2,0,34},{0,2,0,42},{0,2,0,76},{9269,8,0,32},{0,2,0,35},{0,
2,0,42},{0,2,0,76},{9229,2,0,32},{0,2,0,38},{9229,2,0,32},{0,2,0,50},{9229,2,0,
32},{0,2,0,37},{0,2,0,76},{9229,2,0,32},{0,2,0,76},{9229,2,0,32},{0,2,0,36},{0,
2,0,76},{9229,2,0,32},{0,2,0,42},{9229,2,0,32},{0,2,0,42},{0,2,0,76},{9229,8,0,
32},{0,2,0,38},{9229,8,0,32},{0,2,0,50},{9229,8,0,32},{0,2,0,37},{9229,8,0,32},
{0,2,0,76},{1232,2,1,32},{0,2,0,42},{9240,2,0,32},{0,2,0,37},{0,2,0,76},{9240,2,
0,32},{0,2,0,76},{9240,2,0,32},{0,2,0,36},{0,2,0,76},{9240,2,0,32},{0,2,0,42},
{9240,2,0,32},{0,2,0,42},{0,2,0,76},{9234,8,0,32},{0,2,0,37},{9240,8,0,32},{0,2,
0,37},{9240,8,0,32},{0,2,0,76},{1237,2,1,32},{0,2,0,37},{1237,2,1,32},{0,2,0,
36},{1237,2,1,32},{0,2,0,42},{9242,2,0,32},{0,2,0,38},{9242,2,0,32},{0,2,0,50},
{9242,2,0,32},{0,2,0,43},{0,2,0,37},{9242,2,0,32},{0,2,0,42},{9242,2,0,32},{0,2,
0,43},{0,2,0,42},{9242,8,0,32},{0,2,0,38},{9242,8,0,32},{0,2,0,50},{9242,8,0,
32},{0,2,0,37},{1238,2,1,32},{0,2,0,37},{1238,2,1,32},{0,2,0,36},{1238,2,1,32},
{0,2,0,42},{9264,2,0,32},{0,2,0,38},{9264,2,0,32},{0,2,0,50},{9264,2,0,32},{0,2,
0,43},{0,2,0,37},{9256,2,0,32},{0,2,0,34},{9256,2,0,32},{0,2,0,35},{9264,2,0,
32},{0,2,0,42},{9264,2,0,32},{0,2,0,43},{0,2,0,42},{9264,8,0,32},{0,2,0,38},
{9264,8,0,32},{0,2,0,50},{9264,8,0,32},{0,2,0,37},{9256,8,0,32},{0,2,0,35},
{1232,2,1,32},{0,2,0,37},{9269,2,0,32},{0,2,0,37},{0,2,0,76},{9269,2,0,32},{0,2,
0,76},{9269,2,0,32},{0,2,0,36},{0,2,0,76},{9269,2,0,32},{0,2,0,42},{9269,2,0,
32},{0,2,0,42},{0,2,0,76},{9250,8,0,32},{0,2,0,37},{9269,8,0,32},{0,2,0,37},
{9269,8,0,32},{0,2,0,76},{641,4,1,32},{641,4,1,32},{641,4,1,32},{641,4,1,32},
{641,4,1,32},{979,4,1,32},{979,4,1,32},{979,4,1,32},{979,4,1,32},{979,4,1,32},
{980,4,1,32},{980,4,1,32},{980,4,1,32},{980,4,1,32},{980,4,1,32},{616,4,1,32},
{616,4,1,32},{623,4,1,32},{623,4,1,32},{623,4,1,32},{616,4,1,32},{616,4,1,32},
{623,4,1,32},{979,4,1,32},{979,4,1,32},{979,4,1,32},{979,4,1,32},{8821,10,0,32},
{8886,4,0,32},{8309,4,0,32},{954,4,1,32},{8361,4,0,32},{8309,4,0,32},{954,4,1,
32},{8886,4,0,32},{1356,4,1,32},{8361,10,0,32},{8361,4,0,32},{954,4,1,32},{8733,
4,0,32},{8361,4,0,32},{954,4,1,32},{8961,4,0,32},{1356,4,1,32},{8470,10,0,32},
{8524,2,0,32},{0,2,0,57},{8695,10,0,32},{8733,4,0,32},{8886,20,0,32},{8680,20,0,
32},{8927,10,0,32},{8411,10,0,32},{8624,10,0,32},{8927,20,0,32},{8680,20,0,32},
{8470,10,0,32},{8309,10,0,32},{9037,10,0,32},{8309,10,0,32},{954,4,1,32},{8886,
10,0,32},{8300,30,0,32},{1709,30,1,32},{8306,30,0,32},{8300,30,0,32},{1709,30,1,
32},{8308,30,0,32},{8300,30,0,32},{1709,30,1,32},{8300,30,0,32},{8299,30,0,32},
{8300,30,0,32},{1709,30,1,32},{8302,30,0,32},{8301,30,0,32},{1709,30,1,32},
{8302,30,0,32},{8300,30,0,32},{1709,30,1,32},{8304,30,0,32},{8301,30,0,32},
{1709,30,1,32},{8304,30,0,32},{8302,30,0,32},{1709,30,1,32},{8304,30,0,32},
{8303,30,0,32},{1709,30,1,32},{8304,30,0,32},{8300,30,0,32},{1709,30,1,32},
{8305,30,0,32},{8304,30,0,32},{1709,30,1,32},{8305,30,0,32},{8300,30,0,32},
{1709,30,1,32},{8307,30,0,32},{8302,30,0,32},{1709,30,1,32},{8307,30,0,32},
{8304,30,0,32},{1709,30,1,32},{8307,30,0,32},{8306,30,0,32},{1709,30,1,32},
{8307,30,0,32},{8300,30,0,32},{1709,30,1,32},{8551,10,0,32},{8551,10,0,32},
{8551,10,0,32},{8551,10,0,32},{8551,10,0,32},{8551,10,0,32},{9009,10,0,32},
{9009,10,0,32},{8551,10,0,32},{9009,10,0,32},{8551,10,0,32},{8551,10,0,32},
{9009,10,0,32},{8551,10,0,32},{8551,10,0,32},{8551,10,0,32},{8551,10,0,32},
{9037,10,0,32},{9037,10,0,32},{8551,10,0,32},{9037,10,0,32},{8551,10,0,32},
{8551,10,0,32},{8551,4,0,32},{8551,4,0,32},{8551,4,0,32},{8551,4,0,32},{8551,4,
0,32},{8551,4,0,32},{9009,4,0,32},{9009,4,0,32},{8551,4,0,32},{9009,4,0,32},
{8551,4,0,32},{8551,4,0,32},{9009,4,0,32},{8551,4,0,32},{8551,4,0,32},{8551,4,0,
32},{8551,4,0,32},{9037,4,0,32},{9037,4,0,32},{8551,4,0,32},{9037,4,0,32},{8551,
4,0,32},{8551,4,0,32},{8299,30,0,32},{1709,30,1,32},{8302,30,0,32},{1571,2,1,
32},{0,2,0,47},{1572,2,1,32},{0,2,0,47},{1575,2,1,32},{0,2,0,47},{1629,2,1,32},
{0,2,0,47},{1633,2,1,32},{0,2,0,47},{1631,2,1,32},{0,2,0,47},{1680,2,1,32},{0,2,
0,47},{1684,2,1,32},{0,2,0,47},{1686,2,1,32},{0,2,0,47},{1725,2,1,32},{0,2,0,
47},{1726,2,1,32},{0,2,0,47},{1731,4,1,32},{1731,4,1,32},{1731,4,1,32},{1731,4,
1,32},{1731,4,1,32},{1732,4,1,32},{1732,4,1,32},{1732,4,1,32},{1732,4,1,32},
{1732,4,1,32},{1744,2,1,32},{0,2,0,47},{1750,2,1,32},{0,2,0,47},{1751,2,1,32},
{0,2,0,47},{1753,2,1,32},{0,2,0,47},{1698,2,1,32},{0,2,0,47},{1776,2,1,32},{0,2,
0,47},{1757,2,1,32},{0,2,0,47},{1697,2,1,32},{0,2,0,47},{1699,2,1,32},{0,2,0,
47},{1778,2,1,32},{0,2,0,47},{1779,2,1,32},{0,2,0,47},{1787,2,1,32},{0,2,0,47},
{1788,2,1,32},{0,2,0,47},{1789,2,1,32},{0,2,0,47},{1790,2,1,32},{0,2,0,47},
{1791,2,1,32},{0,2,0,47},{1792,2,1,32},{0,2,0,47},{1797,2,1,32},{0,2,0,47},
{1798,2,1,32},{0,2,0,47},{1799,2,1,32},{0,2,0,47},{1800,2,1,32},{0,2,0,47},
{1825,2,1,32},{0,2,0,47},{1831,2,1,32},{0,2,0,47},{1832,2,1,32},{0,2,0,47},
{1834,2,1,32},{0,2,0,47},{1793,2,1,32},{0,2,0,47},{1794,2,1,32},{0,2,0,47},
{1808,2,1,32},{0,2,0,47},{1809,2,1,32},{0,2,0,47},{1837,2,1,32},{0,2,0,47},
{1838,2,1,32},{0,2,0,47},{1839,2,1,32},{0,2,0,47},{1840,2,1,32},{0,2,0,47},
{8300,6,0,32},{8299,6,0,32},{8300,6,0,32},{8300,6,0,32},{8300,6,0,32},{8301,6,0,
32},{8300,6,0,32},{8302,6,0,32},{8300,6,0,32},{8303,6,0,32},{8300,6,0,32},{8304,
6,0,32},{8300,6,0,32},{8305,6,0,32},{8300,6,0,32},{8306,6,0,32},{8300,6,0,32},
{8307,6,0,32},{8300,6,0,32},{8308,6,0,32},{8301,6,0,32},{8299,6,0,32},{820,4,1,
32},{8300,4,0,32},{821,4,1,32},{820,4,1,32},{8301,4,0,32},{821,4,1,32},{820,4,1,
32},{8302,4,0,32},{821,4,1,32},{820,4,1,32},{8303,4,0,32},{821,4,1,32},{820,4,1,
32},{8304,4,0,32},{821,4,1,32},{820,4,1,32},{8305,4,0,32},{821,4,1,32},{820,4,1,
32},{8306,4,0,32},{821,4,1,32},{820,4,1,32},{8307,4,0,32},{821,4,1,32},{820,4,1,
32},{8308,4,0,32},{821,4,1,32},{820,4,1,32},{8300,4,0,32},{8299,4,0,32},{821,4,
1,32},{820,4,1,32},{8300,4,0,32},{8300,4,0,32},{821,4,1,32},{820,4,1,32},{8300,
4,0,32},{8301,4,0,32},{821,4,1,32},{820,4,1,32},{8300,4,0,32},{8302,4,0,32},
{821,4,1,32},{820,4,1,32},{8300,4,0,32},{8303,4,0,32},{821,4,1,32},{820,4,1,32},
{8300,4,0,32},{8304,4,0,32},{821,4,1,32},{820,4,1,32},{8300,4,0,32},{8305,4,0,
32},{821,4,1,32},{820,4,1,32},{8300,4,0,32},{8306,4,0,32},{821,4,1,32},{820,4,1,
32},{8300,4,0,32},{8307,4,0,32},{821,4,1,32},{820,4,1,32},{8300,4,0,32},{8308,4,
0,32},{821,4,1,32},{820,4,1,32},{8301,4,0,32},{8299,4,0,32},{821,4,1,32},{8300,
4,0,32},{641,4,1,32},{8301,4,0,32},{641,4,1,32},{8302,4,0,32},{641,4,1,32},
{8303,4,0,32},{641,4,1,32},{8304,4,0,32},{641,4,1,32},{8305,4,0,32},{641,4,1,
32},{8306,4,0,32},{641,4,1,32},{8307,4,0,32},{641,4,1,32},{8308,4,0,32},{641,4,
1,32},{8300,4,0,32},{8299,4,0,32},{641,4,1,32},{8300,4,0,32},{8300,4,0,32},{641,
4,1,32},{8300,4,0,32},{8301,4,0,32},{641,4,1,32},{8300,4,0,32},{8302,4,0,32},
{641,4,1,32},{8300,4,0,32},{8303,4,0,32},{641,4,1,32},{8300,4,0,32},{8304,4,0,
32},{641,4,1,32},{8300,4,0,32},{8305,4,0,32},{641,4,1,32},{8300,4,0,32},{8306,4,
0,32},{641,4,1,32},{8300,4,0,32},{8307,4,0,32},{641,4,1,32},{8300,4,0,32},{8308,
4,0,32},{641,4,1,32},{8301,4,0,32},{8299,4,0,32},{641,4,1,32},{820,4,1,32},
{8309,4,0,32},{821,4,1,32},{820,4,1,32},{8335,4,0,32},{821,4,1,32},{820,4,1,32},
{8361,4,0,32},{821,4,1,32},{820,4,1,32},{8383,4,0,32},{821,4,1,32},{820,4,1,32},
{8411,4,0,32},{821,4,1,32},{820,4,1,32},{8470,4,0,32},{821,4,1,32},{820,4,1,32},
{8485,4,0,32},{821,4,1,32},{820,4,1,32},{8524,4,0,32},{821,4,1,32},{820,4,1,32},
{8551,4,0,32},{821,4,1,32},{820,4,1,32},{8579,4,0,32},{821,4,1,32},{820,4,1,32},
{8604,4,0,32},{821,4,1,32},{820,4,1,32},{8624,4,0,32},{821,4,1,32},{820,4,1,32},
{8680,4,0,32},{821,4,1,32},{820,4,1,32},{8695,4,0,32},{821,4,1,32},{820,4,1,32},
{8733,4,0,32},{821,4,1,32},{820,4,1,32},{8781,4,0,32},{821,4,1,32},{820,4,1,32},
{8802,4,0,32},{821,4,1,32},{820,4,1,32},{8821,4,0,32},{821,4,1,32},{820,4,1,32},
{8886,4,0,32},{821,4,1,32},{820,4,1,32},{8927,4,0,32},{821,4,1,32},{820,4,1,32},
{8961,4,0,32},{821,4,1,32},{820,4,1,32},{9009,4,0,32},{821,4,1,32},{820,4,1,32},
{9027,4,0,32},{821,4,1,32},{820,4,1,32},{9037,4,0,32},{821,4,1,32},{820,4,1,32},
{9049,4,0,32},{821,4,1,32},{820,4,1,32},{9071,4,0,32},{821,4,1,32},{8300,6,0,
32},{8300,6,0,32},{8300,6,0,32},{8301,6,0,32},{8300,6,0,32},{8302,6,0,32},{8300,
6,0,32},{8303,6,0,32},{8300,6,0,32},{8304,6,0,32},{8300,6,0,32},{8305,6,0,32},
{8300,6,0,32},{8306,6,0,32},{8300,6,0,32},{8307,6,0,32},{8300,6,0,32},{8308,6,0,
32},{8301,6,0,32},{8299,6,0,32},{8300,6,0,32},{8299,6,0,32},{8300,6,0,32},{8299,
6,0,32},{8300,6,0,32},{8299,6,0,32},{8300,6,0,32},{8299,6,0,32},{1731,4,1,32},
{1731,4,1,32},{1731,4,1,32},{1731,4,1,32},{577,4,1,32},{577,4,1,32},{1698,4,1,
32},{1698,4,1,32},{1698,4,1,32},{1698,4,1,32},{1698,4,1,32},{1698,4,1,32},{3577,
2,1,32},{0,2,0,47},{9285,4,0,32},{9274,4,0,32},{9284,4,0,32},{9561,4,0,32},
{9570,4,0,32},{64320,4,0,32},{52790,0,0,0},{0,4,0,280},{64320,4,0,32},{54146,0,
0,0},{0,4,0,280},{64320,4,0,32},{52827,0,0,0},{64320,4,0,32},{52826,0,0,0},
{64320,4,0,32},{52825,0,0,0},{0,4,0,280},{64320,4,0,32},{52923,0,0,0},{64320,4,
0,32},{53634,0,0,0},{0,4,0,280},{64320,4,0,32},{53728,0,0,0},{0,4,0,280},{64320,
4,0,32},{53760,0,0,0},{0,4,0,280},{64320,4,0,32},{53762,0,0,0},{64320,4,0,32},
{54108,0,0,0},{0,4,0,280},{64320,4,0,32},{54121,0,0,0},{0,4,0,280},{64320,4,0,
32},{56335,0,0,0},{0,4,0,280},{64320,4,0,32},{56335,0,0,0},{0,4,0,281},{64320,4,
0,32},{56354,0,0,0},{0,4,0,280},{64320,4,0,32},{56355,0,0,0},{64320,4,0,32},
{56354,0,0,0},{64320,4,0,32},{56355,0,0,0},{0,4,0,280},{64320,4,0,32},{56819,0,
0,0},{64320,4,0,32},{56954,0,0,0},{64320,4,0,32},{57169,0,0,0},{64320,4,0,32},
{57168,0,0,0},{0,4,0,280},{64320,4,0,32},{57284,0,0,0},{64320,4,0,32},{57283,0,
0,0},{0,4,0,280},{64320,4,0,32},{57932,0,0,0},{64320,4,0,32},{58677,0,0,0},
{64320,4,0,32},{58849,0,0,0},{64320,4,0,32},{58853,0,0,0},{0,4,0,280},{64320,4,
0,32},{59144,0,0,0},{0,4,0,280},{64320,4,0,32},{60282,0,0,0},{0,4,0,280},{64320,
4,0,32},{60365,0,0,0},{64320,4,0,32},{60433,0,0,0},{64320,4,0,32},{60469,0,0,0},
{64320,4,0,32},{60474,0,0,0},{64320,4,0,32},{61548,0,0,0},{64320,4,0,32},{61995,
0,0,0},{64320,4,0,32},{61995,0,0,0},{0,4,0,280},{64320,4,0,32},{52780,0,0,0},
{64320,4,0,32},{62043,0,0,0},{0,4,0,280},{64320,4,0,32},{62125,0,0,0},{64320,4,
0,32},{62347,0,0,0},{0,4,0,280},{64320,4,0,32},{62859,0,0,0},{0,4,0,280},{64320,
4,0,32},{63214,0,0,0},{0,4,0,280},{64320,4,0,32},{63802,0,0,0},{0,4,0,280},
{64320,4,0,32},{63803,0,0,0},{64320,4,0,32},{64249,0,0,0},{0,4,0,280},{64320,4,
0,32},{64761,0,0,0},{64320,4,0,32},{65183,0,0,0},{64320,4,0,32},{65363,0,0,0},
{64320,4,0,32},{65362,0,0,0},{64320,4,0,32},{65363,0,0,0},{0,4,0,280},{64320,4,
0,32},{65363,0,0,0},{0,4,0,281},{64320,4,0,32},{65362,0,0,0},{0,4,0,280},{64320,
4,0,32},{65418,0,0,0},{0,4,0,280},{64320,4,0,32},{65418,0,0,0},{0,4,0,281},
{64320,4,0,32},{65419,0,0,0},{64321,4,0,32},{32770,0,0,0},{64321,4,0,32},{32896,
0,0,0},{64321,4,0,32},{32895,0,0,0},{0,4,0,280},{64321,4,0,32},{32905,0,0,0},{0,
4,0,280},{64321,4,0,32},{33276,0,0,0},{0,4,0,280},{64321,4,0,32},{33401,0,0,0},
{64321,4,0,32},{33401,0,0,0},{0,4,0,280},{64321,4,0,32},{33401,0,0,0},{0,4,0,
281},{64321,4,0,32},{34382,0,0,0},{64321,4,0,32},{34916,0,0,0},{64321,4,0,32},
{35200,0,0,0},{64321,4,0,32},{35199,0,0,0},{64321,4,0,32},{35265,0,0,0},{64321,
4,0,32},{35282,0,0,0},{64321,4,0,32},{35282,0,0,0},{0,4,0,280},{64321,4,0,32},
{35744,0,0,0},{64321,4,0,32},{36125,0,0,0},{64321,4,0,32},{36275,0,0,0},{0,4,0,
280},{64321,4,0,32},{36710,0,0,0},{64321,4,0,32},{36790,0,0,0},{64321,4,0,32},
{36790,0,0,0},{0,4,0,280},{64321,4,0,32},{36790,0,0,0},{0,4,0,281},{64321,4,0,
32},{37009,0,0,0},{0,4,0,280},{64321,4,0,32},{38021,0,0,0},{64321,4,0,32},
{38263,0,0,0},{64321,4,0,32},{38264,0,0,0},{64321,4,0,32},{38271,0,0,0},{64321,
4,0,32},{38376,0,0,0},{64321,4,0,32},{38428,0,0,0},{0,4,0,280},{64321,4,0,32},
{38429,0,0,0},{64321,4,0,32},{38632,0,0,0},{0,4,0,280},{64321,4,0,32},{38738,0,
0,0},{64321,4,0,32},{38886,0,0,0},{64321,4,0,32},{39029,0,0,0},{64321,4,0,32},
{39118,0,0,0},{64321,4,0,32},{39134,0,0,0},{64321,4,0,32},{39135,0,0,0},{64321,
4,0,32},{39136,0,0,0},{0,4,0,280},{64321,4,0,32},{39136,0,0,0},{64321,4,0,32},
{39267,0,0,0},{64321,4,0,32},{39318,0,0,0},{0,4,0,280},{64321,4,0,32},{39532,0,
0,0},{64321,4,0,32},{39592,0,0,0},{0,4,0,280},{64321,4,0,32},{39740,0,0,0},{0,4,
0,280},{64321,4,0,32},{40060,0,0,0},{64321,4,0,32},{40479,0,0,0},{64321,4,0,32},
{40565,0,0,0},{0,4,0,280},{64321,4,0,32},{40614,0,0,0},{64321,4,0,32},{40644,0,
0,0},{64321,4,0,32},{40702,0,0,0},{64321,4,0,32},{40778,0,0,0},{0,4,0,280},
{64321,4,0,32},{40784,0,0,0},{64321,4,0,32},{40786,0,0,0},{0,4,0,280},{64321,4,
0,32},{40831,0,0,0},{64321,4,0,32},{40845,0,0,0},{0,4,0,280},{64321,4,0,32},
{40857,0,0,0},{64321,4,0,32},{40860,0,0,0},{0,4,0,280},{64321,4,0,32},{40860,0,
0,0},{0,4,0,281},{64321,4,0,32},{40863,0,0,0},{64320,4,0,32},{52736,0,0,0},
{64320,4,0,32},{52776,0,0,0},{64320,4,0,32},{52790,0,0,0},{64320,4,0,32},{52799,
0,0,0},{64320,4,0,32},{52825,0,0,0},{64320,4,0,32},{52869,0,0,0},{64320,4,0,32},
{52876,0,0,0},{64320,4,0,32},{52896,0,0,0},{64320,4,0,32},{52922,0,0,0},{64320,
4,0,32},{53567,0,0,0},{64320,4,0,32},{53605,0,0,0},{64320,4,0,32},{53611,0,0,0},
{64320,4,0,32},{53634,0,0,0},{64320,4,0,32},{53654,0,0,0},{64320,4,0,32},{53675,
0,0,0},{64320,4,0,32},{53728,0,0,0},{64320,4,0,32},{53749,0,0,0},{64320,4,0,32},
{53760,0,0,0},{64320,4,0,32},{53915,0,0,0},{64320,4,0,32},{54009,0,0,0},{64320,
4,0,32},{54037,0,0,0},{64320,4,0,32},{54042,0,0,0},{64320,4,0,32},{54072,0,0,0},
{64320,4,0,32},{54081,0,0,0},{64320,4,0,32},{54108,0,0,0},{64320,4,0,32},{54121,
0,0,0},{64320,4,0,32},{54146,0,0,0},{64320,4,0,32},{54198,0,0,0},{64320,4,0,32},
{54216,0,0,0},{64320,4,0,32},{54243,0,0,0},{64320,4,0,32},{54999,0,0,0},{64320,
4,0,32},{55071,0,0,0},{64320,4,0,32},{55531,0,0,0},{64320,4,0,32},{55554,0,0,0},
{64320,4,0,32},{55562,0,0,0},{64320,4,0,32},{55573,0,0,0},{64320,4,0,32},{55591,
0,0,0},{64320,4,0,32},{55667,0,0,0},{64320,4,0,32},{56144,0,0,0},{64320,4,0,32},
{56192,0,0,0},{64320,4,0,32},{56312,0,0,0},{64320,4,0,32},{56335,0,0,0},{64320,
4,0,32},{56354,0,0,0},{64320,4,0,32},{56376,0,0,0},{64320,4,0,32},{56430,0,0,0},
{64320,4,0,32},{56433,0,0,0},{64320,4,0,32},{56795,0,0,0},{64320,4,0,32},{56805,
0,0,0},{64320,4,0,32},{56817,0,0,0},{64320,4,0,32},{56830,0,0,0},{64320,4,0,32},
{56946,0,0,0},{64320,4,0,32},{56954,0,0,0},{64320,4,0,32},{56959,0,0,0},{64320,
4,0,32},{57076,0,0,0},{64320,4,0,32},{57086,0,0,0},{64320,4,0,32},{57099,0,0,0},
{64320,4,0,32},{57107,0,0,0},{64320,4,0,32},{57168,0,0,0},{64320,4,0,32},{57185,
0,0,0},{64320,4,0,32},{57203,0,0,0},{64320,4,0,32},{57283,0,0,0},{64320,4,0,32},
{57864,0,0,0},{64320,4,0,32},{57910,0,0,0},{64320,4,0,32},{57931,0,0,0},{64320,
4,0,32},{58671,0,0,0},{64320,4,0,32},{58676,0,0,0},{64320,4,0,32},{58759,0,0,0},
{64320,4,0,32},{58775,0,0,0},{64320,4,0,32},{58788,0,0,0},{64320,4,0,32},{58809,
0,0,0},{64320,4,0,32},{58848,0,0,0},{64320,4,0,32},{58853,0,0,0},{64320,4,0,32},
{59120,0,0,0},{64320,4,0,32},{59144,0,0,0},{64320,4,0,32},{59176,0,0,0},{64320,
4,0,32},{60192,0,0,0},{64320,4,0,32},{60258,0,0,0},{64320,4,0,32},{60281,0,0,0},
{64320,4,0,32},{60339,0,0,0},{64320,4,0,32},{60363,0,0,0},{64320,4,0,32},{60372,
0,0,0},{64320,4,0,32},{60379,0,0,0},{64320,4,0,32},{60431,0,0,0},{64320,4,0,32},
{60436,0,0,0},{64320,4,0,32},{60468,0,0,0},{64320,4,0,32},{61547,0,0,0},{64320,
4,0,32},{61994,0,0,0},{64320,4,0,32},{62006,0,0,0},{64320,4,0,32},{62011,0,0,0},
{64320,4,0,32},{62015,0,0,0},{64320,4,0,32},{62023,0,0,0},{64320,4,0,32},{62041,
0,0,0},{64320,4,0,32},{62043,0,0,0},{64320,4,0,32},{62124,0,0,0},{64320,4,0,32},
{62340,0,0,0},{64320,4,0,32},{62345,0,0,0},{64320,4,0,32},{62684,0,0,0},{64320,
4,0,32},{62694,0,0,0},{64320,4,0,32},{62744,0,0,0},{64320,4,0,32},{62751,0,0,0},
{64320,4,0,32},{62760,0,0,0},{64320,4,0,32},{62768,0,0,0},{64320,4,0,32},{62859,
0,0,0},{64320,4,0,32},{62866,0,0,0},{64320,4,0,32},{63094,0,0,0},{64320,4,0,32},
{63101,0,0,0},{64320,4,0,32},{63150,0,0,0},{64320,4,0,32},{63167,0,0,0},{64320,
4,0,32},{63214,0,0,0},{64320,4,0,32},{63451,0,0,0},{64320,4,0,32},{63458,0,0,0},
{64320,4,0,32},{63475,0,0,0},{64320,4,0,32},{63802,0,0,0},{64320,4,0,32},{63928,
0,0,0},{64320,4,0,32},{63934,0,0,0},{64320,4,0,32},{64116,0,0,0},{64320,4,0,32},
{64203,0,0,0},{64320,4,0,32},{64249,0,0,0},{64320,4,0,32},{64627,0,0,0},{64320,
4,0,32},{64760,0,0,0},{64320,4,0,32},{65334,0,0,0},{64320,4,0,32},{65361,0,0,0},
{64320,4,0,32},{65418,0,0,0},{64320,4,0,32},{65469,0,0,0},{64321,4,0,32},{32769,
0,0,0},{64321,4,0,32},{32780,0,0,0},{64321,4,0,32},{32786,0,0,0},{64321,4,0,32},
{32819,0,0,0},{64321,4,0,32},{32895,0,0,0},{64321,4,0,32},{32905,0,0,0},{64321,
4,0,32},{33251,0,0,0},{64321,4,0,32},{33258,0,0,0},{64321,4,0,32},{33267,0,0,0},
{64321,4,0,32},{33276,0,0,0},{64321,4,0,32},{33292,0,0,0},{64321,4,0,32},{33307,
0,0,0},{64321,4,0,32},{33311,0,0,0},{64321,4,0,32},{33390,0,0,0},{64321,4,0,32},
{33394,0,0,0},{64321,4,0,32},{33400,0,0,0},{64321,4,0,32},{34381,0,0,0},{64321,
4,0,32},{34411,0,0,0},{64321,4,0,32},{34880,0,0,0},{64321,4,0,32},{34892,0,0,0},
{64321,4,0,32},{34915,0,0,0},{64321,4,0,32},{35198,0,0,0},{64321,4,0,32},{35211,
0,0,0},{64321,4,0,32},{35282,0,0,0},{64321,4,0,32},{35328,0,0,0},{64321,4,0,32},
{35895,0,0,0},{64321,4,0,32},{35910,0,0,0},{64321,4,0,32},{35925,0,0,0},{64321,
4,0,32},{35960,0,0,0},{64321,4,0,32},{35997,0,0,0},{64321,4,0,32},{36196,0,0,0},
{64321,4,0,32},{36208,0,0,0},{64321,4,0,32},{36275,0,0,0},{64321,4,0,32},{36523,
0,0,0},{64321,4,0,32},{36554,0,0,0},{64321,4,0,32},{36763,0,0,0},{64321,4,0,32},
{36784,0,0,0},{64321,4,0,32},{36789,0,0,0},{64321,4,0,32},{37009,0,0,0},{64321,
4,0,32},{37193,0,0,0},{64321,4,0,32},{37318,0,0,0},{64321,4,0,32},{37324,0,0,0},
{64321,4,0,32},{37329,0,0,0},{64321,4,0,32},{38263,0,0,0},{64321,4,0,32},{38272,
0,0,0},{64321,4,0,32},{38428,0,0,0},{64321,4,0,32},{38582,0,0,0},{64321,4,0,32},
{38585,0,0,0},{64321,4,0,32},{38632,0,0,0},{64321,4,0,32},{38737,0,0,0},{64321,
4,0,32},{38750,0,0,0},{64321,4,0,32},{38754,0,0,0},{64321,4,0,32},{38761,0,0,0},
{64321,4,0,32},{38859,0,0,0},{64321,4,0,32},{38893,0,0,0},{64321,4,0,32},{38899,
0,0,0},{64321,4,0,32},{38913,0,0,0},{64321,4,0,32},{39080,0,0,0},{64321,4,0,32},
{39131,0,0,0},{64321,4,0,32},{39135,0,0,0},{64321,4,0,32},{39318,0,0,0},{64321,
4,0,32},{39321,0,0,0},{64321,4,0,32},{39340,0,0,0},{64321,4,0,32},{39592,0,0,0},
{64321,4,0,32},{39640,0,0,0},{64321,4,0,32},{39647,0,0,0},{64321,4,0,32},{39717,
0,0,0},{64321,4,0,32},{39727,0,0,0},{64321,4,0,32},{39730,0,0,0},{64321,4,0,32},
{39740,0,0,0},{64321,4,0,32},{39770,0,0,0},{64321,4,0,32},{40165,0,0,0},{64321,
4,0,32},{40565,0,0,0},{64321,4,0,32},{40575,0,0,0},{64321,4,0,32},{40613,0,0,0},
{64321,4,0,32},{40635,0,0,0},{64321,4,0,32},{40643,0,0,0},{64321,4,0,32},{40653,
0,0,0},{64321,4,0,32},{40657,0,0,0},{64321,4,0,32},{40697,0,0,0},{64321,4,0,32},
{40701,0,0,0},{64321,4,0,32},{40718,0,0,0},{64321,4,0,32},{40723,0,0,0},{64321,
4,0,32},{40736,0,0,0},{64321,4,0,32},{40763,0,0,0},{64321,4,0,32},{40778,0,0,0},
{64321,4,0,32},{40786,0,0,0},{64321,4,0,32},{40845,0,0,0},{64321,4,0,32},{40860,
0,0,0},{64321,4,0,32},{40864,0,0,0},{17435,4,0,32},{17457,4,0,32},{8238,2,0,32},
{0,2,0,55},{8239,2,0,32},{0,2,0,55},{64320,4,0,32},{54081,0,0,0},{64320,4,0,32},
{54084,0,0,0},{64320,4,0,32},{54085,0,0,0},{17454,4,0,32},{17436,4,0,32},{17429,
14,0,32},{0,2,0,55},{17430,14,0,32},{0,2,0,55},{17431,14,0,32},{0,2,0,55},
{17432,14,0,32},{0,2,0,55},{17433,14,0,32},{0,2,0,55},{17434,14,0,32},{0,2,0,
55},{17435,14,0,32},{0,2,0,55},{17436,14,0,32},{0,2,0,55},{17437,14,0,32},{0,2,
0,55},{17438,14,0,32},{0,2,0,55},{17439,14,0,32},{0,2,0,55},{17440,14,0,32},{0,
2,0,55},{17441,14,0,32},{0,2,0,55},{17442,14,0,32},{0,2,0,55},{17443,14,0,32},
{0,2,0,55},{17449,14,0,32},{0,2,0,55},{17449,14,0,32},{0,2,0,56},{17450,14,0,
32},{0,2,0,55},{17450,14,0,32},{0,2,0,56},{17451,14,0,32},{0,2,0,55},{17451,14,
0,32},{0,2,0,56},{17452,14,0,32},{0,2,0,55},{17452,14,0,32},{0,2,0,56},{17453,
14,0,32},{0,2,0,55},{17453,14,0,32},{0,2,0,56},{17425,14,0,32},{0,2,0,55},{8241,
2,0,32},{0,2,0,55},{17463,22,0,32},{17465,22,0,32},{17429,17,0,32},{0,2,0,55},
{17430,17,0,32},{0,2,0,55},{17431,17,0,32},{0,2,0,55},{17432,17,0,32},{0,2,0,
55},{17433,17,0,32},{0,2,0,55},{17434,17,0,32},{0,2,0,55},{17435,17,0,32},{0,2,
0,55},{17436,17,0,32},{0,2,0,55},{17437,17,0,32},{0,2,0,55},{17438,17,0,32},{0,
2,0,55},{17439,17,0,32},{0,2,0,55},{17440,17,0,32},{0,2,0,55},{17441,17,0,32},
{0,2,0,55},{17442,17,0,32},{0,2,0,55},{17443,17,0,32},{0,2,0,55},{17449,17,0,
32},{0,2,0,55},{17449,17,0,32},{0,2,0,56},{17450,17,0,32},{0,2,0,55},{17450,17,
0,32},{0,2,0,56},{17451,17,0,32},{0,2,0,55},{17451,17,0,32},{0,2,0,56},{17452,
17,0,32},{0,2,0,55},{17452,17,0,32},{0,2,0,56},{17453,17,0,32},{0,2,0,55},
{17453,17,0,32},{0,2,0,56},{17425,17,0,32},{0,2,0,55},{17469,17,0,32},{0,2,0,
55},{17470,17,0,32},{0,2,0,55},{17472,17,0,32},{0,2,0,55},{17473,17,0,32},{0,2,
0,55},{8243,2,0,32},{0,2,0,55},{17433,22,0,32},{17443,22,0,32},{64320,20,0,32},
{52736,0,0,0},{64320,20,0,32},{52876,0,0,0},{64320,20,0,32},{52745,0,0,0},
{64320,20,0,32},{55003,0,0,0},{64320,20,0,32},{52746,0,0,0},{64320,20,0,32},
{52781,0,0,0},{64320,20,0,32},{52747,0,0,0},{64320,20,0,32},{62770,0,0,0},
{64320,20,0,32},{52825,0,0,0},{64320,20,0,32},{52761,0,0,0},{64320,20,0,32},
{52737,0,0,0},{64320,20,0,32},{55593,0,0,0},{64320,20,0,32},{55088,0,0,0},
{64320,20,0,32},{52922,0,0,0},{17761,4,0,32},{0,4,0,281},{17787,4,0,32},{0,4,0,
281},{17777,4,0,32},{0,4,0,281},{17772,4,0,32},{0,4,0,281},{17798,4,0,32},{0,4,
0,281},{17794,4,0,32},{0,4,0,281},{17812,4,0,32},{0,4,0,282},{17793,4,0,32},{0,
4,0,281},{17811,4,0,32},{0,4,0,281},{17812,4,0,32},{0,4,0,281},{17799,4,0,32},
{0,4,0,281},{17801,4,0,32},{0,4,0,281},{17811,22,0,32},{0,22,0,281},{820,4,1,
32},{17066,4,0,32},{821,4,1,32},{820,4,1,32},{17068,4,0,32},{821,4,1,32},{820,4,
1,32},{17069,4,0,32},{821,4,1,32},{820,4,1,32},{17071,4,0,32},{821,4,1,32},{820,
4,1,32},{17072,4,0,32},{821,4,1,32},{820,4,1,32},{17073,4,0,32},{821,4,1,32},
{820,4,1,32},{17075,4,0,32},{821,4,1,32},{820,4,1,32},{17077,4,0,32},{821,4,1,
32},{820,4,1,32},{17078,4,0,32},{821,4,1,32},{820,4,1,32},{17080,4,0,32},{821,4,
1,32},{820,4,1,32},{17081,4,0,32},{821,4,1,32},{820,4,1,32},{17082,4,0,32},{821,
4,1,32},{820,4,1,32},{17083,4,0,32},{821,4,1,32},{820,4,1,32},{17084,4,0,32},
{821,4,1,32},{820,4,1,32},{17066,4,0,32},{17192,4,0,32},{821,4,1,32},{820,4,1,
32},{17068,4,0,32},{17192,4,0,32},{821,4,1,32},{820,4,1,32},{17069,4,0,32},
{17192,4,0,32},{821,4,1,32},{820,4,1,32},{17071,4,0,32},{17192,4,0,32},{821,4,1,
32},{820,4,1,32},{17072,4,0,32},{17192,4,0,32},{821,4,1,32},{820,4,1,32},{17073,
4,0,32},{17192,4,0,32},{821,4,1,32},{820,4,1,32},{17075,4,0,32},{17192,4,0,32},
{821,4,1,32},{820,4,1,32},{17077,4,0,32},{17192,4,0,32},{821,4,1,32},{820,4,1,
32},{17078,4,0,32},{17192,4,0,32},{821,4,1,32},{820,4,1,32},{17080,4,0,32},
{17192,4,0,32},{821,4,1,32},{820,4,1,32},{17081,4,0,32},{17192,4,0,32},{821,4,1,
32},{820,4,1,32},{17082,4,0,32},{17192,4,0,32},{821,4,1,32},{820,4,1,32},{17083,
4,0,32},{17192,4,0,32},{821,4,1,32},{820,4,1,32},{17084,4,0,32},{17192,4,0,32},
{821,4,1,32},{820,4,1,32},{17078,4,0,32},{17205,4,0,32},{821,4,1,32},{820,4,1,
32},{17077,4,0,32},{17200,4,0,32},{17078,4,0,32},{17196,4,0,32},{17289,4,0,32},
{821,4,1,32},{820,4,1,32},{17077,4,0,32},{17200,4,0,32},{17084,4,0,32},{17205,4,
0,32},{821,4,1,32},{820,4,1,32},{64320,4,0,32},{52736,0,0,0},{821,4,1,32},{820,
4,1,32},{64320,4,0,32},{52876,0,0,0},{821,4,1,32},{820,4,1,32},{64320,4,0,32},
{52745,0,0,0},{821,4,1,32},{820,4,1,32},{64320,4,0,32},{55003,0,0,0},{821,4,1,
32},{820,4,1,32},{64320,4,0,32},{52884,0,0,0},{821,4,1,32},{820,4,1,32},{64320,
4,0,32},{53613,0,0,0},{821,4,1,32},{820,4,1,32},{64320,4,0,32},{52739,0,0,0},
{821,4,1,32},{820,4,1,32},{64320,4,0,32},{53611,0,0,0},{821,4,1,32},{820,4,1,
32},{64320,4,0,32},{52829,0,0,0},{821,4,1,32},{820,4,1,32},{64320,4,0,32},
{54081,0,0,0},{821,4,1,32},{820,4,1,32},{64320,4,0,32},{59144,0,0,0},{821,4,1,
32},{820,4,1,32},{64320,4,0,32},{61547,0,0,0},{821,4,1,32},{820,4,1,32},{64320,
4,0,32},{60468,0,0,0},{821,4,1,32},{820,4,1,32},{64320,4,0,32},{59176,0,0,0},
{821,4,1,32},{820,4,1,32},{64321,4,0,32},{37329,0,0,0},{821,4,1,32},{820,4,1,
32},{64320,4,0,32},{55071,0,0,0},{821,4,1,32},{820,4,1,32},{64320,4,0,32},
{58853,0,0,0},{821,4,1,32},{820,4,1,32},{64320,4,0,32},{59434,0,0,0},{821,4,1,
32},{820,4,1,32},{64320,4,0,32},{59145,0,0,0},{821,4,1,32},{820,4,1,32},{64320,
4,0,32},{63806,0,0,0},{821,4,1,32},{820,4,1,32},{64320,4,0,32},{54285,0,0,0},
{821,4,1,32},{820,4,1,32},{64320,4,0,32},{62073,0,0,0},{821,4,1,32},{820,4,1,
32},{64321,4,0,32},{36001,0,0,0},{821,4,1,32},{820,4,1,32},{64320,4,0,32},
{63837,0,0,0},{821,4,1,32},{820,4,1,32},{64320,4,0,32},{53940,0,0,0},{821,4,1,
32},{820,4,1,32},{64320,4,0,32},{52963,0,0,0},{821,4,1,32},{820,4,1,32},{64320,
4,0,32},{54396,0,0,0},{821,4,1,32},{820,4,1,32},{64320,4,0,32},{56166,0,0,0},
{821,4,1,32},{820,4,1,32},{64320,4,0,32},{63203,0,0,0},{821,4,1,32},{820,4,1,
32},{64320,4,0,32},{52993,0,0,0},{821,4,1,32},{820,4,1,32},{64321,4,0,32},
{36039,0,0,0},{821,4,1,32},{820,4,1,32},{64320,4,0,32},{54100,0,0,0},{821,4,1,
32},{820,4,1,32},{64320,4,0,32},{63853,0,0,0},{821,4,1,32},{820,4,1,32},{64320,
4,0,32},{53009,0,0,0},{821,4,1,32},{820,4,1,32},{64321,4,0,32},{33258,0,0,0},
{821,4,1,32},{820,4,1,32},{64321,4,0,32},{33267,0,0,0},{821,4,1,32},{64320,6,0,
32},{54607,0,0,0},{64320,6,0,32},{56956,0,0,0},{64320,6,0,32},{58759,0,0,0},
{64320,6,0,32},{64399,0,0,0},{8300,6,0,32},{8299,6,0,32},{8301,6,0,32},{8299,6,
0,32},{8302,6,0,32},{8299,6,0,32},{8303,6,0,32},{8299,6,0,32},{8304,6,0,32},
{8299,6,0,32},{8305,6,0,32},{8299,6,0,32},{8306,6,0,32},{8299,6,0,32},{8307,6,0,
32},{8299,6,0,32},{8781,29,0,32},{8927,29,0,32},{8411,29,0,32},{8301,6,0,32},
{8300,6,0,32},{8301,6,0,32},{8301,6,0,32},{8301,6,0,32},{8302,6,0,32},{8301,6,0,
32},{8303,6,0,32},{8301,6,0,32},{8304,6,0,32},{8301,6,0,32},{8305,6,0,32},{8301,
6,0,32},{8306,6,0,32},{8301,6,0,32},{8307,6,0,32},{8301,6,0,32},{8308,6,0,32},
{8302,6,0,32},{8299,6,0,32},{8302,6,0,32},{8300,6,0,32},{8302,6,0,32},{8301,6,0,
32},{8302,6,0,32},{8302,6,0,32},{8302,6,0,32},{8303,6,0,32},{8302,6,0,32},{8304,
6,0,32},{17066,6,0,32},{17192,6,0,32},{17068,6,0,32},{17192,6,0,32},{17069,6,0,
32},{17192,6,0,32},{17071,6,0,32},{17192,6,0,32},{17072,6,0,32},{17192,6,0,32},
{17073,6,0,32},{17192,6,0,32},{17075,6,0,32},{17192,6,0,32},{17077,6,0,32},
{17192,6,0,32},{17078,6,0,32},{17192,6,0,32},{17080,6,0,32},{17192,6,0,32},
{17081,6,0,32},{17192,6,0,32},{17082,6,0,32},{17192,6,0,32},{17083,6,0,32},
{17192,6,0,32},{17084,6,0,32},{17192,6,0,32},{17080,6,0,32},{17192,6,0,32},
{17301,6,0,32},{17066,6,0,32},{17200,6,0,32},{17078,6,0,32},{17205,6,0,32},
{17077,6,0,32},{17211,6,0,32},{17077,6,0,32},{17205,6,0,32},{64320,6,0,32},
{52736,0,0,0},{64320,6,0,32},{52876,0,0,0},{64320,6,0,32},{52745,0,0,0},{64320,
6,0,32},{55003,0,0,0},{64320,6,0,32},{52884,0,0,0},{64320,6,0,32},{53613,0,0,0},
{64320,6,0,32},{52739,0,0,0},{64320,6,0,32},{53611,0,0,0},{64320,6,0,32},{52829,
0,0,0},{64320,6,0,32},{54081,0,0,0},{64320,6,0,32},{59144,0,0,0},{64320,6,0,32},
{61547,0,0,0},{64320,6,0,32},{60468,0,0,0},{64320,6,0,32},{59176,0,0,0},{64321,
6,0,32},{37329,0,0,0},{64320,6,0,32},{55071,0,0,0},{64320,6,0,32},{58853,0,0,0},
{64320,6,0,32},{59434,0,0,0},{64320,6,0,32},{59145,0,0,0},{64320,6,0,32},{63806,
0,0,0},{64320,6,0,32},{54285,0,0,0},{64320,6,0,32},{62073,0,0,0},{64321,6,0,32},
{36001,0,0,0},{64320,6,0,32},{63837,0,0,0},{64320,6,0,32},{53940,0,0,0},{64320,
6,0,32},{63960,0,0,0},{64320,6,0,32},{62775,0,0,0},{64320,6,0,32},{55667,0,0,0},
{64321,6,0,32},{36969,0,0,0},{64320,6,0,32},{53546,0,0,0},{64320,6,0,32},{54128,
0,0,0},{64320,6,0,32},{60648,0,0,0},{64321,6,0,32},{38917,0,0,0},{64320,6,0,32},
{53009,0,0,0},{64320,6,0,32},{53657,0,0,0},{64320,6,0,32},{60259,0,0,0},{64320,
6,0,32},{52746,0,0,0},{64320,6,0,32},{52781,0,0,0},{64320,6,0,32},{52747,0,0,0},
{64320,6,0,32},{56806,0,0,0},{64320,6,0,32},{54259,0,0,0},{64320,6,0,32},{54075,
0,0,0},{64320,6,0,32},{56215,0,0,0},{64320,6,0,32},{56166,0,0,0},{64320,6,0,32},
{63203,0,0,0},{64320,6,0,32},{52993,0,0,0},{64321,6,0,32},{36039,0,0,0},{64320,
6,0,32},{54100,0,0,0},{64320,6,0,32},{55580,0,0,0},{8302,6,0,32},{8305,6,0,32},
{8302,6,0,32},{8306,6,0,32},{8302,6,0,32},{8307,6,0,32},{8302,6,0,32},{8308,6,0,
32},{8303,6,0,32},{8299,6,0,32},{8303,6,0,32},{8300,6,0,32},{8303,6,0,32},{8301,
6,0,32},{8303,6,0,32},{8302,6,0,32},{8303,6,0,32},{8303,6,0,32},{8303,6,0,32},
{8304,6,0,32},{8303,6,0,32},{8305,6,0,32},{8303,6,0,32},{8306,6,0,32},{8303,6,0,
32},{8307,6,0,32},{8303,6,0,32},{8308,6,0,32},{8304,6,0,32},{8299,6,0,32},{8300,
4,0,32},{64320,4,0,32},{59144,0,0,0},{8301,4,0,32},{64320,4,0,32},{59144,0,0,0},
{8302,4,0,32},{64320,4,0,32},{59144,0,0,0},{8303,4,0,32},{64320,4,0,32},{59144,
0,0,0},{8304,4,0,32},{64320,4,0,32},{59144,0,0,0},{8305,4,0,32},{64320,4,0,32},
{59144,0,0,0},{8306,4,0,32},{64320,4,0,32},{59144,0,0,0},{8307,4,0,32},{64320,4,
0,32},{59144,0,0,0},{8308,4,0,32},{64320,4,0,32},{59144,0,0,0},{8300,4,0,32},
{8299,4,0,32},{64320,4,0,32},{59144,0,0,0},{8300,4,0,32},{8300,4,0,32},{64320,4,
0,32},{59144,0,0,0},{8300,4,0,32},{8301,4,0,32},{64320,4,0,32},{59144,0,0,0},
{8524,29,0,32},{8485,28,0,32},{8411,28,0,32},{8821,28,0,32},{8485,28,0,32},
{8411,28,0,32},{9009,29,0,32},{8624,29,0,32},{8927,29,0,32},{8383,29,0,32},
{64320,28,0,32},{52964,0,0,0},{64320,28,0,32},{54412,0,0,0},{17423,28,0,32},
{17449,28,0,32},{0,28,0,56},{8242,28,0,32},{17443,28,0,32},{17423,28,0,32},
{17466,28,0,32},{17451,28,0,32},{17423,28,0,32},{17423,28,0,32},{17474,28,0,32},
{17452,28,0,32},{0,28,0,56},{17423,28,0,32},{17423,28,0,32},{8242,28,0,32},
{17466,28,0,32},{17424,28,0,32},{17445,28,0,32},{17474,28,0,32},{17431,28,0,32},
{0,28,0,55},{17424,28,0,32},{17474,28,0,32},{17440,28,0,32},{17425,28,0,32},
{17428,28,0,32},{17474,28,0,32},{17427,28,0,32},{17436,28,0,32},{17431,28,0,32},
{8242,28,0,32},{17443,28,0,32},{0,28,0,55},{17427,28,0,32},{8242,28,0,32},
{17429,28,0,32},{8242,28,0,32},{17428,28,0,32},{17474,28,0,32},{17436,28,0,32},
{17428,28,0,32},{8242,28,0,32},{17456,28,0,32},{17429,28,0,32},{17424,28,0,32},
{17465,28,0,32},{17429,28,0,32},{17464,28,0,32},{17441,28,0,32},{17443,28,0,32},
{17429,28,0,32},{17468,28,0,32},{17465,28,0,32},{8242,28,0,32},{17429,28,0,32},
{0,28,0,55},{17468,28,0,32},{17474,28,0,32},{17429,28,0,32},{0,28,0,55},{17474,
28,0,32},{17454,28,0,32},{17430,28,0,32},{0,28,0,55},{17429,28,0,32},{0,28,0,
55},{17430,28,0,32},{0,28,0,55},{17445,28,0,32},{8242,28,0,32},{17430,28,0,32},
{17461,28,0,32},{17465,28,0,32},{8242,28,0,32},{17430,28,0,32},{0,28,0,55},
{17466,28,0,32},{17439,28,0,32},{0,28,0,55},{8242,28,0,32},{17430,28,0,32},
{17468,28,0,32},{17430,28,0,32},{17468,28,0,32},{17431,28,0,32},{0,28,0,55},
{17464,28,0,32},{17456,28,0,32},{17430,28,0,32},{17468,28,0,32},{17457,28,0,32},
{8242,28,0,32},{17443,28,0,32},{17466,28,0,32},{17430,28,0,32},{17468,28,0,32},
{17469,28,0,32},{17441,28,0,32},{17443,28,0,32},{17431,28,0,32},{0,28,0,55},
{17464,28,0,32},{17456,28,0,32},{17431,28,0,32},{0,28,0,55},{17464,28,0,32},
{17456,28,0,32},{17443,28,0,32},{17474,28,0,32},{17431,28,0,32},{17466,28,0,32},
{17437,28,0,32},{0,28,0,55},{17424,28,0,32},{17468,28,0,32},{17431,28,0,32},
{17468,28,0,32},{8242,28,0,32},{17447,28,0,32},{17432,28,0,32},{8242,28,0,32},
{17436,28,0,32},{17433,28,0,32},{17466,28,0,32},{17444,28,0,32},{17433,28,0,32},
{8242,28,0,32},{17453,28,0,32},{0,28,0,56},{17434,28,0,32},{17424,28,0,32},
{17431,28,0,32},{17466,28,0,32},{17434,28,0,32},{17474,28,0,32},{17440,28,0,32},
{8242,28,0,32},{17456,28,0,32},{17435,28,0,32},{17465,28,0,32},{17474,28,0,32},
{17431,28,0,32},{0,28,0,55},{17437,28,0,32},{17474,28,0,32},{17440,28,0,32},
{17437,28,0,32},{17474,28,0,32},{17443,28,0,32},{17439,28,0,32},{0,28,0,55},
{8242,28,0,32},{17436,28,0,32},{17442,28,0,32},{0,28,0,55},{17435,28,0,32},
{17443,28,0,32},{0,28,0,55},{17466,28,0,32},{17443,28,0,32},{17474,28,0,32},
{17444,28,0,32},{17448,28,0,32},{17448,28,0,32},{17441,28,0,32},{17443,28,0,32},
{17449,28,0,32},{17424,28,0,32},{17441,28,0,32},{17449,28,0,32},{0,28,0,56},
{8242,28,0,32},{17437,28,0,32},{17474,28,0,32},{17443,28,0,32},{17449,28,0,32},
{0,28,0,56},{8242,28,0,32},{17441,28,0,32},{17449,28,0,32},{0,28,0,55},{8242,28,
0,32},{17467,28,0,32},{17466,28,0,32},{17450,28,0,32},{0,28,0,56},{17423,28,0,
32},{17436,28,0,32},{17443,28,0,32},{17466,28,0,32},{17450,28,0,32},{0,28,0,56},
{17431,28,0,32},{17466,28,0,32},{17450,28,0,32},{0,28,0,56},{17433,28,0,32},
{17450,28,0,32},{0,28,0,55},{17466,28,0,32},{17451,28,0,32},{17423,28,0,32},
{17464,28,0,32},{17441,28,0,32},{17443,28,0,32},{0,28,0,55},{17451,28,0,32},
{17424,28,0,32},{8242,28,0,32},{17443,28,0,32},{17451,28,0,32},{0,28,0,55},
{17441,28,0,32},{17435,28,0,32},{17427,28,0,32},{17466,28,0,32},{17451,28,0,32},
{17464,28,0,32},{17474,28,0,32},{17452,28,0,32},{17431,28,0,32},{17439,28,0,32},
{8242,28,0,32},{17466,28,0,32},{17452,28,0,32},{0,28,0,56},{17438,28,0,32},
{17452,28,0,32},{0,28,0,56},{17445,28,0,32},{17450,28,0,32},{17452,28,0,32},
{17466,28,0,32},{17441,28,0,32},{17452,28,0,32},{0,28,0,56},{17474,28,0,32},
{17436,28,0,32},{17452,28,0,32},{0,28,0,56},{8242,28,0,32},{17435,28,0,32},{0,
28,0,55},{17452,28,0,32},{0,28,0,55},{8242,28,0,32},{17439,28,0,32},{17453,28,0,
32},{0,28,0,56},{17424,28,0,32},{17474,28,0,32},{17443,28,0,32},{17453,28,0,32},
{0,28,0,55},{17466,28,0,32},{17443,28,0,32},{17453,28,0,32},{17474,28,0,32},
{17453,28,0,32},{0,28,0,56},{17474,28,0,32},{17443,28,0,32},{0,28,0,55},{17453,
28,0,32},{8242,28,0,32},{17466,28,0,32},{17453,28,0,32},{8242,28,0,32},{17474,
28,0,32},{17454,28,0,32},{17424,28,0,32},{17431,28,0,32},{17468,28,0,32},{17454,
28,0,32},{17424,28,0,32},{17466,28,0,32},{17454,28,0,32},{17441,28,0,32},{17449,
28,0,32},{17454,28,0,32},{17466,28,0,32},{17431,28,0,32},{17454,28,0,32},{17474,
28,0,32},{17435,28,0,32},{17463,28,0,32},{17474,28,0,32},{17455,28,0,32},{17431,
28,0,32},{17468,28,0,32},{17474,28,0,32},{17455,28,0,32},{17465,28,0,32},{17455,
28,0,32},{17465,28,0,32},{17449,28,0,32},{0,28,0,55},{8242,28,0,32},{17466,28,0,
32},{17457,28,0,32},{17429,28,0,32},{0,28,0,55},{17457,28,0,32},{17429,28,0,32},
{0,28,0,55},{17443,28,0,32},{17474,28,0,32},{17457,28,0,32},{8242,28,0,32},
{17443,28,0,32},{17466,28,0,32},{17459,28,0,32},{8242,28,0,32},{17443,28,0,32},
{0,28,0,55},{17459,28,0,32},{8242,28,0,32},{17466,28,0,32},{17461,28,0,32},
{17423,28,0,32},{17474,28,0,32},{17465,28,0,32},{17441,28,0,32},{17443,28,0,32},
{17466,28,0,32},{17465,28,0,32},{17464,28,0,32},{17466,28,0,32},{17450,28,0,32},
{0,28,0,56},{8242,28,0,32},{17466,28,0,32},{8242,28,0,32},{17451,28,0,32},{0,28,
0,55},{17466,28,0,32},{17467,28,0,32},{17456,28,0,32},{17467,28,0,32},{17474,28,
0,32},{17443,28,0,32},{17432,28,0,32},{0,28,0,55},{17474,28,0,32},{17469,28,0,
32},{17441,28,0,32},{17443,28,0,32},{8299,4,0,32},{64320,4,0,32},{61625,0,0,0},
{8300,4,0,32},{64320,4,0,32},{61625,0,0,0},{8301,4,0,32},{64320,4,0,32},{61625,
0,0,0},{8302,4,0,32},{64320,4,0,32},{61625,0,0,0},{8303,4,0,32},{64320,4,0,32},
{61625,0,0,0},{8304,4,0,32},{64320,4,0,32},{61625,0,0,0},{8305,4,0,32},{64320,4,
0,32},{61625,0,0,0},{8306,4,0,32},{64320,4,0,32},{61625,0,0,0},{8307,4,0,32},
{64320,4,0,32},{61625,0,0,0},{8308,4,0,32},{64320,4,0,32},{61625,0,0,0},{8300,4,
0,32},{8299,4,0,32},{64320,4,0,32},{61625,0,0,0},{8300,4,0,32},{8300,4,0,32},
{64320,4,0,32},{61625,0,0,0},{8300,4,0,32},{8301,4,0,32},{64320,4,0,32},{61625,
0,0,0},{8300,4,0,32},{8302,4,0,32},{64320,4,0,32},{61625,0,0,0},{8300,4,0,32},
{8303,4,0,32},{64320,4,0,32},{61625,0,0,0},{8300,4,0,32},{8304,4,0,32},{64320,4,
0,32},{61625,0,0,0},{8300,4,0,32},{8305,4,0,32},{64320,4,0,32},{61625,0,0,0},
{8300,4,0,32},{8306,4,0,32},{64320,4,0,32},{61625,0,0,0},{8300,4,0,32},{8307,4,
0,32},{64320,4,0,32},{61625,0,0,0},{8300,4,0,32},{8308,4,0,32},{64320,4,0,32},
{61625,0,0,0},{8301,4,0,32},{8299,4,0,32},{64320,4,0,32},{61625,0,0,0},{8301,4,
0,32},{8300,4,0,32},{64320,4,0,32},{61625,0,0,0},{8301,4,0,32},{8301,4,0,32},
{64320,4,0,32},{61625,0,0,0},{8301,4,0,32},{8302,4,0,32},{64320,4,0,32},{61625,
0,0,0},{8301,4,0,32},{8303,4,0,32},{64320,4,0,32},{61625,0,0,0},{8524,28,0,32},
{8781,29,0,32},{8309,28,0,32},{8383,28,0,32},{8309,28,0,32},{8309,29,0,32},
{8961,29,0,32},{8335,28,0,32},{8309,28,0,32},{8821,28,0,32},{8733,28,0,32},
{9009,29,0,32},{8781,28,0,32},{8361,28,0,32},{8383,28,0,32},{8680,28,0,32},
{8383,28,0,32},{8680,28,0,32},{8301,28,0,32},{8383,28,0,32},{8680,28,0,32},
{8302,28,0,32},{8551,29,0,32},{8961,29,0,32},{64320,28,0,32},{56947,0,0,0},
{64320,28,0,32},{57872,0,0,0},{64320,28,0,32},{58925,0,0,0},{64320,28,0,32},
{54412,0,0,0},{64320,28,0,32},{55591,0,0,0},{64320,28,0,32},{60259,0,0,0},
{64320,28,0,32},{58894,0,0,0},{64320,28,0,32},{60603,0,0,0},{64320,28,0,32},
{59434,0,0,0},{64320,28,0,32},{57103,0,0,0},{64320,28,0,32},{53018,0,0,0},
{64320,28,0,32},{63806,0,0,0},{8781,28,0,32},{8309,29,0,32},{8695,28,0,32},
{8309,29,0,32},{9247,28,0,32},{8309,29,0,32},{8680,28,0,32},{8309,29,0,32},
{8604,28,0,32},{8309,29,0,32},{8604,29,0,32},{8335,29,0,32},{8680,29,0,32},
{8335,29,0,32},{8485,29,0,32},{8335,29,0,32},{8361,28,0,32},{8309,28,0,32},
{8624,28,0,32},{8604,28,0,32},{8361,28,0,32},{8309,28,0,32},{8624,28,0,32},
{8781,28,0,32},{8470,29,0,32},{8695,28,0,32},{8470,29,0,32},{9247,28,0,32},
{8470,29,0,32},{9247,28,0,32},{8485,28,0,32},{8680,28,0,32},{8485,28,0,32},
{8604,28,0,32},{8485,28,0,32},{8524,29,0,32},{9071,28,0,32},{8604,28,0,32},
{8524,29,0,32},{9071,28,0,32},{8680,29,0,32},{8524,29,0,32},{9071,28,0,32},
{8485,29,0,32},{8524,29,0,32},{9071,28,0,32},{8927,29,0,32},{8524,29,0,32},
{9071,28,0,32},{9247,28,0,32},{8624,28,0,32},{8680,28,0,32},{8624,28,0,32},
{8383,28,0,32},{8624,28,0,32},{8604,28,0,32},{8624,28,0,32},{8470,28,0,32},
{8680,28,0,32},{8695,28,0,32},{8680,28,0,32},{9247,28,0,32},{8680,28,0,32},
{8680,28,0,32},{8680,28,0,32},{8361,28,0,32},{8680,28,0,32},{8604,28,0,32},
{8680,28,0,32},{8680,28,0,32},{8680,28,0,32},{8301,28,0,32},{8361,28,0,32},
{8680,28,0,32},{8301,28,0,32},{8680,28,0,32},{8301,28,0,32},{8604,28,0,32},
{8680,28,0,32},{8301,28,0,32},{8680,28,0,32},{8680,28,0,32},{8302,28,0,32},
{8361,28,0,32},{8680,28,0,32},{8302,28,0,32},{8680,28,0,32},{8302,28,0,32},
{8604,28,0,32},{8680,28,0,32},{8302,28,0,32},{8680,28,0,32},{1708,28,1,32},
{8886,28,0,32},{8680,28,0,32},{1708,28,1,32},{8886,28,0,32},{8301,28,0,32},
{8781,29,0,32},{8309,28,0,32},{8604,28,0,32},{8781,29,0,32},{8309,28,0,32},
{8680,29,0,32},{8781,29,0,32},{8309,28,0,32},{8485,29,0,32},{8781,29,0,32},
{8309,28,0,32},{8821,28,0,32},{8309,28,0,32},{8383,28,0,32},{8821,28,0,32},
{8309,28,0,32},{8383,28,0,32},{1708,28,1,32},{8886,28,0,32},{8821,28,0,32},
{8309,28,0,32},{8383,28,0,32},{1708,28,1,32},{8886,28,0,32},{8301,28,0,32},
{8781,28,0,32},{8886,28,0,32},{8695,28,0,32},{8886,28,0,32},{9247,28,0,32},
{8886,28,0,32},{8680,28,0,32},{8886,28,0,32},{8781,28,0,32},{9009,29,0,32},
{8695,28,0,32},{9009,29,0,32},{9247,28,0,32},{9009,29,0,32},{8680,28,0,32},
{9009,29,0,32},{8604,28,0,32},{9009,29,0,32},{8680,29,0,32},{9009,29,0,32},
{8781,28,0,32},{9027,29,0,32},{8695,28,0,32},{9027,29,0,32},{9247,28,0,32},
{9027,29,0,32},{8680,28,0,32},{9027,29,0,32},{8604,28,0,32},{9027,29,0,32},
{8680,29,0,32},{9027,29,0,32},{8604,28,0,32},{9269,29,0,32},{8680,29,0,32},
{9269,29,0,32},{8309,28,0,32},{641,28,1,32},{8680,28,0,32},{641,28,1,32},{8335,
29,0,32},{8802,28,0,32},{8361,28,0,32},{8361,28,0,32},{8361,28,0,32},{8383,28,0,
32},{8361,29,0,32},{1708,28,1,32},{8604,28,0,32},{8485,28,0,32},{8361,29,0,32},
{8733,28,0,32},{641,28,1,32},{8383,28,0,32},{8335,29,0,32},{8485,29,0,32},{9049,
28,0,32},{8524,28,0,32},{8309,28,0,32},{8524,29,0,32},{8781,29,0,32},{8551,28,0,
32},{8695,28,0,32},{8604,29,0,32},{8604,29,0,32},{8604,29,0,32},{8680,29,0,32},
{8604,28,0,32},{8927,28,0,32},{8624,28,0,32},{8680,28,0,32},{8624,28,0,32},
{8695,28,0,32},{8624,28,0,32},{8733,28,0,32},{8485,28,0,32},{8624,28,0,32},
{9037,28,0,32},{8680,28,0,32},{8335,28,0,32},{8680,28,0,32},{8551,28,0,32},
{8624,28,0,32},{8680,28,0,32},{8733,28,0,32},{8624,28,0,32},{8781,29,0,32},
{8524,29,0,32},{8781,28,0,32},{641,28,1,32},{8680,28,0,32},{641,28,1,32},{8781,
29,0,32},{8781,29,0,32},{8680,29,0,32},{8781,29,0,32},{8821,29,0,32},{8886,28,0,
32},{8821,28,0,32},{8886,29,0,32},{9009,28,0,32},{9027,29,0,32},{8335,28,0,32},
{9009,29,0,32},{1708,28,1,32},{8680,28,0,32},{8309,29,0,32},{1708,28,1,32},
{8680,28,0,32},{8300,4,0,32},{64320,4,0,32},{58853,0,0,0},{8301,4,0,32},{64320,
4,0,32},{58853,0,0,0},{8302,4,0,32},{64320,4,0,32},{58853,0,0,0},{8303,4,0,32},
{64320,4,0,32},{58853,0,0,0},{8304,4,0,32},{64320,4,0,32},{58853,0,0,0},{8305,4,
0,32},{64320,4,0,32},{58853,0,0,0},{8306,4,0,32},{64320,4,0,32},{58853,0,0,0},
{8307,4,0,32},{64320,4,0,32},{58853,0,0,0},{8308,4,0,32},{64320,4,0,32},{58853,
0,0,0},{8300,4,0,32},{8299,4,0,32},{64320,4,0,32},{58853,0,0,0},{8300,4,0,32},
{8300,4,0,32},{64320,4,0,32},{58853,0,0,0},{8300,4,0,32},{8301,4,0,32},{64320,4,
0,32},{58853,0,0,0},{8300,4,0,32},{8302,4,0,32},{64320,4,0,32},{58853,0,0,0},
{8300,4,0,32},{8303,4,0,32},{64320,4,0,32},{58853,0,0,0},{8300,4,0,32},{8304,4,
0,32},{64320,4,0,32},{58853,0,0,0},{8300,4,0,32},{8305,4,0,32},{64320,4,0,32},
{58853,0,0,0},{8300,4,0,32},{8306,4,0,32},{64320,4,0,32},{58853,0,0,0},{8300,4,
0,32},{8307,4,0,32},{64320,4,0,32},{58853,0,0,0},{8300,4,0,32},{8308,4,0,32},
{64320,4,0,32},{58853,0,0,0},{8301,4,0,32},{8299,4,0,32},{64320,4,0,32},{58853,
0,0,0},{8301,4,0,32},{8300,4,0,32},{64320,4,0,32},{58853,0,0,0},{8301,4,0,32},
{8301,4,0,32},{64320,4,0,32},{58853,0,0,0},{8301,4,0,32},{8302,4,0,32},{64320,4,
0,32},{58853,0,0,0},{8301,4,0,32},{8303,4,0,32},{64320,4,0,32},{58853,0,0,0},
{8301,4,0,32},{8304,4,0,32},{64320,4,0,32},{58853,0,0,0},{8301,4,0,32},{8305,4,
0,32},{64320,4,0,32},{58853,0,0,0},{8301,4,0,32},{8306,4,0,32},{64320,4,0,32},
{58853,0,0,0},{8301,4,0,32},{8307,4,0,32},{64320,4,0,32},{58853,0,0,0},{8301,4,
0,32},{8308,4,0,32},{64320,4,0,32},{58853,0,0,0},{8302,4,0,32},{8299,4,0,32},
{64320,4,0,32},{58853,0,0,0},{8302,4,0,32},{8300,4,0,32},{64320,4,0,32},{58853,
0,0,0},{8485,28,0,32},{8309,28,0,32},{8624,28,0,32},{64384,2,0,32},{46238,0,0,
0},{64384,2,0,32},{46265,0,0,0},{64384,2,0,32},{46267,0,0,0},{64384,2,0,32},
{46303,0,0,0},{64384,2,0,32},{46357,0,0,0},{64384,2,0,32},{46830,0,0,0},{64384,
2,0,32},{46844,0,0,0},{64384,2,0,32},{46977,0,0,0},{64384,2,0,32},{47151,0,0,0},
{64384,2,0,32},{47202,0,0,0},{64384,2,0,32},{47228,0,0,0},{64384,2,0,32},{47303,
0,0,0},{64384,2,0,32},{47331,0,0,0},{64384,2,0,32},{47388,0,0,0},{64384,2,0,32},
{47418,0,0,0},{64384,2,0,32},{47662,0,0,0},{64384,2,0,32},{47724,0,0,0},{64384,
2,0,32},{47844,0,0,0},{64384,2,0,32},{47880,0,0,0},{64384,2,0,32},{47897,0,0,0},
{64384,2,0,32},{47945,0,0,0},{64384,2,0,32},{48029,0,0,0},{64384,2,0,32},{48152,
0,0,0},{64384,2,0,32},{48206,0,0,0},{64384,2,0,32},{48435,0,0,0},{64384,2,0,32},
{48534,0,0,0},{64384,2,0,32},{48812,0,0,0},{64384,2,0,32},{48824,0,0,0},{64384,
2,0,32},{48923,0,0,0},{64384,2,0,32},{49148,0,0,0},{64384,2,0,32},{49160,0,0,0},
{64384,2,0,32},{49176,0,0,0},{64384,2,0,32},{49209,0,0,0},{64384,2,0,32},{49222,
0,0,0},{64384,2,0,32},{49302,0,0,0},{64384,2,0,32},{49379,0,0,0},{64384,2,0,32},
{49455,0,0,0},{64384,2,0,32},{49666,0,0,0},{64384,2,0,32},{49703,0,0,0},{64384,
2,0,32},{49824,0,0,0},{64384,2,0,32},{49921,0,0,0},{64384,2,0,32},{49972,0,0,0},
{64384,2,0,32},{50009,0,0,0},{64384,2,0,32},{50133,0,0,0},{64384,2,0,32},{50137,
0,0,0},{64384,2,0,32},{50187,0,0,0},{64384,2,0,32},{50283,0,0,0},{64384,2,0,32},
{50475,0,0,0},{64384,2,0,32},{50525,0,0,0},{64384,2,0,32},{50529,0,0,0},{64384,
2,0,32},{50539,0,0,0},{64384,2,0,32},{50647,0,0,0},{64384,2,0,32},{50681,0,0,0},
{64384,2,0,32},{50741,0,0,0},{64384,2,0,32},{50878,0,0,0},{64384,2,0,32},{50887,
0,0,0},{64384,2,0,32},{51605,0,0,0},{64384,2,0,32},{51686,0,0,0},{64384,2,0,32},
{51822,0,0,0},{64384,2,0,32},{51830,0,0,0},{64384,2,0,32},{51890,0,0,0},{64384,
2,0,32},{52019,0,0,0},{64384,2,0,32},{52174,0,0,0},{64384,2,0,32},{52430,0,0,0},
{64384,2,0,32},{52461,0,0,0},{64384,2,0,32},{52472,0,0,0},{64384,2,0,32},{52566,
0,0,0},{64320,2,0,32},{52749,0,0,0},{64320,2,0,32},{52774,0,0,0},{64320,2,0,32},
{52786,0,0,0},{64320,2,0,32},{52792,0,0,0},{64320,2,0,32},{52793,0,0,0},{64320,
2,0,32},{52797,0,0,0},{64320,2,0,32},{52801,0,0,0},{64320,2,0,32},{52866,0,0,0},
{64320,2,0,32},{52870,0,0,0},{64320,2,0,32},{52910,0,0,0},{64320,2,0,32},{52928,
0,0,0},{64320,2,0,32},{52940,0,0,0},{64320,2,0,32},{52964,0,0,0},{64320,2,0,32},
{53088,0,0,0},{64320,2,0,32},{53120,0,0,0},{64320,2,0,32},{53126,0,0,0},{64320,
2,0,32},{53131,0,0,0},{64320,2,0,32},{53166,0,0,0},{64320,2,0,32},{53179,0,0,0},
{64320,2,0,32},{53183,0,0,0},{64320,2,0,32},{53250,0,0,0},{64320,2,0,32},{53291,
0,0,0},{64320,2,0,32},{53370,0,0,0},{64320,2,0,32},{53401,0,0,0},{64320,2,0,32},
{53455,0,0,0},{64320,2,0,32},{53466,0,0,0},{64320,2,0,32},{53479,0,0,0},{64320,
2,0,32},{53568,0,0,0},{64320,2,0,32},{53573,0,0,0},{64320,2,0,32},{53581,0,0,0},
{64320,2,0,32},{53588,0,0,0},{64320,2,0,32},{53604,0,0,0},{64320,2,0,32},{53607,
0,0,0},{64320,2,0,32},{53608,0,0,0},{64320,2,0,32},{53609,0,0,0},{64320,2,0,32},
{53613,0,0,0},{64320,2,0,32},{53623,0,0,0},{64320,2,0,32},{53632,0,0,0},{64320,
2,0,32},{53645,0,0,0},{64320,2,0,32},{53650,0,0,0},{64320,2,0,32},{53653,0,0,0},
{64320,2,0,32},{53655,0,0,0},{64320,2,0,32},{53668,0,0,0},{64320,2,0,32},{53676,
0,0,0},{64320,2,0,32},{53685,0,0,0},{64320,2,0,32},{53687,0,0,0},{64320,2,0,32},
{53705,0,0,0},{64320,2,0,32},{53708,0,0,0},{64320,2,0,32},{53724,0,0,0},{64320,
2,0,32},{53726,0,0,0},{64320,2,0,32},{53749,0,0,0},{64320,2,0,32},{53763,0,0,0},
{64320,2,0,32},{53767,0,0,0},{64320,2,0,32},{53783,0,0,0},{64320,2,0,32},{53801,
0,0,0},{64320,2,0,32},{53818,0,0,0},{64320,2,0,32},{53819,0,0,0},{64320,2,0,32},
{53830,0,0,0},{64320,2,0,32},{53874,0,0,0},{64320,2,0,32},{53879,0,0,0},{64320,
2,0,32},{53897,0,0,0},{64320,2,0,32},{53915,0,0,0},{64320,2,0,32},{53923,0,0,0},
{64320,2,0,32},{53939,0,0,0},{64320,2,0,32},{53959,0,0,0},{64320,2,0,32},{53961,
0,0,0},{64320,2,0,32},{53970,0,0,0},{64320,2,0,32},{53982,0,0,0},{64320,2,0,32},
{53988,0,0,0},{64320,2,0,32},{54005,0,0,0},{64320,2,0,32},{54010,0,0,0},{64320,
2,0,32},{54021,0,0,0},{64320,2,0,32},{54022,0,0,0},{64320,2,0,32},{54039,0,0,0},
{64320,2,0,32},{54079,0,0,0},{64320,2,0,32},{54089,0,0,0},{64320,2,0,32},{54097,
0,0,0},{64320,2,0,32},{54106,0,0,0},{64320,2,0,32},{54131,0,0,0},{64320,2,0,32},
{54133,0,0,0},{64320,2,0,32},{54141,0,0,0},{64320,2,0,32},{54143,0,0,0},{64320,
2,0,32},{54211,0,0,0},{64320,2,0,32},{54218,0,0,0},{64320,2,0,32},{54239,0,0,0},
{64320,2,0,32},{54245,0,0,0},{64320,2,0,32},{54251,0,0,0},{64320,2,0,32},{54257,
0,0,0},{64320,2,0,32},{54278,0,0,0},{64320,2,0,32},{54287,0,0,0},{64320,2,0,32},
{54301,0,0,0},{64320,2,0,32},{54328,0,0,0},{64320,2,0,32},{54338,0,0,0},{64320,
2,0,32},{54344,0,0,0},{64320,2,0,32},{54376,0,0,0},{64320,2,0,32},{54430,0,0,0},
{64320,2,0,32},{54434,0,0,0},{64320,2,0,32},{54461,0,0,0},{64320,2,0,32},{54518,
0,0,0},{64320,2,0,32},{54544,0,0,0},{64320,2,0,32},{54611,0,0,0},{64320,2,0,32},
{54613,0,0,0},{64320,2,0,32},{54627,0,0,0},{64320,2,0,32},{54660,0,0,0},{64320,
2,0,32},{54663,0,0,0},{64320,2,0,32},{54681,0,0,0},{64320,2,0,32},{54685,0,0,0},
{64320,2,0,32},{54699,0,0,0},{64320,2,0,32},{54707,0,0,0},{64320,2,0,32},{54720,
0,0,0},{64320,2,0,32},{54722,0,0,0},{64320,2,0,32},{54754,0,0,0},{64320,2,0,32},
{54790,0,0,0},{64320,2,0,32},{54865,0,0,0},{64320,2,0,32},{54888,0,0,0},{64320,
2,0,32},{54900,0,0,0},{64320,2,0,32},{55033,0,0,0},{64320,2,0,32},{55062,0,0,0},
{64320,2,0,32},{55063,0,0,0},{64320,2,0,32},{55179,0,0,0},{64320,2,0,32},{55246,
0,0,0},{64320,2,0,32},{55284,0,0,0},{64320,2,0,32},{55309,0,0,0},{64320,2,0,32},
{55345,0,0,0},{64320,2,0,32},{55346,0,0,0},{64320,2,0,32},{55360,0,0,0},{64320,
2,0,32},{55386,0,0,0},{64320,2,0,32},{55390,0,0,0},{64320,2,0,32},{55464,0,0,0},
{64320,2,0,32},{55468,0,0,0},{64320,2,0,32},{55475,0,0,0},{64320,2,0,32},{55512,
0,0,0},{64320,2,0,32},{55519,0,0,0},{64320,2,0,32},{55534,0,0,0},{64320,2,0,32},
{55538,0,0,0},{64320,2,0,32},{55543,0,0,0},{64320,2,0,32},{55558,0,0,0},{64320,
2,0,32},{55578,0,0,0},{64320,2,0,32},{55586,0,0,0},{64320,2,0,32},{55620,0,0,0},
{64320,2,0,32},{55624,0,0,0},{64320,2,0,32},{55633,0,0,0},{64320,2,0,32},{55636,
0,0,0},{64320,2,0,32},{55650,0,0,0},{64320,2,0,32},{55667,0,0,0},{64320,2,0,32},
{55768,0,0,0},{64320,2,0,32},{55788,0,0,0},{64320,2,0,32},{55835,0,0,0},{64320,
2,0,32},{55847,0,0,0},{64320,2,0,32},{55906,0,0,0},{64320,2,0,32},{55910,0,0,0},
{64320,2,0,32},{55989,0,0,0},{64320,2,0,32},{56072,0,0,0},{64320,2,0,32},{56104,
0,0,0},{64320,2,0,32},{56126,0,0,0},{64320,2,0,32},{56197,0,0,0},{64320,2,0,32},
{56259,0,0,0},{64320,2,0,32},{56280,0,0,0},{64320,2,0,32},{56295,0,0,0},{64320,
2,0,32},{56302,0,0,0},{64320,2,0,32},{56307,0,0,0},{64320,2,0,32},{56319,0,0,0},
{64320,2,0,32},{56326,0,0,0},{64320,2,0,32},{56354,0,0,0},{64320,2,0,32},{56383,
0,0,0},{64320,2,0,32},{56416,0,0,0},{64320,2,0,32},{56418,0,0,0},{64320,2,0,32},
{56420,0,0,0},{64320,2,0,32},{56421,0,0,0},{64320,2,0,32},{56430,0,0,0},{64320,
2,0,32},{56461,0,0,0},{64320,2,0,32},{56512,0,0,0},{64320,2,0,32},{56601,0,0,0},
{64320,2,0,32},{56643,0,0,0},{64320,2,0,32},{56656,0,0,0},{64320,2,0,32},{56683,
0,0,0},{64320,2,0,32},{56686,0,0,0},{64320,2,0,32},{56700,0,0,0},{64320,2,0,32},
{56754,0,0,0},{64320,2,0,32},{56762,0,0,0},{64320,2,0,32},{56801,0,0,0},{64320,
2,0,32},{56802,0,0,0},{64320,2,0,32},{56829,0,0,0},{64320,2,0,32},{56872,0,0,0},
{64320,2,0,32},{56893,0,0,0},{64320,2,0,32},{56937,0,0,0},{64320,2,0,32},{56948,
0,0,0},{64320,2,0,32},{56998,0,0,0},{64320,2,0,32},{57008,0,0,0},{64320,2,0,32},
{57011,0,0,0},{64320,2,0,32},{57014,0,0,0},{64320,2,0,32},{57033,0,0,0},{64320,
2,0,32},{57034,0,0,0},{64320,2,0,32},{57042,0,0,0},{64320,2,0,32},{57043,0,0,0},
{64320,2,0,32},{57049,0,0,0},{64320,2,0,32},{57068,0,0,0},{64320,2,0,32},{57086,
0,0,0},{64320,2,0,32},{57092,0,0,0},{64320,2,0,32},{57122,0,0,0},{64320,2,0,32},
{57171,0,0,0},{64320,2,0,32},{57186,0,0,0},{64320,2,0,32},{57193,0,0,0},{64320,
2,0,32},{57195,0,0,0},{64320,2,0,32},{57227,0,0,0},{64320,2,0,32},{57242,0,0,0},
{64320,2,0,32},{57257,0,0,0},{64320,2,0,32},{57261,0,0,0},{64320,2,0,32},{57293,
0,0,0},{64320,2,0,32},{57303,0,0,0},{64320,2,0,32},{57333,0,0,0},{64320,2,0,32},
{57337,0,0,0},{64320,2,0,32},{57362,0,0,0},{64320,2,0,32},{57372,0,0,0},{64320,
2,0,32},{57461,0,0,0},{64320,2,0,32},{57473,0,0,0},{64320,2,0,32},{57492,0,0,0},
{64320,2,0,32},{57543,0,0,0},{64320,2,0,32},{57560,0,0,0},{64320,2,0,32},{57569,
0,0,0},{64320,2,0,32},{57608,0,0,0},{64320,2,0,32},{57668,0,0,0},{64320,2,0,32},
{57672,0,0,0},{64320,2,0,32},{57676,0,0,0},{64320,2,0,32},{57678,0,0,0},{64320,
2,0,32},{57696,0,0,0},{64320,2,0,32},{57704,0,0,0},{64320,2,0,32},{57722,0,0,0},
{64320,2,0,32},{57742,0,0,0},{64320,2,0,32},{57744,0,0,0},{64320,2,0,32},{57764,
0,0,0},{64320,2,0,32},{57775,0,0,0},{64320,2,0,32},{57778,0,0,0},{64320,2,0,32},
{57822,0,0,0},{64320,2,0,32},{57842,0,0,0},{64320,2,0,32},{57846,0,0,0},{64320,
2,0,32},{57856,0,0,0},{64320,2,0,32},{57872,0,0,0},{64320,2,0,32},{57883,0,0,0},
{64320,2,0,32},{57902,0,0,0},{64320,2,0,32},{57908,0,0,0},{64320,2,0,32},{57949,
0,0,0},{64320,2,0,32},{58033,0,0,0},{64320,2,0,32},{58057,0,0,0},{64320,2,0,32},
{58063,0,0,0},{64320,2,0,32},{58067,0,0,0},{64320,2,0,32},{58068,0,0,0},{64320,
2,0,32},{58108,0,0,0},{64320,2,0,32},{58110,0,0,0},{64320,2,0,32},{58173,0,0,0},
{64320,2,0,32},{58192,0,0,0},{64320,2,0,32},{58216,0,0,0},{64320,2,0,32},{58235,
0,0,0},{64320,2,0,32},{58243,0,0,0},{64320,2,0,32},{58272,0,0,0},{64320,2,0,32},
{58281,0,0,0},{64320,2,0,32},{58308,0,0,0},{64320,2,0,32},{58309,0,0,0},{64320,
2,0,32},{58340,0,0,0},{64320,2,0,32},{58396,0,0,0},{64320,2,0,32},{58402,0,0,0},
{64320,2,0,32},{58450,0,0,0},{64320,2,0,32},{58473,0,0,0},{64320,2,0,32},{58487,
0,0,0},{64320,2,0,32},{58494,0,0,0},{64320,2,0,32},{58522,0,0,0},{64320,2,0,32},
{58525,0,0,0},{64320,2,0,32},{58564,0,0,0},{64320,2,0,32},{58703,0,0,0},{64320,
2,0,32},{58710,0,0,0},{64320,2,0,32},{58732,0,0,0},{64320,2,0,32},{58744,0,0,0},
{64320,2,0,32},{58777,0,0,0},{64320,2,0,32},{58821,0,0,0},{64320,2,0,32},{58850,
0,0,0},{64320,2,0,32},{58851,0,0,0},{64320,2,0,32},{58899,0,0,0},{64320,2,0,32},
{58953,0,0,0},{64320,2,0,32},{58996,0,0,0},{64320,2,0,32},{59016,0,0,0},{64320,
2,0,32},{59025,0,0,0},{64320,2,0,32},{59036,0,0,0},{64320,2,0,32},{59060,0,0,0},
{64320,2,0,32},{59078,0,0,0},{64320,2,0,32},{59124,0,0,0},{64320,2,0,32},{59128,
0,0,0},{64320,2,0,32},{59136,0,0,0},{64320,2,0,32},{59159,0,0,0},{64320,2,0,32},
{59163,0,0,0},{64320,2,0,32},{59169,0,0,0},{64320,2,0,32},{59214,0,0,0},{64320,
2,0,32},{59219,0,0,0},{64320,2,0,32},{59222,0,0,0},{64320,2,0,32},{59230,0,0,0},
{64320,2,0,32},{59259,0,0,0},{64320,2,0,32},{59269,0,0,0},{64320,2,0,32},{59287,
0,0,0},{64320,2,0,32},{59379,0,0,0},{64320,2,0,32},{59386,0,0,0},{64320,2,0,32},
{59415,0,0,0},{64320,2,0,32},{59423,0,0,0},{64320,2,0,32},{59474,0,0,0},{64320,
2,0,32},{59521,0,0,0},{64320,2,0,32},{59525,0,0,0},{64320,2,0,32},{59534,0,0,0},
{64320,2,0,32},{59560,0,0,0},{64320,2,0,32},{59668,0,0,0},{64320,2,0,32},{59714,
0,0,0},{64320,2,0,32},{59811,0,0,0},{64320,2,0,32},{59882,0,0,0},{64320,2,0,32},
{59906,0,0,0},{64320,2,0,32},{59923,0,0,0},{64320,2,0,32},{60072,0,0,0},{64320,
2,0,32},{60115,0,0,0},{64320,2,0,32},{60123,0,0,0},{64320,2,0,32},{60164,0,0,0},
{64320,2,0,32},{60193,0,0,0},{64320,2,0,32},{60244,0,0,0},{64320,2,0,32},{60274,
0,0,0},{64320,2,0,32},{60279,0,0,0},{64320,2,0,32},{60281,0,0,0},{64320,2,0,32},
{60319,0,0,0},{64320,2,0,32},{60334,0,0,0},{64320,2,0,32},{60346,0,0,0},{64320,
2,0,32},{60347,0,0,0},{64320,2,0,32},{60494,0,0,0},{64320,2,0,32},{60519,0,0,0},
{64320,2,0,32},{60552,0,0,0},{64320,2,0,32},{60607,0,0,0},{64320,2,0,32},{60620,
0,0,0},{64320,2,0,32},{60621,0,0,0},{64320,2,0,32},{60645,0,0,0},{64320,2,0,32},
{60694,0,0,0},{64320,2,0,32},{60699,0,0,0},{64320,2,0,32},{60702,0,0,0},{64320,
2,0,32},{60724,0,0,0},{64320,2,0,32},{60734,0,0,0},{64320,2,0,32},{60737,0,0,0},
{64320,2,0,32},{60777,0,0,0},{64320,2,0,32},{60778,0,0,0},{64320,2,0,32},{60791,
0,0,0},{64320,2,0,32},{60792,0,0,0},{64320,2,0,32},{60805,0,0,0},{64320,2,0,32},
{60875,0,0,0},{64320,2,0,32},{60890,0,0,0},{64320,2,0,32},{60906,0,0,0},{64320,
2,0,32},{60921,0,0,0},{64320,2,0,32},{60954,0,0,0},{64320,2,0,32},{60975,0,0,0},
{64320,2,0,32},{61038,0,0,0},{64320,2,0,32},{61084,0,0,0},{64320,2,0,32},{61114,
0,0,0},{64320,2,0,32},{61127,0,0,0},{64320,2,0,32},{61131,0,0,0},{64320,2,0,32},
{61137,0,0,0},{64320,2,0,32},{61147,0,0,0},{64320,2,0,32},{61199,0,0,0},{64320,
2,0,32},{61218,0,0,0},{64320,2,0,32},{61219,0,0,0},{64320,2,0,32},{61294,0,0,0},
{64320,2,0,32},{61382,0,0,0},{64320,2,0,32},{61419,0,0,0},{64320,2,0,32},{61438,
0,0,0},{64320,2,0,32},{61467,0,0,0},{64320,2,0,32},{61470,0,0,0},{64320,2,0,32},
{61497,0,0,0},{64320,2,0,32},{61514,0,0,0},{64320,2,0,32},{61552,0,0,0},{64320,
2,0,32},{61559,0,0,0},{64320,2,0,32},{61565,0,0,0},{64320,2,0,32},{61593,0,0,0},
{64320,2,0,32},{61613,0,0,0},{64320,2,0,32},{61640,0,0,0},{64320,2,0,32},{61657,
0,0,0},{64320,2,0,32},{61765,0,0,0},{64320,2,0,32},{61769,0,0,0},{64320,2,0,32},
{61806,0,0,0},{64320,2,0,32},{61852,0,0,0},{64320,2,0,32},{61902,0,0,0},{64320,
2,0,32},{61904,0,0,0},{64320,2,0,32},{61968,0,0,0},{64320,2,0,32},{61979,0,0,0},
{64320,2,0,32},{61992,0,0,0},{64320,2,0,32},{61995,0,0,0},{64320,2,0,32},{62005,
0,0,0},{64320,2,0,32},{62032,0,0,0},{64320,2,0,32},{62050,0,0,0},{64320,2,0,32},
{62080,0,0,0},{64320,2,0,32},{62101,0,0,0},{64320,2,0,32},{62127,0,0,0},{64320,
2,0,32},{62144,0,0,0},{64320,2,0,32},{62204,0,0,0},{64320,2,0,32},{62250,0,0,0},
{64320,2,0,32},{62325,0,0,0},{64320,2,0,32},{62330,0,0,0},{64320,2,0,32},{62343,
0,0,0},{64320,2,0,32},{62347,0,0,0},{64320,2,0,32},{62373,0,0,0},{64320,2,0,32},
{62386,0,0,0},{64320,2,0,32},{62430,0,0,0},{64320,2,0,32},{62470,0,0,0},{64320,
2,0,32},{62473,0,0,0},{64320,2,0,32},{62498,0,0,0},{64320,2,0,32},{62535,0,0,0},
{64320,2,0,32},{62556,0,0,0},{64320,2,0,32},{62569,0,0,0},{64320,2,0,32},{62577,
0,0,0},{64320,2,0,32},{62597,0,0,0},{64320,2,0,32},{62601,0,0,0},{64320,2,0,32},
{62616,0,0,0},{64320,2,0,32},{62666,0,0,0},{64320,2,0,32},{62726,0,0,0},{64320,
2,0,32},{62756,0,0,0},{64320,2,0,32},{62779,0,0,0},{64320,2,0,32},{62782,0,0,0},
{64320,2,0,32},{62809,0,0,0},{64320,2,0,32},{62821,0,0,0},{64320,2,0,32},{62832,
0,0,0},{64320,2,0,32},{62946,0,0,0},{64320,2,0,32},{62992,0,0,0},{64320,2,0,32},
{63005,0,0,0},{64320,2,0,32},{63007,0,0,0},{64320,2,0,32},{63042,0,0,0},{64320,
2,0,32},{63081,0,0,0},{64320,2,0,32},{63178,0,0,0},{64320,2,0,32},{63195,0,0,0},
{64320,2,0,32},{63207,0,0,0},{64320,2,0,32},{63220,0,0,0},{64320,2,0,32},{63233,
0,0,0},{64320,2,0,32},{63262,0,0,0},{64320,2,0,32},{63263,0,0,0},{64320,2,0,32},
{63296,0,0,0},{64320,2,0,32},{63306,0,0,0},{64320,2,0,32},{63371,0,0,0},{64320,
2,0,32},{63399,0,0,0},{64320,2,0,32},{63566,0,0,0},{64320,2,0,32},{63595,0,0,0},
{64320,2,0,32},{63628,0,0,0},{64320,2,0,32},{63633,0,0,0},{64320,2,0,32},{63690,
0,0,0},{64320,2,0,32},{63692,0,0,0},{64320,2,0,32},{63739,0,0,0},{64320,2,0,32},
{63786,0,0,0},{64320,2,0,32},{63804,0,0,0},{64320,2,0,32},{63806,0,0,0},{64320,
2,0,32},{63816,0,0,0},{64320,2,0,32},{63817,0,0,0},{64320,2,0,32},{63824,0,0,0},
{64320,2,0,32},{63830,0,0,0},{64320,2,0,32},{63837,0,0,0},{64320,2,0,32},{63838,
0,0,0},{64320,2,0,32},{63845,0,0,0},{64320,2,0,32},{63871,0,0,0},{64320,2,0,32},
{63885,0,0,0},{64320,2,0,32},{63886,0,0,0},{64320,2,0,32},{63887,0,0,0},{64320,
2,0,32},{63918,0,0,0},{64320,2,0,32},{63946,0,0,0},{64320,2,0,32},{63979,0,0,0},
{64320,2,0,32},{64028,0,0,0},{64320,2,0,32},{64064,0,0,0},{64320,2,0,32},{64074,
0,0,0},{64320,2,0,32},{64079,0,0,0},{64320,2,0,32},{64129,0,0,0},{64320,2,0,32},
{64177,0,0,0},{64320,2,0,32},{64203,0,0,0},{64320,2,0,32},{64238,0,0,0},{64320,
2,0,32},{64288,0,0,0},{64320,2,0,32},{64448,0,0,0},{64320,2,0,32},{64454,0,0,0},
{64320,2,0,32},{64457,0,0,0},{64320,2,0,32},{64574,0,0,0},{64320,2,0,32},{64608,
0,0,0},{64320,2,0,32},{64635,0,0,0},{64320,2,0,32},{64658,0,0,0},{64320,2,0,32},
{64702,0,0,0},{64320,2,0,32},{64722,0,0,0},{64320,2,0,32},{64726,0,0,0},{64320,
2,0,32},{64739,0,0,0},{64320,2,0,32},{64743,0,0,0},{64320,2,0,32},{64744,0,0,0},
{64320,2,0,32},{64768,0,0,0},{64320,2,0,32},{64784,0,0,0},{64320,2,0,32},{64802,
0,0,0},{64320,2,0,32},{64815,0,0,0},{64320,2,0,32},{64859,0,0,0},{64320,2,0,32},
{64867,0,0,0},{64320,2,0,32},{64928,0,0,0},{64320,2,0,32},{64958,0,0,0},{64320,
2,0,32},{64967,0,0,0},{64320,2,0,32},{65012,0,0,0},{64320,2,0,32},{65026,0,0,0},
{64320,2,0,32},{65033,0,0,0},{64320,2,0,32},{65079,0,0,0},{64320,2,0,32},{65089,
0,0,0},{64320,2,0,32},{65093,0,0,0},{64320,2,0,32},{65342,0,0,0},{64320,2,0,32},
{65394,0,0,0},{64320,2,0,32},{65401,0,0,0},{64320,2,0,32},{65402,0,0,0},{64320,
2,0,32},{65413,0,0,0},{64320,2,0,32},{65429,0,0,0},{64320,2,0,32},{65434,0,0,0},
{64320,2,0,32},{65469,0,0,0},{64320,2,0,32},{65530,0,0,0},{64321,2,0,32},{32769,
0,0,0},{64321,2,0,32},{32773,0,0,0},{64321,2,0,32},{32838,0,0,0},{64321,2,0,32},
{32864,0,0,0},{64321,2,0,32},{32879,0,0,0},{64321,2,0,32},{32880,0,0,0},{64321,
2,0,32},{32894,0,0,0},{64321,2,0,32},{32907,0,0,0},{64321,2,0,32},{32941,0,0,0},
{64321,2,0,32},{32946,0,0,0},{64321,2,0,32},{33027,0,0,0},{64321,2,0,32},{33086,
0,0,0},{64321,2,0,32},{33240,0,0,0},{64321,2,0,32},{33256,0,0,0},{64321,2,0,32},
{33261,0,0,0},{64321,2,0,32},{33281,0,0,0},{64321,2,0,32},{33284,0,0,0},{64321,
2,0,32},{33304,0,0,0},{64321,2,0,32},{33391,0,0,0},{64321,2,0,32},{33401,0,0,0},
{64321,2,0,32},{33419,0,0,0},{64321,2,0,32},{33425,0,0,0},{64321,2,0,32},{33437,
0,0,0},{64321,2,0,32},{33457,0,0,0},{64321,2,0,32},{33459,0,0,0},{64321,2,0,32},
{33469,0,0,0},{64321,2,0,32},{33509,0,0,0},{64321,2,0,32},{33510,0,0,0},{64321,
2,0,32},{33565,0,0,0},{64321,2,0,32},{33571,0,0,0},{64321,2,0,32},{33590,0,0,0},
{64321,2,0,32},{33618,0,0,0},{64321,2,0,32},{33619,0,0,0},{64321,2,0,32},{33635,
0,0,0},{64321,2,0,32},{33709,0,0,0},{64321,2,0,32},{33725,0,0,0},{64321,2,0,32},
{33737,0,0,0},{64321,2,0,32},{33738,0,0,0},{64321,2,0,32},{33740,0,0,0},{64321,
2,0,32},{33756,0,0,0},{64321,2,0,32},{33767,0,0,0},{64321,2,0,32},{33775,0,0,0},
{64321,2,0,32},{33777,0,0,0},{64321,2,0,32},{33853,0,0,0},{64321,2,0,32},{33865,
0,0,0},{64321,2,0,32},{33879,0,0,0},{64321,2,0,32},{34030,0,0,0},{64321,2,0,32},
{34033,0,0,0},{64321,2,0,32},{34035,0,0,0},{64321,2,0,32},{34044,0,0,0},{64321,
2,0,32},{34070,0,0,0},{64321,2,0,32},{34148,0,0,0},{64321,2,0,32},{34253,0,0,0},
{64321,2,0,32},{34298,0,0,0},{64321,2,0,32},{34310,0,0,0},{64321,2,0,32},{34322,
0,0,0},{64321,2,0,32},{34349,0,0,0},{64321,2,0,32},{34367,0,0,0},{64321,2,0,32},
{34384,0,0,0},{64321,2,0,32},{34396,0,0,0},{64321,2,0,32},{34407,0,0,0},{64321,
2,0,32},{34409,0,0,0},{64321,2,0,32},{34440,0,0,0},{64321,2,0,32},{34473,0,0,0},
{64321,2,0,32},{34530,0,0,0},{64321,2,0,32},{34574,0,0,0},{64321,2,0,32},{34600,
0,0,0},{64321,2,0,32},{34667,0,0,0},{64321,2,0,32},{34681,0,0,0},{64321,2,0,32},
{34694,0,0,0},{64321,2,0,32},{34746,0,0,0},{64321,2,0,32},{34785,0,0,0},{64321,
2,0,32},{34817,0,0,0},{64321,2,0,32},{34847,0,0,0},{64321,2,0,32},{34892,0,0,0},
{64321,2,0,32},{34912,0,0,0},{64321,2,0,32},{34915,0,0,0},{64321,2,0,32},{35010,
0,0,0},{64321,2,0,32},{35023,0,0,0},{64321,2,0,32},{35031,0,0,0},{64321,2,0,32},
{35038,0,0,0},{64321,2,0,32},{35041,0,0,0},{64321,2,0,32},{35064,0,0,0},{64321,
2,0,32},{35066,0,0,0},{64321,2,0,32},{35088,0,0,0},{64321,2,0,32},{35137,0,0,0},
{64321,2,0,32},{35172,0,0,0},{64321,2,0,32},{35206,0,0,0},{64321,2,0,32},{35211,
0,0,0},{64321,2,0,32},{35222,0,0,0},{64321,2,0,32},{35488,0,0,0},{64321,2,0,32},
{35498,0,0,0},{64321,2,0,32},{35519,0,0,0},{64321,2,0,32},{35531,0,0,0},{64321,
2,0,32},{35538,0,0,0},{64321,2,0,32},{35542,0,0,0},{64321,2,0,32},{35565,0,0,0},
{64321,2,0,32},{35576,0,0,0},{64321,2,0,32},{35582,0,0,0},{64321,2,0,32},{35585,
0,0,0},{64321,2,0,32},{35641,0,0,0},{64321,2,0,32},{35672,0,0,0},{64321,2,0,32},
{35712,0,0,0},{64321,2,0,32},{35722,0,0,0},{64321,2,0,32},{35912,0,0,0},{64321,
2,0,32},{35925,0,0,0},{64321,2,0,32},{36011,0,0,0},{64321,2,0,32},{36033,0,0,0},
{64321,2,0,32},{36034,0,0,0},{64321,2,0,32},{36040,0,0,0},{64321,2,0,32},{36051,
0,0,0},{64321,2,0,32},{36104,0,0,0},{64321,2,0,32},{36123,0,0,0},{64321,2,0,32},
{36215,0,0,0},{64321,2,0,32},{36284,0,0,0},{64321,2,0,32},{36299,0,0,0},{64321,
2,0,32},{36335,0,0,0},{64321,2,0,32},{36336,0,0,0},{64321,2,0,32},{36554,0,0,0},
{64321,2,0,32},{36564,0,0,0},{64321,2,0,32},{36646,0,0,0},{64321,2,0,32},{36650,
0,0,0},{64321,2,0,32},{36664,0,0,0},{64321,2,0,32},{36667,0,0,0},{64321,2,0,32},
{36706,0,0,0},{64321,2,0,32},{36766,0,0,0},{64321,2,0,32},{36784,0,0,0},{64321,
2,0,32},{36790,0,0,0},{64321,2,0,32},{36899,0,0,0},{64321,2,0,32},{36920,0,0,0},
{64321,2,0,32},{36978,0,0,0},{64321,2,0,32},{36988,0,0,0},{64321,2,0,32},{37007,
0,0,0},{64321,2,0,32},{37012,0,0,0},{64321,2,0,32},{37070,0,0,0},{64321,2,0,32},
{37086,0,0,0},{64321,2,0,32},{37105,0,0,0},{64321,2,0,32},{37117,0,0,0},{64321,
2,0,32},{37137,0,0,0},{64321,2,0,32},{37147,0,0,0},{64321,2,0,32},{37226,0,0,0},
{64321,2,0,32},{37273,0,0,0},{64321,2,0,32},{37300,0,0,0},{64321,2,0,32},{37324,
0,0,0},{64321,2,0,32},{37327,0,0,0},{64321,2,0,32},{37329,0,0,0},{64321,2,0,32},
{37428,0,0,0},{64321,2,0,32},{37432,0,0,0},{64321,2,0,32},{37494,0,0,0},{64321,
2,0,32},{37500,0,0,0},{64321,2,0,32},{37591,0,0,0},{64321,2,0,32},{37592,0,0,0},
{64321,2,0,32},{37636,0,0,0},{64321,2,0,32},{37706,0,0,0},{64321,2,0,32},{37881,
0,0,0},{64321,2,0,32},{37909,0,0,0},{64321,2,0,32},{38283,0,0,0},{64321,2,0,32},
{38317,0,0,0},{64321,2,0,32},{38327,0,0,0},{64321,2,0,32},{38446,0,0,0},{64321,
2,0,32},{38475,0,0,0},{64321,2,0,32},{38477,0,0,0},{64321,2,0,32},{38517,0,0,0},
{64321,2,0,32},{38520,0,0,0},{64321,2,0,32},{38524,0,0,0},{64321,2,0,32},{38534,
0,0,0},{64321,2,0,32},{38563,0,0,0},{64321,2,0,32},{38583,0,0,0},{64321,2,0,32},
{38584,0,0,0},{64321,2,0,32},{38595,0,0,0},{64321,2,0,32},{38626,0,0,0},{64321,
2,0,32},{38627,0,0,0},{64321,2,0,32},{38646,0,0,0},{64321,2,0,32},{38647,0,0,0},
{64321,2,0,32},{38691,0,0,0},{64321,2,0,32},{38706,0,0,0},{64321,2,0,32},{38728,
0,0,0},{64321,2,0,32},{38742,0,0,0},{64321,2,0,32},{38875,0,0,0},{64321,2,0,32},
{38880,0,0,0},{64321,2,0,32},{38911,0,0,0},{64321,2,0,32},{38923,0,0,0},{64321,
2,0,32},{38936,0,0,0},{64321,2,0,32},{38953,0,0,0},{64321,2,0,32},{38971,0,0,0},
{64321,2,0,32},{39006,0,0,0},{64321,2,0,32},{39138,0,0,0},{64321,2,0,32},{39151,
0,0,0},{64321,2,0,32},{39164,0,0,0},{64321,2,0,32},{39208,0,0,0},{64321,2,0,32},
{39209,0,0,0},{64321,2,0,32},{39335,0,0,0},{64321,2,0,32},{39362,0,0,0},{64321,
2,0,32},{39409,0,0,0},{64321,2,0,32},{39422,0,0,0},{64321,2,0,32},{39530,0,0,0},
{64321,2,0,32},{39698,0,0,0},{64321,2,0,32},{39791,0,0,0},{64321,2,0,32},{40000,
0,0,0},{64321,2,0,32},{40023,0,0,0},{64321,2,0,32},{40189,0,0,0},{64321,2,0,32},
{40295,0,0,0},{64321,2,0,32},{40372,0,0,0},{64321,2,0,32},{40442,0,0,0},{64321,
2,0,32},{40478,0,0,0},{64321,2,0,32},{40575,0,0,0},{64321,2,0,32},{40599,0,0,0},
{64321,2,0,32},{40607,0,0,0},{64321,2,0,32},{40635,0,0,0},{64321,2,0,32},{40654,
0,0,0},{64321,2,0,32},{40697,0,0,0},{64321,2,0,32},{40702,0,0,0},{64321,2,0,32},
{40709,0,0,0},{64321,2,0,32},{40719,0,0,0},{64321,2,0,32},{40726,0,0,0},{64321,
2,0,32},{40763,0,0,0},{64321,2,0,32},{40771,0,0,0},{64321,2,0,32},{40845,0,0,0},
{64321,2,0,32},{40846,0,0,0},{64321,2,0,32},{40860,0,0,0},{15866,4,0,32},{16121,
4,0,32},{15884,4,0,32},{16121,4,0,32},{15905,4,0,32},{16121,4,0,32},{15925,4,0,
32},{16122,4,0,32},{15936,4,0,32},{16121,4,0,32},{15942,4,0,32},{16122,4,0,32},
{15944,4,0,32},{16122,4,0,32},{15950,4,0,32},{16121,4,0,32},{15987,4,0,32},
{16121,4,0,32},{16034,4,0,32},{16121,4,0,32},{16057,4,0,32},{16121,4,0,32},
{16063,4,0,32},{16122,4,0,32},{16070,4,0,32},{16121,4,0,32},{9436,4,0,32},{0,4,
0,43},{8927,10,0,32},{9071,4,0,32},{8927,4,0,32},{9071,4,0,32},{8309,10,0,32},
{8309,10,0,32},{8309,4,0,32},{8309,4,0,32},{8309,10,0,32},{8733,10,0,32},{8309,
4,0,32},{8733,4,0,32},{8309,10,0,32},{8961,10,0,32},{8309,4,0,32},{8961,4,0,32},
{8309,10,0,32},{9009,10,0,32},{8309,4,0,32},{9009,4,0,32},{8309,10,0,32},{0,4,0,
280},{9009,10,0,32},{8309,4,0,32},{0,4,0,280},{9009,4,0,32},{8309,10,0,32},
{9049,10,0,32},{8309,4,0,32},{9049,4,0,32},{8733,10,0,32},{8733,10,0,32},{8733,
4,0,32},{8733,4,0,32},{8821,10,0,32},{0,4,0,282},{8821,4,0,32},{0,4,0,282},
{9009,10,0,32},{9049,10,0,32},{9009,4,0,32},{9049,4,0,32},{8383,10,0,32},{0,4,0,
281},{8383,4,0,32},{0,4,0,281},{8470,10,0,32},{0,4,0,281},{8470,4,0,32},{0,4,0,
281},{8485,10,0,32},{0,4,0,281},{8821,10,0,32},{0,4,0,281},{8821,4,0,32},{0,4,0,
281},{8886,10,0,32},{0,4,0,282},{8886,4,0,32},{0,4,0,282},{8927,10,0,32},{0,4,0,
281},{8927,4,0,32},{0,4,0,281},{8309,10,0,32},{0,4,0,43},{8309,4,0,32},{0,4,0,
43},{8733,10,0,32},{0,4,0,43},{8733,4,0,32},{0,4,0,43},{8961,10,0,32},{0,4,0,
43},{8961,4,0,32},{0,4,0,43},{8485,10,0,32},{0,4,0,53},{8485,4,0,32},{0,4,0,53},
{8604,10,0,32},{0,4,0,53},{8604,4,0,32},{0,4,0,53},{8695,10,0,32},{0,4,0,53},
{8695,4,0,32},{0,4,0,53},{8821,10,0,32},{0,4,0,53},{8821,4,0,32},{0,4,0,53},
{8886,10,0,32},{0,4,0,53},{8886,4,0,32},{0,4,0,53},{8309,10,0,32},{0,4,0,49},
{8309,4,0,32},{0,4,0,49},{9027,10,0,32},{0,4,0,280},{9027,4,0,32},{0,4,0,280},
{8886,10,0,32},{0,4,0,283},{8886,4,0,32},{0,4,0,283},{8524,20,0,32},{0,20,0,57},
{8733,20,0,32},{0,20,0,280},{8411,20,0,32},{13240,2,0,32},{13293,2,0,32},{13241,
2,0,32},{13293,2,0,32},{13242,2,0,32},{13293,2,0,32},{13243,2,0,32},{13293,2,0,
32},{13244,2,0,32},{13293,2,0,32},{13245,2,0,32},{13293,2,0,32},{13246,2,0,32},
{13293,2,0,32},{13247,2,0,32},{13293,2,0,32},{13248,2,0,32},{13293,2,0,32},
{13249,2,0,32},{13293,2,0,32},{13250,2,0,32},{13293,2,0,32},{13251,2,0,32},
{13293,2,0,32},{13252,2,0,32},{13293,2,0,32},{13253,2,0,32},{13293,2,0,32},
{13254,2,0,32},{13293,2,0,32},{13255,2,0,32},{13293,2,0,32},{13256,2,0,32},
{13293,2,0,32},{13257,2,0,32},{13293,2,0,32},{13258,2,0,32},{13293,2,0,32},
{13259,2,0,32},{13293,2,0,32},{13260,2,0,32},{13293,2,0,32},{13261,2,0,32},
{13293,2,0,32},{13262,2,0,32},{13293,2,0,32},{13263,2,0,32},{13293,2,0,32},
{13264,2,0,32},{13293,2,0,32},{13265,2,0,32},{13293,2,0,32},{13266,2,0,32},
{13293,2,0,32},{13267,2,0,32},{13293,2,0,32},{13268,2,0,32},{13293,2,0,32},
{13269,2,0,32},{13293,2,0,32},{13270,2,0,32},{13293,2,0,32},{13271,2,0,32},
{13293,2,0,32},{13272,2,0,32},{13293,2,0,32},{13273,2,0,32},{13293,2,0,32},
{13274,2,0,32},{13293,2,0,32},{13275,2,0,32},{13293,2,0,32},{13276,2,0,32},
{13293,2,0,32},{13277,2,0,32},{13293,2,0,32},{13278,2,0,32},{13293,2,0,32},
{13279,2,0,32},{13293,2,0,32},{13280,2,0,32},{13293,2,0,32},{13281,2,0,32},
{13293,2,0,32},{13282,2,0,32},{13293,2,0,32},{13283,2,0,32},{13293,2,0,32},
{13284,2,0,32},{13293,2,0,32},{13285,2,0,32},{13293,2,0,32},{13286,2,0,32},
{13293,2,0,32},{13287,2,0,32},{13293,2,0,32},{13240,2,0,32},{13294,2,0,32},
{13241,2,0,32},{13294,2,0,32},{13242,2,0,32},{13294,2,0,32},{13243,2,0,32},
{13294,2,0,32},{13244,2,0,32},{13294,2,0,32},{13245,2,0,32},{13294,2,0,32},
{13246,2,0,32},{13294,2,0,32},{13247,2,0,32},{13294,2,0,32},{13248,2,0,32},
{13294,2,0,32},{13249,2,0,32},{13294,2,0,32},{13250,2,0,32},{13294,2,0,32},
{13251,2,0,32},{13294,2,0,32},{13252,2,0,32},{13294,2,0,32},{13253,2,0,32},
{13294,2,0,32},{13254,2,0,32},{13294,2,0,32},{13255,2,0,32},{13294,2,0,32},
{13256,2,0,32},{13294,2,0,32},{13257,2,0,32},{13294,2,0,32},{13258,2,0,32},
{13294,2,0,32},{13259,2,0,32},{13294,2,0,32},{13260,2,0,32},{13294,2,0,32},
{13261,2,0,32},{13294,2,0,32},{13262,2,0,32},{13294,2,0,32},{13263,2,0,32},
{13294,2,0,32},{13264,2,0,32},{13294,2,0,32},{13265,2,0,32},{13294,2,0,32},
{13266,2,0,32},{13294,2,0,32},{13267,2,0,32},{13294,2,0,32},{13268,2,0,32},
{13294,2,0,32},{13269,2,0,32},{13294,2,0,32},{13270,2,0,32},{13294,2,0,32},
{13271,2,0,32},{13294,2,0,32},{13272,2,0,32},{13294,2,0,32},{13273,2,0,32},
{13294,2,0,32},{13274,2,0,32},{13294,2,0,32},{13275,2,0,32},{13294,2,0,32},
{13276,2,0,32},{13294,2,0,32},{13277,2,0,32},{13294,2,0,32},{13278,2,0,32},
{13294,2,0,32},{13279,2,0,32},{13294,2,0,32},{13280,2,0,32},{13294,2,0,32},
{13281,2,0,32},{13294,2,0,32},{13282,2,0,32},{13294,2,0,32},{13283,2,0,32},
{13294,2,0,32},{13284,2,0,32},{13294,2,0,32},{13285,2,0,32},{13294,2,0,32},
{13286,2,0,32},{13294,2,0,32},{13287,2,0,32},{13294,2,0,32},{13240,2,0,32},
{13297,2,0,32},{13241,2,0,32},{13297,2,0,32},{13242,2,0,32},{13297,2,0,32},
{13243,2,0,32},{13297,2,0,32},{13244,2,0,32},{13297,2,0,32},{13245,2,0,32},
{13297,2,0,32},{13246,2,0,32},{13297,2,0,32},{13247,2,0,32},{13297,2,0,32},
{13248,2,0,32},{13297,2,0,32},{13249,2,0,32},{13297,2,0,32},{13250,2,0,32},
{13297,2,0,32},{13251,2,0,32},{13297,2,0,32},{13252,2,0,32},{13297,2,0,32},
{13253,2,0,32},{13297,2,0,32},{13254,2,0,32},{13297,2,0,32},{13255,2,0,32},
{13297,2,0,32},{13256,2,0,32},{13297,2,0,32},{13257,2,0,32},{13297,2,0,32},
{13258,2,0,32},{13297,2,0,32},{13259,2,0,32},{13297,2,0,32},{13260,2,0,32},
{13297,2,0,32},{13261,2,0,32},{13297,2,0,32},{13262,2,0,32},{13297,2,0,32},
{13263,2,0,32},{13297,2,0,32},{13264,2,0,32},{13297,2,0,32},{13265,2,0,32},
{13297,2,0,32},{13266,2,0,32},{13297,2,0,32},{13267,2,0,32},{13297,2,0,32},
{13268,2,0,32},{13297,2,0,32},{13269,2,0,32},{13297,2,0,32},{13270,2,0,32},
{13297,2,0,32},{13271,2,0,32},{13297,2,0,32},{13272,2,0,32},{13297,2,0,32},
{13273,2,0,32},{13297,2,0,32},{13274,2,0,32},{13297,2,0,32},{13275,2,0,32},
{13297,2,0,32},{13276,2,0,32},{13297,2,0,32},{13277,2,0,32},{13297,2,0,32},
{13278,2,0,32},{13297,2,0,32},{13279,2,0,32},{13297,2,0,32},{13280,2,0,32},
{13297,2,0,32},{13281,2,0,32},{13297,2,0,32},{13282,2,0,32},{13297,2,0,32},
{13283,2,0,32},{13297,2,0,32},{13284,2,0,32},{13297,2,0,32},{13285,2,0,32},
{13297,2,0,32},{13286,2,0,32},{13297,2,0,32},{13287,2,0,32},{13297,2,0,32},
{13240,2,0,32},{13299,2,0,32},{13241,2,0,32},{13299,2,0,32},{13242,2,0,32},
{13299,2,0,32},{13243,2,0,32},{13299,2,0,32},{13244,2,0,32},{13299,2,0,32},
{13245,2,0,32},{13299,2,0,32},{13246,2,0,32},{13299,2,0,32},{13247,2,0,32},
{13299,2,0,32},{13248,2,0,32},{13299,2,0,32},{13249,2,0,32},{13299,2,0,32},
{13250,2,0,32},{13299,2,0,32},{13251,2,0,32},{13299,2,0,32},{13252,2,0,32},
{13299,2,0,32},{13253,2,0,32},{13299,2,0,32},{13254,2,0,32},{13299,2,0,32},
{13255,2,0,32},{13299,2,0,32},{13256,2,0,32},{13299,2,0,32},{13257,2,0,32},
{13299,2,0,32},{13258,2,0,32},{13299,2,0,32},{13259,2,0,32},{13299,2,0,32},
{13260,2,0,32},{13299,2,0,32},{13261,2,0,32},{13299,2,0,32},{13262,2,0,32},
{13299,2,0,32},{13263,2,0,32},{13299,2,0,32},{13264,2,0,32},{13299,2,0,32},
{13265,2,0,32},{13299,2,0,32},{13266,2,0,32},{13299,2,0,32},{13267,2,0,32},
{13299,2,0,32},{13268,2,0,32},{13299,2,0,32},{13269,2,0,32},{13299,2,0,32},
{13270,2,0,32},{13299,2,0,32},{13271,2,0,32},{13299,2,0,32},{13272,2,0,32},
{13299,2,0,32},{13273,2,0,32},{13299,2,0,32},{13274,2,0,32},{13299,2,0,32},
{13275,2,0,32},{13299,2,0,32},{13276,2,0,32},{13299,2,0,32},{13277,2,0,32},
{13299,2,0,32},{13278,2,0,32},{13299,2,0,32},{13279,2,0,32},{13299,2,0,32},
{13280,2,0,32},{13299,2,0,32},{13281,2,0,32},{13299,2,0,32},{13282,2,0,32},
{13299,2,0,32},{13283,2,0,32},{13299,2,0,32},{13284,2,0,32},{13299,2,0,32},
{13285,2,0,32},{13299,2,0,32},{13286,2,0,32},{13299,2,0,32},{13287,2,0,32},
{13299,2,0,32},{13240,2,0,32},{13300,2,0,32},{13241,2,0,32},{13300,2,0,32},
{13242,2,0,32},{13300,2,0,32},{13243,2,0,32},{13300,2,0,32},{13244,2,0,32},
{13300,2,0,32},{13245,2,0,32},{13300,2,0,32},{13246,2,0,32},{13300,2,0,32},
{13247,2,0,32},{13300,2,0,32},{13248,2,0,32},{13300,2,0,32},{13249,2,0,32},
{13300,2,0,32},{13250,2,0,32},{13300,2,0,32},{13251,2,0,32},{13300,2,0,32},
{13252,2,0,32},{13300,2,0,32},{13253,2,0,32},{13300,2,0,32},{13254,2,0,32},
{13300,2,0,32},{13255,2,0,32},{13300,2,0,32},{13256,2,0,32},{13300,2,0,32},
{13257,2,0,32},{13300,2,0,32},{13258,2,0,32},{13300,2,0,32},{13259,2,0,32},
{13300,2,0,32},{13260,2,0,32},{13300,2,0,32},{13261,2,0,32},{13300,2,0,32},
{13262,2,0,32},{13300,2,0,32},{13263,2,0,32},{13300,2,0,32},{13264,2,0,32},
{13300,2,0,32},{13265,2,0,32},{13300,2,0,32},{13266,2,0,32},{13300,2,0,32},
{13267,2,0,32},{13300,2,0,32},{13268,2,0,32},{13300,2,0,32},{13269,2,0,32},
{13300,2,0,32},{13270,2,0,32},{13300,2,0,32},{13271,2,0,32},{13300,2,0,32},
{13272,2,0,32},{13300,2,0,32},{13273,2,0,32},{13300,2,0,32},{13274,2,0,32},
{13300,2,0,32},{13275,2,0,32},{13300,2,0,32},{13276,2,0,32},{13300,2,0,32},
{13277,2,0,32},{13300,2,0,32},{13278,2,0,32},{13300,2,0,32},{13279,2,0,32},
{13300,2,0,32},{13280,2,0,32},{13300,2,0,32},{13281,2,0,32},{13300,2,0,32},
{13282,2,0,32},{13300,2,0,32},{13283,2,0,32},{13300,2,0,32},{13284,2,0,32},
{13300,2,0,32},{13285,2,0,32},{13300,2,0,32},{13286,2,0,32},{13300,2,0,32},
{13287,2,0,32},{13300,2,0,32},{8383,4,0,32},{9086,4,0,32},{8927,4,0,32},{8894,4,
0,32},{64321,2,0,32},{64014,0,0,0},{64321,2,0,32},{64015,0,0,0},{64321,2,0,32},
{64017,0,0,0},{64321,2,0,32},{64019,0,0,0},{64321,2,0,32},{64020,0,0,0},{64321,
2,0,32},{64031,0,0,0},{64321,2,0,32},{64033,0,0,0},{64321,2,0,32},{64035,0,0,0},
{64321,2,0,32},{64036,0,0,0},{64321,2,0,32},{64039,0,0,0},{64321,2,0,32},{64040,
0,0,0},{64321,2,0,32},{64041,0,0,0},{8470,4,0,32},{8470,4,0,32},{8470,4,0,32},
{8551,4,0,32},{8470,4,0,32},{8624,4,0,32},{8470,4,0,32},{8470,4,0,32},{8551,4,0,
32},{8470,4,0,32},{8470,4,0,32},{8624,4,0,32},{8886,4,0,32},{0,4,0,281},{8927,4,
0,32},{8886,4,0,32},{8927,4,0,32},{9977,4,0,32},{9980,4,0,32},{9977,4,0,32},
{9962,4,0,32},{9977,4,0,32},{9968,4,0,32},{9988,4,0,32},{9980,4,0,32},{9977,4,0,
32},{9970,4,0,32},{9998,4,0,32},{10009,4,0,32},{10270,26,0,32},{0,26,0,131},
{10270,25,0,32},{0,25,0,131},{10300,26,0,32},{0,26,0,131},{10300,25,0,32},{0,25,
0,131},{10068,26,0,32},{10275,26,0,32},{10078,26,0,32},{10082,26,0,32},{10078,
25,0,32},{10082,25,0,32},{10078,26,0,32},{10270,26,0,32},{10078,25,0,32},{10270,
25,0,32},{10078,26,0,32},{10271,26,0,32},{10078,25,0,32},{10271,25,0,32},{10078,
26,0,32},{10275,26,0,32},{10078,25,0,32},{10275,25,0,32},{10078,26,0,32},{10274,
26,0,32},{10078,25,0,32},{10274,25,0,32},{10078,26,0,32},{10276,26,0,32},{10078,
25,0,32},{10276,25,0,32},{10078,26,0,32},{10290,26,0,32},{10078,25,0,32},{10290,
25,0,32},{10078,23,0,32},{10290,23,0,32},{10078,26,0,32},{10285,26,0,32},{10078,
25,0,32},{10285,25,0,32},{10078,23,0,32},{10285,23,0,32},{10078,26,0,32},{10111,
26,0,32},{10078,26,0,32},{10122,26,0,32},{10078,26,0,32},{10250,26,0,32},{10078,
26,0,32},{10285,26,0,32},{10078,26,0,32},{10286,26,0,32},{10084,26,0,32},{10111,
26,0,32},{10084,26,0,32},{10122,26,0,32},{10084,26,0,32},{10123,26,0,32},{10084,
26,0,32},{10250,26,0,32},{10084,26,0,32},{10285,26,0,32},{10084,26,0,32},{10286,
26,0,32},{10101,26,0,32},{10111,26,0,32},{10101,26,0,32},{10122,26,0,32},{10101,
26,0,32},{10123,26,0,32},{10101,26,0,32},{10250,26,0,32},{10101,26,0,32},{10285,
26,0,32},{10101,26,0,32},{10286,26,0,32},{10102,26,0,32},{10111,26,0,32},{10102,
26,0,32},{10250,26,0,32},{10102,26,0,32},{10285,26,0,32},{10102,26,0,32},{10286,
26,0,32},{10111,26,0,32},{10122,26,0,32},{10111,26,0,32},{10250,26,0,32},{10122,
26,0,32},{10111,26,0,32},{10122,26,0,32},{10250,26,0,32},{10123,26,0,32},{10111,
26,0,32},{10123,26,0,32},{10122,26,0,32},{10123,26,0,32},{10250,26,0,32},{10167,
26,0,32},{10111,26,0,32},{10167,26,0,32},{10122,26,0,32},{10167,26,0,32},{10123,
26,0,32},{10167,26,0,32},{10250,26,0,32},{10178,26,0,32},{10122,26,0,32},{10178,
26,0,32},{10250,26,0,32},{10179,26,0,32},{10111,26,0,32},{10179,26,0,32},{10122,
26,0,32},{10179,26,0,32},{10123,26,0,32},{10179,26,0,32},{10250,26,0,32},{10184,
26,0,32},{10122,26,0,32},{10184,26,0,32},{10250,26,0,32},{10185,26,0,32},{10250,
26,0,32},{10190,26,0,32},{10111,26,0,32},{10190,26,0,32},{10250,26,0,32},{10191,
26,0,32},{10111,26,0,32},{10191,26,0,32},{10250,26,0,32},{10199,26,0,32},{10111,
26,0,32},{10199,26,0,32},{10122,26,0,32},{10199,26,0,32},{10123,26,0,32},{10199,
26,0,32},{10250,26,0,32},{10199,26,0,32},{10285,26,0,32},{10199,26,0,32},{10286,
26,0,32},{10211,26,0,32},{10122,26,0,32},{10211,26,0,32},{10250,26,0,32},{10211,
26,0,32},{10285,26,0,32},{10211,26,0,32},{10286,26,0,32},{10218,26,0,32},{10082,
26,0,32},{10218,26,0,32},{10111,26,0,32},{10218,26,0,32},{10122,26,0,32},{10218,
26,0,32},{10123,26,0,32},{10218,26,0,32},{10242,26,0,32},{10218,26,0,32},{10250,
26,0,32},{10218,26,0,32},{10285,26,0,32},{10218,26,0,32},{10286,26,0,32},{10242,
26,0,32},{10111,26,0,32},{10242,26,0,32},{10122,26,0,32},{10242,26,0,32},{10123,
26,0,32},{10242,26,0,32},{10250,26,0,32},{10242,26,0,32},{10285,26,0,32},{10242,
26,0,32},{10286,26,0,32},{10250,26,0,32},{10111,26,0,32},{10250,26,0,32},{10122,
26,0,32},{10250,26,0,32},{10123,26,0,32},{10250,26,0,32},{10250,26,0,32},{10250,
26,0,32},{10285,26,0,32},{10250,26,0,32},{10286,26,0,32},{10254,26,0,32},{10111,
26,0,32},{10254,26,0,32},{10122,26,0,32},{10254,26,0,32},{10123,26,0,32},{10254,
26,0,32},{10250,26,0,32},{10254,26,0,32},{10285,26,0,32},{10254,26,0,32},{10286,
26,0,32},{10265,26,0,32},{10111,26,0,32},{10265,26,0,32},{10250,26,0,32},{10265,
26,0,32},{10285,26,0,32},{10265,26,0,32},{10286,26,0,32},{10286,26,0,32},{10111,
26,0,32},{10286,26,0,32},{10122,26,0,32},{10286,26,0,32},{10123,26,0,32},{10286,
26,0,32},{10250,26,0,32},{10286,26,0,32},{10285,26,0,32},{10286,26,0,32},{10286,
26,0,32},{10134,26,0,32},{0,26,0,152},{10148,26,0,32},{0,26,0,152},{10285,26,0,
32},{0,26,0,152},{0,26,0,112},{0,26,0,128},{0,26,0,115},{0,26,0,128},{0,26,0,
118},{0,26,0,128},{0,26,0,122},{0,26,0,128},{0,26,0,125},{0,26,0,128},{0,26,0,
128},{0,26,0,152},{10078,25,0,32},{10148,25,0,32},{10078,25,0,32},{10149,25,0,
32},{10078,25,0,32},{10250,25,0,32},{10078,25,0,32},{10254,25,0,32},{10078,25,0,
32},{10285,25,0,32},{10078,25,0,32},{10286,25,0,32},{10084,25,0,32},{10148,25,0,
32},{10084,25,0,32},{10149,25,0,32},{10084,25,0,32},{10250,25,0,32},{10084,25,0,
32},{10254,25,0,32},{10084,25,0,32},{10285,25,0,32},{10084,25,0,32},{10286,25,0,
32},{10101,25,0,32},{10148,25,0,32},{10101,25,0,32},{10149,25,0,32},{10101,25,0,
32},{10250,25,0,32},{10101,25,0,32},{10254,25,0,32},{10101,25,0,32},{10285,25,0,
32},{10101,25,0,32},{10286,25,0,32},{10102,25,0,32},{10148,25,0,32},{10102,25,0,
32},{10149,25,0,32},{10102,25,0,32},{10250,25,0,32},{10102,25,0,32},{10254,25,0,
32},{10102,25,0,32},{10285,25,0,32},{10102,25,0,32},{10286,25,0,32},{10199,25,0,
32},{10285,25,0,32},{10199,25,0,32},{10286,25,0,32},{10211,25,0,32},{10285,25,0,
32},{10211,25,0,32},{10286,25,0,32},{10218,25,0,32},{10082,25,0,32},{10218,25,0,
32},{10242,25,0,32},{10218,25,0,32},{10250,25,0,32},{10218,25,0,32},{10285,25,0,
32},{10218,25,0,32},{10286,25,0,32},{10242,25,0,32},{10250,25,0,32},{10242,25,0,
32},{10285,25,0,32},{10242,25,0,32},{10286,25,0,32},{10250,25,0,32},{10082,25,0,
32},{10250,25,0,32},{10250,25,0,32},{10254,25,0,32},{10148,25,0,32},{10254,25,0,
32},{10149,25,0,32},{10254,25,0,32},{10250,25,0,32},{10254,25,0,32},{10254,25,0,
32},{10254,25,0,32},{10285,25,0,32},{10254,25,0,32},{10286,25,0,32},{10285,25,0,
32},{0,25,0,152},{10286,25,0,32},{10148,25,0,32},{10286,25,0,32},{10149,25,0,
32},{10286,25,0,32},{10250,25,0,32},{10286,25,0,32},{10254,25,0,32},{10286,25,0,
32},{10285,25,0,32},{10286,25,0,32},{10286,25,0,32},{10078,23,0,32},{10111,23,0,
32},{10078,23,0,32},{10122,23,0,32},{10078,23,0,32},{10123,23,0,32},{10078,23,0,
32},{10250,23,0,32},{10078,23,0,32},{10265,23,0,32},{10084,23,0,32},{10111,23,0,
32},{10084,23,0,32},{10122,23,0,32},{10084,23,0,32},{10123,23,0,32},{10084,23,0,
32},{10250,23,0,32},{10084,23,0,32},{10265,23,0,32},{10101,23,0,32},{10111,23,0,
32},{10101,23,0,32},{10122,23,0,32},{10101,23,0,32},{10123,23,0,32},{10101,23,0,
32},{10250,23,0,32},{10101,23,0,32},{10265,23,0,32},{10102,23,0,32},{10250,23,0,
32},{10111,23,0,32},{10122,23,0,32},{10111,23,0,32},{10250,23,0,32},{10122,23,0,
32},{10111,23,0,32},{10122,23,0,32},{10250,23,0,32},{10123,23,0,32},{10111,23,0,
32},{10123,23,0,32},{10250,23,0,32},{10167,23,0,32},{10111,23,0,32},{10167,23,0,
32},{10122,23,0,32},{10167,23,0,32},{10123,23,0,32},{10167,23,0,32},{10250,23,0,
32},{10178,23,0,32},{10122,23,0,32},{10178,23,0,32},{10123,23,0,32},{10178,23,0,
32},{10250,23,0,32},{10179,23,0,32},{10111,23,0,32},{10179,23,0,32},{10122,23,0,
32},{10179,23,0,32},{10123,23,0,32},{10179,23,0,32},{10250,23,0,32},{10184,23,0,
32},{10122,23,0,32},{10185,23,0,32},{10250,23,0,32},{10190,23,0,32},{10111,23,0,
32},{10190,23,0,32},{10250,23,0,32},{10191,23,0,32},{10111,23,0,32},{10191,23,0,
32},{10250,23,0,32},{10199,23,0,32},{10111,23,0,32},{10199,23,0,32},{10122,23,0,
32},{10199,23,0,32},{10123,23,0,32},{10199,23,0,32},{10250,23,0,32},{10211,23,0,
32},{10122,23,0,32},{10211,23,0,32},{10250,23,0,32},{10218,23,0,32},{10111,23,0,
32},{10218,23,0,32},{10122,23,0,32},{10218,23,0,32},{10123,23,0,32},{10218,23,0,
32},{10242,23,0,32},{10218,23,0,32},{10250,23,0,32},{10242,23,0,32},{10111,23,0,
32},{10242,23,0,32},{10122,23,0,32},{10242,23,0,32},{10123,23,0,32},{10242,23,0,
32},{10250,23,0,32},{10242,23,0,32},{10265,23,0,32},{10250,23,0,32},{10111,23,0,
32},{10250,23,0,32},{10122,23,0,32},{10250,23,0,32},{10123,23,0,32},{10250,23,0,
32},{10250,23,0,32},{10254,23,0,32},{10111,23,0,32},{10254,23,0,32},{10122,23,0,
32},{10254,23,0,32},{10123,23,0,32},{10254,23,0,32},{10250,23,0,32},{10254,23,0,
32},{10265,23,0,32},{10265,23,0,32},{10111,23,0,32},{10265,23,0,32},{10250,23,0,
32},{10265,23,0,32},{0,23,0,152},{10286,23,0,32},{10111,23,0,32},{10286,23,0,
32},{10122,23,0,32},{10286,23,0,32},{10123,23,0,32},{10286,23,0,32},{10250,23,0,
32},{10286,23,0,32},{10265,23,0,32},{10078,24,0,32},{10250,24,0,32},{10078,24,0,
32},{10265,24,0,32},{10084,24,0,32},{10250,24,0,32},{10084,24,0,32},{10265,24,0,
32},{10101,24,0,32},{10250,24,0,32},{10101,24,0,32},{10265,24,0,32},{10102,24,0,
32},{10250,24,0,32},{10102,24,0,32},{10265,24,0,32},{10167,24,0,32},{10250,24,0,
32},{10167,24,0,32},{10265,24,0,32},{10168,24,0,32},{10250,24,0,32},{10168,24,0,
32},{10265,24,0,32},{10218,24,0,32},{10242,24,0,32},{10218,24,0,32},{10250,24,0,
32},{10242,24,0,32},{10250,24,0,32},{10254,24,0,32},{10250,24,0,32},{10254,24,0,
32},{10265,24,0,32},{10286,24,0,32},{10250,24,0,32},{10286,24,0,32},{10265,24,0,
32},{0,24,0,118},{0,24,0,128},{0,24,0,122},{0,24,0,128},{0,24,0,125},{0,24,0,
128},{10184,26,0,32},{10285,26,0,32},{10184,26,0,32},{10286,26,0,32},{10190,26,
0,32},{10285,26,0,32},{10190,26,0,32},{10286,26,0,32},{10191,26,0,32},{10285,26,
0,32},{10191,26,0,32},{10286,26,0,32},{10167,26,0,32},{10285,26,0,32},{10167,26,
0,32},{10286,26,0,32},{10168,26,0,32},{10285,26,0,32},{10168,26,0,32},{10286,26,
0,32},{10122,26,0,32},{10285,26,0,32},{10122,26,0,32},{10286,26,0,32},{10111,26,
0,32},{10285,26,0,32},{10111,26,0,32},{10286,26,0,32},{10123,26,0,32},{10285,26,
0,32},{10123,26,0,32},{10286,26,0,32},{10178,26,0,32},{10285,26,0,32},{10178,26,
0,32},{10286,26,0,32},{10179,26,0,32},{10285,26,0,32},{10179,26,0,32},{10286,26,
0,32},{10168,26,0,32},{10111,26,0,32},{10168,26,0,32},{10122,26,0,32},{10168,26,
0,32},{10123,26,0,32},{10168,26,0,32},{10250,26,0,32},{10168,26,0,32},{10148,26,
0,32},{10167,26,0,32},{10148,26,0,32},{10178,26,0,32},{10148,26,0,32},{10179,26,
0,32},{10148,26,0,32},{10184,25,0,32},{10285,25,0,32},{10184,25,0,32},{10286,25,
0,32},{10190,25,0,32},{10285,25,0,32},{10190,25,0,32},{10286,25,0,32},{10191,25,
0,32},{10285,25,0,32},{10191,25,0,32},{10286,25,0,32},{10167,25,0,32},{10285,25,
0,32},{10167,25,0,32},{10286,25,0,32},{10168,25,0,32},{10285,25,0,32},{10168,25,
0,32},{10286,25,0,32},{10122,25,0,32},{10285,25,0,32},{10122,25,0,32},{10286,25,
0,32},{10111,25,0,32},{10285,25,0,32},{10111,25,0,32},{10286,25,0,32},{10123,25,
0,32},{10285,25,0,32},{10123,25,0,32},{10286,25,0,32},{10178,25,0,32},{10285,25,
0,32},{10178,25,0,32},{10286,25,0,32},{10179,25,0,32},{10285,25,0,32},{10179,25,
0,32},{10286,25,0,32},{10168,25,0,32},{10111,25,0,32},{10168,25,0,32},{10122,25,
0,32},{10168,25,0,32},{10123,25,0,32},{10168,25,0,32},{10250,25,0,32},{10168,25,
0,32},{10148,25,0,32},{10167,25,0,32},{10148,25,0,32},{10178,25,0,32},{10148,25,
0,32},{10179,25,0,32},{10148,25,0,32},{10168,23,0,32},{10111,23,0,32},{10168,23,
0,32},{10122,23,0,32},{10168,23,0,32},{10123,23,0,32},{10168,23,0,32},{10250,23,
0,32},{10167,23,0,32},{10265,23,0,32},{10168,23,0,32},{10265,23,0,32},{10184,23,
0,32},{10250,23,0,32},{10167,24,0,32},{10111,24,0,32},{10167,24,0,32},{10122,24,
0,32},{10167,24,0,32},{10123,24,0,32},{10168,24,0,32},{10111,24,0,32},{10168,24,
0,32},{10122,24,0,32},{10168,24,0,32},{10123,24,0,32},{10184,24,0,32},{10250,24,
0,32},{10185,24,0,32},{10250,24,0,32},{10082,25,0,32},{0,25,0,109},{10082,26,0,
32},{0,26,0,109},{10101,23,0,32},{10111,23,0,32},{10250,23,0,32},{10101,25,0,
32},{10122,25,0,32},{10111,25,0,32},{10101,23,0,32},{10122,23,0,32},{10111,23,0,
32},{10101,23,0,32},{10122,23,0,32},{10250,23,0,32},{10101,23,0,32},{10123,23,0,
32},{10250,23,0,32},{10101,23,0,32},{10250,23,0,32},{10111,23,0,32},{10101,23,0,
32},{10250,23,0,32},{10122,23,0,32},{10101,23,0,32},{10250,23,0,32},{10123,23,0,
32},{10111,25,0,32},{10250,25,0,32},{10122,25,0,32},{10111,23,0,32},{10250,23,0,
32},{10122,23,0,32},{10122,25,0,32},{10250,25,0,32},{10286,25,0,32},{10122,25,0,
32},{10250,25,0,32},{10285,25,0,32},{10167,23,0,32},{10122,23,0,32},{10111,23,0,
32},{10167,23,0,32},{10111,23,0,32},{10122,23,0,32},{10167,25,0,32},{10111,25,0,
32},{10285,25,0,32},{10167,25,0,32},{10250,25,0,32},{10122,25,0,32},{10167,23,0,
32},{10250,23,0,32},{10122,23,0,32},{10167,23,0,32},{10250,23,0,32},{10111,23,0,
32},{10167,25,0,32},{10250,25,0,32},{10250,25,0,32},{10167,23,0,32},{10250,23,0,
32},{10250,23,0,32},{10178,25,0,32},{10122,25,0,32},{10122,25,0,32},{10178,23,0,
32},{10122,23,0,32},{10122,23,0,32},{10178,25,0,32},{10250,25,0,32},{10250,25,0,
32},{10168,25,0,32},{10122,25,0,32},{10250,25,0,32},{10168,23,0,32},{10122,23,0,
32},{10250,23,0,32},{10168,25,0,32},{10111,25,0,32},{10286,25,0,32},{10168,25,0,
32},{10250,25,0,32},{10123,25,0,32},{10168,23,0,32},{10250,23,0,32},{10123,23,0,
32},{10168,25,0,32},{10250,25,0,32},{10250,25,0,32},{10168,23,0,32},{10250,23,0,
32},{10250,23,0,32},{10179,25,0,32},{10122,25,0,32},{10285,25,0,32},{10179,25,0,
32},{10123,25,0,32},{10250,25,0,32},{10179,23,0,32},{10123,23,0,32},{10250,23,0,
32},{10184,25,0,32},{10250,25,0,32},{10122,25,0,32},{10184,23,0,32},{10250,23,0,
32},{10122,23,0,32},{10184,23,0,32},{10250,23,0,32},{10250,23,0,32},{10184,25,0,
32},{10250,25,0,32},{10286,25,0,32},{10190,25,0,32},{10111,25,0,32},{10250,25,0,
32},{10190,25,0,32},{10250,25,0,32},{10250,25,0,32},{10190,23,0,32},{10250,23,0,
32},{10250,23,0,32},{10190,25,0,32},{10250,25,0,32},{10285,25,0,32},{10191,25,0,
32},{10250,25,0,32},{10250,25,0,32},{10191,25,0,32},{10250,25,0,32},{10286,25,0,
32},{10191,25,0,32},{10250,25,0,32},{10285,25,0,32},{10199,25,0,32},{10123,25,0,
32},{10250,25,0,32},{10199,23,0,32},{10123,23,0,32},{10250,23,0,32},{10211,25,0,
32},{10250,25,0,32},{10122,25,0,32},{10211,25,0,32},{10250,25,0,32},{10250,25,0,
32},{10242,25,0,32},{10122,25,0,32},{10250,25,0,32},{10242,25,0,32},{10122,25,0,
32},{10286,25,0,32},{10242,25,0,32},{10122,25,0,32},{10285,25,0,32},{10242,23,0,
32},{10111,23,0,32},{10111,23,0,32},{10242,25,0,32},{10111,25,0,32},{10111,25,0,
32},{10242,25,0,32},{10123,25,0,32},{10250,25,0,32},{10242,23,0,32},{10123,23,0,
32},{10250,23,0,32},{10242,25,0,32},{10250,25,0,32},{10122,25,0,32},{10242,23,0,
32},{10250,23,0,32},{10122,23,0,32},{10250,23,0,32},{10122,23,0,32},{10111,23,0,
32},{10250,23,0,32},{10122,23,0,32},{10250,23,0,32},{10250,25,0,32},{10122,25,0,
32},{10286,25,0,32},{10250,23,0,32},{10111,23,0,32},{10122,23,0,32},{10250,23,0,
32},{10111,23,0,32},{10250,23,0,32},{10250,23,0,32},{10123,23,0,32},{10111,23,0,
32},{10250,23,0,32},{10123,23,0,32},{10250,23,0,32},{10250,23,0,32},{10111,23,0,
32},{10123,23,0,32},{10265,23,0,32},{10250,23,0,32},{10111,23,0,32},{10265,23,0,
32},{10250,23,0,32},{10250,23,0,32},{10254,23,0,32},{10122,23,0,32},{10250,23,0,
32},{10254,25,0,32},{10122,25,0,32},{10285,25,0,32},{10254,25,0,32},{10111,25,0,
32},{10250,25,0,32},{10254,23,0,32},{10111,23,0,32},{10250,23,0,32},{10254,25,0,
32},{10111,25,0,32},{10285,25,0,32},{10254,25,0,32},{10250,25,0,32},{10286,25,0,
32},{10254,25,0,32},{10250,25,0,32},{10285,25,0,32},{10286,25,0,32},{10250,25,0,
32},{10250,25,0,32},{10286,23,0,32},{10250,23,0,32},{10250,23,0,32},{10084,25,0,
32},{10123,25,0,32},{10286,25,0,32},{10101,25,0,32},{10111,25,0,32},{10286,25,0,
32},{10101,25,0,32},{10111,25,0,32},{10285,25,0,32},{10101,25,0,32},{10123,25,0,
32},{10286,25,0,32},{10101,25,0,32},{10123,25,0,32},{10285,25,0,32},{10101,25,0,
32},{10250,25,0,32},{10286,25,0,32},{10101,25,0,32},{10250,25,0,32},{10285,25,0,
32},{10111,25,0,32},{10250,25,0,32},{10286,25,0,32},{10111,25,0,32},{10122,25,0,
32},{10285,25,0,32},{10111,25,0,32},{10250,25,0,32},{10285,25,0,32},{10167,25,0,
32},{10123,25,0,32},{10285,25,0,32},{10178,25,0,32},{10122,25,0,32},{10286,25,0,
32},{10168,25,0,32},{10122,25,0,32},{10286,25,0,32},{10179,25,0,32},{10122,25,0,
32},{10286,25,0,32},{10242,25,0,32},{10111,25,0,32},{10286,25,0,32},{10242,25,0,
32},{10250,25,0,32},{10286,25,0,32},{10286,25,0,32},{10122,25,0,32},{10286,25,0,
32},{10286,25,0,32},{10111,25,0,32},{10286,25,0,32},{10286,25,0,32},{10250,25,0,
32},{10286,25,0,32},{10250,25,0,32},{10250,25,0,32},{10286,25,0,32},{10211,25,0,
32},{10250,25,0,32},{10286,25,0,32},{10254,25,0,32},{10122,25,0,32},{10286,25,0,
32},{10211,23,0,32},{10250,23,0,32},{10122,23,0,32},{10242,23,0,32},{10122,23,0,
32},{10250,23,0,32},{10190,25,0,32},{10250,25,0,32},{10286,25,0,32},{10218,25,0,
32},{10250,25,0,32},{10286,25,0,32},{10254,23,0,32},{10111,23,0,32},{10122,23,0,
32},{10250,25,0,32},{10123,25,0,32},{10286,25,0,32},{10242,23,0,32},{10111,23,0,
32},{10250,23,0,32},{10218,25,0,32},{10250,25,0,32},{10250,25,0,32},{10242,25,0,
32},{10111,25,0,32},{10250,25,0,32},{10254,25,0,32},{10111,25,0,32},{10122,25,0,
32},{10111,25,0,32},{10122,25,0,32},{10286,25,0,32},{10122,25,0,32},{10111,25,0,
32},{10286,25,0,32},{10250,25,0,32},{10111,25,0,32},{10286,25,0,32},{10199,25,0,
32},{10250,25,0,32},{10286,25,0,32},{10084,25,0,32},{10122,25,0,32},{10286,25,0,
32},{10218,23,0,32},{10250,23,0,32},{10250,23,0,32},{10190,23,0,32},{10111,23,0,
32},{10250,23,0,32},{10178,23,0,32},{10250,23,0,32},{10250,23,0,32},{10167,25,0,
32},{10123,25,0,32},{10286,25,0,32},{10254,25,0,32},{10111,25,0,32},{10286,25,0,
32},{10178,26,0,32},{10242,26,0,32},{10300,26,0,32},{10211,26,0,32},{10242,26,0,
32},{10300,26,0,32},{10082,26,0,32},{10242,26,0,32},{10242,26,0,32},{10265,26,0,
32},{10082,26,0,32},{10218,26,0,32},{10084,26,0,32},{10148,26,0,32},{10250,26,0,
32},{10122,26,0,32},{10250,26,0,32},{10133,26,0,32},{10178,26,0,32},{10242,26,0,
32},{10190,26,0,32},{10250,26,0,32},{10148,26,0,32},{10167,26,0,32},{10271,26,0,
32},{10242,26,0,32},{10190,26,0,32},{10242,26,0,32},{10286,26,0,32},{10265,26,0,
32},{10271,26,0,32},{10167,26,0,32},{10242,26,0,32},{10250,26,0,32},{10178,26,0,
32},{10242,26,0,32},{10285,26,0,32},{10178,26,0,32},{10242,26,0,32},{10285,26,0,
32},{521,26,1,32},{10082,26,0,32},{10242,26,0,32},{10242,26,0,32},{10265,26,0,
32},{521,26,1,32},{10190,26,0,32},{10242,26,0,32},{10286,26,0,32},{10265,26,0,
32},{521,26,1,32},{10271,26,0,32},{10167,26,0,32},{10242,26,0,32},{10250,26,0,
32},{10111,26,0,32},{10242,26,0,32},{521,26,1,32},{10111,26,0,32},{10242,26,0,
32},{10082,26,0,32},{10242,26,0,32},{10265,26,0,32},{10148,26,0,32},{10287,26,0,
32},{10082,26,0,32},{10242,26,0,32},{641,22,1,32},{641,22,1,32},{641,22,1,32},
{641,22,1,32},{641,22,1,32},{10242,26,0,32},{10069,26,0,32},{10242,25,0,32},
{10069,25,0,32},{10242,26,0,32},{10070,26,0,32},{10242,25,0,32},{10070,25,0,32},
{10242,26,0,32},{10074,26,0,32},{10242,25,0,32},{10074,25,0,32},{10242,26,0,32},
{10082,26,0,32},{10242,25,0,32},{10082,25,0,32},{8309,20,0,32},{8309,20,0,32},
{8309,20,0,32},{0,20,0,280},{8411,20,0,32},{8383,20,0,32},{9071,20,0,32},{8383,
20,0,32},{9086,20,0,32},{8383,20,0,32},{9090,20,0,32},{8383,20,0,32},{9100,20,0,
32},{8470,20,0,32},{8726,20,0,32},{8524,20,0,32},{0,20,0,57},{8624,20,0,32},
{8886,20,0,32},{8624,20,0,32},{9071,20,0,32},{8733,20,0,32},{0,20,0,47},{8927,
20,0,32},{8377,20,0,32},{8927,20,0,32},{8886,20,0,32},{8927,20,0,32},{8894,20,0,
32},{8927,20,0,32},{8906,20,0,32},{23569,4,0,32},{0,4,0,280},{23570,4,0,32},{0,
4,0,280},{23571,4,0,32},{0,4,0,280},{23572,4,0,32},{0,4,0,280},{23573,4,0,32},
{0,4,0,280},{23574,4,0,32},{0,4,0,280},{23575,4,0,32},{0,4,0,280},{23575,4,0,
32},{0,4,0,281},{23576,4,0,32},{0,4,0,280},{23577,4,0,32},{0,4,0,280},{23578,4,
0,32},{0,4,0,280},{23578,4,0,32},{0,4,0,281},{23579,4,0,32},{0,4,0,280},{23579,
4,0,32},{0,4,0,281},{23580,4,0,32},{0,4,0,280},{23580,4,0,32},{0,4,0,281},
{23581,4,0,32},{0,4,0,280},{23582,4,0,32},{0,4,0,280},{23583,4,0,32},{0,4,0,
280},{23584,4,0,32},{0,4,0,281},{23584,4,0,32},{0,4,0,282},{23585,4,0,32},{0,4,
0,280},{23586,4,0,32},{0,4,0,280},{23587,4,0,32},{0,4,0,280},{23588,4,0,32},{0,
4,0,280},{23588,4,0,32},{0,4,0,281},{23589,4,0,32},{0,4,0,280},{23589,4,0,32},
{0,4,0,281},{23590,4,0,32},{0,4,0,280},{23591,4,0,32},{0,4,0,280},{23584,4,0,
32},{0,4,0,280},{21154,4,0,32},{0,4,0,281},{20971,4,0,32},{0,4,0,280},{15809,4,
0,32},{0,4,0,280},{15811,4,0,32},{0,4,0,280},{15814,4,0,32},{0,4,0,280},{15815,
4,0,32},{0,4,0,280},{15816,4,0,32},{0,4,0,280},{15817,4,0,32},{0,4,0,280},
{15818,4,0,32},{0,4,0,280},{15819,4,0,32},{0,4,0,280},{15821,4,0,32},{0,4,0,
280},{15822,4,0,32},{0,4,0,280},{15823,4,0,32},{0,4,0,280},{15824,4,0,32},{0,4,
0,280},{15825,4,0,32},{0,4,0,280},{15826,4,0,32},{0,4,0,280},{15831,4,0,32},{0,
4,0,280},{15832,4,0,32},{0,4,0,280},{15833,4,0,32},{0,4,0,280},{15834,4,0,32},
{0,4,0,280},{15836,4,0,32},{0,4,0,280},{15840,4,0,32},{0,4,0,280},{15841,4,0,
32},{0,4,0,280},{15842,4,0,32},{0,4,0,280},{15843,4,0,32},{0,4,0,280},{15844,4,
0,32},{0,4,0,280},{15848,4,0,32},{0,4,0,280},{15849,4,0,32},{0,4,0,280},{15850,
4,0,32},{0,4,0,280},{15851,4,0,32},{0,4,0,280},{15768,10,0,32},{0,4,0,280},
{15776,10,0,32},{0,4,0,280},{15776,10,0,32},{0,4,0,281},{15781,10,0,32},{0,4,0,
280},{15791,10,0,32},{0,4,0,280},{15792,10,0,32},{0,4,0,280},{15792,10,0,32},{0,
4,0,281},{15795,10,0,32},{0,4,0,280},{15802,10,0,32},{0,4,0,280},{15803,10,0,
32},{0,4,0,280},{15768,4,0,32},{0,4,0,280},{15776,4,0,32},{0,4,0,280},{15776,4,
0,32},{0,4,0,281},{15781,4,0,32},{0,4,0,280},{15791,4,0,32},{0,4,0,280},{15792,
4,0,32},{0,4,0,280},{15792,4,0,32},{0,4,0,281},{15795,4,0,32},{0,4,0,280},
{15802,4,0,32},{0,4,0,280},{15803,4,0,32},{0,4,0,280},{21194,4,0,32},{0,4,0,
281},{21196,4,0,32},{0,4,0,281},{21198,4,0,32},{0,4,0,281},{21201,4,0,32},{0,4,
0,281},{21196,4,0,32},{21199,4,0,32},{21219,4,0,32},{0,4,0,281},{21131,4,0,32},
{21134,4,0,32},{11889,2,0,32},{0,2,0,194},{11890,2,0,32},{0,2,0,194},{11899,2,0,
32},{0,2,0,194},{12382,4,0,32},{0,4,0,280},{12382,4,0,32},{0,4,0,281},{12383,4,
0,32},{0,4,0,280},{12384,4,0,32},{0,4,0,280},{12430,4,0,32},{0,4,0,280},{12431,
4,0,32},{0,4,0,280},{12734,4,0,32},{0,4,0,280},{12750,4,0,32},{0,4,0,280},
{12737,4,0,32},{0,4,0,280},{8300,4,0,32},{0,4,0,280},{8301,4,0,32},{0,4,0,280},
{8302,2,0,32},{0,2,0,280},{4893,2,1,32},{0,0,0,0},{4894,2,1,32},{0,0,0,0},{4894,
2,1,32},{0,0,0,0},{0,0,0,0},{4894,2,1,32},{0,0,0,0},{0,0,0,0},{4894,2,1,32},{0,
0,0,0},{0,0,0,0},{4894,2,1,32},{0,0,0,0},{0,0,0,0},{4894,2,1,32},{0,0,0,0},{0,0,
0,0},{4946,2,1,32},{0,0,0,0},{4946,2,1,32},{0,0,0,0},{0,0,0,0},{4946,2,1,32},{0,
0,0,0},{0,0,0,0},{4947,2,1,32},{0,0,0,0},{4947,2,1,32},{0,0,0,0},{0,0,0,0},
{4947,2,1,32},{0,0,0,0},{0,0,0,0},{8470,4,0,32},{0,4,0,282},{8726,4,0,32},{8383,
4,0,32},{9109,4,0,32},{8927,4,0,32},{8911,4,0,32},{8383,4,0,32},{9110,4,0,32},
{8927,4,0,32},{8912,4,0,32},{8300,4,0,32},{0,4,0,280},{8301,4,0,32},{0,4,0,280},
{8301,4,0,32},{0,4,0,280},{8302,4,0,32},{0,4,0,280},{8303,4,0,32},{0,4,0,280},
{8304,4,0,32},{0,4,0,280},{8305,4,0,32},{0,4,0,280},{8306,4,0,32},{0,4,0,280},
{8307,4,0,32},{0,4,0,280},{8308,4,0,32},{0,4,0,280},{8299,4,0,32},{641,4,1,32},
{8299,4,0,32},{548,4,1,32},{8300,4,0,32},{548,4,1,32},{8301,4,0,32},{548,4,1,
32},{8302,4,0,32},{548,4,1,32},{8303,4,0,32},{548,4,1,32},{8304,4,0,32},{548,4,
1,32},{8305,4,0,32},{548,4,1,32},{8306,4,0,32},{548,4,1,32},{8307,4,0,32},{548,
4,1,32},{8308,4,0,32},{548,4,1,32},{820,4,1,32},{8309,10,0,32},{821,4,1,32},
{820,4,1,32},{8335,10,0,32},{821,4,1,32},{820,4,1,32},{8361,10,0,32},{821,4,1,
32},{820,4,1,32},{8383,10,0,32},{821,4,1,32},{820,4,1,32},{8411,10,0,32},{821,4,
1,32},{820,4,1,32},{8470,10,0,32},{821,4,1,32},{820,4,1,32},{8485,10,0,32},{821,
4,1,32},{820,4,1,32},{8524,10,0,32},{821,4,1,32},{820,4,1,32},{8551,10,0,32},
{821,4,1,32},{820,4,1,32},{8579,10,0,32},{821,4,1,32},{820,4,1,32},{8604,10,0,
32},{821,4,1,32},{820,4,1,32},{8624,10,0,32},{821,4,1,32},{820,4,1,32},{8680,10,
0,32},{821,4,1,32},{820,4,1,32},{8695,10,0,32},{821,4,1,32},{820,4,1,32},{8733,
10,0,32},{821,4,1,32},{820,4,1,32},{8781,10,0,32},{821,4,1,32},{820,4,1,32},
{8802,10,0,32},{821,4,1,32},{820,4,1,32},{8821,10,0,32},{821,4,1,32},{820,4,1,
32},{8886,10,0,32},{821,4,1,32},{820,4,1,32},{8927,10,0,32},{821,4,1,32},{820,4,
1,32},{8961,10,0,32},{821,4,1,32},{820,4,1,32},{9009,10,0,32},{821,4,1,32},{820,
4,1,32},{9027,10,0,32},{821,4,1,32},{820,4,1,32},{9037,10,0,32},{821,4,1,32},
{820,4,1,32},{9049,10,0,32},{821,4,1,32},{820,4,1,32},{9071,10,0,32},{821,4,1,
32},{926,4,1,32},{8886,10,0,32},{927,4,1,32},{8361,12,0,32},{8383,12,0,32},
{9027,12,0,32},{9071,12,0,32},{8524,29,0,32},{9009,29,0,32},{8680,29,0,32},
{9009,29,0,32},{8886,29,0,32},{8383,29,0,32},{8886,29,0,32},{8886,29,0,32},
{8781,29,0,32},{8781,29,0,32},{9009,29,0,32},{9027,29,0,32},{8361,29,0,32},
{8680,20,0,32},{8361,20,0,32},{8680,20,0,32},{8383,20,0,32},{8680,20,0,32},
{8821,20,0,32},{8551,29,0,32},{8361,29,0,32},{8781,29,0,32},{8309,29,0,32},
{8886,29,0,32},{8309,29,0,32},{8309,29,0,32},{8335,29,0,32},{9027,29,0,32},
{8361,29,0,32},{8383,29,0,32},{8579,29,0,32},{8361,29,0,32},{8624,29,0,32},
{8361,29,0,32},{8733,29,0,32},{8733,29,0,32},{8624,29,0,32},{8470,29,0,32},
{8821,29,0,32},{8411,29,0,32},{8411,29,0,32},{8551,29,0,32},{8383,29,0,32},
{8695,29,0,32},{8411,29,0,32},{9027,29,0,32},{8695,29,0,32},{8485,29,0,32},
{8733,29,0,32},{8604,29,0,32},{8886,29,0,32},{8733,29,0,32},{8886,29,0,32},
{8961,29,0,32},{8781,29,0,32},{616,28,1,32},{9009,29,0,32},{8886,29,0,32},{8302,
28,0,32},{8383,29,0,32},{8301,28,0,32},{8695,28,0,32},{8383,28,0,32},{521,28,1,
32},{8886,29,0,32},{8361,28,0,32},{8821,28,0,32},{8301,28,0,32},{8604,29,0,32},
{8303,28,0,32},{8604,29,0,32},{8307,28,0,32},{8604,29,0,32},{8304,28,0,32},{641,
28,1,32},{8300,28,0,32},{8306,28,0,32},{641,28,1,32},{8300,28,0,32},{8301,28,0,
32},{8301,28,0,32},{641,28,1,32},{8301,28,0,32},{8305,28,0,32},{8299,28,0,32},
{8781,29,0,32},{8300,28,0,32},{8301,28,0,32},{8299,28,0,32},{8781,29,0,32},
{8524,29,0,32},{8361,28,0,32},{8524,29,0,32},{8383,28,0,32},{8821,29,0,32},
{8524,29,0,32},{8551,28,0,32},{521,28,1,32},{8821,29,0,32},{8411,28,0,32},{8886,
28,0,32},{8624,29,0,32},{8733,28,0,32},{8886,28,0,32},{8886,28,0,32},{8624,28,0,
32},{8411,28,0,32},{8886,28,0,32},{8886,28,0,32},{8886,29,0,32},{8524,29,0,32},
{9009,29,0,32},{8961,29,0,32},{8524,29,0,32},{8383,29,0,32},{9009,29,0,32},
{8733,29,0,32},{8383,29,0,32},{17453,28,0,32},{17429,28,0,32},{17433,28,0,32},
{17433,28,0,32},{64320,28,0,32},{57931,0,0,0},{64320,28,0,32},{56151,0,0,0},
{64320,28,0,32},{54220,0,0,0},{17442,28,0,32},{0,28,0,55},{64320,28,0,32},
{52876,0,0,0},{64320,28,0,32},{55578,0,0,0},{64321,28,0,32},{35299,0,0,0},
{64320,28,0,32},{55593,0,0,0},{64320,28,0,32},{52900,0,0,0},{64320,28,0,32},
{58912,0,0,0},{64320,28,0,32},{61729,0,0,0},{64320,28,0,32},{58777,0,0,0},
{64320,28,0,32},{53837,0,0,0},{64320,28,0,32},{57228,0,0,0},{64320,28,0,32},
{53645,0,0,0},{64320,28,0,32},{58800,0,0,0},{64320,28,0,32},{53789,0,0,0},
{64320,28,0,32},{64834,0,0,0},{64320,28,0,32},{62751,0,0,0},{64321,28,0,32},
{36009,0,0,0},{64320,28,0,32},{55536,0,0,0},{64320,28,0,32},{54329,0,0,0},
{64320,28,0,32},{61204,0,0,0},{64320,28,0,32},{58005,0,0,0},{64320,28,0,32},
{58197,0,0,0},{64320,28,0,32},{52736,0,0,0},{64320,28,0,32},{52745,0,0,0},
{64321,28,0,32},{36938,0,0,0},{64320,28,0,32},{56806,0,0,0},{64320,28,0,32},
{52781,0,0,0},{64320,28,0,32},{54259,0,0,0},{64320,28,0,32},{58119,0,0,0},
{64321,28,0,32},{36208,0,0,0},{64320,28,0,32},{57939,0,0,0},{64320,28,0,32},
{63873,0,0,0},{64320,28,0,32},{64122,0,0,0},{64320,28,0,32},{54280,0,0,0},
{64320,28,0,32},{61056,0,0,0},{64320,28,0,32},{59145,0,0,0},{64320,28,0,32},
{59144,0,0,0},{64320,28,0,32},{62771,0,0,0},{64320,28,0,32},{53874,0,0,0},
{64320,28,0,32},{54710,0,0,0},{64321,28,0,32},{37197,0,0,0},{926,4,1,32},{64320,
4,0,32},{59180,0,0,0},{927,4,1,32},{926,4,1,32},{64320,4,0,32},{52745,0,0,0},
{927,4,1,32},{926,4,1,32},{64320,4,0,32},{52876,0,0,0},{927,4,1,32},{926,4,1,
32},{64320,4,0,32},{56201,0,0,0},{927,4,1,32},{926,4,1,32},{64320,4,0,32},
{61625,0,0,0},{927,4,1,32},{926,4,1,32},{64320,4,0,32},{57939,0,0,0},{927,4,1,
32},{926,4,1,32},{64320,4,0,32},{63191,0,0,0},{927,4,1,32},{926,4,1,32},{64320,
4,0,32},{53981,0,0,0},{927,4,1,32},{926,4,1,32},{64320,4,0,32},{58711,0,0,0},
{927,4,1,32},{64320,6,0,32},{57239,0,0,0},{64320,6,0,32},{54255,0,0,0},{64388,2,
0,32},{33058,0,0,0},{64388,2,0,32},{34076,0,0,0},{64388,2,0,32},{34085,0,0,0},
{64388,2,0,32},{34123,0,0,0},{64388,2,0,32},{34362,0,0,0},{64388,2,0,32},{34820,
0,0,0},{64388,2,0,32},{35038,0,0,0},{64388,2,0,32},{35372,0,0,0},{64388,2,0,32},
{35683,0,0,0},{64388,2,0,32},{38116,0,0,0},{64388,2,0,32},{38568,0,0,0},{64388,
2,0,32},{38634,0,0,0},{64388,2,0,32},{39368,0,0,0},{64388,2,0,32},{39704,0,0,0},
{64388,2,0,32},{40203,0,0,0},{64388,2,0,32},{40420,0,0,0},{64388,2,0,32},{40422,
0,0,0},{64388,2,0,32},{41347,0,0,0},{64388,2,0,32},{41375,0,0,0},{64388,2,0,32},
{41777,0,0,0},{64388,2,0,32},{42708,0,0,0},{64388,2,0,32},{43076,0,0,0},{64388,
2,0,32},{43082,0,0,0},{64388,2,0,32},{43788,0,0,0},{64388,2,0,32},{44017,0,0,0},
{64388,2,0,32},{45066,0,0,0},{64388,2,0,32},{45752,0,0,0},{64388,2,0,32},{45919,
0,0,0},{64388,2,0,32},{45971,0,0,0},{64388,2,0,32},{45980,0,0,0},{64388,2,0,32},
{46019,0,0,0},{64388,2,0,32},{46037,0,0,0},{64388,2,0,32},{46189,0,0,0},{64388,
2,0,32},{46755,0,0,0},{64388,2,0,32},{47271,0,0,0},{64388,2,0,32},{47757,0,0,0},
{64388,2,0,32},{47866,0,0,0},{64388,2,0,32},{48316,0,0,0},{64388,2,0,32},{48414,
0,0,0},{64388,2,0,32},{48849,0,0,0},{64388,2,0,32},{48990,0,0,0},{64388,2,0,32},
{49038,0,0,0},{64388,2,0,32},{49763,0,0,0},{64388,2,0,32},{49902,0,0,0},{64388,
2,0,32},{50091,0,0,0},{64388,2,0,32},{50696,0,0,0},{64388,2,0,32},{50997,0,0,0},
{64388,2,0,32},{51220,0,0,0},{64388,2,0,32},{52278,0,0,0},{64388,2,0,32},{52370,
0,0,0},{64388,2,0,32},{53153,0,0,0},{64388,2,0,32},{53176,0,0,0},{64388,2,0,32},
{53316,0,0,0},{64388,2,0,32},{53490,0,0,0},{64388,2,0,32},{53491,0,0,0},{64388,
2,0,32},{53529,0,0,0},{64388,2,0,32},{53555,0,0,0},{64388,2,0,32},{53833,0,0,0},
{64388,2,0,32},{54301,0,0,0},{64388,2,0,32},{54822,0,0,0},{64388,2,0,32},{54938,
0,0,0},{64388,2,0,32},{54981,0,0,0},{64388,2,0,32},{55676,0,0,0},{64388,2,0,32},
{55975,0,0,0},{64388,2,0,32},{56235,0,0,0},{64388,2,0,32},{56448,0,0,0},{64388,
2,0,32},{56528,0,0,0},{64388,2,0,32},{57222,0,0,0},{64388,2,0,32},{57818,0,0,0},
{64388,2,0,32},{57896,0,0,0},{64388,2,0,32},{57927,0,0,0},{64388,2,0,32},{58073,
0,0,0},{64388,2,0,32},{58174,0,0,0},{64388,2,0,32},{58586,0,0,0},{64388,2,0,32},
{58659,0,0,0},{64388,2,0,32},{58792,0,0,0},{64388,2,0,32},{59303,0,0,0},{64388,
2,0,32},{59317,0,0,0},{64388,2,0,32},{60220,0,0,0},{64388,2,0,32},{60470,0,0,0},
{64388,2,0,32},{60629,0,0,0},{64388,2,0,32},{60779,0,0,0},{64388,2,0,32},{61228,
0,0,0},{64388,2,0,32},{61361,0,0,0},{64388,2,0,32},{61650,0,0,0},{64388,2,0,32},
{62410,0,0,0},{64388,2,0,32},{63079,0,0,0},{64388,2,0,32},{63662,0,0,0},{64388,
2,0,32},{63846,0,0,0},{64388,2,0,32},{64680,0,0,0},{64388,2,0,32},{65235,0,0,0},
{64388,2,0,32},{65327,0,0,0},{64389,2,0,32},{34258,0,0,0},{64389,2,0,32},{34285,
0,0,0},{64389,2,0,32},{34606,0,0,0},{64389,2,0,32},{35834,0,0,0},{64389,2,0,32},
{36215,0,0,0},{64389,2,0,32},{37189,0,0,0},{64389,2,0,32},{37343,0,0,0},{64389,
2,0,32},{37402,0,0,0},{64389,2,0,32},{37898,0,0,0},{64389,2,0,32},{38038,0,0,0},
{64389,2,0,32},{38326,0,0,0},{64389,2,0,32},{39728,0,0,0},{64389,2,0,32},{41166,
0,0,0},{64389,2,0,32},{41221,0,0,0},{64389,2,0,32},{41486,0,0,0},{64389,2,0,32},
{41617,0,0,0},{64389,2,0,32},{41874,0,0,0},{64389,2,0,32},{42496,0,0,0}};
