/* -*- c-basic-offset:2; tab-width:2; indent-tabs-mode:nil -*- */
/*
 * Copyright (c) Araki Ken(arakiken@users.sourceforge.net)
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. The name of any author may not be used to endorse or promote
 *    products derived from this software without their specific prior
 *    written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
*/

#include "drcssixel.c"

static void pua_to_utf8(unsigned char *dst, unsigned int *src, unsigned int len) {
  unsigned int i;

  for(i = 0; i < len; i++) {
    unsigned int code = src[i];
    *(dst++) = ((code >> 18) & 0x07) | 0xf0;
    *(dst++) = ((code >> 12) & 0x3f) | 0x80;
    *(dst++) = ((code >> 6) & 0x3f) | 0x80;
    *(dst++) = (code & 0x3f) | 0x80;
  }
}

static int output(char *path, char *sixel) {
  unsigned int *buf;
  size_t sixel_len = strlen(sixel);
  char charset = '0';
  int is_96cs = 0;
  int num_cols;
  int num_rows;
  int col;
  int row;

  if (path) {
    if (!(buf = drcs_sixel_from_file(path, &charset, &is_96cs, &num_cols, &num_rows))) {
      return 1;
    }
  } else {
    if (!(buf = drcs_sixel_from_data(sixel, sixel_len, &charset, &is_96cs, &num_cols, &num_rows))) {
      return 1;
    }
  }

  pua_to_utf8(buf, buf, num_cols * num_rows);

  printf("cs: 0(94cs)-%c(%s)\n", charset, is_96cs ? "96cs" : "94cs");

  for(row = 0; row < num_rows; row++) {
    for (col = 0; col < num_cols; col++) {
      write(STDOUT_FILENO, buf++, 4);
    }
    write(STDOUT_FILENO, "\n", 1);
  }

  /* XXX buf is not freed */

  return 0;
}

int main(int argc, char **argv) {
  char *sixel1 = "\x1bPq\"1;1;32;32#0;2;0;0;0#1;2;97;97;97#2;2;75;75;72#3;2;91;91;91#4;2;88;88;88#5;2;85;85;85#6;2;85;85;82#7;2;82;82;82#8;2;78;78;78#9;2;75;75;75#10;2;44;44;44#11;2;16;16;16#12;2;6;6;6#13;2;9;9;9#14;2;19;19;19#15;2;22;22;22#16;2;25;25;25#17;2;28;28;28#18;2;72;72;72#19;2;38;38;38#20;2;35;35;35#21;2;69;69;69#22;2;3;3;3#23;2;63;63;50#24;2;69;69;38#25;2;22;44;75#26;2;13;31;44#27;2;69;66;56#28;2;28;31;19#29;2;91;75;41#30;2;91;78;47#31;2;91;75;50#32;2;22;47;85#33;2;16;38;66#34;2;3;6;16#35;2;28;53;78#36;2;56;63;44#37;2;13;35;69#38;2;13;35;66#39;2;16;19;25#40;2;25;41;53#41;2;91;78;56#42;2;94;85;72#43;2;97;91;85#44;2;50;63;66#45;2;9;25;50#46;2;16;19;28#47;2;97;91;88#48;2;66;63;31#49;2;50;56;41#50;2;19;38;56#51;2;22;41;72#52;2;13;28;66#53;2;9;25;47#54;2;6;6;13#55;2;28;53;82#56;2;72;72;69#57;2;97;94;91#58;2;25;44;72#59;2;35;63;88#60;2;9;22;47#61;2;0;3;6#62;2;28;50;85#63;2;28;50;78#64;2;9;9;6#65;2;31;56;85#66;2;13;13;13#67;2;47;72;88#68;2;35;56;85#69;2;31;53;82#70;2;85;85;78#71;2;50;53;60#72;2;41;35;25#73;2;35;31;25#74;2;22;44;66#75;2;75;60;22#0~@@@pPPP!8@!9`!4@~~~$#1?}!23AaAA#10{$#3??{{!4KC#12OOO???_#7GKKKC#16?OO#9GC#18_o$#10!5?__#19_#11O???__!4O#14OO#8GKKKC#2G[KA$#4!8?GKKKC#6GKKC#17!7?OO$#20!8?_#17_#16_#15_!8?OO$#13!12?OO_$#5!12?GC-#0~???@!9?_w~^NN^^^N^_???~~~$#1?~!4?DA?CC#22!6?_?O#23_#24_#25_#26_#1?N#18FB#10~$#3??FB#13G!7?_OF!9?_#8O#21W[$#4??w{#12E!8?_WF!7?O#27???_$#11!4?o!6?_WN!4?_$#15!5?__?_?OD!6?O!7?_$#20!5?CIKIB!9?_$#16!5?O?_?OGA$#17!5?GOOOGB$#19!5?A??D#14__WF$#10!5?@?@-#0~!4?ooo}}}mY@A@#30AAABGO#24WQC#37A?_#20@?CO$#1?~#5A@#14@?@@@!4?A@#41C???So#21C#32@@#25a_#38EO#53G#46O#12_#14_$#6??{]#15A#12GGG!4?D#22C#6_#43GGKO#27?A@#36A#49_W#19@#34@#0@AFZN$#4??@#7_#16{#13CCC???P#34_#46G#18G#47O??g#31?Dg#44C#48G#33@#40C#51w#39AC#54G$#11!5?BAA?@@#55??O#40C#1__o#35???A#50???G#45?CO#60_$#59!13?_#56O#10A#42C?Cg#58!5?O#52?G_$#28!16?@#29@@???_C$#57!16?O-#0~!4?!6NK#65C_???_???O?E#51__@F#60oN#14C#0]$#1?~??\?!6O!6?@#44g??G#10_#40_#32PG#37o#52oN#46oG#22@$#8??ow_#9_#2___#18__#22Q#69GW?G!7?G#25?OM#38G#39??O#61_$#7??NF#16F#54!6?_#58Q!8?_#49@#63??@#54!4?_$#17!4?W#61!6?@#26`#59FW__!5?G#64!7?@$#41!14?@??CA?@#23E#66!8?A$#67!14?C!5?G#29@$#68!14?_O???K#62O?CPME$#7!14?A#57BB#30WOP#71_$#4!15?C#55O!5?Q$#43!16?CA#27C?C$#70!16?G#42?@#31AA$#24!19?_-#0~!11wy_O_#50Oo_#25C#53_!6?@#34G#12C#61@$#2?C??AAB@#19???@#34@C??_#51G#32?A#48INBA#28G#66_O??A$#1?B#10!10C#14C#20O_!5?O#72O?KFC#39C?C@$#8??B@#28@#49@#18?ABBB#27A#33?A!4?OO#44@#15_#16__oO#54_O#22?G$#9???A#63!9?@??K#55C#37?G#75C#73?OO?I#14G#0_oo}~$#22!13?G#26G!4?_#49??K#36@#38?@#45@#46EB$#65!14?@BA?C#62@#60!6?A#11G$#74!14?CG#59@BB$#69!14?A#58C??G$#46!15?O-#0!15BAB?A?AAA?AA!6B$#10!15?@#22?@!7?@$#19!17?A#61@A???A#12@$#39!19?@#46@#15@@#66@\x1b\\";
  char *sixel2 = "\x1bPq\"1;1;49;43#0;2;97;97;88#1;2;96;96;86#2;2;96;96;83#3;2;95;95;85#4;2;95;95;82#5;2;95;95;78#6;2;93;91;87#7;2;93;93;78#8;2;94;93;73#9;2;90;90;90#10;2;90;90;87#11;2;90;88;83#12;2;90;87;83#13;2;87;87;83#14;2;89;89;75#15;2;90;87;61#16;2;86;85;83#17;2;87;83;80#18;2;83;83;80#19;2;88;85;61#20;2;83;82;77#21;2;83;80;77#22;2;89;82;61#23;2;81;83;69#24;2;80;80;77#25;2;80;80;70#26;2;80;79;74#27;2;80;77;74#28;2;82;79;62#29;2;83;78;57#30;2;78;78;69#31;2;74;78;71#32;2;77;76;74#33;2;77;74;71#34;2;78;74;62#35;2;81;75;57#36;2;75;75;71#37;2;74;75;58#38;2;77;72;58#39;2;73;71;68#40;2;79;71;51#41;2;75;69;51#42;2;73;69;49#43;2;74;68;50#44;2;69;75;62#45;2;69;72;67#46;2;72;71;69#47;2;71;69;64#48;2;62;70;55#49;2;69;67;64#50;2;71;68;51#51;2;70;67;46#52;2;67;67;60#53;2;60;68;66#54;2;71;66;49#55;2;68;66;60#56;2;66;66;58#57;2;64;64;59#58;2;64;63;58#59;2;63;61;58#60;2;67;62;46#61;2;66;60;41#62;2;61;64;53#63;2;61;61;59#64;2;60;60;51#65;2;52;64;59#66;2;52;61;58#67;2;52;60;50#68;2;61;60;60#69;2;61;59;52#70;2;59;59;52#71;2;51;59;55#72;2;58;58;58#73;2;58;57;58#74;2;59;57;55#75;2;58;58;55#76;2;58;57;53#77;2;60;57;38#78;2;57;56;55#79;2;57;54;51#80;2;57;54;43#81;2;55;55;55#82;2;49;57;61#83;2;53;55;48#84;2;55;55;51#85;2;54;54;51#86;2;55;53;55#87;2;55;53;52#88;2;55;53;52#89;2;60;50;45#90;2;53;51;47#91;2;52;52;52#92;2;52;50;52#93;2;52;52;41#94;2;52;48;37#95;2;51;51;50#96;2;51;50;48#97;2;51;50;39#98;2;49;51;48#99;2;50;48;44#100;2;47;48;47#101;2;48;48;46#102;2;47;47;47#103;2;47;44;29#104;2;41;57;69#105;2;44;53;48#106;2;32;52;70#107;2;30;51;72#108;2;41;49;52#109;2;31;50;68#110;2;28;48;68#111;2;27;48;68#112;2;46;46;44#113;2;44;45;44#114;2;28;46;64#115;2;45;44;44#116;2;45;44;41#117;2;44;44;44#118;2;41;44;41#119;2;28;44;58#120;2;45;43;41#121;2;41;42;41#122;2;42;42;42#123;2;41;41;41#124;2;42;41;33#125;2;40;40;38#126;2;37;39;37#127;2;29;41;48#128;2;25;41;58#129;2;23;40;58#130;2;39;38;38#131;2;37;37;37#132;2;38;37;36#133;2;37;37;37#134;2;37;37;30#135;2;35;37;33#136;2;34;36;34#137;2;35;35;35#138;2;34;34;34#139;2;35;34;32#140;2;33;36;32#141;2;32;34;32#142;2;35;32;30#143;2;32;32;30#144;2;31;33;31#145;2;31;32;26#146;2;31;31;31#147;2;31;33;30#148;2;31;31;31#149;2;31;31;28#150;2;30;31;30#151;2;30;30;29#152;2;24;37;50#153;2;20;37;53#154;2;20;37;54#155;2;25;32;37#156;2;17;33;50#157;2;28;31;25#158;2;28;30;28#159;2;21;30;37#160;2;16;30;44#161;2;28;29;28#162;2;28;29;28#163;2;28;29;28#164;2;28;28;28#165;2;28;28;26#166;2;27;29;27#167;2;27;28;27#168;2;27;28;27#169;2;23;29;33#170;2;14;29;44#171;2;28;28;28#172;2;26;28;26#173;2;27;26;27#174;2;26;27;28#175;2;28;26;28#176;2;27;25;27#177;2;26;25;26#178;2;26;25;25#179;2;25;25;25#180;2;25;25;25#181;2;24;24;24#182;2;20;26;31#183;2;18;24;30#184;2;14;27;41#185;2;12;26;44#186;2;13;26;36#187;2;15;25;34#188;2;12;25;36#189;2;24;24;24#190;2;24;23;24#191;2;24;22;24#192;2;23;23;22#193;2;21;23;21#194;2;24;22;24#195;2;23;22;23#196;2;23;21;23#197;2;22;21;22#198;2;22;20;22#199;2;20;20;20#200;2;16;23;31#201;2;17;24;27#202;2;13;22;31#203;2;19;20;21#204;2;14;21;26#205;2;19;19;19#206;2;19;19;19#207;2;20;18;20#208;2;17;18;19#209;2;18;19;15#210;2;11;23;36#211;2;10;23;38#212;2;10;22;36#213;2;10;22;33#214;2;11;22;31#215;2;11;22;31#216;2;10;22;32#217;2;11;21;33#218;2;10;21;34#219;2;11;21;31#220;2;12;21;29#221;2;11;21;29#222;2;11;21;30#223;2;12;21;28#224;2;11;21;28#225;2;11;21;28#226;2;10;21;31#227;2;11;21;27#228;2;10;19;28#229;2;17;17;17#230;2;17;16;17#231;2;16;16;16#232;2;10;17;23#233;2;8;16;23#234;2;8;16;22#235;2;14;14;14#236;2;12;13;12#237;2;12;12;12#238;2;7;13;17#239;2;9;11;12#240;2;7;10;12#241;2;4;6;8#242;2;2;4;5#243;2;1;1;2#244;2;1;1;1#245;2;1;1;1#246;2;1;1;1#247;2;0;1;1#248;2;0;0;1#249;2;0;0;0#250;2;0;0;0#251;2;0;0;0#252;2;0;0;0#253;2;0;0;0#254;2;0;0;0#255;2;0;0;0$#255!12?#255??#255??#255??#255??#255??#255??#255!16?#255!9?$#255!9?#255??#255!16?#255?#255!12?#255??#255!7?$#255!6?#255!3?#255?#255?#255??#255??#255?#255??#255?#255??#255?#255?#255??#255?#255!3?#255?#255!8?#255?#255?#255?#255?#255?#255!6?$#255!5?#255?#255??#255?#255?#255??#255?#255??#255!4?#255?#255!4?#255?#255?#255??#255?#255?#255??#255?#255?#255!3?#255?#255?#255?#255?#255?#255?#255?#255!5?$#255!3?#255??#255?#255?#255?#255?#255?#255?#255?#255?#255?#255?#255?#255??#255?#255?#255??#255??#255?#255!4?#255?#255?#255?#255??#255?#255?#255?#255?#255?#255?#255?#255?#255?#255?#255?#255!4?$-#255!3?#255?#255?#255?#255?#255?#255?#255?#255?#255?#255??#255!7?#255?#255?#255!6?#255?#255??#255?#255!3?#255?#255?#255?#255?#255?#255?#255?#255?#255?#255!4?$#255??#255?#255?#255?#255?#255?#255?#255?#255?#255?#255?#255?#255!3?#255?#255?#255??#255?#255?#255??#255??#255??#255?#255?#255!3?#255?#255?#255?#255?#255?#255?#255?#255?#255?#255?#255?#255?#255!4?$#255??#255?#255?#255?#255?#255?#255?#255?#255?#255?#255?#255?#255?#255??#255??#255??#255??#255?#255??#255?#255!3?#255?#255!3?#255!3?#255?#255?#255?#255?#255?#255?#255?#255?#255?#255?#255!3?$#255??#255?#255?#255?#255?#255?#255?#255?#18G#6!5G#10GG#11GG#13GG#16G#17G#18GG#20G#21G#24G#26GG#27G#32GG#33G#36G#39GG#49G#63G#84G#101G#255?#255?#255?#255?#255?#255?#255??$#255??#255?#255?#255?#255?#255?#255?#18O#6!5O#10OO#11OO#13OO#16O#17O#18OO#20O#24OO#26OO#27O#32OO#33O#36O#39OO#47O#49O#57O#58O#96O#255?#255?#255?#255?#255?#255?#255??$#255??#255?#255?#255?#255?#255?#255?#6__#46_#102!6_#113__#117_#121__#123_#126_#131__#136__#138__#144_#146_#158__#164_#175_#176_#189_#101_#59_#79_#255_#255?#255?#255?#255?#255?#255??$-#255??#255?#255?#255?#255?#255?#255?#6@@#102@#81@#32@#68@#72@#86@#92@#91@#81@#92@#113@@#117@#121@@#131!3@#146@#158@@#164@#175@#164@#175@@#181@#194@#196@#59@#75@#255@#255@#255?#255?#255?#255?#255?#255?$#255??#255?#255?#255?#255?#255?#255?#6AA#86A#46A#9A#46A#57A#92A#100A#102AA#113AA#123A#126AA#131A#138!3A#144A#146A#158AA#164A#175AA#180A#191A#196A#199A#72A#76A#255A#255A#255?#255?#255?#255?#255?#255?$#255??#255?#255?#255?#255?#255?#255?#6CC#102C#57C#36C#72C#91C#73CC#121C#100C#72!3C#113C#92C#81C#100C#123C#86C#91C#68C#131C#136C#81C#138CC#191CC#199C#205C#74C#84C#255C#255C#255?#255?#255?#255?#255?#255?$#255??#255?#255?#255?#255?#255?#255?#6G#10G#102G#57G#46G#113GG#92G#121GG#123G#126GG#131G#136GG#138G#144GG#146GG#162G#171G#175GG#180GG#191G#199GG#229G#75G#84G#255G#255G#255?#255?#255?#255?#255?#255?$#255??#255?#255?#255?#255?#255?#255?#10OO#102O#68O#73O#91O#92O#100O#81O#86O#72O#113O#73O#117O#136O#100O#144OO#102O#162O#133O#136O#176OO#189O#194OO#199OO#229O#230O#78O#87O#255O#255O#255?#255?#255?#255?#255?#255?$#255??#255?#255?#255?#255?#255?#255?#11__#102_#86_#81_#117_#121__#123_#126__#131_#136__#138_#144_#147_#148__#166_#173_#177__#192_#198__#206__#230_#231__#88_#90_#255_#255_#255_#255?#255?#255?#255?#255?$-#255??#255?#255?#255?#255?#255?#255?#11@#12@#91@#72@#73@#68@#81@#102@#72@#113@@#92@#121@#100@#102@#123@#148@#117@#122@#144@#147@#151@#136@#131@#150@#181@#189@#235!3@#236@#96@#98@#255@#255@#255@#255?#255?#255?#255?#255?$#255??#255?#255?#255?#255?#255?#255?#12A#13A#117A#91A#102A#121A#123A#126AA#131A#136AA#138A#144A#147A#148A#167A#172A#179A#190A#195A#205A#229A#231A#235AA#237!5A#116A#115A#255A#255A#255A#255?#255?#255?#255?#255?$#255??#255?#255?#255?#255?#255?#255?#13C#16C#117C#102C#121C#102C#126CC#131C#136CC#138C#144C#147C#148C#167C#172C#179C#195C#197C#229C#208C#187C#155C#127C#108C#105C#125C#157C#199C#236C#132C#125C#252C#255C#255C#255?#255?#255?#255?#255?$#255??#255?#255?#255?#255?#255?#255?#16G#13G#100G#91G#123G#91G#113G#73G#117G#121G#81G#123GG#91G#118G#137G#115G#161G#179G#174G#159G#119G#82GG#67!3G#83G#93G#97G#140G#145G#143G#246G#249G#252G#255?#255?#255?#255?#255?$#255??#255?#255?#255?#255?#255?#255?#17O#18O#121O#113O#126OO#131O#136OO#138O#144OO#148O#166O#172O#179O#195O#199O#203O#152O#106O#46O#25O#53O#82OO#58O#62O#98O#80O#60O#77O#103O#237O#246O#249O#252?#255?#255?#255?#255?$#255??#255?#255?#255?#255?#255?#255?#18__#123_#117_#126_#131_#136__#121_#123__#148_#166_#137_#179_#195_#199_#203_#128_#53_#24_#3_#0_#3_#31_#82__#81_#56_#50_#41_#62_#51_#103_#237_#245_#249?#252?#255?#255?#255?$-#255??#255?#255?#255?#255?#255?#255?#18@#20@#126@#121@#131@#92@#121@#100@#123@@#102@#113@#133@#137@#136@#144@#195@#128@#53@#4@#2@#0@#3@#2@#5@#11@#13@#31@#52@#15@#19@#50@#51@#61@#134@#243@#246@#249?#252?#255?#255?$#255??#255?#255?#255?#255?#255?#255?#20A#21A#126A#131AA#136A#138A#144AA#146A#162A#166A#173A#180A#195A#229A#159A#106A#18A#0AA#1A#4A#2A#5AA#3A#4A#28A#19A#15A#38A#51A#77A#94A#192A#244A#246?#251?#255?#255?$#255??#255?#255?#255?#255?#255?#255?#21C#24C#131C#136CC#138C#144CC#146C#158C#162C#171C#177C#190C#205C#208C#129C#104C#23C#8C#4C#2C#1C#0C#2C#4C#3C#4C#37C#56C#15C#37C#64C#77C#94C#134C#240C#246?#250?#253?#255?$#255??#255?#255?#255?#255?#255?#255?#24G#26G#136GG#138G#144GG#146GG#158G#171G#176G#177G#199G#229G#200G#111G#104G#52G#37G#23G#14G#7GG#8G#5GG#8G#28G#70G#19G#15G#42G#140G#124GG#209G#247?#252?#254?#255?$#255??#255?#255?#255?#255?#255?#255?#26OO#136O#138O#144OO#146O#158OO#164O#175O#176O#192O#207O#231O#184O#110O#107O#104O#82O#65O#48O#44OO#37O#28O#22OO#35O#64O#38O#41O#93O#183O#201O#134O#193O#249?#252?#255?#255?$#255??#255?#255?#255?#255?#255?#255?#26_#27_#138_#144__#146__#158_#164_#175__#189_#198_#207_#235_#153_#111_#107__#106__#82_#48_#67__#62_#50_#41_#43__#64_#127_#186_#202_#204_#145_#192_#252_#255?#255?#255?$-#255??#255?#255?#255?#255?#255?#255?#27@#32@#144@@#86@#73@@#92@#81@#100@#68@#91@#122@#112@#168@#129@#111@#110@#107@#109@@#66@#48@@#50!3@#41@@#40@#43@#155@#210@#222@#220@#167@#201@#254@#255?#255?#255?$#255??#255?#255?#255?#255?#255?#255?#32A#33A#73A#146A#162AA#171A#175AA#181A#191A#196A#206A#230A#237A#154A#114A#111A#110AA#114A#104A#34A#40AA#43A#60!3A#116A#155A#188A#213A#220AA#201A#204A#255A#255?#255?#255?$#255??#255?#255?#255?#255?#255?#255?#49C#33C#46CC#39C#47C#49CC#55CC#57C#59C#74C#96C#130C#153C#129C#114!3C#119C#108C#23C#35C#40C#54C#60C#61C#123C#160C#186C#213C#222C#223!3C#233C#254C#255?#255?#255?$#255??#255?#255?#255?#255?#255?#255?#255?#74G#49GG#52GG#57GG#58G#63G#89GG#79G#116G#142G#159G#129GG#128!3G#57G#28G#29G#40G#60G#61G#77G#159G#184G#188G#216G#224G#223GG#224G#238G#251G#255?#255?#255?$#255??#255?#255?#255?#255?#255?#255?#255?#255?#126O#97O#63!3O#74OO#75O#78O#84O#96O#115O#132O#155O#154O#129!3O#153O#75O#35O#29O#42O#60O#80O#93O#159O#187O#202O#225O#224O#227O#224O#225O#240O#251?#252?#255?#255?$#255??#255?#255?#255?#255?#255?#255?#255?#255?#255?#255_#255_#255_#255_#179_#181_#151_#120_#124_#165_#149_#139_#168_#184_#156_#154_#153__#108_#22_#29_#54_#61_#121_#155__#136_#200_#225__#227_#224_#234_#242_#250?#252?#255?#255?$-#255??#255?#255?#255?#255?#255?#255?#255?#255?#255?#255?#255@#255@#255@#149@#165@#135@@#149@#151@#143@#151@#193@#200@#170@#156!3@#152@#28@#29@#51@#80@#159@#187@#141@#182@#220@#221@#227@@#225@#240@#248@#250?#252?#255?#255?$#255??#255?#255?#255?#255?#255?#255?#255?#255?#255?#141A#98A#95A#79AA#84A#88A#85A#95A#96A#101A#116A#132A#151A#187A#170!3A#160A#98A#60A#89A#155A#210A#212A#200A#214A#219A#222A#225AA#238A#244A#248?#251?#253?#255?#255?$#255??#255?#255?#255?#255?#255?#255?#255?#255?#255?#136C#85C#84C#74CC#75C#76CC#84C#85C#95C#99C#120C#132C#163C#200C#188CC#185CC#184C#211CC#212C#213C#214C#215C#219CC#228C#234C#242C#247C#249?#252?#255?#255?#255?$#255!3?#255?#255?#255?#255?#255?#255?#255?#255?#255?#255?#255?#255G#255G#255G#255G#255G#255G#255G#255G#255G#255G#252G#246G#242G#233G#212G#211!3G#212G#217G#213G#214G#216GG#215G#226G#234G#242G#247G#249?#252?#253?#255?#255?#255?$#255!4?#255?#255?#255?#255?#255?#255?#255?#255?#255?#255?#255?#255O#255O#255O#255O#255O#255O#255O#255O#255O#255O#252O#246O#243O#238O#228O#218!3O#216O#219O#215O#213O#216O#233O#238O#243O#248?#249?#252?#254?#255?#255?#255?#255?$#255!5?#255?#255?#255?#255?#255?#255?#255?#255?#255?#255?#255?#255?#255?#255_#255_#255__#255_#255_#255_#255_#252_#246_#245_#242_#240_#238_#228_#218_#226_#233_#238_#240_#242_#246_#246?#249?#252?#254?#255?#255?#255?#255?#255?$-#255!5?#255??#255?#255?#255?#255?#255?#255?#255?#255?#255?#255?#255?#255?#255?#255?#255?#255?#255?#255?#255?#255?#252?#249?#247?#249@#250@#252@#254@#255@#253@#251@#249?#248?#248?#251?#252?#254?#255?#255?#255?#255?#255??$#255!6?#255?#255?#255?#255?#255?#255?#255?#255?#255?#255?#255?#255?#255?#255?#255!3?#255?#255?#255?#255?#255?#252?#251?#252?#252?#255?#255??#255?#254?#252?#251?#252?#254?#255?#255?#255?#255?#255?#255!3?$#255!7?#255??#255?#255??#255?#255?#255?#255?#255?#255??#255?#255?#255?#255?#255?#255?#255?#255?#255?#255?#255?#255?#255?#255??#255?#255?#255?#255?#255?#255?#255?#255?#255?#255?#255!5?$#255!9?#255!5?#255!8?#255?#255?#255?#255?#255??#255?#255?#255?#255?#255?#255??#255?#255?#255?#255?#255?#255?#255?#255!7?$#255!14?#255!15?#255?#255?#255?#255!4?#255??#255?#255!10?$$-\x1b\\";

  if (argc == 2) {
    return output(argv[1], NULL);
  } else {
    output(NULL, sixel1);
    output(NULL, sixel2);

    return 0;
  }
}
