"""Python handler for mkdocstrings."""

from mkdocstrings_handlers.python._internal.config import (
    AutoStyleOptions,
    GoogleStyleOptions,
    Inventory,
    NumpyStyleOptions,
    PerStyleOptions,
    PythonConfig,
    PythonInputConfig,
    PythonInputOptions,
    PythonOptions,
    SphinxStyleOptions,
    SummaryOption,
)
from mkdocstrings_handlers.python._internal.handler import PythonHandler, get_handler
from mkdocstrings_handlers.python._internal.rendering import (
    AutorefsHook,
    Order,
    Tree,
    do_as_attributes_section,
    do_as_classes_section,
    do_as_functions_section,
    do_as_modules_section,
    do_backlink_tree,
    do_crossref,
    do_filter_objects,
    do_format_attribute,
    do_format_code,
    do_format_signature,
    do_get_template,
    do_multi_crossref,
    do_order_members,
    do_split_path,
    do_stash_crossref,
)

__all__ = [
    "AutoStyleOptions",
    "AutorefsHook",
    "GoogleStyleOptions",
    "Inventory",
    "NumpyStyleOptions",
    "Order",
    "PerStyleOptions",
    "PythonConfig",
    "PythonHandler",
    "PythonInputConfig",
    "PythonInputOptions",
    "PythonOptions",
    "SphinxStyleOptions",
    "SummaryOption",
    "Tree",
    "do_as_attributes_section",
    "do_as_classes_section",
    "do_as_functions_section",
    "do_as_modules_section",
    "do_backlink_tree",
    "do_crossref",
    "do_filter_objects",
    "do_format_attribute",
    "do_format_code",
    "do_format_signature",
    "do_get_template",
    "do_multi_crossref",
    "do_order_members",
    "do_split_path",
    "do_stash_crossref",
    "get_handler",
]
