#!/usr/bin/env python

from distutils.core import setup

if __name__=='__main__':
    setup(name='mailping',
          description='monitor email service availability and functioning',
           long_description="""

Monitor email service availability and functioning. Tests the whole
route from SMTP submission to local delivery, not just whether an SMTP
server accepts TCP connections.

Multiple email servers can be tested by creating a remote alias that
points back to a local address, and sending test emails to it.

The results of this monitoring are available as graphs via Munin
plugins, and can be connected to Nagios to send alerts when the test
emails no longer get delivered, or if the delivery takes too long.

""".strip(),
	  author="Tommi Virtanen",
	  author_email="tv@havoc.fi",
	  #url="http://TODO/",
	  license="GNU GPL",

          packages=['MailPing', 'MailPing.test'],
          scripts=['bin/mailping-cron',
                   'bin/mailping-store',
                   ],
          data_files=[
        ['share/mailping/munin-plugins', ['munin-plugins/mailping-success',
                                          'munin-plugins/mailping-latency',
                                          ]],
        ],
          classifiers=[
        'Development Status :: 3 - Alpha',
        #'Development Status :: 4 - Beta',
        #'Development Status :: 5 - Production/Stable',
        'Environment :: No Input/Output (Daemon)',
        'Environment :: Plugins',
        'Intended Audience :: System Administrators',
        'License :: DFSG approved',
        'License :: OSI Approved :: GNU General Public License (GPL)',
        'Operating System :: Unix',
        'Programming Language :: Python',
        'Topic :: Communications :: Email',
        'Topic :: Internet',
        'Topic :: System :: Monitoring',
        ],
          )
