#
# Copyright (c) 2010 Canonical
#
# Written by Gustavo Niemeyer <gustavo@niemeyer.net>
#
# This file is part of the Xpresser GUI automation library.
#
# Xpresser is free software; you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License version 3,
# as published by the Free Software Foundation.
#
# Xpresser is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#
from xpresser.image import Image

import pyatspi
import gtk

import warnings

# pygtk is using a deprecated method from numpy in get_pixels_array().
warnings.filterwarnings("ignore", ".*use PyArray_NewFromDescr.*")


def click(x, y):
    pyatspi.Registry.generateMouseEvent(x, y, pyatspi.MOUSE_B1C)

def right_click(x, y):
    pyatspi.Registry.generateMouseEvent(x, y, pyatspi.MOUSE_B3C)

def hover(x, y):
    pyatspi.Registry.generateMouseEvent(x, y, pyatspi.MOUSE_ABS)

def type(string):
    for char in string:
        keyval = gtk.gdk.unicode_to_keyval(ord(char))
        pyatspi.Registry.generateKeyboardEvent(keyval, None, pyatspi.KEY_SYM) 


def take_screenshot(x=0, y=0, width=None, height=None):
    window = gtk.gdk.get_default_root_window()
    if not (width and height):
        size = window.get_size()
        if not width:
            width = size[0]
        if not height:
            height = size[1]
    pixbuf = gtk.gdk.Pixbuf(gtk.gdk.COLORSPACE_RGB, False, 8, width, height)
    pixbuf = pixbuf.get_from_drawable(window, window.get_colormap(),
                                      x, y, 0, 0, width, height)
    array = pixbuf.get_pixels_array()
    return Image("screenshot", array=array,
                 width=array.shape[1], height=array.shape[0])
